# The LearningOnline Network
# "Template" Functions to generate html output
#
# $Id: lontemplate.pm,v 1.43.4.1 2011/05/13 19:45:28 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#


package Apache::lontemplate;


use strict;
use Apache::Constants qw(:common);
use Apache::loncommon;
use Apache::lonnet;
use Apache::lonxml;
use Apache::lonspeller;
use Apache::lontexconvert;
use Apache::lonfeedback;
use Apache::lonrss();
use Apache::lonlocal;
use Apache::lonmsgdisplay();
use HTML::Entities();

use constant {
	RICH_TEXT_ALWAYS_ON => 'LC_richAlwaysOn',
	RICH_TEXT_ALWAYS_OFF => 'LC_richAlwaysOff',
	RICH_TEXT_DEFAULT_ON => 'LC_richDefaultOn',
	RICH_TEXT_DETECT_HTML => 'LC_richDetectHtml',
	RICH_TEXT_DEFAULT_OFF => 'LC_richDefaultOff'
};

sub start_columnSection {
	my ($r) = @_;
	 $r->print('<div class="LC_columnSection">');
}

sub end_columnSection {
	my ($r) = @_;
	 $r->print('</div>');
}

sub print_aboutme_content_template {
	my ($r,$allowed,$target,$syllabusfields_ref,$syllabus_ref) = @_;
	my %syllabusfields = %{$syllabusfields_ref};
	my %syllabus = %{$syllabus_ref};

       foreach my $field (sort(keys(%syllabusfields))) {
          if (($syllabus{$field}) || ($allowed)) {
              my $message=$syllabus{$field};
              if (!&Apache::lonfeedback::contains_block_html($message)) {
              	&Apache::lonfeedback::newline_to_br(\$message);
              }
              $message=&Apache::lonhtmlcommon::raw_href_to_link($message);
              if ($allowed) {
                  $message=&Apache::lonspeller::markeduptext($message);
              }
              $message=&Apache::lontexconvert::msgtexconverted($message);
              if ($target ne 'tex') {
		    if($field eq 'aaa_contactinfo') {
				$r->print('<div class="LC_Clear_AboutMe_Image" >&nbsp;</div>');
				&print_template($r,$syllabusfields{$field},$message,$allowed,'LC_Box');
		    } else {
			  &print_template($r,$syllabusfields{$field},$message,$allowed,'LC_Box');
		    }
			if($allowed) {
               &print_editbox_template($r,$syllabus{$field},$field);
			}

              } else {
                     $r->print('\\\\\textbf{'.$syllabusfields{$field}.'}\\\\'.
                               &Apache::lonxml::xmlparse($r,'tex',$message).'\\\\');
              }
          }
       }

}

sub send_message {
	my ($r,$cnum,$cdom) = @_;
	my $linktext = &mt('Send message to [_1]',
			   &Apache::loncommon::plainname($cnum,$cdom));
	my $image = qq{<img name="Send_message" alt="Send message symbol" src="/res/adm/pages/mail-message-new.png" border="none" align="middle" />};
	return &Apache::loncommon::messagewrapper($image,$cnum,$cdom).' '.&Apache::loncommon::messagewrapper($linktext,$cnum,$cdom);
}

sub print_template {
	my ($r,$topic,$content, $allowed,$boxclass) = @_;
	$r->print('<div class="'.$boxclass.'">');
	$r->print('<h4 class="LC_hcell">'.$topic.'</h4>');
	$r->print($content);
	$r->print('</div>');
}

sub print_start_template {
	my ($r,$topic,$boxclass) = @_;
	$r->print('<div class="'.$boxclass.'">');
	$r->print('<h4 class="LC_hcell">'.$topic.'</h4>');
}

sub print_end_template {
	my ($r) = @_;
	$r->print('</div>');
}

sub print_editbox_template {
	my ($r,$content,$field) = @_;
	$r->print('<textarea cols="81" rows="6" name="'.$field.'">'.
                           &HTML::Entities::encode($content,'"&<>').
           '</textarea><br /><input type="submit" name="storesyl" value="'.
                           &mt('Save All').'" />');
}

sub print_textarea_template {
	my ($r, $content, $field, $wysiwyg) = @_;
	$r->print('<textarea cols="81" rows="6" class="'.$wysiwyg.'" id="'.$field.'" name="'.$field.'">'.
						  &HTML::Entities::encode($content, '"&<>').
			'</textarea><br />');
}

sub print_saveall_template {
	my ($r) = @_;
	$r->print('<input type="submit" name="storesyl" value="'.&mt('Save All').'" />');
}

sub print_template_fields {
	my ($r, $data_ref, $fields_ref, $target, $allowed, $default_rich_text, $custom_handlers_ref, $group) = @_;
	my @html_ids = ();
	my %data = %{$data_ref};
	my %fields = %{$fields_ref};
	my %custom_handlers = %{$custom_handlers_ref};

	foreach my $field (sort(keys(%fields))) {
		my $message = $data{$field} if (($data{$field}=~/\w/) || ($allowed));
		if ((%custom_handlers) && ($custom_handlers{$field})) {
			$custom_handlers{$field}->($r, $field, $message, $group, $data_ref, $fields_ref, $target, $allowed);
		} else {
			if (($data{$field}=~/\w/) || ($allowed)) {
				if (!&Apache::lonfeedback::contains_block_html($message)) {
					&Apache::lonfeedback::newline_to_br(\$message);
				} else {
					$message = &Apache::lonfeedback::tidy_html($message);
				}
				$message=&Apache::lonhtmlcommon::raw_href_to_link($message);
				if ($allowed) {
					$message=&Apache::lonspeller::markeduptext($message);
				}
				$message=&Apache::lontexconvert::msgtexconverted($message);
				if ($target ne 'tex') {
					#output of syllabusfields will be generated here. 
					&Apache::lontemplate::print_start_template($r,$fields{$field},'LC_Box');
					$r->print($message);
					if ($allowed) {
						$r->print("<br /><div>");
						&Apache::lontemplate::print_textarea_template($r, $data{$field},
							$field, $default_rich_text);
						&Apache::lontemplate::print_saveall_template($r);
						$r->print("</div>");
					} 
					&Apache::lontemplate::print_end_template($r);
				} else {
				    my $safeinit;
                                    if ($fields{$field}=~/\w/) {
                                        $r->print(&Apache::lonxml::xmlparse($r,'tex','<h3>'.$fields{$field}.'</h3>'));
                                    } else {
                                        $r->print(&Apache::lonxml::xmlparse($r,'tex','<br />'));
                                    }
                                    $r->print(&Apache::lonxml::xmlparse($r,'tex',$message));
				}
				push(@html_ids,$field);
			}
		}
	}
	
	return @html_ids;	
}

1;
