# The LearningOnline Network with CAPA
# Arabic Localization Lexicon
#
# $Id: ar.pm,v 1.21 2011/05/27 14:39:55 bisitz Exp $
#
# Copyright i-Learning Limited Partnership Company
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::ar;
use base qw(Apache::localize);
%Lexicon=('_AUTO' => 1,
'language_code' => 'ar',
'char_encoding' => 'UTF-8',
'date_locale'  =>
      '$weekday, $day.$month.$year, $twentyfour:$minutes:$seconds',
'date_months'  => ' يناير,فبراير,مارس,أبريل,مايو,يونيو,يوليو,أغسطس,سبتمبر,أكتوبر,نوفمبر,ديسمبر',
'date_days'    => 'الأحد,الإثنين,الثلاثاء,الأربعاء,الخميس, الجمعة,السبت ',
'date_am' => 'صباحا',
'date_pm' => 'مساء',
'textual_remote_display' => 'on',

#يناير - كانون الثاني,فبراير - شباط,مارس - آذار,أبريل - نيسان, مايو - أيار,يونيو - حزيران,يوليو - تموز,أغسطس - آب,سبتمبر - أيلول,أكتوبر - تشرين الأول,نوفمبر - تشرين الثاني,ديسمبر - كانون الأول


   'Arabic - UTF'
=> 'ﺎﻠﻋﺮﺒﻳﺓ - UTF',

   'German - UTF'
=> 'Deutsch - UTF', # 'UTF - ألماني'

   'English - UTF'
=> 'English - UTF', # 'UTF - إنجليزي'

   'Spanish (Castellan) - UTF'
=> 'español (castellano) - UTF',

   'Persian - UTF'
=> 'ﺍیﺭﺎﻧی - UTF',

   'French - UTF'
=> 'français - UTF',

   'Hebrew - UTF'
=> 'עברית - UTF',

   'Japanese - UTF'
=> '日本語 - UTF', # 'UTF - ياباني'

   'Portuguese - UTF'
=> 'Português - UTF', # 'UTF - اللغة البرتغالية'

   'Russian - UTF'
=> 'Русский - UTF', # 'UTF - اللغة الروسية'

   'Turkish - UTF'
=> 'türkçe - UTF', # 'UTF تركي'

   'Chinese Simplified - UTF'
=> '简体中文 - UTF',

   'Swedish Chef - UTF'
=> 'Swedish Chef - UTF',

   'Domain'
=> 'نطاق',

   'Server'
=> 'خادم الشبكة',

   'Load'
=> 'تحميل',

   'User Load'
=> 'تحميل المستخدم',

   'Help'
=> 'مساعد',

   'Log in'
=> 'اتصال',

   'Username'
=> 'اسم المستخدم',

   'Password'
=> 'كلمة مرور',

   'choose'
=> 'انتخاب',

   'enter'
=> 'إدخال',

   'view'
=> 'مشاهدة',

   'calendar'
=> 'تقويم',

   'prefer-'
=> 'تنظيمات',

   'ences'
=> ' تنظيمات',

  'role'
=> 'دور',

   'course'
=> 'دورة',

   'create'
=> 'إنشاء',

   'grades'
=> 'درجات',

   'commu-'
=> 'اتصالات',

   'nication'
=> 'اتصالات',

   'enroll'
=> 'تسجيل',

   'navigate'
=> 'تجوال',

   'Announcements and Calendar'
=> 'الإعلانات و التقويم',

   'Author'
=> 'الكاتب',

   'Change Your Preferences'
=> 'تعديل التنظيمات',

   'Choose the user role'
=> 'انتخاب دور المستخدم',

   'Co-Author'
=> 'مساعد الكاتب',

   'Communication and Messages'
=> 'الاتصالات و الرسائل',

   'Course Coordinator'
=> 'منسق الدورة',

   'Course Statistics and Charts'
=> 'إحصائيات و جداول الدورة',

   'Course announcements and my calendar'
=> 'إعلانات الدورة و التقويم الخاص بي',

   'Create Users, Change User Privileges'
=> 'إنشاء مستخدمين و تغيير امتيازات المستخدم',

   'Domain Coordinator'
=> 'منسق النطاق',

   'Enrollment Manager'
=> 'مدير التسجيل',

   'Enter grades from check-out assessment resources'
=> 'أدخل الدرجات من فهرس موارد التقييم',

   'Exam Proctor'
=> 'المراقب في الامتحان',

   'Exit LON-CAPA'
=> 'LON-CAPA الخروج  من',

   'Grades Spreadsheet'
=> 'لوحة الدرجات الجدولية',

   'Grading'
=> 'يصحح الأوراق',

   'Instructor'
=> 'معلم',

   'Launch Remote Control'
=> 'البدء بعملية التحكم عن بعد',

   'Main Menu'
=> 'القائمة الرئيسية',

   'Navigate Course Contents'
=> 'تجوال في محتويات الدورة',

   'No Role, Cumulative Privileges'
=> 'بدون دور، مع تراكم الامتيازات',

   'Return to Last Location'
=> 'الرجوع إلى الموضع السابق',

   'Send and receive messages'
=> 'إرسال و استقبال الرسالة',

   'Set my user preferences'
=> 'تحديد امتيازاتي الاستخدامية',

   'Student'
=> 'طالب',

   'Switch to another user role'
=> 'الانتقال إلى دور مستخدم آخر',

   'Teaching Assistant'
=> 'مساعد الأستاذ',

   'Use or edit my bookmark collection'
=> 'استخدم أو حرر المجموعة التي انتخبتُها',

   'User Roles'
=> 'أدوار المستخدم',

   'Calculate course grades (Spreadsheet)'
=> 'حساب درجات الدورة',

   'Enter the chatroom for the course'
=> 'أُدخل غرفة المحادثة للدورة',

   'Navigate the table of contents for this course'
=> 'التجوال في فهرس محتويات هذه الدورة',

   'Syllabus'
=> 'برنامج دراسي',

   'View the course assessment progress chart'
=> 'مشاهدة جدول تقييم تطور الدورة',

   'Class Hours'
=> 'أوقات الدرس',

   'Course Description'
=> 'وصف الدورة',

   'Coursepack'
=> 'حقيبة الدورة',

   'Current Month'
=> 'الشهر الحالي',

   'Deadlines'
=> 'المواعيد الأخيرة',

   'Fri'
=> 'الجمعة',

   'Grading Information'
=> 'معلومات حول التصحيح',

   'Helproom Hours'
=> 'ساعات عمل غرفة الاستشارة',

   'Instructor Information'
=> 'معلومات المعلم',

   'Mon'
=> 'الإثنين',

   'Next Month'
=> 'الشهر المقبل',

   'Office Hours'
=> 'الساعات الإدارية',

   'Prerequisites'
=> 'المتطلبات',

   'Previous Month'
=> 'الشهر الماضي',

   'Readings'
=> 'مطالب للقراءة',

   'Sat'
=> 'السبت',

   'January'
=> 'يناير - كانون الثاني',

   'February'
=> 'فبراير - شباط',

   'March'
=> 'مارس - آذار',

   'April'
=> 'أبريل - نيسان',

   'May'
=> 'مايو - أيار',

   'June'
=> 'يونيو - حزيران',

   'August'
=> 'أغسطس - آب',

   'September'
=> 'سبتمبر - أيلول',

   'October'
=> 'أكتوبر - تشرين الأول',

   'November'
=> 'نوفمبر - تشرين الثاني',

   'December'
=> 'ديسمبر - كانون الأول',

   'Sun'
=> 'الأحد',

   'Textbook'
=> 'كتاب دراسي',

   'Thu'
=> 'الخميس',

   'Tue'
=> 'الثلاثاء',

   'Web Links'
=> 'اتصالات الشبكة',

   'Wed'
=> 'الأربعاء',

   'Drop/Add students in this course'
=> 'إخراج أو إضافة  طلاب إلى الدورة',

   'You have entered that answer before'
=> 'قد أَدرجتَ هذا الجواب فيما سبق',

   'A score has been assigned.'
=> 'تم تخصيص درجة',

   'You are correct.'
=> 'الحق معك',

   'Your receipt is'
=> 'استلامك',

   'You are excused from the problem.'
=> 'أنت معفي من الإجابة عن هذه المسألة',

   'Incorrect'
=> 'غير صحيح',

   'Some parts were not submitted.'
=> 'لم يتم تسليم بعض الحقول',

   'An error occurred while grading your answer.'
=> 'عَرَض اشتباه عند تصحيح جوابك',

   'The submitted answer was too long.'
=> 'الجواب المعروض طويل للغاية',

   'This question expects a numeric answer.'
=> 'يحتاج هذا السؤال إلى جواب بالأعداد',

   'You have provided an invalid ranking'
=> 'الرتبة التي حصلت عليها غير معتبرة',

   'please refer to'
=> 'يرجى الإشارة إلى',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'نوع امتداد الملف الذي حمّلته إلى الشبكة',

   'Please adjust significant figures.'
=> 'يرجى انتخاب أعداد هامة',

   'Units incorrect.'
=> 'الوحدات غير صحيحة',

   'Only a number required.'
=> 'المطلوب في هذا الحقل هو عدد واحد',

   'Units required'
=> 'الوحدات مطلوبة',

   'Unable to understand formula'
=> 'الصيغة غير واضحة',

   'Your submission has been recorded.'
=> 'تم تسجيل ما أرسلته',

   'Unknown message'
=> 'رسالة مجهولة',

   'Answer Submitted'
=> 'تم تسليم الجواب',

   'Tries'
=> 'اختبارات',

   'Submit Answer'
=> 'تسليم الجواب',

   'Prepare a printable document'
=> 'قدِّم سنداً صالحاً للطباعة',

   'Go To My First Homework Problem'
=> 'الانتقال إلى أول مسألة من واجباتي المنزلية',

   'Discussions'
=> 'بحوث',

   'New discussion since'
=> 'بحث جديد من',

   'Goodbye'
=> 'في أمان الله',

   ', and answers will be available on'
=> 'و الأجوبة ستكون متاحة في',

   ', or the next time you log in.'
=> ' أو حينما تتصل في المرة التالية',

   ', select a template from the pull-down menu below'
=> ',  انتخب نموذجاً من القائمة التالية المنفتحة للأسفل',

   'Abstract'
=> 'تلخيص',

   'Access and Usage Statistics'
=> 'إحصائيات المراجعة و الاستفادة',

   'Actions'
=> 'عمليات',

   'All homework is currently completed'
=> 'تم إنجاز جميع الواجبات في الوقت الحاضر',

   'Analyze Progress'
=> 'تحليل التطور',

   'Analyzing a problem'
=> 'تحليل مسألة',

   'Answer'
=> 'جواب',

   'Answer available'
=> 'الجواب متاح',

   'Answer submitted'
=> 'تم تسليم الجواب',

   'Answer submitted, not yet graded'
=> 'تم تسليم الجواب إلا أنه لم يُصحَّح بعد',

   'Back to Directory'
=> 'الرجوع إلى الدليل',

   'Bulletin Board'
=> 'لوحة الإعلانات',

   'Cancel'
=> 'انصراف',

   'Changes will become active for your current session after'
=> 'سيتم تفعيل التعديلات لجلستك الحالية بعد أن',

   'Construction Space Directory'
=> 'دليل مساحة الأطروحة',

   'Contact'
=> 'اتصال',

   'Copying file'
=> 'ينسخ الملف',

   'Course'
=> 'دورة',

   'Create'
=> 'إنشاء',

   'Create a user or modify the roles and privileges of a user'
=> 'إنشاء مستخدم أو تغيير أدواره و امتيازاته',

   'Currently not available'
=> 'لم يَعُد متوفراً في الوقت الحاضر',

   'Currently selected. '
=> 'تم انتخابه في الوقت الحاضر',

   'Date'
=> 'تاريخ',

   'Discard Edits and View'
=> 'حذف المحرر و المشاهدة',

   'Display'
=> 'عرض',

   'Done'
=> 'منجز',

   'Edit'
=> 'تحرير',

   'EditXML'
=> ' XML تحرير ',

   'Empty'
=> 'فارغ',

   'End'
=> 'نهاية',

   'Evaluation Comments'
=> 'ملاحظات التقييم',

   'Evaluation Data'
=> 'بيانات التقييم',

   'Excused by instructor'
=> 'تغاضى المعلم ',

   'Extent'
=> 'حد',

   'File'
=> 'ملف',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'لم يتم العثور على قسم صالح للتحليل لهذه المسألة و لا تسند في الوقت الحاضر إلا الأجوبة العددية و الصيغية و الفرعية',

   'Frequency'
=> 'تواتر',

   'Getting Problem Variants'
=> 'استلام أنواع المسألة',

   'Go Back'
=> 'رجوع',

   'Import'
=> 'استيراد',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'يرجى الإفادة من مضاد فيروس متطور قبل فتح هذا الملف',

   'July'
=> 'يوليو - تموز',

   'Language'
=> 'لغة',

   'Last Modified'
=> 'آخر تعديل لهذا الملف',

   'List of possible answers'
=> 'قائمة الأجوبة المحتملة',

   'Main Course Documents'
=> 'مستندات الدورة الرئيسية',

   'Map'
=> 'خارطة',

   'Map contents are not shown in order.'
=> 'لم يتم عرض محتويات الخارطة بالترتيب',

   'Name'
=> 'اسم',

   'Navigate Contents'
=> 'تجوال في المحتويات',

   'New Folder'
=> 'مجلد جديد',

   'New Messages'
=> 'رسائل جديدة',

   'New Search'
=> 'بحث جديد',

   'No content modifications yet.'
=> 'لم يتم إجراء أي تعديل في المحتويات حتى الآن',

   'No due date'
=> 'بدون تاريخ محدد',

   'No role specified'
=> 'لم يتم تحديد أي دور',

   'No upload file specified.'
=> 'لم يتم تحديد ملف لتحميله إلى الشبكة',

   'No write permission to user directory, FAIL'
=> 'لا يُسمح التلاعب في دليل المستخدم',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'ملاحظة: يستغرق إجراء التعديلات لكل المستخدمين عشر ثوانٍ',

   'Notes'
=> 'مذكرات',

   'Open, no due date'
=> 'مفتوح، بدون تاريخ محدد',

   'Page'
=> 'صفحة',

   'Part'
=> 'حقل',

   'Part is not open to be viewed. It'
=> 'الحقل مغلق و لا يمكن مشاهدته',

   'Path'
=> 'مسار',

   'Please use browser "Back" button and pick a filename'
=> 'يرجى استخدام مفتاح إرجاع المستعرض و انتخاب اسم أحد الملفات',

   'Processing'
=> 'يعالج',

   'Re-Initialize'
=> 'إعادة تمهيد',

   'Remark'
=> 'الإدلاء برأي',

   'Rename'
=> 'تبديل الاسم',

   'Save'
=> 'خزن',

   'Saving Modifications to'
=> 'خزن التعديلات في',

   'Search'
=> 'بحث',

   'Searching'
=> 'يبحث',

   'Section/Group'
=> 'حقل / مجموعة',

   'Select'
=> 'انتخب',

   'Select Course'
=> 'انتخب الدورة',

   'Select User'
=> 'انتخب المستخدم',

   'Select a'
=> 'انتخب',

   'Select the Construction Space'
=> 'انتخب مساحة الأطروحة',

   'Sequence'
=> 'توالي',

   'Server Administration'
=> 'إدارة الملقم',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'تحديد المواعيد الأخيرة و وسائط التقييم الأخرى و أيضاً تغيير مجال الدورة',

   'Show Only Uncompleted Homework'
=> 'اعرض الواجبات الناقصة فقط',

   'Simple Page'
=> 'صفحة بسيطة',

   'Simple Problem'
=> 'مسألة بسيطة',

   'Special Documents'
=> 'وثائق خاصة',

   'Start'
=> 'تشغيل',

   'Status'
=> 'حالة',

   'Store uploaded file as '
=> 'خزن الملف المحمَّل إلى الشبكة باسم',

   'Submit'
=> 'تسليم',

   'Submit Changes'
=> 'تسليم التغييرات',

   'Submit Changes and View'
=> 'تسليم التغييرات و المشاهدة',

   'Supplemental Course Documents'
=> 'مستندات الدورة التكميلية',

   'Switch Server'
=> 'تبديل الملقم',

   'System'
=> 'نظام',

   'System Administration'
=> 'إدارة النظام',

   'The target is an existing directory.'
=> 'المقصد هو الدليل الموجود',

   'Then'
=> 'ثم',

   'Title'
=> 'اسم',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'بسبب الإشكالات الموجودة في الشبكة لا يمكن أن يعرف أن هذا المورد مفتوح أم لا. حاول مرة أخرى رجاءً',

   'Unable to find'
=> 'غير متوفر',

   'Unable to make backup'
=> 'لا يمكن إعداد المساند',

   'Unable to undo, unable to switch'
=> 'لا يمكن إلغاء التعديلات أو تبديلها',

   'Unable to write to'
=> 'لا تتوافر إمكانية الكتابة إلى',

   'Uncompleted Homework'
=> 'واجبات ناقصة',

   'Undid changes, Switched'
=> 'أُلغيت التعديلات، تم تبديلها',

   'Upload Document'
=> 'تحميل السند إلى الشبكة',

   'Uploaded Document'
=> 'السند المحمَّل إلى الشبكة',

   'User Role'
=> 'دور المستخدم',

   'View All Messages'
=> 'مشاهدة جميع الرسائل',

   'View course assessment statistics'
=> 'مشاهدة إحصائيات تقييم الدورة',

   'Was due'
=> 'كان من المقرر',

   'Yes'
=> 'نعم',

   'You did not select a template.'
=> 'لم تنتخب نموذجاً',

   'You do not have authoring privileges for this resource'
=> 'لا تملك الصلاحيات تغيير محتويات هذا المورد',

   'You have no unread messages'
=> 'لا توجد لديك رسالة لم تُقرأ',

   'an indeterminate date'
=> 'تاريخ غير محدد',

   'an unknown date'
=> 'تاريخ لا يمكن تشخيصه',

   'could not be copied.'
=> 'لم ينسخ',

   'is closed but you are allowed to view it'
=> 'يُغلق و لكن تستطيع أن تشاهده',

   'is due at'
=> 'المقرر في',

   'is in under construction'
=> 'في طور الإعداد',

   'is not analyzable at this time'
=> 'غير صالح للتحليل في الحال الحاضر',

   'last month'
=> 'الشهر الماضي',

   'last problem'
=> 'آخر مسألة',

   'last six months'
=> 'الأشهر الست الماضية',

   'last three months'
=> 'الأشهر الثلاث الماضية月',

   'last week'
=> 'الأسبوع الماضي',

   'last year'
=> 'السنة الماضية',

   'may open later.'
=> 'قد يُفتح فيما بعد',

   'never'
=> 'أبداً، مطلقاً',

   'not displayed'
=> 'لم يُعرض',

   're-initializing course'
=> 'إعادة الدورة',

   'system wide'
=> 'النظام واسع',

   'today'
=> 'اليوم',

   'undo'
=> 'إلغاء',

   'was due on'
=> 'كان من المقرر في',

   'will open on'
=> 'سيُفتح في',

   ', is reserved internally by LON-CAPA.'
=> ',  LON-CAPA يتم خزنه داخلياً بواسطة ',

   'Back to'
=> 'الرجوع إلى',

   'Back to Source'
=> 'الرجوع إلى المورد',

   'Back to Source Directory'
=> 'الرجوع إلى دليل المورد',

   'Became this version on ...'
=> 'تم تبديل هذه النسخة ',

   'Browse published resources'
=> 'استعراض الموارد المنشورة',

   'Choose the course to work on'
=> 'انتخب دورة لتشتغل عليها',

   'Create a new course'
=> ' إنشاء دورة جديدة',

   'Customized right of use ...'
=> ' ... حق طلب استخدام',

   'Delete messages from bulletin boards'
=> 'حذف الرسائل من لوحة الإعلانات',

   'Domain only - use limited to courses in the domain'
=> 'النطاق الوحيد - عملية تحديد الدورات',

   'Dynamic Metadata'
=> 'بيانات معيارية فاعلة',

   'Edit and view documents included in this course'
=> 'تحرير و مشاهدة المستندات المودعة في هذه الدورة',

   'Edit/Modify DOCS'
=> ' DOC تحرير أو تبديل الملفات بامتداد ',

   'Enter my resource construction space'
=> 'الدخول إلى مساحة أطروحة المورد المختص بي',

   'FAIL'
=> 'فشل',

   'Failed to copy source'
=> 'لم يتم نسخ المورد',

   'Failed to write metadata copy'
=> 'الفشل في كتابة نسخة البيانات المعيارية',

   'File copied.'
=> 'لم يتم نسخ الملف',

   'Finalize Publication'
=> 'إنهاء النشر',

   'Grant/revoke role of Co-Author'
=> 'منح أو إلغاء دور مساعد الكاتب',

   'Grant/revoke role of Domain Coordinator'
=> 'منح أو إلغاء دور منسق النطاق',

   'Grant/revoke role of Exam Proctor'
=> 'منح أو إلغاء دور المراقب في الامتحان',

   'Grant/revoke role of Instructor'
=> 'منح أو إلغاء دور المعلم',

   'Grant/revoke role of Student'
=> 'منح أو إلغاء دور الطالب',

   'Grant/revoke role of Superuser'
=> 'منح أو إلغاء دور المستخدم الفائق',

   'Illegal filename.'
=> 'اسم الملف غير معتبر',

   'Name starting with'
=> ' الاسم الذي يبدأ ب',

   'No previous versions published.'
=> 'لم يتم نشر أي نسخة من النسخ السابقة',

   'No write permission to'
=> ' لا يُسمح لك أن تكتب في',

   'Please pick a version to retrieve'
=> 'يرجى انتخاب نسخة ليتم استخراجها',

   'Private - visible to author only for testing purposes'
=> 'خاص - لا يمكن استخراج الملف إلا للكاتب و من أجل الاختبار',

   'Private Publication - did not synchronize database'
=> 'نشر خاص - لم تتم المواقتة مع قاعدة البيانات',

   'Public - no authentication or authorization required for use'
=> 'عام - لا حاجة للاستفادة إلى التوثيق أو الإذن',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> 'استخراج النسخة السابقة يستوجب الكتابة على الملف الموجود حالياً في مساحة الأطروحة',

   'Retrieve previous versions of'
=> 'استخراج النسخة السابقة',

   'Retrieve version'
=> 'استخراج نسخة',

   'Rule'
=> 'قانون',

   'Search the contents of this course'
=> 'البحث في محتويات هذه الدورة',

   'Search the database of published resources'
=> 'البحث في قاعدة بيانات الموارد المنشورة',

   'Send broadcast and receipt-required email'
=> 'إرسال إذاعي و استلام الرسالة الإلكترونية المحتاجة إلى الإشعار بالاستلام',

   'Show Problem Completeness'
=> 'عرض مسار إكمال المسألة',

   'Switch to another course'
=> 'الانتقال إلى دورة أخرى',

   'System wide - can be used for any courses system wide'
=> 'النظام واسع - يمكن استخدامه لجميع دورات النظام الواسع',

   'System wide - open source to all authors'
=> 'النظام واسع - فتح المورد لجميع المؤلفين',

   'The extension on this file'
=> 'الامتداد على هذا الملف',

   'This resource has been marked obsolete by the author(s)'
=> 'أفصح الكاتب أو الكتّاب عن قِدَم هذا المورد',

   'Unsupported character combination'
=> 'لا يتم إسناد هذا التركيب من الحروف',

   'Uploaded'
=> 'تم تحميله إلى الشبكة',

   'Users with Roles Assigned by'
=> 'المستخدمون عبر الأدوار التي أحيلت إليهم بواسطة',

   'View documents included in this course'
=> 'مشاهدة الملفات المودعة في هذه الدورة',

   'View file'
=> 'مشاهدة الملف',

   'untitled'
=> 'بدون اسم',

#SYNC Sun Sep 28 12:06:11 2003
   'Additional Keywords'
=> 'كلمات دليلية إضافية',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'بيانات معيارية إضافية -غير قياسي، وسائط، تصديرات',

   'All versions'
=> 'جميع النسخ',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'لا يتوفر دور الكاتب و لا مساعده على أي ملقم سوى ملقم المضيف',

   'Author(s)'
=> 'كاتب / كتّاب',

   'Average number of tries till solved'
=> 'معدَّل تكرار محاولات المستخدم لحل هذه المسألة',

   'Browse Resources'
=> 'استعراض الموارد',

   'Catalog Information'
=> 'معلومات القائمة',

   'Collapse Remote Control'
=> 'إخفاق (عملية) التحكم عن بعد',

   'Construction Space'
=> 'مساحة الأطروحة',

   'Content changed'
=> 'تبدَّلَ المحتوى',

   'Copied metadata'
=> 'تم نسخ البيانات المعيارية',

   'Copied source file'
=> 'تم نسخ ملف المورد',

   'Copyright/Distribution'
=> 'حقوق النشر و الطباعة/التوزيع',

   'Could not write metadata'
=> 'لم تتوافر إمكانية',

   'Course Documents'
=> 'مستندات الدورة',

   'Creation Date'
=> 'تاريخ الإنشاء',

   'Custom Distribution File'
=> 'ملف توزيع مطلوب',

   'Default Cataloging Information for Directory'
=> 'معلومات حول فهرسة الدليل الافتراضية',

   'Degree of difficulty'
=> 'درجة الصعوبة',

   'Differences'
=> 'فروق',

   'Dump Course DOCS to Construction Space'
=> 'طرح الملفات بامتداد DOC الموجودة في مساحة الأطروحة',

   'Entering course ...'
=> '...الدخول إلى الدورة',

   'Error Messages'
=> 'رسائل خطأ',

   'Exam Information'
=> 'معلومات حول الامتحان',

   'External Resource'
=> 'مورد خارجي',

   'Generate new role ...'
=> '...إنشاء دور جديد',

   'Go to the next resource in the course sequence'
=> 'الانتقال إلى المورد التالي في ترتيب الدورة',

   'Go to the previous resource in the course sequence'
=> 'الانتقال إلى المورد السابق في ترتيب الدورة',

   'Import a published document'
=> 'إدخال السند المنشور',

   'Keyword(s)'
=> 'كلمات دليلية',

   'Last Week'
=> 'الأسبوع الماضي',

   'Load Map'
=> 'تحميل الخارطة',

   'Logged Out'
=> 'انقطع الاتصال',

   'MIME Type'
=> 'MIME- نوع',

   'Make notes and annotations about this resource'
=> 'كتابة التعليقة و الشرح على هذا المورد',

   'Material appears to be correct'
=> 'المطالب التي تبدو صحيحة',

   'Material covered with sufficient depth'
=> 'مطالب عميقة',

   'Material is helpful'
=> 'مطالب مفيدة',

   'Material presented in clear way'
=> 'مطالب واضحة',

   'Metadata Information'
=> 'معلومات حول البيانات المعيارية',

   'Modification Date'
=> 'تاريخ التعديل',

   'My Personal Info'
=> 'معلوماتي الخاصة',

   'Network-wide number of accesses (hits)'
=> 'الشبكة الواسعة - عدد المراجعات',

   'Network-wide number of courses using resource'
=> 'الشبكة الواسعة - عدد الدورات المستفيدة من هذا المورد',

   'Number of resources that follow this resource in maps'
=> 'عدد الموارد التالية لهذا المورد في الخرائط',

   'Number of resources that lead up to this resource in maps'
=> 'عدد الموارد المنتهية إلى هذا المورد في الخرائط',

   'Number of resources using or importing resource'
=> 'عدد الموارد التي تستفيد من هذا المورد أو تدرجه',

   'Obsolete'
=> 'قديم',

   'Parent Directory'
=> 'الدليل الرئيسي',

   'Please either'
=> 'يرجى إما',

   'Project Information'
=> 'معلومات حول المشروع',

   'Publisher/Owner'
=> 'ناشر أو صاحب',

   'Publishing'
=> 'منشورات',

   'Resource Publication'
=> 'نشر المورد',

   'Resource is technically correct'
=> 'المورد صحيح من الجانب الفني',

   'Score Upload Form'
=> 'وضع درجة على الاستمارة المحمَّلة إلى الشبكة',

   'Select Map'
=> 'انتخاب الخارطة',

   'Set a bookmark for this resource'
=> 'وضع المؤشرة في هذا المورد',

   'Show all roles'
=> 'عرض جميع الأدوار',

   'Since Start of Course'
=> 'من حين بدء الدورة',

   'Since Yesterday'
=> 'من يوم أمس',

   'Special documents'
=> 'وثائق خاصة',

   'Store Catalog Information'
=> 'حفظ معلومات القائمة',

   'Subject'
=> 'موضوع',

   'Successful Login'
=> 'تم الاتصال بنجاح',

   'Suggested Replacement for Obsolete File'
=> 'البديل المقترح للملف القديم',

   'Switching Role'
=> 'تبديل الدور',

   'Target'
=> 'الهدف',

   'This syllabus can be publicly viewed at'
=> 'يستطيع الجميع أن يشاهدوا هذا البرنامج الدراسي',

   'Total number of students who have worked on this problem'
=> 'عدد جميع الطلاب الذين تناولوا هذه المسألة',

   'URLs To Include in Syllabus'
=> 'عناوين مجموعة من المواقع لإدراجها في هذا البرنامج الدراسي',

   'Update Display'
=> 'تحديث العرض',

   'Upload a new main course document'
=> 'تحميل سند الدورة الرئيسي الجديد إلى الشبكة',

   'Upload a new supplemental course document'
=> 'تحميل سند الدورة التكميلي الجديد إلى الشبكة',

   'User'
=> 'مستخدم',

   'Verify Course Documents'
=> 'التصديق على صحة مستندات الدورة',

   'Version'
=> 'نسخة',

   'Wrote Metadata'
=> 'كُتبت البيانات المعيارية',

   'Your home server is '
=> 'ملقمك المضيف',

   'access denied'
=> 'لم يتم الوصول',

   'anno-'
=> 'إعلان',

   'announce'
=> 'إعلان',

   'backward'
=> 'إلى الوراء',

   'bookmark'
=> 'مؤشرة',

   'chart'
=> 'مخطط',

   'chat'
=> 'محادثة',

   'close this window'
=> 'إغلاق هذه النافذة',

   'con-'
=> 'con-',

   'connection down'
=> 'عدم الاتصال',

   'docs'
=> 'مستندات',

   'during the last'
=> 'خلال الماضي',

   'edit crs'
=> 'crs تحرير  ',

   'exit'
=> 'خروج',

   'fas'
=> 'fas',

   'forward'
=> 'إلى الأمام',

   'library'
=> 'مكتبة',

   'log in again'
=> 'اتصال من جديد',

   'my'
=> 'لي',

   'not found'
=> 'لم يُعثر عليه',

   'or'
=> 'أو',

   'parms'
=> 'parms',

   'prepare'
=> 'تهيئة',

   'printout'
=> 'نسخة مطبوعة',

   'resource'
=> 'مورد',

   'roles'
=> 'أدوار',

   'search'
=> 'بحث',

   'set'
=> 'تنظيم',

   'space'
=> 'فضاء',

   'stats'
=> 'إحصائيات',

   'struct'
=> 'تشكيلة',

   'switch'
=> 'تغيير',

   'tations'
=> '',

   'updated periodically'
=> 'يتم تحديثه بأسلوب دوري',

   'user'
=> 'مستخدم',

   'visible to author and co-authors only'
=> 'يمكن مشاهدته للكاتب و مساعده فقط',

   'warning(s)'
=> 'إنذار',

   "Click to download or use your browser's Save Link function"
=> " يتم التحميل إما من خلال نقرك على هذا المكان أو إفادتك من خيار  المودع في مستعرضك",

   '#Stdnts'
=> '#طلاب',

   '#YES'
=> '#صحیح',

   '%Wrng'
=> '%غير صحيح',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;عرض&nbsp;جميع&nbsp;أوجه التقابل',

   '. . . for a particular section'
=> '. . . لحقل خاص',

   '. . . for all students in the course'
=> '. . . لجميع طلاب الدورة',

   '. . . for an individual student'
=> '. . . لطالب واحد',

   '1 out of N multiple choice (radio button)'
=> 'واحدة من  خيارات',

   '12 am' # midnight
=> '12 قبل الظهرً',

   'midnight'
=> 'نصف الليل',

   '1 am'
=> '1 صباحاً',

   '2 am'
=> '2 مساءً',

   '3 am'
=> '3 صباحاً',

   '4 am'
=> '4 صباحاً',

   '5 am'
=> '5 صباحاً',

   '6 am'
=> '6 صباحاً',

   '7 am'
=> '7 صباحاً',

   '8 am'
=> '8 صباحاً',

   '9 am'
=> '9 صباحاً',

   '10 am'
=> '10 صباحاً',

   '11 am'
=> '11 صباحاً',

   '12 noon'
=> '12 ظهراً',

   'noon'
=> 'الظهر',

   '1 pm'
=> '1 مساءً',

   '2 pm'
=> '2 مساءً',

   '3 pm'
=> '3 مساءً',

   '4 pm'
=> '4 مساءً',

   '5 pm'
=> '5 مساءً',

   '6 pm'
=> '6 مساءً',

   '7 pm'
=> '7 مساءً',

   '8 pm'
=> '8 مساءً',

   '9 pm'
=> '9 مساءً',

   '10 pm'
=> '10 مساءً',

   '11 pm'
=> '11 مساءً',

   '<- Previous'
=> '<- سابق',

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  لا يمكن التسجيل l: [_2] (34)',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: لا يمكن التسجيل. لم تحدد كلمة المرور l.',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>:  لا يُقبل الاسم الاستخدامي لهذا المستخدم l [_2] [_3] [_4] [_5] (36)',

   'ALL'
=> 'جميع',

   'About Me'
=> 'حولي',

   'Access Key Management'
=> 'الوصول إلى الإدارة الرئيسية',

   'Add new option'
=> 'إضافة خيار جديد',

   'Additional Recipients'
=> 'مستقبلون إضافيون',

   'Administrator'
=> 'مدير',

   'Advanced Catalog Search'
=> 'بحث متطور في القائمة',

   'Advanced Search'
=> 'بحث متطور',

   'All Documents in Course'
=> 'جميع المستندات في الدورة',

   'All Maps or Folders'
=> 'جميع الخرائط و المجلدات',

   'All Resources (possibly large output)'
=> 'جميع الموارد -المحتمل خرج واسع',

   'Analyze Over '
=> 'تحليل',

   'Analyze Problem'
=> 'تحليل المسألة',

   'Analyze Problem Again'
=> 'تحليل المسألة من جديد',

   'Analyze as '
=> 'تحليل باسم',

   'Anonymous'
=> 'مجهول',

   'Anonymous contribution to course discussion of resource'
=> 'مساعدة مجهولة بالنسبة إلى بحث الدورة من المورد',

   'Answer:'
=> 'جواب',

   'Any Language'
=> 'كل لغة',

   'Any User'
=> 'كل مستخدم',

   'Any category'
=> 'كل مقولة',

   'Any copyright/distribution'
=> 'كل نوع من أنواع حقوق النشر و الطباعة',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'في الأغلب لا يسمح الوصول إلى نظام الملفات الذي يوفر إمكانية الوصول إلى ظام ملفات الملقم إلا للكتّاب و مساعديهم',

   'Assessment'
=> 'تقييم',

   'Assessment URL and Title'
=> 'تقييم عنوان و اسم الموقع',

   'Assigned User Roles'
=> 'الأدوار الموكلة إلى المستخدمين',

   'Associate columns with student attributes.'
=> 'الربط بين الأعمدة و خصائص الطلاب',

   'Attachment'
=> 'ملحق',

   'Attribute'
=> 'خصائص',

   'Brief view of each students performance in course.'
=> 'دراسة موجزة لإنجازات كل واحد من الطلاب في هذه الدورة',

   'Broadcast Message to Course'
=> 'إرسال رسالة عبر الإذاعة إلى الدورة',

   'Browse resources'
=> 'استعراض الموارد',

   'Browsing resource, all submissions are temporary.'
=> 'يستعرض المورد، جميع الطلبات وقتية',

   'Bulletin Board/Discussion'
=> 'لوحة الإعلانات / مناقشة',

   'By'
=> 'بواسطة',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (الضوابط المتميزة بالفاصلة، اللوحة الجدولية)',

   'Calculate answers'
=> 'حساب الأجوبة',

   'Calculations'
=> 'حسابات',

   'Change'
=> 'تغيير',

   'Change Random Seed To:'
=> 'تبديل المقدار الأول المستفاد منه إلى',

   'Change Your Language Preferences'
=> 'تبديل تنظيمات لغتك',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'لابد من مضي 10 دقائق على الأكثر ليتم إجراء التغييرات لجميع الطلاب',

   'Check All'
=> 'دراسة جميع الموارد',

   'Check Course Document Versions'
=> 'دراسة نسخ مستندات الدورة',

   'Check for All'
=> 'دراسة جميع الموارد',

   'Check for None'
=> 'دراسة لا شي‏ء من الموارد',

   'Check for Section/Group'
=> 'دراسة الحقل/المجموعة',

   'Check/Set Resource Versions'
=> 'دراسة أو تنظيم نسخ المصدر',

   'Choose a different resource'
=> 'انتخاب مورد متفاوت',

   'Chronological View'
=> 'عرض قائم على أساس ترتيب زمني',

   'Clear All'
=> 'مسح جميع الموارد',

   'Clear Caches'
=> 'مسح الذاکرةالخفیة',

   'Close'
=> 'إغلاق',

   'Close All Folders'
=> 'إغلاق جميع المجلدات',

   'Column'
=> 'عمود',

   'Column&nbsp;[_1]'
=> 'عمود&nbsp;[_1]',

   'Comma Separated Values'
=> 'الضوابط التي تمايزت بالفاصلة',

   'Compact View'
=> 'دراسة مكثفة',

   'Concept:'
=> 'مفهوم',

   'Concepts'
=> 'مفاهيم',

   'Construction Space File Operation'
=> 'عمليات ملف أطروحة الفضاء',

   'Contact Information'
=> 'معلومات الاتصال',

   'Continue enrollment?'
=> 'هل يستمر التسجيل؟',

   'Contribution to course discussion of resource'
=> 'إسناد بحث موارد الدورة',

   'Copied old metadata'
=> 'بيانات معيارية قديمة منسوخة',

   'Copied old target file'
=> 'تم نسخ ملف المقصد القديم',

   'Copyright'
=> 'حقوق النشر و الطباعة',

   'Correct Option:'
=> 'الخيار الصحيح',

   'Could Not Process Request'
=> 'لم تتم معالجة الطلب',

   'Course Assessment Parameter - Helper Mode'
=> 'وسيط تقييم الدورة - حالة المساعد',

   'Course Assessment Parameters - Overview Mode'
=> 'وسيط تقييم الدورة - صيغة الخطوط العامة',

   'Course Assessments Parameters - Table Mode'
=> 'وسيط تقييم الدورة - الصيغة الجدولية',

   'Course Environment Parameters'
=> 'وسائط محيط الدورة',

   'Course ID'
=> 'هوية الدورة',

   'Course Parameter Helper'
=> 'مساعد وسيط الدورة',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'لا يمكن استخراج الإحصائيات و الجداول المختصة بالدورة إلا بعد استعادة تشغيل موقع المعلومات. معلوماتك كاملة و لكن لا يمكن عرضها في الحال الحاضر',

   'Course level sheet'
=> 'ورقة مستوى الدورة',

   'Create New Environment Variable'
=> 'إنشاء محيط متغير جديد',

   'Create a New Course'
=> 'إنشاء دورة جديدة',

   'Critical Messages'
=> 'رسائل مهمة',

   'Current'
=> 'حالي',

   'Current Session Value'
=> 'تقييم الجلسة الحالية',

   'Default'
=> 'افتراضي',

   'Default Value'
=> 'مقدار افتراضي',

   'Delete'
=> 'حذف',

   'Delete Checked'
=> 'حذف الموارد المدروسة',

   'Delete a role'
=> 'حذف دور',

   'Delete an option'
=> 'حذف خيار',

   'Delete:'
=> 'حذف',

   'Detailed Citation View'
=> 'تحليل استشهادي مفصل',

   'Detailed Problem Analysis'
=> 'تحليل مفصل للمسألة',

   'Detailed statistics and graphs of student performance on problems.'
=> 'إحصائيات و جداول مفصلة حول عمل الطلاب في حل المسائل',

   'Diffs'
=> 'اختلافات',

   'Diffs with Current Version'
=> 'اختلافات مع النسخة الحالية',

   'Diffs with Version'
=> 'اختلافات مع النسخة',

   'Diffs with current Version'
=> 'اختلافات مع النسخة الحالية',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'تعطيل هوية الطالب و تحميله لانتخاب رقم آخر',

   'Disable all communication among students'
=> 'تعطيل جميع الاتصالات بين الطلاب',

   'Discard Selected'
=> 'إهمال الموارد المنتخبة',

   'Discussion Contributions'
=> 'مساعدات دراسية',

   'Display All Messages'
=> 'عرض جميع الرسائل',

   'Display all Messages'
=> 'عرض جميع الرسائل',

   'Display and analysis of submission times on assessments.'
=> 'عرض و تحليل طلبات التقييم',

   'Display foils in order given'
=> 'عرض أوجه التقابل وفق ترتيب محدد',

   'Display foils in random order'
=> 'عرض أوجه التقابل بأسلوب عشوائي',

   'Distribute Messages from Uploaded File to Course'
=> 'توزيع الرسائل من الملف المحمَّل مرجَّعاً إلى الدورة',

   'DoDiff'
=> 'درجةالصعوبة',

   'Domain Guest'
=> 'ضيف النطاق',

   'Drop Students'
=> 'حذف الطلاب',

   'Dropped [_1]'
=> 'حُذِفَ [_1][_1 ',

   'Dropped [_1] student(s).'
=> 'طالب محذوف',

   'Dropping Students'
=> 'يحذف الطلاب',

   'Due'
=> 'مقرر',

   'Dump Course DOCS'
=> 'طرح مستندات الدورة',

   'EMail Address'
=> 'عنوان البريد الإلكتروني',

   'EMail and Messages'
=> 'عنوان البريد الإلكتروني و الرسائل',

   'Edit Catalog Information'
=> 'تحرير محتوى الخارطة',

   'Edit Content of a Map'
=> 'تحرير قائمة الدليل',

   'Edit Directory Catalog Information'
=> 'تحرير هذا المورد',

   'Edit this resource'
=> 'إضافة الخارطة أو المجلد',

   'Enclosing Map or Folder'
=> 'إضافة الخارطة أو المجلد',

   'End Helper'
=> 'إنهاء المساعدة',

   'Enroll a single student'
=> 'تسجيل طالب واحد',

   'Enrolling Students'
=> 'يسجل الطلاب',

   'Enrollment Status'
=> 'وضع التسجيل',

   'Enter construction space as a co-author'
=> 'الدخول في مساحة الأطروحة كأستاذ مساعد',

   'Error'
=> 'خطأ',

   'Error dropping [_1]:[_2]'
=> 'إهمال الخطأ l [_1]:[_2]',

   'Essay, open end'
=> 'مقالة، مفتوح',

   'Evaluate Resource'
=> 'تقييم المورد',

   'Excel'
=> 'Excel',

   'Failed Access to Construction Space'
=> 'لم تتوفر إمكانية الوصول إلى مساحة الأطروحة',

   'False'
=> 'غير صحيح',

   'Field'
=> 'حقل/فرع',

   'Fielded Format'
=> 'فیلد مصمَّم',

   'File Category'
=> 'مقولة الملف',

   'Filenames in Construction Space'
=> 'اسم  الملف في مساحة الأطروحة',

   'Finish Course Initialization'
=> 'إتمام وضع القيمة النهائية للدورة',

   'First Name'
=> 'اسم',

   'Foil'
=> 'وجه التقابل',

   'Foils'
=> 'أوجه التقابل',

   'Folder'
=> 'مجلد',

   'Folder in Construction Space'
=> 'المجلد في مساحة الأطروحة',

   'For User'
=> 'للمستخدم',

   'Force publication of unmodified files'
=> 'لزوم نشر الملفات غير المعدَّلة',

   'Format:'
=> 'تهيئة',

   'Forward'
=> 'إرسال الرسالة الواصلة إلى مرسَل إليه آخر',

   'Forwarded message from'
=> 'تم إرسالها من قِبَل المرسَل إليه',

   'Forwarding'
=> 'يرسل الرسالة الواصلة إلى مرسَل إليه آخر',

   'From'
=> 'من',

   'Full Update'
=> 'تطوير كامل',

   'Full update (also print list of users not enrolled anymore)'
=> 'تطوير كامل و أيضاً طباعة قائمة المستخدمين الذين لم يسجِّلوا بعد',

   'Functions'
=> 'الإنجازات',

   'Generate Spreadsheet'
=> 'توليد اللوحة الجدولية',

   'Generate Statistics'
=> 'تهيئة الإحصائيات',

   'Generation'
=> 'إنتاج',

   'Grant/revoke Course Custom Role'
=> 'منح أو إلغاء دور التوصية للدورة',

   'Grant/revoke role of Administrator'
=> 'منح أو إلغاء دور المدير',

   'Grant/revoke role of Author'
=> 'منح أو إلغاء دور الكاتب',

   'Grant/revoke role of Course Coordinator'
=> 'منح أو إلغاء دور مساعد الدورة',

   'Grant/revoke role of Domain Guest'
=> 'منح أو إلغاء دور ضيف النطاق',

   'Grant/revoke role of Librarian'
=> 'منح أو إلغاء دور أمين المكتبة',

   'Grant/revoke role of Bubblesheet Scanning Operator'
=> 'Grant/revoke role of Bubblesheet Scanning Operator', # 'Scantron منح أو إلغاء دور مشغِّل',

   'Grant/revoke role of Teaching Assistant'
=> 'منح أو إلغاء دور الأستاذ المساعد',

   'Group/Section'
=> 'مجموعة/حقل',

   'HTML'
=> 'HTML',

   'HTML/XML'
=> 'HTML/XML',

   'Height(pixel):'
=> 'ارتفاع  النقاط الضوئية - بكسل',

   'Hide'
=> 'إخفاء',

   'Hint Text'
=> 'نص بتوضيحات تلميحية',

   'Host'
=> 'مضيف',

   'ID/Student Number'
=> 'الهوية الشخصية/رقم الطالب',

   'Identify fields'
=> 'كشف المجالات',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'LON-CAPA إذا كان فاعلاً، سيتوافر الدور الجديد في المرة التالية التي يتصل الطلاب ب',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'قد لا تتوافر إنجازات الطالب من النسخة السابقة، إن كان هذا المورد يُستخدم بشكل فاعل',

   'Ignore First Line'
=> 'أهمل السطر الأول',

   'Image:'
=> 'صورة',

   'Incorrect Answers:'
=> 'أجوبة خاطئة',

   'Initial Password'
=> 'كلمة مرور بدائية',

   'Internal Filename'
=> 'اسم الملف الداخلي',

   'Internally authenticated'
=> 'تم تأييده من حيث المحتوى',

   'Invalid date entry'
=> 'تاريخ الدخول غير معتبر',

   'Invalid home server specified'
=> 'الملقم المضيف المحدَّد غير معتبر',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'تطوير حفظ جميع الموارد مع أحدث النسخ  حالة افتراضية',

   'Kerberos authenticated'
=> 'Kerberos تم تأييد ',

   'Keywords'
=> 'كلمات دليلية',

   'LON-CAPA Domain for Students'
=> 'نطاق لون کابا الخاص بالطلاب',

   'LON-CAPA Enrollment Manager'
=> 'مدير تسجيل  لون کابا',

   'LON-CAPA Helper:'
=> 'مساعد لون کابا',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPAنطاق  لون کابا l: [_1]',

   'Last Name'
=> 'اللقب',

   'Last Name, First Names'
=> 'اللقب، الأسم',

   'Last access'
=> 'آخر وصول',

   'Last accessed'
=> 'آخر مراجعة',

   'Last modified'
=> 'آخر تغيير لهذا الملف',

   'Last updated'
=> 'آخر تطوير لهذا الملف',

   'Librarian'
=> 'أمين المكتبة',

   'Limit by copyright/distribution'
=> 'تحديد على أساس حقوق النشر و الطباعة/التوزيع',

   'Limit by language'
=> 'تحديد على أساس اللغة',

   'Load:'
=> 'تحميل',

   'Lock and unlock assessments'
=> 'إقفال و إزالة إقفال التقييمات',

   'Login Type'
=> 'نوع الاتصال',

   'Mail'
=> 'رساله',

   'Making Backup to'
=> 'إنشاء مساند في',

   'Manage Access Keys'
=> 'إدارة مفاتيح الوصول',

   'Manage access keys'
=> 'إدارة مفاتيح الوصول',

   'Mark Unread'
=> 'وضع علامة على عنوان غير مقروء',

   'Max Number Of Shown Foils:'
=> 'الحد الأعلى لأوجه التقابل المعروضة',

   'Max Possible To Date'
=> 'الحد الأعلى للموارد الممكنة على أساس التاريخ',

   'Max Tries'
=> 'الحد الأعلى للاختبارات',

   'Max number of foils displayed'
=> 'الحد الأعلى لأوجه التقابل المعروضة',

   'Mean Tries'
=> 'معدَّل الاختبارات',

   'Metadata'
=> 'بيانات معيارية',

   'Metadata Version'
=> 'نسخة البيانات المعيارية',

   'Metadata current version'
=> 'النسخة الحالية للبيانات المعيارية',

   'Middle Names/Initials'
=> 'الأسماء المتوسطة/حروف الاسم الأولى',

   'Mime type'
=> 'Mime نوع',

   'Modified'
=> 'متغير',

   'Modify Course Assessment Parameters'
=> 'تغيير وسائط تقييم الدورة',

   'Modify Parameters'
=> 'تغيير الوسائط',

   'Modify authentication mechanism and data for a user'
=> 'تغيير الآلية و المعلومات المتعلقة بتوثيق المستخدم',

   'Modify deadlines, etc, for this assessment resource'
=> 'تبديل تاريخ المواعيد الأخيرة و المسائل الأخرى المتعلقة بهذا المورد للتقييم',

   'Modify grades'
=> 'تغيير الدرجات',

   'Modify student data'
=> 'تغيير المعلومات المختصة بالطالب',

   'Modify user grades for this assessment resource'
=> 'تغيير الدرجات المتعلقة بهذا المورد لتقييم المستخدم',

   'Most recently published Version'
=> 'آخر نسخة منشورة',

   'Move Down'
=> 'تحريك البيانات نحو الأسفل',

   'Move Up'
=> 'تحريك البيانات نحو الأعلى',

   'Name:'
=> 'اسم',

   'New Problem Variation'
=> 'نوع جديد للمسألة',

   'New Randomization'
=> 'عشوائية جديدة',

   'New Title'
=> 'اسم جديد',

   'New parameters or stored values'
=> 'الوسائط الجديدة أو الضوابط المخزونة',

   'Next'
=> 'التالي',

   'Next ->'
=> 'Next -> (274)',

   'No Kerberos domain was specified.'
=> 'Kerberos لم يتم تحديد أي نطاق لل',

   'No changes were made to the current settings.'
=> 'لم يتم أي تغيير في التنظيمات الحالية',

   'No language preference'
=> 'لا توجد أولوية في اللغات',

   'None Found'
=> 'لم يتم العثور على أي مورد',

   'Not shown, not used'
=> 'لم يُعرض، لم يُستخدم',

   'Note: for large courses, this operation may be time consuming'
=> 'ملاحظة: قد تستغرق هذه العمليات مدة طويلة في الدورات الكبيرة',

   'Note: this will not take effect if the user already exists'
=> 'ملاحظة: لا يؤثر هذا إن كان المستخدم موجوداً من قبل',

   'Number of Plots:'
=> 'عدد الرسوم البيانية',

   'Obsolete parameters or stored values'
=> 'الوسائط القديمة أو الضوابط المخزونة',

   'Open'
=> 'فتح',

   'Open All Folders'
=> 'فتح جميع المجلدات',

   'Option Response Problem Analysis'
=> 'تحليل إمكانية الإجابة على المسألة',

   'Option response'
=> 'جواب الانتخاب',

   'Output'
=> ' خروج',

   'Output Format'
=> 'هيئة الخروج',

   'Overall Problem Statistics'
=> 'إحصائيات عامة للمسألة',

   'Owner/Publisher'
=> 'صاحب/ناشر',

   'Parameter Name'
=> 'اسم الوسيط',

   'Parameter Type'
=> 'نوع الوسيط',

   'Parameter in Effect'
=> 'الوسيط في الحالة الواقعية',

   'Per Page'
=> 'في كل صفحة',

   'Personal Information'
=> 'معلومات خاصة',

   'Please do not reply to this address.'
=> 'يرجى عدم إرسال الجواب على هذا العنوان',

   'Please notify the server administrator '
=> 'يرجى إخبار مدير الملقم',

   'Please select a problem to analyze'
=> 'يرجى انتخاب مسألة للدراسة و التحليل',

   'Please select a report to generate'
=> 'يرجى انتخاب تقرير لإنشاء',

   'Please select a report to generate.'
=> 'يرجى انتخاب تقرير لإنشاء',

   'Position'
=> 'موقع',

   'Post anonymously'
=> 'إرسال بدون اسم الكاتب',

   'Post discussion on course resources'
=> 'إرسال بحث حول موارد الدورة',

   'Post system frontpage announcements'
=> 'إرسال إعلانات نظام الصفحة الأمامية',

   'Post to live chatrooms'
=> 'إرسال إلى غرف المحادثة',

   'Preferred language'
=> 'لغة مفضَّلة',

   'Preparing Excel Spreadsheet'
=> 'Excel إعداد اللوحة الجدولية ل',

   'Previous'
=> 'سابق',

   'Printing Helper'
=> 'مساعد الطباعة',

   'Privacy Note'
=> 'مفكرة خاصة',

   'Problem Status Chart'
=> 'رسم بياني لحالة المسألة',

   'Problems'
=> 'مسائل',

   'Problems Not Contained In A Folder'
=> 'لم تدرج المسائل في مجلد واحد',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'المسائل الموجِدة لملف اکسل الجديد. تم ضبط هذا الخطأ. يرجى إخبار مدير لون کابا',

   'Processed [_1] student(s).'
=> 'معالَج l [_1] الطلاب',

   'Processing course structure'
=> 'يعالج تشكيلة الدورة',

   'Processing first student'
=> 'يعالج أول طالب',

   'Produce Excel Output'
=> 'Excel إنتاج خرج',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'تهيئة رسائل التغذية العكسية أو التعاون في بحث الدورة حول هذا المورد',

   'Provide my evaluation of this resource'
=> 'بيِّن تقييمك حول هذا المورد',

   'Publish'
=> 'نشر',

   'Publish Directory'
=> 'نشر الدليل',

   'Publish Directory and Sub Directories'
=> 'نشر الدليل و عناوينه الفرعية',

   'Published'
=> 'منشور',

   'Question Text'
=> 'نص السؤال',

   'Question Type'
=> 'نوع السؤال',

   'Quick Completed Problems Display'
=> 'عرض سريع للمسائل التامة',

   'Random position'
=> 'موقع عشوائي',

   'Re'
=> 'من جديد',

   'Re-enrollment will re-activate data.'
=> 'التسجيل ثانية يؤدي إلى تفعيل المعلومات من جديد',

   'Reading results from'
=> 'قراءة النتائج من',

   'Record'
=> 'تقرير',

   'Registering'
=> 'يسجل',

   'Related'
=> 'متعلق',

   'Reply'
=> 'إجابة',

   'Reset Submissions'
=> 'تنظيم الطلبات من جديد',

   'Resource Feedback and Discussion'
=> 'التغذية العكسية و البحث المختص بالمورد',

   'Resource Level'
=> 'مستوى المورد',

   'Retrieve'
=> 'استخراج',

   'Retrieve Published Resources'
=> 'استخراج الموارد المنشورة',

   'Revert to Last Saved'
=> 'الرجوع إلى آخر مورد  مخزون',

   'Revision Date'
=> 'تاريخ التعديل',

   'Row'
=> 'صف',

   'S.D. tries'
=> 'S.D. اختبارات',

   'Samples'
=> 'نماذج',

   'Save as'
=> 'حفظ باسم',

   'Save as & Make This Sheet the Default'
=> 'حفظ باسم و انتخاب مسبق لهذه الصفحة',

   'Save as ...'
=> 'حفظ باسم',

   'Bubblesheet Scanning Operator'
=> 'Bubblesheet Scanning Operator', # 'Scantron مشغِّل',

   'Search Complete'
=> 'البحث كامل',

   'Section'
=> 'حقل',

   'Sections'
=> 'حقول',

   'Select All'
=> 'انتخاب جميع  الموارد',

   'Select All Students'
=> 'انتخاب جميع الطلاب',

   'Select Date'
=> 'انتخاب التاريخ',

   'Select Enclosing Map or Folder'
=> 'انتخاب الخارطة أو المجلد الملحق',

   'Select Parameter Level'
=> 'انتخاب مستوى الوسيط',

   'Select Spreadsheet File'
=> 'انتخاب ملف اللوحة الجدولية',

   'Select a course'
=> 'انتخب دورة درسیة',

   'Selecting a User'
=> 'ينتخب مستخدما',

   'Send Message to User(s)'
=> 'إرسال رسالة إلى المستخدم',

   'Send New'
=> 'إرسال رسالة جديدة',

   'Send Reply'
=> 'إرسال جواب',

   'Send bubblesheet data to a course'
=> 'Send bubblesheet data to a course', # 'إرسال بيانات اسکنترون إلى دورة',

   'Send as critical message'
=> 'إرسال رسالة مهمة',

   'Send internal email'
=> 'إرسال رسالة إلكترونية داخلية',

   'Sequence or Folder'
=> 'تسلسل أو مجلد',

   'Sequences and Folders'
=> 'تسلسلات و مجلدات',

   'Set Course Environment Parameters'
=> 'تنظيم وسائط محيط الدورة',

   'Set Date'
=> 'تنظيم التاريخ',

   'Set Defaults for All Resources in Course'
=> 'تنظيم الافتراضيات لجميع الموارد في الدورة',

   'Set Version to be used in Course'
=> 'تنظيم نسخة للإفادة منها في الدورة',

   'Set Versions to be used in Course according to Selections below'
=> 'تنظيم نسخة للإفادة منها في الدورة وفق الانتخابات التالية',

   'Set a due date'
=> 'تحديد موعد مناسب',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'تنظيم جميع نسخ المورد وفق النسخة الحالية تحديد النسخ',

   'Set an answer open date'
=> 'تنظيم جواب في تاريخ مفتوح',

   'Set an open date'
=> 'تعيين موعد مفتوح',

   'Set opening datefor all problems in the course for. . .'
=> 'تحديد موعد لشروع جميع المسائل في الدورة',

   'Set the number of tries'
=> 'تحديد عدد الاختبارات',

   'Set the problem weight'
=> 'تحديد أهمية المسألة',

   'Set/Modify Course Assessment Parameter'
=> 'تحديد/تغيير وسيط تقييم الدورة',

   'Set/Modify Course Assessment Parameters'
=> 'تحديد/تغيير وسائط تقييم الدورة',

   'Set/Modify Course Parameters'
=> 'تحديد/تغيير وسائط الدورة',

   'Shared by course faculty and staff'
=> 'مشترك بين أعضاء الهيئة العلمية و الموظفين',

   'Short string response'
=> 'جواب صغير منضَّد',

   'Show More Options'
=> 'عرض خيارات أكثر',

   'Show Preview'
=> 'معاينة قبل الطباعة',

   'Show always at bottom position'
=> 'اعرض دوماً في الحقل السفلي',

   'Show always at top position'
=> 'اعرض دوماً في الحقل العلوي',

   'Show catalog information'
=> 'عرض معلومات القائمة',

   'Show resource'
=> 'عرض المورد',

   'Significant figures are incorrect, submission was not graded.'
=> 'الأعداد الكثيرة غير صحيحة، لم يتم تصحيح الطلب',

   'Simple Problem Editor'
=> 'محرر المسألة البسيط',

   'Size'
=> 'حجم',

   'Size:'
=> 'حجم',

   'Skew Tries'
=> 'تحريف الاختبارات',

   'Space separated'
=> 'تم فصل المساحة',

   'Spreadsheet Computation'
=> 'حساب اللوحة الجدولية',

   'Spreadsheet Computation Status'
=> 'حالة حساب اللوحة الجدولية',

   'Starting'
=> 'يبدأ',

   'Starting and Ending Dates'
=> 'تاريخ البدء و الختم',

   'Statistics'
=> 'إحصائيات',

   'Statistics and Problem Analysis'
=> 'إحصائيات و دراسة المسألة',

   'Store'
=> 'تخزين',

   'Store Changes'
=> 'حفظ التعديلات',

   'Student Data Compilation Progress'
=> 'تطوير جمع معلومات الطالب',

   'Student Data Compilation Status'
=> 'حالة تطوير جمع معلومات الطالب',

   'Student Number'
=> 'رقم الطالب',

   'Student level sheet'
=> 'ورقة مستوى الطالب',

   'Student performance statistics on all problems.'
=> 'إحصائيات عمل الطالب حول جميع المسائل',

   'Students Affected'
=> 'طلاب متأثرون',

   'Submission Time Analysis'
=> 'تحليل زمن الطلب',

   'Submit Changes and Edit'
=> 'تسليم التغييرات و التحرير',

   'Summary'
=> 'مختصر',

   'Summary View'
=> 'رأي مختصر',

   'Synchronized SQL metadata database'
=> 'المعيارية SQL قاعدة البيانات التزامنية لبيانات',

   'Tabulator separated'
=> 'تم فصل المجدولة',

   'Task'
=> 'مهمة',

   'TeXWidth(mm):'
=> 'الاتساع -بالميلي متر',

   'Template'
=> 'أسوة',

   'Temporary Assembly Workspace'
=> 'مساحة العمل الموقتة للتجميع',

   'Text'
=> 'نص',

   'Text Block'
=> 'كتلة النص',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'يستطيع أن يطلع على المعلومات التي ترسلها كل من اتصل ب لون کابا فإن لم تكن راغباً في ذلك، لا ترسل هذه المعلومات',

   'The optional email address field was not specified.'
=> 'لم يتم تحديد حقل عنوان البريد الإلكتروني الاختياري',

   'The optional name field was not specified.'
=> 'لم يتم تحديد حقل الاسم الاختياري',

   'The optional section or group field was not specified.'
=> 'لم يتم تحديد حقل القسم أو المجموعة الاختياري',

   'The optional student number field was not specified.'
=> 'لم يتم تحديد حقل رقم الطلاب الاختياري',

   'There are currently no results'
=> 'لا توجد في الوقت الحاضر أي نتيجة',

   'There are no students currently enrolled.'
=> 'لم يسجل في الوقت الحاضر أي طالب',

   'There is no student data for this problem.'
=> 'لا يوجد لهذه المسألة أي بيان طلابي',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'يعينك هذا المساعد على تعيين المواعيد المفتوحة و المناسبة لهذه المسائل أو على عدد تكرار اختبار هذه المسائل. و سوف تُسأل عن المسائل التي تريد أن تنتخب لها وسيطاً و الوسائط التي تعنى بها. ثم ستنتخب الأشخاص الذين تؤثر عليهم هذه التنظيمات. و يمكنك مشاهدة المواضع التي استعرضتها بعد انتهاء عمل المساعد لتتوافر لك إمكانية إنهاء هذه المرحلة مباشرةً بالضغط على مفتاح التالي سيتم البدء بالعمل و بالضغط على مفتاح السابق سيتم الرجوع إلى الصفحة السابقة',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'LON-CAPA هذه رسالة تلقائية أُنشئت بواسطة نظام لون کابا',

   'Threaded View'
=> 'Threaded View',

   'Time'
=> 'زمن',

   'To'
=> 'إلى',

   'Topic'
=> 'موضوع',

   'Total'
=> 'مجموع',

   'Total Parts In Course'
=> 'الأقسام العامة في الدورة',

   'Total number of records found in file: [_1].'
=> 'لم يتم العثور على مجموع هذه التقارير في الملف',

   'True'
=> 'صحيح',

   'Type'
=> 'نوع',

   'Type-in value'
=> 'نوع المقدار الوارد',

   'UNIX authenticated'
=> 'UNIX تم تأييد',

   'URL'
=> 'عنوان إنترنتي',

   'USERS'
=> 'مستخدمون',

   'Unable to connect to database!'
=> 'لم تتوافر إمكانية الاتصال بقاعدة البيانات',

   'Unable to enroll students'
=> 'لم تتوافر إمكانية تسجيل الطلاب',

   'Uncheck All'
=> 'تسجيل',

   'Unit:'
=> 'وحدة',

   'Unknown ID'
=> 'هوية مجهولة',

   'Unknown user'
=> 'مستخدم مجهول',

   'Unpublished'
=> 'لم يُنشر',

   'Unselect All'
=> 'إلغاء انتخاب الجميع',

   'Unselect All Students'
=> 'إلغاء انتخاب جميع الطلاب',

   'Unsuccessful Login'
=> 'لم يتم الاتصال بنجاح',

   'Up'
=> 'فوق',

   'Update Course Assessment Parameter Display'
=> 'تطوير عرض وسيط تقييم الدورة',

   'Update Section or Specific User'
=> 'تطوير مستخدم القسم أو المستخدم الخاص',

   'Update Student Data'
=> 'تطوير بيانات الطالب',

   'Updating discussion time'
=> 'يطور زمن البحث',

   'Upload bubblesheet data'
=> 'Upload bubblesheet data', # 'تحميل بيانات اسکنترون إلى الشبكة',

   'Upload a Photo'
=> 'تحميل صورة إلى الشبكة',

   'Uploading Class List'
=> 'تحميل قائمة صف إلى الشبكة',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'مذكرات المستخدم، تقارير حول بحوث شفهية و رسائل نقدية في الدورة',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'مذكرات المستخدم، تقارير حول بحوث شفهية و رسائل نقدية',

   'Value'
=> 'مقدار',

   'Verify Content'
=> ' توثيق المحتوى',

   'Verify Selection'
=> 'تأييد الانتخاب',

   'Version Number'
=> 'رقم النسخة',

   'Version changes since Yesterday'
=> 'تغييرات النسخة من يوم أمس  حتى الآن',

   'Version changes since last Month'
=> 'تغييرات النسخة من الشهر الماضي  حتى الآن',

   'Version changes since last Week'
=> 'تغييرات النسخة من الأسبوع الماضي  حتى الآن',

   'Version changes since start of Course'
=> 'تغييرات النسخة من بداية الدورة  حتى الآن',

   'Version used in Course'
=> 'النسخة المستفاد منها في الدورة',

   'View'
=> 'مشاهدة',

   'View Class List'
=> 'مشاهدة قائمة الصف',

   'View Critical Messages'
=> 'مشاهدة الرسائل النقدية',

   'View Published Version'
=> 'مشاهدة النسخة المنشورة',

   'View user submissions for this assessment resource'
=> 'مشاهدة طلبات المستخدم لهذا المورد للتقييم',

   'Warning!'
=> 'إنذار',

   'Web References'
=> 'موارد الوب',

   'Welcome'
=> '!أهلاً و سهلاً',

   'Welcome to the Assignment Parameter Helper'
=> 'نرحب بك في مساعد تسليم الوسيط',

   'Welcome to the Learning[_1]Online[_2] Network with CAPA. Please wait while your session is being set up'
=> 'نرحب بك في شبكة تحميل التعليم بواسطة لون کابا انتظر رجاءً ليتم تنظيم جلستك',

   'What parameter do you want to set for all problems in the course?'
=> 'أي وسيط تريده لتطبيق كل مسائل الدورة؟',

   'What should the opening date be set to?'
=> 'على أي أساس يتم تنظيم تاريخ الافتتاح؟',

   'Which Problem or Problems?'
=> 'أي مسألة أو مسائل؟',

   'Which problems do you wish to set a parameter for?'
=> 'لأي المسائل تريد أن تعين وسيطاً؟',

   'Width(pixel):'
=> 'اتساع النقاط الضوئية - بكسل',

   'Words'
=> 'مفردات',

   'XML/SGML'
=> 'XML/SGML',

   'You have no critical messages.'
=> 'لا توجد لديك أي رسالة نقدية',

   'You must choose an authentication type.'
=> 'عليك أن تنتخب نوعاً من التوثيق',

   'You must choose at least one student to continue.'
=> 'لابد للاستمرار من انتخاب طالب واحد على الأقل',

   'You must choose one or more choices to continue.'
=> 'لابد للاستمرار من انتخاب خيار واحد أو أكثر',

   'You need to choose another user role or enter a specific course for this function'
=> 'لابد من انتخاب دور مستخدم آخر أو إدراج دورة معينة لهذا العمل',

   'You need to specify the Kerberos domain.'
=> 'Kerberos لابد من تحديد نطاق',

   'You need to specify the initial password.'
=> 'لابد من تحديد كلمة المرور البدائية',

   'You need to specify the username field.'
=> 'لابد من تحديد خلفية اسم المستخدم',

   'Your Excel Spreadsheet'
=> 'لوحة اکسیل الجدولية الخاصة بك',

   'Your Version Settings have been Stored'
=> 'تم تخزين تنظيمات نسختك',

   '[_1] Do not change login data'
=> '[_1] لا تبدل بيانات إيجاد الاتصال',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] تم توثيق نظام الملفات بكلمة المرور البدائية',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] تم توثيقه من حيث المحتوى بكلمة المرور البدائية',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] تم توثيق  Kerberos  [_2] [_3] مع النطاق l [_4] الإصدار  l',

   '[_1] Local Authentication with arguement [_2]'
=> '[_1]  argument [توثيق  [_2',

   'a.m.'
=> 'قبل الظهر',

   'abstract'
=> 'تلخيص',

   'acc keys'
=> 'acc مفاتيح',

   'according to course preferences'
=> 'وفق أولويات الدورة',

   'according to resource settings'
=> 'وفق تنظيمات المورد',

   'according to user session state'
=> 'وفق حالة جلسة المستخدم',

   'all'
=> 'جميع',

   'and return receipt'
=> 'و أرجع الوصل',

   'anonymous'
=> 'مجهول',

   'at'
=> 'في',

   'at Domain'
=> 'في النطاق',

   'at domain'
=> 'في النطاق',

   'audio'
=> 'صوتي',

   'author'
=> 'كاتب',

   'bytes'
=> 'بايت',

   'can not be accessed from your location.'
=> 'لا يمكن الوصول إليه من موقعك',

   'catalog'
=> 'قائمة',

   'co con-'
=> 'co con- (530)',

   'co res'
=> 'co res (531)',

   'contacting'
=> 'يتصل',

   'copyright'
=> 'حقوق النشر و الطباعة',

   'customdistributionfile'
=> 'ملف توزيع مطلوب',

   'default'
=> 'افتراضي',

   'directory'
=> 'دليل',

   'discuss'
=> 'مباحثة',

   'edit'
=> 'تحرير',

   'evaluate'
=> 'تقييم',

   'feedback'
=> 'التغذية العكسية',

   'for Enclosing Map or Folder'
=> 'للخارطة أو المجلد الملحق',

   'for Resource'
=> 'للمورد',

   'from Enclosing Map or Folder'
=> 'من الخارطة أو المجلد الملحق',

   'general'
=> 'عام',

   'in Course'
=> 'في الدورة',

   'in Section/Group'
=> 'في الحقل/المجموعة',

   'info'
=> 'معلومات',

   'interface available'
=> 'واجهة المستخدم متاحة',

   'keywords'
=> 'مفاتيح دليلية',

   'language'
=> 'لغة',

   'last student'
=> 'آخر طالب',

   'loginproblems.html'
=> 'loginproblems.html',

   'manage'
=> 'إدارة',

   'minutes'
=> 'دقائق',

   'missions'
=> 'مهمات',

   'most recent'
=> 'أحدث',

   'movies'
=> 'أفلام',

   'name only visible to course faculty'
=> 'لا يمكن مشاهدة الاسم إلا للهيئة العلمية في الدورة',

   'notes'
=> 'مذكرات',

   'num_override'
=> 'num_override',

   'obsolete'
=> 'قديم',

   'obsoletereplacement'
=> 'تبديل القديم',

   'of'
=> 'من',

   'or ID'
=> 'أو الهوية الشخصية',

   'p.m.'
=> 'بعد الظهر',

   'pages'
=> 'صفحات',

   'part'
=> 'حقل',

   'percent'
=> 'نسبة مئوية',

   'pictures'
=> 'صور',

   'problem'
=> 'مسألة',

   'problem statistics grouped by sequence'
=> 'تم تبويب إحصائيات المسألة وفق التوالي',

   'problem statistics ungrouped'
=> 'لم يتم تبويب إحصائيات المسألة',

   'problem statistics, Excel'
=> 'إحصائيات المسألة -اکسیل',

   'remaining'
=> 'الباقي',

   'resources'
=> 'الموارد',

   'second'
=> 'ثانية',

   'seconds'
=> 'ثوان',

   'seconds for'
=> 'ثوان',

   'sequence'
=> 'توالي',

   'subject'
=> 'موضوع',

   'this'
=> 'هذا',

   'title'
=> 'اسم',

   'unless locked'
=> 'إلا إذا كان مُقفلاً',

   'users in'
=> 'المستخدمون في',

   'versions of this problem'
=> 'نُسخ هذه المسألة',

   'view sub-'
=> 'ملاحظة فرعية',

   'waiting on'
=> 'إسداء الخدمة إلى',


#SYNCMARKER
);

1;
