# The LearningOnline Network with CAPA
# Portuguese Localization Lexicon
#
# $Id: pt.pm,v 1.59 2011/10/21 15:30:53 raeburn Exp $
#
# Copyright UNICAMP, Sao Paulo
# Supported in part by Partnership in Global Learning
# Ricardo Kulzer
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################
#
#
# OBSERVAÇÃO: A tradução para o português ainda está em desenvolvimento.
# Para aprimoramentos, edite /home/httpd/lib/perl/Apache/localize/pt.pm
# no servidor (precisa reiniciar o apache para ativar mudanças).
#
# Veja mais detalhes sobre a tradução em
#       http://www.lon-capa.org/international.html
#
# SUAS CONTRIBUIÇÕES E MELHORIAS SERÃO BEM VINDAS AQUI:
#       http://mail.lon-capa.org/mailman/listinfo/lon-capa-dev



package Apache::localize::pt;
use base qw(Apache::localize);

%Lexicon=('_AUTO' => 1,

'char_encoding'=> 'UTF-8',
'language_code'=> 'pt',
'date_locale'  =>
      '$weekday, $day. $month $year, $twentyfour:$minutes:$seconds hs',
'date_months'  => 'Jan,Fev,Mar,Abr,Mai,Jun,Jul,Ago,Set,Out,Nov,Dez',
'date_days'    => 'Dom,Seg,Ter,Qua,Qui,Sex,Sab',
'date_am' => 'manhã',
'date_pm' => 'tarde',
#'textual_remote_display' => 'on',
'htmlarea_lang' => 'pt_br',
'spellcheck_lang' => 'pt',

'anno.gif' => 'pt/anno_pt.gif',
'ccrs.gif' => 'pt/ccrs_pt.gif',
'cprv.gif' => 'pt/cprv_pt.gif',
'enrl.gif' => 'pt/enrl_pt.gif',
'keys.gif' => 'pt/keys_pt.gif',
'pref.gif' => 'pt/pref_pt.gif',
'sbkm.gif' => 'pt/sbkm_pt.gif',
'stat.gif' => 'pt/stat_pt.gif',
'anot.gif' => 'pt/anot_pt.gif',
'chrt.gif' => 'pt/chrt_pt.gif',
'cstr.gif' => 'pt/cstr_pt.gif',
'eval.gif' => 'pt/eval_pt.gif',
'logout.gif' => 'pt/logout_pt.gif',
'prt.gif' => 'pt/prt_pt.gif',
'spacer.gif' => 'pt/spacer_pt.gif',
'vbkm.gif' => 'pt/vbkm_pt.gif',
'bchat.gif' => 'pt/bchat_pt.gif',
'com.gif' => 'pt/com_pt.gif',
'docs.gif' => 'pt/docs_pt.gif',
'fdbk.gif' => 'pt/fdbk_pt.gif',
'nav.gif' => 'pt/nav_pt.gif',
'res.gif' => 'pt/res_pt.gif',
'sprs.gif' => 'pt/sprs_pt.gif',
'catalog.gif' => 'pt/catalog_pt.gif',
'courses.gif' => 'pt/courses_pt.gif',
'egrd.gif' => 'pt/egrd_pt.gif',
'grds.gif' => 'pt/grds_pt.gif',
'parm.gif' => 'pt/parm_pt.gif',
'roles.gif' => 'pt/roles_pt.gif',
'src.gif' => 'pt/src_pt.gif',


   'Arabic - UTF'
=> 'ﺎﻠﻋﺮﺒﻳﺓ - UTF',

   'German - UTF'
=> 'Deutsch - UTF',

   'English - UTF'
=> 'English - UTF',

   'Spanish (Castellan) - UTF'
=> 'español (castellano) - UTF',

   'Persian - UTF'
=> 'ﺍیﺭﺎﻧی - UTF',

   'French - UTF'
=> 'français - UTF',

   'Hebrew - UTF'
=> 'עברית - UTF',

   'Japanese - UTF'
=> '日本語 - UTF',

   'Portuguese - UTF'
=> 'Português - UTF',

   'Russian - UTF'
=> 'Русский - UTF',

   'Turkish - UTF'
=> 'türkçe - UTF',

   'Chinese Simplified - UTF'
=> '简体中文 - UTF',

   'Swedish Chef - UTF'
=> 'Swedish Chef - UTF',

   'aboutlon.gif'
=> 'aboutlon_pt.gif',

   'accessbutton.gif'
=> 'accessbutton_pt.gif',

   'Domain'
=> 'Domínio',

   'Server'
=> 'Servidor',

   'Load'
=> 'Utilização do Servidor',

   'User Load'
=> 'Carregador de Usuários',

   'Help'
=> 'Ajuda',

   'Log in'
=> 'Entrar',

   'Username'
=> 'Username',

   'Password'
=> 'Senha',

   'choose'
=> 'escolha',

   'enter'
=> 'fornecer',

   'view'
=> 'exibir',

   'calendar'
=> 'calendário',

   'role'
=> 'sua função',

   'course'
=> 'curso',

   'Course'
=> 'Curso',

   'Section/Group'
=> 'Seção/Grupo',

   'today'
=> 'hoje',

   'last week'
=> 'semana passada',

   'last month'
=> 'mês passado',

   'last three months'
=> 'ultimos três meses',

   'last six months'
=> 'ultimos seis meses',

   'last year'
=> 'ano passado',

   'Submit'
=> 'Submeter',

   'Rename'
=> 'Renomear',

   'Save'
=> 'Salvar', # 'Salvar como',

   'Done'
=> 'Concluído',

   'Select User'
=> 'Selecionar Usuário',

   'Select Course'
=> 'Selecionar Curso',

   'Changes will become active for your current session after'
=> 'As alterações serão ativadas para sua atual seção após',

   're-initializing course'
=> 'reiniciar o curso',

   ', or the next time you log in.'
=> ', ou na próxima vez que você executar o logon.',

   'Uploaded Document'
=> 'Carregar Documento',

   'No content modifications yet.'
=> 'Sem modificações de conteúdo ainda.',

   'Part is not open to be viewed. It'
=> 'Item não disponível para visualização.',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Impossível determinar se o recurso está aberto devido a problemas de rede. Por favor tente novamente mais tarde',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Aviso: Para as alterações sejam atualizadas para todos os usuários, pode ser necessário cerca de 10 minutos',

   'Language'
=> 'Linguagem',

   'Notes'
=> 'Avisos',

   'Abstract'
=> 'Sumário',

   'Create a user or modify the roles and privileges of a user'
=> 'Criar um usuário ou modificar funções e privilégios de um usuário', # 'Adicionar usuário ou modificar funções e privilégios de um usuário',

   'View course assessment statistics'
=> 'Exibir estatísticas das avaliações do curso', # 'Ver estatísticas dos problemas resolvidos pelos estudantes',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'Definir prazos finais e outros parâmetros de avaliação, bem como modificar o ambiente do curso', # 'Alterar o ambiente do curso, setar prazos finais e outros parâmetros de avaliação',

   'New Folder'
=> 'Nova Pasta',

   'Simple Page'
=> 'Página Simples',

   'Simple Problem'
=> 'Problema Simples',

   'Upload Document'
=> 'Carregar Documento',

   'Search'
=> 'Pesquisar',

   'Import'
=> 'Importar',

   'Main Course Documents'
=> 'Documentos Principais do Curso',

   'Supplemental Course Documents'
=> 'Documentos Suplementares do Curso',

   'Bulletin Board'
=> 'Bulletin Board',

   'Special Documents'
=> 'Documentos Especiais',

   'create'
=> 'criar',

   'grades'
=> 'notas',

   'enroll'
=> 'matrículas',

   'navigate'
=> 'navegar',

   'contents'
=> 'conteúdos',

   'Navigate Contents'
=> 'Navegar Conteúdos',

   'Announcements and Calendar'
=> 'Anúncios e Calendário',

   'Author'
=> 'Autor',

   'Change Your Preferences'
=> 'Modificar Suas Preferências',

   'Choose the user role'
=> 'Alterar a função do usuário', # 'Selecionar a Função',

   'Co-Author'
=> 'Co-Autor',

   'Communication and Messages'
=> 'Comunicação e Mensagens',

   'Course Coordinator'
=> 'Coordenador do Curso',

   'Course Statistics and Charts'
=> 'Estatísticas do Curso e Gráficos',

   'Course announcements and my calendar'
=> 'Calendário e notícias do curso', # 'Avisos do curso e meu calendário',

   'Create Users, Change User Privileges'
=> 'Criar Usuários, Alterar Privilégios de Usuários',

   'Domain Coordinator'
=> 'Coordenador do Domínio',

   'Enrollment Manager'
=> 'Gerenciador de Inscrições',

   'Enter grades from check-out assessment resources'
=> 'Entrar com as notas obidas de recursos de avaliação', # 'Insir notas advindas do check-out das pesquisas de avaliação',

   'Exam Proctor'
=> 'Exame Proktor',

   'Exit LON-CAPA'
=> 'Sair do LON-CAPA',

   'Grades Spreadsheet'
=> 'Planilha de Notas',

   'Grading'
=> 'Boletim',

   'Instructor'
=> 'Instrutor',

   'Launch Remote Control'
=> 'Ativar o Controle Remoto',

   'Main Menu'
=> 'Menu Principal',

   'Navigate Course Contents'
=> 'Navegar pelos Conteúdos do Curso',

   'No Role, Cumulative Privileges'
=> 'Sem função, privilégios cumulativos',

   'Return to Last Location'
=> 'Retorna para última Localização',

   'Send and receive messages'
=> 'Enviar e receber mensagens',

   'Set my user preferences'
=> 'Configurar minhas preferências pessoais',

   'Student'
=> 'Estudante',

   'Switch to another user role'
=> 'Trocar para outra função de usuário', # 'Trocar de Função',

   'Teaching Assistant'
=> 'Assistente do professor',

   'Use or edit my bookmark collection'
=> 'Usar ou editar minha coleção de marcadores',

   'User Roles'
=> 'Função do Usuário',

   'Calculate course grades (Spreadsheet)'
=> 'Calcular notas de curso (planilha)', # 'Planilha para cálculo das notas do curso',

   'Enter the chatroom for the course'
=> 'Entrar na sala de bate-papo do curso',

   'Navigate the table of contents for this course'
=> 'Navegar conteúdos deste curso', # 'Navegar na lista de conteúdos deste curso',

   'Syllabus'
=> 'Plano de Estudos',

   'View the course assessment progress chart'
=> 'Visualizar o gráfico de desempenho na avaliação do curso', # 'Ver quadro de avaliação dos estudantes do curso',

   'Class Hours'
=> 'Horário de Aulas',

   'Course Description'
=> 'Descrição do Curso',

   'Coursepack'
=> 'Conjunto do curso',

   'Current Month'
=> 'Mês Atual',

   'Deadlines'
=> 'Prazos finais',

   'Fri'
=> 'Sex',

   'Grading Information'
=> 'Informação de Notas',

   'Helproom Hours'
=> 'Plantão de dúvidas',

   'Instructor Information'
=> 'Informações do Instrutor',

   'Mon'
=> 'Seg',

   'Next Month'
=> 'Próximo Mês',

   'Office Hours'
=> 'Atendimento extra classe',

   'Prerequisites'
=> 'Pré-Requisitos',

   'Previous Month'
=> 'Mês Passado',

   'Readings'
=> 'Leituras',

   'Sat'
=> 'Sab',

   'January'
=> 'Janeiro',

   'February'
=> 'Fevereiro',

   'March'
=> 'Março',

   'April'
=> 'Abril',

   'May'
=> 'Maio',

   'June'
=> 'Junho',

   'July'
=> 'Julho',

   'August'
=> 'Agosto',

   'September'
=> 'Setembro',

   'October'
=> 'Outubro',

   'November'
=> 'Novembro',

   'December'
=> 'Dezembro',

   'Sun'
=> 'Dom',

   'Textbook'
=> 'Livro Texto',

   'Thu'
=> 'Qui',

   'Tue'
=> 'Ter',

   'Web Links'
=> 'Atalhos para Web',

   'Wed'
=> 'Qua',

   'Drop/Add students in this course'
=> 'Adicionar/Remover estudantes do curso', # 'Remover/Adicionar estudantes ao curso',

   'You have entered that answer before'
=> 'Você já entrou com esta resposta anteriormente',

   'A score has been assigned.'
=> 'Uma nota foi atribuída.',

   'You are correct.'
=> 'Correto!',

   'Your receipt is'
=> 'Seu comprovante é',

   'You are excused from the problem.'
=> 'Você está liberado do problema.',

   'Incorrect'
=> 'Incorreto.',

   'Some parts were not submitted.'
=> 'Algumas partes não foram enviadas.',

   'An error occurred while grading your answer.'
=> 'Ocorreu um erro durante a avaliação da sua resposta.',

   'The submitted answer was too long.'
=> 'A resposta enviada era muito longa.',

   'This question expects a numeric answer.'
=> 'Esta questão requer uma resposta numérica',

   'You have provided an invalid ranking'
=> 'Você forneceu uma ordem invalida',

   'please refer to'
=> 'por favor verifique',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'A extensão do arquivo que você carregou não é permitida.',

   'Units incorrect.'
=> 'Unidades incorretas.',

   'Only a number required.'
=> 'Somente um número requerido.',

   'Units required'
=> 'Unidades requeridas',

   'Unable to understand formula'
=> 'Impossível entender a formula',

   'Your submission has been recorded.'
=> 'Sua submissão foi registrada.',

   'Unknown message'
=> 'Mensagem desconhecida',

   'Answer Submitted'
=> 'Resposta Submetida',

   'Tries'
=> 'Tentativas',

   'Submit Answer'
=> 'Submeter Resposta',

   'Prepare a printable document'
=> 'Preparar um documento para Impressão',

   'Go To My First Homework Problem'
=> 'Vá para o primeiro exercício da Lição de Casa',

   'Discussions'
=> 'Discussões',

   'New discussion since'
=> 'Nova discussão desde',

   'Goodbye'
=> 'Até a próxima!',

   'Select'
=> 'Selecionar',

   'Re-Initialize'
=> 'Reiniciar',

   'Currently selected. '
=> 'Função atual.',

   'Switch Server'
=> 'Trocar Servidor',

   'system wide'
=> 'sistema amplo',

   'Currently not available'
=> 'Indisponível no momento',

   'No role specified'
=> 'Sem função especificada',

   'Remark'
=> 'Observação',

   'Extent'
=> 'Extensão',

   'User Role'
=> 'Função de usuário',

   'Start'
=> 'Início',

   'End'
=> 'Fim',

   'System'
=> 'Sistema',

   'Display'
=> 'Visor',

   "an unknown date"
=> 'data desconhecida',

   "an indeterminate date"
=> 'data indeterminada',

   "will open on"
=> "irá abrir em",

   "is due at"
=> "é devido a;",

   "was due on"
=> "foi devido a;",

   'is closed but you are allowed to view it'
=> "está fechado mas você tem permissão para visualizá-lo",

   "Undid changes, Switched"
=> "alterações desfeitas, Alterado",

   "Unable to undo, unable to switch"
=> "Impossível desfazer, impossível trocar",

   "Unable to make backup"
=> "Impossível fazer cópia de segurança",

   "Saving Modifications to"
=> "Salvando modificações em",

   "Unable to write to"
=> "Impossível escrever em",

   "Analyzing a problem"
=> "Analisando um problema",

   "EditXML"
=> "Editar XML",

   'Discard Edits and View'
=> 'Descartar Alterações e Visualizar',

   'Submit Changes'
=> 'Submeter Alterações',

   'Submit Changes and View'
=> 'Submeter alterações e Visualizar',

   'Edit'
=> 'Editar',

   ', select a template from the pull-down menu below'
=> ', selecione um modelo do menu exibido abaixo',

   'undo'
=> 'desfazer',

   'Answer'
=> 'Resposta',

   'Frequency'
=> 'Freqüência',

   'You did not select a template.'
=> 'Você não selecionou um modelo.',

   'Analyze Progress'
=> 'Analisar Progresso',

   'Getting Problem Variants'
=> 'Adquirindo Variantes do Problema',

   'last problem'
=> 'último problema',

   "may open later."
=> 'pode abrir mais tarde.',

   ', and answers will be available on'
=> ', e respostas estarão disponíveis em',

   "Select a"
=> "Selecione um",

   'Unable to find'
=> 'Impossível localizar',

   'Part'
=> 'Part',

   "Then"
=> 'Então',

   'Create'
=> 'Criar',

   'is in under construction'
=> 'em construção',

   'List of possible answers'
=> 'Lista de respostas possíveis',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Não foram encontradas partes analisáveis neste problema. Atualmente somente estilos de respostas Numéricas, Fórmulas e Cadeias de Caracteres são suportados.',

   'is not analyzable at this time'
=> 'não é analisável neste momento',

   'Access and Usage Statistics'
=> 'Aesso e uso das esatísticas',

   'Actions'
=> 'Ações',

   'All homework is currently completed'
=> 'Toda lição de casa está completa',

   'Answer available'
=> 'Resposta disponível',

   'Answer submitted'
=> 'Resposta enviada',

   'Answer submitted, not yet graded'
=> 'Resposta submetida, ainda não avaliada',

   'Back to Directory'
=> 'Voltar para o Diretório',

   'Cancel'
=> 'Cancelar',

   'Construction Space Directory'
=> 'Construção da Área do Diretório',

   'Contact'
=> 'Contato',

   'Copying file'
=> 'Copiando arquivo',

   'Date'
=> 'Data',

   'Empty'
=> 'Vazio',

   'Evaluation Comments'
=> 'Avaliando Comentários',

   'Evaluation Data'
=> 'Dados de Avaliação',

   'Excused by instructor'
=> 'Desculpado pelo instrutor',

   'File'
=> 'Arquivo',

   'Go Back'
=> 'Voltar',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'Recomenda-se que você use um anti-virus atualizado antes de abrir este arquivo.',

   'Last Modified'
=> 'Última Modificação',

   'Map'
=> 'Mapa/Sequëncia',

   'Map contents are not shown in order.'
=> 'Os conteúdos do mapa não estão sendo exibidos em ordem.',

   'Name'
=> 'Nome',

   'New Messages'
=> 'Novas Mensagens',

   'New Search'
=> 'Nova Pesquisa',

   'No due date'
=> 'Sem data limite',

   'No upload file specified.'
=> 'Não foi especificado o arquivo para carregamento.',

   'No write permission to user directory, FAIL'
=> 'Sem permissão para escrever no diretório de usuário, FALHA',

   'Open, no due date'
=> 'Aberto, sem data limite',

   'Page'
=> 'Página',

   'Path'
=> 'Caminho',

   'Please use browser "Back" button and pick a filename'
=> 'Por favor, clique no botão "Voltar" do navegador e entre com um nome de arquivo',

   'Processing'
=> 'Processando',

   'Searching'
=> 'Pesquisando',

   'Select the Construction Space'
=> 'Selecione a  Área de Construção',

   'Sequence'
=> 'Seqüência',

   'Server Administration'
=> 'Administração do Servidor',

   'Show Only Uncompleted Homework'
=> 'Mostrar apenas a lição de casa incompleta',

   'Status'
=> 'Estado',

   'Save uploaded file as '
=> 'Salvar o arquivo carregado como ',

   'System Administration'
=> 'Administração do Sistema',

   'The target is an existing directory.'
=> 'O destino é um diretório já existente.',

   'Title'
=> 'Título',

   'Uncompleted Homework'
=> 'Lição de Casa não completada',

   'View All Messages'
=> 'Ver Todas as Mensagens',

   'Was due'
=> 'Foi devido a',

   'Yes'
=> 'Sim',

   'You do not have authoring privileges for this resource'
=> 'Você não tem privilégios ou autorização para este recurso',

   'You have no unread messages'
=> 'Você não tem mensagens não lidas', # 'Você não tem mensagens novas',

   'could not be copied.'
=> 'não pode ser copiado(a).',

   'never'
=> 'nunca',

   'not displayed'
=> 'não mostrado',

   ', is reserved internally by LON-CAPA.'
=> ', é reservado internamente pelo LON-CAPA.',

   'Back to'
=> 'Voltar para',

   'Back to Source'
=> 'Volta para a fonte',

   'Back to Source Directory'
=> 'Volta para o diretório do arquivo',

   'Became this version on ...'
=> 'Se tornou esta versão em ...',

   'Browse published resources'
=> 'Navegar pelos recursos publicados',

   'Choose the course to work on'
=> 'Selecione o curso a ser trabalhado', # 'Escolha o curso a ser assistido',

   'Create a new course'
=> 'Criar um novo curso', # 'Cria um novo curso',

   'Customized right of use ...	'
=> 'Direito customizado de uso ...	',

   'Delete messages from bulletin boards'
=> 'Remove mensagens do quadro de anúncios',

   'Domain only - use limited to courses in the domain'
=> 'Domínio Apenas - uso limitou a cursos no domínio',

   'Dynamic Metadata'
=> 'Meta-dado dinâmico',

   'Edit and view documents included in this course'
=> 'Editar e Visualizar documentos incluídos neste curso', # 'Editar e verificar documentos deste curso',

   'Edit/Modify DOCS'
=> 'Editar/Modificar Documentos',

   'Enter my resource construction space'
=> 'Entrar na minha Área de Construção de Recursos', # 'Entrar na Área de Construção',

   'FAIL'
=> 'FALHA',

   'Failed to copy source'
=> 'Falha ao copiar fonte',

   'Failed to write metadata copy'
=> 'Falha ao escrever na copia dos meta-dados',

   'File copied.'
=> 'Arquivo copiado',

   'Finalize Publication'
=> 'Publicação Finalizada',

   'Grant/revoke role of Co-Author'
=> 'Garante/Revoga função de Co-Autor',

   'Grant/revoke role of Domain Coordinator'
=> 'Garante/Revoga função de Coordenador de Domínio',

   'Grant/revoke role of Exam Proctor'
=> 'Garante/Revoga função de Fiscal de Prova',

   'Grant/revoke role of Instructor'
=> 'Garante/Revoga função de Instrutor',

   'Grant/revoke role of Student'
=> 'Garante/Revoga função de Estudante',

   'Grant/revoke role of Superuser'
=> 'Garante/Revoga função de Super-Usuário',

   'Illegal filename.'
=> 'Nome de arquivo ilegal.',

   'Name starting with'
=> 'Nome(s) iniciado com ',

   'No previous versions published.'
=> 'Sem versão prévia publicada.',

   'No write permission to'
=> 'Sem permissão de escrita para',

   'Please pick a version to retrieve'
=> 'Por favor escolha uma versão para restaurar',

   'Private - visible to author only for testing purposes'
=> 'Privado - Visível apenas ao Autor apenas para fins de testes',

   'Private Publication - did not synchronize database'
=> 'Publicação Privada - sem sincronização com a base de dados',

   'Public - no authentication or authorization required for use'
=> 'Público - não requer autenticação ou autorização para o uso',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> 'A restauração de uma versão antiga irá sobre-escrever o arquivo atual na área de construção',

   'Retrieve previous versions of'
=> 'Restaurar versões anteriores de',

   'Retrieve version'
=> 'Restaurar versão',

   'Rule'
=> 'Função',

   'Search the contents of this course'
=> 'Pesquisar o conteúdo deste curso', # 'Pesquisa nos conteúdos do curso',

   'Search the database of published resources'
=> 'Pesquisar a base de dados de material publicado', # 'Pesquisar a base de recursos publicados',

   'Send broadcast and receipt-required email'
=> 'Enviar e-mail geral com exigência de recibimento"',

   'Show Problem Completeness'
=> 'Ver desempenho na solução dos problemas', # 'Mostrar meu desempenho na solução dos problemas',

   'Switch to another course'
=> 'Alterar para outro curso',

   'System wide - can be used for any courses system wide'
=> 'Amplitude do sistema - pode ser usado para qualquer curso do sistema',

   'System wide - open source to all authors'
=> 'Alcance do Sistema - open source to all authors',

   'The extension on this file'
=> 'A estensão deste arquivo',

   'This resource has been marked obsolete by the author(s)'
=> 'Este recurso foi marcado como obsoleto pelo(s) autor(es)',

   'Unsupported character combination'
=> 'Combinação de caracteres não suportada',

   'Uploaded'
=> 'Carregado',

   'Users with Roles Assigned by'
=> 'Usuários com funções atribuidas por',

   'View documents included in this course'
=> 'Ver documentos do curso', # 'Visualizar os documentos suplementares para este curso',

   'View file'
=> 'Eibir arquivo',

   'View pending official course requests'
=> 'View pending official course requests',

   'untitled'
=> 'sem título',

   "Click to download or use your browser's Save Link function"
=> "Clique para baixar ou use a função Salvar Destino do seu navegador",

   '#Stdnts'
=> '#Estudantes',

   '#YES'
=> '#SIM',

   '%Wrng'
=> '%Errados',

   '. . . for a particular section'
=> '. . . para uma seção particular',

   '. . . for all students in the course'
=> '. . . para todos os estudantes do curso',

   '. . . for an individual student'
=> '. . . para um estudante individual',

   '12 am' # midnight
=> '00:00',

   'midnight'
=> 'meia noite',

   '1 am'
=> '1:00',

   '2 am'
=> '2:00',

   '3 am'
=> '3:00',

   '4 am'
=> '4:00',

   '5 am'
=> '5:00',

   '6 am'
=> '6:00',

   '7 am'
=> '7:00',

   '8 am'
=> '8:00',

   '9 am'
=> '9:00',

   '10 am'
=> '10:00',

   '11 am'
=> '11:00',

   '12 noon'
=> '12:00',

   'noon'
=> 'meio dia',

   '1 pm'
=> '13:00',

   '2 pm'
=> '14:00',

   '3 pm'
=> '15:00',

   '4 pm'
=> '16:00',

   '5 pm'
=> '17:00',

   '6 pm'
=> '18:00',

   '7 pm'
=> '19:00',

   '8 pm'
=> '20:00',

   '9 pm'
=> '21:00',

   '10 pm'
=> '22:00',

   '11 pm'
=> '23:00',

   '<- Previous'
=> '<- Anterior',

   'ALL'
=> 'TUDO',

   'About Me'
=> 'Sobre mim',

   'Access Key Management'
=> 'Gerenciamento de chaves de acesso',

   'Additional Keywords'
=> 'Palavras-chave adicionais',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'Meta-dados Adicionais (excessões, parâmetros, exportações)',

   'Advanced Catalog Search'
=> 'Pesquisa Avançada no Catálogo',

   'Advanced Search'
=> 'Pesquisa Avançada',

   'All Maps or Folders'
=> 'Todos os Mapas ou Pastas',

   'All versions'
=> 'Todas as versões',

   'Any Language'
=> 'Qualquer Linguagem',

   'Any User'
=> 'Qualquer Usuário',

   'Any category'
=> 'Qualquer Categoria',

   'Any copyright/distribution'
=> 'Qualquer copyright/distribuição',

   'Assessment'
=> 'Avaliação',

   'Assessment URL and Title'
=> 'URL de Avaliação e Título',

   'Assigned User Roles'
=> 'Funções Atribuidas ao Usuário',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'Funções de Autor e Co-Autor podem não estar disponíveis em outros servidores que não sejam o seu HOME server.',

   'Author(s)'
=> 'Autor(es)',

   'Average number of tries till solved'
=> 'Número médio de tentativas até resolver',

   'Brief view of each students performance in course.'
=> 'Breve resumo do desempenho de cada estudante do curso.',

   'Broadcast Message to Course'
=> 'Enviar Mensagem para todos os Usuários do Curso',

   'Browse Resources'
=> 'Navegar pelos recursos',

   'Browse resources'
=> 'Navegar pelos recursos',

   'Bulletin Board/Discussion'
=> 'Quadro de Avisos/Discussão',

   'Calculations'
=> 'Cálculos',

   'Catalog Information'
=> 'Informação de Catálogo',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Alterações podem levar 10 minutos antes de estarem ativas para todos os estudantes.',

   'Clear All'
=> 'Limpar Tudo',

   'Clear Caches'
=> 'Limpar Caches',

   'Close'
=> 'Fechar',

   'Close All Folders'
=> 'Fechar todas as Pastas',

   'Collapse Remote Control'
=> 'Colapso do Controle Remoto',

   'Comma Separated Values'
=> 'Valores separados por Vírgula',

   'Compact View'
=> 'Visualização Compacta',

   'Construction Space'
=> 'Área de Construção',

   'Construction Space File Operation'
=> 'Operação de Arquivo da Área de Construção',

   'Contact Information'
=> 'Informação de contato',

   'Content changed'
=> 'Conteúdo alterado',

   'Copied metadata'
=> 'Metadado copiado',

   'Copied old metadata'
=> 'Meta-dado antigo copiado',

   'Copied old target file'
=> 'Arquivo de destino angigo copiado',

   'Copied source file'
=> 'Arquivo fonte copiado',

   'Copyright'
=> 'Copyright',

   'Copyright/Distribution'
=> 'Copyright/Distribuição',

   'Could Not Process Request'
=> 'Não foi possível processar requisição',

   'Could not write metadata'
=> 'Não foi possível escrever meta-dados',

   'Course Assessment Parameter - Helper Mode'
=> 'Parâmetros de Avaliação do Curso - Modo Assistente',

   'Course Assessment Parameters - Overview Mode'
=> 'Parâmetros de Avaliação do Curso - Modo Visão Geral',

   'Course Assessments Parameters - Table Mode'
=> 'Parâmetros de Avaliação do Curso - Modo Tabela',

   'Course Documents'
=> 'Documentos do Curso',

   'Course Environment Parameters'
=> 'Parâmetros do Ambiente do Curso',

   'Course ID'
=> 'ID (identificação) do curso',

   'Course Parameter Helper'
=> 'Assistente de Parâmetros de Avaliação',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'Estatísticas do curso e gráficos não podem ser obtidos até que a base dados seja reiniciada. Seus dados estão intactos, mas não podem ser exibidos neste momento.',

   'Course level sheet'
=> 'Planilha - nível do curso',

   'Create New Environment Variable'
=> 'Cria nova variável de Ambiente',

   'Creation Date'
=> 'Data de Criação',

   'Current Session Value'
=> 'Valor da Seção Corrente',

   'Custom Distribution File'
=> 'Arquivo de Distribuição Customizado',

   'Default'
=> 'Padrão',

   'Default Cataloging Information for Directory'
=> 'Informação de Catálogo Padrão para o Diretório',

   'Default Value'
=> 'Valor Padrão',

   'Degree of difficulty'
=> 'Grau de dificuldade',

   'Delete a role'
=> 'Excluir uma função',

   'Detailed Citation View'
=> 'Visualizar Citação Detalhada',

   'Detailed Problem Analysis'
=> 'Análise detalhada dos exercícios',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Estatísticas detalhadas e gráficos do desempenho dos estudantes na solução dos problemas.',

   'Differences'
=> 'Diferenças',

   'Disable all communication among students'
=> 'Desabilitar toda a comunicação entre os estudantes',

   'Discard Selected'
=> 'Descartar Seleção',

   'Distribute Messages from Uploaded File to Course'
=> 'Distribuir Mensagem de Arquivo Carregado para o Curso',

   'DoDiff'
=> 'DoDiff',

   'Due'
=> 'Limite',

   'Dump Course DOCS to Construction Space'
=> 'Descarregar Documentos do Curso na Área de Construção',

   'EMail and Messages'
=> 'E-Mail e Mensagens',

   'Edit Catalog Information'
=> 'Editar Informação de Catálogo',

   'Edit Content of a Map'
=> 'Editar Conteúdo ou Mapa',

   'Edit Directory Catalog Information'
=> 'Editar Informação de Catálogo do Diretório',

   'Edit this resource'
=> 'Editar este recurso',

   'Enclosing Map or Folder'
=> 'Enclosing Map or Folder',

   'End Helper'
=> 'Finalizar Assistente',

   'Enrollment Status'
=> 'Estado das Inscrições',

   'Enter construction space as a co-author'
=> 'Entrar na Área de Construção como Co-Autor',

   'Entering course ...'
=> 'Entrando no curso ...',

   'Error Messages'
=> 'Mensagem de Erro',

   'Evaluate Resource'
=> 'Avaliar Recurso',

   'Every problem in a particular folder'
=> 'Cada problema em uma pasta particular',

   'Every problem in the course'
=> 'Cada problema no curso',

   'Exam Information'
=> 'Informação de Exame',

   'Excel'
=> 'Excel',

   'External Resource'
=> 'Recurso Externo',

   'Failed Access to Construction Space'
=> 'Falha no Acesso a Área de Construção',

   'Fielded Format'
=> 'Formato em Campos',

   'File Category'
=> 'Categoria do Arquivo',

   'Finish Course Initialization'
=> 'Aplicar Configurações ao Curso',

   'Folder'
=> 'Pasta',

   'For User'
=> 'Para Usuário',

   'Force publication of unmodified files'
=> 'Forçar publicação de arquivos não modificados',

   'Generate Spreadsheet'
=> 'Gerar Planilha',

   'Generate Statistics'
=> 'Gerar Estatísticas',

   'Generate new role ...'
=> 'Gerar nova função ...',

   'Go to the next resource in the course sequence'
=> 'Ir para o próximo recurso na sequência do curso',

   'Go to the previous resource in the course sequence'
=> 'Ir para o recurso anterior na sequência do curso',

   'Grant/revoke Course Custom Role'
=> 'Garantir/Revogar função Customizada do Curso',

   'Grant/revoke role of Administrator'
=> 'Garantir/Revogar função de Administrador',

   'Grant/revoke role of Author'
=> 'Garantir/Revogar função de Autor',

   'Grant/revoke role of Course Coordinator'
=> 'Garantir/Revogar função de Coordenador de Curso',

   'Grant/revoke role of Domain Guest'
=> 'Garantir/Revogar função de Convidado do Domínio',

   'Grant/revoke role of Librarian'
=> 'Garantir/Revogar função de Bibliotecário',

   'Grant/revoke role of Bubblesheet Scanning Operator'
=> 'Garantir/Revogar função de operador de bubblesheet scanner',

   'Grant/revoke role of Teaching Assistant'
=> 'Garantir/Revogar função de Assistente do Professor',

   'HTML'
=> 'HTML',

   'Host'
=> 'Hospedeiro',

   'Import a published document'
=> 'Importar um documento publicado',

   'Internally authenticated'
=> 'Autenticado Internamente',

   'Invalid date entry'
=> 'Data de entrada inválida',

   'Kerberos authenticated'
=> 'Kerberos autenticado',

   'Keyword(s)'
=> 'Palavra(s) Chave(s)',

   'Keywords'
=> 'Palavras Chaves',

   'LON-CAPA Helper:'
=> 'Assistente do LON-CAPA:',

   'Last Week'
=> 'Semana Passada',

   'Last access'
=> 'Último acesso',

   'Last modified'
=> 'Última modificação',

   'Last updated'
=> 'Última atualização',

   'Limit by copyright/distribution'
=> 'Limitado por copyright/distribuição',

   'Limit by language'
=> 'Limitado por linguagem',

   'Load Map'
=> 'Carregar Mapa/Sequência',

   'Load:'
=> 'Carga:',

   'Lock and unlock assessments'
=> 'Bloquear e desbloquear avaliações',

   'Logged Out'
=> 'Sessão encerrada',

   'MIME Type'
=> 'MIME Type',

   'Make notes and annotations about this resource'
=> 'Inserir anotações a respeito dessa fonte ',

   'Manage Access Keys'
=> 'Gerenciar Chaves de Acesso', # 'Gerenciar senhas de acesso ao curso',

   'Manage access keys'
=> 'Gerenciar chaves de acesso',

   'Material appears to be correct'
=> 'O material aparenta estar correto',

   'Material covered with sufficient depth'
=> 'O material abrange o assunto com profundidade suficiente',

   'Material is helpful'
=> 'O material é útil',

   'Material presented in clear way'
=> 'O material é apresentado de uma maneira clara',

   'Max Possible To Date'
=> 'Máx. possível até aqui',

   'Max Tries'
=> 'Máx. de Tentativas',

   'Mean Tries'
=> 'Média de Tentativas',

   'Metadata Information'
=> 'Informação de meta-dado',

   'Mime type'
=> 'Tipo Mime',

   'Modification Date'
=> 'Data de Modificação',

   'Modified'
=> 'Modificado',

   'Modify Course Assessment Parameters'
=> 'Modificar Parâmetros de Acesso ao Curso',

   'Modify authentication mechanism and data for a user'
=> 'Modificar mecanismo de autenticação e dados de um usuário',

   'Modify deadlines, etc, for this assessment resource'
=> 'Modifica prazos finais, etc. para este recurso de avaliação',

   'Modify grades'
=> 'Modificar notas',

   'Modify user grades for this assessment resource'
=> 'Modificar notas de usuário para este recurso de avaliação',

   'Move Down'
=> 'Mover para Baixo',

   'Move Up'
=> 'Mover para Cima',

   'My Personal Info'
=> 'Minhas informações pessoais',

   'Network-wide number of accesses (hits)'
=> 'Número de acessos através da rede (hits)',

   'Network-wide number of courses using resource'
=> 'Número de curos na rede que utilizam este recurso',

   'New Title'
=> 'Novo Título',

   'Next    '
=> 'Próximo    ',

   'No changes were made to the current settings.'
=> 'Não foram feitas alterações nas configurações correntes.',

   'Number of resources that follow this resource in maps'
=> 'Número de recursos que seguem essa fonte em mapas ',

   'Number of resources that lead up to this resource in maps'
=> 'Número de recursos que levam a esta fonte em mapas',

   'Number of resources using or importing resource'
=> 'Número de recursos usando ou importando recursos',

   'Obsolete'
=> 'Obsoleto',

   'One particular problem'
=> 'Um problema particular',

   'Open'
=> 'Abrir',

   'Open All Folders'
=> 'Abrir todas as Pastas',

   'Output'
=> 'Saída',

   'Output Format'
=> 'Formato da Saída',

   'Overall Problem Statistics'
=> 'Estatísticas globais dos exercícios',

   'Owner/Publisher'
=> 'Proprietário/Publicador',

   'Parameter Name'
=> 'Nome do Parâmetro',

   'Parameter Type'
=> 'Tipo de Parâmetro',

   'Parameter in Effect'
=> 'Parâmetro em Efeito',

   'Parent Directory'
=> 'Diretório Pai',

   'Per Page'
=> 'Por página',

   'Personal Information'
=> 'Informação Pessoal',

   'Please either'
=> 'Por favor, ',

   'Please notify the server administrator '
=> 'Por favor, notifique o administrador do servidor ',

   'Please select a problem to analyze'
=> 'Por favor, selecione um problema para analizar',

   'Please select a report to generate.'
=> 'Por favor, selecione um relatório a gerar.',

   'Post anonymously'
=> 'Postar anonimamente',

   'Post discussion on course resources'
=> 'Postar discussão nos recursos do curso',

   'Post system frontpage announcements'
=> 'Postar anúncios na frontpage do sistema',

   'Post to live chatrooms'
=> 'Postar livremente em salas de chat',

   'Preparing Excel Spreadsheet'
=> 'Preparar Planilha do Excel',

   'Printing Helper'
=> 'Assistente de Impressão',

   'Privacy Note'
=> 'Nota Privada',

   'Problem Status Chart'
=> 'Quadro dos Estados dos Problemas',

   'Problems Not Contained In A Folder'
=> 'Problemas não estão contidos em uma pasta',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'Problemas criando novo arquivo do Excel.  Este erro foi armazenado em log. Por favor, alerte o administrador do LON-CAPA.',

   'Processing course structure'
=> 'Processando estrutura do curso',

   'Processing first student'
=> 'Processando primeiro estudante',

   'Project Information'
=> 'Informação do Projeto',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Fornece mensagens de realimentação ou contribui para discussão do curso sobre este recurso',

   'Provide my evaluation of this resource'
=> 'Fornece minha avaliação deste recurso',

   'Publish'
=> 'Publicar',

   'Publish Directory'
=> 'Publicar Diretório',

   'Publish Directory and Sub Directories'
=> 'Publicar Diretório e Sub-Diretórios',

   'Published'
=> 'Publicado',

   'Publisher/Owner'
=> 'Publicador/Dono',

   'Publishing'
=> 'Publicando',

   'Quick Completed Problems Display'
=> 'Visualizador Rápido de Problemas Resolvidos',

   'Reading results from'
=> 'Lendo resultados de',

   'Related'
=> 'Relacionado',

   'Resource Feedback and Discussion'
=> 'Realimentação do Recurso e discussão',

   'Resource Level'
=> 'Nível do Recurso',

   'Resource Publication'
=> 'Publicação de Recurso',

   'Resource is technically correct'
=> 'Recurso está técnicamente correto',

   'Retrieve'
=> 'Restaurar',

   'Revert to Last Saved'
=> 'Reverter Para Última Versão Salva',

   'Revision Date'
=> 'Data de Revisão',

   'Row'
=> 'Linha',

   'S.D. tries'
=> 'Desv. Pad. Tentativas',

   'Save as'
=> 'Salvar como',

   'Save as & Make This Sheet the Default'
=> 'Salvar como & tornar esta a Planilha Padrão',

   'Bubblesheet Scanning Operator'
=> 'Operador Bubblesheet Scanner',

   'Score Upload Form'
=> 'Formulário para Carregar pontuações',

   'Search Complete'
=> 'Pesquisa Completada',

   'Section'
=> 'Seção',

   'Sections'
=> 'Seções',

   'Select All'
=> 'Selecione Tudo',

   'Select All Students'
=> 'Selecione Todos os Estudantes',

   'Select Date'
=> 'Selecione a Data',

   'Select Enclosing Map or Folder'
=> 'Selecione o Mapa ou Pasta',

   'Select Map'
=> 'Selecione Mapa/Sequência',

   'Select Parameter Level'
=> 'Selecione Nível do Parâmetro',

   'Select Spreadsheet File'
=> 'Selecione o Arquivo de Planilha',

   'Send Message to User(s)'
=> 'Enviar Mensagem para Usuário(s)',

   'Send bubblesheet data to a course'
=> 'Enviar dados bubblesheet para o curso', # 'Enviar dados de Scantron para um curso',

   'Send internal email'
=> 'Enviar e-mail interno',

   'Sequence or Folder'
=> 'Sequência ou Pasta',

   'Sequences and Folders'
=> 'Sequências e Pastas',

   'Set Course Environment Parameters'
=> 'Configurar Parâmetros de Ambiente do Curso',

   'Set Date'
=> 'Configurar Data',

   'Set Defaults for All Resources in Course'
=> 'Configurar Padrões para Todos os Recursos do Curso',

   'Set a bookmark for this resource'
=> 'Configurar um marcador para este recurso',

   'Set a due date'
=> 'Configurar uma data de vencimento',

   'Set an answer open date'
=> 'Definir uma resposta de data de abertura',

   'Set an open date'
=> 'Configurar uma data de abertura',

   'Set opening datefor all problems in the course for. . .'
=> 'Configurar data de abertura de todos os problemas do curso para  . .',

   'Set the number of tries'
=> 'Definir o número de tentativas',

   'Set the problem weight'
=> 'Definir o peso do problema',

   'Set/Modify Course Assessment Parameter'
=> 'Definir/Modificar Parâmetro de Avaliação do Curso',

   'Set/Modify Course Assessment Parameters'
=> 'Definir/Modificar Parâmetros de Avaliação do Curso',

   'Set/Modify Course Parameters'
=> 'Definir/Modificar Parâmetros do Curso',

   'Shared by course faculty and staff'
=> 'Compartilhado por cursos da faculdade e equipe',

   'Show More Options'
=> 'Mostrar Mais Opções',

   'Show all roles'
=> 'Mostrar todas as funções',

   'Show catalog information'
=> 'Mostrar informação de catálogo',

   'Show resource'
=> 'Mostrar recurso',

   'Significant figures are incorrect, submission was not graded.'
=> 'As figuras significativas estão incorretas, a submissão não foi avaliada.',

   'Since Start of Course'
=> 'Desde o Início do Curso',

   'Since Yesterday'
=> 'Desde Ontem',

   'Size'
=> 'Tamanho',

   'Skew Tries'
=> 'Skew Tentativas',

   'Special documents'
=> 'Documentos especiais',

   'Spreadsheet Computation'
=> 'Processamento da Planilha',

   'Spreadsheet Computation Status'
=> 'Estado do Processamento da Planilha',

   'Statistics'
=> 'Estatísticas',

   'Statistics and Problem Analysis'
=> 'Estatísticas e Análise de Problemas',

   'Save Catalog Information'
=> 'Armazena Informação de Catálogo',

   'Student level sheet'
=> 'Planilha - nível do estudante',

   'Student performance statistics on all problems.'
=> 'Estatísticas de desempenho do estudante em todos os problemas.',

   'Students Affected'
=> 'Estudantes Afetados',

   'Subject'
=> 'Assunto',

   'Successful Login'
=> 'Login Bem Sucedido',

   'Suggested Replacement for Obsolete File'
=> 'Substituição sugerida por arquivo obsoleto',

   'Summary'
=> 'Sumário',

   'Summary View'
=> 'Visualizar Sumário',

   'Switching Role'
=> 'Trocando de Função',

   'Synchronized SQL metadata database'
=> 'Base de meta-dados SQL sincronizada',

   'Target'
=> 'Destino',

   'Task'
=> 'Tarefa',

   'Template'
=> 'Modelo',

   'Temporary Assembly Workspace'
=> 'Área de Trabalho temporária',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'A informação submetida pode ser vista por qualquer pessoa logada no LON-CAPA. Não forneça informação que você não queira compartilhar publicamente.',

   'There are currently no results'
=> 'Atualmente não existem resultados',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'Este assistente irá auxiliá-lo na configuração da data de abertura, data de vencimento, e data de resposta para problemas, ou na configuração do número de tentativas para os problemas. Será pedido a você para selecionar quais problemas você quer configurar, quais os parâmetros a serem configurados, e então você selecionará a quem estes parâmetros devem afetar. Após o assistente ter finalizado, você verá na interface avançada em que lugar você configurou os parâmetros você escolheu. Desta forma, no futuro você poderá fazê-lo diretamente na interface avançada. Clique em  Next -&gt; para iniciar, ou select &lt;- Previous para voltar para tela anterior.',

   'This syllabus can be publicly viewed at'
=> 'Este Plano de Estudos pode ser visualizado publicamente em',

   'Topic'
=> 'Tópico',

   'Total'
=> 'Total',

   'Total Parts In Course'
=> 'Total de partes do curso',

   'Total number of students who have worked on this problem'
=> 'Número total de estudantes que tem trabalhado neste problema',

   'Type'
=> 'Tipo',

   'UNIX authenticated'
=> 'autenticado pelo UNIX',

   'URL'
=> 'URL',

   'URLs To Include in Syllabus'
=> 'URLs para Incluir no Plano de Estudos',

   'USERS'
=> 'USUÁRIOS',

   'Unable to connect to database!'
=> 'Não foi possível conectar a base de dados!',

   'Unknown ID'
=> 'ID desconhecida',

   'Unknown user'
=> 'Usuários desconhecido',

   'Unpublished'
=> 'Não Publicado',

   'Unselect All'
=> 'Deselecionar Tudo',

   'Unselect All Students'
=> 'Desmarcar todos os estudantes',

   'Up'
=> 'Cima',

   'Update Course Assessment Parameter Display'
=> 'Atualizar Exibição do Parâmetro de Avaliação do Curso',

   'Update Display'
=> 'Atualizar visor',

   'Update Section or Specific User'
=> 'Atualizar Seção de Usuário Específico',

   'Upload bubblesheet data'
=> 'Carregamento de informação bubblesheet',

   'Upload a Photo'
=> 'Carga de uma Imagem',

   'Upload a new main course document'
=> 'Carregar um novo Documento Principal para o curso',

   'Upload a new supplemental course document'
=> 'Carregar um novo Documento Suplementar para o curso',

   'User'
=> 'Usuário',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'Notas de Usuários, Registros de Discussões, e Mensagens Críticas no Curso',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'Notas de Usuários, Registros de Discussões, e Mensagens Críticas',

   'Verify Course Documents'
=> 'Verificar Documentos do Curso',

   'Verify Selection'
=> 'Verificar Seleção',

   'Version'
=> 'Versão',

   'Version Number'
=> 'Número da Versão',

   'View'
=> 'Visualizar',

   'View Critical Messages'
=> 'Visualizar Críticas',

   'View Published Version'
=> 'Visualizar Versão Publicada',

   'View user submissions for this assessment resource'
=> 'Visualizar submissões do usuário para este recurso de avaliação',

   'Web References'
=> 'Referências na Web',

   'Welcome to the Assignment Parameter Helper'
=> 'Bem-vindo ao Assistente de Configuração de Parâmetros',

   'What parameter do you want to set for all problems in the course?'
=> 'Qual parâmetro você gostaria de configurar para os problemas do curso?',

   'What should the opening date be set to?'
=> 'Qual a data de abertura a ser configurada?',

   'Which Problem or Problems?'
=> 'Qual(is) problema(s)?',

   'Which problems do you wish to set a parameter for?'
=> 'Quais problemas você gostaria de configurar?',

   'Words'
=> 'Palavras',

   'Wrote Metadata'
=> 'Escreva Meta-dados',

   'XML/SGML'
=> 'XML/SGML',

   'You must choose at least one student to continue.'
=> 'Você precisa escolher ao menos um estudante para continuar.',

   'You must choose one or more choices to continue.'
=> 'Você precisa escolher uma ou mais seleções para continuar.',

   'You need to choose another user role or enter a specific course for this function'
=> 'Você precisa escolher outra função de usuário ou entrar em um curso específico para esta função',

   'Your Excel Spreadsheet'
=> 'Sua Planilha do Excel',

   'Your home server is '
=> 'Seu servidor HOME é ',

   'a.m.'
=> 'a.m.',

   'abstract'
=> 'resumo',

   'acc keys'
=> 'chaves de acesso',

   'access denied'
=> 'acesso negado',

   'according to course preferences'
=> 'de acordo com as preferências do curso',

   'according to resource settings'
=> 'de acordo com as configurações do recurso',

   'according to user session state'
=> 'de acordo com o estado da sessão do usuário',

   'all'
=> 'tudo',

   'anno-[_1]'
=> 'anotações',

   'announce'
=> 'notícias',

   'at'
=> 'em',

   'at Domain'
=> 'no Domínio',

   'at domain'
=> 'no domínio',

   'audio'
=> 'áudio',

   'author'
=> 'autor',

   'backward[_1]'
=> 'voltar',

   'bookmark[_2]'
=> 'marcadores',

   'catalog[_1]'
=> 'Catálogo',

   'chart'
=> 'quadro',

   'chat'
=> 'chat',

   'close this window'
=> 'feche esta janela',

   'connection down'
=> 'sem conexão',

   'contacting'
=> 'contactando',

   'copyright'
=> 'copyright',

   'customdistributionfile'
=> 'arquivo de distribuicao customizado',

   'default'
=> 'padrão',

   'directory'
=> 'diretório',

   'docs'
=> 'documentos',

   'during the last'
=> 'durante a última',

   'edit'
=> 'editar',

   'evaluate[_1]'
=> 'avaliação',

   'exit'
=> 'sair',

   'fas'
=> 'fas',

   'feedback[_1]'
=> 'realimentação',

   'for Enclosing Map or Folder'
=> 'para o Mapa ou Sequência',

   'for Resource'
=> 'para o Recurso',

   'forward[_1]'
=> 'para frente',

   'from Enclosing Map or Folder'
=> 'do Mapa ou Sequência',

   'general'
=> 'geral',

   'in Course'
=> 'no Curso',

   'in Section/Group'
=> 'na Seção/Grupo',

   'interface available'
=> 'Interface disponível',

   'keywords'
=> 'palavras-chave',

   'language'
=> 'linguagem',

   'last student'
=> 'último estudante',

   'library'
=> 'catálogo',

   'log in again'
=> 'efetue o login novamente',

   'manage'
=> 'gerenciar',

   'may be open from a different computer.'
=> 'pode estar aberto em um outro computador.',

   'minutes'
=> 'minutos',

   'missions'
=> 'missões',

   'movies'
=> 'filmes',

   'my'
=> 'minhas',

   'not found'
=> 'não encontrado',

   'notes'
=> 'avios',

   'num_override'
=> 'num_sobrescritos',

   'obsolete'
=> 'obsoleto',

   'obsoletereplacement'
=> 'recolocação do obsoleto',

   'of'
=> 'de',

   'or'
=> 'ou',

   'or ID'
=> 'ou ID',

   'p.m.'
=> 'p.m..',

   'pages'
=> 'páginas',

   'parms'
=> 'parâmetros',

   'part'
=> 'parte',

   'percent'
=> '%',

   'pictures'
=> 'figuras',

   'prepare'
=> 'Preparar',

   'printout'
=> 'impressão',

   'problem'
=> 'problema',

   'problem statistics grouped by sequence'
=> 'estatísticas de problemas agrupadas por sequências',

   'problem statistics ungrouped'
=> 'estatísticas de problemas desagrupadas',

   'problem statistics, Excel'
=> 'estatísticas de problemas, Excel',

   'remaining'
=> 'restante',

   'resource'
=> 'recurso(s)',

   'resources'
=> 'recursos',

   'roles'
=> 'usuários',

   'search'
=> 'pesquisar',

   'second'
=> 'segundo',

   'seconds'
=> 'segundos',

   'seconds for'
=> 'segundos para',

   'sequence'
=> 'sequência',

   'set[_1]'
=> 'inserir',

   'space'
=> 'publicado(s)',

   'stats'
=> 'estatísticas',

   'con-'
=> 'construção',

   'struct'
=> 'de recursos',

   'subject'
=> 'assunto',

   'switch'
=> 'trocar',

   'title'
=> 'Título',

   'unless locked'
=> 'a menos que esteja bloqueado',

   'updated periodically'
=> 'atualizado periódicamente',

   'user'
=> 'usuário',

   'users in'
=> 'usuários em',

   'view sub-'
=> 'visualizar sub-',

   'visible to author and co-authors only'
=> 'visível para autor e co-autores apenas',

   'waiting on'
=> 'aguardando',

   'warning(s)'
=> 'advertência(s)',

   'Welcome to the Learning[_1]Online[_2] Network with CAPA. Please wait while your session is being set up'
=> 'Bem vindo à Rede de Aprendizado[_1]Online[_2] Rede de trabalho com CAPA. Esta é a primeira versão do LON-CAPA traduzida para o português. Aguarde enquanto sua sessão é configurada',

   'Welcome'
=> 'Bem Vindo',

   'Calculate answers'
=> 'Calcular respostas',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;Mostrar&nbsp;Todas&nbsp;Alternativas',

   '1 out of N multiple choice (radio button)'
=> 'tirar 1 de N alternativas de múltipla-escolha (botão de rádio)',

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  Não é possível matricular: [_2]',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: Não é possível matricular. Não foi especificada uma senha.',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>: Username ináceitavel para o usuário [_2] [_3] [_4] [_5]',

   'Administrator'
=> 'Administrador',

   'All Documents in Course'
=> 'Todos os documentos do curso',

   'All Resources (possibly large output)'
=> 'Todos os recursos (possivelmente saída extensa)',

   'Analyze Over '
=> 'Analisar Sobre ',

   'Analyze Problem'
=> 'Analisar Problema',

   'Analyze Problem Again'
=> 'Analisar Problema Novamente',

   'Analyze as '
=> 'Analisar como ',

   'Anonymous'
=> 'Anônimo',

   'Anonymous contribution to course discussion of resource'
=> 'Contribuição Anônima para discussão sobre o recurso',

   'Answer:'
=> 'Resposta:',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'Como regra geral, somente autores ou co-autores podem ser autenticados via sistema de arquivos (o que permite acesso aos arquivos do servidor).',

   'Associate columns with student attributes.'
=> 'Associar colunas com atributos do estudante.',

   'Attachment'
=> 'Atachado',

   'Attribute'
=> 'Attributo',

   'Browsing resource, all submissions are temporary.'
=> 'Recursos de navegação, todas as submissões são temporárias.',

   'By'
=> 'Por',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (planilha, valores separados por vírgula)',

   'Change'
=> 'Alterar',

   'Change Random Seed To:'
=> 'Nova Semente do Gerador de Números:',

   'Change Your Language Preferences'
=> 'Alterar Linguagem',

   'Changed discussion view mode'
=> 'Modo de visualização da discussão alterado',

   'Check All'
=> 'Selecionar Tudo',

   'Check Course Document Versions'
=> 'Checar Versões dos Documentos do Curso',

   'Check for All'
=> 'Selecionar para Todos',

   'Check for None'
=> 'Selecionar para Nenhum',

   'Check for Section/Group'
=> 'Selecionar por Seção/Grupo',

   'Check/Set Resource Versions'
=> 'Checar/Setar Versões do Recurso',

   'Choose a different resource'
=> 'Selecione um recurso diferente',

   'Chronological View'
=> 'Visualização Cronológica',

   'Click-On Texts (comma sep):'
=> 'Click-On Texts (comma sep):',

   'Column'
=> 'Coluna',

   'Column&nbsp;[_1]'
=> 'Coluna&nbsp;[_1]',

   'Concept:'
=> 'Conceito:',

   'Concepts'
=> 'Conceitos',

   'Continue enrollment?'
=> 'Continuar matrícula?',

   'Contribution to course discussion of resource'
=> 'Contribuição à discussão do recurso',

   'Correct Option:'
=> 'Opção Correta:',

   'Create a New Course'
=> 'Criando um Novo Curso <p> <font size="-1" style="color: rgb(255, 0, 0);"> <center> <b>NOTA AO ADMINISTRADOR</b> </center> <p>  A tradução p/ o português está em desenvolvimento. <br>  P/ aprimorar a tradução, edite <b> /home/httpd/lib/perl/Apache/localize/pt.pm </b> no servidor (precisa reiniciar apache p/ ativar mudanças). <br>  Veja mais detalhes sobre a tradução <a href=http://www.lon-capa.org/international.html> aqui. </a> <br> <b> SUAS CONTRIBUIÇÕES E MELHORIAS SERÃO BEM VINDAS <a href=http://mail.lon-capa.org/mailman/listinfo/lon-capa-dev> AQUI. </a></b> </font>',
#=> 'Criando um Novo Curso',

   'Critical Messages'
=> 'Críticas',

   'Current'
=> 'Corrente',

   'Default:'
=> 'Padrao:',

   'Delete'
=> 'Excluir',

   'Delete Checked'
=> 'Excluir Checados',

   'Delete an option'
=> 'Excluir uma opção',

   'Delete:'
=> 'Excluir:',

   'Description:'
=> 'Description:',

   'Diffs'
=> 'Diferença',

   'Diffs with Current Version'
=> 'Diferenças com versão corrente',

   'Diffs with Version'
=> 'Diferenças p/ Versão',

   'Diffs with current Version'
=> 'Diferenças p/ Versão Corrente',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'Desabilitar verificação de conflitos de ID/número de identificação dos estudantes, e forçar alteração de IDs conflitantes (somente se você sabe o que está fazendo). ',

   'Discussion Contributions'
=> 'Contribuições para Discussão',

   'Display All Messages'
=> 'Mostrar Todas as Mensagens',

   'Display all Messages'
=> 'Mostrar todas as Mensagens',

   'Display and analysis of submission times on assessments.'
=> 'Análise dos tempos de submissão das respostas aos exercícios.',

   'Display foils in order given'
=> 'Mostrar alternativas na ordem dada',

   'Display foils in random order'
=> 'Mostrar alternativas em ordem aleatória',

   'Domain Guest'
=> 'Convidado do Domínio',

   'Drop Students'
=> 'Excluir Estudante(s)',

   'Dropped [_1]'
=> 'Excluído [_1]',

   'Dropped [_1] student(s).'
=> 'Excluído(s) [_1] estudante(s).',

   'Dropping Students'
=> 'Excluindo Estudantes',

   'Dump Course DOCS'
=> 'Excluir DOCS do curso',

   'EMail Address'
=> 'Endereço de E-Mail',

   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Erros do Editor - estes erros podem não ter efeitos no processamento do problema, mas provavelmente irão causar problemasmais adiante na Edição usando a ferramenta Edit. Por favor, use o modo de Edição XML (EditXML) para corrigir os erros.',

   'Enroll a single student'
=> 'Matricular um único estudante',

   'Enrolling Students'
=> 'Matriculando estudantes',

   'Error'
=> 'Erro',

   'Error dropping [_1]:[_2]'
=> 'Erro ao exclir [_1]:[_2]',

   'False'
=> 'Falso',

   'Field'
=> 'Campo',

   'Filenames in Construction Space'
=> 'Nomes de arquivos na Área de Construção',

   'First Name'
=> 'Primeiro Nome',

   'Foil'
=> 'Alternativa',

   'Foils'
=> 'Alternativas',

   'Folder in Construction Space'
=> 'Pastas na Área de Construção',

   'Format:'
=> 'Formato:',

   'Forward'
=> 'Passar Adiante',

   'Forwarded message from'
=> 'Mensagem Repassada de',

   'Forwarding'
=> 'Repassando',

   'From'
=> 'De',

   'Full Update'
=> 'Atualização Completa',

   'Full update (also print list of users not enrolled anymore)'
=> 'Atualização completa (também imprime lista de usuários já não mais matriculados)',

   'Functions'
=> 'Funções',

   'Generation'
=> 'Geração',

   'Group/Section'
=> 'Grupo/Seção',

   'HTML/XML'
=> 'HTML/XML',

   'Height(pixel):'
=> 'Altura(pontos):',

   'Hide'
=> 'Ocultar',

   'Hint Text'
=> 'Texto da Dica',

   'ID/Student Number'
=> 'ID/Número de Identificação do Estudante',

   'Identify fields'
=> 'Campos de Identificação',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'Se estivar ativa, a nova função estára diponível na próxima vez em que o estudante entrar no LON-CAPA.',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'Se este recurso está em uso ativo, os dados do desempenho dos estudates para versão anterior poderá se tornar inacessível.',

   'Ignore First Line'
=> 'Ignorar Primeira Linha',

   'Image:'
=> 'Imagem:',

   'Incorrect Answers:'
=> 'Respostas Incorretas:',

   'Initial Password'
=> 'Senha Inicial',

   'Internal Filename'
=> 'Nome de arquivo interno',

   'Invalid home server specified'
=> 'O servidor HOME especificado é inválido',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Manter todos os Recursos atualizados com as Versões mais recentes (padrão)',

   'LON-CAPA Domain for Students'
=> 'Domínio LON-CAPA para os estudantes',

   'LON-CAPA Enrollment Manager'
=> 'Gerenciador de Matrículas do LON-CAPA',

   'LON-CAPA domain: [_1]'
=> 'Domínio LON-CAPA: [_1]',

   'LaTeX batchmode'
=> 'LaTeX batchmode',

   'LaTeX mode:'
=> 'modo LaTeX:',

   'Last Name'
=> 'Último Nome',

   'Last Name, First Names'
=> 'Último Nome, Primeiros Nomes',

   'Last accessed'
=> 'Último acesso',

   'Librarian'
=> 'Bibliotecário',

   'Login Type'
=> 'Tipo de Login',

   'Making Backup to'
=> 'Criando cópia de segurança em',

   'Mark Unread'
=> 'Marcado com Não Lido',

   'Max Number Of Shown Foils:'
=> 'Número Máximo de Alternativas Mostradas:',

   'Max number of foils displayed'
=> 'Número Máximo de Alternativas Exibidas',

   'Metadata'
=> 'Meta-dados',

   'Metadata Version'
=> 'Versão dos Meta-dados',

   'Metadata current version'
=> 'Versão Corrente dos Meta-dados',

   'Middle Names/Initials'
=> 'Nomes Intermediários/Iniciais',

   'Modify Parameters'
=> 'Modificar Parâmetros',

   'Modify student data'
=> 'Modificar dados de um estudante',

   'Most recently published Version'
=> 'Mais recente versão publicada',

   'Name:'
=> 'Nome:',

   'New Problem Variation'
=> 'Nova Variação do Problema',

   'New Randomization'
=> 'Nova Randomização',

   'New parameters or saved values'
=> 'Novos Parâmetros ou Valores Armazenados',

   'Next'
=> 'Próximo',

   'No'
=> 'Não',

   'No Kerberos domain was specified.'
=> 'Não foi especificado o domínio Kerberos.',

   'No language preference'
=> 'Sem preferência de linguagem',

   'None Found'
=> 'nenhum encontrado',

   'Not applicable - '
=> 'Não aplicável - ',

   'Not set - '
=> 'Não configurado - ',

   'Not shown, not used'
=> 'Não mostrado, não usado',

   'Note: for large courses, this operation may be time consuming'
=> 'Nota: para cursos extensos, esta operação poderá demorar um pouco',

   'Note: this will not take effect if the user already exists'
=> 'Nota: Isso não terá efeito se o usuário já existe',

   'Number of Plots:'
=> 'Número de Gráficos:',

   'Obsolete parameters or saved values'
=> 'Parâmetros obsoletos ou valores armazenados',

   'One particular problem (overrides folder and course defaults)'
=> 'Um problema particular (sobrepões padrões da pasta e do curso)',

   'Only Answers'
=> 'Somente Respostas',

   'Option Response Problem Analysis'
=> 'Análise do problema Selecione as Alternativas',

   'Option response'
=> 'Opção Resposta',

   'Please do not reply to this address.'
=> 'Por favor, não responda para este endereço.',

   'Please select a report to generate'
=> 'Por favor, selecione o relatório a ser gerado',

   'Position'
=> 'Posição',

   'Preferred language'
=> 'Linguagem Preferida',

   'Preparing Printout'
=> 'Preparando Impressão',

   'Previous'
=> 'Anterior',

   'Print Index:'
=> 'Imprimir Índice:',

   'Print Table of Contents:'
=> 'Imprimir Tabela de Conteúdos:',

   'Print:'
=> 'Imprimir:',

   'Problems'
=> 'Problemas',

   'Problems from entire course'
=> 'Problemas do curso inteiro',

   'Processed [_1] student(s).'
=> 'Processado(s) [_1] estudante(s).',

   'Produce Excel Output'
=> 'Produzir saída para o Excel',

   'Question Text'
=> 'Texto da Questão',

   'Question Type'
=> 'Tipo da Questão',

   'Random position'
=> 'Posição Aleatória',

   'Re'
=> 'Re',

   'Re-enrollment will re-activate data.'
=> 'Re-matrícula irá reativar os dados.',

   'Record'
=> 'Registro',

   'Registering'
=> 'Registrando',

   'Reply'
=> 'Resposta',

   'Reset Submissions'
=> 'Reiniciar Submissões',

   'Resources from selected sequence in course'
=> 'Resources from selected sequence in course',

   'Retrieve Published Resources'
=> 'Restaurar Recursos Publicados',

   'Retrieving current (most recent) version'
=> 'Retrieving current (most recent) version',

   'Sample Points:'
=> 'Sample Points:',

   'Samples'
=> 'Exemplos',

   'Save as ...'
=> 'Salvar como ...',

   'Select Printing Options:'
=> 'Select Printing Options:',

   'Select a course'
=> 'Selecione um curso',

   'Selecting a User'
=> 'Selecione um Usuário',

   'Send New'
=> 'Enviar ',

   'Send Reply'
=> 'Enviar Resposta',

   'Send as critical message'
=> 'Enviar como mensagem crítica',

   'Set Version to be used in Course'
=> 'Setar Versão a ser usada no Curso',

   'Set Versions to be used in Course according to Selections below'
=> 'Setar Versões a serem usadas no Curso de acordo com as Seleções abaixo ',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Setar todas as Versões de Recursos para Versão Corrente (Corrigir Versões)',

   'Short string response'
=> 'Resposta em curta cadeia de caracteres (string)',

   'Show Preview'
=> 'Pré-visualizar',

   'Show always at bottom position'
=> 'Mostrar sempre na posição inferior',

   'Show always at top position'
=> 'Mostrar sempre na posição superior',

   'Simple Problem Editor'
=> 'Editor de Problema Simplificado',

   'Size:'
=> 'Tamanho:',

   'Space separated'
=> 'separado por espaço',

   'Starting'
=> 'Iniciando',

   'Starting and Ending Dates'
=> 'Datas de Início e de Finalização',

   'Save Changes'
=> 'Salvar Alterações',

   'Student Data Compilation Progress'
=> 'Progresso da Compilação dos Dados do Estudante',

   'Student Data Compilation Status'
=> 'Estado da Compilação dos Dados do Estudante',

   'Student Number'
=> 'Número do Estudante',

   'Student Sheet Links'
=> 'Links para planilha dos estudantes',

   'Submission Time Analysis'
=> 'Análise dos tempos de submissão das respostas',

   'Submit Changes and Edit'
=> 'Submeter Alterações e Editar',

   'Tabulator separated'
=> 'Tabulator separado',

   'TeXWidth(mm):'
=> 'TeXWidth(mm):',

   'Text'
=> 'Texto',

   'Text Block'
=> 'Bloco de Texto',

   'The optional email address field was not specified.'
=> 'O campo E-mail (opcional) não foi especificado.',

   'The optional name field was not specified.'
=> 'O campo Nome (opcional) não foi especificado.',

   'The optional section or group field was not specified.'
=> 'O campo Seção/Grupo (opcional) não foi especificado.',

   'The optional student number field was not specified.'
=> 'O campo Número do Estudante (opcional) não foi especificado.',

   'There are no students currently enrolled.'
=> 'Não existem estudantes matriculados no momento.',

   'There is no student data for this problem.'
=> 'Não existem dados de estudantes para este problema.',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'Esta é uma mensagem gerada automaticamente pelo sistema LON-CAPA.',

   'Threaded View'
=> 'Visualização em Linha (Threaded)',

   'Time'
=> 'Tempo',

   'To'
=> 'Para',

   'Total number of records found in file: [_1].'
=> 'Número total de registros encontrados no arquivo: [_1].',

   'True'
=> 'Verdadeiro',

   'Type in value'
=> 'Digite um valor',

   'Type:'
=> 'Tipo:',

   'Unable to enroll students'
=> 'Não foi possível matricular os estudantes',

   'Uncheck All'
=> 'Deselecionar Tudo',

   'Unit:'
=> 'Unidade:',

   'Unsuccessful Login'
=> 'Login mal sucedido',

   'Update Student Data'
=> 'Atualizar dados do estudante',

   'Updating discussion time'
=> 'Atualizando tempo de discussão',

   'Upload file to Construction Space'
=> 'Carregar arquivo para Área de Construção',

   'Uploading Class List'
=> 'Carregando lista de estudantes',

   'Value'
=> 'Valor',

   'Verify Content'
=> 'Verificar Conteúdo',

   'Version changes since Yesterday'
=> 'Alterações na versão desde ontem',

   'Version changes since last Month'
=> 'Alterações na versão desde o mês passado',

   'Version changes since last Week'
=> 'Alterações na versão desde a última semana',

   'Version changes since start of Course'
=> 'Alterações na versão desde o início do Curso',

   'Version used in Course'
=> 'Versão usada no Curso',

   'View Class List'
=> 'Ver Lista de Estudantes',

   'Warning!'
=> 'Alerta!',

   'Width(pixel):'
=> 'Largura(pontos):',

   'With Answers'
=> 'Com Respostas',

   'Without Answers'
=> 'Sem Respostas',

   'You have no critical messages.'
=> 'Você não tem mensagens críticas.',

   'You must choose an authentication type.'
=> 'Você precisa selecionar algum tipo de autenticação.',

   'You need to specify the Kerberos domain.'
=> 'Você precisa especificar o domínio Kerberos.',

   'You need to specify the initial password.'
=> 'Você precisa especificar uma senha inicial.',

   'You need to specify the username field.'
=> 'Você precisa especificar o campo Username.',

   'Your Version Settings have been Saved'
=> 'Suas configurações de Versão foram armazenadas',

   '[_1] Do not change login data'
=> '[_1] Não alterar dados de login',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Autenticação via Sistema de Arquivos (com a seguinte senha inicial [_2])',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] Autenticado Internamente (com a seguinte senha inicial [_2])',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] Autenticação via Kerberos, domínio [_2] [_3] Versão 4 [_4] Versão 5',

   '[_1] Local Authentication with arguement [_2]'
=> '[_1] Autenticação Local com argumento [_2]',

   'and return receipt'
=> 'e recibo de devolução',

   'anonymous'
=> 'anônimo',

   'bytes'
=> 'bytes',

   'can not be accessed from your location.'
=> 'não pode ser acessado a partir da sua localização.',

   'file<br />extension'
=> 'estensão <br /> do arquivo',

   'most recent'
=> 'mais recente',

   'name only visible to course faculty'
=> 'nome visível apenas para Faculdade do curso',

   'publisher<br />owner'
=> 'publicador<br />dono',

   'standard LaTeX mode'
=> 'modo LaTeX padrão ',

   'versions of this problem'
=> 'versões deste problema',

   'loginproblems.html'
=> 'loginproblems_pt.html',

# ----

   'calendar[_1]'
=> 'Notícias e',

   'announce[_1]'
=> 'calendário',


# ----

   'commu-[_1]'
=> 'Gerenciar', # 'comunicação',

   'nication[_1]'
=> 'mensagens',


# ----

   'course[_10]'
=> 'Sala de',

   'chat[_1]'
=> 'Bate-Papo',


# ----

   'search[_1]'
=> 'Pesquisar',

   'course[_11]'
=> 'conteudos',


# ----

   'search[_2]'
=> 'Pesquisar',

   'library[_1]'
=> 'recursos',


# ----

   'prefer-[_1]'
=> 'Preferências',

   'ences[_1]'
=> 'Pessoais',


# ----

   'exit[_1]'
=> 'Sair do',

   ' [_1]'
=> 'LON-CAPA',


# ----

   'switch[_2]'
=> 'Trocar',

   'role[_1]'
=> 'função',


# ----

   'choose[_2]'
=> 'Trocar',

   'role[_2]'
=> 'função',


# ----

   'choose[_1]'
=> 'Selecionar',

   'course[_1]'
=> 'curso',


# ----

   'switch[_1]'
=> 'Selecionar',

   'course[_2]'
=> 'curso',


# ----

   'course[_3]'
=> 'Ver docs.',

   'docs[_1]'
=> 'do curso',


# ----

   'edit crs[_1]'
=> 'Editar documentos',

   'docs[_2]'
=> 'do curso',


# ----

   'navigate[_1]'
=> 'Navegar',

   'contents[_1]'
=> 'conteudos',


# ----

   'my[_1]'
=> 'Minha',

   'grades[_1]'
=> 'nota',


# ----

   'course[_4]'
=> 'Planilha de',

   'grades[_2]'
=> 'notas do curso',


# ----

   'course[_5]'
=> 'Avaliação',

   'chart[_1]'
=> 'dos estudantes',


# ----

   'course[_6]'
=> 'Estatística',

   'stats[_1]'
=> 'do curso',


# ----

   'course[_7]'
=> 'Matrícular',

   'enroll[_1]'
=> 'estudantes',


# ----

   'manage[_1]'
=> 'Gerenciar',

   'acc keys[_1]'
=> 'chav. de acesso',


# ----

   'user[_1]'
=> 'Gerenciar',

   'roles[_1]'
=> 'usuarios',


# ----

   'create[_1]'
=> 'Criar',

   'course[_8]'
=> 'curso',


# ----

   'course[_9]'
=> 'Parametros',

   'parms[_1]'
=> 'do curso',


# ----

   'con-[_1]'
=> 'Área de',

   'struct[_1]'
=> 'construção',


# ----

   'co con-[_1]'
=> 'Á. cstrção.',

   'struct[_2]'
=> 'como co-autor',


# ----

   'resource[_1]'
=> 'Navegar',

   'space[_1]'
=> 'recursos',


# ----

   'co res[_1]'
=> 'Navegar',

   'space[_2]'
=> 'recursos',


# ----

   'enter[_1]'
=> 'Entrar',

   'grades[_3]'
=> 'notas',


# ----

   'send bub[_1]'
=> 'Entrar',

   'blesheet[_1]'
=> 'bubsheet',


# ----

   'view[_1]'
=> 'Visualizar',

   'bookmark[_1]'
=> 'marcadores',


   '"[_1]" for default hiding'
=> '"[_1]" for default hiding',
# "[_1]" fou padrão hiding
   '"[_1]" for visible separation'
=> '"[_1]" for visible separation',
# "[_1]" fou visible sepaRemion
   '"[_1]" if allowed, anything else if not'
=> '"[_1]" if allowed, anything else if not',
# "[_1]" if tudooQua, anything else if Nãot
   '"[_1]" to disable, anything else if not'
=> '"[_1]" to disable, anything else if not',
# "[_1]" Para disable, anything else if Nãot
   '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.',
# &quot; [_1] &quot; is Nãot an acceptable number de Tentativas. Tentativas must be a positive number with Não decimal point.
   '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.'
=> '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.',
# &quot; [_1] &quot; is Nãot an acceptable weight. Weight must be a positive number.
   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)',
# (fornecer maximum [_1] collabouemous using geRenciarNome ou geRenciarNome@Domínio, e.g. smithje ou smithje@[_2].)
   '(Hand in a file you have prepared on your computer)'
=> '(Hand in a file you have prepared on your computer)',
# (Hand in a Arquivo you have PReparard on your computer)
   ', select a template from the pull-down menu below.'
=> ', select a template from the pull-down menu below.',
# , Selecione um templeme De the pull-down menu below.
   '1 minute'
=> '1 minute',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.',
# <*Response>s aRe both inside de <Parte> and outside de <Parte>, this is Nãot a valid problema, errous in Grading Maio occur.
   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.',
# <b>HTML tudooQua</b>: Discussion Parteicipants can use limited HTML in their postings.
   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML banned</b>: HTML will not be allowed in discussion postings.',
# <b>HTML banned</b>: HTML will Nãot be tudooQua in discussion postings.
   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Instructor</b> - instructors will not be able to participate in discussions',
# <b>Inde Recursosou</b> - inde Recursosous will Nãot be able Para Parteicipeme in Discussões
   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Instructor</b> - instructors will not be able to use or view the chat room',
# <b>Inde Recursosou</b> - inde Recursosous will Nãot be able Para use ou acessar the chem room
   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Students</b> - students will not be able to participate in discussions',
# <b>Estudantes</b> - Estudantes will Nãot be able Para Parteicipeme in Discussões
   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Students</b> - students will not be able to use or view the chat room.',
# <b>Estudantes</b> - Estudantes will Nãot be able Para use ou acessar the chem room.
   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions',
# <b>Assistente do professors</b> - Assistente do professors will Nãot be able Para Parteicipeme in Discussões
   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room',
# <b>Assistente do professors</b> - Assistente do professors will Nãot be able use ou acessar the chem room
   '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>'
=> '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>',
# <p>Your Corrente LON-CAPA Domínio is &quot;<b>[_1]</b>&quot;.</p>
   'ABSTRACT'
=> 'ABSTRACT',
# Resumo
   'Access Control'
=> 'Access Control',

   'Activate'
=> 'Activate',
# Activeme
   'Add Roles'
=> 'Add Roles',
# Add usuários
   'Add new option'
=> 'Add new option',

   "Add one empty page/column after each student's assignment"
=> "Add one empty page/column after each student's assignment",
# Add one Vazio Mapa/Sequënciaa/Exercícios/Coluna after each Estudante's assignment
   "Add three empty pages/column after each student's assignment"
=> "Add three empty pages/column after each student's assignment",
# Add thRee Vazio páginas/Coluna after each Estudante's assignment
   "Add two empty pages/column after each student's assignment"
=> "Add two empty pages/column after each student's assignment",
# Add two Vazio páginas/Coluna after each Estudante's assignment
   'Additional Recipients'
=> 'Additional Recipients',

   'Additional settings, if specified below, will override cloned settings'
=> 'Additional settings, if specified below, will override cloned settings',

   'Advanced Edit'
=> 'Advanced Edit',
# Advanced Editarar
   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.',
# Advanced: You can sFim the feedback De diffeRent Seções Para diffeRent people, Por doing the following: SepaReme each entry with a comma. Para sFim feedback Para a certain addRess fou diffeRent Seções, appFim the Seção Nome ou Nomes (sepaRemed Por semi-colons) in a paRentheTamanhod list after the geRenciar:Domínio. Fou example, john102:msu(001;002;003),bob293:msu(004;005;006),madeCimaNome:heRe(007;008;009) will route  feedback Para &quot;john102&quot; fou SeçõesLON-CAPA, 2, and 3, Para &quot;bob293&quot; fou 4, 5, and 6, and Para &quot;madeCimaNome:heRe&quot; fou 7, 8, and 9. Nãote theRe is Não RequiRement them the addResses be in any Parteicular Domínio.
   'All Resources'
=> 'All Resources',
# tudo Recursos
   'All Students'
=> 'All Students',
# tudo Estudantes
   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.'
=> 'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.',
# tudo settings which you can Alterar with this Ajudaer can also be Alterard Por going Para the Pa.m.scReen and clicking on the &quot;Set  environment&quot; butParan. If you do Nãot have experience cooudineming LON-CAPA s ou if you pRefer the Ajudaer interface, please click Próximo -&gt;.
   'Allow limited HTML in discussion posts'
=> 'Allow limited HTML in discussion posts',
# tudoow limited HTML in discussion posts
   'Allow problems to be split over pages'
=> 'Allow problems to be split over pages',
# tudoow problemas Para be split over páginas
   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Allowed File Extensions for Uploaded Files (uploadedfiletypes)',
# tudooQua Arquivo Extensions fou CarRegado Arquivos (CarRegadoArquivoTipos)
   'Allowed filetypes: <b>[_1]</b>'
=> 'Allowed filetypes: <b>[_1]</b>',
# tudooQua ArquivoTipos: <b>[_1]</b>
   'An error occurred during the attempt to change the section for this student.'
=> 'An error occurred during the attempt to change the section for this student.',
# An errou occuRed during the emtempt Para Alterar the Seção fou this Estudante.
   'An error occurred during the attempt to change the role information for this student.'
=> 'An error occurred during the attempt to change the role information for this student.',
# An errou occurRed during the emtempt Para Alterar the sua função umemion fou this Estudante.
   'Analyzing Results'
=> 'Analyzing Results',

   'Answer Date (answerdate)'
=> 'Answer Date (answerdate)',
# Resposta Deme (Respostademe)
   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Answer Submitted: Your final submission will be graded after the due date.',
# Resposta Submeterted: Your final submission will be graded after the Limite deme.
   'Answerable'
=> 'Answerable',
# Respostaable
   'Assessment Parameters'
=> 'Assessment Parameters',
# Avaliação Parameters
   'Automated Enrollment Manager'
=> 'Automated Enrollment Manager',
# AuParamemed memrícula.m.nt geRenciarr
   'Automated adds'
=> 'Automated adds',
# AuParamemed adds
   'Automated drops'
=> 'Automated drops',
# AuParamemed drops
   'Automated enrollment settings'
=> 'Automated enrollment settings',
# AuParamemed memrícula.m.nt settings
   'Bad Filename'
=> 'Bad Filename',
# Bad ArquivoNome
   'Begin Enrollment'
=> 'Begin Enrollment',
# Begin memrícula.m.nt
   'Binary File'
=> 'Binary File',
# Binary Arquivo
   'Blank'
=> 'Blank',

   'Browse'
=> 'Browse',
# BLinhase
   'CSV format'
=> 'CSV format',
# CSV foumem
   'Cannot publish directory'
=> 'Cannot publish directory',
# CanNãot Publica diRecParauy
   'Cannot retrieve directory'
=> 'Cannot retrieve directory',
# CanNãot Restaurar diRecParauy
   'Catalog Search'
=> 'Catalog Search',
# Cemalog pesquisar
   'Change User Privileges'
=> 'Change User Privileges',
# Alterar geRenciar Privileges
   'Chat Participation'
=> 'Chat Participation',
# chem Parteicipemion
   'Click here for FAQ'
=> 'Click here for FAQ',
# Click heRe fou FAQ
   'Click here for help'
=> 'Click here for help',
# Click heRe fou Ajuda
   'Click here to report bugs'
=> 'Click here to report bugs',
# Click heRe Para Repout bugs
   'Click here to return to the chart.'
=> 'Click here to return to the chart.',
# Click heRe Para Return Para the quadro.
   'Client IP/Name Access Control (acc)'
=> 'Client IP/Name Access Control (acc)',
# Client IP/Nome Access Control (acc)
   'Clone an existing course'
=> 'Clone an existing course',
# Clone an existing
   'Close This Window'
=> 'Close This Window',
# feche esta janela
   'Closed'
=> 'Closed',
# Fechard
   'Communication'
=> 'Communication',
# Commu
   'Compare versions of'
=> 'Compare versions of',
# CompaRe Versãos de
   'Completed'
=> 'Completed',

   'Completely new course'
=> 'Completely new course',
# Completely new
   'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.'
=> 'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.',
# Confirm them this umemion is couRect, Então click &quot;Finish Ajudaer&quot; Para complete setting the parameter.
   'Construction Space Version'
=> 'Construction Space Version',
# Conde Recursosion publicado(s) Versão
   'Continue'
=> 'Continue',

   'Copy current file to'
=> 'Copy current file to',
# Copy Corrente Arquivo Para
   'Copy selected'
=> 'Copy selected',
# Copy SelecionaRed
   'Course Code'
=> 'Course Code',
#  Code
   'Course Content'
=> 'Course Content',
#  Content
   'Course Data'
=> 'Course Data',
#  Dema
   'Course Home Server'
=> 'Course Home Server',
#  Home Servidor
   'Course ID or number'
=> 'Course ID or number',
#  ID ou number
   'Course ID/Number'
=> 'Course ID/Number',
#  ID/Number
   'Course Information'
=> 'Course Information',
#  umemion
   'Course Initialization Helper'
=> 'Course Initialization Helper',
#  Initializemion Ajudaer
   'Course Level'
=> 'Course Level',
#  Level
   'Course Search'
=> 'Course Search',
#  pesquisar
   'Course Title'
=> 'Course Title',
#  Título
   'Course default for all problems'
=> 'Course default for all problems',
#  padrão fou tudo problemas
   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.'
=> 'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.',
#  members can provide feedback about the . You can escolha who will Receive the feedback, such as a diffeRent inde Recursosou ou a TA. Please fornecer their LON-CAPA addRess below, in the foum geRenciar:Domínio, wheRe &quot;geRenciar&quot; and &quot;Domínio&quot; aRe both the LON-CAPA geRenciarNome and LON-CAPA Domínio, Nãot an Endereço de E-Mail.
   'Courses'
=> 'Courses',
# s
   'Create New User'
=> 'Create New User',
# criar New geRenciar
   'Create User'
=> 'Create User',
# criar geRenciar
   'Creating a new'
=> 'Creating a new',
# CReeming a new
   'Crosslisted courses'
=> 'Crosslisted courses',
# Crosslisted s
   'Current Class List'
=> 'Current Class List',
# Corrente Class List
   'Current Ending Date: [_1]'
=> 'Current Ending Date: [_1]',
# Corrente Fiming Deme: [_1]
   'Current Ending Date: not set'
=> 'Current Ending Date: not set',
# Corrente Fiming Deme: Nãot set
   'Current Resource'
=> 'Current Resource',
# Corrente Recurso(s)
   'Current Starting Date: [_1]'
=> 'Current Starting Date: [_1]',
# Corrente Iniciando Deme: [_1]
   'Current Starting Date: not set'
=> 'Current Starting Date: not set',
# Corrente Iniciando Deme: Nãot set
   'Current Version'
=> 'Current Version',
# Corrente Versão
   'Currently no active roles or courses'
=> 'Currently no active roles or courses',
# Correntely Não active usuários ou s
   'Currently no additional roles or courses'
=> 'Currently no additional roles or courses',
# Correntely Não additional usuários ou s
   'Currently submitted: <tt>[_1]</tt>'
=> 'Currently submitted: <tt>[_1]</tt>',
# Correntely Submeterted: <tt>[_1]</tt>
   'Custom Role Editor'
=> 'Custom Role Editor',
# CusParam sua função Editararou
   'Cut selected'
=> 'Cut selected',
# Cut SelecionaRed
   'Decompress'
=> 'Decompress',

   'Default Assessment Spreadsheet'
=> 'Default Assessment Spreadsheet',
# padrão Avaliação SpReadsheet
   'Default Course Spreadsheet'
=> 'Default Course Spreadsheet',
# padrão  SpReadsheet
   'Default Student Spreadsheet'
=> 'Default Student Spreadsheet',
# padrão Estudante SpReadsheet
   'Default XML Style File'
=> 'Default XML Style File',
# padrão XML Style Arquivo
   'Default beginning date when enrolling students'
=> 'Default beginning date when enrolling students',
# padrão beginning deme when memrículasing Estudantes
   'Default ending date when enrolling students'
=> 'Default ending date when enrolling students',
# padrão Fiming deme when memrículasing Estudantes
   'Default for new courses is'
=> 'Default for new courses is',
# padrão fou new s is
   'Default set of options to pass to tth/m when converting tex'
=> 'Default set of options to pass to tth/m when converting tex',
# padrão set de options Para pass Para tth/m when converting tex
   'Define Role'
=> 'Define Role',
# Define sua função
   'Dependencies'
=> 'Dependencies',
# DepFimencies
   'Disable display of problem receipts'
=> 'Disable display of problem receipts',
# Disable Display de problema Receipts
   'Disable student resource discussion'
=> 'Disable student resource discussion',
# Disable Estudante Recurso(s) discussion
   'Disable student use of chatrooms'
=> 'Disable student use of chatrooms',
# Disable Estudante use de chemrooms
   'Disallow Resource Discussion for Roles'
=> 'Disallow Resource Discussion for Roles',
# Distudoow Recurso(s) Discussion fou usuários
   'Disallow Resource Discussion for Users'
=> 'Disallow Resource Discussion for Users',
# Distudoow Recurso(s) Discussion fou geRenciars
   'Disallow live chatroom use for Roles'
=> 'Disallow live chatroom use for Roles',
# Distudoow live chemroom use fou usuários
   'Disallow live chatroom use for Users'
=> 'Disallow live chatroom use for Users',
# Distudoow live chemroom use fou geRenciars
   'Discussion Participation'
=> 'Discussion Participation',
# Discussion Parteicipemion
   'Display file attributes'
=> 'Display file attributes',
# Display Arquivo emtributes
   'Do NOT generate as standard course'
=> 'Do NOT generate as standard course',
# Do NãoT geneReme as standard
   'Do not show plain URL (encrypturl)'
=> 'Do not show plain URL (encrypturl)',
# Do Nãot show plain URL (encryptURL)
   'Domain Level'
=> 'Domain Level',
# Domínio Level
   "Don't Show Feedback"
=> "Don't Show Feedback",

   'Due Date (contentclose)'
=> 'Due Date (contentclose)',
# Limite Deme (contentFechar)
   'Due Date (duedate)'
=> 'Due Date (duedate)',
# Limite Deme (Limitedeme)
   'Duration of automated classlist updates'
=> 'Duration of automated classlist updates',
# DuRemion de auParamemed classlist Cimademes
   'Dynamic Metadata (updated periodically)'
=> 'Dynamic Metadata (updated periodically)',
# Dynamic Metadema (emualizado periódicamente)
   'ERROR'
=> 'ERROR',
# ERRou
   'Edit Custom Role Privileges'
=> 'Edit Custom Role Privileges',
# Editarar CusParam sua função Privileges
   'End Time'
=> 'End Time',
# Fim Tempo
   'Ending Date'
=> 'Ending Date',
# Fiming Deme
   'Enroll One Student'
=> 'Enroll One Student',
# memrículas One Estudante
   'Enroll as student'
=> 'Enroll as student',
# memrículas as Estudante
   'Enrolling'
=> 'Enrolling',
# memrículasing
   'Enrolling Student'
=> 'Enrolling Student',
# memrículasing Estudante
   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.',
# fornecer as many Campos as you can. The Sistema will um you and bring you back Para this Mapa/Sequënciaa/Exercícios if the dema SelecionaRed is insufficient Para memrículas Estudantes in your class.
   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below',
# fornecer terms ou phrases sepaRemed Por AND, ou, ou NãoT Então pRess pesquisar below
   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Enter terms or phrases separated by search operators such as AND, OR, or NOT',
# fornecer terms ou phrases sepaRemed Por pesquisar opeRemous such as AND, ou, ou NãoT
   'Entering Construction Space'
=> 'Entering Construction Space',
# fornecering Conde Recursosion publicado(s)
   'Error: Directory Non Empty'
=> 'Error: Directory Non Empty',
# Errou: DiRecParauy Nãon Vazio
   'Error: destination for operation is an existing directory.'
=> 'Error: destination for operation is an existing directory.',
# Errou: destinemion fou opeRemion is an existing diRecParauy.
   'Essay, open end'
=> 'Essay, open end',
# Essay, Abrir Fim
   'Evaluation Error '
=> 'Evaluation Error ',
# EValormion Errou
   'Every problem in a particular folder (overrides course default)'
=> 'Every problem in a particular folder (overrides course default)',
# Every problema in a Parteicular Pasta (overrides  padrão)
   'Exam Problem'
=> 'Exam Problem',
# Exam problema
   'Excel format'
=> 'Excel format',
# Excel foumem
   'Exit'
=> 'Exit',
# sair
   'Feedback Addresses for Course Content'
=> 'Feedback Addresses for Course Content',
# Feedback AddResses fou  Content
   'Feedback Addresses for Course Content Comments'
=> 'Feedback Addresses for Course Content Comments',
# Feedback AddResses fou  Content Comments
   'Feedback Addresses for Course Policy'
=> 'Feedback Addresses for Course Policy',
# Feedback AddResses fou  Policy
   'Feedback Addresses for Resource Content Question'
=> 'Feedback Addresses for Resource Content Question',
# Feedback AddResses fou Recurso(s) Content Question
   'Finish Helper'
=> 'Finish Helper',
# Finish Ajudaer
   'First'
=> 'First',

   'First Resource'
=> 'First Resource',
# First Recurso(s)
   'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.'
=> 'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.',
# Alternativa Nome <b><tt>[_1]</tt></b> appears moue than once. Alternativa Nomes need Para be unique.
   'Folder/Map'
=> 'Folder/Map',
# Pasta/Mapa/Sequëncia
   'For one or more students'
=> 'For one or more students',
# Fou one ou moue Estudantes
   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Found a <*response> outside of a <part> in a <part>ed problem',
# Found a <*Response> outside de a <Parte> in a <Parte>ed problema
   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.',
# Found Não analyzable Respones in this problema, Correntely only Numerical, Foumula and String Response styles aRe sCiMapa/Sequënciaouted.
   'Generate messages from a file'
=> 'Generate messages from a file',
# GeneReme messages De a Arquivo
   'Go'
=> 'Go',

   'Go to ...'
=> 'Go to ...',
# Go Para ...
   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML can be allowed or banned inside of course discussion.',
# HTML can be tudooQua ou banned inside de  discussion.
   'HTML in Discussions'
=> 'HTML in Discussions',
# HTML in Discussões
   'Hand Graded (handgrade)'
=> 'Hand Graded (handgrade)',

   'Help on Creating Courses'
=> 'Help on Creating Courses',
# Ajuda on CReeming s
   'Hide Empty Rows in Spreadsheets'
=> 'Hide Empty Rows in Spreadsheets',
# Ocultar Vazio Linhas in SpReadsheets
   'Home Server'
=> 'Home Server',
# Home Servidor
   'Homework problem'
=> 'Homework problem',
# Homewouk problema
   'How do I create a CSV file from a spreadsheet'
=> 'How do I create a CSV file from a spreadsheet',
# How do I criar a CSV Arquivo De a spReadsheet
   'How do I create a class list from a spreadsheet'
=> 'How do I create a class list from a spreadsheet',
# How do I criar a class list De a spReadsheet
   'How many tries should be set for all problems in the course?'
=> 'How many tries should be set for all problems in the course?',
# How many Tentativas should be set fou tudo problemas in the ?
   'How many tries should be set for the selected folder?'
=> 'How many tries should be set for the selected folder?',
# How many Tentativas should be set fou the SelecionaRed Pasta?
   'How many tries should be set for the selected problem?'
=> 'How many tries should be set for the selected problem?',
# How many Tentativas should be set fou the SelecionaRed problema?
   'How should the results be printed?'
=> 'How should the results be printed?',

   'Immediately expire own role as Course Coordinator'
=> 'Immediately expire own role as Course Coordinator',
# Immediemely expiRe own sua função as  Cooudinemou
   'Import and Paste Area'
=> 'Import and Paste Area',
# Impout and Paste ARea
   'Include retrieval of student photographs?'
=> 'Include retrieval of student photographs?',
# Include Retrieval de Estudante phoParagraphs?
   'Institutional Information'
=> 'Institutional Information',
# Institutional umemion
   'Invalid Significant figures detected'
=> 'Invalid Significant figures detected',

   'Invalid characters in requested name have been removed.'
=> 'Invalid characters in requested name have been removed.',
# Invalid characters in Requested Nome have been Removed.
   'Invalid login mode or password.'
=> 'Invalid login mode or password.',
# Invalid login mode ou passwoud.
   'Invalid username or domain'
=> 'Invalid username or domain',
# Invalid geRenciarNome ou Domínio
   'KEYWORDS'
=> 'KEYWORDS',
# KEYWouDS
   'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.',
# LON-CAPA has live chem functionality. This  will Receive its own chem room. You Maio deny Estudantes, TAs, ou inde Recursosous the right Para access the chem room.
   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.',
# LON-CAPA Hosts Discussões on tudo Recursos in a . Por padrão, tudo geRenciars aRe tudooQua Para Parteicipeme in these Discussões. If you do Nãot wish certain Tipos de geRenciars Para be able Para use the discussion feemuRes, Selecionar those Tipos below. Nãote your class Maio Nãot have tudo de these usuários; you Maio safely igNãoue usuários you do Nãot intFim Para use. (Fou instance, &quot;Exam ProcParau&quot; is gertudoy useful only fou large s.) Tipos de geRenciars Nãot tudooQua Para Parteicipeme in discussion can still acessar any discussion them other geRenciars post.
   'Languages used'
=> 'Languages used',
# linguagems used
   'Last'
=> 'Last',

   'Leave blank on scoring form'
=> 'Leave blank on scoring form',
# Leave blank on scouing foum
   'List Directory'
=> 'List Directory',
# List DiRecParauy
   'List of hidden parts (hiddenparts)'
=> 'List of hidden parts (hiddenparts)',
# List de hidden Partes (hiddenPartes)
   'Location'
=> 'Location',
# Locemion
   'Login Data'
=> 'Login Data',
# Login Dema
   'Logout'
=> 'Logout',

   'Mail'
=> 'Mail',

   'Make new directory'
=> 'Make new directory',
# Make new diRecParauy
   'Make new file'
=> 'Make new file',
# Make new Arquivo
   'Manual Grading'
=> 'Manual Grading',

   'Map has branchings. Use advanced editor.'
=> 'Map has branchings. Use advanced editor.',
# Mapa/Sequëncia has branchings. Use advanced Editararou.
   'Map has conditions. Use advanced editor.'
=> 'Map has conditions. Use advanced editor.',
# Mapa/Sequëncia has conditions. Use advanced Editararou.
   'Map has resource parameters. Use advanced editor.'
=> 'Map has resource parameters. Use advanced editor.',
# Mapa/Sequëncia has Recurso(s) parameters. Use advanced Editararou.
   'Map has unconnected resources. Use advanced editor.'
=> 'Map has unconnected resources. Use advanced editor.',
# Mapa/Sequëncia has unconnected Recursos. Use advanced Editararou.
   'Maximum Number of Collaborators'
=> 'Maximum Number of Collaborators',
# Maximum Number de Collabouemous
   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximum Number of Collaborators (maxcollaborators)',
# Maximum Number de Collabouemous (maxcollabouemous)
   'Maximum Number of Tries (maxtries)'
=> 'Maximum Number of Tries (maxtries)',
# Maximum Number de Tentativas (maxTentativas)
   'Messaging'
=> 'Messaging',

   'Middle'
=> 'Middle',

   'Middle Name'
=> 'Middle Name',
# Middle Nome
   'Missing Kerberos domain information.'
=> 'Missing Kerberos domain information.',
# Missing Kerberos Domínio umemion.
   'Modification may make assessment data inaccessible'
=> 'Modification may make assessment data inaccessible',
# Modificemion Maio make Avaliação dema inaccessible
   'Modify Enrollment for'
=> 'Modify Enrollment for',
# Modify memrícula.m.nt fou
   'Modify User'
=> 'Modify User',
# Modify geRenciar
   'Modify another students data'
=> 'Modify another students data',
# Modify aNãother Estudantes dema
   'Modify deadlines, etc, for this resource'
=> 'Modify deadlines, etc, for this resource',
# Modify Prazos finais, etc, fou this Recurso(s)
   'Modifying data for user'
=> 'Modifying data for user',
# Modifying dema fou geRenciar
   'Modifying this will make problems'
=> 'Modifying this will make problems',
# Modifying this will make problemas
   'Move current file to'
=> 'Move current file to',
# Move Corrente Arquivo Para
   'Must create new subdirectory inside a directory'
=> 'Must create new subdirectory inside a directory',
# Must criar new subdiRecParauy inside a diRecParauy
   'Name of Role'
=> 'Name of Role',
# Nome de sua função
   'New Directory'
=> 'New Directory',
# New DiRecParauy
   'New HTML file'
=> 'New HTML file',
# New HTML Arquivo
   'New Resource'
=> 'New Resource',
# New Recurso(s)
   'New Role'
=> 'New Role',
# New sua função
   'New User'
=> 'New User',
# New geRenciar
   'New Value'
=> 'New Value',
# New Valor
   'New assembled page'
=> 'New assembled page',
# New assembled Mapa/Sequënciaa/Exercícios
   'New assembled sequence'
=> 'New assembled sequence',
# New assembled sequência
   'New custom rights file'
=> 'New custom rights file',
# New cusParam rights Arquivo
   'New file'
=> 'New file',
# New Arquivo
   'New problem'
=> 'New problem',
# New problema
   'New style file'
=> 'New style file',
# New style Arquivo
   'New subdirectory'
=> 'New subdirectory',
# New subdiRecParauy
   'Next ->'
=> 'Next ->',
# Próximo ->
   'No Access or Usages Statistics are available for this resource.'
=> 'No Access or Usages Statistics are available for this resource.',
# Não Access ou Usages Stemistics aRe available fou this Recurso(s).
   'No Assessment Statistical Data is available for this resource'
=> 'No Assessment Statistical Data is available for this resource',
# Não Avaliação Stemistical Dema is available fou this Recurso(s)
   'No Evaluation Data is available for this resource.'
=> 'No Evaluation Data is available for this resource.',
# Não EValormion Dema is available fou this Recurso(s).
   'No new filename specified.'
=> 'No new filename specified.',
# Não new ArquivoNome specified.
   'No section assigned'
=> 'No section assigned',
# Não Seção assigned
   'No such file'
=> 'No such file',
# Não such Arquivo
   'Not Allowed'
=> 'Not Allowed',
# Nãot tudooQua
   'Not open to be viewed'
=> 'Not open to be viewed',
# Nãot Abrir Para be acessaRed
   'Notification of enrollment changes'
=> 'Notification of enrollment changes',
# Nãotificemion de memrícula.m.nt Alterars
   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?',
# Nãotificemion Para  cooudinemou via LON-CAPa.m.ssage when memrícula.m.nt Alterars occur during the auParamemed Cimademe?
   'Number of Tries before hints appear (hinttries)'
=> 'Number of Tries before hints appear (hinttries)',
# Number de Tentativas befoue hints appear (hintTentativas)
   'Number of assignments printed at the same time:'
=> 'Number of assignments printed at the same time:',
# Number de assignments printed em the same Tempo:
   'Number of bubbles in exam mode (numbubbles)'
=> 'Number of bubbles in exam mode (numbubbles)',
# Number de bubbles in exam mode (numbubbles)
   'Number of columns'
=> 'Number of columns',
# Number de Colunas
   'Numerical Tolerance (tol)'
=> 'Numerical Tolerance (tol)',
# Numerical Paralerance (Paral)
   'Old Value'
=> 'Old Value',
# Old Valor
   'Online Help'
=> 'Online Help',
# Online Ajuda
   'Only domain coordinators can change a users password.'
=> 'Only domain coordinators can change a users password.',
# Only Domínio cooudinemous can Alterar a geRenciars passwoud.
   'Open Course'
=> 'Open Course',
# Abrir
   'Open all assessments'
=> 'Open all assessments',
# Abrir tudo Avaliaçãos
   'Open and correct'
=> 'Open and correct',
# Abrir and couRect
   'Open with full tries'
=> 'Open with full tries',
# Abrir with full Tentativas
   'Opening Date (contentopen)'
=> 'Opening Date (contentopen)',
# Abriring Deme (contenParapen)
   'Opening Date (opendate)'
=> 'Opening Date (opendate)',
# Abriring Deme (Abrirdeme)
   'Output Format: [_1]'
=> 'Output Format: [_1]',
# Saída Foumem: [_1]
   'Page layout'
=> 'Page layout',
# Mapa/Sequënciaa/Exercícios layout
   'Paper type'
=> 'Paper type',
# Paper Tipo
   'Parameter'
=> 'Parameter',

   'Part Description (display)'
=> 'Part Description (display)',
# Parte Description (Display)
   'Paste after selected'
=> 'Paste after selected',
# Paste after SelecionaRed
   'Personal Data'
=> 'Personal Data',
# Personal Dema
   'Please adjust significant figures.'
=> 'Please adjust significant figures.',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process',
# Please escolha the padrão auEntãoticemion method Para be used Por new geRenciars added Para this LON-CAPA Domínio Por the auParamemed memrícula.m.nt process
   'Please click Back on your browser and select another user, or '
=> 'Please click Back on your browser and select another user, or ',
# Please click Back on your bLinhaser and Selecione umNãother geRenciar, ou
   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Please contact your LON-CAPA administrator regarding this situation.',
# Please Contato your LON-CAPA a.m.nistRemou Regarding this siTermion.
   'Please select an authentication mechanism'
=> 'Please select an authentication mechanism',
# Please Selecione umn auEntãoticemion mechanism
   'Please select the authentication mechanism'
=> 'Please select the authentication mechanism',
# Please Selecionar the auEntãoticemion mechanism
   'Please select the section you wish to set the answer open date for:'
=> 'Please select the section you wish to set the answer open date for:',
# Please Selecionar the Seção you wish Para set the Resposta Abrir deme fou:
   'Please select the section you wish to set the due date for:'
=> 'Please select the section you wish to set the due date for:',
# Please Selecionar the Seção you wish Para set the Limite deme fou:
   'Please select the section you wish to set the number of tries for:'
=> 'Please select the section you wish to set the number of tries for:',
# Please Selecionar the Seção you wish Para set the number de Tentativas fou:
   'Please select the section you wish to set the opening date for:'
=> 'Please select the section you wish to set the opening date for:',
# Please Selecionar the Seção you wish Para set the Abriring deme fou:
   'Please select the section you wish to set the problem weight for:'
=> 'Please select the section you wish to set the problem weight for:',
# Please Selecionar the Seção you wish Para set the problema weight fou:
   'Please select the student you wish to set the answer open date for:'
=> 'Please select the student you wish to set the answer open date for:',
# Please Selecionar the Estudante you wish Para set the Resposta Abrir deme fou:
   'Please select the student you wish to set the due date for:'
=> 'Please select the student you wish to set the due date for:',
# Please Selecionar the Estudante you wish Para set the Limite deme fou:
   'Please select the student you wish to set the number of tries for:'
=> 'Please select the student you wish to set the number of tries for:',
# Please Selecionar the Estudante you wish Para set the number de Tentativas fou:
   'Please select the student you wish to set the opening date for:'
=> 'Please select the student you wish to set the opening date for:',
# Please Selecionar the Estudante you wish Para set the Abriring deme fou:
   'Please select the student you wish to set the problem weight for:'
=> 'Please select the student you wish to set the problem weight for:',
# Please Selecionar the Estudante you wish Para set the problema weight fou:
   'Please stand by.'
=> 'Please stand by.',
# Please stand Por.
   "Please use browser 'Back' button and pick a filename"
=> "Please use browser 'Back' button and pick a filename",
# Please use bLinhaser 'Back' butParan and pick a ArquivoNome
   'Print'
=> 'Print',

   'Privileged users that should not be hidden on staff listings'
=> 'Privileged users that should not be hidden on staff listings',
# Privileged geRenciars them should Nãot be hidden on staff listings
   'Processed file'
=> 'Processed file',
# Processed Arquivo
   'Publish this Resource'
=> 'Publish this Resource',
# Publica this Recurso(s)
   'Question Type (type)'
=> 'Question Type (type)',
# Question Tipo (Tipo)
   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)',
# Random seed fou randomly picking number de Recursos (optional, only set if you kNãow whem you aRe doing) (randompickseed)
   'Randomization algorithm used'
=> 'Randomization algorithm used',
# Randomizemion algouithm used
   'Randomly pick number of resources (randompick)'
=> 'Randomly pick number of resources (randompick)',
# Randomly pick number de Recursos (randompick)
   'Reading results from [_1]'
=> 'Reading results from [_1]',
# LFimo Resultados de [_1]
   'Receipt algorithm used'
=> 'Receipt algorithm used',
# Receipt algouithm used
   'Receiving results from [_1]'
=> 'Receiving results from [_1]',
# Receiving Results De [_1]
   'Recent'
=> 'Recent',

   'Rename current file to'
=> 'Rename current file to',
# ReNãomear Corrente Arquivo Para
   'Report a Bug'
=> 'Report a Bug',
# Repout a Bug
   'Resource'
=> 'Resource',
# Recurso(s)
   'Resource Differences'
=> 'Resource Differences',
# Recurso(s) Differ
   'Resource Hidden from Students (hiddenresource)'
=> 'Resource Hidden from Students (hiddenresource)',
# Recurso(s) Hidden De Estudantes (hiddenRecurso(s))
   'Resource alias name for conditions (mapalias)'
=> 'Resource alias name for conditions (mapalias)',
# Recurso(s) alias Nome fou conditions (Mapa/Sequënciaalias)
   'Resources'
=> 'Resources',
# Recursos
   'Response'
=> 'Response',

   'Retrieve Old Version'
=> 'Retrieve Old Version',
# Restaurar Old Versão
   'Return to DOCS'
=> 'Return to DOCS',
# Return Para documenParas
   'Reverse Association'
=> 'Reverse Association',
# Reverse Associemion
   'Revoke'
=> 'Revoke',

   'Revoke Existing Roles'
=> 'Revoke Existing Roles',
# Revoke Existing usuários
   'Role'
=> 'Role',
# sua função
   'Role Information'
=> 'Role Information',
# sua função umemion
   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Save entries below as a draft answer (not submitting them for credit yet)',
# Salvar enTentativas below as a draft Resposta (Nãot Submeterting them fou cREditarar yet)
   'Search Complete [_1]'
=> 'Search Complete [_1]',
# pesquisar Complete [_1]
   'Search: [_1]'
=> 'Search: [_1]',
# pesquisar: [_1]
   'Select Action'
=> 'Select Action',
# Selecione umction
   'Select All Files'
=> 'Select All Files',
# Selecionar tudo Arquivos
   'Select All Published'
=> 'Select All Published',
# Selecionar tudo Publicado
   'Select All Resources'
=> 'Select All Resources',
# Selecionar tudo Recursos
   'Select Folder'
=> 'Select Folder',
# Selecionar Pasta
   'Select Only Current Students'
=> 'Select Only Current Students',
# Selecionar Only Corrente Estudantes
   'Select Problem'
=> 'Select Problem',
# Selecionar problema
   'Select Problem(s) to print'
=> 'Select Problem(s) to print',
# Selecionar problema(s) Para print
   'Select Resource(s) to print'
=> 'Select Resource(s) to print',
# Selecionar Recurso(s)(s) Para print
   'Select Resources To Print'
=> 'Select Resources To Print',
# Selecionar Recursos Para Print
   'Select Section'
=> 'Select Section',
# Selecionar Seção
   'Select Sequence To Print From'
=> 'Select Sequence To Print From',
# Selecionar sequência Para Print De
   'Select Student'
=> 'Select Student',
# Selecionar Estudante
   'Select Students and Resources'
=> 'Select Students and Resources',
# Selecionar Estudantes and Recursos
   'Select Style File'
=> 'Select Style File',
# Selecionar Style Arquivo
   'Select a user name to modify the students information'
=> 'Select a user name to modify the students information',
# Selecione um geRenciar Nome Para modify the Estudantes umemion
   'Select a user name to view the users personal page.'
=> 'Select a user name to view the users personal page.',
# Selecione um geRenciar Nome Para acessar the geRenciars personal Mapa/Sequënciaa/Exercícios.
   'Select for Section/Group'
=> 'Select for Section/Group',
# Selecionar fou Seção/GroCima
   'Select resources for the assignment'
=> 'Select resources for the assignment',
# Selecionar Recursos fou the assignment
   'Select the folder you wish to set the parameter for:'
=> 'Select the folder you wish to set the parameter for:',
# Selecionar the Pasta you wish Para set the parameter fou:
   'Select the problem you wish to set the parameter for:'
=> 'Select the problem you wish to set the parameter for:',
# Selecionar the problema you wish Para set the parameter fou:
   'Set'
=> 'Set',

   'Set Course Environment'
=> 'Set Course Environment',
# Set  Environment
   'Set End Date'
=> 'Set End Date',
# Set Fim Deme
   'Set Individual User Roles'
=> 'Set Individual User Roles',
# Set Individual geRenciar usuários
   'Set Problem Tries'
=> 'Set Problem Tries',
# Set problema Tentativas
   'Set Problem Weight'
=> 'Set Problem Weight',
# Set problema Weight
   'Set Start Date'
=> 'Set Start Date',
# Set Início Deme
   'Set answer open date for all problems in the course for ...'
=> 'Set answer open date for all problems in the course for ...',
# Set Resposta Abrir deme fou tudo problemas in the  fou ...
   'Set answer open date for the selected folder for ...'
=> 'Set answer open date for the selected folder for ...',
# Set Resposta Abrir deme fou the SelecionaRed Pasta fou ...
   'Set answer open date for the selected problem for ...'
=> 'Set answer open date for the selected problem for ...',
# Set Resposta Abrir deme fou the SelecionaRed problema fou ...
   'Set content feedback to Course Coordinator'
=> 'Set content feedback to Course Coordinator',
# Set content feedback Para  Cooudinemou
   'Set course policy feedback to Course Coordinator'
=> 'Set course policy feedback to Course Coordinator',
# Set  policy feedback Para  Cooudinemou
   'Set due date for all problems in the course for ...'
=> 'Set due date for all problems in the course for ...',
# Set Limite deme fou tudo problemas in the  fou ...
   'Set due date for the selected folder for ...'
=> 'Set due date for the selected folder for ...',
# Set Limite deme fou the SelecionaRed Pasta fou ...
   'Set due date for the selected problem for ...'
=> 'Set due date for the selected problem for ...',
# Set Limite deme fou the SelecionaRed problema fou ...
   'Set number of tries for all problems in the course for ...'
=> 'Set number of tries for all problems in the course for ...',
# Set number de Tentativas fou tudo problemas in the  fou ...
   'Set number of tries for the selected folder for ...'
=> 'Set number of tries for the selected folder for ...',
# Set number de Tentativas fou the SelecionaRed Pasta fou ...
   'Set number of tries for the selected problem for ...'
=> 'Set number of tries for the selected problem for ...',
# Set number de Tentativas fou the SelecionaRed problema fou ...
   'Set opening date for all problems in the course for ...'
=> 'Set opening date for all problems in the course for ...',
# Set Abriring deme fou tudo problemas in the  fou ...
   'Set opening date for all problems in the course for. . .'
=> 'Set opening date for all problems in the course for. . .',
# Set Abriring deme fou tudo problemas in the  fou. . .
   'Set opening date for the selected folder for ...'
=> 'Set opening date for the selected folder for ...',
# Set Abriring deme fou the SelecionaRed Pasta fou ...
   'Set opening date for the selected problem for ...'
=> 'Set opening date for the selected problem for ...',
# Set Abriring deme fou the SelecionaRed problema fou ...
   'Set problem weight for all problems in the course for ...'
=> 'Set problem weight for all problems in the course for ...',
# Set problema weight fou tudo problemas in the  fou ...
   'Set problem weight for the selected folder for ...'
=> 'Set problem weight for the selected folder for ...',
# Set problema weight fou the SelecionaRed Pasta fou ...
   'Set problem weight for the selected problem for ...'
=> 'Set problem weight for the selected problem for ...',
# Set problema weight fou the SelecionaRed problema fou ...
   'Set to ...'
=> 'Set to ...',
# Set Para ...
   'Set value to "[_1]" to allow'
=> 'Set value to "[_1]" to allow',
# Set Valor Para "[_1]" Para tudoow
   'Setting the [_1]'
=> 'Setting the [_1]',

   'Setting the [_1] to [_2]'
=> 'Setting the [_1] to [_2]',
# Setting the [_1] Para [_2]
   'Show Answer'
=> 'Show Answer',
# Show Resposta
   'Show Feedback'
=> 'Show Feedback',

   'Show Problem Status (problemstatus)'
=> 'Show Problem Status (problemstatus)',
# Show problema Stemus (problemastemus)
   'Show Units - Disable Entry (turnoffunit)'
=> 'Show Units - Disable Entry (turnoffunit)',
# Show Units - Disable Entry (turndefunit)
   'Significant Digits (sig)'
=> 'Significant Digits (sig)',

   'Simple Edit'
=> 'Simple Edit',
# Simple Editarar
   'Some items were not submitted'
=> 'Some items were not submitted',
# Some items weRe Nãot Submeterted
   'Start Time'
=> 'Start Time',
# Início Tempo
   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Start each student's assignment on a new page/column (add a pagefeed after each assignment)",
# Início each Estudante's assignment on a new Mapa/Sequënciaa/Exercícios/Coluna (add a Mapa/Sequënciaa/Exercíciosfeed after each assignment)
   'Starting Date'
=> 'Starting Date',
# Iniciando Deme
   'Student ID'
=> 'Student ID',
# Estudante ID
   'Student Information'
=> 'Student Information',
# Estudante umemion
   'Student Name'
=> 'Student Name',
# Estudante Nome
   'Student Status'
=> 'Student Status',
# Estudante Stemus
   'Student Status: [_1]'
=> 'Student Status: [_1]',
# Estudante Stemus: [_1]
   'Student information updated successfully.'
=> 'Student information updated successfully.',
# Estudante umemion Cimademed successfully.
   'Students need access key to enter course'
=> 'Students need access key to enter course',
# Estudantes need access key Para fornecer
   'Students with expired roles'
=> 'Students with expired roles',
# Estudantes with expiRed usuários
   'Subject:'
=> 'Subject:',
# asDomPara:
   'Submissions'
=> 'Submissions',
# Submissões
   'Submit Modifications'
=> 'Submit Modifications',
# Submeter Modificemions
   'Submit entries below as answer to receive credit'
=> 'Submit entries below as answer to receive credit',
# Submeter enTentativas below as Resposta Para Receive cREditarar
   'Survey Question'
=> 'Survey Question',

   'Swedish Chef'
=> 'Swedish Chef',
# SQuaish Chef
   'System Level'
=> 'System Level',
# Sistema Level
   'Target Edit Map'
=> 'Target Edit Map',
# DestiNão Editarar Mapa/Sequëncia
   'TeX unconverted due to errors'
=> 'TeX unconverted due to errors',
# TeX unconverted Limite Para errous
   'TeX unconverted due to previous errors'
=> 'TeX unconverted due to previous errors',
# TeX unconverted Limite Para Anterior errous
   'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.'
=> 'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.',
# The &quot; Description&quot; is the Nome de the  them will be seen Por the Estudantes. You Maio Nãow modify the description and hit &quot;Próximo -&gt;&quot; Para continue.
   'The error reported was'
=> 'The error reported was',
# The errou Repouted was
   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.',
# The following enTentativas will be used Para identify the  accouding Para the naming scheme adopted Por your institution. Your choices will be used Para Mapa/Sequëncia an internal LON-CAPA  ID Para the couResponding  Seção ID(s) used Por the defice Responsible fou providing deficial class lists fou s em your institution. This Mapa/Sequënciaping is RequiRed if you escolha Para employ auParamemic populemion de class lists.
   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists.",
# The following settings control auParamemic memrícula.m.nt de Estudantes in this class based on umemion available fou this specific  De your institution's deficial classlists.
   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options',
# The question can Nãot be gotten couRect, the following Alternativas in the &lt;optionResponse&gt; have invalid couRect options
   'The requested file'
=> 'The requested file',
# The Requested Arquivo
   'The student must log out and log in again to see these changes.'
=> 'The student must log out and log in again to see these changes.',
# The Estudante must log out and efeTer o login Nãovamente Para see these Alterars.
   'There are currently no Error Messages for this resource.'
=> 'There are currently no Error Messages for this resource.',
# TheRe aRe Correntely Não Errou Messages fou this Recurso(s).
   'There are no Evaluation Comments on this resource.'
=> 'There are no Evaluation Comments on this resource.',
# TheRe aRe Não EValormion Comments on this Recurso(s).
   'There are no currently enrolled students in the course.'
=> 'There are no currently enrolled students in the course.',
# TheRe aRe Não Correntely memrículased Estudantes in the .
   'There are no currently enrolled students in the selected sections.'
=> 'There are no currently enrolled students in the selected sections.',
# TheRe aRe Não Correntely memrículased Estudantes in the SelecionaRed Seções.
   'There are no previously enrolled students in the course.'
=> 'There are no previously enrolled students in the course.',
# TheRe aRe Não Anteriorly memrículased Estudantes in the .
   'There are no previously enrolled students in the selected sections.'
=> 'There are no previously enrolled students in the selected sections.',
# TheRe aRe Não Anteriorly memrículased Estudantes in the SelecionaRed Seções.
   'There are no students in the course.'
=> 'There are no students in the course.',
# TheRe aRe Não Estudantes in the .
   'There are no students in the selected sections.'
=> 'There are no students in the selected sections.',
# TheRe aRe Não Estudantes in the SelecionaRed Seções.
   'There was an error determining the environment values for'
=> 'There was an error determining the environment values for',
# TheRe was an errou determining the environment Valors fou
   'This controls how receipt numbers are generated.'
=> 'This controls how receipt numbers are generated.',
# This controls how Receipt numbers aRe geneRemed.
   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'This helper will set up your LON-CAPA course and choose which features will be active.',
# This Ajudaer will set Cima your LON-CAPA  and escolha which feemuRes will be active.
   'To create a new'
=> 'To create a new',
# Para criar a new
   'Top Level Map'
=> 'Top Level Map',
# Parap Level Mapa/Sequëncia
   'Type Name Here'
=> 'Type Name Here',
# Tipo Nome HeRe
   'Type-in value'
=> 'Type-in value',
# Tipo-in Valor
   'UNDISPLAYABLE'
=> 'UNDISPLAYABLE',

   'Unable to enroll'
=> 'Unable to enroll',
# Unable Para memrículas
   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are',
# Unable Para Publica Arquivo, it contains dCimalicemed ID(s), ID(s) need Para be unique. The dCimalicemed ID(s) aRe
   'Unable to retrieve environment data for'
=> 'Unable to retrieve environment data for',
# Unable Para Restaurar environment dema fou
   'Unable to set default dates for course'
=> 'Unable to set default dates for course',
# Unable Para set padrão demes fou
   'Unavailable course'
=> 'Unavailable course',
# Unavailable
   'Unknown Action'
=> 'Unknown Action',
# UnkNãown Action
   'Unselect All Files'
=> 'Unselect All Files',
# UnSelecionar tudo Arquivos
   'Unselect All Published'
=> 'Unselect All Published',
# UnSelecionar tudo Publicado
   'Unselect All Resources'
=> 'Unselect All Resources',
# UnSelecionar tudo Recursos
   'Unselect for Section/Group'
=> 'Unselect for Section/Group',
# UnSelecionar fou Seção/GroCima
   'Upload file'
=> 'Upload file',
# CimaUtilização do Servidor Arquivo
   'VIEW'
=> 'VIEW',
# acessar
   'View the FAQ'
=> 'View the FAQ',
# acessar the FAQ
   'Visibly Separate Items on Pages'
=> 'Visibly Separate Items on Pages',
# Visibly SepaReme Items on páginas
   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'WARNING: The metadata table does not exist in the LON-CAPA database.',
# WARNING: The metadema table does Nãot exist in the LON-CAPA demabase.
   'Warning: change of MIME type!'
=> 'Warning: change of MIME type!',
# Warning: Alterar de MIME Tipo!
   'Warning: target file exists!'
=> 'Warning: target file exists!',
# Warning: DestiNão Arquivo exists!
   'Warning: target file exists, and has been published!'
=> 'Warning: target file exists, and has been published!',
# Warning: DestiNão Arquivo exists, and has been Publicado!
   'Weight (weight)'
=> 'Weight (weight)',

   'Welcome to Your New LON-CAPA Course'
=> 'Welcome to Your New LON-CAPA Course',
# Bem Vindo Para Your New LON-CAPA
   'What parameter do you want to set for the selected folder?'
=> 'What parameter do you want to set for the selected folder?',
# Whem parameter do you want Para set fou the SelecionaRed Pasta?
   'What parameter do you want to set for the selected problem?'
=> 'What parameter do you want to set for the selected problem?',
# Whem parameter do you want Para set fou the SelecionaRed problema?
   'What should the answer open date be set to?'
=> 'What should the answer open date be set to?',
# Whem should the Resposta Abrir deme be set Para?
   'What should the due date be set to?'
=> 'What should the due date be set to?',
# Whem should the Limite deme be set Para?
   'What weight should be set for all problems in the course?'
=> 'What weight should be set for all problems in the course?',
# Whem weight should be set fou tudo problemas in the ?
   'What weight should be set for the selected folder?'
=> 'What weight should be set for the selected folder?',
# Whem weight should be set fou the SelecionaRed Pasta?
   'What weight should be set for the selected problem?'
=> 'What weight should be set for the selected problem?',
# Whem weight should be set fou the SelecionaRed problema?
   'Width'
=> 'Width',

   'You are working with an unsaved version of your map.'
=> 'You are working with an unsaved version of your map.',
# You aRe wouking with an unSalvard Versão de your Mapa/Sequëncia.
   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.',
# You Alterard the Estudantes id but did Nãot disable the ID Alterar safeguard. The Estudantes id will Nãot be Alterard.
   'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.'
=> 'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.',
# Your  is Nãow set Cima. Please Selecionar the Finish  Initializemion butParan Para Re-intialize the  with your chosen settings. Remember them tudo de these settings can be Modificado in the parâmetros scReen, Por pushing the  Environment butParan.
   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.',
# Your Request Para Alterar the sua função umemion fou this Estudante was Refused. You do Nãot appear Para have sufficient authouity Para Alterar Estudante umemion.
   '[_1] (what you just saw on the screen)'
=> '[_1] (what you just saw on the screen)',
# [_1] (whem you just saw on the scReen)
   '[_1] Local Authentication with argument [_2]'
=> '[_1] Local Authentication with argument [_2]',
# [_1] Local AuEntãoticemion with argument [_2]
   '[_1] Records per Page'
=> '[_1] Records per Page',
# [_1] Recouds Por página
   '[_1] minutes'
=> '[_1] minutes',
# [_1] minuParas
   '[_1] minutes, [_2] seconds'
=> '[_1] minutes, [_2] seconds',
# [_1] minuParas, [_2] segundos
   '[_1] with value [_2]'
=> '[_1] with value [_2]',
# [_1] with Valor [_2]
   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',
# [_1]pRev[_2] &nbsp; [_3]ReUtilização do Servidor[_4] &nbsp; [_5]Próximo[_6]
   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next',
# [_1]pRev[_2] &nbsp; [_3]ReUtilização do Servidor[_4] &nbsp; Próximo
   '[_2] seconds'
=> '[_2] seconds',
# [_2] segundos
   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2'
=> 'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2',
# a comma sepaRemed list de  Seções crosslisted with the Corrente , with each entry including the institutional  Seção Nome folloQua Por a colon and Então the (optional) groCimaID Para be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2
   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2',
# a comma sepaRemed list de institutional Seção numbers, each sepaRemed Por a colon De the (optional) couResponding Seção/groCima ID Para be used in LON-CAPA e.g., 001:1,002:2
   'after selected'
=> 'after selected',
# after SelecionaRed
   'all resources in the course'
=> 'all resources in the course',
# tudo Recursos in the
   'all students in course'
=> 'all students in course',
# tudo Estudantes Não Curso
   'and'
=> 'and',

   'anno-'
=> 'anno-',
# anNão-
   'anonymous students'
=> 'anonymous students',
# anônimo Estudantes
   'answer date'
=> 'answer date',
# Resposta deme
   'backward'
=> 'backward',

   'between'
=> 'between',

   'bookmark'
=> 'bookmark',

   'button'
=> 'button',
# butParan
   'by'
=> 'by',
# Por
   'catalog'
=> 'catalog',
# cemalog
   'changes will not show until next login'
=> 'changes will not show until next login',
# Alterars will Nãot show until Próximo login
   'check all'
=> 'check all',
# check tudo
   'chmod error'
=> 'chmod error',
# chmod errou
   'click on the'
=> 'click on the',

   'co con-'
=> 'co con-',
# co construção
   'co res'
=> 'co res',

   'contacting [_1]'
=> 'contacting [_1]',
# Contatoando [_1]
   'copy Error'
=> 'copy Error',
# copy Errou
   'currently does not exist'
=> 'currently does not exist',
# Correntely does Nãot exist
   'custom'
=> 'custom',
# cusParam
   'custom distribution file'
=> 'custom distribution file',
# cusParam distribution Arquivo
   'domain'
=> 'domain',
# Domínio
   'due date'
=> 'due date',
# Limite deme
   'edit crs'
=> 'edit crs',
# Editarar crs
   'evaluate'
=> 'evaluate',
# eValorme
   'expired or revoked'
=> 'expired or revoked',
# expiRed ou Revoked
   'extension'
=> 'extension',

   'external'
=> 'external',

   'feedback'
=> 'feedback',

   'first name'
=> 'first name',
# first Nome
   'for'
=> 'for',
# fou
   'for <b>all resources in the course</b>'
=> 'for <b>all resources in the course</b>',
# fou <b>tudo Recursos in the </b>
   'for <b>all students in course</b>'
=> 'for <b>all students in course</b>',
# fou <b>tudo Estudantes Não Curso</b>
   'for [_1]'
=> 'for [_1]',
# fou [_1]
   'for section [_1]'
=> 'for section [_1]',
# fou Seção [_1]
   'for the map named [_1]'
=> 'for the map named [_1]',
# fou the Mapa/Sequëncia Nomed [_1]
   'for the resource named [_1]'
=> 'for the resource named [_1]',
# fou the Recurso(s) Nomed [_1]
   'for visible separation'
=> 'for visible separation',
# fou visible sepaRemion
   'forward'
=> 'forward',
# fouward
   'from'
=> 'from',
# De
   'from current subdirectory'
=> 'from current subdirectory',
# De Corrente subdiRecParauy
   'generation'
=> 'generation',
# geneRemion
   'have different numbers and answers'
=> 'have different numbers and answers',
# have diffeRent numbers and Respostas
   'helper'
=> 'helper',
# Ajudaer
   'in'
=> 'in',

   'in domain'
=> 'in domain',
# in Domínio
   'instructor'
=> 'instructor',
# inde Recursosou
   'internal'
=> 'internal',

   'is in this state by royal decree.'
=> 'is in this state by royal decree.',
# is in this steme Por royal decRee.
   'is ready for download'
=> 'is ready for download',
# is Ready fou downUtilização do Servidor
   'last name'
=> 'last name',
# last Nome
   'make these dates the default for future enrollment'
=> 'make these dates the default for future enrollment',
# make these demes the padrão fou futuRe memrícula.m.nt
   'middle name'
=> 'middle name',
# middle Nome
   'name'
=> 'name',
# Nome
   'no ending date'
=> 'no ending date',
# Não Fiming deme
   'number'
=> 'number',

   'number of tries'
=> 'number of tries',
# number de Tentativas
   'obsolete replacement'
=> 'obsolete replacement',
# obsolePara Replacement
   'only check if you know what you are doing'
=> 'only check if you know what you are doing',
# only check if you kNãow whem you aRe doing
   'only search domain'
=> 'only search domain',
# only pesquisar Domínio
   'opening date'
=> 'opening date',
# Abriring deme
   'optional'
=> 'optional',

   'or any other value'
=> 'or any other value',
# ou any other Valor
   'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> 'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',
# pRev &nbsp; [_3]ReUtilização do Servidor[_4] &nbsp; [_5]Próximo[_6]
   'private'
=> 'private',
# priveme
   'problem weight'
=> 'problem weight',
# problema weight
   'public'
=> 'public',

   'role,role,...'
=> 'role,role,...',
# sua função,sua função,...
   'section'
=> 'section',
# Seção
   'selected students'
=> 'selected students',
# SelecionaRed Estudantes
   'set'
=> 'set',

   'standard'
=> 'standard',

   'standard courses only'
=> 'standard courses only',
# standard s only
   'student'
=> 'student',
# Estudante
   'student name'
=> 'student name',
# Estudante Nome
   'tations'
=> 'tations',
# temions
   'template'
=> 'template',
# templeme
   'this'
=> 'this',

   'to'
=> 'to',
# Para
   'to [_1] ([_2])'
=> 'to [_1] ([_2])',
# Para [_1] ([_2])
   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231',
# Para interface with institutional dema, e.g., fs03glg231 fou Ftudo 2003 Geology 231
   'unable to enroll'
=> 'unable to enroll',
# unable Para memrículas
   'uncheck all'
=> 'uncheck all',
# uncheck tudo
   'use related words'
=> 'use related words',
# use Relemed wouds
   'username'
=> 'username',
# geRenciarNome
   'versus'
=> 'versus',

   'waiting on [_1]'
=> 'waiting on [_1]',
# aguardando [_1]
   'what you just saw on the screen'
=> 'what you just saw on the screen',
# whem you just saw on the scReen
   'with server'
=> 'with server',
# with Servidor
   'yes'
=> 'yes',
# Sim


   '# 16 Aug 14:45'
=> '# 16 Aug 14:45',
# #LON-CAPA6 AugLON-CAPA4:45
   'Enter my portfolio space'
=> 'Enter my portfolio space',
# fornecer minhas poutfolio publicado(s)
   'No syllabus information provided.'
=> 'No syllabus information provided.',
# Não PlaNão de Estudos infoumemion provided.
   'Post Discussion'
=> 'Post Discussion',

   'Sorry ...'
=> 'Sorry ...',
# Soury ...
   'This resource might be part of another course.'
=> 'This resource might be part of another course.',
# this Recurso(s) might be Parte de aNãother Curso.


   'Agree'
=> 'Agree',

   'Any comments? '
=> 'Any comments? ',

   'Copy this column'
=> 'Copy this column',
# Copy this Coluna
   'Disagree'
=> 'Disagree',

   'General Intro'
=> 'General Intro',
# geral intro
   'Greek Symbols'
=> 'Greek Symbols',

   'HTML character enties'
=> 'HTML character enties',

   'Highest Grade Level'
=> 'Highest Grade Level',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.',
# If you aRe acessaring this online, copy and paste the Texto De any de the right Colunas inPara your Texto aRea Para get the symbol on the left.
   'LON-CAPA Help'
=> 'LON-CAPA Help',
# LON-CAPA Ajuda
   'Landscape'
=> 'Landscape',

   'Launch navigation window'
=> 'Launch navigation window',
# Launch navigemion window
   'Lowest Grade Level'
=> 'Lowest Grade Level',

   'Mark all posts read'
=> 'Mark all posts read',
# Mark tudo posts Read
   'My question/comment/feedback:'
=> 'My question/comment/feedback:',
# minhas question/comment/feedback:
   'Not set -'
=> 'Not set -',
# Nãot Set -
   'Other Symbols'
=> 'Other Symbols',

   'Please check at least one of the following feedback types:'
=> 'Please check at least one of the following feedback types:',
# Please check em least one de the following feedback Tipos:
   'Please rank the following criteria:'
=> 'Please rank the following criteria:',

   'Portrait'
=> 'Portrait',
# Poutrait
   'Question about resource content'
=> 'Question about resource content',
# Question about Recurso(s) content
   'Question/Comment/Feedback about course policy'
=> 'Question/Comment/Feedback about course policy',
# Question/Comment/feedback about Curso policy
   'Select a Course to Enter'
=> 'Select a Course to Enter',
# Selecione um curso Para fornecer
   'Sending Messages'
=> 'Sending Messages',
# SFiming Messages
   'Show Me My First Homework Problem'
=> 'Show Me My First Homework Problem',
# Show Me minhas First Homewouk problema
   'Standards'
=> 'Standards',

   'Strongly Agree'
=> 'Strongly Agree',

   'Strongly Disagree'
=> 'Strongly Disagree',

   'Symbol'
=> 'Symbol',

   'The material appears to be correct '
=> 'The material appears to be correct ',
# The memerial appears Para be couRect
   'The material is helpful '
=> 'The material is helpful ',
# The memerial is Ajudaful
   'The material is presented in a clear way '
=> 'The material is presented in a clear way ',
# The memerial is pResented in a clear way
   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) '
=> 'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) ',
# The Recurso(s) is technictudoy couRect (Utilização do Servidors fast eNãough, does Nãot produce errous, links wouk, etc)


   'HTML character entities'
=> 'HTML character entities',

   'New parameters or stored values'
=> 'New parameters or stored values',
# New Parameters ou sParaued Valors
   'Obsolete parameters or stored values'
=> 'Obsolete parameters or stored values',
# obsolePara Parameters ou sParaued Valors
   'Store'
=> 'Store',
# SParaue
   'Store Catalog Information'
=> 'Store Catalog Information',
# SParaue cemaEntrarfoumemion
   'Store Changes'
=> 'Store Changes',
# SParaue Alterars
   'Store uploaded file as '
=> 'Store uploaded file as ',
# SParaue CarRegado Arquivo as
   'Your Version Settings have been Stored'
=> 'Your Version Settings have been Stored',
# Your Versão Settings have been SParaued




#
# >>>>>>>>>> IMPORTANT NOTE TO THE TRANSLATOR: <<<<<<<<<<
#
# The following explanation is valid for all entries marked with "Old key: ...".
# These entries have been automatically generated to save you some hours of translating.
# The _key_ is in all cases correct and up-to-date and must not be changed.
# The _value_ is very similar to what the actual translation needs to be.
# In most cases, it's just the case (lower/upper) or punctuation what needs to be changed.
# Please watch out for changes related to "Course" and "Community".
# Some values are untranslated. These entries have to be completely translated anyway.
# Recommendation:
# If you are done with the correction of the translation,
# you should remove the corresponding "#Old key: ..." row
#
# Example:
# #Old key: course documents
#    'Community Documents:'
# => 'documentos do curso',
#
# This would be changed to:
#    'Community Documents:'
# => 'Documentos do Comunidade:',
#
# Not sure, if "Comunidade" is an appropriate translation of "Community",
# but you should get the idea.



#Old key: Do NOT generate as standard course
   'Do NOT generate as standard community'
=> 'Do NOT generate as standard course',

#Old key: seconds
   'Seconds'
=> 'segundos',

#Old key: Select Style File
   'Select style file'
=> 'Select Style File',

#Old key: no ending date
   'No ending date'
=> 'no ending date',

#Old key: Retrieval of an old version will overwrite the file currently in construction space
   'Retrieval of an old version will overwrite the file currently in construction space.'
=> 'A restauração de uma versão antiga irá sobre-escrever o arquivo atual na área de construção',

#Old key: Last Name
   'Last name'
=> 'Último Nome',

#Old key: ALL
   'All:'
=> 'TUDO',

#Old key: Ending Date
   'Ending date'
=> 'Ending Date',

#Old key: part
   'Part:'
=> 'parte',

#Old key: Completed
   'Completed.'
=> 'Completed',

#Old key: Version changes since last Week
   'version changes since last week'
=> 'Alterações na versão desde a última semana',

#Old key: Set
   'Set?'
=> 'Set',

#Old key: internal
   'Internal'
=> 'internal',

#Old key: Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up
   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up.'
=> 'Bem vindo à Rede de Aprendizado<i>Online</i> Rede de trabalho com CAPA. Esta é a primeira versão do LON-CAPA traduzida para o português. Aguarde enquanto sua sessão é configurada',

#Old key: No
   'no'
=> 'Não',

#Old key: Version changes since last Month
   'version changes since last month'
=> 'Alterações na versão desde o mês passado',

#Old key: Go
   'go'
=> 'Go',

#Old key: Course Title
   'Community Title'
=> 'Course Title',

#Old key: Upload file
   'Upload File'
=> 'Upload file',

#Old key: No
   'No.'
=> 'Não',

#Old key: Close All Folders
   'Close all folders'
=> 'Fechar todas as Pastas',

#Old key: Change
   'Change?'
=> 'Alterar',

#Old key: Extent
   'extent'
=> 'Extensão',

#Old key: Main Course Documents
   'Main Community Documents'
=> 'Documentos Principais do Curso',

#Old key: File
   'File:'
=> 'Arquivo',

#Old key: You have provided an invalid ranking
   'You have provided an invalid ranking.'
=> 'Você forneceu uma ordem invalida',

#Old key: FAIL
   'Fail'
=> 'FALHA',

#Old key: Page
   'Page:'
=> 'Página',

#Old key: Privacy Note
   'Privacy Note:'
=> 'Nota Privada',

#Old key: Access Control
   'Access control'
=> 'Access Control',

#Old key: Highest Grade Level
   'Highest Grade Level:'
=> 'Highest Grade Level',

#Old key: roles
   'Roles'
=> 'usuários',

#Old key: Check Course Document Versions
   'Check Community Document Versions'
=> 'Checar Versões dos Documentos do Curso',

#Old key: Width
   'Width:'
=> 'Width',

#Old key: Modify student data
   'Modify Student Data'
=> 'Modificar dados de um estudante',

#Old key: Update Display
   'Update display'
=> 'Atualizar visor',

#Old key: No new filename specified.
   'No New filename specified'
=> 'No new filename specified.',

#Old key: Please select the authentication mechanism
   'Please select the Authentication mechanism'
=> 'Please select the authentication mechanism',

#Old key: Copyright/Distribution
   'Copyright/Distribution:'
=> 'Copyright/Distribuição',

#Old key: calendar
   'Calendar'
=> 'calendário',

#Old key: Create a New Course
   'Create a New Community'
=> 'Criando um Novo Curso <p> <font size="-1" style="color: rgb(255, 0, 0);"> <center> <b>NOTA AO ADMINISTRADOR</b> </center> <p>  A tradução p/ o português está em desenvolvimento. <br>  P/ aprimorar a tradução, edite <b> /home/httpd/lib/perl/Apache/localize/pt.pm </b> no servidor (precisa reiniciar apache p/ ativar mudanças). <br>  Veja mais detalhes sobre a tradução <a href=http://www.lon-capa.org/international.html> aqui. </a> <br> <b> SUAS CONTRIBUIÇÕES E MELHORIAS SERÃO BEM VINDAS <a href=http://mail.lon-capa.org/mailman/listinfo/lon-capa-dev> AQUI. </a></b> </font>',

#Old key: enroll
   'Enroll'
=> 'matrículas',

#Old key: never
   'Never'
=> 'nunca',

#Old key: Unavailable course
   'Unavailable community'
=> 'Unavailable course',

#Old key: Courses
   'Communities'
=> 'Courses',

#Old key: Communication
   'communication'
=> 'Communication',

#Old key: Course Description
   'Community Description'
=> 'Descrição do Curso',

#Old key: Folder
   'folder'
=> 'Pasta',

#Old key: Start Time
   'Start time'
=> 'Start Time',

#Old key: or
   'OR:'
=> 'ou',

#Old key: EMail Address
   'e-mail address'
=> 'Endereço de E-Mail',

#Old key: Print Table of Contents:
   'Print Table of Contents'
=> 'Imprimir Tabela de Conteúdos:',

#Old key: Course Title
   'Course Title:'
=> 'Course Title',

#Old key: percent
   'Percent'
=> '%',

#Old key: Course ID
   'course ID'
=> 'ID (identificação) do curso',

#Old key: Middle
   'middle'
=> 'Middle',

#Old key: standard courses only
   'standard communities only'
=> 'standard courses only',

#Old key: Course Content
   'Community Content'
=> 'Course Content',

#Old key: Set Version to be used in Course
   'Set Version to be used in Community'
=> 'Setar Versão a ser usada no Curso',

#Old key: re-initializing course
   're-initializing Course'
=> 'reiniciar o curso',

#Old key: and
   'And'
=> 'and',

#Old key: Course Search
   'Course search'
=> 'Course Search',

#Old key: Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.
   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an e-mail address.'
=> 'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.',

#Old key: To
   'To:'
=> 'Para',

#Old key: Default set of options to pass to tth/m when converting tex
   'Default set of options to pass to tth/m when converting TeX'
=> 'Default set of options to pass to tth/m when converting tex',

#Old key: Default XML Style File
   'Default XML style file'
=> 'Default XML Style File',

#Old key: Survey Question
   'Survey question'
=> 'Survey Question',

#Old key: Enroll One Student
   'Enroll one student'
=> 'Enroll One Student',

#Old key: Back to Directory
   'Back To Directory'
=> 'Voltar para o Diretório',

#Old key: optional
   'Optional'
=> 'optional',

#Old key: Mark Unread
   'Mark unread'
=> 'Marcado com Não Lido',

#Old key: Your Excel Spreadsheet
   'Your Excel spreadsheet.'
=> 'Sua Planilha do Excel',

#Old key: Import
   'Import?'
=> 'Importar',

#Old key: Print Index:
   'Print Index'
=> 'Imprimir Índice:',

#Old key: Import
   'IMPORT'
=> 'Importar',

#Old key: Show resource
   'Show Resource'
=> 'Mostrar recurso',

#Old key: Lowest Grade Level
   'Lowest Grade Level:'
=> 'Lowest Grade Level',

#Old key: catalog
   'Catalog:'
=> 'catalog',

#Old key: All homework is currently completed
   'All homework is currently completed.'
=> 'Toda lição de casa está completa',

#Old key: Degree of difficulty
   'Degree of Difficulty'
=> 'Grau de dificuldade',

#Old key: Upload bubblesheet data
   'Upload Bubblesheet Data'
=> 'Carregamento de informação bubblesheet',

#Old key: Delete
   'delete'
=> 'Excluir',

#Old key: End Time
   'End time'
=> 'End Time',

#Old key: Version changes since Yesterday
   'version changes since yesterday'
=> 'Alterações na versão desde ontem',

#Old key: End Time
   'End Time:'
=> 'End Time',

#Old key: Current
   'current'
=> 'Corrente',

#Old key: choose
   'Choose'
=> 'escolha',

#Old key: Description:
   'Description'
=> 'Description:',

#Old key: Delete an option
   'Delete an Option:'
=> 'Excluir uma opção',

#Old key: Completely new course
   'Completely new community'
=> 'Completely new course',

#Old key: Select Resources To Print
   'Select resources to print'
=> 'Select Resources To Print',

#Old key: Display
   'Display:'
=> 'Visor',

#Old key: Construction Space
   'Construction space'
=> 'Área de Construção',

#Old key: Your Excel Spreadsheet
   'Your Excel spreadsheet'
=> 'Sua Planilha do Excel',

#Old key: Clone an existing course
   'Clone an existing community'
=> 'Clone an existing course',

#Old key: Set Versions to be used in Course according to Selections below
   'Set Versions to be used in Community according to Selections below'
=> 'Setar Versões a serem usadas no Curso de acordo com as Seleções abaixo ',

#Old key: changes will not show until next login
   'Changes will not show until next login.'
=> 'changes will not show until next login',

#Old key: Start
   'Start:'
=> 'Início',

#Old key: Domain
   'Domain:'
=> 'Domínio',

#Old key: Select Course
   'Select Community'
=> 'Selecionar Curso',

#Old key: Last access
   'Last Access'
=> 'Último acesso',

#Old key: Total number of records found in file: [_1].
   'Total number of records found in file: [_1]'
=> 'Número total de registros encontrados no arquivo: [_1].',

#Old key: Previous
   'previous'
=> 'Anterior',

#Old key: or
   'Or'
=> 'ou',

#Old key: Since Start of Course
   'since start of course'
=> 'Desde o Início do Curso',

#Old key: URL
   'URL:'
=> 'URL',

#Old key: All Students
   'all students'
=> 'All Students',

#Old key: Course Documents
   'Community Documents'
=> 'Documentos do Curso',

#Old key: Add new option
   'Add new Option:'
=> 'Add new option',

#Old key: EMail Address
   'E-mail Address'
=> 'Endereço de E-Mail',

#Old key: Section
   'section:'
=> 'Seção',

#Old key: Incorrect
   'Incorrect:'
=> 'Incorreto.',

#Old key: Retrieve Old Version
   'Retrieve old version'
=> 'Retrieve Old Version',

#Old key: This controls how receipt numbers are generated.
   'This controls how receipt numbers are generated'
=> 'This controls how receipt numbers are generated.',

#Old key: most recent
   'Most Recent:'
=> 'mais recente',

#Old key: Go Back
   'Go back'
=> 'Voltar',

#Old key: Homework problem
   'Homework Problem'
=> 'Homework problem',

#Old key: View
   'View:'
=> 'Visualizar',

#Old key: Version used in Course
   'Version used in Community'
=> 'Versão usada no Curso',

#Old key: Anonymous contribution to course discussion of resource
   'Anonymous contribution to community discussion of resource'
=> 'Contribuição Anônima para discussão sobre o recurso',

#Old key: chart
   'Chart'
=> 'quadro',

#Old key: Select Action
   'Select action'
=> 'Select Action',

#Old key: Middle Name
   'Middle name'
=> 'Middle Name',

#Old key: Publish this Resource
   'Publish this resource'
=> 'Publish this Resource',

#Old key: EMail Address
   'E-mail address'
=> 'Endereço de E-Mail',

#Old key: Log in
   'Log In'
=> 'Entrar',

#Old key: Version changes since start of Course
   'version changes since start of course'
=> 'Alterações na versão desde o início do Curso',

#Old key: Courses
   'Courses:'
=> 'Courses',

#Old key: LaTeX mode:
   'LaTeX mode'
=> 'modo LaTeX:',

#Old key: library
   'Library'
=> 'catálogo',

#Old key: Modification may make assessment data inaccessible
   'Modification may make assessment data inaccessible!'
=> 'Modification may make assessment data inaccessible',

#Old key: minutes
   'Minutes'
=> 'minutos',

#Old key: manage
   'Manage'
=> 'gerenciar',

#Old key: Home Server
   'Home server'
=> 'Home Server',

#Old key: roles
   'Roles:'
=> 'usuários',

#Old key: Automated Enrollment Manager
   'Automated enrollment manager.'
=> 'Automated Enrollment Manager',

#Old key: Error
   'ERROR:'
=> 'Erro',

#Old key: chat
   'Chat'
=> 'chat',

#Old key: Save Changes
   'Save changes'
=> 'Salvar Alterações',

#Old key: Some items were not submitted
   'Some items were not submitted.'
=> 'Some items were not submitted',

#Old key: Starting Date
   'Starting date'
=> 'Starting Date',

#Old key: Yes
   'Yes!'
=> 'Sim',

#Old key: New User
   'New User?'
=> 'New User',

#Old key: role
   'Role:'
=> 'sua função',

#Old key: public
   'Public'
=> 'public',

#Old key: in Course
   'In Course:'
=> 'no Curso',

#Old key: helper
   'Helper'
=> 'helper',

#Old key: Enroll a single student
   'Enroll a Single Student'
=> 'Matricular um único estudante',

#Old key: Open Course
   'Open Community'
=> 'Open Course',

#Old key: private
   'Private'
=> 'private',

#Old key: End
   'End:'
=> 'Fim',

#Old key: Course Home Server
   'Community Home Server'
=> 'Course Home Server',

#Old key: Resource Hidden from Students (hiddenresource)
   'Resource hidden from students (hiddenresource)'
=> 'Resource Hidden from Students (hiddenresource)',

#Old key: Status
   'status'
=> 'Estado',

#Old key: number
   'Number'
=> 'number',

#Old key: directory
   'Directory'
=> 'diretório',

#Old key: Not Allowed
   'Not allowed'
=> 'Not Allowed',

#Old key: ALL
   'All'
=> 'TUDO',

#Old key: Sections
   'Sections:'
=> 'Seções',

#Old key: Status
   'Status:'
=> 'Estado',

#Old key: Course Content
   'Course content'
=> 'Course Content',

#Old key: Course Information
   'Community Information'
=> 'Course Information',

#Old key: problem
   'Problem'
=> 'problema',

#Old key: #YES
   '#yes'
=> '#SIM',

#Old key: Start Time
   'Start Time:'
=> 'Start Time',

#Old key: Question/Comment/Feedback about course policy
   'Question/Comment/Feedback about community policy'
=> 'Question/Comment/Feedback about course policy',

#Old key: Sections
   'sections'
=> 'Seções',

#Old key: Format:
   'Format'
=> 'Formato:',

#Old key: Construction Space
   'Construction Space:'
=> 'Área de Construção',

#Old key: There are currently no results
   'There are currently no results.'
=> 'Atualmente não existem resultados',

#Old key: Select
   'Select:'
=> 'Selecionar',

#Old key: Course ID/Number
   'Community ID/Number'
=> 'Course ID/Number',

#Old key: None Found
   'None found'
=> 'nenhum encontrado',

#Old key: Course Title
   'Course title'
=> 'Course Title',

#Old key: Open All Folders
   'Open all folders'
=> 'Abrir todas as Pastas',

#Old key: Value
   'Value:'
=> 'Valor',

#Old key: First Resource
   'First resource'
=> 'First Resource',

#Old key: Language
   'Language:'
=> 'Linguagem',

#Old key: USERS
   'users'
=> 'USUÁRIOS',

#Old key: Contribution to course discussion of resource
   'Contribution to community discussion of resource'
=> 'Contribuição à discussão do recurso',

#Old key: Note: for large courses, this operation may be time consuming
   'Note: For large courses, this operation may be time consuming.'
=> 'Nota: para cursos extensos, esta operação poderá demorar um pouco',

#Old key: Please pick a version to retrieve
   'Please pick a version to retrieve:'
=> 'Por favor escolha uma versão para restaurar',

#Old key: Error
   'Error:'
=> 'Erro',

#Old key: First Name
   'First name'
=> 'Primeiro Nome',

#Old key: Version changes since start of Course
   'Version changes since start of Community'
=> 'Alterações na versão desde o início do Curso',

#Old key: Metadata
   'metadata'
=> 'Meta-dados',

#Old key: Course ID
   'Community ID'
=> 'ID (identificação) do curso',

#Old key: User Role
   'User role'
=> 'Função de usuário',

#Old key: Title
   'Title:'
=> 'Título',

#Old key: USERS
   'Users'
=> 'USUÁRIOS',

#Old key: The optional email address field was not specified.
   'The optional e-mail address field was not specified.'
=> 'O campo E-mail (opcional) não foi especificado.',

#Old key: Delete
   'Delete?'
=> 'Excluir',

#Old key: Supplemental Course Documents
   'Supplemental Community Documents'
=> 'Documentos Suplementares do Curso',

#Old key: _AUTO
   'auto'
=> '1',

#Old key: undo
   'Undo'
=> 'desfazer',

#Old key: contents
   'Contents'
=> 'conteúdos',

#Old key: announce
   'Announce'
=> 'notícias',

#Old key: Image:
   'Image'
=> 'Imagem:',

#Old key: All Resources
   'all resources'
=> 'All Resources',

#Old key: Section
   'Section:'
=> 'Seção',

#Old key: Unit:
   'Unit'
=> 'Unidade:',

#Old key: Course
   'Community'
=> 'Curso',

#Old key: Location
   'Location:'
=> 'Location',

#Old key: Starting
   'starting'
=> 'Iniciando',

#Old key: course
   'community'
=> 'curso',

#Old key: Answer available
   'Answer Available'
=> 'Resposta disponível',

#Old key: Since Yesterday
   'since yesterday'
=> 'Desde Ontem',


#SYNC Fri Jun 25 17:54:07 2010
   ' Creation Settings'
=> ' Creation Settings',

   ' Display Request Queue'
=> ' Display Request Queue',

   ' The last submission was after the Due Date '
=> ' The last submission was after the Due Date ',

   ' and also members of group: "[_1]"'
=> ' and also members of group: "[_1]"',

   ' and also not in any group'
=> ' and also not in any group',

   ' and members of group: "[_1]"'
=> ' and members of group: "[_1]"',

   ' and not in any group'
=> ' and not in any group',

   ' at '
=> ' at ',

   ' for a single user?'
=> ' for a single user?',

   ' for multiple users?'
=> ' for multiple users?',

   ' in this Course'
=> ' in this Course',

   ' not allowed to participate in chat room.'
=> ' not allowed to participate in chat room.',

   ' to '
=> ' to ',

   '"[_1]" is not the name of a valid group in this [_2].'
=> '"[_1]" is not the name of a valid group in this [_2].',

   '"[_1]" set to "[_2]".'
=> '"[_1]" set to "[_2]".',

   '#Wrng'
=> '#Wrng',

   "'New'  critical message from "
=> "'New'  critical message from ",

   "'New'  message from "
=> "'New'  message from ",

   '(128 KB max size)'
=> '(128 KB max size)',

   '(Course Coordinators automatically have the right to clone their own courses.) Format: user:domain, where &quot;user&quot; and &quot;domain&quot; are the LON-CAPA username and domain of the user.Separate different users with a comma.Use *:domain to allow course to be cloned by any course owner in the specified domain.Use * to allow unrestricted cloning by all course owners in all domains.'
=> '(Course Coordinators automatically have the right to clone their own courses.) Format: user:domain, where &quot;user&quot; and &quot;domain&quot; are the LON-CAPA username and domain of the user.Separate different users with a comma.Use *:domain to allow course to be cloned by any course owner in the specified domain.Use * to allow unrestricted cloning by all course owners in all domains.',

   '(Currently: [_1])'
=> '(Currently: [_1])',

   '(Does not apply to member roles).'
=> '(Does not apply to member roles).',

   '(Does not apply to student roles).'
=> '(Does not apply to student roles).',

   '(Less ...)'
=> '(Less ...)',

   '(Message not fully displayed due to incorrect embedded TeX.)'
=> '(Message not fully displayed due to incorrect embedded TeX.)',

   '(Month - Day - Year)'
=> '(Month - Day - Year)',

   '(More ...)'
=> '(More ...)',

   '(Next and Previous (student) do not save the scores.)'
=> '(Next and Previous (student) do not save the scores.)',

   '(No subcategories)'
=> '(No subcategories)',

   '(Previous URL backed up)'
=> '(Previous URL backed up)',

   '(Problems with av. attempts &ge; [_1] or deg. difficulty &ge; [_2]) [_3] and total number of students with submissions &ge; [_4]'
=> '(Problems with av. attempts &ge; [_1] or deg. difficulty &ge; [_2]) [_3] and total number of students with submissions &ge; [_4]',

   "(You can only create new users in your current role's domain - [_1])"
=> "(You can only create new users in your current role's domain - [_1])",

   "(You can only define new users in the new course's domain - [_1])"
=> "(You can only define new users in the new course's domain - [_1])",

   '([_1] time zone)'
=> '([_1] time zone)',

   '(applies when current role is student)'
=> '(applies when current role is student)',

   '(blank for unlimited)'
=> '(blank for unlimited)',

   '(click for example)'
=> '(click for example)',

   '(default for [_1])'
=> '(default for [_1])',

   '(default)'
=> '(default)',

   '(e.g., MSU.EDU=msu.edu, MSUE.EDU=msue.msu.edu).'
=> '(e.g., MSU.EDU=msu.edu, MSUE.EDU=msue.msu.edu).',

   '(in [_1])'
=> '(in [_1])',

   '(leave blank to delete announcement)'
=> '(leave blank to delete announcement)',

   '(mark desired resources then click "next" button)'
=> '(mark desired resources then click "next" button)',

   '(mark them then click "next" button)'
=> '(mark them then click "next" button)',

   '(off)'
=> '(off)',

   '(on)'
=> '(on)',

   '(only do if you know what you are doing.)'
=> '(only do if you know what you are doing.)',

   '(overrides affiliation, if checked)'
=> '(overrides affiliation, if checked)',

   '(overrides affiliation, if set)'
=> '(overrides affiliation, if set)',

   '(overrides individual user preference)'
=> '(overrides individual user preference)',

   '(preferred)'
=> '(preferred)',

   '(problem weight)'
=> '(problem weight)',

   '(randomly ordered)'
=> '(randomly ordered)',

   '(randomly select [_1])'
=> '(randomly select [_1])',

   '(re-initialize community to access)'
=> '(re-initialize community to access)',

   '(re-initialize course to access)'
=> '(re-initialize course to access)',

   '(role-based)'
=> '(role-based)',

   '(shown if you post anonymously)'
=> '(shown if you post anonymously)',

   '(shown if you post non-anonymously)'
=> '(shown if you post non-anonymously)',

   '(shows course personnel)'
=> '(shows course personnel)',

   '(specific user(s))'
=> '(specific user(s))',

   '(will be assigned Coordinator role)'
=> '(will be assigned Coordinator role)',

   '(will be assigned Course Coordinator role)'
=> '(will be assigned Course Coordinator role)',

   ', default last access:'
=> ', default last access:',

   '- does not correspond to the name of an existing group'
=> '- does not correspond to the name of an existing group',

   '. . . for a particular group'
=> '. . . for a particular group',

   '100 Level'
=> '100 Level',

   '200 Level'
=> '200 Level',

   '300 Level'
=> '300 Level',

   '400 Level'
=> '400 Level',

   '<b>Current Resource: </b>[_1]'
=> '<b>Current Resource: </b>[_1]',

   '[_1]Message:[_2] No more students for this section or class.'
=> '[_1]Message:[_2] No more students for this section or class.',

   '<b>Note:</b> Problems graded correct by the computer are marked with a [_1] symbol.'
=> '<b>Note:</b> Problems graded correct by the computer are marked with a [_1] symbol.',

   '<b>Resource: </b> [_1]'
=> '<b>Resource: </b> [_1]',

   '<b>[_1]</b> enrolled'
=> '<b>[_1]</b> enrolled',

   '<br />Invalid map: <tt>[_1]</tt>'
=> '<br />Invalid map: <tt>[_1]</tt>',

   '<br />Map not loaded: The file <tt>[_1]</tt> does not exist.'
=> '<br />Map not loaded: The file <tt>[_1]</tt> does not exist.',

   '?[_98]'
=> '?[_98]',

   '?[_99]'
=> '?[_99]',

   'A Community title is required'
=> 'A Community title is required',

   'A LON-CAPA account already exists for username [_1] at this institution ([_2]).'
=> 'A LON-CAPA account already exists for username [_1] at this institution ([_2]).',

   'A LON-CAPA account for the institution: [_1] has been created [_2] from IP address: [_3]. If you did not perform this action or authorize it, please contact the [_4] ([_5]).'
=> 'A LON-CAPA account for the institution: [_1] has been created [_2] from IP address: [_3]. If you did not perform this action or authorize it, please contact the [_4] ([_5]).',

   'A LON-CAPA account has been created for username: [_1] in domain: [_2].'
=> 'A LON-CAPA account has been created for username: [_1] in domain: [_2].',

   'A LON-CAPA account may not be created with the username you use.'
=> 'A LON-CAPA account may not be created with the username you use.',

   'A MySQL error has occurred.'
=> 'A MySQL error has occurred.',

   'A coordinator role will be added with access to all sections'
=> 'A coordinator role will be added with access to all sections',

   'A course coordinator role will be added with access to all sections.'
=> 'A course coordinator role will be added with access to all sections.',

   'A course-wide error occurred.'
=> 'A course-wide error occurred.',

   'A draft copy has been saved.'
=> 'A draft copy has been saved.',

   'A file or directory by that name already exists.'
=> 'A file or directory by that name already exists.',

   "A group folder is added to the 'Community Groups' folder which contains folders for all groups in the community."
=> "A group folder is added to the 'Community Groups' folder which contains folders for all groups in the community.",

   "A group folder is added to the 'Course Groups' folder which contains folders for all groups in the course."
=> "A group folder is added to the 'Course Groups' folder which contains folders for all groups in the course.",

   'A listing of files viewable without log-in is available at: '
=> 'A listing of files viewable without log-in is available at: ',

   'A low percentage of matches results from one of the following:'
=> 'A low percentage of matches results from one of the following:',

   'A message has been sent to the e-mail address you provided.'
=> 'A message has been sent to the e-mail address you provided.',

   'A message has been sent to the instructor describing this failure.'
=> 'A message has been sent to the instructor describing this failure.',

   'A message will be sent to your LON-CAPA account when a domain coordinator takes action on your request.'
=> 'A message will be sent to your LON-CAPA account when a domain coordinator takes action on your request.',

   'A message will be sent to your LON-CAPA account when the course coordinator takes action on your request.'
=> 'A message will be sent to your LON-CAPA account when the course coordinator takes action on your request.',

   'A new community could not be cloned from the specified original - [_1] - because it is a course not a community.'
=> 'A new community could not be cloned from the specified original - [_1] - because it is a course not a community.',

   'A new community could not be cloned from the specified original - [_1] - because it is a non-existent community.'
=> 'A new community could not be cloned from the specified original - [_1] - because it is a non-existent community.',

   'A new course could not be cloned from the specified original - [_1] - because it is a non-existent course.'
=> 'A new course could not be cloned from the specified original - [_1] - because it is a non-existent course.',

   'A non-zero score can be assigned to the student during bubblesheet grading by selecting a bubble in at least one line.'
=> 'A non-zero score can be assigned to the student during bubblesheet grading by selecting a bubble in at least one line.',

   'A number equal or greater than 0 is expected. Entered value = '
=> 'A number equal or greater than 0 is expected. Entered value = ',

   'A problem occurred deleting access controls: [_1]'
=> 'A problem occurred deleting access controls: [_1]',

   'A problem occurred saving access control settings: [_1]'
=> 'A problem occurred saving access control settings: [_1]',

   'A problem occurred when attempting to create your new LON-CAPA account.'
=> 'A problem occurred when attempting to create your new LON-CAPA account.',

   'A problem occurred when attempting to reset the password for your account. Please contact the [_1] - ([_2]) for assistance.'
=> 'A problem occurred when attempting to reset the password for your account. Please contact the [_1] - ([_2]) for assistance.',

   'A problem occurred when attempting to reset the password for your account. Please try again from your [_1]home server[_2].'
=> 'A problem occurred when attempting to reset the password for your account. Please try again from your [_1]home server[_2].',

   'A problem occurred when creating folders for the new group [_1]:'
=> 'A problem occurred when creating folders for the new group [_1]:',

   'A reply will not be received by the recipient!'
=> 'A reply will not be received by the recipient!',

   'A request was submitted on [_1] for creation of a LON-CAPA account at the following institution:[_2].'
=> 'A request was submitted on [_1] for creation of a LON-CAPA account at the following institution:[_2].',

   'A request was submitted on [_1] for reset of the password for your LON-CAPA account.'
=> 'A request was submitted on [_1] for reset of the password for your LON-CAPA account.',

   'A role with no section will be added'
=> 'A role with no section will be added',

   'A self-enrollment request already exists for you for this course.'
=> 'A self-enrollment request already exists for you for this course.',

   'A subsequent step will also allow you to specify automatic adding/dropping of group members triggered by specified user role and section [_1]changes[_2] in the course.'
=> 'A subsequent step will also allow you to specify automatic adding/dropping of group members triggered by specified user role and section [_1]changes[_2] in the course.',

   'A support request has been sent to'
=> 'A support request has been sent to',

   'A total of [_1] Mb can be divided amongst all groups in the course, and [_2] Mb are currently unallocated.'
=> 'A total of [_1] Mb can be divided amongst all groups in the course, and [_2] Mb are currently unallocated.',

   'A total of [_1] group portfolio files are available.'
=> 'A total of [_1] group portfolio files are available.',

   'A total of [_1] portfolio files owned by [_2] are available'
=> 'A total of [_1] portfolio files owned by [_2] are available',

   'A user account will be created with information displayed in the table below, when you click the [_1]Create LON-CAPA account[_2] button.'
=> 'A user account will be created with information displayed in the table below, when you click the [_1]Create LON-CAPA account[_2] button.',

   'A valid e-mail address was not located in the LON-CAPA system for the username and domain you provided.'
=> 'A valid e-mail address was not located in the LON-CAPA system for the username and domain you provided.',

   'A2'
=> 'A2',

   'A3'
=> 'A3',

   'A4'
=> 'A4',

   'A5'
=> 'A5',

   'A6'
=> 'A6',

   'About LON-CAPA'
=> 'About LON-CAPA',

   'Accept?'
=> 'Accept?',

   'Accepting changes'
=> 'Accepting changes',

   'Access'
=> 'Access',

   'Access  : '
=> 'Access  : ',

   'Access Denied ([_1])'
=> 'Access Denied ([_1])',

   'Access Ends'
=> 'Access Ends',

   'Access Starts'
=> 'Access Starts',

   'Access Status'
=> 'Access Status',

   'Access controls also deleted for the file.'
=> 'Access controls also deleted for the file.',

   'Access controls updated to reflect the name change.'
=> 'Access controls updated to reflect the name change.',

   'Access dates for community members'
=> 'Access dates for community members',

   'Access dates for students'
=> 'Access dates for students',

   'Access dates to apply for selected users'
=> 'Access dates to apply for selected users',

   'Access requires proctor validation.'
=> 'Access requires proctor validation.',

   'Access starts immediately'
=> 'Access starts immediately',

   'Access starts: '
=> 'Access starts: ',

   'Access status'
=> 'Access status',

   'Access status:'
=> 'Access status:',

   "Access to What's New Page"
=> "Access to What's New Page",

   'Access to other pages will be prevented until you have moved all critical messages to your inbox.'
=> 'Access to other pages will be prevented until you have moved all critical messages to your inbox.',

   'Access to other pages will be prevented until you have moved the message to your inbox.'
=> 'Access to other pages will be prevented until you have moved the message to your inbox.',

   'Access to server status pages'
=> 'Access to server status pages',

   'Access to this file by others can be set to be one or more of the following types: public, passphrase-protected or conditional.'
=> 'Access to this file by others can be set to be one or more of the following types: public, passphrase-protected or conditional.',

   'Access types'
=> 'Access types',

   'Access will be set to continue indefinitely'
=> 'Access will be set to continue indefinitely',

   'Access will be set to start immediately'
=> 'Access will be set to start immediately',

   'Accessibility Options'
=> 'Accessibility Options',

   'Account creation'
=> 'Account creation',

   'Account creation failed for username: [_1] in domain: [_2].'
=> 'Account creation failed for username: [_1] in domain: [_2].',

   'Account creation unavailable'
=> 'Account creation unavailable',

   'Action'
=> 'Action',

   'Action  : '
=> 'Action  : ',

   'Action disallowed'
=> 'Action disallowed',

   'Action to take for selected users'
=> 'Action to take for selected users',

   'Action?'
=> 'Action?',

   'Actions available after searching for a community:'
=> 'Actions available after searching for a community:',

   'Actions available after searching for a course:'
=> 'Actions available after searching for a course:',

   'Actions for current directory'
=> 'Actions for current directory',

   "Activated role of '[_1]' in [_2] for [_3]"
=> "Activated role of '[_1]' in [_2] for [_3]",

   'Activated role(s) for [quant,_1,user,users,no users].'
=> 'Activated role(s) for [quant,_1,user,users,no users].',

   'Activation of self-enrollment was selected for the following domain(s)'
=> 'Activation of self-enrollment was selected for the following domain(s)',

   'Active'
=> 'Active',

   'Active Link Color'
=> 'Active Link Color',

   'Active Member'
=> 'Active Member',

   'Active access status.'
=> 'Active access status.',

   'Active at next login.'
=> 'Active at next login.',

   'Active link'
=> 'Active link',

   'Active?'
=> 'Active?',

   'Activity data compiled up to [_1]'
=> 'Activity data compiled up to [_1]',

   'Add Members'
=> 'Add Members',

   'Add Records'
=> 'Add Records',

   'Add Selection for...'
=> 'Add Selection for...',

   'Add Selection for:'
=> 'Add Selection for:',

   'Add a Metadata Field'
=> 'Add a Metadata Field',

   'Add a course role'
=> 'Add a course role',

   'Add a course/community role'
=> 'Add a course/community role',

   'Add a domain role'
=> 'Add a domain role',

   'Add a new attachment to this post.'
=> 'Add a new attachment to this post.',

   'Add a roles-based condition'
=> 'Add a roles-based condition',

   'Add a user to the domain, and/or a course or community in the domain.'
=> 'Add a user to the domain, and/or a course or community in the domain.',

   'Add a user with a certain role to this course.'
=> 'Add a user with a certain role to this course.',

   'Add a user with a co- or assistant author role.'
=> 'Add a user with a co- or assistant author role.',

   'Add a user with the role of student to this course'
=> 'Add a user with the role of student to this course',

   'Add a user with the role student to this course.'
=> 'Add a user with the role student to this course.',

   'Add another'
=> 'Add another',

   'Add block'
=> 'Add block',

   'Add category'
=> 'Add category',

   'Add category:'
=> 'Add category:',

   'Add conditional access'
=> 'Add conditional access',

   'Add enrollment from additional sections.'
=> 'Add enrollment from additional sections.',

   'Add member(s) to the group'
=> 'Add member(s) to the group',

   'Add members'
=> 'Add members',

   'Add new [_1] condition(s)?'
=> 'Add new [_1] condition(s)?',

   'Add new [_1]-based[_2] access control for portfolio file: [_3]'
=> 'Add new [_1]-based[_2] access control for portfolio file: [_3]',

   'Add new address'
=> 'Add new address',

   'Add new communication blocking periods'
=> 'Add new communication blocking periods',

   'Add or Edit Blog Entries'
=> 'Add or Edit Blog Entries',

   'Add registered students automatically'
=> 'Add registered students automatically',

   'Add subcategory:'
=> 'Add subcategory:',

   'Add to Course Announcements'
=> 'Add to Course Announcements',

   'Add to classlist'
=> 'Add to classlist',

   'Add to classlist:'
=> 'Add to classlist:',

   'Add to my public community blog'
=> 'Add to my public community blog',

   'Add to my public course blog'
=> 'Add to my public course blog',

   'Add/Modify a Co-author'
=> 'Add/Modify a Co-author',

   'Add/Modify a Course User'
=> 'Add/Modify a Course User',

   'Add/Modify a Student'
=> 'Add/Modify a Student',

   'Add/Modify a User'
=> 'Add/Modify a User',

   'Add/modify a single user'
=> 'Add/modify a single user',

   'Add?'
=> 'Add?',

   'Added to my community blog'
=> 'Added to my community blog',

   'Added to my course blog'
=> 'Added to my course blog',

   'Adding/Modifying Users'
=> 'Adding/Modifying Users',

   'Additional Display Specification (optional)'
=> 'Additional Display Specification (optional)',

   'Additional Personnel'
=> 'Additional Personnel',

   'Additional Tools'
=> 'Additional Tools',

   'Additional domain:'
=> 'Additional domain:',

   'Additional information'
=> 'Additional information',

   'Additional language:'
=> 'Additional language:',

   'Additional options'
=> 'Additional options',

   'Additional privileges'
=> 'Additional privileges',

   'Additional recipient:'
=> 'Additional recipient:',

   'Additions Complete'
=> 'Additions Complete',

   'Additions based on classlist changes:'
=> 'Additions based on classlist changes:',

   'Admin E-mail address'
=> 'Admin E-mail address',

   'Administration'
=> 'Administration',

   'Administrator Settings'
=> 'Administrator Settings',

   'Advanced Portfolio Search'
=> 'Advanced Portfolio Search',

   'Advanced Role'
=> 'Advanced Role',

   'Advanced printing options (with answers, discussions, all foils, ...)'
=> 'Advanced printing options (with answers, discussions, all foils, ...)',

   'Affected User'
=> 'Affected User',

   'Affiliation'
=> 'Affiliation',

   'Affliations'
=> 'Affliations',

   'After'
=> 'After',

   'After course enrollment end!'
=> 'After course enrollment end!',

   'After:'
=> 'After:',

   'Algebraic Response Problems'
=> 'Algebraic Response Problems',

   'Alignment:'
=> 'Alignment:',

   'All Course Personnel'
=> 'All Course Personnel',

   'All Messages'
=> 'All Messages',

   'All Parts'
=> 'All Parts',

   'All [_1] students in the course[_2] are listed in the roster.'
=> 'All [_1] students in the course[_2] are listed in the roster.',

   'All [_1] students in the course[_2] have opted to be listed in the roster.'
=> 'All [_1] students in the course[_2] have opted to be listed in the roster.',

   'All [_1] students in the section[_2] are listed in the roster.'
=> 'All [_1] students in the section[_2] are listed in the roster.',

   'All [_1] students in the section[_2] have opted to be listed in the roster.'
=> 'All [_1] students in the section[_2] have opted to be listed in the roster.',

   'All [_1] students without a section[_2] are listed in the roster.'
=> 'All [_1] students without a section[_2] are listed in the roster.',

   'All [_1] students without a section[_2] have opted to be listed in the roster.'
=> 'All [_1] students without a section[_2] have opted to be listed in the roster.',

   'All assignments in a single PDF file'
=> 'All assignments in a single PDF file',

   'All co-authors'
=> 'All co-authors',

   'All co-authors in domain with [_1] roles'
=> 'All co-authors in domain with [_1] roles',

   'All co-authors with [_1] roles'
=> 'All co-authors with [_1] roles',

   'All communities'
=> 'All communities',

   'All communities in domain'
=> 'All communities in domain',

   'All courses'
=> 'All courses',

   'All courses in domain'
=> 'All courses in domain',

   'All documents out of a published map into this folder'
=> 'All documents out of a published map into this folder',

   'All file types'
=> 'All file types',

   'All group members will receive the same privileges for any tool assigned to them, including the default set of optional privileges.'
=> 'All group members will receive the same privileges for any tool assigned to them, including the default set of optional privileges.',

   'All group membership is terminated.'
=> 'All group membership is terminated.',

   'All groups.'
=> 'All groups.',

   'All homework assignments have been completed.'
=> 'All homework assignments have been completed.',

   'All messages:'
=> 'All messages:',

   'All new group members will receive the same privileges.'
=> 'All new group members will receive the same privileges.',

   'All posts'
=> 'All posts',

   'All roles'
=> 'All roles',

   'All sections.'
=> 'All sections.',

   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click &quot;Next&quot;.'
=> 'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click &quot;Next&quot;.',

   'All types'
=> 'All types',

   'All users'
=> 'All users',

   'All users in community'
=> 'All users in community',

   'All users in community with [_1] roles'
=> 'All users in community with [_1] roles',

   'All users in course'
=> 'All users in course',

   'All users in course with [_1] roles'
=> 'All users in course with [_1] roles',

   'All users in domain'
=> 'All users in domain',

   'All users in domain with [_1] roles'
=> 'All users in domain with [_1] roles',

   'All users with co-author roles in domain'
=> 'All users with co-author roles in domain',

   'Allow limited HTML in discussion'
=> 'Allow limited HTML in discussion',

   'Allow replies'
=> 'Allow replies',

   'Allow replies:'
=> 'Allow replies:',

   'Allow students to view classlist.'
=> 'Allow students to view classlist.',

   'Allow users with specified roles to edit/delete their own discussion posts'
=> 'Allow users with specified roles to edit/delete their own discussion posts',

   'Allow/disallow name updates'
=> 'Allow/disallow name updates',

   'Allowable role(s) is/are: [_1].'
=> 'Allowable role(s) is/are: [_1].',

   'Allowed File Extensions for Uploaded Files'
=> 'Allowed File Extensions for Uploaded Files',

   'Allowed course/community affiliations'
=> 'Allowed course/community affiliations',

   'Allowed filetypes: [_1]'
=> 'Allowed filetypes: [_1]',

   'Allowing others to retrieve file: [_1]'
=> 'Allowing others to retrieve file: [_1]',

   'Already in this course:<br />[_1] in folder/map [_2].<br />'
=> 'Already in this course:<br />[_1] in folder/map [_2].<br />',

   'Already logged in'
=> 'Already logged in',

   'Alternatively access can be granted to people with specific LON-CAPA usernames and domains.'
=> 'Alternatively access can be granted to people with specific LON-CAPA usernames and domains.',

   "Alternatively, the 'Review bubblesheet data' utility (see grading menu) can be used for all students after grading is complete."
=> "Alternatively, the 'Review bubblesheet data' utility (see grading menu) can be used for all students after grading is complete.",

   'Although a deleted group is no longer accessible, the group name used for the group will be reserved, and will not be available for assignment to a new group in the same community in the future.'
=> 'Although a deleted group is no longer accessible, the group name used for the group will be reserved, and will not be available for assignment to a new group in the same community in the future.',

   'Although a deleted group is no longer accessible, the group name used for the group will be reserved, and will not be available for assignment to a new group in the same course in the future.'
=> 'Although a deleted group is no longer accessible, the group name used for the group will be reserved, and will not be available for assignment to a new group in the same course in the future.',

   'Although almost all community settings can be modified by a Coordinator, the following may only be set or modified by a Domain Coordinator:'
=> 'Although almost all community settings can be modified by a Coordinator, the following may only be set or modified by a Domain Coordinator:',

   'Although almost all course settings can be modified by a Course Coordinator, the following may only be set or modified by a Domain Coordinator:'
=> 'Although almost all course settings can be modified by a Course Coordinator, the following may only be set or modified by a Domain Coordinator:',

   'Although almost all course settings can be modified by a [_1], a number of settings exist which only a [_2] may change:'
=> 'Although almost all course settings can be modified by a [_1], a number of settings exist which only a [_2] may change:',

   'Although more than one section was indicated, a role was only added for the first section - [_1], as each community member may only be in one section at a time.'
=> 'Although more than one section was indicated, a role was only added for the first section - [_1], as each community member may only be in one section at a time.',

   'Although more than one section was indicated, a role was only added for the first section - [_1], as each student may only be in one section of a course at a time.'
=> 'Although more than one section was indicated, a role was only added for the first section - [_1], as each student may only be in one section of a course at a time.',

   'Although self-enrollment will become available starting [_1], you are ineligible for enrollment.'
=> 'Although self-enrollment will become available starting [_1], you are ineligible for enrollment.',

   "Although the group was deleted, an error occurred when removing the group's folder from the 'Community Groups' folder: [_1]"
=> "Although the group was deleted, an error occurred when removing the group's folder from the 'Community Groups' folder: [_1]",

   "Although the group was deleted, an error occurred when removing the group's folder from the 'Course Groups' folder: [_1]"
=> "Although the group was deleted, an error occurred when removing the group's folder from the 'Course Groups' folder: [_1]",

   "Although the group was re-enabled, an error occurred when adding the group's folder to the 'Community Groups' folder: [_1]"
=> "Although the group was re-enabled, an error occurred when adding the group's folder to the 'Community Groups' folder: [_1]",

   "Although the group was re-enabled, an error occurred when adding the group's folder to the 'Course Groups' folder: [_1]"
=> "Although the group was re-enabled, an error occurred when adding the group's folder to the 'Course Groups' folder: [_1]",

   'Although this particular question type requires handgrading, the instructions for this question in the exam directed students to leave [quant,_1,line] blank on their bubblesheets.'
=> 'Although this particular question type requires handgrading, the instructions for this question in the exam directed students to leave [quant,_1,line] blank on their bubblesheets.',

   'Although your current role has privileges to add students to section "[_1]", you do not have privileges to modify existing enrollments in other sections.'
=> 'Although your current role has privileges to add students to section "[_1]", you do not have privileges to modify existing enrollments in other sections.',

   'Although your current role has privileges to view any existing groups in this course, you do not have privileges to create new groups.'
=> 'Although your current role has privileges to view any existing groups in this course, you do not have privileges to create new groups.',

   'Although your current role has privileges to view any existing groups in this course, you do not have privilegesto create new groups.'
=> 'Although your current role has privileges to view any existing groups in this course, you do not have privilegesto create new groups.',

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account at this institution, and you are not permitted to create one."
=> "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account at this institution, and you are not permitted to create one.",

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account in this domain."
=> "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account in this domain.",

   'Although your username and password were authenticated, you do not currently have a LON-CAPA account at this institution.'
=> 'Although your username and password were authenticated, you do not currently have a LON-CAPA account at this institution.',

   'Although your username and password were authenticated, you do not currently have a LON-CAPA account in this domain, and you are not permitted to create one.'
=> 'Although your username and password were authenticated, you do not currently have a LON-CAPA account in this domain, and you are not permitted to create one.',

   'An RSS Feed provided by the LON-CAPA Learning Content Management System'
=> 'An RSS Feed provided by the LON-CAPA Learning Content Management System',

   'An e-mail address must have previously been associated with your LON-CAPA username.'
=> 'An e-mail address must have previously been associated with your LON-CAPA username.',

   'An e-mail confirming creation of your new LON-CAPA account has been sent to [_1].'
=> 'An e-mail confirming creation of your new LON-CAPA account has been sent to [_1].',

   'An e-mail confirming setting of the password for your LON-CAPA account has been sent to [_1].'
=> 'An e-mail confirming setting of the password for your LON-CAPA account has been sent to [_1].',

   'An e-mail sent to the e-mail address associated with your LON-CAPA account includes the web address for the link you should use to complete the reset process.<br /><br />The link included in the message will be valid for the next <b>two</b> hours.'
=> 'An e-mail sent to the e-mail address associated with your LON-CAPA account includes the web address for the link you should use to complete the reset process.<br /><br />The link included in the message will be valid for the next <b>two</b> hours.',

   'An e-mail will also be sent to: [_1] when this occurs.'
=> 'An e-mail will also be sent to: [_1] when this occurs.',

   'An error occurred ([_1]) while trying to create a new directory [_2].'
=> 'An error occurred ([_1]) while trying to create a new directory [_2].',

   'An error occurred ([_1]) while trying to delete [_2].'
=> 'An error occurred ([_1]) while trying to delete [_2].',

   'An error occurred ([_1]) while trying to delete access control records for the old name.'
=> 'An error occurred ([_1]) while trying to delete access control records for the old name.',

   'An error occurred ([_1]) while trying to delete access controls for the file.'
=> 'An error occurred ([_1]) while trying to delete access controls for the file.',

   'An error occurred ([_1]) while trying to rename [_2] to [_3]'
=> 'An error occurred ([_1]) while trying to rename [_2] to [_3]',

   'An error occurred ([_1]) while trying to upload [_2] for embedded element [_3].'
=> 'An error occurred ([_1]) while trying to upload [_2] for embedded element [_3].',

   'An error occurred ([_1]) while trying to upload [_2].'
=> 'An error occurred ([_1]) while trying to upload [_2].',

   'An error occurred (dir) ([_1]) while trying to delete [_2].'
=> 'An error occurred (dir) ([_1]) while trying to delete [_2].',

   'An error occurred creating a token required for the account creation process.'
=> 'An error occurred creating a token required for the account creation process.',

   'An error occurred generating the validation code[_1] required for an e-mail address to be used as username.'
=> 'An error occurred generating the validation code[_1] required for an e-mail address to be used as username.',

   'An error occurred opening the export file for posting'
=> 'An error occurred opening the export file for posting',

   'An error occurred opening the manifest file.'
=> 'An error occurred opening the manifest file.',

   'An error occurred retrieving information about resources in the course.'
=> 'An error occurred retrieving information about resources in the course.',

   'An error occurred retrieving the link to this problem.'
=> 'An error occurred retrieving the link to this problem.',

   'An error occurred saving a personal record of your request.'
=> 'An error occurred saving a personal record of your request.',

   'An error occurred saving a record of the details of your request: [_1].'
=> 'An error occurred saving a record of the details of your request: [_1].',

   'An error occurred saving a record of the status of your request: [_1].'
=> 'An error occurred saving a record of the status of your request: [_1].',

   "An error occurred saving the modified course request for [_1] submitted by [_2] in the domain's courserequestqueue.db."
=> "An error occurred saving the modified course request for [_1] submitted by [_2] in the domain's courserequestqueue.db.",

   'An error occurred saving your request in the pending requests queue.'
=> 'An error occurred saving your request in the pending requests queue.',

   'An error occurred storing the quota for group portfolio files: '
=> 'An error occurred storing the quota for group portfolio files: ',

   'An error occurred validating your request with institutional data sources: [_1].'
=> 'An error occurred validating your request with institutional data sources: [_1].',

   'An error occurred when [_1] the group. Please try again.'
=> 'An error occurred when [_1] the group. Please try again.',

   'An error occurred when processing your community request.'
=> 'An error occurred when processing your community request.',

   'An error occurred when processing your course request.'
=> 'An error occurred when processing your course request.',

   'An error occurred when reading contents of parent folder to group:'
=> 'An error occurred when reading contents of parent folder to group:',

   'An error occurred when recording your request.'
=> 'An error occurred when recording your request.',

   'An error occurred when removing community settings which are no longer in use.'
=> 'An error occurred when removing community settings which are no longer in use.',

   'An error occurred when removing course settings which are no longer in use.'
=> 'An error occurred when removing course settings which are no longer in use.',

   'An error occurred when removing the request for [_1] submitted by [_2] from the pending queue.'
=> 'An error occurred when removing the request for [_1] submitted by [_2] from the pending queue.',

   'An error occurred when saving changes to community settings, which remain unchanged.'
=> 'An error occurred when saving changes to community settings, which remain unchanged.',

   'An error occurred when saving changes to course settings, which remain unchanged.'
=> 'An error occurred when saving changes to course settings, which remain unchanged.',

   'An error occurred when saving changes to self-enrollment settings in this course.'
=> 'An error occurred when saving changes to self-enrollment settings in this course.',

   'An error occurred when saving updated parent folder to group:'
=> 'An error occurred when saving updated parent folder to group:',

   'An error occurred when sending a message to the e-mail address you provided.'
=> 'An error occurred when sending a message to the e-mail address you provided.',

   'An error occurred when sending e-mail to [_1] confirming creation of your LON-CAPA account.'
=> 'An error occurred when sending e-mail to [_1] confirming creation of your LON-CAPA account.',

   'An error occurred when storing a token'
=> 'An error occurred when storing a token',

   'An error occurred when updating the pending requests queue: [_1]'
=> 'An error occurred when updating the pending requests queue: [_1]',

   "An error occurred when updating the status of this request in the requestor's records: [_1]"
=> "An error occurred when updating the status of this request in the requestor's records: [_1]",

   'An error occurred while processing this resource. The author has been notified.'
=> 'An error occurred while processing this resource. The author has been notified.',

   'An error occurred while processing this resource. The course personnel ([_1]) and the author have been notified.'
=> 'An error occurred while processing this resource. The course personnel ([_1]) and the author have been notified.',

   'An error occurred while processing this resource. The instructor has been notified.'
=> 'An error occurred while processing this resource. The instructor has been notified.',

   'An error occurred while saving.'
=> 'An error occurred while saving.',

   'An error occurred while setting parameters for Discussion Boards folder: [_1]'
=> 'An error occurred while setting parameters for Discussion Boards folder: [_1]',

   'An error occurred while updating the group membership list:'
=> 'An error occurred while updating the group membership list:',

   'An uploaded screenshot file [_1] ([_2] bytes) was included in the request sent by [_3].'
=> 'An uploaded screenshot file [_1] ([_2] bytes) was included in the request sent by [_3].',

   'Analysis of [_1] is not supported.'
=> 'Analysis of [_1] is not supported.',

   'Analyze Over [_1] [_2]'
=> 'Analyze Over [_1] [_2]',

   'Annotations'
=> 'Annotations',

   'Annotator'
=> 'Annotator',

   'Announcements'
=> 'Announcements',

   'Announcements and my calendar'
=> 'Announcements and my calendar',

   'Anonymous Survey'
=> 'Anonymous Survey',

   'Anonymous Survey Question'
=> 'Anonymous Survey Question',

   'Anonymous Survey Question (with credit)'
=> 'Anonymous Survey Question (with credit)',

   'Another custom field/value pair?'
=> 'Another custom field/value pair?',

   'Answer [_1]'
=> 'Answer [_1]',

   'Answer for Part: [_1]'
=> 'Answer for Part: [_1]',

   'Answer open'
=> 'Answer open',

   'Any'
=> 'Any',

   'Any Access Status'
=> 'Any Access Status',

   'Any Membership status'
=> 'Any Membership status',

   'Any Users'
=> 'Any Users',

   'Any access status.'
=> 'Any access status.',

   'Any course/community requests which are successfully validated will be created immediately.'
=> 'Any course/community requests which are successfully validated will be created immediately.',

   'Any currently logged in course users affected by the changes you made to group membership or privileges for the [_1] group will need to log out and log back in for their LON-CAPA sessions to reflect these changes.'
=> 'Any currently logged in course users affected by the changes you made to group membership or privileges for the [_1] group will need to log out and log back in for their LON-CAPA sessions to reflect these changes.',

   'Any domain'
=> 'Any domain',

   'Any new text to display before the text of the original messages:'
=> 'Any new text to display before the text of the original messages:',

   'Any role'
=> 'Any role',

   'Any status'
=> 'Any status',

   'Any user in additional domain:'
=> 'Any user in additional domain:',

   'Any user in any domain:'
=> 'Any user in any domain:',

   'Any user in domain:'
=> 'Any user in domain:',

   'Any user in other domain:'
=> 'Any user in other domain:',

   'Any user in specific domain:'
=> 'Any user in specific domain:',

   'Any users'
=> 'Any users',

   'Apache Server Status'
=> 'Apache Server Status',

   'Apache Status Page'
=> 'Apache Status Page',

   'Append listing of contents of top level of package to contents list for the current folder.'
=> 'Append listing of contents of top level of package to contents list for the current folder.',

   'Apply style file: '
=> 'Apply style file: ',

   'Approval by Dom. Coord.'
=> 'Approval by Dom. Coord.',

   'Approve'
=> 'Approve',

   'Approve or reject enrollment requests.'
=> 'Approve or reject enrollment requests.',

   'Approve or reject requests'
=> 'Approve or reject requests',

   'Approved enrollments:'
=> 'Approved enrollments:',

   'Archive:'
=> 'Archive:',

   'Archived Message'
=> 'Archived Message',

   'Are you sure you want to cancel this request?\n'
=> 'Are you sure you want to cancel this request?\n',

   'Are you sure you want to cancel this request?\nYour request will be removed.'
=> 'Are you sure you want to cancel this request?\nYour request will be removed.',

   'Are you sure you want to delete this post?'
=> 'Are you sure you want to delete this post?',

   'As Course Coordinator, use [_1]Main Menu -> Manage Course Users -> "Enrollment Requests"[_1] to display a list of pending enrollment requests which you can either approve or reject.'
=> 'As Course Coordinator, use [_1]Main Menu -> Manage Course Users -> "Enrollment Requests"[_1] to display a list of pending enrollment requests which you can either approve or reject.',

   'As no group members are being added, there are no specific user privileges to set.'
=> 'As no group members are being added, there are no specific user privileges to set.',

   'As no group tools will be made available to users, there are no specific user privileges to set.'
=> 'As no group tools will be made available to users, there are no specific user privileges to set.',

   'As no institutional course sections are currently associated with this course, your registration status is undetermined.'
=> 'As no institutional course sections are currently associated with this course, your registration status is undetermined.',

   'As the current submission is for an anonymous survey, no other details are available.'
=> 'As the current submission is for an anonymous survey, no other details are available.',

   'As the e-mail address provided for this LON-CAPA server ([_1]) does not appear to be a valid e-mail address, your support request has <b>not</b> been sent to the LON-CAPA support staff or administrator at your institution.'
=> 'As the e-mail address provided for this LON-CAPA server ([_1]) does not appear to be a valid e-mail address, your support request has <b>not</b> been sent to the LON-CAPA support staff or administrator at your institution.',

   'As this group has no members, there are no recipients to select.'
=> 'As this group has no members, there are no recipients to select.',

   'As this is not the case, most functionality in the system will be unavailable.'
=> 'As this is not the case, most functionality in the system will be unavailable.',

   'As you are not currently registered for this course, self-enrollment is unavailable.'
=> 'As you are not currently registered for this course, self-enrollment is unavailable.',

   'As you did not select any content items or discussions for export, an IMS package has not been created.'
=> 'As you did not select any content items or discussions for export, an IMS package has not been created.',

   'As you have chosen not to include any collaborative tools in the group, no default optional privileges need to be set.'
=> 'As you have chosen not to include any collaborative tools in the group, no default optional privileges need to be set.',

   'As your session file for the course or community has expired, you will need to re-select it.'
=> 'As your session file for the course or community has expired, you will need to re-select it.',

   'Ascending'
=> 'Ascending',

   'Ask a domain coordinator to assign a category to the course.'
=> 'Ask a domain coordinator to assign a category to the course.',

   'Ask a domain coordinator to assign an institutional code (if this is an official course).'
=> 'Ask a domain coordinator to assign an institutional code (if this is an official course).',

   'Ask a domain coordinator to change the "Exclude from course catalog" setting.'
=> 'Ask a domain coordinator to change the "Exclude from course catalog" setting.',

   'Ask a domain coordinator to change the category assigned to the course, as the one currently assigned is no longer used in the domain'
=> 'Ask a domain coordinator to change the category assigned to the course, as the one currently assigned is no longer used in the domain',

   'Ask a domain coordinator to create a hierarchy of categories and sub categories for courses in the domain.'
=> 'Ask a domain coordinator to create a hierarchy of categories and sub categories for courses in the domain.',

   'Ask a domain coordinator to enable display the catalog of "Official courses (with institutional codes)".'
=> 'Ask a domain coordinator to enable display the catalog of "Official courses (with institutional codes)".',

   'Ask a domain coordinator to enable or create at least one course category in the domain.'
=> 'Ask a domain coordinator to enable or create at least one course category in the domain.',

   'Ask helpdesk'
=> 'Ask helpdesk',

   'Assemble resources'
=> 'Assemble resources',

   'Assessment Questions'
=> 'Assessment Questions',

   'Assign Common Grade to Class'
=> 'Assign Common Grade to Class',

   'Assign Grade'
=> 'Assign Grade',

   'Assign Grade to Specific Students in Class'
=> 'Assign Grade to Specific Students in Class',

   'Assign Grades'
=> 'Assign Grades',

   'Assign a category to a community'
=> 'Assign a category to a community',

   'Assign a category to a course'
=> 'Assign a category to a course',

   'Assign collaborative tools'
=> 'Assign collaborative tools',

   'Assign one or more categories and/or subcategories to this course.'
=> 'Assign one or more categories and/or subcategories to this course.',

   'Assign one or more categories to this community.'
=> 'Assign one or more categories to this community.',

   'Assign one or more categories to this course.'
=> 'Assign one or more categories to this course.',

   'Assign one or more subcategories to this community.'
=> 'Assign one or more subcategories to this community.',

   'Assignable authentication types'
=> 'Assignable authentication types',

   'Assigned categories for this community'
=> 'Assigned categories for this community',

   'Assigned from [_1] at [_2] for [_3]'
=> 'Assigned from [_1] at [_2] for [_3]',

   'Assigning'
=> 'Assigning',

   'Assigning Role to Self'
=> 'Assigning Role to Self',

   'Assigning grades based on clicker file'
=> 'Assigning grades based on clicker file',

   'Assigning role of '
=> 'Assigning role of ',

   'Assigning role of Course Coordinator to [_1]:'
=> 'Assigning role of Course Coordinator to [_1]:',

   'Assigning role of Group Coordinator to [_1]:'
=> 'Assigning role of Group Coordinator to [_1]:',

   'Assigning yourself a co-author or assistant co-author role in your own author area in Construction Space is not permitted'
=> 'Assigning yourself a co-author or assistant co-author role in your own author area in Construction Space is not permitted',

   'Assistant Co-Author'
=> 'Assistant Co-Author',

   'Assistant Leader'
=> 'Assistant Leader',

   'Associate Resource With Selected Course'
=> 'Associate Resource With Selected Course',

   'Associated with course [_1]'
=> 'Associated with course [_1]',

   'At end of file some tags were still left unclosed, '
=> 'At end of file some tags were still left unclosed, ',

   'At end of file some tags were still left unclosed:'
=> 'At end of file some tags were still left unclosed:',

   'Attachments'
=> 'Attachments',

   'Attempted'
=> 'Attempted',

   'Authenticated Help Settings'
=> 'Authenticated Help Settings',

   'Authentication Method'
=> 'Authentication Method',

   'Authentication changed for [_1] existing users.'
=> 'Authentication changed for [_1] existing users.',

   'Authentication failed'
=> 'Authentication failed',

   'Authentication mechanism'
=> 'Authentication mechanism',

   'Authentication type for this user can not be changed by this mechanism'
=> 'Authentication type for this user can not be changed by this mechanism',

   'Author Settings'
=> 'Author Settings',

   'Author Space'
=> 'Author Space',

   'Author space for [_1]'
=> 'Author space for [_1]',

   'Auto-cataloging is enabled and the course is assigned an institutional code.'
=> 'Auto-cataloging is enabled and the course is assigned an institutional code.',

   'Auto-course creation settings'
=> 'Auto-course creation settings',

   'Auto-enrollment active?'
=> 'Auto-enrollment active?',

   'Auto-enrollment not currently enabled for [_1]'
=> 'Auto-enrollment not currently enabled for [_1]',

   'Auto-enrollment of[_1]registered students'
=> 'Auto-enrollment of[_1]registered students',

   'Auto-enrollment settings'
=> 'Auto-enrollment settings',

   'Auto-update active?'
=> 'Auto-update active?',

   'Auto-update settings'
=> 'Auto-update settings',

   'Automated Enrollment'
=> 'Automated Enrollment',

   'Automated adds/drops'
=> 'Automated adds/drops',

   'Automated creation from batch file'
=> 'Automated creation from batch file',

   'Automated enrollment'
=> 'Automated enrollment',

   'Automatic Adds'
=> 'Automatic Adds',

   'Automatic Drops'
=> 'Automatic Drops',

   'Automatic access for Dom. Coords.'
=> 'Automatic access for Dom. Coords.',

   'Automatic enrollment of registered students has not been enabled for the course.'
=> 'Automatic enrollment of registered students has not been enabled for the course.',

   'Automatic name changes'
=> 'Automatic name changes',

   'Automatic update of first, middle and last names if institutional directory information indicates changes'
=> 'Automatic update of first, middle and last names if institutional directory information indicates changes',

   'Automatically enable group membership when roles are added?'
=> 'Automatically enable group membership when roles are added?',

   'Automatically expire group membership when roles are removed?'
=> 'Automatically expire group membership when roles are removed?',

   'Av. Attempts'
=> 'Av. Attempts',

   'Availability determined currently from custom setting.'
=> 'Availability determined currently from custom setting.',

   'Availability determined currently from default setting.'
=> 'Availability determined currently from default setting.',

   'Availability/Processing of requests'
=> 'Availability/Processing of requests',

   'Available Group Tools'
=> 'Available Group Tools',

   'Available Portfolio files'
=> 'Available Portfolio files',

   'Available RSS Feeds and Blogs'
=> 'Available RSS Feeds and Blogs',

   'Available for assignment to members:'
=> 'Available for assignment to members:',

   'Available functions'
=> 'Available functions',

   'Available sections are:'
=> 'Available sections are:',

   'Available tools'
=> 'Available tools',

   'Availibility list'
=> 'Availibility list',

   'Average'
=> 'Average',

   'Average Number of Tries'
=> 'Average Number of Tries',

   'Average number of attempts'
=> 'Average number of attempts',

   'Award points just for participation'
=> 'Award points just for participation',

   'Awarded Total Points'
=> 'Awarded Total Points',

   'Awarding [_1] percent for correct and [_2] percent for incorrect responses'
=> 'Awarding [_1] percent for correct and [_2] percent for incorrect responses',

   'Back'
=> 'Back',

   'Back to Course Editor'
=> 'Back to Course Editor',

   'Back to Folder Display'
=> 'Back to Folder Display',

   'Back to Metadata'
=> 'Back to Metadata',

   'Back to Resource'
=> 'Back to Resource',

   'Back to Source File'
=> 'Back to Source File',

   'Back to [_1]'
=> 'Back to [_1]',

   'Back to community listing'
=> 'Back to community listing',

   'Back to configuration display'
=> 'Back to configuration display',

   'Back to course listing'
=> 'Back to course listing',

   'Back to display/edit settings'
=> 'Back to display/edit settings',

   'Back to last location'
=> 'Back to last location',

   'Back to options page'
=> 'Back to options page',

   'Back to preferences menu'
=> 'Back to preferences menu',

   'Back to previous page'
=> 'Back to previous page',

   'Background colors'
=> 'Background colors',

   'Bad filename [_1]'
=> 'Bad filename [_1]',

   'Banner for admin role'
=> 'Banner for admin role',

   'Banner for author role'
=> 'Banner for author role',

   'Banner for coordinator role'
=> 'Banner for coordinator role',

   'Banner for student role'
=> 'Banner for student role',

   'Based on your institutional affiliation no name information is automatically updated for your LON-CAPA account.'
=> 'Based on your institutional affiliation no name information is automatically updated for your LON-CAPA account.',

   'Basic Display'
=> 'Basic Display',

   'Batch creation from uploaded file'
=> 'Batch creation from uploaded file',

   'Bcc:'
=> 'Bcc:',

   'Bcc: community participants with current access'
=> 'Bcc: community participants with current access',

   'Bcc: community participants with expired access'
=> 'Bcc: community participants with expired access',

   'Bcc: community participants with future access'
=> 'Bcc: community participants with future access',

   'Bcc: course members with current access'
=> 'Bcc: course members with current access',

   'Bcc: course members with expired access'
=> 'Bcc: course members with expired access',

   'Because of this student/employee ID conflict, the new username - [_1] - has not been added to the LON-CAPA classlist'
=> 'Because of this student/employee ID conflict, the new username - [_1] - has not been added to the LON-CAPA classlist',

   'Before'
=> 'Before',

   'Before course enrollment start!'
=> 'Before course enrollment start!',

   'Before:'
=> 'Before:',

   'Begin'
=> 'Begin',

   'Begins with'
=> 'Begins with',

   'Behavior of clickable username link for each user'
=> 'Behavior of clickable username link for each user',

   'Behaviour of Input Fields'
=> 'Behaviour of Input Fields',

   'Blank Problem'
=> 'Blank Problem',

   'Block access to construction space'
=> 'Block access to construction space',

   'Block set by'
=> 'Block set by',

   'Blocked?'
=> 'Blocked?',

   'Blog'
=> 'Blog',

   'Blog Availability'
=> 'Blog Availability',

   'Blogs will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Blogs will be inaccessible between [_1] and [_2] because communication is being blocked.',

   'Body of document goes here'
=> 'Body of document goes here',

   'Bomb'
=> 'Bomb',

   'Bookmark Tree Viewer/Editor'
=> 'Bookmark Tree Viewer/Editor',

   'Bookmarks'
=> 'Bookmarks',

   'Border'
=> 'Border',

   'Box color'
=> 'Box color',

   'Branch'
=> 'Branch',

   'Bridge Task Grading'
=> 'Bridge Task Grading',

   'Bridge Task grading by instructors and TAs in sections'
=> 'Bridge Task grading by instructors and TAs in sections',

   'Bridge tasks'
=> 'Bridge tasks',

   'Brief Community Description'
=> 'Brief Community Description',

   'Brief Course Description'
=> 'Brief Course Description',

   'Broadcast E-mail'
=> 'Broadcast E-mail',

   'Broadcast Message'
=> 'Broadcast Message',

   'Broadcast e-mail display options'
=> 'Broadcast e-mail display options',

   'Broadcast e-mail to Domain'
=> 'Broadcast e-mail to Domain',

   'Broadcast e-mail to users'
=> 'Broadcast e-mail to users',

   'Broadcast message'
=> 'Broadcast message',

   'Browse own authored/co-authored published resources'
=> 'Browse own authored/co-authored published resources',

   'Browser'
=> 'Browser',

   'Bubble sheet type:'
=> 'Bubble sheet type:',

   'Bubblesheet'
=> 'Bubblesheet',

   'Bubblesheet format file'
=> 'Bubblesheet format file',

   'Build a list of users for selection of group members'
=> 'Build a list of users for selection of group members',

   'Building spreadsheet.'
=> 'Building spreadsheet.',

   'Building text document.'
=> 'Building text document.',

   'Building valid e-mail address from username, if missing from preferences:'
=> 'Building valid e-mail address from username, if missing from preferences:',

   'By default, based on your institutional affiliation, your LON-CAPA account can be automatically updated nightly based on directory information from your institution.'
=> 'By default, based on your institutional affiliation, your LON-CAPA account can be automatically updated nightly based on directory information from your institution.',

   'By default, the Domain Coordinator can enter your construction space.'
=> 'By default, the Domain Coordinator can enter your construction space.',

   'By domain and username'
=> 'By domain and username',

   'By last name, first name'
=> 'By last name, first name',

   'By member'
=> 'By member',

   'By student'
=> 'By student',

   'By subject'
=> 'By subject',

   'CSS file to link'
=> 'CSS file to link',

   'CSS file to link (cssfile)'
=> 'CSS file to link (cssfile)',

   'CSV'
=> 'CSV',

   'Calendar Announcement for '
=> 'Calendar Announcement for ',

   'Can Request Communities'
=> 'Can Request Communities',

   'Can Request Official Courses'
=> 'Can Request Official Courses',

   'Can Request Unofficial Courses'
=> 'Can Request Unofficial Courses',

   'Can request creation of communities'
=> 'Can request creation of communities',

   'Can request creation of official courses'
=> 'Can request creation of official courses',

   'Can request creation of unofficial courses'
=> 'Can request creation of unofficial courses',

   "Can't find any valid PDF formfields."
=> "Can't find any valid PDF formfields.",

   'Cancel Request'
=> 'Cancel Request',

   'Cancel community request'
=> 'Cancel community request',

   'Cancel course request'
=> 'Cancel course request',

   'Cancellation Date'
=> 'Cancellation Date',

   'Cancelling the request will remove it from the queue of pending community requests'
=> 'Cancelling the request will remove it from the queue of pending community requests',

   'Cancelling the request will remove it from the queue of pending course requests'
=> 'Cancelling the request will remove it from the queue of pending course requests',

   'Cannot change MIME type of a directory.'
=> 'Cannot change MIME type of a directory.',

   'Cannot delete non-obsolete published file.'
=> 'Cannot delete non-obsolete published file.',

   'Cannot rename or move non-obsolete published file.'
=> 'Cannot rename or move non-obsolete published file.',

   'Catalog Settings for Community'
=> 'Catalog Settings for Community',

   'Catalog Settings for Course'
=> 'Catalog Settings for Course',

   'Catalog settings'
=> 'Catalog settings',

   'Catalog settings in this domain are set in community context via "Community Configuration".'
=> 'Catalog settings in this domain are set in community context via "Community Configuration".',

   'Catalog settings in this domain are set in course context via "Course Configuration".'
=> 'Catalog settings in this domain are set in course context via "Course Configuration".',

   'Cataloging of courses'
=> 'Cataloging of courses',

   'Cataloging of courses/communities'
=> 'Cataloging of courses/communities',

   'Categories'
=> 'Categories',

   'Categorize Community'
=> 'Categorize Community',

   'Categorize Course'
=> 'Categorize Course',

   'Categorize course'
=> 'Categorize course',

   'Category'
=> 'Category',

   'Category settings'
=> 'Category settings',

   'Category settings for communities in this domain should be modified in community context (via "[_1]Community Configuration[_2]").'
=> 'Category settings for communities in this domain should be modified in community context (via "[_1]Community Configuration[_2]").',

   'Category settings for courses in this domain should be modified in course context (via "[_1]Course Configuration[_2]").'
=> 'Category settings for courses in this domain should be modified in course context (via "[_1]Course Configuration[_2]").',

   'Caution: this folder is set to randomly order its contents. Adding or removing resources from this folder will change the order of resources shown.'
=> 'Caution: this folder is set to randomly order its contents. Adding or removing resources from this folder will change the order of resources shown.',

   'Caution: this folder is set to randomly pick a subset of resources. Adding or removing resources from this folder will change the set of resources that the students see, resulting in spurious or missing credit for completed problems, not limited to ones you modify. Do not modify the contents of this folder if it is in active student use.'
=> 'Caution: this folder is set to randomly pick a subset of resources. Adding or removing resources from this folder will change the set of resources that the students see, resulting in spurious or missing credit for completed problems, not limited to ones you modify. Do not modify the contents of this folder if it is in active student use.',

   'Cc'
=> 'Cc',

   'Cc:'
=> 'Cc:',

   "Certain settings which control auto-enrollment of students from your institution's student information system."
=> "Certain settings which control auto-enrollment of students from your institution's student information system.",

   'Change Color Scheme'
=> 'Change Color Scheme',

   'Change Colors'
=> 'Change Colors',

   'Change Conditions'
=> 'Change Conditions',

   'Change Course Init. Pref.'
=> 'Change Course Init. Pref.',

   'Change Course Initialization Preference'
=> 'Change Course Initialization Preference',

   'Change Course Page Pref'
=> 'Change Course Page Pref',

   'Change Course Page Preferences'
=> 'Change Course Page Preferences',

   'Change Courses Page Pref'
=> 'Change Courses Page Pref',

   'Change Current Login Data'
=> 'Change Current Login Data',

   'Change Discussion Display Preferences'
=> 'Change Discussion Display Preferences',

   'Change Discussion Preferences'
=> 'Change Discussion Preferences',

   'Change How Math Equations Are Displayed'
=> 'Change How Math Equations Are Displayed',

   'Change How Menus are Displayed'
=> 'Change How Menus are Displayed',

   'Change LON-CAPA default colors.'
=> 'Change LON-CAPA default colors.',

   'Change Language'
=> 'Change Language',

   'Change Language Preferences'
=> 'Change Language Preferences',

   'Change Log'
=> 'Change Log',

   'Change Math Pref'
=> 'Change Math Pref',

   'Change Math Preferences'
=> 'Change Math Preferences',

   'Change Message Forwarding/Notification'
=> 'Change Message Forwarding/Notification',

   'Change Order'
=> 'Change Order',

   'Change Parameter Selection'
=> 'Change Parameter Selection',

   'Change Password'
=> 'Change Password',

   'Change Preferences'
=> 'Change Preferences',

   'Change Privileges'
=> 'Change Privileges',

   'Change Roles Page Pref'
=> 'Change Roles Page Pref',

   'Change Roles Page Preferences'
=> 'Change Roles Page Preferences',

   'Change Roles Preferences'
=> 'Change Roles Preferences',

   'Change Screen Name'
=> 'Change Screen Name',

   'Change Screenname'
=> 'Change Screenname',

   'Change View'
=> 'Change View',

   'Change WYSIWYG Editor Preferences'
=> 'Change WYSIWYG Editor Preferences',

   'Change WYSIWYG Preferences'
=> 'Change WYSIWYG Preferences',

   'Change access dates'
=> 'Change access dates',

   'Change authentication for existing users in domain "[_1]" to these settings?'
=> 'Change authentication for existing users in domain "[_1]" to these settings?',

   'Change crosslistings'
=> 'Change crosslistings',

   'Change discussion display'
=> 'Change discussion display',

   'Change enrollment dates'
=> 'Change enrollment dates',

   'Change how Scientific Equations are displayed.'
=> 'Change how Scientific Equations are displayed.',

   'Change how math is displayed'
=> 'Change how math is displayed',

   'Change how math is displayed.'
=> 'Change how math is displayed.',

   'Change interval'
=> 'Change interval',

   'Change interval?'
=> 'Change interval?',

   "Change is not permitted without checking the 'Force ID change' checkbox on the previous page."
=> "Change is not permitted without checking the 'Force ID change' checkbox on the previous page.",

   'Change messageforwarding or notifications settings.'
=> 'Change messageforwarding or notifications settings.',

   'Change options?'
=> 'Change options?',

   'Change quota'
=> 'Change quota',

   'Change reservation'
=> 'Change reservation',

   'Change section associated with user roles'
=> 'Change section associated with user roles',

   'Change settings'
=> 'Change settings',

   'Change starting/ending dates'
=> 'Change starting/ending dates',

   'Change the name that is displayed in your posts.'
=> 'Change the name that is displayed in your posts.',

   'Change thresholds'
=> 'Change thresholds',

   'Change thresholds?'
=> 'Change thresholds?',

   'Change to '
=> 'Change to ',

   'Change to [_1]'
=> 'Change to [_1]',

   'Change your password.'
=> 'Change your password.',

   "Changed Access Dates for role of '[_1]' in [_2] for [_3]"
=> "Changed Access Dates for role of '[_1]' in [_2] for [_3]",

   'Changed Access Dates for role(s) for [quant,_1,user,users,no users].'
=> 'Changed Access Dates for role(s) for [quant,_1,user,users,no users].',

   'Changed To:'
=> 'Changed To:',

   'Changed User'
=> 'Changed User',

   'Changed discussion status'
=> 'Changed discussion status',

   'Changed display status'
=> 'Changed display status',

   "Changed section for role of '[_1]' in [_2] for [_3]"
=> "Changed section for role of '[_1]' in [_2] for [_3]",

   'Changed section for role(s) for [quant,_1,user,users,no users].'
=> 'Changed section for role(s) for [quant,_1,user,users,no users].',

   'Changed sort/filter'
=> 'Changed sort/filter',

   'Changes in section affiliation to apply to selected users'
=> 'Changes in section affiliation to apply to selected users',

   'Changes made:'
=> 'Changes made:',

   'Changes to default start and/or end dates for student access'
=> 'Changes to default start and/or end dates for student access',

   'Changes to first and/or last automated enrollment dates'
=> 'Changes to first and/or last automated enrollment dates',

   'Changes to nightly automated enrollments'
=> 'Changes to nightly automated enrollments',

   'Changes to section settings'
=> 'Changes to section settings',

   'Changes to threshold(s) for problem tracking:'
=> 'Changes to threshold(s) for problem tracking:',

   'Changes will become active for your current session after [_1], or the next time you log in.'
=> 'Changes will become active for your current session after [_1], or the next time you log in.',

   'Changes/page:'
=> 'Changes/page:',

   'Chat Room'
=> 'Chat Room',

   'Chat Room Participation'
=> 'Chat Room Participation',

   'Chat Room will be unavailable to you until [_1] because communication is blocked in one or more of your courses:'
=> 'Chat Room will be unavailable to you until [_1] because communication is blocked in one or more of your courses:',

   'Chat will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Chat will be inaccessible between [_1] and [_2] because communication is being blocked.',

   'Check For Plagiarism'
=> 'Check For Plagiarism',

   'Check Import first'
=> 'Check Import first',

   'Check Mark'
=> 'Check Mark',

   'Check Section/Group'
=> 'Check Section/Group',

   'Check Spelling'
=> 'Check Spelling',

   'Check as many files as you wish in response to the problem:'
=> 'Check as many files as you wish in response to the problem:',

   'Check machines:'
=> 'Check machines:',

   "Check the boxes for any users for whom roles are to be deleted, and click 'Proceed'"
=> "Check the boxes for any users for whom roles are to be deleted, and click 'Proceed'",

   "Check the boxes for any users for whom roles are to be revoked, and click 'Proceed'"
=> "Check the boxes for any users for whom roles are to be revoked, and click 'Proceed'",

   'Check the checkbox for at least one message.'
=> 'Check the checkbox for at least one message.',

   'Check the checkboxes for all areas you wish to import from the IMS package:'
=> 'Check the checkboxes for all areas you wish to import from the IMS package:',

   'Check username'
=> 'Check username',

   'Chemical Reaction Response'
=> 'Chemical Reaction Response',

   'Chemical Reaction Response with Hints'
=> 'Chemical Reaction Response with Hints',

   'Chemistry Problems'
=> 'Chemistry Problems',

   'Choices:'
=> 'Choices:',

   'Choices: '
=> 'Choices: ',

   'Choose Privileges'
=> 'Choose Privileges',

   'Choose Task'
=> 'Choose Task',

   'Choose a category to display'
=> 'Choose a category to display',

   'Choose a course'
=> 'Choose a course',

   'Choose a different Problem'
=> 'Choose a different Problem',

   'Choose a different Survey'
=> 'Choose a different Survey',

   'Choose a student:'
=> 'Choose a student:',

   'Choose a subcategory to display'
=> 'Choose a subcategory to display',

   'Choose an action to take for selected users'
=> 'Choose an action to take for selected users',

   'Choose another server.'
=> 'Choose another server.',

   'Choose course entry'
=> 'Choose course entry',

   'Choose display options for listing of contents of top level of package'
=> 'Choose display options for listing of contents of top level of package',

   'Choose e-mail audience'
=> 'Choose e-mail audience',

   'Choose next report:'
=> 'Choose next report:',

   'Choose one of the following:'
=> 'Choose one of the following:',

   'Choose sender(s)'
=> 'Choose sender(s)',

   'Choose sender(s):'
=> 'Choose sender(s):',

   'Choose the default language for this user.'
=> 'Choose the default language for this user.',

   'Choose the role and/or section(s) to assign to users without values specified in the uploaded file.'
=> 'Choose the role and/or section(s) to assign to users without values specified in the uploaded file.',

   'Choose the role to assign to users without a value specified in the uploaded file.'
=> 'Choose the role to assign to users without a value specified in the uploaded file.',

   'Choose the time window to use to display resources in the course with version changes.'
=> 'Choose the time window to use to display resources in the course with version changes.',

   'Choose the time window to use to display roles for which access to the course became available.'
=> 'Choose the time window to use to display roles for which access to the course became available.',

   'Choose the time window to use to display roles for which access to the course expired.'
=> 'Choose the time window to use to display roles for which access to the course expired.',

   'Choose whether or not to display a count of the number of new posts for each resource or discussion board which has unread posts.'
=> 'Choose whether or not to display a count of the number of new posts for each resource or discussion board which has unread posts.',

   'Choose which content types you wish to import'
=> 'Choose which content types you wish to import',

   'Choose which course(s) to list.'
=> 'Choose which course(s) to list.',

   'Choose which items you wish to export from your Course.'
=> 'Choose which items you wish to export from your Course.',

   'Choose which page will be displayed when you enter this course after selecting a role.'
=> 'Choose which page will be displayed when you enter this course after selecting a role.',

   'Choose your LON-CAPA domain'
=> 'Choose your LON-CAPA domain',

   'Class Print Status'
=> 'Class Print Status',

   'Classlist'
=> 'Classlist',

   'Classlist Manager'
=> 'Classlist Manager',

   'Classlist of all students'
=> 'Classlist of all students',

   "Classlist of viewer's section"
=> "Classlist of viewer's section",

   'Classlist update for "[_1]" in "[_2]".'
=> 'Classlist update for "[_1]" in "[_2]".',

   'Classlists and Staff Listing'
=> 'Classlists and Staff Listing',

   'Clean Up'
=> 'Clean Up',

   'Clean up'
=> 'Clean up',

   'Cleaned up file'
=> 'Cleaned up file',

   'Cleanup XML Document'
=> 'Cleanup XML Document',

   'Clear'
=> 'Clear',

   'Clear Form'
=> 'Clear Form',

   'Clear all Messages in Subdirectory'
=> 'Clear all Messages in Subdirectory',

   "Click 'Search'"
=> "Click 'Search'",

   "Click a 'Select' button to view or modify settings for a [_1] which may only be modified by a [_2] in this domain."
=> "Click a 'Select' button to view or modify settings for a [_1] which may only be modified by a [_2] in this domain.",

   "Click on a student's name or username to view their chart"
=> "Click on a student's name or username to view their chart",

   'Click on a students name or username to view their chart'
=> 'Click on a students name or username to view their chart',

   "Click on a username to view the user's personal information page."
=> "Click on a username to view the user's personal information page.",

   'Click on the button below to return to the grading menu.'
=> 'Click on the button below to return to the grading menu.',

   "Click the 'Switch Server' link to go there."
=> "Click the 'Switch Server' link to go there.",

   'Click to add/remove attachments'
=> 'Click to add/remove attachments',

   'Click to select a Coordinate or click Finish to save current selection'
=> 'Click to select a Coordinate or click Finish to save current selection',

   'Click-On-Image Problem'
=> 'Click-On-Image Problem',

   'Clickable Image'
=> 'Clickable Image',

   'Clicker registered more than once'
=> 'Clicker registered more than once',

   'Client IP/Name Access Control'
=> 'Client IP/Name Access Control',

   'Clipboard'
=> 'Clipboard',

   'Clone From'
=> 'Clone From',

   'Clone content and settings from an existing community?'
=> 'Clone content and settings from an existing community?',

   'Clone content and settings from an existing course?'
=> 'Clone content and settings from an existing course?',

   'Clone date parameters as-is'
=> 'Clone date parameters as-is',

   'Clone?'
=> 'Clone?',

   'Cloneable by you'
=> 'Cloneable by you',

   'Cloneable for'
=> 'Cloneable for',

   'Cloning course from'
=> 'Cloning course from',

   'Close Folder'
=> 'Close Folder',

   'Close Window'
=> 'Close Window',

   'Close navigation window'
=> 'Close navigation window',

   'Close window'
=> 'Close window',

   'Closed - XML source is closed to everyone'
=> 'Closed - XML source is closed to everyone',

   'Closes '
=> 'Closes ',

   'Closing'
=> 'Closing',

   'Co-Author Roles'
=> 'Co-Author Roles',

   'Co-Author [_1]'
=> 'Co-Author [_1]',

   'Co-authors in domain with active [_1] roles'
=> 'Co-authors in domain with active [_1] roles',

   'Co-authors in domain with expired [_1] roles'
=> 'Co-authors in domain with expired [_1] roles',

   'Co-authors in domain with future [_1] roles'
=> 'Co-authors in domain with future [_1] roles',

   'Co-authors with active [_1] roles'
=> 'Co-authors with active [_1] roles',

   'Co-authors with expired [_1] roles'
=> 'Co-authors with expired [_1] roles',

   'Co-authors with future [_1] roles'
=> 'Co-authors with future [_1] roles',

   'Co-ownership is set automatically when a Course Coordinator role is assigned to official course personnel (from institutional data).'
=> 'Co-ownership is set automatically when a Course Coordinator role is assigned to official course personnel (from institutional data).',

   'Code'
=> 'Code',

   'Code ran too long. It ran for more than'
=> 'Code ran too long. It ran for more than',

   'Collaborated with [_1]'
=> 'Collaborated with [_1]',

   'Collaborative Tool'
=> 'Collaborative Tool',

   'Collaborative Tools'
=> 'Collaborative Tools',

   'Collection of Imageresponse foils'
=> 'Collection of Imageresponse foils',

   'Color Scheme'
=> 'Color Scheme',

   'Column [_1]'
=> 'Column [_1]',

   'Combined size of files not to exceed: [_1] MB[_2].'
=> 'Combined size of files not to exceed: [_1] MB[_2].',

   'Comment'
=> 'Comment',

   'Comments'
=> 'Comments',

   'Communicate'
=> 'Communicate',

   'Communication Blocked'
=> 'Communication Blocked',

   'Communication Blocking'
=> 'Communication Blocking',

   'Communication Blocking Status Information'
=> 'Communication Blocking Status Information',

   'Communication blocking during scheduled exams'
=> 'Communication blocking during scheduled exams',

   'Communication will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Communication will be inaccessible between [_1] and [_2] because communication is being blocked.',

   'Communication/Messages'
=> 'Communication/Messages',

   'Communities: description, section(s), status'
=> 'Communities: description, section(s), status',

   'Community - [_1]:'
=> 'Community - [_1]:',

   'Community Announcements'
=> 'Community Announcements',

   'Community Blog'
=> 'Community Blog',

   'Community Contents'
=> 'Community Contents',

   'Community Created'
=> 'Community Created',

   'Community Creation'
=> 'Community Creation',

   'Community Discussion Board'
=> 'Community Discussion Board',

   'Community Domain'
=> 'Community Domain',

   'Community Editor'
=> 'Community Editor',

   'Community Folder -[_1]'
=> 'Community Folder -[_1]',

   'Community Group Settings'
=> 'Community Group Settings',

   'Community Owner'
=> 'Community Owner',

   'Community Owner/Co-owner'
=> 'Community Owner/Co-owner',

   'Community Personnel Includes'
=> 'Community Personnel Includes',

   'Community Request'
=> 'Community Request',

   'Community Request Details'
=> 'Community Request Details',

   'Community Roles'
=> 'Community Roles',

   'Community Settings'
=> 'Community Settings',

   'Community created'
=> 'Community created',

   'Community owner (permitted to assign Coordinator roles in the community).'
=> 'Community owner (permitted to assign Coordinator roles in the community).',

   'Community portfolio files disk space'
=> 'Community portfolio files disk space',

   'Community roles'
=> 'Community roles',

   'Community sections'
=> 'Community sections',

   'Community status'
=> 'Community status',

   'Comparison of bubblesheet data (including corrections) with corresponding submission records (most recent submission) for [_1][quant,_2,student][_3] ([quant,_4,bubblesheet line] per student).'
=> 'Comparison of bubblesheet data (including corrections) with corresponding submission records (most recent submission) for [_1][quant,_2,student][_3] ([quant,_4,bubblesheet line] per student).',

   'Comparison of student IDs in the uploaded file with the course roster found matches for [_1] of the [_2] entries in the file (for the format defined for [_3]).'
=> 'Comparison of student IDs in the uploaded file with the course roster found matches for [_1] of the [_2] entries in the file (for the format defined for [_3]).',

   'Compiled on [_1]'
=> 'Compiled on [_1]',

   'Compiling Excel spreadsheet for [quant,_1,student]...'
=> 'Compiling Excel spreadsheet for [quant,_1,student]...',

   'Compiling student activity data can take a long time. Your request continues to be processed while results are displayed.'
=> 'Compiling student activity data can take a long time. Your request continues to be processed while results are displayed.',

   'Completed Problems Display'
=> 'Completed Problems Display',

   'Completed upload of the file. This file contained references to other files. You must upload the referenced files or else the uploaded file may not work properly.'
=> 'Completed upload of the file. This file contained references to other files. You must upload the referenced files or else the uploaded file may not work properly.',

   'Compose E-mail'
=> 'Compose E-mail',

   'Compose Group Message'
=> 'Compose Group Message',

   'Compose message to student'
=> 'Compose message to student',

   'Composing Query'
=> 'Composing Query',

   "Computer's answer is incorrect ([_1])."
=> "Computer's answer is incorrect ([_1]).",

   "Computer's answer now shown above."
=> "Computer's answer now shown above.",

   'Computing correct answers greatly increases the amount of time required to prepare a report.'
=> 'Computing correct answers greatly increases the amount of time required to prepare a report.',

   'Condense'
=> 'Condense',

   'Conditional'
=> 'Conditional',

   'Conditional access controls for file: [_1]'
=> 'Conditional access controls for file: [_1]',

   'Conditional access: [_1]'
=> 'Conditional access: [_1]',

   'Conditional files are accessible to logged-in users with accounts in the LON-CAPA network, who satisfy the conditions you set.'
=> 'Conditional files are accessible to logged-in users with accounts in the LON-CAPA network, who satisfy the conditions you set.',

   'Conditional: course/community-based'
=> 'Conditional: course/community-based',

   'Conditional: domain-based'
=> 'Conditional: domain-based',

   'Conditional: user-based'
=> 'Conditional: user-based',

   'Configuration'
=> 'Configuration',

   'Configuration Setting'
=> 'Configuration Setting',

   'Configuration setting'
=> 'Configuration setting',

   'Configure Blocking of Student Communication during Exams'
=> 'Configure Blocking of Student Communication during Exams',

   'Configure Self-enrollment'
=> 'Configure Self-enrollment',

   'Configure User Self-enrollment'
=> 'Configure User Self-enrollment',

   'Configure a custom role.'
=> 'Configure a custom role.',

   'Configure blocking of student communication during exams'
=> 'Configure blocking of student communication during exams',

   'Configure the roles hotlist.'
=> 'Configure the roles hotlist.',

   'Configure user self-enrollment.'
=> 'Configure user self-enrollment.',

   'Confirm Cancellation'
=> 'Confirm Cancellation',

   'Confirm Password'
=> 'Confirm Password',

   'Confirm Receipt'
=> 'Confirm Receipt',

   'Confirm Receipt and Reply'
=> 'Confirm Receipt and Reply',

   'Confirm that this information is correct, then click &quot;Save&quot; to complete setting the parameter.'
=> 'Confirm that this information is correct, then click &quot;Save&quot; to complete setting the parameter.',

   'Confirm that you wish to create an account.'
=> 'Confirm that you wish to create an account.',

   'Confirmation'
=> 'Confirmation',

   'Confirmed Receipt'
=> 'Confirmed Receipt',

   'Confirming Receipt'
=> 'Confirming Receipt',

   'Connection Status'
=> 'Connection Status',

   'Connections Matrix'
=> 'Connections Matrix',

   'Consequently, although a new role was created for you in the course, it is an inactive role which does not provide access to the course.'
=> 'Consequently, although a new role was created for you in the course, it is an inactive role which does not provide access to the course.',

   'Consequently, although a new role was created for you in the course, you will not be able to select this role until [_1].'
=> 'Consequently, although a new role was created for you in the course, you will not be able to select this role until [_1].',

   'Construction Space access is only available from the home server of the corresponding Author.'
=> 'Construction Space access is only available from the home server of the corresponding Author.',

   'Contact Helpdesk'
=> 'Contact Helpdesk',

   'Contact [_1] for access.'
=> 'Contact [_1] for access.',

   'Contact your instructor instead.'
=> 'Contact your instructor instead.',

   'Contacting course home server'
=> 'Contacting course home server',

   'Containing phrase'
=> 'Containing phrase',

   'Contains'
=> 'Contains',

   'Content'
=> 'Content',

   'Content Close Date'
=> 'Content Close Date',

   'Content Close Date (contentclose)'
=> 'Content Close Date (contentclose)',

   'Content Dates'
=> 'Content Dates',

   'Content Display Settings'
=> 'Content Display Settings',

   'Content Due Date'
=> 'Content Due Date',

   'Content Due Date (contentclose)'
=> 'Content Due Date (contentclose)',

   'Content Library'
=> 'Content Library',

   'Content Opening Date'
=> 'Content Opening Date',

   'Content Opening Date (contentopen)'
=> 'Content Opening Date (contentopen)',

   'Content items'
=> 'Content items',

   'Content type'
=> 'Content type',

   'Context'
=> 'Context',

   'Context:'
=> 'Context:',

   'Continue Import'
=> 'Continue Import',

   'Continue Search'
=> 'Continue Search',

   'Continue adding users?'
=> 'Continue adding users?',

   'Control Access'
=> 'Control Access',

   'Convert to Images'
=> 'Convert to Images',

   'Coordinate Pairs'
=> 'Coordinate Pairs',

   'Coordinate list'
=> 'Coordinate list',

   'Coordinator'
=> 'Coordinator',

   'Coordinator Settings'
=> 'Coordinator Settings',

   'Coordinators included automatically'
=> 'Coordinators included automatically',

   'Copy'
=> 'Copy',

   'Copy Problem Source Code to Construction Space'
=> 'Copy Problem Source Code to Construction Space',

   'Copy [_1] to [_2]?'
=> 'Copy [_1] to [_2]?',

   'Copy of'
=> 'Copy of',

   'Copy saved but not submitted.'
=> 'Copy saved but not submitted.',

   'Copy to Construction Space'
=> 'Copy to Construction Space',

   'Copy to main window'
=> 'Copy to main window',

   'Copyright/distribution option "Private" is no longer supported. Select another option from below. Consider "Custom Rights" for maximum control over the usage of your resource.'
=> 'Copyright/distribution option "Private" is no longer supported. Select another option from below. Consider "Custom Rights" for maximum control over the usage of your resource.',

   'Core privileges'
=> 'Core privileges',

   'Correct'
=> 'Correct',

   'Correct Answer(s) (if applicable)'
=> 'Correct Answer(s) (if applicable)',

   'Correct Problems Plot'
=> 'Correct Problems Plot',

   'Correct answer'
=> 'Correct answer',

   'Correct answer: [_1]'
=> 'Correct answer: [_1]',

   'Correct:'
=> 'Correct:',

   'Correctness determined by the following IDs'
=> 'Correctness determined by the following IDs',

   'Correctness determined from given list of answers'
=> 'Correctness determined from given list of answers',

   'Correctness determined from response by course personnel'
=> 'Correctness determined from response by course personnel',

   'Correctness determined from response with clicker ID(s)'
=> 'Correctness determined from response with clicker ID(s)',

   'Could not deliver forwarded message.'
=> 'Could not deliver forwarded message.',

   'Could not deliver message'
=> 'Could not deliver message',

   'Could not forward [quant,_1,message].'
=> 'Could not forward [quant,_1,message].',

   'Could not handle ambiguous resource reference'
=> 'Could not handle ambiguous resource reference',

   'Could not identify problem.'
=> 'Could not identify problem.',

   'Could not initialize [_1] at this time.'
=> 'Could not initialize [_1] at this time.',

   'Could not load javascript file [_1]'
=> 'Could not load javascript file [_1]',

   'Could not transfer data in added fields to notes'
=> 'Could not transfer data in added fields to notes',

   'Could not verify current authentication.'
=> 'Could not verify current authentication.',

   'Could not write metadata, FAIL'
=> 'Could not write metadata, FAIL',

   'Count'
=> 'Count',

   'Count unread posts in discussions display set to [_1]'
=> 'Count unread posts in discussions display set to [_1]',

   'Counting pages for student: [_1]'
=> 'Counting pages for student: [_1]',

   'Course - [_1]:'
=> 'Course - [_1]:',

   'Course / User'
=> 'Course / User',

   'Course Access'
=> 'Course Access',

   'Course Activity'
=> 'Course Activity',

   'Course Activity:'
=> 'Course Activity:',

   'Course Announcements'
=> 'Course Announcements',

   'Course Category'
=> 'Course Category',

   'Course Configuration'
=> 'Course Configuration',

   'Course Contents'
=> 'Course Contents',

   'Course Coordinators'
=> 'Course Coordinators',

   'Course Coordinators to be notified of enrollment changes'
=> 'Course Coordinators to be notified of enrollment changes',

   'Course Created'
=> 'Course Created',

   'Course Creation'
=> 'Course Creation',

   'Course Details'
=> 'Course Details',

   'Course Discussion Board'
=> 'Course Discussion Board',

   'Course Discussion Boards'
=> 'Course Discussion Boards',

   'Course Document Change Log'
=> 'Course Document Change Log',

   'Course Domain'
=> 'Course Domain',

   'Course Domain:'
=> 'Course Domain:',

   'Course Editor'
=> 'Course Editor',

   'Course Environment'
=> 'Course Environment',

   'Course Folder -[_1]'
=> 'Course Folder -[_1]',

   'Course Grading'
=> 'Course Grading',

   'Course Group Settings'
=> 'Course Group Settings',

   'Course Groups'
=> 'Course Groups',

   'Course ID of Key Authority'
=> 'Course ID of Key Authority',

   'Course ID of Key Authority:'
=> 'Course ID of Key Authority:',

   'Course Information - [_1]'
=> 'Course Information - [_1]',

   'Course Information page'
=> 'Course Information page',

   'Course Initialization'
=> 'Course Initialization',

   'Course Institutional Code'
=> 'Course Institutional Code',

   'Course Institutional Code:'
=> 'Course Institutional Code:',

   'Course Management'
=> 'Course Management',

   'Course Name'
=> 'Course Name',

   'Course Owner'
=> 'Course Owner',

   "Course Owner's Domain"
=> "Course Owner's Domain",

   "Course Owner's Domain:"
=> "Course Owner's Domain:",

   "Course Owner's Username"
=> "Course Owner's Username",

   "Course Owner's Username:"
=> "Course Owner's Username:",

   'Course Owner/Co-owner'
=> 'Course Owner/Co-owner',

   'Course Owner:'
=> 'Course Owner:',

   'Course Page'
=> 'Course Page',

   'Course Personnel Includes'
=> 'Course Personnel Includes',

   'Course Policy'
=> 'Course Policy',

   'Course Request'
=> 'Course Request',

   'Course Request Details'
=> 'Course Request Details',

   'Course Requests'
=> 'Course Requests',

   'Course Roles'
=> 'Course Roles',

   'Course Roster'
=> 'Course Roster',

   'Course Settings'
=> 'Course Settings',

   'Course Statistics and Charts cannot be retrieved until the database is restarted. Your data is intact but cannot be displayed at this time.'
=> 'Course Statistics and Charts cannot be retrieved until the database is restarted. Your data is intact but cannot be displayed at this time.',

   'Course Type'
=> 'Course Type',

   'Course Type:'
=> 'Course Type:',

   'Course View'
=> 'Course View',

   'Course access dates assigned to self-enrolling users'
=> 'Course access dates assigned to self-enrolling users',

   'Course and Catalog Search'
=> 'Course and Catalog Search',

   'Course and community creation'
=> 'Course and community creation',

   'Course anouncements and my calendar'
=> 'Course anouncements and my calendar',

   'Course created'
=> 'Course created',

   'Course creation failed, unrecognized course home server.'
=> 'Course creation failed, unrecognized course home server.',

   'Course details'
=> 'Course details',

   'Course initialization preference'
=> 'Course initialization preference',

   'Course listing'
=> 'Course listing',

   'Course members with current access'
=> 'Course members with current access',

   'Course members with expired access'
=> 'Course members with expired access',

   'Course members with future access'
=> 'Course members with future access',

   'Course or community created by Dom. Coord.'
=> 'Course or community created by Dom. Coord.',

   'Course owner (permitted to assign Course Coordinator roles in the course).'
=> 'Course owner (permitted to assign Course Coordinator roles in the course).',

   'Course portfolio files disk space'
=> 'Course portfolio files disk space',

   'Course roles'
=> 'Course roles',

   'Course section number(:LON-CAPA section)'
=> 'Course section number(:LON-CAPA section)',

   'Course section number:LON-CAPA section'
=> 'Course section number:LON-CAPA section',

   'Course sections'
=> 'Course sections',

   'Course setting'
=> 'Course setting',

   'Course settings modifiable by [_1] only.'
=> 'Course settings modifiable by [_1] only.',

   'Course settings modifiable only by [_1] for:'
=> 'Course settings modifiable only by [_1] for:',

   'Course settings that control automated enrollment in this LON-CAPA course are currently:'
=> 'Course settings that control automated enrollment in this LON-CAPA course are currently:',

   'Course settings which only a [_1] may modify.'
=> 'Course settings which only a [_1] may modify.',

   'Course status'
=> 'Course status',

   'Course syllabus'
=> 'Course syllabus',

   'Course(s): description, section(s), status'
=> 'Course(s): description, section(s), status',

   'Course, Portfolio and Catalog Search'
=> 'Course, Portfolio and Catalog Search',

   'Course/Community'
=> 'Course/Community',

   'Course/Community Catalog'
=> 'Course/Community Catalog',

   'Course/Community Creation'
=> 'Course/Community Creation',

   'Course/Community Creation Logs'
=> 'Course/Community Creation Logs',

   'Course/Community Description'
=> 'Course/Community Description',

   'Course/Community Domain'
=> 'Course/Community Domain',

   'Course/Community Level'
=> 'Course/Community Level',

   'Course/Community Management'
=> 'Course/Community Management',

   'Course/Community Request Details'
=> 'Course/Community Request Details',

   'Course/Community Requests'
=> 'Course/Community Requests',

   'Course/Community defaults'
=> 'Course/Community defaults',

   'Course/Community requests'
=> 'Course/Community requests',

   'Course/Community requests queued pending approval by a Domain Coordinator'
=> 'Course/Community requests queued pending approval by a Domain Coordinator',

   'Course/Community search'
=> 'Course/Community search',

   'Course/Community users can create/upload PDF forms'
=> 'Course/Community users can create/upload PDF forms',

   'Course/Community users can create/upload PDF forms set to "off"'
=> 'Course/Community users can create/upload PDF forms set to "off"',

   'Course/Community users can create/upload PDF forms set to "on"'
=> 'Course/Community users can create/upload PDF forms set to "on"',

   'Course/ommunity Creation'
=> 'Course/ommunity Creation',

   'CourseID'
=> 'CourseID',

   'Coursemap undefined.'
=> 'Coursemap undefined.',

   'Courses can be absent from the Catalog, because they do not have an institutional code, have no assigned category, or have been specifically excluded.'
=> 'Courses can be absent from the Catalog, because they do not have an institutional code, have no assigned category, or have been specifically excluded.',

   'Courses can be both self-cataloging, based on an institutional code (e.g., fs08phy231), or can be assigned categories from a hierarchy defined for the domain.'
=> 'Courses can be both self-cataloging, based on an institutional code (e.g., fs08phy231), or can be assigned categories from a hierarchy defined for the domain.',

   'Courses in domain with institutional code: [_1]'
=> 'Courses in domain with institutional code: [_1]',

   'Courses/Communities'
=> 'Courses/Communities',

   'Courses/Network Hits'
=> 'Courses/Network Hits',

   'Create Another Community'
=> 'Create Another Community',

   'Create Another Course'
=> 'Create Another Course',

   'Create Another Group'
=> 'Create Another Group',

   'Create Courses/Communities'
=> 'Create Courses/Communities',

   'Create Group'
=> 'Create Group',

   'Create LON-CAPA account'
=> 'Create LON-CAPA account',

   'Create Plot'
=> 'Create Plot',

   'Create Polygon Data'
=> 'Create Polygon Data',

   'Create Subdirectory'
=> 'Create Subdirectory',

   "Create User Notes, Display all User's Notes, Face-to-Face, Critical Messages, Broadcast Messages"
=> "Create User Notes, Display all User's Notes, Face-to-Face, Critical Messages, Broadcast Messages",

   'Create a New Course or Community'
=> 'Create a New Course or Community',

   'Create a New Course or Group Space'
=> 'Create a New Course or Group Space',

   'Create a New Group'
=> 'Create a New Group',

   'Create a New Slot'
=> 'Create a New Slot',

   'Create a message from file and send to users.'
=> 'Create a message from file and send to users.',

   'Create a new collaborative community by completing an online form.'
=> 'Create a new collaborative community by completing an online form.',

   'Create a new course by completing an online form.'
=> 'Create a new course by completing an online form.',

   'Create a new directory or LON-CAPA document'
=> 'Create a new directory or LON-CAPA document',

   'Create a new group'
=> 'Create a new group',

   'Create a new group space for non-course use by completing an online form.'
=> 'Create a new group space for non-course use by completing an online form.',

   'Create a new user'
=> 'Create a new user',

   'Create a single collaborative group space'
=> 'Create a single collaborative group space',

   'Create a single community'
=> 'Create a single community',

   'Create a single course'
=> 'Create a single course',

   'Create a user account in LON-CAPA'
=> 'Create a user account in LON-CAPA',

   'Create account'
=> 'Create account',

   'Create account with a username provided by this institution'
=> 'Create account with a username provided by this institution',

   'Create account with an e-mail address as your username'
=> 'Create account with an e-mail address as your username',

   'Create boards'
=> 'Create boards',

   'Create courses/communities by uploading an attributes file'
=> 'Create courses/communities by uploading an attributes file',

   'Create courses/groups by uploading an attributes file'
=> 'Create courses/groups by uploading an attributes file',

   'Create group'
=> 'Create group',

   'Create library'
=> 'Create library',

   'Create pending official courses from XML files'
=> 'Create pending official courses from XML files',

   'Create pending requests for official courses (if validated)'
=> 'Create pending requests for official courses (if validated)',

   'Create problem'
=> 'Create problem',

   'Create subdirectory in current directory'
=> 'Create subdirectory in current directory',

   'Create survey'
=> 'Create survey',

   'Create task'
=> 'Create task',

   'Create users or modify the roles and privileges of users'
=> 'Create users or modify the roles and privileges of users',

   'Create, edit, modify and publish resources'
=> 'Create, edit, modify and publish resources',

   'Create, modify and delete course groups'
=> 'Create, modify and delete course groups',

   'Create/Modify Another User'
=> 'Create/Modify Another User',

   'Create/Modify user'
=> 'Create/Modify user',

   'Create/modify a user'
=> 'Create/modify a user',

   'Created'
=> 'Created',

   'Created Courses/Communities'
=> 'Created Courses/Communities',

   'Created between'
=> 'Created between',

   'Created directory [_1]'
=> 'Created directory [_1]',

   'Created on'
=> 'Created on',

   'Creating PDF'
=> 'Creating PDF',

   'Creating a new library resource.'
=> 'Creating a new library resource.',

   'Creating a new problem resource.'
=> 'Creating a new problem resource.',

   'Creating a new survey resource.'
=> 'Creating a new survey resource.',

   'Creating a new task resource.'
=> 'Creating a new task resource.',

   'Creating new account.'
=> 'Creating new account.',

   'Creating new file [_1]'
=> 'Creating new file [_1]',

   'Creating old version [_1]'
=> 'Creating old version [_1]',

   'Creating users when a Domain Coordinator'
=> 'Creating users when a Domain Coordinator',

   'Creating users when an Author'
=> 'Creating users when an Author',

   'Creating users when in a course'
=> 'Creating users when in a course',

   'Creation Complete'
=> 'Creation Complete',

   'Creation Context'
=> 'Creation Context',

   'Creation Context:'
=> 'Creation Context:',

   'Creation Options'
=> 'Creation Options',

   'Creation Outcome'
=> 'Creation Outcome',

   'Creation and Modification dates'
=> 'Creation and Modification dates',

   'Creation failed.'
=> 'Creation failed.',

   'Creation of a LON-CAPA account with this type of e-mail address as username is not permitted.'
=> 'Creation of a LON-CAPA account with this type of e-mail address as username is not permitted.',

   'Creation of a new LON-CAPA user account using an e-mail address or an institutional log-in ID as your username is not permitted at [_1].'
=> 'Creation of a new LON-CAPA user account using an e-mail address or an institutional log-in ID as your username is not permitted at [_1].',

   'Creation of a new user account using an e-mail address as username is not permitted at this LON-CAPA institution.'
=> 'Creation of a new user account using an e-mail address as username is not permitted at this LON-CAPA institution.',

   'Creation of a new user account using an e-mail address or an institutional log-in ID as username is not permitted at this institution: ([_1]).'
=> 'Creation of a new user account using an e-mail address or an institutional log-in ID as username is not permitted at this institution: ([_1]).',

   'Creation options menu'
=> 'Creation options menu',

   'Creator'
=> 'Creator',

   'Critical'
=> 'Critical',

   'Critical Message'
=> 'Critical Message',

   'Critical only'
=> 'Critical only',

   'Cross Listed Course'
=> 'Cross Listed Course',

   'Crosslisted'
=> 'Crosslisted',

   'Crosslisted class:LON-CAPA section'
=> 'Crosslisted class:LON-CAPA section',

   'Crosslisted courses for auto-enrollment'
=> 'Crosslisted courses for auto-enrollment',

   'Crosslistings'
=> 'Crosslistings',

   'Current Access Status'
=> 'Current Access Status',

   'Current Announcement'
=> 'Current Announcement',

   'Current Password'
=> 'Current Password',

   'Current Privileges'
=> 'Current Privileges',

   'Current Tool Set'
=> 'Current Tool Set',

   'Current access'
=> 'Current access',

   'Current access controls defined for this file:'
=> 'Current access controls defined for this file:',

   'Current attempts of student (if applicable)'
=> 'Current attempts of student (if applicable)',

   'Current automated enrollment settings for:'
=> 'Current automated enrollment settings for:',

   'Current co-owners'
=> 'Current co-owners',

   'Current co-owners are:'
=> 'Current co-owners are:',

   'Current critical notification e-mail - [_1] for [_2] is different to e-mail address in institutional classlist - [_3].'
=> 'Current critical notification e-mail - [_1] for [_2] is different to e-mail address in institutional classlist - [_3].',

   'Current discussion settings'
=> 'Current discussion settings',

   'Current folder/page'
=> 'Current folder/page',

   'Current notification status'
=> 'Current notification status',

   'Current print header:'
=> 'Current print header:',

   'Current quota'
=> 'Current quota',

   'Current recipient:'
=> 'Current recipient:',

   'Current recipients:'
=> 'Current recipients:',

   'Current screen output (if applicable)'
=> 'Current screen output (if applicable)',

   'Current setting '
=> 'Current setting ',

   'Current settings are:'
=> 'Current settings are:',

   'Current standard notification e-mail - [_1] for [_2] is different to e-mail address in institutional classlist - [_3].'
=> 'Current standard notification e-mail - [_1] for [_2] is different to e-mail address in institutional classlist - [_3].',

   'Current value'
=> 'Current value',

   'Current value is'
=> 'Current value is',

   'Current value is "[_1]".'
=> 'Current value is "[_1]".',

   'Current value is [_1].'
=> 'Current value is [_1].',

   'Current value is determined by'
=> 'Current value is determined by',

   'Currently Filesystem Authenticated.'
=> 'Currently Filesystem Authenticated.',

   'Currently Has Access'
=> 'Currently Has Access',

   'Currently Kerberos authenticated with domain [_1] Version [_2].'
=> 'Currently Kerberos authenticated with domain [_1] Version [_2].',

   'Currently Kerberos authenticated, Version [_1].'
=> 'Currently Kerberos authenticated, Version [_1].',

   'Currently active communication blocks'
=> 'Currently active communication blocks',

   'Currently available actions (will open extra window)'
=> 'Currently available actions (will open extra window)',

   'Currently enabled'
=> 'Currently enabled',

   'Currently from custom setting.'
=> 'Currently from custom setting.',

   'Currently from default setting.'
=> 'Currently from default setting.',

   'Currently has access'
=> 'Currently has access',

   'Currently in use'
=> 'Currently in use',

   'Currently internally authenticated.'
=> 'Currently internally authenticated.',

   'Currently no active roles, courses or communities'
=> 'Currently no active roles, courses or communities',

   'Currently no additional roles, courses or communities'
=> 'Currently no additional roles, courses or communities',

   'Currently no co-owners.'
=> 'Currently no co-owners.',

   'Currently no documents.'
=> 'Currently no documents.',

   'Currently no sections of'
=> 'Currently no sections of',

   'Currently published version'
=> 'Currently published version',

   'Currently selected.'
=> 'Currently selected.',

   'Currently set to'
=> 'Currently set to',

   'Currently set to [_1].'
=> 'Currently set to [_1].',

   'Currently submitted: [_1]'
=> 'Currently submitted: [_1]',

   'Currently the group is configured '
=> 'Currently the group is configured ',

   'Currently using [_1] of the [_2] available.'
=> 'Currently using [_1] of the [_2] available.',

   'Currently using local (institutional) authentication.'
=> 'Currently using local (institutional) authentication.',

   'Currently: First enrollment: [_1], Last enrollment: [_2]'
=> 'Currently: First enrollment: [_1], Last enrollment: [_2]',

   'Currently: Nightly adds: [_1], Nightly drops: [_2]'
=> 'Currently: Nightly adds: [_1], Nightly drops: [_2]',

   'Currently: Notification:'
=> 'Currently: Notification:',

   'Currently: [_1].'
=> 'Currently: [_1].',

   'Currently: default first access:'
=> 'Currently: default first access:',

   'Curve Plot with Numerical Response'
=> 'Curve Plot with Numerical Response',

   'Custom Metadata fields'
=> 'Custom Metadata fields',

   'Custom Response'
=> 'Custom Response',

   'Custom Response with Partial Credit'
=> 'Custom Response with Partial Credit',

   'Custom Role'
=> 'Custom Role',

   'Custom Roles'
=> 'Custom Roles',

   'Custom Text for Course Content Option in Feedback'
=> 'Custom Text for Course Content Option in Feedback',

   'Custom Text for Course Policy Option in Feedback'
=> 'Custom Text for Course Policy Option in Feedback',

   'Custom Text for Resource Content Question Option in Feedback'
=> 'Custom Text for Resource Content Question Option in Feedback',

   'Custom bubblesheet format file error'
=> 'Custom bubblesheet format file error',

   'Custom metadata [_1]'
=> 'Custom metadata [_1]',

   'Custom quota'
=> 'Custom quota',

   'Custom role'
=> 'Custom role',

   'Custom roles'
=> 'Custom roles',

   'Custom setting'
=> 'Custom setting',

   'Custom text for '
=> 'Custom text for ',

   'Customized right of use ...'
=> 'Customized right of use ...',

   'Customrole'
=> 'Customrole',

   'Cut'
=> 'Cut',

   'Cut[_98]'
=> 'Cut[_98]',

   'Data'
=> 'Data',

   'Data Plot with Numerical Response'
=> 'Data Plot with Numerical Response',

   'Date Shift'
=> 'Date Shift',

   'Date Submitted:'
=> 'Date Submitted:',

   'Date and Section selector'
=> 'Date and Section selector',

   'Date of first automated enrollment'
=> 'Date of first automated enrollment',

   'Date of first student access'
=> 'Date of first student access',

   'Date of last automated enrollment'
=> 'Date of last automated enrollment',

   'Date of last student access'
=> 'Date of last student access',

   'Date order - newest first'
=> 'Date order - newest first',

   'Date order - oldest first'
=> 'Date order - oldest first',

   'Date range'
=> 'Date range',

   'Date range:'
=> 'Date range:',

   'Date requested'
=> 'Date requested',

   'Date selector'
=> 'Date selector',

   'Date/Time'
=> 'Date/Time',

   'Dates available'
=> 'Dates available',

   'Dates self-enrollment available'
=> 'Dates self-enrollment available',

   'Days'
=> 'Days',

   'De-select'
=> 'De-select',

   'Decline?'
=> 'Decline?',

   'Decompress [_1]?'
=> 'Decompress [_1]?',

   'Decompress complete.'
=> 'Decompress complete.',

   'Default Access Dates'
=> 'Default Access Dates',

   'Default Access Dates for Members'
=> 'Default Access Dates for Members',

   'Default Access Dates for Students'
=> 'Default Access Dates for Students',

   'Default Authentication method'
=> 'Default Authentication method',

   'Default Login Page Help File In Use'
=> 'Default Login Page Help File In Use',

   'Default Metadata for Directory [_1]'
=> 'Default Metadata for Directory [_1]',

   'Default Server Admin E-mail address'
=> 'Default Server Admin E-mail address',

   'Default access dates'
=> 'Default access dates',

   'Default authentication argument'
=> 'Default authentication argument',

   'Default authentication method'
=> 'Default authentication method',

   'Default authentication method for new users added to this domain by the automated enrollment process'
=> 'Default authentication method for new users added to this domain by the automated enrollment process',

   'Default authentication parameter'
=> 'Default authentication parameter',

   'Default authentication type'
=> 'Default authentication type',

   'Default authentication/language/timezone'
=> 'Default authentication/language/timezone',

   'Default beginning date for student access.'
=> 'Default beginning date for student access.',

   'Default bubblesheet format file error'
=> 'Default bubblesheet format file error',

   'Default color schemes'
=> 'Default color schemes',

   'Default dates for student access'
=> 'Default dates for student access',

   'Default domain'
=> 'Default domain',

   'Default end access'
=> 'Default end access',

   'Default ending date for student access.'
=> 'Default ending date for student access.',

   'Default image:'
=> 'Default image:',

   'Default in use:'
=> 'Default in use:',

   'Default language'
=> 'Default language',

   'Default locale for dates'
=> 'Default locale for dates',

   'Default now set'
=> 'Default now set',

   'Default paper type'
=> 'Default paper type',

   'Default quotas for user portfolios'
=> 'Default quotas for user portfolios',

   'Default role'
=> 'Default role',

   'Default role and section'
=> 'Default role and section',

   'Default role and/or section(s)'
=> 'Default role and/or section(s)',

   'Default section name "[_1]" is the name of a course group. Section names and group names must be distinct.'
=> 'Default section name "[_1]" is the name of a course group. Section names and group names must be distinct.',

   'Default section name [_1] could not be used as it is a reserved word.'
=> 'Default section name [_1] could not be used as it is a reserved word.',

   'Default start access'
=> 'Default start access',

   'Default start and end dates for group access'
=> 'Default start and end dates for group access',

   'Default start and end dates for member access'
=> 'Default start and end dates for member access',

   'Default start and end dates for student access'
=> 'Default start and end dates for student access',

   'Default timezone'
=> 'Default timezone',

   'Default value or none'
=> 'Default value or none',

   'Default(s) in use:'
=> 'Default(s) in use:',

   'Defaults'
=> 'Defaults',

   'Define new custom role:'
=> 'Define new custom role:',

   'Define new section'
=> 'Define new section',

   'Define new user'
=> 'Define new user',

   'Define or Edit Custom Role'
=> 'Define or Edit Custom Role',

   'Defined by [_1] at [_2].'
=> 'Defined by [_1] at [_2].',

   'Deg. Diff'
=> 'Deg. Diff',

   'Degree of Discrimination'
=> 'Degree of Discrimination',

   'Degree of discrimination'
=> 'Degree of discrimination',

   'Delete Checked Files'
=> 'Delete Checked Files',

   'Delete Directory'
=> 'Delete Directory',

   'Delete Folder'
=> 'Delete Folder',

   'Delete Messages for this Resource'
=> 'Delete Messages for this Resource',

   'Delete Photo'
=> 'Delete Photo',

   'Delete Selected'
=> 'Delete Selected',

   'Delete [_1]?'
=> 'Delete [_1]?',

   'Delete an existing group'
=> 'Delete an existing group',

   'Delete directory'
=> 'Delete directory',

   'Delete group'
=> 'Delete group',

   'Delete messages from discussion boards'
=> 'Delete messages from discussion boards',

   'Delete or move the messages to a different folder first.'
=> 'Delete or move the messages to a different folder first.',

   'Delete this resource'
=> 'Delete this resource',

   'Delete this rule'
=> 'Delete this rule',

   'Delete user roles'
=> 'Delete user roles',

   'Deleted'
=> 'Deleted',

   'Deleted Folder'
=> 'Deleted Folder',

   'Deleted Message'
=> 'Deleted Message',

   'Deleted Messages'
=> 'Deleted Messages',

   'Deleted [quant,_1,message]'
=> 'Deleted [quant,_1,message]',

   'Deleted posts will no longer be visible to you and other students'
=> 'Deleted posts will no longer be visible to you and other students',

   'Deleted posts will no longer be visible to you or anyone else.'
=> 'Deleted posts will no longer be visible to you or anyone else.',

   "Deleted role of '[_1]' in [_2] for [_3]"
=> "Deleted role of '[_1]' in [_2] for [_3]",

   'Deleted role(s) for [quant,_1,user,users,no users].'
=> 'Deleted role(s) for [quant,_1,user,users,no users].',

   'Deleted setting for [_1]'
=> 'Deleted setting for [_1]',

   'Deleting [_1] in [_2]: [_3]'
=> 'Deleting [_1] in [_2]: [_3]',

   'Deleting custom role [_1] by [_2] in [_3]'
=> 'Deleting custom role [_1] by [_2] in [_3]',

   'Deletion Complete'
=> 'Deletion Complete',

   'Deletion failed.'
=> 'Deletion failed.',

   'Deletion not permitted'
=> 'Deletion not permitted',

   'Descending'
=> 'Descending',

   'Destination folder'
=> 'Destination folder',

   'Destination folder [_1] is not a valid folder'
=> 'Destination folder [_1] is not a valid folder',

   'Detailed Citation Preview'
=> 'Detailed Citation Preview',

   'Detailed Description'
=> 'Detailed Description',

   'Detailed Display'
=> 'Detailed Display',

   'Detailed community information:'
=> 'Detailed community information:',

   'Detailed course information:'
=> 'Detailed course information:',

   'Details'
=> 'Details',

   'Differences can occur if submissions were modified using manual grading after a bubblesheet grading pass.'
=> 'Differences can occur if submissions were modified using manual grading after a bubblesheet grading pass.',

   'Different collaborative tools<br />for different members:'
=> 'Different collaborative tools<br />for different members:',

   'Different group members may receive different privileges from others for the tools they have been assigned.'
=> 'Different group members may receive different privileges from others for the tools they have been assigned.',

   'Different subsets of the chosen collaborative tools for different group members?'
=> 'Different subsets of the chosen collaborative tools for different group members?',

   'Dimension: [_1], status [_2] '
=> 'Dimension: [_1], status [_2] ',

   'Directory search available?'
=> 'Directory search available?',

   'Directory search has not been configured for domain: [_1]'
=> 'Directory search has not been configured for domain: [_1]',

   'Directory search in domain [_1] is not available for the requested search type: "[_2]"'
=> 'Directory search in domain [_1] is not available for the requested search type: "[_2]"',

   'Disable'
=> 'Disable',

   'Disable ID/Student Number Safeguard and Force Change '
=> 'Disable ID/Student Number Safeguard and Force Change ',

   'Disable Student/Employee ID Safeguard and force change of conflicting IDs'
=> 'Disable Student/Employee ID Safeguard and force change of conflicting IDs',

   'Disable WYSIWYG Editor'
=> 'Disable WYSIWYG Editor',

   'Disable WYSIWYG editor'
=> 'Disable WYSIWYG editor',

   'Disable automatically printing point values on exams'
=> 'Disable automatically printing point values on exams',

   'Disable checking of Significant Figures'
=> 'Disable checking of Significant Figures',

   'Disable member resource discussion'
=> 'Disable member resource discussion',

   'Disable member use of chat rooms'
=> 'Disable member use of chat rooms',

   'Disable student use of chat rooms'
=> 'Disable student use of chat rooms',

   'Disallow automatic updates to name information for your LON-CAPA account'
=> 'Disallow automatic updates to name information for your LON-CAPA account',

   'Disallow chat room use for Roles'
=> 'Disallow chat room use for Roles',

   'Disallow chat room use for Users'
=> 'Disallow chat room use for Users',

   'Disallow more:'
=> 'Disallow more:',

   'Disallowed:'
=> 'Disallowed:',

   'Discard Edits and Return to Portfolio'
=> 'Discard Edits and Return to Portfolio',

   'Discontinue?'
=> 'Discontinue?',

   'Discussion'
=> 'Discussion',

   'Discussion Board'
=> 'Discussion Board',

   'Discussion Board Title'
=> 'Discussion Board Title',

   'Discussion Boards'
=> 'Discussion Boards',

   'Discussion Boards Folder created.'
=> 'Discussion Boards Folder created.',

   'Discussion Display'
=> 'Discussion Display',

   'Discussion End Time'
=> 'Discussion End Time',

   'Discussion End Time (discussend)'
=> 'Discussion End Time (discussend)',

   'Discussion Post Attachments'
=> 'Discussion Post Attachments',

   'Discussion Settings'
=> 'Discussion Settings',

   'Discussion and Chat'
=> 'Discussion and Chat',

   'Discussion and message records for [_1] ([_2])'
=> 'Discussion and message records for [_1] ([_2])',

   'Discussion display options'
=> 'Discussion display options',

   'Discussion for'
=> 'Discussion for',

   'Discussion options'
=> 'Discussion options',

   'Discussion posts'
=> 'Discussion posts',

   'Discussion posts in this course will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Discussion posts in this course will be inaccessible between [_1] and [_2] because communication is being blocked.',

   'Disk Quota'
=> 'Disk Quota',

   'Disk Use (%)'
=> 'Disk Use (%)',

   'Disk quota'
=> 'Disk quota',

   'Disk space allocated to portfolio files'
=> 'Disk space allocated to portfolio files',

   "Disk space allocated to user's portfolio files"
=> "Disk space allocated to user's portfolio files",

   'Disk space for storage of group portfolio files for:'
=> 'Disk space for storage of group portfolio files for:',

   'Disk usage [_1] exceeds the quota for this community.'
=> 'Disk usage [_1] exceeds the quota for this community.',

   'Display &quot;Submit a bug&quot; link?'
=> 'Display &quot;Submit a bug&quot; link?',

   'Display Actions'
=> 'Display Actions',

   "Display Administrator's E-mail Address?"
=> "Display Administrator's E-mail Address?",

   'Display Broadcast e-mail'
=> 'Display Broadcast e-mail',

   'Display Categories'
=> 'Display Categories',

   'Display Course/Community Catalog link?'
=> 'Display Course/Community Catalog link?',

   'Display Critical Messages'
=> 'Display Critical Messages',

   'Display Detailed Report'
=> 'Display Detailed Report',

   'Display Direction'
=> 'Display Direction',

   'Display Groups'
=> 'Display Groups',

   'Display List of Users'
=> 'Display List of Users',

   'Display Message'
=> 'Display Message',

   'Display Metadata Keywords'
=> 'Display Metadata Keywords',

   'Display Options'
=> 'Display Options',

   'Display Pending Queue'
=> 'Display Pending Queue',

   'Display Preference'
=> 'Display Preference',

   'Display Requests'
=> 'Display Requests',

   'Display User Lists'
=> 'Display User Lists',

   'Display [_1] Most Recent Courses.'
=> 'Display [_1] Most Recent Courses.',

   'Display [_1] Most Recent Roles.'
=> 'Display [_1] Most Recent Roles.',

   'Display a Message'
=> 'Display a Message',

   'Display a histogram of student performance in the course.'
=> 'Display a histogram of student performance in the course.',

   "Display a user's personal information page"
=> "Display a user's personal information page",

   'Display all access settings for this file'
=> 'Display all access settings for this file',

   'Display all versions'
=> 'Display all versions',

   'Display catalog of courses and communities'
=> 'Display catalog of courses and communities',

   'Display communities'
=> 'Display communities',

   'Display course and community creation requests submitted by authorized users, held pending approval by a Domain Coordinator.'
=> 'Display course and community creation requests submitted by authorized users, held pending approval by a Domain Coordinator.',

   'Display courses'
=> 'Display courses',

   'Display current class roster'
=> 'Display current class roster',

   'Display current settings for automated enrollment'
=> 'Display current settings for automated enrollment',

   'Display e-mail'
=> 'Display e-mail',

   'Display e-mail sent by Domain Coordinators in this domain'
=> 'Display e-mail sent by Domain Coordinators in this domain',

   'Display file listing'
=> 'Display file listing',

   'Display information about official [_1] classes for which LON-CAPA courses have been created:'
=> 'Display information about official [_1] classes for which LON-CAPA courses have been created:',

   'Display information about when, how and by whom courses and communities were created in this domain.'
=> 'Display information about when, how and by whom courses and communities were created in this domain.',

   'Display listing of contents in a new folder, with folder name:'
=> 'Display listing of contents in a new folder, with folder name:',

   'Display members with current/future access who are not in the uploaded file'
=> 'Display members with current/future access who are not in the uploaded file',

   'Display of Scientific Equations'
=> 'Display of Scientific Equations',

   'Display of a student-viewable course roster is not currently enabled.'
=> 'Display of a student-viewable course roster is not currently enabled.',

   'Display of options when printed'
=> 'Display of options when printed',

   'Display of resources '
=> 'Display of resources ',

   'Display of your name in the student-viewable roster set to <b>[_1]</b>.'
=> 'Display of your name in the student-viewable roster set to <b>[_1]</b>.',

   'Display of your name in the student-viewable roster unchanged (set to <b>[_1]</b>).'
=> 'Display of your name in the student-viewable roster unchanged (set to <b>[_1]</b>).',

   'Display official course requests submitted by authorized users, held pending validation of instructor status.'
=> 'Display official course requests submitted by authorized users, held pending validation of instructor status.',

   'Display options'
=> 'Display options',

   'Display sent e-mails'
=> 'Display sent e-mails',

   'Display settings'
=> 'Display settings',

   'Display students with current/future access who are not in the uploaded file'
=> 'Display students with current/future access who are not in the uploaded file',

   'Display students with current/future access who are not in the uploaded file.'
=> 'Display students with current/future access who are not in the uploaded file.',

   "Display the What's New Page"
=> "Display the What's New Page",

   "Display the [_1]What's New Page[_2] - a summary of items in the course which require attention."
=> "Display the [_1]What's New Page[_2] - a summary of items in the course which require attention.",

   'Display the [_1]first resource[_2] in the course.'
=> 'Display the [_1]first resource[_2] in the course.',

   'Display using: '
=> 'Display using: ',

   'Display/Edit Settings'
=> 'Display/Edit Settings',

   'Displayed Part Description:'
=> 'Displayed Part Description:',

   'Displaying Critical Messages'
=> 'Displaying Critical Messages',

   'Distribute from Uploaded File'
=> 'Distribute from Uploaded File',

   'Do <b>not</b> use this form to ask questions about course content.'
=> 'Do <b>not</b> use this form to ask questions about course content.',

   'Do not clone date parameters'
=> 'Do not clone date parameters',

   'Do not display'
=> 'Do not display',

   'Do not show plain URL'
=> 'Do not show plain URL',

   'Do only previously skipped records'
=> 'Do only previously skipped records',

   'Do you have any guesses why this might have happened?'
=> 'Do you have any guesses why this might have happened?',

   'DocID'
=> 'DocID',

   'Document'
=> 'Document',

   'Documents, pages, and folders'
=> 'Documents, pages, and folders',

   'Domain - [_1]:'
=> 'Domain - [_1]:',

   'Domain Configuration'
=> 'Domain Configuration',

   'Domain Coordinator status'
=> 'Domain Coordinator status',

   'Domain Logo'
=> 'Domain Logo',

   'Domain Management'
=> 'Domain Management',

   'Domain Roles'
=> 'Domain Roles',

   'Domain Settings'
=> 'Domain Settings',

   'Domain Status'
=> 'Domain Status',

   'Domain does not exist'
=> 'Domain does not exist',

   'Domain status'
=> 'Domain status',

   'Domain/institution to search'
=> 'Domain/institution to search',

   'Domains'
=> 'Domains',

   'Domains: '
=> 'Domains: ',

   "Don't Show Any Feedback"
=> "Don't Show Any Feedback",

   "Don't Show Incorect/Correct Feedback"
=> "Don't Show Incorect/Correct Feedback",

   "Don't show option list"
=> "Don't show option list",

   'Done compiling spreadsheet. See link below to download.'
=> 'Done compiling spreadsheet. See link below to download.',

   'Done compiling text file. See link below to download.'
=> 'Done compiling text file. See link below to download.',

   'Download'
=> 'Download',

   'Download All Submitted Documents'
=> 'Download All Submitted Documents',

   'Download a scoring office file'
=> 'Download a scoring office file',

   'Download the zip file from'
=> 'Download the zip file from',

   'Download the zip file from [_1]Discussion Posting Archive'
=> 'Download the zip file from [_1]Discussion Posting Archive',

   'Download your Calendar as iCalendar File'
=> 'Download your Calendar as iCalendar File',

   'Download: Show List of Associated Files'
=> 'Download: Show List of Associated Files',

   'DragMath LaTeX Equation Editor'
=> 'DragMath LaTeX Equation Editor',

   'Drop Box'
=> 'Drop Box',

   'Drop Members'
=> 'Drop Members',

   'Drop from classlist: [_1]'
=> 'Drop from classlist: [_1]',

   'Drop unregistered students automatically'
=> 'Drop unregistered students automatically',

   'Dropped [quant,_1,student].'
=> 'Dropped [quant,_1,student].',

   'Dropped reservation'
=> 'Dropped reservation',

   "Dropped role of '[_1]' in [_2] for [_3]"
=> "Dropped role of '[_1]' in [_2] for [_3]",

   'Dropped role(s) for [quant,_1,user,users,no users].'
=> 'Dropped role(s) for [quant,_1,user,users,no users].',

   'Due and Answer Available'
=> 'Due and Answer Available',

   'Due date: [_1]'
=> 'Due date: [_1]',

   'Duedate'
=> 'Duedate',

   'Dump Community Documents'
=> 'Dump Community Documents',

   'Dump Course Documents'
=> 'Dump Course Documents',

   'Dump Course Documents to Construction Space'
=> 'Dump Course Documents to Construction Space',

   'Dump Course Documents to Construction Space: available on other servers'
=> 'Dump Course Documents to Construction Space: available on other servers',

   'Duration'
=> 'Duration',

   'E-mail'
=> 'E-mail',

   'E-mail address in LON-CAPA'
=> 'E-mail address in LON-CAPA',

   'E-mail address(es) which should be notified about new LON-CAPA messages'
=> 'E-mail address(es) which should be notified about new LON-CAPA messages',

   'E-mail display'
=> 'E-mail display',

   'E-mail from course requests requiring approval'
=> 'E-mail from course requests requiring approval',

   'E-mail from nightly status check (warnings/errors)'
=> 'E-mail from nightly status check (warnings/errors)',

   'E-mail notification of LON-CAPA messages'
=> 'E-mail notification of LON-CAPA messages',

   'Each PDF contains exactly one assignment'
=> 'Each PDF contains exactly one assignment',

   'Each PDF contains exactly one section'
=> 'Each PDF contains exactly one section',

   'Each collaborative tool includes core privileges assigned to all members with access to the tool. Some tools may also feature additional privileges which can be set for specific members.'
=> 'Each collaborative tool includes core privileges assigned to all members with access to the tool. Some tools may also feature additional privileges which can be set for specific members.',

   'Each of the[_1] [quant,_2,message] [_3]you checked will be forwarded to the recipient(s) you select below.'
=> 'Each of the[_1] [quant,_2,message] [_3]you checked will be forwarded to the recipient(s) you select below.',

   'Each post can be toggled read/unread'
=> 'Each post can be toggled read/unread',

   'Earlier version(s) were posted on: '
=> 'Earlier version(s) were posted on: ',

   'Earliest to display:'
=> 'Earliest to display:',

   'Edit Answer'
=> 'Edit Answer',

   'Edit Course Configuration'
=> 'Edit Course Configuration',

   'Edit Course Environment'
=> 'Edit Course Environment',

   'Edit Custom Roles'
=> 'Edit Custom Roles',

   'Edit Directory Metadata'
=> 'Edit Directory Metadata',

   'Edit Group Homepage'
=> 'Edit Group Homepage',

   'Edit Group Portfolio File Metadata'
=> 'Edit Group Portfolio File Metadata',

   'Edit Group Settings'
=> 'Edit Group Settings',

   'Edit Math'
=> 'Edit Math',

   'Edit Metadata'
=> 'Edit Metadata',

   'Edit Portfolio File Metadata'
=> 'Edit Portfolio File Metadata',

   'Edit Resource Parameters - Helper Mode'
=> 'Edit Resource Parameters - Helper Mode',

   'Edit Resource Parameters - Overview Mode'
=> 'Edit Resource Parameters - Overview Mode',

   'Edit Resource Parameters - Table Mode'
=> 'Edit Resource Parameters - Table Mode',

   'Edit [_1] board'
=> 'Edit [_1] board',

   'Edit action'
=> 'Edit action',

   'Edit any group in the course'
=> 'Edit any group in the course',

   'Edit blogs, RSS feeds, and podcasts'
=> 'Edit blogs, RSS feeds, and podcasts',

   'Edit course contents'
=> 'Edit course contents',

   'Edit custom role'
=> 'Edit custom role',

   'Edit environment settings for this course.'
=> 'Edit environment settings for this course.',

   'Edit information about yourself that should be displayed on your public profile.'
=> 'Edit information about yourself that should be displayed on your public profile.',

   'Edit own posts'
=> 'Edit own posts',

   'Edit the Personal Information Page'
=> 'Edit the Personal Information Page',

   'Edit the meta data'
=> 'Edit the meta data',

   'EditXML [_1]'
=> 'EditXML [_1]',

   'Editing Help'
=> 'Editing Help',

   'Editing not permitted'
=> 'Editing not permitted',

   'Editing the Table of Contents for your Course'
=> 'Editing the Table of Contents for your Course',

   'Effect'
=> 'Effect',

   'Empty tags'
=> 'Empty tags',

   'Enable'
=> 'Enable',

   'Enable Recent Courses Hotlist'
=> 'Enable Recent Courses Hotlist',

   'Enable Recent Roles Hotlist'
=> 'Enable Recent Roles Hotlist',

   'Enable WYSIWYG Editor'
=> 'Enable WYSIWYG Editor',

   'Enable WYSIWYG editor'
=> 'Enable WYSIWYG editor',

   'Enable or disable the WYSIWYG-Editor.'
=> 'Enable or disable the WYSIWYG-Editor.',

   'Enable/disable automatic group enrollment for users in specified roles and sections'
=> 'Enable/disable automatic group enrollment for users in specified roles and sections',

   'Encrypt URL:'
=> 'Encrypt URL:',

   'End Date'
=> 'End Date',

   'End auto-enrollment'
=> 'End auto-enrollment',

   'End date'
=> 'End date',

   'End date:'
=> 'End date:',

   'End of Sequence'
=> 'End of Sequence',

   'End: '
=> 'End: ',

   'Ended: [_1]'
=> 'Ended: [_1]',

   'Ends'
=> 'Ends',

   'Ends: [_1]'
=> 'Ends: [_1]',

   'Enroll Another Member'
=> 'Enroll Another Member',

   'Enroll Another Student'
=> 'Enroll Another Student',

   'Enroll Member'
=> 'Enroll Member',

   'Enroll Student'
=> 'Enroll Student',

   'Enroll a student'
=> 'Enroll a student',

   'Enroll another student'
=> 'Enroll another student',

   'Enroll in course'
=> 'Enroll in course',

   'Enroll one member'
=> 'Enroll one member',

   'Enroll one member: '
=> 'Enroll one member: ',

   'Enroll one student: '
=> 'Enroll one student: ',

   'Enrolling Member'
=> 'Enrolling Member',

   'Enrolling Users'
=> 'Enrolling Users',

   'Enrollment'
=> 'Enrollment',

   'Enrollment Ends'
=> 'Enrollment Ends',

   'Enrollment Requests'
=> 'Enrollment Requests',

   'Enrollment Starts'
=> 'Enrollment Starts',

   'Enrollment in the following course: [_1] was requested by [_2] on [_3].'
=> 'Enrollment in the following course: [_1] was requested by [_2] on [_3].',

   'Enrollment incomplete'
=> 'Enrollment incomplete',

   'Enrollment limit'
=> 'Enrollment limit',

   'Enrollment process complete'
=> 'Enrollment process complete',

   'Enrollment request processing'
=> 'Enrollment request processing',

   'Enrollment requests'
=> 'Enrollment requests',

   'Enrollment requests in the following course: [_1] have been processed.'
=> 'Enrollment requests in the following course: [_1] have been processed.',

   'Enrollment requests pending Course Coordinator approval'
=> 'Enrollment requests pending Course Coordinator approval',

   'Enrollment result'
=> 'Enrollment result',

   'Enter Access Key to Unlock this Course'
=> 'Enter Access Key to Unlock this Course',

   'Enter Coordinate or click finish to close Polygon'
=> 'Enter Coordinate or click finish to close Polygon',

   'Enter Coordinates'
=> 'Enter Coordinates',

   'Enter Course'
=> 'Enter Course',

   'Enter New Login Data'
=> 'Enter New Login Data',

   'Enter a file name: '
=> 'Enter a file name: ',

   'Enter a maximum of [quant,_1,collaborator] using username or username:domain, e.g. smithje or smithje:[_2].'
=> 'Enter a maximum of [quant,_1,collaborator] using username or username:domain, e.g. smithje or smithje:[_2].',

   'Enter a specific section, or leave blank for no section.'
=> 'Enter a specific section, or leave blank for no section.',

   'Enter a specific section.'
=> 'Enter a specific section.',

   'Enter an existing group'
=> 'Enter an existing group',

   'Enter any group in the course'
=> 'Enter any group in the course',

   'Enter as many fields as you can.<br /> The system will inform you and bring you back to this page, <br /> if the data selected are insufficient to add users.'
=> 'Enter as many fields as you can.<br /> The system will inform you and bring you back to this page, <br /> if the data selected are insufficient to add users.',

   'Enter construction space as assistant co-author'
=> 'Enter construction space as assistant co-author',

   'Enter construction space as co-author'
=> 'Enter construction space as co-author',

   'Enter course'
=> 'Enter course',

   'Enter course now'
=> 'Enter course now',

   'Enter course title'
=> 'Enter course title',

   'Enter institutional course code'
=> 'Enter institutional course code',

   'Enter my construction space'
=> 'Enter my construction space',

   'Enter my groups in the course'
=> 'Enter my groups in the course',

   'Enter response device ("clicker") numbers'
=> 'Enter response device ("clicker") numbers',

   'Enter terms or phrases, then press "Search" below'
=> 'Enter terms or phrases, then press "Search" below',

   'Enter the chat room for the course'
=> 'Enter the chat room for the course',

   'Enter the community with the role of [_1]'
=> 'Enter the community with the role of [_1]',

   'Enter the community with the role of [_1].'
=> 'Enter the community with the role of [_1].',

   'Enter the course with the role of [_1]'
=> 'Enter the course with the role of [_1]',

   'Enter the course with the role of [_1].'
=> 'Enter the course with the role of [_1].',

   'Enter the username you use to log-in to LON-CAPA'
=> 'Enter the username you use to log-in to LON-CAPA',

   'Enter the username you use to log-in to LON-CAPA, and your domain.'
=> 'Enter the username you use to log-in to LON-CAPA, and your domain.',

   "Enter user:domain for User's Personal Information Page"
=> "Enter user:domain for User's Personal Information Page",

   'Enter words and quoted phrases'
=> 'Enter words and quoted phrases',

   'Entering Course'
=> 'Entering Course',

   'Entering [_1]'
=> 'Entering [_1]',

   'Entering [_1] ...'
=> 'Entering [_1] ...',

   'Error - could not obtain lock on message folders record.'
=> 'Error - could not obtain lock on message folders record.',

   'Error activating [_1] in [_2] for [_3]: [_4].'
=> 'Error activating [_1] in [_2] for [_3]: [_4].',

   'Error changing access dates for [_1] in [_2] for [_3]: [_4].'
=> 'Error changing access dates for [_1] in [_2] for [_3]: [_4].',

   'Error changing section for [_1] in [_2] for [_3]: [_4].'
=> 'Error changing section for [_1] in [_2] for [_3]: [_4].',

   'Error clearing messages'
=> 'Error clearing messages',

   'Error copying file attachment - [_1] to IMS package'
=> 'Error copying file attachment - [_1] to IMS package',

   'Error copying file attachment - [_1] to IMS package: '
=> 'Error copying file attachment - [_1] to IMS package: ',

   'Error creating token.'
=> 'Error creating token.',

   'Error deleting [_1] in [_2] for [_3]: [_4].'
=> 'Error deleting [_1] in [_2] for [_3]: [_4].',

   'Error deleting messages'
=> 'Error deleting messages',

   'Error dropping [_1] in [_2] for [_3]: [_4].'
=> 'Error dropping [_1] in [_2] for [_3]: [_4].',

   'Error getting student data ([_1])'
=> 'Error getting student data ([_1])',

   'Error in instructor specifed unit. This error has been reported to the instructor.'
=> 'Error in instructor specifed unit. This error has been reported to the instructor.',

   'Error occurred saving display setting.'
=> 'Error occurred saving display setting.',

   'Error occurred saving new values in metadata table in LON-CAPA database!'
=> 'Error occurred saving new values in metadata table in LON-CAPA database!',

   'Error re-enabling [_1] in [_2] for [_3]: [_4].'
=> 'Error re-enabling [_1] in [_2] for [_3]: [_4].',

   'Error reading community contents.'
=> 'Error reading community contents.',

   'Error reading contents of parent folder.'
=> 'Error reading contents of parent folder.',

   'Error reports to be e-mailed to'
=> 'Error reports to be e-mailed to',

   'Error retrieving community contents'
=> 'Error retrieving community contents',

   'Error retrieving file information.'
=> 'Error retrieving file information.',

   'Error revoking [_1] in [_2] for [_3]: [_4].'
=> 'Error revoking [_1] in [_2] for [_3]: [_4].',

   'Error saving updated parent folder.'
=> 'Error saving updated parent folder.',

   'Error sending message to'
=> 'Error sending message to',

   'Error sending message to [_1], no domain specified.'
=> 'Error sending message to [_1], no domain specified.',

   'Error sending message to [_1], no user specified.'
=> 'Error sending message to [_1], no user specified.',

   'Error uploading new folder.'
=> 'Error uploading new folder.',

   'Error: '
=> 'Error: ',

   'Error: "[_1]" during classlist update for "[_2]" in "[_3]".'
=> 'Error: "[_1]" during classlist update for "[_2]" in "[_3]".',

   'Error: [_1]'
=> 'Error: [_1]',

   'Error: could not determine domain or number of course'
=> 'Error: could not determine domain or number of course',

   'Error: invalid community domain or number - group folder creation failed.'
=> 'Error: invalid community domain or number - group folder creation failed.',

   'Error: invalid course domain or number - group folder creation failed.'
=> 'Error: invalid course domain or number - group folder creation failed.',

   'Error: no directory name was provided.'
=> 'Error: no directory name was provided.',

   'Error: no valid filename was provided to rename to.'
=> 'Error: no valid filename was provided to rename to.',

   'Error: you must have a course role selected to be able to send a broadcast message to a group in the course.'
=> 'Error: you must have a course role selected to be able to send a broadcast message to a group in the course.',

   'Essay Response'
=> 'Essay Response',

   'Essay is [_1]% similar to an essay by [_2] in course [_3] (course id [_4]:[_5])'
=> 'Essay is [_1]% similar to an essay by [_2] in course [_3] (course id [_4]:[_5])',

   'Essay was found to be similar to another essay submitted for this assignment.'
=> 'Essay was found to be similar to another essay submitted for this assignment.',

   'Essay will be hand graded.'
=> 'Essay will be hand graded.',

   'Evade communication blocking'
=> 'Evade communication blocking',

   'Evaluation: Clear'
=> 'Evaluation: Clear',

   'Evaluation: Material has Depth'
=> 'Evaluation: Material has Depth',

   'Evaluation: Material is Correct'
=> 'Evaluation: Material is Correct',

   'Evaluation: Material is Helpful'
=> 'Evaluation: Material is Helpful',

   'Evaluation: Technically Correct'
=> 'Evaluation: Technically Correct',

   'Even larger than normal'
=> 'Even larger than normal',

   'Event'
=> 'Event',

   'Event from [_1] to [_2]'
=> 'Event from [_1] to [_2]',

   'Everyone can participate in chat room.'
=> 'Everyone can participate in chat room.',

   'Exact match'
=> 'Exact match',

   'Exam'
=> 'Exam',

   'Exam Upload Resource'
=> 'Exam Upload Resource',

   'Exam proctors'
=> 'Exam proctors',

   'Example'
=> 'Example',

   'Example: "<tt>st:001,st:002,in,cc</tt>" would permit students in sections 001 and 002 and instructors in any section, and course coordinators to edit their own posts.'
=> 'Example: "<tt>st:001,st:002,in,cc</tt>" would permit students in sections 001 and 002 and instructors in any section, and course coordinators to edit their own posts.',

   'Examples'
=> 'Examples',

   'Excerpt'
=> 'Excerpt',

   'Excerpt retains HTML tags in message'
=> 'Excerpt retains HTML tags in message',

   'Exclude from community catalog'
=> 'Exclude from community catalog',

   'Exclude from course catalog'
=> 'Exclude from course catalog',

   'Exclude from course catalog:'
=> 'Exclude from course catalog:',

   'Excluded from community catalog'
=> 'Excluded from community catalog',

   'Excluded from course catalog'
=> 'Excluded from course catalog',

   'Executive'
=> 'Executive',

   'Existing Co-Author Roles in your Construction Space'
=> 'Existing Co-Author Roles in your Construction Space',

   'Existing Parameter Settings for Resources'
=> 'Existing Parameter Settings for Resources',

   'Existing Parameter Settings for Your Resources'
=> 'Existing Parameter Settings for Your Resources',

   'Existing Role'
=> 'Existing Role',

   'Existing Roles'
=> 'Existing Roles',

   'Existing Roles in this Community'
=> 'Existing Roles in this Community',

   'Existing Roles in this Course'
=> 'Existing Roles in this Course',

   'Existing Roles in this Domain'
=> 'Existing Roles in this Domain',

   'Existing control(s) deleted'
=> 'Existing control(s) deleted',

   'Existing control(s) modified'
=> 'Existing control(s) modified',

   'Existing courses can be cloned when creating new courses. Cloning will copy the course structure, contents, and most parameters (automatically advancing any date parameters by six months). Usernames of owners of other courses permitted to clone this course:'
=> 'Existing courses can be cloned when creating new courses. Cloning will copy the course structure, contents, and most parameters (automatically advancing any date parameters by six months). Usernames of owners of other courses permitted to clone this course:',

   'Existing sections'
=> 'Existing sections',

   'Expire'
=> 'Expire',

   'Expired'
=> 'Expired',

   'Expired access status.'
=> 'Expired access status.',

   'Expired after logout.'
=> 'Expired after logout.',

   'Export'
=> 'Export',

   'Export Course to IMS Package'
=> 'Export Course to IMS Package',

   'Export content item?'
=> 'Export content item?',

   'Export discussion posts?'
=> 'Export discussion posts?',

   'External Resource, preview not enabled'
=> 'External Resource, preview not enabled',

   'External: shows number of completed parts and totals'
=> 'External: shows number of completed parts and totals',

   'External: shows only number of completed parts'
=> 'External: shows only number of completed parts',

   'Extra space<br />before selected'
=> 'Extra space<br />before selected',

   'Failed to copy old target'
=> 'Failed to copy old target',

   'Failed to delete [quant,_1,message]'
=> 'Failed to delete [quant,_1,message]',

   'Failed to delete the message.'
=> 'Failed to delete the message.',

   'Failed to move [quant,_1,message]'
=> 'Failed to move [quant,_1,message]',

   'Failed to write old metadata copy'
=> 'Failed to write old metadata copy',

   'Feedback Mode:'
=> 'Feedback Mode:',

   'Feedback Settings'
=> 'Feedback Settings',

   'Feedback messages'
=> 'Feedback messages',

   'Feedback sent'
=> 'Feedback sent',

   'Feedback to resource author'
=> 'Feedback to resource author',

   'Field Name'
=> 'Field Name',

   'Field Value(s)'
=> 'Field Value(s)',

   'File Dialogs'
=> 'File Dialogs',

   'File Size (Bytes)'
=> 'File Size (Bytes)',

   'File Submission'
=> 'File Submission',

   'File Type'
=> 'File Type',

   'File Type Displayed: [_1]'
=> 'File Type Displayed: [_1]',

   'File [_1] already exists.'
=> 'File [_1] already exists.',

   'File [_1] could not be copied.'
=> 'File [_1] could not be copied.',

   'File access type: '
=> 'File access type: ',

   'File does not have [_1] or [_2] ending tag'
=> 'File does not have [_1] or [_2] ending tag',

   'File does not have [_1] or [_2] starting tag'
=> 'File does not have [_1] or [_2] starting tag',

   'File does not have [_1] ending tag'
=> 'File does not have [_1] ending tag',

   'File not found: [_1]'
=> 'File not found: [_1]',

   'File quota'
=> 'File quota',

   'File to upload'
=> 'File to upload',

   'File to upload: [_1]'
=> 'File to upload: [_1]',

   'File: [_1] deleted.'
=> 'File: [_1] deleted.',

   'Filename of bubblesheet data file:'
=> 'Filename of bubblesheet data file:',

   'Filename of resource'
=> 'Filename of resource',

   'Filename of resource contains internal version number. Cannot publish such resources, FAIL'
=> 'Filename of resource contains internal version number. Cannot publish such resources, FAIL',

   'Filename of scoring office file:'
=> 'Filename of scoring office file:',

   'Filename of scoring office file: [_1]'
=> 'Filename of scoring office file: [_1]',

   'Files'
=> 'Files',

   'Files selected from other directories:'
=> 'Files selected from other directories:',

   'Files: [_1]'
=> 'Files: [_1]',

   'Filesystem (UNIX)'
=> 'Filesystem (UNIX)',

   'Fill out one of the forms below'
=> 'Fill out one of the forms below',

   'Filter [_1]'
=> 'Filter [_1]',

   'Filters'
=> 'Filters',

   'Finalize Grading'
=> 'Finalize Grading',

   'Finalize order of resources'
=> 'Finalize order of resources',

   'Finish'
=> 'Finish',

   'Finish Import'
=> 'Finish Import',

   'Finished!'
=> 'Finished!',

   'Fixed'
=> 'Fixed',

   'Fixed privileges'
=> 'Fixed privileges',

   'Floating Point'
=> 'Floating Point',

   'Floating Point between 1 and 0'
=> 'Floating Point between 1 and 0',

   'Floating point number'
=> 'Floating point number',

   'Floating point number between zero and one'
=> 'Floating point number between zero and one',

   'Foil Name'
=> 'Foil Name',

   'Foil Text'
=> 'Foil Text',

   'Foil name [_1] appears more than once. Foil names need to be unique.'
=> 'Foil name [_1] appears more than once. Foil names need to be unique.',

   'Foils without names exist. This can cause problems to malfunction.'
=> 'Foils without names exist. This can cause problems to malfunction.',

   'Folder "[_1]" created.'
=> 'Folder "[_1]" created.',

   'Folder "[_1]" deleted.'
=> 'Folder "[_1]" deleted.',

   'Folder "[_1]" renamed to "[_2]".'
=> 'Folder "[_1]" renamed to "[_2]".',

   'Folders: [_1]'
=> 'Folders: [_1]',

   'Font Color'
=> 'Font Color',

   'Font Menu'
=> 'Font Menu',

   'Font Menu Color'
=> 'Font Menu Color',

   'Font Size'
=> 'Font Size',

   'Font color'
=> 'Font color',

   'Footnote Size'
=> 'Footnote Size',

   'For User [_1] or Student/Employee ID [_2] at Domain [_3]'
=> 'For User [_1] or Student/Employee ID [_2] at Domain [_3]',

   'For a community role that is not "member", users may have roles in more than one section at a time.'
=> 'For a community role that is not "member", users may have roles in more than one section at a time.',

   'For a course role that is not "student", users may have roles in more than one section at a time.'
=> 'For a course role that is not "student", users may have roles in more than one section at a time.',

   'For a role in a course that is not a student role, a user may have roles in more than one section of a course at a time.'
=> 'For a role in a course that is not a student role, a user may have roles in more than one section of a course at a time.',

   'For each collaborative tool you have chosen to include, there is a set of core privileges which all group members assigned use of the tool will receive.'
=> 'For each collaborative tool you have chosen to include, there is a set of core privileges which all group members assigned use of the tool will receive.',

   "For logged in users a 'Display file listing' link will also appear (when there are Viewable files) on your personal information page:"
=> "For logged in users a 'Display file listing' link will also appear (when there are Viewable files) on your personal information page:",

   "For logged in users a 'Display file listing' link will also appear (when there are viewable files) on your personal information page:"
=> "For logged in users a 'Display file listing' link will also appear (when there are viewable files) on your personal information page:",

   'For member roles, changing the section will result in a section switch, as members may only be in one section of a community at a time.'
=> 'For member roles, changing the section will result in a section switch, as members may only be in one section of a community at a time.',

   'For some tools there are also additional optional privileges which can be set.'
=> 'For some tools there are also additional optional privileges which can be set.',

   'For student roles changing the section, will result in a section switch as students may only be in one section of a course at a time.'
=> 'For student roles changing the section, will result in a section switch as students may only be in one section of a course at a time.',

   'For student roles, changing the section will result in a section switch as students may only be in one section of a course at a time.'
=> 'For student roles, changing the section will result in a section switch as students may only be in one section of a course at a time.',

   'For the collaborative tools included for group members being added or modified, there are no optional privileges to set for specific members.'
=> 'For the collaborative tools included for group members being added or modified, there are no optional privileges to set for specific members.',

   'For the collaborative tools you have chosen to include only core privileges are available, so there are no optional privileges to assign.'
=> 'For the collaborative tools you have chosen to include only core privileges are available, so there are no optional privileges to assign.',

   'For the following course/community requests an error occurred when removing requests for the following from the pending queue:'
=> 'For the following course/community requests an error occurred when removing requests for the following from the pending queue:',

   "For the following course/community requests an error occurred when updating the requestor's own requests record:"
=> "For the following course/community requests an error occurred when updating the requestor's own requests record:",

   'For the following requests, the requestor could [_1]not[_2] be validated as official course personnel, so the request remains in the pending queue.'
=> 'For the following requests, the requestor could [_1]not[_2] be validated as official course personnel, so the request remains in the pending queue.',

   "For the following users, an error occurred when updating the user's own self-enroll requests record:"
=> "For the following users, an error occurred when updating the user's own self-enroll requests record:",

   'For this user, the default quota is [_1] Mb.'
=> 'For this user, the default quota is [_1] Mb.',

   "For this user, the default quota of [_1] Mb, is determined by the user's institutional affiliation ([_2])."
=> "For this user, the default quota of [_1] Mb, is determined by the user's institutional affiliation ([_2]).",

   'For this user, the default quota would be [_1]'
=> 'For this user, the default quota would be [_1]',

   "For this user, the default quota would be [_1] Mb, as determined by the user's institutional affiliation ([_2])."
=> "For this user, the default quota would be [_1] Mb, as determined by the user's institutional affiliation ([_2]).",

   'For this user, the default quota would be [_1] Mb.'
=> 'For this user, the default quota would be [_1] Mb.',

   'Force all students in the course to use a specific math rendering engine.'
=> 'Force all students in the course to use a specific math rendering engine.',

   'Force use of a specific math rendering engine'
=> 'Force use of a specific math rendering engine',

   'Forgot password?'
=> 'Forgot password?',

   'Format for display of score'
=> 'Format for display of score',

   'Format for display of score (scoreformat)'
=> 'Format for display of score (scoreformat)',

   "Format for users' username:domain information:"
=> "Format for users' username:domain information:",

   'Format of bubblesheet data file:'
=> 'Format of bubblesheet data file:',

   'Format of data file:'
=> 'Format of data file:',

   'Format of the print job'
=> 'Format of the print job',

   'Format rule type'
=> 'Format rule type',

   'Format rules in force'
=> 'Format rules in force',

   'Former Member'
=> 'Former Member',

   'Formula Response using Computer Algebra System'
=> 'Formula Response using Computer Algebra System',

   'Formula Response using Computer Algebra System R and Data Plot'
=> 'Formula Response using Computer Algebra System R and Data Plot',

   'Formula Response using Computer Algebra System and Hints'
=> 'Formula Response using Computer Algebra System and Hints',

   'Formula Response with Samples'
=> 'Formula Response with Samples',

   'Forward Message'
=> 'Forward Message',

   'Forward Messages'
=> 'Forward Messages',

   'Forward messages to other account(s) in LON-CAPA'
=> 'Forward messages to other account(s) in LON-CAPA',

   'Forward to account(s)'
=> 'Forward to account(s)',

   'Forwarded'
=> 'Forwarded',

   'Forwarded message from '
=> 'Forwarded message from ',

   'Forwarded messages:'
=> 'Forwarded messages:',

   'Forwarding Multiple Messages'
=> 'Forwarding Multiple Messages',

   'Forwarding a Message'
=> 'Forwarding a Message',

   'Found [_1] entries for grading!'
=> 'Found [_1] entries for grading!',

   'Found [_1] question(s)'
=> 'Found [_1] question(s)',

   'Found [_1] registered and [_2] unregistered clickers.'
=> 'Found [_1] registered and [_2] unregistered clickers.',

   'Found [_1] without responses. This resource cannot be published.'
=> 'Found [_1] without responses. This resource cannot be published.',

   'Found no analyzable responses in this problem. Currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable responses in this problem. Currently only Numerical, Formula and String response styles are supported.',

   'Found no correct answers answers for grading!'
=> 'Found no correct answers answers for grading!',

   'Found no questions.'
=> 'Found no questions.',

   'Found tag [_1] on line [_2] when looking for [_3] in file.'
=> 'Found tag [_1] on line [_2] when looking for [_3] in file.',

   'Free Form Problems'
=> 'Free Form Problems',

   'Freeze Course'
=> 'Freeze Course',

   'Freeze Courses'
=> 'Freeze Courses',

   'Freeze Role'
=> 'Freeze Role',

   'Freeze Roles'
=> 'Freeze Roles',

   'Freezing Role: [_1]'
=> 'Freezing Role: [_1]',

   'From:[_1]'
=> 'From:[_1]',

   'Fullname'
=> 'Fullname',

   'Functionality'
=> 'Functionality',

   'Functionality to display/modify'
=> 'Functionality to display/modify',

   'Future'
=> 'Future',

   'Future Member'
=> 'Future Member',

   'Future access'
=> 'Future access',

   'Future access status.'
=> 'Future access status.',

   'Gathering initial domain data'
=> 'Gathering initial domain data',

   'General course settings'
=> 'General course settings',

   'General message text'
=> 'General message text',

   'Generate Chart'
=> 'Generate Chart',

   'Generate Detailed Report'
=> 'Generate Detailed Report',

   'Generate Graph'
=> 'Generate Graph',

   'Generate Report'
=> 'Generate Report',

   'Generate Survey Report'
=> 'Generate Survey Report',

   'Generate anonymous statistics'
=> 'Generate anonymous statistics',

   'Generated [_1] ([_2] bytes)'
=> 'Generated [_1] ([_2] bytes)',

   'Generated on [_1]'
=> 'Generated on [_1]',

   'Generating user'
=> 'Generating user',

   'Generating user: [_1]'
=> 'Generating user: [_1]',

   'Get help'
=> 'Get help',

   'Get identity behind anonymous postings'
=> 'Get identity behind anonymous postings',

   'Getting started guide'
=> 'Getting started guide',

   'Go to Automated Enrollment Manager for course'
=> 'Go to Automated Enrollment Manager for course',

   'Go to first resource'
=> 'Go to first resource',

   "Go to group's home page"
=> "Go to group's home page",

   'Go to main menu'
=> 'Go to main menu',

   'Go to personal information page for [_1]'
=> 'Go to personal information page for [_1]',

   'Go to the login page'
=> 'Go to the login page',

   'Go to the start of the course'
=> 'Go to the start of the course',

   'Grade'
=> 'Grade',

   'Grade 1'
=> 'Grade 1',

   'Grade 10'
=> 'Grade 10',

   'Grade 11'
=> 'Grade 11',

   'Grade 12'
=> 'Grade 12',

   'Grade 13'
=> 'Grade 13',

   'Grade 2'
=> 'Grade 2',

   'Grade 3'
=> 'Grade 3',

   'Grade 4'
=> 'Grade 4',

   'Grade 5'
=> 'Grade 5',

   'Grade 6'
=> 'Grade 6',

   'Grade 7'
=> 'Grade 7',

   'Grade 8'
=> 'Grade 8',

   'Grade 9'
=> 'Grade 9',

   'Grade BTs in any section'
=> 'Grade BTs in any section',

   'Grade BTs only in own section'
=> 'Grade BTs only in own section',

   'Grade Complete Folder for One Student'
=> 'Grade Complete Folder for One Student',

   'Grade Current Resource'
=> 'Grade Current Resource',

   'Grade Level'
=> 'Grade Level',

   'Grade Levels'
=> 'Grade Levels',

   'Grade Status'
=> 'Grade Status',

   'Grade all selected students in a grading table.'
=> 'Grade all selected students in a grading table.',

   'Grade bubblesheet exams, upload/download bubblesheet data files, and review previously graded bubblesheet exams.'
=> 'Grade bubblesheet exams, upload/download bubblesheet data files, and review previously graded bubblesheet exams.',

   'Grade items in grading queue'
=> 'Grade items in grading queue',

   'Grade/Manage/Review Bubblesheets'
=> 'Grade/Manage/Review Bubblesheets',

   'Graded folder/sequence:'
=> 'Graded folder/sequence:',

   'Grades Assigned'
=> 'Grades Assigned',

   'Grades remain inaccessible if resource is pasted into another folder.'
=> 'Grades remain inaccessible if resource is pasted into another folder.',

   'Grading Feedback'
=> 'Grading Feedback',

   'Grading Increments'
=> 'Grading Increments',

   'Grading Menu'
=> 'Grading Menu',

   'Grading and Statistics'
=> 'Grading and Statistics',

   'Grading: Validate Bubblesheet Records'
=> 'Grading: Validate Bubblesheet Records',

   'Graduate Level'
=> 'Graduate Level',

   'Granting permission to clone course'
=> 'Granting permission to clone course',

   'Granularity'
=> 'Granularity',

   'Granularity:'
=> 'Granularity:',

   'Graph Problem Submission Times'
=> 'Graph Problem Submission Times',

   'Graphics'
=> 'Graphics',

   'Group'
=> 'Group',

   'Group Actions'
=> 'Group Actions',

   'Group Chat Room'
=> 'Group Chat Room',

   'Group Chat Room:'
=> 'Group Chat Room:',

   'Group Discussion Board'
=> 'Group Discussion Board',

   'Group Discussion Boards'
=> 'Group Discussion Boards',

   'Group Documents'
=> 'Group Documents',

   'Group Folder - [_1]'
=> 'Group Folder - [_1]',

   'Group Membership'
=> 'Group Membership',

   'Group Message'
=> 'Group Message',

   'Group Name'
=> 'Group Name',

   'Group Portfolio'
=> 'Group Portfolio',

   'Group Portfolio files'
=> 'Group Portfolio files',

   'Group Settings'
=> 'Group Settings',

   'Group Title'
=> 'Group Title',

   'Group [_1] was created.'
=> 'Group [_1] was created.',

   'Group [_1] was updated.'
=> 'Group [_1] was updated.',

   'Group [_1].'
=> 'Group [_1].',

   'Group access start and end dates'
=> 'Group access start and end dates',

   'Group deletion failed because deletion of [_1] out of [_2] members failed.'
=> 'Group deletion failed because deletion of [_1] out of [_2] members failed.',

   'Group deletion failed.'
=> 'Group deletion failed.',

   'Group home page'
=> 'Group home page',

   'Group homepage - [_1]'
=> 'Group homepage - [_1]',

   'Group membership'
=> 'Group membership',

   'Group membership list updated.'
=> 'Group membership list updated.',

   'Group membership mapping to specific sections/roles'
=> 'Group membership mapping to specific sections/roles',

   'Group membership selection list criteria:'
=> 'Group membership selection list criteria:',

   'Group membership status - [_1]'
=> 'Group membership status - [_1]',

   'Group name, title and available collaborative tools'
=> 'Group name, title and available collaborative tools',

   'Group names and section names must be distinct'
=> 'Group names and section names must be distinct',

   'Group names and section names used in a Course must be unique.'
=> 'Group names and section names used in a Course must be unique.',

   'Group names may only contain letters, numbers or underscores.'
=> 'Group names may only contain letters, numbers or underscores.',

   'Group page - [_1]'
=> 'Group page - [_1]',

   'Group portfolio'
=> 'Group portfolio',

   'Group portfolio for [_1]'
=> 'Group portfolio for [_1]',

   "Group portfolio in the course '[_1]' will be inaccessible between [_2] and [_3] because communication is being blocked."
=> "Group portfolio in the course '[_1]' will be inaccessible between [_2] and [_3] because communication is being blocked.",

   'Group settings'
=> 'Group settings',

   'Group settings and membership at the time the group was deleted are reinstated.'
=> 'Group settings and membership at the time the group was deleted are reinstated.',

   'Group successfully deleted.'
=> 'Group successfully deleted.',

   'Group(s)'
=> 'Group(s)',

   'Group:'
=> 'Group:',

   'Groups'
=> 'Groups',

   'Groups Manager'
=> 'Groups Manager',

   'Groups [_1] and [_2].'
=> 'Groups [_1] and [_2].',

   'Groups in this course will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Groups in this course will be inaccessible between [_1] and [_2] because communication is being blocked.',

   'HTML, with all links'
=> 'HTML, with all links',

   'HTML, with links'
=> 'HTML, with links',

   'HTML, without links'
=> 'HTML, without links',

   'Half Points'
=> 'Half Points',

   'Hand Graded'
=> 'Hand Graded',

   'Handgraded Problems'
=> 'Handgraded Problems',

   'Handler Versions'
=> 'Handler Versions',

   'Harvest Metadata Keywords'
=> 'Harvest Metadata Keywords',

   'Harvest Metadata Searches'
=> 'Harvest Metadata Searches',

   'Has New Discussion'
=> 'Has New Discussion',

   'Having technical difficulties; please check status later'
=> 'Having technical difficulties; please check status later',

   'Header'
=> 'Header',

   'Header Background Color'
=> 'Header Background Color',

   'Header Border Color'
=> 'Header Border Color',

   'Height'
=> 'Height',

   'Height:'
=> 'Height:',

   'Help Menu'
=> 'Help Menu',

   'Help on Creating Courses and Communities'
=> 'Help on Creating Courses and Communities',

   'Help on changing settings'
=> 'Help on changing settings',

   'Help on printing'
=> 'Help on printing',

   'Help on removing share access'
=> 'Help on removing share access',

   'Help on setting up share access'
=> 'Help on setting up share access',

   'Help on slots'
=> 'Help on slots',

   'Help on the portfolio'
=> 'Help on the portfolio',

   'Help page settings'
=> 'Help page settings',

   'Help with filling in text boxes'
=> 'Help with filling in text boxes',

   'Help: [_1]'
=> 'Help: [_1]',

   'Helpdesk requests to be e-mailed to'
=> 'Helpdesk requests to be e-mailed to',

   'Here are the error messages in the LaTeX log file:'
=> 'Here are the error messages in the LaTeX log file:',

   'Hidden'
=> 'Hidden',

   'Hide Closed Discussion'
=> 'Hide Closed Discussion',

   'Hide Closed Discussion (discusshide)'
=> 'Hide Closed Discussion (discusshide)',

   'Hide DragMath-Editor'
=> 'Hide DragMath-Editor',

   'Hide DragMath-Editor (turnoffeditor)'
=> 'Hide DragMath-Editor (turnoffeditor)',

   'Hide all'
=> 'Hide all',

   'Hide buttons from students'
=> 'Hide buttons from students',

   'Hide buttons from students (buttonshide)'
=> 'Hide buttons from students (buttonshide)',

   'Hide detailed Parameter Selection'
=> 'Hide detailed Parameter Selection',

   'Hide this Feed'
=> 'Hide this Feed',

   'Hide upload references prompt if uploading file to portfolio'
=> 'Hide upload references prompt if uploading file to portfolio',

   'Hide/Delete any post'
=> 'Hide/Delete any post',

   'Hiding'
=> 'Hiding',

   'Hiding/unhiding a community from the catalog (although can be [_1]configured[_2] to be modifiable by a Coordinator in community context).'
=> 'Hiding/unhiding a community from the catalog (although can be [_1]configured[_2] to be modifiable by a Coordinator in community context).',

   'Hiding/unhiding a course from the course catalog (although can be [_1]configured[_2] to be modifiable by a Course Coordinator in course context).'
=> 'Hiding/unhiding a course from the course catalog (although can be [_1]configured[_2] to be modifiable by a Course Coordinator in course context).',

   'High Level Randomization'
=> 'High Level Randomization',

   'Hint'
=> 'Hint',

   'History'
=> 'History',

   'History of member-reservable slots for: [_1]'
=> 'History of member-reservable slots for: [_1]',

   'History of student-reservable slots for: [_1]'
=> 'History of student-reservable slots for: [_1]',

   'Home'
=> 'Home',

   'Home Server for Course'
=> 'Home Server for Course',

   'Home server: [_1]'
=> 'Home server: [_1]',

   'Hours'
=> 'Hours',

   'How do I create a users list from a spreadsheet'
=> 'How do I create a users list from a spreadsheet',

   'How do you want assignments split into PDF files?'
=> 'How do you want assignments split into PDF files?',

   'How should each column be formatted?'
=> 'How should each column be formatted?',

   'Hypertext Cascading Style Sheet'
=> 'Hypertext Cascading Style Sheet',

   'Hypertext Document'
=> 'Hypertext Document',

   'ID'
=> 'ID',

   'ID [_1] contains invalid characters. IDs are only allowed to contain letters, numbers, spaces and -'
=> 'ID [_1] contains invalid characters. IDs are only allowed to contain letters, numbers, spaces and -',

   'IMS Export'
=> 'IMS Export',

   'IMS Export Failed'
=> 'IMS Export Failed',

   'IMS Import'
=> 'IMS Import',

   'IMS course archive'
=> 'IMS course archive',

   'IMS package'
=> 'IMS package',

   'INBOX'
=> 'INBOX',

   'IP1,IP2 etc.'
=> 'IP1,IP2 etc.',

   'Identify fields in uploaded list'
=> 'Identify fields in uploaded list',

   'If'
=> 'If',

   'If a change is required, contact a domain coordinator for the domain'
=> 'If a change is required, contact a domain coordinator for the domain',

   "If a community has been categorized using at least one of the categories defined for communities in the domain, it will be listed in the domain's publicly accessible Course/Community Catalog, unless excluded."
=> "If a community has been categorized using at least one of the categories defined for communities in the domain, it will be listed in the domain's publicly accessible Course/Community Catalog, unless excluded.",

   'If a course or community is [_1]not[_2] in your list of current courses and communities below, you may be able to enroll if self-enrollment is permitted.'
=> 'If a course or community is [_1]not[_2] in your list of current courses and communities below, you may be able to enroll if self-enrollment is permitted.',

   'If a user is currently logged-in to LON-CAPA, any new roles which are active will be available when the user next logs in.'
=> 'If a user is currently logged-in to LON-CAPA, any new roles which are active will be available when the user next logs in.',

   'If active, the new role will be available when the student next logs in to LON-CAPA.'
=> 'If active, the new role will be available when the student next logs in to LON-CAPA.',

   'If auto-cataloging based on institutional code is enabled in the domain, a course will continue to be listed in the catalog of official courses, in addition to receiving a listing under any manually assigned categor(ies).'
=> 'If auto-cataloging based on institutional code is enabled in the domain, a course will continue to be listed in the catalog of official courses, in addition to receiving a listing under any manually assigned categor(ies).',

   'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, once the first enrollment date has been reached. Prior to this date, the class roster will only contain students you have added directly using the standard LON-CAPA enrollment tools'
=> 'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, once the first enrollment date has been reached. Prior to this date, the class roster will only contain students you have added directly using the standard LON-CAPA enrollment tools',

   'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, until the last enrollment date has been reached.'
=> 'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, until the last enrollment date has been reached.',

   'If automated enrollment at your institution requires validation of course owners, automated enrollment will fail.'
=> 'If automated enrollment at your institution requires validation of course owners, automated enrollment will fail.',

   'If automatic enrollment is enabled for "[_1]", automated enrollment may fail for "[_2]" - section [_3] for the following reason: "[_4]".'
=> 'If automatic enrollment is enabled for "[_1]", automated enrollment may fail for "[_2]" - section [_3] for the following reason: "[_4]".',

   'If automatic enrollment is enabled for "[_1]", automated enrollment may fail for "[_2]" - section: [_3] for the following reason: "[_4]"'
=> 'If automatic enrollment is enabled for "[_1]", automated enrollment may fail for "[_2]" - section: [_3] for the following reason: "[_4]"',

   'If automatic enrollment is enabled for "[_1]", automated enrollment may fail for "[_2]" - section: [_3], because this is not a valid section entry.'
=> 'If automatic enrollment is enabled for "[_1]", automated enrollment may fail for "[_2]" - section: [_3], because this is not a valid section entry.',

   "If automatic group disenrollment is enabled, when a user's role is expired, access to the group will be terminated unless the user continues to have other course-wide or section-specific active or future roles which receive automatic membership in the group."
=> "If automatic group disenrollment is enabled, when a user's role is expired, access to the group will be terminated unless the user continues to have other course-wide or section-specific active or future roles which receive automatic membership in the group.",

   'If automatic group enrollment is enabled, when a user is newly assigned a course-wide or section-specific role, he/she will automatically be added as a member of the group, with start and end access dates defined by the default dates set for the group, unless he/she is already a group member, with access dates that permit either current or future group access.'
=> 'If automatic group enrollment is enabled, when a user is newly assigned a course-wide or section-specific role, he/she will automatically be added as a member of the group, with start and end access dates defined by the default dates set for the group, unless he/she is already a group member, with access dates that permit either current or future group access.',

   'If entering more than one, use spaces to separate the collaborators.'
=> 'If entering more than one, use spaces to separate the collaborators.',

   'If previously expired members are being re-enabled, or if access for future members is being activated now, previously set privileges will be preserved.'
=> 'If previously expired members are being re-enabled, or if access for future members is being activated now, previously set privileges will be preserved.',

   'If the member is currently logged-in to LON-CAPA, the new role will be available when the member next logs in.'
=> 'If the member is currently logged-in to LON-CAPA, the new role will be available when the member next logs in.',

   'If the student is currently logged-in to LON-CAPA, the new role will be available when the student next logs in.'
=> 'If the student is currently logged-in to LON-CAPA, the new role will be available when the student next logs in.',

   'If unexpected discrepancies were detected, it is recommended that you inspect the original bubblesheets.'
=> 'If unexpected discrepancies were detected, it is recommended that you inspect the original bubblesheets.',

   'If unvalidated, the request will be held in a queue.'
=> 'If unvalidated, the request will be held in a queue.',

   'If you already have a log-in ID at this institution,[_1] you may be able to use it for LON-CAPA.'
=> 'If you already have a log-in ID at this institution,[_1] you may be able to use it for LON-CAPA.',

   'If you are officially enrolled in a course but the course is not listed in your LON-CAPA courses, click the "Show more details" link for the specific course and check the default access dates and/or automated enrollment settings.'
=> 'If you are officially enrolled in a course but the course is not listed in your LON-CAPA courses, click the "Show more details" link for the specific course and check the default access dates and/or automated enrollment settings.',

   'If you do not wish to add members when you first create the group, there is no need to pick any criteria.'
=> 'If you do not wish to add members when you first create the group, there is no need to pick any criteria.',

   'If you enable the group portfolio for the group, allocate a disk quota.'
=> 'If you enable the group portfolio for the group, allocate a disk quota.',

   'If you have an account in LON-CAPA, [_1]log-in[_2].'
=> 'If you have an account in LON-CAPA, [_1]log-in[_2].',

   'If you use the same account for other campus services besides LON-CAPA, (e.g., e-mail, course registration, etc.), a separate centrally managed mechanism likely exists to reset a password. However, if your account is used for just LON-CAPA access you will probably be able to reset a password from this page.'
=> 'If you use the same account for other campus services besides LON-CAPA, (e.g., e-mail, course registration, etc.), a separate centrally managed mechanism likely exists to reset a password. However, if your account is used for just LON-CAPA access you will probably be able to reset a password from this page.',

   'If you were expecting to see an active role listed for a particular course in the [_1] domain, it may be missing for one of the following reasons:'
=> 'If you were expecting to see an active role listed for a particular course in the [_1] domain, it may be missing for one of the following reasons:',

   'If you were expecting to see an active role listed for a particular course, that course may not have been created yet.'
=> 'If you were expecting to see an active role listed for a particular course, that course may not have been created yet.',

   'If you would like to associate this resource ([_1]) with a current or previous course, please select one from the list below, otherwise select, "None".'
=> 'If you would like to associate this resource ([_1]) with a current or previous course, please select one from the list below, otherwise select, "None".',

   'If your problem is still unresolved, the form below can be used to send a question to the LON-CAPA helpdesk.'
=> 'If your problem is still unresolved, the form below can be used to send a question to the LON-CAPA helpdesk.',

   'Image Options'
=> 'Image Options',

   'Image Source File'
=> 'Image Source File',

   'Image Url:'
=> 'Image Url:',

   'Image response foil'
=> 'Image response foil',

   'Images'
=> 'Images',

   'Immediate course roster update'
=> 'Immediate course roster update',

   'Import Bookmarks'
=> 'Import Bookmarks',

   'Import Checked'
=> 'Import Checked',

   'Import Document'
=> 'Import Document',

   'Import Documents'
=> 'Import Documents',

   'Import IMS package'
=> 'Import IMS package',

   'Import Resources from Bookmarks'
=> 'Import Resources from Bookmarks',

   'Import a document'
=> 'Import a document',

   'In discussions: all posts will be displayed.'
=> 'In discussions: all posts will be displayed.',

   'In discussions: new posts will be cease to be identified as "NEW" after display.'
=> 'In discussions: new posts will be cease to be identified as "NEW" after display.',

   'In discussions: only new posts will be displayed.'
=> 'In discussions: only new posts will be displayed.',

   'In discussions: posts will be identified as "NEW" until marked as not "NEW".'
=> 'In discussions: posts will be identified as "NEW" until marked as not "NEW".',

   'In each community, each user may only have one member role at a time'
=> 'In each community, each user may only have one member role at a time',

   'In each community, each user may only have one member role at a time.'
=> 'In each community, each user may only have one member role at a time.',

   'In each course, each user may only have one student role at a time'
=> 'In each course, each user may only have one student role at a time',

   'In each course, each user may only have one student role at a time.'
=> 'In each course, each user may only have one student role at a time.',

   'In the course:'
=> 'In the course:',

   'Inactive'
=> 'Inactive',

   'Include'
=> 'Include',

   'Include communities set to be hidden from catalog ([_1] only)'
=> 'Include communities set to be hidden from catalog ([_1] only)',

   'Include courses set to be hidden from catalog ([_1] only)'
=> 'Include courses set to be hidden from catalog ([_1] only)',

   'Include in community RSS newsfeed'
=> 'Include in community RSS newsfeed',

   "Include in community's 'User records' for recipient(s)"
=> "Include in community's 'User records' for recipient(s)",

   'Include in course RSS newsfeed'
=> 'Include in course RSS newsfeed',

   "Include in course's 'User records' for recipient(s)"
=> "Include in course's 'User records' for recipient(s)",

   'Include link to accessible portfolio files'
=> 'Include link to accessible portfolio files',

   'Include other personnel?'
=> 'Include other personnel?',

   'Include parameter types'
=> 'Include parameter types',

   'Include subcategories within "[_1]"'
=> 'Include subcategories within "[_1]"',

   'Include yourself in the roster?'
=> 'Include yourself in the roster?',

   'Include?'
=> 'Include?',

   'Incompatible units. No conversion found between "[_1]" and the required units.'
=> 'Incompatible units. No conversion found between "[_1]" and the required units.',

   'Indicate which <b>optional</b> privileges members will receive by default for a specific tool.'
=> 'Indicate which <b>optional</b> privileges members will receive by default for a specific tool.',

   'Information about [_1]'
=> 'Information about [_1]',

   'Information needed to verify your login information is missing, inaccessible or expired.'
=> 'Information needed to verify your login information is missing, inaccessible or expired.',

   'Information settable when self-creating account (if directory data blank)'
=> 'Information settable when self-creating account (if directory data blank)',

   'Initial version'
=> 'Initial version',

   'Insert rule above'
=> 'Insert rule above',

   'Insert rule below'
=> 'Insert rule below',

   'Insert:'
=> 'Insert:',

   'Instead a copy has been sent to the LON-CAPA support team at Michigan State University.'
=> 'Instead a copy has been sent to the LON-CAPA support team at Michigan State University.',

   'Instead of using this template you can specify an external URL as Syllabus in the [_1]Course Configuration[_2].'
=> 'Instead of using this template you can specify an external URL as Syllabus in the [_1]Course Configuration[_2].',

   'Institution Logo'
=> 'Institution Logo',

   'Institutional Categorization'
=> 'Institutional Categorization',

   'Institutional Code'
=> 'Institutional Code',

   'Institutional ID'
=> 'Institutional ID',

   'Institutional Login'
=> 'Institutional Login',

   'Institutional Section'
=> 'Institutional Section',

   'Institutional code'
=> 'Institutional code',

   'Institutional code and default authentication (both required for auto-enrollment of students from institutional datafeeds).'
=> 'Institutional code and default authentication (both required for auto-enrollment of students from institutional datafeeds).',

   'Institutional course/section'
=> 'Institutional course/section',

   'Institutional directory search has not been configured for domain: [_1]'
=> 'Institutional directory search has not been configured for domain: [_1]',

   'Institutional directory search in domain [_1] is not available for the requested search type: "[_2]"'
=> 'Institutional directory search in domain [_1] is not available for the requested search type: "[_2]"',

   'Institutional directory search in domain: [_1] is not available for searching by "[_2]"'
=> 'Institutional directory search in domain: [_1] is not available for searching by "[_2]"',

   'Institutional directory search in domain: [_1] is not available to your user type: '
=> 'Institutional directory search in domain: [_1] is not available to your user type: ',

   'Institutional directory search in domain: [_1] is not available.'
=> 'Institutional directory search in domain: [_1] is not available.',

   'Institutional directory search in domain: [_1] is only allowed for users with a current role in the domain.'
=> 'Institutional directory search in domain: [_1] is only allowed for users with a current role in the domain.',

   'Institutional directory search is not available in domain: [_1]'
=> 'Institutional directory search is not available in domain: [_1]',

   'Institutional directory searches'
=> 'Institutional directory searches',

   'Institutional only '
=> 'Institutional only ',

   'Institutional section'
=> 'Institutional section',

   'Instructors'
=> 'Instructors',

   'Instructors and TAs in sections, when grading bridge tasks, should be allowed to grade other sections.'
=> 'Instructors and TAs in sections, when grading bridge tasks, should be allowed to grade other sections.',

   'Instructors may use a reservation system to place restrictions on when and where assignments can be worked on.'
=> 'Instructors may use a reservation system to place restrictions on when and where assignments can be worked on.',

   'Intended course owner does not exist'
=> 'Intended course owner does not exist',

   'Internal (LON-CAPA)'
=> 'Internal (LON-CAPA)',

   'Internal Error - Bad view selected.'
=> 'Internal Error - Bad view selected.',

   'Internal info:'
=> 'Internal info:',

   'Internal, Filesystem and Local authentication: enter single default.'
=> 'Internal, Filesystem and Local authentication: enter single default.',

   'Interval set to version changes [_1]'
=> 'Interval set to version changes [_1]',

   'Invalid ID format'
=> 'Invalid ID format',

   'Invalid LON-CAPA course number for the new course'
=> 'Invalid LON-CAPA course number for the new course',

   'Invalid [_1]'
=> 'Invalid [_1]',

   'Invalid course ID'
=> 'Invalid course ID',

   'Invalid domain name'
=> 'Invalid domain name',

   'Invalid domain name.'
=> 'Invalid domain name.',

   'Invalid domain or course number'
=> 'Invalid domain or course number',

   'Invalid domain.'
=> 'Invalid domain.',

   'Invalid filename: '
=> 'Invalid filename: ',

   'Invalid format'
=> 'Invalid format',

   'Invalid group'
=> 'Invalid group',

   'Invalid group name'
=> 'Invalid group name',

   'Invalid group name provided.'
=> 'Invalid group name provided.',

   'Invalid home server for course: [_1]'
=> 'Invalid home server for course: [_1]',

   'Invalid login name.'
=> 'Invalid login name.',

   'Invalid search.'
=> 'Invalid search.',

   'Invalid slot name: [_1]'
=> 'Invalid slot name: [_1]',

   'Invalid target directory, FAIL'
=> 'Invalid target directory, FAIL',

   'Invalid username and/or domain'
=> 'Invalid username and/or domain',

   'Invalid username or domain for community requestor'
=> 'Invalid username or domain for community requestor',

   'Invalid username or domain for course requestor'
=> 'Invalid username or domain for course requestor',

   'Invitation to be co-owner declined'
=> 'Invitation to be co-owner declined',

   'Invite other Coordinators [_1]to become co-owners'
=> 'Invite other Coordinators [_1]to become co-owners',

   'Invited as co-owners [_1](agreement pending)'
=> 'Invited as co-owners [_1](agreement pending)',

   'Invited as co-owners, pending acceptance'
=> 'Invited as co-owners, pending acceptance',

   'Is this problem reproducible?'
=> 'Is this problem reproducible?',

   'It has found an error in [_1][_2]and corrected it.'
=> 'It has found an error in [_1][_2]and corrected it.',

   'It is likely that the tolerance range [_1] needs to be adjusted.'
=> 'It is likely that the tolerance range [_1] needs to be adjusted.',

   'It is likely that the tolerance range [_1] or significant figures [_2] need to be adjusted.'
=> 'It is likely that the tolerance range [_1] or significant figures [_2] need to be adjusted.',

   'It is recommended that you [_1]re-initialize the course[_2] and then return to this grading page.'
=> 'It is recommended that you [_1]re-initialize the course[_2] and then return to this grading page.',

   'It is recommended that you [_1]re-initialize the course[_2] and then return to this grading page..'
=> 'It is recommended that you [_1]re-initialize the course[_2] and then return to this grading page..',

   'It is recommended that you [_1]re-initialize the course[_2] and then return to this page.'
=> 'It is recommended that you [_1]re-initialize the course[_2] and then return to this page.',

   "It looks like you don't have the TeX math fonts installed."
=> "It looks like you don't have the TeX math fonts installed.",

   'It may take some time to update the student data for the first analysis. Future analysis this session will not have this delay.'
=> 'It may take some time to update the student data for the first analysis. Future analysis this session will not have this delay.',

   'It probably has errors in it.'
=> 'It probably has errors in it.',

   'Item'
=> 'Item',

   'Kerberos 4'
=> 'Kerberos 4',

   'Kerberos 5'
=> 'Kerberos 5',

   'Kerberos: enter default for each realm used in the domain, with comma separation of entries'
=> 'Kerberos: enter default for each realm used in the domain, with comma separation of entries',

   'Key authority ([_1]id:domain[_2]) if other than community'
=> 'Key authority ([_1]id:domain[_2]) if other than community',

   'Key authority ([_1]id:domain[_2]) if other than course'
=> 'Key authority ([_1]id:domain[_2]) if other than course',

   'LON-CAPA Access Control'
=> 'LON-CAPA Access Control',

   'LON-CAPA Advanced Users'
=> 'LON-CAPA Advanced Users',

   'LON-CAPA Catalog Search'
=> 'LON-CAPA Catalog Search',

   'LON-CAPA Domain Status'
=> 'LON-CAPA Domain Status',

   'LON-CAPA Feed "[_1]" for [_2]'
=> 'LON-CAPA Feed "[_1]" for [_2]',

   'LON-CAPA Home Server for New Users'
=> 'LON-CAPA Home Server for New Users',

   'LON-CAPA Logo'
=> 'LON-CAPA Logo',

   'LON-CAPA Module Versions'
=> 'LON-CAPA Module Versions',

   'LON-CAPA Modules'
=> 'LON-CAPA Modules',

   'LON-CAPA Section(s)'
=> 'LON-CAPA Section(s)',

   'LON-CAPA Sections'
=> 'LON-CAPA Sections',

   'LON-CAPA Standard'
=> 'LON-CAPA Standard',

   'LON-CAPA User Message'
=> 'LON-CAPA User Message',

   'LON-CAPA account required'
=> 'LON-CAPA account required',

   'LON-CAPA course ID'
=> 'LON-CAPA course ID',

   'LON-CAPA course ID:'
=> 'LON-CAPA course ID:',

   'LON-CAPA domain: [_1] with home server:'
=> 'LON-CAPA domain: [_1] with home server:',

   'LON-CAPA has chat room functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA has chat room functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.',

   'LON-CAPA helpdesk'
=> 'LON-CAPA helpdesk',

   'LON-CAPA messages sent to you between [_1] and [_2] will be inaccessible until the end of this time period, because you are a student in a course with an active communications block.'
=> 'LON-CAPA messages sent to you between [_1] and [_2] will be inaccessible until the end of this time period, because you are a student in a course with an active communications block.',

   'LON-CAPA section'
=> 'LON-CAPA section',

   'LON-CAPA user(s) do(es) not exist.'
=> 'LON-CAPA user(s) do(es) not exist.',

   'LON-CAPA will automatically scale your uploaded file so the image will not exceed a width of 400px and a height of 500px.'
=> 'LON-CAPA will automatically scale your uploaded file so the image will not exceed a width of 400px and a height of 500px.',

   'LONC report.'
=> 'LONC report.',

   'LOND report'
=> 'LOND report',

   'LaTeX could not successfully parse your TeX file.'
=> 'LaTeX could not successfully parse your TeX file.',

   'Language and Time Localization'
=> 'Language and Time Localization',

   'Largest possible size'
=> 'Largest possible size',

   'Last Modifying User'
=> 'Last Modifying User',

   'Last Reset'
=> 'Last Reset',

   'Last Revision Date'
=> 'Last Revision Date',

   'Last Transaction'
=> 'Last Transaction',

   'Last modified between'
=> 'Last modified between',

   'Last revised'
=> 'Last revised',

   'Latest to display:'
=> 'Latest to display:',

   'Launched'
=> 'Launched',

   'Layout Options'
=> 'Layout Options',

   'Leader'
=> 'Leader',

   'Left Margin'
=> 'Left Margin',

   'Legal'
=> 'Legal',

   'Letter'
=> 'Letter',

   'Letters, numbers and underscore only'
=> 'Letters, numbers and underscore only',

   'Limit by total self-enrolled students'
=> 'Limit by total self-enrolled students',

   'Limit by total students'
=> 'Limit by total students',

   'Linefeeds, formfeeds, and carriage returns'
=> 'Linefeeds, formfeeds, and carriage returns',

   'Link'
=> 'Link',

   'Link colors'
=> 'Link colors',

   'Link to Resource'
=> 'Link to Resource',

   'Link to create a user account'
=> 'Link to create a user account',

   'Link to published resource'
=> 'Link to published resource',

   'Link to resource in Construction Space'
=> 'Link to resource in Construction Space',

   'Linked/Related Resources'
=> 'Linked/Related Resources',

   'Links to external sites'
=> 'Links to external sites',

   'List Environment'
=> 'List Environment',

   'List Symbs'
=> 'List Symbs',

   'List Users'
=> 'List Users',

   'List current directory'
=> 'List current directory',

   'List of all members'
=> 'List of all members',

   'List of hidden parts'
=> 'List of hidden parts',

   'Listed in vertical column'
=> 'Listed in vertical column',

   'Load Average'
=> 'Load Average',

   'Load Report'
=> 'Load Report',

   'Loading Data Upload Page'
=> 'Loading Data Upload Page',

   'Loading Domain Coordinator Menu'
=> 'Loading Domain Coordinator Menu',

   'Loading student data...'
=> 'Loading student data...',

   'Local'
=> 'Local',

   'Local/Customized'
=> 'Local/Customized',

   'Locale used for course calendar'
=> 'Locale used for course calendar',

   'Locate the IMS content package you wish to upload'
=> 'Locate the IMS content package you wish to upload',

   'Locating your clicker ID'
=> 'Locating your clicker ID',

   'Lock'
=> 'Lock',

   'Log-in Header'
=> 'Log-in Header',

   'Log-in Help'
=> 'Log-in Help',

   'Log-in ID'
=> 'Log-in ID',

   'Log-in Page Items'
=> 'Log-in Page Items',

   'Log-in Service'
=> 'Log-in Service',

   'Log-in banner'
=> 'Log-in banner',

   'Log-in help'
=> 'Log-in help',

   'Log-in page options'
=> 'Log-in page options',

   'Log-in to LON-CAPA'
=> 'Log-in to LON-CAPA',

   'Logging first evaluation'
=> 'Logging first evaluation',

   'Login box'
=> 'Login box',

   'Login page requests redirected'
=> 'Login page requests redirected',

   'Login problems?'
=> 'Login problems?',

   'Login time'
=> 'Login time',

   'Lower casing'
=> 'Lower casing',

   'MIME Type Category'
=> 'MIME Type Category',

   'Made reservation'
=> 'Made reservation',

   'Main Categories'
=> 'Main Categories',

   'Main Logo'
=> 'Main Logo',

   'Make Obsolete'
=> 'Make Obsolete',

   'Make Visible'
=> 'Make Visible',

   'Make a sequence selection from the "Sequences and Folders" menu and hit "Create Plot" to begin'
=> 'Make a sequence selection from the "Sequences and Folders" menu and hit "Create Plot" to begin',

   'Make another request'
=> 'Make another request',

   'Make any changes to self-enrollment settings below, click "Save", then take action to include the course in the Catalog:'
=> 'Make any changes to self-enrollment settings below, click "Save", then take action to include the course in the Catalog:',

   'Make future user roles active now'
=> 'Make future user roles active now',

   'Make new directory [_1]?'
=> 'Make new directory [_1]?',

   'Make new user "[_1]"'
=> 'Make new user "[_1]"',

   'Making Backup to [_1]'
=> 'Making Backup to [_1]',

   'Manage Co-authors'
=> 'Manage Co-authors',

   'Manage Course Groups'
=> 'Manage Course Groups',

   'Manage Course Slots'
=> 'Manage Course Slots',

   'Manage Course Users'
=> 'Manage Course Users',

   'Manage Reservations'
=> 'Manage Reservations',

   'Manage Slots'
=> 'Manage Slots',

   'Manage Users'
=> 'Manage Users',

   'Manage co-authors'
=> 'Manage co-authors',

   'Manage course groups'
=> 'Manage course groups',

   'Manage course groups.'
=> 'Manage course groups.',

   'Manage course users'
=> 'Manage course users',

   'Manage reservations'
=> 'Manage reservations',

   'Manage slots'
=> 'Manage slots',

   'Manage slots for this course.'
=> 'Manage slots for this course.',

   'Manage student enrollment'
=> 'Manage student enrollment',

   'Manage student enrollment '
=> 'Manage student enrollment ',

   'Manual Grading by Page or Sequence'
=> 'Manual Grading by Page or Sequence',

   'Manual Grading/View Submissions'
=> 'Manual Grading/View Submissions',

   'Manual cataloging of a community (although can be [_1]configured[_2] to be modifiable by a Coordinator in community context).'
=> 'Manual cataloging of a community (although can be [_1]configured[_2] to be modifiable by a Coordinator in community context).',

   'Map not loaded - Lock file could not be opened when reading map:'
=> 'Map not loaded - Lock file could not be opened when reading map:',

   'Map/Folder Level'
=> 'Map/Folder Level',

   'Mapping of roles and sections affected by automatic group enrollment/disenrollment follows scheme chosen below.'
=> 'Mapping of roles and sections affected by automatic group enrollment/disenrollment follows scheme chosen below.',

   'Mark NEW posts no longer new'
=> 'Mark NEW posts no longer new',

   'Mark Read'
=> 'Mark Read',

   'Mark obsolete'
=> 'Mark obsolete',

   'Mark read'
=> 'Mark read',

   'Marked Message as Unread'
=> 'Marked Message as Unread',

   'Marked Messages Read'
=> 'Marked Messages Read',

   'Marked Messages Unread'
=> 'Marked Messages Unread',

   'Marked [quant,_1,message] read'
=> 'Marked [quant,_1,message] read',

   'Marked [quant,_1,message] unread'
=> 'Marked [quant,_1,message] unread',

   'Marked postings read/unread'
=> 'Marked postings read/unread',

   'Matching Response'
=> 'Matching Response',

   'Math Rendering:'
=> 'Math Rendering:',

   'Math Response using Computer Algebra System MAXIMA'
=> 'Math Response using Computer Algebra System MAXIMA',

   'Math Response using Computer Algebra System R'
=> 'Math Response using Computer Algebra System R',

   'Math Response using Computer Algebra System and Hints'
=> 'Math Response using Computer Algebra System and Hints',

   'Math display settings'
=> 'Math display settings',

   'Max. Cumulative Size (MB) for Submitted Files'
=> 'Max. Cumulative Size (MB) for Submitted Files',

   'Max. Cumulative Size (MB) for Submitted Files (maxfilesize)'
=> 'Max. Cumulative Size (MB) for Submitted Files (maxfilesize)',

   'Max. Total'
=> 'Max. Total',

   'Max. cumulative size (MB) for submitted files'
=> 'Max. cumulative size (MB) for submitted files',

   'Max. cumulative size (MB) for submitted files (maxfilesize)'
=> 'Max. cumulative size (MB) for submitted files (maxfilesize)',

   'Maximum'
=> 'Maximum',

   'Maximum Number of Tries'
=> 'Maximum Number of Tries',

   'Maximum enrollment setting unchanged.'
=> 'Maximum enrollment setting unchanged.',

   'Maximum number allowed: '
=> 'Maximum number allowed: ',

   'Mean Degree of Difficulty'
=> 'Mean Degree of Difficulty',

   'Mean Degree of Discrimination'
=> 'Mean Degree of Discrimination',

   'Median'
=> 'Median',

   'Member'
=> 'Member',

   'Members'
=> 'Members',

   'Members need access key to enter course'
=> 'Members need access key to enter course',

   'Members selected from this list can be dropped.'
=> 'Members selected from this list can be dropped.',

   'Members to delete or expire'
=> 'Members to delete or expire',

   'Membership Mapping'
=> 'Membership Mapping',

   'Membership Roster'
=> 'Membership Roster',

   "Membership of viewer's section"
=> "Membership of viewer's section",

   'Membership reinstated for [quant,_1,user], each with start and end dates for group access set to defaults: [_2] and [_3]'
=> 'Membership reinstated for [quant,_1,user], each with start and end dates for group access set to defaults: [_2] and [_3]',

   'Membership status: '
=> 'Membership status: ',

   'Menu'
=> 'Menu',

   'Message'
=> 'Message',

   'Message (new)'
=> 'Message (new)',

   'Message Administration'
=> 'Message Administration',

   'Message Log for Selected Users'
=> 'Message Log for Selected Users',

   'Message Status'
=> 'Message Status',

   'Message begins with:'
=> 'Message begins with:',

   'Message copied to new folder but status was not, A network error occurred.'
=> 'Message copied to new folder but status was not, A network error occurred.',

   'Message copied, but unable to delete the original from the source folder.'
=> 'Message copied, but unable to delete the original from the source folder.',

   'Message copied, but unable to delete the original status from the source folder.'
=> 'Message copied, but unable to delete the original status from the source folder.',

   'Message not moved as the message is no longer in the source folder.'
=> 'Message not moved as the message is no longer in the source folder.',

   'Message not moved, A network error occurred.'
=> 'Message not moved, A network error occurred.',

   'Message not moved, Attempted to move message to the same folder as it already is in.'
=> 'Message not moved, Attempted to move message to the same folder as it already is in.',

   'Message to member and add to user notes'
=> 'Message to member and add to user notes',

   'Message to student and add to user notes'
=> 'Message to student and add to user notes',

   'Message will be sent when you click on Save &amp; Next below.'
=> 'Message will be sent when you click on Save &amp; Next below.',

   'Messages'
=> 'Messages',

   'Messages & Notifications'
=> 'Messages & Notifications',

   'Messages &amp; Notifications'
=> 'Messages &amp; Notifications',

   'Messages being sent.'
=> 'Messages being sent.',

   'Messages cleared.'
=> 'Messages cleared.',

   'Messages deleted.'
=> 'Messages deleted.',

   'Metadata Diffs'
=> 'Metadata Diffs',

   'Metadata Modified'
=> 'Metadata Modified',

   'Metadata Publication'
=> 'Metadata Publication',

   'Metadata for [_1]'
=> 'Metadata for [_1]',

   'Min Tries'
=> 'Min Tries',

   'Minimum'
=> 'Minimum',

   'Miscellaneous'
=> 'Miscellaneous',

   'Missing tags, unable to properly run file.'
=> 'Missing tags, unable to properly run file.',

   'Moderately Active'
=> 'Moderately Active',

   'Modifiable by DC only'
=> 'Modifiable by DC only',

   'Modifiable only by Domain Coordinator'
=> 'Modifiable only by Domain Coordinator',

   'Modification of scores not allowed for the following username(s):'
=> 'Modification of scores not allowed for the following username(s):',

   'Modifications Complete'
=> 'Modifications Complete',

   'Modify'
=> 'Modify',

   'Modify Request'
=> 'Modify Request',

   'Modify Resource Parameters - Overview Mode'
=> 'Modify Resource Parameters - Overview Mode',

   'Modify User Privileges'
=> 'Modify User Privileges',

   "Modify a user's information"
=> "Modify a user's information",

   'Modify access, tools and privileges for members'
=> 'Modify access, tools and privileges for members',

   'Modify an existing group'
=> 'Modify an existing group',

   'Modify course catalog settings for course'
=> 'Modify course catalog settings for course',

   'Modify course configuration'
=> 'Modify course configuration',

   'Modify course entry'
=> 'Modify course entry',

   'Modify course settings'
=> 'Modify course settings',

   'Modify default group settings'
=> 'Modify default group settings',

   'Modify existing communication blocking periods'
=> 'Modify existing communication blocking periods',

   'Modify existing user: '
=> 'Modify existing user: ',

   'Modify grade queue'
=> 'Modify grade queue',

   'Modify group membership'
=> 'Modify group membership',

   'Modify institutional code, course owner and/or default authentication'
=> 'Modify institutional code, course owner and/or default authentication',

   'Modify page'
=> 'Modify page',

   'Modify parameter settings (due dates, etc) for resources and the course'
=> 'Modify parameter settings (due dates, etc) for resources and the course',

   'Modify parameter settings for this resource'
=> 'Modify parameter settings for this resource',

   'Modify quota for group portfolio'
=> 'Modify quota for group portfolio',

   'Modify this request'
=> 'Modify this request',

   'Modify this user: [_1]'
=> 'Modify this user: [_1]',

   'Modify/Delete Members'
=> 'Modify/Delete Members',

   'Modifying Roles'
=> 'Modifying Roles',

   'Modifying authentication:'
=> 'Modifying authentication:',

   'Modifying this will make problems have different numbers and answers!'
=> 'Modifying this will make problems have different numbers and answers!',

   'Month[_1]Day[_2]Year'
=> 'Month[_1]Day[_2]Year',

   'More Options'
=> 'More Options',

   'More than one correct result given for question "[_1]": [_2] versus [_3].'
=> 'More than one correct result given for question "[_1]": [_2] versus [_3].',

   'Move'
=> 'Move',

   'Move Checked to Folder'
=> 'Move Checked to Folder',

   'Move [_1] to [_2]?'
=> 'Move [_1] to [_2]?',

   'Move rule down'
=> 'Move rule down',

   'Move rule up'
=> 'Move rule up',

   'Move to Folder ->'
=> 'Move to Folder ->',

   'Move to Inbox'
=> 'Move to Inbox',

   'Move to Inbox/Compose reply'
=> 'Move to Inbox/Compose reply',

   'Moved Messages'
=> 'Moved Messages',

   'Moved [quant,_1,message]'
=> 'Moved [quant,_1,message]',

   'Multiple Choice Problems'
=> 'Multiple Choice Problems',

   'Multiple Option Response Question'
=> 'Multiple Option Response Question',

   'Multiple Users'
=> 'Multiple Users',

   'Must not include'
=> 'Must not include',

   'My Courses'
=> 'My Courses',

   'My Courses/Communities'
=> 'My Courses/Communities',

   'My Personal Information Page'
=> 'My Personal Information Page',

   'My Roles'
=> 'My Roles',

   'My Space'
=> 'My Space',

   'NEW'
=> 'NEW',

   'Name (username)'
=> 'Name (username)',

   'Name already used as a standard role name'
=> 'Name already used as a standard role name',

   'Name already used as the name of a custom role'
=> 'Name already used as the name of a custom role',

   'Name already used to replace a different standard role name'
=> 'Name already used to replace a different standard role name',

   'Name for New Feed'
=> 'Name for New Feed',

   'Name not given'
=> 'Name not given',

   'Name of New Folder'
=> 'Name of New Folder',

   'Name of New Page'
=> 'Name of New Page',

   'Name of Simple Course Page'
=> 'Name of Simple Course Page',

   'Name of new file is the same as name of old file'
=> 'Name of new file is the same as name of old file',

   'Name of this Feed'
=> 'Name of this Feed',

   'Navigate Course Content'
=> 'Navigate Course Content',

   'Network-wide courses using resource'
=> 'Network-wide courses using resource',

   'Neutral'
=> 'Neutral',

   'New'
=> 'New',

   'New Broadcast Message'
=> 'New Broadcast Message',

   'New Composite Page'
=> 'New Composite Page',

   'New Discussion'
=> 'New Discussion',

   'New Discussion Board'
=> 'New Discussion Board',

   'New E-mail'
=> 'New E-mail',

   'New Error'
=> 'New Error',

   'New Feed'
=> 'New Feed',

   'New LON-CAPA [_1] ID: [_2]'
=> 'New LON-CAPA [_1] ID: [_2]',

   'New LON-CAPA course ID:'
=> 'New LON-CAPA course ID:',

   'New Link'
=> 'New Link',

   'New Message'
=> 'New Message',

   'New Messages Only'
=> 'New Messages Only',

   'New Messages from File'
=> 'New Messages from File',

   'New Name'
=> 'New Name',

   'New Name for Folder'
=> 'New Name for Folder',

   'New Page'
=> 'New Page',

   'New Password'
=> 'New Password',

   'New RSS Feed or Blog'
=> 'New RSS Feed or Blog',

   'New Record (record is visible to course faculty and staff)'
=> 'New Record (record is visible to course faculty and staff)',

   'New and Existing Parameter Settings for Resources'
=> 'New and Existing Parameter Settings for Resources',

   'New and Existing Parameter Settings for Your Resources'
=> 'New and Existing Parameter Settings for Your Resources',

   'New attachments'
=> 'New attachments',

   'New bridgetask file'
=> 'New bridgetask file',

   'New control(s) added'
=> 'New control(s) added',

   'New course messages'
=> 'New course messages',

   'New critical messages in course'
=> 'New critical messages in course',

   'New in course'
=> 'New in course',

   'New library file'
=> 'New library file',

   'New message (click to open)'
=> 'New message (click to open)',

   'New posts cease to be identified as "NEW"?'
=> 'New posts cease to be identified as "NEW"?',

   'New posts marked as read'
=> 'New posts marked as read',

   'New posts only'
=> 'New posts only',

   'New request'
=> 'New request',

   'New role-based condition'
=> 'New role-based condition',

   'New section'
=> 'New section',

   'New section to assign'
=> 'New section to assign',

   'New self-enrollment no longer allowed when total (all students) reaches [_1].'
=> 'New self-enrollment no longer allowed when total (all students) reaches [_1].',

   'New self-enrollment no longer allowed when total number of self-enrolled students reaches [_1].'
=> 'New self-enrollment no longer allowed when total number of self-enrolled students reaches [_1].',

   'New student/employee ID does not match existing ID for this user.'
=> 'New student/employee ID does not match existing ID for this user.',

   'New user accounts in [_1]'
=> 'New user accounts in [_1]',

   'New username'
=> 'New username',

   'New users can only be created in the domain to which your current role belongs - [_1].'
=> 'New users can only be created in the domain to which your current role belongs - [_1].',

   'New version'
=> 'New version',

   'New:'
=> 'New:',

   'Next Item'
=> 'Next Item',

   'Next Problem'
=> 'Next Problem',

   'Next Student'
=> 'Next Student',

   'Next Student ([_1])'
=> 'Next Student ([_1])',

   'Next Survey'
=> 'Next Survey',

   'Next [_1] changes'
=> 'Next [_1] changes',

   'Nickname'
=> 'Nickname',

   'Nightly additions based on classlist changes now'
=> 'Nightly additions based on classlist changes now',

   'Nightly additions based on classlist changes still'
=> 'Nightly additions based on classlist changes still',

   'Nightly removals based on classlist changes now'
=> 'Nightly removals based on classlist changes now',

   'Nightly removals based on classlist changes still'
=> 'Nightly removals based on classlist changes still',

   'No Access times found for student'
=> 'No Access times found for student',

   'No Chat room use'
=> 'No Chat room use',

   'No Course Data'
=> 'No Course Data',

   'No Domain Coordinators have community roles'
=> 'No Domain Coordinators have community roles',

   'No Domain Coordinators have course roles'
=> 'No Domain Coordinators have course roles',

   'No IDs found to determine correct answer'
=> 'No IDs found to determine correct answer',

   'No Resource'
=> 'No Resource',

   'No Resource Discussion'
=> 'No Resource Discussion',

   'No Section'
=> 'No Section',

   'No [_1]-based conditions defined.'
=> 'No [_1]-based conditions defined.',

   'No access control settings currently exist for this file.'
=> 'No access control settings currently exist for this file.',

   'No available times.'
=> 'No available times.',

   'No calendar available for this date.'
=> 'No calendar available for this date.',

   'No categories defined for this domain'
=> 'No categories defined for this domain',

   'No categories defined in this domain'
=> 'No categories defined in this domain',

   'No categories defined in this domain.'
=> 'No categories defined in this domain.',

   'No change'
=> 'No change',

   'No change in section assignment (none)'
=> 'No change in section assignment (none)',

   'No change occurred for the following users:'
=> 'No change occurred for the following users:',

   'No changes made to auto-creation settings'
=> 'No changes made to auto-creation settings',

   'No changes made to community configuration.'
=> 'No changes made to community configuration.',

   'No changes made to community settings.'
=> 'No changes made to community settings.',

   'No changes made to course and community categories'
=> 'No changes made to course and community categories',

   'No changes made to course configuration.'
=> 'No changes made to course configuration.',

   'No changes made to course defaults'
=> 'No changes made to course defaults',

   'No changes made to course settings.'
=> 'No changes made to course settings.',

   'No changes made to help settings'
=> 'No changes made to help settings',

   'No changes made to log-in page settings'
=> 'No changes made to log-in page settings',

   'No changes were made to the existing self-enrollment settings in this course.'
=> 'No changes were made to the existing self-enrollment settings in this course.',

   'No cloning for '
=> 'No cloning for ',

   'No communication blocks currently saved'
=> 'No communication blocks currently saved',

   'No communities match the criteria you selected.'
=> 'No communities match the criteria you selected.',

   'No community items currently require a reservation to gain access.'
=> 'No community items currently require a reservation to gain access.',

   'No context.'
=> 'No context.',

   'No correct result given for question "[_1]"!'
=> 'No correct result given for question "[_1]"!',

   'No course items currently require a reservation to gain access.'
=> 'No course items currently require a reservation to gain access.',

   'No course request ID provided.'
=> 'No course request ID provided.',

   'No course selected'
=> 'No course selected',

   'No course was found matching your choice of institutional course category.'
=> 'No course was found matching your choice of institutional course category.',

   'No courses match the criteria you selected.'
=> 'No courses match the criteria you selected.',

   'No current reservation.'
=> 'No current reservation.',

   'No data.'
=> 'No data.',

   'No differences found'
=> 'No differences found',

   'No domain specified'
=> 'No domain specified',

   'No end date'
=> 'No end date',

   'No end date set'
=> 'No end date set',

   'No exact match found for the last name [_1] in LON-CAPA domain: [_2]'
=> 'No exact match found for the last name [_1] in LON-CAPA domain: [_2]',

   'No exact match found for the last name [_1] in the institutional directory for domain: [_2]'
=> 'No exact match found for the last name [_1] in the institutional directory for domain: [_2]',

   'No exact match found for the last name [_1] in this course.'
=> 'No exact match found for the last name [_1] in this course.',

   'No exact match found for the last name, first name [_1] in LON-CAPA domain: [_2]'
=> 'No exact match found for the last name, first name [_1] in LON-CAPA domain: [_2]',

   'No exact match found for the last name, first name [_1] in the institutional directory for domain: [_2]'
=> 'No exact match found for the last name, first name [_1] in the institutional directory for domain: [_2]',

   'No exact match found for the last name, first name [_1] in this course.'
=> 'No exact match found for the last name, first name [_1] in this course.',

   'No exact match found for the username [_1] in LON-CAPA domain: [_2]'
=> 'No exact match found for the username [_1] in LON-CAPA domain: [_2]',

   'No exact match found for the username [_1] in the institutional directory for domain: [_2]'
=> 'No exact match found for the username [_1] in the institutional directory for domain: [_2]',

   'No exact match found for the username [_1] in this course.'
=> 'No exact match found for the username [_1] in this course.',

   'No existing sections'
=> 'No existing sections',

   'No file was selected to upload.'
=> 'No file was selected to upload.',

   'No file: [_1]'
=> 'No file: [_1]',

   'No format rules have been defined for usernames or IDs in this domain.'
=> 'No format rules have been defined for usernames or IDs in this domain.',

   'No further action will be taken'
=> 'No further action will be taken',

   'No group functionality (e.g., e-mail, discussion, chat room or file upload) is currently available to you in this group: [_1].'
=> 'No group functionality (e.g., e-mail, discussion, chat room or file upload) is currently available to you in this group: [_1].',

   'No group functionality.'
=> 'No group functionality.',

   'No group member privileges to display or set, as you have not indicated that you will be activating, re-enabling, changing privileges, or adding/removing tools for any current members.'
=> 'No group member privileges to display or set, as you have not indicated that you will be activating, re-enabling, changing privileges, or adding/removing tools for any current members.',

   'No group name provided.'
=> 'No group name provided.',

   'No groups exist.'
=> 'No groups exist.',

   'No info'
=> 'No info',

   'No information available'
=> 'No information available',

   'No information available for [_1].'
=> 'No information available for [_1].',

   'No information was found for this community request.'
=> 'No information was found for this community request.',

   'No information was found for this course request.'
=> 'No information was found for this course request.',

   'No institutional classlist data could be retrieved for [_1]'
=> 'No institutional classlist data could be retrieved for [_1]',

   'No limit'
=> 'No limit',

   'No login name specified'
=> 'No login name specified',

   'No mail sent matching supplied criteria'
=> 'No mail sent matching supplied criteria',

   'No map selected.'
=> 'No map selected.',

   'No match found for the above receipt number.'
=> 'No match found for the above receipt number.',

   'No match found for the last name [_1] in LON-CAPA domain: [_2]'
=> 'No match found for the last name [_1] in LON-CAPA domain: [_2]',

   'No match found for the last name [_1] in the institutional directory for domain: [_2]'
=> 'No match found for the last name [_1] in the institutional directory for domain: [_2]',

   'No match found for the last name [_1] in this course.'
=> 'No match found for the last name [_1] in this course.',

   'No match found for the last name, first name [_1] in LON-CAPA domain: [_2]'
=> 'No match found for the last name, first name [_1] in LON-CAPA domain: [_2]',

   'No match found for the last name, first name [_1] in the institutional directory for domain: [_2]'
=> 'No match found for the last name, first name [_1] in the institutional directory for domain: [_2]',

   'No match found for the last name, first name [_1] in this course.'
=> 'No match found for the last name, first name [_1] in this course.',

   'No match found for the username [_1] in LON-CAPA domain: [_2]'
=> 'No match found for the username [_1] in LON-CAPA domain: [_2]',

   'No match found for the username [_1] in the institutional directory for domain: [_2]'
=> 'No match found for the username [_1] in the institutional directory for domain: [_2]',

   'No match found for the username [_1] in this course.'
=> 'No match found for the username [_1] in this course.',

   'No matches found in postings.'
=> 'No matches found in postings.',

   'No matches found in resources.'
=> 'No matches found in resources.',

   'No members to add at this time, as there are no users matching the specified type(s), role(s) and section(s).'
=> 'No members to add at this time, as there are no users matching the specified type(s), role(s) and section(s).',

   'No members to be deleted or expired from the group.'
=> 'No members to be deleted or expired from the group.',

   'No message or record in user notes'
=> 'No message or record in user notes',

   'No messages have been selected to apply this action to.'
=> 'No messages have been selected to apply this action to.',

   'No messages sent.'
=> 'No messages sent.',

   'No new community created.'
=> 'No new community created.',

   'No new course created.'
=> 'No new course created.',

   'No new course messages'
=> 'No new course messages',

   'No new dynamic data found.'
=> 'No new dynamic data found.',

   'No notes, face-to-face discussion records, critical messages or broadcast messages in this [_1].'
=> 'No notes, face-to-face discussion records, critical messages or broadcast messages in this [_1].',

   'No notes, face-to-face discussion records, critical messages, or broadcast messages in this [_1].'
=> 'No notes, face-to-face discussion records, critical messages, or broadcast messages in this [_1].',

   'No notifications sent when an enrollment request needs approval, or has been approved.'
=> 'No notifications sent when an enrollment request needs approval, or has been approved.',

   'No official courses to display for [_1].'
=> 'No official courses to display for [_1].',

   'No override set'
=> 'No override set',

   'No override set for [_1]'
=> 'No override set for [_1]',

   'No page information provided.'
=> 'No page information provided.',

   'No personal information provided'
=> 'No personal information provided',

   'No problems require handgrading'
=> 'No problems require handgrading',

   'No problems satisfy threshold criteria'
=> 'No problems satisfy threshold criteria',

   'No problems with errors'
=> 'No problems with errors',

   'No recipients identified'
=> 'No recipients identified',

   'No record exists for the course ID'
=> 'No record exists for the course ID',

   'No recorded submission for this problem.'
=> 'No recorded submission for this problem.',

   'No redirect'
=> 'No redirect',

   'No replies to sender'
=> 'No replies to sender',

   'No restriction'
=> 'No restriction',

   'No rights to clone'
=> 'No rights to clone',

   'No role changes'
=> 'No role changes',

   'No roles'
=> 'No roles',

   'No roles added'
=> 'No roles added',

   'No roles to modify'
=> 'No roles to modify',

   'No saved comments yet for this resource.'
=> 'No saved comments yet for this resource.',

   'No saved comments yet.'
=> 'No saved comments yet.',

   'No score was changed or updated.'
=> 'No score was changed or updated.',

   'No scores stored for the following username(s):'
=> 'No scores stored for the following username(s):',

   'No section'
=> 'No section',

   'No settings chosen'
=> 'No settings chosen',

   'No slot name provided'
=> 'No slot name provided',

   'No slots have been created in this community.'
=> 'No slots have been created in this community.',

   'No slots have been created in this course.'
=> 'No slots have been created in this course.',

   'No start date'
=> 'No start date',

   'No students found.'
=> 'No students found.',

   'No subject'
=> 'No subject',

   'No such directory: [_1]'
=> 'No such directory: [_1]',

   'No such file: [_1]'
=> 'No such file: [_1]',

   'No such user [_1] at domain [_2].'
=> 'No such user [_1] at domain [_2].',

   'No such user: '
=> 'No such user: ',

   'No suitable categories defined for this course type in this domain.'
=> 'No suitable categories defined for this course type in this domain.',

   'No syllabus available'
=> 'No syllabus available',

   'No unread critical messages in course'
=> 'No unread critical messages in course',

   'No unread posts in course discussions'
=> 'No unread posts in course discussions',

   'No updated versions'
=> 'No updated versions',

   'No user information available'
=> 'No user information available',

   'No user personal information page available'
=> 'No user personal information page available',

   'No username and/or domain provided.'
=> 'No username and/or domain provided.',

   'No valid custom distribution rights file specified, FAIL'
=> 'No valid custom distribution rights file specified, FAIL',

   'No valid extension found in filename, FAIL'
=> 'No valid extension found in filename, FAIL',

   'No version changes since last month'
=> 'No version changes since last month',

   'No version changes since last week'
=> 'No version changes since last week',

   'No version changes since start of course'
=> 'No version changes since start of course',

   'No version changes since yesterday'
=> 'No version changes since yesterday',

   'No viewable classlist'
=> 'No viewable classlist',

   'No viewable membership list'
=> 'No viewable membership list',

   "No, don't show correct/incorrect feedback."
=> "No, don't show correct/incorrect feedback.",

   'No, show no feedback at all.'
=> 'No, show no feedback at all.',

   'Non-critical only'
=> 'Non-critical only',

   'Non-institutional only'
=> 'Non-institutional only',

   'Non-standard Course'
=> 'Non-standard Course',

   'Non-standard course - folder for all groups not added.'
=> 'Non-standard course - folder for all groups not added.',

   'None'
=> 'None',

   'None available'
=> 'None available',

   'None of the [_1] students in the course[_2] have opted to be listed in the roster.'
=> 'None of the [_1] students in the course[_2] have opted to be listed in the roster.',

   'None of the [_1] students in the section[_2] have opted to be listed in the roster.'
=> 'None of the [_1] students in the section[_2] have opted to be listed in the roster.',

   'None of the [_1] students without a section[_2] have opted to be listed in the roster.'
=> 'None of the [_1] students without a section[_2] have opted to be listed in the roster.',

   'None of the selected students attempted the problem more than [quant,_1,time].'
=> 'None of the selected students attempted the problem more than [quant,_1,time].',

   'None of the selected students have attempted the problem.'
=> 'None of the selected students have attempted the problem.',

   'None specified'
=> 'None specified',

   'None specified - use domain default'
=> 'None specified - use domain default',

   "None specified - use member's choice"
=> "None specified - use member's choice",

   "None specified - use student's choice"
=> "None specified - use student's choice",

   'Normal (default)'
=> 'Normal (default)',

   'Normal list'
=> 'Normal list',

   'Not Available'
=> 'Not Available',

   'Not Open'
=> 'Not Open',

   'Not a valid group for this course'
=> 'Not a valid group for this course',

   'Not a valid user:domain'
=> 'Not a valid user:domain',

   'Not active anymore'
=> 'Not active anymore',

   'Not all requested personnel could be included.'
=> 'Not all requested personnel could be included.',

   'Not allowed to modify grades for [_1]'
=> 'Not allowed to modify grades for [_1]',

   'Not applicable'
=> 'Not applicable',

   'Not applicable -'
=> 'Not applicable -',

   'Not authorized'
=> 'Not authorized',

   'Not available'
=> 'Not available',

   'Not currently assigned.'
=> 'Not currently assigned.',

   'Not enabled'
=> 'Not enabled',

   'Not new'
=> 'Not new',

   'Not permitted'
=> 'Not permitted',

   'Not registered'
=> 'Not registered',

   'Not shown'
=> 'Not shown',

   'Not specified'
=> 'Not specified',

   'Not within time window for auto-enrollment in [_1]'
=> 'Not within time window for auto-enrollment in [_1]',

   'Note'
=> 'Note',

   'Note for students:'
=> 'Note for students:',

   'Note that grading records for problems included in this sequence or folder will overlap.'
=> 'Note that grading records for problems included in this sequence or folder will overlap.',

   'Note: Any students added manually by course coordinators using the Enrollment Manager will be unaffected by the nightly removal process if you choose to enable it.'
=> 'Note: Any students added manually by course coordinators using the Enrollment Manager will be unaffected by the nightly removal process if you choose to enable it.',

   'Note: This operation may be time consuming when adding several users.'
=> 'Note: This operation may be time consuming when adding several users.',

   'Note: in anonymous discussion, your name is visible only to community facilitators'
=> 'Note: in anonymous discussion, your name is visible only to community facilitators',

   'Note: in anonymous discussion, your name is visible only to course faculty'
=> 'Note: in anonymous discussion, your name is visible only to course faculty',

   'Note: the path is in reference to the root of your construction space, and new directories will be automatically created.'
=> 'Note: the path is in reference to the root of your construction space, and new directories will be automatically created.',

   'Nothing submitted - no attempts.'
=> 'Nothing submitted - no attempts.',

   'Nothing submitted.'
=> 'Nothing submitted.',

   'Notification active'
=> 'Notification active',

   'Notification address'
=> 'Notification address',

   'Notification inactive'
=> 'Notification inactive',

   'Notification messages - sender'
=> 'Notification messages - sender',

   'Notification of LON-CAPA course roster changes resulting from nightly automated enrollment process?'
=> 'Notification of LON-CAPA course roster changes resulting from nightly automated enrollment process?',

   'Notification of changes'
=> 'Notification of changes',

   'Notification of enrollment changes now'
=> 'Notification of enrollment changes now',

   'Notification of enrollment changes still'
=> 'Notification of enrollment changes still',

   'Notification to domain coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to domain coordinator via LON-CAPA message when enrollment changes occur during the automated update?',

   'Notification?'
=> 'Notification?',

   'Notifying host'
=> 'Notifying host',

   'Num Student'
=> 'Num Student',

   'Num Students'
=> 'Num Students',

   'Num. students'
=> 'Num. students',

   'Number of Courses in Hotlist'
=> 'Number of Courses in Hotlist',

   'Number of Courses in Hotlist:'
=> 'Number of Courses in Hotlist:',

   'Number of Plots [_1]'
=> 'Number of Plots [_1]',

   'Number of Problem Parts completed successfully'
=> 'Number of Problem Parts completed successfully',

   'Number of Roles in Hotlist'
=> 'Number of Roles in Hotlist',

   'Number of Tries before hints appear'
=> 'Number of Tries before hints appear',

   'Number of Tries before success on each Problem Part'
=> 'Number of Tries before success on each Problem Part',

   'Number of accesses'
=> 'Number of accesses',

   'Number of bubbles in exam mode'
=> 'Number of bubbles in exam mode',

   'Number of errors'
=> 'Number of errors',

   'Number of new posts'
=> 'Number of new posts',

   'Number of new sections to add:'
=> 'Number of new sections to add:',

   'Number of roles in Hotlist:'
=> 'Number of roles in Hotlist:',

   'Number to add: '
=> 'Number to add: ',

   'Number ungraded'
=> 'Number ungraded',

   'Numerical Problems'
=> 'Numerical Problems',

   'Numerical Response'
=> 'Numerical Response',

   'Numerical Tolerance'
=> 'Numerical Tolerance',

   'Numerical limit'
=> 'Numerical limit',

   'OFF'
=> 'OFF',

   'OK'
=> 'OK',

   'ON'
=> 'ON',

   'OS'
=> 'OS',

   'Off'
=> 'Off',

   'Official'
=> 'Official',

   'Official course'
=> 'Official course',

   'Official course code'
=> 'Official course code',

   'Official course:'
=> 'Official course:',

   'Official courses'
=> 'Official courses',

   'Official courses (with institutional codes)'
=> 'Official courses (with institutional codes)',

   'Offline - replace Log-in page'
=> 'Offline - replace Log-in page',

   'On'
=> 'On',

   'Once displayed'
=> 'Once displayed',

   'Once marked not NEW'
=> 'Once marked not NEW',

   'One example is for management of laboratory space, which is only available at certain times, and has a limited number of seats.'
=> 'One example is for management of laboratory space, which is only available at certain times, and has a limited number of seats.',

   'One group portfolio file is available.'
=> 'One group portfolio file is available.',

   'One of Multiple Answers Numerical Problem'
=> 'One of Multiple Answers Numerical Problem',

   'One or more password fields were blank'
=> 'One or more password fields were blank',

   'One portfolio file owned by [_1] is available.'
=> 'One portfolio file owned by [_1] is available.',

   'Online - restore Log-in page'
=> 'Online - restore Log-in page',

   'Online Survey'
=> 'Online Survey',

   'Only a Domain Coordinator may assign a course category or choose to exclude this course from the catalog.'
=> 'Only a Domain Coordinator may assign a course category or choose to exclude this course from the catalog.',

   'Only a number required. Computer reads units of "[_1]".'
=> 'Only a number required. Computer reads units of "[_1]".',

   'Only active roles'
=> 'Only active roles',

   'Only changes made from servers running LON-CAPA [_1] or later are displayed.'
=> 'Only changes made from servers running LON-CAPA [_1] or later are displayed.',

   'Only courses and communities created from servers running LON-CAPA [_1] or later are displayed.'
=> 'Only courses and communities created from servers running LON-CAPA [_1] or later are displayed.',

   'Only empty directories may be deleted.'
=> 'Only empty directories may be deleted.',

   'Only future roles'
=> 'Only future roles',

   'Only letters, numbers, periods, dashes, @, and underscores are valid.'
=> 'Only letters, numbers, periods, dashes, @, and underscores are valid.',

   'Only letters, numbers, periods, dashes, and underscores are valid.'
=> 'Only letters, numbers, periods, dashes, and underscores are valid.',

   'Only past roles'
=> 'Only past roles',

   'Only show communities which allow self-enrollment'
=> 'Only show communities which allow self-enrollment',

   'Only show courses which allow self-enrollment'
=> 'Only show courses which allow self-enrollment',

   'Only students who have opted to be listed in the roster ([_1] out of [_2] students) are shown.'
=> 'Only students who have opted to be listed in the roster ([_1] out of [_2] students) are shown.',

   'Open '
=> 'Open ',

   'Open (and edit) cleaned up file in new window'
=> 'Open (and edit) cleaned up file in new window',

   'Open - XML source is open to people who want to use it'
=> 'Open - XML source is open to people who want to use it',

   'Open Folder'
=> 'Open Folder',

   'Open in a new window'
=> 'Open in a new window',

   'Opening'
=> 'Opening',

   'Opening all assignments'
=> 'Opening all assignments',

   'Option Response - Concept Groups'
=> 'Option Response - Concept Groups',

   'Option Response - Matching'
=> 'Option Response - Matching',

   'Option Response - True/False'
=> 'Option Response - True/False',

   'Option to mark each post as read/unread?'
=> 'Option to mark each post as read/unread?',

   'Optional file upload'
=> 'Optional file upload',

   'Optional privileges'
=> 'Optional privileges',

   'Options'
=> 'Options',

   'Options:'
=> 'Options:',

   'Order Metadata Fields'
=> 'Order Metadata Fields',

   'Organic Material Response'
=> 'Organic Material Response',

   'Organic Material Response with Hint'
=> 'Organic Material Response with Hint',

   'Original file'
=> 'Original file',

   'Original screen output (if applicable)'
=> 'Original screen output (if applicable)',

   'Other'
=> 'Other',

   'Other Roles'
=> 'Other Roles',

   'Other domain:'
=> 'Other domain:',

   'Other domains can search?'
=> 'Other domains can search?',

   'Other named users'
=> 'Other named users',

   'Other settings'
=> 'Other settings',

   'Others'
=> 'Others',

   'Otherwise, if you have an institutional login, [_1]create an account[_2].'
=> 'Otherwise, if you have an institutional login, [_1]create an account[_2].',

   "Otherwise, use your institution's [_1]single sign on page[_2] to log-in, then create an account."
=> "Otherwise, use your institution's [_1]single sign on page[_2] to log-in, then create an account.",

   'Otherwise, you will use an e-mail address to [_1]create an account[_2].'
=> 'Otherwise, you will use an e-mail address to [_1]create an account[_2].',

   'Otherwise:'
=> 'Otherwise:',

   'Output Data'
=> 'Output Data',

   'Output Tags'
=> 'Output Tags',

   'Output of decompress:'
=> 'Output of decompress:',

   'Overall'
=> 'Overall',

   'Overall Assessment Statistical Data'
=> 'Overall Assessment Statistical Data',

   'Overall result: [_1]'
=> 'Overall result: [_1]',

   'Override "Correct"'
=> 'Override "Correct"',

   'Overview'
=> 'Overview',

   'Overview Mode'
=> 'Overview Mode',

   'Overwrite'
=> 'Overwrite',

   'Owner'
=> 'Owner',

   'Owner and Coordinators included automatically'
=> 'Owner and Coordinators included automatically',

   'Owner(s)'
=> 'Owner(s)',

   'Owner/Co-owner(s)'
=> 'Owner/Co-owner(s)',

   'Owner:Domain'
=> 'Owner:Domain',

   'PDF File'
=> 'PDF File',

   'PDF-Formfields'
=> 'PDF-Formfields',

   'Package update alerts to be e-mailed to'
=> 'Package update alerts to be e-mailed to',

   'Page Background Color'
=> 'Page Background Color',

   'Page Display Settings'
=> 'Page Display Settings',

   'Page Title'
=> 'Page Title',

   'Page display controlled by'
=> 'Page display controlled by',

   "Page displayed after role selection in community now set by [_1]user's global preferences[_2]."
=> "Page displayed after role selection in community now set by [_1]user's global preferences[_2].",

   "Page displayed after role selection in course now set by [_1]user's global preferences[_2]."
=> "Page displayed after role selection in course now set by [_1]user's global preferences[_2].",

   'Page displayed after role selection in this course set to [_1].'
=> 'Page displayed after role selection in this course set to [_1].',

   'Page requested in unexpected context'
=> 'Page requested in unexpected context',

   'Page set to be displayed after you have selected a role in this course'
=> 'Page set to be displayed after you have selected a role in this course',

   'Parameter Change Log'
=> 'Parameter Change Log',

   'Parameter Change Log and Course Blog Posting/User Notification'
=> 'Parameter Change Log and Course Blog Posting/User Notification',

   'Parameter Manager'
=> 'Parameter Manager',

   'Parameter Selection'
=> 'Parameter Selection',

   'Parameter Specification'
=> 'Parameter Specification',

   'Parameters'
=> 'Parameters',

   'Parameters for a response'
=> 'Parameters for a response',

   'Parameters not set for [_1] because the contents of the community could not be retrieved.'
=> 'Parameters not set for [_1] because the contents of the community could not be retrieved.',

   'Parameters not set for [_1] because the resource was not recognized as part of the community.'
=> 'Parameters not set for [_1] because the resource was not recognized as part of the community.',

   'Parameters not set for [_1] because the resource was not recognized as part of the course.'
=> 'Parameters not set for [_1] because the resource was not recognized as part of the course.',

   'Parameters:'
=> 'Parameters:',

   'Parsing results'
=> 'Parsing results',

   'Part '
=> 'Part ',

   'Part Description'
=> 'Part Description',

   'Part ID:'
=> 'Part ID:',

   'Part ID: [_1]'
=> 'Part ID: [_1]',

   'Part Parameters'
=> 'Part Parameters',

   'Part [_1], Response [_2]'
=> 'Part [_1], Response [_2]',

   'Part(s) graded correct by the computer is marked with a [_1] symbol.'
=> 'Part(s) graded correct by the computer is marked with a [_1] symbol.',

   'Part: [_1]'
=> 'Part: [_1]',

   'Partially Correct'
=> 'Partially Correct',

   'Parts'
=> 'Parts',

   'Parts Correct'
=> 'Parts Correct',

   'Passphrase'
=> 'Passphrase',

   'Passphrase-protected'
=> 'Passphrase-protected',

   'Passphrase-protected access: [_1]'
=> 'Passphrase-protected access: [_1]',

   'Passphrase-protected files do not require log-in, but will require the viewer to enter the passphrase you set.'
=> 'Passphrase-protected files do not require log-in, but will require the viewer to enter the passphrase you set.',

   'Passwords must be a minimum of 7 characters long.'
=> 'Passwords must be a minimum of 7 characters long.',

   'Passwords must be a minimum of 7 characters long. Please try again.'
=> 'Passwords must be a minimum of 7 characters long. Please try again.',

   'Paste'
=> 'Paste',

   'Paste failed: an error occurred creating a unique URL for the composite page'
=> 'Paste failed: an error occurred creating a unique URL for the composite page',

   'Paste failed: an error occurred creating a unique URL for the folder'
=> 'Paste failed: an error occurred creating a unique URL for the folder',

   'Paste failed: an error occurred saving the composite page'
=> 'Paste failed: an error occurred saving the composite page',

   'Paste failed: an error occurred saving the folder'
=> 'Paste failed: an error occurred saving the folder',

   'Pending community requests'
=> 'Pending community requests',

   'Pending course/community requests'
=> 'Pending course/community requests',

   'Pending enrollment requests'
=> 'Pending enrollment requests',

   'Pending requests for official courses'
=> 'Pending requests for official courses',

   'Pending requests for unofficial courses'
=> 'Pending requests for unofficial courses',

   'Percentage points for correct solution'
=> 'Percentage points for correct solution',

   'Percentage points for incorrect solution'
=> 'Percentage points for incorrect solution',

   'Permanent e-mail address'
=> 'Permanent e-mail address',

   'Personal Information Page'
=> 'Personal Information Page',

   'Personal Information Page - [_1]'
=> 'Personal Information Page - [_1]',

   'Personal Information Page Availability'
=> 'Personal Information Page Availability',

   'Personal Information Page for a User'
=> 'Personal Information Page for a User',

   'Personal Information Page of '
=> 'Personal Information Page of ',

   'Personnel'
=> 'Personnel',

   'Personnel to be notified when an enrollment request needs approval, or has been approved:'
=> 'Personnel to be notified when an enrollment request needs approval, or has been approved:',

   'Phone'
=> 'Phone',

   'Pick'
=> 'Pick',

   'Pick Action'
=> 'Pick Action',

   'Pick a Date'
=> 'Pick a Date',

   'Pick action'
=> 'Pick action',

   'Pick another action'
=> 'Pick another action',

   'Pick course first'
=> 'Pick course first',

   'Pick custom role'
=> 'Pick custom role',

   'Pick functionality'
=> 'Pick functionality',

   'Pick group first'
=> 'Pick group first',

   'Pick main category'
=> 'Pick main category',

   'Pick roles and sections for automatic group enrollment'
=> 'Pick roles and sections for automatic group enrollment',

   'Pick specific communities:'
=> 'Pick specific communities:',

   'Pick specific course(s):'
=> 'Pick specific course(s):',

   'Pick specific users (by name)'
=> 'Pick specific users (by name)',

   'Pick subcategory'
=> 'Pick subcategory',

   'Pick the action to take on roles for these users:'
=> 'Pick the action to take on roles for these users:',

   'Pick the criteria to use to build a list of community participants from which you will select '
=> 'Pick the criteria to use to build a list of community participants from which you will select ',

   'Pick the criteria to use to build a list of course users from which you will select '
=> 'Pick the criteria to use to build a list of course users from which you will select ',

   'Pick the criteria to use to build a list of course users from which you will select additional members of the group.'
=> 'Pick the criteria to use to build a list of course users from which you will select additional members of the group.',

   'Pick the criteria to use to build a list of course users from which you will select members of the new group.'
=> 'Pick the criteria to use to build a list of course users from which you will select members of the new group.',

   'Picture Conversion Status'
=> 'Picture Conversion Status',

   'Please [_1]add the user(s)[_2] before returning to the [_3]Community Configuration[_2] to add as potential cloners.'
=> 'Please [_1]add the user(s)[_2] before returning to the [_3]Community Configuration[_2] to add as potential cloners.',

   'Please [_1]add the user(s)[_2] before returning to the [_3]Course Configuration[_2] to add as potential cloners.'
=> 'Please [_1]add the user(s)[_2] before returning to the [_3]Course Configuration[_2] to add as potential cloners.',

   'Please [_1]go back[_2] and choose a different section name.'
=> 'Please [_1]go back[_2] and choose a different section name.',

   'Please [_1]go back[_2] and try again.'
=> 'Please [_1]go back[_2] and try again.',

   'Please [_1]go back[_2] to select either content items or discussions for export.'
=> 'Please [_1]go back[_2] to select either content items or discussions for export.',

   'Please [_1]log in again[_2].'
=> 'Please [_1]log in again[_2].',

   'Please alert a domain coordinator of this situation'
=> 'Please alert a domain coordinator of this situation',

   'Please alert your LON-CAPA administrator.'
=> 'Please alert your LON-CAPA administrator.',

   'Please attempt to login to one of the following servers:'
=> 'Please attempt to login to one of the following servers:',

   'Please be patient'
=> 'Please be patient',

   'Please change the extension.'
=> 'Please change the extension.',

   'Please check the username and password.'
=> 'Please check the username and password.',

   'Please choose a PDF-File.'
=> 'Please choose a PDF-File.',

   'Please choose a different section name'
=> 'Please choose a different section name',

   'Please choose a different section name.'
=> 'Please choose a different section name.',

   'Please choose the CMS used to create your IMS content package:'
=> 'Please choose the CMS used to create your IMS content package:',

   'Please click Back on your browser and select another user, or [_1]Create User[_2]'
=> 'Please click Back on your browser and select another user, or [_1]Create User[_2]',

   'Please click on the the resource you intend to access'
=> 'Please click on the the resource you intend to access',

   'Please contact the [_1] ([_2]) for assistance.'
=> 'Please contact the [_1] ([_2]) for assistance.',

   'Please contact the [_1]helpdesk[_2] for assistance.'
=> 'Please contact the [_1]helpdesk[_2] for assistance.',

   'Please contact the [_1]helpdesk[_2] if you need to create a new user.'
=> 'Please contact the [_1]helpdesk[_2] if you need to create a new user.',

   'Please contact your [_1]helpdesk[_2] for more information.'
=> 'Please contact your [_1]helpdesk[_2] for more information.',

   'Please describe what you did just before this screen came up'
=> 'Please describe what you did just before this screen came up',

   'Please either [_1]close this window[_2] or [_3]log in again[_4].'
=> 'Please either [_1]close this window[_2] or [_3]log in again[_4].',

   'Please either [_1]continue the current session[_2] or [_3]log out[_4].'
=> 'Please either [_1]continue the current session[_2] or [_3]log out[_4].',

   'Please enter a receipt number given by a student in the receipt box.'
=> 'Please enter a receipt number given by a student in the receipt box.',

   'Please enter both user and domain in the format user:domain'
=> 'Please enter both user and domain in the format user:domain',

   'Please enter the directory that you would like the source code to go into.'
=> 'Please enter the directory that you would like the source code to go into.',

   'Please enter the username and domain of the LON-CAPA account, and the associated e-mail address, for which you are setting a password. The new password must contain at least 7 characters.'
=> 'Please enter the username and domain of the LON-CAPA account, and the associated e-mail address, for which you are setting a password. The new password must contain at least 7 characters.',

   'Please fill out all fields below.'
=> 'Please fill out all fields below.',

   'Please help us to find out what.'
=> 'Please help us to find out what.',

   'Please log into [_1] to edit.'
=> 'Please log into [_1] to edit.',

   'Please log out and try again.'
=> 'Please log out and try again.',

   'Please make sure your old password was entered correctly.'
=> 'Please make sure your old password was entered correctly.',

   'Please modify your selections so they include no more than one section'
=> 'Please modify your selections so they include no more than one section',

   'Please modify your selections so they include no more than one section.'
=> 'Please modify your selections so they include no more than one section.',

   'Please notify the server administrator [_1]'
=> 'Please notify the server administrator [_1]',

   'Please provide user information and a password for your new account.'
=> 'Please provide user information and a password for your new account.',

   'Please refer to [_1]'
=> 'Please refer to [_1]',

   'Please review the information in "Log-in help" and the "Getting started" guide if you are unable to log-in.'
=> 'Please review the information in "Log-in help" and the "Getting started" guide if you are unable to log-in.',

   'Please review the information in "Log-in help" if you are unable to log-in.'
=> 'Please review the information in "Log-in help" if you are unable to log-in.',

   'Please select'
=> 'Please select',

   'Please select a Survey to analyze'
=> 'Please select a Survey to analyze',

   'Please select a different role.'
=> 'Please select a different role.',

   'Please select a feedback type.'
=> 'Please select a feedback type.',

   'Please select a student or group of students before clicking on the Next button.'
=> 'Please select a student or group of students before clicking on the Next button.',

   'Please select an action to perform using the new filename'
=> 'Please select an action to perform using the new filename',

   'Please select problems and use the [_1]Prepare Report[_2] button to continue.'
=> 'Please select problems and use the [_1]Prepare Report[_2] button to continue.',

   'Please select the group you wish to set the answer open date for:'
=> 'Please select the group you wish to set the answer open date for:',

   'Please select the group you wish to set the due date for:'
=> 'Please select the group you wish to set the due date for:',

   'Please select the group you wish to set the number of tries for:'
=> 'Please select the group you wish to set the number of tries for:',

   'Please select the group you wish to set the opening date for:'
=> 'Please select the group you wish to set the opening date for:',

   'Please select the group you wish to set the problem weight for:'
=> 'Please select the group you wish to set the problem weight for:',

   'Please select the locations from which the referenced files are to be uploaded.'
=> 'Please select the locations from which the referenced files are to be uploaded.',

   'Please select the student before clicking on the Next button.'
=> 'Please select the student before clicking on the Next button.',

   'Please select the student you wish to grade.'
=> 'Please select the student you wish to grade.',

   'Please select the type of LON-CAPA entity - Course or Group - for which you wish to add/modify a user role'
=> 'Please select the type of LON-CAPA entity - Course or Group - for which you wish to add/modify a user role',

   'Please specify login data below'
=> 'Please specify login data below',

   'Please stand by while processing your print request, this may take some time ...'
=> 'Please stand by while processing your print request, this may take some time ...',

   'Please submit a [_1]new request[_2] for account creation and follow the new link included in the e-mail that will be sent to you.'
=> 'Please submit a [_1]new request[_2] for account creation and follow the new link included in the e-mail that will be sent to you.',

   'Please take a moment to fill out the form below.'
=> 'Please take a moment to fill out the form below.',

   'Please try again later.'
=> 'Please try again later.',

   'Please try again.'
=> 'Please try again.',

   "Please uncheck 'activate' or check at least one type."
=> "Please uncheck 'activate' or check at least one type.",

   'Please upload an UTF8 encoded file to ensure a correct character encoding in your classlist.'
=> 'Please upload an UTF8 encoded file to ensure a correct character encoding in your classlist.',

   'Please use a different name for the new top level category'
=> 'Please use a different name for the new top level category',

   "Please use the 'Select Course' link to open a separate pick course window where you may select the course you wish to enter"
=> "Please use the 'Select Course' link to open a separate pick course window where you may select the course you wish to enter",

   "Please use the 'Select Course' link to open a separate window where you can search for a course to which a file can be uploaded."
=> "Please use the 'Select Course' link to open a separate window where you can search for a course to which a file can be uploaded.",

   "Please use the 'Select Course/Community' link to open a separate pick course window where you may select the course or community you wish to enter."
=> "Please use the 'Select Course/Community' link to open a separate pick course window where you may select the course or community you wish to enter.",

   'Please use the LON-CAPA navigation arrows to move to another item in the course'
=> 'Please use the LON-CAPA navigation arrows to move to another item in the course',

   'Please use the browse button to select a file from your local directory.'
=> 'Please use the browse button to select a file from your local directory.',

   'Please use the browser "Back" button and correct the recipient addresses ([_1]).'
=> 'Please use the browser "Back" button and correct the recipient addresses ([_1]).',

   'Plot Graph'
=> 'Plot Graph',

   'Plots'
=> 'Plots',

   'Points'
=> 'Points',

   'Points Display'
=> 'Points Display',

   'Points Scored'
=> 'Points Scored',

   'Points:'
=> 'Points:',

   'Polygon'
=> 'Polygon',

   'Portfolio'
=> 'Portfolio',

   'Portfolio Availability'
=> 'Portfolio Availability',

   'Portfolio Manager'
=> 'Portfolio Manager',

   'Portfolio Metadata'
=> 'Portfolio Metadata',

   'Portfolio Search'
=> 'Portfolio Search',

   'Portfolio and Catalog Search'
=> 'Portfolio and Catalog Search',

   'Portfolio and Course Search'
=> 'Portfolio and Course Search',

   'Portfolio files belonging to [_1] will be inaccessible between [_2] and [_3] because communication is being blocked.'
=> 'Portfolio files belonging to [_1] will be inaccessible between [_2] and [_3] because communication is being blocked.',

   'Portfolio files for [_1]'
=> 'Portfolio files for [_1]',

   'Portfolio files previously selected: [_1]'
=> 'Portfolio files previously selected: [_1]',

   'Portfolio quota'
=> 'Portfolio quota',

   'Positive Floating Point'
=> 'Positive Floating Point',

   'Positive floating point number or zero'
=> 'Positive floating point number or zero',

   'Post'
=> 'Post',

   'Post Announcement'
=> 'Post Announcement',

   'Post Anonymous'
=> 'Post Anonymous',

   'Post Anonymous Discussion'
=> 'Post Anonymous Discussion',

   'Post Server Announcements'
=> 'Post Server Announcements',

   'Post announcements to the system login and roles screen'
=> 'Post announcements to the system login and roles screen',

   'Post this Record'
=> 'Post this Record',

   'Post to chat rooms'
=> 'Post to chat rooms',

   'Posting [_1]'
=> 'Posting [_1]',

   'Posts cease to be marked "NEW"'
=> 'Posts cease to be marked "NEW"',

   'Posts displayed?'
=> 'Posts displayed?',

   'Posts not marked read'
=> 'Posts not marked read',

   'Posts to be displayed'
=> 'Posts to be displayed',

   'Practice'
=> 'Practice',

   'Practice Problem'
=> 'Practice Problem',

   'Preferences'
=> 'Preferences',

   'Preferences can be set for this discussion that determine ....'
=> 'Preferences can be set for this discussion that determine ....',

   'Preferences can be set that determine'
=> 'Preferences can be set that determine',

   'Preferences on what is marked as NEW'
=> 'Preferences on what is marked as NEW',

   'Preferred method to display Math'
=> 'Preferred method to display Math',

   'Preferred method to display math'
=> 'Preferred method to display math',

   'Prepare Report'
=> 'Prepare Report',

   'Prepare reports of student submissions.'
=> 'Prepare reports of student submissions.',

   'Prepare reports on survey results.'
=> 'Prepare reports on survey results.',

   'Press "Generate Statistics" when you are ready.'
=> 'Press "Generate Statistics" when you are ready.',

   'Prev'
=> 'Prev',

   'Preview'
=> 'Preview',

   'Previous Problem'
=> 'Previous Problem',

   'Previous Student'
=> 'Previous Student',

   'Previous Student ([_1])'
=> 'Previous Student ([_1])',

   'Previous Survey'
=> 'Previous Survey',

   'Previous Tries'
=> 'Previous Tries',

   'Previous Value:'
=> 'Previous Value:',

   'Previous [_1] changes'
=> 'Previous [_1] changes',

   'Previous access'
=> 'Previous access',

   'Previous attempts of student (if applicable)'
=> 'Previous attempts of student (if applicable)',

   'Previously Had Access'
=> 'Previously Had Access',

   'Previously had access'
=> 'Previously had access',

   'Previously published version'
=> 'Previously published version',

   'Print Annotations'
=> 'Print Annotations',

   'Print Answers'
=> 'Print Answers',

   'Print Discussions'
=> 'Print Discussions',

   'Print Options'
=> 'Print Options',

   'Print contents of directory'
=> 'Print contents of directory',

   'Print directory'
=> 'Print directory',

   'Print for other users and entire course'
=> 'Print for other users and entire course',

   'Print header format'
=> 'Print header format',

   'Print options:'
=> 'Print options:',

   'Printout generation'
=> 'Printout generation',

   'Privilege'
=> 'Privilege',

   'Privileged users (Domain Coordinators) in staff listing'
=> 'Privileged users (Domain Coordinators) in staff listing',

   'Privileges'
=> 'Privileges',

   'Problem Answer Date'
=> 'Problem Answer Date',

   'Problem Answer Date (answerdate)'
=> 'Problem Answer Date (answerdate)',

   'Problem Appearance'
=> 'Problem Appearance',

   'Problem Dates'
=> 'Problem Dates',

   'Problem Document'
=> 'Problem Document',

   'Problem Due Date'
=> 'Problem Due Date',

   'Problem Due Date (duedate)'
=> 'Problem Due Date (duedate)',

   'Problem Editing'
=> 'Problem Editing',

   'Problem Name'
=> 'Problem Name',

   'Problem Opening Date'
=> 'Problem Opening Date',

   'Problem Opening Date (opendate)'
=> 'Problem Opening Date (opendate)',

   'Problem Parameters'
=> 'Problem Parameters',

   'Problem Part'
=> 'Problem Part',

   'Problem Statistics'
=> 'Problem Statistics',

   'Problem Status:'
=> 'Problem Status:',

   'Problem Testing'
=> 'Problem Testing',

   'Problem Text'
=> 'Problem Text',

   'Problem Type'
=> 'Problem Type',

   'Problem Type:'
=> 'Problem Type:',

   'Problem is available at a different location.'
=> 'Problem is available at a different location.',

   'Problem is currently available.'
=> 'Problem is currently available.',

   'Problem is not open to be viewed. It'
=> 'Problem is not open to be viewed. It',

   'Problem is unavailable.'
=> 'Problem is unavailable.',

   'Problem will be available later.'
=> 'Problem will be available later.',

   'Problems during Course Initialization'
=> 'Problems during Course Initialization',

   'Problems from'
=> 'Problems from',

   'Problems from the Whole Course'
=> 'Problems from the Whole Course',

   'Problems graded correct by the computer are marked with a [_1] symbol.'
=> 'Problems graded correct by the computer are marked with a [_1] symbol.',

   'Problems occurred in creating the new Excel file.'
=> 'Problems occurred in creating the new Excel file.',

   'Problems occurred in creating the output file.'
=> 'Problems occurred in creating the output file.',

   'Problems occurred in writing the CSV file.'
=> 'Problems occurred in writing the CSV file.',

   'Problems requiring handgrading'
=> 'Problems requiring handgrading',

   'Problems with errors'
=> 'Problems with errors',

   'Proceed'
=> 'Proceed',

   'Process'
=> 'Process',

   'Process Clicker'
=> 'Process Clicker',

   'Processed [quant,_1,student].'
=> 'Processed [quant,_1,student].',

   'Processed [quant,_1,user].'
=> 'Processed [quant,_1,user].',

   'Processed file: [_1]'
=> 'Processed file: [_1]',

   'Processing of submitted course request'
=> 'Processing of submitted course request',

   'Proper comma separation is required'
=> 'Proper comma separation is required',

   'Provide choices for students to select from'
=> 'Provide choices for students to select from',

   "Provide comma-separated list. Use '*' for any answer correct, '-' for skip"
=> "Provide comma-separated list. Use '*' for any answer correct, '-' for skip",

   'Provide text area for students to type metadata'
=> 'Provide text area for students to type metadata',

   'Provide the proposed username'
=> 'Provide the proposed username',

   'Provide your e-mail address to request a LON-CAPA account,[_1] if you do not have a log-in ID at your institution.'
=> 'Provide your e-mail address to request a LON-CAPA account,[_1] if you do not have a log-in ID at your institution.',

   'Public RSS/podcast (subscribe to)'
=> 'Public RSS/podcast (subscribe to)',

   'Public RSS/podcast (subscribe to):'
=> 'Public RSS/podcast (subscribe to):',

   'Public access: [_1]'
=> 'Public access: [_1]',

   'Public files are available to anyone without the need for login.'
=> 'Public files are available to anyone without the need for login.',

   'Publish this Directory'
=> 'Publish this Directory',

   'Published Map'
=> 'Published Map',

   'Published Resources'
=> 'Published Resources',

   'Published documents'
=> 'Published documents',

   'Published on ...'
=> 'Published on ...',

   'Publishing [_1]'
=> 'Publishing [_1]',

   'Quarter Points'
=> 'Quarter Points',

   'Question [_1]'
=> 'Question [_1]',

   'Question pools'
=> 'Question pools',

   'Question/Comment/Feedback about community content'
=> 'Question/Comment/Feedback about community content',

   'Question/Comment/Feedback about course content'
=> 'Question/Comment/Feedback about course content',

   'Questions about:'
=> 'Questions about:',

   'Queue Status'
=> 'Queue Status',

   'Queued course request for [_1] submitted by [_2] with status [_3] rejected when validating.'
=> 'Queued course request for [_1] submitted by [_2] with status [_3] rejected when validating.',

   'Queued course request for [_1] submitted by [_2] with status [_3] switched to "approval by DC" because of validation error: [_4].'
=> 'Queued course request for [_1] submitted by [_2] with status [_3] switched to "approval by DC" because of validation error: [_4].',

   'Queued pending approval'
=> 'Queued pending approval',

   'Queued pending validation'
=> 'Queued pending validation',

   'Quit Grading'
=> 'Quit Grading',

   'Quizzes'
=> 'Quizzes',

   'Quota (Mb)'
=> 'Quota (Mb)',

   'Quota allocated to group portfolio:'
=> 'Quota allocated to group portfolio:',

   'RSS Feeds and Blogs'
=> 'RSS Feeds and Blogs',

   'Radio Button Response'
=> 'Radio Button Response',

   'Random Order'
=> 'Random Order',

   'Randomize Foil Order:'
=> 'Randomize Foil Order:',

   'Randomly Labelled Image with Option Response'
=> 'Randomly Labelled Image with Option Response',

   'Randomly Order Resources'
=> 'Randomly Order Resources',

   'Randomly Order Resources (randomorder)'
=> 'Randomly Order Resources (randomorder)',

   'Randomly Pick: '
=> 'Randomly Pick: ',

   'Randomly labeled image'
=> 'Randomly labeled image',

   'Randomly pick number of resources'
=> 'Randomly pick number of resources',

   'Rank Response'
=> 'Rank Response',

   'Raw (Screen Reader)'
=> 'Raw (Screen Reader)',

   'Re-Enable'
=> 'Re-Enable',

   'Re-Enter Key'
=> 'Re-Enter Key',

   'Re-Select'
=> 'Re-Select',

   'Re-enable'
=> 'Re-enable',

   'Re-enable a deleted group'
=> 'Re-enable a deleted group',

   'Re-enable expired user roles'
=> 'Re-enable expired user roles',

   'Re-enabled'
=> 'Re-enabled',

   "Re-enabled role of '[_1]' in [_2] for [_3]"
=> "Re-enabled role of '[_1]' in [_2] for [_3]",

   'Re-enabled role(s) for [quant,_1,user,users,no users].'
=> 'Re-enabled role(s) for [quant,_1,user,users,no users].',

   'Re-enabling [_1] in [_2]: [_3]'
=> 'Re-enabling [_1] in [_2]: [_3]',

   'Re-enabling custom role [_1] by [_2] in [_3]: [_4]'
=> 'Re-enabling custom role [_1] by [_2] in [_3]: [_4]',

   'Re-enabling custom role [_1] by [_2]:[_3] in [_4] : [_5]'
=> 'Re-enabling custom role [_1] by [_2]:[_3] in [_4] : [_5]',

   'Re-enabling group failed.'
=> 'Re-enabling group failed.',

   'Re-enabling will re-activate data for the role.'
=> 'Re-enabling will re-activate data for the role.',

   'Re-publish'
=> 'Re-publish',

   'Re: '
=> 'Re: ',

   'Read'
=> 'Read',

   'Read messages:'
=> 'Read messages:',

   'Readonly:'
=> 'Readonly:',

   'Receipt'
=> 'Receipt',

   'Receive notification of course requests requiring approval.'
=> 'Receive notification of course requests requiring approval.',

   'Recent Courses'
=> 'Recent Courses',

   'Recent Courses Hotlist'
=> 'Recent Courses Hotlist',

   'Recent Courses Hotlist is Disabled'
=> 'Recent Courses Hotlist is Disabled',

   'Recent Courses Hotlist is Enabled.'
=> 'Recent Courses Hotlist is Enabled.',

   'Recent Detailed Assessment Statistical Data'
=> 'Recent Detailed Assessment Statistical Data',

   'Recent Roles'
=> 'Recent Roles',

   'Recent Roles Hotlist'
=> 'Recent Roles Hotlist',

   'Recent Roles Hotlist is Disabled'
=> 'Recent Roles Hotlist is Disabled',

   'Recent Roles Hotlist is Enabled.'
=> 'Recent Roles Hotlist is Enabled.',

   'Recent activity of [_1]'
=> 'Recent activity of [_1]',

   'Recently generated printout zip files'
=> 'Recently generated printout zip files',

   'Recently generated printouts'
=> 'Recently generated printouts',

   'Recipients'
=> 'Recipients',

   'Recipients of '
=> 'Recipients of ',

   'Records'
=> 'Records',

   'Records [_1]'
=> 'Records [_1]',

   'Records per Page:'
=> 'Records per Page:',

   'Records/page:'
=> 'Records/page:',

   'Recover Checked'
=> 'Recover Checked',

   'Recover Deleted'
=> 'Recover Deleted',

   'Recover Deleted Documents'
=> 'Recover Deleted Documents',

   'Recover Removed Resources'
=> 'Recover Removed Resources',

   'Recover deleted'
=> 'Recover deleted',

   'Rectangle'
=> 'Rectangle',

   'Redirect to log-in via:'
=> 'Redirect to log-in via:',

   'Redo'
=> 'Redo',

   'Reenable group'
=> 'Reenable group',

   'Reference Warning'
=> 'Reference Warning',

   'Refers to'
=> 'Refers to',

   'Refresh'
=> 'Refresh',

   'Register'
=> 'Register',

   'Register Clicker'
=> 'Register Clicker',

   'Register Response Devices (&quot;Clickers&quot;)'
=> 'Register Response Devices (&quot;Clickers&quot;)',

   'Register your clicker.'
=> 'Register your clicker.',

   'Registering clickers: [_1]'
=> 'Registering clickers: [_1]',

   'Regular file'
=> 'Regular file',

   'Reject'
=> 'Reject',

   'Rejected enrollments:'
=> 'Rejected enrollments:',

   'Rejecting changes'
=> 'Rejecting changes',

   'Rejection Date'
=> 'Rejection Date',

   'Reload'
=> 'Reload',

   'Removals based on classlist changes:'
=> 'Removals based on classlist changes:',

   'Remove'
=> 'Remove',

   'Remove Checked Entries'
=> 'Remove Checked Entries',

   'Remove a student from this course.'
=> 'Remove a student from this course.',

   'Remove all existing corrections'
=> 'Remove all existing corrections',

   'Remove[_99]'
=> 'Remove[_99]',

   'Removed by '
=> 'Removed by ',

   'Removing error messages:'
=> 'Removing error messages:',

   'Removing the [_1].number.[_2] from requested filename.'
=> 'Removing the [_1].number.[_2] from requested filename.',

   'Rename Folder'
=> 'Rename Folder',

   'Rename [_1] to [_2]?'
=> 'Rename [_1] to [_2]?',

   'Renamed Folder'
=> 'Renamed Folder',

   'Renaming failed.'
=> 'Renaming failed.',

   'Rendering:'
=> 'Rendering:',

   'Replace log-in page with offline notice'
=> 'Replace log-in page with offline notice',

   'Replace offline notice with log-in page'
=> 'Replace offline notice with log-in page',

   'Replace:'
=> 'Replace:',

   'Replacement titles for standard course roles'
=> 'Replacement titles for standard course roles',

   'Replied to'
=> 'Replied to',

   'Replied to messages:'
=> 'Replied to messages:',

   'Reply To'
=> 'Reply To',

   'Reply to'
=> 'Reply to',

   'Reply to other recipients'
=> 'Reply to other recipients',

   'Reply to:'
=> 'Reply to:',

   'Replying to'
=> 'Replying to',

   'Replying to a Critical Message'
=> 'Replying to a Critical Message',

   'Replying to a Message'
=> 'Replying to a Message',

   'Report a documentation bug'
=> 'Report a documentation bug',

   'Report submitted'
=> 'Report submitted',

   'Reports'
=> 'Reports',

   'Request Action'
=> 'Request Action',

   'Request Cancellation'
=> 'Request Cancellation',

   'Request Date'
=> 'Request Date',

   'Request LON-CAPA account'
=> 'Request LON-CAPA account',

   'Request Status:'
=> 'Request Status:',

   'Request cancelled'
=> 'Request cancelled',

   'Request creation of a course or community'
=> 'Request creation of a course or community',

   'Request creation of a new course or community, or review your pending requests.'
=> 'Request creation of a new course or community, or review your pending requests.',

   'Request creation of a new course, or review your pending course requests.'
=> 'Request creation of a new course, or review your pending course requests.',

   'Request creation of a new course, or review your pending requests.'
=> 'Request creation of a new course, or review your pending requests.',

   'Request creation of courses'
=> 'Request creation of courses',

   'Request rejected'
=> 'Request rejected',

   'Requested'
=> 'Requested',

   'Requested custom role: [_1] unavailable, as it was not defined by the course owner.'
=> 'Requested custom role: [_1] unavailable, as it was not defined by the course owner.',

   'Requested role: [_1] is unavailable.'
=> 'Requested role: [_1] is unavailable.',

   'Requesting Another Worktime'
=> 'Requesting Another Worktime',

   'Requestor'
=> 'Requestor',

   'Requestor is automatically assigned Coordinator role.'
=> 'Requestor is automatically assigned Coordinator role.',

   'Requestor is automatically assigned Course Coordinator role.'
=> 'Requestor is automatically assigned Course Coordinator role.',

   'Requests Updated'
=> 'Requests Updated',

   'Requests Validation Result'
=> 'Requests Validation Result',

   'Requests are validated against institutional data to confirm that the requestor is an instructor of record.'
=> 'Requests are validated against institutional data to confirm that the requestor is an instructor of record.',

   'Requests for official courses queued pending validation'
=> 'Requests for official courses queued pending validation',

   'Requests may be left in the queue, or you can manually approve or reject them.'
=> 'Requests may be left in the queue, or you can manually approve or reject them.',

   'Require return receipt?'
=> 'Require return receipt?',

   'Required'
=> 'Required',

   'Res. ID'
=> 'Res. ID',

   'Reservable ending [_1]'
=> 'Reservable ending [_1]',

   'Reservable starting [_1]'
=> 'Reservable starting [_1]',

   'Reservation History'
=> 'Reservation History',

   'Reservation changes for member-reservable slot: [_1]'
=> 'Reservation changes for member-reservable slot: [_1]',

   'Reservation changes for student-reservable slot: [_1]'
=> 'Reservation changes for student-reservable slot: [_1]',

   'Reservation history unavailable for non-member-reservable slot: [_1].'
=> 'Reservation history unavailable for non-member-reservable slot: [_1].',

   'Reservation history unavailable for non-student-reservable slot: [_1].'
=> 'Reservation history unavailable for non-student-reservable slot: [_1].',

   'Reservation needed'
=> 'Reservation needed',

   'Reservation needed: none available.'
=> 'Reservation needed: none available.',

   'Reservation not available'
=> 'Reservation not available',

   'Reservation status unknown'
=> 'Reservation status unknown',

   'Reserve a time/place to work'
=> 'Reserve a time/place to work',

   'Reserved - ends [_1]'
=> 'Reserved - ends [_1]',

   'Reserved - next open [_1]'
=> 'Reserved - next open [_1]',

   'Reserved - specific location(s) - ends [_1]'
=> 'Reserved - specific location(s) - ends [_1]',

   'Reserved:'
=> 'Reserved:',

   'Reset'
=> 'Reset',

   'Reset '
=> 'Reset ',

   'Reset Access Times'
=> 'Reset Access Times',

   'Reset All'
=> 'Reset All',

   'Reset All Colors to Default'
=> 'Reset All Colors to Default',

   'Reset Count?'
=> 'Reset Count?',

   'Reset Student Access Times'
=> 'Reset Student Access Times',

   'Reset [_1]'
=> 'Reset [_1]',

   'Reset access times for folders/maps, resources or the course.'
=> 'Reset access times for folders/maps, resources or the course.',

   'Reset counters to 0'
=> 'Reset counters to 0',

   'Reset forgotten LON-CAPA password'
=> 'Reset forgotten LON-CAPA password',

   'Reset nickname.'
=> 'Reset nickname.',

   'Reset password'
=> 'Reset password',

   'Reset screenname.'
=> 'Reset screenname.',

   'Reset times on a single folder/map for a section or whole clase.'
=> 'Reset times on a single folder/map for a section or whole clase.',

   'Reset times on a single folder/map, resource or the course for a section or the whole class.'
=> 'Reset times on a single folder/map, resource or the course for a section or the whole class.',

   'Reset times on one or more folders/maps for a single student.'
=> 'Reset times on one or more folders/maps for a single student.',

   'Reset times on one or more folders/maps, resources or the course for a single student.'
=> 'Reset times on one or more folders/maps, resources or the course for a single student.',

   'Resource Content'
=> 'Resource Content',

   'Resource Details'
=> 'Resource Details',

   'Resource Hidden from Students'
=> 'Resource Hidden from Students',

   'Resource Space Home'
=> 'Resource Space Home',

   'Resource Specification'
=> 'Resource Specification',

   'Resource alias name for conditions'
=> 'Resource alias name for conditions',

   'Resource hidden from students'
=> 'Resource hidden from students',

   'Resource not available.'
=> 'Resource not available.',

   'Resource space'
=> 'Resource space',

   'Resource: '
=> 'Resource: ',

   'Resources from the Whole Course'
=> 'Resources from the Whole Course',

   'Resources in course with version changes seit start of course'
=> 'Resources in course with version changes seit start of course',

   'Resources in course with version changes since last month'
=> 'Resources in course with version changes since last month',

   'Resources in course with version changes since last week'
=> 'Resources in course with version changes since last week',

   'Resources in course with version changes since yesterday'
=> 'Resources in course with version changes since yesterday',

   'Resources that follow this resource in maps'
=> 'Resources that follow this resource in maps',

   'Resources that lead up to this resource in maps'
=> 'Resources that lead up to this resource in maps',

   'Resources used by this resource'
=> 'Resources used by this resource',

   'Resources using or importing resource'
=> 'Resources using or importing resource',

   'Response [_1] is not analyzable at this time.'
=> 'Response [_1] is not analyzable at this time.',

   'Response: Click on Image'
=> 'Response: Click on Image',

   'Response: Numerical'
=> 'Response: Numerical',

   'Restrict Domain Coordinator Access'
=> 'Restrict Domain Coordinator Access',

   'Restrict Metadata'
=> 'Restrict Metadata',

   'Restrict domain coordinator access.'
=> 'Restrict domain coordinator access.',

   'Restrict metadata for this course.'
=> 'Restrict metadata for this course.',

   'Restrict self-enrollment to students officially registered for the course'
=> 'Restrict self-enrollment to students officially registered for the course',

   'Resubmit last request to check for newer data'
=> 'Resubmit last request to check for newer data',

   'Result'
=> 'Result',

   'Result of Changes to Automated Enrollment Settings.'
=> 'Result of Changes to Automated Enrollment Settings.',

   'Results'
=> 'Results',

   'Results [_1] to [_2] out of [_3]'
=> 'Results [_1] to [_2] out of [_3]',

   'Results of PDF Form problems'
=> 'Results of PDF Form problems',

   "Retain each user's current section affiliations?"
=> "Retain each user's current section affiliations?",

   'Retained attachments'
=> 'Retained attachments',

   'Retrieve Metadata'
=> 'Retrieve Metadata',

   'Retrieve discussion and message records'
=> 'Retrieve discussion and message records',

   'Retrieve previous version'
=> 'Retrieve previous version',

   'Retrieve previous versions of [_1]'
=> 'Retrieve previous versions of [_1]',

   'Retrieve selected Version'
=> 'Retrieve selected Version',

   'Retrieving old version'
=> 'Retrieving old version',

   'Return'
=> 'Return',

   'Return commented version of [_1] to student.'
=> 'Return commented version of [_1] to student.',

   'Return to Community Editor'
=> 'Return to Community Editor',

   'Return to Directory'
=> 'Return to Directory',

   'Return to directory'
=> 'Return to directory',

   'Return to group page'
=> 'Return to group page',

   'Return to last resource'
=> 'Return to last resource',

   'Return to previous page'
=> 'Return to previous page',

   'Return to reservations'
=> 'Return to reservations',

   'Return to the chart'
=> 'Return to the chart',

   'Returned file(s): [_1]'
=> 'Returned file(s): [_1]',

   'Revert'
=> 'Revert',

   'Revert to Default'
=> 'Revert to Default',

   'Revert to beginning of edit session?'
=> 'Revert to beginning of edit session?',

   'Reverted.'
=> 'Reverted.',

   'Review Bubblesheet Data and Submission Records'
=> 'Review Bubblesheet Data and Submission Records',

   'Review bubblesheet data and submissions for a previously graded folder/sequence'
=> 'Review bubblesheet data and submissions for a previously graded folder/sequence',

   'Review community request details before submission'
=> 'Review community request details before submission',

   'Review course request details before submission'
=> 'Review course request details before submission',

   'Review user information'
=> 'Review user information',

   'Revise Search Request'
=> 'Revise Search Request',

   'Revise search'
=> 'Revise search',

   'Revise your search criteria for this domain'
=> 'Revise your search criteria for this domain',

   'Revoke user roles'
=> 'Revoke user roles',

   "Revoked role of '[_1]' in [_2] for [_3]"
=> "Revoked role of '[_1]' in [_2] for [_3]",

   'Revoked role(s) for [quant,_1,user,users,no users].'
=> 'Revoked role(s) for [quant,_1,user,users,no users].',

   'Revoking [_1] in [_2]: [_3]'
=> 'Revoking [_1] in [_2]: [_3]',

   'Revoking custom role:'
=> 'Revoking custom role:',

   'Role Type: [_1]'
=> 'Role Type: [_1]',

   'Role and/or section(s) for users without values specified in the uploaded file.'
=> 'Role and/or section(s) for users without values specified in the uploaded file.',

   'Role selected. Please stand by.'
=> 'Role selected. Please stand by.',

   'Role(s) for [_1]'
=> 'Role(s) for [_1]',

   'Role: '
=> 'Role: ',

   'Role: [_1]'
=> 'Role: [_1]',

   'Roles Page'
=> 'Roles Page',

   'Roles added for [quant,_1,user].'
=> 'Roles added for [quant,_1,user].',

   'Roles for which access to course has become available since last month'
=> 'Roles for which access to course has become available since last month',

   'Roles for which access to course has become available since last week'
=> 'Roles for which access to course has become available since last week',

   'Roles for which access to course has become available since start of course'
=> 'Roles for which access to course has become available since start of course',

   'Roles for which access to course has become available since yesterday'
=> 'Roles for which access to course has become available since yesterday',

   'Roles for which access to course has expired since last month'
=> 'Roles for which access to course has expired since last month',

   'Roles for which access to course has expired since last week'
=> 'Roles for which access to course has expired since last week',

   'Roles for which access to course has expired since start of course'
=> 'Roles for which access to course has expired since start of course',

   'Roles for which access to course has expired since yesterday'
=> 'Roles for which access to course has expired since yesterday',

   'Roles of any status'
=> 'Roles of any status',

   'Roles will be active at next login'
=> 'Roles will be active at next login',

   'Roles will be added for section(s):'
=> 'Roles will be added for section(s):',

   'Roster Update'
=> 'Roster Update',

   'Rsource is undefined.'
=> 'Rsource is undefined.',

   'Running loncron ...'
=> 'Running loncron ...',

   'SSO'
=> 'SSO',

   'Save &amp; Next'
=> 'Save &amp; Next',

   'Save All'
=> 'Save All',

   'Save Marked Changes'
=> 'Save Marked Changes',

   'Save Metadata'
=> 'Save Metadata',

   'Save Selected'
=> 'Save Selected',

   'Save and Edit'
=> 'Save and Edit',

   'Save and Update'
=> 'Save and Update',

   'Save and View'
=> 'Save and View',

   'Save as &amp; Make This Sheet the Default'
=> 'Save as &amp; Make This Sheet the Default',

   'Save entries below (not submitted for credit yet)'
=> 'Save entries below (not submitted for credit yet)',

   'Save map'
=> 'Save map',

   'Save map and layout'
=> 'Save map and layout',

   'Save message for re-use'
=> 'Save message for re-use',

   'Save uploaded file as'
=> 'Save uploaded file as',

   'Save uploaded file as [_1]'
=> 'Save uploaded file as [_1]',

   'Saved scores for [quant,_1,student]'
=> 'Saved scores for [quant,_1,student]',

   'Saved.'
=> 'Saved.',

   'Saving Modifications to [_1]'
=> 'Saving Modifications to [_1]',

   'Saving feedback: [_1]'
=> 'Saving feedback: [_1]',

   'Scanning clicker file'
=> 'Scanning clicker file',

   'Scheduled Members'
=> 'Scheduled Members',

   'Score'
=> 'Score',

   'Score Part: [_1]<br /> (weight = [_2])'
=> 'Score Part: [_1]<br /> (weight = [_2])',

   'Score based on attendance only'
=> 'Score based on attendance only',

   'Score on each Problem Part'
=> 'Score on each Problem Part',

   'Scores Per Problem'
=> 'Scores Per Problem',

   'Scores Summary'
=> 'Scores Summary',

   'Screen Name'
=> 'Screen Name',

   'Screenname'
=> 'Screenname',

   'Script'
=> 'Script',

   'Script Functions'
=> 'Script Functions',

   'Script Size'
=> 'Script Size',

   'Script Vars'
=> 'Script Vars',

   'Scripting (optional)'
=> 'Scripting (optional)',

   'Search Complete on Server [_1]'
=> 'Search Complete on Server [_1]',

   'Search LON-CAPA help'
=> 'Search LON-CAPA help',

   'Search Status'
=> 'Search Status',

   'Search and Enroll'
=> 'Search and Enroll',

   'Search criteria'
=> 'Search criteria',

   'Search for a community in the [_1] domain'
=> 'Search for a community in the [_1] domain',

   'Search for a course in the [_1] domain'
=> 'Search for a course in the [_1] domain',

   'Search for a user and enroll as a member'
=> 'Search for a user and enroll as a member',

   'Search for a user and enroll as a student'
=> 'Search for a user and enroll as a student',

   'Search for a user and modify/add user information or roles'
=> 'Search for a user and modify/add user information or roles',

   'Search for a user to add to course personnel'
=> 'Search for a user to add to course personnel',

   'Search for user'
=> 'Search for user',

   'Search latitude'
=> 'Search latitude',

   'Search or Add New User'
=> 'Search or Add New User',

   'Search the contents of this course or accessible portfolio files'
=> 'Search the contents of this course or accessible portfolio files',

   'Search the database of accessible portfolio files'
=> 'Search the database of accessible portfolio files',

   'Search the database of published resources and accessible portfolio files'
=> 'Search the database of published resources and accessible portfolio files',

   'Search: '
=> 'Search: ',

   'Searching ...'
=> 'Searching ...',

   'Searching for your resource will be based on the following metadata. Please provide as much data as possible.'
=> 'Searching for your resource will be based on the following metadata. Please provide as much data as possible.',

   'Section Number'
=> 'Section Number',

   'Section Numbers and corresponding LON-CAPA section IDs'
=> 'Section Numbers and corresponding LON-CAPA section IDs',

   'Section [_1]'
=> 'Section [_1]',

   'Section [_1].'
=> 'Section [_1].',

   'Section assigned to self-enrolling users'
=> 'Section assigned to self-enrolling users',

   "Section assignment for role of '[_1]' in [_2] for '[_3]' unchanged."
=> "Section assignment for role of '[_1]' in [_2] for '[_3]' unchanged.",

   'Section designations do not apply to '
=> 'Section designations do not apply to ',

   'Section designations do not apply to Coordinator roles.'
=> 'Section designations do not apply to Coordinator roles.',

   'Section designations do not apply to Course Coordinator roles.'
=> 'Section designations do not apply to Course Coordinator roles.',

   'Section for self-enrolled users unchanged as the proposed section is a group'
=> 'Section for self-enrolled users unchanged as the proposed section is a group',

   'Section for self-enrolled users unchanged, as "all" is a reserved section name.'
=> 'Section for self-enrolled users unchanged, as "all" is a reserved section name.',

   'Section names and group names must be distinct'
=> 'Section names and group names must be distinct',

   'Section names and group names must be distinct.'
=> 'Section names and group names must be distinct.',

   'Section names and group names must be distinct. Please choose a different section name.'
=> 'Section names and group names must be distinct. Please choose a different section name.',

   'Section names may only contain letters or numbers.'
=> 'Section names may only contain letters or numbers.',

   'Section settings'
=> 'Section settings',

   'Section(s)'
=> 'Section(s)',

   'Section(s): [_1] - [_2]'
=> 'Section(s): [_1] - [_2]',

   'Sections [_1] and [_2].'
=> 'Sections [_1] and [_2].',

   'Sections for auto-enrollment'
=> 'Sections for auto-enrollment',

   'Sections of [_1]'
=> 'Sections of [_1]',

   "Sections will be switched to 'No section'"
=> "Sections will be switched to 'No section'",

   'Sections will be switched to:'
=> 'Sections will be switched to:',

   'See course contents for further information.'
=> 'See course contents for further information.',

   'Select Audience'
=> 'Select Audience',

   'Select Author'
=> 'Select Author',

   'Select Common Only'
=> 'Select Common Only',

   'Select Communities'
=> 'Select Communities',

   'Select Course(s)'
=> 'Select Course(s)',

   'Select Course/Community'
=> 'Select Course/Community',

   'Select Courses'
=> 'Select Courses',

   'Select Currently Enrolled Students and Active Course Personnel'
=> 'Select Currently Enrolled Students and Active Course Personnel',

   'Select Finish to save selection'
=> 'Select Finish to save selection',

   'Select First Coordinate on Image'
=> 'Select First Coordinate on Image',

   'Select Group'
=> 'Select Group',

   'Select Members'
=> 'Select Members',

   'Select One Student'
=> 'Select One Student',

   'Select Options'
=> 'Select Options',

   'Select Parameters to View'
=> 'Select Parameters to View',

   'Select Parts to View'
=> 'Select Parts to View',

   'Select People'
=> 'Select People',

   'Select Portfolio Files'
=> 'Select Portfolio Files',

   'Select Position on Image'
=> 'Select Position on Image',

   'Select Previously Enrolled Students and Inactive Course Personnel'
=> 'Select Previously Enrolled Students and Inactive Course Personnel',

   'Select Scope'
=> 'Select Scope',

   'Select Second Coordinate on Image'
=> 'Select Second Coordinate on Image',

   'Select [_1]'
=> 'Select [_1]',

   'Select a Template'
=> 'Select a Template',

   'Select a destination folder to which the messages will be moved.'
=> 'Select a destination folder to which the messages will be moved.',

   'Select a display option for the package content:'
=> 'Select a display option for the package content:',

   'Select a folder/map'
=> 'Select a folder/map',

   'Select a student you wish to grade and then click on the Next button.'
=> 'Select a student you wish to grade and then click on the Next button.',

   'Select a user'
=> 'Select a user',

   "Select a user name to modify the student's information"
=> "Select a user name to modify the student's information",

   "Select a user name to view the user's personal information page."
=> "Select a user name to view the user's personal information page.",

   'Select a user to add/modify roles'
=> 'Select a user to add/modify roles',

   'Select a user to enroll as a member'
=> 'Select a user to enroll as a member',

   'Select a user to enroll as a student'
=> 'Select a user to enroll as a student',

   'Select actions to attempt'
=> 'Select actions to attempt',

   'Select all that are <b>[_1]</b>.'
=> 'Select all that are <b>[_1]</b>.',

   'Select checked files, and close window'
=> 'Select checked files, and close window',

   'Select checked files, and continue selecting'
=> 'Select checked files, and continue selecting',

   'Select individual students to grade and view submissions.'
=> 'Select individual students to grade and view submissions.',

   'Select message recipients from the group members listed below.'
=> 'Select message recipients from the group members listed below.',

   'Select portfolio files'
=> 'Select portfolio files',

   'Select roles, community status, section(s) and group(s) for users who will be able to access the portfolio file.'
=> 'Select roles, community status, section(s) and group(s) for users who will be able to access the portfolio file.',

   'Select roles, course status, section(s) and group(s) for users who will be able to access the portfolio file.'
=> 'Select roles, course status, section(s) and group(s) for users who will be able to access the portfolio file.',

   'Select sorting order of printout'
=> 'Select sorting order of printout',

   'Select the sequence to print resources from:'
=> 'Select the sequence to print resources from:',

   'SelectProblem(s) to print'
=> 'SelectProblem(s) to print',

   'Selected Parameters:'
=> 'Selected Parameters:',

   'Selected Problems from entire course'
=> 'Selected Problems from entire course',

   'Selected Problems from entire course for selected people'
=> 'Selected Problems from entire course for selected people',

   'Selected Resources from entire course'
=> 'Selected Resources from entire course',

   'Selected Resources from selected folder in course'
=> 'Selected Resources from selected folder in course',

   'Selected [_1]Problems[_2] from current subdirectory [_3]'
=> 'Selected [_1]Problems[_2] from current subdirectory [_3]',

   'Selected [_1]Problems[_2] from folder [_3]'
=> 'Selected [_1]Problems[_2] from folder [_3]',

   'Selected [_1]Problems[_2] from folder [_3] for [_4]CODEd assignments[_5]'
=> 'Selected [_1]Problems[_2] from folder [_3] for [_4]CODEd assignments[_5]',

   'Selected [_1]Problems[_2] from folder [_3] for [_4]selected people[_5]'
=> 'Selected [_1]Problems[_2] from folder [_3] for [_4]selected people[_5]',

   'Selected [_1]Problems[_2] from page [_3]'
=> 'Selected [_1]Problems[_2] from page [_3]',

   'Selected [_1]Resources[_2] from folder [_3]'
=> 'Selected [_1]Resources[_2] from folder [_3]',

   'Selected [_1]Resources[_2] from folder [_3] for [_4]CODEd assignments[_5]'
=> 'Selected [_1]Resources[_2] from folder [_3] for [_4]CODEd assignments[_5]',

   'Selected [_1]Resources[_2] from folder [_3] for [_4]selected people[_5]'
=> 'Selected [_1]Resources[_2] from folder [_3] for [_4]selected people[_5]',

   'Selected [_1]Resources[_2] from page [_3]'
=> 'Selected [_1]Resources[_2] from page [_3]',

   'Selected communities in domain'
=> 'Selected communities in domain',

   'Selected courses in domain'
=> 'Selected courses in domain',

   'Selecting a Course'
=> 'Selecting a Course',

   'Selecting an Author'
=> 'Selecting an Author',

   'Selecting course personnel'
=> 'Selecting course personnel',

   'Self-Enrollment'
=> 'Self-Enrollment',

   'Self-creation of account by users with status: [_1]'
=> 'Self-creation of account by users with status: [_1]',

   'Self-enroll'
=> 'Self-enroll',

   'Self-enroll (if permitted)'
=> 'Self-enroll (if permitted)',

   'Self-enroll in [_1]'
=> 'Self-enroll in [_1]',

   'Self-enroll in a LON-CAPA course'
=> 'Self-enroll in a LON-CAPA course',

   'Self-enroll in course'
=> 'Self-enroll in course',

   'Self-enrolled'
=> 'Self-enrolled',

   'Self-enrollers:'
=> 'Self-enrollers:',

   'Self-enrollment error'
=> 'Self-enrollment error',

   'Self-enrollment in this course failed.'
=> 'Self-enrollment in this course failed.',

   'Self-enrollment in this course is available to any user affiliated with [_1].'
=> 'Self-enrollment in this course is available to any user affiliated with [_1].',

   'Self-enrollment in this course is only available to users affiliated with the following institutions, and who have the required status:'
=> 'Self-enrollment in this course is only available to users affiliated with the following institutions, and who have the required status:',

   'Self-enrollment in this course is only available to users in affiliated with [_1] who have the following status: "[_2]".'
=> 'Self-enrollment in this course is only available to users in affiliated with [_1] who have the following status: "[_2]".',

   'Self-enrollment in this course was successful.'
=> 'Self-enrollment in this course was successful.',

   'Self-enrollment is not currently available for this course for users affiliated with [_1].'
=> 'Self-enrollment is not currently available for this course for users affiliated with [_1].',

   'Self-enrollment is not currently available for this course.'
=> 'Self-enrollment is not currently available for this course.',

   'Self-enrollment is not currently available in this course'
=> 'Self-enrollment is not currently available in this course',

   'Self-enrollment is restricted to officially registered students.'
=> 'Self-enrollment is restricted to officially registered students.',

   'Self-enrollment is restricted to students officially registered for this course.'
=> 'Self-enrollment is restricted to students officially registered for this course.',

   'Self-enrollment request'
=> 'Self-enrollment request',

   'Self-enrollment requests need approval?'
=> 'Self-enrollment requests need approval?',

   'Self-enrollment requests processed'
=> 'Self-enrollment requests processed',

   'Self-enrollment requests queued pending approval by a Coordinator'
=> 'Self-enrollment requests queued pending approval by a Coordinator',

   'Self-enrollment result'
=> 'Self-enrollment result',

   'Self-enrollment unavailable'
=> 'Self-enrollment unavailable',

   'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users at your institution ([_2]).'
=> 'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users at your institution ([_2]).',

   'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users.'
=> 'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users.',

   'Self-enrollment will become available starting [_1].'
=> 'Self-enrollment will become available starting [_1].',

   'Self-enrollment will become available starting [_1]; please enroll at that time.'
=> 'Self-enrollment will become available starting [_1]; please enroll at that time.',

   'Self-enrollment with a student role'
=> 'Self-enrollment with a student role',

   'Semicolon separated values'
=> 'Semicolon separated values',

   'Send'
=> 'Send',

   'Send Feedback'
=> 'Send Feedback',

   'Send Information'
=> 'Send Information',

   'Send Message'
=> 'Send Message',

   'Send Messages'
=> 'Send Messages',

   'Send Reply to Message'
=> 'Send Reply to Message',

   'Send Reply to Messages'
=> 'Send Reply to Messages',

   'Send a Message'
=> 'Send a Message',

   'Send a Message in a Group'
=> 'Send a Message in a Group',

   'Send a broadcast message to members of this Course and/or other users.'
=> 'Send a broadcast message to members of this Course and/or other users.',

   'Send a message to users.'
=> 'Send a message to users.',

   'Send a new e-mail to selected users from this domain'
=> 'Send a new e-mail to selected users from this domain',

   'Send and display broadcast e-mail'
=> 'Send and display broadcast e-mail',

   'Send and display messages'
=> 'Send and display messages',

   'Send another e-mail'
=> 'Send another e-mail',

   'Send another group message'
=> 'Send another group message',

   'Send broadcast and receipt-required message'
=> 'Send broadcast and receipt-required message',

   'Send copy to permanent e-mail address (if known)'
=> 'Send copy to permanent e-mail address (if known)',

   'Send e-mail to selected users'
=> 'Send e-mail to selected users',

   'Send group message'
=> 'Send group message',

   'Send internal message'
=> 'Send internal message',

   'Send me a message'
=> 'Send me a message',

   'Send message'
=> 'Send message',

   'Send message to [_1]'
=> 'Send message to [_1]',

   'Send message to member'
=> 'Send message to member',

   'Send message to student'
=> 'Send message to student',

   'Send message to student when clicking Done on Tasks'
=> 'Send message to student when clicking Done on Tasks',

   'Sender'
=> 'Sender',

   'Sending'
=> 'Sending',

   'Sending Error Report'
=> 'Sending Error Report',

   'Sending critical message'
=> 'Sending critical message',

   'Sending message to [_1]'
=> 'Sending message to [_1]',

   'Sent Messages'
=> 'Sent Messages',

   'Separate multiple sections with a comma.'
=> 'Separate multiple sections with a comma.',

   'Sequence of Materials'
=> 'Sequence of Materials',

   'Sequence to grade:'
=> 'Sequence to grade:',

   'Server Actions'
=> 'Server Actions',

   'Server Load'
=> 'Server Load',

   'Server Setting'
=> 'Server Setting',

   'Server Status'
=> 'Server Status',

   'Server Status Information'
=> 'Server Status Information',

   'Server Switch Required'
=> 'Server Switch Required',

   'Server Utilities for Domain: [_1]'
=> 'Server Utilities for Domain: [_1]',

   'Session could not be opened.'
=> 'Session could not be opened.',

   "Set 'Domain/institution to search' to: [_1]"
=> "Set 'Domain/institution to search' to: [_1]",

   "Set 'Search criteria' to: [_1]username is ..... in selected LON-CAPA domain[_2]"
=> "Set 'Search criteria' to: [_1]username is ..... in selected LON-CAPA domain[_2]",

   'Set Defaults'
=> 'Set Defaults',

   'Set Defaults for All Resources in [_1]Specifically for [_2][_3]'
=> 'Set Defaults for All Resources in [_1]Specifically for [_2][_3]',

   'Set Margins'
=> 'Set Margins',

   'Set Parameter Setting Default Actions'
=> 'Set Parameter Setting Default Actions',

   'Set Parameters'
=> 'Set Parameters',

   'Set Portfolio Metadata'
=> 'Set Portfolio Metadata',

   'Set Privileges for New User'
=> 'Set Privileges for New User',

   'Set User Preferences'
=> 'Set User Preferences',

   'Set [_1] to [_2]'
=> 'Set [_1] to [_2]',

   'Set a quota for the total disk space available for storage of community group portfolio files'
=> 'Set a quota for the total disk space available for storage of community group portfolio files',

   'Set a quota for the total disk space available for storage of course group portfolio files'
=> 'Set a quota for the total disk space available for storage of course group portfolio files',

   'Set address(es) to receive excerpts with html retained '
=> 'Set address(es) to receive excerpts with html retained ',

   'Set all notification addresses to receive excerpts with html stripped.'
=> 'Set all notification addresses to receive excerpts with html stripped.',

   'Set answer open date for the selected problem for...'
=> 'Set answer open date for the selected problem for...',

   'Set assessment parameters'
=> 'Set assessment parameters',

   'Set by'
=> 'Set by',

   'Set community policy feedback to Coordinator'
=> 'Set community policy feedback to Coordinator',

   'Set content feedback to Coordinator'
=> 'Set content feedback to Coordinator',

   'Set critical message notification address(es) to '
=> 'Set critical message notification address(es) to ',

   "Set critical message notification to 'off'."
=> "Set critical message notification to 'off'.",

   'Set date of first access for registered students added via automated enrollment'
=> 'Set date of first access for registered students added via automated enrollment',

   'Set date of first automated enrollment for registered students'
=> 'Set date of first automated enrollment for registered students',

   'Set date of last access for registered students added via automated enrollment'
=> 'Set date of last access for registered students added via automated enrollment',

   'Set date of last automated enrollment for registered students'
=> 'Set date of last automated enrollment for registered students',

   'Set default actions for parameters.'
=> 'Set default actions for parameters.',

   'Set default start and end access dates for community.'
=> 'Set default start and end access dates for community.',

   'Set default start and end access dates for course.'
=> 'Set default start and end access dates for course.',

   'Set display preferences for discussion posts for both discussion boards and individual resources in all your courses.'
=> 'Set display preferences for discussion posts for both discussion boards and individual resources in all your courses.',

   'Set domain configuration'
=> 'Set domain configuration',

   'Set enrollment'
=> 'Set enrollment',

   'Set in "Modify Course" (Domain)'
=> 'Set in "Modify Course" (Domain)',

   'Set in "Modify Parameters" (Course)'
=> 'Set in "Modify Parameters" (Course)',

   'Set message forwarding to '
=> 'Set message forwarding to ',

   "Set message forwarding to 'off'."
=> "Set message forwarding to 'off'.",

   'Set new nickname to '
=> 'Set new nickname to ',

   'Set new screenname to '
=> 'Set new screenname to ',

   'Set non-critical message notification address(es) to '
=> 'Set non-critical message notification address(es) to ',

   "Set non-critical message notification to 'off'."
=> "Set non-critical message notification to 'off'.",

   'Set notification address to receive excerpts with html stripped.'
=> 'Set notification address to receive excerpts with html stripped.',

   'Set options that control the sort order of posts, and/or which posts are displayed.'
=> 'Set options that control the sort order of posts, and/or which posts are displayed.',

   'Set section/dates'
=> 'Set section/dates',

   'Set the default page to be displayed when you select a course role'
=> 'Set the default page to be displayed when you select a course role',

   'Set the default page to be displayed when you select a course role.'
=> 'Set the default page to be displayed when you select a course role.',

   'Set threshold for [_1] to [_2]'
=> 'Set threshold for [_1] to [_2]',

   'Set user role'
=> 'Set user role',

   'Set value to [_1] to allow all roles.'
=> 'Set value to [_1] to allow all roles.',

   'Set value to [_1] to allow.'
=> 'Set value to [_1] to allow.',

   'Set/Change grades'
=> 'Set/Change grades',

   'Set/Change parameters'
=> 'Set/Change parameters',

   'Set/Modify Resource Parameters - Helper Mode'
=> 'Set/Modify Resource Parameters - Helper Mode',

   'Set/Modify Resource Parameters - Overview Mode'
=> 'Set/Modify Resource Parameters - Overview Mode',

   'Set/Modify Resource Parameters - Table Mode'
=> 'Set/Modify Resource Parameters - Table Mode',

   'Set/Modify existing resource parameters in overview mode.'
=> 'Set/Modify existing resource parameters in overview mode.',

   'Set/Modify resource parameters in helper mode.'
=> 'Set/Modify resource parameters in helper mode.',

   'Set/Modify resource parameters in overview mode.'
=> 'Set/Modify resource parameters in overview mode.',

   'Set/Modify resource parameters in table mode.'
=> 'Set/Modify resource parameters in table mode.',

   'Setting'
=> 'Setting',

   'Setting Changes Complete'
=> 'Setting Changes Complete',

   'Setting environment'
=> 'Setting environment',

   'Setting first resource'
=> 'Setting first resource',

   'Setting optional privileges for specific group members'
=> 'Setting optional privileges for specific group members',

   'Settings'
=> 'Settings',

   'Settings for Your Course'
=> 'Settings for Your Course',

   'Settings for assigning roles'
=> 'Settings for assigning roles',

   'Settings for automatic group enrollment'
=> 'Settings for automatic group enrollment',

   'Settings for this Course'
=> 'Settings for this Course',

   'Settings for this community have been left unchanged.'
=> 'Settings for this community have been left unchanged.',

   'Settings for this course have been left unchanged.'
=> 'Settings for this course have been left unchanged.',

   'Settings modifiable by a [_1] via [_2]View/Modify course owner, institutional code, and default authentication[_3].'
=> 'Settings modifiable by a [_1] via [_2]View/Modify course owner, institutional code, and default authentication[_3].',

   'Settings modifiable by a [_1] via the [_2]Automated Enrollment Manager[_3] in a course.'
=> 'Settings modifiable by a [_1] via the [_2]Automated Enrollment Manager[_3] in a course.',

   'Settings to display/modify'
=> 'Settings to display/modify',

   "Settings which control auto-enrollment using classlists from your institution's student information system fall into two groups:"
=> "Settings which control auto-enrollment using classlists from your institution's student information system fall into two groups:",

   'Shift all dates based on this date'
=> 'Shift all dates based on this date',

   'Shift date parameters by number of days'
=> 'Shift date parameters by number of days',

   'Shift dates by [_1] days'
=> 'Shift dates by [_1] days',

   'Show'
=> 'Show',

   'Show All Foils'
=> 'Show All Foils',

   'Show All Instances'
=> 'Show All Instances',

   'Show Default View'
=> 'Show Default View',

   'Show Log'
=> 'Show Log',

   'Show Metadata'
=> 'Show Metadata',

   'Show Parts One-at-a-Time'
=> 'Show Parts One-at-a-Time',

   'Show Parts One-at-a-Time (ordered)'
=> 'Show Parts One-at-a-Time (ordered)',

   'Show Preview and Check Spelling'
=> 'Show Preview and Check Spelling',

   'Show Problem Status'
=> 'Show Problem Status',

   'Show Public View'
=> 'Show Public View',

   'Show Source'
=> 'Show Source',

   'Show Student View'
=> 'Show Student View',

   'Show Units - Disable Entry'
=> 'Show Units - Disable Entry',

   'Show a list of current posters'
=> 'Show a list of current posters',

   'Show all'
=> 'Show all',

   'Show all parts'
=> 'Show all parts',

   'Show all posts'
=> 'Show all posts',

   'Show all submissions'
=> 'Show all submissions',

   'Show and manage co- or assistant authors.'
=> 'Show and manage co- or assistant authors.',

   'Show and manage users in this course.'
=> 'Show and manage users in this course.',

   'Show and manage users of this course.'
=> 'Show and manage users of this course.',

   'Show correct answers'
=> 'Show correct answers',

   'Show detailed Parameter Selection'
=> 'Show detailed Parameter Selection',

   'Show diffs in new window'
=> 'Show diffs in new window',

   'Show everything'
=> 'Show everything',

   'Show full details for each community ([_1] only)'
=> 'Show full details for each community ([_1] only)',

   'Show full details for each course ([_1] only)'
=> 'Show full details for each course ([_1] only)',

   'Show hint even if problem Correct:'
=> 'Show hint even if problem Correct:',

   'Show links in new window'
=> 'Show links in new window',

   'Show links in new window:'
=> 'Show links in new window:',

   'Show more details'
=> 'Show more details',

   'Show my first due problem'
=> 'Show my first due problem',

   'Show only uncompleted problems'
=> 'Show only uncompleted problems',

   'Show problem'
=> 'Show problem',

   'Show problem grading'
=> 'Show problem grading',

   'Show re-usable messages'
=> 'Show re-usable messages',

   'Show subcategories'
=> 'Show subcategories',

   'Show to student'
=> 'Show to student',

   'Show user environment'
=> 'Show user environment',

   'Show/Hide a community in catalog'
=> 'Show/Hide a community in catalog',

   'Show/Hide a course in catalog'
=> 'Show/Hide a course in catalog',

   'Show/Hide a course in the catalog'
=> 'Show/Hide a course in the catalog',

   'Showing users with a name starting with [_1]'
=> 'Showing users with a name starting with [_1]',

   'Shown'
=> 'Shown',

   'Sign up for time to work'
=> 'Sign up for time to work',

   'Sign up for time to work.'
=> 'Sign up for time to work.',

   'Significant Digits'
=> 'Significant Digits',

   'Significant digits'
=> 'Significant digits',

   'Simple Course Page'
=> 'Simple Course Page',

   'Simple Group Page'
=> 'Simple Group Page',

   'Single Course User'
=> 'Single Course User',

   'Single Line Text Entry Area'
=> 'Single Line Text Entry Area',

   'Single Users'
=> 'Single Users',

   'Size limit'
=> 'Size limit',

   'Skip hidden resources'
=> 'Skip hidden resources',

   'Skip hidden resources when grading'
=> 'Skip hidden resources when grading',

   'Skipping'
=> 'Skipping',

   'Slot reservation history'
=> 'Slot reservation history',

   'Slots'
=> 'Slots',

   'Slots of availability'
=> 'Slots of availability',

   'Slots of availability (available)'
=> 'Slots of availability (available)',

   'Slots of availability selected by student'
=> 'Slots of availability selected by student',

   'Slots of availability selected by student (availablestudent)'
=> 'Slots of availability selected by student (availablestudent)',

   'Small'
=> 'Small',

   'So far, no data has been returned for your request'
=> 'So far, no data has been returned for your request',

   'Some LON-CAPA users have a long list of courses. The Recent Courses Hotlist feature keeps track of the last N courses which have been visited and places a table of these at the top of the courses page. People with very few courses should leave this feature disabled.'
=> 'Some LON-CAPA users have a long list of courses. The Recent Courses Hotlist feature keeps track of the last N courses which have been visited and places a table of these at the top of the courses page. People with very few courses should leave this feature disabled.',

   'Some LON-CAPA users have a long list of roles. The Recent Roles Hotlist feature keeps track of the last N roles which have been visited and places a table of these at the top of the roles page. People with very few roles should leave this feature disabled.'
=> 'Some LON-CAPA users have a long list of roles. The Recent Roles Hotlist feature keeps track of the last N roles which have been visited and places a table of these at the top of the roles page. People with very few roles should leave this feature disabled.',

   'Some extra items were submitted.'
=> 'Some extra items were submitted.',

   'Some point values were assigned for problems with a weight of zero. These values were ignored.'
=> 'Some point values were assigned for problems with a weight of zero. These values were ignored.',

   'Some resources in the sequence currently are not set to exam mode. Grading these resources currently may not work correctly.'
=> 'Some resources in the sequence currently are not set to exam mode. Grading these resources currently may not work correctly.',

   'Somewhere something went wrong'
=> 'Somewhere something went wrong',

   'Sorry!'
=> 'Sorry!',

   'Sorry, no feedback possible on this resource ...'
=> 'Sorry, no feedback possible on this resource ...',

   'Sorry, no recipients ...'
=> 'Sorry, no recipients ...',

   'Sorry, the URL generated when you requested creation of an account contained incomplete information.'
=> 'Sorry, the URL generated when you requested creation of an account contained incomplete information.',

   'Sorry, the URL generated when you requested reset of your password contained incomplete information.'
=> 'Sorry, the URL generated when you requested reset of your password contained incomplete information.',

   'Sorry, the URL generated when you requested reset of your password contained incomplete information. Please submit a [_1]new request[_2] for a password reset, and use the new URL that will be sent to your e-mail account to complete the process.'
=> 'Sorry, the URL generated when you requested reset of your password contained incomplete information. Please submit a [_1]new request[_2] for a password reset, and use the new URL that will be sent to your e-mail account to complete the process.',

   'Sorry, the URL you provided to complete creation of a new LON-CAPA account was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid.'
=> 'Sorry, the URL you provided to complete creation of a new LON-CAPA account was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid.',

   'Sorry, the URL you provided to complete the reset of your password was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid. Please submit a [_1]new request[_2] for a password reset, and follow the link to the new URL included in the e-mail that will be sent to you, to allow you to enter a new password.'
=> 'Sorry, the URL you provided to complete the reset of your password was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid. Please submit a [_1]new request[_2] for a password reset, and follow the link to the new URL included in the e-mail that will be sent to you, to allow you to enter a new password.',

   'Sorry, the token generated when you requested a password reset has expired.'
=> 'Sorry, the token generated when you requested a password reset has expired.',

   'Sorry, the token generated when you requested creation of an account has expired.'
=> 'Sorry, the token generated when you requested creation of an account has expired.',

   'Sort Imported Resources'
=> 'Sort Imported Resources',

   'Sort by realm first, then student (group/section)'
=> 'Sort by realm first, then student (group/section)',

   'Sort by section then student'
=> 'Sort by section then student',

   'Sort by student (group/section) first, then realm'
=> 'Sort by student (group/section) first, then realm',

   'Sort by students across sections.'
=> 'Sort by students across sections.',

   'Sort by:'
=> 'Sort by:',

   'Sort order'
=> 'Sort order',

   'Sorted by'
=> 'Sorted by',

   'Sorting/Filtering options'
=> 'Sorting/Filtering options',

   'Source Available'
=> 'Source Available',

   'Source Code'
=> 'Source Code',

   'Source Custom Distribution File'
=> 'Source Custom Distribution File',

   'Source Distribution'
=> 'Source Distribution',

   'Source: closed'
=> 'Source: closed',

   'Source: open'
=> 'Source: open',

   'Space units<br />check for mm'
=> 'Space units<br />check for mm',

   'Special Document'
=> 'Special Document',

   'Specific IPs'
=> 'Specific IPs',

   'Specific Resource: [_1] ([_2])'
=> 'Specific Resource: [_1] ([_2])',

   'Specific domain:'
=> 'Specific domain:',

   'Specific groups'
=> 'Specific groups',

   'Specific role status'
=> 'Specific role status',

   'Specific sections'
=> 'Specific sections',

   'Specific user roles'
=> 'Specific user roles',

   'Specific users'
=> 'Specific users',

   'Specify a bubblesheet data file to upload.'
=> 'Specify a bubblesheet data file to upload.',

   'Specify a file containing the class scores for current resource.'
=> 'Specify a file containing the class scores for current resource.',

   'Specify a file containing the clicker information for this resource.'
=> 'Specify a file containing the clicker information for this resource.',

   'Specify file and which Folder/Sequence to grade'
=> 'Specify file and which Folder/Sequence to grade',

   'Specify the Course Management system used to create the package'
=> 'Specify the Course Management system used to create the package',

   'Specify the course to be created.'
=> 'Specify the course to be created.',

   'Specify the number of assignments per PDF:'
=> 'Specify the number of assignments per PDF:',

   'Speller Suggestions'
=> 'Speller Suggestions',

   'Spreadsheet'
=> 'Spreadsheet',

   'Spreadsheet Help'
=> 'Spreadsheet Help',

   'Spreadsheet: (with link to detailed scores)'
=> 'Spreadsheet: (with link to detailed scores)',

   'Spreadsheets'
=> 'Spreadsheets',

   'Staff information'
=> 'Staff information',

   'Standard Catalog Metadata'
=> 'Standard Catalog Metadata',

   'Standard Portfolio Metadata'
=> 'Standard Portfolio Metadata',

   'Standard Problem'
=> 'Standard Problem',

   'Standard: shows points'
=> 'Standard: shows points',

   'Start Date'
=> 'Start Date',

   'Start Time: [_1]'
=> 'Start Time: [_1]',

   'Start Timer?'
=> 'Start Timer?',

   'Start a New Feed'
=> 'Start a New Feed',

   'Start auto-enrollment'
=> 'Start auto-enrollment',

   'Start date'
=> 'Start date',

   'Start date:'
=> 'Start date:',

   'Start new page<br />before selected'
=> 'Start new page<br />before selected',

   'Start the process of hand grading submissions.'
=> 'Start the process of hand grading submissions.',

   'Start: '
=> 'Start: ',

   'Starting ...'
=> 'Starting ...',

   'Starts'
=> 'Starts',

   'Starts: [_1]'
=> 'Starts: [_1]',

   'Statistics Main Page'
=> 'Statistics Main Page',

   'Statistics and Analyses'
=> 'Statistics and Analyses',

   'Statistics calculated for number of students'
=> 'Statistics calculated for number of students',

   'Status Page'
=> 'Status Page',

   'Status Report'
=> 'Status Report',

   'Status information'
=> 'Status information',

   'Status of domain servers'
=> 'Status of domain servers',

   'Status: [_1]'
=> 'Status: [_1]',

   'Std Dev'
=> 'Std Dev',

   'Still larger than normal'
=> 'Still larger than normal',

   'Straighten'
=> 'Straighten',

   'String Response'
=> 'String Response',

   'String Value'
=> 'String Value',

   'String to display for answer:'
=> 'String to display for answer:',

   'Student Activity'
=> 'Student Activity',

   'Student Activity Retrieval'
=> 'Student Activity Retrieval',

   'Student Counts'
=> 'Student Counts',

   'Student Data'
=> 'Student Data',

   'Student Settings'
=> 'Student Settings',

   'Student Submission Reports'
=> 'Student Submission Reports',

   'Student View'
=> 'Student View',

   'Student agreement needed to be listed'
=> 'Student agreement needed to be listed',

   'Student enrollment changes in [_1]'
=> 'Student enrollment changes in [_1]',

   'Student may select multiple choices from list'
=> 'Student may select multiple choices from list',

   'Student may select only one choice from list'
=> 'Student may select only one choice from list',

   'Student photo settings'
=> 'Student photo settings',

   'Student questions about course content should be directed to the course instructor'
=> 'Student questions about course content should be directed to the course instructor',

   "Student's agreement needed for listing in student-viewable roster"
=> "Student's agreement needed for listing in student-viewable roster",

   'Student-viewable classlist options'
=> 'Student-viewable classlist options',

   'Student-viewable course roster'
=> 'Student-viewable course roster',

   'Student/Employee ID'
=> 'Student/Employee ID',

   'Student: '
=> 'Student: ',

   'Student: [_1]'
=> 'Student: [_1]',

   'Students'
=> 'Students',

   'Students Attempting'
=> 'Students Attempting',

   'Students did not bubble their IDs, or mis-bubbled them'
=> 'Students did not bubble their IDs, or mis-bubbled them',

   'Students enrolling in the sections listed below will be automatically added to the class roster for LON-CAPA course'
=> 'Students enrolling in the sections listed below will be automatically added to the class roster for LON-CAPA course',

   'Students in any section'
=> 'Students in any section',

   'Students in section "[_1]"'
=> 'Students in section "[_1]"',

   'Students selected from this list can be dropped.'
=> 'Students selected from this list can be dropped.',

   'Students to Drop'
=> 'Students to Drop',

   'Students with differences between bubblesheet data and submissions are as follows:'
=> 'Students with differences between bubblesheet data and submissions are as follows:',

   'Students with exact correspondence between bubblesheet data and submissions are as follows:'
=> 'Students with exact correspondence between bubblesheet data and submissions are as follows:',

   'Students with future roles'
=> 'Students with future roles',

   'Students with no section'
=> 'Students with no section',

   'Subcategory ...'
=> 'Subcategory ...',

   'Submission'
=> 'Submission',

   'Submission #'
=> 'Submission #',

   'Submission Record'
=> 'Submission Record',

   'Submission Status'
=> 'Submission Status',

   'Submission Time Plots'
=> 'Submission Time Plots',

   'Submission in grading queue'
=> 'Submission in grading queue',

   'Submission not graded. Use fewer digits.'
=> 'Submission not graded. Use fewer digits.',

   'Submission not graded. Use more digits.'
=> 'Submission not graded. Use more digits.',

   "Submission won't be graded. The type of file submitted is not allowed."
=> "Submission won't be graded. The type of file submitted is not allowed.",

   'Submissions are not permanently recorded'
=> 'Submissions are not permanently recorded',

   'Submissions to practice problems are not permanently recorded.'
=> 'Submissions to practice problems are not permanently recorded.',

   'Submit Evaluation'
=> 'Submit Evaluation',

   'Submit Grades'
=> 'Submit Grades',

   'Submit Request'
=> 'Submit Request',

   'Submit a file: (only one file can be uploaded)'
=> 'Submit a file: (only one file can be uploaded)',

   'Submit a request to the LON-CAPA [_1]helpdesk[_2] for [_3] if you require assistance.'
=> 'Submit a request to the LON-CAPA [_1]helpdesk[_2] for [_3] if you require assistance.',

   'Submit community request'
=> 'Submit community request',

   'Submit course request'
=> 'Submit course request',

   'Submitted Answer'
=> 'Submitted Answer',

   'Submitted Answer:'
=> 'Submitted Answer:',

   'Submitted and currently in grading queue.'
=> 'Submitted and currently in grading queue.',

   'Submitting as Comment'
=> 'Submitting as Comment',

   'Submitting as Policy Feedback'
=> 'Submitting as Policy Feedback',

   'Submitting as Question'
=> 'Submitting as Question',

   'Substitution'
=> 'Substitution',

   'Substitutions:<br />[_1]: student name, [_2]: course id, [_3]: assignment note. Numbers after the <tt>%</tt> limit the field size.'
=> 'Substitutions:<br />[_1]: student name, [_2]: course id, [_3]: assignment note. Numbers after the <tt>%</tt> limit the field size.',

   'Successfully registered key'
=> 'Successfully registered key',

   'Successfully stored grades for [quant,_1,student].'
=> 'Successfully stored grades for [quant,_1,student].',

   'Summary Preview'
=> 'Summary Preview',

   'Summary Table'
=> 'Summary Table',

   'Summary Tables'
=> 'Summary Tables',

   'Summary table for [_1] ([_2])'
=> 'Summary table for [_1] ([_2])',

   'Supplemental documents'
=> 'Supplemental documents',

   'Support E-mail address'
=> 'Support E-mail address',

   'Support Request'
=> 'Support Request',

   'Suppress number of tries in printing'
=> 'Suppress number of tries in printing',

   'Survey'
=> 'Survey',

   'Survey Question (with credit)'
=> 'Survey Question (with credit)',

   'Survey Reports'
=> 'Survey Reports',

   'Survey submission recorded'
=> 'Survey submission recorded',

   'Surveys'
=> 'Surveys',

   'Switch community role to...'
=> 'Switch community role to...',

   'Switch course role to...'
=> 'Switch course role to...',

   'Switching Server ...'
=> 'Switching Server ...',

   'Symb List'
=> 'Symb List',

   'Symbol font'
=> 'Symbol font',

   'TAs'
=> 'TAs',

   'TRASH'
=> 'TRASH',

   'Table Mode'
=> 'Table Mode',

   'Table Mode Parameter Setting'
=> 'Table Mode Parameter Setting',

   'Table of Contents'
=> 'Table of Contents',

   'Table of course contents'
=> 'Table of course contents',

   'Tabloid'
=> 'Tabloid',

   'Take the following action to ensure the course appears in the Catalog:'
=> 'Take the following action to ensure the course appears in the Catalog:',

   'Task Description'
=> 'Task Description',

   'Task information'
=> 'Task information',

   'TeX error message: [_1]'
=> 'TeX error message: [_1]',

   'TeX to HTML'
=> 'TeX to HTML',

   'TeXheight (mm):'
=> 'TeXheight (mm):',

   'TeXwidth (mm):'
=> 'TeXwidth (mm):',

   'TeXwrap:'
=> 'TeXwrap:',

   'Tenths of a Point'
=> 'Tenths of a Point',

   'Testbank file'
=> 'Testbank file',

   'Text (essays only)'
=> 'Text (essays only)',

   'Text color'
=> 'Text color',

   'Text default(s):'
=> 'Text default(s):',

   'Text you want to appear by default:'
=> 'Text you want to appear by default:',

   'Thank you for using LON-CAPA.'
=> 'Thank you for using LON-CAPA.',

   'Thank you for your help!'
=> 'Thank you for your help!',

   'Thank you for your input!'
=> 'Thank you for your input!',

   'Thank you for your request to create a new LON-CAPA account.'
=> 'Thank you for your request to create a new LON-CAPA account.',

   'Thank you for your request to reset the password for your LON-CAPA account.'
=> 'Thank you for your request to reset the password for your LON-CAPA account.',

   'Thank you!'
=> 'Thank you!',

   'The &quot;Course Title&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next&quot; to continue.'
=> 'The &quot;Course Title&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next&quot; to continue.',

   'The <b>complete</b> page/sequence/folder: For one student'
=> 'The <b>complete</b> page/sequence/folder: For one student',

   'The LearningOnline Network with CAPA'
=> 'The LearningOnline Network with CAPA',

   'The LearningOnline Network with CAPA Login'
=> 'The LearningOnline Network with CAPA Login',

   'The URL you should use to access the LON-CAPA system at your institution is: '
=> 'The URL you should use to access the LON-CAPA system at your institution is: ',

   'The WYSIWYG editor only supports simple HTML and is in many cases unsuited for advanced authoring. In a number of cases, it may destroy advanced authoring involving LaTeX and script function calls.'
=> 'The WYSIWYG editor only supports simple HTML and is in many cases unsuited for advanced authoring. In a number of cases, it may destroy advanced authoring involving LaTeX and script function calls.',

   'The [_1]Course/Community Catalog[_2] provides information about all [_3] classes for which LON-CAPA courses have been created, as well as any communities in the domain.'
=> 'The [_1]Course/Community Catalog[_2] provides information about all [_3] classes for which LON-CAPA courses have been created, as well as any communities in the domain.',

   'The above receipt number matches the following [quant,_1,student].'
=> 'The above receipt number matches the following [quant,_1,student].',

   'The administrator of this domain has disabled personal information page functionality for this specific user.'
=> 'The administrator of this domain has disabled personal information page functionality for this specific user.',

   'The administrators of the domain [_1] have not set any e-mail addresses for receipt of your error report.'
=> 'The administrators of the domain [_1] have not set any e-mail addresses for receipt of your error report.',

   'The analysis you have selected is not supported at this time.'
=> 'The analysis you have selected is not supported at this time.',

   'The change will become active on the next page.'
=> 'The change will become active on the next page.',

   'The chosen course category [_1] is valid.'
=> 'The chosen course category [_1] is valid.',

   'The community you selected is not a valid community in this domain'
=> 'The community you selected is not a valid community in this domain',

   'The conditions can include affiliation with a particular course or community, or a user account in a specific domain.'
=> 'The conditions can include affiliation with a particular course or community, or a user account in a specific domain.',

   'The conditions can include affiliation with a particular course, or a user account in a specific domain.'
=> 'The conditions can include affiliation with a particular course, or a user account in a specific domain.',

   'The course has been categorized using at least one of the course categories defined for the domain.'
=> 'The course has been categorized using at least one of the course categories defined for the domain.',

   'The course has yet to be created.'
=> 'The course has yet to be created.',

   'The course owner has invited you to become a co-owner:'
=> 'The course owner has invited you to become a co-owner:',

   'The course roster is not up to date'
=> 'The course roster is not up to date',

   'The courseID provided does not match a community in this domain.'
=> 'The courseID provided does not match a community in this domain.',

   'The courseID provided does not match a course in this domain.'
=> 'The courseID provided does not match a course in this domain.',

   'The current status of this request could not be verified as pending approval/institutional action.'
=> 'The current status of this request could not be verified as pending approval/institutional action.',

   'The data are not in the format expected for the domain: [_1]'
=> 'The data are not in the format expected for the domain: [_1]',

   'The default privileges new members will receive are:'
=> 'The default privileges new members will receive are:',

   'The disk space allocated for group portfolio files in this community is the default quota for this domain: [_1] Mb.'
=> 'The disk space allocated for group portfolio files in this community is the default quota for this domain: [_1] Mb.',

   'The disk space allocated for group portfolio files in this course is the default quota for this domain: [_1] Mb.'
=> 'The disk space allocated for group portfolio files in this course is the default quota for this domain: [_1] Mb.',

   'The disk space allocated for group portfolio files is now: [_1] Mb.'
=> 'The disk space allocated for group portfolio files is now: [_1] Mb.',

   'The disk space allocated for group portfolio files remains unchanged as [_1] Mb.'
=> 'The disk space allocated for group portfolio files remains unchanged as [_1] Mb.',

   'The document contains errors and cannot be published.'
=> 'The document contains errors and cannot be published.',

   'The domain has been configured to disable, by default, personal information page functionality for all users in the domain.'
=> 'The domain has been configured to disable, by default, personal information page functionality for all users in the domain.',

   'The domain you provided is not a valid LON-CAPA domain.'
=> 'The domain you provided is not a valid LON-CAPA domain.',

   'The e-mail address entered in row '
=> 'The e-mail address entered in row ',

   'The e-mail address you entered'
=> 'The e-mail address you entered',

   'The e-mail address you provided does not appear to be a valid address.'
=> 'The e-mail address you provided does not appear to be a valid address.',

   'The e-mail address you provided does not match the address recorded in the LON-CAPA system for the username and domain you provided.'
=> 'The e-mail address you provided does not match the address recorded in the LON-CAPA system for the username and domain you provided.',

   'The e-mail address you provided is already in use as a username at this institution.'
=> 'The e-mail address you provided is already in use as a username at this institution.',

   'The e-mail address you provided may not be used as a username at this LON-CAPA institution.'
=> 'The e-mail address you provided may not be used as a username at this LON-CAPA institution.',

   'The end date for access to this course for users who self-enroll has passed.'
=> 'The end date for access to this course for users who self-enroll has passed.',

   'The enrollment limit of [quant,_1,self-enrolled student] has been reached.'
=> 'The enrollment limit of [quant,_1,self-enrolled student] has been reached.',

   'The enrollment limit of [quant,_1,student] has been reached.'
=> 'The enrollment limit of [quant,_1,student] has been reached.',

   'The error occurred on host [_1]'
=> 'The error occurred on host [_1]',

   'The existing LON-CAPA classlist contains user: [_1] and student/employee ID: [_2].'
=> 'The existing LON-CAPA classlist contains user: [_1] and student/employee ID: [_2].',

   'The extension on this file is not recognized by LON-CAPA.'
=> 'The extension on this file is not recognized by LON-CAPA.',

   'The extension on this file is reserved internally by LON-CAPA.'
=> 'The extension on this file is reserved internally by LON-CAPA.',

   'The extension on this file, [_1], is not recognized by LON-CAPA.'
=> 'The extension on this file, [_1], is not recognized by LON-CAPA.',

   'The extension on this file, [_1], is reserved internally by LON-CAPA.'
=> 'The extension on this file, [_1], is reserved internally by LON-CAPA.',

   'The file format for the uploaded portion of the message is'
=> 'The file format for the uploaded portion of the message is',

   'The file was uploaded to the wrong course'
=> 'The file was uploaded to the wrong course',

   'The first date for automated enrollment has been changed'
=> 'The first date for automated enrollment has been changed',

   'The first date for automated enrollment has been left unchanged as'
=> 'The first date for automated enrollment has been left unchanged as',

   'The folder "[_1]" contains messages so it may not be deleted.'
=> 'The folder "[_1]" contains messages so it may not be deleted.',

   'The folder "[_1]" could not be renamed to "[_2]" because the folder does not exist.'
=> 'The folder "[_1]" could not be renamed to "[_2]" because the folder does not exist.',

   'The folder "[_1]" does not exist so deletion is not required.'
=> 'The folder "[_1]" does not exist so deletion is not required.',

   'The folder "[_1]" may not be deleted'
=> 'The folder "[_1]" may not be deleted',

   'The folder "[_1]" may not be deleted.'
=> 'The folder "[_1]" may not be deleted.',

   'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is an invalid name.'
=> 'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is an invalid name.',

   'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is reserved for folders provided automatically by the system.'
=> 'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is reserved for folders provided automatically by the system.',

   'The folder "[_1]" may not be renamed to "[_2]" because the new name you requested is already being used for an existing folder.'
=> 'The folder "[_1]" may not be renamed to "[_2]" because the new name you requested is already being used for an existing folder.',

   'The folder may not be renamed'
=> 'The folder may not be renamed',

   'The folder name: "[_1]" is already in use for an existing folder.'
=> 'The folder name: "[_1]" is already in use for an existing folder.',

   'The folder name: "[_1]" is already used for one of the folders automatically generated by the system.'
=> 'The folder name: "[_1]" is already used for one of the folders automatically generated by the system.',

   'The following Cc e-mail address is invalid: '
=> 'The following Cc e-mail address is invalid: ',

   'The following Cc e-mail addresses are invalid: '
=> 'The following Cc e-mail addresses are invalid: ',

   'The following [quant,_1,change] occurred in [_2] - [_3] as a result of the automated classlist update:'
=> 'The following [quant,_1,change] occurred in [_2] - [_3] as a result of the automated classlist update:',

   'The following [quant,_1,role,roles] will become active in the future:'
=> 'The following [quant,_1,role,roles] will become active in the future:',

   'The following are valid extensions: [_1].'
=> 'The following are valid extensions: [_1].',

   'The following automated enrollment parameters have been changed:'
=> 'The following automated enrollment parameters have been changed:',

   'The following automated enrollment parameters remain unchanged:'
=> 'The following automated enrollment parameters remain unchanged:',

   'The following changes occurred:'
=> 'The following changes occurred:',

   'The following changes were made'
=> 'The following changes were made',

   'The following changes were made to self-enrollment settings:'
=> 'The following changes were made to self-enrollment settings:',

   'The following community [quant,_1,role] will become available for selection from your [_2]roles page[_3], once the default student access start date - [_4] - has been reached:'
=> 'The following community [quant,_1,role] will become available for selection from your [_2]roles page[_3], once the default student access start date - [_4] - has been reached:',

   'The following course [quant,_1,role] will become available for selection from your [_2]roles page[_3], once the default student access start date - [_4] - has been reached:'
=> 'The following course [quant,_1,role] will become available for selection from your [_2]roles page[_3], once the default student access start date - [_4] - has been reached:',

   'The following course/community creation request rejections could not be fully processed because an error occurred:'
=> 'The following course/community creation request rejections could not be fully processed because an error occurred:',

   'The following course/community creation requests could not be processed because an error occurred:'
=> 'The following course/community creation requests could not be processed because an error occurred:',

   'The following course/community creation requests could not be processed because the owner does not have rights to create this type of course:'
=> 'The following course/community creation requests could not be processed because the owner does not have rights to create this type of course:',

   'The following course/community creation requests were deleted because the course or community has already been created:'
=> 'The following course/community creation requests were deleted because the course or community has already been created:',

   'The following course/community creation requests were ignored because the request is no longer in the queue:'
=> 'The following course/community creation requests were ignored because the request is no longer in the queue:',

   'The following courses/communities were created:'
=> 'The following courses/communities were created:',

   'The following crosslisted courses were invalid:'
=> 'The following crosslisted courses were invalid:',

   'The following enrollment requests could not be processed because an error occurred:'
=> 'The following enrollment requests could not be processed because an error occurred:',

   'The following enrollment requests were deleted because the requestor does not have a LON-CAPA account:'
=> 'The following enrollment requests were deleted because the requestor does not have a LON-CAPA account:',

   'The following enrollment requests were deleted because the user is already enrolled in the course:'
=> 'The following enrollment requests were deleted because the user is already enrolled in the course:',

   'The following enrollment requests were ignored because the request is no longer in the enrollment queue:'
=> 'The following enrollment requests were ignored because the request is no longer in the enrollment queue:',

   'The following enrollment requests were rejected:'
=> 'The following enrollment requests were rejected:',

   'The following enrollment requests were skipped because the enrollment limit has been reached for the course:'
=> 'The following enrollment requests were skipped because the enrollment limit has been reached for the course:',

   'The following errors occurred during export - [_1]'
=> 'The following errors occurred during export - [_1]',

   'The following fields were not updated: '
=> 'The following fields were not updated: ',

   'The following may be updated, unless you disallow updates:'
=> 'The following may be updated, unless you disallow updates:',

   'The following need to be corrected before the search can be run:'
=> 'The following need to be corrected before the search can be run:',

   'The following problems occurred:'
=> 'The following problems occurred:',

   'The following requested role: [_1] is unavailable.'
=> 'The following requested role: [_1] is unavailable.',

   'The following requested roles are unavailable:'
=> 'The following requested roles are unavailable:',

   'The following requests were rejected:'
=> 'The following requests were rejected:',

   'The following settings have been changed:<br/><ul>'
=> 'The following settings have been changed:<br/><ul>',

   'The following settings remain unchanged:<br/><ul>'
=> 'The following settings remain unchanged:<br/><ul>',

   'The following settings will apply to the group:'
=> 'The following settings will apply to the group:',

   'The following users could not be activated, because an error occurred:'
=> 'The following users could not be activated, because an error occurred:',

   'The following users could not be added, because an error occurred:'
=> 'The following users could not be added, because an error occurred:',

   'The following users could not be deleted, because an error occurred:'
=> 'The following users could not be deleted, because an error occurred:',

   'The following users could not be expired, because an error occurred:'
=> 'The following users could not be expired, because an error occurred:',

   'The following users could not be modified, because an error occurred:'
=> 'The following users could not be modified, because an error occurred:',

   'The following users could not be reenabled, because an error occurred:'
=> 'The following users could not be reenabled, because an error occurred:',

   'The following were enrolled in the community:'
=> 'The following were enrolled in the community:',

   'The following were enrolled in the course:'
=> 'The following were enrolled in the course:',

   'The following were unchanged:'
=> 'The following were unchanged:',

   'The following will be notified when an enrollment request needs approval, or has been approved: [_1].'
=> 'The following will be notified when an enrollment request needs approval, or has been approved: [_1].',

   'The following will receive notification if there are any changes in enrollment in LON-CAPA course:'
=> 'The following will receive notification if there are any changes in enrollment in LON-CAPA course:',

   "The global user preference you set for your courses can be overridden in an individual course by setting a course specific setting via the [_1]What's New Page[_2] in the course."
=> "The global user preference you set for your courses can be overridden in an individual course by setting a course specific setting via the [_1]What's New Page[_2] in the course.",

   'The group [_1] was not re-enabled, because it is not a deleted group.[_2]Perhaps it has already been re-enabled?'
=> 'The group [_1] was not re-enabled, because it is not a deleted group.[_2]Perhaps it has already been re-enabled?',

   'The group ceases to be available either for viewing or for modification of group settings and membership.'
=> 'The group ceases to be available either for viewing or for modification of group settings and membership.',

   "The group folder is removed from the folder containing it - normally this is the 'Community Groups' folder which contains folders for all groups in the community."
=> "The group folder is removed from the folder containing it - normally this is the 'Community Groups' folder which contains folders for all groups in the community.",

   "The group folder is removed from the folder containing it - normally this is the 'Course Groups' folder which contains folders for all groups in the course."
=> "The group folder is removed from the folder containing it - normally this is the 'Course Groups' folder which contains folders for all groups in the course.",

   'The group name entered '
=> 'The group name entered ',

   'The jsMath example on this page may not look right without them. The [_1]jsMath Home Page[_2] has information on how to download the needed fonts. In the meantime, jsMath will do the best it can with the fonts you have, but it may not be pretty and some equations may not be rendered correctly.'
=> 'The jsMath example on this page may not look right without them. The [_1]jsMath Home Page[_2] has information on how to download the needed fonts. In the meantime, jsMath will do the best it can with the fonts you have, but it may not be pretty and some equations may not be rendered correctly.',

   'The last date for automated enrollment has been changed'
=> 'The last date for automated enrollment has been changed',

   'The last date for automated enrollment has been left unchanged as'
=> 'The last date for automated enrollment has been left unchanged as',

   'The link included in the message will be valid for the next [_1]two[_2] hours.'
=> 'The link included in the message will be valid for the next [_1]two[_2] hours.',

   'The link to [_1]Your log file[_2]'
=> 'The link to [_1]Your log file[_2]',

   'The link to [_1]Your original LaTeX file[_2]'
=> 'The link to [_1]Your original LaTeX file[_2]',

   'The link to the requested page could not be followed.'
=> 'The link to the requested page could not be followed.',

   'The list of instructional personnel for the course will be automatically checked daily, and once you are listed the request will be processed.'
=> 'The list of instructional personnel for the course will be automatically checked daily, and once you are listed the request will be processed.',

   'The material appears to be correct'
=> 'The material appears to be correct',

   'The material is covered with sufficient depth'
=> 'The material is covered with sufficient depth',

   'The material is helpful'
=> 'The material is helpful',

   'The material is presented in a clear way'
=> 'The material is presented in a clear way',

   'The message includes the web address for the link you will use to complete the account creation process.'
=> 'The message includes the web address for the link you will use to complete the account creation process.',

   "The message itself will begin with a first line: <i>'Forwarded message from'</i> followed by the original sender's name."
=> "The message itself will begin with a first line: <i>'Forwarded message from'</i> followed by the original sender's name.",

   'The message you checked will be forwarded to the recipient(s) you select below.'
=> 'The message you checked will be forwarded to the recipient(s) you select below.',

   'The messages will be assembled from all lines with the respective
<tt>username:domain</tt>, and appended to the general message text.'
=> 'The messages will be assembled from all lines with the respective
<tt>username:domain</tt>, and appended to the general message text.',

   'The name of the new file needs to end with an appropriate file extension to indicate the type of file to create.'
=> 'The name of the new file needs to end with an appropriate file extension to indicate the type of file to create.',

   'The name: "communities" is a reserved category'
=> 'The name: "communities" is a reserved category',

   'The name: "instcode" is a reserved category'
=> 'The name: "instcode" is a reserved category',

   'The nature of the problem is unclear'
=> 'The nature of the problem is unclear',

   'The new community could not be cloned from the existing community because the new community owner ([_1]) does not have cloning rights in the existing community ([_2]).'
=> 'The new community could not be cloned from the existing community because the new community owner ([_1]) does not have cloning rights in the existing community ([_2]).',

   'The new course could not be cloned from the existing course because the new course owner ([_1]) does not have cloning rights in the existing course ([_2]).'
=> 'The new course could not be cloned from the existing course because the new course owner ([_1]) does not have cloning rights in the existing course ([_2]).',

   'The new directory name was changed from [_1] to [_2].'
=> 'The new directory name was changed from [_1] to [_2].',

   'The new discussion board was added successfully.<br />'
=> 'The new discussion board was added successfully.<br />',

   'The new file name was changed from:<br />[_1] to [_2]'
=> 'The new file name was changed from:<br />[_1] to [_2]',

   'The new folder may not be named'
=> 'The new folder may not be named',

   'The new passwords you entered do not match.'
=> 'The new passwords you entered do not match.',

   'The new passwords you entered do not match. Please try again.'
=> 'The new passwords you entered do not match. Please try again.',

   'The optional affiliation field was not specified'
=> 'The optional affiliation field was not specified',

   'The optional domain field was not specified.'
=> 'The optional domain field was not specified.',

   'The optional role field was not specified.'
=> 'The optional role field was not specified.',

   'The optional section field was not specified.'
=> 'The optional section field was not specified.',

   'The optional student/employee ID field was not specified.'
=> 'The optional student/employee ID field was not specified.',

   'The password entered was also correct so you have been logged in.'
=> 'The password entered was also correct so you have been logged in.',

   'The password for user [_1] was not changed.'
=> 'The password for user [_1] was not changed.',

   'The password for user [_1] was successfully changed.'
=> 'The password for user [_1] was successfully changed.',

   'The password for your LON-CAPA account in the [_1] domain was changed [_2] from IP address: [_3].  If you did not perform this change or authorize it, please contact the [_4] ([_5]).'
=> 'The password for your LON-CAPA account in the [_1] domain was changed [_2] from IP address: [_3].  If you did not perform this change or authorize it, please contact the [_4] ([_5]).',

   'The password you entered contained illegal characters.'
=> 'The password you entered contained illegal characters.',

   'The passwords you entered did not match.'
=> 'The passwords you entered did not match.',

   'The placeholder for the courseID is absent.'
=> 'The placeholder for the courseID is absent.',

   'The preferences you set here can be overridden within each individual discussion.'
=> 'The preferences you set here can be overridden within each individual discussion.',

   'The problem '
=> 'The problem ',

   'The quota can be increased to [_1] Mb, by adding all unallocated space for groups in the course.'
=> 'The quota can be increased to [_1] Mb, by adding all unallocated space for groups in the course.',

   'The quota is currently [_1] Mb'
=> 'The quota is currently [_1] Mb',

   'The recipient addresses may need to be corrected'
=> 'The recipient addresses may need to be corrected',

   'The request cancellation process was not complete.'
=> 'The request cancellation process was not complete.',

   'The requested file [_1] currently does not exist.'
=> 'The requested file [_1] currently does not exist.',

   'The resource depends on another resource with variable filename, i.e., [_1].'
=> 'The resource depends on another resource with variable filename, i.e., [_1].',

   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc)'
=> 'The resource is technically correct (loads fast enough, does not produce errors, links work, etc)',

   'The resources in "[_1]" are open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete all resources "[_1]".'
=> 'The resources in "[_1]" are open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete all resources "[_1]".',

   'The resources in "[_1]" are open for a limited time. Once you click the "[_2]" button below you have [_3] to complete all resources in "[_1]".'
=> 'The resources in "[_1]" are open for a limited time. Once you click the "[_2]" button below you have [_3] to complete all resources in "[_1]".',

   'The scores were changed for [quant,_1,problem].'
=> 'The scores were changed for [quant,_1,problem].',

   'The sender did not designate a reply to address for this message.'
=> 'The sender did not designate a reply to address for this message.',

   'The single student in the course[_1] has opted not to be listed in the roster.'
=> 'The single student in the course[_1] has opted not to be listed in the roster.',

   'The single student in the course[_1] has opted to be listed in the roster.'
=> 'The single student in the course[_1] has opted to be listed in the roster.',

   'The single student in the section[_1] has opted not to be listed in the roster.'
=> 'The single student in the section[_1] has opted not to be listed in the roster.',

   'The single student in the section[_1] has opted to be listed in the roster.'
=> 'The single student in the section[_1] has opted to be listed in the roster.',

   'The single student without a section[_1] has opted not to be listed in the roster.'
=> 'The single student without a section[_1] has opted not to be listed in the roster.',

   'The single student without a section[_1] has opted to be listed in the roster.'
=> 'The single student without a section[_1] has opted to be listed in the roster.',

   'The start date for access to this course for users who self-enroll has yet to be reached.'
=> 'The start date for access to this course for users who self-enroll has yet to be reached.',

   "The subject in each forwarded message will be <i>'Forwarding:'</i> followed by the original subject."
=> "The subject in each forwarded message will be <i>'Forwarding:'</i> followed by the original subject.",

   'The subject is 

 [_1]

'
=> 'The subject is 

 [_1]

',

   "The table below contains a list of Domänen-Koordinators from this course's domain who are not also Kurs-Koordinators."
=> "The table below contains a list of Domänen-Koordinators from this course's domain who are not also Kurs-Koordinators.",

   'The table below contains a list of Kurs-Koordinators in this course.'
=> 'The table below contains a list of Kurs-Koordinators in this course.',

   "The text you are searching for must contain at least three characters when using a 'contains' type search."
=> "The text you are searching for must contain at least three characters when using a 'contains' type search.",

   "The text you are searching for must contain at least two characters when using a 'begins' type search."
=> "The text you are searching for must contain at least two characters when using a 'begins' type search.",

   'The token included in an e-mail sent to you [_1] has been verified, so you may now proceed to reset the password for your LON-CAPA account.'
=> 'The token included in an e-mail sent to you [_1] has been verified, so you may now proceed to reset the password for your LON-CAPA account.',

   'The total disk space allocated for storage of portfolio files in all groups in a course.'
=> 'The total disk space allocated for storage of portfolio files in all groups in a course.',

   'The uploaded screenshot file ([_1] bytes) included with your request exceeded the maximum allowed size - 128 KB, and has therefore been discarded.'
=> 'The uploaded screenshot file ([_1] bytes) included with your request exceeded the maximum allowed size - 128 KB, and has therefore been discarded.',

   'The username [_1] remains in the institutional classlist, but the same student/employee ID is used for new user: [_2] now found in the institutional classlist.'
=> 'The username [_1] remains in the institutional classlist, but the same student/employee ID is used for new user: [_2] now found in the institutional classlist.',

   'The username of the Coordinator is required'
=> 'The username of the Coordinator is required',

   'The username you provided uses an authentication type which can not be reset directly via LON-CAPA.'
=> 'The username you provided uses an authentication type which can not be reset directly via LON-CAPA.',

   'The username you provided was not verified as a valid username in the LON-CAPA system for the [_1] domain.'
=> 'The username you provided was not verified as a valid username in the LON-CAPA system for the [_1] domain.',

   'The value provided was invalid - it must be a positive integer if enrollment is being limited.'
=> 'The value provided was invalid - it must be a positive integer if enrollment is being limited.',

   'The value you entered for the quota for the group portfolio in this group contained invalid characters, so it has been set to 0 Mb. You can change this by modifying the group settings.'
=> 'The value you entered for the quota for the group portfolio in this group contained invalid characters, so it has been set to 0 Mb. You can change this by modifying the group settings.',

   'The value you entered for the quota for the group portfolio in this group exceeded the maximum possible value, so it has been set to [_1] Mb (the maximum possible value).'
=> 'The value you entered for the quota for the group portfolio in this group exceeded the maximum possible value, so it has been set to [_1] Mb (the maximum possible value).',

   'There are [_1] matches to your query.'
=> 'There are [_1] matches to your query.',

   'There are currently no course or community requests awaiting approval.'
=> 'There are currently no course or community requests awaiting approval.',

   'There are currently no discussion boards in this course.'
=> 'There are currently no discussion boards in this course.',

   'There are currently no discussion boards in this group.'
=> 'There are currently no discussion boards in this group.',

   'There are currently no enrollment requests awaiting approval.'
=> 'There are currently no enrollment requests awaiting approval.',

   'There are currently no enrollment requests.'
=> 'There are currently no enrollment requests.',

   'There are currently no publicly accessible or password protected group portfolio files.'
=> 'There are currently no publicly accessible or password protected group portfolio files.',

   'There are currently no requests for official courses awaiting validation.'
=> 'There are currently no requests for official courses awaiting validation.',

   'There are currently no resources or discussion boards with unread discussion postings.'
=> 'There are currently no resources or discussion boards with unread discussion postings.',

   'There are currently no students to display.'
=> 'There are currently no students to display.',

   'There are errors in [_1].'
=> 'There are errors in [_1].',

   'There are errors.'
=> 'There are errors.',

   'There are no active Domain Coordinators'
=> 'There are no active Domain Coordinators',

   'There are no active, future or previous group members to modify.'
=> 'There are no active, future or previous group members to modify.',

   'There are no author roles currently in domain: [_1], so there are no Construction spaces for which you can assume a co-author role.'
=> 'There are no author roles currently in domain: [_1], so there are no Construction spaces for which you can assume a co-author role.',

   'There are no authors or co-authors to display.'
=> 'There are no authors or co-authors to display.',

   'There are no available files of the specified access type: [_1]'
=> 'There are no available files of the specified access type: [_1]',

   'There are no co-authors to display.'
=> 'There are no co-authors to display.',

   'There are no community users to display'
=> 'There are no community users to display',

   'There are no coordinators to select as co-owners'
=> 'There are no coordinators to select as co-owners',

   'There are no course users to display'
=> 'There are no course users to display',

   'There are no course users to display.'
=> 'There are no course users to display.',

   'There are no forwarded messages in this folder.'
=> 'There are no forwarded messages in this folder.',

   'There are no groups to display in this [_1].'
=> 'There are no groups to display in this [_1].',

   'There are no library servers containing Construction spaces currently in domain: [_1], so you can not assume a co-author role.'
=> 'There are no library servers containing Construction spaces currently in domain: [_1], so you can not assume a co-author role.',

   'There are no members currently enrolled.'
=> 'There are no members currently enrolled.',

   'There are no members to drop.'
=> 'There are no members to drop.',

   'There are no membership data to display for this [_1]'
=> 'There are no membership data to display for this [_1]',

   'There are no membership data to display for this group.'
=> 'There are no membership data to display for this group.',

   'There are no messages in this folder.'
=> 'There are no messages in this folder.',

   'There are no parameters.'
=> 'There are no parameters.',

   'There are no read messages in this folder.'
=> 'There are no read messages in this folder.',

   'There are no records to display'
=> 'There are no records to display',

   'There are no records to display.'
=> 'There are no records to display.',

   'There are no resources in your bookmarks to import.'
=> 'There are no resources in your bookmarks to import.',

   'There are no resources to import.'
=> 'There are no resources to import.',

   'There are no resources to recover.'
=> 'There are no resources to recover.',

   'There are no roles which expired since last month'
=> 'There are no roles which expired since last month',

   'There are no roles which expired since last week'
=> 'There are no roles which expired since last week',

   'There are no roles which expired since start of course'
=> 'There are no roles which expired since start of course',

   'There are no roles which expired since yesterday'
=> 'There are no roles which expired since yesterday',

   'There are no roles which have become active since last month'
=> 'There are no roles which have become active since last month',

   'There are no roles which have become active since last week'
=> 'There are no roles which have become active since last week',

   'There are no roles which have become active since start of course'
=> 'There are no roles which have become active since start of course',

   'There are no roles which have become active since yesterday'
=> 'There are no roles which have become active since yesterday',

   'There are no students in the sections selected.'
=> 'There are no students in the sections selected.',

   'There are no students in the sections/groups selected.'
=> 'There are no students in the sections/groups selected.',

   'There are no students to drop.'
=> 'There are no students to drop.',

   'There are no students with current/future access to the course.'
=> 'There are no students with current/future access to the course.',

   'There are no students with future access in the course.'
=> 'There are no students with future access in the course.',

   'There are no students with future access in the selected sections.'
=> 'There are no students with future access in the selected sections.',

   'There are no survey problems in this course.'
=> 'There are no survey problems in this course.',

   'There are no transactions to display.'
=> 'There are no transactions to display.',

   'There are no unread messages in this folder.'
=> 'There are no unread messages in this folder.',

   'There are no users matching the search criteria.'
=> 'There are no users matching the search criteria.',

   'There are no users to add as new members, as all users matching the specified type(s), role(s), and section(s) are already affiliated with this group.'
=> 'There are no users to add as new members, as all users matching the specified type(s), role(s), and section(s) are already affiliated with this group.',

   'There are no users with domain roles to display.'
=> 'There are no users with domain roles to display.',

   'There are several possibilities of where to go next'
=> 'There are several possibilities of where to go next',

   'There are unsaved changes'
=> 'There are unsaved changes',

   'There is currently no owner set for this community.'
=> 'There is currently no owner set for this community.',

   'There is currently no owner set for this course.'
=> 'There is currently no owner set for this course.',

   'There is no data to plot.'
=> 'There is no data to plot.',

   'There is no essay or string response data to output for this survey.'
=> 'There is no essay or string response data to output for this survey.',

   'There is no owner associated with this LON-CAPA course.'
=> 'There is no owner associated with this LON-CAPA course.',

   'There is no submission data for this problem at all.'
=> 'There is no submission data for this problem at all.',

   'There is no submission data for this problem.'
=> 'There is no submission data for this problem.',

   'There is no submission data for this resource.'
=> 'There is no submission data for this resource.',

   'There is only a single student in the course[_1]'
=> 'There is only a single student in the course[_1]',

   'There is only a single student in the section[_1]'
=> 'There is only a single student in the section[_1]',

   'There is only a single student without a section[_1]'
=> 'There is only a single student without a section[_1]',

   'There was a problem processing your requested changes.'
=> 'There was a problem processing your requested changes.',

   'There was a problem with your community selection'
=> 'There was a problem with your community selection',

   'There was a problem with your course selection'
=> 'There was a problem with your course selection',

   'There were no new students to add to the course.'
=> 'There were no new students to add to the course.',

   'There were no results matching your query.'
=> 'There were no results matching your query.',

   'These errors prevent this resource from printing correctly.'
=> 'These errors prevent this resource from printing correctly.',

   "These file(s) don't exist: [_1]"
=> "These file(s) don't exist: [_1]",

   'These will be the privileges given to members assigned in the future via automatic group assignment for users who receive specific sections/roles in the community '
=> 'These will be the privileges given to members assigned in the future via automatic group assignment for users who receive specific sections/roles in the community ',

   'These will be the privileges given to members assigned in the future via automatic group assignment for users who receive specific sections/roles in the course '
=> 'These will be the privileges given to members assigned in the future via automatic group assignment for users who receive specific sections/roles in the course ',

   'This LON-CAPA server is temporarily not available for login.'
=> 'This LON-CAPA server is temporarily not available for login.',

   'This LON-CAPA server is version [_1]'
=> 'This LON-CAPA server is version [_1]',

   'This action is currently not authorized.'
=> 'This action is currently not authorized.',

   "This can increase the time taken to gather data for the [_1]What's New Page[_2] by a few seconds."
=> "This can increase the time taken to gather data for the [_1]What's New Page[_2] by a few seconds.",

   'This course is empty.'
=> 'This course is empty.',

   'This directory is empty.'
=> 'This directory is empty.',

   'This error has been logged.'
=> 'This error has been logged.',

   'This error occurred on machine [_1]'
=> 'This error occurred on machine [_1]',

   'This error occurred while processing part [_1]'
=> 'This error occurred while processing part [_1]',

   'This error occurred while processing response [_1] in part [_2]'
=> 'This error occurred while processing response [_1] in part [_2]',

   'This file appears to be a rendering of a LON-CAPA resource. If this is correct, this resource will act very oddly and incorrectly.'
=> 'This file appears to be a rendering of a LON-CAPA resource. If this is correct, this resource will act very oddly and incorrectly.',

   'This helper will assist you in setting the open, due, and answer dates for problems, setting the problem weights, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'This helper will assist you in setting the open, due, and answer dates for problems, setting the problem weights, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.',

   'This is a list of first access times and what was accessed, please select those you want deleted.'
=> 'This is a list of first access times and what was accessed, please select those you want deleted.',

   'This is a result of one of the following:'
=> 'This is a result of one of the following:',

   'This is an automatic e-mail generated by the LON-CAPA system.'
=> 'This is an automatic e-mail generated by the LON-CAPA system.',

   'This list below can be used to <q>freeze</q> roles on your screen. Those marked as frozen will not be removed from the list, even if they have not been used recently.'
=> 'This list below can be used to <q>freeze</q> roles on your screen. Those marked as frozen will not be removed from the list, even if they have not been used recently.',

   'This may take a few moments to display.'
=> 'This may take a few moments to display.',

   'This may take some time ..'
=> 'This may take some time ..',

   'This message was designated by the sender not to allow replies.'
=> 'This message was designated by the sender not to allow replies.',

   'This message will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'This message will be inaccessible between [_1] and [_2] because communication is being blocked.',

   'This page is either empty or it only contains resources that are currently hidden'
=> 'This page is either empty or it only contains resources that are currently hidden',

   'This post has been edited by the author.'
=> 'This post has been edited by the author.',

   'This problem has been graded correct by the computer. Do you want to change the score?'
=> 'This problem has been graded correct by the computer. Do you want to change the score?',

   'This request has already been cancelled.'
=> 'This request has already been cancelled.',

   'This request has already been processed, and a course created.'
=> 'This request has already been processed, and a course created.',

   'This resource "[_1]" is open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete this resource "[_1]".'
=> 'This resource "[_1]" is open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete this resource "[_1]".',

   "This resource currently isn't open. It will be available at [_1]."
=> "This resource currently isn't open. It will be available at [_1].",

   'This resource is currently associated with a course ([_1]) which includes added metadata fields specific to the course.'
=> 'This resource is currently associated with a course ([_1]) which includes added metadata fields specific to the course.',

   'This resource is not associated with a course.'
=> 'This resource is not associated with a course.',

   'This role has section(s) associated with it.'
=> 'This role has section(s) associated with it.',

   'This screen shows how many problems (or problem parts) you have completed, and how many you have not yet done. You can also look at [_1]a detailed score sheet[_2].'
=> 'This screen shows how many problems (or problem parts) you have completed, and how many you have not yet done. You can also look at [_1]a detailed score sheet[_2].',

   'This syllabus can be publicly viewed at [_1]'
=> 'This syllabus can be publicly viewed at [_1]',

   'This user already has an active/future role in section "[_1]" of the course.'
=> 'This user already has an active/future role in section "[_1]" of the course.',

   'This user already has an active/future student role in the course, unaffiliated to any section.'
=> 'This user already has an active/future student role in the course, unaffiliated to any section.',

   'This user has an unrecognized authentication scheme'
=> 'This user has an unrecognized authentication scheme',

   'This username - [_1] - has been dropped from the institutional classlist, but the student/employee ID of this user is also used by [_2] who now appears in the institutional classlist.'
=> 'This username - [_1] - has been dropped from the institutional classlist, but the student/employee ID of this user is also used by [_2] who now appears in the institutional classlist.',

   'This username has been dropped from the institutional classlist, but the same student/employee ID is used for user: [_1] who still appears in the institutional classlist.'
=> 'This username has been dropped from the institutional classlist, but the same student/employee ID is used for user: [_1] who still appears in the institutional classlist.',

   'This will not take effect if the user already exists.'
=> 'This will not take effect if the user already exists.',

   'This will only retrieve the resource. If you want to retrieve the metadata, you will need to do that separately.'
=> 'This will only retrieve the resource. If you want to retrieve the metadata, you will need to do that separately.',

   'Threaded'
=> 'Threaded',

   'Three conditions must be met:'
=> 'Three conditions must be met:',

   'Threshold Name'
=> 'Threshold Name',

   'Time Period'
=> 'Time Period',

   'Time Remaining'
=> 'Time Remaining',

   'Time Settings'
=> 'Time Settings',

   'Time members can start reserving'
=> 'Time members can start reserving',

   'Time of change'
=> 'Time of change',

   'Time of computation'
=> 'Time of computation',

   'Time of last post'
=> 'Time of last post',

   'Time-Limit'
=> 'Time-Limit',

   'Time-Limit (interval)'
=> 'Time-Limit (interval)',

   'Timezone in which the course takes place'
=> 'Timezone in which the course takes place',

   'Tiny'
=> 'Tiny',

   'Title for the Discussion Board'
=> 'Title for the Discussion Board',

   'Title for the Drop Box'
=> 'Title for the Drop Box',

   'Title for the Problem'
=> 'Title for the Problem',

   'Title for the Uploaded Score'
=> 'Title for the Uploaded Score',

   'Title in map'
=> 'Title in map',

   'Title of document goes here'
=> 'Title of document goes here',

   'To access your LON-CAPA message, go to the Main Menu and click on "Send and Receive Messages".'
=> 'To access your LON-CAPA message, go to the Main Menu and click on "Send and Receive Messages".',

   'To add a new user:'
=> 'To add a new user:',

   'To be deleted'
=> 'To be deleted',

   'To be expired'
=> 'To be expired',

   'To change access dates for <b>currently active</b> students, use User Management -> "Manage Course Users" to display currently active students, then use the dropdown menu for "Action to take for selected users:" to choose "Change starting/ending dates", select the students to change, and click "Proceed".'
=> 'To change access dates for <b>currently active</b> students, use User Management -> "Manage Course Users" to display currently active students, then use the dropdown menu for "Action to take for selected users:" to choose "Change starting/ending dates", select the students to change, and click "Proceed".',

   'To change access dates for any currently active students, use User Management -> "Manage Users" to display currently active students, then use the dropdown menu for "Action to take for selected users:" to choose "Change starting/ending dates", select the students to change, and click "Proceed".'
=> 'To change access dates for any currently active students, use User Management -> "Manage Users" to display currently active students, then use the dropdown menu for "Action to take for selected users:" to choose "Change starting/ending dates", select the students to change, and click "Proceed".',

   'To complete this process please open a web browser and enter the following URL in the address/location box: [_1]'
=> 'To complete this process please open a web browser and enter the following URL in the address/location box: [_1]',

   'To create a new library, select a template from the list below. Then click on the "Create library" button.'
=> 'To create a new library, select a template from the list below. Then click on the "Create library" button.',

   'To create a new problem, select a template from the list below. Then click on the "Create problem" button.'
=> 'To create a new problem, select a template from the list below. Then click on the "Create problem" button.',

   'To create a new survey, select a template from the list below. Then click on the "Create survey" button.'
=> 'To create a new survey, select a template from the list below. Then click on the "Create survey" button.',

   'To create a new task, select a template from the list below. Then click on the "Create task" button.'
=> 'To create a new task, select a template from the list below. Then click on the "Create task" button.',

   'To create one, use the table below to provide information about yourself (if appropriate), then click the "Create LON-CAPA account" button.'
=> 'To create one, use the table below to provide information about yourself (if appropriate), then click the "Create LON-CAPA account" button.',

   'To create one, use the table below to provide information about yourself, then click the [_1]Create LON-CAPA account[_2] button.'
=> 'To create one, use the table below to provide information about yourself, then click the [_1]Create LON-CAPA account[_2] button.',

   "To enter multiple addresses, enter one address at a time, click 'Change' and then add the next one"
=> "To enter multiple addresses, enter one address at a time, click 'Change' and then add the next one",

   'To replace the standard title for a course role, enter a title, otherwise leave blank'
=> 'To replace the standard title for a course role, enter a title, otherwise leave blank',

   'To upload a file, click <strong>Browse...</strong> and select a file, then click <strong>Upload</strong>.'
=> 'To upload a file, click <strong>Browse...</strong> and select a file, then click <strong>Upload</strong>.',

   'To upload, rename or delete existing [_1] in [_2].'
=> 'To upload, rename or delete existing [_1] in [_2].',

   "To view a submission or a group of submissions, click on the check box(es) next to the student's name(s). Then click on the Next button."
=> "To view a submission or a group of submissions, click on the check box(es) next to the student's name(s). Then click on the Next button.",

   "To view/grade/regrade a submission or a group of submissions, click on the check box(es) next to the student's name(s). Then click on the Next button."
=> "To view/grade/regrade a submission or a group of submissions, click on the check box(es) next to the student's name(s). Then click on the Next button.",

   'To:[_1]'
=> 'To:[_1]',

   'Toggle Debug Messages.'
=> 'Toggle Debug Messages.',

   'Toggle debug messages'
=> 'Toggle debug messages',

   'Toggle display'
=> 'Toggle display',

   'Toggle read/unread'
=> 'Toggle read/unread',

   'Tolerance'
=> 'Tolerance',

   'Tools'
=> 'Tools',

   'Tools:'
=> 'Tools:',

   'Total Matches'
=> 'Total Matches',

   'Total Parts Done'
=> 'Total Parts Done',

   'Total Points In Course'
=> 'Total Points In Course',

   'Total Score and Maximum Possible for each Sequence or Folder'
=> 'Total Score and Maximum Possible for each Sequence or Folder',

   'Total disk space allocated for storage of portfolio files in all groups in a community.'
=> 'Total disk space allocated for storage of portfolio files in all groups in a community.',

   'Total disk space allocated for storage of portfolio files in all groups in a course.'
=> 'Total disk space allocated for storage of portfolio files in all groups in a course.',

   'Total number of students with submissions'
=> 'Total number of students with submissions',

   'Transaction [_1]'
=> 'Transaction [_1]',

   'Transferred data in added fields to notes'
=> 'Transferred data in added fields to notes',

   'Trial not counted'
=> 'Trial not counted',

   'Trial: [_1]'
=> 'Trial: [_1]',

   'Tries Statistics'
=> 'Tries Statistics',

   'Trouble'
=> 'Trouble',

   'Try'
=> 'Try',

   'Try Selecting Again'
=> 'Try Selecting Again',

   'Try [_1]'
=> 'Try [_1]',

   'Try again'
=> 'Try again',

   'Try again?'
=> 'Try again?',

   'Two-option checkboxes for:'
=> 'Two-option checkboxes for:',

   'Type in the letters/numbers shown below'
=> 'Type in the letters/numbers shown below',

   'Type in your log-in ID and password to find out.'
=> 'Type in your log-in ID and password to find out.',

   'Type of change'
=> 'Type of change',

   'Type: [_1]'
=> 'Type: [_1]',

   'Types of message for which notification is sent'
=> 'Types of message for which notification is sent',

   'URL hidden'
=> 'URL hidden',

   'URL of Syllabus'
=> 'URL of Syllabus',

   'URL of Syllabus (not using internal handler)'
=> 'URL of Syllabus (not using internal handler)',

   'URL of page'
=> 'URL of page',

   'URLs hidden'
=> 'URLs hidden',

   'Un-Visited Link Color'
=> 'Un-Visited Link Color',

   'Unable to add to allowed cloners: '
=> 'Unable to add to allowed cloners: ',

   'Unable to create a directory named'
=> 'Unable to create a directory named',

   'Unable to create a directory named [_1].'
=> 'Unable to create a directory named [_1].',

   'Unable to determine section, groups and access status'
=> 'Unable to determine section, groups and access status',

   'Unable to determine status due to network problems.'
=> 'Unable to determine status due to network problems.',

   'Unable to enroll users'
=> 'Unable to enroll users',

   'Unable to find [_1]'
=> 'Unable to find [_1]',

   'Unable to find section for this student'
=> 'Unable to find section for this student',

   'Unable to grade requested sequence ([_1]).'
=> 'Unable to grade requested sequence ([_1]).',

   'Unable to include amongst replacements for role names: '
=> 'Unable to include amongst replacements for role names: ',

   'Unable to include as a recipient of community feedback for:'
=> 'Unable to include as a recipient of community feedback for:',

   'Unable to include as a recipient of course feedback for:'
=> 'Unable to include as a recipient of course feedback for:',

   'Unable to include in community localization:'
=> 'Unable to include in community localization:',

   'Unable to include in course localization:'
=> 'Unable to include in course localization:',

   'Unable to include in user-based access control for:'
=> 'Unable to include in user-based access control for:',

   'Unable to interpret units. Computer reads units as "[_1]".'
=> 'Unable to interpret units. Computer reads units as "[_1]".',

   'Unable to make backup [_1]'
=> 'Unable to make backup [_1]',

   'Unable to modify requested student ([_1])'
=> 'Unable to modify requested student ([_1])',

   'Unable to retrieve course information.'
=> 'Unable to retrieve course information.',

   'Unable to retrieve information about community contents'
=> 'Unable to retrieve information about community contents',

   'Unable to retrieve information about course contents'
=> 'Unable to retrieve information about course contents',

   'Unable to retrieve saved token for password decryption'
=> 'Unable to retrieve saved token for password decryption',

   'Unable to retrieve search results. Unable to determine the table results were saved in.'
=> 'Unable to retrieve search results. Unable to determine the table results were saved in.',

   'Unable to retrieve your log-in information - unexpected context'
=> 'Unable to retrieve your log-in information - unexpected context',

   'Unable to save file [_1]'
=> 'Unable to save file [_1]',

   'Unable to save import results.'
=> 'Unable to save import results.',

   'Unable to set "number unread posts display" to [_1] due to [_2].'
=> 'Unable to set "number unread posts display" to [_1] due to [_2].',

   'Unable to set control of page display to [_1] due to [_2].'
=> 'Unable to set control of page display to [_1] due to [_2].',

   'Unable to set default access dates for community'
=> 'Unable to set default access dates for community',

   'Unable to set default access dates for course'
=> 'Unable to set default access dates for course',

   'Unable to set default access dates for course.'
=> 'Unable to set default access dates for course.',

   'Unable to set interval to [_1] due to [_2].'
=> 'Unable to set interval to [_1] due to [_2].',

   'Unable to set page display, after role selection, for this course to [_1] due to [_2].'
=> 'Unable to set page display, after role selection, for this course to [_1] due to [_2].',

   'Unable to successfully change environment for'
=> 'Unable to successfully change environment for',

   'Unable to understand the search phrase [_1]. Please modify your search.'
=> 'Unable to understand the search phrase [_1]. Please modify your search.',

   'Unable to understand the search phrase [_1]: [_2]'
=> 'Unable to understand the search phrase [_1]: [_2]',

   'Unable to undo, unable to switch [_1] and [_2]'
=> 'Unable to undo, unable to switch [_1] and [_2]',

   'Unable to upload [_1]. (size = [_2] kilobytes). Disk quota will be exceeded.'
=> 'Unable to upload [_1]. (size = [_2] kilobytes). Disk quota will be exceeded.',

   'Unable to upload [_1]. A file by that name was found in [_2].'
=> 'Unable to upload [_1]. A file by that name was found in [_2].',

   'Unable to upload [_1]. A locked file by that name was found in [_2].'
=> 'Unable to upload [_1]. A locked file by that name was found in [_2].',

   'Unable to write to [_1]'
=> 'Unable to write to [_1]',

   'Unactionable Search Query'
=> 'Unactionable Search Query',

   'Unauthenticated Help Settings'
=> 'Unauthenticated Help Settings',

   'Unavailable for assignment:'
=> 'Unavailable for assignment:',

   'Uncompleted Problems'
=> 'Uncompleted Problems',

   'Under what circumstances posts are identified as "NEW"'
=> 'Under what circumstances posts are identified as "NEW"',

   'Under what circumstances posts are identified as "NEW", and'
=> 'Under what circumstances posts are identified as "NEW", and',

   'Under you current role you are not permitted to change login settings for this user'
=> 'Under you current role you are not permitted to change login settings for this user',

   'Undid changes, Switched [_1] and [_2]'
=> 'Undid changes, Switched [_1] and [_2]',

   'Unfortunately you will not be able to retrieve an IMS archive of this posts at this time, because there was a problem creating a manifest file.'
=> 'Unfortunately you will not be able to retrieve an IMS archive of this posts at this time, because there was a problem creating a manifest file.',

   'Unfortunately you will not be able to retrieve an archive of the discussion posts at this time, because there was a problem creating a manifest file.'
=> 'Unfortunately you will not be able to retrieve an archive of the discussion posts at this time, because there was a problem creating a manifest file.',

   'Unfreezing Role: [_1]'
=> 'Unfreezing Role: [_1]',

   'Unknown'
=> 'Unknown',

   'Unknown area style [_1]'
=> 'Unknown area style [_1]',

   'Unknown command'
=> 'Unknown command',

   'Unknown status'
=> 'Unknown status',

   'Unknown type'
=> 'Unknown type',

   "Unless excluded, a course will be listed in the domain's publicly accessible Course/Community Catalog, if at least one of the following applies"
=> "Unless excluded, a course will be listed in the domain's publicly accessible Course/Community Catalog, if at least one of the following applies",

   "Unless excluded, a course/community is listed in this domain's publicly accessible Course/Community Catalog, if at least one of the following applies:"
=> "Unless excluded, a course/community is listed in this domain's publicly accessible Course/Community Catalog, if at least one of the following applies:",

   'Unless you choose otherwise:'
=> 'Unless you choose otherwise:',

   'Unlock'
=> 'Unlock',

   'Unofficial'
=> 'Unofficial',

   'Unofficial course'
=> 'Unofficial course',

   'Unofficial courses'
=> 'Unofficial courses',

   'Unordered Multi-Answer Formula Response Problem'
=> 'Unordered Multi-Answer Formula Response Problem',

   'Unpacking of your IMS package failed because an IMS manifest file was not located in the package.'
=> 'Unpacking of your IMS package failed because an IMS manifest file was not located in the package.',

   'Unread'
=> 'Unread',

   'Unread course discussion posts'
=> 'Unread course discussion posts',

   'Unread messages:'
=> 'Unread messages:',

   'Unread only'
=> 'Unread only',

   'Unrecognized course type: [_1]'
=> 'Unrecognized course type: [_1]',

   'Unregistered Clicker'
=> 'Unregistered Clicker',

   'Unselect'
=> 'Unselect',

   'Unsupported IMS format: [_1]'
=> 'Unsupported IMS format: [_1]',

   'Unsupported character combination [_1] in filename, FAIL.'
=> 'Unsupported character combination [_1] in filename, FAIL.',

   'Untitled Resource'
=> 'Untitled Resource',

   'Untitled resource'
=> 'Untitled resource',

   'Unvalidated requests will be listed for manual approval/rejection.'
=> 'Unvalidated requests will be listed for manual approval/rejection.',

   'Updataeable user data'
=> 'Updataeable user data',

   'Update'
=> 'Update',

   'Update Caches'
=> 'Update Caches',

   'Update Connections and Refresh Status Information'
=> 'Update Connections and Refresh Status Information',

   'Update Parameter Display'
=> 'Update Parameter Display',

   'Update Requests Result'
=> 'Update Requests Result',

   'Update Users'
=> 'Update Users',

   'Update information in classlists?'
=> 'Update information in classlists?',

   'Update roster now'
=> 'Update roster now',

   'Update student photos'
=> 'Update student photos',

   'Update student/employee ID in courses in which user is active/future student,[_1](if forcing change).'
=> 'Update student/employee ID in courses in which user is active/future student,[_1](if forcing change).',

   'Updated'
=> 'Updated',

   'Updating Co-authors'
=> 'Updating Co-authors',

   'Upload'
=> 'Upload',

   'Upload Classlist'
=> 'Upload Classlist',

   'Upload Course/Community Attributes File'
=> 'Upload Course/Community Attributes File',

   'Upload Custom Login Page Help File:'
=> 'Upload Custom Login Page Help File:',

   'Upload Description File'
=> 'Upload Description File',

   'Upload IMS package'
=> 'Upload IMS package',

   'Upload PDF Form'
=> 'Upload PDF Form',

   'Upload Scores'
=> 'Upload Scores',

   'Upload Slot List'
=> 'Upload Slot List',

   'Upload Users List'
=> 'Upload Users List',

   'Upload a CSV or a text file containing users.'
=> 'Upload a CSV or a text file containing users.',

   'Upload a File of Co-authors'
=> 'Upload a File of Co-authors',

   'Upload a File of Course Users'
=> 'Upload a File of Course Users',

   'Upload a File of Users'
=> 'Upload a File of Users',

   'Upload a PDF Form with filled Form Fields'
=> 'Upload a PDF Form with filled Form Fields',

   'Upload a class list'
=> 'Upload a class list',

   'Upload a courses or communities attributes file'
=> 'Upload a courses or communities attributes file',

   'Upload a file (e.g., a screenshot) relevant to your help request (128 KB max.)'
=> 'Upload a file (e.g., a screenshot) relevant to your help request (128 KB max.)',

   'Upload a file containing information about users'
=> 'Upload a file containing information about users',

   'Upload a new document'
=> 'Upload a new document',

   'Upload an attributes file containing specifications for one or more courses or communities in XML format.'
=> 'Upload an attributes file containing specifications for one or more courses or communities in XML format.',

   'Upload an attributes file containing specifications for one or more courses or groups in XML format.'
=> 'Upload an attributes file containing specifications for one or more courses or groups in XML format.',

   'Upload and Send'
=> 'Upload and Send',

   'Upload class list'
=> 'Upload class list',

   'Upload embedded images/multimedia files if HTML file'
=> 'Upload embedded images/multimedia files if HTML file',

   'Upload embedded images/multimedia/css/linked files if HTML file'
=> 'Upload embedded images/multimedia/css/linked files if HTML file',

   'Upload file of users'
=> 'Upload file of users',

   'Upload file to current directory'
=> 'Upload file to current directory',

   'Upload of new portfolio files and assignment of a non-zero Mb quota to new groups in the community will not be possible until some files have been deleted, and total usage is below community quota.'
=> 'Upload of new portfolio files and assignment of a non-zero Mb quota to new groups in the community will not be possible until some files have been deleted, and total usage is below community quota.',

   'Upload:'
=> 'Upload:',

   'Uploaded file contained no data'
=> 'Uploaded file contained no data',

   'Uploading file to [_1]'
=> 'Uploading file to [_1]',

   'Usage Statistics'
=> 'Usage Statistics',

   'Use 

 [_1]

to access the full message.'
=> 'Use 

 [_1]

to access the full message.',

   'Use "Save" to update the main window with your selections.'
=> 'Use "Save" to update the main window with your selections.',

   "Use 'Save' in the main window to save community categories"
=> "Use 'Save' in the main window to save community categories",

   "Use 'Save' in the main window to save course categories"
=> "Use 'Save' in the main window to save course categories",

   'Use [_1] to allow course to be cloned by anyone in the specified domain.'
=> 'Use [_1] to allow course to be cloned by anyone in the specified domain.',

   'Use [_1] to allow unrestricted cloning in all domains.'
=> 'Use [_1] to allow unrestricted cloning in all domains.',

   'Use [_1]Categorize course[_2] to assign a category to the course.'
=> 'Use [_1]Categorize course[_2] to assign a category to the course.',

   'Use [_1]Categorize course[_2] to change the "Exclude from course catalog" setting.'
=> 'Use [_1]Categorize course[_2] to change the "Exclude from course catalog" setting.',

   'Use [_1]Categorize course[_2] to change the category assigned to the course, as the one currently assigned is no longer used in the domain.'
=> 'Use [_1]Categorize course[_2] to change the category assigned to the course, as the one currently assigned is no longer used in the domain.',

   'Use of LON-CAPA requires Javascript to be enabled in your web browser.'
=> 'Use of LON-CAPA requires Javascript to be enabled in your web browser.',

   'Use of LON-CAPA requires java_script to be enabled in your web browser.'
=> 'Use of LON-CAPA requires java_script to be enabled in your web browser.',

   'Use random seed'
=> 'Use random seed',

   'Use slot based access controls'
=> 'Use slot based access controls',

   'Use slot based access controls (useslots)'
=> 'Use slot based access controls (useslots)',

   'Use style file'
=> 'Use style file',

   'Use template:'
=> 'Use template:',

   'Use the [_1]request form[_2] to submit a request for creation of a new course or community.'
=> 'Use the [_1]request form[_2] to submit a request for creation of a new course or community.',

   'Use the following link to enter the community:'
=> 'Use the following link to enter the community:',

   'Use the following link to enter the course:'
=> 'Use the following link to enter the course:',

   'Use the following links to your new roles to enter the community:'
=> 'Use the following links to your new roles to enter the community:',

   'Use the following links to your new roles to enter the course:'
=> 'Use the following links to your new roles to enter the course:',

   'Use the menu on the left to choose an enrollment management task.'
=> 'Use the menu on the left to choose an enrollment management task.',

   'Use:'
=> 'Use:',

   'User Can Request Creation of Courses/Communities in this Domain?'
=> 'User Can Request Creation of Courses/Communities in this Domain?',

   'User Changes'
=> 'User Changes',

   'User Counts'
=> 'User Counts',

   'User Data for'
=> 'User Data for',

   'User Environment for current log-in'
=> 'User Environment for current log-in',

   'User Information'
=> 'User Information',

   'User Information (unchanged)'
=> 'User Information (unchanged)',

   'User Information Changed'
=> 'User Information Changed',

   'User Management'
=> 'User Management',

   'User Management Logs'
=> 'User Management Logs',

   'User Management in community'
=> 'User Management in community',

   'User Management in course'
=> 'User Management in course',

   'User Management in domain'
=> 'User Management in domain',

   'User Notes, Face-to-Face, Critical Messages, Broadcast Messages, Archived Messages'
=> 'User Notes, Face-to-Face, Critical Messages, Broadcast Messages, Archived Messages',

   'User Notes, Records of Face-To-Face Discussions, Critical Messages, Broadcast Messages and Archived Messages in Course'
=> 'User Notes, Records of Face-To-Face Discussions, Critical Messages, Broadcast Messages and Archived Messages in Course',

   'User Report'
=> 'User Report',

   'User Search'
=> 'User Search',

   'User Search to add/modify roles'
=> 'User Search to add/modify roles',

   'User Search to enroll member'
=> 'User Search to enroll member',

   'User Search to enroll student'
=> 'User Search to enroll student',

   'User Self-Enrollment'
=> 'User Self-Enrollment',

   'User Sessions'
=> 'User Sessions',

   'User Specification (optional)'
=> 'User Specification (optional)',

   'User Status'
=> 'User Status',

   'User Status Summary'
=> 'User Status Summary',

   'User Status: [_1]'
=> 'User Status: [_1]',

   'User [_1] in domain [_2]'
=> 'User [_1] in domain [_2]',

   'User account creation'
=> 'User account creation',

   'User account creation is not available for the current default authentication type.'
=> 'User account creation is not available for the current default authentication type.',

   'User affiliation'
=> 'User affiliation',

   'User blogs, personal information pages and portfolios'
=> 'User blogs, personal information pages and portfolios',

   'User creates own account'
=> 'User creates own account',

   'User creation'
=> 'User creation',

   'User does not exist - username: [_1], domain: [_2].'
=> 'User does not exist - username: [_1], domain: [_2].',

   'User information'
=> 'User information',

   'User modification'
=> 'User modification',

   'User modify/custom role edit'
=> 'User modify/custom role edit',

   'User notes, records of face-to-face discussions, critical messages, broadcast messages and archived messages in Course.'
=> 'User notes, records of face-to-face discussions, critical messages, broadcast messages and archived messages in Course.',

   'User privileges for collaborative tools'
=> 'User privileges for collaborative tools',

   'User types:'
=> 'User types:',

   'Username -> E-mail conversion'
=> 'Username -> E-mail conversion',

   'Username -> E-mail conversion:'
=> 'Username -> E-mail conversion:',

   'Username -> e-mail conversion'
=> 'Username -> e-mail conversion',

   'Username : Domain'
=> 'Username : Domain',

   'Username and domain were blank'
=> 'Username and domain were blank',

   'Username and/or password could not be authenticated.'
=> 'Username and/or password could not be authenticated.',

   'Username rules at this institution do not allow the e-mail address you provided to be used as a username.'
=> 'Username rules at this institution do not allow the e-mail address you provided to be used as a username.',

   'Username, password and domain need to be specified.'
=> 'Username, password and domain need to be specified.',

   'Username:Domain'
=> 'Username:Domain',

   'Username:domain of community owner'
=> 'Username:domain of community owner',

   'Username:domain of course owner'
=> 'Username:domain of course owner',

   'Username:domain of each co-owner'
=> 'Username:domain of each co-owner',

   'Users allowed to clone course'
=> 'Users allowed to clone course',

   'Users allowed to self-enroll in this course'
=> 'Users allowed to self-enroll in this course',

   'Users can edit/delete own discussion posts'
=> 'Users can edit/delete own discussion posts',

   'Users can print problems as PDF forms and upload later for grading'
=> 'Users can print problems as PDF forms and upload later for grading',

   'Users in additional domain:'
=> 'Users in additional domain:',

   'Users in community with active [_1] roles'
=> 'Users in community with active [_1] roles',

   'Users in community with expired [_1] roles'
=> 'Users in community with expired [_1] roles',

   'Users in community with future [_1] roles'
=> 'Users in community with future [_1] roles',

   'Users in course with active [_1] roles'
=> 'Users in course with active [_1] roles',

   'Users in course with expired [_1] roles'
=> 'Users in course with expired [_1] roles',

   'Users in course with future [_1] roles'
=> 'Users in course with future [_1] roles',

   'Users in domain with active [_1] roles'
=> 'Users in domain with active [_1] roles',

   'Users in domain with expired [_1] roles'
=> 'Users in domain with expired [_1] roles',

   'Users in domain with future [_1] roles'
=> 'Users in domain with future [_1] roles',

   'Users in other domain:'
=> 'Users in other domain:',

   'Users in specific domain:'
=> 'Users in specific domain:',

   'Users with active Course Coordinator role in this course are permitted to clone and need not be included.'
=> 'Users with active Course Coordinator role in this course are permitted to clone and need not be included.',

   "Users with privileges to edit course contents may add a course information page to a course using the 'Course Info' button in DOCS"
=> "Users with privileges to edit course contents may add a course information page to a course using the 'Course Info' button in DOCS",

   'Users: '
=> 'Users: ',

   'Using tag [_1] on line [_2] as end tag to [_3]'
=> 'Using tag [_1] on line [_2] as end tag to [_3]',

   'Using the portfolio file list'
=> 'Using the portfolio file list',

   'Usually this correction is valid but you probably need to check the indicated resource one more time and implement neccessary corrections by yourself.'
=> 'Usually this correction is valid but you probably need to check the indicated resource one more time and implement neccessary corrections by yourself.',

   "Usually this means that your institution's information systems do not list you among the instructional personnel for this course."
=> "Usually this means that your institution's information systems do not list you among the instructional personnel for this course.",

   'Valid characters are'
=> 'Valid characters are',

   'Validate'
=> 'Validate',

   'Validation'
=> 'Validation',

   'Validation Attempted'
=> 'Validation Attempted',

   'Validation is attempted when the request is submitted.'
=> 'Validation is attempted when the request is submitted.',

   'Validation of pending requests is automatically repeated daily.'
=> 'Validation of pending requests is automatically repeated daily.',

   'Validation of the code you entered failed.'
=> 'Validation of the code you entered failed.',

   'Value(s)'
=> 'Value(s)',

   'Verify Receipt No.'
=> 'Verify Receipt No.',

   'Verify deletion'
=> 'Verify deletion',

   'Verifying Access Key to Unlock this Course'
=> 'Verifying Access Key to Unlock this Course',

   'Verifying Receipt No. [_1]'
=> 'Verifying Receipt No. [_1]',

   'Version Actions'
=> 'Version Actions',

   'Version changes'
=> 'Version changes',

   'Version discrepancy: resource [_1] included in both version [_2] and version [_3]. Using version [_2].'
=> 'Version discrepancy: resource [_1] included in both version [_2] and version [_3]. Using version [_2].',

   'Version used'
=> 'Version used',

   'Via Parameter Manager'
=> 'Via Parameter Manager',

   'Via Slot Manager'
=> 'Via Slot Manager',

   'View Answer'
=> 'View Answer',

   'View Change Logs'
=> 'View Change Logs',

   'View Classlist'
=> 'View Classlist',

   'View Folder'
=> 'View Folder',

   'View Log-in History'
=> 'View Log-in History',

   'View Problem Text'
=> 'View Problem Text',

   'View Status'
=> 'View Status',

   'View Submissions for a Student or a Group of Students'
=> 'View Submissions for a Student or a Group of Students',

   "View a user's recent activity"
=> "View a user's recent activity",

   'View all group discussion boards'
=> 'View all group discussion boards',

   'View boards'
=> 'View boards',

   'View calculated grades (Spreadsheet)'
=> 'View calculated grades (Spreadsheet)',

   'View change log.'
=> 'View change log.',

   'View class lists'
=> 'View class lists',

   'View course groups'
=> 'View course groups',

   'View course roster'
=> 'View course roster',

   'View creation log'
=> 'View creation log',

   'View current problem status and grading information'
=> 'View current problem status and grading information',

   'View grades'
=> 'View grades',

   'View more activity by this student'
=> 'View more activity by this student',

   'View of the problem'
=> 'View of the problem',

   'View or modify a course'
=> 'View or modify a course',

   'View or modify a course or community'
=> 'View or modify a course or community',

   'View or modify community settings which only a [_1] may modify.'
=> 'View or modify community settings which only a [_1] may modify.',

   'View or modify course settings which only a [_1] may modify.'
=> 'View or modify course settings which only a [_1] may modify.',

   'View page'
=> 'View page',

   'View parameter and course blog posting/user notification change log.'
=> 'View parameter and course blog posting/user notification change log.',

   'View recent activity'
=> 'View recent activity',

   'View recent activity by this student'
=> 'View recent activity by this student',

   'View recent activity of this student'
=> 'View recent activity of this student',

   'View request history'
=> 'View request history',

   'View slot reservation history of this student'
=> 'View slot reservation history of this student',

   'View student activity'
=> 'View student activity',

   'View students and change type'
=> 'View students and change type',

   'View supplemental course documents'
=> 'View supplemental course documents',

   'View survey'
=> 'View survey',

   "View this user's personal information page"
=> "View this user's personal information page",

   'View/Change Status'
=> 'View/Change Status',

   'View/Grade/Regrade Submissions for a Student or a Group of Students'
=> 'View/Grade/Regrade Submissions for a Student or a Group of Students',

   'View/Modify Community Settings'
=> 'View/Modify Community Settings',

   'View/Modify Course Settings'
=> 'View/Modify Course Settings',

   'View/Modify Course/Community Settings'
=> 'View/Modify Course/Community Settings',

   'View/Modify Courses'
=> 'View/Modify Courses',

   'View/Modify Domain Settings'
=> 'View/Modify Domain Settings',

   'View/Modify catalog settings for community'
=> 'View/Modify catalog settings for community',

   'View/Modify catalog settings for course'
=> 'View/Modify catalog settings for course',

   'View/Modify community owner'
=> 'View/Modify community owner',

   'View/Modify course owner'
=> 'View/Modify course owner',

   'View/Modify course owner, institutional code, and default authentication'
=> 'View/Modify course owner, institutional code, and default authentication',

   'View/Modify existing role:'
=> 'View/Modify existing role:',

   'View/Modify quota for group portfolio files'
=> 'View/Modify quota for group portfolio files',

   'View/Modify settings for: [_1]'
=> 'View/Modify settings for: [_1]',

   'View/Modify/Cancel pending requests'
=> 'View/Modify/Cancel pending requests',

   'Viewable files - [_1]'
=> 'Viewable files - [_1]',

   'Viewable group portfolio files'
=> 'Viewable group portfolio files',

   'Viewable portfolio files'
=> 'Viewable portfolio files',

   'Viewable portfolio files for [_1]'
=> 'Viewable portfolio files for [_1]',

   'Viewable portfolio files.'
=> 'Viewable portfolio files.',

   'Visibilities'
=> 'Visibilities',

   'Visibility in Course/Community Catalog'
=> 'Visibility in Course/Community Catalog',

   'Visible input'
=> 'Visible input',

   'Visit [_1] to log-in and access the course'
=> 'Visit [_1] to log-in and access the course',

   'Visited Link Color'
=> 'Visited Link Color',

   'Visited link'
=> 'Visited link',

   'WARNING: Cannot connect to database!'
=> 'WARNING: Cannot connect to database!',

   'WARNING: Cutting a resource makes associated grades and scores inaccessible!'
=> 'WARNING: Cutting a resource makes associated grades and scores inaccessible!',

   'WARNING: Removing a resource makes associated grades and scores inaccessible!'
=> 'WARNING: Removing a resource makes associated grades and scores inaccessible!',

   'WYSIWYG Editor'
=> 'WYSIWYG Editor',

   'Waiting for results'
=> 'Waiting for results',

   'Waiting up to [_1] seconds for results'
=> 'Waiting up to [_1] seconds for results',

   'Warning: It can take up to 1 hour for rights changes to fully propagate.'
=> 'Warning: It can take up to 1 hour for rights changes to fully propagate.',

   'Warning: Report not submitted'
=> 'Warning: Report not submitted',

   'Warning: a published library of this name exists.'
=> 'Warning: a published library of this name exists.',

   'Warning: a published problem of this name exists.'
=> 'Warning: a published problem of this name exists.',

   'Warning: data retrieval for multiple communities can take considerable time, as this operation is not currently optimized.'
=> 'Warning: data retrieval for multiple communities can take considerable time, as this operation is not currently optimized.',

   'Warning: data retrieval for multiple courses can take considerable time, as this operation is not currently optimized.'
=> 'Warning: data retrieval for multiple courses can take considerable time, as this operation is not currently optimized.',

   'Warning: failed to release lock for counter'
=> 'Warning: failed to release lock for counter',

   'Warning: failed to release lock for folder: [_1].'
=> 'Warning: failed to release lock for folder: [_1].',

   'Warnings and Errors'
=> 'Warnings and Errors',

   'Weight'
=> 'Weight',

   'What are critical messages?'
=> 'What are critical messages?',

   'What are forwarding and notification addresses?'
=> 'What are forwarding and notification addresses?',

   "What's New Page"
=> "What's New Page",

   "What's New?"
=> "What's New?",

   'When'
=> 'When',

   'When a deleted group is re-enabled the following occurs:'
=> 'When a deleted group is re-enabled the following occurs:',

   'When a group is deleted the following occurs:'
=> 'When a group is deleted the following occurs:',

   'When adding a co-author'
=> 'When adding a co-author',

   'When adding a user to a course'
=> 'When adding a user to a course',

   'When requesting a course'
=> 'When requesting a course',

   'When searching by last,first you must include at least one character in the first name.'
=> 'When searching by last,first you must include at least one character in the first name.',

   'When using searching by last,first you must include a comma as separator between last name and first name.'
=> 'When using searching by last,first you must include a comma as separator between last name and first name.',

   'Whether individual posts can be marked as read/unread'
=> 'Whether individual posts can be marked as read/unread',

   'Which posts are displayed when you display a discussion board or resource, and'
=> 'Which posts are displayed when you display a discussion board or resource, and',

   'Which posts are displayed when you display this discussion board or resource, and'
=> 'Which posts are displayed when you display this discussion board or resource, and',

   'While data is processed, periodically reload this page for more recent activity'
=> 'While data is processed, periodically reload this page for more recent activity',

   'Who made the change'
=> 'Who made the change',

   'Whole Points'
=> 'Whole Points',

   'Will Have Future Access'
=> 'Will Have Future Access',

   'Will have future access'
=> 'Will have future access',

   'Will remove access times for'
=> 'Will remove access times for',

   'Window during which changes occurred:'
=> 'Window during which changes occurred:',

   'Window during which course/community was created:'
=> 'Window during which course/community was created:',

   'Window during which course/community was requested:'
=> 'Window during which course/community was requested:',

   'With validation'
=> 'With validation',

   'Course creation processed as: (choose Dom. Coord.)'
=> 'Course creation processed as: (choose Dom. Coord.)',

   'Yes, and show correct answer if they exceed the maximum number of tries.'
=> 'Yes, and show correct answer if they exceed the maximum number of tries.',

   'Yes, automatic creation'
=> 'Yes, automatic creation',

   'Yes, need approval'
=> 'Yes, need approval',

   'Yes, processed automatically'
=> 'Yes, processed automatically',

   'Yes, up to [quant,_1,request]/user'
=> 'Yes, up to [quant,_1,request]/user',

   'Yes, up to limit of [quant,_1,request] per user.'
=> 'Yes, up to limit of [quant,_1,request] per user.',

   'Yes, with validation'
=> 'Yes, with validation',

   'You already have an active student role (section: "[_1]") in this course.'
=> 'You already have an active student role (section: "[_1]") in this course.',

   'You are able to both assign a course category and choose to exclude this course from the catalog.'
=> 'You are able to both assign a course category and choose to exclude this course from the catalog.',

   'You are able to choose to exclude this course from the catalog, but only a Domain Coordinator may assign a course category.'
=> 'You are able to choose to exclude this course from the catalog, but only a Domain Coordinator may assign a course category.',

   'You are accessing an invalid course'
=> 'You are accessing an invalid course',

   'You are already logged in'
=> 'You are already logged in',

   'You are already logged in!'
=> 'You are already logged in!',

   'You are currently <b>not</b> listed in the student-viewable roster.'
=> 'You are currently <b>not</b> listed in the student-viewable roster.',

   'You are currently a co-owner:'
=> 'You are currently a co-owner:',

   'You are currently listed in the student-viewable roster.'
=> 'You are currently listed in the student-viewable roster.',

   'You are in a section of course for which automatic enrollment in the corresponding LON-CAPA course is not active.'
=> 'You are in a section of course for which automatic enrollment in the corresponding LON-CAPA course is not active.',

   'You are not allowed to upload bubblesheet data to the requested course.'
=> 'You are not allowed to upload bubblesheet data to the requested course.',

   'You are not authorized to create new institutional users in this domain.'
=> 'You are not authorized to create new institutional users in this domain.',

   'You are not authorized to create new non-institutional users in this domain.'
=> 'You are not authorized to create new non-institutional users in this domain.',

   "You are not authorized to create new users in your current role's domain - [_1]."
=> "You are not authorized to create new users in your current role's domain - [_1].",

   "You are not authorized to define new users in the new course's domain - [_1]."
=> "You are not authorized to define new users in the new course's domain - [_1].",

   'You are not authorized to make bulk changes to user roles'
=> 'You are not authorized to make bulk changes to user roles',

   'You are not currently a member of any active groups in this course.'
=> 'You are not currently a member of any active groups in this course.',

   'You are not currently signed up to work at this time and/or place.'
=> 'You are not currently signed up to work at this time and/or place.',

   'You are not permitted to create a LON-CAPA account.'
=> 'You are not permitted to create a LON-CAPA account.',

   'You are not permitted to enroll yourself in this course.'
=> 'You are not permitted to enroll yourself in this course.',

   'You are not permitted to request creation of a community this domain.'
=> 'You are not permitted to request creation of a community this domain.',

   'You are not permitted to request creation of an official course in this domain.'
=> 'You are not permitted to request creation of an official course in this domain.',

   'You are not permitted to request creation of an unofficial course in this domain.'
=> 'You are not permitted to request creation of an unofficial course in this domain.',

   'You are not permitted to request creation of communities'
=> 'You are not permitted to request creation of communities',

   'You are not permitted to request creation of official courses.'
=> 'You are not permitted to request creation of official courses.',

   'You are not permitted to request creation of unofficial courses.'
=> 'You are not permitted to request creation of unofficial courses.',

   'You are not permitted to set a user preference for automatic name updates for your LON-CAPA account.'
=> 'You are not permitted to set a user preference for automatic name updates for your LON-CAPA account.',

   'You are partially correct.'
=> 'You are partially correct.',

   'You are running LaTeX in [_1]batch mode[_2].'
=> 'You are running LaTeX in [_1]batch mode[_2].',

   'You attempted to display a message that is currently blocked because you are enrolled in one or more courses for which there is an ongoing online exam.'
=> 'You attempted to display a message that is currently blocked because you are enrolled in one or more courses for which there is an ongoing online exam.',

   'You can [_1]close this window[_2] now.'
=> 'You can [_1]close this window[_2] now.',

   'You can choose to transfer data from the added fields to the "Notes" field if you are planning to change the course association.'
=> 'You can choose to transfer data from the added fields to the "Notes" field if you are planning to change the course association.',

   'You can only use this screen to select courses and communities in the current domain.'
=> 'You can only use this screen to select courses and communities in the current domain.',

   'You can only use this screen to select courses in the current domain.'
=> 'You can only use this screen to select courses in the current domain.',

   'You can reply to this e-mail'
=> 'You can reply to this e-mail',

   'You can search for courses and communities which permit self-enrollment, if you would like to enroll in one.'
=> 'You can search for courses and communities which permit self-enrollment, if you would like to enroll in one.',

   'You can use communication blocking to prevent students enrolled in this course from displaying LON-CAPA messages sent by other students during an online exam. As blocking of communication could potentially interrupt legitimate communication between students who are also both enrolled in a different LON-CAPA course, please be careful that you select the correct start and end times for your scheduled exam when setting or modifying these parameters.'
=> 'You can use communication blocking to prevent students enrolled in this course from displaying LON-CAPA messages sent by other students during an online exam. As blocking of communication could potentially interrupt legitimate communication between students who are also both enrolled in a different LON-CAPA course, please be careful that you select the correct start and end times for your scheduled exam when setting or modifying these parameters.',

   'You did not fill in enough information for the search to be started. You need to fill in relevant fields on the search page in order for a query to be processed.'
=> 'You did not fill in enough information for the search to be started. You need to fill in relevant fields on the search page in order for a query to be processed.',

   'You do not currently have rights to view this group.'
=> 'You do not currently have rights to view this group.',

   'You do not have a domain coordinator role in domain: [_1], so you cannot choose a Construction space for which you can assume a co-author role.'
=> 'You do not have a domain coordinator role in domain: [_1], so you cannot choose a Construction space for which you can assume a co-author role.',

   'You do not have a domain coordinator role, so you cannot choose a Construction space for which you can assume a co-author role.'
=> 'You do not have a domain coordinator role, so you cannot choose a Construction space for which you can assume a co-author role.',

   'You do not have group administration privileges in this course.'
=> 'You do not have group administration privileges in this course.',

   'You do not have permission to modify dates or sections for users'
=> 'You do not have permission to modify dates or sections for users',

   'You do not have privileges to assign co-author roles.'
=> 'You do not have privileges to assign co-author roles.',

   'You do not have privileges to modify Portfolio, Blog or Personal Information Page settings for this user.'
=> 'You do not have privileges to modify Portfolio, Blog or Personal Information Page settings for this user.',

   'You do not have privileges to modify the authentication configuration for this user.'
=> 'You do not have privileges to modify the authentication configuration for this user.',

   'You do not have privileges to modify the portfolio quota for this user.'
=> 'You do not have privileges to modify the portfolio quota for this user.',

   'You do not have privileges to request creation of courses or communities.'
=> 'You do not have privileges to request creation of courses or communities.',

   'You do not have privileges to view all versions of posts.'
=> 'You do not have privileges to view all versions of posts.',

   'You do not have privileges to view the membership roster in this group.'
=> 'You do not have privileges to view the membership roster in this group.',

   'You do not have rights to request creation of courses in this domain; please choose a different domain.'
=> 'You do not have rights to request creation of courses in this domain; please choose a different domain.',

   'You do not have rights to view community request information.'
=> 'You do not have rights to view community request information.',

   'You do not have rights to view course or community request information.'
=> 'You do not have rights to view course or community request information.',

   'You do not have rights to view course request information.'
=> 'You do not have rights to view course request information.',

   'You do not have sufficient privileges to [_1]'
=> 'You do not have sufficient privileges to [_1]',

   "You do not have the authority to change these fields given the user's current set of active/future [_1] roles:"
=> "You do not have the authority to change these fields given the user's current set of active/future [_1] roles:",

   "You do not have the authority to change this field given the user's current set of active/future [_1] roles:"
=> "You do not have the authority to change this field given the user's current set of active/future [_1] roles:",

   'You do not have the authority to modify this users authentification information'
=> 'You do not have the authority to modify this users authentification information',

   'You do not have the privileges required to access the shared files space for this group.'
=> 'You do not have the privileges required to access the shared files space for this group.',

   'You entered an invalid section choice:'
=> 'You entered an invalid section choice:',

   'You had selected'
=> 'You had selected',

   'You have a student role (section: "[_1]") in this course which will become active [_2].'
=> 'You have a student role (section: "[_1]") in this course which will become active [_2].',

   'You have been enrolled in the LON-CAPA system at your institution, because you are a registered student in a class which is using the LON-CAPA couse management and online homework system.'
=> 'You have been enrolled in the LON-CAPA system at your institution, because you are a registered student in a class which is using the LON-CAPA couse management and online homework system.',

   'You have been successfully logged out.'
=> 'You have been successfully logged out.',

   'You have indicated that the group portfolio should be enabled, but you have set the respository quota to 0 Mb.\nThis will prevent any upload of files.\nPlease set a value or disable the repository feature.'
=> 'You have indicated that the group portfolio should be enabled, but you have set the respository quota to 0 Mb.\nThis will prevent any upload of files.\nPlease set a value or disable the repository feature.',

   'You have modified your course recently, [_1] may fix this access problem.'
=> 'You have modified your course recently, [_1] may fix this access problem.',

   'You have new messages'
=> 'You have new messages',

   'You have no matching community requests awaiting approval by a Domain Coordinator or held in a queue pending administrative action at your institution.'
=> 'You have no matching community requests awaiting approval by a Domain Coordinator or held in a queue pending administrative action at your institution.',

   'You have no matching course or community requests awaiting approval by a Domain Coordinator or held in a queue pending administrative action at your institution.'
=> 'You have no matching course or community requests awaiting approval by a Domain Coordinator or held in a queue pending administrative action at your institution.',

   'You have no matching course requests awaiting approval by a Domain Coordinator or held in a queue pending administrative action at your institution.'
=> 'You have no matching course requests awaiting approval by a Domain Coordinator or held in a queue pending administrative action at your institution.',

   'You have not replied to any messages in this folder.'
=> 'You have not replied to any messages in this folder.',

   'You have previously set [_1] conditional access controls.'
=> 'You have previously set [_1] conditional access controls.',

   'You have reached the end of the sequence of materials.'
=> 'You have reached the end of the sequence of materials.',

   'You have requested deletion of the group [_1].'
=> 'You have requested deletion of the group [_1].',

   'You have requested enabling the previously deleted group [_1].'
=> 'You have requested enabling the previously deleted group [_1].',

   "You have requested to create file in directory [_1] which doesn't exist. The requested directory path has been removed from the requested file name."
=> "You have requested to create file in directory [_1] which doesn't exist. The requested directory path has been removed from the requested file name.",

   'You have rights to request the creation of courses and/or communities in the following domain(s):'
=> 'You have rights to request the creation of courses and/or communities in the following domain(s):',

   'You have to confirm that you have received this message before you can view other pages. After confirmation, this message will be moved to your regular inbox'
=> 'You have to confirm that you have received this message before you can view other pages. After confirmation, this message will be moved to your regular inbox',

   'You likely need to explicitly allow access to all possible dependencies using the [_1]-tag.'
=> 'You likely need to explicitly allow access to all possible dependencies using the [_1]-tag.',

   'You may also add users later, once the community has been created, by using the "Manage community users" link, accessible from the "Main Menu".'
=> 'You may also add users later, once the community has been created, by using the "Manage community users" link, accessible from the "Main Menu".',

   'You may also add users later, once the course has been created, by using the "Manage course users" link, accessible from the "Main Menu".'
=> 'You may also add users later, once the course has been created, by using the "Manage course users" link, accessible from the "Main Menu".',

   'You may assign a course category, but only a Domain Coordinator may choose to exclude this course from the catalog.'
=> 'You may assign a course category, but only a Domain Coordinator may choose to exclude this course from the catalog.',

   'You may need to reload the previous page to obtain a new token.'
=> 'You may need to reload the previous page to obtain a new token.',

   "You may need to use the 'modify existing, past or future members' page if you need to re-enable or activate access for previous or future members."
=> "You may need to use the 'modify existing, past or future members' page if you need to re-enable or activate access for previous or future members.",

   'You may want to broaden your search to a search of the institutional directory for the domain.'
=> 'You may want to broaden your search to a search of the institutional directory for the domain.',

   'You may want to broaden your search to the selected LON-CAPA domain.'
=> 'You may want to broaden your search to the selected LON-CAPA domain.',

   'You may want to review the request details and submit the request again.'
=> 'You may want to review the request details and submit the request again.',

   'You may want to search in the LON-CAPA domain instead of the institutional directory.'
=> 'You may want to search in the LON-CAPA domain instead of the institutional directory.',

   'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3] domain.'
=> 'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3] domain.',

   'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3].'
=> 'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3].',

   'You may wish to send an e-mail to the server administrator: [_1] for [_2].'
=> 'You may wish to send an e-mail to the server administrator: [_1] for [_2].',

   'You must [_1]log-in[_2] to LON-CAPA with an existing account to be able to enroll in this course, as account creation at this institution ([_3]) is not permitted when self-enrolling.'
=> 'You must [_1]log-in[_2] to LON-CAPA with an existing account to be able to enroll in this course, as account creation at this institution ([_3]) is not permitted when self-enrolling.',

   'You must be able to access e-mail sent to that address.'
=> 'You must be able to access e-mail sent to that address.',

   'You must choose a domain when using a domain search.'
=> 'You must choose a domain when using a domain search.',

   'You must choose a domain when using an institutional directory search.'
=> 'You must choose a domain when using an institutional directory search.',

   'You must choose a specific course type when making a new course request.\n\"All types\" is not allowed.'
=> 'You must choose a specific course type when making a new course request.\n\"All types\" is not allowed.',

   'You must delete the contents of the directory first.'
=> 'You must delete the contents of the directory first.',

   'You must enter a password'
=> 'You must enter a password',

   'You must enter a search term.'
=> 'You must enter a search term.',

   'You must include a description'
=> 'You must include a description',

   'You must include a subject'
=> 'You must include a subject',

   'You must include some text to search for.'
=> 'You must include some text to search for.',

   'You must provide a (brief) community description.'
=> 'You must provide a (brief) community description.',

   'You must provide a (brief) course description.'
=> 'You must provide a (brief) course description.',

   'You must select a course or community in the current domain'
=> 'You must select a course or community in the current domain',

   'You must select at least one functionality type to display.'
=> 'You must select at least one functionality type to display.',

   "You must select at least one user by checking a user's 'Select' checkbox"
=> "You must select at least one user by checking a user's 'Select' checkbox",

   'You must specify a valid domain when searching in a domain or institutional directory.'
=> 'You must specify a valid domain when searching in a domain or institutional directory.',

   'You must specify a valid username. Only the following are allowed: letters numbers - . @'
=> 'You must specify a valid username. Only the following are allowed: letters numbers - . @',

   'You need to be logged into LON-CAPA to self-enroll in a course.'
=> 'You need to be logged into LON-CAPA to self-enroll in a course.',

   'You need to change one or more LON-CAPA section names - names may only contain letters or numbers.'
=> 'You need to change one or more LON-CAPA section names - names may only contain letters or numbers.',

   'You need to change one or more LON-CAPA section names - none is a reserved word in the system, and may not be used.'
=> 'You need to change one or more LON-CAPA section names - none is a reserved word in the system, and may not be used.',

   'You need to choose another user role or enter a specific course or community for this function.'
=> 'You need to choose another user role or enter a specific course or community for this function.',

   'You need to re-initialize the community.'
=> 'You need to re-initialize the community.',

   'You need to reinitialize the community.'
=> 'You need to reinitialize the community.',

   'You need to select an action to take for the user(s) you have selected'
=> 'You need to select an action to take for the user(s) you have selected',

   'You need to specify a clicker ID for the correct answer'
=> 'You need to specify a clicker ID for the correct answer',

   'You need to specify at least one grading field'
=> 'You need to specify at least one grading field',

   'You need to specify the username or the student/employee ID'
=> 'You need to specify the username or the student/employee ID',

   'You received a critical message from [_1] in LON-CAPA.'
=> 'You received a critical message from [_1] in LON-CAPA.',

   'You received a message from [_1] in LON-CAPA.'
=> 'You received a message from [_1] in LON-CAPA.',

   'You registered for the course recently and there is a time lag between the time you register, and the time this information becomes available for the update of LON-CAPA course rosters.'
=> 'You registered for the course recently and there is a time lag between the time you register, and the time this information becomes available for the update of LON-CAPA course rosters.',

   'You should remedy this if you plan to allow self-enrollment, otherwise students will have difficulty finding your course.'
=> 'You should remedy this if you plan to allow self-enrollment, otherwise students will have difficulty finding your course.',

   'You should request creation of a LON-CAPA account for a log-in ID of "[_1]" at your institution instead.'
=> 'You should request creation of a LON-CAPA account for a log-in ID of "[_1]" at your institution instead.',

   'You will be able to rename or delete existing [_1] after a grade has been assigned.'
=> 'You will be able to rename or delete existing [_1] after a grade has been assigned.',

   'You will be able to self enroll in this course once the account has been created.'
=> 'You will be able to self enroll in this course once the account has been created.',

   'You will be able to self-enroll in the course you selected ([_1]) after you have successfully logged in.'
=> 'You will be able to self-enroll in the course you selected ([_1]) after you have successfully logged in.',

   'You will not be able to proceed to the next stage of account creation'
=> 'You will not be able to proceed to the next stage of account creation',

   'Your CSV file'
=> 'Your CSV file',

   'Your CSV file.'
=> 'Your CSV file.',

   'Your LON-CAPA account'
=> 'Your LON-CAPA account',

   'Your LON-CAPA account must be of a type for which LON-CAPA can reset a password.'
=> 'Your LON-CAPA account must be of a type for which LON-CAPA can reset a password.',

   'Your anonymous submission has been recorded, and credit awarded.'
=> 'Your anonymous submission has been recorded, and credit awarded.',

   'Your anonymous submission has been recorded.'
=> 'Your anonymous submission has been recorded.',

   'Your co-ownership status'
=> 'Your co-ownership status',

   'Your community limit is [_1].'
=> 'Your community limit is [_1].',

   'Your community request has been cancelled.'
=> 'Your community request has been cancelled.',

   'Your community request has been processed and the community has been created.'
=> 'Your community request has been processed and the community has been created.',

   'Your community request has been recorded.'
=> 'Your community request has been recorded.',

   'Your community request has been updated'
=> 'Your community request has been updated',

   'Your community request was rejected.'
=> 'Your community request was rejected.',

   'Your course is now set up. Please select the Save button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen (Course Configuration).'
=> 'Your course is now set up. Please select the Save button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen (Course Configuration).',

   'Your course limit is [_1].'
=> 'Your course limit is [_1].',

   'Your course request has been cancelled.'
=> 'Your course request has been cancelled.',

   'Your course request has been processed and the course has been created.'
=> 'Your course request has been processed and the course has been created.',

   'Your course request has been recorded.'
=> 'Your course request has been recorded.',

   'Your course request has been updated'
=> 'Your course request has been updated',

   'Your course request was rejected.'
=> 'Your course request was rejected.',

   'Your course/community currently appears in the Course/Community Catalog for this domain.'
=> 'Your course/community currently appears in the Course/Community Catalog for this domain.',

   'Your course/community does not currently appear in the Course/Community Catalog for this domain.'
=> 'Your course/community does not currently appear in the Course/Community Catalog for this domain.',

   'Your current LON-CAPA domain is [_1].'
=> 'Your current LON-CAPA domain is [_1].',

   'Your e-mail address'
=> 'Your e-mail address',

   "Your e-mail address uses the same internet domain as your institution's LON-CAPA service."
=> "Your e-mail address uses the same internet domain as your institution's LON-CAPA service.",

   'Your earlier request is in a queue awaiting action by a Course Coordinator.'
=> 'Your earlier request is in a queue awaiting action by a Course Coordinator.',

   'Your earlier request was submitted: [_1] and remains in a queue awaiting action by a Course Coordinator.'
=> 'Your earlier request was submitted: [_1] and remains in a queue awaiting action by a Course Coordinator.',

   'Your file - [_1] - was uploaded successfully.'
=> 'Your file - [_1] - was uploaded successfully.',

   'Your group selections - '
=> 'Your group selections - ',

   'Your import is complete.'
=> 'Your import is complete.',

   'Your information, together with internal debugging information, will be e-mailed to the system and server administrators.'
=> 'Your information, together with internal debugging information, will be e-mailed to the system and server administrators.',

   'Your limit is [_1].'
=> 'Your limit is [_1].',

   'Your new password will be sent to the LON-CAPA server in an encrypted form.'
=> 'Your new password will be sent to the LON-CAPA server in an encrypted form.',

   'Your new role is available immediately, and will provide access to the course until [_1].'
=> 'Your new role is available immediately, and will provide access to the course until [_1].',

   'Your password, which must contain at least seven characters, will be sent to the LON-CAPA server in an encrypted form.'
=> 'Your password, which must contain at least seven characters, will be sent to the LON-CAPA server in an encrypted form.',

   'Your portfolio files will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Your portfolio files will be inaccessible between [_1] and [_2] because communication is being blocked.',

   'Your receipt no. is [_1]'
=> 'Your receipt no. is [_1]',

   'Your registration status could not be verified.'
=> 'Your registration status could not be verified.',

   'Your registration status could not determined, because a problem occurred retrieving data.'
=> 'Your registration status could not determined, because a problem occurred retrieving data.',

   'Your request for enrollment has been approved.'
=> 'Your request for enrollment has been approved.',

   'Your request for enrollment has not been approved.'
=> 'Your request for enrollment has not been approved.',

   'Your request for enrollment in the following course: [_1], requested on [_2], has been reviewed by a Course Coordinator.'
=> 'Your request for enrollment in the following course: [_1], requested on [_2], has been reviewed by a Course Coordinator.',

   'Your request for self-enrollment has been recorded.'
=> 'Your request for self-enrollment has been recorded.',

   'Your request has been placed in a queue pending administrative action.'
=> 'Your request has been placed in a queue pending administrative action.',

   'Your request has not been processed because you have reached the limit for the number of communities.'
=> 'Your request has not been processed because you have reached the limit for the number of communities.',

   'Your request has not been processed because you have reached the limit for the number of courses of this type.'
=> 'Your request has not been processed because you have reached the limit for the number of courses of this type.',

   'Your request status is: [_1].'
=> 'Your request status is: [_1].',

   'Your reservation status for any such assignments is listed below:'
=> 'Your reservation status for any such assignments is listed below:',

   'Your roster setting'
=> 'Your roster setting',

   'Your search term must contain more than just spaces.'
=> 'Your search term must contain more than just spaces.',

   'Your submission has been recorded, and credit awarded.'
=> 'Your submission has been recorded, and credit awarded.',

   'Your support request contained the following information'
=> 'Your support request contained the following information',

   'Your text file'
=> 'Your text file',

   'Zip File'
=> 'Zip File',

   'Zoom in'
=> 'Zoom in',

   'Zoom out'
=> 'Zoom out',

   '[_1] Display Creation History'
=> '[_1] Display Creation History',

   '[_1] Display Request Queue'
=> '[_1] Display Request Queue',

   '[_1] Error: [_2] The file you attempted to upload, [_3] contained no information. Please check that you entered the correct filename.'
=> '[_1] Error: [_2] The file you attempted to upload, [_3] contained no information. Please check that you entered the correct filename.',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5 [_5]'
=> '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5 [_5]',

   '[_1] Limit by time'
=> '[_1] Limit by time',

   '[_1] Mb'
=> '[_1] Mb',

   '[_1] Requests Updated'
=> '[_1] Requests Updated',

   '[_1] [_2] [_3] '
=> '[_1] [_2] [_3] ',

   '[_1] [_2] [_3] [_4] [_5]m [_6]s '
=> '[_1] [_2] [_3] [_4] [_5]m [_6]s ',

   '[_1] [_2] was created.<br />'
=> '[_1] [_2] was created.<br />',

   '[_1] discussion boards - [_2]'
=> '[_1] discussion boards - [_2]',

   '[_1] for [_2] versions.'
=> '[_1] for [_2] versions.',

   '[_1] for default hiding'
=> '[_1] for default hiding',

   "[_1] for link to each a listing of each student's files."
=> "[_1] for link to each a listing of each student's files.",

   '[_1] for visible separation.'
=> '[_1] for visible separation.',

   '[_1] if allowed, anything else if not'
=> '[_1] if allowed, anything else if not',

   '[_1] include external resources'
=> '[_1] include external resources',

   '[_1] is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '[_1] is not an acceptable number of tries. Tries must be a positive number with no decimal point.',

   '[_1] is not an acceptable weight. Weight must be a positive number.'
=> '[_1] is not an acceptable weight. Weight must be a positive number.',

   '[_1] may not be used as the name for a section, as it is a reserved word.'
=> '[_1] may not be used as the name for a section, as it is a reserved word.',

   '[_1] may not be used as the name for a section, as it is the name of a course group.'
=> '[_1] may not be used as the name for a section, as it is the name of a course group.',

   '[_1] membership status - [_2]'
=> '[_1] membership status - [_2]',

   '[_1] now set to: [_2]'
=> '[_1] now set to: [_2]',

   '[_1] of [quant,_2,try,tries] used'
=> '[_1] of [quant,_2,try,tries] used',

   '[_1] parts'
=> '[_1] parts',

   '[_1] portfolio files - [_2]'
=> '[_1] portfolio files - [_2]',

   '[_1] selected.'
=> '[_1] selected.',

   '[_1] set to [_2]'
=> '[_1] set to [_2]',

   '[_1] still set to: [_2]'
=> '[_1] still set to: [_2]',

   '[_1] to [_2]'
=> '[_1] to [_2]',

   '[_1] to require students to opt-in to listing in the roster (on the roster page).'
=> '[_1] to require students to opt-in to listing in the roster (on the roster page).',

   '[_1] to send a message only to student, [_2] to send message to student and add record to user information page for instructors. Leave blank to disable.'
=> '[_1] to send a message only to student, [_2] to send message to student and add record to user information page for instructors. Leave blank to disable.',

   '[_1] to suppress, anything else to not suppress'
=> '[_1] to suppress, anything else to not suppress',

   '[_1] was excluded because new users need to be from the course domain'
=> '[_1] was excluded because new users need to be from the course domain',

   '[_1] was excluded because the domain is invalid'
=> '[_1] was excluded because the domain is invalid',

   '[_1] was excluded because the username or domain is invalid.'
=> '[_1] was excluded because the username or domain is invalid.',

   '[_1] was excluded because the username violated format rules for the domain'
=> '[_1] was excluded because the username violated format rules for the domain',

   '[_1] was excluded because you may not request new users in the domain'
=> '[_1] was excluded because you may not request new users in the domain',

   '[_1] was handed back in response to problem: [_2]'
=> '[_1] was handed back in response to problem: [_2]',

   '[_1] was submitted in response to problem: [_2]'
=> '[_1] was submitted in response to problem: [_2]',

   '[_1](name).(number).(extension)[_2] not allowed.'
=> '[_1](name).(number).(extension)[_2] not allowed.',

   "[_1], [_2] (Convert to Images), [_3] (TeX to HTML), or blank for student's preference"
=> "[_1], [_2] (Convert to Images), [_3] (TeX to HTML), or blank for student's preference",

   '[_1], [_2], or [_3]'
=> '[_1], [_2], or [_3]',

   '[_1]-based conditional access: '
=> '[_1]-based conditional access: ',

   '[_1]/[_2]: [quant,_3,minute,minutes,] [quant,_4,second ,seconds ,]remaining ([quant,_5,second] for last five students)'
=> '[_1]/[_2]: [quant,_3,minute,minutes,] [quant,_4,second ,seconds ,]remaining ([quant,_5,second] for last five students)',

   '[_1]/[_2]: [quant,_3,minute,minutes,] [quant,_4,second ,seconds ,]remaining ([quant,_5,second] for last student)'
=> '[_1]/[_2]: [quant,_3,minute,minutes,] [quant,_4,second ,seconds ,]remaining ([quant,_5,second] for last student)',

   '[_1]: "[_2]" set to "[_3]".'
=> '[_1]: "[_2]" set to "[_3]".',

   '[_1]: Unable to add co-author. No password specified.'
=> '[_1]: Unable to add co-author. No password specified.',

   '[_1]: Unable to add role: [_2]'
=> '[_1]: Unable to add role: [_2]',

   '[_1]: Unable to add user. No password specified.'
=> '[_1]: Unable to add user. No password specified.',

   '[_1]: Unable to add/modify: [_2]'
=> '[_1]: Unable to add/modify: [_2]',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a course group.'
=> '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a course group.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a reserved word.'
=> '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a reserved word.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]".'
=> '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]".',

   '[_1]: Unable to enroll. No password specified.'
=> '[_1]: Unable to enroll. No password specified.',

   '[_1]: Unable to modify authentication: [_2]'
=> '[_1]: Unable to modify authentication: [_2]',

   '[_1]: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '[_1]: Unacceptable username for user [_2] [_3] [_4] [_5]',

   '[_1]: You do not have permission to add the requested role [_2] for the user.'
=> '[_1]: You do not have permission to add the requested role [_2] for the user.',

   '[_1]: [_2] from domain [_3]'
=> '[_1]: [_2] from domain [_3]',

   '[_1]: student, [_2]: TA, [_3]: instructor'
=> '[_1]: student, [_2]: TA, [_3]: instructor',

   '[_1]: students can view all sections. [_2]: students can only view their own section. blank or [_3] prevents student view.'
=> '[_1]: students can view all sections. [_2]: students can only view their own section. blank or [_3] prevents student view.',

   '[_1]: they are allowed (this is the default). [_2]: no, they can only grade their own section.'
=> '[_1]: they are allowed (this is the default). [_2]: no, they can only grade their own section.',

   '[_1]:[_2] responses to [_3] may be too long to fit Excel spreadsheet.'
=> '[_1]:[_2] responses to [_3] may be too long to fit Excel spreadsheet.',

   '[_1]Ad hoc[_2] roles in domain [_3] --'
=> '[_1]Ad hoc[_2] roles in domain [_3] --',

   '[_1]Change[_2] for just [_3]this community[_4] or for [_5]all your courses/communities[_6].'
=> '[_1]Change[_2] for just [_3]this community[_4] or for [_5]all your courses/communities[_6].',

   '[_1]Change[_2] for just [_3]this course[_4] or for [_5]all your courses/communities[_6].'
=> '[_1]Change[_2] for just [_3]this course[_4] or for [_5]all your courses/communities[_6].',

   '[_1]Community[_2] in domain: [_3]'
=> '[_1]Community[_2] in domain: [_3]',

   '[_1]Contact the helpdesk[_2] or [_3]reload[_2] the page and try again.'
=> '[_1]Contact the helpdesk[_2] or [_3]reload[_2] the page and try again.',

   '[_1]Continue[_2] on in Inline Menu mode'
=> '[_1]Continue[_2] on in Inline Menu mode',

   '[_1]Error:[_2] An error ([_3]) occurred when attempting to upload the file, [_4]'
=> '[_1]Error:[_2] An error ([_3]) occurred when attempting to upload the file, [_4]',

   '[_1]Error:[_2] The file you attempted to upload, [_3] contained no information. Please check that you entered the correct filename.'
=> '[_1]Error:[_2] The file you attempted to upload, [_3] contained no information. Please check that you entered the correct filename.',

   '[_1]Hide[_2] clicker id'
=> '[_1]Hide[_2] clicker id',

   '[_1]Log in again[_2]'
=> '[_1]Log in again[_2]',

   '[_1]No section[_2] - [_3]'
=> '[_1]No section[_2] - [_3]',

   '[_1]Official course[_2] in domain: [_3]'
=> '[_1]Official course[_2] in domain: [_3]',

   '[_1]Return[_2] to editing resource.'
=> '[_1]Return[_2] to editing resource.',

   '[_1]Select Date[_2]'
=> '[_1]Select Date[_2]',

   '[_1]Show[_2] clicker id'
=> '[_1]Show[_2] clicker id',

   '[_1]Success:[_2] Successfully uploaded [_3] bytes of data into location: [_4]'
=> '[_1]Success:[_2] Successfully uploaded [_3] bytes of data into location: [_4]',

   '[_1]Unofficial course[_2] in domain: [_3]'
=> '[_1]Unofficial course[_2] in domain: [_3]',

   '[_1]Visit the [_2]Course/Community Catalog[_3] to view all [_4] LON-CAPA courses and communities.'
=> '[_1]Visit the [_2]Course/Community Catalog[_3] to view all [_4] LON-CAPA courses and communities.',

   '[_1]W[_2]ARNING'
=> '[_1]W[_2]ARNING',

   '[_1]Your CSV file[_2] is ready for download.'
=> '[_1]Your CSV file[_2] is ready for download.',

   '[_1]Your Excel spreadsheet[_2] is ready for download.'
=> '[_1]Your Excel spreadsheet[_2] is ready for download.',

   '[_1]Your IMS package[_2] is ready for download.'
=> '[_1]Your IMS package[_2] is ready for download.',

   '[_1]student(s)'
=> '[_1]student(s)',

   '[quant,_1,communication blocking period was,communication blocking periods were] added.'
=> '[quant,_1,communication blocking period was,communication blocking periods were] added.',

   '[quant,_1,communication blocking period was,communication blocking periods were] modified.'
=> '[quant,_1,communication blocking period was,communication blocking periods were] modified.',

   '[quant,_1,communication blocking period was,communication blocking periods were] removed.'
=> '[quant,_1,communication blocking period was,communication blocking periods were] removed.',

   '[quant,_1,day]'
=> '[quant,_1,day]',

   '[quant,_1,error]'
=> '[quant,_1,error]',

   '[quant,_1,file is,files are] publicly accessible.'
=> '[quant,_1,file is,files are] publicly accessible.',

   '[quant,_1,file requires,files require] a passphrase for access.'
=> '[quant,_1,file requires,files require] a passphrase for access.',

   '[quant,_1,file,files,No files]'
=> '[quant,_1,file,files,No files]',

   '[quant,_1,file] uploaded to this anonymous survey'
=> '[quant,_1,file] uploaded to this anonymous survey',

   '[quant,_1,hour]'
=> '[quant,_1,hour]',

   '[quant,_1,hr]'
=> '[quant,_1,hr]',

   '[quant,_1,item]'
=> '[quant,_1,item]',

   '[quant,_1,message is, messages are] not viewable because display of LON-CAPA messages sent to you by other students between [_2] and [_3] is currently being blocked because of online exams.'
=> '[quant,_1,message is, messages are] not viewable because display of LON-CAPA messages sent to you by other students between [_2] and [_3] is currently being blocked because of online exams.',

   '[quant,_1,message] forwarded.'
=> '[quant,_1,message] forwarded.',

   '[quant,_1,min]'
=> '[quant,_1,min]',

   '[quant,_1,minute]'
=> '[quant,_1,minute]',

   '[quant,_1,mth]'
=> '[quant,_1,mth]',

   '[quant,_1,sec]'
=> '[quant,_1,sec]',

   '[quant,_1,second]'
=> '[quant,_1,second]',

   '[quant,_1,section:,sections:,No sections]'
=> '[quant,_1,section:,sections:,No sections]',

   '[quant,_1,student]'
=> '[quant,_1,student]',

   '[quant,_1,warning]'
=> '[quant,_1,warning]',

   '[quant,_1,yr]'
=> '[quant,_1,yr]',

   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) sectionID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2'
=> 'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) sectionID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section ID to be used in LON-CAPA e.g., 001:1,002:2',

   'a page will be displayed that lists items in the course that may require action from you.'
=> 'a page will be displayed that lists items in the course that may require action from you.',

   'active'
=> 'active',

   'active group(s)'
=> 'active group(s)',

   'active groups'
=> 'active groups',

   'all LON-CAPA'
=> 'all LON-CAPA',

   'all access types '
=> 'all access types ',

   'all details'
=> 'all details',

   'all sections'
=> 'all sections',

   'all users'
=> 'all users',

   'allow'
=> 'allow',

   'allowed'
=> 'allowed',

   'an existing [_1]'
=> 'an existing [_1]',

   'and is set to display'
=> 'and is set to display',

   'any'
=> 'any',

   'are contributing enrollment to the LON-CAPA class roster.'
=> 'are contributing enrollment to the LON-CAPA class roster.',

   'as a member'
=> 'as a member',

   'as a result of the nightly enrollment check:'
=> 'as a result of the nightly enrollment check:',

   'as a student'
=> 'as a student',

   'assignment note'
=> 'assignment note',

   'attachments'
=> 'attachments',

   'based on domain, username, or course/community affiliation.'
=> 'based on domain, username, or course/community affiliation.',

   'begins with'
=> 'begins with',

   'bomb'
=> 'bomb',

   'bottom'
=> 'bottom',

   'bubblesheet forms'
=> 'bubblesheet forms',

   'but will continue to be visible to your instructor'
=> 'but will continue to be visible to your instructor',

   'by dates and submissions'
=> 'by dates and submissions',

   'can not be used as it is the name of '
=> 'can not be used as it is the name of ',

   'click for example'
=> 'click for example',

   'clicker file'
=> 'clicker file',

   'clicker id'
=> 'clicker id',

   'closed folder'
=> 'closed folder',

   'comments'
=> 'comments',

   'condition'
=> 'condition',

   'conditionally hidden'
=> 'conditionally hidden',

   'conditions'
=> 'conditions',

   'contains'
=> 'contains',

   'contents hidden'
=> 'contents hidden',

   'copy metadata error'
=> 'copy metadata error',

   'course only'
=> 'course only',

   'course/community'
=> 'course/community',

   'create new user if required'
=> 'create new user if required',

   'delete files'
=> 'delete files',

   'deleted'
=> 'deleted',

   'deny'
=> 'deny',

   'disabled'
=> 'disabled',

   'disallowed'
=> 'disallowed',

   'discard'
=> 'discard',

   'discussion'
=> 'discussion',

   'discussion board'
=> 'discussion board',

   'disk space allocated to portfolio files'
=> 'disk space allocated to portfolio files',

   'domains'
=> 'domains',

   'e.g. <tt>joe@doe.com</tt>'
=> 'e.g. <tt>joe@doe.com</tt>',

   'e.g. <tt>userA:domain1,userB:domain2,...</tt>'
=> 'e.g. <tt>userA:domain1,userB:domain2,...</tt>',

   'e.g., Exam 1'
=> 'e.g., Exam 1',

   'enabled'
=> 'enabled',

   'end date'
=> 'end date',

   'ending'
=> 'ending',

   'ends: '
=> 'ends: ',

   'ends: no ending date'
=> 'ends: no ending date',

   'enroll type/action'
=> 'enroll type/action',

   'error(s)'
=> 'error(s)',

   'excused'
=> 'excused',

   'expired'
=> 'expired',

   'files'
=> 'files',

   'first resource in the course'
=> 'first resource in the course',

   'for [_1]all resources in the course[_2]'
=> 'for [_1]all resources in the course[_2]',

   'for [_1]all students in course[_2]'
=> 'for [_1]all students in course[_2]',

   'for the resource ID [_1] (name unavailable), part [_2]'
=> 'for the resource ID [_1] (name unavailable), part [_2]',

   'for the resource named [_1], part [_2]'
=> 'for the resource named [_1], part [_2]',

   'force directory level metadata over existing'
=> 'force directory level metadata over existing',

   'force republication of previously published files'
=> 'force republication of previously published files',

   'formula'
=> 'formula',

   'from domain'
=> 'from domain',

   'from users'
=> 'from users',

   'fullname'
=> 'fullname',

   'fulltext search (time consuming)'
=> 'fulltext search (time consuming)',

   'future'
=> 'future',

   'future role(s); starts: [_1].'
=> 'future role(s); starts: [_1].',

   'group'
=> 'group',

   'group membership status - [_1]'
=> 'group membership status - [_1]',

   'groups'
=> 'groups',

   'height (pixel):'
=> 'height (pixel):',

   'help on ranking problems'
=> 'help on ranking problems',

   'help/support'
=> 'help/support',

   'hidden'
=> 'hidden',

   'homepage'
=> 'homepage',

   'horizontal'
=> 'horizontal',

   'huge font size'
=> 'huge font size',

   'id'
=> 'id',

   'if enabled below'
=> 'if enabled below',

   'if enabled on the next page'
=> 'if enabled on the next page',

   "if you have an institutional log-in, use your institution's [_1]single sign on page[_2] to log-in, then create an account"
=> "if you have an institutional log-in, use your institution's [_1]single sign on page[_2] to log-in, then create an account",

   'if you have an institutional login, [_1]create an account[_2]'
=> 'if you have an institutional login, [_1]create an account[_2]',

   'if you have chosen to enable a nightly automated enrollment update.'
=> 'if you have chosen to enable a nightly automated enrollment update.',

   'in LON-CAPA domain '
=> 'in LON-CAPA domain ',

   'in LON-CAPA domains:'
=> 'in LON-CAPA domains:',

   'in all LON-CAPA domains.'
=> 'in all LON-CAPA domains.',

   'in grading queue'
=> 'in grading queue',

   'in institutional directory'
=> 'in institutional directory',

   'in institutional directory for selected domain'
=> 'in institutional directory for selected domain',

   'in section [_1]'
=> 'in section [_1]',

   'in selected LON-CAPA domain'
=> 'in selected LON-CAPA domain',

   'in the future'
=> 'in the future',

   "in the group's group portfolio."
=> "in the group's group portfolio.",

   'in the past'
=> 'in the past',

   'in this course'
=> 'in this course',

   'in this domain'
=> 'in this domain',

   'in this portfolio.'
=> 'in this portfolio.',

   'incl. grades'
=> 'incl. grades',

   'include subdirectories'
=> 'include subdirectories',

   'inflating:'
=> 'inflating:',

   'info'
=> 'info',

   'information not available'
=> 'information not available',

   'internal, optional'
=> 'internal, optional',

   'is'
=> 'is',

   'is in this state due to author settings.'
=> 'is in this state due to author settings.',

   'is not a valid e-mail address'
=> 'is not a valid e-mail address',

   'is not a valid name.'
=> 'is not a valid name.',

   'jsMath'
=> 'jsMath',

   'jsMath:'
=> 'jsMath:',

   'lang_locale'
=> 'lang_locale',

   'larger than normal'
=> 'larger than normal',

   'last name, first name'
=> 'last name, first name',

   'last submission &amp; parts info'
=> 'last submission &amp; parts info',

   'last submission only'
=> 'last submission only',

   'left'
=> 'left',

   'make file(s) obsolete'
=> 'make file(s) obsolete',

   'make these dates the default access dates for future community enrollment'
=> 'make these dates the default access dates for future community enrollment',

   'make these dates the default access dates for future course enrollment'
=> 'make these dates the default access dates for future course enrollment',

   'make these dates the default access dates for future student enrollment'
=> 'make these dates the default access dates for future student enrollment',

   'manual'
=> 'manual',

   'maximum'
=> 'maximum',

   'maximum possible'
=> 'maximum possible',

   'may not be used as the name for a section, as it is the name of a community group'
=> 'may not be used as the name for a section, as it is the name of a community group',

   'member name'
=> 'member name',

   'members of the new group.'
=> 'members of the new group.',

   'mimetex (Convert to Images)'
=> 'mimetex (Convert to Images)',

   'mimetex (Convert to Images):'
=> 'mimetex (Convert to Images):',

   'modifiable fields (if institutional data blank): '
=> 'modifiable fields (if institutional data blank): ',

   'modify'
=> 'modify',

   'most recent version'
=> 'most recent version',

   'name only visible to community facilitators'
=> 'name only visible to community facilitators',

   'no action taken'
=> 'no action taken',

   'no section'
=> 'no section',

   'none'
=> 'none',

   'not available'
=> 'not available',

   'not graded'
=> 'not graded',

   'not in this course'
=> 'not in this course',

   'not using syllabus template)'
=> 'not using syllabus template)',

   'now'
=> 'now',

   'now set to'
=> 'now set to',

   'now set to:'
=> 'now set to:',

   'numerical'
=> 'numerical',

   'occurred while running'
=> 'occurred while running',

   'off'
=> 'off',

   'official'
=> 'official',

   'ok'
=> 'ok',

   'on'
=> 'on',

   'one column'
=> 'one column',

   'one student'
=> 'one student',

   'only members of group: "[_1]"'
=> 'only members of group: "[_1]"',

   'only search domain [_1]'
=> 'only search domain [_1]',

   'only users affiliated with no section'
=> 'only users affiliated with no section',

   'only users affiliated with no section or section "[_1]"'
=> 'only users affiliated with no section or section "[_1]"',

   'only users affiliated with section "[_1]"'
=> 'only users affiliated with section "[_1]"',

   'only users in section "[_1]"'
=> 'only users in section "[_1]"',

   'only users not in any group'
=> 'only users not in any group',

   'opened folder'
=> 'opened folder',

   'original subject'
=> 'original subject',

   'other'
=> 'other',

   'part - '
=> 'part - ',

   'parts correct'
=> 'parts correct',

   'passphrase not required'
=> 'passphrase not required',

   'passphrase protected'
=> 'passphrase protected',

   'permanent e-mail'
=> 'permanent e-mail',

   'photo'
=> 'photo',

   'practice'
=> 'practice',

   'radiobutton'
=> 'radiobutton',

   'random'
=> 'random',

   'random order'
=> 'random order',

   'randomly pick [quant,_1,resource]'
=> 'randomly pick [quant,_1,resource]',

   'reason'
=> 'reason',

   'reason - invalid user: [_1]'
=> 'reason - invalid user: [_1]',

   'reason - unsupported language: [_1]'
=> 'reason - unsupported language: [_1]',

   'receipt no.'
=> 'receipt no.',

   'related words'
=> 'related words',

   'rename files'
=> 'rename files',

   'reset status'
=> 'reset status',

   'right'
=> 'right',

   'role name'
=> 'role name',

   'role(s) active now; ends [_1].'
=> 'role(s) active now; ends [_1].',

   'role(s) active now; no end date'
=> 'role(s) active now; no end date',

   'role(s) expired: [_1].'
=> 'role(s) expired: [_1].',

   'role:section,role:section,...'
=> 'role:section,role:section,...',

   'roles which expired since last month'
=> 'roles which expired since last month',

   'roles which expired since last week'
=> 'roles which expired since last week',

   'roles which expired since start of course'
=> 'roles which expired since start of course',

   'roles which expired since yesterday'
=> 'roles which expired since yesterday',

   'roles which have become active since last month'
=> 'roles which have become active since last month',

   'roles which have become active since last week'
=> 'roles which have become active since last week',

   'roles which have become active since start of course'
=> 'roles which have become active since start of course',

   'roles which have become active since yesterday'
=> 'roles which have become active since yesterday',

   'roster'
=> 'roster',

   'saved CODEs'
=> 'saved CODEs',

   'score'
=> 'score',

   'scores from file'
=> 'scores from file',

   'search discussion postings (resources and discussion boards)'
=> 'search discussion postings (resources and discussion boards)',

   'seconds occurred while running &lt;while&gt; on line'
=> 'seconds occurred while running &lt;while&gt; on line',

   'secs ago'
=> 'secs ago',

   "sender's name"
=> "sender's name",

   'set access controls for files'
=> 'set access controls for files',

   'shared_source'
=> 'shared_source',

   'show'
=> 'show',

   'showing messages [_1] through [_2] of [_3].'
=> 'showing messages [_1] through [_2] of [_3].',

   'since last month'
=> 'since last month',

   'since last week'
=> 'since last week',

   'single part'
=> 'single part',

   'so all members will receive the same optional privileges for a particular tool.'
=> 'so all members will receive the same optional privileges for a particular tool.',

   'so different members can receive different optional privileges for a particular tool.'
=> 'so different members can receive different optional privileges for a particular tool.',

   'specific setting for this course'
=> 'specific setting for this course',

   'specified'
=> 'specified',

   'start date'
=> 'start date',

   'still set to'
=> 'still set to',

   'still set to:'
=> 'still set to:',

   'sum'
=> 'sum',

   'supported types'
=> 'supported types',

   'textual_remote_display'
=> 'textual_remote_display',

   'the resource you just saw on the screen'
=> 'the resource you just saw on the screen',

   'this course'
=> 'this course',

   'to add/modify roles'
=> 'to add/modify roles',

   'top'
=> 'top',

   'tth (TeX to HTML)'
=> 'tth (TeX to HTML)',

   'tth (TeX to HTML):'
=> 'tth (TeX to HTML):',

   'two columns'
=> 'two columns',

   'unable to verify variable URL'
=> 'unable to verify variable URL',

   'unofficial'
=> 'unofficial',

   'unused'
=> 'unused',

   'upload files'
=> 'upload files',

   'user preference'
=> 'user preference',

   'user1:domain1,user2:domain2 etc.'
=> 'user1:domain1,user2:domain2 etc.',

   'user:domain,user:domain'
=> 'user:domain,user:domain',

   'user:domain,user:domain(section;section;...;*;...),...'
=> 'user:domain,user:domain(section;section;...;*;...),...',

   'user:domain,user:domain,*:domain'
=> 'user:domain,user:domain,*:domain',

   'user:domain,user:domain,...'
=> 'user:domain,user:domain,...',

   'username is known'
=> 'username is known',

   'username1:domain1: text'
=> 'username1:domain1: text',

   'username2:domain2: text'
=> 'username2:domain2: text',

   'username3:domain3: text'
=> 'username3:domain3: text',

   'username:domain'
=> 'username:domain',

   'username:domain,username:domain,...'
=> 'username:domain,username:domain,...',

   'username@'
=> 'username@',

   'users with [_1] roles'
=> 'users with [_1] roles',

   'users with active [_1] roles'
=> 'users with active [_1] roles',

   'users with expired [_1] roles'
=> 'users with expired [_1] roles',

   'users with future [_1] roles'
=> 'users with future [_1] roles',

   'vertical'
=> 'vertical',

   'when you select a course role from the roles screen'
=> 'when you select a course role from the roles screen',

   'width (pixel):'
=> 'width (pixel):',

   'will override current values'
=> 'will override current values',

   'with Formfields'
=> 'with Formfields',

   'with any status'
=> 'with any status',

   'with incorrect submissions'
=> 'with incorrect submissions',

   'with institutional codes'
=> 'with institutional codes',

   'with no related words'
=> 'with no related words',

   'with related words'
=> 'with related words',

   'with submissions'
=> 'with submissions',

   'with ungraded submissions'
=> 'with ungraded submissions',

   'without Formfields'
=> 'without Formfields',

   'you can use an e-mail address to [_1]create an account[_2]'
=> 'you can use an e-mail address to [_1]create an account[_2]',

   'you will be taken to the start of the course.'
=> 'you will be taken to the start of the course.',

   'your general user preferences'
=> 'your general user preferences',


#SYNCMARKER
);
1;

