# The LearningOnline Network with CAPA
# Russian Localization Lexicon
#
# $Id: ru.pm,v 1.63 2011/05/27 14:39:56 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::ru;
use base qw(Apache::localize);
%Lexicon=('_AUTO' => 1,
'char_encoding'=> 'UTF-8',
'lang_locale' => 'ru_RU.utf8',
'language_code'=> 'ru',
'date_locale'  =>
      '$weekday, $day. $month $year, $twentyfour:$minutes:$seconds',
'date_months'  => 'Январь,Февраль,Март,Апрель,Май,Июнь,Июль,Август,Сентябрь,Октябрь,Ноябрь,Декабрь',
'date_days'    => 'Вс,Пн,Вт,Ср,Чт,Пт,Сб',
'date_am' => 'am',
'date_pm' => 'pm',
'textual_remote_display' => 'on',
'htmlarea_lang' => 'ru',

   'Arabic - UTF'
=> 'ﺎﻠﻋﺮﺒﻳﺓ - UTF',

   'German - UTF'
=> 'Deutsch - UTF',

   'English - UTF'
=> 'English - UTF',

   'Spanish (Castellan) - UTF'
=> 'español (castellano) - UTF',

   'Persian - UTF'
=> 'ﺍیﺭﺎﻧی - UTF',

   'French - UTF'
=> 'français - UTF',

   'Hebrew - UTF'
=> 'עברית - UTF',

   'Japanese - UTF'
=> '日本語 - UTF',

   'Portuguese - UTF'
=> 'Português - UTF',

   'Russian - UTF'
=> 'Русский - UTF',

   'Turkish - UTF'
=> 'türkçe - UTF',

   'Chinese Simplified - UTF'
=> '简体中文 - UTF',

   'Swedish Chef - UTF'
=> 'Swedish Chef - UTF',

   'calendar'
=> 'календарь',

   'January'
=> 'Январь',

   'February'
=> 'Февраль',


#SYNC Fri Nov 14 14:31:31 2003
   "Calculate answers"
=> "Сосчитать ответы",

   '#Stdnts'
=> '#Студ',

   '#YES'
=> '#YES',

   '%Wrng'
=> '%Wrng',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;Show&nbsp;All&nbsp;Foils',

   '"[_1]" for default hiding'
=> '"[_1]" для прятания по-умолчанию',

   '"[_1]" if allowed, anything else if not'
=> '"[_1]" если разрешено, любое другое - нет',

   '"[_1]" to disable, anything else if not'
=> 'если отменить, любое другое - нет',

   ', and answers will be available on'
=> ', и ответы будут доступны',

   ', is reserved internally by LON-CAPA.'
=> ', зарезервирован внутренне LON-CAPA-ой.',

   ', or the next time you log in.'
=> ', или во время следующего Вашего входа в систему.',

   ', select a template from the pull-down menu below'
=> ', выберите шаблон из меню ниже',

   '. . . for a particular section'
=> '. . . для определенного раздела',

   '. . . for all students in the course'
=> '. . . для всех студентов курса',

   '. . . for an individual student'
=> '. . . для индивидуального студента',

   '1 out of N multiple choice (radio button)'
=> '1 из N возможных выборов (радио кнопка)',

   '12 am' # midnight
=> '0',

   'midnight'
=> 'полночь',

   '1 am'
=> '1',

   '2 am'
=> '2',

   '3 am'
=> '3',

   '4 am'
=> '4',

   '5 am'
=> '5',

   '6 am'
=> '6',

   '7 am'
=> '7',

   '8 am'
=> '8',

   '9 am'
=> '9',

   '10 am'
=> '10',

   '11 am'
=> '11',

   '12 noon'
=> '12',

   'noon'
=> 'полдень',

   '1 pm'
=> '13',

   '2 pm'
=> '14',

   '3 pm'
=> '15',

   '4 pm'
=> '16',

   '5 pm'
=> '17',

   '6 pm'
=> '18',

   '7 pm'
=> '19',

   '8 pm'
=> '20',

   '9 pm'
=> '21',

   '10 pm'
=> '22',

   '11 pm'
=> '23',

   '<- Previous'
=> '<- Назад',

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  Невозможно зачислить: [_2]',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: Зачисление невозможно.  Пароль не задан.',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>: Неприемлимое имя пользователя для пользователя [_2] [_3] [_4] [_5]',

   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML разрешен</b>: Участники обсуждений могут использовать элементы HTML  в курсовых обсуждениях.',

   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML запрещен</b>: HTML будет запрещен в курсовых обсуждениях.',

   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Инструкторы</b> - инструкторы не смогут участвовать в обсуждениях',

   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Инструкторы</b> - инструкторы не смогут использовать или просматривать дискуссионную комнату.',

   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Студенты</b> - студенты не смогут участвовать в обсуждениях',

   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Студенты</b> - студенты не смогут использовать или просматривать дискуссионную комнату.',

   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Помощники Преподавателя</b> - помощники преподавателя не смогут участвовать в обсуждениях',

   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Помощники Преподавателя</b> - помощники преподавателя не смогут использовать или просматривать дискуссионную комнату.',

   'Hand Graded (handgrade)'
=> 'Оцененный Вручную (handgrade)',

   'Home Server'
=> 'Домашний Сервер',

   'How many tries should be set for all problems in the course?'
=> 'Сколько попыток задается для каждой из задач курса? <br /><br />',

   'How many tries should be set for the selected folder?'
=> 'Сколько попыток задается для выбранной папки?<br /><br />',

   'How many tries should be set for the selected problem?'
=> 'Сколько попыток задается для выбранной задачи?<br /><br />',

   'How should the results be printed?'
=> '<br /><big><i><b>Способ Печати?</b></i></big><br />',

   'helper'
=> 'помощник',

   'A score has been assigned.'
=> 'Оценка выставлена.',

   'ABSTRACT'
=> 'РЕФЕРАТ',

   'ALL'
=> 'ВСЕ',

   'About Me'
=> 'Обо Мне',

   'Abstract'
=> 'Реферат',

   'Access Control'
=> 'Контроль Доступа',

   'Access Key Management'
=> 'Управление Ключами Доступа',

   'Access and Usage Statistics'
=> 'Статистика Доступа и Использования',

   'Actions'
=> 'Действия',

   'Activate'
=> 'Активизировать',

   'Add Roles'
=> 'Добавить Роли',

   'Add new option'
=> 'Добавить новую опцию',

   "Add one empty page/column after each student's assignment"
=> "Добавить пустую страницу/столбец после каждого студенческого задания",

   "Add two empty pages/column after each student's assignment"
=> "Добавить две пустые страницы/столбца после каждого студенческого задания",

   "Add three empty pages/column after each student's assignment"
=> "Добавить три пустые страницы/столбца после каждого студенческого задания",

   'Additional Keywords'
=> 'Дополнительные Ключевые Слова',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'Дополнительные Метаданные (не стандартные, параметры, экспортируемые)',

   'Additional Recipients'
=> 'Дополнительные Получатели',

   'Additional settings, if specified below, will override cloned settings'
=> 'Дополнительные установки, в случае задания, заместят клонированные устанвки',

   'Administrator'
=> 'Администратор',

   'Advanced Catalog Search'
=> 'Расширенный Поиск в Каталоге',

   'Advanced Edit'
=> 'Продвинутое Редактирование',

   'Advanced Search'
=> 'Расширенное Поиск',

   'All Documents in Course'
=> 'Все Документы в Курсе',

   'All Maps or Folders'
=> 'Все Последовательности или Папки',

   'All Resources'
=> 'Все Ресурсы',

   'All Resources (possibly large output)'
=> 'Все Ресурсы (возможен большой вывод)',

   'All Students'
=> 'Все Студенты',

   'All homework is currently completed'
=> 'Все домашние задания на данный момент выполнены',

   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.'
=> '<p>Все установки/параметры, которые Вы можете изменить с помощью данного Помощника, могут быть изменены путем перехода в PARM экран и нажатия на клавишу &quot;Задать Окружение Курса&quot;.</p> <p>Если Вы не имеете опыта работы с LON-CAPA курсами или предпочитаете использовать интерфейс Помощника, нажмите <nobr><b>Далее -&gt;</b></nobr>.</p>',

   '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>'
=> '<p>Ваш текущий LON-CAPA домен - &quot;<b>[_1]</b>&quot;.</p>',

   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> '<p><b>Продвинутые возможности</b>: Вы можете посылать отзывы из различных разделов разным людям следующим образом:</p>
      <ul><li>Разделяйте различные данные запятыми.</li>
          <li>Для посылки отзыва по определенному адресу для различных разделов, добавьте имя раздела или имена (разделенные знаком ;) во взятый в скобки список после <b>пользователь:домен</b>.</li></ul>
      <p>Например,</p>
      <p><b>john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009)</b></p>
      <p>направит отзыв к &quot;john102&quot; для разделов 1, 2, и 3, к
         &quot;bob293&quot; для 4, 5, и 6, и к &quot;madeupname:here&quot; для
         7, 8, и 9. Отметим, что нет ограничений на то чтобы адрес был в определенном домене.</p>',

   'All versions'
=> 'Все версии',

   'Allow limited HTML in discussion posts'
=> 'Разрешить использовать средства HTML в обсуждениях',

   'Allow problems to be split over pages'
=> 'Разрешить печать задач с переносом на другую страницу',

   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Допустимые Расширения Файлов для Обновляемых Файлов  (uploadedfiletypes)',

   'An error occurred during the attempt to change the role information for this student.'
=> 'Ошибка при попытке изменения информации о роли этого студента.',

   'An error occurred during the attempt to change the section for this student.'
=> 'Ошибка во время попытки изменения раздела для этого студента.',

   'An error occurred while grading your answer.'
=> 'Ошибка при оценке Вашего ответа.',

   'Analyze Over '
=> 'Анализировать По ',

   'Analyze Problem'
=> 'Анализировать Задачу',

   'Analyze Problem Again'
=> 'Анализировать Задачу Вновь',

   'Analyze Progress'
=> 'Анализировать Прогресс',

   'Analyze as '
=> 'Анализировать как ',

   'Analyzing a problem'
=> 'Анализировать задачу',

   'Announcements and Calendar'
=> 'Объявления и Календарь',

# Announcements and календарь
   'Anonymous'
=> 'Анонимный',

   'Anonymous contribution to course discussion of resource'
=> 'Анонимный вклад в обсуждение ресурса курса',

   'Answer'
=> 'Ответ',

   'Answer Date (answerdate)'
=> 'Дата Открытия Ответов (answerdate)',

   'Answer Submitted'
=> 'Ответ Послан',

   'Answer available'
=> 'Ответ доступен',

   'Answer submitted'
=> 'Ответ послан',

   'Answer submitted, not yet graded'
=> 'Ответ послан, еще не оценен',

   'Answer:'
=> 'Ответ:',

   'Any Language'
=> 'Любой Язык',

   'Any User'
=> 'Любой Пользователь',

   'Any category'
=> 'Любая категория',

   'Any copyright/distribution'
=> 'Любое авторское право/распространение',

   'April'
=> 'Апрель',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'Как правило, только авторы или соавторы должны быть filesystem authenticated (дает доступ к файловой системе сервера).',

   'Assessment'
=> 'Оценка',

   'Assessment Parameters'
=> 'Параметры Оценки',

   'Assessment URL and Title'
=> 'URL и Название Оценки',

   'Assigned User Roles'
=> 'Заданнуе Роли Пользователя',

   'Associate columns with student attributes.'
=> 'Ассоциированные столбцы со студенческими атрибутами.',

   'Attachment'
=> 'Приложение',

   'Attribute'
=> 'Атрибут',

   'August'
=> 'Август',

   'Author'
=> 'Автор',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'Роли Автора и Соавтора могут быть недоступны на серверах не являющихся вашим домашним сервером.',

   'Author(s)'
=> 'Автор(ы)',

   'Automated adds'
=> 'Автоматическое зачисление',

   'Automated drops'
=> 'Автоматическое отчисление',

   'Automated Enrollment Manager'
=> 'Мэнеджер Автоматического Зачисления',

   'Automated enrollment settings'
=> 'Автоматические установки зачисления',

   'Average number of tries till solved'
=> 'Среднее число попыток до решения',

   'Back to'
=> 'Назад к',

   'Back to Directory'
=> 'Назад к Директории',

   'Back to Source'
=> 'Назад к Источнику',

   'Back to Source Directory'
=> 'Назад к Директории Источника',

   'Became this version on ...'
=> 'Стало данной жерсией на ...',

   'Bad Filename'
=> 'Плохое имя файла',

   'Binary File'
=> 'Двоичный Файл',

   'Blank'
=> 'Пробел',

   'Brief view of each students performance in course.'
=> 'Краткий обзор успеваемости каждого студента в курсе.',

   'Broadcast Message to Course'
=> 'Транслировать Сообщение Курсу',

   'Browse'
=> 'Просмотр',

   'Browse Resources'
=> 'Просмотреть Ресурсы',

   'Browse published resources'
=> 'Просмотреть опубликованные ресурсы',

   'Browse resources'
=> 'Просмотреть ресурсы',

   'Browsing resource, all submissions are temporary.'
=> 'Просмотр ресурсов, все submissions временные.',

   'Bulletin Board'
=> 'Доска Обьявлений',

   'Bulletin Board/Discussion'
=> 'Доска Обьявлений/Обсуждения',

   'By'
=> 'By',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (значения, разделенные запятыми, журнал)',

   'CSV format'
=> 'CSV формат',

   'Calculate course grades (Spreadsheet)'
=> 'Сосчитать оценки для курса (Журнал)',

   'Calculations'
=> 'Рассчеты',

   'Cancel'
=> 'Отменить',

   'Catalog Information'
=> 'Информация из Каталога',

   'Change'
=> 'Изменить',

   'Change Random Seed To:'
=> 'Изменить Ядро Рэндомизации На:',

   'Change Your Language Preferences'
=> 'Изменить Ваши Языковые Предпочтения',

   'Change Your Preferences'
=> 'Изменить Ваши Предпочтения',

   'Change User Privileges'
=> 'Изменить Привилегии Пользователя',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Изменения для всех студентов станут активными через 10 минут.',

   'Changes will become active for your current session after'
=> 'Изменения для вашей текущей сессии станут активными после',

   'Chat Participation'
=> 'Доступ к Обсуждению в Реальном Времени',

   'Check All'
=> 'Выбрать Все',

   'Check Course Document Versions'
=> 'Выбрать Версии Документов Курса',

   'Check for All'
=> 'Выбрать для Всех',

   'Check for None'
=> 'Отменить выбор для Всех',

   'Check for Section/Group'
=> 'Выбрать для Раздела/Группы',

   'Check/Set Resource Versions'
=> 'Выбор/Задание Версии Ресурсов',

   'Choose a different resource'
=> 'Выбрать другой ресурс',

   'Choose the course to work on'
=> 'Выберите курс для работы',

   'Choose the user role'
=> 'Выберите роль пользователя',

   'Chronological View'
=> 'Хронологический Просмотр',

   'Class Hours'
=> 'Рассписание (Class Hours)',

   'Clear All'
=> 'Очистить Все',

   'Clear Caches'
=> 'Очистить Кэш',

   "Click to download or use your browser's Save Link function"
=> "Щелкни загрузить или используй функцию Save Link своего браузера",

   'Clone an existing course'
=> 'Клон уже существующего курса',

   'Close'
=> 'Закрыть',

   'Close All Folders'
=> 'Закрыть Все Папки',

   'Close This Window'
=> 'Закрыть данное окно',

   'Co-Author'
=> 'Соавтор',

   'Collapse Remote Control'
=> 'Поломка Пульта Дистанционного Управления',

   'Column'
=> 'Столбец',

   'Column&nbsp;[_1]'
=> 'Столбец&nbsp;[_1]',

   'Comma Separated Values'
=> 'Значения, Разделенные Запятыми',

   'Communication'
=> 'Связь',

   'Communication and Messages'
=> 'Связь и Сообщения',

   'Compact View'
=> 'Compact View',

   'Compare versions of'
=> 'Сравнение версий',

   'Completed'
=> 'Завершено',

   'Completely new course'
=> 'Совершенно новый курс',

   'Concept:'
=> 'Понятие:',

   'Concepts'
=> 'Понятия',

   'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.'
=> 'Подтвердите, что введенная информация правильна, затем кликните &quot;Завершить Помощник&quot; чтобы завершить процесс задания параметра.',

   'Construction Space'
=> 'Авторское Пространство',

   'Construction Space Directory'
=> 'Директория Авторского Пространства',

   'Construction Space File Operation'
=> 'Операция над Файлом из Авторского Пространства',

   'Construction Space Version'
=> 'Версия из Авторского Пространства',

   'Contact'
=> 'Контактировать',

   'Contact Information'
=> 'Контактная Информация',

   'Content changed'
=> 'Содержание изменено',

   'Continue'
=> 'Продолжить',

   'Continue enrollment?'
=> 'Продолжать зачисление?',

   'Contribution to course discussion of resource'
=> 'Вклад в обсуждение ресурса курсом',

   'Copied metadata'
=> 'Метаданные скопированны',

   'Copied old metadata'
=> 'Старые метаданные скопированны',

   'Copied old target file'
=> 'Старый целевой файл скопирован',

   'Copied source file'
=> 'Файл-источник скопирован',

   'Copy selected'
=> 'Копировать выбранное',

   'Copying file'
=> 'Копирование файла',

   'Copy current file to'
=> 'Копировать текущий файл в',

   'Copyright'
=> 'Авторское Право',

   'Copyright/Distribution'
=> 'Авторское Право/Распространение',

   'Correct Option:'
=> 'Правильный Выбор:',

   'Could Not Process Request'
=> 'Запрос Не Может Быть Выполнен',

   'Could not write metadata'
=> 'Метаданные не могут быть записаны',

   'Course'
=> 'Курс',

   'Course Assessment Parameter - Helper Mode'
=> 'Параметры Доступа к Курсу - Мода Помощник',

   'Course Assessment Parameters - Overview Mode'
=> 'Параметры Доступа к Курсу - Обзорная Мода',

   'Course Assessments Parameters - Table Mode'
=> 'Параметры Доступа к Курсу - Табличная Мода',

   'Course Code'
=> 'Код Курса',

   'Course Content'
=> 'Содержание Курса',

   'Course Coordinator'
=> "Координатор Курса",

   'Course Data'
=> 'Курсовые Данные',

   'Course Description'
=> 'Описание Курса',

   'Course Documents'
=> 'Документы Курса',

   'Course default for all problems'
=> 'Для всех задач курса по-умолчанию',

   'Course Environment Parameters'
=> 'Параметры Окружения Курса',

   'Course Home Server'
=> 'Домашний Сервер Курса',

   'Course ID'
=> 'ID Курса',

   'Course ID/Number'
=> 'ID/Номер Курса',

   'Course ID or number'
=> 'ID или номер курса',

   'Course Information'
=> 'Информация о Курсе',

   'Course Initialization Helper'
=> 'Помощник Задания Структуры Курса',

   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.'
=> '<p>Члены курса могут высказывать свое мнение о содержании курса. Вы можете выбрать кто будет получать эты информацию - инструктор или помощник преподавателя. Пожалуйста введите их LON-CAPA адреса ниже в виде <b>пользователь:домен</b>, где &quot;пользователь&quot; и &quot;домен&quot; являются LON-CAPA именем пользоватвателя и LON-CAPA доменом, а не адресами электронной почты.</p>',

   'Course Title'
=> 'Название Курса',

   'Course Level'
=> 'Уровень Курса',

   'Course Parameter Helper'
=> 'Помощник Работы с Параметрами Курса',

   'Course Statistics and Charts'
=> 'Статистика Курса и Диаграммы',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'Статистика Курса и Диаграммы не могут быть восстановлены до рестарта базы данных.  Ваши данные неповреждены однако не могут быть показаны в данное время.',

   'Course announcements and my calendar'
=> 'Объявления и календарь курса',

# Course announcements and my календарь

   'Course level sheet'
=> 'Журнал курса',

   'Coursepack'
=> 'Дополнительные Материалы (Coursepack)',

   'Create'
=> 'Создать',

   'Create New Environment Variable'
=> 'Создать Новую Переменную Окружения Курса',

   'Create New User'
=> 'Создать Нового Пользователя',

   'Create Users, Change User Privileges'
=> 'Создать Пользователя, Изменить Его Привилегии',

   'Create a New Course'
=> 'Создать Новый Курс',

   'Create a new course'
=> 'Создать новый курс',

   'Create a user or modify the roles and privileges of a user'
=> 'Создать пользователя или модифицировать роль и привилегии',

   'Creation Date'
=> 'Дата Создания',

   'Critical Messages'
=> 'Критические Сообщения',

   'Crosslisted courses'
=> 'Crosslisted курсы',

   'Current'
=> 'Текущий',

   'Current Class List'
=> 'Текущий Список Класса',

   'Current Month'
=> 'Текущий Месяц',

   'Current Session Value'
=> 'Значение для Данной Сессии',

   'Current Version'
=> 'Текущая Версия',

   'Currently not available'
=> 'В данный момент недоступно',

   'Currently selected. '
=> 'Выбрано в данный момент. ',

   'Custom Distribution File'
=> 'Индивидуализированный Файл Распределения',

   'Custom Role Editor'
=> 'Редактор Ролей',

   'Customized right of use ...'
=> 'Индивидуализировать права использования ...',

   'Cut selected'
=> 'Вырезать выбранное',

   'Date'
=> 'Дата',

   'Deadlines'
=> 'Дата Сдачи (Deadlines)',

   'December'
=> 'Декабрь',

   'Decompress'
=> 'Распаковать',

   'Default'
=> 'По умолчанию',

   'Default beginning date when enrolling students'
=> 'Начальная дата зачисления студентов по-умолчанию',

   'Default Cataloging Information for Directory'
=> 'Информация в Каталоге (по умолчанию) о Директории',

   'Default ending date when enrolling students'
=> 'Конечная дата зачисления студентов по-умолчанию',

   'Default set of options to pass to tth/m when converting tex'
=> 'Набор опций передаваемых в tth/m для конвертирования tex',

   'Default Value'
=> 'Значение По Умолчанию',

   'Define Role'
=> 'Определить Роль',

   'Degree of difficulty'
=> 'Степень Сложности',

   'Delete'
=> 'Удалить',

   'Delete Checked'
=> 'Удалить Выбранное',

   'Delete a role'
=> 'Удалить Роль',

   'Delete an option'
=> 'Удалить опцию',

   'Delete messages from bulletin boards'
=> 'Удалить сообщения с доски обьявлений',

   'Delete:'
=> 'Удалить:',

   'Detailed Citation View'
=> 'Детальный Цитированный Вид',

   'Detailed Problem Analysis'
=> 'Детальный Анализ Задачи',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Детальная статистика и диаграммы успеваемости студента.',

   'Differences'
=> 'Различия',

   'Diffs'
=> 'Различия',

   'Diffs with Current Version'
=> 'Различия с Текущей Версией',

   'Diffs with Version'
=> 'Различия с Версией',

   'Diffs with current Version'
=> 'Различия с текущей Версией',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'Отключить проверку ID/Студенческих Номеров и Принудить Изменения Конфликтующих ID (делайте это только тогда когда Вы знаете что делаете)',

   'Disable all communication among students'
=> 'Отключить все сообщения между студентами',

   'Disable display of problem receipts'
=> 'Отключить показ расписок приема задач',

   'Disable student resource discussion'
=> 'Отключить обсуждение ресурсов студентами',

   'Disable student use of chatrooms'
=> 'Отключить использование студентами chatrooms',

   'Disallow live chatroom use for Roles'
=> 'Запретить живое общение для Ролей',

   'Disallow live chatroom use for Users'
=> 'Запретить живое общение для Пользователей',

   'Disallow Resource Discussion for Roles'
=> 'Запретить Обсуждение Ресурсов для Ролей',

   'Disallow Resource Discussion for Users'
=> 'Запретить Обсуждение Ресурсов для Пользователей',

   'Discard Edits and View'
=> 'Отменить Редактирования и Просмотреть',

   'Discard Selected'
=> 'Отказаться от Выбранного',

   'Discussion Contributions'
=> 'Вклады в Обсуждение',

   'Discussion Participation'
=> 'Участие в Обсуждении',

   'Discussions'
=> 'Обсуждения',

   'Display'
=> 'Показать',

   'Display All Messages'
=> 'Показать Все Сообщения',

   'Display all Messages'
=> 'Показать все Сообщения',

   'Display and analysis of submission times on assessments.'
=> 'Display and analysis of submission times on assessments.',

   'Display foils in order given'
=> 'Показать foils в данном порядке',

   'Display foils in random order'
=> 'Показать foils в случайном порядке',

   'Distribute Messages from Uploaded File to Course'
=> 'Разослать Сообщения Курсу из Файла',

   'Do NOT generate as standard course'
=> 'НЕ генерировать как отдельный курс',

   'Do not show plain URL (encrypturl)'
=> 'Не показывать URL (encrypturl)',

   'DoDiff'
=> 'Найти Различия',

   'Domain'
=> 'Домен',

   'Domain Coordinator'
=> 'Координатор Домена',

   'Domain Guest'
=> 'Гость Домена',

   'Domain only - use limited to courses in the domain'
=> 'Использование ограничено курсами в пределах данного домена',

   'Domain Level'
=> 'Уровень Домена',

   'Done'
=> 'Выполнено',

   'Drop Students'
=> 'Отчислить Студентов',

   'Drop/Add students in this course'
=> 'Отчислить/Добавить студентов в данный курс',

   'Dropped [_1]'
=> 'Отчислен [_1]',

   'Dropped [_1] student(s).'
=> 'Отчислен [_1] студент(ы).',

   'Dropping Students'
=> 'Отчисление Студентов',

   'Due'
=> 'Сдать',

   'Due Date (contentclose)'
=> 'Дата Закрытия Доступа (contentclose)',

   'Due Date (duedate)'
=> 'Дата Сдачи (duedate)',

   'Dump Course DOCS'
=> 'Dump Course DOCS',

   'Dump Course DOCS to Construction Space'
=> 'Скопировать Курс из DOCS в Авторское Пространство',

   'Duration of automated classlist updates'
=> 'Продолжительность автоматического обновления списка класса',

   'Dynamic Metadata'
=> 'Динамические Метаданные',

   'EMail Address'
=> 'EMail Адрес',

   'EMail and Messages'
=> 'EMail и Сообщения',

   'Edit'
=> 'Редактировать',

   'Edit Catalog Information'
=> 'Редактировать Информацию в Каталоге',

   'Edit Content of a Map'
=> 'Редактировать Оглавление Последовательности',

   'Edit Custom Role Privileges'
=> 'Редактировать Ролевые Привилегии',

   'Edit Directory Catalog Information'
=> 'Редактировать Инфо о Директории в Каталоге',

   'Edit and view documents included in this course'
=> 'Редактировать и просматривать документы из данного курса',

   'Edit this resource'
=> 'Редактировать этот ресурс',

   'Edit/Modify DOCS'
=> 'Редактировать/Модифицировать DOCS',

   'EditXML'
=> 'Редактировать XML',

   'Empty'
=> 'Пустой(я)',

   'Enclosing Map or Folder'
=> 'Главная Последовательность или Папка',

   'End'
=> 'Конец',

   'End Helper'
=> 'Конец Помощникаr',

   'End Time'
=> 'Конечное Время',

   'Ending Date'
=> 'Дата Окончания',

   'Enroll a single student'
=> 'Зачислить единственного студента',

   'Enroll as student'
=> 'Зачислить как студента',

   'Enrolling'
=> 'Зачисление',

   'Enroll One Student'
=> 'Зачислить Одного Студента',

   'Enrolling Student'
=> 'Зачисление Студента',

   'Enrolling Students'
=> 'Зачислять Студентов',

   'Enrollment Manager'
=> 'Зачисление/Отчисление',

   'Enrollment Status'
=> 'Статус Зачисления',

   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Заполните так много полей как Вы можете. Система проинформнрует Вас и вернет на данную страницу если заполненных данных окажется недостаточно для зачисления студента в Ваш класс.',

   'Enter construction space as a co-author'
=> 'Вход в авторское пространство в качестве соавтора',

   'Enter grades from check-out assessment resources'
=> 'Введите оженки из check-out assessment resources',

   'Enter my resource construction space'
=> 'Вход в мое авторское пространство',

   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Введите слова или фразы разделенные AND, OR, или NOT, затем нажмите SEARCH',

   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Введите слова или фразы разделенные операторами AND, OR, или NOT',

   'Enter the chatroom for the course'
=> 'Enter the chatroom for the course',

   'Entering course ...'
=> 'Вход в курс ...',

   'ERROR'
=> 'ОШИБКА',

   'Error'
=> 'Ошибка',

   'Error: Directory Non Empty'
=> 'Ошибка: Директория Не Пуста',

   'Error: destination for operation is an existing directory.'
=> 'Ошибка: назначение для операции - существующая директория.',

   'Error Messages'
=> 'Сообщения об Ошибке',

   'Error dropping [_1]:[_2]'
=> 'Ошибка отчисления [_1]:[_2]',

   'Essay, open end'
=> 'Essay, open end',

   'Evaluate Resource'
=> 'Оценка Ресурса',

   'Evaluation Comments'
=> 'Оценочные Комментарии',

   'Evaluation Data'
=> 'Оценочные Данные',

   'Every problem in a particular folder (overrides course default)'
=> 'Каждая задача в определенной папке (переопределяет заданные для курса по-умолчанию)',

   'Every problem in the course'
=> 'Каждая задача в курсе',

   'Exam Information'
=> 'Информация об Экзамене',

   'Exam Proctor'
=> 'Exam Proctor',

   'Excel'
=> 'Excel',

   'Excel format'
=> 'Excel формат',

   'Excused by instructor'
=> 'Освобожден Инструктором',

   'Exit LON-CAPA'
=> 'Покинуть LON-CAPA',

   'Extent'
=> 'Область',

   'External Resource'
=> 'Внешний Ресурс',

   'FAIL'
=> 'НЕУДАЧА',

   'Failed Access to Construction Space'
=> 'Неудача Входа в Авторское Пространствоe',

   'Failed to copy source'
=> 'Копирование источника провалилось',

   'Failed to write metadata copy'
=> 'Failed to write metadata copy',

   'False'
=> 'Ложь',

   'Feedback Addresses for Course Content'
=> 'Адреса для обратной связи по Содержанию Курса',

   'Feedback Addresses for Course Policy'
=> 'Адреса для обратной связи по Структуре Курса',

   'Feedback Addresses for Resource Content Question'
=> 'Адреса для обратной связи по Содержанию Курса',

   'Feedback Addresses for Course Content Comments'
=> 'Адреса для обратной связи по Комментариям к Содержанию Курса',

   'Field'
=> 'Поле',

   'Fielded Format'
=> 'Fielded Формат',

   'File'
=> 'Файл',

   'File Category'
=> 'Категория Файла',

   'File copied.'
=> 'Файл скопирован.',

   'Filenames in Construction Space'
=> 'Имена Файлов в Авторском Пространстве',

   'Finalize Publication'
=> 'Закончить Публикацию',

   'Finish Course Initialization'
=> 'Завершить Инициализацию курса',

   'Finish Helper'
=> 'Завершить Помощник',

   'First'
=> 'Имя',

   'First Name'
=> 'Имя',

   'First Resource'
=> 'Первый Ресурс',

   'Foil'
=> 'Foil',

   'Foils'
=> 'Foils',

   'Folder'
=> 'Папка',

   'Folder in Construction Space'
=> 'Папка в Авторском Пространстве',

   'For User'
=> 'Для Пользователя',

   'Force publication of unmodified files'
=> 'Публиковать и немодифицированные файлы',

   'Format:'
=> 'Формат:',

   'Forward'
=> 'Вперед',

   'Forwarded message from'
=> 'Пересланное сообщение от',

   'Forwarding'
=> 'Пересылка',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Найдены неанализируемые части задачи, в настоящее время поддерживаются лишь Численный, Формульный и Стринговый стили.',

   'Frequency'
=> 'Частота',

   'Fri'
=> 'Пт',

   'From'
=> 'От',

   'Full Update'
=> 'Полное Обновление',

   'Full update (also print list of users not enrolled anymore)'
=> 'Полное Обновление (со списком более не зачисленных пользователей)',

   'Functions'
=> 'Функции',

   'Generate Spreadsheet'
=> 'Генерировать Журнал',

   'Generate Statistics'
=> 'Генерировать Статистику',

   'Generate new role ...'
=> 'Генерировать новую роль ...',

   'Generation'
=> 'Поколение',

   'Getting Problem Variants'
=> 'Получение Вариантов Задачи',

   'Go Back'
=> 'Вернуться',

   'Go To My First Homework Problem'
=> 'Перейти к Первой Задаче Задания',

   'Go to the next resource in the course sequence'
=> 'Перейти к следующему ресурсу в курсовой последовательности',

   'Go to the previous resource in the course sequence'
=> 'Перейти к предыдущему ресурсу в курсовой последовательности',

   'Goodbye'
=> 'До Свидания',

   'Grades Spreadsheet'
=> 'Журнал Оценок',

   'Grading'
=> 'Способ оценки',

   'Grading Information'
=> 'Информация об Отметках',

   'Grant/revoke Course Custom Role'
=> 'Присвоить/отменить Специальную Роль для Курса',

   'Grant/revoke role of Administrator'
=> 'Присвоить/отменить роль Администратора',

   'Grant/revoke role of Author'
=> 'Присвоить/отменить роль Автора',

   'Grant/revoke role of Co-Author'
=> 'Присвоить/отменить роль Соавтора',

   'Grant/revoke role of Course Coordinator'
=> 'Присвоить/отменить роль Координатора Курса',

   'Grant/revoke role of Domain Coordinator'
=> 'Присвоить/отменить роль Координатора Домена',

   'Grant/revoke role of Domain Guest'
=> 'Присвоить/отменить роль Гостя Домена',

   'Grant/revoke role of Exam Proctor'
=> 'Присвоить/отменить роль Экзаменационного Инспектора',

   'Grant/revoke role of Instructor'
=> 'Присвоить/отменить роль Инструктора',

   'Grant/revoke role of Librarian'
=> 'Присвоить/отменить роль Библиотекаря',

   'Grant/revoke role of Bubblesheet Scanning Operator'
=> 'Grant/revoke role of Bubblesheet Scanning Operator',

   'Grant/revoke role of Student'
=> 'Присвоить/отменить роль Студента',

   'Grant/revoke role of Superuser'
=> 'Присвоить/отменить роль Сурерпользователя',

   'Grant/revoke role of Teaching Assistant'
=> 'Присвоить/отменить роль помощника преподавателя',

   'Group/Section'
=> 'Группа/Раздел',

   'HTML'
=> 'HTML',

   'HTML/XML'
=> 'HTML/XML',

   'HTML can be allowed or banned inside of course discussion.'
=> '<p>HTML может быть разрешен или запрещен в курсовых обсуждениях.</p>',

   'HTML in Discussions'
=> 'HTML в Обсуждениях',

   'Height(pixel):'
=> 'Высота(pixel):',

   'Help'
=> 'Помощь',

   'Help on Creating Courses'
=> 'Помощь в Создании Курса',

   'Helproom Hours'
=> 'Часы Работы Helproom',

   'Hide'
=> 'Спрятать',

   'Hide Empty Rows in Spreadsheets'
=> 'Прятать Пустые Строки в Электронных Таблицах',

   'Hint Text'
=> 'Hint Text',

   'Host'
=> 'Хозяин',

   'ID/Student Number'
=> 'ID/Студенчнский Номер',

   'Identify fields'
=> 'Определи поля',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'If active, the new role will be available when the students next log in to LON-CAPA.',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'If this resource is in active use, student performance data from the previous version may become inaccessible.',

   'Ignore First Line'
=> 'Игнорировать Первую Строку',

   'Illegal filename.'
=> 'Неправильное имя файла.',

   'Image:'
=> 'Изображение:',

   'Immediately expire own role as Course Coordinator'
=> 'Немедленно Закончить собственную роль Координатора Курса',

   'Import'
=> 'Импорт',

   'Import a published document'
=> 'Импортировать опубликованный документ',

   'Import and Paste Area'
=> 'Область для Импорта',

   'Include retrieval of student photographs?'
=> 'Запрашивать ли студенческие фотографии?',

   'Incorrect'
=> 'Неверно',

   'Incorrect Answers:'
=> 'Неверные Ответы:',

   'Initial Password'
=> 'Начальный Пароль',

   'Institutional Information'
=> 'Информация об Институте/Организации',

   'Instructor'
=> 'Инструктор',

   'instructor'
=> 'инструктор',

   'Instructor Information'
=> 'Информация об Инструкторе',

   'Internal Filename'
=> 'Внутреннее Имя Файла',

   'Internally authenticated'
=> 'Внутренне удостоверять подлинность',

   'Invalid characters in requested name have been removed.'
=> 'Неправильные символы в запрашиваемом имени были удалены.',

   'Invalid date entry'
=> 'Неверная дата входа',

   'Invalid home server specified'
=> 'Задан неправильный домашний сервер',

   'Invalid login mode or password.'
=> 'Неверная мода входа или пароль.',

   'Invalid username or domain'
=> 'Неверное имя пользователя или домен',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'Рекомендация использовать последнюю версию вирус сканера перед обращением с данным файлом.',

   'July'
=> 'Июль',

   'June'
=> 'Июнь',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Keep all Resources up-to-date with most recent Versions (default)',

   'Kerberos authenticated'
=> 'Kerberos authenticated',

   'Keyword(s)'
=> 'Ключевое Слово(а)',

   'Keywords'
=> 'Ключевые Слова',

   'LON-CAPA Domain for Students'
=> 'LON-CAPA Домен для Студентов',

   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA Enrollment Manager',

   'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> '<p>LON-CAPA поддерживает обсуждение в реальном времени. Данный курс получит свою собственную дискуссионную комнату. Вы можете закрыть студентам, помощникам преподавателя или инструкторам доступ в дискуссионную комнату.</p>',

   'LON-CAPA Helper:'
=> 'LON-CAPA Helper:',

   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA сохраняет обсуждения всех ресурсов, включенных в курс. По-умолчанию, всем пользователям позволяется участвовать в таких обсуждениях. <p>Если Вы желаете запретить некоторым категориям пользователей участие в подобных обсуждениях, выберите эти категории ниже. Заметим, что Ваш класс может не иметь всех данных ролей. В этом случае Вы можете игнорировать роли, не предполагаемые для использования. (Например, &quot;Exam Proctor&quot; полезен лишь для больших курсов.)</p> <p>Категории пользователей, не участвующих в обсуждениях, тем не менее могут просматривать сообщения других пользователей.</p>',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPA домен: [_1]',

   'Language'
=> 'Язык',

   'Last'
=> 'Фамилия',

   'Last Modified'
=> 'Последняя Модифицикация',

   'Last Name'
=> 'Фамилия',

   'Last Name, First Names'
=> 'Фамилия, Имя',

   'Last Week'
=> 'Последняя Неделя',

   'Last access'
=> 'Последний доступ',

   'Last accessed'
=> 'Использовано в последний раз',

   'Last modified'
=> 'В последний раз модифицированно',

   'Last updated'
=> 'В последний раз Обновлен(а)',

   'Launch Remote Control'
=> 'Стартовать Пульт Дистанционного Управления',

   'Librarian'
=> 'Библиотекарь',

   'Limit by copyright/distribution'
=> 'Ограничить авторскими правами/распространением',

   'Limit by language'
=> 'Ограничить языком',

   'List of hidden parts (hiddenparts)'
=> 'Список спрятанных частей (hiddenparts)',

   'List of possible answers'
=> 'Список возможных ответов',

   'List Directory'
=> 'Содержимое Директории',

   'Load'
=> 'Загрузить',

   'Load Map'
=> 'Загрузить Последовательность',

   'Load:'
=> 'Загрузка:',

   'Location'
=> 'Местоположение',

   'Lock and unlock assessments'
=> 'Lock and unlock assessments',

   'Log in'
=> 'Вход',

   'Logged Out'
=> 'Выход',

   'Login Data'
=> 'Данные для входа',

   'Login Type'
=> 'Тип Входа в Систему',

   'MIME Type'
=> 'MIME Тип',

   'Mail'
=> 'Почта',

   'Main Course Documents'
=> 'Главные Документы Курса',

   'Main Menu'
=> 'Главное Меню',

   'Make new directory'
=> 'Создать новую директорию',

   'Make new file'
=> 'Создать новый файл',

   'Make notes and annotations about this resource'
=> 'Сделать заметки и аннотацию этого ресурса',

   'Making Backup to'
=> 'Making Backup to',

   'Manage Access Keys'
=> 'Управление Ключами Доступа',

   'Manage access keys'
=> 'Управление ключами доступа',

   'Map'
=> 'Последовательность',

   'Map contents are not shown in order.'
=> 'Оглавление последовательности показано не по порядку.',

   'Map has branchings. Use advanced editor.'
=> 'Последовательность содержит ветвления. Используйте продвинутый редактор.',

   'Map has conditions. Use advanced editor.'
=> 'Последовательность содержит условия. Используйте продвинутый редактор.',

   'Map has resource parameters. Use advanced editor.'
=> 'Последовательность содержит параметры ресурсов. Используйте продвинутый редактор.',

   'Map has unconnected resources. Use advanced editor.'
=> 'Последовательность содержит нецоединенные ресурсы. Используйте продвинутый редактор.',

   'March'
=> 'Март',

   'Mark Unread'
=> 'Отметить Непрочитанные',

   'Material appears to be correct'
=> 'Материал верен',

   'Material covered with sufficient depth'
=> 'Материал раскрыт достаточно глубоко',

   'Material is helpful'
=> 'Материал полезен',

   'Material presented in clear way'
=> 'Материал представлен доступно',

   'Max Number Of Shown Foils:'
=> 'Максимальное Число Показанных Foils:',

   'Max Possible To Date'
=> 'Max Possible To Date',

   'Max Tries'
=> 'Max Число Попыток',

   'Max number of foils displayed'
=> 'Max number of foils displayed',

   'Maximum Number of Collaborators'
=> 'Максимальное Число Сотрудников',

   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Максимальное Число Сотрудников (maxcollaborators)',

   'Maximum Number of Tries (maxtries)'
=> 'Максимальное Число Попыток (maxtries)',

   'May'
=> 'Май',

   'Mean Tries'
=> 'Среднее Число Попыток',

   'Messaging'
=> 'Messaging',

   'Metadata'
=> 'Метаданные',

   'Metadata Information'
=> 'Информация о Метаданных',

   'Metadata Version'
=> 'Версия Метаданных',

   'Metadata current version'
=> 'Текущая версия метаданных',

   'Middle Names/Initials'
=> 'Отчество/Инициалы',

   'Middle'
=> 'Отчество',

   'Middle Name'
=> 'Отчество',

   'Mime type'
=> 'Mime тип',

   'Missing Kerberos domain information.'
=> 'Missing Kerberos domain information.',

   'Modification Date'
=> 'Дата Модификации',

   'Modified'
=> 'Модифицирован',

   'Modify Course Assessment Parameters'
=> 'Модифицировать Параметры Доступа к Курсу',

   'Modify Enrollment for'
=> 'Модифицировать Зачисление для',

   'Modify Parameters'
=> 'Изменить Параметры',

   'Modify User'
=> 'Модифицировать Пользователя',

   'Modify another students data'
=> 'Модифицировать данные других студентов',

   'Modify authentication mechanism and data for a user'
=> 'Модифицировать механизм паспознавания и данные для пользователя',

   'Modify deadlines, etc, for this assessment resource'
=> 'Modify deadlines, etc, for this assessment resource',

   'Modify grades'
=> 'Изменить оценки',

   'Modify student data'
=> 'Изменить студенческие данные',

   'Modify user grades for this assessment resource'
=> 'Modify user grades for this assessment resource',

   'Modifying data for user'
=> 'Модификация данных для пользователя',

   'Mon'
=> 'Пн',

   'Most recently published Version'
=> 'Последняя опубликованная Версия',

   'Move current file to'
=> 'Перенести текущий файл в',

   'Move Down'
=> 'Двинуться Вниз',

   'Move Up'
=> 'Двинуться Вверх',

   'My Personal Info'
=> 'Моя Персональная Информация',

   'Name'
=> 'Имя',

   'Name starting with'
=> 'Имя начиная с',

   'Name:'
=> 'Имя:',

   'Name of Role'
=> 'Имя Роли',

   'Navigate Contents'
=> 'Navigate Contents',

   'Navigate Course Contents'
=> 'Содержание Курса',

   'Navigate the table of contents for this course'
=> 'Navigate the table of contents for this course',

   'Network-wide number of accesses (hits)'
=> 'Число доступов в сети (нажатий)',

   'Network-wide number of courses using resource'
=> 'Число курсов в сети, использующих ресурс',

   'New Directory'
=> 'Новая Директория',

   'New Folder'
=> 'Новая Папка',

   'New Messages'
=> 'Новые Сообщения',

   'New Problem Variation'
=> 'Новая Вариация Задачи',

   'New Randomization'
=> 'Новая Рэндомизация',

   'New Resource'
=> 'Новый Ресурс',

   'New Role'
=> 'Новая Роль',

   'New Search'
=> 'Новый Поиск',

   'New Title'
=> 'Новое Название',

   'New User'
=> 'Новый Пользователь',

   'New Value'
=> 'Новое Значение',

   'New assembled page'
=> 'Новая собранная страница',

   'New assembled sequence'
=> 'Новая собранная последовательность',

   'New custom rights file'
=> 'Новый файл с правами',

   'New discussion since'
=> 'Новое обсуждение с',

   'New file'
=> 'Новый файл',

   'New HTML file'
=> 'Новый HTML файл',

   'New parameters or saved values'
=> 'Новые параметры ипи сохраненные значения',

   'New problem'
=> 'Новая задача',

   'New style file'
=> 'Новый стилевой файл',

   'New subdirectory'
=> 'Новая поддиректория',

   'Next'
=> 'Далее',

   'Next ->'
=> 'Далее ->',

   'Next Month'
=> 'Следующий Месяц',

   'No'
=> 'Нет',

   'No Kerberos domain was specified.'
=> 'Kerberos домен не задан.',

   'No Role, Cumulative Privileges'
=> 'Роли нет, Совокупные Привилегии',

   'No changes were made to the current settings.'
=> 'Отсутствуют изменения в текущих установках.',

   'No content modifications yet.'
=> 'Изменения в содержании отсутствуют.',

   'No due date'
=> 'Нет даты сдачи',

   'No language preference'
=> 'Нет языковых предпочтений',

   'No new filename specified.'
=> 'Новое имя файла не задано.',

   'No previous versions published.'
=> 'Нет предыдущих опубликованных версий.',

   'No role specified'
=> 'Роль не определена',

   'No section assigned'
=> 'Раздел не задан',

   'No such file'
=> 'Нет такого файла',

   'No upload file specified.'
=> 'Обновляемый файл не задан.',

   'No write permission to'
=> 'No write permission to',

   'No write permission to user directory, FAIL'
=> 'No write permission to user directory, FAIL',

   'None Found'
=> 'Ничего не найдено',

   'Not Allowed'
=> 'Не Позволено',

   'Not shown, not used'
=> 'Не показан, не использован',

   'Note: for large courses, this operation may be time consuming'
=> 'Замечание: для больших курсов данная операция весьма длительна',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Note: it can take up to 10 minutes for changes to take effect for all users.',

   'Note: this will not take effect if the user already exists'
=> 'Замечание: это не будет действовать если пользователь уже существует',

   'Notes'
=> 'Заметки',

   'Notification of enrollment changes'
=> 'Notification of enrollment changes',

   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?',

   'November'
=> 'Ноябрь',

   'Number of assignments printed at the same time:'
=> 'Число студенческих заданий, печатаемых одновременно:',

   'Number of bubbles in exam mode (numbubbles)'
=> 'Число вопросов в экзаменационной моде (numbubbles)',

   'Number of Plots:'
=> 'Число Графиков:',

   'Number of columns'
=> 'Число столбцов',

   'Number of resources that follow this resource in maps'
=> 'Число ресурсов следующих в последовательностях за данным',

   'Number of resources that lead up to this resource in maps'
=> 'Число ресурсов в последовательностях перед данным',

   'Number of resources using or importing resource'
=> 'Число ресурсов использующих или импортирующих ресурсы',

   'Number of Tries before hints appear (hinttries)'
=> 'Число Попыток до появления подсказки (hinttries)',

   'Numerical Tolerance (tol)'
=> 'Допустимая Численная Ошибка (tol)',

   'Obsolete'
=> 'Устаревший',

   'Obsolete parameters or saved values'
=> 'Устаревшие параметры или сохраненные значения',

   'October'
=> 'Октябрь',

   'Office Hours'
=> 'Часы Приема Студентов',

   'Old Value'
=> 'Старое Значение',

   'One particular problem (overrides folder and course defaults)'
=> 'Одна определенная задача (переопределяет заданные для курса или папки по-умолчанию)',

   'Only domain coordinators can change a users password.'
=> 'Только координатор домена может изменить пароли пользователей',

   'Only a number required.'
=> 'Только число допустимо.',

   'Open'
=> 'Открыть',

   'Open Course'
=> 'Открыть Курс',

   'Open all assessments'
=> 'Открыть все задания',

   'Open All Folders'
=> 'Открыть Все Папки',

   'Open, no due date'
=> 'Открыт, дата сдачи отсутствует',

   'Opening Date (contentopen)'
=> 'Дата Открытия Содержимого (contentopen)',

   'Opening Date (opendate)'
=> 'Дата Открытия (opendate)',

   'Option Response Problem Analysis'
=> 'Option Response Problem Analysis',

   'Option response'
=> 'Option response',

   'Output'
=> 'Вывод',

   'Output Format'
=> 'Формат Вывода',

   'Overall Problem Statistics'
=> 'Общая Статистика по Задаче',

   'Owner/Publisher'
=> 'Владелец/Издатель',

   'Page'
=> 'Страница',

   'Page layout'
=> 'Страница', # 'Разметка страницы',

   'Parameter Name'
=> 'Имя Параметра',

   'Parameter Type'
=> 'Тип Параметра',

   'Parameter in Effect'
=> 'Действующий Параметр',

   'Parent Directory'
=> 'Родительская Директория',

   'Part'
=> 'Часть',

   'Part Description (display)'
=> 'Описание Части (display)',

   'Part is not open to be viewed. It'
=> 'Часть не открыта для просмотра. Она',

   'Paste after selected'
=> 'Вставить после выбора',

   'Password'
=> 'Пароль',

   'Path'
=> 'Путь',

   'Per Page'
=> 'На Страницу',

   'Personal Data'
=> 'Персональные Данные',

   'Personal Information'
=> 'Персональная Информация',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process',

   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Пожалуйста обратитесь к Вашемы LON-CAPA администратору относительно данной ситуации.',

   'Please do not reply to this address.'
=> 'Пожалуйста не отвечайте по этому адресу.',

   'Please either'
=> 'Пожалуйста введите',

   'Please notify the server administrator '
=> 'Пожалуйста сообщите администратору сервера ',

   'Please pick a version to retrieve'
=> 'Пожалуйста выберите версию',

   'Please select a problem to analyze'
=> 'Выберите задачу для анализа',

   'Please select a report to generate'
=> 'Выберите генерируемый отчет',

   'Please select an authentication mechanism'
=> 'Please select an authentication mechanism',

   'Please select the authentication mechanism'
=> 'Please select the authentication mechanism',

   'Please select the section you wish to set the answer open date for:'
=> 'Выберите раздел, для которого Вы задаете дату показа ответов',

   'Please select the section you wish to set the due date for:'
=> 'Выберите раздел, для которого Вы задаете дату сдачи',

   'Please select the section you wish to set the number of tries for:'
=> 'Выберите раздел/папку, для которой Вы задаете число попыток',

   'Please select the section you wish to set the opening date for:'
=> 'Выберите раздел, для которого Вы задаете дату доступа к задаче',

   'Please select the section you wish to set the problem weight for:'
=> 'Выберите раздел, для которого Вы задаете вес задачи',

   'Please select the student you wish to set the answer open date for:'
=> 'Выберите студента, для которого Вы задаете дату показа ответов',

   'Please select the student you wish to set the due date for:'
=> 'Выберите студента, для которого Вы задаете дату сдачи',

   'Please select the student you wish to set the number of tries for:'
=> 'Выберите студента, для которого Вы задаете число попыток',

   'Please select the student you wish to set the opening date for:'
=> 'Выберите студента, для которого Вы задаете дату доступа к задаче',

   'Please select the student you wish to set the problem weight for:'
=> 'Выберите студента, для которого Вы задаете вес задачи',

   'Please use browser "Back" button and pick a filename'
=> 'Please use browser "Back" button and pick a filename',

   'Position'
=> 'Позиция',

   'Post anonymously'
=> 'Post anonymously',

   'Post discussion on course resources'
=> 'Post discussion on course resources',

   'Post system frontpage announcements'
=> 'Post system frontpage announcements',

   'Post to live chatrooms'
=> 'Post to live chatrooms',

   'Preferred language'
=> 'Предпочитаемый язык',

   'Prepare a printable document'
=> 'Prepare a printable document',

   'Preparing Excel Spreadsheet'
=> 'Подготовка Журнала в Excel',

   'Prerequisites'
=> 'Пререквизиты',

   'Previous'
=> 'Предыдущий',

   'Previous Month'
=> 'Предыдущий Месяц',

   'Print'
=> 'Печатать',

   'Printing Helper'
=> 'Печать Ресурсов',

   'Privacy Note'
=> 'Privacy Note',

   'Private - visible to author only for testing purposes'
=> 'Private - visible to author only for testing purposes',

   'Private Publication - did not synchronize database'
=> 'Private Publication - did not synchronize database',

   'Privileged users that should not be hidden on staff listings'
=> 'Пользователи с привелегиями, которые не должны быть скрыты в списках сотрудников',

   'Problem Status Chart'
=> 'Problem Status Chart',

   'Problems'
=> 'Задачи',

   'Problems Not Contained In A Folder'
=> 'Problems Not Contained In A Folder',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.',

   'Processed file'
=> 'Processed file',

   'Processed [_1] student(s).'
=> 'Processed [_1] student(s).',

   'Processing'
=> 'Processing',

   'Processing course structure'
=> 'Processing course structure',

   'Processing first student'
=> 'Processing first student',

   'Produce Excel Output'
=> 'Produce Excel Output',

   'Project Information'
=> 'Информация о проекте',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Provide feedback messages or contribute to the course discussion about this resource',

   'Provide my evaluation of this resource'
=> 'Provide my evaluation of this resource',

   'Public - no authentication or authorization required for use'
=> 'Public - no authentication or authorization required for use',

   'Publish'
=> 'Опубликовать',

   'Publish Directory'
=> 'Опубликовать Директорию',

   'Publish Directory and Sub Directories'
=> 'Опубликовать Директорию с поддиректориями',

   'Publish this Resource'
=> 'Опубликовать этот Ресурс',

   'Published'
=> 'Опубликовано',

   'Publisher/Owner'
=> 'Издатель/Владелец',

   'Publishing'
=> 'Публикация',

   'Question Text'
=> 'Текст Вопроса',

   'Question Type'
=> 'Вид Вопроса',

   'Question Type (type)'
=> 'Вид Вопроса (type)',

   'Quick Completed Problems Display'
=> 'Quick Completed Problems Display',

   'Random position'
=> 'Случайная позиция',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)',

   'Randomly pick number of resources (randompick)'
=> 'Randomly pick number of resources (randompick)',

   'Re'
=> 'Re',

   'Re-Initialize'
=> 'Реинициализировать',

   'Re-enrollment will re-activate data.'
=> 'Re-enrollment will re-activate data.',

   'Reading results from'
=> 'Чтение результатов из',

   'Readings'
=> 'Чтение',

   'Receipt algorithm used'
=> 'Алгоритм использованный для подтверждения приема',

   'Record'
=> 'Запись',

   'Registering'
=> 'Регистрация',

   'Related'
=> 'Относящиеся к делу',

   'Remark'
=> 'Замечания',

   'Rename'
=> 'Переименовать',

   'Rename current file to'
=> 'Переименовать текущий файл на',

   'Reply'
=> 'Отвечать',

   'Reset Submissions'
=> 'Reset Submissions',

   'Resource alias name for conditions (mapalias)'
=> 'Имя ресурса для использования в условиях (mapalias)',

   'Resource Differences'
=> 'Различия в ресурсах',

   'Resource Feedback and Discussion'
=> 'Resource Feedback and Discussion',

   'Resource Level'
=> 'Уровень Ресурсов',

   'Resource Publication'
=> 'Публикация Ресурса',

   'Resource is technically correct'
=> 'Ресурс технически правилен',

   'Resources'
=> 'Ресурсы',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> 'Запрос старой версии уничтожит текущую версию в авторском пространстве',

   'Retrieve'
=> 'Запросить',

   'Retrieve Published Resources'
=> 'Запросить Опубликованные Ресурсы',

   'Retrieve previous versions of'
=> 'Запросить предыдущие версии',

   'Retrieve Old Version'
=> 'Запросить Старую Версию',

   'Retrieve version'
=> 'Запросить версию',

   'Return to Last Location'
=> 'Return to Last Location',

   'Reverse Association'
=> 'Reverse Association',

   'Revert to Last Saved'
=> 'Revert to Last Saved',

   'Revoke'
=> 'Отменить',

   'Revoke Existing Roles'
=> 'Отменить Существующую Роль',

   'Revision Date'
=> 'Дата Ревизии',

   'Role'
=> 'Роль',

   'role,role,...'
=> 'роль,роль,...',

   'Role Information'
=> 'Информация о Роли',

   'Row'
=> 'Строка',

   'Rule'
=> 'Правило',

   'S.D. tries'
=> 'S.D. попыток',

   'Samples'
=> 'Образцы',

   'Sat'
=> 'Сб',

   'Save'
=> 'Сохранить',

   'Save as'
=> 'Сохранить как',

   'Save as & Make This Sheet the Default'
=> 'Save as & Make This Sheet the Default',

   'Save as ...'
=> 'Сохранить как ...',

   'Saving Modifications to'
=> 'Сохранение модификаций к',

   'Bubblesheet Scanning Operator'
=> 'Bubblesheet Scanning Operator',

   'Score Upload Form'
=> 'Score Upload Form',

   'Search'
=> 'Поиск',

   'Search Complete'
=> 'Поиск Завершен',

   'Search the contents of this course'
=> 'Search the contents of this course',

   'Search the database of published resources'
=> 'Поиск в базе данных опубликованных ресурсов',

   'Searching'
=> 'Поиск',

   'Section'
=> 'Раздел',

   'Section/Group'
=> 'Раздел/Группа',

   'Sections'
=> 'Разделы',

   'Select'
=> 'Выбрать',

   'Select Action'
=> 'Выберите действие',

   'Select All'
=> 'Выбрать Все',

   'Select All Files'
=> 'Выбрать Все Файлы',

   'Select All Published'
=> 'Выбрать Все Опубликованное',

   'Select All Students'
=> 'Выбрать Всех Студентов',

   'Select Course'
=> 'Выбрать Курс',

   'Select Date'
=> 'Выбрать Дату',

   'Select Enclosing Map or Folder'
=> 'Выбрать Главную Последовательность или Папку',

   'Select Folder'
=> 'Выбор Папки',

   'Select Map'
=> 'Выберите Последовательность',

   'Select Only Current Students'
=> 'Выбрать Только Реальных Студентов',

   'Select Parameter Level'
=> 'Выбрать Уровень Параметров',

   'Select Problem'
=> 'Выбор Задачи',

   'Select Problem(s) to print'
=> 'Выберите Задачу(и) для Печати',

   'Select Printing Options:'
=> 'Выбор печати:',

   'Select Spreadsheet File'
=> 'Выбор Файла Журнала',

   'Select User'
=> 'Выбрать Пользователя',

   'Select a'
=> 'Выберите',

   'Select a course'
=> 'Выберите курс',

   'Select a user name to modify the students information'
=> 'Выбери имя студента для изменения информации о нем',

   'Select a user name to view the users personal page.'
=> 'Выбери имя пользователя для просмотра его персональной страницы.',

   'Select for Section/Group'
=> 'Выбрать для Раздела/Группы',

   'Select the Construction Space'
=> 'Ваберите Авторское Пространство',

   'Select the folder you wish to set the parameter for:'
=> 'Выберите папку, для которой Вы хототе задать параметры:',

   'Select the problem you wish to set the parameter for:'
=> 'Выберите задачу, для которой Вы хотите задать параметры:',

   'Selecting a User'
=> 'Выбор Пользователя',

   'Send Message to User(s)'
=> 'Послать Сообщение Пользователю(ям)',

   'Send New'
=> 'Послать Новый',

   'Send Reply'
=> 'Послать Ответ',

   'Send bubblesheet data to a course'
=> 'Send bubblesheet data to a course',

   'Send and receive messages'
=> 'Послать и получить сообщения',

   'Send as critical message'
=> 'Послать как критическое сообщение',

   'Send broadcast and receipt-required email'
=> 'Send broadcast and receipt-required email',

   'Send internal email'
=> 'Послать внутренний email',

   'September'
=> 'Сентябрь',

   'Sequence'
=> 'Последовательность',

   'Sequence or Folder'
=> 'Последовательность или Папка',

   'Sequences and Folders'
=> 'Последовательности и Папки',

   'Server'
=> 'Сервер',

   'Server Administration'
=> 'Администрация Сервера',

   'Set Course Environment Parameters'
=> 'Задать Параметры Окружения Курса',

   'Set Date'
=> 'Задать Дату',

   'Set Defaults for All Resources in Course'
=> 'Задать Значения По умолчанию для Всех Ресурсов Курса',

   'Set End Date'
=> 'Задать Конечную Дату',

   'Set Problem Tries'
=> 'Задание Числа Попыток',

   'Set Problem Weight'
=> 'Задание Веса Задачи',

   'Set Start Date'
=> 'Задать Начальную Дату',

   'Set value to "[_1]" to allow'
=> 'Задать значение "[_1]" чтобы разрешить',

   'Set Version to be used in Course'
=> 'Задать Версию используемую в Курсе',

   'Set Versions to be used in Course according to Selections below'
=> 'Задать Версии, использованные в Курсе согласно Выбору ниже',

   'Set content feedback to Course Coordinator'
=> 'Set content feedback to Course Coordinator',

   'Set course policy feedback to Course Coordinator'
=> 'Set course policy feedback to Course Coordinator',

   'Set a bookmark for this resource'
=> 'Установить закладку для этого ресурса',

   'Set a due date'
=> 'Задать <b>дату сдачи</b>',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Set all Resource Versions to current Version (Fix Versions)',

   'Set an answer open date'
=> 'Задать <b>дату показа ответов</b>',

   'Set an open date'
=> 'Задать <b>дату открытия</b>',

   'Set answer open date for all problems in the course for ...'
=> 'Задать дату показа ответов для всех задач курса для ...',

   'Set answer open date for the selected folder for ...'
=> 'Задать дату показа ответов для выбранной папки для ...',

   'Set answer open date for the selected problem for ...'
=> 'Задать дату показа ответов для выбранной задачи для ...',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'Set deadlines and other assessment parameters, as well as modify course environment',

   'Set due date for all problems in the course for ...'
=> 'Задать дату сдачи для всех задач курса для ...',

   'Set due date for the selected folder for ...'
=> 'Задать дату сдачи для выбранной папки для ...',

   'Set due date for the selected problem for ...'
=> 'Задать дату сдачи для выбранной задачи для ...',

   'Set my user preferences'
=> 'Задать мои пользовательские привилегии',

   'Set number of tries for all problems in the course for ...'
=> 'Задать число попыток для всех задач курса для ...',

   'Set number of tries for the selected folder for ...'
=> 'Задать число попыток для заданной папки',

   'Set number of tries for the selected problem for ...'
=> 'Задать число попыток для заданной задачи для ...',

   'Set opening date for all problems in the course for ...'
=> 'Задать дату открытия для всех задач в курсе для . . .',

   'Set opening date for the selected folder for ...'
=> 'Задать дату открытия для выбранной задачи для ...',

   'Set opening date for the selected problem for ...'
=> 'Задать дату открытия для выбранной папки для ...',

   'Set problem weight for all problems in the course for ...'
=> 'Задать вес для всех задач курса для ...',

   'Set problem weight for the selected folder for ...'
=> 'Задать вес для задач из выбранной папки для ...',

   'Set problem weight for the selected problem for ...'
=> 'Задать вес для задач из выбранной задачи для ...',

   'Set the number of tries'
=> 'Задать <b>число попыток</b>',

   'Set the problem weight'
=> 'Задать <b>вес задачи</b>',

   'Set/Modify Course Assessment Parameter'
=> 'Задать/Модифицировать Параметры Доступа к Курсу',

   'Set/Modify Course Assessment Parameters'
=> 'Set/Modify Course Assessment Parameters',

   'Set/Modify Course Parameters'
=> 'Задать/Модифицировать Параметры Курса',

   'Setting the [_1]'
=> 'Измение параметра [_1]',

   'Setting the [_1] to [_2]'
=> 'Измение параметра [_1] на [_2]',

   'Shared by course faculty and staff'
=> 'Shared by course faculty and staff',

   'Short string response'
=> 'Short string response',

   'Show More Options'
=> 'Показать Больше Опций',

   'Show Only Uncompleted Homework'
=> 'Показать Только Незавершенные Задания',

   'Show Preview'
=> 'Show Preview',

   'Show Problem Completeness'
=> 'Show Problem Completeness',

   'Show Problem Status (problemstatus)'
=> 'Показать Статус Задачи (problemstatus)',

   'Show all roles'
=> 'Показать Все Роли',

   'Show always at bottom position'
=> 'Всегда показывать снизу',

   'Show always at top position'
=> 'Всегда показывать сверху',

   'Show catalog information'
=> 'Show catalog information',

   'Show resource'
=> 'Показать Ресурс',

   'Show Units - Disable Entry (turnoffunit)'
=> 'Show Units - Disable Entry (turnoffunit)',

   'Significant Digits (sig)'
=> 'Значимые Цифры (sig)',

   'Significant figures are incorrect, submission was not graded.'
=> 'Significant figures are incorrect, submission was not graded.',

   'Simple Edit'
=> 'Простое Редактирование',

   'Simple Page'
=> 'Простая Страница',

   'Simple Problem'
=> 'Простая Задача',

   'Simple Problem Editor'
=> 'Редактор Простых Задач',

   'Since Start of Course'
=> 'С Момента Открытия Курса',

   'Since Yesterday'
=> 'Со Вчерашнего Дня',

   'Size'
=> 'Размер',

   'Size:'
=> 'Размер:',

   'Skew Tries'
=> 'Неверных Попыток',

   'Some parts were not submitted.'
=> 'Some parts were not submitted.',

   'Space separated'
=> 'Разделенные Пробелом',

   'Special Documents'
=> 'Специальные Документы',

   'Special documents'
=> 'Специальные документы',

   'Spreadsheet Computation'
=> 'Расчет Журнала',

   'Spreadsheet Computation Status'
=> 'Статус Расчета Журнала',

   'Start'
=> 'Начало',

   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Задание каждого студента стартовать с новой страницы/столбца",

   'Start Time'
=> 'Начальное Время',

   'Starting'
=> 'Начало',

   'Starting and Ending Dates'
=> 'Начальные и Конечные Даты',

   'Starting Date'
=> 'Начальная Дата',

   'Statistics'
=> 'Статистика',

   'Statistics and Problem Analysis'
=> 'Статистика и Анализ Задачи',

   'Status'
=> 'Статус',

   'Save Catalog Information'
=> 'Save Catalog Information',

   'Save Changes'
=> 'Сохранить Изменения',

   'Save uploaded file as '
=> 'Save uploaded file as ',

   'Student'
=> 'Студент',

   'student'
=> 'студент',

   'Student ID'
=> 'ID Студента',

   'Student Information'
=> 'Информация о Студенте',

   'Student information updated successfully.'
=> 'Информация о студенте обновлена успешно.',

   'Student Data Compilation Progress'
=> 'Student Data Compilation Progress',

   'Student Data Compilation Status'
=> 'Student Data Compilation Status',

   'Student Name'
=> 'Имя студента',

   'Student Number'
=> 'Студенческий Номер',

   'Student Status'
=> 'Статус Студента',

   'Student level sheet'
=> 'Student level sheet',

   'Student performance statistics on all problems.'
=> 'Успеваемость студента по всем задачам.',

   'Students Affected'
=> 'Для Студентов',

   'Students need access key to enter course'
=> 'Студенты для входа в курс должны иметь ключ доступа',

   'Students with expired roles'
=> 'Студенты с устекшими ролями',

   'Subject'
=> 'Предмет',

   'Subject:'
=> 'Предмет:',

   'Submission Time Analysis'
=> 'Анализ Времен Отсылок',

   'Submit'
=> 'Послать',

   'Submit Answer'
=> 'Послать Ответ',

   'Submit Changes'
=> 'Послать Изменения',

   'Submit Changes and Edit'
=> 'Послать Изменения и Редактировать',

   'Submit Changes and View'
=> 'Послать Изменения и Посмотреть',

   'Submit Modifications'
=> 'Послать Изменения',

   'Successful Login'
=> 'Успешный Вход в Систему',

   'Suggested Replacement for Obsolete File'
=> 'Предполагаемая Замена Устаревшего Файла',

   'Summary'
=> 'Резюме',

   'Summary View'
=> 'Summary View',

   'Sun'
=> 'Вс',

   'Supplemental Course Documents'
=> 'Дополнительные Документы Курса',

   'Switch Server'
=> 'Смените Сервер',

   'Switch to another course'
=> 'Переключиться на другой курс',

   'Switch to another user role'
=> 'Переключиться на другую роль',

   'Switching Role'
=> 'Переключение Роли',

   'Syllabus'
=> 'Учебный План',

   'Synchronized SQL metadata database'
=> 'Синхронизованная SQL база метаданных',

   'System'
=> 'Система',

   'System Administration'
=> 'Системное Администрирование',

   'System Level'
=> 'Системный Уровень',

   'System wide - can be used for any courses system wide'
=> 'System wide - can be used for any courses system wide',

   'System wide - open source to all authors'
=> 'System wide - open source to all authors',

   'Tabulator separated'
=> 'Разделенные Табулятором',

   'Target'
=> 'Цель',

   'Target Edit Map'
=> 'Цель - Редактируемая Последовательность',

   'Task'
=> 'Задача',

   'TeXWidth(mm):'
=> 'TeXWidth(mm):',

   'Teaching Assistant'
=> 'Помощник Преподавателя',

   'Template'
=> 'Шаблон',

   'Temporary Assembly Workspace'
=> 'Временное Сборочное Рабочее Пространство',

   'Text'
=> 'Текст',

   'Text Block'
=> 'Текстовый Блок',

   'Textbook'
=> 'Учебник',

   'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.'
=> '&quot;Описание Курса&quot; является именем курса, под которым он будет виден студентами. Вы можете модифицировать сейчас Описание Курса и нажать <nobr>&quot;<b>Далее -&gt;</b>&quot;</nobr> для продолжения.<br />',

   'The error reported was'
=> 'The error reported was',

   'The extension on this file'
=> 'Расширение данного файла',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'The filetype extension of the file you uploaded is not allowed.',


   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.',

   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists.",

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.',

   'The optional email address field was not specified.'
=> 'The optional email address field was not specified.',

   'The optional name field was not specified.'
=> 'The optional name field was not specified.',

   'The optional section or group field was not specified.'
=> 'The optional section or group field was not specified.',

   'The optional student number field was not specified.'
=> 'Необязательный студенческий номер не был задан.',

   'The student must log out and log in again to see these changes.'
=> 'Студент должен выйти из системы и войти вновь чтобы видеть эти изменения.',

   'The submitted answer was too long.'
=> 'Посланный ответ был слишком длинным.',

   'The target is an existing directory.'
=> 'Цель - сыществующая директория.',

   'Then'
=> 'Затем',

   'There are currently no results'
=> 'В данный момент результатов нет',

   'There are no students currently enrolled.'
=> 'в данный момент зачисленных студентов нет.',

   'There is no student data for this problem.'
=> 'Студенческие данные для этой задачи отсутствуют.',

   'There was an error determining the environment values for'
=> 'There was an error determining the environment values for',

   'This controls how receipt numbers are generated.'
=> 'Контролирует каким способом генерируются номера расписок в получении.',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> '<p>Данная система поможет Вам <b>задать время доступа, сдачи, и открытия ответов задач</b>, а также <b>задать число попыток отосланных решений</b>.</p><p> Вам будет задан вопросы <b>"Для каких задач Вы желаете задать параметры?"</b>, <b>"Какой параметер Вы хотите задать?"</b>, <b>"Для кого Вы задаете/изменяете параметр?"</b>. По окончании работы системы Вам будет показано место задания этих параметров в более развитом (продвинутом) интерфейсе, так что Вы сможете задавать/изменять параметры непосредственно.</p> <p>Нажмите <b>Далее -&gt;</b> чтобы начать, или выберите <b>&lt;- Назад</b> для возврата к предыдущему экрану.</p>',

   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'Данная система поможет Вам задать окружение курса и выбрать какие его характеристики будут активизированы.',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'Это сообщение, автоматически сгенерированное LON-CAPA системой.',

   'This question expects a numeric answer.'
=> 'Этот вопрос предполагает численный ответ.',

   'This resource has been marked obsolete by the author(s)'
=> 'Этот ресурс был отмечен устаревшим автором',

   'This syllabus can be publicly viewed at'
=> 'Этот учебный план доступен для всех по адресу',

   'Threaded View'
=> 'Threaded View',

   'Thu'
=> 'Чт',

   'Time'
=> 'Время',

   'Title'
=> 'Название',

   'To'
=> 'To',

   'Topic'
=> 'Тема',

   'Total'
=> 'Суммарный',

   'Total Parts In Course'
=> 'Полное Число Частей в Курсе',

   'Total number of records found in file: [_1].'
=> 'Полное число записей в файле: [_1].',

   'Total number of students who have worked on this problem'
=> 'Число студентов, работавших над этой задачей',

   'Tries'
=> 'Попыток',

   'True'
=> 'Истина',

   'Tue'
=> 'Вт',

   'Type'
=> 'Тип',

   'Type in value'
=> 'Type in value',

   'Type Name Here'
=> 'Напечатайте Имя Здесь',

   'UNIX authenticated'
=> 'UNIX authenticated',

   'URL'
=> 'URL',

   'URLs To Include in Syllabus'
=> 'URLs включенные в учебный план',

   'USERS'
=> 'ПОЛЬЗОВАТЕЛИ',

   'Unable to connect to database!'
=> 'Нет соединения с базой данных!',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Unable to determine if this resource is open due to network problems. Please try again later.',

   'Unable to enroll'
=> 'Невозможно зачислить',

   'Unable to enroll students'
=> 'Студента невозможно зачислить',

   'Unable to find'
=> 'Невозможно найти',

   'Unable to make backup'
=> 'Unable to make backup',

   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Невозможно опубликовать файл, он содержит повторяемые ID(s), ID(s) должны быть уникальны. Повторяемые ID(s):',

   'Unable to retrieve environment data for'
=> 'Unable to retrieve environment data for',

   'Unable to set default dates for course'
=> 'Невозможно задать даты по умолчанию для данного курса',

   'Unable to understand formula'
=> 'Невозможно понять формулу',

   'Unable to undo, unable to switch'
=> 'Unable to undo, unable to switch',

   'Unable to write to'
=> 'Невозможно записать в',

   'Unavailable course'
=> 'Недоступный курс',

   'Uncheck All'
=> 'Отменить Выбор Всего',

   'Uncompleted Homework'
=> 'Незавершенное Домашнее Задание',

   'Undid changes, Switched'
=> 'Undid changes, Switched',

   'Unit:'
=> 'Единица Измерения:',

   'Units incorrect.'
=> 'Неверные Единицы Измерения.',

   'Units required'
=> 'Требуются Единицы Измерения',

   'Unknown Action'
=> 'Неизвестное Действие',

   'Unknown ID'
=> 'Неизвестное ID',

   'Unknown message'
=> 'Неизвестное Сообщение',

   'Unknown user'
=> 'Неизвестный Пользователь',

   'Unpublished'
=> 'Неопубликовано',

   'Unselect All'
=> 'Отменить Выбор Всего',

   'Unselect All Files'
=> 'Отменить Выбор Всех Файлов',

   'Unselect All Published'
=> 'Отменить Выбор Всего Опубликованного',

   'Unselect All Students'
=> 'Отменить Выбор Всех Студентов',

   'Unselect All Resources'
=> 'Отменить Выбор Всех Ресурсов',

   'Unselect for Section/Group'
=> 'Отменить Выбор для Раздела/Группы',

   'Unsuccessful Login'
=> 'Неуспешный Login',

   'Unsupported character combination'
=> 'Неподдерживаемая комбинация символов',

   'Up'
=> 'Вверх',

   'Update Course Assessment Parameter Display'
=> 'Обновить Выдачу Курсовых Параметров',

   'Update Display'
=> 'Обновить Выдачу',

   'Update Section or Specific User'
=> 'Обновить Раздел или Пользователя',

   'Update Student Data'
=> 'Обновить Студенческие Данные',

   'Updating discussion time'
=> 'Обновление Времени Обсуждения',

   'Upload Document'
=> 'Обновить Документ',

   'Upload bubblesheet data'
=> 'Обновить bubblesheet данные',

   'Upload a Photo'
=> 'Обновить Фотографию',

   'Upload a new main course document'
=> 'Обновить новый главный документ курса',

   'Upload a new supplemental course document'
=> 'Обновить новый вспомогательный документ курса',

   'Upload file'
=> 'Обновить файл',

   'Uploaded'
=> 'Обновлено',

   'Uploaded Document'
=> 'Обновленный Документ',

   'Uploading Class List'
=> 'Обновление Списка Студентов Класса',

   'Use or edit my bookmark collection'
=> 'Использовать/Редактировать мою коллекцию закладок',

   'User'
=> 'Пользователь',

   'User Load'
=> 'User Load',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'User Notes, Records of Face-to-Face Discussions, and Critical Messages',

   'User Role'
=> 'Роль Пользователя',

   'User Roles'
=> 'Роли Пользователя',

   'Username'
=> 'Имя Пользователя',

   'Users with Roles Assigned by'
=> 'Пользователи с ролями, приписанными ',

   'Value'
=> 'Значение',

   'Verify Content'
=> 'Просмотр Содержания',

   'Verify Course Documents'
=> 'Проверка Документов Курса',

   'Verify Selection'
=> 'Подтвердите Выбор',

   'Version'
=> 'Версия',

   'Version Number'
=> 'Номер Версии',

   'Version changes since Yesterday'
=> 'Версия изменена со Вчерашнего дня',

   'Version changes since last Month'
=> 'Версия изменена с прошлого Месяца',

   'Version changes since last Week'
=> 'Версия изменена с прошлой Недели',

   'Version changes since start of Course'
=> 'Версия изменена с начала Открытия Курса',

   'Version used in Course'
=> 'Версия, Использованная В Курсе',

   'View'
=> 'Посмотреть',

   'View All Messages'
=> 'Посмотреть Все Сообщения',

   'View Class List'
=> 'Посмотреть Список Класса',

   'View Critical Messages'
=> 'Посмотреть Критические Сообщения',

   'View Published Version'
=> 'Просмотреть Опубликованную Версию',

   'View course assessment statistics'
=> 'View course assessment statistics',

   'View documents included in this course'
=> 'Просмотреть документы, включенные в курс',

   'View file'
=> 'Просмотреть файл',

   'View the course assessment progress chart'
=> 'View the course assessment progress chart',

   'View user submissions for this assessment resource'
=> 'View user submissions for this assessment resource',

   'Warning!'
=> 'Предупреждение!',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'ПРЕДУПРЕЖДЕНИЕ: Таблица метаданных отсутствует в LON-CAPA базе данных.',

   'Warning: change of MIME type!'
=> 'Предупреждение: изменение MIME типа!',

   'Warning: target file exists!'
=> 'Предупреждение: целевой файл существует!',

   'Warning: target file exists, and has been published!'
=> 'Предупреждение: целевой файл существует и был опубликован!',

   'Was due'
=> 'Was due',

   'Web Links'
=> 'Web Links',

   'Web References'
=> 'Web References',

   'Wed'
=> 'Ср',

   'Weight (weight)'
=> 'Вес (weight)',

   'Welcome'
=> 'Приветствуем',

   'Welcome to the Assignment Parameter Helper'
=> 'Вас Приветствует Помощник Задания Параметров',

   'Welcome to the Learning[_1]Online[_2] Network with CAPA. Please wait while your session is being set up'
=> 'Welcome to the Learning[_1]Online[_2] Network with CAPA. Please wait while your session is being set up',

   'Welcome to Your New LON-CAPA Course'
=> 'Вас Приветствует Помощник Задания Структуры Курса',

   'What parameter do you want to set for all problems in the course?'
=> 'Какой параметр Вы хототе установить для всех задач курса?',

   'What parameter do you want to set for the selected folder?'
=> 'Какой параметр Вы хототе установить для выбранной папки?',

   'What parameter do you want to set for the selected problem?'
=> 'Какой параметр Вы хототе установить для выбранной задачи?',

   'What should the opening date be set to?'
=> 'Какова дата открытия? <br /><br />',

   'What should the due date be set to?'
=> 'Какова дата сдачи? <br /><br />',

   'What should the answer open date be set to?'
=> 'Какова дата открытия ответов для показа? <br /><br />',

   'What weight should be set for all problems in the course?'
=> 'Какой вес должен быть приписан каждой задаче курса?<br /></br > ',

   'What weight should be set for the selected folder?'
=> 'Какой вес должен быть приписан выбранной папке?<br /></br >',

   'What weight should be set for the selected problem?'
=> 'Какой вес должен быть приписан выбранной задаче?<br /></br >',

   'Which Problem or Problems?'
=> 'Какая Задача или Задачи?',

   'Which problems do you wish to set a parameter for?'
=> 'Для каких задач Вы желаете задать параметры?',

   'Width(pixel):'
=> 'Ширина(pixel):',

   'Without Answers'
=> 'Без Ответов',

   'With Answers'
=> 'С Ответами',

   'Only Answers'
=> 'Только ответы',

   'Words'
=> 'Слова',

   'Wrote Metadata'
=> 'Метаданные Записаны',

   'XML/SGML'
=> 'XML/SGML',

   'Yes'
=> 'Да',

   'You are correct.'
=> 'Вы Правы.',

   'You are excused from the problem.'
=> 'Вы освобождены от решения этой задачи.',

   'You are working with an unsaved version of your map.'
=> 'Вы работаете с несохраненной версией Вашей последовательности',

   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.',

   'You did not select a template.'
=> 'Вы не выбрали шаблон.',

   'You do not have authoring privileges for this resource'
=> 'You do not have authoring privileges for this resource',

   'You have entered that answer before'
=> 'Вы вводили этот ответ ранее',

   'You have no critical messages.'
=> 'У Вас нет критических сообщений.',

   'You have no unread messages'
=> 'У Вас нет непрочитанных сообщений',

   'You have provided an invalid ranking'
=> 'You have provided an invalid ranking',

   'You must choose an authentication type.'
=> 'You must choose an authentication type.',

   'You must choose at least one student to continue.'
=> 'Отметьте минимум одного студента для продолжения.',

   'You must choose one or more choices to continue.'
=> 'Вы должны сделать выбор чтобы продолжать.',

   'You need to choose another user role or enter a specific course for this function'
=> 'You need to choose another user role or enter a specific course for this function',

   'You need to specify the Kerberos domain.'
=> 'Вы должны задать Kerberos домен.',

   'You need to specify the initial password.'
=> 'Вы должны задать начальный пасроль.',

   'You need to specify the username field.'
=> 'Вы должны задать имя пользователя.',

   'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.'
=> 'Ваш курс задан. Пожалуйста нажмите клавишу <b>Завершить Инициализацию Курса</b> для реинициализации курса с Вашими установками. <p>Помните что все эти ыстановки могут быть модифижированы в <b>PARMS</b> экране нажатием на клавишу <b>Окружение Курса</b>.</p>',

   'Your Excel Spreadsheet'
=> 'Ваш Журнал в Excel',

   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.',

   'Your Version Settings have been Saved'
=> 'Ваши Установки для данной Версии Сохранены',

   'Your home server is '
=> 'Ваш домашний сервер ',

   'Your receipt is'
=> 'Your receipt is',

   'Your submission has been recorded.'
=> 'Your submission has been recorded.',

   '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '&quot; [_1] &quot; не является допустимым числом попыток. Число попыток - положительное целое число.',

   '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.'
=> '&quot; [_1] &quot; не является допустимым весом. Вес - положительное целое число.',

   '[_1] Do not change login data'
=> '[_1] Do not change login data',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Filesystem Authenticated (with initial password [_2])',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] Internally authenticated (with initial password [_2])',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5',

   '[_1] Local Authentication with arguement [_2]'
=> '[_1] Local Authentication with arguement [_2]',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2',
   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2'
=> 'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2',

   'a.m.'
=> 'a.m.',

   'abstract'
=> 'реферат',

   'acc keys'
=> 'ключи доступа',

   'access denied'
=> 'в доступе отказано',

   'according to course preferences'
=> 'according to course preferences',

   'according to resource settings'
=> 'according to resource settings',

   'according to user session state'
=> 'according to user session state',

   'after selected'
=> 'после выбора',

   'all'
=> 'все',

   'all resources in the course'
=> 'всех ресурсов курса',

   'all students in course'
=> 'всех студентов курса',

   'an indeterminate date'
=> 'промежуточная дата',

   'an unknown date'
=> 'неизвестная дата',

   'and return receipt'
=> 'and return receipt',

   'anno-'
=> 'anno-',

   'announce'
=> 'announce',

   'anonymous'
=> 'анонимный',

   'anonymous students'
=> 'анонимных студентов',

   'answer date'
=> 'дата показа ответов',

   'at'
=> 'at',

   'at Domain'
=> 'в Домене',

   'at domain'
=> 'в домене',

   'audio'
=> 'аудио',

   'author'
=> 'автор',

   'backward'
=> 'backward',

   'bookmark'
=> 'закладка',

   'bytes'
=> 'байт',

   'can not be accessed from your location.'
=> 'can not be accessed from your location.',

   'catalog'
=> 'каталог',

   'chart'
=> 'chart',

   'chat'
=> 'chat',

   'chmod error'
=> 'chmod ошибка',

   'choose'
=> 'выберите',

   'close this window'
=> 'закрыть это окно',

   'co con-'
=> 'co con-',

   'co res'
=> 'co res',

   'commu-'
=> 'commu-',

   'con-'
=> 'con-',

   'connection down'
=> 'соединение отсутствует',

   'contacting'
=> 'contacting',

   'contents'
=> 'содержание',

   'copy Error'
=> 'Ошибка копирования',

   'copyright'
=> 'copyright',

   'could not be copied.'
=> 'невозможно было скопировать.',

   'course'
=> 'курс',

   'create'
=> 'создать',

   'customdistributionfile'
=> 'customdistributionfile',

   'default'
=> 'по умолчанию',

   'directory'
=> 'директория',

   'discuss'
=> 'обсудить',

   'docs'
=> 'docs',

   'due date'
=> 'дата сдачи',

   'during the last'
=> 'during the last',

   'edit'
=> 'редактировать',

   'edit crs'
=> 'edit crs',

   'ences'
=> 'ences',

   'enroll'
=> 'зачислить',

   'enter'
=> 'войти',

   'evaluate'
=> 'evaluate',

   'exit'
=> 'выйти',

   'expired or revoked'
=> 'окончилась или отменена',

   'extension'
=> 'расширение',

   'fas'
=> 'fas',

   'feedback'
=> 'feedback',

   'first name'
=> 'имя',

   'for'
=> 'для',

   'for [_1]'
=> 'для [_1]',

   'for <b>all resources in the course</b>'
=> 'для <b>всех ресурсов курса</b>',

   'for <b>all students in course</b>'
=> 'для <b>всех студентов курса</b>',

   'for section [_1]'
=> 'для раздела [_1]',

   'for Enclosing Map or Folder'
=> 'для Главной Последовательности или Папки',

   'for Resource'
=> 'для Ресурса',

   'for the map named [_1]'
=> 'для последовательности с именем [_1]',

   'for the resource named [_1]'
=> 'для ресурса с именем [_1]',

   'forward'
=> 'вперед',

   'from'
=> 'из',

   'from current subdirectory'
=> 'из текущей директории',

   'from Enclosing Map or Folder'
=> 'из Окружающей Последовательности или Папки',

   'general'
=> 'общий',

   'generation'
=> 'поколение',

   'grades'
=> 'оценки',

   'in'
=> 'в',

   'in Course'
=> 'в Курсе',

   'in domain'
=> 'в домене',

   'in Section/Group'
=> 'в Разделе/Группе',

   'info'
=> 'инфо',

   'interface available'
=> 'interface available',

   'is closed but you are allowed to view it'
=> 'is closed but you are allowed to view it',

   'is due at'
=> 'is due at',

   'is in under construction'
=> 'is in under construction',

   'is not analyzable at this time'
=> 'is not analyzable at this time',

   'is ready for download'
=> 'is ready for download',

   'keywords'
=> 'ключевые слова',

   'language'
=> 'язык',

   'last month'
=> 'последний месяц',

   'last name'
=> 'фамилия',

   'last problem'
=> 'последняя задача',

   'last six months'
=> 'последние шесть месяцев',

   'last student'
=> 'последний студент',

   'last three months'
=> 'последние три месяца',

   'last week'
=> 'последняя неделя',

   'last year'
=> 'последний год',

   'library'
=> 'библиотека',

   'log in again'
=> 'log in again',

   'loginproblems.html'
=> 'loginproblems.html',

   'make these dates the default for future enrollment'
=> 'задать эти даты по умолчанию для будущего зачисления',

   'manage'
=> 'manage',

   'may open later.'
=> 'may open later.',

   'middle name'
=> 'отчество',

   'minutes'
=> 'минуты',

   'missions'
=> 'missions',

   'most recent'
=> 'последний',

   'movies'
=> 'фильмы',

   'my'
=> 'мой',

   'name'
=> 'имя',

   'name only visible to course faculty'
=> 'name only visible to course faculty',

   'navigate'
=> 'navigate',

   'never'
=> 'никогда',

   'nication'
=> 'nication',

   'not displayed'
=> 'not displayed',

   'no ending date'
=> 'нет даты окончания',

   'not found'
=> 'не найден',

   'notes'
=> 'заметки',

   'number'
=> 'число', # 'номер',

   'number of tries'
=> 'число попыток',

   'num_override'
=> 'num_override',

   'obsolete'
=> 'устаревший',

   'obsoletereplacement'
=> 'устаревшая замена',

   'of'
=> 'of',

   'only check if you know what you are doing'
=> 'only check if you know what you are doing',

   'opening date'
=> 'дата доступа к задаче',

   'or'
=> 'или',

   'or ID'
=> 'или ID',

   'p.m.'
=> 'p.m.',

   'pages'
=> 'страницы',

   'parms'
=> 'parms',

   'part'
=> 'часть',

   'percent'
=> 'процент',

   'pictures'
=> 'рисунки',

   'please refer to'
=> 'please refer to',

   'prefer-'
=> 'prefer-',

   'prepare'
=> 'prepare',

   'printout'
=> 'printout',

   'problem'
=> 'задача',

   'problem statistics grouped by sequence'
=> 'problem statistics grouped by sequence',

   'problem statistics ungrouped'
=> 'problem statistics ungrouped',

   'problem statistics, Excel'
=> 'статистика задачи, Excel',

   'problem weight'
=> 'вес задачи',

   're-initializing course'
=> 'ре-инициализация курса',

   'remaining'
=> 'остающийся',

   'resource'
=> 'ресурс',

   'resources'
=> 'ресурсы',

   'role'
=> 'роль',

   'roles'
=> 'роли',

   'search'
=> 'помск',

   'second'
=> 'секунда',

   'seconds'
=> 'секунды',

   'seconds for'
=> 'секунд для',

   'selected students'
=> 'отдельных студентов',

   'sequence'
=> 'последовательность',

   'set'
=> 'набор',

   'space'
=> 'пространство',

   'standard courses only'
=> 'только для стандартных курсов',

   'stats'
=> 'stats',

   'struct'
=> 'struct',

   'subject'
=> 'предмет',

   'switch'
=> 'switch',

   'system wide'
=> 'system wide',

   'tations'
=> 'tations',

   'this'
=> 'this',

   'title'
=> 'название',

   'to'
=> 'на',

   'to [_1] ([_2])'
=> 'на [_1] ([_2])',

   'today'
=> 'сегодня',

   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231',

   'unable to enroll'
=> 'unable to enroll',

   'undo'
=> 'отменить',

   'unless locked'
=> 'unless locked',

   'untitled'
=> 'без названия',

   'updated periodically'
=> 'обновляемые периодически',

   'user'
=> 'пользователь',

   'users in'
=> 'пользователи в',

   'versions of this problem'
=> 'версии этой задачи',

   'versus'
=> 'и',

   'view'
=> 'view',

   'view sub-'
=> 'view sub-',

   'visible to author and co-authors only'
=> 'visible to author and co-authors only',

   'waiting on'
=> 'waiting on',

   'warning(s)'
=> 'warning(s)',

   'was due on'
=> 'was due on',

   'will open on'
=> 'will open on',

   'with server'
=> 'с сервером',


   'Select resources for the assignment'
=> '<br /><big><i><b>Выбор ресурсов для задания</b></i></big><br />',

   'Print:'
=> "<hr width='33%' /><table><tr><td align='right'>Печатать: </td><td>",

   'LaTeX mode:'
=> "<tr><td align='right'>Мода LaTeX: </td><td>",

   'standard LaTeX mode'
=> 'стандартная мода',

   'Print Table of Contents:'
=> "</td></tr><tr><td align='right'>Печатать Оглавление: </td><td>",

   'Print Index:'
=> "<tr><td align='right'>Печатать Индекс: </td><td>",

   'what you just saw on the screen'
=> "то что Вы только что видели на экране",

   'Select All Resources'
=> 'Выбрать Все Ресурсы',

   'Resource Hidden from Students (hiddenresource)'
=> 'Ресурсы, Спрятанные от Студентов (hiddenresource)',

   'Resources from selected sequence in course'
=> "<b>Ресурсы</b> из <b>выбранной последовательности</b> курса",

   'Problems from entire course'
=> '<b>Задачи</b> из <b>всего курса</b>',

   'Select Resource(s) to print'
=> 'Выберите Ресурс(ы) для Печати',

   'Select Student'
=> 'Выберите Студента',

   'Select Students and Resources'
=> 'Выберите Студентов и Ресурсы',

   'Select Sequence To Print From'
=> 'Выберите Последовательность Ресурсы Которой Вы Хотите Печатать',

   'Select Resources To Print'
=> 'Выберите Ресурсы для Печати',

   'Begin Enrollment'
=> 'Начать Зачисление',

   'Catalog Search'
=> 'Поиск в Каталоге',

   'Course Search'
=> 'Поиск в Курсе',

   'Generate messages from a file'
=> 'Генерировать сообщения нз файла',

   'Parameter'
=> 'Параметер',

   'Set to ...'
=> 'Установить значение',

   'Set Individual User Roles'
=> 'Задать Роли Индивидуального Пользователя',

   'Width'
=> 'Ширина',

   'Paper type'
=> 'Вид бумаги',

   'Top Level Map'
=> 'Главная Последовательность',

   'Modification may make assessment data inaccessible'
=> 'Модификация может сделать данные недоступными',

   'Display file attributes'
=> 'Показать атрибуты файла',

   'internal'
=> 'внутренний',

   'optional'
=> 'необязательный',

   'standard'
=> 'стандартный',

   'external'
=> 'внешний',

   'or any other value'
=> 'или любое иное значение',

   'Default for new courses is'
=> 'По умолчанию для новых курсов',

   'Default XML Style File'
=> 'XML стилевой файл по умолчанию',

   'Select Style File'
=> 'Выбор Стилевого Файла',

   'Languages used'
=> 'Использованные языки',

   'Randomization algorithm used'
=> 'Использованный алгоритм рэндомизации',

   'Modifying this will make problems'
=> 'Эта модификация может привести к проблеме',

   'have different numbers and answers'
=> 'иметь другие числа и ответы',

   'Resource'
=> 'Ресурс',

   'Folder/Map'
=> 'Папка/Последовательность',

   'Set'
=> 'Установить',

   'yes'
=> 'да',

   'Visibly Separate Items on Pages'
=> 'Видимо Разделять Параграфы на Странице',

   '"[_1]" for visible separation'
=> '"[_1]" для видимого разделения',

   'changes will not show until next login'
=> 'изменения не видны до следующего входа в систему',

   'Default Student Spreadsheet'
=> 'Студенческий Журнал по умолчанию',

   'Default Course Spreadsheet'
=> 'Жырнал Курса по умолчанию',

   'Default Assessment Spreadsheet'
=> 'Журнал Доступа к Курсу по умолчанию',

   'Set Course Environment'
=> 'Задать Окружение Курса',

   'Entering Construction Space'
=> 'Вход в Авторское Пространство',

   'Go to ...'
=> 'Перейти к ...',

   'Manual Grading'
=> 'Выставление Оценок Преподавателем',

   'Current Resource'
=> 'Текущий Ресурс',

   'Select Section'
=> 'Выберите Раздел',

   'For one or more students'
=> 'Для одного или нескольких студентов',

   'Client IP/Name Access Control (acc)'
=> 'Client IP/Name Access Control (acc)',

   'Click here for help'
=> 'Помощь',

   'Dependencies'
=> 'Зависимости',

   'KEYWORDS'
=> 'КЛЮЧЕВЫЕ СЛОВА',

   'check all'
=>  'выбрать все',

   'uncheck all'
=> 'отменить выбор всего',

   'use related words'
=> 'использовать связанные слова',

   'only search domain'
=> 'искать только в домене',

   'VIEW'
=> 'ВЫВОДИТЬ',

   'between'
=> 'между',

   'and'
=> 'и',

   'username'
=> 'имя пользователя',

   'domain'
=> 'домен',

   'student name'
=> 'имя студента',

   'section'
=> 'раздел',

   'How do I create a class list from a spreadsheet'
=> 'Как мне создать список класса из журнала',

   'How do I create a CSV file from a spreadsheet'
=> 'Как мне создать CSV файл из журнала',


# ----

   'calendar[_1]'
=> 'календарь',

   'announce[_1]'
=> 'announce',


# ----

   'commu-[_1]'
=> 'commu-',

   'nication[_1]'
=> 'nication',


# ----

   'course[_10]'
=> 'курс',

   'chat[_1]'
=> 'chat',


# ----

   'search[_1]'
=> 'помск',

   'course[_11]'
=> 'курс',


# ----

   'search[_2]'
=> 'помск',

   'library[_1]'
=> 'библиотека',


# ----

   'prefer-[_1]'
=> 'prefer-',

   'ences[_1]'
=> 'ences',


# ----

   'exit[_1]'
=> 'выйти',

   ' [_1]'
=> ' ',


# ----

   'switch[_2]'
=> 'switch',

   'role[_1]'
=> 'роль',


# ----

   'choose[_2]'
=> 'выберите',

   'role[_2]'
=> 'роль',


# ----

   'choose[_1]'
=> 'выберите',

   'course[_1]'
=> 'курс',


# ----

   'switch[_1]'
=> 'switch',

   'course[_2]'
=> 'курс',


# ----

   'course[_3]'
=> 'курс',

   'docs[_1]'
=> 'docs',


# ----

   'edit crs[_1]'
=> 'edit crs',

   'docs[_2]'
=> 'docs',


# ----

   'navigate[_1]'
=> 'navigate',

   'contents[_1]'
=> 'contents',


# ----

   'my[_1]'
=> 'мой',

   'grades[_1]'
=> 'оценки',


# ----

   'course[_4]'
=> 'курс',

   'grades[_2]'
=> 'оценки',


# ----

   'course[_5]'
=> 'курс',

   'chart[_1]'
=> 'chart',


# ----

   'course[_6]'
=> 'курс',

   'stats[_1]'
=> 'stats',


# ----

   'course[_7]'
=> 'курс',

   'enroll[_1]'
=> 'зачислить',


# ----

   'manage[_1]'
=> 'manage',

   'acc keys[_1]'
=> 'acc keys',


# ----

   'user[_1]'
=> 'пользователь',

   'roles[_1]'
=> 'роли',


# ----

   'create[_1]'
=> 'создать',

   'course[_8]'
=> 'курс',


# ----

   'course[_9]'
=> 'курс',

   'parms[_1]'
=> 'parms',


# ----

   'con-[_1]'
=> 'con-',

   'struct[_1]'
=> 'struct',


# ----

   'co con-[_1]'
=> 'co con-',

   'struct[_2]'
=> 'struct',


# ----

   'resource[_1]'
=> 'ресурс',

   'space[_1]'
=> 'пространство',


# ----

   'co res[_1]'
=> 'co res',

   'space[_2]'
=> 'пространство',


# ----

   'enter[_1]'
=> 'войти',

# ----

   'send[_1]'
=> 'send',

   'scantron[_1]'
=> 'scantron',


# ----

   'view[_1]'
=> 'view',

   'bookmark[_1]'
=> 'закладка',



#SYNC Tue Aug 15 14:23:47 2006
   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)',
# (войти maximum [_1] collabилиaнаrs usвg имя пользователя или имя пользователя@domaв, e.g. smithje или smithje@[_2].)
   '(Hand in a file you have prepared on your computer)'
=> '(Hand in a file you have prepared on your computer)',
# (Hи в a Файл you have pRepaRed on your computer)
   ', select a template from the pull-down menu below.'
=> ', select a template from the pull-down menu below.',
# , Выберите Шаблон из the pull-down menu below.
   '1 minute'
=> '1 minute',
# 1 mвute
   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.',
# <*Response>s aRe both вside of <часть> и outside of <часть>, this is Нетt a valid задача, errилиs в gradвg Май occur.
   'Allowed filetypes: <b>[_1]</b>'
=> 'Allowed filetypes: <b>[_1]</b>',
# всеoСр ФайлТипs: <b>[_1]</b>
   'Analyzing Results'
=> 'Analyzing Results',
# Analyzвg Results
   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Answer Submitted: Your final submission will be graded after the due date.',
# Ответ Послатьted: Your fвal submission will be graded after the дата сдачи.
   'Answerable'
=> 'Answerable',
# Ответable
   'Cannot publish directory'
=> 'Cannot publish directory',
# CanНетt Опубликовать diRecнаry
   'Cannot retrieve directory'
=> 'Cannot retrieve directory',
# CanНетt Запросить diRecнаry
   'Changed discussion view mode'
=> 'Changed discussion view mode',
# Изменитьd обсудитьion Посмотреть mode
   'Click here for FAQ'
=> 'Click here for FAQ',
# Click heRe fили FAQ
   'Click here to report bugs'
=> 'Click here to report bugs',
# Click heRe на Repилиt bugs
   'Click here to return to the chart.'
=> 'Click here to return to the chart.',
# Click heRe на Return на the chart.
   'Click-On Texts (comma sep):'
=> 'Click-On Texts (comma sep):',
# Click-On Текстs (comma sep):
   'Closed'
=> 'Closed',
# Закрытьd
   'Courses'
=> 'Courses',
# курсs
   'Create User'
=> 'Create User',
# создать пользователь
   'Creating a new'
=> 'Creating a new',
# CReatвg a new
   'Current Ending Date: [_1]'
=> 'Current Ending Date: [_1]',
# Текущий Конецвg Дата: [_1]
   'Current Ending Date: not set'
=> 'Current Ending Date: not set',
# Текущий Конецвg Дата: Нетt набор
   'Current Starting Date: [_1]'
=> 'Current Starting Date: [_1]',
# Текущий Началовg Дата: [_1]
   'Current Starting Date: not set'
=> 'Current Starting Date: not set',
# Текущий Началовg Дата: Нетt набор
   'Currently no active roles or courses'
=> 'Currently no active roles or courses',
# Текущийly Нет active роли или курсs
   'Currently no additional roles or courses'
=> 'Currently no additional roles or courses',
# Текущийly Нет additional роли или курсs
   'Currently submitted: <tt>[_1]</tt>'
=> 'Currently submitted: <tt>[_1]</tt>',
# Текущийly Послатьted: <tt>[_1]</tt>
   'Default:'
=> 'Default:',
# по умолчанию:
   'Description:'
=> 'Description:',

   "Don't Show Feedback"
=> "Don't Show Feedback",

   'Dynamic Metadata (updated periodically)'
=> 'Dynamic Metadata (updated periodically)',
# Dynamic Метаданные (обновляемые периодически)
   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.',
# Ediнаr Errилиs - these errилиs might Нетt effect the runnвg of the задача, but they will likely cause задачаs with further use of the редактировать mode. Please use the редактироватьXML mode на fix these errилиs.
   'Evaluation Error '
=> 'Evaluation Error ',
# Evaluation Errили
   'Every problem in a particular folder'
=> 'Every problem in a particular folder',
# Every задача в a частьicular Папка
   'Exam Problem'
=> 'Exam Problem',
# Exam задача
   'Exit'
=> 'Exit',
# выйти
   'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.'
=> 'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.',
# Foil имя <b><tt>[_1]</tt></b> appears mилиe than once. Foil имяs need на be unique.
   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Found a <*response> outside of a <part> in a <part>ed problem',
# Found a <*Response> outside of a <часть> в a <часть>ed задача
   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.',
# Found Нет analyzable Respones в this задача, Текущийly only Numerical, Fилиmula и Strвg Response styles aRe sВверхpилиted.
   'Go'
=> 'Go',

   'Homework problem'
=> 'Homework problem',
# Homewилиk задача
   'Invalid Significant figures detected'
=> 'Invalid Significant figures detected',
# вvalid Significant figuRes detected
   'LaTeX batchmode'
=> 'LaTeX batchmode',

   'Leave blank on scoring form'
=> 'Leave blank on scoring form',
# Leave Пробел on scиливg fилиm
   'Logout'
=> 'Logout',

   'Modify deadlines, etc, for this resource'
=> 'Modify deadlines, etc, for this resource',
# Modify deadlвes, etc, fили this ресурс
   'Must create new subdirectory inside a directory'
=> 'Must create new subdirectory inside a directory',
# Must создать new subdiRecнаry вside a diRecнаry
   'Next    '
=> 'Next    ',
# Далее
   'No Access or Usages Statistics are available for this resource.'
=> 'No Access or Usages Statistics are available for this resource.',
# Нет Access или Usages Статистика aRe available fили this ресурс.
   'No Assessment Statistical Data is available for this resource'
=> 'No Assessment Statistical Data is available for this resource',
# Нет Оценка Statistical Data is available fили this ресурс
   'No Evaluation Data is available for this resource.'
=> 'No Evaluation Data is available for this resource.',
# Нет Оценочные Данные is available fили this ресурс.
   'Not applicable - '
=> 'Not applicable - ',
# Нетt applicable -
   'Not open to be viewed'
=> 'Not open to be viewed',
# Нетt Открыть на be vieСр
   'Not set - '
=> 'Not set - ',
# Нетt набор -
   'One particular problem'
=> 'One particular problem',
# One частьicular задача
   'Online Help'
=> 'Online Help',
# Onlвe Помощь
   'Open and correct'
=> 'Open and correct',
# Открыть и cилиRect
   'Open with full tries'
=> 'Open with full tries',
# Открыть with full Попыток
   'Output Format: [_1]'
=> 'Output Format: [_1]',
# Вывод Fилиmat: [_1]
   'Please adjust significant figures.'
=> 'Please adjust significant figures.',

   'Please click Back on your browser and select another user, or '
=> 'Please click Back on your browser and select another user, or ',
# Please click Back on your bСтрокаser и ВыберитеНетther пользователь, или
   'Please stand by.'
=> 'Please stand by.',
# Please stи By.
   "Please use browser 'Back' button and pick a filename"
=> "Please use browser 'Back' button and pick a filename",
# Please use bСтрокаser 'Back' butнаn и pick a Файлимя
   'Preparing Printout'
=> 'Preparing Printout',
# PReparвg Prвнаut
   'Reading results from [_1]'
=> 'Reading results from [_1]',
# Readвg Results из [_1]
   'Receiving results from [_1]'
=> 'Receiving results from [_1]',
# Receivвg Results из [_1]
   'Recent'
=> 'Recent',

   'Report a Bug'
=> 'Report a Bug',
# Repилиt a Bug
   'Response'
=> 'Response',

   'Retrieving current (most recent) version'
=> 'Retrieving current (most recent) version',
# Retrievвg Текущий (последний) Версия
   'Return to DOCS'
=> 'Return to DOCS',
# Return на docs
   'Sample Points:'
=> 'Sample Points:',
# Sample Poвts:
   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Save entries below as a draft answer (not submitting them for credit yet)',
# Сохранить enПопыток below as a draft Ответ (Нетt Послатьtвg them fили crредактировать yet)
   'Search Complete [_1]'
=> 'Search Complete [_1]',
# помск Complete [_1]
   'Search: [_1]'
=> 'Search: [_1]',
# помск: [_1]
   'Set opening date for all problems in the course for. . .'
=> 'Set opening date for all problems in the course for. . .',
# набор дата доступа к задаче fили все задачаs в the курс fили. . .
   'Set opening datefor all problems in the course for. . .'
=> 'Set opening datefor all problems in the course for. . .',
# набор дата доступа к задачеfили все задачаs в the курс fили. . .
   'Show Answer'
=> 'Show Answer',
# Show Ответ
   'Show Feedback'
=> 'Show Feedback',

   'Some items were not submitted'
=> 'Some items were not submitted',
# Some items weRe Нетt Послатьted
   'Student Sheet Links'
=> 'Student Sheet Links',
# студент Sheet Lвks
   'Student Status: [_1]'
=> 'Student Status: [_1]',
# студент Статус: [_1]
   'Submissions'
=> 'Submissions',

   'Submit entries below as answer to receive credit'
=> 'Submit entries below as answer to receive credit',
# Послать enПопыток below as Ответ на Receive crредактировать
   'Survey Question'
=> 'Survey Question',

   'Swedish Chef'
=> 'Swedish Chef',
# SСрish Chef
   'TeX unconverted due to errors'
=> 'TeX unconverted due to errors',
# TeX unconverted Сдать на errилиs
   'TeX unconverted due to previous errors'
=> 'TeX unconverted due to previous errors',
# TeX unconverted Сдать на Предыдущий errилиs
   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options',
# The question can Нетt be gotten cилиRect, the followвg Foils в the &lt;optionResponse&gt; have вvalid cилиRect options
   'The requested file'
=> 'The requested file',
# The Requested Файл
   'There are currently no Error Messages for this resource.'
=> 'There are currently no Error Messages for this resource.',
# TheRe aRe Текущийly Нет Errили Messages fили this ресурс.
   'There are no Evaluation Comments on this resource.'
=> 'There are no Evaluation Comments on this resource.',
# TheRe aRe Нет Оценочные Комментарии on this ресурс.
   'There are no currently enrolled students in the course.'
=> 'There are no currently enrolled students in the course.',
# TheRe aRe Нет Текущийly зачислитьed студентs в the курс.
   'There are no currently enrolled students in the selected sections.'
=> 'There are no currently enrolled students in the selected sections.',
# TheRe aRe Нет Текущийly зачислитьed студентs в the Выбратьed разделs.
   'There are no previously enrolled students in the course.'
=> 'There are no previously enrolled students in the course.',
# TheRe aRe Нет Предыдущийly зачислитьed студентs в the курс.
   'There are no previously enrolled students in the selected sections.'
=> 'There are no previously enrolled students in the selected sections.',
# TheRe aRe Нет Предыдущийly зачислитьed студентs в the Выбратьed разделs.
   'There are no students in the course.'
=> 'There are no students in the course.',
# TheRe aRe Нет студентs в the курс.
   'There are no students in the selected sections.'
=> 'There are no students in the selected sections.',
# TheRe aRe Нет студентs в the Выбратьed разделs.
   'To create a new'
=> 'To create a new',
# на создать a new
   'Type-in value'
=> 'Type-in value',
# Тип-в Значение
   'Type:'
=> 'Type:',
# Тип:
   'UNDISPLAYABLE'
=> 'UNDISPLAYABLE',
# UNПоказатьABLE
   'Upload file to Construction Space'
=> 'Upload file to Construction Space',
# Обновить файл на Construction пространство
   'View the FAQ'
=> 'View the FAQ',
# Посмотреть the FAQ
   '[_1] (what you just saw on the screen)'
=> '[_1] (what you just saw on the screen)',
# [_1] (то что Вы только что видели на экране)
   '[_1] Local Authentication with argument [_2]'
=> '[_1] Local Authentication with argument [_2]',
# [_1] Local AuЗатемtication with argument [_2]
   '[_1] Records per Page'
=> '[_1] Records per Page',
# [_1] Recилиds На Страницу
   '[_1] minutes'
=> '[_1] minutes',
# [_1] минуты
   '[_1] minutes, [_2] seconds'
=> '[_1] minutes, [_2] seconds',
# [_1] минуты, [_2] секунды
   '[_1] with value [_2]'
=> '[_1] with value [_2]',
# [_1] with Значение [_2]
   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',
# [_1]pRev[_2] &nbsp; [_3]ReЗагрузить[_4] &nbsp; [_5]Далее[_6]
   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next',
# [_1]pRev[_2] &nbsp; [_3]ReЗагрузить[_4] &nbsp; Далее
   '[_2] seconds'
=> '[_2] seconds',
# [_2] секунды
   'anno-[_1]'
=> 'anno-[_1]',
# anНет-[_1]
   'backward[_1]'
=> 'backward[_1]',

   'bookmark[_2]'
=> 'bookmark[_2]',
# закладка[_2]
   'button'
=> 'button',
# butнаn
   'by'
=> 'by',

   'catalog[_1]'
=> 'catalog[_1]',
# каталог[_1]
   'click on the'
=> 'click on the',

   'contacting [_1]'
=> 'contacting [_1]',
# Контактироватьвg [_1]
   'currently does not exist'
=> 'currently does not exist',
# Текущийly does Нетt exist
   'custom'
=> 'custom',
# cusнаm
   'custom distribution file'
=> 'custom distribution file',
# cusнаm distribution Файл
   'discuss[_1]'
=> 'discuss[_1]',
# обсудить[_1]
   'evaluate[_1]'
=> 'evaluate[_1]',

   'feedback[_1]'
=> 'feedback[_1]',

   'file<br />extension'
=> 'file<br />extension',
# Файл<br />расширение
   'for visible separation'
=> 'for visible separation',
# fили visible separation
   'forward[_1]'
=> 'forward[_1]',
# fилиward[_1]
   'is in this state by royal decree.'
=> 'is in this state by royal decree.',
# is в this state By royal decRee.
   'may be open from a different computer.'
=> 'may be open from a different computer.',
# Май be Открыть из a diffeRent computer.
   'obsolete replacement'
=> 'obsolete replacement',
# устаревший Replacement
   'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> 'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',
# pRev &nbsp; [_3]ReЗагрузить[_4] &nbsp; [_5]Далее[_6]
   'private'
=> 'private',

   'public'
=> 'public',

   'publisher<br />owner'
=> 'publisher<br />owner',
# Опубликоватьer<br />owner
   'set[_1]'
=> 'set[_1]',
# набор[_1]
   'spellcheck_lang'
=> 'spellcheck_lang',

   'template'
=> 'template',
# Шаблон
   'waiting on [_1]'
=> 'waiting on [_1]',
# waitвg on [_1]


#SYNC Tue Aug 15 14:43:22 2006
   'Enter my portfolio space'
=> 'Enter my portfolio space',
# войти мой pилиtfolio пространство
   'No syllabus information provided.'
=> 'No syllabus information provided.',
# Нет Учебный План вfилиmation provided.
   'Post Discussion'
=> 'Post Discussion',
# Post обсудитьion
   'Sorry ...'
=> 'Sorry ...',
# Sилиry ...
   'This resource might be part of another course.'
=> 'This resource might be part of another course.',
# this ресурс might be часть of aНетther курс.


#SYNC Tue Aug 15 16:12:14 2006
   'Agree'
=> 'Agree',

   'Any comments? '
=> 'Any comments? ',

   'Copy this column'
=> 'Copy this column',
# Copy this Столбец
   'Disagree'
=> 'Disagree',

   'General Intro'
=> 'General Intro',
# общий вtro
   'Greek Symbols'
=> 'Greek Symbols',

   'HTML character enties'
=> 'HTML character enties',

   'Highest Grade Level'
=> 'Highest Grade Level',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.',
# If you aRe Посмотретьвg this onlвe, copy и paste the Текст из any of the right Столбецs вна your Текст aRea на get the symbol on the left.
   'LON-CAPA Help'
=> 'LON-CAPA Help',
# LON-CAPA Помощь
   'Landscape'
=> 'Landscape',
# Lиscape
   'Launch navigation window'
=> 'Launch navigation window',
# Launch navigation wвdow
   'Lowest Grade Level'
=> 'Lowest Grade Level',

   'Mark all posts read'
=> 'Mark all posts read',
# Mark все posts Read
   'My question/comment/feedback:'
=> 'My question/comment/feedback:',
# мой question/comment/feedback:
   'Not set -'
=> 'Not set -',
# Нетt набор -
   'Other Symbols'
=> 'Other Symbols',

   'Please check at least one of the following feedback types:'
=> 'Please check at least one of the following feedback types:',
# Please check at least one of the followвg feedback Типs:
   'Please rank the following criteria:'
=> 'Please rank the following criteria:',
# Please rank the followвg criteria:
   'Portrait'
=> 'Portrait',
# Pилиtrait
   'Question about resource content'
=> 'Question about resource content',
# Question about ресурс content
   'Question/Comment/Feedback about course policy'
=> 'Question/Comment/Feedback about course policy',
# Question/Comment/feedback about курс policy
   'Select a Course to Enter'
=> 'Select a Course to Enter',
# Выберите курс на войти
   'Sending Messages'
=> 'Sending Messages',
# SКонецвg Messages
   'Show Me My First Homework Problem'
=> 'Show Me My First Homework Problem',
# Show Me мой Имя Homewилиk задача
   'Standards'
=> 'Standards',
# стандартныйs
   'Strongly Agree'
=> 'Strongly Agree',

   'Strongly Disagree'
=> 'Strongly Disagree',

   'Symbol'
=> 'Symbol',

   'The material appears to be correct '
=> 'The material appears to be correct ',
# The material appears на be cилиRect
   'The material is helpful '
=> 'The material is helpful ',
# The Материал полезен
   'The material is presented in a clear way '
=> 'The material is presented in a clear way ',
# The material is pResented в a clear way
   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) '
=> 'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) ',
# The ресурс is technicвсеy cилиRect (Загрузитьs fast eНетugh, does Нетt produce errилиs, lвks wилиk, etc)


#SYNC Tue Aug 15 18:55:42 2006


#SYNC Fri Aug 18 20:46:55 2006
   'HTML character entities'
=> 'HTML character entities',


#SYNCMARKER
);

1;

