# The LearningOnline Network with CAPA
# Server for RAT Maps
#
# $Id: lonratsrv.pm,v 1.41 2008/11/20 15:19:05 jms Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#


package Apache::lonratsrv;

use strict;
use Apache::Constants qw(:common);
use LONCAPA();
use LONCAPA::map();


# ================================================================ Main Handler

sub handler {
  my $r=shift;
  &Apache::loncommon::content_type($r,'text/html');
  $r->send_http_header;

  return OK if $r->header_only;

  my $url=$r->uri;
  $url=~m{/(\w+)/ratserver$};
  my $mode=$1;

  $url=~s{/loadonly/ratserver$}{/save/ratserver};
  
  my $fn=$r->filename;
  my $lonDocRoot=$r->dir_config('lonDocRoot');
  if ( $fn =~ /\Q$lonDocRoot\E/ ) {
      #internal authentication, needs fixup.
      $fn = $url;
      $fn=~s{^/~($LONCAPA::username_re)}{/home/$1/public_html};
      $fn=~s{/[^/]*/ratserver$}{};
  }
  my $errtext='';
  my $infotext='';
  my $outtext='';

  if ($mode ne 'loadonly') {
     ($errtext,$infotext)=&LONCAPA::map::savemap($fn,$errtext);
  }
  ($outtext,$errtext,$infotext)=&LONCAPA::map::loadmap($fn,$errtext,$infotext);

  my $start_page =
      &Apache::loncommon::start_page('Alert',undef,
				     {'only_body' => 1,
				      'bgcolor'   => '#FFFFFF',});
  my $end_page =
      &Apache::loncommon::end_page();

  $r->print(<<ENDDOCUMENT);
$start_page
<form name="storage" method="post" action="$url">
<input type="hidden" name="output" value="$outtext" />
</form>
<script type ="text/javascript">
    parent.flag=1;
</script>
ENDDOCUMENT
    if (($errtext ne '') || ($infotext ne '')) {
	$r->print(<<ENDSCRIPT);
<script type="text/javascript">
    alert("$infotext $errtext");
</script>
ENDSCRIPT
    }
    $r->print($end_page);

  return OK;
}

1;
__END__


=head1 NAME

Apache::lonratsrv

=head1 SYNOPSIS

Handler that takes output from RAT and stores
it on disk. Handles the upper hidden frame of
the added window that comes up in RAT. (3
frames come up in RAT server, code, and
output. This module handles server
connection.)

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.

=cut