/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.api.MOCalculationInterface;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.util.Logger;

public class MOCalculation
extends QuantumCalculation
implements MOCalculationInterface {
    private static int MAX_GRID = 80;
    float[] CX = new float[MAX_GRID];
    float[] CY = new float[MAX_GRID];
    float[] CZ = new float[MAX_GRID];
    float[] DXY = new float[MAX_GRID];
    float[] DXZ = new float[MAX_GRID];
    float[] DYZ = new float[MAX_GRID];
    float[] EX = new float[MAX_GRID];
    float[] EY = new float[MAX_GRID];
    float[] EZ = new float[MAX_GRID];
    String calculationType;
    Vector shells;
    float[][] gaussians;
    int[][] slaterInfo;
    float[][] slaterData;
    float[] moCoefficients;
    int moCoeff;
    int gaussianPtr;
    int firstAtomOffset;
    private static final float ROOT3 = 1.7320508f;

    public void calculate(VolumeData volumeData, BitSet bitSet, String string, Point3f[] point3fArray, int n, Vector vector, float[][] fArray, Hashtable hashtable, int[][] nArray, float[][] fArray2, float[] fArray3) {
        this.calculationType = string;
        this.atomCoordAngstroms = point3fArray;
        this.firstAtomOffset = n;
        this.shells = vector;
        this.gaussians = fArray;
        this.slaterInfo = nArray;
        this.slaterData = fArray2;
        this.moCoefficients = fArray3;
        this.initialize(MAX_GRID);
        this.setVolume(volumeData, bitSet);
        this.atomIndex = n - 1;
        this.doDebug = Logger.isActiveLevel(0);
        if (nArray != null) {
            this.createSlaterCube();
        } else {
            this.createGaussianCube();
        }
    }

    private void createSlaterCube() {
        this.moCoeff = 0;
        int n = this.slaterInfo.length;
        for (int i = 0; i < n; ++i) {
            this.processSlater(i);
        }
    }

    private void createGaussianCube() {
        if (!this.checkCalculationType()) {
            return;
        }
        int n = this.shells.size();
        this.moCoeff = 0;
        for (int i = 0; i < n; ++i) {
            this.processShell(i);
            if (!this.doDebug) continue;
            Logger.debug("createGaussianCube shell=" + i + " moCoeff=" + this.moCoeff + "/" + this.moCoefficients.length);
        }
    }

    private boolean checkCalculationType() {
        if (this.calculationType == null) {
            Logger.warn("calculation type not identified -- continuing");
            return true;
        }
        if (this.calculationType.indexOf("5D") >= 0) {
            Logger.error("QuantumCalculation.checkCalculationType: can't read 5D basis sets yet: " + this.calculationType + " -- exit");
            return false;
        }
        if (this.calculationType.indexOf("+") >= 0 || this.calculationType.indexOf("*") >= 0) {
            Logger.warn("polarization/diffuse wavefunctions have not been tested fully: " + this.calculationType + " -- continuing");
        }
        if (this.calculationType.indexOf("?") >= 0) {
            Logger.warn("unknown calculation type may not render correctly -- continuing");
        } else {
            Logger.info("calculation type: " + this.calculationType + " OK.");
        }
        return true;
    }

    private void processShell(int n) {
        int n2 = this.atomIndex;
        int[] nArray = (int[])this.shells.get(n);
        this.atomIndex = nArray[0] + this.firstAtomOffset;
        int n3 = nArray[1];
        this.gaussianPtr = nArray[2];
        int n4 = nArray[3];
        if (this.doDebug) {
            Logger.debug("processShell: " + n + " type=" + n3 + " nGaussians=" + n4 + " atom=" + this.atomIndex);
        }
        if (this.atomIndex != n2 && this.atomCoordBohr[this.atomIndex] != null) {
            float f = this.atomCoordBohr[this.atomIndex].x;
            float f2 = this.atomCoordBohr[this.atomIndex].y;
            float f3 = this.atomCoordBohr[this.atomIndex].z;
            int n5 = this.countsXYZ[0];
            while (--n5 >= 0) {
                this.X2[n5] = this.X[n5] = this.xyzBohr[n5][0] - f;
                int n6 = n5;
                this.X2[n6] = this.X2[n6] * this.X[n5];
            }
            n5 = this.countsXYZ[1];
            while (--n5 >= 0) {
                this.Y2[n5] = this.Y[n5] = this.xyzBohr[n5][1] - f2;
                int n7 = n5;
                this.Y2[n7] = this.Y2[n7] * this.Y[n5];
            }
            n5 = this.countsXYZ[2];
            while (--n5 >= 0) {
                this.Z2[n5] = this.Z[n5] = this.xyzBohr[n5][2] - f3;
                int n8 = n5;
                this.Z2[n8] = this.Z2[n8] * this.Z[n5];
            }
        }
        switch (n3) {
            case 0: {
                this.addDataS(n4);
                break;
            }
            case 1: {
                this.addDataP(n4);
                break;
            }
            case 2: {
                this.addDataSP(n4);
                break;
            }
            case 3: {
                this.addDataD(n4);
                break;
            }
            default: {
                Logger.warn(" Unsupported basis type for atomno=" + (this.atomIndex + 1) + " -- use \"set loglevel 5\" to debug.");
                return;
            }
        }
    }

    private void addDataS(int n) {
        if (!this.atomSet.get(this.atomIndex)) {
            ++this.moCoeff;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, "S ");
        }
        int n2 = this.moCoeff;
        this.setMinMax();
        for (int i = 0; i < n; ++i) {
            this.moCoeff = n2;
            float f = this.gaussians[this.gaussianPtr + i][0];
            float f2 = this.gaussians[this.gaussianPtr + i][1];
            float f3 = f2 * (float)Math.pow(f, 0.75) * 0.7127055f;
            f3 *= this.moCoefficients[this.moCoeff++];
            int n3 = this.xMax;
            while (--n3 >= this.xMin) {
                this.EX[n3] = f3 * (float)Math.exp(-this.X2[n3] * f);
            }
            n3 = this.yMax;
            while (--n3 >= this.yMin) {
                this.EY[n3] = (float)Math.exp(-this.Y2[n3] * f);
            }
            n3 = this.zMax;
            while (--n3 >= this.zMin) {
                this.EZ[n3] = (float)Math.exp(-this.Z2[n3] * f);
            }
            n3 = this.xMax;
            while (--n3 >= this.xMin) {
                int n4 = this.yMax;
                while (--n4 >= this.yMin) {
                    int n5 = this.zMax;
                    while (--n5 >= this.zMin) {
                        float[] fArray = this.voxelData[n3][n4];
                        int n6 = n5;
                        fArray[n6] = fArray[n6] + this.EX[n3] * this.EY[n4] * this.EZ[n5];
                    }
                }
            }
        }
    }

    private void addDataP(int n) {
        if (!this.atomSet.get(this.atomIndex)) {
            this.moCoeff += 3;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, "X Y Z ");
        }
        this.setMinMax();
        int n2 = this.moCoeff;
        for (int i = 0; i < n; ++i) {
            this.moCoeff = n2;
            float f = this.gaussians[this.gaussianPtr + i][0];
            float f2 = this.gaussians[this.gaussianPtr + i][1];
            float f3 = f2 * (float)Math.pow(f, 1.25) * 1.425411f;
            float f4 = f3 * this.moCoefficients[this.moCoeff++];
            float f5 = f3 * this.moCoefficients[this.moCoeff++];
            float f6 = f3 * this.moCoefficients[this.moCoeff++];
            this.calcSP(f, 0.0f, f4, f5, f6);
        }
    }

    private void addDataSP(int n) {
        if (!this.atomSet.get(this.atomIndex)) {
            this.moCoeff += 4;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, "S X Y Z ");
        }
        this.setMinMax();
        int n2 = this.moCoeff;
        for (int i = 0; i < n; ++i) {
            this.moCoeff = n2;
            float f = this.gaussians[this.gaussianPtr + i][0];
            float f2 = this.gaussians[this.gaussianPtr + i][1];
            float f3 = this.gaussians[this.gaussianPtr + i][2];
            float f4 = f2 * (float)Math.pow(f, 0.75) * 0.7127055f;
            float f5 = f3 * (float)Math.pow(f, 1.25) * 1.425411f;
            float f6 = f2 == 0.0f ? 0.0f : f4 * this.moCoefficients[this.moCoeff++];
            float f7 = f5 * this.moCoefficients[this.moCoeff++];
            float f8 = f5 * this.moCoefficients[this.moCoeff++];
            float f9 = f5 * this.moCoefficients[this.moCoeff++];
            this.calcSP(f, f6, f7, f8, f9);
        }
    }

    private void setCE(float f, float f2, float f3, float f4, float f5) {
        int n = this.xMax;
        while (--n >= this.xMin) {
            this.CX[n] = f2 + f3 * this.X[n];
            this.EX[n] = (float)Math.exp(-this.X2[n] * f);
        }
        n = this.yMax;
        while (--n >= this.yMin) {
            this.CY[n] = f4 * this.Y[n];
            this.EY[n] = (float)Math.exp(-this.Y2[n] * f);
        }
        n = this.zMax;
        while (--n >= this.zMin) {
            this.CZ[n] = f5 * this.Z[n];
            this.EZ[n] = (float)Math.exp(-this.Z2[n] * f);
        }
    }

    private void calcSP(float f, float f2, float f3, float f4, float f5) {
        this.setCE(f, f2, f3, f4, f5);
        int n = this.xMax;
        while (--n >= this.xMin) {
            int n2 = this.yMax;
            while (--n2 >= this.yMin) {
                int n3 = this.zMax;
                while (--n3 >= this.zMin) {
                    float[] fArray = this.voxelData[n][n2];
                    int n4 = n3;
                    fArray[n4] = fArray[n4] + (this.CX[n] + this.CY[n2] + this.CZ[n3]) * this.EX[n] * this.EY[n2] * this.EZ[n3];
                }
            }
        }
    }

    private void addDataD(int n) {
        if (!this.atomSet.get(this.atomIndex)) {
            this.moCoeff += 6;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, "XXYYZZXYXZYZ");
        }
        this.setMinMax();
        int n2 = this.moCoeff;
        for (int i = 0; i < n; ++i) {
            this.moCoeff = n2;
            float f = this.gaussians[this.gaussianPtr + i][0];
            float f2 = this.gaussians[this.gaussianPtr + i][1];
            float f3 = f2 * (float)Math.pow(f, 1.75) * 2.850822f;
            float f4 = f3 / 1.7320508f * this.moCoefficients[this.moCoeff++];
            float f5 = f3 / 1.7320508f * this.moCoefficients[this.moCoeff++];
            float f6 = f3 / 1.7320508f * this.moCoefficients[this.moCoeff++];
            float f7 = f3 * this.moCoefficients[this.moCoeff++];
            float f8 = f3 * this.moCoefficients[this.moCoeff++];
            float f9 = f3 * this.moCoefficients[this.moCoeff++];
            this.setCE(f, 0.0f, f4, f5, f6);
            int n3 = this.xMax;
            while (--n3 >= this.xMin) {
                this.DXY[n3] = f7 * this.X[n3];
                this.DXZ[n3] = f8 * this.X[n3];
            }
            n3 = this.yMax;
            while (--n3 >= this.yMin) {
                this.DYZ[n3] = f9 * this.Y[n3];
            }
            n3 = this.xMax;
            while (--n3 >= this.xMin) {
                float f10 = this.CX[n3] * this.X[n3];
                float f11 = this.DXY[n3];
                float f12 = this.DXZ[n3];
                int n4 = this.yMax;
                while (--n4 >= this.yMin) {
                    float f13 = f10 + (this.CY[n4] + f11) * this.Y[n4];
                    float f14 = f12 + this.DYZ[n4];
                    int n5 = this.zMax;
                    while (--n5 >= this.zMin) {
                        float[] fArray = this.voxelData[n3][n4];
                        int n6 = n5;
                        fArray[n6] = fArray[n6] + (f13 + (this.CZ[n5] + f14) * this.Z[n5]) * this.EX[n3] * this.EY[n4] * this.EZ[n5];
                    }
                }
            }
        }
    }

    private void processSlater(int n) {
        float f;
        this.atomIndex = this.slaterInfo[n][0];
        float f2 = -this.slaterData[n][0];
        if (!this.atomSet.get(this.atomIndex)) {
            if (f2 <= 0.0f) {
                ++this.moCoeff;
            }
            return;
        }
        int n2 = this.slaterInfo[n][1];
        int n3 = this.slaterInfo[n][2];
        int n4 = this.slaterInfo[n][3];
        int n5 = this.slaterInfo[n][4];
        if (f2 > 0.0f) {
            f2 = -f2;
            --this.moCoeff;
        }
        if ((f = this.slaterData[n][1] * this.moCoefficients[this.moCoeff++]) == 0.0f) {
            return;
        }
        this.setMinMax();
        int n6 = this.xMax;
        while (--n6 >= this.xMin) {
            this.X[n6] = this.xyzBohr[n6][0] - this.atomCoordBohr[this.atomIndex].x;
        }
        n6 = this.yMax;
        while (--n6 >= this.yMin) {
            this.Y[n6] = this.xyzBohr[n6][1] - this.atomCoordBohr[this.atomIndex].y;
        }
        n6 = this.zMax;
        while (--n6 >= this.zMin) {
            this.Z[n6] = this.xyzBohr[n6][2] - this.atomCoordBohr[this.atomIndex].z;
        }
        if (n2 == -2 || n3 == -2) {
            n6 = this.xMax;
            while (--n6 >= this.xMin) {
                float f3 = this.X[n6] * this.X[n6];
                int n7 = this.yMax;
                while (--n7 >= this.yMin) {
                    float f4 = this.Y[n7] * this.Y[n7];
                    int n8 = this.zMax;
                    while (--n8 >= this.zMin) {
                        float f5 = this.Z[n8] * this.Z[n8];
                        float f6 = (float)Math.sqrt(f3 + f4 + f5);
                        float f7 = f * (float)Math.exp(f2 * f6) * ((n2 == -2 ? 2.0f * f5 - f3 : f3) - f4);
                        int n9 = n5;
                        while (--n9 >= 0) {
                            f7 *= f6;
                        }
                        float[] fArray = this.voxelData[n6][n7];
                        int n10 = n8;
                        fArray[n10] = fArray[n10] + f7;
                    }
                }
            }
        } else {
            n6 = this.xMax;
            while (--n6 >= this.xMin) {
                float f8 = this.X[n6];
                int n11 = this.yMax;
                while (--n11 >= this.yMin) {
                    float f9 = this.Y[n11];
                    int n12 = this.zMax;
                    while (--n12 >= this.zMin) {
                        float f10 = this.Z[n12];
                        float f11 = (float)Math.sqrt(f8 * f8 + f9 * f9 + f10 * f10);
                        float f12 = f * (float)Math.exp(f2 * f11);
                        int n13 = n2;
                        while (--n13 >= 0) {
                            f12 *= f8;
                        }
                        n13 = n3;
                        while (--n13 >= 0) {
                            f12 *= f9;
                        }
                        n13 = n4;
                        while (--n13 >= 0) {
                            f12 *= f10;
                        }
                        n13 = n5;
                        while (--n13 >= 0) {
                            f12 *= f11;
                        }
                        float[] fArray = this.voxelData[n6][n11];
                        int n14 = n12;
                        fArray[n14] = fArray[n14] + f12;
                    }
                }
            }
        }
    }

    private void dumpInfo(int n, String string) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            float f = this.gaussians[this.gaussianPtr + n2][0];
            float f2 = this.gaussians[this.gaussianPtr + n2][1];
            if (!Logger.isActiveLevel(0)) continue;
            Logger.debug("Gaussian " + (n2 + 1) + " alpha=" + f + " c=" + f2);
        }
        n2 = string.length() / 2;
        if (Logger.isActiveLevel(0)) {
            for (int i = 0; i < n2; ++i) {
                Logger.debug("MO coeff " + string.substring(2 * i, 2 * i + 2) + " " + (this.moCoeff + i + 1) + " " + this.moCoefficients[this.moCoeff + i]);
            }
        }
    }
}

