/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.geodesic.Geodesic;
import org.jmol.modelset.Atom;
import org.jmol.shape.Dots;
import org.jmol.shape.ShapeRenderer;

public class DotsRenderer
extends ShapeRenderer {
    boolean iShowSolid;
    Vector3f[] verticesTransformed;
    int screenLevel;
    int screenDotCount;
    int[] screenCoordinates;
    int[] faceMap = null;

    protected void initRenderer() {
        this.screenLevel = Dots.MAX_LEVEL;
        this.screenDotCount = Geodesic.getVertexCount(Dots.MAX_LEVEL);
        this.verticesTransformed = new Vector3f[this.screenDotCount];
        int n = this.screenDotCount;
        while (--n >= 0) {
            this.verticesTransformed[n] = new Vector3f();
        }
        this.screenCoordinates = new int[3 * this.screenDotCount];
    }

    protected void render() {
        Dots dots = (Dots)this.shape;
        this.render1(dots);
    }

    protected void render1(Dots dots) {
        if (!this.iShowSolid && !this.g3d.setColix((short)4)) {
            return;
        }
        int n = (int)this.viewer.getScalePixelsPerAngstrom();
        this.screenLevel = this.iShowSolid || n > 20 ? 3 : (n > 10 ? 2 : (n > 5 ? 1 : 0));
        int n2 = this.screenDotCount = Geodesic.getVertexCount(this.screenLevel);
        while (--n2 >= 0) {
            this.viewer.transformVector(Geodesic.getVertexVector(n2), this.verticesTransformed[n2]);
        }
        int[][] nArray = dots.ec.getDotsConvexMaps();
        int n3 = dots.ec.getDotsConvexMax();
        while (--n3 >= 0) {
            int n4;
            Atom atom = this.modelSet.atoms[n3];
            int[] nArray2 = nArray[n3];
            if (nArray2 == null || !atom.isShapeVisible(this.myVisibilityFlag) || this.modelSet.isAtomHidden(n3) || !this.g3d.isInDisplayRange(atom.screenX, atom.screenY) || (n4 = this.calcScreenPoints(nArray2, dots.ec.getAppropriateRadius(n3), atom.screenX, atom.screenY, atom.screenZ)) == 0) continue;
            this.renderConvex(Graphics3D.getColixInherited(dots.colixes[n3], atom.getColix()), nArray2, n4);
        }
    }

    private int calcScreenPoints(int[] nArray, float f, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        float f2 = this.viewer.scaleToPerspective(n3, f);
        int n6 = Math.min(nArray.length << 5, this.screenDotCount);
        while (--n6 >= 0) {
            if (!EnvelopeCalculation.getBit(nArray, n6)) continue;
            Vector3f vector3f = this.verticesTransformed[n6];
            if (this.faceMap != null) {
                this.faceMap[n6] = n5;
            }
            this.screenCoordinates[n5++] = n + (int)((double)(f2 * vector3f.x) + (vector3f.x < 0.0f ? -0.5 : 0.5));
            this.screenCoordinates[n5++] = n2 + (int)((double)(f2 * vector3f.y) + (vector3f.y < 0.0f ? -0.5 : 0.5));
            this.screenCoordinates[n5++] = n3 + (int)((double)(f2 * vector3f.z) + (vector3f.z < 0.0f ? -0.5 : 0.5));
            ++n4;
        }
        return n4;
    }

    protected void renderConvex(short s, int[] nArray, int n) {
        this.renderDots(s, n);
    }

    protected void renderDots(short s, int n) {
        this.g3d.setColix(Graphics3D.getColixTranslucent(s, false, 0.0f));
        this.g3d.drawPoints(n, this.screenCoordinates);
    }
}

