/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.jmol.g3d.Platform3D;
import org.jmol.util.Logger;

public final class Font3D {
    public final byte fid;
    public final String fontFace;
    public final String fontStyle;
    public final short fontSize;
    public final Font font;
    public final FontMetrics fontMetrics;
    static Graphics graphicsOffscreen;
    private static final int FONT_ALLOCATION_UNIT = 8;
    private static int fontkeyCount;
    private static short[] fontkeys;
    private static Font3D[] font3ds;
    public static final int FONT_FACE_SANS = 0;
    public static final int FONT_FACE_SERIF = 1;
    public static final int FONT_FACE_MONO = 2;
    private static final String[] fontFaces;
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLDITALIC = 3;
    private static final String[] fontStyles;

    private Font3D(byte by, int n, int n2, int n3, Font font, FontMetrics fontMetrics) {
        this.fid = by;
        this.fontFace = fontFaces[n];
        this.fontStyle = fontStyles[n2];
        this.fontSize = (short)n3;
        this.font = font;
        this.fontMetrics = fontMetrics;
    }

    static synchronized void initialize(Platform3D platform3D) {
        if (graphicsOffscreen == null) {
            graphicsOffscreen = platform3D.allocateOffscreenImage(1, 1).getGraphics();
        }
    }

    static Font3D getFont3D(int n, int n2, int n3, Platform3D platform3D) {
        if (graphicsOffscreen == null) {
            Font3D.initialize(platform3D);
        }
        if (n3 > 63) {
            n3 = 63;
        }
        short s = (short)((n & 3) << 8 | (n2 & 3) << 6 | n3);
        int n4 = fontkeyCount;
        while (--n4 > 0) {
            if (s != fontkeys[n4]) continue;
            return font3ds[n4];
        }
        return Font3D.allocFont3D(s, n, n2, n3);
    }

    public static synchronized Font3D allocFont3D(short s, int n, int n2, int n3) {
        Font3D font3D;
        Font3D[] font3DArray;
        Object object;
        int n4 = fontkeyCount;
        while (--n4 > 0) {
            if (s != fontkeys[n4]) continue;
            return font3ds[n4];
        }
        if ((n4 = fontkeyCount++) == fontkeys.length) {
            object = new short[n4 + 8];
            System.arraycopy(fontkeys, 0, object, 0, n4);
            fontkeys = object;
            font3DArray = new Font3D[n4 + 8];
            System.arraycopy(font3ds, 0, font3DArray, 0, n4);
            font3ds = font3DArray;
        }
        object = new Font(fontFaces[n], n2, n3);
        if (graphicsOffscreen == null) {
            Logger.error("Font3D.graphicsOffscreen not initialized");
        }
        font3DArray = graphicsOffscreen.getFontMetrics((Font)object);
        Font3D.font3ds[n4] = font3D = new Font3D((byte)n4, n, n2, n3, (Font)object, (FontMetrics)font3DArray);
        Font3D.fontkeys[n4] = s;
        return font3D;
    }

    public static int getFontFaceID(String string) {
        if ("Monospaced".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("Serif".equalsIgnoreCase(string)) {
            return 1;
        }
        return 0;
    }

    public static int getFontStyleID(String string) {
        int n = 4;
        while (--n > 0 && !fontStyles[n].equalsIgnoreCase(string)) {
        }
        return n;
    }

    public static Font3D getFont3D(byte by) {
        return font3ds[by & 0xFF];
    }

    static {
        fontkeyCount = 1;
        fontkeys = new short[8];
        font3ds = new Font3D[8];
        fontFaces = new String[]{"SansSerif", "Serif", "Monospaced", ""};
        fontStyles = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};
    }
}

