/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.Polyhedra;

public class PolyhedraRenderer
extends ShapeRenderer {
    int drawEdges;

    protected void render() {
        Polyhedra polyhedra = (Polyhedra)this.shape;
        Polyhedra.Polyhedron[] polyhedronArray = polyhedra.polyhedrons;
        this.drawEdges = polyhedra.drawEdges;
        int n = polyhedra.polyhedronCount;
        while (--n >= 0) {
            short s = polyhedra.colixes == null ? (short)0 : polyhedra.colixes[polyhedronArray[n].centralAtom.getAtomIndex()];
            this.render1(polyhedronArray[n], s);
        }
    }

    void render1(Polyhedra.Polyhedron polyhedron, short s) {
        int n;
        int n2;
        boolean bl;
        if (polyhedron.visibilityFlags == 0) {
            return;
        }
        s = Graphics3D.getColixInherited((short)s, (short)polyhedron.centralAtom.getColix());
        Atom[] atomArray = polyhedron.vertices;
        byte[] byArray = polyhedron.planes;
        boolean bl2 = atomArray.length;
        while ((bl2 -= 1) >= false) {
            if (!atomArray[bl2].isSimple()) continue;
            atomArray[bl2].transform(this.viewer);
        }
        bl2 = this.drawEdges == 1;
        boolean bl3 = bl = this.drawEdges == 2;
        if (this.g3d.setColix(s)) {
            n2 = 0;
            n = 0;
            while (n < byArray.length) {
                this.fillFace(polyhedron.normixes[n2++], atomArray[byArray[n++]], atomArray[byArray[n++]], atomArray[byArray[n++]]);
            }
        }
        if (!this.g3d.setColix(Graphics3D.getColixTranslucent((short)s, (boolean)false, (float)0.0f))) {
            return;
        }
        n2 = 0;
        n = 0;
        while (n < byArray.length) {
            this.drawFace(polyhedron.normixes[n2++], atomArray[byArray[n++]], atomArray[byArray[n++]], atomArray[byArray[n++]], bl2, bl);
        }
    }

    void drawFace(short s, Atom atom, Atom atom2, Atom atom3, boolean bl, boolean bl2) {
        if (bl || bl2 && this.g3d.isDirectedTowardsCamera(s)) {
            this.g3d.drawCylinderTriangle(atom.screenX, atom.screenY, atom.screenZ, atom2.screenX, atom2.screenY, atom2.screenZ, atom3.screenX, atom3.screenY, atom3.screenZ, 3);
        }
    }

    void fillFace(short s, Atom atom, Atom atom2, Atom atom3) {
        this.g3d.fillTriangle(s, atom.screenX, atom.screenY, atom.screenZ, atom2.screenX, atom2.screenY, atom2.screenZ, atom3.screenX, atom3.screenY, atom3.screenZ);
    }
}

