#!/usr/bin/perl

# The LearningOnline Network with CAPA
# getcvsdate.pl - script to get CVS commit date for a file from CVS/Entries.
#
# $Id: getcvsdate.pl,v 1.1 2012/01/27 23:50:57 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use strict;

# ------------------------------------------------------------------ Invocation
my $invocation=<<END;
getcvsdate.pl [PATH TO CVS/Entries] [FILE]

END

unless (@ARGV) {
    print $invocation;
    exit 1;
}

my %month_to_twodigit = (
    Jan => '01',
    Feb => '02',
    Mar => '03',
    Apr => '04',
    May => '05',
    Jun => '06',
    Jul => '07',
    Aug => '08',
    Sep => '09',
    Oct => '10',
    Nov => '11',
    Dec => '12',
);

if (@ARGV==2) {
    my $path = $ARGV[0];
    my $file = $ARGV[1];
    my $datetime;
    if ($path ne '' && $file ne '') {
        if (-e $path) {
            if (open(my $fh,"<$path")) {
                while(<$fh>) {
                    chomp();
                    if (m{\Q$file\E/[\d.]+/+([^/]+)/}) {
                        my ($wday,$month,$day,$clock,$yr) = split(/\s+/,$1);
                        if (exists($month_to_twodigit{$month})) { 
                            $datetime = $yr.'-'.$month_to_twodigit{$month}.'-'.$day.' '.$clock.' +0000';
                        }
                        last;
                    }
                }
                close($fh);
            }
        }
    }
    print $datetime;
}

=pod

=head1 NAME

getcvsdate.pl - script to get CVS commit date for a file from CVS/Entries.

=head1 SYNOPSIS

getcvsdate.pl [PATH TO CVS/Entries] [FILE]

=head1 DESCRIPTION

getcvsdate.pl can be used to retrieve the CVS commit date/time for a prticular
file from the corresponding entry in CVS/Entries.

The date is returned in the following format:
YYYY-MM-DD HH:MM:SS +0000

where +0000 (in HHMM) is the (assumed zero) timezone offset from UTC. 

This script is invoked in Makefile (within aboutVERSION and postaboutVERSION
targets) to set the modification dates for two files containing version 
information which are modified during the LON-CAPA installation process. 
In this use case the time string generated by a call to getcvsdate.pl for 
loncapa_apache.conf and about.html is passed as the input for the date argument
in a call to the touch utility, e.g.,

touch --date="$(shell echo `perl getcvsdate.pl 
$(SOURCE)/loncom/license/CVS/Entries about.html`)" 
$(SOURCE)/loncom/license/about.html

=cut

