#!/usr/bin/perl
$|=1;
# Compares checksums for most installed files with expected values
# and reports discrepancies.
#
# $Id: lonmodulecheck.pl,v 1.4 2013/09/10 17:44:01 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use strict;

use lib '/home/httpd/lib/perl/';
use Apache::lonnet();
use Apache::lonlocal();
use LONCAPA::Configuration();
use LONCAPA::loncgi();
use LONCAPA::lonauthcgi();
use LONCAPA::Checksumming();
use LONCAPA;

my $perlvar=&LONCAPA::Configuration::read_conf('loncapa.conf');
my ($londaemons,$lonlib,$lonincludes,$lontabdir,$lonhost);
if (ref($perlvar) eq 'HASH') {
    $londaemons = $perlvar->{'lonDaemons'};
    $lonlib = $perlvar->{'lonLib'};
    $lonincludes = $perlvar->{'lonIncludes'};
    $lontabdir = $perlvar->{'lonTabDir'};
    $lonhost = $perlvar->{'lonHostID'}; 
}
undef($perlvar);

print &LONCAPA::loncgi::cgi_header('text/html',1);
if ($londaemons ne '' && $lonlib ne '' && $lonincludes ne '' && 
    $lontabdir ne '' && $lonhost ne '') {
    &main($londaemons,$lonlib,$lonincludes,$lontabdir,$lonhost);
}

sub main {
    my ($londaemons,$lonlib,$lonincludes,$lontabdir,$lonhost) = @_;
    if (&LONCAPA::lonauthcgi::check_ipbased_access('checksums')) {
        &LONCAPA::loncgi::check_cookie_and_load_env();
    } else {
        if (!&LONCAPA::loncgi::check_cookie_and_load_env()) {
            &Apache::lonlocal::get_language_handle();
            print(&LONCAPA::loncgi::missing_cookie_msg());
            return;
        }

        if (!&LONCAPA::lonauthcgi::can_view('checksums')) {
            &Apache::lonlocal::get_language_handle();
            print(&LONCAPA::lonauthcgi::unauthorized_msg('checksums'));
            return;
        }
    }

    &print_differences($londaemons,$lonlib,$lonincludes,$lontabdir,$lonhost);
    return;
}

sub print_differences {
    my ($londaemons,$lonlib,$lonincludes,$lontabdir,$lonhost) = @_;
    my $machine_dom = &Apache::lonnet::host_domain($lonhost);
    my $loncaparev = &Apache::lonnet::get_server_loncaparev($machine_dom);
    my ($version,$timestamp) = split(/\-/,$loncaparev);
    &Apache::lonlocal::get_language_handle();
    print(&Apache::loncommon::start_page('Code integrity check'));
    if ($loncaparev =~ /CVS_HEAD/) {
        print('<h3>'.
              &Apache::lonlocal::mt('Code checking unavailable for LON-CAPA CVS HEAD').
              '</h3>');
    } else {
        print('<h3>'.
              &Apache::lonlocal::mt('Code integrity check -- LON-CAPA version: [_1]',
                                    $version).
              '</h3>');
        my $distro = &LONCAPA::distro();
        if ($distro) {
            my ($serversums,$serverversions) =
                &LONCAPA::Checksumming::get_checksums($distro,$londaemons,$lonlib,
                                                      $lonincludes,$lontabdir);
            if ((ref($serversums) eq 'HASH') && (ref($serverversions) eq 'HASH')) {
                if (keys(%{$serversums}) > 0) {
                    my ($result,$numchg) =
                        &LONCAPA::Checksumming::compare_checksums('web',$lonhost,
                                                                  $version,
                                                                  $serversums,
                                                                  $serverversions);
                    print($result);
                } else {
                    print(&Apache::lonlocal::mt('No comparison attempted - failed to retrieve checksums for installed files.'));
                }
            } else {
                print(&Apache::lonlocal::mt('No comparison attempted - failed to retrieve checksums for installed files.'));
            }
        } else {
            print(&Apache::lonlocal::mt('No comparison attempted - unable to determine Linux distribution.'));
        }
    }
    print(&Apache::loncommon::end_page());
    return;
}

