#!/usr/bin/perl
$|=1;
# Prints out the Id line from most files
# $Id: lonversions.pl,v 1.9 2011/11/07 20:50:02 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use strict;

use lib '/home/httpd/lib/perl/';
use Apache::lonlocal;
use LONCAPA::Configuration;
use LONCAPA::loncgi;
use LONCAPA::lonauthcgi;

my $perlvar=&LONCAPA::Configuration::read_conf();
my ($londaemons,$lonlib,$londocroot,$lonincludes); 
if (ref($perlvar) eq 'HASH') {
    $londaemons = $perlvar->{'lonDaemons'};
    $lonlib = $perlvar->{'lonLib'};
    $londocroot = $perlvar->{'lonDocRoot'};
    $lonincludes = $perlvar->{'lonIncludes'};
}
undef($perlvar);

print &LONCAPA::loncgi::cgi_header('text/html',1);
if ($londaemons ne '' && $lonlib ne '' && $londocroot ne '' && $lonincludes ne '') {
    &main($londaemons,$lonlib,$londocroot,$lonincludes);
}

sub main {
    my ($londaemons,$lonlib,$londocroot,$lonincludes) = @_;
    if (!&LONCAPA::lonauthcgi::check_ipbased_access('codeversions')) {
        if (!&LONCAPA::loncgi::check_cookie_and_load_env()) {
            &Apache::lonlocal::get_language_handle();
            print(&LONCAPA::loncgi::missing_cookie_msg());
            return;
        }

        if (!&LONCAPA::lonauthcgi::can_view('codeversions')) {
            &Apache::lonlocal::get_language_handle();
            print(&LONCAPA::lonauthcgi::unauthorized_msg('codeversions'));
            return;
        }
    }

    &Apache::lonlocal::get_language_handle();
    &print_versions($londaemons,$lonlib,$londocroot,$lonincludes);
    return;
}

sub print_versions {
    my ($londaemons,$lonlib,$londocroot,$lonincludes) = @_;
    print '<html><body bgcolor="#FFFFFF"><h1>'.&Apache::lonlocal::mt('Handler Versions').'</h1>'.
          "<pre>\n";
    my $revtag = '$Id:';
    open (DFH, "grep '$revtag' $londaemons/* $lonlib/perl/Apache/*.pm $lonlib/perl/LONCAPA/*.pm $lonincludes/* $londocroot/res/adm/pages/* |");
    while (my $line=<DFH>) {
        chomp($line); 
        unless ($line =~ /\Q.lpmlsave:# \E\$Id/) { 
            print "$line\n";
        }
    }
    close(DFH);
    print '</pre></body></html>';
}
