# The LearningOnline Network with CAPA
# Chinese Simplified Localization Lexicon
#
# $Id: zh.pm,v 1.127 2014/04/25 18:00:53 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::zh;
use base qw(Apache::localize);

%Lexicon=('_AUTO' => 1,
'char_encoding'=> 'UTF-8',
'language_code'=> 'zh',
'lang_locale' => 'zh-cn.utf8',
'date_locale'  =>
      '$weekday, $day. $month $year, $twentyfour:$minutes:$seconds',
'date_months'  => '一月,二月,三月,四月,五月,六月,七月,八月,九月,十月,十一月,十二月',
'date_days'    => '星期日,星期一,星期二,星期三,星期四,星期五,星期六',
'date_am' => '上午',
'date_pm' => '下午',
'htmlarea_lang' => 'zh-cn',

   'Deutsch - UTF' # do not translate
=> 'Deutsch - UTF',

   'English - UTF' # do not translate
=> 'English - UTF',

   'Português - UTF' # do not translate
=> 'Português - UTF',

   'español (castellano) - UTF' # do not translate
=> 'español (castellano) - UTF',

   'français - UTF' # do not translate
=> 'français - UTF',

   'türkçe - UTF' # do not translate
=> 'türkçe - UTF',

   'Русский - UTF' # do not translate
=> 'Русский - UTF',

   'עברית - UTF' # do not translate
=> 'עברית - UTF',

   '日本語 - UTF' # do not translate
=> '日本語 - UTF',

   '简体中文 - UTF' # do not translate
=> '简体中文 - UTF',

   'ﺍیﺭﺎﻧی - UTF' # do not translate
=> 'ﺍیﺭﺎﻧی - UTF',

   'ﺎﻠﻋﺮﺒﻳﺓ - UTF' # do not translate
=> 'ﺎﻠﻋﺮﺒﻳﺓ - UTF',

   'Swedish Chef - UTF'
=> 'Swedish Chef - UTF',

   'Domain'
=> '领域',

   'Domain:'
=> '领域：',

   'Server'
=> '服务器',

   'Server Load'
=> '服务器负载',

   'User Load'
=> '用户负载',

   'Help'
=> '帮助',

   'Log in'
=> '登录',

   'Log-in to LON-CAPA'
=> '登录 LON-CAPA',

   'Username'
=> '用户名',

   'Password'
=> '密码',

   'choose'
=> '选择',

   'enter'
=> '进入',

   'view'
=> 'view',

   'calendar'
=> '日历',

   'prefer-'
=> 'prefer-',

   'ences'
=> 'ences',

   'role'
=> '角色',

   'course'
=> '课程',

   'Course'
=> '课程',

   'Section/Group'
=> '科/组',

   'today'
=> '今日',

   'last week'
=> '上周',

   'last month'
=> '上个月',

   'last three months'
=> '过去3个月',

   'last six months'
=> '过去6个月',

   'last year'
=> '去年',

   'Submit'
=> '提交',

   'Rename'
=> '重命名',

   'Save'
=> '保存',

   'Save All'
=> '全部保存',

   'Done'
=> '完成',

   'Select User'
=> '选择用户',

   'Select Course'
=> '选择课程',

   'Changes will become active for your current session after'
=> 'Changes will become active for your current session after',

   're-initializing course'
=> '课程重新初始化',

   ', or the next time you log in.'
=> '，或在您下次登录。',

   'Uploaded Document'
=> '上传文件',

   'No content modifications yet.'
=> '还没有修改任何内容。',

   'Part is not open to be viewed. It'
=> 'Part is not open to be viewed. It',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Unable to determine if this resource is open due to network problems. Please try again later.',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> '注意：所有用户更改生效可能需要10分钟。',

   'Language'
=> '语言',

   'Notes'
=> '注释',

   'Abstract'
=> '摘要',

   'Create a user or modify the roles and privileges of a user'
=> '创建或修改用户的角色和权限',

   'View course assessment statistics'
=> '查看课程评估统计',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> '设置最后期限和其他评估参数，以及修改课程环境',

   'New Folder'
=> '新建文件夹',

   'Simple Page'
=> '简单的页面',

   'Simple Problem'
=> '简单的问题',

   'Upload Document'
=> '上传文件',

   'Search'
=> '搜索',

   'Import'
=> '导入',

   'Main Course Documents'
=> '主要课程文件',

   'Supplemental Course Documents'
=> '附加的课程文件',

   'Discussion Board'
=> '公告板',

   'Published Resources'
=> '发布的资源',

   'Special Documents'
=> '特别文件',

   'Special documents'
=> '特别文件',

   'Document'
=> '文件',

   'Settings'
=> '设置',

   'create'
=> '创建',

   'grades'
=> '评估',

   'commu-'
=> 'commu-',

   'nication'
=> 'nication',

   'enroll'
=> '记录',

   'navigate'
=> '目录',

   'contents'
=> '导航',

   'Navigate Contents'
=> '浏览目录',

   'Announcements and Calendar'
=> '注意事项和日历',

   'Author'
=> '作者',

   'Change Your Preferences'
=> '更改用户首选项',

   'Choose the user role'
=> '更换用户角色',

   'Co-Author'
=> '合著者',

   'Co-Author [_1]'
=> '合著者 [_1]',

   'Communication and Messages'
=> '通信与信息',

   'Course Coordinator'
=> '课程组织者',

   'Course Statistics and Charts'
=> '课程统计和图表',

   'Course announcements and my calendar'
=> '注意事项和日历',

   'Course Announcements'
=> '课程公告',

   'Create Users, Change User Privileges'
=> 'Create Users, Change User Privileges',

   'Domain Coordinator'
=> 'Domain Coordinator',

   'Enrollment Manager'
=> 'Enrollment Manager',

   'Enter grades from check-out assessment resources'
=> 'Enter grades from check-out assessment resources',

   'Exam Proctor'
=> '监考人员',

   'Exit LON-CAPA'
=> '退出',

   'Grades Spreadsheet'
=> '等级表',

   'Grading'
=> '评估',

   'Instructor'
=> '讲师',

   'Launch Remote Control'
=> '激活远程控制',

   'Main Menu'
=> '主菜单',

   'Navigate Course Contents'
=> '浏览目录',

   'No Role, Cumulative Privileges'
=> '没有角色，增加特权',

   'Return to Last Location'
=> '回到最后的位置',

   'Send and receive messages'
=>'发送和接收邮件',

   'Send and Receive Messages'
=>'发送和接收邮件',

   'Set my user preferences'
=> '用户设置',

   'Student'
=> '学生',

   'Student: '
=> '学生：',

   'Switch to another user role'
=> '更换用户角色',

   'Teaching Assistant'
=> '教学助理',

   'Use or edit my bookmark collection'
=> '书签收藏',

   'User Roles'
=> '用户角色',

   'Calculate course grades (Spreadsheet)'
=> 'Calculate course grades (Spreadsheet)',

   'Enter the chat room for the course'
=> '课程聊天室',

   'Navigate the table of contents for this course'
=> '课程目录',

   'Syllabus'
=> '课程表',

   'Course syllabus'
=> '课程教学大纲',

   'View the course assessment progress chart'
=> '察看课程评估进展图表',

   'Class Hours'
=> '课时',

   'Coursepack'
=> '课外书',

   'Current Month'
=> '这个月',

   'Deadlines'
=> '截止日期',

   'Grading Information'
=> '评估信息',

   'Helproom Hours'
=> '帮助',

   'Instructor Information'
=> '讲师信息',

   'Next Month'
=> '下个月',

   'Office Hours'
=> '办公时间',

   'Prerequisites'
=> '必要条件',

   'Previous Month'
=> '上个月',

   'Readings'
=> '材料',

   'Mon'
=> '星期一',

  'Tue'
=> '星期二',

   'Wed'
=> '星期三',

   'Thu'
=> '星期四',

   'Fri'
=> '星期五',

   'Sat'
=> '星期六',

   'Sun'
=> '星期日',

   'January'
=> '一月',

   'February'
=> '二月',

   'March'
=> '三月',

   'April'
=> '四月',

   'May'
=> '五月',

   'June'
=> '六月',

   'July'
=> '七月',

   'August'
=> '八月',

   'September'
=> '九月',

   'October'
=> '十月',

   'November'
=> '十一月',

   'December'
=> '十二月',

   'Textbook'
=> '教材',

    'Web Links'
=> '网站链接',

   'Drop/Add students in this course'
=> '在该课程移除/添加学生',

   'A score has been assigned.'
=> 'A score has been assigned.',

   'Some parts were not submitted.'
=> 'Some parts were not submitted.',

   'Due'
=> 'Due',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'The filetype extension of the file you uploaded is not allowed.',

   'Units incorrect.'
=> '单位不正确的。',

   'Only a number required.'
=> '只允许一个数字。Only a number required.',

   'Units required'
=> '要求单位',

   'Tries'
=> '尝试',

   'Submit Answer'
=> '提交答案',

   'Prepare a printable document'
=> '打印',

   'Go To My First Homework Problem'
=> '转到我的第一次作业问题',

   'Cancel'
=> '取消',

   'Discussions'
=> '讨论',

   'New discussion since'
=> 'New discussion since',

   'New message (click to open)'
=> '新邮件 (点击查看)',

   'Close all folders'
=> '关闭所有文件夹',

   'Open all folders'
=> '打开所有文件夹',

   'Goodbye'
=> '再见',

   'Select'
=> '选择',

   'Re-Initialize'
=> '重新初始化',

   'Currently selected.'
=> '目前选定的。',

   'Switch Server'
=> '选择服务器',

   'system wide'
=> '全系统的',

   'Currently not available'
=> '目前无法使用',

   'No role specified'
=> '没有具体的角色',

   'Remark'
=> '注释',

   'Extent'
=> '领域',

   'Current Privileges'
=> '当前权限',

   'User Role'
=> '用户角色',

   'Start'
=> '开始',

   'End'
=> '结束',

   'System'
=> '系统',

   'Display'
=> '显示',

   'Display:'
=> '显示:',

   'Do not display'
=> '不显示',

   "an unknown date"
=> '日期不详', # !

   "an indeterminate date"
=> '无限期',

   'will open on [_1]'
=> '开放于 [_1]',

   'is due at [_1]'
=> 'is due at [_1]',

   'was due on [_1], and answers will be available on [_2]'
=> 'was due on [_1], and answers will be available on [_2]',

   'is closed but you are allowed to view it'
=> "is closed but you are allowed to view it",

   "Undid changes, Switched [_1] and [_2]"
=> "Undid changes, Switched [_1] and [_2]",

   "Unable to undo, unable to switch [_1] and [_2]"
=> "Unable to undo, unable to switch [_1] and [_2]",

   "Unable to make backup [_1]"
=> "Unable to make backup [_1]",

   "Saving Modifications to [_1]"
=> "Saving Modifications to [_1]",

   "Unable to write to [_1]"
=> "Unable to write to [_1]",

   "Analyzing a problem"
=> "Analyzing a problem",

   "EditXML"
=> "EditXML",

   'Discard Edits and View'
=> 'Discard Edits and View',

   'Submit Changes'
=> 'Submit Changes',

   'Submit Changes and View'
=> 'Submit Changes and View',

   'Edit'
=> '编辑',

   ', select a template from the pull-down menu below'
=> ', select a template from the pull-down menu below',

   'undo'
=> 'undo',

   'Answer'
=> 'Answer',

   'Frequency'
=> 'Frequency',

   'You did not select a template.'
=> 'You did not select a template.',

   'Analyze Progress'
=> 'Analyze Progress',

   'Getting Problem Variants'
=> 'Getting Problem Variants',

   'last problem'
=> 'last problem',

   "may open later."
=> 'may open later.',

   "Select a"
=> "Select a",

   'Part'
=> '部分',

   "Then"
=> 'Then',

   'is in under construction'
=> 'is in under construction',

   'List of possible answers'
=> 'List of possible answers',

   'Response [_1] is not analyzable at this time'  #    'is not analyzable at this time'
=> 'Response [_1] is not analyzable at this time',  #   '目前没有可分析性',

   'Title'
=> '标题',

   'Path'
=> 'Path',

   'New Search'
=> '重新搜索',

   'Go Back'
=> '后退',

   'Go back'
=> '后退',

   'File'
=> '文件',

   'Date'
=> '日期',

   'You have no unread messages'
=> '您没有未读邮件',

   'New Message'
=> '新邮件',

   'New Messages'
=> '新邮件',

   'View All Messages'
=> '查看所有邮件',

   'Map'
=> '课程内容',

   'Page'
=> '页',

   'Page:'
=> '页：',

   'Sequence'
=> '顺序',

   'Map contents are not shown in order.'
=> '课程内容不排序显示。',

   'Empty'
=> '空的',

   'File [_1] could not be copied.'
=> '文件 [_1] 无法复制。',

   'Back to Directory'
=> '返回文件夹',

   'No upload file specified.'
=> '没有上传指定的文件。',

   'The target is an existing directory.'
=> '目标在一个现有的目录中。',

   'Please use browser "Back" button and pick a filename'
=> 'Please use browser "Back" button and pick a filename',

   "You do not have authoring privileges for this resource"
=> "You do not have authoring privileges for this resource",

   'Copying file'
=> '复制文件',

   'No write permission to user directory, FAIL'
=> '没有权限写入这个目录。中断',

   'Actions'
=> '动作', # '行动',

   'Name'
=> '名字',

   'Status'
=> '状态',

   'Last Modified'
=> '最后修改',

   'Yes'
=> '是',

   'Authoring Space Directory'
=> 'Authoring Space Directory', # '建设目录',

   'Contact [_1] for access.'
=> '获取 [_1] 联系。',

   'Please log into [_1] to edit.'
=> '请登入 [_1] 进行修改。',

   'Save uploaded file as [_1]'
=> '保存上传的文件为 [_1]',

   'Searching'
=> '搜索',

   'Searching ...'
=> '搜索...',

   'Owner:Domain'
=> '所有者：域',

   'Owner/Co-owner(s)'
=> '所有者/合伙人',

   'Select the Authoring Space'
=> 'Select the Authoring Space', # '选择建设领域',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'It is recommended that you use an up-to-date virus scanner before handling this file.',

   'not displayed'
=> '不显示',

   "Open, no due date"
=> "开放的，没有截止日期",

   "Uncompleted Homework"
=> "未完成家庭作业",

   "Show Only Uncompleted Homework"
=> "只显示未完成家庭作业",

   "All homework is currently completed."
=> "目前所有完成的功课。",

   'This course is empty.'
=> '这课程是空的。',

   'Coursemap undefined.'
=> '课程内容没有定义。',

   "Was due"
=> "截止于",

   "Answer available"
=> "答案可用",

   "Excused by instructor"
=> "由讲师通过",

   "Answer submitted, not yet graded"
=> "提交答案，尚未评分",

   "No due date"
=> "没有截止日期",

   'never'
=> '从来不',

   'Answer submitted'
=> '提交答案',

   '[_1] of [_2] tries used'
=> '[_1] 的 [_2] 尝试使用',

   'Processing'
=> '数据处理',

   'Access and Usage Statistics'
=> '访问和使用统计',

   'Evaluation Comments'
=> '评价评论',

   'Evaluation Data'
=> '评价数据',

   'Server Administration'
=> '服务器管理',

   'System Administration'
=> '系统管理',

   'Users with Roles Assigned by'
=> 'Users with Roles Assigned by',

   'Name starting with'
=> '从开头',

   'This resource has been marked obsolete by the author(s)'
=> 'This resource has been marked obsolete by the author(s)',

   'Upload'
=> '上传',

   'Uploaded'
=> '已上传',

   'Dynamic Metadata'
=> '动态数据',

   'View file'
=> '查看文件',

   'Illegal filename.'
=> '无效的文件名。',

   'Rule'
=> '规则',

   'Back to Source Directory'
=> '回到源目录',

   'Back to Source'
=> '回到源文件',

   'Back to Resource'
=> 'Back to Resource', # '回到资源',

   'File copied.'
=> '档案复制。',

   'FAIL'
=> '中断',

   'Back to [_1]'
=> '回到 [_1]',

   'untitled'
=> '无标题',

   'The extension on this file, [_1], is reserved internally by LON-CAPA.'
=> 'The extension on this file, [_1], is reserved internally by LON-CAPA.',

   'The extension on this file is reserved internally by LON-CAPA.'
=> 'The extension on this file is reserved internally by LON-CAPA.',

   'The extension on this file, [_1], is not recognized by LON-CAPA.'
=> 'The extension on this file, [_1], is not recognized by LON-CAPA.',

   'The extension on this file is not recognized by LON-CAPA.'
=> 'The extension on this file is not recognized by LON-CAPA.',

   'Please change the extension.'
=> 'Please change the extension.',

   'Became this version on ...'
=> 'Became this version on ...',

   'Browse published resources'
=> '发布资源',

   'Choose the course to work on'
=> '选择您想要选的课程',

   'Create a new course'
=> '创建课程',

   'Customized right of use ...'
=> 'Customized right of use ...',

   'Delete messages from discussion boards'
=> 'Delete messages from discussion boards',

   'Domain only - use limited to courses in the domain'
=> 'Domain only - use limited to courses in the domain',

   'Edit and view documents included in this course'
=> '布置课程内容',

   'Edit/Modify DOCS'
=> '布置课程内容',

   'Enter my Authoring Space'
=> 'Enter my Authoring Space',

   'Failed to copy source'
=> 'Failed to copy source',

   'Failed to write metadata copy'
=> 'Failed to write metadata copy',

   'Finalize Publication'
=> 'Finalize Publication',

   'Grant/revoke role of Co-Author'
=> 'Grant/revoke role of Co-Author',

   'Grant/revoke role of Domain Coordinator'
=> 'Grant/revoke role of Domain Coordinator',

   'Grant/revoke role of Exam Proctor'
=> 'Grant/revoke role of Exam Proctor',

   'Grant/revoke role of Instructor'
=> 'Grant/revoke role of Instructor',

   'Grant/revoke role of Student'
=> 'Grant/revoke role of Student',

   'Grant/revoke role of Superuser'
=> 'Grant/revoke role of Superuser',

   'No previous versions published.'
=> 'No previous versions published.',

   'No write permission to'
=> 'No write permission to',

   'Please pick a version to retrieve:'
=> 'Please pick a version to retrieve:',

   'Private - visible to author only for testing purposes'
=> 'Private - visible to author only for testing purposes',

#   'Private Publication - did not synchronize database'
#=> 'Private Publication - did not synchronize database',

   'Public - no authentication or authorization required for use'
=> 'Public - no authentication or authorization required for use',

   'Retrieval of an old version will overwrite the file currently in Authoring Space.'
=> 'Retrieval of an old version will overwrite the file currently in Authoring Space.',

   'Retrieve selected Version'
=> 'Retrieve selected Version',

   'Retrieve previous version'
=> 'Retrieve previous version',

   'Retrieve previous versions of [_1]'
=> 'Retrieve previous versions of [_1]',

   'Search the contents of this course'
=> '课程内容搜索',

   'Search the database of published resources and accessible portfolio files'
=> '搜索数据库资源和文件夹',

   'Send broadcast and receipt-required email'
=> 'Send broadcast and receipt-required email',

   'Show Problem Completeness'
=> 'Show Problem Completeness',

   'Switch to another course'
=> 'Switch to another course',

   'System wide - can be used for any courses system wide'
=> '全系统-可用于全系统任何课程',

   'The extension on this file'
=> 'The extension on this file',

   'Unsupported character combination [_1] in filename, FAIL.'
=> 'Unsupported character combination [_1] in filename, FAIL.',

   'No valid extension found in filename, FAIL'
=> 'No valid extension found in filename, FAIL',

   'Filename of resource contains internal version number. Cannot publish such resources, FAIL'
=> 'Filename of resource contains internal version number. Cannot publish such resources, FAIL',

   'No valid custom distribution rights file specified, FAIL'
=> 'No valid custom distribution rights file specified, FAIL',

   'Could not write metadata, FAIL'
=> 'Could not write metadata, FAIL',

   'View documents included in this course'
=> '附加的课程文件',

   'Additional Keywords'
=> '其他关键字',

   'Additional Metadata (non-standard, parameters, exports)'
=> '其他元数据 (没有标准化，参数，导出)',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> '作者和共同作者的角色可能无法使用服务器上以外的其他家庭服务器。',

   'Author(s)'
=> '作者',

   'Average number of tries till solved'
=> '平均人数，尝试成功解答的',

   'Browse Resources'
=> '浏览资源',

   'Catalog Information'
=> '目录信息',

   'Collapse Remote Control'
=> '禁用远程控制',

   'Authoring Space'
=> 'Authoring Space',

   'Copied metadata'
=> '复制元数据',

   'Copied source file'
=> '复制源文件',

   'Copyright/Distribution'
=> '版权/权限',

   'Copyright/Distribution:'
=> '版权/权限：',

   'Course Documents'
=> '课程文件',

   'Creation Date'
=> '创建日期',

   'Custom Distribution File'
=> '自定义文件访问权限',

   'Degree of difficulty'
=> '难度',

   'Copy Course Content to Authoring Space'
=> 'Copy Course Content to Authoring Space',

   'Copying content to Authoring Space requires switching server.'
=> 'Copying content to Authoring Space requires switching server.',

   'Entering course ...'
=> '进入课程...',

   'Exam Information'
=> '考试信息',

   'External Resource'
=> '外部资源',

   'Generate new role ...'
=> '创建新的角色...',

   'Go to the next resource in the course sequence'
=> '前进',

   'Go to the previous resource in the course sequence'
=> '后退',

   'Import a published document'
=> '导入出版文件',

   'Keyword(s)'
=> '密码',

   'Logged Out'
=> '登出',

   'MIME Type'
=> 'MIME类型',

   'Make notes and annotations about this resource'
=> '备忘录',

   'The material is covered with sufficient depth'
=> '这些主题包含有足够的难度',

   'Metadata Information'
=> '元数据信息',

   'My Personal Info'
=> '我的个人网页',

   'Network-wide number of accesses (hits)'
=> '网络的访问数量（“点击”）',

   'Network-wide number of courses using resource'
=> '使用该课程资源的访问数量',

   'Number of resources that follow this resource in maps'
=> '该资源目录汇编之后的访问数量',

   'Number of resources that lead up to this resource in maps'
=> '该资源目录汇编之前的访问数量',

   'Number of resources using or importing resource'
=> '资源数量的使用或导入',

   'Obsolete'
=> '过时的',

   'Parent Directory'
=> '父目录',

   'Project Information'
=> '项目信息',

   'Publisher/Owner'
=> '出版社/所有人',

   'Publishing'
=> '出版物:',

   'Publishing [_1]'
=> '出版物: [_1]',

   'Resource Details'
=> 'Resource Details',

   'Link to Resource'
=> 'Link to Resource',

   'Searching for your resource will be based on the following metadata. Please provide as much data as possible.'
=> 'Searching for your resource will be based on the following metadata. Please provide as much data as possible.',

   'Resource Publication'
=> 'Resource Publication',

   'Resource is technically correct'
=> 'Resource is technically correct',

   'Score Upload Form'
=> '分数上传表单',

   'Select Map'
=> '选择内容列表',

   'Load Map'
=> '上传',

   'Set a bookmark for this resource'
=> '设定书签',

   'Show all roles'
=> '显示所有角色',

   'Subject'
=> '主题',

   'Successful Login'
=> '登录成功',

   'Suggested Replacement for Obsolete File'
=> '建议更换过时文件',

   'Switching Role'
=> '更换角色',

   'Target'
=> '目标',

   'This syllabus can be publicly viewed at [_1]'
=> '此课程可公开浏览： [_1]',

   'Instead of using this template you can specify an external URL as Syllabus in the [_1]Course Parameters[_2].'
=> '如果不使用此模板，您可以在[_1]课程参数[_2]指定外部网址作为课程摘要。',

   'Total number of students who have worked on this problem'
=> '回答该问题的学生总数',

   'URLs To Include in Syllabus'
=> '网址，包括教学大纲',

   'Upload a new main course document'
=> '外部文件',

   'Upload a new supplemental course document'
=> '附加的课程文件',

   'User'
=> '用户',

   'Wrote Metadata'
=> 'Wrote Metadata',

   'Your home server is '
=> 'Your home server is ',

   'anno-'
=> 'anno-',

   'announce'
=> 'announce',

   'bookmark'
=> 'bookmark',

   'chart'
=> 'chart',

   'chat'
=> '聊天室',

   'close this window'
=> 'close this window',

   'con-'
=> 'con-',

   'docs'
=> 'docs',

   'exit'
=> '退出',

   'fas'
=> 'fas',

   'library'
=> 'library',

   'log in again'
=> 'log in again',

   'my'
=> 'my',

   'or'
=> 'or',

   'Or'
=> 'Or',

   'prepare'
=> 'prepare',

   'printout'
=> 'printout',

   'resource'
=> 'resource',

   'roles'
=> '角色',

   'search'
=> '查找',

   'set'
=> 'set',

   'space'
=> '领域',

   'stats'
=> 'stats',

   'struct'
=> 'struct',

   'switch'
=> 'switch',

   'tations'
=> 'tations',

   'updated periodically'
=> '定期更新',

   'user'
=> '用户',

   'visible to author and co-authors only'
=> '只有作者和共同作者可见',

   'All versions'
=> '所有版本',

   'Default Metadata for Directory [_1]'
=> '默认元数据目录 [_1]',

   'Error Messages'
=> '错误信息',

   'Save Catalog Information'
=> '保存目录信息',

   'Update Display'
=> '更新显示',

   'Content changed'
=> '内容变化',

   'Differences'
=> '差异',

   'Last Week'
=> '上周',

   'Modification Date'
=> '修改日期',

   'Since Start of Course'
=> '从启动课程起',

   'Since Yesterday'
=> '从昨天起',

   'Verify Course Documents'
=> '验证课程文件',

   'Version'
=> '版本',

   'access denied'
=> '拒绝访问',

   'connection down'
=> 'connection down',

   'during the last'
=> 'during the last',

   'not found'
=> 'not found',

   'warning(s)'
=> 'warning(s)',

   '[quant,_1,warning]'
=> '[quant,_1,warning]',

   'Advanced Catalog Search'
=> 'Advanced Catalog Search',

   'Advanced Search'
=> '高级搜索',

   'Any Language'
=> '任何语言',

   'Any category'
=> '任何类别',

   'Any copyright/distribution'
=> '任何版权/访问权限',

   'Broadcast Message to Course'
=> '发送广播消息',

   "Click to download or use your browser's Save Link function"
=> "Click to download or use your browser's Save Link function",

   'Close'
=> '关闭',

   'Compact View'
=> '简洁视图',

   'Detailed Citation View'
=> '查看详细引文',

   'Distribute Messages from Uploaded File to Course'
=> 'Distribute Messages from Uploaded File to Course',

   'Edit Catalog Information'
=> '编辑目录信息',

   'Edit Content of a Map'
=> 'Edit Content of a Map',

   'Edit Directory Catalog Information'
=> '编辑目录信息分类',

   'Evaluate Resource'
=> '评估此资源',

   'Failed Access to Authoring Space'
=> 'Failed Access to Authoring Space',

   'Fielded Format'
=> '字段格式',

   'File Category'
=> '文件分类',

   'Force publication of unmodified files'
=> 'Force publication of unmodified files',

   'Keywords'
=> '关键词',

   'Last access'
=> '上次访问',

   'Last modified'
=> '最后修改',

   'Limit by copyright/distribution'
=> '受版权/访问权限限制',

   'Limit by language'
=> '受语言限制',

   'Open'
=> '打开',

   'Per Page'
=> '每页',

   'Printing Helper'
=> '打印助手',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> '反馈意见或讨论',

   'Provide my evaluation of this resource'
=> '对此资源给出我的评价',

   'Publish'
=> '发布',

   'Publish Directory'
=> '发布目录',

   'Publish Directory and Sub Directories'
=> '发布目录和子目录',

   'Related'
=> '相关的',

   'Resource Feedback and Discussion'
=> '资源的反馈和讨论',

   'Search Complete'
=> '搜索完成',

   'Send Message to User(s)'
=> '发送讯息到用户',

   'Show catalog information'
=> '查看目录信息',

   'Show Metadata'
=> '查看元数据',

   'Show resource'
=> '查看资源',

   'Statistics'
=> '统计',

   'Summary View'
=> '概要',

   'There are currently no results.'
=> '目前没有任何结果。',

   'Search: '
=> '搜索： ',

   'URL'
=> 'URL',

   'Unpublished'
=> '未发行的',

   'Up'
=> 'Up',

   'View'
=> '查看',

   'View Critical Messages'
=> '浏览重要讯息',

   'Words'
=> '词',

   'XML/SGML'
=> 'XML/SGML',

   'abstract'
=> 'abstract',

   'audio'
=> '音频',

   'author'
=> '作者',

   'catalog'
=> '目录',

   'copyright'
=> '版权',

   'directory'
=> '文件夹',

   'discuss'
=> 'discuss',

   'evaluate'
=> '评价',

   'feedback'
=> '反馈',

   'keywords'
=> '关键词',

   'language'
=> '语言',

   'movies'
=> '电影',

   'notes'
=> '注释',

   'obsolete'
=> '过时的',

   'pages'
=> '页',

   'pictures'
=> '图片',

   'problem'
=> '任务',

   'resources'
=> '资源',

   'sequence'
=> '顺序',

   'subject: '
=> '主题',

   'this'
=> '这个',

   'title'
=> '标题',

   'About Me'
=> '关于我',

   'Discussion Board/Discussion'
=> 'Discussion Board/Discussion',

   'Clear All'
=> '全部清除',

   'Close All Folders'
=> '关闭所有文件夹',

   'Authoring Space File Operation'
=> 'Authoring Space File Operation',

   'Contact Information'
=> '联系信息',

   'Contact'
=> '联系我',

   'Copied old metadata'
=> '复制旧数据',

   'Failed to write old metadata copy'
=> 'Failed to write old metadata copy',

   'Copied old target file'
=> '复制旧的目标文件',

   'Failed to copy old target'
=> 'Failed to copy old target',

   'Created directory [_1]'
=> 'Created directory [_1]',

   'Copyright'
=> '版权',

   'Could Not Process Request'
=> '命令无法执行',

   'Default'
=> '默认设置',

   'Discard Selected'
=> 'Discard Selected',

   'EMail and Messages'
=> '电子邮件和信息',

   'Edit this resource'
=> '编辑此资源',

   'Enter Authoring Space as co-author'
=> 'Enter Authoring Space as co-author',

   'Enter Authoring Space as a co-author'
=> 'Enter Authoring Space as a co-author',

   'Enter Authoring Space as assistant co-author'
=> 'Enter Authoring Space as assistant co-author',

   'Host'
=> '计算',

   'Last updated'
=> '最后更新',

   'Mime type'
=> 'MIME 类型',

   'Modified'
=> '修改过的',

   'Modify deadlines, etc, for this assessment resource'
=> '为这项评估资源修改期限等',

   'Modify user grades for this assessment resource'
=> '手动评估',

   'View user submissions for this assessment resource'
=> 'View user submissions for this assessment resource',

   'Move Down'
=> '下移',

   'Move Up'
=> '上移',

   'New Title'
=> '新标题',

   'Open All Folders'
=> '打开所有文件夹',

   'Owner/Publisher'
=> '所有者/出版社',

   'Personal Information Page'
=> '个人资料页面',

   'Personal Information'
=> '个人信息',

   'Privacy Note:'
=> '注意隐私:',

   'Published'
=> '出版的',

   'Reading results from'
=> 'Reading results from',

   'Retrieve'
=> '恢复',

   'Revert to Last Saved'
=> 'Revert to Last Saved',

   'Revision Date'
=> 'Revision Date',

   'Shared by course faculty and staff'
=> '共同管理人员和工作人员',

   'Synchronized SQL metadata database'
=> 'Synchronized SQL metadata database',

   'Task'
=> 'Task',

   'Temporary Assembly Workspace'
=> 'Temporary Assembly Workspace',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> '任何登录LON-CAPA的人都能看到您提供的数据，如果不想公开就不要上传任何数据。',

   'Topic'
=> '主题',

   'Upload a Photo'
=> '上传相片',

   'Add Records'
=> '添加记录',

   'User Notes, Face-to-Face, Critical Messages, Broadcast Messages, Archived Messages'
=> '用户注释， 个人讨论， 重要信息， 小区广播，存档信息',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> '用户注释，记录用户的讨论和重要信息',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> '用户注释，记录面对面的讨论，课程重要讯息',

   'User Notes, Records of Face-To-Face Discussions, Critical Messages, Broadcast Messages and Archived Messages in Course'
=> '用户注释，记录面对面讨论，重要的信息，广播信息，课程存档',

   'No notes, face-to-face discussion records, critical messages or broadcast messages in this course.'
=> 'No notes, face-to-face discussion records, critical messages or broadcast messages in this course.', # '对于 [_1] 没有用户注释, 记录用户的讨论, 重要信息, 或者广播信息。',

   'No notes, face-to-face discussion records, critical messages or broadcast messages in this community.'
=> 'No notes, face-to-face discussion records, critical messages or broadcast messages in this community.', # '对于 [_1] 没有用户注释, 记录用户的讨论, 重要信息, 或者广播信息。',

   'Version Number'
=> '版本号',

   'View Published Version'
=> '查看发布的版本',

   'Web References'
=> 'Web 引用',

   'co con-'
=> 'co con-',

   'co res'
=> 'co res',

   'contacting'
=> '建立联系',

   'edit'
=> '编辑',

   'interface available'
=> 'interface available',

   'missions'
=> '任务',

   'view sub-'
=> 'view sub-',

   'waiting on'
=> 'waiting on',

   '#Stdnts'
=> '#Stdnts',

   '#YES'
=> '#YES',

   '%Wrng'
=> '%Wrng',

   'Brief view of each students performance in course.'
=> 'Brief view of each students performance in course.',

   'Clear Caches'
=> '清除缓存',

   'Course Statistics and Charts cannot be retrieved until the database is restarted. Your data is intact but cannot be displayed at this time.'
=> 'Course Statistics and Charts cannot be retrieved until the database is restarted. Your data is intact but cannot be displayed at this time.',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Detailed statistics and graphs of student performance on problems.',

   'DoDiff'
=> 'DoDiff',

   'Enrollment Status'
=> 'Enrollment Status',

   'Generate Statistics'
=> '建立统计资料',

   'Max Tries'
=> 'Max Tries',

   'Mean Tries'
=> 'Mean Tries',

   'Output'
=> 'Output',

   'Overall Problem Statistics'
=> 'Overall Problem Statistics',

   'Please notify the server administrator [_1]'
=> 'Please notify the server administrator [_1]',

   'Preparing Excel Spreadsheet'
=> 'Preparing Excel Spreadsheet',

   'Problem Status Chart'
=> 'Problem Status Chart',

   'S.D. tries'
=> 'S.D. tries',

   'Sections'
=> 'Sections',

   'Sequence or Folder'
=> 'Sequence or Folder',

   'Sequences and Folders'
=> 'Sequences and Folders',

   'Skew Tries'
=> 'Skew Tries',

   'Statistics and Problem Analysis'
=> 'Statistics and Problem Analysis',

   'Student performance statistics on all problems.'
=> 'Student performance statistics on all problems.',

   'Unable to connect to database!'
=> 'Unable to connect to database!',

   'Your Excel Spreadsheet'
=> 'Your Excel Spreadsheet',

   'Your Excel spreadsheet.'
=> 'Your Excel spreadsheet.',

   'Your Excel spreadsheet'
=> 'Your Excel spreadsheet',

   'Your CSV file.'
=> 'Your CSV file.',

   'Your CSV file'
=> 'Your CSV file',

   'part'
=> '部分',

   'part - '
=> '部分 ',

   'problem statistics grouped by sequence'
=> 'problem statistics grouped by sequence',

   'problem statistics ungrouped'
=> 'problem statistics ungrouped',

   'problem statistics, Excel'
=> 'problem statistics, Excel',

   'Significant figures are incorrect, submission was not graded.'
=> 'Significant figures are incorrect, submission was not graded.',

   '. . . for a particular section'
=> '. . . for a particular section',

   '. . . for all students in the course'
=> '. . . for all students in the course',

   '. . . for an individual student'
=> '. . . for an individual student',

   '12 am' # midnight
=> '12 am',

   'midnight'
=> '午夜',

   '1 am'
=> '1 am',

   '2 am'
=> '2 am',

   '3 am'
=> '3 am',

   '4 am'
=> '4 am',

   '5 am'
=> '5 am',

   '6 am'
=> '6 am',

   '7 am'
=> '7 am',

   '8 am'
=> '8 am',

   '9 am'
=> '9 am',

   '10 am'
=> '10 am',

   '11 am'
=> '11 am',

   '12 noon'
=> '12 noon',

   'noon'
=> '中午',

   '1 pm'
=> '1 pm',

   '2 pm'
=> '2 pm',

   '3 pm'
=> '3 pm',

   '4 pm'
=> '4 pm',

   '5 pm'
=> '5 pm',

   '6 pm'
=> '6 pm',

   '7 pm'
=> '7 pm',

   '8 pm'
=> '8 pm',

   '9 pm'
=> '9 pm',

   '10 pm'
=> '10 pm',

   '11 pm'
=> '11 pm',

   '<- Previous'
=> '<- Previous',

   'ALL'
=> 'ALL',

   'All Maps or Folders'
=> 'All Maps or Folders',

   'Any User'
=> '任何用户',

   'Assessment URL and Title'
=> '评估网址和标题',

   'Assigned User Roles'
=> '用户角色分配',

   'Browse resources'
=> '搜索资源',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Changes can take up to 10 minutes before being active for all students.',

   'Course Assessment Parameter - Helper Mode'
=> '课程评估参数 - 助手模式',

   'Course Assessment Parameters - Overview Mode'
=> '课程评估参数 - 摘要模式',

   'Course Assessments Parameters - Table Mode'
=> '课程评估参数 - 表模式',

   'Course Environment Parameters'
=> '课程环境参数',

   'Course Parameter Helper'
=> '课程参数实用工具',

   'Create New Environment Variable'
=> '创造新的环境变量',

   'Current Session Value'
=> '当前会话的值',

   'Default Value'
=> '缺省值',

   'Delete a role'
=> '删除角色',

   'Disable all communication among students'
=> 'Disable all communication among students',

   'Enclosing Map or Folder'
=> '附有目录或文件夹',

   'Every problem in a particular folder'
=> '每一个问题在一个特定的文件夹',

   'Every problem in the course'
=> '课程的中每一个问题',

   'Folder'
=> '文件夹',

   'Grant/revoke Course Custom Role'
=> 'Grant/revoke Course Custom Role',

   'Grant/revoke role of Administrator'
=> 'Grant/revoke role of Administrator',

   'Grant/revoke role of Author'
=> 'Grant/revoke role of Author',

   'Grant/revoke role of Course Coordinator'
=> 'Grant/revoke role of Course Coordinator',

   'Grant/revoke role of Domain Guest'
=> 'Grant/revoke role of Domain Guest',

   'Grant/revoke role of Librarian'
=> 'Grant/revoke role of Librarian',

   'Grant/revoke role of Teaching Assistant'
=> 'Grant/revoke role of Teaching Assistant',

   'Internally authenticated'
=> 'Internally authenticated',

   'Kerberos authenticated'
=> 'Kerberos authenticated',

   'LON-CAPA Helper:'
=> 'LON-CAPA Helper:',

   'Lock and unlock assessments'
=> 'Lock and unlock assessments',

   'Manage Access Keys'
=> 'Manage Access Keys',

   'Manage access keys'
=> 'Manage access keys',

   'Max Possible To Date'
=> '到现在为止，最高可达到',

   'Modify Course Assessment Parameters'
=> 'Modify Course Assessment Parameters',

   'Modify authentication mechanism and data for a user'
=> 'Modify authentication mechanism and data for a user',

   'Modify grades'
=> 'Modify grades',

   'Next ->'
=> '下一步 ->',

   'One particular problem'
=> 'One particular problem',

   'Parameter Name'
=> '参数名',

   'Parameter Type'
=> '参数类型',

   'Parameter in Effect'
=> '有效参数',

   'Please select a problem to analyze'
=> '请选择问题进行分析',

   'Post anonymously'
=> '匿名发送',

   'Post discussion on course resources'
=> '发送该课程资源的讨论',

   'Post system frontpage announcements'
=> '给系统主页发送通知',

   'Post to live chatrooms'
=> '发送到在线聊天室',

   'Post to chatrooms'
=> '发送到聊天室',

   'Problems Not Contained In A Folder'
=> '问题不包含在一个文件夹中',

   'Section'
=> '章节',

   'Section:'
=> '章节:',

   'Select Date'
=> '请选择日期',

   'Select Enclosing Map or Folder'
=> 'Select Enclosing Map or Folder',

   'Select Parameter Level'
=> 'Select Parameter Level',

   'Send internal email'
=> '发送内部电子邮件',

   'Set Course Environment Parameters'
=> 'Set Course Environment Parameters',

   'Set Date'
=> '设定日期',

   'Set Defaults for All Resources in [_1]Specifically for [_2][_3]'
=> 'Set Defaults for All Resources in [_1]Specifically for [_2][_3]',

   'Set a due date'
=> '设定一个截止日期',

   'Set an answer open date'
=> 'Set an answer open date',

   'Set an open date'
=> 'Set an open date',

   'Set opening datefor all problems in the course for. . .'
=> 'Set opening datefor all problems in the course for. . .',

   'Set the number of tries'
=> '设置尝试次数',

   'Set the problem weight'
=> '设置问题难度',

   'Set/Modify Course Assessment Parameter'
=> '设置/修改课程评估参数',

   'Set/Modify Course Assessment Parameters'
=> '设置/修改课程评估参数',

   'Set/Modify Course Parameters'
=> '设置/修改课程参数',

   'Show More Options'
=> '显示更多选项',

   'Students Affected'
=> '受影响的学生',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.',

   'Total'
=> '总共',

   'Total Parts In Course'
=> 'Total Parts In Course',

   'Type'
=> '型号',

   'UNIX authenticated'
=> 'UNIX 认证',

   'USERS'
=> '用户',

   'Unknown ID'
=> '未知 ID',

   'Unknown user'
=> '未知用户',

   'Update Course Assessment Parameter Display'
=> 'Update Course Assessment Parameter Display',

   'Update Section or Specific User'
=> 'Update Section or Specific User',

   'Verify Selection'
=> '确认选择',

   'Welcome to the Assignment Parameter Helper'
=> 'Welcome to the Assignment Parameter Helper',

   'What parameter do you want to set for all problems in the course?'
=> 'What parameter do you want to set for all problems in the course?',

   'What should the opening date be set to?'
=> 'What should the opening date be set to?',

   'Which Problem or Problems?'
=> 'Which Problem or Problems?',

   'Which problems do you wish to set a parameter for?'
=> 'Which problems do you wish to set a parameter for?',

   'You need to choose another user role or enter a specific course or community for this function.'
=> 'You need to choose another user role or enter a specific course or community for this function.', # '对于此功能您需要选择另一个用户角色，或者输入特定的课程。',

   'a.m.'
=> '上午',

   'acc keys'
=> 'acc keys',

   'according to course preferences'
=> '根据课程设置',

   'according to resource settings'
=> '根据资源设置',

   'according to user session state'
=> '根据用户会话状态',

   'all'
=> '所有的',

   'at'
=> '在',

   'at Domain'
=> '在域',

   'at domain'
=> '在域',

   'default'
=> '默认',

   'for Enclosing Map or Folder'
=> '对于附有目录或文件夹', #??? [SB 18.10.2006]

   'for Resource'
=> '资源',

   'from Enclosing Map or Folder'
=> '从附有目录或文件夹', #??? [SB 18.10.2006]

   'general'
=> '一般的',

   'in Course'
=> '在课程',

   'in Section/Group'
=> '在科/组',

   'manage'
=> '管理',

   'of'
=> 'of',

   'or ID'
=> '或者 ID',

   'p.m.'
=> '下午',

   'percent'
=> '百分比',

   'unless locked'
=> '除非锁定',

   'users in'
=> 'users in',

   'Access Key Management'
=> 'Access Key Management',

   'Assessment'
=> '评价',

   'Calculations'
=> 'Calculations',

   'Comma Separated Values'
=> 'Comma Separated Values',

   'Course ID'
=> '课程 ID',

   'Course level sheet'
=> 'Course level sheet', # ??? [SB 2007-07-02]

   'Detailed Problem Analysis'
=> 'Detailed Problem Analysis',

   'End Helper'
=> 'End Helper',

   'Excel'
=> 'Excel',

   'Text (essays only)'
=> 'Text (essays only)',

   'Finish Course Initialization'
=> 'Finish Course Initialization',

   'Generate Spreadsheet'
=> '生成报告表',

   'Grant/revoke role of Bubblesheet Operator'
=> 'Grant/revoke role of Bubblesheet Operator',

   'HTML'
=> 'HTML',

   'Invalid date entry'
=> 'Invalid date entry',

   'Load:'
=> '加载:',

   'No changes were made to the current settings.'
=> 'No changes were made to the current settings.',

   'Output Format'
=> '输出格式',

   'Processing course structure'
=> 'Processing course structure',

   'Processing first student'
=> 'Processing first student',

   'Row'
=> '排列',

   'Save as'
=> '另存为',

   'Save as &amp; Make This Sheet the Default'
=> '另存为 ＆ 使此工作表作为一个默认使用',

   'Bubblesheet Operator'
=> 'Bubblesheet Operator',

   'Select All'
=> '全选',

   'Select All Students'
=> '选择所有学生',

   'Select Spreadsheet File'
=> '选择电子表格文件',

   'Send bubblesheet data to a course'
=> 'Send bubblesheet data to a course',

   'Spreadsheet Computation'
=> 'Spreadsheet Computation',

   'Spreadsheet Computation Status'
=> 'Spreadsheet Computation Status',

   'Student level sheet'
=> 'Student level sheet',

   'Summary'
=> 'Summary',

   'Template'
=> 'Template',

   'Unselect All'
=> 'Unselect All',

   'Unselect All Students'
=> 'Unselect All Students',

   'Upload bubblesheet data'
=> 'Upload bubblesheet data',

   'You must choose at least one student to continue.'
=> 'You must choose at least one student to continue.',

   'You must choose one or more choices to continue.'
=> 'You must choose one or more choices to continue.',

   'may be open from a different computer.'
=> 'may be open from a different computer.',

   'minutes'
=> 'minutes',

   'remaining'
=> 'remaining',

   'second'
=> 'second',

   'seconds'
=> 'seconds',

   'Additional Recipients'
=> '其他收件人',

   'Analyze Over [_1] [_2]'
=> 'Analyze Over [_1] [_2]',

   'Analyze Problem'
=> 'Analyze Problem',

   'Analyze Problem Again'
=> 'Analyze Problem Again',

   'Analyze as '
=> 'Analyze as ',

   'Browsing resource, all submissions are temporary.'
=> 'Browsing resource, all submissions are temporary.',

   'By'
=> 'By',

   'Check All'
=> '全选',

   'Check for All'
=> '检查所有',

   'Check for None'
=> '检查无',

   'Check for Section/Group'
=> '检查科/组',

   'Choose a different resource'
=> '选择不同的资源',

   'Concepts'
=> '草稿',

   'Critical Messages'
=> '重要讯息',

   'Delete'
=> '删除',

   'Delete Checked'
=> '删除选中',

   'Display All Messages'
=> '显示所有邮件',

   'Display all Messages'
=> '显示所有邮件',

   'Foils'
=> '选择',

   'Forward'
=> '转发',

   'Forwarded message from'
=> '转发邮件从',

   'Forwarding'
=> '转发',

   'From'
=> '从',

   'Functions'
=> '功能',

   'Mail'
=> '邮件',

   'Mark Unread'
=> '标记为未读',

   'New Problem Variation'
=> 'New Problem Variation',

   'New Randomization'
=> '新的变化',

   'Next'
=> '下一步',

   'Number of Plots [_1]'
=> 'Number of Plots [_1]',

   'Option Response Problem Analysis'
=> 'Option Response Problem Analysis',

   'Previous'
=> '以前的',

   'Re'
=> '回复',

   'Record'
=> '记录',

   'Reply'
=> '回复',

   'Reset Submissions'
=> 'Reset Submissions',

   'Select a course'
=> '选择课程',

   'Selecting a User'
=> '选择用户',

   'Send New'
=> 'Send New',

   'Send Reply'
=> '发送回复',

   'Send as critical message'
=> '发出一个重要信息',

   'Simple Problem Editor'
=> '简单的问题编辑器',

   'Starting'
=> '开始',

   'Student Data Compilation Progress'
=> '学生资料汇编进展',

   'Student Data Compilation Status'
=> '学生资料汇编状态',

   'There is no student data for this problem.'
=> '对于这个问题，没有任何学生的数据。',

   'Time'
=> '时间',

   'To:'
=> '收件人：',

   'Uncheck All'
=> '全部取消',

   'Unsuccessful Login'
=> '登录失败',

   'Update Student Data'
=> '更新学生资料',

   'You have no critical messages.'
=> '您没有任何重要讯息。',

   'and return receipt'
=> 'and return receipt',

   'can not be accessed from your location.'
=> 'can not be accessed from your location.',

   'Unacceptable username [_1] for user [_2] [_3] [_4] [_5]'
=> 'Unacceptable username [_1] for user [_2] [_3] [_4] [_5]',

   'Unacceptable domain [_1] for user [_2] [_3] [_4] [_5]'
=> 'Unacceptable domain [_1] for user [_2] [_3] [_4] [_5]',

   'All Documents in Course'
=> 'All Documents in Course',

   'All Resources (possibly large output)'
=> 'All Resources (possibly large output)',

   'Anonymous'
=> '匿名',

   'Anonymous contribution to course discussion of resource'
=> '匿名参加这个资源的讨论',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).',

   'Associate columns with student attributes.'
=> 'Associate columns with student attributes.',

   'Attribute'
=> 'Attribute',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (逗号分隔值, 表格)',

   'Check Course Document Versions'
=> 'Check Course Document Versions',

   'Check/Set Resource Versions'
=> '检查/设置源版本',

   'Chronological View'
=> '顺序查看',

   'Column'
=> 'Column',

   'Column [_1]'
=> 'Column [_1]',

   'Continue enrollment?'
=> 'Continue enrollment?',

   'Contribution to course discussion of resource'
=> '正常参加这个资源的讨论',

   'Diffs'
=> '区别',

#   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
#=> 'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)',


   'Disable Student/Employee ID Safeguard and force change of conflicting IDs'
=> '禁用学生/员工编号，维护和强制改变不一致的IDs',

   '(only do if you know what you are doing.)'
=> '(只有这样做，如果你知道自己在做什么。)',

   'Discussion Contributions'
=> '参加讨论',

   'Drop Students'
=> '从该课程删除学生',

   'Dropped [_1]'
=> '[_1] ausgeschlossen',

   'Dropped [_1] student(s).'
=> '[_1] Student(en) ausgeschlossen.',

   'Dropping Students'
=> 'Dropping Students',

   'EMail Address'
=> 'EMail Address',

   'Enroll a single student'
=> '注册一个学生',

   'Enrolling Students'
=> '注册学生',

   'Error'
=> 'Error',

   'Error: '
=> 'Error: ',

   'Error: [_1]'
=> 'Error: [_1]',

   'Field'
=> 'Field',

   'Filenames in Authoring Space'
=> 'Filenames in Authoring Space',

   'First Name'
=> '名',

   'Folder in Authoring Space'
=> 'Folder in Authoring Space',

   'Full Update'
=> '全面更新',

   'Full update (also print list of users not enrolled anymore)'
=> 'Full update (also print list of users not enrolled anymore)', # => '全面更新 (auch Liste von Benutzern ausgeben, die den Kurs nicht mehr belegt haben)',

   'Generation'
=> '生成',

   'Group/Section'
=> '组/科',

   'HTML/XML'
=> 'HTML/XML',

   'Hide'
=> '隐藏',

   'Student/Employee ID'
=> '学生/员工 ID',

   'Identify fields'
=> 'Identify fields',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'If active, the new role will be available when the students next log in to LON-CAPA.',

   'Ignore First Line'
=> '忽略第一行',

   'Initial Password'
=> '初始密码',

   'Internal Filename'
=> '内部文件名',

   'Invalid home server specified'
=> 'Invalid home server specified',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Keep all Resources up-to-date with most recent Versions (default)',

   'LON-CAPA Domain for Students'
=> 'LON-CAPA Domain for Students',

   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA Enrollment Manager',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPA 域： [_1]',

   'Last Name'
=> '姓',

   'Last Name, First Names'
=> '姓，名',

   'Login Type'
=> '登录类型',

   'Middle Names/Initials'
=> '中名/缩写',

   'Modify Parameters'
=> '修改参数',

   'Modify student data'
=> '修改学生资料',

   'Most recently published Version'
=> '最近发布的版本',

   'No Kerberos domain was specified.'
=> 'No Kerberos domain was specified.',

   'None Found'
=> '没有找到',

   'Note: For large courses, this operation may be time consuming.'
=> 'Note: For large courses, this operation may be time consuming.',

   'This will not take effect if the user already exists.'
=> 'This will not take effect if the user already exists.',

   'Processed [_1] student(s).'
=> '[_1] Studierende bearbeitet.',

   'Re-enrollment will re-activate data.'
=> 'Re-enrollment will re-activate data.',

   'Registering'
=> 'Registering',

   'Samples'
=> '例如',

   'Save as ...'
=> '另存为...',

   'Set Version to be used in Course'
=> 'Set Version to be used in Course',

   'Set Versions to be used in Course according to Selections below'
=> 'Set Versions to be used in Course according to Selections below',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Set all Resource Versions to current Version (Fix Versions)',

   'Show Preview'
=> 'Show Preview',

   'Space separated'
=> '以空格分隔',

   'Starting and Ending Dates'
=> '起始和结束日期',

   'Student Number'
=> '学生证号码',

   'Tabulator separated'
=> '以制表符分隔',

   'The optional email address field was not specified.'
=> 'The optional email address field was not specified.',

   'The optional name field was not specified.'
=> 'The optional name field was not specified.',

   'The optional ID number field was not specified.'
=> 'The optional ID number field was not specified.',

   'The optional section or group field was not specified.'
=> 'The optional section or group field was not specified.',

   'The optional student number field was not specified.'
=> 'The optional student number field was not specified.',

   'The optional section field was not specified.'
=> 'The optional section field was not specified.',

   'The optional role field was not specified.'
=> 'The optional role field was not specified.',

   'The optional domain field was not specified.'
=> 'The optional domain field was not specified.',

   'There are no students currently enrolled.'
=> 'There are no students currently enrolled.',

   'Continue adding users?'
=> 'Continue adding users?',

   'Threaded View'
=> '线程查看',

   'Total number of records found in file: [_1]'
=> 'Total number of records found in file: [_1]',

   'Unable to enroll students'
=> 'Unable to enroll students',

   'Updating discussion time'
=> 'Updating discussion time',

   'Uploading Class List'
=> 'Uploading Class List',

   'Verify Content'
=> '检查内容',

   'Version used in Course'
=> 'Version used in Course',

   'View Class List'
=> 'View Class List',

   'View Class list'
=> 'View Class list',

   'Welcome'
=> '欢迎',

   'Welcome to the Learning[_1]Online[_2] Network with CAPA. Please wait while your session is being set up.'
=> '欢迎您到在线网络 LON-CAPA 学习。请稍候，您的会话正在建立。',

   'You must choose an authentication type.'
=> '你必须选择一个身份验证类型。',

   'You need to specify the Kerberos domain.'
=> 'You need to specify the Kerberos domain.',

   'You need to specify the initial password.'
=> 'You need to specify the initial password.',

   'You need to specify the username field.'
=> 'You need to specify the username field.',

   'Your Version Settings have been Saved'
=> 'Your Version Settings have been Saved',

   '[_1] Do not change login data'
=> '[_1] 不要更改登录数据',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5 [_5]'
=> '[_1] Kerberos身份验证域 [_2] [_3] 版本 4 [_4] 版本 5 [_5]',

   'Currently Kerberos authenticated with domain [_1] Version [_2].'
=> '目前的Kerberos身份验证域 [_1] 版本 [_2]。',

   'Currently Kerberos authenticated, Version [_1].'
=> '目前Kerberos身份验证，版本 [_1]。',

   'most recent'
=> '最新的',

   'name only visible to course faculty'
=> '只有课程管理者能看见',

   'Calculate answers'
=> '计算的答案',

  'Show All Foils'
=> '显示全部选项',

   'Show All Instances'
=> '显示全部选项',

   '1 out of N multiple choice (radio button)'
=> '单选',

   'Add new option'
=> '添加新的选择',

   'Administrator'
=> '管理员',

   'Answer:'
=> '回复:',

   'Attachment'
=> '附件',

   '(128 KB max size)'
=> '(最大 128 KB)',

   'Change'
=> '改变',

   'Change Random Seed To:'
=> '随机数的基础上：',

   'Change Your Language Preferences'
=> '变更您的语言偏好',

   'Concept:'
=> '概念：',

   'Correct Option:'
=> '正确的选择:',

   'Create a New Course'
=> '创建一个新的课程',

   'Create a New Course or Group Space'
=> '创建一个新的课程或组空间',

   'Current'
=> '现在的',

   'Delete an option'
=> '删除一个选项',

   'Delete:'
=> '删除:',

   'Diffs with Current Version'
=> '与当前版本的区别',

   'Diffs with Version'
=> '不同版本之间的区别',

   'Diffs with current Version'
=> '与当前版本的区别',

   'Display and analysis of submission times on assessments.'
=> 'Display and analysis of submission times on assessments.',

   'Display foils in order given'
=> '在给定的分类里显示选项',

   'Display foils in random order'
=> '在一个随机序列里显示选项',

   'Domain Guest'
=> '网上邻居',

   'Essay, open end'
=> '尝试，没有时间限制',

   'False'
=> '错误的',

   'Foil'
=> '选项',

   'Format:'
=> '格式:',

   'Height(pixel):'
=> '高 (Pixel):',

   'Hint Text'
=> '提示文字',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'If this resource is in active use, student performance data from the previous version may become inaccessible.',

   'Image:'
=> '图片:',

   'Incorrect Answers:'
=> '错误的答案:',

   'Last accessed'
=> '上次访问',

   'Librarian'
=> 'Librarian',

   'Making Backup to [_1]'
=> 'Making Backup to [_1]',

   'Max Number Of Shown Foils:'
=> '显示选项的最大数量：',

   'Max number of foils displayed'
=> '显示选项的最大数量',

   'Metadata'
=> '元数据',

   'metadata'
=> '元数据',

   'Metadata Version'
=> '元数据版本',

   'Metadata current version'
=> '元数据的最新版本',

   'Save Metadata'
=> '保存元数据',

   'Name:'
=> '姓氏:',

   'New parameters or saved values'
=> '新的参数或保存价值',

   'No language preference'
=> '没有语言偏好',

   'Not shown, not used'
=> '没有显示，没有使用',

   'Obsolete parameters or saved values'
=> '过时的参数或保存价值',

   'Option response'
=> '答案选项',

   'Please do not reply to this address.'
=> 'Please do not reply to this address.',

   'Position'
=> 'Position',

   'Preferred language'
=> '首选语言',

   'Problems'
=> 'Problems',

   'Produce Excel Output'
=> 'Produce Excel Output',

   'Question Text'
=> '文字问题',

   'Random position'
=> '随机位置',

   'Retrieve Published Resources'
=> '恢复发布的资源',

   'Short string response'
=> '简短的文字回答',

   'Show always at bottom position'
=> '总是在最后显示',

   'Show always at top position'
=> '总是在最开始显示',

   'Size:'
=> '大小：',

   'Save Changes'
=> '保存更改',

   'Submission Time Analysis'
=> '提交时间分析',

   'Submit Changes and Edit'
=> '保存并继续编辑',

   'TeXWidth(mm):'
=> 'TeX-宽 (mm):',

   'Text'
=> '文本',

   'Text Block'
=> '文本块',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'This is an automatic message generated by the LON-CAPA system.',

   'True'
=> '正确的',

   'unused'
=> '未用过的',

   'Type-in value'
=> 'Type-in value',

   'Unit:'
=> '单位：',

   'Value'
=> '值',

   'Warning!'
=> '警告！',

   'Width(pixel):'
=> '宽 (Pixel):',

   'anonymous'
=> '匿名',

   'bytes'
=> 'bytes',

   'loginproblems.html'
=> 'loginproblems.html',

   'versions of this problem'
=> '这个问题的版本',


#=====================
# Begin remote control (mydesk.tab)
# 2x8 chars, only lower case
# Same order as in mydesk.tab!
   'choose[_1]'
=> '选择',
   'course[_1]'
=> '课程',

   'switch[_1]'
=> '转换',
   'course[_2]'
=> '课程',

   'switch[_2]'
=> '转换',
   'role[_1]'
=> '角色',

   'choose[_2]'
=> '选择',
   'role[_2]'
=> '角色',

   'course[_3]'
=> '课程',
   'docs[_1]'
=> '内容',

   'course[_7]'
=> '编辑',
   'editor[_1]'
=> '课程文档',

   'navigate[_1]'
=> '课程',
   'contents[_1]'
=> '目录',

   'request-[_1]'
=> 'request-[_1]',
   'course[_16]'
=> 'course[_16]',

   'my[_1]'
=> '我的',
   'grades[_1]'
=> '得分',

   'course[_4]'
=> '课程',
   'grades[_2]'
=> '等级',

   'course[_5]'
=> 'course[_5]',
   'chart[_1]'
=> 'chart[_1]',

   'course[_6]'
=> '课程',
   'stats[_1]'
=> '统计',

   'manage[_1]'
=> 'manage[_1]',
   'acc keys[_1]'
=> 'acc keys[_1]',

   'course[_12]'
=> '课程参加者',
   'roster[_1]'
=> '名单',

   'user[_1]'
=> '用户',
   'roles[_1]'
=> '角色',

   'create[_1]'
=> '创建',
   'course[_8]'
=> '课程',

   'course[_9]'
=> '课程',
   'parms[_1]'
=> '参数',

   'con-[_1]'
=> 'con-[_1]',
   'struct[_1]'
=> 'struct[_1]',

   'co con-[_1]'
=> 'co con-[_1]',
   'struct[_2]'
=> 'struct[_2]',

   'domain[_1]'
=> '域',
   'config[_1]'
=> '配置',

   'resource[_1]'
=> '发布', # '资源',
   'space[_1]'
=> '资源',

   'co res[_1]'
=> 'co res[_1]',
   'space[_2]'
=> 'space[_2]',

   'what is[_1]'
=> '有什么',
   'new[_1]'
=> '新内容',

   'enter[_1]'
=> 'enter[_1]',
   'grades[_3]'
=> 'grades[_3]',

   'course[_13]'
=> '课程',
   'catalog[_1]'
=> '目录',

   'view[_1]'
=> '查看',
   'bookmark[_1]'
=> '书签',

   'calendar[_1]'
=> '日历',
   'announce[_1]'
=> '通告',

   'commu-[_1]'
=> '发送和接收',
   'nication[_1]'
=> '邮件',

   'course[_10]'
=> '课程-',
   'chatroom[_1]'
=> '聊天室',

   'course[_14]'
=> '课程-',
   'groups[_1]'
=> '组',

   'port-[_1]'
=> '文件夹',
   'folio[_1]'
=> '空间',

   'edit[_1]'
=> '编辑',
   'blogs[_1]'
=> '博客',

   'search[_3]'
=> 'search[_3]',
   'prtfolio[_1]'
=> 'prtfolio[_1]',

   'search[_1]'
=> '在课程中',
   'course[_11]'
=> '搜索',

   'search[_2]'
=> '搜索',
   'library[_1]'
=> '资源',

   'prefer-[_1]'
=> '用户',
   'ences[_1]'
=> '设置',

   'exit[_1]'
=> '注销',
   ' [_1]'
=> ' ',

#=====================
# Remote control entries which occur only in lonmenu.pm

   'problem[_1]'
=> 'problem[_1]', # '问题',
   'grades[_4]'
=> 'grades[_4]',

   'sub-[_1]'
=> 'sub-[_1]',
   'missions[_1]'
=> 'missions[_1]',

   'problem[_2]'
=> 'problem[_2]', # '问题',
   'parms[_2]'
=> 'parms[_2]',

   'dir[_1]'
=> 'dir[_1]',
   'list[_1]'
=> 'list[_1]',

   'retrieve[_1]'
=> 'retrieve[_1]',
   'version[_1]'
=> 'version[_1]',

   'publish[_1]'
=> 'publish[_1]',
   'resource[_3]'
=> 'resource[_3]',

   'delete[_1]'
=> 'delete[_1]',
   'resource[_2]'
=> 'resource[_2]',

   'prepare[_1]'
=> 'prepare[_1]',
   'printout[_1]'
=> '', # !

   'backward[_1]'
=> 'backward[_1]',

   'forward[_1]'
=> 'forward[_1]',

   'set[_1]'
=> 'set[_1]',
   'bookmark[_2]'
=> 'bookmark[_2]',

   'anno-[_1]'
=> 'anno-[_1]',
   'tations[_1]'
=> 'tations[_1]',

   'catalog[_2]'
=> 'catalog[_2]',
   'info[_1]'
=> 'info[_1]', # '信息',

   'evaluate[_1]'
=> 'evaluate[_1]',
   'this[_1]'
=> 'this[_1]',

   'feedback[_1]'
=> 'feedback[_1]',
   'discuss[_1]'
=> 'discuss[_1]',

# End remote control
#=====================

   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(输入最大[_1]同事的用户名或用户名@域名，例如：smithje or smithje@[_2]。)',

   '(Hand in a file you have prepared on your computer)'
=> '(Hand in a file you have prepared on your computer)',

   ', select a template from the pull-down menu below.'
=> ', select a template from the pull-down menu below.',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.',

   'ABSTRACT'
=> '摘要',

   'Access Control'
=> '访问控制',

   'Activate'
=> '激活',

   'Add Roles'
=> '添加角色',

   "Add one empty page/column after each student's assignment"
=> "Add one empty page/column after each student's assignment",

   "Add three empty pages/column after each student's assignment"
=> "Add three empty pages/column after each student's assignment",

   "Add two empty pages/column after each student's assignment"
=> "Add two empty pages/column after each student's assignment",

   'Date Shift'
=> 'Date Shift',

   'Do not clone date parameters'
=> 'Do not clone date parameters',

   'Clone date parameters as-is'
=> 'Clone date parameters as-is',

   'Shift date parameters by number of days'
=> 'Shift date parameters by number of days',

   'Additional settings, if specified below, will override cloned settings'
=> 'Additional settings, if specified below, will override cloned settings',

   'Advanced Edit'
=> 'Advanced Edit',

   'All Resources'
=> 'All Resources',

   'All Students'
=> '所有学生',

   'Allowed filetypes: [_1]'
=> 'Allowed filetypes: [_1]',

   'An error occurred during the attempt to change the section for this student.'
=> 'An error occurred during the attempt to change the section for this student.',

   'An error occurred during the attempt to change the role information for this student.'
=> 'An error occurred during the attempt to change the role information for this student.',

   'Analyzing Results'
=> 'Analyzing Results',

   'Answerable'
=> 'Answerable',

   'Assessment Parameters'
=> 'Assessment Parameters',

   'Automated Enrollment Manager'
=> 'Automated Enrollment Manager',

   'Automated adds'
=> 'Automated adds',

   'Automated drops'
=> 'Automated drops',

   'Automated enrollment settings'
=> 'Automated enrollment settings',

   'Bad Filename'
=> 'Bad Filename',

   'Begin Enrollment'
=> 'Begin Enrollment',

   'Binary File'
=> 'Binary File',

   'Blank'
=> 'Blank',

   'Browse'
=> 'Browse',

   'CSV format'
=> 'CSV format',

   'Cannot publish directory'
=> 'Cannot publish directory',

   'Cannot retrieve directory'
=> 'Cannot retrieve directory',

   'Catalog Search'
=> 'Catalog Search',

   'Change User Privileges'
=> 'Change User Privileges',

   'Changed discussion view mode'
=> '改变讨论视图模式',

   'Click here for FAQ'
=> 'Click here for FAQ',

   'Click here for help'
=> 'Click here for help',

   'Click here to report bugs'
=> 'Click here to report bugs',

   'Click-On Texts (comma sep):'
=> 'Click-On Texts (comma sep):',

   'Clone an existing course'
=> 'Clone an existing course',

   'Close This Window'
=> 'Close This Window',

   'Closed'
=> 'Closed',

   'Communication'
=> '通讯',

   'Compare versions of'
=> 'Compare versions of',

   'No differences found'
=> 'No differences found',

   'Completely new course'
=> 'Completely new course',

   'Authoring Space Version'
=> 'Authoring Space Version',

   'Continue'
=> '下一步',

   'Copy current file to'
=> 'Copy current file to',

   'Copy selected'
=> 'Copy selected',

   'Course Code'
=> 'Course Code',

   'Course Content'
=> '课程内容',

   'Course Data'
=> '课程数据',

   'Course Home Server'
=> 'Course Home Server',

   'Course ID/Number'
=> '课程-ID/编号',

   'Course Information'
=> '课程资料',

   'Resource Level'
=> '资源等级',

   'Map/Folder Level'
=> 'Map/Folder Level',

   'Course Level'
=> '课程等级',

   'Course Search'
=> '课程搜寻',

   'Course Title'
=> '课程名称',

   'Create New User'
=> '创建新用户',

   'Create User'
=> '创建用户',

   'Crosslisted courses'
=> 'Crosslisted courses',

   'Current Class List'
=> '目前的学生名单',

   'Current Ending Date: [_1]'
=> '目前结束日期： [_1]',

   'Current Ending Date: not set'
=> '目前结束日期： 未设置',

   'Current Resource'
=> '现有资源',

   'Current Starting Date: [_1]'
=> '目前开始日期： [_1]',

   'Current Starting Date: not set'
=> '目前开始日期： 未设置',

   'Current Version'
=> '当前版本',

   'Currently no active roles, courses or communities'
=> 'Currently no active roles, courses or communities', # '目前没有任何活动的角色或课程',

   'Currently no additional roles, courses or communities'
=> 'Currently no additional roles, courses or communities', # '目前还没有更多的角色或课程',

   'The following [quant,_1,role,roles] will become active in the future:'
=> 'The following [quant,_1,role,roles] will become active in the future:',

   'Currently submitted: [_1]'
=> '目前提交：[_1]',

   'Custom Role Editor'
=> '自订角色编辑器',

   'Cut selected'
=> 'Cut selected',

   'Decompress'
=> '解压缩',

   'Default Assessment Spreadsheet'
=> 'Default Assessment Spreadsheet',

   'Default Course Spreadsheet'
=> 'Default Course Spreadsheet',

   'Default Student Spreadsheet'
=> 'Default Student Spreadsheet',

   'Default XML Style File'
=> 'Default XML Style File',

   'Default for new courses is'
=> 'Default for new courses is',

   'Default:'
=> 'Default:',

   'Define Role'
=> 'Define Role',

   'Dependencies'
=> 'Dependencies',

   'Description:'
=> '描述:',

   'Disable student resource discussion'
=> 'Disable student resource discussion',

   'Disable student use of chatrooms'
=> 'Disable student use of chatrooms',

   'Display file attributes'
=> 'Display file attributes',

   'Do NOT generate as standard course'
=> 'Do NOT generate as standard course',

   'Domain Level'
=> 'Domain Level',

   "Don't Show Feedback"
=> "Don't Show Feedback",

   'Duration of automated classlist updates'
=> 'Duration of automated classlist updates',

   'Dynamic Metadata (updated periodically)'
=> '动态数据 (定期更新)',

   'ERROR'
=> '错误',

   'Edit Custom Role Privileges'
=> '编辑自定义角色权限',

   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> '编辑错误-这些错误可能不会影响正在运行的问题，但他们很可能会导致问题进一步使用编辑模式。请使用XML模式来解决这些错误。',

   'End Time'
=> '结束时间',

   'Ending Date'
=> '结束日期',

   'Ending date'
=> '结束日期',

   'Enroll One Student'
=> '登记一名学生',

   'Enroll as student'
=> '登记学生',

   'Enrolling'
=> '登记',

   'Enrolling Student'
=> '登记学生',

   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.',

   'Enter as many fields as you can.<br /> The system will inform you and bring you back to this page, <br /> if the data selected are insufficient to add users.'
=> 'Enter as many fields as you can.<br /> The system will inform you and bring you back to this page, <br /> if the data selected are insufficient to add users.',

   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> '在搜索栏里输入关键字或词组用  AND, OR, 或 NOT 间隔，然后点击下面的 搜索 ',

   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> '在搜索栏里输入关键字或词组，如 AND，OR，或 NOT 间隔。',

   'Entering Authoring Space'
=> 'Entering Authoring Space',

   'Error: Directory Non Empty'
=> 'Error: Directory Non Empty',

   'Error: destination for operation is an existing directory.'
=> 'Error: destination for operation is an existing directory.',

   'Evaluation Error '
=> 'Evaluation Error ',

   'Homework Problem'
=> 'Homework Problem',

   'Exam Problem'
=> 'Exam Problem',

   'Excel format'
=> 'Excel format',

   'Feedback Addresses for Course Content Comments'
=> 'Feedback Addresses for Course Content Comments',

   'Feedback Addresses for Course Policy'
=> 'Feedback Addresses for Course Policy',

   'Feedback Addresses for Resource Content Question'
=> 'Feedback Addresses for Resource Content Question',

   'First'
=> 'First',

   'First Resource'
=> 'First Resource',

   'Foil name [_1] appears more than once. Foil names need to be unique.'
=> 'Foil name [_1] appears more than once. Foil names need to be unique.',

   'Folder/Map'
=> '文件夹/课程内容',

   'For one or more students'
=> 'For one or more students',

   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Found a <*response> outside of a <part> in a <part>ed problem',

   'Generate messages from a file'
=> '从一个文件生成邮件',

   'Go'
=> 'Go',

   'go'
=> 'go',

   'Go to ...'
=> '转到...',

   'Help on Creating Courses'
=> 'Help on Creating Courses',

   'Home Server'
=> 'Home Server',

   'Homework problem'
=> 'Homework problem',

   'How do I create a CSV file from a spreadsheet'
=> '我如何从Excel表创建一个CSV文件',

   'How do I create a class list from a spreadsheet'
=> 'How do I create a class list from a spreadsheet',

   'How should the results be printed?'
=> 'How should the results be printed?',

   'Immediately expire own role as Course Coordinator'
=> 'Immediately expire own role as Course Coordinator',

   'Import and Paste Area'
=> 'Import and Paste Area',

   'Include retrieval of student photographs?'
=> 'Include retrieval of student photographs?',

   'Institutional Information'
=> 'Institutional Information',

   'Invalid Significant figures detected'
=> 'Invalid Significant figures detected',

   'Invalid characters in requested name have been removed.'
=> 'Invalid characters in requested name have been removed.',

   'Invalid login mode or password.'
=> 'Invalid login mode or password.',

   'Invalid username or domain'
=> '无效的用户名或域',

   'KEYWORDS'
=> 'KEYWORDS',

   'LaTeX batchmode'
=> 'LaTeX batchmode',

   'LaTeX mode'
=> 'LaTeX mode',

   'Languages used'
=> '所用语言',

   'Last'
=> 'Last',

   'Leave blank on scoring form'
=> 'Leave blank on scoring form',

   'List Directory'
=> '目录列表',

   'Location'
=> '地点',

   'Login Data'
=> '登录数据',

   'Logout'
=> '退出',

   'Make new directory'
=> '创建新目录',

   'Make new file'
=> '创建新文件',

   'Manual Grading'
=> '手动评分',

   'Map has branchings. Use advanced editor.'
=> 'Map has branchings. Use advanced editor.',

   'Map has conditions. Use advanced editor.'
=> 'Map has conditions. Use advanced editor.',

   'Map has resource parameters. Use advanced editor.'
=> 'Map has resource parameters. Use advanced editor.',

   'Map has unconnected resources. Use advanced editor.'
=> 'Map has unconnected resources. Use advanced editor.',

   'Messaging'
=> '发送邮件',

   'first'
=> '名', # !

   'last'
=> '姓', # !

   'middle'
=> '中名', # !

   'Middle Name'
=> '中名',

   'Missing Kerberos domain information.'
=> '丢失的Kerberos域信息。',

   'Modification may make assessment data inaccessible!'
=> '修改可能使评估数据无法访问！',

   'Modify Enrollment for'
=> '修改注册为',

   'Modify User'
=> '修改用户',

   'Modify another students data'
=> '修改另一个学生的数据',

   'Modify deadlines, etc, for this resource'
=> '修改此资源的截止日期等',

   'Modifying data for user'
=> '修改用户的数据',

   'Modifying this will make problems have different numbers and answers!'
=> '修改这将使问题有不同的号码和答案！',

   'Move current file to'
=> '目前文件移动到',

   'Must create new subdirectory inside a directory'
=> '必须在目录里面创造新的子目录',

   'Name of Role'
=> '角色名字',

   'New Directory'
=> '新目录',

   'New HTML file'
=> '新的HTML文件',

   'New Resource'
=> '新资源',

   'New Role'
=> '新角色',

   'New User'
=> '新用户',

   'New Value'
=> '新的价值',

   'New assembled page'
=> '新组合页面',

   'New assembled sequence'
=> '新的组合序列',

   'New custom rights file'
=> '新文件的访问控制',

   'New file'
=> '新文件',

   'New problem'
=> '新问题',

   'New style file'
=> '新的风格文件',

   'New subdirectory'
=> '新的子目录',

   'Next    '
=> '下一步    ',

   'No'
=> '否',

   'No Access or Usages Statistics are available for this resource.'
=> '没有访问或使用的统计数据可用于该资源。',

   'No Assessment Statistical Data is available for this resource'
=> '没有任何评估统计数据可用于该资源。',

   'No Evaluation Data is available for this resource.'
=> '没有任何评价数据可用于该资源。',

   'No new filename specified.'
=> '没有指定新的文件名。',

   'No such file'
=> '文件未找到',

   'Not Allowed'
=> '不允许',

   'Not applicable -'
=> 'Not applicable -',

   'Not open to be viewed'
=> 'Not open to be viewed',

   'Not set -'
=> 'Not set -',

   'Notification of enrollment changes'
=> 'Notification of enrollment changes',

   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?',

   'Number of columns'
=> 'Number of columns',

   'Old Value'
=> 'Old Value',

   'One particular problem (overrides folder and course defaults)'
=> 'One particular problem (overrides folder and course defaults)',

   'Online Help'
=> '联机帮助',

   'Help: [_1]'
=> '帮助: [_1]',

   'Only domain coordinators can change a users password.'
=> '只有域协调员可以更改用户的密码。',

   'Open Course'
=> '创建课程',

   'Open all assessments'
=> '所有评估访问',

   'Open and correct'
=> '公开和正确',

   'Open with full tries'
=> '向所有人开放的尝试',

   'Output Format: [_1]'
=> '输出格式： [_1]',

   'Layout Options'
=> '布局选项',

   'Page layout'
=> '页面布局',

   'Paper type'
=> '纸张类型',

   'PDF Form Fields'
=> 'PDF格式字段',

   'with Form Fields'
=> '带有格式字段',

   'without Form Fields'
=> '不带有格式字段',

   'Problems from the Whole Course'
=> 'Problems from the Whole Course',

   'Resources from the Whole Course'
=> 'Resources from the Whole Course',

   'Parameter'
=> '参数',

   'Paste after selected'
=> 'Paste after selected',

   'Personal Data'
=> '个人资料',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process',

   'No such user [_1] at domain [_2].' # 1: user, 2: domain
=> 'No such user [_1] at domain [_2].',

   'Please click Back on your browser and select another user, or [_1]Create User[_2]'
=> 'Please click Back on your browser and select another user, or [_1]Create User[_2]',

   'Invalid home server for course: [_1]'
=> 'Invalid home server for course: [_1]',

   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Please contact your LON-CAPA administrator regarding this situation.',

   'Please select an authentication mechanism'
=> 'Please select an authentication mechanism',

   'Please select the Authentication mechanism'
=> 'Please select the Authentication mechanism',

   'Please stand by.'
=> 'Please stand by.',

   "Please use browser 'Back' button and pick a filename"
=> "Please use browser 'Back' button and pick a filename",

   'Preparing Printout'
=> 'Preparing Printout',

   'Print'
=> 'Print',

   'Print Index'
=> 'Print Index',

   'Print Discussions'
=> 'Print Discussions',

   'Print Annotations'
=> 'Print Annotations',

   'Print Table of Contents'
=> 'Print Table of Contents',

   'Print:'
=> 'Print:',

   'Problems from entire course'
=> 'Problems from entire course',

   'Processed file: [_1]'
=> 'Processed file: [_1]',

   'Publish this Resource'
=> 'Publish this Resource',

   'Randomization algorithm used'
=> 'Randomization algorithm used',

   'Recent'
=> '最新的',

   'Rename current file to'
=> '当前文件重命名为',

   'Report a Bug'
=> '报告错误',

   'Resource'
=> '资源',

   'Resource Differences'
=> '资源的差异',

   'Resources from selected sequence in course'
=> 'Resources from selected sequence in course',

   'Response'
=> '回答',

   'Retrieve Old Version'
=> 'Retrieve Old Version',

   'Retrieving current (most recent) version'
=> 'Retrieving current (most recent) version',

   'Retrieving old version'
=> 'Retrieving old version',

   'Return to DOCS'
=> '回到课程内容',

   'Reverse Association'
=> 'Reverse Association',

   'Revoke'
=> '撤销',

   'Revoke Existing Roles'
=> '撤销现有的角色',

   'Role'
=> '角色',

   'Role:'
=> '角色：',

   'Role Information'
=> '角色信息',

   'Sample Points:'
=> 'Sample Points:',

   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Save entries below as a draft answer (not submitting them for credit yet)',

   'Select Action'
=> '选择行动',

   'Select All Resources'
=> '选择所有资源',

   'Select Printing Options:'
=> '选择打印选项：',

   'Select Problem(s) to print'
=> '选择要打印任务',

   'Select Resource(s) to print'
=> '选择要打印的资源',

   'Select Resources To Print'
=> '选择要打印的资源',

   'Select Section'
=> '选择章节',

   'Select Sequence To Print From'
=> '选择打印顺序',

   'Select Students and Resources'
=> '选择学生和资源',

   'Select Style File'
=> '选择文件风格',

   "Select a user name to modify the student's information"
=> "选择一个用户名来修改学生的信息",

   'Select a user name to view the users personal page.'
=> '选择一个用户名，以查看用户的个人页面。',

   'Select resources for the assignment'
=> 'Select resources for the assignment',

   'Set'
=> '设置',

   'Set?'
=> '设置？',

   'Set Course Environment'
=> '设置课程环境',

   'Set End Date'
=> '设置结束日期',

   'Set Individual User Roles'
=> '设定用户角色和权限',

   'Set Start Date'
=> '设置开始日期',

   'Set content feedback to Course Coordinator'
=> 'Set content feedback to Course Coordinator',

   'Set course policy feedback to Course Coordinator'
=> 'Set course policy feedback to Course Coordinator',

   'Set opening date for all problems in the course for. . .'
=> 'Set opening date for all problems in the course for. . .',

   'Set to ...'
=> 'Set to ...',

   'Show Answer'
=> 'Show Answer',

   'Show Feedback'
=> 'Show Feedback',

   'Simple Edit'
=> 'Simple Edit',

   'Start Time'
=> 'Start Time',

   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Start each student's assignment on a new page/column (add a pagefeed after each assignment)",

   'Starting Date'
=> '开始日期',

   'Starting date'
=> '开始日期',

   'Student ID'
=> '学生证',

   'Student Information'
=> '学生信息',

   'Student Sheet Links'
=> '学生表链接',

   'Student Status'
=> '学生状态',

   'Student Status: [_1]'
=> '学生状态： [_1]',

   'Student information updated successfully.'
=> '学生信息已成功更新。',

   'Students need access key to enter course'
=> 'Students need access key to enter course',

   'Students with expired roles'
=> 'Students with expired roles',

   'Subject:'
=> '标题：',

   'Submissions'
=> 'Submissions',

   'Submit Modifications'
=> '提交更改',

   'Submit entries below as answer to receive credit'
=> 'Submit entries below as answer to receive credit',

   'Survey Question'
=> 'Survey Question',

   'Survey question'
=> 'Survey question',

   'System Level'
=> 'System Level',

   'Target Edit Map'
=> 'Target Edit Map', #??? [SB 18.10.2006]

   'TeX unconverted due to errors'
=> 'TeX unconverted due to errors',

   'TeX unconverted due to previous errors'
=> 'TeX unconverted due to previous errors',

   'The error reported was'
=> 'The error reported was',

   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.',

   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists.",

   'The requested file'
=> 'The requested file',

   'The student must log out and log in again to see these changes.'
=> 'The student must log out and log in again to see these changes.',

   'There are currently no Error Messages for this resource.'
=> 'There are currently no Error Messages for this resource.',

   'There are no Evaluation Comments on this resource.'
=> 'There are no Evaluation Comments on this resource.',

   'There was an error determining the environment values for'
=> 'There was an error determining the environment values for',

   'Top Level Map'
=> 'Top Level Map',

   'Type Name Here'
=> 'Type Name Here',

   'Type in value'
=> 'Type in value',

   'Type:'
=> 'Type:',

   'UNDISPLAYABLE'
=> 'UNDISPLAYABLE',

   'Unable to enroll'
=> 'Unable to enroll',

   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are',

   'Unable to retrieve environment data for'
=> 'Unable to retrieve environment data for',

   'Unable to set default dates for course'
=> 'Unable to set default dates for course',

   'Unavailable course'
=> 'Unavailable course',

   'Unknown Action'
=> 'Unknown Action',

   'Upload file'
=> 'Upload file',

   'Upload file to Authoring Space'
=> 'Upload file to Authoring Space',

   'VIEW'
=> 'VIEW',

   'View the FAQ'
=> 'View the FAQ',

   'Visibly Separate Items on Pages'
=> 'Visibly Separate Items on Pages',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'WARNING: The metadata table does not exist in the LON-CAPA database.',

   'Warning: change of MIME type!'
=> 'Warning: change of MIME type!',

   'Warning: target file exists!'
=> 'Warning: target file exists!',

   'Warning: target file exists, and has been published!'
=> 'Warning: target file exists, and has been published!',

   'Width'
=> 'Width',

   'Print Options'
=> '打印选项',

   'Print Answers'
=> '打印回答',

   'Only Answers'
=> '只有回答',

   'With Answers'
=> '带答案',

   'Without Answers'
=> '没有答案',

   'You are working with an unsaved version of your map.'
=> 'You are working with an unsaved version of your map.',

   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.',

   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.',

   '[_1] (what you just saw on the screen)'
=> '[_1] (what you just saw on the screen)',

   '[_1] Local Authentication with argument [_2]'
=> '[_1] 局部认证带 [_2]',

   'Currently using local (institutional) authentication.'
=> 'Currently using local (institutional) authentication.', # => '目前使用的地方（机构）的认证。Derzeit lokal (institutionell) authentifiziert.',

   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) section ID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2'
=> 'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) section ID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section ID to be used in LON-CAPA e.g., 001:1,002:2',

   'after selected'
=> '选定后',

   'and'
=> 'and',

   'between'
=> 'between',

   'button'
=> 'button',

   'by'
=> 'by',

   'check all'
=> '全选',

   'chmod error'
=> '属性错误',

   'click on the'
=> 'click on the',

   'copy Error'
=> '复制错误',

   'currently does not exist'
=> 'currently does not exist',

   'custom'
=> "自定义",

   'custom distribution file'
=> '自定义文件', # ???

   'domain'
=> '域',

   'expired or revoked'
=> 'expired or revoked',

   'extension'
=> 'extension',

   'external'
=> 'external',

   'file<br />extension'
=> 'file<br />extension',

   'first name'
=> '名',

   'generation'
=> '生成',

   'in domain'
=> '在域',

   'internal'
=> '内部的',

   'is in this state by royal decree.'
=> 'is in this state by royal decree.',

   'last name'
=> '姓',

   'make these dates the default for future enrollment'
=> 'make these dates the default for future enrollment',

   'middle name'
=> '中名',

   'name'
=> '姓',

   'no ending date'
=> '无结束日期',

   'number'
=> 'number',

   'obsolete replacement'
=> 'obsolete replacement',

   'only check if you know what you are doing'
=> 'only check if you know what you are doing',

   'only search domain [_1]'
=> '只在该域 [_1] 搜索',

   'optional'
=> '可选的',

   'or any other value'
=> '或任何其他的值',

   'private'
=> '私人的',

   'public'
=> '公开的',

   'publisher<br />owner'
=> 'publisher<br />owner',

   'section'
=> 'section',

   'standard'
=> '标准的',

   'standard LaTeX mode'
=> '标准的 LaTeX 模式',

   'standard courses only'
=> '只标准课程',

   'student name'
=> '学生姓名',

   'template'
=> '模板',

   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231',

   'unable to enroll'
=> '无法注册',

   'uncheck all'
=> '全部取消',

   'use related words'
=> '使用相关的关键词',

   'username'
=> '用户名',

   'versus'
=> 'versus',

   'with server'
=> 'with server',

   'yes'
=> '是',

   'Swedish Chef'
=> 'Swedish Chef',

   '[_1] for default hiding'
=> '[_1] for default hiding',

   '[_1] for visible separation.'
=> '[_1] for visible separation.',

   'Changes will not show until next login.'
=> 'Changes will not show until next login.',

   '[_1] if allowed, anything else if not'
=> '[_1] if allowed, anything else if not',

   '"[_1]" to disable, anything else if not'
=> '"[_1]" to disable, anything else if not',

   '[_1] to suppress, anything else to not suppress'
=> '[_1] to suppress, anything else to not suppress',

   'Set value to [_1] to allow all roles.'
=> 'Set value to [_1] to allow all roles.',

   '[_1] is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '[_1] is not an acceptable number of tries. Tries must be a positive number with no decimal point.',

   '[_1] is not an acceptable weight. Weight must be a positive number.'
=> '[_1] is not an acceptable weight. Weight must be a positive number.',

   '1 minute'
=> '1 minute',

   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.',

   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML banned</b>: HTML will not be allowed in discussion postings.',

   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Instructor</b> - instructors will not be able to participate in discussions',

   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Instructor</b> - instructors will not be able to use or view the chat room',

   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Students</b> - students will not be able to participate in discussions',

   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Students</b> - students will not be able to use or view the chat room.',

   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions',

   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room',

   'Your current LON-CAPA domain is [_1].'
=> 'Your current LON-CAPA domain is [_1].',

   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.',

   'Granting permission to clone course'
=> 'Granting permission to clone course',

   'Existing courses can be cloned when creating new courses. Cloning will copy the course structure, contents, and most parameters (automatically advancing any date parameters by six months). Usernames of owners of other courses permitted to clone this course:'
=> 'Existing courses can be cloned when creating new courses. Cloning will copy the course structure, contents, and most parameters (automatically advancing any date parameters by six months). Usernames of owners of other courses permitted to clone this course:',

   '(Course Coordinators automatically have the right to clone their own courses.) Format: user:domain, where &quot;user&quot; and &quot;domain&quot; are the LON-CAPA username and domain of the user.Separate different users with a comma.Use *:domain to allow course to be cloned by any course owner in the specified domain.Use * to allow unrestricted cloning by all course owners in all domains.'
=> '(Course Coordinators automatically have the right to clone their own courses.) Format: user:domain, where &quot;user&quot; and &quot;domain&quot; are the LON-CAPA username and domain of the user.Separate different users with a comma.Use *:domain to allow course to be cloned by any course owner in the specified domain.Use * to allow unrestricted cloning by all course owners in all domains.',

   'Allow limited HTML in discussion posts'
=> 'Allow limited HTML in discussion posts',

   'Allow problems to be split over pages'
=> 'Allow problems to be split over pages',

   'Answer Date (answerdate)'
=> 'Answer Date (answerdate)',

   'Chat Room Participation'
=> 'Chat Room Participation',

   'Chat Participation'
=> 'Chat Participation',

   'Click here to return to the chart.'
=> 'Click here to return to the chart.',

   'Completed'
=> 'Completed',

   'Confirm that this information is correct, then click &quot;Save&quot; to complete setting the parameter.'
=> 'Confirm that this information is correct, then click &quot;Save&quot; to complete setting the parameter.',

   'Course ID or number'
=> 'Course ID or number',

   'Course Initialization Helper'
=> 'Course Initialization Helper',

   'Course default for all problems'
=> 'Course default for all problems',

   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an e-mail address.'
=> 'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an e-mail address.',

   'Courses'
=> '课程',

   'Default beginning date when enrolling students'
=> 'Default beginning date when enrolling students',

   'Default ending date when enrolling students'
=> 'Default ending date when enrolling students',


   'Default set of options to pass to tth/m when converting tex'
=> 'Default set of options to pass to tth/m when converting tex',

   'Disable display of problem receipts'
=> 'Disable display of problem receipts',

   'Disallow Resource Discussion for Roles'
=> 'Disallow Resource Discussion for Roles',

   'Disallow Resource Discussion for Users'
=> 'Disallow Resource Discussion for Users',

   'Disallow live chatroom use for Roles'
=> 'Disallow live chatroom use for Roles',

   'Disallow live chatroom use for Users'
=> 'Disallow live chatroom use for Users',

   'Discussion Participation'
=> 'Discussion Participation',

   'Due Date (contentclose)'
=> 'Due Date (contentclose)',

   'Due Date (duedate)'
=> 'Due Date (duedate)',

   'Every problem in a particular folder (overrides course default)'
=> 'Every problem in a particular folder (overrides course default)',

   'Exit'
=> '退出',

   'Feedback Addresses for Course Content'
=> '课程内容的信息反馈地址',

   'Finish Helper'
=> '结束帮助程序',

   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML can be allowed or banned inside of course discussion.',

   'HTML in Discussions'
=> 'HTML in Discussions',

   'Hide Empty Rows in Spreadsheets'
=> 'Hide Empty Rows in Spreadsheets',

   'How many tries should be set for all problems in the course?'
=> 'How many tries should be set for all problems in the course?',

   'How many tries should be set for the selected folder?'
=> 'How many tries should be set for the selected folder?',

   'How many tries should be set for the selected problem?'
=> 'How many tries should be set for the selected problem?',

   'LON-CAPA has chat room functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA has chat room functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.',

   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.',

   'No section assigned'
=> 'No section assigned',

   'Number of assignments printed at the same time:'
=> 'Number of assignments printed at the same time:',

   'Opening Date (contentopen)'
=> 'Opening Date (contentopen)',

   'Opening Date (opendate)'
=> 'Opening Date (opendate)',

   'Please adjust significant figures.'
=> 'Please adjust significant figures.',

   'Please select the section you wish to set the answer open date for:'
=> 'Please select the section you wish to set the answer open date for:',

   'Please select the section you wish to set the due date for:'
=> 'Please select the section you wish to set the due date for:',

   'Please select the section you wish to set the number of tries for:'
=> 'Please select the section you wish to set the number of tries for:',

   'Please select the section you wish to set the opening date for:'
=> 'Please select the section you wish to set the opening date for:',

   'Please select the section you wish to set the problem weight for:'
=> 'Please select the section you wish to set the problem weight for:',

   'Please select the student you wish to set the answer open date for:'
=> 'Please select the student you wish to set the answer open date for:',

   'Please select the student you wish to set the due date for:'
=> 'Please select the student you wish to set the due date for:',

   'Please select the student you wish to set the number of tries for:'
=> 'Please select the student you wish to set the number of tries for:',

   'Please select the student you wish to set the opening date for:'
=> 'Please select the student you wish to set the opening date for:',

   'Please select the student you wish to set the problem weight for:'
=> 'Please select the student you wish to set the problem weight for:',

   'Privileged users that should not be hidden on staff listings'
=> 'Privileged users that should not be hidden on staff listings',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)',

   'Reading results from [_1]'
=> 'Reading results from [_1]',

   'Receipt algorithm used'
=> 'Receipt algorithm used',

   'Receiving results from [_1]'
=> 'Receiving results from [_1]',

   'Resources'
=> '资源',

   'Search Complete on Server [_1]'
=> 'Search Complete on Server [_1]', # '搜索完成 [_1]',

   'Search: [_1]'
=> '搜索: [_1]',

   'Select All Files'
=> '选择所有文件',

   'Select All Published'
=> '选择所有发布的',

   'Select Folder'
=> '选择文件夹',

   'Select Only Current Students'
=> '只选择目前的学生',

   'Select Problem'
=> '选择任务',

   'Select Student'
=> '选择学生',

   'Select for Section/Group'
=> '选择科/组',

   'Select the folder you wish to set the parameter for:'
=> 'Select the folder you wish to set the parameter for:',

   'Select the problem you wish to set the parameter for:'
=> 'Select the problem you wish to set the parameter for:',

   'Set Problem Tries'
=> 'Set Problem Tries',

   'Set Problem Weight'
=> 'Set Problem Weight',

   'Set answer open date for all problems in the course for ...'
=> 'Set answer open date for all problems in the course for ...',

   'Set answer open date for the selected folder for ...'
=> 'Set answer open date for the selected folder for ...',

   'Set answer open date for the selected problem for...'
=> 'Set answer open date for the selected problem for...',

   'Set due date for all problems in the course for ...'
=> 'Set due date for all problems in the course for ...',

   'Set due date for the selected folder for ...'
=> 'Set due date for the selected folder for ...',

   'Set due date for the selected problem for ...'
=> 'Set due date for the selected problem for ...',

   'Set number of tries for all problems in the course for ...'
=> 'Set number of tries for all problems in the course for ...',

   'Set number of tries for the selected folder for ...'
=> 'Set number of tries for the selected folder for ...',

   'Set number of tries for the selected problem for ...'
=> 'Set number of tries for the selected problem for ...',

   'Set opening date for all problems in the course for ...'
=> 'Set opening date for all problems in the course for ...',

   'Set opening date for the selected folder for ...'
=> 'Set opening date for the selected folder for ...',

   'Set opening date for the selected problem for ...'
=> 'Set opening date for the selected problem for ...',

   'Set problem weight for all problems in the course for ...'
=> 'Set problem weight for all problems in the course for ...',

   'Set problem weight for the selected folder for ...'
=> 'Set problem weight for the selected folder for ...',

   'Set problem weight for the selected problem for ...'
=> 'Set problem weight for the selected problem for ...',

   'Set value to [_1] to allow.'
=> 'Set value to [_1] to allow.',

   'Setting the [_1]'
=> 'Setting the [_1]',

   'Setting the [_1] to [_2]'
=> 'Setting the [_1] to [_2]',

   'Student Name'
=> '学生姓名',

   'The &quot;Course Title&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next&quot; to continue.'
=> 'The &quot;Course Title&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next&quot; to continue.',

   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options',

   'There are no currently enrolled students in the course.'
=> 'There are no currently enrolled students in the course.',

   'There are no currently enrolled students in the selected sections.'
=> 'There are no currently enrolled students in the selected sections.',

   'There are no previously enrolled students in the course.'
=> 'There are no previously enrolled students in the course.',

   'There are no previously enrolled students in the selected sections.'
=> 'There are no previously enrolled students in the selected sections.',

   'There are no students with future access in the course.'
=> 'There are no students with future access in the course.',

   'There are no students with future access in the selected sections.'
=> 'There are no students with future access in the selected sections.',

   'There are no students in the course.'
=> 'There are no students in the course.',

   'There are no students in the selected sections.'
=> 'There are no students in the selected sections.',

   'This controls how receipt numbers are generated.'
=> 'This controls how receipt numbers are generated.',

   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'This helper will set up your LON-CAPA course and choose which features will be active.',

   'Unselect All Files'
=> 'Unselect All Files',

   'Unselect All Published'
=> 'Unselect All Published',

   'Unselect All Resources'
=> 'Unselect All Resources',

   'Unselect for Section/Group'
=> '取消选择科/组',

   'Welcome to Your New LON-CAPA Course'
=> '欢迎使用您的新 LON-CAPA 课程',

   'What parameter do you want to set for the selected folder?'
=> 'What parameter do you want to set for the selected folder?',

   'What parameter do you want to set for the selected problem?'
=> 'What parameter do you want to set for the selected problem?',

   'What should the answer open date be set to?'
=> 'What should the answer open date be set to?',

   'What should the due date be set to?'
=> 'What should the due date be set to?',

   'What weight should be set for all problems in the course?'
=> 'What weight should be set for all problems in the course?',

   'What weight should be set for the selected folder?'
=> 'What weight should be set for the selected folder?',

   'What weight should be set for the selected problem?'
=> 'What weight should be set for the selected problem?',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Filesystem Authenticated (with initial password [_2])',

   'Currently Filesystem Authenticated.'
=> 'Currently Filesystem Authenticated.',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] LON-CAPA 内部认证 (初始密码 [_2])',

   'Currently internally authenticated.'
=> '目前 LON-CAPA 内部认证。',

   'Records per Page:'
=> '每页显示结果：',

   '[_1] with value [_2]'
=> '[_1] 与价值 [_2]',

   'all resources in the course'
=> '课程中的所有资源',

   'all students in course'
=> '在课程中的所有学生',

   'anonymous students'
=> '匿名学生',

   'answer date'
=> '回答日期',

   'contacting [_1]'
=> '联系 [_1]',

   'due date'
=> '截止日期',

   'for'
=> 'for',

   'for [_1]all resources in the course[_2]'
=> '为 [_1]课程中的所有资源 [_2]',

   'for [_1]all students in course[_2]'
=> '为 [_1]在课程中的所有学生 [_2]',

   'for [_1]'
=> '为 [_1]',

   'for section [_1]'
=> 'for section [_1]',

   'for the map named [_1]'
=> 'for the map named [_1]',

   'for the resource named [_1], part [_2]'
=> 'for the resource named [_1], part [_2]',

   'for the resource ID [_1] (name unavailable), part [_2]'
=> 'for the resource ID [_1] (name unavailable), part [_2]',

   'from'
=> 'from',

   'from current subdirectory'
=> 'from current subdirectory',

   'helper'
=> '辅助程序',

   'in'
=> 'in',

   'instructor'
=> '讲师',

   'number of tries'
=> '尝试次数',

   'opening date'
=> '开始日期',

   'problem weight'
=> '问题难度',

   'role,role,...'
=> '角色，角色，...',

   'selected students'
=> '选定的学生',

   'student'
=> '学生',

   'to'
=> 'to',

   'to [_1] ([_2])'
=> 'to [_1] ([_2])',

   'waiting on [_1]'
=> '等待 [_1]',

   'what you just saw on the screen'
=> 'what you just saw on the screen',

   'Enter my portfolio space'
=> '文件夹空间',

   'No syllabus information provided.'
=> 'No syllabus information provided.',

   'Sorry ...'
=> '对不起...',

   'This resource might be part of another course.'
=> 'This resource might be part of another course.',

   'Agree'
=> 'Agree',

   'Any comments?'
=> '评论：',

   'Copy this column'
=> 'Copy this column',

   'Disagree'
=> 'Disagree',

   'General Intro'
=> 'General Intro',

   'Greek Symbols'
=> '希腊字母',

   'HTML character entities'
=> 'HTML character entities',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.',

   'LON-CAPA Help'
=> 'LON-CAPA Help',

   'Landscape'
=> 'Landscape',

   'Launch navigation window'
=> '启动导航窗口',

   'Grade Levels'
=> '级别',

   'Grade Level'
=> '级别',

   'Lowest Grade Level'
=> '最低级别',

   'Lowest Grade Level:'
=> '最低级别:',

   'Highest Grade Level'
=> '最高级别',

   'Highest Grade Level:'
=> '最高级别:',

   'Mark all posts read'
=> '将所有帖子标记为已阅读',

   'My question/comment/feedback:'
=> '我的问题/评论/反馈:',

   'Other Symbols'
=> '其他符号',

   'Please check at least one of the following feedback types:'
=> '请从以下选项：',

   'Please rank the following criteria:'
=> '请以以下标准评价：',

   'Portrait'
=> '竖排格式',

   'Question about resource content'
=> '关于此资源内容的问题',

   'Question/Comment/Feedback about course policy'
=> '关于课程规则的问题/评论/反馈',

   'Select a Course to Enter'
=> '选择一个课程',

   'Sending Messages'
=> '发送邮件',

   'Show Me My First Homework Problem'
=> 'Show Me My First Homework Problem',

   'Standards'
=> '标准',

   'Strongly Agree'
=> 'Strongly Agree',

   'Strongly Disagree'
=> 'Strongly Disagree',

   'Symbol'
=> '符号',

   'The material appears to be correct'
=> '这些材料似乎是正确的',

   'The material is helpful'
=> '这些材料是有用的',

   'The material is presented in a clear way'
=> '这些材料中提出一个明确的方式',

   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc)'
=> '资源在技术上是正确的(加载速度足够快, 不会产生错误, 链接页面可以访问, 等等)',

   'HTML character enties'
=> 'HTML 字符实体',

   '"Waiting for Remote Control window to load: "+[_1]'
=> '"等待加载远程控制窗口: "+[_1]',

   '[_1]Continue[_2] on in Inline Menu mode'
=> '[_1]继续[_2] 在内置菜单模式下',

   'All posts'
=> '所有的讨论',

   'Change Color Scheme'
=> '更改颜色方案',

   'Change Colors'
=> '改变颜色',

   'Change Discussion Display Preferences'
=> '改变讨论显示偏好',

   'Change How Math Equations Are Displayed'
=> '改变显示科学计算公式',

   'Change Language'
=> '语言',

   'Change Language Preferences'
=> '更改语言首选项',

   'Change Message Forwarding and Notification Email Addresses'
=> '更改邮件转发和通知的电子邮件地址',

   'Change Password'
=> '更改密码',

   'Change Preferences'
=> '改变参数',

   'Change Roles Page Preferences'
=> '改变角色页参数',

   'Change Screen Name'
=> '改变昵称',

   'Change Screenname'
=> '改变昵称',

   'Change WYSIWYG Editor Preferences'
=> 'WYSIWYG-编辑器',

   'Contact Helpdesk'
=> '联系求助',

   'Current discussion settings'
=> '目前讨论的设置',

   'Due Date'
=> '截止日期',

   'Each post can be toggled read/unread'
=> 'Each post can be toggled read/unread',

   "Edit the 'About Me' Personal Information Screen"
=> "个人网页",

   'Enable WYSIWYG Editor'
=> '应用 WYSIWYG-编辑器',

   'End of Sequence'
=> '结束序列',

   'Entering Course'
=> '进入课程',

   'Get help'
=> '获得帮助',

   'Go to main menu'
=> '进入主菜单',

   'Has New Discussion'
=> '有新讨论',

   'Launching of the Remote Control menu will fail if pop-up window filters are active. To use the Remote Control, disable the filter for this site.'
=> '当弹出式窗口过滤器被激活，远程控制启动将会失败。 为了使用远程控制，在此网站请禁用这些过滤器。',

   'Navigate Course Content'
=> '浏览目录',

   'New posts only'
=> '只有新的讨论',

   'No Resource'
=> '没有资源',

   'No syllabus available'
=> '没有提供教学大纲',

   'Not currently assigned.'
=> '目前没有任务发布。',

   'Not new'
=> '不是新的',

   'Off'
=> '关',

   'On'
=> '开',

   'Once displayed'
=> '显示一次',

   'Once marked not NEW'
=> '一次后标记不是新的',

   'Please click on the the resource you intend to access'
=> 'Please click on the the resource you intend to access',

   'Posts cease to be marked "NEW"'
=> 'Posts cease to be marked "NEW"',

   'Posts to be displayed'
=> 'Posts to be displayed',

   'Role selected. Please stand by.'
=> '角色选定。请稍候。',

   'Send'
=> '发送',

   'Set User Preferences'
=> '设置用户参数',

   'Show Preview and Check Spelling'
=> '查看预览和拼写检查',

   'Sort by:'
=> '排序方式:',

   'The external menu (Remote Control) has been disabled, and you will be working with the smaller inline menu. You may have either closed the Remote Control window, or it was blocked by a pop-up window filter in your browser. To use the Remote Control, disable the filter for this site, and re-launch the Remote Control from the inline menu.'
=> '外部菜单（远程控制）已被禁用，继续在内置菜单模式下工作。您可能已经关闭了远程控制的窗口，或被您的浏览器的弹出窗口过滤器阻止了。为了使用远程控制，在此网站禁用该过滤器，并在内置菜单重新启动远程控制。',

   'There are several possibilities of where to go next'
=> 'There are several possibilities of where to go next',

   'To use the Remote Control, disable the filter for this site, and re-launch the Remote Control from the inline menu.'
=> '为了使用远程控制，在此网站禁用弹出窗口过滤器，并在内置菜单重新启动远程控制。',

   'Toggle read/unread'
=> '切换已读/未读',

   'Unread only'
=> '只有未读',

   "View this user's personal page"
=> "显示这个用户的个人网页",

   'You have reached the end of the sequence of materials.'
=> '您已达到教材序列的最后。',

   'You may have either closed the Remote Control window, or it was blocked by a pop-up window filter in your browser.'
=> '您可能已经关闭了远程控制的窗口，或者被您的浏览器的弹出窗口过滤器拦截了。',

   'attachments'
=> '附件',

   'About User'
=> '个人网页',


   'All documents out of a published map into this folder'
=> '在这个目录里面发布的所有文件的内容列表',

   'Change Math Pref'
=> 'Change Math Pref',

   'Change Math Preferences'
=> '改变显示科学方程式偏好',

   'Comment'
=> '注解',

   'Communication/Messages'
=> '通信/邮件',

   'Configure blocking of student communication during exams'
=> 'Configure blocking of student communication during exams',

   'Convert to Images'
=> '转换为图像',

   'Course and Catalog Search'
=> '课程和目录搜索',

   'Create Subdirectory'
=> '创建子目录',

   'Upload file to current directory'
=> '上传文件到当前目录',

   'Create subdirectory in current directory'
=> '在当前目录下，创建一个新的子目录',

   'Upload embedded images/multimedia/css/linked files if HTML file'
=> '对于HTML文件: 上传嵌入式图像/多媒体文件/CSS/链接文件',

   'Delete Selected'
=> '删除所选',

   'CRITICAL'
=> '重要的',

   'Currently no documents.'
=> '目前没有任何文件。',

   'Enter terms or phrases, then press "Search" below'
=> '在搜索栏里输入关键字或词组，然后点击下面的“搜索”。',

   'INBOX'
=> '收件箱',

   'Upload embedded images/multimedia files if HTML file'
=> '对于HTML文件: 上传嵌入式图像/多媒体文件',

   'IMS Import'
=> 'IMS Import',

   'Import IMS package'
=> '导入 IMS-包',

   'IMS Export'
=> 'IMS Export',

   'Export Course to IMS Package'
=> '导出-IMS-包',

   'Export content item?'
=> 'Export content item?',

   'Export discussion posts?'
=> 'Export discussion posts?',

   'As you did not select any content items or discussions for export, an IMS package has not been created.'
=> 'As you did not select any content items or discussions for export, an IMS package has not been created.',

   'Please [_1]go back[_2] to select either content items or discussions for export.'
=> 'Please [_1]go back[_2] to select either content items or discussions for export.',

   '[_1]Your IMS package[_2] is ready for download.'
=> '[_1]Your IMS package[_2] is ready for download.',

   'Import a document'
=> 'LON-CAPA-内部文件',

   'Make New Folder'
=> '新建文件夹',

   'New Composite Page'
=> '新组合页面',

   'New Messages Only'
=> '只有新邮件',

   'Portfolio Manager'
=> '组合管理',

   'Preferred method to display Math'
=> '首选的方法来显示科学方程式',

   'Published documents'
=> '发布文件',

   'Recover Deleted Documents'
=> '恢复已删除的资源',

   'Send a Message'
=> '发送邮件',

   'SENT MESSAGES'
=> '已发送邮件',

   'Show'
=> '显示',

   'TRASH'
=> '已删除邮件',

   'TeX to HTML'
=> 'TeX to HTML',

   'View Folder'
=> '查看文件夹',

   'fulltext search (time consuming)'
=> '全文检索 (费时的)',

   'search discussion postings (resources and discussion boards)'
=> '搜索讨论帖子 (资源和布告栏)',

   'Roles'
=> '角色',

   'Select style file'
=> '选择档案风格',

   '(mark them then click "next" button)'
=> '(标记，然后点击“下一步”按钮)',

   '100 Level'
=> '1. 学年',

   '200 Level'
=> '2. 学年',

   '300 Level'
=> '3. 学年',

   '400 Level'
=> '4. 学年',

   'Action'
=> '动作',

   'Actions for current directory'
=> '此目录的行动',

   'Change Discussion Preferences'
=> '改变讨论偏好',

   'Change Message Forwarding/Notification'
=> '邮件转发和通知',

   'Change WYSIWYG Preferences'
=> 'WYSIWYG-编辑器',

   'Change to '
=> '变化为 ',

   'Clean Up'
=> '清理',

   'Closed - XML source is closed to everyone'
=> '锁定 - XML的源代码对手有人锁定',

   'Copy'
=> '复制',

   'Create a new directory or LON-CAPA document'
=> '创建一个新的目录或 LON-CAPA 文件',

   'Current setting '
=> '当前设置 ',

   'Delete Directory'
=> '删除文件夹',

   'Delete directory'
=> '删除文件夹',

   'Delete this resource'
=> '删除此资源',

   'Disable WYSIWYG editor'
=> '不使用 WYSIWYG-编辑器',

   'Display Preference'
=> '显示偏好',

   'Edit catalog information'
=> '编辑目录信息',

   'Enable WYSIWYG editor'
=> '使用 WYSIWYG-编辑器',

   'Grade 1'
=> '1 级',

   'Grade 10'
=> '10 级',

   'Grade 11'
=> '11 级',

   'Grade 12'
=> '12 级',

   'Grade 13'
=> '13 级',

   'Grade 2'
=> '2 级',

   'Grade 3'
=> '3 级',

   'Grade 4'
=> '4 级',

   'Grade 5'
=> '5 级',

   'Grade 6'
=> '6 级',

   'Grade 7'
=> '7 级',

   'Grade 8'
=> '8 级',

   'Grade 9'
=> '9 级',

   'Graduate Level'
=> '研究生层次',

   'List current directory'
=> '文件夹',

   'Mark obsolete'
=> '标记为过时的',

   'Move'
=> '移动',

   'New library file'
=> '新的库文件',

   'No file: [_1]'
=> '没有任何文件： [_1]',

   'No personal information provided'
=> '没有提供的个人资料',

   'Not specified'
=> '未指定',

   'Open - XML source is open to people who want to use it'
=> '开放 - XML的源代码开放给想要使用它的人',

   'Points Display'
=> '分数显示',

   'Completed Problems Display'
=> '显示完成作业',

   'Points Scored'
=> '得分',

   'Attempted'
=> '尝试',

   'Posts displayed?'
=> '帖子显示？',

   'Preferences can be set that determine'
=> '预置可设置确定',

   'Print contents of directory'
=> '打印目录',

   'Print directory'
=> '打印目录',

   'Problem Document'
=> '任务文件', # '问题',

   'Publish this Directory'
=> '发布此目录',

   'Publish this resource'
=> '发布此资源',

   'Re-publish'
=> '重新发布',

   'Retrieve old version'
=> '恢复旧版本',

   'Select action'
=> '选择行动',

   'Send message'
=> '发送消息',

    'Set display preferences for discussion posts for both discussion boards and individual resources in all your courses.'
=> '在这里，您可以设置您的讨论是否显示在所有的课程的布告栏和个人资源里。',

   'Source Distribution'
=> '源代码的访问权限',

   'The preferences you set here can be overridden within each individual discussion.'
=> '您的喜好设定这里可以适用在每个讨论。', # '您的喜好设定可以被每个讨论更改。',

   'Under what circumstances posts are identified as "NEW"'
=> '在什么情况下讨论被设定为“新”',

   'Upload a new document'
=> '上传新文件',

   'Use random seed'
=> '使用随机种子',

   'Use style file'
=> '使用样式文件',

   'Which posts are displayed when you display a discussion board or resource, and'
=> '哪些讨论将将被显示，如果你有一个布告栏或资源，',

   'closed'
=> '锁定源代码', # !

   'open'
=> '公开源代码', # !

   '(mark desired resources then click "next" button)'
=> '(标记所需资源然后单击“下一步”按钮)',

   '[_1]Change[_2] for just [_3]this course[_4] or for all [_5]your courses[_6].'
=> '[_1]改变[_2] 只为 [_3]该课程[_4] 或者为所有 [_5]您的课程[_6].',

   "Page displayed after role selection in course now set by [_1]user's global preferences[_2]."
=> "Page displayed after role selection in course now set by [_1]user's global preferences[_2].",

   'Page displayed after role selection in this course set to [_1].'
=> 'Page displayed after role selection in this course set to [_1].',

   'Unable to set control of page display to [_1] due to [_2].'
=> 'Unable to set control of page display to [_1] due to [_2].',

   'Unable to set page display, after role selection, for this course to [_1] due to [_2].'
=> 'Unable to set page display, after role selection, for this course to [_1] due to [_2].',

   'Add or Edit Blog Entries'
=> '添加或修改博客条目',

   'Add to my public course blog'
=> '添加到我的公共课程博客',

   'Annotator'
=> '注释者',

   'Av. Attempts'
=> 'Av. Attempts',

   'Available RSS Feeds and Blogs'
=> '可用的 RSS订阅和博客',

   'Average number of attempts'
=> 'Average number of attempts',

   'Bookmarks'
=> '书签',

   'Change interval?'
=> '更改间隔？',

   'Change options?'
=> '更改选项？',

   'Change thresholds?'
=> '更改阈值？',

   'Clean up'
=> '清理',

   'Close Folder'
=> '关闭文件夹',

   'Configure Blocking of Student Communication during Exams'
=> 'Configure Blocking of Student Communication during Exams',

   'Course Action Items'
=> 'Course Action Items',

   'Creating PDF'
=> '创建PDF文件',

   'Currently: [_1].'
=> '现在： [_1].',

   'Deg. Diff'
=> '难度',

   'Description'
=> '描述',

   'Display Action Items'
=> 'Display Action Items',

   'Enter my groups in the course'
=> '我的课程组',

   'Entering [_1]'
=> '进入 [_1]',

   'Entering [_1] ...'
=> '进入 [_1]...',

   'First resource'
=> '第一资源',

   'Generated [_1] ([_2] bytes)'
=> '生成于 [_1] ([_2] bytes)',

   'Go to first resource'
=> '转到第一资源',

   'Group Documents'
=> '组文件',

   'Groups'
=> '组',

   'Help Menu'
=> '求助菜单',

   'Hide all'
=> '全部隐藏',

   'Hide this Feed'
=> '隐藏这个Feed',

   'LON-CAPA Feed "[_1]" for [_2]'
=> 'LON-CAPA-Feed "[_1]" 对于 [_2]',

   'Last Reset'
=> '最后重启',

   'Last revised'
=> '最近更改',

   'Link'
=> '连接',

   'Log In'
=> '登录',

   'Move Checked to Folder'
=> 'Move Checked to Folder',

   'Name for New Feed'
=> '新Feed的名字',

   'Name of this Feed'
=> '这个Feed的名字',

   'New course messages'
=> '新的课程信息',

   'New critical messages in course'
=> '新的课程重要信息',

   'New in course'
=> '新课程',

   'New version'
=> '新版本',

   'No messages sent.'
=> '没有寄出的邮件。',

   'No new course messages'
=> '没有新的课程信息',

   'No problems require handgrading'
=> '没有习题需要手动评分',

   'No problems satisfy threshold criteria'
=> '没有问题达到要求标准',

   'No problems with errors'
=> '没有错误的问题',

   'No unread critical messages in course'
=> '没有未读的重要邮件',

   'No unread posts in course discussions'
=> '没有未读的帖子在课程论坛里面',

   'No updated versions'
=> '没有更新版本',

   'Num. students'
=> '学生的数量',

   'Number of errors'
=> '错误的数量',

   'Number of new posts'
=> '新帖子的数量',

   'Number ungraded'
=> '未评分的数量',

   'Open Folder'
=> '打开文件夹',

#   'Open all folders'
#=> '打开所有文件夹',

   'Page set to be displayed after you have selected a role in this course'
=> '页面显示设置，在您选择了该课程中的角色后',

   'Please select the type of LON-CAPA entity - Course or Group - for which you wish to add/modify a user role'
=> 'Please select the type of LON-CAPA entity - Course or Group - for which you wish to add/modify a user role',

   'Please stand by while processing your print request, this may take some time ...'
=> 'Please stand by while processing your print request, this may take some time ...',

   'Problem'
=> '问题',

   'Problem Name'
=> '问题描述',

   'Problem is not open to be viewed. It'
=> 'Problem is not open to be viewed. It',

   'Problems requiring handgrading'
=> '必须手动评分的问题',

   '(Problems with av. attempts &ge; [_1] or deg. difficulty &ge; [_2]) [_3] and total number of students with submissions &ge; [_4]'
=> '(问题尝试的平均数目 &ge; [_1] 或者难度 &ge; [_2]) [_3] 和回答问题的学生总数 &ge; [_4]',

   'Problems with errors'
=> '错误的问题',

   'Recently generated printouts'
=> 'Recently generated printouts',

   'Recently generated printout zip files'
=> 'Recently generated printout zip files',

   'Reset Count?'
=> '计数器复位？',

   'Reset counters to 0'
=> '重置计数器为0',

   'Select [_1]'
=> '选择 [_1]',

   'Select the sequence to print resources from:'
=> '选择该资源的打印顺序：',

   'Selected [_1]Problems[_2] from folder [_3]'
=> '选定[_1]问题[_2]从文件夹[_3]',

   'Selected [_1]Resources[_2] from folder [_3]'
=> '选定[_1]资源[_2]从文件夹[_3]',

   'Selected <b>Problems</b> from <b>entire course</b>'
=> '选定<b>问题</b>从<b>整个课程</b>',

   'Selected <b>Resources</b> from <b>entire course</b>'
=> '选定<b>资源</b>从<b>整个课程</b>',

   'Selected <b>Problems</b> from <b>entire course</b> for <b>selected people</b>'
=> '选定<b>资源</b>从<b>整个课程</b>给<b>选定的人</b>',

   'Selected [_1]Problems[_2] from folder [_3] for [_4]selected people[_5]'
=> '选定[_1]问题[_2]从文件夹[_3]给[_4]选定的人[_5]',

   'Selected [_1]Problems[_2] from folder [_3] for [_4]CODEd assignments[_5]'
=> '选定[_1]问题[_2]从文件夹[_3]给[_4]编码练习[_5]', # ???

   'Selected [_1]Resources[_2] from folder [_3] for [_4]selected people[_5]'
=> '选定[_1]资源[_2]从文件夹[_3]给[_4]选定的人[_5]',

   'Selected [_1]Resources[_2] from folder [_3] for [_4]CODEd assignments[_5]'
=> '选定[_1]资源[_2]从文件夹[_3]给[_4]编码练习[_5]', # ???

   'Selected [_1]Problems[_2] from current subdirectory [_3]'
=> '选定[_1]问题[_2]从当前的子文件夹[_3]',

   'Selected <b>Resources</b> from <b>selected folder</b> in course'
=> '选定<b>资源</b>从课程里的<b>选定的文件夹</b>',

   'Show all'
=> '全部显示',

   'Show my first due problem'
=> '查看我的首要问题来处理',

   'Show only uncompleted problems'
=> '只显示未完成的问题',

   'Show everything'
=> '查看所有',

   'Uncompleted Problems'
=> '没有完成问题',

   'All homework assignments have been completed.'
=> '所有的问题都已经完成。',

   'Speller Suggestions'
=> 'Speller Suggestions',

   'Start a New Feed'
=> '开始一个新的Feed',

   'Save Marked Changes'
=> '保存标记的更改',

   'Save changes'
=> '保存更改',

   'This action is currently not authorized.'
=> '这一行动目前是不被允许的。',

   'Time of last post'
=> '最后发表的帖子的时间',

   'Title of document goes here'
=> 'Title of document goes here',

   'Body of document goes here'
=> 'Body of document goes here',

   'Total number of students with submissions'
=> 'Total number of students with submissions',

   'Unread course discussion posts'
=> '未读的课程讨论帖子',

   'Version used'
=> '使用版本',

   'View current problem status and grading information'
=> '查看当前的问题的状态和等级评定信息',

   "What's New?"
=> "有什么新内容？",

   "What's New? page"
=> "有什么新页面",

   "What's New page"
=> "有什么新页面",

   'You are accessing an invalid course'
=> '您在试图访问无效的课程。',

   'course only'
=> 'course only',

   'delete'
=> '删除',

   'first resource in the course'
=> '第一期课程资源',

   'hidden'
=> '隐藏的',

   'since last month'
=> '自上个月以来',

   'since last week'
=> '自上周以来',

   'since start of course'
=> '从课程开始起',

   'since yesterday'
=> '从昨天起',

   'specific setting for this course'
=> '这门课程的具体设置',

   'user preference'
=> '用户偏好',

   "what's new? page"
=> "有什么新页面",

   'your general user preferences'
=> '您的一般使用者偏好',

   'Submitting as Comment'
=> '提交评论',

   'Submitting as Policy Feedback'
=> '提交课程指导方针反馈',

   'Submitting as Question'
=> '提交的问题',

   'Total Points In Course'
=> '课程总分',

   'the resource you just saw on the screen'
=> 'the resource you just saw on the screen',

   'Annotations'
=> '注释',

   'Close (no save)'
=> '关闭 (不保存)',

   'Save and Update'
=> '保存和更新',

   'Bookmark Tree Viewer/Editor'
=> '书签树浏览器/编辑器',

   'Chat'
=> '聊天',

   'Chat Room'
=> '聊天室',

   'Drop Box'
=> '收件箱',

   'Import Bookmarks'
=> '导入书签',

   'The LearningOnline Network with CAPA'
=> 'The LearningOnline Network with CAPA',

   'This LON-CAPA server is temporarily not available for login.'
=> '该 LON-CAPA 服务器目前无法登录。',

   'Please attempt to login to one of the following servers:'
=> '请尝试登录到下列其中一个服务器：',

   '(preferred)'
=> '(首选的)',

   'Although your current role has privileges to view any existing groups in this course, you do not have privilegesto create new groups.'
=> 'Although your current role has privileges to view any existing groups in this course, you do not have privilegesto create new groups.',

   'Collaborative Tools'
=> '协作工具',

   'Course content'
=> '课程内容',

   'Create a new group'
=> '创建新组',

   'Created'
=> '生成',

   'Creator'
=> '创设者',

   'Discussion Boards'
=> '讨论板',

   'Disk Use (%)'
=> '使用的存贮空间 (%)',

   'Enable Recent Roles Hotlist:'
=> '启用最近的角色活动表：',

   'Files'
=> '文件',

   'Group Name'
=> '组名',

   'Group Title'
=> '组标题',

   'Members'
=> '成员',

   'Modify'
=> '修改',

   'Re-enable'
=> '修复',

   'Expire'
=> '失效',

   'Group settings'
=> '组设置',

   'Modify group membership'
=> '修改组成员',

   'No groups exist.'
=> '没有组存在。',

   'Number of roles in Hotlist:'
=> '角色的快速访问列表：',

   'Quota (MB)'
=> '容量 (MB)',

   'Remote Control'
=> '遥控器',

   'Some LON-CAPA users have a long list of roles. The Recent Roles Hotlist feature keeps track of the last N roles which have been visited and places a table of these at the top of the roles page. People with very few roles should leave this feature disabled.'
=> '一些 LON-CAPA 用户有很多角色。在快速访问列表里面将显示最近使用过的角色的最后N角色访问过的地方，这些角色将显示在角色选择页面的上方。 用户如果只有很少的角色，应该禁用快速访问列表。',

   'Some LON-CAPA users have a long list of courses. The Recent Courses Hotlist feature keeps track of the last N courses which have been visited and places a table of these at the top of the courses page. People with very few courses should leave this feature disabled.'
=> '一些 LON-CAPA 用户有很多课程。在快速访问列表里面将显示最近使用过的课程的最后N课程访问过的地方，这些课程将显示在课程选择页面的上方。用户如果只有很少的角色，应该禁用快速访问列表。',

   'Switch to Inline Menu Mode'
=> '切换到内置菜单模式',

   'This list below can be used to <q>freeze</q> roles on your screen. Those marked as frozen will not be removed from the list, even if they have not been used recently.'
=> '这下面的列表可以用来<q>冻结</q>屏幕上的角色。这些标记为冻结的将不会从名单中删除，即便最近没有被使用过时。',

   'View Status'
=> '查看状态',

   'View/Change Status'
=> '查看/修改状态',

   'You are not currently a member of any active groups in this course.'
=> 'You are not currently a member of any active groups in this course.',

   'Group [_1] was updated.'
=> '组 [_1] 已更新。',

   'An error occurred while setting parameters for Discussion Boards folder: [_1]'
=> 'An error occurred while setting parameters for Discussion Boards folder: [_1]',

   'Discussion Boards Folder created.'
=> '创建讨论板夹。',

   'You do not have group administration privileges in this course.'
=> 'You do not have group administration privileges in this course.',

   'An error occurred when [_1] the group. Please try again.'
=> 'An error occurred when [_1] the group. Please try again.',

   'You have requested deletion of the group [_1].'
=> 'You have requested deletion of the group [_1].',

   'The following users could not be activated, because an error occurred:'
=> 'The following users could not be activated, because an error occurred:',

   'The following users could not be re-enabled, because an error occurred:'
=> 'The following users could not be re-enabled, because an error occurred:',

   'The following users could not be modified, because an error occurred:'
=> 'The following users could not be modified, because an error occurred:',

   'The following users could not be added, because an error occurred:'
=> 'The following users could not be added, because an error occurred:',

   'The following users could not be deleted, because an error occurred:'
=> 'The following users could not be deleted, because an error occurred:',

   'The following users could not be expired, because an error occurred:'
=> 'The following users could not be expired, because an error occurred:',

   'No change occurred for the following users:'
=> 'No change occurred for the following users:',

   'When a group is deleted the following occurs:'
=> 'When a group is deleted the following occurs:',

   'All group membership is terminated.'
=> 'All group membership is terminated.',

   'The group ceases to be available either for viewing or for modification of group settings and membership.'
=> 'The group ceases to be available either for viewing or for modification of group settings and membership.',

   'The group folder is removed from the folder containing it - normally this is the "Course Groups" folder which contains folders for all groups in the course.'
=> 'The group folder is removed from the folder containing it - normally this is the "Course Groups" folder which contains folders for all groups in the course.',

   'Although a deleted group is no longer accessible, the group name used for the group will be reserved, and will not be available for assignment to a new group in the same course in the future.'
=> 'Although a deleted group is no longer accessible, the group name used for the group will be reserved, and will not be available for assignment to a new group in the same course in the future.',

   'Delete group'
=> '删除组',

   'Group deletion failed because deletion of [_1] out of [_2] members failed.'
=> '删除组失败，因为[_1]的[_2]成员不能被删除。',

   'Group successfully deleted.'
=> '该组已成功删除。',

   "Although the group was deleted, an error occurred when removing the group's folder from the 'Course Groups' folder: [_1]"
=> "该组已被删除，从课程组的文件夹删除组文件夹时发生错误：[_1]",

   'Group deletion failed.'
=> '组删除失败。',

   'Course Folder -[_1]'
=> '课程文件夹 [_1]',

   'An error occurred when reading contents of parent folder to group:'
=> 'An error occurred when reading contents of parent folder to group:',

   'An error occurred when saving updated parent folder to group:'
=> 'An error occurred when saving updated parent folder to group:',

   'You have requested enabling the previously deleted group [_1].'
=> 'You have requested enabling the previously deleted group [_1].',

   'When a deleted group is re-enabled the following occurs:'
=> 'When a deleted group is re-enabled the following occurs:',

   'Group settings and membership at the time the group was deleted are reinstated.'
=> 'Group settings and membership at the time the group was deleted are reinstated.',

   'A group folder is added to the "Course Groups" folder which contains folders for all groups in the course.'
=> 'A group folder is added to the "Course Groups" folder which contains folders for all groups in the course.',

   'Reenable group'
=> '组恢复',

   'The group [_1] was not re-enabled, because it is not a deleted group.[_2]Perhaps it has already been re-enabled?'
=> 'The group [_1] was not re-enabled, because it is not a deleted group.[_2]Perhaps it has already been re-enabled?',

   'No end date set'
=> '没有设定结束日期',

   'Membership reinstated for [quant,_1,user], each with start and end dates for group access set to defaults: [_2] and [_3]'
=> 'Membership reinstated for [quant,_1,user], each with start and end dates for group access set to defaults: [_2] and [_3]',

   "Although the group was re-enabled, an error occurred when adding the group's folder to the 'Course Groups' folder: [_1]"
=> "Although the group was re-enabled, an error occurred when adding the group's folder to the 'Course Groups' folder: [_1]",

   'Re-enabling group failed.'
=> '重新启用组失败。',

   'with related words'
=> '相关的关键词',

   'with no related words'
=> '没有相关的关键词',

   'Change Roles Preferences'
=> '改变角色偏好',

   'Display [_1] Most Recent Roles'
=> '显示 [_1] 个最近角色',

   'Freeze Role'
=> '冻结角色',

   'Recent Roles Hotlist is Disabled'
=> '禁用最近使用角色的快速访问列表',

   'Recent Roles Hotlist is Enabled'
=> '启用最近使用角色的快速访问列表',

   'Author Space'
=> '作者空间',

   'Degree of discrimination'
=> '分化程度',

   'Disable WYSIWYG Editor'
=> '禁用WYSIWYG编辑器',

   'Hypertext Document'
=> 'HTML 文件',

   'Last Modifying User'
=> '上次修改用户',

   'Last Revision Date'
=> '最近修订日期',

   'Linked/Related Resources'
=> '联系/相关资源',

   'Network-wide courses using resource'
=> '网络上使用该课程资源',

   'Never'
=> '从不',

   'Preview'
=> '预览',

   'Resources that follow this resource in maps'
=> 'Resources that follow this resource in maps',

   'Resources that lead up to this resource in maps'
=> 'Resources that lead up to this resource in maps',

   'Resources used by this resource'
=> 'Resources used by this resource',

   'Resources using or importing resource'
=> '资源使用或导入',

   'Return'
=> '后退',

   'Setting WYSIWYG editor to:'
=> 'WYSIWYG-编辑器设置为：',

   'Source Available'
=> '源代码可用',

   'Source Custom Distribution File'
=> '源代码的访问权限',

   'Start new page[_1]before selected'
=> 'Start new page[_1]before selected',

   'on'
=> '开',

   '(on)'
=> '(on)',

   'off'
=> '关',

   '(off)'
=> '(off)',

   '(re-initialize course to access)'
=> '(re-initialize course to access)',

   'All Parts'
=> 'All Parts',

   'Changes will become active for your current session after [_1], or the next time you log in.'
=> '点击 [_1] 按钮来保存最后的更改。',

   'Cut'
=> '剪切',

   'Random Order'
=> '任意顺序',

   'Due and Answer Available'
=> 'Due and Answer Available',

   'Edit any group in the course'
=> '课程分组管理',

   'Editing the Table of Contents for your Course'
=> '如何修改课程内容',

   'Enter any group in the course'
=> 'Enter any group in the course',

   'Existing Parameter Settings for Your Resources'
=> 'Existing Parameter Settings for Your Resources',

   'Group'
=> '组',

   'Group:'
=> '组：',

   'Hidden'
=> '隐藏',

   'List Symbs'
=> '内部标识',

   'Symb List'
=> '内部标识名单',

#   'Manage Course Slots'
#=> '管理课程插槽',

   'Manage Slots'
=> 'Manage Slots',

   'Manage student enrollment '
=> '招生管理 ',

   'Modify Resource Parameters - Overview Mode'
=> '修改资源参数 - 概况模式',

   'Modify parameter settings (due dates, etc) for resources and the course'
=> '修改课程和资源参数',

   'Modify parameter settings for this resource'
=> '参数设置',

   'New and Existing Parameter Settings for Your Resources'
=> '为您的资源设置新的和现有的参数',

   'Parameter Change Log and Course Blog Posting/User Notification'
=> '参数变更记录和课程博客/用户通知',

   'Parameter Manager'
=> '参数管理',

   'Randomly Pick: '
=> '随机挑选： ',

   'Remove'
=> '删除',

   'Rendering:'
=> '检查:',

   'Select Parameters to View'
=> '选择想要查看的参数',

   'Select Parts to View'
=> '选择想要查看的部分',

   'Set Parameter Setting Default Actions'
=> '设置默认操作的参数',

   'Set Portfolio Metadata'
=> '设置元数据-组合',

   'Set/Modify Resource Parameters - Helper Mode'
=> '设置/修改资源参数 - 辅助模式',

   'Set/Modify Resource Parameters - Overview Mode'
=> '设置/修改资源参数 - 概况模式',

   'Set/Modify Resource Parameters - Table Mode'
=> '设置/修改资源参数 - 表模式',

   'Settings for Your Course'
=> '课程设置',

   'Table Mode'
=> '表模式',

   'Table Mode Parameter Setting'
=> '表模式参数设定',

   'The resources in "[_1]" are open for a limited time. Once you click the "[_2]" button below you have [_3] to complete all resources in "[_1]".'
=> 'The resources in "[_1]" are open for a limited time. Once you click the "[_2]" button below you have [_3] to complete all resources in "[_1]".',

   'URL hidden'
=> '隐藏 URL',

   'Update Parameter Display'
=> '更新参数',

   'View calculated grades (Spreadsheet)'
=> '计算评分（Spreadsheet）',

   "What's new?"
=> "有什么新的？",

   're-initializing Course'
=> '重新初始化课程',

   'Show Resource'
=> '查看资源',

   'Feedback to resource author'
=> '反馈给此资源的作者',

   'Click to add/remove attachments'
=> '单击添加/删除附件',

   'New attachments'
=> '新附件',

   'Retained attachments'
=> '保留附件',

   'Add a new attachment to this post.'
=> '给这个信息添加新的附件：',

   'Discussion Post Attachments'
=> '讨论张贴附件',

   'Modify course settings'
=> 'Modify course settings',

   'Send and display broadcast e-mail'
=> 'Send and display broadcast e-mail',

   'Awarded Total Points'
=> '达到总分',

   'Total Parts Done'
=> 'Total Parts Done',

   'Create a single course'
=> 'Create a single course',

   'Create a new course by completing an online form.'
=> 'Create a new course by completing an online form.',

   'Create a single collaborative group space'
=> 'Create a single collaborative group space',

   'Create a new group space for non-course use by completing an online form.'
=> 'Create a new group space for non-course use by completing an online form.',

   'Create courses/groups by uploading an attributes file'
=> 'Create courses/groups by uploading an attributes file',

   'Upload an attributes file containing specifications for one or more courses or groups in XML format.'
=> 'Upload an attributes file containing specifications for one or more courses or groups in XML format.',

   'current'
=> '当前的',

   'Version changes'
=> 'Version changes',

   'Change interval'
=> 'Change interval',

   'Student Submission Reports'
=> 'Student Submission Reports',

   'Prepare reports of student submissions.'
=> 'Prepare reports of student submissions.',

   'Survey Reports'
=> 'Survey Reports',

   'Prepare reports on survey results.'
=> 'Prepare reports on survey results.',

   'View survey'
=> 'View survey',

   'Previous Survey'
=> 'Previous Survey',

   'Next Survey'
=> 'Next Survey',

   'Choose a different Survey'
=> 'Choose a different Survey',

   'Generate Report'
=> 'Generate Report',

   'Part [_1], Response [_2]'
=> '部份 [_1], 答案 [_2]',

   'Foil Name'
=> 'Foil Name',

   'Foil Text'
=> 'Foil Text',

   'Percent'
=> '百分比',

   'Correct Problems Plot'
=> 'Correct Problems Plot',

   'Display a histogram of student performance in the course.'
=> 'Display a histogram of student performance in the course.',

   'Access Status'
=> '访问状态',

   '[_1] Limit by time'
=> '[_1] 限制时间',

   'Submission Time Plots'
=> 'Submission Time Plots',

   'Currently Has Access'
=> '目前访问',

   'Will Have Future Access'
=> '将来的访问',

   'Previously Had Access'
=> '此前的访问',

   'Any Access Status'
=> '任易的访问状态',

   'Previous Problem'
=> '前面的问题',

   'Next Problem'
=> '下一个问题',

   'Choose a different Problem'
=> 'Choose a different Problem',

   'Update Caches'
=> 'Update Caches',

   'Begin'
=> 'Begin',

   'There are no students in the sections selected.'
=> 'There are no students in the sections selected.',

   'There are no students in the sections/groups selected.'
=> 'There are no students in the sections/groups selected.',

   'There is no submission data for this problem at all.'
=> 'There is no submission data for this problem at all.',

   'There is no submission data for this problem.'
=> 'There is no submission data for this problem.',

   'There is no submission data for this resource.'
=> 'There is no submission data for this resource.',

   'There is no data to plot.'
=> 'There is no data to plot.',

   'Analysis of [_1] is not supported.'
=> 'Analysis of [_1] is not supported.',

   'None of the selected students attempted the problem more than [_1] times.'
=> 'None of the selected students attempted the problem more than [_1] times.',

   'None of the selected students attempted the problem.'
=> 'None of the selected students attempted the problem.',

   'The analysis you have selected is not supported at this time.'
=> 'The analysis you have selected is not supported at this time.',

   'Graph Problem Submission Times'
=> 'Graph Problem Submission Times',

   'Return to Directory'
=> '返回目录',

   'Return to directory'
=> '返回目录',

   'My Roles'
=> '我的角色',

   'My Space'
=> '我的空间',

   'Edit blogs, RSS feeds, and podcasts'
=> '博客, RSS-反馈 和 播客',

   'Content Library'
=> '内容',

   'Search the contents of this course or accessible portfolio files'
=> '搜索这门课程的内容，或可组合文件',

   'Grading and Statistics'
=> '审查和统计',

   'Other'
=> '其他',

   'group'
=> '组',

   'Size'
=> '大小',

   'Current Access Status'
=> '目前获得状态',

   'Delete Checked Files'
=> '删除选中的文件',

   'Using the portfolio file list'
=> '使用组合的文件列表',

   'Help on the portfolio'
=> '组帮助',

   'Private'
=> '私人的',

   'Change How Menus are Displayed'
=> '改变菜单显示',

   'Use icons and text'
=> '使用图标和文本',

   'Use buttons and text'
=> '使用按钮和文本',

   'Use icons only'
=> '只有图标',

   'Previous Tries'
=> '以前的尝试',

   'Change Main Menu'
=> '改变主菜单',

   'New screenname (shown if you post anonymously)'
=> '新昵称（显示在匿名讨论中）',

   'New nickname (shown if you post non-anonymously)'
=> '新昵称（显示在正常讨论中）',

   'Choose the time window to use to display roles for which access to the course expired.'
=> 'Choose the time window to use to display roles for which access to the course expired.',

   'Choose the time window to use to display roles for which access to the course became available.'
=> 'Choose the time window to use to display roles for which access to the course became available.',

   'Choose the time window to use to display resources in the course with version changes.'
=> '选择的时间窗口，显示课程资源与版本变化。',

   'User Management'
=> '用户管理',

   'Manage student enrollment'
=> '招生管理',

   'Modify an existing group'
=> '修改现有的组',

   'Delete an existing group'
=> '删除现有的组',

   'Re-enable a deleted group'
=> '还原已删除的组',

   'Enter an existing group'
=> '加入现有的组',

   'Course Management'
=> '课程管理',

   'Reset Student Access Times'
=> '重置学生的访问时间',

   'Submission #'
=> '回答次数',

   'Try'
=> '尝试',

   'Try [_1]'
=> '尝试 [_1]。',

   'Submitted Answer'
=> '提交答案',

   'Close Window'
=> '关闭窗口',

   'Close window'
=> '关闭窗口',

   'Portfolio Search'
=> '组合搜索',

   'Enter words and quoted phrases'
=> '输入字词和引用短语',

   'Portfolio and Course Search'
=> '组合及课程搜寻',

   'Message Status'
=> '邮件状态',

   'Any'
=> '任意的',

   'Unread'
=> '未阅读',

   'Read'
=> '已阅读',

   'Replied to'
=> '回复',

   'Forwarded'
=> '转发',

   'Rename Folder'
=> '重命名文件夹',

   'Delete Folder'
=> '删除文件夹',

   'Recent Roles'
=> '最近的角色',

   'Close navigation window'
=> '关闭导航窗口',

   'Post Anonymous'
=> '匿名发送',

   'Post'
=> '发送',

   'Back to preferences menu'
=> '后退',

   'Forward messages to other account(s) in LON-CAPA'
=> 'Forward messages to other account(s) in LON-CAPA',

   'Forward to account(s)'
=> 'Forward to account(s)', # '转发地址',

   'e.g. <tt>userA:domain1,userB:domain2,...</tt>'
=> '例如 <tt>用户A:领域1,用户B:领域2,...</tt>',

   'Notification E-mail Address(es)'
=> 'Notification E-mail Address(es)',

   'E-mail address(es) which should be notified about new LON-CAPA messages'
=> '关于 LON-CAPA 新消息被通知的 E-Mail 地址',

   'e.g. <tt>joe@doe.com</tt>'
=> '例如 <tt>xiaoming@sohu.com</tt>',

   'Notification address'
=> '通知地址',

   'Types of message for which notification is sent'
=> '发出应该被通知的信息',

   'Excerpt retains HTML tags in message'
=> '在邮件中保持 HTML',

   'All'
=> '所有的',

   'Critical only'
=> '只重要的',

   'Non-critical only'
=> '非重要的',

   'Add new address'
=> '添加新的地址',

   'What are forwarding and notification addresses?'
=> '什么是转发和通知地址?',

   'What are critical messages?'
=> '什么是重要的信息?',

   'Change Roles Page Pref'
=> '用户角色快速访问列表',

   'Number of Roles in Hotlist:'
=> '一些角色的快速访问列表:',

   'Current Password'
=> '当前密码',

   'New Password'
=> '新密码',

   'Confirm Password'
=> '新密码确认',

   'Passwords must be a minimum of 7 characters long. Please try again.'
=> '密码必须至少有7个字符长。请再试一次。',

   'The new passwords you entered do not match. Please try again.'
=> '新的密码输入不匹配。请再试一次。',

   'Please make sure your old password was entered correctly.'
=> '请确认您的旧密码输入正确。',

   'Send me a message'
=> '请给我发送邮件',

   'Show Public View'
=> '查看公众视野',

   'Delete Photo'
=> '删除照片',

   'Help with filling in text boxes'
=> '文本框输入帮助',

   'Examples'
=> '例子',

   'Summary Preview'
=> '摘要预览',

   'Send copy to permanent email address (if known)'
=> '发送副本到其它的电子邮件地址 (如果已知)',

   'Include in course RSS newsfeed'
=> '包括课程的 RSS-Feeds',

   'Allow replies:'
=> '允许答复:',

   'Reply to:'
=> '回复:',

   'Domain Management'
=> '域管理',

   'Course ID of Key Authority:'
=> 'Course ID of Key Authority:',

   'Set domain configuration'
=> '域配置',

   'Domain Configuration'
=> '域配置',

   'View/Modify Domain Settings'
=> '查看/修改域配置',

   'Menu'
=> '菜单',

   'Domain Settings'
=> '域配置',

   'Course Environment'
=> '课程环境',

   'Edit Course Environment'
=> '编辑课程环境',

   'Users allowed to clone course'
=> 'Users allowed to clone course',

   'Users with active Course Coordinator role in this course are permitted to clone and need not be included.'
=> 'Users with active Course Coordinator role in this course are permitted to clone and need not be included.',

   'Use [_1] to allow course to be cloned by anyone in the specified domain.'
=> 'Use [_1] to allow course to be cloned by anyone in the specified domain.',

   'Use [_1] to allow unrestricted cloning in all domains.'
=> 'Use [_1] to allow unrestricted cloning in all domains.',

   'URL of Syllabus (not using internal handler)'
=> '教学大纲的网址 (URL)',

   'Custom Text for Resource Content Question Option in Feedback'
=> 'Custom Text for Resource Content Question Option in Feedback',

   'Custom Text for Course Content Option in Feedback'
=> 'Custom Text for Course Content Option in Feedback',

   'Custom Text for Course Policy Option in Feedback'
=> 'Custom Text for Course Policy Option in Feedback',

   'Allow students to view classlist.'
=> 'Allow students to view classlist.',

   'Allow users with specified roles to edit/delete their own discussion posts'
=> 'Allow users with specified roles to edit/delete their own discussion posts',

   'Suppress number of tries in printing'
=> 'Suppress number of tries in printing',

   'Default paper type'
=> 'Default paper type',

   'Default beginning date for student access.'
=> '学生访问的默认开始日期',

   'Default ending date for student access.'
=> '学生访问的默认结束日期',

   'Disable checking of Significant Figures'
=> 'Disable checking of Significant Figures',

   'Disable automatically printing point values onto exams.'
=> 'Disable automatically printing point values onto exams.',

   'Send message to student when clicking Done on Tasks'
=> 'Send message to student when clicking Done on Tasks', # ???

   'Restrict Metadata'
=> '限制数据',

   'Show to student'
=> 'Show to student',

   'Provide text area for students to type metadata'
=> 'Provide text area for students to type metadata',

   'Provide choices for students to select from'
=> 'Provide choices for students to select from',

   'Student may select multiple choices from list'
=> 'Student may select multiple choices from list',

   'Student may select only one choice from list'
=> 'Student may select only one choice from list',

   'Add a Metadata Field'
=> 'Add a Metadata Field',

   'Order Metadata Fields'
=> 'Order Metadata Fields',

   'Continue Import'
=> 'Continue Import',

   'Continue Search'
=> 'Continue Search',

   'Finish Import'
=> 'Finish Import',

   'Include'
=> 'Include',

   'LON-CAPA Catalog Search'
=> 'LON-CAPA 目录搜索',

   '[_1] include external resources'
=> '[_1] include external resources',

   'Change Course Initialization Preference'
=> '课程初始化设置',

   'Change Course Init. Pref.'
=> '课程初始化设置',

   'Reset Access Times'
=> 'Reset Access Times',

   'Select Scope'
=> 'Select Scope',

   'Reset times on one or more folders/maps for a single student.'
=> 'Reset times on one or more folders/maps for a single student.',

   'Reset times on a single folder/map for a section or whole clase.'
=> 'Reset times on a single folder/map for a section or whole clase.',

   'Choose a student:'
=> '选择一个学生：',

   'Select Currently Enrolled Students and Active Course Personnel'
=> 'Select Currently Enrolled Students and Active Course Personnel',

   'This is a list of first access times and what was accessed, please select those you want deleted.'
=> 'This is a list of first access times and what was accessed, please select those you want deleted.',

   'Select:'
=> '选择:',

   'All Course Personnel'
=> '所有课程人员',

   'No Section'
=> 'No Section',

   'Unselect'
=> '取消',

   'Select a folder/map'
=> '选择目录/内容列表',

   'Will remove access times for'
=> 'Will remove access times for',

   'from users'
=> 'from users',

   'No Access times found for student'
=> 'No Access times found for student',

   'Finish'
=> 'Finish',

   'Name of New Folder'
=> '新建文件夹的名称',

   'Name of New Page'
=> '新组合页面的名称',

   'New Page'
=> '新组合页面',

   'WARNING: Removing a resource makes associated grades and scores inaccessible!'
=> 'WARNING: Removing a resource makes associated grades and scores inaccessible!',

   'Clipboard'
=> 'Clipboard',

   'Remove[_99]'
=> 'Remove[_99]',

   '?[_99]'
=> '?[_99]',

   'WARNING: Cutting a resource makes associated grades and scores inaccessible!'
=> 'WARNING: Cutting a resource makes associated grades and scores inaccessible!',

   'Grades remain inaccessible if resource is pasted into another folder.'
=> 'Grades remain inaccessible if resource is pasted into another folder.',

   'Cut[_98]'
=> 'Cut[_98]',

   '?[_98]'
=> '?[_98]',

   'Paste'
=> 'Paste',

   'This screen shows how many problems (or problem parts) you have completed, and how many you have not yet done. You can also look at [_1]a detailed score sheet[_2].'
=> 'This screen shows how many problems (or problem parts) you have completed, and how many you have not yet done. You can also look at [_1]a detailed score sheet[_2].',

   'This may take a few moments to display.'
=> '计算需要几分钟的时间。',

   'Detailed Citation Preview'
=> '详细引文预览',

   'related words'
=> '相关词',

   'Any domain'
=> '任何域',

   'Reset'
=> '重置',

   'MIME Type Category'
=> 'MIME 类型分类',

   'Domains'
=> '域',

   'Custom Metadata fields'
=> '自定义元数据字段',

   'Field Name'
=> '域名',

   'Field Value(s)'
=> '域值',

   'Another custom field/value pair?'
=> '其他自定义字段/值配对？',

   'Creation and Modification dates'
=> '建立与修改日期',

   'Created between'
=> '创建时间',

   'Last modified between'
=> '上次修改时间',

   'Standard Portfolio Metadata'
=> '标准的元数据组合',

   'Advanced Portfolio Search'
=> '高级组合搜索',

   'Standard Catalog Metadata'
=> '标准目录元数据',

   'Problem Statistics'
=> '问题统计',

   'Statistics calculated for number of students'
=> '统计计算出以下的学生人数',

   'Portfolio and Catalog Search'
=> '搜索文件夹和目录',

   'Search the database of accessible portfolio files'
=> 'Search the database of accessible portfolio files',

   'Authoring Space:'
=> 'Authoring Space:',

   'Problem Status:'
=> '问题状态:',

   'Problem Type:'
=> '问题类型:',

   'Feedback Mode:'
=> '反馈模式:',

   'Answer for Part: [_1]'
=> 'Answer for Part: [_1]',

   'Script Vars'
=> 'Script Vars',

   'Regular file'
=> 'Regular file',

   'Testbank file'
=> 'Testbank file',

   'IMS package'
=> 'IMS-软件包',

   'There are unsaved changes'
=> 'There are unsaved changes',

   'Found no analyzable responses in this problem. Currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable responses in this problem. Currently only Numerical, Formula and String response styles are supported.',

   'Active Link'
=> '活动链接',

   'Font'
=> '字体',

   'Un-Visited Link'
=> '未访问过的链接',

   'Page Background'
=> '网页背景',

   'Header Border'
=> '标题边框',

   'Header Background'
=> '标题背景',

   'Visited Link'
=> '访问过的链接',

   'Change Custom Colors'
=> '更改自定义颜色',

   'Reset All'
=> '所有颜色重置为默认颜色',

   'Save and Edit'
=> '保存并继续编辑',

   'Save and View'
=> '保存和查看',

   'Check Spelling'
=> '拼写检查',

   'Selecting a Course'
=> '选择课程',

   'Course Activity:'
=> 'Course Activity:',

   'Course Domain:'
=> 'Course Domain:',

   'Course Institutional Code:'
=> 'Course Institutional Code:',

   "Course Owner's Username:"
=> "Course Owner's Username:",

   "Course Owner's Domain:"
=> "Course Owner's Domain:",

   'LON-CAPA course ID:'
=> 'LON-CAPA 课程 ID：',

   'Course Description'
=> '课程简介',

   'Resource Space Home'
=> '资源空间主页',

   'Default start and end dates for student access'
=> 'Default start and end dates for student access',

   'Notification to domain coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to domain coordinator via LON-CAPA message when enrollment changes occur during the automated update?',

   'Course Group Settings'
=> '课程组设置',

   'Set a quota for the total disk space available for storage of course group portfolio files.'
=> 'Set a quota for the total disk space available for storage of course group portfolio files.',

   'Creation Options'
=> '创建选项',

   ' Creation Settings'
=> ' 创建设置',

   'Creation Outcome'
=> '创作成果',

   'New LON-CAPA course ID:'
=> '新的 LON-CAPA 课程 ID:',

   'Created on'
=> '创建于',

   'Cloning course from'
=> 'Cloning course from',

   'Setting environment'
=> 'Setting environment',

   'Opening all assignments'
=> 'Opening all assignments',

   'Setting first resource'
=> 'Setting first resource',

   'Assigning role of [_1] Coordinator to [_2] at [_3]: '
=> 'Assigning role of [_1] Coordinator to [_2] at [_3]: ',

   'Roles will be active at next login'
=> 'Roles will be active at next login',

   'Active at next login.'
=> 'Active at next login.',

   'Expired after logout.'
=> 'Expired after logout.',

   'No new course created.'
=> 'No new course created.',

   'A new course could not be cloned from the specified original - [_1] - because it is a non-existent course.'
=> 'A new course could not be cloned from the specified original - [_1] - because it is a non-existent course.',

   'The new course could not be cloned from the existing course because the new course owner ([_1]) does not have cloning rights in the existing course ([_2]).'
=> 'The new course could not be cloned from the existing course because the new course owner ([_1]) does not have cloning rights in the existing course ([_2]).',

   'Create Another [_1]'
=> 'Create Another [_1]',

   'from domain'
=> 'from domain',

   'Submit Evaluation'
=> '提交评价',

   'Standard Problem'
=> '标准问题',

   'Practice'
=> 'Practice',

   'Exam'
=> 'Exam',

   'Survey'
=> '调查',

   'Library'
=> '图书馆',

   'Value:'
=> 'Value:',

   'String Value'
=> 'String Value',

   'practice'
=> 'practice',

   'Loading Domain Coordinator Menu'
=> 'Loading Domain Coordinator Menu',

   "Disk space allocated to user's portfolio files"
=> "Disk space allocated to user's portfolio files",

   'Current quota'
=> '目前的配额',

   'For this user, the default quota is [_1] MB.'
=> '此用户的默认配额是 [_1] MB。',

   'Change quota'
=> '更改配额',

   'Custom quota'
=> '自定义配额',

   'Existing sections'
=> '现有的章节',

   'Define new section'
=> '创建新的章节',

   'Create/Modify Another User'
=> '创建/修改另一个用户',

   'Set Privileges for New User'
=> '设置新用户的权限',

   'Generating user'
=> '生成用户',

   'Generating user: [_1]'
=> '生成用户： [_1]',

   'Home server'
=> 'Home server',

   'Home server: [_1]'
=> 'Home server: [_1]',

   'Modifying Roles'
=> '修改角色',

   'No roles to modify'
=> '没有角色修改',

   'starting'
=> '开始',

   'Add to classlist:'
=> '添加到学生名册：',

   'Change Current Login Data'
=> 'Change Current Login Data',

   'Enter New Login Data'
=> 'Enter New Login Data',

   'will override current values'
=> 'will override current values',

   'Section Numbers and corresponding LON-CAPA section IDs'
=> 'Section Numbers and corresponding LON-CAPA section IDs',

   'Overall Assessment Statistical Data'
=> '总体评价统计数据',

   'No new dynamic data found.'
=> '没有发现新的动态数据。',

   'Current value is'
=> 'Current value is',

   'Interval set to version changes [_1]'
=> 'Interval set to version changes [_1]',

   'Creating a new problem resource.'
=> 'Creating a new problem resource.',

   'Creating a new library resource.'
=> 'Creating a new library resource.',

   'Creating a new survey resource.'
=> 'Creating a new survey resource.',

   'Creating a new task resource.'
=> 'Creating a new task resource.',

   'The requested file [_1] currently does not exist.'
=> 'The requested file [_1] currently does not exist.',

   'To create a new problem, select a template from the list below. Then click on the "Create problem" button.'
=> 'To create a new problem, select a template from the list below. Then click on the "Create problem" button.',

   'To create a new library, select a template from the list below. Then click on the "Create library" button.'
=> 'To create a new library, select a template from the list below. Then click on the "Create library" button.',

   'To create a new survey, select a template from the list below. Then click on the "Create survey" button.'
=> 'To create a new survey, select a template from the list below. Then click on the "Create survey" button.',

   'To create a new task, select a template from the list below. Then click on the "Create task" button.'
=> 'To create a new task, select a template from the list below. Then click on the "Create task" button.',

   'Accessibility Options'
=> 'Accessibility Options',

   'About LON-CAPA'
=> '关于 LON-CAPA',

   'Course/Community Catalog'
=> '课程目录',

   'If you were expecting to see an active role listed for a particular course in the [_1] domain, it may be missing for one of the following reasons:'
=> 'If you were expecting to see an active role listed for a particular course in the [_1] domain, it may be missing for one of the following reasons:',

   'The course has yet to be created.'
=> 'The course has yet to be created.',

   'Automatic enrollment of registered students has not been enabled for the course.'
=> 'Automatic enrollment of registered students has not been enabled for the course.',

   'You are in a section of course for which automatic enrollment in the corresponding LON-CAPA course is not active.'
=> 'You are in a section of course for which automatic enrollment in the corresponding LON-CAPA course is not active.',

   'You registered for the course recently and there is a time lag between the time you register, and the time this information becomes available for the update of LON-CAPA course rosters.'
=> 'You registered for the course recently and there is a time lag between the time you register, and the time this information becomes available for the update of LON-CAPA course rosters.',

   'If you were expecting to see an active role listed for a particular course, that course may not have been created yet.'
=> 'If you were expecting to see an active role listed for a particular course, that course may not have been created yet.',

   'The [_1]Course/Community Catalog[_2] provides information about all [_3] classes for which LON-CAPA courses have been created, as well as any communities in the domain.' # [_3]: domain
=> 'The [_1]Course/Community Catalog[_2] provides information about all [_3] classes for which LON-CAPA courses have been created, as well as any communities in the domain.',

   'You can search the Course/Community Catalog for courses and communities which permit self-enrollment, if you would like to enroll in one.'
=> 'You can search the Course/Community Catalog for courses and communities which permit self-enrollment, if you would like to enroll in one.',

   'User Authentication'
=> 'User Authentication',

   'Log-in Help'
=> '登录帮助',

   'Forgot password?'
=> '忘记密码？',

   'New User?'
=> '新用户？',

   'Crosslisted'
=> 'Crosslisted',

   'Owner'
=> 'Owner',

   'Code'
=> 'Code',

   'Course listing'
=> '课程目录',

   'Display information about official [_1] classes for which LON-CAPA courses have been created:'
=> 'Display information about official [_1] classes for which LON-CAPA courses have been created:',

   'help/support'
=> 'help/support',

   'Ask helpdesk'
=> 'Ask helpdesk',

   'Back to last location'
=> 'Back to last location',

   'Note'
=> '注意',

   'Note:'
=> '注意：',

   'Student questions about course content should be directed to the course instructor'
=> 'Student questions about course content should be directed to the course instructor',

   'Submit Request'
=> 'Submit Request',

   'E-mail address'
=> 'E-Mail 地址',

   'Enter the username you use to log-in to LON-CAPA, and your domain.'
=> 'Enter the username you use to log-in to LON-CAPA, and your domain.',

   'URL of page'
=> '该页的网址',

   'Phone'
=> '电话',

   'Course Details'
=> 'Course Details',

   'Enter institutional course code'
=> 'Enter institutional course code',

   'Enter course title'
=> 'Enter course title',

   'Section Number'
=> 'Section Number',

   'Detailed Description'
=> '详细说明',

   'Clear Form'
=> '重置表',

   'Material presented in clear way'
=> '这些材料中提出一个明确的方式',

   'Material covered with sufficient depth'
=> '这些材料包括有足够的深度',

   'Material is helpful'
=> '这些材料是有用的',

   'Material appears to be correct'
=> '这些材料似乎是正确的',

   'This will only retrieve the resource. If you want to retrieve the metadata, you will need to do that separately.'
=> 'This will only retrieve the resource. If you want to retrieve the metadata, you will need to do that separately.',

   'is in this state due to author settings.'
=> 'is in this state due to author settings.',

   'User Data for'
=> 'User Data for',

   'Email Address'
=> 'E-Mail地址',

   'Enroll Student'
=> '注册学生',

   'If active, the new role will be available when the student next logs in to LON-CAPA.'
=> 'If active, the new role will be available when the student next logs in to LON-CAPA.',

   'Enroll another student'
=> '注册另一名学生',

   'Enroll Another Student'
=> '注册另一名学生',

   'start date'
=> '开始日期',

   'end date'
=> '结束日期',

   'active groups'
=> '活跃的组',

   'active group(s)'
=> '活跃的组',

   "Select a user name to view the user's personal page."
=> "选择一个用户名，以查看此用户的个人网页。",

   'View recent activity by this student'
=> '最后处于活动状态的人',

   'View recent activity'
=> '查看最近活动',

   'Recent activity of [_1]'
=> '最后处于活动状态的 [_1]',


   'Compiling student activity data can take a long time. Your request continues to be processed while results are displayed.'
=> 'Compiling student activity data can take a long time. Your request continues to be processed while results are displayed.',

   'Composing Query'
=> 'Composing Query',

   'Student Activity'
=> 'Student Activity',

   'Waiting up to [_1] seconds for results'
=> 'Waiting up to [_1] seconds for results',

   'Activity data compiled up to [_1]'
=> 'Activity data compiled up to [_1]',

   'While data is processed, periodically reload this page for more recent activity'
=> 'While data is processed, periodically reload this page for more recent activity',

   'Data'
=> 'Data',

   'Resubmit last request to check for newer data'
=> 'Resubmit last request to check for newer data',

   'View Classlist'
=> 'View Classlist',

   'Count'
=> 'Count',

   'Modifying authentication:'
=> 'Modifying authentication:',

   'Modify User Privileges'
=> 'Modify User Privileges',

   'Insert:'
=> 'Insert:',

   'Delete?'
=> 'Delete?',

   'Randomize Foil Order:'
=> 'Randomize Foil Order:',

   'Use template:'
=> 'Use template:',

   'Display Direction'
=> 'Display Direction',

   'vertical'
=> 'vertical',

   'horizontal'
=> 'horizontal',

   'Script'
=> 'Script',

   'Problem Editing'
=> '问题编辑',

   'Hint'
=> '提示',

   'Show hint even if problem Correct:'
=> 'Show hint even if problem Correct:',

   'Single Line Text Entry Area'
=> 'Single Line Text Entry Area',

   'Parameters for a response'
=> 'Parameters for a response',

   'Problem Part'
=> '问题部分',

   'Part ID:'
=> '问题部分编号：',

   'Displayed Part Description:'
=> 'Displayed Part Description:',

   'Readonly:'
=> 'Readonly:',

   'Response: Numerical'
=> 'Response: Numerical',

   'random'
=> 'random',

   'top'
=> 'top',

   'bottom'
=> 'bottom',

   'Add new Option:'
=> 'Add new Option:',

   'Delete an Option:'
=> 'Delete an Option:',

   'Print options:'
=> 'Print options:',

   "Don't show option list"
=> "Don't show option list",

   'Display of options when printed'
=> 'Display of options when printed',

   'Normal list'
=> 'Normal list',

   'Listed in vertical column'
=> 'Listed in vertical column',

   'Multiple Option Response Question'
=> 'Multiple Option Response Question',

   'Select Options'
=> 'Select Options',

   'Image'
=> 'Image',

   'Image Url:'
=> 'Image Url:',

   'width (pixel):'
=> 'width (pixel):',

   'height (pixel):'
=> 'height (pixel):',

   'Alignment:'
=> 'Alignment:',

   'Encrypt URL:'
=> 'Encrypt URL:',

   'no'
=> 'no',

   'Location:'
=> 'Location:',

   'Randomly labeled image'
=> 'Randomly labeled image',

   'Response: Click on Image'
=> 'Response: Click on Image',

   'Collection of Imageresponse foils'
=> 'Collection of Imageresponse foils',

   'Image response foil'
=> 'Image response foil',

   'Enter Coordinates'
=> 'Enter Coordinates',

   'Rectangle'
=> 'Rectangle',

   'Coordinate Pairs'
=> 'Coordinate Pairs',

   'Polygon'
=> 'Polygon',

   'Coordinate list'
=> 'Coordinate list',

   'Create Polygon Data'
=> 'Create Polygon Data',

   'Task Description'
=> '问题描述',

   'Clickable Image'
=> 'Clickable Image',

   'Image Source File'
=> 'Image Source File',

   'Select Position on Image'
=> 'Select Position on Image',

   'Select First Coordinate on Image'
=> 'Select First Coordinate on Image',

   'Select Second Coordinate on Image'
=> 'Select Second Coordinate on Image',

   'Select Finish to save selection'
=> 'Select Finish to save selection',

   'Enter Coordinate or click finish to close Polygon'
=> 'Enter Coordinate or click finish to close Polygon',

   'Click to select a Coordinate or click Finish to save current selection'
=> 'Click to select a Coordinate or click Finish to save current selection',

   'New Name'
=> 'New Name',

   'Make Obsolete'
=> 'Make Obsolete',

   'Set Margins'
=> 'Set Margins',

   'How should each column be formatted?'
=> 'How should each column be formatted?',

   'Width:'
=> '宽：',

   'Height:'
=> '高：',

   'Left Margin:'
=> 'Left Margin:',

   'Username and/or password could not be authenticated.'
=> '用户名和（或）密码无法验证。',

   'Please check the username and password.'
=> '请检查您的用户名和密码。',

   'Try again'
=> '再试一次',

   'Information needed to verify your login information is missing, inaccessible or expired.'
=> '验证您的登录的信息丢失，无法进入或已经过期。',

   'Sending'
=> '发送中',

   'Completed.'
=> '邮件已发送。',

   'Messages being sent.'
=> '邮件被发送。',

   'Assigning'
=> 'Assigning',

   'ending'
=> 'ending',

   'Assistant Co-Author'
=> 'Assistant Co-Author',

   'Metadata for [_1]'
=> 'Metadata for [_1]',

   'There are [_1] matches to your query.'
=> '有 [_1] 匹配您的查询。',

   'There were no results matching your query.'
=> 'There were no results matching your query.',

   'Revise search'
=> '修改搜寻',

   'Internal Error - Bad view selected.'
=> 'Internal Error - Bad view selected.',

   'Unable to save import results.'
=> 'Unable to save import results.',

   'A MySQL error has occurred.'
=> 'A MySQL error has occurred.',

   'Number of accesses'
=> 'Number of accesses',

   'Ascending'
=> '上升的',

   'Descending'
=> '下降的',

   'Students Attempting'
=> 'Students Attempting', # ??? [SB 2007-07-03]

   'Average Number of Tries'
=> 'Average Number of Tries',

   'Mean Degree of Difficulty'
=> 'Mean Degree of Difficulty',

   'Mean Degree of Discrimination'
=> 'Mean Degree of Discrimination',

   'Evaluation: Clear'
=> 'Evaluation: Clear',

   'Evaluation: Technically Correct'
=> 'Evaluation: Technically Correct',

   'Evaluation: Material is Correct'
=> 'Evaluation: Material is Correct',

   'Evaluation: Material is Helpful'
=> 'Evaluation: Material is Helpful',

   'Evaluation: Material has Depth'
=> 'Evaluation: Material has Depth',

   'Prev'
=> '上一个',

   'Reload'
=> '重新加载',

   'Results [_1] to [_2] out of [_3]'
=> '结果 [_1] 至 [_2] 的 [_3]',

   'Unactionable Search Query'
=> '查询被否决',

   'Revise Search Request'
=> '修改搜索请求',

   'LON-CAPA Access Control'
=> 'LON-CAPA 访问控制',

   'Access  : '
=> '访问  ： ',

   'Resource: '
=> '资源： ',

   'Action  : '
=> 'Action  : ',

   'You have modified your course recently, [_1] may fix this access problem.'
=> 'You have modified your course recently, [_1] may fix this access problem.',

   'Published on ...'
=> 'Published on ...',

   'Currently published version'
=> 'Currently published version',

   'Edit Metadata'
=> '编辑元数据',

   'Cleanup XML Document'
=> 'Cleanup XML Document',

   'Select actions to attempt:'
=> '选择所需的行动:',

   'Linefeeds, formfeeds, and carriage returns'
=> 'Linefeeds, formfeeds, and carriage returns',

   'Empty tags'
=> 'Empty tags',

   'Lower casing'
=> 'Lower casing',

   'Symbol font'
=> 'Symbol font', # ??? [SB 2007-07-03]

   'Cleanup'
=> 'Cleanup',

   'Back to Source File'
=> 'Back to Source File',

   'Hypertext Cascading Style Sheet'
=> 'Hypertext Cascading Style Sheet',

   'Online Survey'
=> 'Online Survey',

   'Unable to find [_1]'
=> 'Unable to find [_1]',

   'Post Server Announcements'
=> 'Post Server Announcements',

   'Post announcements to the system login and roles screen'
=> 'Post announcements to the system login and roles screen',

   '(leave blank to delete announcement)'
=> '(leave blank to delete announcement)',

   'Check machines:'
=> 'Check machines:',

   'Current Announcement'
=> 'Current Announcement',

   'Calendar'
=> '日历',

   'Download your Calendar as iCalendar File'
=> '下载您的日历',

   'No calendar available for this date.'
=> '没有日历用于此日期。',

   'Posting [_1]'
=> 'Posting [_1]',

   'This LON-CAPA server is version [_1]'
=> '这里是 LON-CAPA [_1]',

   'Only changes made from servers running LON-CAPA [_1] or later are displayed.'
=> 'Only changes made from servers running LON-CAPA [_1] or later are displayed.',

   'Edit Answer'
=> 'Edit Answer',

   'Date/Time'
=> '日期/时间',

   'Threshold Name'
=> 'Threshold Name',

   'Current value'
=> 'Current value',

   'Change?'
=> '改变？',

   'Make changes'
=> '保存',

   'Change thresholds'
=> 'Change thresholds',

   'Picture Conversion Status'
=> 'Picture Conversion Status',

   'Class Print Status'
=> 'Class Print Status',

   'Removing error messages:'
=> 'Removing error messages:',

   'Invalid target directory, FAIL'
=> 'Invalid target directory, FAIL',

   'Creating old version [_1]'
=> 'Creating old version [_1]',

   'Initial version'
=> 'Initial version',

   'Press "Generate Statistics" when you are ready.'
=> 'Press "Generate Statistics" when you are ready.',

   'It may take some time to update the student data for the first analysis. Future analysis this session will not have this delay.'
=> 'It may take some time to update the student data for the first analysis. Future analysis this session will not have this delay.',

   'A course-wide error occurred.'
=> 'A course-wide error occurred.',

   'none'
=> '没有',

   'Prepare Report'
=> '编写报告',

   'Show problem'
=> '提示显示',

   'Show correct answers'
=> 'Show correct answers',

   'Show all submissions'
=> 'Show all submissions',

   'Show problem grading'
=> 'Show problem grading',

   'Computing correct answers greatly increases the amount of time required to prepare a report.'
=> 'Computing correct answers greatly increases the amount of time required to prepare a report.',

   'Please select problems and use the [_1]Prepare Report[_2] button to continue.'
=> 'Please select problems and use the [_1]Prepare Report[_2] button to continue.',

   'Please select a Survey to analyze'
=> 'Please select a Survey to analyze',

   'There are no survey problems in this course.'
=> 'There are no survey problems in this course.',

   'Generate Survey Report'
=> 'Generate Survey Report',

   'Building text document.'
=> 'Building text document.',

   'Generated on [_1]'
=> 'Generated on [_1]',

   'Your text file'
=> 'Your text file',

   'Done compiling text file. See link below to download.'
=> 'Done compiling text file. See link below to download.',

   'There is no essay or string response data to output for this survey.'
=> 'There is no essay or string response data to output for this survey.',

   'Building spreadsheet.'
=> '生成电子表格。',

   '[_1]:[_2] responses to [_3] may be too long to fit Excel spreadsheet.'
=> '[_1]:[_2] responses to [_3] may be too long to fit Excel spreadsheet.',

   'Done compiling spreadsheet. See link below to download.'
=> 'Done compiling spreadsheet. See link below to download.',

   'Make a sequence selection from the "Sequences and Folders" menu and hit "Create Plot" to begin'
=> 'Make a sequence selection from the "Sequences and Folders" menu and hit "Create Plot" to begin',

   'Create Plot'
=> 'Create Plot',

   'Start Time:'
=> 'Start Time:',

   'End Time:'
=> 'End Time:',

   'Sender'
=> '寄件人',

   'Number'
=> 'Number',

   'Upload Classlist'
=> 'Upload Classlist',

   'Semicolon separated values'
=> '以分号分隔',

   'Show Log'
=> '查看日志',

   'Course Document Change Log'
=> 'Course Document Change Log',

   'Records'
=> 'Records',

   'Before'
=> '以前',

   'After'
=> '以后',

   'Current folder/page'
=> '当前文件夹/页',

   'Containing phrase'
=> '含有短语',

   'None'
=> '没有',

   'Users'
=> '用户',

   'Include parameter types'
=> 'Include parameter types',

   'Parameter Change Log'
=> 'Parameter Change Log',

   'Announce'
=> 'Announce',

   'Not active anymore'
=> 'Not active anymore',

   'Add to Course Announcements'
=> 'Add to Course Announcements',

   'Username : Domain'
=> '用户名：域',

   'Active'
=> '活跃的',

   'Expired'
=> 'Expired',

   'Future'
=> 'Future',

   'Sort by realm first, then student (group/section)'
=> 'Sort by realm first, then student (group/section)',

   'Sort by student (group/section) first, then realm'
=> 'Sort by student (group/section) first, then realm',

   'Shift all dates based on this date'
=> 'Shift all dates based on this date',

   'Overview Mode'
=> '概况模式',

   'Overview'
=> '概况',

   'Set Parameters'
=> '参数设置',

   'Parts'
=> '部分',

   'Section(s)'
=> '章节(en)',

   'Group(s)'
=> '组',

   'Parameter Selection'
=> '参数选择',

   'Add Selection for...'
=> 'Add Selection for...',

   'Select Common Only'
=> 'Select Common Only',

   'Problem Dates'
=> 'Problem Dates',

   'Content Dates'
=> 'Content Dates',

   'Discussion Settings'
=> 'Discussion Settings',

   'Visibilities'
=> '可见的',

   'Part Parameters'
=> '部分参数',

   'For User [_1] or Student/Employee ID [_2] at Domain [_3]'
=> '对于用户 [_1] 或学生/员工编号 [_2] 在域 [_3]',

   'Group Files'
=> '编组文件',

   "Enter user:domain for User's 'About Me' Page"
=> "Enter user:domain for User's 'About Me' Page",

   'No map selected.'
=> 'No map selected.',

   'Most Recent:'
=> '最新：',

   'In Course:'
=> '课程：',

   'Use:'
=> '使用：',

   'Search LON-CAPA help'
=> '搜索 LON-CAPA 帮助',

   'Before course enrollment start!'
=> 'Before course enrollment start!',

   'After course enrollment end!'
=> 'After course enrollment end!',

   'in the past'
=> '在过去',

   'in the future'
=> '在将来',

   'Choose'
=> 'Choose',

   'Title:'
=> '标题：',

   'URL:'
=> 'URL:',

   'Course, Portfolio and Catalog Search'
=> '目录搜索，组合搜索和课程搜索',

   'ERROR:'
=> '错误：',

   '(click for example)'
=> '(click for example)',

   'click for example'
=> 'click for example',

   'Re-Enable'
=> '重新启用',

   'Script Functions'
=> 'Script Functions',

   'Image Options'
=> '图像选项',

   'left'
=> '左边',

   'right'
=> '右边',

   'TeXwidth (mm):'
=> 'TeX-宽 (mm)：',

   'TeXheight (mm):'
=> 'TeX-高 (mm)：',

   'TeXwrap:'
=> 'TeXwrap:',

   'Sorry!'
=> '对不起...',

   'Resource not available.'
=> 'Resource not available.',

   'File Type'
=> 'File Type',

   'Output of decompress:'
=> 'Output of decompress:',

   'Decompress complete.'
=> 'Decompress complete.',

   'Archive:'
=> '存档：',

   'inflating:'
=> 'inflating:',

   'Incorrect:'
=> '错误:',

   'Correct:'
=> '正确:',

   'Correct'
=> '正确',

   'Pick course first'
=> '只能选择课程',

   'User Information Changed'
=> '用户信息变更',

   'Changed To'
=> '改为',

   'disk space allocated to portfolio files'
=> 'disk space allocated to portfolio files',

   'You have new messages'
=> 'You have new messages',

   'Destination folder'
=> '目的文件夹',

   'Mark Read'
=> '标记为已读',

   'Move to Folder ->'
=> '移至文件夹 ->',

   'Register Response Devices (&quot;Clickers&quot;)'
=> '注册应答设备 (&quot;Clickers&quot;)',

   'Enter response device ("clicker") numbers'
=> '输入应答设备（&quot;Clickers&quot;）的号码',

   'Locating your clicker ID'
=> '定位您的应答设备编号',

   'Register Clicker'
=> '注册应答设备',

   'Register'
=> '注册',

   'New Link'
=> '新的书签',

   'Refresh'
=> '更新',

   'Custom metadata [_1]'
=> '自定义元数据 [_1]',

   'Question/Comment/Feedback about course content'
=> '课程内容的问题/评论/反馈',

   'User modify/custom role edit'
=> '用户帐户和权限管理',

   'User Search'
=> '用户搜索',

   'to add/modify roles'
=> ', 添加/修改角色',

   'is'
=> '是',

   'contains'
=> '包括',

   'in this domain'
=> '在该域',

   'in institutional directory'
=> '在研究所目录',

   'Domain/institution to search'
=> 'Domain/institution to search',

   'Directory search has not been configured for domain: [_1]'
=> '目录搜索，在还没有被配置的域：[_1]',

   'permanent e-mail'
=> '永久电子邮件',

   'Set user role'
=> '设置用户角色',

   'No exact match found for this username ([_1]) in this domain.'
=> '对该用户名（[_1]）在这个领域中没有找到完全匹配的。',

   'No match found for this username ([_1]) in this domain.'
=> '对该用户名（[_1]）在这个领域中没有找到相应的。',

   'Make new user "[_1]"'
=> '新用户 "[_1]"',

   'Course Editor'
=> '编辑课程',

   'Community Editor'
=> 'Community Editor',

   'Choose which items you wish to export from your Course.'
=> '选择您要从课程中导出的项目。',

   'Content items'
=> '内容项目',

   'Discussion posts'
=> '讨论文章',

   'Download the zip file from'
=> '下载zip档案从：',

   'IMS course archive'
=> 'IMS课程存档',

   'last name, first name'
=> '姓氏，名字',

   'Select a Template'
=> 'Select a Template',

   'Edit custom role'
=> 'Edit custom role',

   'Privilege'
=> 'Privilege',

   'Showing users with a name starting with [_1]'
=> '显示用户，起始是 [_1]',

   'Permanent e-mail address'
=> '永久的 E-Mail 地址',

   'Permanent e-mail'
=> '永久的 E-Mail 地址',

   'User [_1] in domain [_2]'
=> '用户 [_1] 在域 [_2]',

   'Result'
=> 'Result',

   'Directory search in domain [_1] is not available for the requested search type: "[_2]"'
=> 'Directory search in domain [_1] is not available for the requested search type: "[_2]"',

   "No match found for this username ([_1]) in your institution's directory."
=> "No match found for this username ([_1]) in your institution's directory.",

   'Setting'
=> 'Setting',

   'Directory search available?'
=> 'Directory search available?',

   'Back to actions menu'
=> 'Back to actions menu',

   'Edit action'
=> 'Edit action',

   'Effect'
=> 'Effect',

   'Course / User'
=> 'Course / User',

   'deny'
=> 'deny',

   'allow'
=> 'allow',

   'Delete this rule'
=> 'Delete this rule',

   'Insert rule above'
=> 'Insert rule above',

   'Insert rule below'
=> 'Insert rule below',

   'Move rule down'
=> 'Move rule down',

   'Move rule up'
=> 'Move rule up',

   'Warning: It can take up to 1 hour for rights changes to fully propagate.'
=> 'Warning: It can take up to 1 hour for rights changes to fully propagate.',

   'email address'
=> 'email address',

   'Updated'
=> '已更新',

   'The error occurred on host [_1]'
=> 'The error occurred on host [_1]',

   'This error occurred on machine [_1]'
=> 'This error occurred on machine [_1]',

   'Clear all Messages in Subdirectory'
=> 'Clear all Messages in Subdirectory',

   'Task information'
=> 'Task information',

   'Automated adds/drops'
=> 'Automated adds/drops',

   'Change enrollment dates'
=> 'Change enrollment dates',

   'Change access dates'
=> 'Change access dates',

   'Notification of changes'
=> 'Notification of changes',

   'Change crosslistings'
=> 'Change crosslistings',

   'Section settings'
=> 'Section settings',

   'Student photo settings'
=> 'Student photo settings',

   'Update roster now'
=> 'Update roster now',

   'Update student photos'
=> 'Update student photos',

   'View students and change type'
=> 'View students and change type',

   'Changes to nightly automated enrollments'
=> 'Changes to nightly automated enrollments',

   'Currently: Nightly adds: [_1], Nightly drops: [_2]'
=> 'Currently: Nightly adds: [_1], Nightly drops: [_2]',

   'OFF'
=> 'OFF',

   'ON'
=> 'ON',

   'Additions based on classlist changes:'
=> 'Additions based on classlist changes:',

   'Removals based on classlist changes:'
=> 'Removals based on classlist changes:',

   'Enable'
=> 'Enable',

   'Disable'
=> 'Disable',

   'Note: Any students added manually by course coordinators using the Enrollment Manager will be unaffected by the nightly removal process if you choose to enable it.'
=> 'Note: Any students added manually by course coordinators using the Enrollment Manager will be unaffected by the nightly removal process if you choose to enable it.',

   'Changes to first and/or last automated enrollment dates'
=> 'Changes to first and/or last automated enrollment dates',

   'Currently: First enrollment: [_1], Last enrollment: [_2]'
=> 'Currently: First enrollment: [_1], Last enrollment: [_2]',

   'Set date of first automated enrollment for registered students'
=> 'Set date of first automated enrollment for registered students',

   'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, once the first enrollment date has been reached. Prior to this date, the class roster will only contain students you have added directly using the standard LON-CAPA enrollment tools'
=> 'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, once the first enrollment date has been reached. Prior to this date, the class roster will only contain students you have added directly using the standard LON-CAPA enrollment tools',

   'Set date of last automated enrollment for registered students'
=> 'Set date of last automated enrollment for registered students',

   'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, until the last enrollment date has been reached.'
=> 'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, until the last enrollment date has been reached.',

   'Changes to default start and/or end dates for student access'
=> 'Changes to default start and/or end dates for student access',

   'Currently: default first access:'
=> 'Currently: default first access:',

   ', default last access:'
=> ', default last access:',

   'Set date of first access for registered students added via automated enrollment'
=> 'Set date of first access for registered students added via automated enrollment',

   'Set date of last access for registered students added via automated enrollment'
=> 'Set date of last access for registered students added via automated enrollment',

   'Changes to section settings'
=> 'Changes to section settings',

   'Currently no sections of'
=> 'Currently no sections of',

   'are contributing enrollment to the LON-CAPA class roster.'
=> 'are contributing enrollment to the LON-CAPA class roster.',

   'Add enrollment from additional sections.'
=> 'Add enrollment from additional sections.',

   'Number of new sections to add:'
=> 'Number of new sections to add:',

   'Students enrolling in the sections listed below will be automatically added to the class roster for LON-CAPA course'
=> 'Students enrolling in the sections listed below will be automatically added to the class roster for LON-CAPA course',

   'if you have chosen to enable a nightly automated enrollment update.'
=> 'if you have chosen to enable a nightly automated enrollment update.',

   'Nightly additions based on classlist changes now'
=> 'Nightly additions based on classlist changes now',

   'Nightly additions based on classlist changes still'
=> 'Nightly additions based on classlist changes still',

   'Nightly removals based on classlist changes now'
=> 'Nightly removals based on classlist changes now',

   'Nightly removals based on classlist changes still'
=> 'Nightly removals based on classlist changes still',

   'enabled'
=> 'enabled',

   'disabled'
=> 'disabled',

   'The first date for automated enrollment has been changed'
=> 'The first date for automated enrollment has been changed',

   'The last date for automated enrollment has been changed'
=> 'The last date for automated enrollment has been changed',

   'The first date for automated enrollment has been left unchanged as'
=> 'The first date for automated enrollment has been left unchanged as',

   'The last date for automated enrollment has been left unchanged as'
=> 'The last date for automated enrollment has been left unchanged as',

   'Currently: Notification:'
=> 'Currently: Notification:',

   'Notification of LON-CAPA course roster changes resulting from nightly automated enrollment process?'
=> 'Notification of LON-CAPA course roster changes resulting from nightly automated enrollment process?',

   'The table below contains a list of Kurs-Koordinators in this course.'
=> 'The table below contains a list of Kurs-Koordinators in this course.',

   'username:domain'
=> '用户名：域',

   'Course Access'
=> 'Course Access',

   'Current notification status'
=> 'Current notification status',

   'Notification active'
=> 'Notification active',

   'Notification inactive'
=> 'Notification inactive',

   'Notification?'
=> 'Notification?',

   'Notification of enrollment changes now'
=> 'Notification of enrollment changes now',

   'Notification of enrollment changes still'
=> 'Notification of enrollment changes still',

   'The following will receive notification if there are any changes in enrollment in LON-CAPA course:'
=> 'The following will receive notification if there are any changes in enrollment in LON-CAPA course:',

   'as a result of the nightly enrollment check:'
=> 'as a result of the nightly enrollment check:',

   'View/Modify Course Settings'
=> 'View/Modify Course Settings',

   'Course search'
=> 'Course search',

   'View/Modify Courses'
=> 'View/Modify Courses',

   'Course details'
=> 'Course details',

   'Detailed course information:'
=> 'Detailed course information:',

   'Default Access Dates for Students'
=> 'Default Access Dates for Students',

   'Student Counts'
=> 'Student Counts',

   'Auto-enrollment of[_1]registered students'
=> 'Auto-enrollment of[_1]registered students',

   'Details'
=> 'Details',

   'Not enabled'
=> 'Not enabled',

   'section:'
=> 'section:',

   'Previous access'
=> 'Previous access',

   'Current access'
=> 'Current access',

   'Future access'
=> 'Future access',

   'Back to course listing'
=> '返回课程目录',

   'Immediate course roster update'
=> 'Immediate course roster update',

   'There were no new students to add to the course.'
=> 'There were no new students to add to the course.',

   'Back to options page'
=> 'Back to options page',

   'View/Modify settings for: '
=> 'View/Modify settings for: ',

   'Modify quota for group portfolio files'
=> 'Modify quota for group portfolio files',

   'Display current settings for automated enrollment'
=> 'Display current settings for automated enrollment',

   'Modify institutional code, course owner and/or default authentication'
=> 'Modify institutional code, course owner and/or default authentication',

   'Modify course catalog settings for course'
=> 'Modify course catalog settings for course',

   'Catalog settings'
=> 'Catalog settings',

   'Catalog Settings for Course'
=> 'Catalog Settings for Course',

   'Visibility in Course/Community Catalog'
=> 'Visibility in Course/Community Catalog',

   "Unless excluded, a course/community is listed in this domain's publicly accessible Course/Community Catalog, if at least one of the following applies:"
=> "Unless excluded, a course/community is listed in this domain's publicly accessible Course/Community Catalog, if at least one of the following applies:",

   'Auto-cataloging is enabled and the course is assigned an institutional code'
=> 'Auto-cataloging is enabled and the course is assigned an institutional code',

   'The course has been categorized into at least one of the course categories defined for the domain.'
=> 'The course has been categorized into at least one of the course categories defined for the domain.',

   'Exclude from course catalog'
=> 'Exclude from course catalog',

   'Categorize Course'
=> 'Categorize Course',

   'No categories defined for this domain'
=> 'No categories defined for this domain',

   'Assign one or more categories to this course.'
=> 'Assign one or more categories to this course.',

   'If auto-cataloging based on institutional code is enabled in the domain, a course will continue to be listed in the catalog of official courses, in addition to receiving a listing under any manually assigned categor(ies).'
=> 'If auto-cataloging based on institutional code is enabled in the domain, a course will continue to be listed in the catalog of official courses, in addition to receiving a listing under any manually assigned categor(ies).',

   'Category settings'
=> 'Category settings',

   'Show/Hide a course in the catalog'
=> 'Show/Hide a course in the catalog',

   'Assign a category to a course'
=> 'Assign a category to a course',

   'Set in "Modify Course" (Domain)'
=> 'Set in "Modify Course" (Domain)',

   'Set in "Modify Parameters" (Course)'
=> 'Set in "Modify Parameters" (Course)',

   'Categories'
=> 'Categories',

   'Add category'
=> 'Add category',

   'Add category:'
=> 'Add category:',

   'Add subcategory:'
=> 'Add subcategory:',

   'New:'
=> 'New:',

   'Choose a course'
=> 'Choose a course',

   'Pick action'
=> 'Pick action',

   'Display settings'
=> 'Display settings',

   'Course settings that control automated enrollment in this LON-CAPA course are currently:'
=> 'Course settings that control automated enrollment in this LON-CAPA course are currently:',

   'Course setting'
=> 'Course setting',

   'Modifiable by DC only'
=> 'Modifiable by DC only',

   'Default authentication parameter'
=> 'Default authentication parameter',

   'Default authentication method'
=> 'Default authentication method',

   'Date of last automated enrollment'
=> 'Date of last automated enrollment',

   'Date of first automated enrollment'
=> 'Date of first automated enrollment',

   'Official course code'
=> 'Official course code',

   'Username:domain of course owner'
=> 'Username:domain of course owner',

   'Date of last student access'
=> '学生访问的结束日期',

   'Date of first student access'
=> '学生访问的开始日期',

   'Course section number(:LON-CAPA section)'
=> 'Course section number(:LON-CAPA section)',

   'Show more details'
=> '查看更多详情',

   'Public RSS/podcast (subscribe to)'
=> '公共RSS /播客(订阅)',

   'Course Owner:'
=> '课程所有者:',

   'Default Authentication method'
=> 'Default Authentication method',

   'Modify settings'
=> 'Modify settings',

   'Automated Enrollment'
=> 'Automated Enrollment',

   'Use the menu on the left to choose an enrollment management task.'
=> 'Use the menu on the left to choose an enrollment management task.',

   'Result of Changes to Automated Enrollment Settings.'
=> 'Result of Changes to Automated Enrollment Settings.',

   'The following automated enrollment parameters have been changed:'
=> 'The following automated enrollment parameters have been changed:',

   'now set to'
=> 'now set to',

   'still set to'
=> 'still set to',

   'The following automated enrollment parameters remain unchanged:'
=> 'The following automated enrollment parameters remain unchanged:',

   'Change settings'
=> 'Change settings',

   "Student's agreement needed for listing in student-viewable roster"
=> "Student's agreement needed for listing in student-viewable roster",

   'Include link to accessible portfolio files'
=> 'Include link to accessible portfolio files',

   'Print header format'
=> 'Print header format',

   'Substitutions:<br />[_1]: student name, [_2]: course id, [_3]: assignment note. Numbers after the <tt>%</tt> limit the field size.'
=> 'Substitutions:<br />[_1]: student name, [_2]: course id, [_3]: assignment note. Numbers after the <tt>%</tt> limit the field size.',

   'Force all students in the course to use a specific math rendering engine.'
=> 'Force all students in the course to use a specific math rendering engine.',

   "[_1], [_2] (Convert to Images), [_3] (TeX to HTML), or blank for student's preference"
=> "[_1], [_2] (Convert to Images), [_3] (TeX to HTML), or blank for student's preference",

   'Bridge Task Grading'
=> 'Bridge Task Grading',

   'Classlist Manager'
=> 'Classlist Manager', # !?!

   'Note for students:'
=> '注意事项：',

   'If you are officially enrolled in a course but the course is not listed in your LON-CAPA courses, click the "Show more details" link for the specific course and check the default access dates and/or automated enrollment settings.'
=> 'If you are officially enrolled in a course but the course is not listed in your LON-CAPA courses, click the "Show more details" link for the specific course and check the default access dates and/or automated enrollment settings.',

   'Please [_1]log in again[_2].'
=> '请[_1]重新登录[_2].',

   'Switching Server ...'
=> '更换服务器 ...',

   'Already logged in'
=> '已经登录',

   'Apply style file: '
=> 'Apply style file: ',

   'The problem '
=> '问题 ',

   'Search criteria'
=> '搜索条件',

   'begins with'
=> '始于',

   'in selected LON-CAPA domain'
=> '在选定的 LON-CAPA-域 ',

   'in institutional directory for selected domain'
=> '在选定的域中的研究所列表',

   'No exact match found for the username ([_1]) in LON-CAPA domain: [_2]'
=> '没有找到完全匹配的用户名（[_1] ）在LON-CAPA-域：',

   'Creating new account.'
=> '创建新帐户。',

   'Report a documentation bug'
=> '报告文件错误 (Englisch)',

   'You must specify a valid username. Only the following are allowed: letters numbers - . @'
=> '您必须指定一个有效的用户名。只允许以下字符：字母，数字， "-"， "." 和 "@"',

   'The following need to be corrected before the search can be run:'
=> '在搜索可以开始之前，下面必须予以纠正：',

   'You must include some text to search for.'
=> '您必须包括一些要搜寻的文字。',

   "The text you are searching for must contain at least two characters when using a 'begins' type search."
=> "文本搜索必须包含至少有两个字符，当使用的是'开始'类型的搜索。",

   "The text you are searching for must contain at least three characters when using a 'contains' type search."
=> "文字要搜索必须包含至少3个字符时，当使用的是'包含'式的搜索。",

   'You must choose a domain when using an institutional directory search.'
=> '您必须选择一个域，当使用的是研究所目录搜索。',

   'You must choose a domain when using a domain search.'
=> '您必须选择一个域，当使用域搜索。',

   "When using searching by last,first you must include a comma as separator between last name and first name."
=> "When using searching by last,first you must include a comma as separator between last name and first name.",

   "When searching by last,first you must include at least one character in the first name."
=> "When searching by last,first you must include at least one character in the first name.",

   'Revoking [_1] in [_2]: [_3]'
=> 'Revoking [_1] in [_2]: [_3]',

   'Revoking custom role:'
=> 'Revoking custom role:',

   'Deleting [_1] in [_2]: [_3]'
=> 'Deleting [_1] in [_2]: [_3]',

   'Deleting custom role [_1] by [_2] in [_3]'
=> 'Deleting custom role [_1] by [_2] in [_3]',

   'Add to classlist'
=> 'Add to classlist',

   'Re-enabling [_1] in [_2]: [_3]'
=> 'Re-enabling [_1] in [_2]: [_3]',

   'Re-enabling custom role [_1] by [_2] in [_3]: [_4]'
=> 'Re-enabling custom role [_1] by [_2] in [_3]: [_4]',

   'Unknown command'
=> 'Unknown command',

   '[_1] may not be used as the name for a section, as it is a reserved word.'
=> '[_1] may not be used as the name for a section, as it is a reserved word.',

   '[_1] may not be used as the name for a section, as it is the name of a course group.'
=> '[_1] may not be used as the name for a section, as it is the name of a course group.',

   'Please [_1]go back[_2] and choose a different section name.'
=> 'Please [_1]go back[_2] and choose a different section name.',

   'Drop from classlist: [_1]'
=> 'Drop from classlist: [_1]',

   'Existing Role'
=> 'Existing Role',

   'Assigning Role to Self'
=> 'Assigning Role to Self', # ???

   'Invalid search.'
=> 'Invalid search.',

   'You must enter a search term.'
=> 'You must enter a search term.',

   'You must specify a valid domain when searching in a domain or institutional directory.'
=> 'You must specify a valid domain when searching in a domain or institutional directory.',

   'You may want to search in the LON-CAPA domain instead of the institutional directory.'
=> 'You may want to search in the LON-CAPA domain instead of the institutional directory.',

   'New users can only be created in the domain to which your current role belongs - [_1].'
=> 'New users can only be created in the domain to which your current role belongs - [_1].',

   'Institutional directory search is not available in domain: [_1]'
=> 'Institutional directory search is not available in domain: [_1]',

   'Institutional directory search in domain: [_1] is only allowed for users with a current role in the domain.'
=> 'Institutional directory search in domain: [_1] is only allowed for users with a current role in the domain.',

   'Institutional directory search in domain: [_1] is not available to your user type: '
=> 'Institutional directory search in domain: [_1] is not available to your user type: ',

   'Institutional directory search has not been configured for domain: [_1]'
=> 'Institutional directory search has not been configured for domain: [_1]',

   'Institutional directory search in domain: [_1] is not available for searching by "[_2]"'
=> 'Institutional directory search in domain: [_1] is not available for searching by "[_2]"',

   'Institutional directory search in domain: [_1] is not available.'
=> 'Institutional directory search in domain: [_1] is not available.',

   'Institutional directory search in domain [_1] is not available for the requested search type: "[_2]"'
=> 'Institutional directory search in domain [_1] is not available for the requested search type: "[_2]"',

   'You may want to broaden your search to a search of the institutional directory for the domain.'
=> 'You may want to broaden your search to a search of the institutional directory for the domain.',

   'You may want to broaden your search to the selected LON-CAPA domain.'
=> 'You may want to broaden your search to the selected LON-CAPA domain.',

   'Pick group first'
=> 'Pick group first',

   'No login name specified'
=> 'No login name specified',

   'Invalid login name'
=> 'Invalid login name',

   'Only letters, numbers, periods, dashes, @, and underscores are valid'
=> 'Only letters, numbers, periods, dashes, @, and underscores are valid',

   'For this user, the default quota would be [_1] MB.'
=> 'For this user, the default quota would be [_1] MB.',

   "For this user, the default quota would be [_1] MB, as determined by the user's institutional affiliation ([_2])."
=> "For this user, the default quota would be [_1] MB, as determined by the user's institutional affiliation ([_2]).",

   "For this user, the default quota of [_1] MB, is determined by the user's institutional affiliation ([_2])."
=> "For this user, the default quota of [_1] MB, is determined by the user's institutional affiliation ([_2]).",

   'in all LON-CAPA domains.'
=> 'in all LON-CAPA domains.',

   'in LON-CAPA domains:'
=> 'in LON-CAPA domains:',

   'in LON-CAPA domain '
=> '在LON-CAPA域 ',

   'Course settings modifiable by [_1] only.'
=> 'Course settings modifiable by [_1] only.',

   'Course Owner'
=> 'Course Owner',

   'Username:Domain'
=> '用户名：域',

   'Course Activity'
=> 'Course Activity',

   'Course Domain'
=> 'Course Domain',

   'Course Institutional Code'
=> 'Course Institutional Code',

   "Course Owner's Username"
=> "Course Owner's Username",

   "Course Owner's Domain"
=> "Course Owner's Domain",

   'Course Type'
=> 'Course Type',

   'LON-CAPA course ID'
=> 'LON-CAPA course ID',

   'None found'
=> 'None found',

   'Course settings which only a [_1] may modify.'
=> 'Course settings which only a [_1] may modify.',

   "Click a 'Select' button to view or modify settings for a [_1] which may only be modified by a [_2] in this domain."
=> "Click a 'Select' button to view or modify settings for a [_1] which may only be modified by a [_2] in this domain.",

   'Single user search'
=> 'Single user search',

   'Set enrollment'
=> 'Set enrollment',

   'Please review the information in "Log-in help" and the "Getting started" guide if you are unable to log-in.'
=> 'Please review the information in "Log-in help" and the "Getting started" guide if you are unable to log-in.',

   'Please review the information in "Log-in help" if you are unable to log-in.'
=> 'Please review the information in "Log-in help" if you are unable to log-in.',

   'If your problem is still unresolved, the form below can be used to send a question to the LON-CAPA helpdesk.'
=> 'If your problem is still unresolved, the form below can be used to send a question to the LON-CAPA helpdesk.',

   'Getting started guide'
=> 'Getting started guide',

   '[_1] [_2] [_3] [_4] [_5]m [_6]s ' # "mm dd yyyy hh mi ss" (1:month, 2:day, 3:year, 4:hour, 5:minute, 6:second)
=> '[_1] [_2] [_3] [_4] [_5]m [_6]s ', # => '[_2]. [_1] [_3], [_4]:[_5]:[_6] ', # "dd. mm yyyy, hh:mi:ss" (German date format)

   '[_1]Select Date[_2]'
=> '[_1]请选择日期[_2]',

   '[_1]: students can view all sections. [_2]: students can only view their own section. blank or [_3] prevents student view.'
=> '[_1]: students can view all sections. [_2]: students can only view their own section. blank or [_3] prevents student view.',

   '[_1] to require students to opt-in to listing in the roster (on the roster page).'
=> '[_1] to require students to opt-in to listing in the roster (on the roster page).',

   "[_1] for link to each a listing of each student's files."
=> "[_1] for link to each a listing of each student's files.",

   '[_1]: student, [_2]: TA, [_3]: instructor'
=> '[_1]： 学生， [_2]： 导师， [_3]： 讲师',

   'role:section,role:section,...'
=> 'role:section,role:section,...',

   'Example: "<tt>st:001,st:002,in,cc</tt>" would permit students in sections 001 and 002 and instructors in any section, and course coordinators to edit their own posts.'
=> 'Example: "<tt>st:001,st:002,in,cc</tt>" would permit students in sections 001 and 002 and instructors in any section, and course coordinators to edit their own posts.',

   'supported types'
=> 'supported types',

   '[_1] to send a message only to student, [_2] to send message to student and add record to user information page for instructors. Leave blank to disable.'
=> '[_1] to send a message only to student, [_2] to send message to student and add record to user information page for instructors. Leave blank to disable.',

   'Instructors and TAs in sections, when grading bridge tasks, should be allowed to grade other sections.'
=> 'Instructors and TAs in sections, when grading bridge tasks, should be allowed to grade other sections.',

   '[_1]: they are allowed (this is the default). [_2]: no, they can only grade their own section.'
=> '[_1]: they are allowed (this is the default). [_2]: no, they can only grade their own section.',

   'Calendar Announcement for '
=> 'Calendar Announcement for ',

   'Opening'
=> 'Opening',

   'Closing'
=> 'Closing',

   'To add a new user:'
=> 'To add a new user:',

   "(You can only create new users in your current role's domain - [_1])"
=> "(You can only create new users in your current role's domain - [_1])",

   "You are not authorized to create new users in your current role's domain - [_1]."
=> "You are not authorized to create new users in your current role's domain - [_1].",

   "Set 'Domain/institution to search' to: [_1]"
=> "Set 'Domain/institution to search' to: [_1]",

   "Set 'Search criteria' to: [_1]username is ..... in selected LON-CAPA domain[_2]"
=> "Set 'Search criteria' to: [_1]username is ..... in selected LON-CAPA domain[_2]",

   'Provide the proposed username'
=> 'Provide the proposed username',

   'Select a user to add/modify roles'
=> 'Select a user to add/modify roles',

   "Click 'Search'"
=> "Click 'Search'",

   'User Search to add/modify roles'
=> 'User Search to add/modify roles',


# Feedback messages:

   'You have entered that answer before'
=> '您已经输入了答案',

   "Computer's answer now shown above."
=> "上面显示的是正确答案。",

   'You are correct.'
=> '正确答案！',

   'You are partially correct.'
=> '部分正确。',

   'Incorrect'
=> '错误',

   'Your receipt no. is [_1]'
=> '您的证明编号是 [_1]',

   'You are excused from the problem.'
=> '你的作业已通过。',

   'Some extra items were submitted.'
=> 'Some extra items were submitted.',

   'Some items were not submitted.'
=> 'Some items were not submitted.',

   'An error occurred while grading your answer.'
=> 'An error occurred while grading your answer.',

   'The submitted answer was too long.'
=> 'The submitted answer was too long.',

   'This question expects a numeric answer.'
=> 'This question expects a numeric answer.',

   'You have provided an invalid ranking.'
=> 'You have provided an invalid ranking.',

   'Please refer to [_1]'
=> 'Please refer to [_1]',

   'help on ranking problems'
=> 'help on ranking problems',

   "Submission won't be graded. The type of file submitted is not allowed."
=> "Submission won't be graded. The type of file submitted is not allowed.",

   'Submission not graded. Use fewer digits.'
=> 'Submission not graded. Use fewer digits.',

   'Submission not graded. Use more digits.'
=> 'Submission not graded. Use more digits.',

   'Error in instructor specifed unit. This error has been reported to the instructor.'
=> 'Error in instructor specifed unit. This error has been reported to the instructor.',

   'Unable to interpret units. Computer reads units as "[_1]".'
=> 'Unable to interpret units. Computer reads units as "[_1]".',

   'Incompatible units. No conversion found between "[_1]" and the required units.'
=> 'Incompatible units. No conversion found between "[_1]" and the required units.',

   'Only a number required. Computer reads units of "[_1]".'
=> 'Only a number required. Computer reads units of "[_1]".',

   'Proper comma separation is required'
=> 'Proper comma separation is required',

   'Unable to understand formula'
=> 'Unable to understand formula',

   'Your submission has been recorded.'
=> 'Your submission has been recorded.',

   'A draft copy has been saved.'
=> 'A draft copy has been saved.',

   'Nothing submitted.'
=> 'Nothing submitted.',

   'Unknown message'
=> 'Unknown message',

   'Returned file(s): [_1]'
=> 'Returned file(s): [_1]',

   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Answer Submitted: Your final submission will be graded after the due date.',

# --/


   ' The last submission was after the Due Date '
=> ' The last submission was after the Due Date ',

   'Submit a file: (only one file can be uploaded)'
=> '提交档案: (只允许上传一个文件)',

   'OR:'
=> '或者:',

   'Select Portfolio Files'
=> '选择组合文件',

   'Portfolio files previously selected: [_1]'
=> 'Portfolio files previously selected: [_1]',

   "These file(s) don't exist: [_1]"
=> "These file(s) don't exist: [_1]",

   'Previously published version'
=> 'Previously published version',

   'You do not have privileges to modify the authentication configuration for this user.'
=> 'You do not have privileges to modify the authentication configuration for this user.',

   'You do not have privileges to modify the portfolio quota for this user.'
=> 'You do not have privileges to modify the portfolio quota for this user.',

   'If a change is required, contact a domain coordinator for the domain'
=> 'If a change is required, contact a domain coordinator for the domain',

   'with submissions'
=> '带答案',

   'in grading queue'
=> '在评估队列中',

   'with ungraded submissions'
=> '未评估的答案',

   'with incorrect submissions'
=> '错误的答案',

   'with any status'
=> '任何状态',

   'Default value or none'
=> '默认值或无',

   'Floating Point between 1 and 0'
=> '浮点运算的1和0',

   'Floating point number between zero and one'
=> 'Floating point number between zero and one',

   'Positive Floating Point'
=> 'Positive Floating Point',

   'Positive floating point number or zero'
=> 'Positive floating point number or zero',

   'Floating Point'
=> 'Floating Point',

   'Floating point number'
=> 'Floating point number',

   'Auto-enrollment settings'
=> 'Auto-enrollment settings',

   'Configuration setting'
=> '配置设置',

   'Value(s)'
=> 'Value(s)',

   'Auto-enrollment active?'
=> 'Auto-enrollment active?',

   'Access to other pages will be prevented until you have moved the message to your inbox.'
=> '只有把该邮件移至收件箱才可以访问其他网页。',

   'Access to other pages will be prevented until you have moved all critical messages to your inbox.'
=> '只有把所有的重要邮件移至收件箱才可以访问其他网页。',

   'Move to Inbox'
=> '移至收件箱',

   'Move to Inbox/Compose reply'
=> '移至收件箱并回复',

   'Confirm Receipt'
=> '确认已收到',

   'Confirm Receipt and Reply'
=> '确认已收到并回复',

   'Displaying Critical Messages'
=> '显示重要邮件',

   'Confirming Receipt'
=> '确认已收到',

   'Confirmed Receipt'
=> '确认已收到',

   'Communicate'
=> '通讯',

   'Replying to a Critical Message'
=> '针对重要邮件',

   'Answer Available'
=> '答复可用',

   ' to '
=> ' 到 ', # ???

   'Event from [_1] to [_2]'
=> '活动由 [_1] 至 [_2]',

   '[_1]: [_2] from domain [_3]'
=> '[_1]: [_2] 从域 [_3]',

   'The following problems occurred:'
=> '发生下列问题：',

   'Could not initialize [_1] at this time.'
=> '目前无法初始化[_1]。',

   'Please try again.'
=> '请再试一次。',

   'in this course'
=> '在该课程中',

   'Remove Checked Entries'
=> '删除选中的条目',

   'Modify Student Data'
=> '修改学生资料',

   'First name'
=> '名字',

   'Middle name'
=> '第二个名字',

   'Last name'
=> '姓氏',

   'ID'
=> 'ID/学号',,

   'Sending critical message'
=> '发送重要消息',

   'Replying to'
=> '回复',

   'All messages:'
=> 'All messages:',

   'Unread messages:'
=> 'Unread messages:',

   'Read messages:'
=> 'Read messages:',

   'Replied to messages:'
=> 'Replied to messages:',

   'Forwarded messages:'
=> 'Forwarded messages:',

   'showing messages [_1] through [_2] of [_3].'
=> '显示消息[_1]通过[_2]的[_3] 。',

   'Broadcast Message'
=> '广播消息',

   'randomly pick [quant,_1,resource]'
=> 'randomly pick [quant,_1,resource]', # => '随机挑选 [quant,_1,resource,resource]',

   'contents hidden'
=> '隐藏的内容',

   'URLs hidden'
=> '隐藏 URLs',

   'random order'
=> '随机顺序',

   'Resources in course with version changes since yesterday'
=> '课程中的资源，从昨天起版本的变化',

   'Version changes since Yesterday'
=> '从昨天起版本的变化',

   'Resources in course with version changes since last week'
=> '课程中的资源，从上周起版本的变化',

   'Version changes since last Week'
=> '从上周起版本的变化',

   'Resources in course with version changes since last month'
=> '课程中的资源，从上个月起版本的变化',

   'Version changes since last Month'
=> '从上个月起版本的变化',

   'Resources in course with version changes seit start of course'
=> '课程中的资源，从课程开始起版本的变化',

   'Version changes since start of Course'
=> '从课程开始起版本的变化',

   'No version changes since yesterday'
=> '从昨天起版本没有变化',

   'No version changes since last week'
=> '从上周起版本没有变化',

   'No version changes since last month'
=> '从上个月起版本没有变化',

   'No version changes since start of course'
=> '从课程开始起版本没有变化',

   'version changes since yesterday'
=> '从昨天起版本的变化',

   'version changes since last week'
=> '从上周起版本的变化',

   'version changes since last month'
=> '从上个月起版本的变化',

   'version changes since start of course'
=> '从课程开始起版本的变化',

   'Roles for which access to course has expired since yesterday'
=> '从昨天起该课程过期的角色',

   'Roles for which access to course has expired since last week'
=> '从上周起该课程过期的角色',

   'Roles for which access to course has expired since last month'
=> '从上个月起该课程过期的角色',

   'Roles for which access to course has expired since start of course'
=> '从课程开始起过期的角色',

   'There are no roles which expired since yesterday'
=> '没有角色从昨天起过期了',

   'There are no roles which expired since last week'
=> '没有角色从上周起过期了',

   'There are no roles which expired since last month'
=> '没有角色从上个月起过期了',

   'There are no roles which expired since start of course'
=> '没有角色从课程开始起过期了',

   'roles which expired since yesterday'
=> '从昨天起该课程过期的角色',

   'roles which expired since last week'
=> '从上周起该课程过期的角色',

   'roles which expired since last month'
=> '从上个月起该课程过期的角色',

   'roles which expired since start of course'
=> '从课程开始起过期的角色',

   'Roles for which access to course has become available since yesterday'
=> '从昨天起分配给该课程的角色',

   'Roles for which access to course has become available since last week'
=> '从上周起分配给该课程的角色',

   'Roles for which access to course has become available since last month'
=> '从上个月起分配给该课程的角色',

   'Roles for which access to course has become available since start of course'
=> '从课程开始起分配给该课程的角色',

   'There are no roles which have become active since yesterday'
=> '从昨天起没有角色分配给该课程',

   'There are no roles which have become active since last week'
=> '从上周起没有角色分配给该课程',

   'There are no roles which have become active since last month'
=> '从上个月起没有角色分配给该课程',

   'There are no roles which have become active since start of course'
=> '从课程开始起没有角色分配给该课程',

   'roles which have become active since yesterday'
=> '从昨天起分配给该课程的角色',

   'roles which have become active since last week'
=> '从上周起分配给该课程的角色',

   'roles which have become active since last month'
=> '从上个月起分配给该课程的角色',

   'roles which have become active since start of course'
=> '从课程开始起分配给该课程的角色',

   'Show all posts'
=> '查看所有帖子',

   'to display'
=> '显示', # ???

   'posts previously marked read'
=> '帖子先前标记为已读',

   'previously viewed posts'
=> '先前浏览的帖子',

   'NEW'
=> '新的',

   'Preferences on what is marked as NEW'
=> '偏好，什么将被标记为新',

   'Mark NEW posts no longer new'
=> '随着新的帖子将不再标记为新',

   'Sorting/Filtering options'
=> '排序/过滤选项',

   'Export'
=> '导出',

   'Attachments'
=> '附件',

   'Download the zip file from [_1]Discussion Posting Archive'
=> '下载zip档案由[_1]讨论发布档案',

   'The following errors occurred during export - [_1]'
=> 'The following errors occurred during export - [_1]',

   'Unfortunately you will not be able to retrieve an archive of the discussion posts at this time, because there was a problem creating a manifest file.'
=> 'Unfortunately you will not be able to retrieve an archive of the discussion posts at this time, because there was a problem creating a manifest file.',

   'Unfortunately you will not be able to retrieve an IMS archive of this posts at this time, because there was a problem creating a manifest file.'
=> 'Unfortunately you will not be able to retrieve an IMS archive of this posts at this time, because there was a problem creating a manifest file.',

   'Make Visible'
=> '显示',

   'Mark unread'
=> 'Mark unread',

   'Mark read'
=> 'Mark read',

   'This post has been edited by the author.'
=> 'This post has been edited by the author.',

   'Display all versions'
=> 'Display all versions',

   'Earlier version(s) were posted on: '
=> 'Earlier version(s) were posted on: ',

   'You do not have privileges to view all versions of posts.'
=> 'You do not have privileges to view all versions of posts.',

   'Please select a different role.'
=> 'Please select a different role.',

   'Error copying file attachment - [_1] to IMS package'
=> 'Error copying file attachment - [_1] to IMS package',

   'Error copying file attachment - [_1] to IMS package: '
=> 'Error copying file attachment - [_1] to IMS package: ',

   'Re: '
=> 'Re: ',

   'Please select a feedback type.'
=> 'Please select a feedback type.',

   'Sorry, no feedback possible on this resource ...'
=> 'Sorry, no feedback possible on this resource ...',

   'Error sending message to [_1], no user specified.'
=> 'Error sending message to [_1], no user specified.',

   'Error sending message to [_1], no domain specified.'
=> 'Error sending message to [_1], no domain specified.',

   'Error sending message to'
=> 'Error sending message to',

   'Not registered'
=> '未注册', # ???

   'Editing not permitted'
=> '不允许编辑',

   'Marked postings read/unread'
=> '标记贴子为已读/未读',

   'Changed sort/filter'
=> '改变排序/过滤器',

   'Changed display status'
=> '改变显示状态',

   'Deletion not permitted'
=> '不允许删除',

   'Changed discussion status'
=> '讨论的状态已更改',

   'Added to my course blog'
=> '添加到我的课程博客',

   'Back to previous page'
=> '返回前一页',

   'Go to previous page'
=> '返回前一页',

   'Return to previous page'
=> '返回前一页',

   'Untitled resource'
=> '资源没有标题',

   'Discussion display options'
=> '讨论显示选项',

   'Preferences can be set for this discussion that determine ....'
=> '这个讨论可以设置使用偏好',

   'Which posts are displayed when you display this discussion board or resource, and'
=> '哪些讨论将被显示在您的公告栏或资源里',

   'Under what circumstances posts are identified as "NEW", and'
=> '在什么情况下讨论被确定为“新”',

   'Whether individual posts can be marked as read/unread'
=> '个别帖子是否可以被标记为已读/未读',

   'Posts not marked read'
=> '讨论没有标记为已读',

   'New posts cease to be identified as "NEW"?'
=> '新的讨论不再被标识为“新”？',

   'Option to mark each post as read/unread?'
=> '选择帖子标记为已读/未读？',

   'Shown'
=> '显示',

   'Not shown'
=> '不显示',

   'Discussion options'
=> '论坛选项',

   'Set options that control the sort order of posts, and/or which posts are displayed.'
=> 'Set options that control the sort order of posts, and/or which posts are displayed.',

   'Sort order'
=> '排序顺序',

   'Date order - oldest first'
=> '按日期顺序 - 最老的优先',

   'Date order - newest first'
=> '按日期顺序 - 最新的优先',

   'Threaded'
=> '按帖子', # ???

   'By subject'
=> '按主题',

   'By domain and username'
=> '按域名和用户名',

   'By last name, first name'
=> '按姓氏，名字',

   'Specific role status'
=> '具体角色的状态',

   'Roles of any status'
=> '任意的角色',

   'Only active roles'
=> '只有现在的角色',

   'Only past roles'
=> '只有过去的角色',

   'Only future roles'
=> '只有未来的角色',

   'Specific user roles'
=> '特定的用户角色',

   'All roles'
=> '所有角色',

   'Students'
=> '学生',

   'Course Coordinators'
=> '课程协调员',

   'Instructors'
=> '讲师',

   'TAs'
=> '辅导员',

   'Exam proctors'
=> '监考老师',

   'Custom role defined by [_1].'
=> 'Custom role defined by [_1].', # '自定义角色',

   'Custom role [_1][_2]defined by [_3]' # _2: <br />
=> 'Custom role [_1][_2]defined by [_3]', # '自定义角色',

   'Specific sections'
=> '具体章节',

   'Specific groups'
=> '特定组',

   'Pick specific users (by name)'
=> '选择特定的用户 (姓)',

   'Show a list of current posters'
=> 'Show a list of current posters',

   'So far, no data has been returned for your request'
=> '到现在为止，您的查询没有返回任何数据。',

   'Select a user'
=> '选择一个用户',

   'An error occurred while processing this resource. The course personnel ([_1]) and the author have been notified.'
=> 'An error occurred while processing this resource. The course personnel ([_1]) and the author have been notified.',

   'photo'
=> '图片',

   'Critical Message'
=> '重要邮件',

   'Display a Message'
=> '显示邮件',

   'Back to Folder Display'
=> '返回文件夹列表',

   'Currently available actions (will open extra window):'
=> '目前可采取的行动 (在新窗口中打开):',

   'There are no unread messages in this folder.'
=> '在此文件夹中没有未阅读邮件。',

   'There are no read messages in this folder'
=> '在此文件夹中没有已阅读邮件。',

   'There are no forwarded messages in this folder.'
=> '在此文件夹中没有转发的邮件。',

   'You have not replied to any messages in this folder.'
=> '在此文件夹中您没有需要回答的邮件。',

   'There are no messages in this folder.'
=> '空文件夹', # Empty Folder

   'Cc:'
=> '抄送：',

   'Bcc:'
=> '密送：',

   'Bcc'
=> '密送',

   'Retrieve discussion and message records'
=> '检索讨论和信息记录',

   'New Record (record is visible to course faculty and staff)'
=> '新记录 (只有课程管理者和工作人员可见)：',

   'Post this Record'
=> '保存',

   'Revise your search criteria for this domain'
=> 'Revise your search criteria for this domain',

   'Metadata Modified'
=> 'Metadata Modified',

   'Use of LON-CAPA requires Javascript to be enabled in your web browser.'
=> 'Use of LON-CAPA requires Javascript to be enabled in your web browser.',

   'As this is not the case, most functionality in the system will be unavailable.'
=> 'As this is not the case, most functionality in the system will be unavailable.',

   "You have requested to create file in directory [_1] which doesn't exist. The requested directory path has been removed from the requested filename."
=> "You have requested to create file in directory [_1] which doesn't exist. The requested directory path has been removed from the requested filename.",

   'Directory'
=> '目录',

   'Only empty directories may be deleted.'
=> '只有空的目录可以被删除。',

   'You must delete the contents of the directory first.'
=> '您必须首先删除目录中的内容。',

   'Cannot delete non-obsolete published file'
=> 'Cannot delete non-obsolete published file',

   'Must not include'
=> 'Must not include',

   'Name of new file is the same as name of old file'
=> 'Name of new file is the same as name of old file',

   'no action taken'
=> 'no action taken',

   'copy metadata error'
=> 'copy metadata error',

   'No New filename specified'
=> 'No New filename specified',

   'Warning: a published problem of this name exists.'
=> 'Warning: a published problem of this name exists.',

   'Warning: a published library of this name exists.'
=> 'Warning: a published library of this name exists.',

   'Bad filename [_1].<br /> <tt>(name).(number).(extension)</tt> not allowed. <br /> Removing the <tt>.number.</tt> from requested filename.'
=> 'Bad filename [_1].<br /> <tt>(name).(number).(extension)</tt> not allowed. <br /> Removing the <tt>.number.</tt> from requested filename.',

   'Cannot change MIME type of a directory'
=> 'Cannot change MIME type of a directory',

   'Cannot rename or move non-obsolete published file'
=> 'Cannot rename or move non-obsolete published file',

   'Change discussion display'
=> 'Change discussion display',

   'Choose whether or not to display a count of the number of new posts for each resource or discussion board which has unread posts.'
=> 'Choose whether or not to display a count of the number of new posts for each resource or discussion board which has unread posts.',

   "This can increase the time taken to gather data for the '<i>What's New?</i>' page by a few seconds."
=> "This can increase the time taken to gather data for the '<i>What's New?</i>' page by a few seconds.",

   'Currently set to [_1].'
=> '当前设置为 [_1].',

   'Change to [_1]'
=> '改变为 [_1]',

   'No change'
=> '无变化',

   'Count unread posts in discussions display set to [_1]'
=> '未读讨论计数显示设置为 [_1]',

   'Groups Manager'
=> '组管理',

   'Group access start and end dates'
=> '组访问开始和结束日期',

   'None available'
=> '无可用',

   'There are no active, future or previous group members to modify.'
=> 'There are no active, future or previous group members to modify.',

   'Members to delete or expire'
=> '成员身份到期或将被删除',

   'To be deleted'
=> '将删除的',

   'To be expired'
=> '期满',

   'No members to be deleted or expired from the group.'
=> 'No members to be deleted or expired from the group.',

   'Files: [_1]'
=> '文件： [_1]',

   'Folders: [_1]'
=> '文件夹： [_1]',

   'Choose Task'
=> '选择行动',

   'Modify default group settings'
=> '修改默认组设置',

   'Modify access, tools and/or privileges for previous, future, or current members'
=> '修改组成员访问，工具和权限',

   'Add member(s) to the group'
=> '添加组成员',

   'Group Settings'
=> '组设定',

   'Modify/Delete Members'
=> '修改/删除会员',

   'Current Tool Set'
=> '目前的工具集',

   'Change Privileges'
=> '更改权限',

   'Membership Mapping'
=> '会员推荐',

   'Group name, title and available collaborative tools'
=> '组名称，所有权和使用协作工具',

   'Letters, numbers and underscore only'
=> '只有字母，数字和下划线',

   'Discussion boards'
=> '论坛',

   'E-mail'
=> 'E-mail',

   'File Repository'
=> '档案库',

   'Group home page'
=> '组首页',

   'Membership Roster'
=> '会员名册',

   'Granularity:'
=> '細微性：',

   'Different subsets of the chosen collaborative tools for different group members?'
=> '不同的组成员选择不同的协作工具？',

#   'Disk quota: '
#=> '磁盘配额： ',

   'Disk quota'
=> '磁盘配额',

   'If you enable the group portfolio for the group, allocate a disk quota.'
=> 'If you enable the group portfolio for the group, allocate a disk quota.', # '如果您对组启用了文件存放，请分配磁盘配额：',

   '[_1] MB'
=> '[_1] MB',

   'A total of [_1] MB can be divided amongst all groups in the course, and [_2] MB are currently unallocated.'
=> '该课的所有组共有 [_1] MB 可分，[_2] MB 目前未被分配。',

   'Default start and end dates for group access'
=> '默认情况下组访问的开始和结束日期',

   'Start:'
=> '开始：',

   'End:'
=> '结束：',

   'Error: invalid course domain or number - group folder creation failed.'
=> '错误：无效的课程或域号码。建立了组列表失败。',

   'Course Groups'
=> '课程组',

   'Non-standard course - folder for all groups not added.'
=> '非标准课程 - 所有组的文件夹不会增加。',

   'Build a list of users for selection of group members'
=> '从组成员里选择来建立一个用户列表',

   'Group membership selection list criteria:'
=> '组成员名单选择标准：',

   'Pick the criteria to use to build a list of course users from which you will select '
=> '选择的标准的使用来建立一个名单，您将选择',

   'members of the new group.'
=> '新的组成员。',

   'If you do not wish to add members when you first create the group, there is no need to pick any criteria.'
=> '如果您创建的组不想立即要添加成员，就没有必要选择任何标准。',

   'A subsequent step will also allow you to specify automatic adding/dropping of group members triggered by specified user role and section <i>changes</i> in the course.'
=> '随后的步骤将自动添加/删除组成员，也可以让您指定所引发指定用户角色和第的过程中。这是通过指定的用户角色和在课程中章节<i>变化</i>被触发的。',

   'Access types'
=> '访问类型',

   'Currently has access'
=> '目前已获得',

   'Will have future access'
=> '今后将有机会',

   'Previously had access'
=> '曾获得',

   'Course roles'
=> '课程角色',

   'Course sections'
=> '课程章节',

   'all sections'
=> '所有章节',

   'no section'
=> '无章节',

   'Go to next step'
=> '下一步',

   'Invalid group name'
=> '无效的组名称',

   'The group name entered '
=> '输入的组名称 ',

   'is not a valid name.'
=> '不是一个有效的名称。',

   'can not be used as it is the name of '
=> '不能使用，因为它的名字是 ',

   'an existing [_1]'
=> '现有的 [_1]',

   ' in this Course'
=> ' 在该课程里',

   'Group names and section names used in a Course must be unique.'
=> '组名称和章节名称在课程中必须是独一无二的。',

   'Group names may only contain letters, numbers or underscores.'
=> '组名称只能包含字母，数字或下划线。',

   'Go to previous step'
=> '返回',

   'Select Members'
=> '选择成员',

   'Your group selections - '
=> '您的组选择 - ',

   'The following settings will apply to the group:'
=> '下面的设置将适用于本组：',

   'Granularity'
=> '細微性',

   'File quota'
=> '文件共享',

   'Default access dates'
=> '默认访问日期',

   'Different collaborative tools[_1]for different members:'
=> '不同的协作工具[_1]对不同的成员组成：',

   'Start date'
=> '开始日期',

   'Start date:'
=> '开始日期：',

   'End date'
=> '结束日期',

   'End date:'
=> '结束日期：',

   'Available for assignment to members:'
=> '可供成员访问：',

   'Unavailable for assignment:'
=> '没有可能访问：',

   'User privileges for collaborative tools'
=> '协作工具的用户权限',

   'For each collaborative tool you have chosen to include, there is a set of core privileges which all group members assigned use of the tool will receive.'
=> 'For each collaborative tool you have chosen to include, there is a set of core privileges which all group members assigned use of the tool will receive.',

   'For some tools there are also additional optional privileges which can be set.'
=> 'For some tools there are also additional optional privileges which can be set.',

   'Choose one of the following:'
=> 'Choose one of the following:',

   'For the collaborative tools you have chosen to include only core privileges are available, so there are no optional privileges to assign.'
=> 'For the collaborative tools you have chosen to include only core privileges are available, so there are no optional privileges to assign.',

   'As you have chosen not to include any collaborative tools in the group, no default optional privileges need to be set.'
=> 'As you have chosen not to include any collaborative tools in the group, no default optional privileges need to be set.',

   'Group membership'
=> '组员',

   'Add members'
=> '添加成员',

   'Assign collaborative tools'
=> '转让协作工具',

   'Tools'
=> '工具',

   'Add Members'
=> '添加成员',

   'Add?'
=> '添加？',

   'All:'
=> '全部：',

   'You have indicated that the group portfolio should be enabled, but you have set the repository quota to 0 MB.\nThis will prevent any upload of files.\nPlease set a value or disable the repository feature.'
=> 'You have indicated that the group portfolio should be enabled, but you have set the repository quota to 0 MB.\nThis will prevent any upload of files.\nPlease set a value or disable the repository feature.',

   '[_1] [_2] was created.<br />'
=> '[_1] [_2] 已创建。<br />',

   'Group membership list updated.'
=> '该组成员名单已经更新。',

   'Any currently logged in course users affected by the changes you made to group membership or privileges for the [_1] group will need to log out and log back in for their LON-CAPA sessions to reflect these changes.'
=> 'Any currently logged in course users affected by the changes you made to group membership or privileges for the [_1] group will need to log out and log back in for their LON-CAPA sessions to reflect these changes.',

   'An error occurred while updating the group membership list:'
=> 'An error occurred while updating the group membership list:',

   'Choose Privileges'
=> 'Choose Privileges',

   'Setting Changes Complete'
=> 'Setting Changes Complete',

   'Modifications Complete'
=> 'Modifications Complete',

   'Creation Complete'
=> 'Creation Complete',

   'Additions Complete'
=> 'Additions Complete',

   'Verify deletion'
=> 'Verify deletion',

   'Deletion Complete'
=> 'Deletion Complete',

   'Create Group'
=> '创建组',

   'discussion'
=> '论坛',

   'email files'
=> '电子邮件档案',

   'homepage'
=> '主页',

   'roster'
=> '花名册',

   'Edit Group Homepage'
=> '编辑组首页',

   'Edit Group Settings'
=> '编辑组设置',

   'Available Group Tools'
=> '可用的工具组',

   'Group Chat Room'
=> '组聊天室',

   'Group e-mail'
=> '组电子邮箱',

   'Group page - [_1]'
=> '组页 - [_1]',

   '[_1] discussion boards - [_2]'
=> '[_1] 论坛 - [_2]',

   'New Discussion Board'
=> '创建新论坛',

   'There are currently no discussion boards in this [_1].'
=> '在这 [_1] 里目前还没有论坛。',

   'Discussion Board Title'
=> '论坛讨论标题',

   'The new discussion board was added successfully.<br />'
=> '新的讨论论坛已成功创建。<br />',

   'Edit [_1] board'
=> '编辑 [_1] 论坛',

   'View all group discussion boards'
=> '查看各组讨论论坛',

   'Show Student View'
=> '以学生视角显示',

   'Note: in anonymous discussion, your name is visible only to course faculty'
=> '注意：在匿名的讨论中，你的名字只有课程教师看的见。',

   'Send a Message in a Group'
=> '组内发送邮件',

   'As this group has no members, there are no recipients to select.'
=> '由于这组没有成员，您无法选择收件人。',

   'Allow replies'
=> '允许回复',

   'Reply to'
=> '回复',

   'Group Portfolio'
=> '组档案',

   '[_1] portfolio files - [_2]'
=> '[_1] 组合文件 - [_2]',

   'There are no membership data to display for this [_1]'
=> 'There are no membership data to display for this [_1]',

   'Group Membership'
=> '组成员',

   '[_1] membership status - [_2]'
=> '[_1] 成员状态 - [_2]',

   'Group Message'
=> '组邮件',

   'Compose Group Message'
=> '撰写组邮件',

   'Course Discussion Boards'
=> '课程讨论区',

   'Post Discussion'
=> '提交讨论文件',

   'Post Anonymous Discussion'
=> '匿名提交讨论文件',

   'Content'
=> '内容',

   'You do not currently have rights to view this group.'
=> 'You do not currently have rights to view this group.',

   'No page information provided.'
=> 'No page information provided.',

   '<p>No page information provided.</p>'
=> '<p>No page information provided.</p>',

   'Available functions'
=> '可用的功能',

   'No group functionality.'
=> 'No group functionality.',

   'No group functionality (e.g., e-mail, discussion, chat or file upload) is currently available to you in this group: [_1].'
=> 'No group functionality (e.g., e-mail, discussion, chat or file upload) is currently available to you in this group: [_1].',

   'Group Page'
=> '组页',

   'Quota allocated to group portfolio:'
=> '配额分配给组文件夹',


   'The quota is currently [_1] MB'
=> '目前的配额： [_1] MB',

   'The quota can be increased to [_1] MB, by adding all unallocated space for groups in the course.'
=> '配额可提高到 [_1] MB， 加上该课程的组中所有未分配的空间。',

   'Each collaborative tool includes core privileges assigned to all members with access to the tool. Some tools may also feature additional privileges which can be set for specific members.'
=> '每个协作工具，包括核心权限，分配给所有成员基本权限。某些工具可能会还具有额外的权限，即可以设置特定的成员。',

   'All group members will receive the same privileges for any tool assigned to them, including the default set of optional privileges.'
=> '所有组成员分配给他们的任何工具将得到相同的权限，包括默认设置可选特权。',

   'Different group members may receive different privileges from others for the tools they have been assigned.'
=> 'Different group members may receive different privileges from others for the tools they have been assigned.',

   'Indicate which <b>optional</b> privileges members will receive by default for a specific tool.'
=> 'Indicate which <b>optional</b> privileges members will receive by default for a specific tool.',

   'These will be the privileges given to members assigned in the future via automatic group assignment for users who receive specific sections/roles in the course '
=> 'These will be the privileges given to members assigned in the future via automatic group assignment for users who receive specific sections/roles in the course ',

   'if enabled on the next page'
=> 'if enabled on the next page',

   'if enabled below'
=> 'if enabled below',

   'Additional privileges'
=> 'Additional privileges',

   'Fixed privileges'
=> '固定权限',

   'Optional privileges'
=> '任择权限',

   'Collaborative Tool'
=> '协作工具',

   'Fixed'
=> '固定的',

   'Optional'
=> '可选的',

   'Additional Tools'
=> '其他工具',

   'Core privileges'
=> '基本权限',

   'For the collaborative tools included for group members being added or modified, there are no optional privileges to set for specific members.'
=> 'For the collaborative tools included for group members being added or modified, there are no optional privileges to set for specific members.',

   'All new group members will receive the same privileges.'
=> '所有新的小组成员将得到同样的权限。',

   'If previously expired members are being re-enabled, or if access for future members is being activated now, previously set privileges will be preserved.'
=> '如果以前到期的成员正在重新启用，或者未来进入的成员现在正在激活，先前的权限将被保留。',

   'As no group members are being added, there are no specific user privileges to set.'
=> '由于没有增加组成员，没有设置具体用户的权限。',

   'No group member privileges to display or set, as you have not indicated that you will be activating, re-enabling, changing privileges, or adding/removing tools for any current members'
=> '目前还没有任何组织成员的权限以显示或设置，因为您还没有表示，你将被激活，重新启用，改变权限，或添加/删除任何现有成员的工具。',

   'Currently the group is configured '
=> '目前该组的配置， ',

   'so different members can receive different optional privileges for a particular tool.'
=> '不同成员为特定的工具可以得到不同的可选权限。',

   'so all members will receive the same optional privileges for a particular tool.'
=> '所有成员为特定的工具可以得到相同的可选权限。',

   'Settings for automatic group enrollment'
=> '设置自动分配组',

   'Group membership mapping to specific sections/roles'
=> 'Group membership mapping to specific sections/roles',

   'Enable/disable automatic group enrollment for users in specified roles and sections'
=> 'Enable/disable automatic group enrollment for users in specified roles and sections',

   'If automatic group enrollment is enabled, when a user is newly assigned a course-wide or section-specific role, he/she will automatically be added as a member of the group, with start and end access dates defined by the default dates set for the group, unless he/she is already a group member, with access dates that permit either current or future group access.'
=> 'If automatic group enrollment is enabled, when a user is newly assigned a course-wide or section-specific role, he/she will automatically be added as a member of the group, with start and end access dates defined by the default dates set for the group, unless he/she is already a group member, with access dates that permit either current or future group access.',

   "If automatic group disenrollment is enabled, when a user's role is expired, access to the group will be terminated unless the user continues to have other course-wide or section-specific active or future roles which receive automatic membership in the group."
=> "If automatic group disenrollment is enabled, when a user's role is expired, access to the group will be terminated unless the user continues to have other course-wide or section-specific active or future roles which receive automatic membership in the group.",

   'Automatically enable group membership when roles are added?'
=> 'Automatically enable group membership when roles are added?',

   'Automatically expire group membership when roles are removed?'
=> 'Automatically expire group membership when roles are removed?',

   'Currently set to'
=> '当前设置为',

   'Mapping of roles and sections affected by automatic group enrollment/disenrollment follows scheme chosen below.'
=> 'Mapping of roles and sections affected by automatic group enrollment/disenrollment follows scheme chosen below.',

   'Pick roles and sections for automatic group enrollment'
=> 'Pick roles and sections for automatic group enrollment',

   'Active?'
=> '激活？',

   'Send group message'
=> '发送组邮件',

   'Create boards'
=> '创建论坛',

   'Edit own posts'
=> '编辑自己的帖子',

   'Hide/Delete any post'
=> '隐藏/删除 任意帖子',

   'View boards'
=> '查看论坛',

   'Control Access'
=> '访问控制',

   'Basic Display'
=> '基本显示',

   'Detailed Display'
=> '详细显示',

   'View page'
=> '查看网页',

   'Modify page'
=> '修改网页',

   'email'
=> 'email',

   'Broadcast message'
=> '广播邮件',

   'files'
=> '文件',

   'Foils without names exist. This can cause problems to malfunction.'
=> 'Foils without names exist. This can cause problems to malfunction.',

   'Unknown area style [_1]'
=> 'Unknown area style [_1]',

   "The message itself will begin with a first line: <i>'Forwarded message from'</i> followed by the original sender's name."
=> "The message itself will begin with a first line: <i>'Forwarded message from'</i> followed by the original sender's name.",

   'Forwarded message from '
=> 'Forwarded message from ',

   'You received a critical message from [_1] in LON-CAPA.'
=> 'You received a critical message from [_1] in LON-CAPA.',

   'You received a message from [_1] in LON-CAPA.'
=> 'You received a message from [_1] in LON-CAPA.',

   "'New' critical message from [_1]"
=> "'New' critical message from [_1]",

   "'New' message from [_1]"
=> "'New' message from [_1]",

   'Refers to'
=> 'Refers to',

   'Previous attempts of student (if applicable)'
=> 'Previous attempts of student (if applicable)',

   'Original screen output (if applicable)'
=> 'Original screen output (if applicable)',

   'Correct Answer(s) (if applicable)'
=> 'Correct Answer(s) (if applicable)',

   'LON-CAPA messages sent to you between [_1] and [_2] will be inaccessible until the end of this time period, because you are a student in a course with an active communications block.'
=> 'LON-CAPA messages sent to you between [_1] and [_2] will be inaccessible until the end of this time period, because you are a student in a course with an active communications block.',

   'The subject is 

 [_1]

'
=> 'The subject is 

 [_1]

',

   'Excerpt'
=> 'Excerpt',

   'Use 

 [_1]

to access the full message.'
=> 'Use 

 [_1]

to access the full message.',

   'You can reply to this message'
=> 'You can reply to this message',

   'A reply will not be received by the recipient!'
=> 'A reply will not be received by the recipient!',

   "Include in course's 'User records' for recipient(s)"
=> "包括课程中的'用户记录'给收信人",

   'No replies to sender'
=> '没有答复发件人',

   'Display Message'
=> '显示邮件',

   'Replying to a Message'
=> '回复邮件',

   'Forwarding a Message'
=> '转发邮件',

   'Forwarding Multiple Messages'
=> '转发多封邮件',

   'At end of file some tags were still left unclosed, '
=> 'At end of file some tags were still left unclosed, ',

   'Upload and Send'
=> '上传和发送',

   'Choose which course(s) to list.'
=> 'Choose which course(s) to list.',

   'Display courses'
=> '显示课程',

   'Public'
=> '公开的',

   'Answer [_1]'
=> '答复 [_1]',

   'EditXML [_1]'
=> 'EditXML [_1]',

   'Not authorized'
=> '未授权',

   'An error occurred while processing this resource. The author has been notified.'
=> 'An error occurred while processing this resource. The author has been notified.',

   'Code ran too long. It ran for more than [_1] seconds.'
=> 'Code ran too long. It ran for more than [_1] seconds.',

   'This occurred while running &lt;while&gt; on line [_1].'
=> 'This occurred while running &lt;while&gt; on line [_1].',

   'This occurred while running: [_1]'
=> 'This occurred while running: [_1]',

   'Substitution on [_1] with [_2] caused:'
=> 'Substitution on [_1] with [_2] caused:',

   'Student View'
=> '学生视野',

   'Correct answer'
=> '正确答案',

   'Could not identify problem.'
=> '无法确定的问题。', # ???

   'Chart'
=> '图表',

   'Student Data'
=> '学生资料',

   'HTML, with links'
=> 'HTML格式，链接',

   'HTML, with all links'
=> 'HTML格式，与所有链接',

   'HTML, without links'
=> 'HTML格式，没有链接',

   'Output Data'
=> '输出数据',

   'Scores Summary'
=> '总分',

   'Scores Per Problem'
=> '每题分数',

   'Parts Correct'
=> 'Parts Correct',

   'fullname'
=> '全名',

   'id'
=> 'ID/学生证号',

   'Generate Chart'
=> '生成图表',

   'Generate Graph'
=> '生成图',

   'Select One Student'
=> '选择一个学生',

   'All sections.'
=> '所有科目。',

   'Section [_1].'
=> '章节 [_1]。',

   'Section [_1]'
=> '章节 [_1]',

   'Sections [_1] and [_2].'
=> '章节 [_1] 和 [_2]。',

   'All groups.'
=> '所有组。',

   'Group [_1].'
=> '组 [_1].',

   'Groups [_1] and [_2].'
=> '组 [_1] 和 [_2].',

   'Active access status.'
=> 'Active access status.',

   'Future access status.'
=> 'Future access status.',

   'Expired access status.'
=> 'Expired access status.',

   'Any access status.'
=> 'Any access status.',

   'Show links in new window:'
=> 'Show links in new window:',

   'Summary Table'
=> 'Summary Table',

   'Summary Tables'
=> 'Summary Tables',

   'Summary table for [_1] ([_2])'
=> 'Summary table for [_1] ([_2])',

   'Average'
=> 'Average',

   'maximum'
=> 'maximum',

   'Maximum'
=> 'Maximum',

   'Max. Total'
=> 'Max. Total',

   'Median'
=> 'Median',

   'Std Dev'
=> 'Std Dev',

   'sum'
=> 'sum',

   'maximum possible'
=> 'maximum possible',

   'parts correct'
=> 'parts correct',

   'Return to the chart'
=> 'Return to the chart',

   'Compiled on [_1]'
=> 'Compiled on [_1]',

   "Click on a student's name or username to view their chart"
=> "Click on a student's name or username to view their chart",

   'status'
=> '状态',

   'groups'
=> '组',

   'Click on a students name or username to view their chart'
=> 'Click on a students name or username to view their chart',

   'Essay will be hand graded.'
=> 'Essay will be hand graded.',

   'Text you want to appear by default:'
=> '文字在默认情况下显示：',

   'Check as many files as you wish in response to the problem:'
=> '选择所有的文件对于您想答复的问题：',

   'Select portfolio files'
=> '选择组合文件',

   'Select checked files, and continue selecting'
=> '选择文件并继续选择',

   'Select checked files, and close window'
=> '选择文件并关闭窗口',

   'Copy of'
=> 'Copy of',

   'The e-mail address you provided does not match the address recorded in the LON-CAPA system for the username and domain you provided.'
=> 'The e-mail address you provided does not match the address recorded in the LON-CAPA system for the username and domain you provided.',

   'Overall result: [_1]'
=> '总分： [_1]',

   'Dimension: [_1], status [_2] '
=> 'Dimension: [_1], status [_2] ',

   'Queue Status'
=> '队列状态',

   'Check Mark'
=> '核选标记',

   'Return commented version of [_1] to student.'
=> 'Return commented version of [_1] to student.',

   'Download All Submitted Documents'
=> 'Download All Submitted Documents',

   'Essay is [_1]% similar to an essay by [_2] in course [_3] (course id [_4]:[_5])'
=> 'Essay is [_1]% similar to an essay by [_2] in course [_3] (course id [_4]:[_5])',

   'Compose message to student'
=> 'Compose message to student',

   'incl. grades'
=> '包含评分',

   'Message will be sent when you click on Save &amp; Next below.'
=> 'Message will be sent when you click on Save &amp; Next below.',

   'Set/Change parameters'
=> 'Set/Change parameters',

   'Grading Feedback'
=> '评估反馈',

   'Sending message to [_1]'
=> '发送邮件至 [_1]',

   'Not allowed to modify grades for [_1]'
=> 'Not allowed to modify grades for [_1]',

   'You need to specify the username or ID'
=> 'You need to specify the username or ID',

   'You need to specify at least one grading field'
=> 'You need to specify at least one grading field',

   'Specify a file containing the class scores for current resource'
=> 'Specify a file containing the class scores for current resource',

   'Upload Scores'
=> '上传分数',

   'Some point values were assigned for problems with a weight of zero. These values were ignored.'
=> 'Some point values were assigned for problems with a weight of zero. These values were ignored.',

   'Use CODE:'
=> 'Use CODE:',

   'Some resources in the sequence currently are not set to exam mode. Grading these resources currently may not work correctly.'
=> 'Some resources in the sequence currently are not set to exam mode. Grading these resources currently may not work correctly.',

   'scores from file' # Upload scores from file
=> 'scores from file',

   'Process'
=> 'Process',

   'clicker file' # Process clicker file
=> 'clicker file',

   'Grade'
=> 'Grade',

   'bubblesheet forms'
=> 'bubblesheet forms',

   'Verify'
=> 'Verify',

   'receipt'
=> 'receipt',

   'Manage'
=> 'Manage',

   'saved CODEs' # View saved CODEs
=> 'saved CODEs',

   'Specify a file containing the clicker information for this resource'
=> 'Specify a file containing the clicker information for this resource',

   'Upload File'
=> '上传文件',

   'Award points just for participation'
=> 'Award points just for participation',

   'Correctness determined from response by course personnel'
=> 'Correctness determined from response by course personnel',

   'Correctness determined from response with clicker ID(s)'
=> 'Correctness determined from response with clicker ID(s)',

   'Percentage points for correct solution'
=> 'Percentage points for correct solution',

   'Percentage points for incorrect solution'
=> 'Percentage points for incorrect solution',

   'You need to specify a clicker ID for the correct answer'
=> 'You need to specify a clicker ID for the correct answer',

   'Score based on attendance only'
=> 'Score based on attendance only',

   'Correctness determined by the following IDs'
=> 'Correctness determined by the following IDs',

   'specified'
=> 'specified',

   'No IDs found to determine correct answer'
=> 'No IDs found to determine correct answer',

   'The file: [_1] you attempted to upload contained no information. Please check that you entered the correct filename.'
=> 'The file: [_1] you attempted to upload contained no information. Please check that you entered the correct filename.',

   'Scanning clicker file'
=> 'Scanning clicker file',

   'Found [_1] question(s)'
=> '[_1] Frage(n) gefunden',

   'Awarding [_1] percent for correct and [_2] percent for incorrect responses'
=> 'Awarding [_1] percent for correct and [_2] percent for incorrect responses',

   'Clicker registered more than once'
=> 'Clicker registered more than once',

   'Unregistered Clicker'
=> 'Unregistered Clicker',

   'Found [_1] registered and [_2] unregistered clickers.'
=> 'Found [_1] registered and [_2] unregistered clickers.',

   'Found no correct answers for grading!'
=> 'Found no correct answers for grading!',

   'Found [_1] entries for grading!'
=> 'Found [_1] entries for grading!',

   'Found no questions.'
=> 'Found no questions.',

   'Finalize Grading'
=> 'Finalize Grading',

   'Question [_1]'
=> 'Question [_1]',

   'Assigning grades based on clicker file'
=> 'Assigning grades based on clicker file',

   'More than one correct result given for question "[_1]": [_2] versus [_3].'
=> 'More than one correct result given for question "[_1]": [_2] versus [_3].',

   'No correct result given for question "[_1]"!'
=> 'No correct result given for question "[_1]"!',

   'Correct answer: [_1]'
=> '正确答案： [_1]',

   'Successfully stored grades for [_1] student(s).'
=> 'Successfully stored grades for [_1] student(s).',

   'Grading Menu'
=> '评估菜单',

   'Missing tags, unable to properly run file.'
=> 'Missing tags, unable to properly run file.',

   'Using tag [_1] on line [_2] as end tag to [_3]'
=> 'Using tag [_1] on line [_2] as end tag to [_3]', # ??? lonxml.pm [SB 2008-08-07]

   'Found tag [_1] on line [_2] when looking for [_3] in file.'
=> 'Found tag [_1] on line [_2] when looking for [_3] in file.',

   'ID [_1] contains invalid characters. IDs are only allowed to contain letters, numbers, spaces and -'
=> 'ID [_1] contains invalid characters. IDs are only allowed to contain letters, numbers, spaces and -',

   'File not found'
=> 'File not found',

   'This file appears to be a rendering of a LON-CAPA resource. If this is correct, this resource will act very oddly and incorrectly.'
=> 'This file appears to be a rendering of a LON-CAPA resource. If this is correct, this resource will act very oddly and incorrectly.', # ??? [SB 2007-11-27]

   'An error occurred while processing this resource. The instructor has been notified.'
=> 'An error occurred while processing this resource. The instructor has been notified.',

   'CourseID'
=> '课程编号',

   'DocID'
=> '文件编号',

   'Username, password and domain need to be specified.'
=> '用户名，密码和域必须指定！',

   'Untitled Resource'
=> '无名资源',

   'Not Available'
=> 'Not Available',

   'Clear'
=> 'Clear',

   'There are no parameters.'
=> 'There are no parameters.',

   'enroll type/action'
=> '注册类型/行动',

   'Map not loaded: The file [_1] does not exist.'
=> 'Map not loaded: The file [_1] does not exist.',

   'Saved.'
=> '保存的。',

   'An error occurred while saving.'
=> 'An error occurred while saving.',

   'Reverted.'
=> 'Reverted.',

   'Title in map'
=> 'Title in map',

   'Filename of resource'
=> 'Filename of resource',

   'Link to published resource'
=> 'Link to published resource',

   'Link to resource in Authoring Space'
=> 'Link to resource in Authoring Space',

   'Resource space'
=> 'Resource space',

   'discard'
=> 'discard',

   'Change Order'
=> 'Change Order',

   'Sort Imported Resources'
=> 'Sort Imported Resources',

   'Finalize order of resources'
=> 'Finalize order of resources',

   'Recover Deleted'
=> 'Recover Deleted',

   'Recover Removed Resources'
=> 'Recover Removed Resources',

   'Recover Checked'
=> 'Recover Checked',

   'Recent Detailed Assessment Statistical Data'
=> 'Recent Detailed Assessment Statistical Data',

   'No information available'
=> 'No information available',

   'Creating new file [_1]'
=> '创建新文件 [_1]',

   'If you would like to associate this resource ([_1]) with a current or previous course, please select one from the list below, otherwise select, "None".'
=> 'If you would like to associate this resource ([_1]) with a current or previous course, please select one from the list below, otherwise select, "None".',

    'Associate Resource With Selected Course'
=> 'Associate Resource With Selected Course',

   'This resource is currently associated with a course ([_1]) which includes added metadata fields specific to the course.'
=> 'This resource is currently associated with a course ([_1]) which includes added metadata fields specific to the course.',

   'You can choose to transfer data from the added fields to the "Notes" field if you are planning to change the course association.'
=> 'You can choose to transfer data from the added fields to the "Notes" field if you are planning to change the course association.',

   'not available'
=> 'not available',

   'most recent version'
=> 'most recent version',

   'information not available'
=> 'information not available',

   'Num Student'
=> 'Num Student',

   'Degree of Difficulty'
=> 'Degree of Difficulty',

   'Degree of Discrimination'
=> 'Degree of Discrimination',

   'Time of computation'
=> 'Time of computation',

   'Messages deleted.'
=> '邮件已删除。',

   'Error deleting messages'
=> 'Error deleting messages',

   'Messages cleared.'
=> '邮件已删除。',

   'Error clearing messages'
=> '删除邮件时发生错误',

   'Delete Messages for this Resource'
=> 'Delete Messages for this Resource',

   'Back To Directory'
=> '返回目录',

   'Associated with course [_1]'
=> 'Associated with course [_1]',

   'This resource is not associated with a course.'
=> 'This resource is not associated with a course.',

   'Discard Edits and Return to Portfolio'
=> 'Discard Edits and Return to Portfolio',

   'Could not transfer data in added fields to notes'
=> 'Could not transfer data in added fields to notes',

   'Transferred data in added fields to notes'
=> 'Transferred data in added fields to notes',

   'Home'
=> '根目录',

   'Usage Statistics'
=> '使用统计',

   'Courses/Network Hits'
=> '课程/网络访问次数',

   'Already in this course:'
=> 'Already in this course:',

   '[_1] in folder/map [_2]'
=> '[_1] in folder/map [_2]',

   'External Resource, preview not enabled'
=> 'External Resource, preview not enabled',

   'Somewhere something went wrong'
=> 'Somewhere something went wrong',

   'Please help us to find out what.'
=> 'Please help us to find out what.',

   'Please take a moment to fill out the form below.'
=> 'Please take a moment to fill out the form below.',

   'Your information, together with internal debugging information, will be emailed to the system and server administrators.'
=> 'Your information, together with internal debugging information, will be emailed to the system and server administrators.',

   'Send Information'
=> '发送错误报告',

   'Please describe what you did just before this screen came up'
=> 'Please describe what you did just before this screen came up',

   'Is this problem reproducible?'
=> 'Is this problem reproducible?',

   'Yes!'
=> '是！',

   'Do you have any guesses why this might have happened?'
=> '你有任何猜测，为什么会发生？',

   'Thank you for your help!'
=> '谢谢您的支持！',

   'Internal info:'
=> '内部信息：',

   'Report submitted'
=> '提交的报告',

   'Sending Error Report'
=> '发送错误报告',

   'Thank you!'
=> '谢谢您！',

   'Warning: Report not submitted'
=> '警告：报告未提交',

   'The administrators of the domain [_1] have not set any e-mail addresses for receipt of your error report.'
=> 'The administrators of the domain [_1] have not set any e-mail addresses for receipt of your error report.',

   'The document contains errors and cannot be published.'
=> 'The document contains errors and cannot be published.',

   'error(s)'
=> 'error(s)',

   '[quant,_1,error]'
=> '[quant,_1,error]',

   'Please fill out all fields below.'
=> '请填写以下所有问题。',

   'Caution: this folder is set to randomly pick a subset of resources. Adding or removing resources from this folder will change the set of resources that the students see, resulting in spurious or missing credit for completed problems, not limited to ones you modify. Do not modify the contents of this folder if it is in active student use.'
=> 'Caution: this folder is set to randomly pick a subset of resources. Adding or removing resources from this folder will change the set of resources that the students see, resulting in spurious or missing credit for completed problems, not limited to ones you modify. Do not modify the contents of this folder if it is in active student use.',

   'Caution: this folder is set to randomly order its contents. Adding or removing resources from this folder will change the order of resources shown.'
=> 'Caution: this folder is set to randomly order its contents. Adding or removing resources from this folder will change the order of resources shown.',

   'Parameters'
=> '参数',

   'Parameters:'
=> '参数：',

   'Total Score and Maximum Possible for each Sequence or Folder'
=> 'Total Score and Maximum Possible for each Sequence or Folder',

   'Score on each Problem Part'
=> 'Score on each Problem Part',

   'Number of Tries before success on each Problem Part'
=> 'Number of Tries before success on each Problem Part',

   'Number of Problem Parts completed successfully'
=> 'Number of Problem Parts completed successfully',

   'Unable to retrieve course information.'
=> 'Unable to retrieve course information.',

   'Please select an action to perform using the new filename'
=> 'Please select an action to perform using the new filename',

   'View or modify a course'
=> '查看或修改课程',

   'Enter the course with the role of [_1]'
=> 'Enter the course with the role of [_1]',

   'Enter the course with the role of [_1].'
=> 'Enter the course with the role of [_1].',

   'View or modify course settings which only a [_1] may modify.'
=> 'View or modify course settings which only a [_1] may modify.',

   'Manage course users'
=> '管理课程参加者',

   'Upload a File of Course Users'
=> '课程用户上传文件',

   'Add/Modify a Course User'
=> '添加/修改课程用户',

   'Edit Custom Roles'
=> '编辑自定义角色',

   'Custom Role'
=> '自定义角色',

   'Enroll a Single Student'
=> '注册一名学生',

   'Enroll a student'
=> '注册学生',

   'Manage Course Groups'
=> '管理课程组',

   'This error occurred while processing response [_1] in part [_2]'
=> 'This error occurred while processing response [_1] in part [_2]',

   'This error occurred while processing part [_1]'
=> 'This error occurred while processing part [_1]',

   'Unable to find section for this student'
=> 'Unable to find section for this student',

   'Classlist update for "[_1]" in "[_2]".'
=> 'Classlist update for "[_1]" in "[_2]".',

   'Error: "[_1]" during classlist update for "[_2]" in "[_3]".'
=> 'Error: "[_1]" during classlist update for "[_2]" in "[_3]".',

   'Role: '
=> '角色： ',

   'Identify fields in uploaded list'
=> 'Identify fields in uploaded list',

   'Default domain'
=> '默认域',

   'Change authentication for existing users in domain "[_1]" to these settings?'
=> 'Change authentication for existing users in domain "[_1]" to these settings?',

   'LON-CAPA Home Server for New Users'
=> 'LON-CAPA 家庭服务器的新用户',

   'LON-CAPA domain: [_1] with home server:'
=> 'LON-CAPA 域 [_1] 与家庭服务器：',

   'Settings for assigning roles'
=> 'Settings for assigning roles',

   'Pick the action to take on roles for these users:'
=> 'Pick the action to take on roles for these users:',

   'No role changes'
=> 'No role changes',

   'Add a domain role'
=> 'Add a domain role',

   'Add a course role'
=> 'Add a course role',

   'Default role'
=> 'Default role',

   'Choose the role to assign to users without a value specified in the uploaded file.'
=> 'Choose the role to assign to users without a value specified in the uploaded file.',

   'Default role and section'
=> 'Default role and section',

   'Choose the role and/or section(s) to assign to users without values specified in the uploaded file.'
=> 'Choose the role and/or section(s) to assign to users without values specified in the uploaded file.',

   'Default role and/or section(s)'
=> 'Default role and/or section(s)',

   'Role and/or section(s) for users without values specified in the uploaded file.'
=> 'Role and/or section(s) for users without values specified in the uploaded file.',

   'Display students with current/future access who are not in the uploaded file.'
=> 'Display students with current/future access who are not in the uploaded file.',

   'Students selected from this list can be dropped.'
=> 'Students selected from this list can be dropped.',

   'Update Student/Employee ID in courses in which user is active/future student,[_1](if forcing change).'
=> 'Update Student/Employee ID in courses in which user is active/future student,[_1](if forcing change).',

   'make these dates the default access dates for future student enrollment'
=> 'make these dates the default access dates for future student enrollment',

   'Set default start and end access dates for course.'
=> 'Set default start and end access dates for course.',

   'Unable to set default access dates for course.'
=> 'Unable to set default access dates for course.',

   'Please select'
=> 'Please select',

   'User Status: [_1]'
=> '用户状态： [_1]',

   'Role Type: [_1]'
=> '角色类别： [_1]',

   'Any role'
=> '任意角色',

   'Role: [_1]'
=> '角色： [_1]',

   'Select Course(s)'
=> '选择课程',

   'Warning: data retrieval for multiple courses can take considerable time, as this operation is not currently optimized.'
=> 'Warning: data retrieval for multiple courses can take considerable time, as this operation is not currently optimized.',

   'There are no co-authors to display.'
=> 'There are no co-authors to display.',

   'There are no users with domain roles to display.'
=> 'There are no users with domain roles to display.',

   'There are no authors or co-authors to display.'
=> 'There are no authors or co-authors to display.',

   'There are no course users to display'
=> 'There are no course users to display',

   'There are no course users to display.'
=> 'There are no course users to display.',

   'There are no users matching the search criteria.'
=> 'There are no users matching the search criteria.',

   "You must select at least one user by checking a user's 'Select' checkbox"
=> "You must select at least one user by checking a user's 'Select' checkbox",

   'You need to select an action to take for the user(s) you have selected'
=> 'You need to select an action to take for the user(s) you have selected',

   ' for a single user?'
=> ' for a single user?',

   ' for multiple users?'
=> ' for multiple users?',

   'Proceed'
=> '下一步',

   'Action to take for selected users'
=> 'Action to take for selected users',

   'Behavior of clickable username link for each user'
=> 'Behavior of clickable username link for each user',

   "Display a user's personal page"
=> "显示个人网页",

   "Modify a user's information"
=> "Modify a user's information",

   'Course(s): description, section(s), status'
=> 'Course(s): description, section(s), status',

   "Click on a username to view the user's personal page."
=> "点击用户名，以查看用户的个人网页。",

   'auto'
=> '自动',

   'manual'
=> '手动',

   'Unlock'
=> 'Unlock',

   'Lock'
=> 'Lock',

   'Domain Roles'
=> '域角色',

   'Co-Author Roles'
=> '合著者角色',

   'Course Roles'
=> '课程角色',

   'Date and Section selector'
=> '日期和组选择',

   'Date selector'
=> '日期选择器',

   "Check the boxes for any users for whom roles are to be revoked, and click 'Proceed'"
=> "Check the boxes for any users for whom roles are to be revoked, and click 'Proceed'",

   "Check the boxes for any users for whom roles are to be deleted, and click 'Proceed'"
=> "Check the boxes for any users for whom roles are to be deleted, and click 'Proceed'",

   'Choose an action to take for selected users'
=> 'Choose an action to take for selected users',

   'New section to assign'
=> 'New section to assign',

   'Use "Save" to update the main window with your selections.'
=> 'Use "Save" to update the main window with your selections.',

   'New section'
=> '新的章节',

   'Course - [_1]:'
=> '课程 - [_1]：',

   'Domain - [_1]:'
=> '域 - [_1]：',

   'Users in course with expired [_1] roles'
=> 'Users in course with expired [_1] roles',

   'Users in course with future [_1] roles'
=> 'Users in course with future [_1] roles',

   'Users in course with active [_1] roles'
=> 'Users in course with active [_1] roles',

   'All users in course'
=> 'All users in course',

   'All users in course with [_1] roles'
=> 'All users in course with [_1] roles',

   'only users in section "[_1]"'
=> 'only users in section "[_1]"',

   'only users affiliated with no section or section "[_1]"'
=> 'only users affiliated with no section or section "[_1]"',

   ' and not in any group'
=> ' and not in any group',

   ' and members of group: "[_1]"'
=> ' and members of group: "[_1]"',

   'only users affiliated with no section'
=> 'only users affiliated with no section',

   'only users affiliated with section "[_1]"'
=> 'only users affiliated with section "[_1]"',

   'only users not in any group'
=> 'only users not in any group',

   ' and also not in any group'
=> ' and also not in any group',

   'only members of group: "[_1]"'
=> '只有该组成员 "[_1]"',

   ' and also members of group: "[_1]"'
=> ' and also members of group: "[_1]"',

   'Author space for [_1]'
=> 'Author space for [_1]',

   'Co-authors with expired [_1] roles'
=> 'Co-authors with expired [_1] roles',

   'Co-authors with future [_1] roles'
=> 'Co-authors with future [_1] roles',

   'Co-authors with active [_1] roles'
=> 'Co-authors with active [_1] roles',

   'All co-authors'
=> '所有合著者',

   'All co-authors with [_1] roles'
=> 'All co-authors with [_1] roles',

   'Users in domain with expired [_1] roles'
=> 'Users in domain with expired [_1] roles',

   'Users in domain with future [_1] roles'
=> 'Users in domain with future [_1] roles',

   'Users in domain with active [_1] roles'
=> 'Users in domain with active [_1] roles',

   'All users in domain'
=> 'All users in domain',

   'All users in domain with [_1] roles'
=> 'All users in domain with [_1] roles',

   'Co-authors in domain with expired [_1] roles'
=> 'Co-authors in domain with expired [_1] roles',

   'Co-authors in domain with future [_1] roles'
=> 'Co-authors in domain with future [_1] roles',

   'Co-authors in domain with active [_1] roles'
=> 'Co-authors in domain with active [_1] roles',

   'All users with co-author roles in domain'
=> 'All users with co-author roles in domain',

   'All co-authors in domain  with [_1] roles'
=> 'All co-authors in domain  with [_1] roles',

   'All courses in domain'
=> 'All courses in domain',

   'Courses in domain with institutional code: [_1]'
=> 'Courses in domain with institutional code: [_1]',

   'Selected courses in domain'
=> 'Selected courses in domain',

   'users with expired [_1] roles'
=> 'users with expired [_1] roles',

   'users with future [_1] roles'
=> 'users with future [_1] roles',

   'users with active [_1] roles'
=> 'users with active [_1] roles',

   'all users'
=> '所有用户',

   'users with [_1] roles'
=> '用户角色"[_1]"',

   'There are no students to drop.'
=> 'There are no students to drop.',

   'Upload a file containing information about users'
=> '上传一个包含有用户信息的文件',

   'Upload file of users'
=> '上传用户文件',

   'How do I create a users list from a spreadsheet'
=> '如何从电子表格建立用户列表',

   'Unable to enroll users'
=> '无法注册用户',

   'Enrolling Users'
=> '注册用户',

   'Updating Co-authors'
=> '更新共同作者',

   'Adding/Modifying Users'
=> '添加/修改用户',

   'Default section name [_1] could not be used as it is a reserved word.'
=> 'Default section name [_1] could not be used as it is a reserved word.',

   'Default section name "[_1]" is the name of a course group. Section names and group names must be distinct.'
=> 'Default section name "[_1]" is the name of a course group. Section names and group names must be distinct.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a reserved word.'
=> '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a reserved word.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a course group.'
=> '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a course group.',

   'Section names and group names must be distinct.'
=> 'Section names and group names must be distinct.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]".'
=> '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]".',

   'This user already has an active/future student role in the course, unaffiliated to any section.'
=> 'This user already has an active/future student role in the course, unaffiliated to any section.',

   'This user already has an active/future role in section "[_1]" of the course.'
=> 'This user already has an active/future role in section "[_1]" of the course.',

   'Although your current role has privileges to add students to section "[_1]", you do not have privileges to modify existing enrollments in other sections.'
=> 'Although your current role has privileges to add students to section "[_1]", you do not have privileges to modify existing enrollments in other sections.',

   '[_1]: You do not have permission to add the requested role [_2] for the user.'
=> '[_1]: You do not have permission to add the requested role [_2] for the user.',

   'Allowable role(s) is/are: [_1].'
=> 'Allowable role(s) is/are: [_1].',

   '[_1]: Unable to enroll. No password specified.'
=> '[_1]: Unable to enroll. No password specified.',

   '[_1]: Unable to add co-author. No password specified.'
=> '[_1]: Unable to add co-author. No password specified.',

   '[_1]: Unable to add user. No password specified.'
=> '[_1]: Unable to add user. No password specified.',

   'Processed [quant,_1,user].'
=> 'Processed [quant,_1,user].',

   'Roles added for [quant,_1,user].'
=> 'Roles added for [quant,_1,user].',

   'If a user is currently logged-in to LON-CAPA, any new roles which are active will be available when the user next logs in.'
=> 'If a user is currently logged-in to LON-CAPA, any new roles which are active will be available when the user next logs in.',

   'No roles added'
=> 'No roles added',

   'Authentication changed for [_1] existing users.'
=> 'Authentication changed for [_1] existing users.',

   'Students to Drop'
=> 'Students to Drop',

   'There are no students with current/future access to the course.'
=> 'There are no students with current/future access to the course.',

   '[_1]: Unable to add/modify: [_2]'
=> '[_1]: Unable to add/modify: [_2]',

   '[_1]: Unable to modify authentication: [_2]'
=> '[_1]: Unable to modify authentication: [_2]',

   '[_1]: Unable to add role: [_2]'
=> '[_1]: Unable to add role: [_2]',

   'No change in section assignment (none)'
=> 'No change in section assignment (none)',

   "Revoked role of '[_1]' in [_2] for [_3]"
=> "Revoked role of '[_1]' in [_2] for [_3]",

   "Deleted role of '[_1]' in [_2] for [_3]"
=> "Deleted role of '[_1]' in [_2] for [_3]",

   "Re-enabled role of '[_1]' in [_2] for [_3]"
=> "Re-enabled role of '[_1]' in [_2] for [_3]",

   "Activated role of '[_1]' in [_2] for [_3]"
=> "Activated role of '[_1]' in [_2] for [_3]",

   "Changed Access Dates for role of '[_1]' in [_2] for [_3]"
=> "Changed Access Dates for role of '[_1]' in [_2] for [_3]",

   "Changed section for role of '[_1]' in [_2] for [_3]"
=> "Changed section for role of '[_1]' in [_2] for [_3]",

   "Dropped role of '[_1]' in [_2] for [_3]"
=> "Dropped role of '[_1]' in [_2] for [_3]",

   'Error revoking [_1] in [_2] for [_3]: [_4].'
=> 'Error revoking [_1] in [_2] for [_3]: [_4].',

   'Error deleting [_1] in [_2] for [_3]: [_4].'
=> 'Error deleting [_1] in [_2] for [_3]: [_4].',

   'Error re-enabling [_1] in [_2] for [_3]: [_4].'
=> 'Error re-enabling [_1] in [_2] for [_3]: [_4].',

   'Error activating [_1] in [_2] for [_3]: [_4].'
=> 'Error activating [_1] in [_2] for [_3]: [_4].',

   'Error changing access dates for [_1] in [_2] for [_3]: [_4].'
=> 'Error changing access dates for [_1] in [_2] for [_3]: [_4].',

   'Error changing section for [_1] in [_2] for [_3]: [_4].'
=> 'Error changing section for [_1] in [_2] for [_3]: [_4].',

   'Error dropping [_1] in [_2] for [_3]: [_4].'
=> 'Error dropping [_1] in [_2] for [_3]: [_4].',

   'Revoked role(s) for [quant,_1,user,users,no users].'
=> 'Revoked role(s) for [quant,_1,user,users,no users].',

   'Deleted role(s) for [quant,_1,user,users,no users].'
=> 'Deleted role(s) for [quant,_1,user,users,no users].',

   'Re-enabled role(s) for [quant,_1,user,users,no users].'
=> 'Re-enabled role(s) for [quant,_1,user,users,no users].',

   'Activated role(s) for [quant,_1,user,users,no users].'
=> 'Activated role(s) for [quant,_1,user,users,no users].',

   'Changed Access Dates for role(s) for [quant,_1,user,users,no users].'
=> 'Changed Access Dates for role(s) for [quant,_1,user,users,no users].',

   'Changed section for role(s) for [quant,_1,user,users,no users].'
=> 'Changed section for role(s) for [quant,_1,user,users,no users].',

   'Dropped role(s) for [quant,_1,user,users,no users].'
=> 'Dropped role(s) for [quant,_1,user,users,no users].',

   'Re-enabling will re-activate data for the role.'
=> 'Re-enabling will re-activate data for the role.',

   'Display User Lists'
=> 'Display User Lists',

   'Display current class roster'
=> 'Display current class roster',

   'No section'
=> 'No section',

   'List Users'
=> '用户列表',

   'Pick custom role'
=> '选择自定义角色',

   'Advanced Role'
=> '扩展的角色',

   "Create User Notes, Display all User's Notes, Face-to-Face, Critical Messages, Broadcast Messages"
=> "Create User Notes, Display all User's Notes, Face-to-Face, Critical Messages, Broadcast Messages",

   'Evade communication blocking'
=> 'Evade communication blocking',

   'Generate anonymous statistics'
=> 'Generate anonymous statistics',

   'Modify grade queue'
=> 'Modify grade queue',

   'Grade items in grading queue'
=> 'Grade items in grading queue',

   'Set assessment parameters'
=> 'Set assessment parameters',

   'Advanced printing options (with answers, discussions, all foils, ...)'
=> 'Advanced printing options (with answers, discussions, all foils, ...)',

   'Print for other users and entire course'
=> 'Print for other users and entire course',

   'Get identity behind anonymous postings'
=> 'Get identity behind anonymous postings',

   'View grades'
=> 'View grades',

   "Access to What's New page"
=> "进入新页",

   'Upload Users List'
=> '上传用户列表',

   'Update Users'
=> '用户更新',

   'Create/modify a user'
=> '创建/修改用户',

   'Search for a user and modify/add user information or roles'
=> '搜索用户和修改/添加用户资料或角色',

   'Add/modify a single user'
=> '添加/修改一个用户',

   'Create users or modify the roles and privileges of users'
=> '创建或修改用户的角色和权限',

   'Upload a File of Users'
=> '上传用户文件',

   'Add/Modify a User'
=> '添加/修改用户',

   'create new user if required'
=> '如有必要，创建新用户',

   'Manage Users'
=> '管理用户',

   'Create/Modify user'
=> '创建/修改用户',

   'Visible input'
=> '可见输入',

   'Currently in use'
=> '目前正在使用',

   'Modify this user: [_1]'
=> '改此用户名： [_1]',

   'Blank Problem'
=> '空白问题',

   'Chemical Reaction Response'
=> '化学反应',

   'Chemical Reaction Response with Hints'
=> 'Chemical Reaction Response with Hints', # '化学反应',

   'Click-On-Image Problem'
=> '点击图片',

   'Curve Plot with Numerical Response'
=> 'Curve Plot with Numerical Response',

   'Custom Response'
=> 'Custom Response',

   'Custom Response with Partial Credit'
=> 'Custom Response with Partial Credit',

   'Data Plot with Numerical Response'
=> 'Data Plot with Numerical Response',

   'Essay Response'
=> '尝试回答',

   'Exam Upload Resource'
=> 'Exam Upload Resource',

   'Formula Response using Computer Algebra System'
=> 'Formula Response using Computer Algebra System',

   'Formula Response using Computer Algebra System and Hints'
=> 'Formula Response using Computer Algebra System and Hints',

   'Formula Response using Computer Algebra System R and Data Plot'
=> 'Formula Response using Computer Algebra System R and Data Plot',

   'Formula Response with Samples'
=> 'Formula Response with Samples',

   'Unordered Multi-Answer Formula Response Problem'
=> 'Unordered Multi-Answer Formula Response Problem',

   'Math Response using Computer Algebra System MAXIMA'
=> 'Math Response using Computer Algebra System MAXIMA',

   'Math Response using Computer Algebra System R'
=> 'Math Response using Computer Algebra System R',

   'Math Response using Computer Algebra System and Hints'
=> 'Math Response using Computer Algebra System and Hints',

   'Numerical Response'
=> 'Numerical Response',

   'One of Multiple Answers Numerical Problem'
=> 'One of Multiple Answers Numerical Problem',

   'Option Response - Matching'
=> 'Option Response - Matching',

   'Option Response - Concept Groups'
=> 'Option Response - Concept Groups',

   'Matching Response'
=> 'Matching Response',

   'Option Response - True/False'
=> 'Option Response - True/False',

   'Organic Material Response'
=> 'Organic Material Response',

   'Organic Material Response with Hint'
=> 'Organic Material Response with Hint',

   'Radio Button Response'
=> '单选',

   'Randomly Labelled Image with Option Response'
=> 'Randomly Labelled Image with Option Response',

   'Rank Response'
=> '等级制度 (Rank Response)',

   'String Response'
=> '文本输入 (String Response)',

   'Display catalog of courses and communities'
=> '课程目录',

   'Manage co-authors'
=> '管理共同作者',

   'Upload a File of Co-authors'
=> '上传共同作者的文件',

   'Add/Modify a Co-author'
=> '添加/修改一个共同的作者',

   'Manage Co-authors'
=> '管理共同作者',

   'No courses match the criteria you selected.'
=> '没有选择相对应的课程。',

   'Key authority (<tt>id@domain</tt>) if other than course'
=> 'Key authority (<tt>id@domain</tt>) if other than course',

   'New bridgetask file'
=> 'New bridgetask file',

   'Create problem'
=> '创建问题',

   'Create library'
=> '创建图书馆',

   'Create survey'
=> '创建调查',

   'Create task'
=> '创建任务',

   'Problem Testing'
=> '问题测试',

   "Don't Show Incorrect/Correct Feedback"
=> "不显示不正确/正确的反馈",

   "Don't Show Any Feedback"
=> "不显示任何反馈",

   'Change View'
=> '更改视图',

   'Show Default View'
=> '查看默认视图',

   '[_1] for [_2] versions.'
=> '[_1] 的 [_2] 版本。',

   'Set new preferred languages to '
=> '首选语言设置为 ',

   'Reset preferred language.'
=> '重设的首选语言。',

   'Set new preferred math display to '
=> 'Set new preferred math display to ',

   'Reset preferred math display.'
=> 'Reset preferred math display.',

   'Set new screenname to '
=> '在匿名讨论中新的昵称为 ',

   'Reset screenname.'
=> '重置昵称。',

   'Set new nickname to '
=> '设置新的昵称为 ',

   'Reset nickname.'
=> '重设昵称。',

   'Set menu mode to [_1].'
=> '设置菜单模式为 [_1]。',

   'Reset '
=> '重置',

   'Set message forwarding to '
=> '设置邮件转发到 ',

   "Set message forwarding to 'off'."
=> "设置邮件转发为'关闭'。",

   'Set non-critical message notification address(es) to '
=> '设置非重要的邮件通知地址为 ',

   "Set non-critical message notification to 'off'."
=> "设置非重要的邮件通知为'关闭'。",

   'Set critical message notification address(es) to '
=> '设置重要的邮件通知地址为 ',

   "Set critical message notification to 'off'."
=> "设置重要的邮件通知为'关闭'。",

   'Set address(es) to receive excerpts with html retained '
=> '设置保留HTML摘录的地址为 ',

   'Set notification address to receive excerpts with html stripped.'
=> '设置接收邮件地址为不保留的HTML摘录。',

   'Set all notification addresses to receive excerpts with html stripped.'
=> '设置所有的接收邮件地址为不保留的HTML摘录。',

   'Set Page Background to '
=> '设置页面的背景为 ',

   'Set Header Background to '
=> '设置页眉背景为 ',

   'Set Header Border to '
=> '设置页眉边界为 ',

   'Set Font to '
=> '设置字体为 ',

   'Set Un-Visited Link to '
=> '设置未访问链接颜色为 ',

   'Set Visited Link to '
=> '设置已访问链接颜色为 ',

   'Set Active Link to '
=> '设置活动链接颜色为 ',

   'Reset Page Background'
=> '重设网页背景',

   'Reset Header Background'
=> '重置页眉背景',

   'Reset Header Border'
=> '重置页眉边界',

   'Reset Font.'
=> '重置字体颜色。',

   'Reset Un-Visited Link.'
=> '重置未访问链接颜色。',

   'Reset Visited Link.'
=> '重置已访问链接颜色。',

   'Reset Active Link.'
=> '重置活动链接颜色。',

   'Freezing Role: [_1]'
=> '冻结的角色： [_1]',

   'Unfreezing Role: [_1]'
=> '解冻的角色： [_1] reversed',

   'No such user: '
=> '此用户不存在： ',

   'Sorry, the URL you provided to complete the reset of your password was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid. Please submit a [_1]new request[_2] for a password reset, and follow the link to the new URL included in the e-mail that will be sent to you, to allow you to enter a new password.'
=> 'Sorry, the URL you provided to complete the reset of your password was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid. Please submit a [_1]new request[_2] for a password reset, and follow the link to the new URL included in the e-mail that will be sent to you, to allow you to enter a new password.',

   'Sorry, the token generated when you requested a password reset has expired.'
=> 'Sorry, the token generated when you requested a password reset has expired.',

   'Sorry, the URL generated when you requested reset of your password contained incomplete information.'
=> 'Sorry, the URL generated when you requested reset of your password contained incomplete information.',

   'Page requested in unexpected context'
=> 'Page requested in unexpected context',

   'Invalid username and/or domain'
=> 'Invalid username and/or domain',

   'Username and domain were blank'
=> 'Username and domain were blank',

   'Authentication type for this user can not be changed by this mechanism'
=> 'Authentication type for this user can not be changed by this mechanism',

   'One or more password fields were blank'
=> 'One or more password fields were blank',

   'Please log out and try again.'
=> 'Please log out and try again.',

   'Please try again later.'
=> 'Please try again later.',

   'Unable to retrieve saved token for password decryption'
=> 'Unable to retrieve saved token for password decryption',

   'Could not verify current authentication.'
=> 'Could not verify current authentication.',

   'The new passwords you entered do not match.'
=> 'The new passwords you entered do not match.',

   'Passwords must be a minimum of 7 characters long.'
=> 'Passwords must be a minimum of 7 characters long.',

   'The password you entered contained illegal characters.'
=> 'The password you entered contained illegal characters.',

   'Valid characters are'
=> 'Valid characters are',

   'The password for [_1] was successfully changed.'
=> '[_1] 的密码已成功更改。',

   'The password for [_1] was not changed.'
=> 'The password for [_1] was not changed.',

   'In discussions: only new posts will be displayed.'
=> 'In discussions: only new posts will be displayed.',

   'In discussions: all posts will be displayed.'
=> 'In discussions: all posts will be displayed.',

   'In discussions: new posts will cease to be identified as "NEW" after display.'
=> 'In discussions: new posts will cease to be identified as "NEW" after display.',

   'In discussions: posts will be identified as "NEW" until marked as not "NEW".'
=> 'In discussions: posts will be identified as "NEW" until marked as not "NEW".',

   'The e-mail address entered in row '
=> '电子邮件地址输入行 ',

   'The e-mail address you entered'
=> '您输入的电子邮件地址',

   'is not a valid e-mail address'
=> '不是一个有效的电子邮件地址',

   'Title for the Uploaded Score'
=> 'Title for the Uploaded Score',

   'Title for the Page'
=> '标题页',

   'Title for the Problem'
=> '问题的标题',

   'Title for the Drop Box'
=> 'Title for the Drop Box',

   'Title for the Discussion Board'
=> '公告栏的标题',

   'Not a valid user:domain'
=> '不是有效的用户：域',

   'Please enter both user and domain in the format user:domain'
=> '请输入用户和域，格式为 用户：域',

   'Personal Information Page of '
=> 'Personal Information Page of ',

   'No info'
=> 'No info',

   'No user information available'
=> 'No user information available',

   'The new directory name was changed from [_1] to [_2].'
=> 'The new directory name was changed from [_1] to [_2].',

   'Unable to create a directory named'
=> 'Unable to create a directory named',

   'A file or directory by that name already exists.'
=> 'A file or directory by that name already exists.',

   'Allowing others to retrieve file: [_1]'
=> 'Allowing others to retrieve file: [_1]',

   'Access to this file by others can be set to be one or more of the following types: public, passphrase-protected or conditional.'
=> 'Access to this file by others can be set to be one or more of the following types: public, passphrase-protected or conditional.',

   'Public files are available to anyone without the need for login.'
=> 'Public files are available to anyone without the need for login.',

   'Passphrase-protected files do not require log-in, but will require the viewer to enter the passphrase you set.'
=> 'Passphrase-protected files do not require log-in, but will require the viewer to enter the passphrase you set.',

   'A listing of files viewable without log-in is available at: '
=> 'A listing of files viewable without log-in is available at: ',

   "For logged in users a 'Display file listing' link will also appear (when there are viewable files) on your personal information page:"
=> "For logged in users a 'Display file listing' link will also appear (when there are viewable files) on your personal information page:",

   "Users with privileges to edit course contents may add a course information page to a course using the 'Course Info' button in DOCS"
=> "Users with privileges to edit course contents may add a course information page to a course using the 'Course Info' button in DOCS",

   'Conditional access controls for file: [_1]'
=> 'Conditional access controls for file: [_1]',

   'Help on setting up share access'
=> 'Help on setting up share access',

   'Help on changing settings'
=> 'Help on changing settings',

   'Help on removing share access'
=> 'Help on removing share access',

   'Public access: [_1]'
=> 'Public access: [_1]',

   'Dates available'
=> '能够使用的日期',

   'Passphrase-protected access: [_1]'
=> 'Passphrase-protected access: [_1]',

   'Passphrase'
=> 'Passphrase',

   'Conditional access: [_1]'
=> 'Conditional access: [_1]',

   'You have previously set [_1] conditional access controls.'
=> 'You have previously set [_1] conditional access controls.',

   'Change Conditions'
=> 'Change Conditions',

   'Add conditional access'
=> 'Add conditional access',

   'based on domain, username, or course affiliation.'
=> 'based on domain, username, or course affiliation.',

   '[_1]-based conditional access: '
=> '[_1]-based conditional access: ',

   'conditions'
=> 'conditions',

   'condition'
=> 'condition',

   'Action?'
=> 'Action?',

   'Allowed [_1] member affiliations'
=> 'Allowed [_1] member affiliations', # ???

   'No [_1]-based conditions defined.'
=> 'No [_1]-based conditions defined.',

   'Type of change'
=> 'Type of change',

   'Access control'
=> 'Access control',

   'Additional information'
=> 'Additional information',

   'A problem occurred deleting access controls: [_1]'
=> 'A problem occurred deleting access controls: [_1]',

   'A problem occurred saving access control settings: [_1]'
=> 'A problem occurred saving access control settings: [_1]',

   'opened folder'
=> 'opened folder',

   'closed folder'
=> 'closed folder',

   'Passphrase-protected'
=> '密码保护',

   'Conditional'
=> 'Conditional',

   'An error occurred ([_1]) while trying to delete [_2].'
=> 'An error occurred ([_1]) while trying to delete [_2].',

   'File: [_1] deleted.'
=> '文件 [_1] 已删除。',

   'An error occurred ([_1]) while trying to delete access controls for the file.'
=> 'An error occurred ([_1]) while trying to delete access controls for the file.',

   'Access controls also deleted for the file.'
=> 'Access controls also deleted for the file.',

   'Error: no valid filename was provided to rename to.'
=> 'Error: no valid filename was provided to rename to.',

   'An error occurred ([_1]) while trying to rename [_2] to [_3]'
=> 'An error occurred ([_1]) while trying to rename [_2] to [_3]',

   'The new filename was changed from:<br />[_1] to [_2]'
=> 'The new filename was changed from:<br />[_1] to [_2]',

   'An error occurred ([_1]) while trying to delete access control records for the old name.'
=> 'An error occurred ([_1]) while trying to delete access control records for the old name.',

   'An error occurred ([_1]) while trying to upload [_2].'
=> 'An error occurred ([_1]) while trying to upload [_2].',

   'An error occurred (dir) ([_1]) while trying to delete [_2].'
=> 'An error occurred (dir) ([_1]) while trying to delete [_2].',

   'An error occurred ([_1]) while trying to upload [_2] for embedded element [_3].'
=> 'An error occurred ([_1]) while trying to upload [_2] for embedded element [_3].',

   'An error occurred ([_1]) while trying to create a new directory [_2].'
=> 'An error occurred ([_1]) while trying to create a new directory [_2].',

   'Access controls updated to reflect the name change.'
=> 'Access controls updated to reflect the name change.',

   'Conditional files are accessible to logged-in users with accounts in the LON-CAPA network, who satisfy the conditions you set.'
=> 'Conditional files are accessible to logged-in users with accounts in the LON-CAPA network, who satisfy the conditions you set.',

   'The conditions can include affiliation with a particular course, or a user account in a specific domain.'
=> 'The conditions can include affiliation with a particular course, or a user account in a specific domain.',

   'Alternatively access can be granted to people with specific LON-CAPA usernames and domains.'
=> 'Alternatively access can be granted to people with specific LON-CAPA usernames and domains.',

   'Current access controls defined for this file:'
=> 'Current access controls defined for this file:',

   'No access control settings currently exist for this file.'
=> 'No access control settings currently exist for this file.',

   'Deleted'
=> 'Deleted',

   'No end date'
=> '无结束日期',

   'Start: '
=> '开始： ',

   'End: '
=> '结束： ',

   'Domains: '
=> '域： ',

   'Users: '
=> '用户： ',

   'New control(s) added'
=> 'New control(s) added',

   'Existing control(s) deleted'
=> 'Existing control(s) deleted',

   'Existing control(s) modified'
=> 'Existing control(s) modified',

   'Add new <b>[_1]-based</b> access control for portfolio file: <b>[_2]</b>'
=> 'Add new <b>[_1]-based</b> access control for portfolio file: <b>[_2]</b>',

   'Display all access settings for this file'
=> 'Display all access settings for this file',

   'Add a roles-based condition'
=> 'Add a roles-based condition',

   'New role-based condition'
=> 'New role-based condition',

   "Format for users' username:domain information:"
=> "Format for users' username:domain information:", # ??? -> portfolio.pm

   'Add new [_1] condition(s)?'
=> 'Add new [_1] condition(s)?',

   'Number to add: '
=> 'Number to add: ',

   'Select roles, course status, section(s) and group(s) for users who will be able to access the portfolio file.'
=> 'Select roles, course status, section(s) and group(s) for users who will be able to access the portfolio file.',

   'Course status'
=> 'Course status', # '[_1] 状态',

   'Files selected from other directories:'
=> 'Files selected from other directories:',

   'Unable to upload [_1]. (size = [_2] kilobytes). Disk quota will be exceeded.'
=> 'Unable to upload [_1]. (size = [_2] kilobytes). Disk quota will be exceeded.',

   'Unable to upload [_1]. A locked file by that name was found in [_2].'
=> 'Unable to upload [_1]. A locked file by that name was found in [_2].',

   'You will be able to rename or delete existing [_1] after a grade has been assigned.'
=> 'You will be able to rename or delete existing [_1] after a grade has been assigned.',

   'Unable to upload [_1]. A file by that name was found in [_2].'
=> 'Unable to upload [_1]. A file by that name was found in [_2].',

   'To upload, rename or delete existing [_1] in [_2].'
=> 'To upload, rename or delete existing [_1] in [_2].', # ???

   'Rename [_1] to [_2]?'
=> 'Rename [_1] to [_2]?',

   'Reference Warning'
=> 'Reference Warning',

   'Completed upload of the file. This file contained references to other files. You must upload the referenced files or else the uploaded file may not work properly.'
=> 'Completed upload of the file. This file contained references to other files. You must upload the referenced files or else the uploaded file may not work properly.',

   'Please select the locations from which the referenced files are to be uploaded.'
=> 'Please select the locations from which the referenced files are to be uploaded.',

   'Delete [_1]?'
=> '删除 [_1]?',

   'Edit Portfolio File Catalog Information'
=> '编辑组合文件的目录信息',

   'Edit Group Portfolio File Catalog Information'
=> '编辑组组合文件的目录信息',

   'Update'
=> '更新',

   'domains'
=> '域',

   'users'
=> '用户',

   'Access'
=> 'Access',

   'Conditional: domain-based'
=> 'Conditional: domain-based',

   'Conditional: user-based'
=> 'Conditional: user-based',

   'Conditional: course-based'
=> 'Conditional: course-based',

   '[_1] was submitted in response to problem: [_2]'
=> '[_1] was submitted in response to problem: [_2]',

   '[_1] was handed back in response to problem: [_2]'
=> '[_1] was handed back in response to problem: [_2]',

   'In the course:'
=> 'In the course:',

   'Back'
=> '返回',

   'Error: no directory name was provided.'
=> '错误：没有输入目录名称。',

   'Unable to create a directory named [_1].'
=> '无法创建目录名 [_1]。',

   'Action disallowed'
=> '不允许行动',

   'You do not have sufficient privileges to [_1]'
=> '您没有足够权限 [_1]',

   'upload files'
=> '上传文件',

   'delete files'
=> '删除文件',

   'rename files'
=> '重命名文件',

   'set access controls for files'
=> '设置访问控制文件',

   "in the group's group portfolio."
=> "in the group's group portfolio.",

   'in this portfolio.'
=> '在这个组区。',

   'You do not have the privileges required to access the shared files space for this group.'
=> '您没有权限访问该组的共享文件。',

   'Not a valid group for this course'
=> '本课程里不是一个有效的组',

   'Group files for [_1]'
=> '[_1] 组的组文件 ',

   'Invalid group'
=> '无效组',

   'No file was selected to upload.'
=> '没有文件被选中上传。',

   'To upload a file, click <strong>Browse...</strong> and select a file, then click <strong>Upload</strong>.'
=> '要上传文件，请点击<strong>浏览... </strong>，并选择一个文件，然后点击<strong>上传</strong> 。',

   'Pick functionality'
=> '选择功能',

   'Functionality to display/modify'
=> '功能显示/修改',

   'You must select at least one functionality type to display.'
=> '您必须至少选择一个功能型。',

   'Default color schemes'
=> '默认颜色方案',

   'Log-in page options'
=> '登录页面选项',

   'Default authentication/language/timezone'
=> '默认的身份验证/语言/时区',

   'Default quotas for user portfolios'
=> 'Default quotas for user portfolios',

   'Auto-update settings'
=> '设置自动更新',

   'Institutional directory searches'
=> 'Institutional directory searches',

   'User creation'
=> '创建用户',

   'User modification'
=> '用户设置',

   'Bubblesheet format file'
=> 'Bubblesheet format file',

   'Cataloging of courses'
=> '课程目录',

   'Display options'
=> '显示选项',

   'Display using: '
=> 'Display using: ',

   'one column'
=> '一列',

   'two columns'
=> '两列',

   'Changes made:'
=> 'Changes made:',

   'Back to configuration display'
=> 'Back to configuration display',

   'No changes made to log-in page settings'
=> 'No changes made to log-in page settings',

   'Support Request'
=> 'Support Request',

   'Do <b>not</b> use this form to ask questions about course content.'
=> 'Do <b>not</b> use this form to ask questions about course content.',

   'Contact your instructor instead.'
=> 'Contact your instructor instead.',

   'Cc'
=> '抄送',

   'Your e-mail address'
=> '您的E-Mail地址',

   'Search and Enroll'
=> '搜索和注册',

   'Search or Add New User'
=> '搜索或添加新用户',

   'No username and/or domain provided.'
=> 'No username and/or domain provided.',

   'No match was found for the username ([_1]) in LON-CAPA domain: [_2]'
=> 'No match was found for the username ([_1]) in LON-CAPA domain: [_2]',

   'Submit a request to the LON-CAPA [_1]helpdesk[_2] for [_3] if you require assistance.'
=> 'Submit a request to the LON-CAPA [_1]helpdesk[_2] for [_3] if you require assistance.',

   'Problems occurred in creating the new Excel file.'
=> 'Problems occurred in creating the new Excel file.',

   'Problems occurred in creating the output file.'
=> 'Problems occurred in creating the output file.',

   'Problems occurred in writing the CSV file.'
=> 'Problems occurred in writing the CSV file.',

   'This error has been logged.'
=> 'This error has been logged.',

   'Please alert your LON-CAPA administrator.'
=> 'Please alert your LON-CAPA administrator.',

   'Records [_1]'
=> 'Records [_1]', # ???

   'Filter [_1]'
=> 'Filter [_1]',

   'Under you current role you are not permitted to change login settings for this user'
=> 'Under you current role you are not permitted to change login settings for this user',

   'History'
=> '历史',

   'Part '
=> '部分 ',

   'Transaction [_1]'
=> 'Transaction [_1]', # ???

   'Nothing submitted - no attempts.'
=> 'Nothing submitted - no attempts.',

   'No data.'
=> 'No data.',

   'Open in a new window'
=> 'Open in a new window',

   'Revoke user roles'
=> 'Revoke user roles',

   'Delete user roles'
=> 'Delete user roles',

   'Re-enable expired user roles'
=> 'Re-enable expired user roles',

   'Make future user roles active now'
=> 'Make future user roles active now',

   'Change starting/ending dates'
=> 'Change starting/ending dates',

   'Change section associated with user roles'
=> 'Change section associated with user roles',

   'Modify existing user: '
=> '修改现有的用户： ',

   'Enroll one student'
=> '注册一名学生',

   'Enroll one student: '
=> '注册一名学生： ',

   'Existing Roles'
=> '现有的角色',

   'Existing Roles in this Course'
=> '课程中现有的角色',

   'Existing Co-Author Roles in your Authoring Space'
=> 'Existing Co-Author Roles in your Authoring Space',

   'Existing Roles in this Domain'
=> '在该域中现有的角色',

   'Text-based Interface Login'
=> 'Text-based Interface Login',

   'Select Accessibility Options'
=> 'Select Accessibility Options',

   'Suppress rendering of images'
=> 'Suppress rendering of images',

   'Suppress Java applets'
=> '禁止Java小程序',

   'Suppress rendering of embedded multimedia'
=> 'Suppress rendering of embedded multimedia',

   'Increase font size'
=> '放大字体',

   'Switch to black and white mode'
=> '切换到黑白模式',

   'Remember these settings for next login'
=> '下次登录时记住这些设置',

   'You are already logged in!'
=> '您已经登录！',

   'You are already logged in'
=> '您已经登录！',

   'Please either [_1]continue the current session[_2] or [_3]logout[_4].'
=> '您的选择：[_1]继续当前的会话[_2]或者[_3]退出[_4]。',

   'Login problems?'
=> '无法登录？',

   'Reset password'
=> '重设密码',

   'Reset forgotten LON-CAPA password'
=> '重置 LON-CAPA 密码',

   'If you use the same account for other campus services besides LON-CAPA, (e.g., e-mail, course registration, etc.), a separate centrally managed mechanism likely exists to reset a password. However, if your account is used for just LON-CAPA access you will probably be able to reset a password from this page.'
=> '如果您使用相同的帐户的其他校园服务除了LON-CAPA， （例如，电子邮件，课程注册等） ，一个单独的中央管理机制可以重置密码。然而，如果您的帐户只是用于LON-CAPA访问，您可以从这个网页重置密码。',

   'Three conditions must be met:'
=> '三个条件必须满足：',

   'An e-mail address must have previously been associated with your LON-CAPA username.'
=> '必须有一个电子邮件地址与您的LON-CAPA用户联系在一起的。',

   'You must be able to access e-mail sent to that address.'
=> '您必须能访问即将发送的电子邮件地址。',

   'Your LON-CAPA account must be of a type for which LON-CAPA can reset a password.'
=> '您 LON-CAPA 帐户必须是一个类型为 LON-CAPA 可以重置密码。',

   'Thank you for your request to reset the password for your LON-CAPA account.'
=> '感谢您要求重设 LON-CAPA 帐户的密码 。',

   'Email address in LON-CAPA'
=> 'Email address in LON-CAPA',

   'E-mail address in LON-CAPA'
=> 'E-mail address in LON-CAPA',

   'The username you provided was not verified as a valid username in the LON-CAPA system for the [_1] domain.'
=> '您提供的用户名不是有效的用户名在 LON-CAPA 系统在该[_1]域。',

   'Please [_1]go back[_2] and try again.'
=> '请[_1]返回[_2] ，然后再试一次。',

   'The e-mail address you provided does not appear to be a valid address.'
=> '您提供的电子邮件地址不是一个有效的地址。',

   'A valid e-mail address was not located in the LON-CAPA system for the username and domain you provided.'
=> '您提供的用户名和域在 LON-CAPA 系统中没有找到一个有效的电子邮件地址。',

   'The username you provided uses an authentication type which can not be reset directly via LON-CAPA.'
=> '您提供的用户名使用的身份验证类型，不能直接通过 LON-CAPA 重置密码。',

   'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3].'
=> '您不妨联系[_2]的[_3]的[_1] LON-CAPA 求助。',

   'You may wish to send an e-mail to the server administrator: [_1] for [_2].' # 1: e-mail, 2: domain
=> '您不妨给服务器管理员发送电子邮件： [_1]的[_2] 。',

   'Assigning yourself a co-author or assistant co-author role in your own author area in Authoring Space is not permitted'
=> 'Assigning yourself a co-author or assistant co-author role in your own author area in Authoring Space is not permitted',

   'Owner(s)'
=> 'Owner(s)',

   'Practice Problem'
=> '练习题',

   'Submissions are not permanently recorded'
=> 'Submissions are not permanently recorded',

   'Submissions to practice problems are not permanently recorded.'
=> 'Submissions to practice problems are not permanently recorded.',

   'not graded'
=> 'not graded',

   'Course initialization preference'
=> 'Course initialization preference',

   'Choose which page will be displayed when you enter this course after selecting a role.'
=> 'Choose which page will be displayed when you enter this course after selecting a role.',

   'Current value is determined by'
=> 'Current value is determined by',

   'and is set to display'
=> 'and is set to display',

   'Page display controlled by'
=> 'Page display controlled by',

   'If'
=> 'If',

   'Choose course entry'
=> 'Choose course entry',

   'Modify course entry'
=> 'Modify course entry',

   'No members to add at this time, as there are no users matching the specified type(s), role(s) and section(s).'
=> 'No members to add at this time, as there are no users matching the specified type(s), role(s) and section(s).',

   'There are no users to add as new members, as all users matching the specified type(s), role(s), and section(s) are already affiliated with this group.'
=> 'There are no users to add as new members, as all users matching the specified type(s), role(s), and section(s) are already affiliated with this group.',

   "You may need to use the 'modify existing, past or future members' page if you need to re-enable or activate access for previous or future members."
=> "You may need to use the 'modify existing, past or future members' page if you need to re-enable or activate access for previous or future members.",

   'Setting optional privileges for specific group members'
=> '对具体组成员设置可选的权限',

   'As no group tools will be made available to users, there are no specific user privileges to set.'
=> 'As no group tools will be made available to users, there are no specific user privileges to set.',

   'Create group'
=> '创建组',

   'The value you entered for the quota for the group portfolio in this group contained invalid characters, so it has been set to 0 MB. You can change this by modifying the group settings.'
=> 'The value you entered for the quota for the group portfolio in this group contained invalid characters, so it has been set to 0 MB. You can change this by modifying the group settings.',

   'The value you entered for the quota for the group portfolio in this group exceeded the maximum possible value, so it has been set to [_1] MB (the maximum possible value).'
=> 'The value you entered for the quota for the group portfolio in this group exceeded the maximum possible value, so it has been set to [_1] MB (the maximum possible value).',

   'A problem occurred when creating folders for the new group [_1]:'
=> 'A problem occurred when creating folders for the new group [_1]:',

   'Group [_1] was created.'
=> '组 [_1] 已创建。',

   'E-mail Address'
=> 'E-mail Address',

   'Closes '
=> 'Closes ',

   'The resources in "[_1]" are open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete all resources "[_1]".'
=> 'The resources in "[_1]" are open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete all resources "[_1]".',

   'This resource "[_1]" is open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete this resource "[_1]".'
=> 'This resource "[_1]" is open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete this resource "[_1]".',

   '[quant,_1,day]'
=> '[quant,_1,day]',

   '[quant,_1,hour]'
=> '[quant,_1,hour]',

   '[quant,_1,minute]'
=> '[quant,_1,minute]',

   '[quant,_1,second]'
=> '[quant,_1,second]',

   'Start Timer?'
=> 'Start Timer?',

   'Sign up for time to work.'
=> 'Sign up for time to work.',

   'Requesting Another Worktime'
=> 'Requesting Another Worktime',

   'No available times.'
=> 'No available times.',

   'Return to last resource'
=> 'Return to last resource',

   'My Courses'
=> '我的课程',

   '[_1] parts'
=> '[_1] parts',

   'Part: [_1]'
=> '部分： [_1]',

   'New Discussion'
=> '新的讨论',

   'New Email'
=> '新的 E-Mail',

   'New Error'
=> '新的错误',

   '(randomly select [_1])'
=> '(randomly select [_1])',

   '(randomly ordered)'
=> '(randomly ordered)',

   'No course selected'
=> 'No course selected',

   'Open '
=> 'Open ',

   'Having technical difficulties; please check status later'
=> 'Having technical difficulties; please check status later',

   'Answer open'
=> 'Answer open',

   'Yes, and show correct answer if they exceed the maximum number of tries.'
=> 'Yes, and show correct answer if they exceed the maximum number of tries.',

   "No, don't show correct/incorrect feedback."
=> "No, don't show correct/incorrect feedback.",

   'No, show no feedback at all.'
=> 'No, show no feedback at all.',

   'single part'
=> 'single part',

   'Course Page'
=> '课程页面',

   'Unable to set "number unread posts display" to [_1] due to [_2].'
=> 'Unable to set "number unread posts display" to [_1] due to [_2].',

   'Current value is [_1].'
=> '当前的值是 [_1].',

   'Unable to set interval to [_1] due to [_2].'
=> 'Unable to set interval to [_1] due to [_2].',

   'Changes to threshold(s) for problem tracking:'
=> 'Changes to threshold(s) for problem tracking:',

   'Set threshold for [_1] to [_2]'
=> '对于 [_1] 到 [_2] 的临界值',

   'Set the default page to be displayed when you select a course role'
=> '设置默认页， 显示您选择的课程的角色',

   '(Currently: [_1])'
=> '(现在: [_1])',

   "The global user preference you set for your courses can be overridden in an individual course by setting a course specific setting via the [_1]What's New page[_2] in the course."
=> "在课程中为您的课程的全局的用户首选项设置可以覆盖个别的课程设置，通过特定的课程设置[_1]What's New page[_2]。",

   'Display the [_1]first resource[_2] in the course.'
=> '显示课程中的[_1]第一资源[_2]。',

   "Display the [_1]What's New page[_2] - a summary of items in the course which require attention."
=> "显示 [_1]What's New page[_2] - 课程中的内容概述需要被注意。",

   'Default now set'
=> 'Default now set',

   'when you select a course role from the roles screen'
=> 'when you select a course role from the roles screen',

   'you will be taken to the start of the course.'
=> 'you will be taken to the start of the course.',

   'a page will be displayed that lists items in the course that may require action from you.'
=> 'a page will be displayed that lists items in the course that may require action from you.',

   "Display the What's New page listing course action items"
=> "Display the What's New page listing course action items",

   'Go to the start of the course'
=> 'Go to the start of the course',

   'now'
=> 'now',

   'No official courses to display for [_1].'
=> 'No official courses to display for [_1].',

   '(Month - Day - Year)'
=> '(月 - 日 - 年)',

   'Month[_1]Day[_2]Year'
=> '月[_1]日[_2]年',

   'Copyright/distribution option "Private" is no longer supported. Select another option from below. Consider "Custom Rights" for maximum control over the usage of your resource.'
=> 'Copyright/distribution option "Private" is no longer supported. Select another option from below. Consider "Custom Rights" for maximum control over the usage of your resource.',

   'Skipping'
=> 'Skipping',

   'Notifying host'
=> 'Notifying host', # ???

   'Back to Catalog Information'
=> '返回到目录信息',

   ' at '
=> ' at ',

   "Computer's answer is incorrect ([_1])."
=> "Computer's answer is incorrect ([_1]).",

   'It is likely that the tolerance range [_1] or significant figures [_2] need to be adjusted.'
=> 'It is likely that the tolerance range [_1] or significant figures [_2] need to be adjusted.',

   'It is likely that the tolerance range [_1] needs to be adjusted.'
=> 'It is likely that the tolerance range [_1] needs to be adjusted.',

   'Submission Record'
=> 'Submission Record',

   'Set/Change grades'
=> 'Set/Change grades',

   'View of the problem'
=> 'View of the problem',

   'Assign Grades'
=> 'Assign Grades',

   'Save &amp; Next'
=> '保存并继续',

   '[_1]student(s)'
=> '[_1]学生',

   '(Next and Previous (student) do not save the scores.)'
=> '(Next and Previous (student) do not save the scores.)',

   'LON-CAPA User Message'
=> 'LON-CAPA 用户邮件',

   '[_1]Message:[_2] No more students for this section or class.'
=> '[_1]Message:[_2] No more students for this section or class.',

   'Click on the button below to return to the grading menu.'
=> 'Click on the button below to return to the grading menu.',

   'Group files'
=> '组文件',

   'One group portfolio file is available.'
=> 'One group portfolio file is available.',

   'One portfolio file owned by [_1] is available.'
=> 'One portfolio file owned by [_1] is available.',

   'A total of [_1] group portfolio files are available.'
=> 'A total of [_1] group portfolio files are available.',

   'A total of [_1] portfolio files owned by [_2] are available'
=> 'A total of [_1] portfolio files owned by [_2] are available',

   '[quant,_1,file is,files are] publicly accessible.'
=> '[quant,_1,file is,files are] publicly accessible.',

   '[quant,_1,file requires,files require] a passphrase for access.'
=> '[quant,_1,file requires,files require] a passphrase for access.',

   'Group Portfolio files'
=> '组组合文件',

   'Viewable portfolio files.'
=> '可见组合文件。',

   'Viewable portfolio files'
=> '可见组合文件',

   'Viewable group portfolio files'
=> '可见组组合文件',

   'Display file listing'
=> '显示文件列表',

   'Portfolio files for [_1]'
=> '[_1] 的组合文件',

   'File access type: '
=> '文件访问类型： ',

   'Update display'
=> '更新显示',

   'Course Information page'
=> '课程资料页',

   'Information about [_1]'
=> '关于 [_1] 的消息',

   'There are no available files of the specified access type: [_1]'
=> '没有提供文件的指定访问类型： [_1]',

   'File Type Displayed: [_1]'
=> '显示文件类型： [_1]',

   'All file types'
=> '所有文件类型',

   'The resource depends on another resource with variable filename, i.e., [_1].'
=> 'The resource depends on another resource with variable filename, i.e., [_1].',

   'You likely need to explicitly allow access to all possible dependencies using the [_1]-tag.'
=> 'You likely need to explicitly allow access to all possible dependencies using the [_1]-tag.',

   'Add Selection for:'
=> 'Add Selection for:',

   'Selected Parameters:'
=> 'Selected Parameters:',

   'Show detailed Parameter Selection'
=> 'Show detailed Parameter Selection',

# Resource Parameters - Start

   'Problem Opening Date (opendate)'
=> '问题开始日期 (opendate)',

   'Problem Opening Date'
=> '问题开始日期',

   'Problem Due Date (duedate)'
=> '问题截止日期 (duedate)',

   'Problem Due Date'
=> '问题截止日期',

   'Problem Answer Date (answerdate)'
=> '问题答案日期 (answerdate)',

   'Problem Answer Date'
=> '问题答案日期',

   'Time-Limit (interval)'
=> '期限 (interval)',

   'Time-Limit'
=> '期限',

   'Weight (weight)'
=> 'Weight (weight)',

   'Weight'
=> 'Weight',

   'Maximum Number of Tries (maxtries)'
=> 'Maximum Number of Tries (maxtries)',

   'Maximum Number of Tries'
=> 'Maximum Number of Tries',

   'Number of Tries before hints appear (hinttries)'
=> 'Number of Tries before hints appear (hinttries)',

   'Number of Tries before hints appear'
=> 'Number of Tries before hints appear',

   'Content Opening Date (contentopen)'
=> '内容开放日期 (contentopen)',

   'Content Due Date (contentclose)'
=> '内容关闭日期 (contentclose)',

   'Content Opening Date'
=> '内容开放日期',

   'Content Close Date'
=> '内容关闭日期',

   'Question Type (type)'
=> '问题类型 (type)',

   'Question Type'
=> '问题类型',

   'Show Problem Status (problemstatus)'
=> 'Show Problem Status (problemstatus)',

   'Show Problem Status'
=> '查看问题状态',

   'Resource Hidden from Students (hiddenresource)'
=> 'Resource Hidden from Students (hiddenresource)',

   'Resource Hidden from Students'
=> 'Resource Hidden from Students',

   'Resource hidden from students (hiddenresource)'
=> 'Resource hidden from students (hiddenresource)',

   'Resource hidden from students'
=> 'Resource hidden from students',

   'List of hidden parts (hiddenparts)'
=> 'List of hidden parts (hiddenparts)',

   'List of hidden parts'
=> 'List of hidden parts', # ???

   'Part Description (display)'
=> 'Part Description (display)',

   'Part Description'
=> 'Part Description',

   'Show Parts One-at-a-Time (ordered)'
=> 'Show Parts One-at-a-Time (ordered)',

   'Show Parts One-at-a-Time'
=> 'Show Parts One-at-a-Time',

   'Numerical Tolerance (tol)'
=> 'Numerical Tolerance (tol)',

   'Numerical Tolerance'
=> 'Numerical Tolerance',

   'Significant Digits (sig)'
=> 'Significant Digits (sig)',

   'Significant Digits'
=> 'Significant Digits',

   'Show Units - Disable Entry (turnoffunit)'
=> 'Show Units - Disable Entry (turnoffunit)',

   'Show Units - Disable Entry'
=> 'Show Units - Disable Entry', # ???

   'Discussion End Time (discussend)'
=> 'Discussion End Time (discussend)',

   'Discussion End Time'
=> 'Discussion End Time',

   'Hide Closed Discussion (discusshide)'
=> 'Hide Closed Discussion (discusshide)',

   'Hide Closed Discussion'
=> 'Hide Closed Discussion',

   'Randomly Order Resources (randomorder)'
=> 'Randomly Order Resources (randomorder)',

   'Randomly Order Resources'
=> 'Randomly Order Resources',

   'Randomly pick number of resources (randompick)'
=> 'Randomly pick number of resources (randompick)',

   'Do not show plain URL (encrypturl)'
=> 'Do not show plain URL (encrypturl)',

   'Do not show plain URL'
=> 'Do not show plain URL',

   'Slots of availability (available)'
=> 'Slots of availability (available)',

   'Slots of availability'
=> 'Slots of availability',

   'CSS file to link (cssfile)'
=> 'CSS file to link (cssfile)',

   'CSS file to link'
=> 'CSS file to link',

   'Use slot based access controls (useslots)'
=> 'Use slot based access controls (useslots)',

   'Use slot based access controls'
=> 'Use slot based access controls',

   'Client IP/Name Access Control (acc)'
=> 'Client IP/Name Access Control (acc)',

   'Client IP/Name Access Control'
=> 'Client IP/Name Access Control',

   'Resource alias name for conditions (mapalias)'
=> 'Resource alias name for conditions (mapalias)',

   'Resource alias name for conditions'
=> 'Resource alias name for conditions',

   'Slots of availability selected by student (availablestudent)'
=> 'Slots of availability selected by student (availablestudent)',

   'Slots of availability selected by student'
=> 'Slots of availability selected by student',

   'Hide buttons from students (buttonshide)'
=> 'Hide buttons from students (buttonshide)',

   'Hide buttons from students'
=> 'Hide buttons from students', # ???

   'Hide DragMath-Editor (turnoffeditor)'
=> 'Hide DragMath-Editor (turnoffeditor)',

   'Hide DragMath-Editor'
=> 'Hide DragMath-Editor',

   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximum Number of Collaborators (maxcollaborators)',

   'Maximum Number of Collaborators'
=> 'Maximum Number of Collaborators',

   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Allowed File Extensions for Uploaded Files (uploadedfiletypes)',

   'Allowed File Extensions for Uploaded Files'
=> 'Allowed File Extensions for Uploaded Files',

   'Hand Graded (handgrade)'
=> 'Hand Graded (handgrade)',

   'Hand Graded'
=> 'Hand Graded',

   'Number of bubbles in exam mode (numbubbles)'
=> '考试模式中的一些复选框 (numbubbles)',

   'Number of bubbles in exam mode'
=> '考试模式中的一些复选框',

   'Format for display of score (scoreformat)'
=> '评分显示格式 (scoreformat)',

   'Format for display of score'
=> '评分显示格式',

   'Max. Cumulative Size (MB) for Submitted Files (maxfilesize)'
=> '最大(MB)累积提交文件 (maxfilesize)',

   'Max. Cumulative Size (MB) for Submitted Files'
=> '最大(MB)累积提交文件',

   'Max. cumulative size (MB) for submitted files (maxfilesize)'
=> '最大(MB)累积提交文件 (maxfilesize)',

   'Max. cumulative size (MB) for submitted files'
=> '最大(MB)累积提交文件',
# Resource Parameters - End

# Resource Parameter Categories - Start
   'Problem Appearance'
=> 'Problem Appearance',

   'Time Settings'
=> 'Time Settings',

   'High Level Randomization'
=> 'High Level Randomization',

   'Hiding'
=> 'Hiding',

   'Behaviour of Input Fields'
=> 'Behaviour of Input Fields',

   'Slots'
=> 'Slots',

   'File Submission'
=> 'File Submission',
# Resource Parameters Categories - End

   'New LON-CAPA [_1] ID: [_2]'
=> '新的 LON-CAPA-[_1]-ID: [_2]',

   'Not available'
=> '不详',

   'Post Announcement'
=> '提交通知',

   'The folder name: "[_1]" is already in use for an existing folder.'
=> '文件夹名称： "[_1]" 已经在现有的文件夹中。',

   'The folder name: "[_1]" is already used for one of the folders automatically generated by the system.'
=> '文件夹名称： "[_1]" 已经用于一个文件夹自动生成系统。',

   'Error - could not obtain lock on email folders record.'
=> 'Error - could not obtain lock on email folders record.',

   'The folder "[_1]" may not be deleted'
=> 'The folder "[_1]" may not be deleted',

   'The folder "[_1]" does not exist so deletion is not required.'
=> 'The folder "[_1]" does not exist so deletion is not required.',

   'The folder "[_1]" contains messages so it may not be deleted.'
=> '该文件夹“[_1]”包含有信息，因此不能删除。',

   'Delete or move the messages to a different folder first.'
=> 'Delete or move the messages to a different folder first.',

   'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is an invalid name.'
=> 'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is an invalid name.',

   'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is reserved for folders provided automatically by the system.'
=> 'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is reserved for folders provided automatically by the system.',

   'The folder "[_1]" may not be renamed to "[_2]" because the new name you requested is already being used for an existing folder.'
=> 'The folder "[_1]" may not be renamed to "[_2]" because the new name you requested is already being used for an existing folder.',

   'The folder "[_1]" could not be renamed to "[_2]" because the folder does not exist.'
=> 'The folder "[_1]" could not be renamed to "[_2]" because the folder does not exist.',

   'Warning: failed to release lock for counter'
=> 'Warning: failed to release lock for counter',

   'Warning: failed to release lock for folder: [_1].'
=> 'Warning: failed to release lock for folder: [_1].',

   'Error uploading new folder.'
=> 'Error uploading new folder.',

   'Error reading contents of parent folder.'
=> 'Error reading contents of parent folder.',

   'Error saving updated parent folder.'
=> 'Error saving updated parent folder.',

   'Parameters not set for [_1] because the resource was not recognized as part of the course.'
=> 'Parameters not set for [_1] because the resource was not recognized as part of the course.',

   'Message not moved, Attempted to move message to the same folder as it already is in.'
=> 'Message not moved, Attempted to move message to the same folder as it already is in.',

   'Message not moved, A network error occurred.'
=> 'Message not moved, A network error occurred.',

   'Message not moved as the message is no longer in the source folder.'
=> 'Message not moved as the message is no longer in the source folder.',

   'Message copied to new folder but status was not, A network error occurred.'
=> 'Message copied to new folder but status was not, A network error occurred.',

   'Message copied, but unable to delete the original from the source folder.'
=> 'Message copied, but unable to delete the original from the source folder.',

   'Message copied, but unable to delete the original status from the source folder.'
=> 'Message copied, but unable to delete the original status from the source folder.',

   'Error: you must have a course role selected to be able to send a broadcast message to a group in the course.'
=> 'Error: you must have a course role selected to be able to send a broadcast message to a group in the course.',

   'Error: could not determine domain or number of course'
=> 'Error: could not determine domain or number of course',

   'Select message recipients from the group members listed below.'
=> 'Select message recipients from the group members listed below.',

   'Send another e-mail'
=> '发送另一个电子邮件',

   'Send another group message'
=> '给其他组发送邮件',

   'Return to group page'
=> '返回到组网页',

   'You have to confirm that you have received this message before you can view other pages. After confirmation, this message will be moved to your regular inbox'
=> '您必须确认您已经收到此邮件，然后才能访问其他页面。确认后，此邮件将移至您的收件箱。',

   '[quant,_1,message is, messages are] not viewable because display of LON-CAPA messages sent to you by other students between [_2] and [_3] is currently being blocked because of online exams.'
=> '[quant,_1,message is, messages are] not viewable because display of LON-CAPA messages sent to you by other students between [_2] and [_3] is currently being blocked because of online exams.',

   'Each of the[_1] [quant,_2,message] [_3]you checked will be forwarded to the recipient(s) you select below.'
=> 'Each of the[_1] [quant,_2,message] [_3]you checked will be forwarded to the recipient(s) you select below.',

   'The message you checked will be forwarded to the recipient(s) you select below.'
=> 'The message you checked will be forwarded to the recipient(s) you select below.',

   'Send Messages'
=> '发送邮件',

   'Send Message'
=> '发送邮件', # '发送讯息',

   'Send Reply to Messages'
=> '发送回复邮件',

   'Send Reply to Message'
=> '发送回复邮件',

   'Forward Messages'
=> '转发邮件',

   'Forward Message'
=> '转发邮件',

   'Save message for re-use'
=> '邮件重新保存',

   'Show re-usable messages'
=> '显示保存的邮件',

   'This message was designated by the sender not to allow replies.'
=> 'This message was designated by the sender not to allow replies.',

   'The sender did not designate a reply to address for this message.'
=> 'The sender did not designate a reply to address for this message.',

   'Reply to other recipients'
=> 'Reply to other recipients',

   'Unless you choose otherwise:'
=> 'Unless you choose otherwise:',

   "The subject in each forwarded message will be <i>'Forwarding:'</i> followed by the original subject."
=> "The subject in each forwarded message will be <i>'Forwarding:'</i> followed by the original subject.",

   'original subject'
=> 'original subject',

   "sender's name"
=> "sender's name",

   'Message begins with:'
=> 'Message begins with:',

   'Any new text to display before the text of the original messages:'
=> 'Any new text to display before the text of the original messages:',

   'username1:domain1: text'
=> '用户名1：域名1： 文本',

   'username2:domain2: text'
=> '用户名2：域名2： 文本',

   'username3:domain1: text'
=> '用户名3：域名3： 文本',

   "The messages will be assembled from all lines with the respective\n<tt>username:domain</tt>, and appended to the general message text."
=> "邮件从相应用户的所有行<tt>用户名：域</tt>收集并附加到一般消息文本。", # ???

   'Not allowed'
=> '不允许',

   'Archived Message'
=> '存档的邮件',

   '[quant,_1,communication blocking period was,communication blocking periods were] removed.'
=> '[quant,_1,communication blocking period was,communication blocking periods were] removed.',

   '[quant,_1,communication blocking period was,communication blocking periods were] modified.'
=> '[quant,_1,communication blocking period was,communication blocking periods were] modified.',

   '[quant,_1,communication blocking period was,communication blocking periods were] added.'
=> '[quant,_1,communication blocking period was,communication blocking periods were] added.',

   'You attempted to display a message that is currently blocked because you are enrolled in one or more courses for which there is an ongoing online exam.'
=> 'You attempted to display a message that is currently blocked because you are enrolled in one or more courses for which there is an ongoing online exam.',

   'Reply To'
=> 'Reply To',

   'Current attempts of student (if applicable)'
=> 'Current attempts of student (if applicable)',

   'Current screen output (if applicable)'
=> 'Current screen output (if applicable)',

   'No saved comments yet.'
=> 'No saved comments yet.',

   'No saved comments yet for this resource.'
=> 'No saved comments yet for this resource.',

   'Could not deliver message'
=> 'Could not deliver message',

   'Please use the browser "Back" button and correct the recipient addresses ([_1]).'
=> 'Please use the browser "Back" button and correct the recipient addresses ([_1]).',

   'Failed to delete the message.'
=> 'Failed to delete the message.',

   'Marked [_1] message(s) read'
=> 'Marked [_1] message(s) read',

   'Marked [_1] message(s) Unread'
=> 'Marked [_1] message(s) Unread',

   'Destination folder [_1] is not a valid folder'
=> 'Destination folder [_1] is not a valid folder',

   'Failed to move [_1] message(s)'
=> 'Failed to move [_1] message(s)',

   'Moved [_1] message(s)'
=> 'Moved [_1] message(s)',

   'Failed to delete [_1] message(s)'
=> 'Failed to delete [_1] message(s)',

   'Deleted [_1] message(s)'
=> 'Deleted [_1] message(s)',

   '[quant,_1,message] forwarded.'
=> '[quant,_1,message] forwarded.',

   'Could not forward [quant,_1,message].'
=> 'Could not forward [quant,_1,message].',

   'Could not deliver forwarded message.'
=> 'Could not deliver forwarded message.',

   'The recipient addresses may need to be corrected'
=> 'The recipient addresses may need to be corrected',

   'Mail folder "[_1]" created.'
=> '邮件文件夹 "[_1]" 已创建。',

   'Creation failed.'
=> '创建失败。',

   'Mail folder "[_1]" deleted.'
=> '邮件文件夹 "[_1]" 已删除。',

   'Deletion failed.'
=> '删除失败。',

   'Mail folder "[_1]" renamed "[_2]".'
=> '邮件文件夹 "[_1]" 更名为 "[_2]".',

   'Renaming failed.'
=> '重命名失败。',

   'Messages'
=> '邮件',

   'Distribute from Uploaded File'
=> '从上传的文件分发', # ???

   'Communication Blocking'
=> '通讯阻塞',

   'Communication blocking during scheduled exams'
=> '有时限的通讯阻塞',

   'You can use communication blocking to prevent students enrolled in this course from displaying LON-CAPA messages sent by other students during an online exam. As blocking of communication could potentially interrupt legitimate communication between students who are also both enrolled in a different LON-CAPA course, please be careful that you select the correct start and end times for your scheduled exam when setting or modifying these parameters.'
=> '您可以在网上考试期间使用通信阻断，以防止该课程的学生接收其他学生的LON-CAPA信息。作为阻止的通信可能会中断参加了其他的LON-CAPA课程的学生之间的沟通，请您在在设置和更改安排考试时间时注意选择正确的开始和结束时间。',

   'Modify existing communication blocking periods'
=> '修改现有的通信阻断时间',

   'No communication blocks currently saved'
=> '目前任何通信被锁定。',

   'Duration'
=> '持续',

   'Event'
=> '事件',

   'Blocked?'
=> '被锁定？',

   'Add block'
=> '新增锁定',

   'e.g., Exam 1'
=> '(例如：考试1)',

   'Discussion'
=> '论坛',

   'The following changes were made'
=> '进行了以下更改：',

   'Add new communication blocking periods'
=> '添加新的的通信阻断时间',

   'Set by'
=> 'Set by',

   'Deleted Message'
=> '删除的邮件',

   'Marked Messages Read'
=> '邮件标记为已读',

   'Marked Messages Unread'
=> '邮件标记为未读',

   'Moved Messages'
=> '移动邮件',

   'Deleted Messages'
=> '删除邮件',

   'Marked Message as Unread'
=> '邮件标记为未读',

   'Deleted Folder'
=> '删除文件夹',

   'Renamed Folder'
=> '重命名文件夹',

   'username:domain,username:domain,...'
=> '用户名：域，用户名：域...',

   'All courses'
=> '所有课程',

   'Pick specific course(s):'
=> 'Pick specific course(s):',

   'Search for a course in the [_1] domain'
=> 'Search for a course in the [_1] domain',

   'Actions available after searching for a course:'
=> 'Actions available after searching for a course:',

   'Although almost all course settings can be modified by a [_1], a number of settings exist which only a [_2] may change:'
=> 'Although almost all course settings can be modified by a [_1], a number of settings exist which only a [_2] may change:',

   "Certain settings which control auto-enrollment of students from your institution's student information system."
=> "Certain settings which control auto-enrollment of students from your institution's student information system.",

   'The total disk space allocated for storage of portfolio files in all groups in a course.'
=> 'The total disk space allocated for storage of portfolio files in all groups in a course.',

   'No existing sections'
=> 'No existing sections',

   'Broadcast e-mail to users'
=> 'Broadcast e-mail to users',

   'Broadcast E-mail'
=> 'Broadcast E-mail',

   'Broadcast e-mail to Domain'
=> 'Broadcast e-mail to Domain',

   'Send a new e-mail message to selected users from this domain'
=> 'Send a new e-mail message to selected users from this domain',

   'Send a new e-mail to selected users from this domain'
=> 'Send a new e-mail to selected users from this domain',

   'Display e-mail sent by Domain Coordinators in this domain'
=> 'Display e-mail sent by Domain Coordinators in this domain',

   'Select Audience'
=> 'Select Audience',

   'Choose e-mail audience'
=> 'Choose e-mail audience',

   'Roles:'
=> '角色：',

   'Courses:'
=> '课程：',

   '[_1] selected.'
=> '[_1] 选择的。',

   'Access status:'
=> 'Access status:',

   'Username -> Email conversion:'
=> '用户名 -> E-Mail 转换:',

   'Building valid e-mail address from username, if missing from preferences:'
=> 'Building valid e-mail address from username, if missing from preferences:',

   'Kerberos: enter default for each realm used in the domain, with comma separation of entries'
=> 'Kerberos: enter default for each realm used in the domain, with comma separation of entries',

   '(e.g., MSU.EDU=msu.edu, MSUE.EDU=msue.msu.edu).'
=> '(e.g., MSU.EDU=msu.edu, MSUE.EDU=msue.msu.edu).',

   'Internal, Filesystem and Local authentication: enter single default.'
=> 'Internal, Filesystem and Local authentication: enter single default.',

   'Authentication Method'
=> 'Authentication Method',

   'Username -> e-mail conversion'
=> 'Username -> e-mail conversion',

   'Internal (LON-CAPA)'
=> 'Internal (LON-CAPA)',

   'username@'
=> '用户名@',

   'Local/Customized'
=> 'Local/Customized',

   'Filesystem (UNIX)'
=> 'Filesystem (UNIX)',

   'Compose E-mail'
=> 'Compose E-mail',

   'No recipients identified'
=> 'No recipients identified',

   'Broadcast e-mail display options'
=> 'Broadcast e-mail display options',

   'Date range:'
=> 'Date range:',

   'Earliest to display:'
=> 'Earliest to display:',

   'Latest to display:'
=> 'Latest to display:',

   'Choose sender(s):'
=> 'Choose sender(s):',

   'Display e-mail'
=> '显示 E-Mail',

   'E-mail display'
=> '显示 E-Mail',

   'Display Broadcast e-mail'
=> '显示广播 E-Mail',

   'No mail sent matching supplied criteria'
=> 'No mail sent matching supplied criteria',

   'No students found.'
=> 'No students found.',

   'Spreadsheet'
=> 'Spreadsheet',

   'Spreadsheet Help'
=> 'Spreadsheet Help',

   'Editing Help'
=> 'Editing Help',

   'Help on printing'
=> 'Help on printing',

   'Metadata Diffs'
=> 'Metadata Diffs',

   'Retrieve Metadata'
=> 'Retrieve Metadata',

   'Enter course'
=> 'Enter course',

   'Enter Course'
=> 'Enter Course',

   'Enter Access Key to Unlock this Course'
=> 'Enter Access Key to Unlock this Course',

   'Verifying Access Key to Unlock this Course'
=> 'Verifying Access Key to Unlock this Course',

   'Successfully registered key'
=> 'Successfully registered key',

   'Re-Enter Key'
=> 'Re-Enter Key',

   'Assigned from [_1] at [_2] for [_3]'
=> 'Assigned from [_1] at [_2] for [_3]',

   'Total Matches'
=> 'Total Matches',

   'Time Remaining'
=> 'Time Remaining',

   'IMPORT'
=> 'IMPORT',

   'Help on slots'
=> 'Help on slots',

   'New user accounts in [_1]'
=> 'New user accounts in [_1]',

   'Student enrollment changes in [_1]'
=> 'Student enrollment changes in [_1]',

   'The following [quant,_1,change] occurred in [_2] - [_3] as a result of the automated classlist update:'
=> 'The following [quant,_1,change] occurred in [_2] - [_3] as a result of the automated classlist update:',

   'No institutional classlist data could be retrieved for [_1]'
=> 'No institutional classlist data could be retrieved for [_1]',

   'Not within time window for auto-enrollment in [_1]'
=> 'Not within time window for auto-enrollment in [_1]',

   'Auto-enrollment not currently enabled for [_1]'
=> 'Auto-enrollment not currently enabled for [_1]',

   'The courseID provided does not match a course in this domain.'
=> 'The courseID provided does not match a course in this domain.',

   'Not Open'
=> 'Not Open',

   "This resource currently isn't open. It will be available at [_1]."
=> "This resource currently isn't open. It will be available at [_1].",

   'Could not handle ambiguous resource reference'
=> 'Could not handle ambiguous resource reference',

   'The nature of the problem is unclear'
=> 'The nature of the problem is unclear',

   'Course Roster'
=> '课程名册',

   'Classlist'
=> '班级名册',

   'Display of a student-viewable course roster is not currently enabled.'
=> 'Display of a student-viewable course roster is not currently enabled.',

   'Student-viewable course roster'
=> 'Student-viewable course roster',

   'Students with no section'
=> 'Students with no section',

   'Students in section "[_1]"'
=> 'Students in section "[_1]"',

   'Students in any section'
=> 'Students in any section',

   'Only students who have opted to be listed in the roster ([_1] out of [_2] students) are shown.'
=> 'Only students who have opted to be listed in the roster ([_1] out of [_2] students) are shown.',

   'The single student without a section[_1] has opted not to be listed in the roster.'
=> 'The single student without a section[_1] has opted not to be listed in the roster.',

   'The single student in the section[_1] has opted not to be listed in the roster.'
=> 'The single student in the section[_1] has opted not to be listed in the roster.',

   'The single student in the course[_1] has opted not to be listed in the roster.'
=> 'The single student in the course[_1] has opted not to be listed in the roster.',

   'None of the [_1] students without a section[_2] have opted to be listed in the roster.'
=> 'None of the [_1] students without a section[_2] have opted to be listed in the roster.',

   'None of the [_1] students in the section[_2] have opted to be listed in the roster.'
=> 'None of the [_1] students in the section[_2] have opted to be listed in the roster.',

   'None of the [_1] students in the course[_2] have opted to be listed in the roster.'
=> 'None of the [_1] students in the course[_2] have opted to be listed in the roster.',

   'All [_1] students without a section[_2] have opted to be listed in the roster.'
=> 'All [_1] students without a section[_2] have opted to be listed in the roster.',

   'All [_1] students in the section[_2] have opted to be listed in the roster.'
=> 'All [_1] students in the section[_2] have opted to be listed in the roster.',

   'All [_1] students in the course[_2] have opted to be listed in the roster.'
=> 'All [_1] students in the course[_2] have opted to be listed in the roster.',

   'The single student without a section[_1] has opted to be listed in the roster.'
=> 'The single student without a section[_1] has opted to be listed in the roster.',

   'The single student in the section[_1] has opted to be listed in the roster.'
=> 'The single student in the section[_1] has opted to be listed in the roster.',

   'The single student in the course[_1] has opted to be listed in the roster.'
=> 'The single student in the course[_1] has opted to be listed in the roster.',

   'All [_1] students without a section[_2] are listed in the roster.'
=> 'All [_1] students without a section[_2] are listed in the roster.',

   'All [_1] students in the section[_2] are listed in the roster.'
=> 'All [_1] students in the section[_2] are listed in the roster.',

   'All [_1] students in the course[_2] are listed in the roster.'
=> 'All [_1] students in the course[_2] are listed in the roster.',

   'There is only a single student without a section[_1]'
=> 'There is only a single student without a section[_1]',

   'There is only a single student in the section[_1]'
=> 'There is only a single student in the section[_1]',

   'There is only a single student in the course[_1]'
=> 'There is only a single student in the course[_1]',

   'There are currently no students to display.'
=> 'There are currently no students to display.',

   'Available Portfolio files'
=> 'Available Portfolio files',

   'Name not given'
=> '姓名不详',

   '[quant,_1,file,files,No files]'
=> '[quant,_1,Datei,Dateien,Keine Dateien]',

   'Error retrieving file information.'
=> 'Error retrieving file information.',

   'Your roster setting'
=> 'Your roster setting',

   'You are currently listed in the student-viewable roster.'
=> 'You are currently listed in the student-viewable roster.',

   'You are currently <b>not</b> listed in the student-viewable roster.'
=> 'You are currently <b>not</b> listed in the student-viewable roster.',

   'Include yourself in the roster?'
=> 'Include yourself in the roster?',

   'Display of your name in the student-viewable roster set to [_1].'
=> 'Display of your name in the student-viewable roster set to [_1].',

   'Error occurred saving display setting.'
=> 'Error occurred saving display setting.',

   'Display of your name in the student-viewable roster unchanged (set to [_1]).'
=> 'Display of your name in the student-viewable roster unchanged (set to [_1]).',

   'View course roster'
=> 'View course roster',

   'Change Course Page Preferences'
=> 'Change Course Page Preferences',

   'Change Course Page Pref'
=> 'Change Course Page Pref',

   'No context.'
=> 'No context.',

   'unable to verify variable URL'
=> 'unable to verify variable URL',

   'Receipt'
=> 'Receipt',

   'Problems during Course Initialization'
=> 'Problems during Course Initialization',

   'Try Selecting Again'
=> 'Try Selecting Again',

   'Invalid map: [_1]'
=> 'Invalid map: [_1]',

   'Please either [_1]close this window[_2] or [_3]log in again[_4].'
=> 'Please either [_1]close this window[_2] or [_3]log in again[_4].',

   'Thank you for using LON-CAPA.'
=> '感谢您使用 LON-CAPA。',

   'You have been successfully logged out.'
=> '您已成功退出。',

   'You can [_1]close this window[_2] now.'
=> '您现在可以 [_1]关闭这个窗口[_2]。',

   '[_1]Log in again[_2]'
=> '[_1]重新登录[_2]',

   'No matches found in resources.'
=> 'No matches found in resources.',

   'No matches found in postings.'
=> 'No matches found in postings.',

   'Unable to understand the search phrase [_1]. Please modify your search.'
=> 'Unable to understand the search phrase [_1]. Please modify your search.',

   'Unable to understand the search phrase [_1]: [_2]'
=> 'Unable to understand the search phrase [_1]: [_2]',

   'You did not fill in enough information for the search to be started. You need to fill in relevant fields on the search page in order for a query to be processed.'
=> '搜寻无法完成，因为您没有足够的数据。您必须在搜索页面的搜索栏里填写关键词，从而使您的要求可以得到处理。', # '您没有填写足够的信息进行搜索的开始。您需要填写在有关领域在搜寻网页上，以便查询处理。'

   'conditionally hidden'
=> '有条件的隐藏',

   'Problem Parameters'
=> '问题参数',

   'No group name provided.'
=> '没有组名称。',

   'Invalid group name provided.'
=> '无效的组名称。',

   'Invalid [_1]'
=> '无效的 [_1]', # ???

   '"[_1]" is not the name of a valid group in this [_2].'
=> '"[_1]" 并非是一个有效的名称在本组 [_2].',

   'You do not have privileges to view the membership roster in this group.'
=> '您没有权限以查看该组的会员名册。',

   'Group membership status - [_1]'
=> '组会员状态: [_1]',

   'group membership status - [_1]'
=> '组会员状态: [_1]',

   'There are no membership data to display for this group.'
=> '该组没有任何会员数据。',

   'Membership status: '
=> '会员状态: ',

   'There are no groups to display in this [_1].'
=> '没有任何组在此 [_1] 可以显示。', # ??? -> grouproster.pm

   'Start Date'
=> '开始日期',

   'End Date'
=> '结束日期',

   'Functionality'
=> '功能',

   'Privileges'
=> '权限',

   'Any Membership status'
=> '任何会员状态',

   'Active Member'
=> '活跃的会员',

   'Former Member'
=> '以前的会员',

   'Future Member'
=> '未来的会员',

   'Group Folder - [_1]'
=> '组文件夹 - [_1]',

   'Group homepage - [_1]'
=> '组网页 - [_1]',

   'A support request has been sent to'
=> 'A support request has been sent to',

   'Your support request contained the following information'
=> 'Your support request contained the following information',

   'The following Cc e-mail address is invalid: '
=> 'The following Cc e-mail address is invalid: ',

   'The following Cc e-mail addresses are invalid: '
=> 'The following Cc e-mail addresses are invalid: ',

   'As the e-mail address provided for this LON-CAPA server ([_1]) does not appear to be a valid e-mail address, your support request has <b>not</b> been sent to the LON-CAPA support staff or administrator at your institution.'
=> 'As the e-mail address provided for this LON-CAPA server ([_1]) does not appear to be a valid e-mail address, your support request has <b>not</b> been sent to the LON-CAPA support staff or administrator at your institution.',

   'Instead a copy has been sent to the LON-CAPA support team at Michigan State University.'
=> 'Instead a copy has been sent to the LON-CAPA support team at Michigan State University.',

   'The uploaded screenshot file ([_1] bytes) included with your request exceeded the maximum allowed size - 128 KB, and has therefore been discarded.'
=> 'The uploaded screenshot file ([_1] bytes) included with your request exceeded the maximum allowed size - 128 KB, and has therefore been discarded.',

   'An uploaded screenshot file [_1] ([_2] bytes) was included in the request sent by [_3].'
=> 'An uploaded screenshot file [_1] ([_2] bytes) was included in the request sent by [_3].',

   'File does not have [_1] or [_2] starting tag'
=> 'File does not have [_1] or [_2] starting tag',

   'File does not have [_1] or [_2] ending tag'
=> 'File does not have [_1] or [_2] ending tag',

   'File does not have [_1] ending tag'
=> 'File does not have [_1] ending tag',

   'Example'
=> 'Example',

   'Algebraic Response Problems'
=> 'Algebraic Response Problems',

   'Chemistry Problems'
=> 'Chemistry Problems',

   'Free Form Problems'
=> 'Free Form Problems',

   'Handgraded Problems'
=> 'Handgraded Problems',

   'Miscellaneous'
=> 'Miscellaneous',

   'Multiple Choice Problems'
=> 'Multiple Choice Problems',

   'Numerical Problems'
=> 'Numerical Problems',

   'Language:'
=> '语言：',

   'Math Rendering:'
=> 'Math Rendering:',

   'Restrict Domain Coordinator Access'
=> 'Restrict Domain Coordinator Access',

   'By default, the Domain Coordinator can enter your Authoring Space.'
=> 'By default, the Domain Coordinator can enter your Authoring Space.',

   'Block access to Authoring Space'
=> 'Block access to Authoring Space',

   'jsMath'
=> 'jsMath',

   'tth (TeX to HTML)'
=> 'tth (TeX to HTML)',

   'mimetex (Convert to Images)'
=> 'mimetex (Convert to Images)',

   'jsMath:'
=> 'jsMath:',

   'tth (TeX to HTML):'
=> 'tth (TeX to HTML):',

   'mimetex (Convert to Images):'
=> 'mimetex (Convert to Images):',

   '[_1], [_2], or [_3]'
=> '[_1], [_2] 或者 [_3]',

   'internal, optional'
=> '内部的，可选的',

   'user:domain,user:domain,...'
=> '用户名：域，用户名：域...',

   'user:domain,user:domain(section;section;...;*;...),...'
=> '用户名：域，用户名：域（科，章节;...;*;...),...',

   'user:domain,user:domain,*:domain'
=> '用户名：域，用户名：域，*：域',

   'Course members with current access'
=> 'Course members with current access',

   'Course members with expired access'
=> 'Course members with expired access',

   'Course members with future access'
=> 'Course members with future access',

   'Other Roles'
=> '其他角色',

   'Select Author'
=> '选择作者',

   'Non-standard Course'
=> '非标准课程',

   'Switch course role to...'
=> '更改用户角色...',

   'Message'
=> '邮件',

   'Time of change'
=> '更改时间',

   'active'
=> '活跃的',

   'previous'
=> '以前的',

   'Access dates to apply for selected users'
=> 'Access dates to apply for selected users',

   'Changes in section affiliation to apply to selected users'
=> 'Changes in section affiliation to apply to selected users',

   'For student roles changing the section, will result in a section switch as students may only be in one section of a course at a time.'
=> 'For student roles changing the section, will result in a section switch as students may only be in one section of a course at a time.',

   'For a role in a course that is not a student role, a user may have roles in more than one section of a course at a time.'
=> 'For a role in a course that is not a student role, a user may have roles in more than one section of a course at a time.',

   "Retain each user's current section affiliations?"
=> "Retain each user's current section affiliations?",

   '(Does not apply to student roles).'
=> '(Does not apply to student roles).',

   '[_1]Show[_2] clicker id'
=> '[_1]Show[_2] clicker id',

   '[_1]Hide[_2] clicker id'
=> '[_1]Hide[_2] clicker id',

   'Catalog:'
=> '目录：',

   'Main Categories'
=> '主要类型',

   'Official courses (with institutional codes)'
=> '官方课程（带机构代码）',

   'Official courses'
=> '官方课程',

   'with institutional codes'
=> '带机构代码',

   'Self-enroll (if permitted)'
=> '自己报名（如果被允许）',

   'No ending date'
=> '无结束日期',

   'From:[_1]'
=> 'From:[_1]',

   'To:[_1]'
=> 'To:[_1]',

   'Starts: [_1]'
=> '开始： [_1]',

   'Ends: [_1]'
=> '结束： [_1]',

   'Ended: [_1]'
=> 'Ended: [_1]',

   'Currently enabled'
=> 'Currently enabled',

   '[quant,_1,section:,sections:,No sections]'
=> '[quant,_1,section:,sections:,No sections]',

   'No information available for [_1].'
=> 'No information available for [_1].',

   'Self-enrollers:'
=> 'Self-enrollers:',

   'Choices:'
=> 'Choices:',

   'Configure User Self-enrollment'
=> '配置用户自助注册',

   'View Change Logs'
=> 'View Change Logs',

   'View Log-in History'
=> 'View Log-in History',

   'Configure Self-enrollment'
=> '配置自助注册',

   'Self-enrollment with a student role'
=> '自助注册一个学生角色',

   'Users allowed to self-enroll in this course'
=> '用户可自行注册来参加此课程',

   'Any user in any domain:'
=> '任何用户在任何域：',

   'User types:'
=> '用户类型：',

   'any'
=> '任意',

   'Any Users'
=> '任何用户',

   'Any users'
=> '任何用户',

   'Others'
=> '其他',

   'Additional domain:'
=> '其他域：',

   'Users in additional domain:'
=> '用户在其他域：',

   'Specific domain:'
=> '特定域：',

   'Users in specific domain:'
=> '用户在其特定域：',

   'Other domain:'
=> '其他域：',

   'Users in other domain:'
=> '用户在其他域：',

   'Restrict self-enrollment to students officially registered for the course'
=> '限制自助注册为正式注册的学生的课程',

   'Dates self-enrollment available'
=> '自助注册期限',

   'Starts'
=> '开始',

   'Ends'
=> '结束',

   'Course access dates assigned to self-enrolling users'
=> '课程访问日期分配给自助注册的用户',

   'Section assigned to self-enrolling users'
=> '章节指派给自助注册用户',

   'The following changes were made to self-enrollment settings:'
=> '进行了以下自助注册设置的更改：',

   '[_1]: "[_2]" set to "[_3]".'
=> '[_1]: "[_2]" 设置为 "[_3]".',

   '"[_1]" set to "[_2]".'
=> '"[_1]" 设置为 "[_2]".',

   'No changes were made to the existing self-enrollment settings in this course.'
=> '现有的自助注册设置在该课程中未作任何修改。',

   'Self-enrollment result'
=> '自助注册结果',

   'Enroll in course'
=> '注册课程',

   'Sections:'
=> '章节：',

   'Self-enroll in course'
=> '自助注册参加课程',

   'Self-enroll in a LON-CAPA course'
=> '自助注册参加LON-CAPA课程',

   'Self-enroll'
=> '自助注册',

   'Self-enroll in [_1]'
=> '自助注册到 [_1]',

   'Self-enrollment error'
=> '自助注册错误',

   'Invalid domain or course number'
=> '无效的域或课程数目',

   'Self-enrollment unavailable'
=> '自助注册无法使用',

   'Self-enrollment is restricted to students officially registered for this course.'
=> 'Self-enrollment is restricted to students officially registered for this course.',

   'Self-enrollment is not currently available for this course.'
=> 'Self-enrollment is not currently available for this course.',

   'Self-enrollment is not currently available in this course'
=> 'Self-enrollment is not currently available in this course',

   'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users.'
=> 'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users.',

   'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users at your institution ([_2]).'
=> 'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users at your institution ([_2]).',

   'Self-enrollment will become available starting [_1]; please enroll at that time.'
=> 'Self-enrollment will become available starting [_1]; please enroll at that time.',

   'Although self-enrollment will become available starting [_1], you are ineligible for enrollment.'
=> 'Although self-enrollment will become available starting [_1], you are ineligible for enrollment.',

   'Self-enrollment will become available starting [_1].'
=> 'Self-enrollment will become available starting [_1].',

   'The link to the requested page could not be followed.'
=> 'The link to the requested page could not be followed.',

   'The placeholder for the courseID is absent.'
=> 'The placeholder for the courseID is absent.',

   'LON-CAPA account required'
=> 'LON-CAPA account required',

   'You need to be logged into LON-CAPA to self-enroll in a course.'
=> 'You need to be logged into LON-CAPA to self-enroll in a course.',

   'If you have an account in LON-CAPA, [_1]log-in[_2].'
=> 'If you have an account in LON-CAPA, [_1]log-in[_2].',

   'Otherwise:'
=> 'Otherwise:',

   "if you have an institutional log-in, use your institution's [_1]single sign on page[_2] to log-in, then create an account"
=> "if you have an institutional log-in, use your institution's [_1]single sign on page[_2] to log-in, then create an account",

   'if you have an institutional login, [_1]create an account[_2]'
=> 'if you have an institutional login, [_1]create an account[_2]',

   'you can use an e-mail address to [_1]create an account[_2]'
=> 'you can use an e-mail address to [_1]create an account[_2]',

   'Otherwise, if you have an institutional login, [_1]create an account[_2].'
=> 'Otherwise, if you have an institutional login, [_1]create an account[_2].',

   'Otherwise, you will use an e-mail address to [_1]create an account[_2].'
=> 'Otherwise, you will use an e-mail address to [_1]create an account[_2].',

   "Otherwise, use your institution's [_1]single sign on page[_2] to log-in, then create an account."
=> "Otherwise, use your institution's [_1]single sign on page[_2] to log-in, then create an account.",

   'You will be able to self enroll in this course once the account has been created.'
=> 'You will be able to self enroll in this course once the account has been created.',

   'You will be able to self-enroll in the course you selected ([_1]) after you have successfully logged in.'
=> 'You will be able to self-enroll in the course you selected ([_1]) after you have successfully logged in.',

   'You must [_1]log-in[_2] to LON-CAPA with an existing account to be able to enroll in this course, as account creation at this institution ([_3]) is not permitted when self-enrolling.'
=> 'You must [_1]log-in[_2] to LON-CAPA with an existing account to be able to enroll in this course, as account creation at this institution ([_3]) is not permitted when self-enrolling.',

   'You already have an active student role (section: "[_1]") in this course.'
=> 'You already have an active student role (section: "[_1]") in this course.',

   'You have a student role (section: "[_1]") in this course which will become active [_2].'
=> 'You have a student role (section: "[_1]") in this course which will become active [_2].',

   'Self-enrollment is restricted to officially registered students.'
=> 'Self-enrollment is restricted to officially registered students.',

   'As you are not currently registered for this course, self-enrollment is unavailable.'
=> 'As you are not currently registered for this course, self-enrollment is unavailable.',

   'The end date for access to this course for users who self-enroll has passed.'
=> 'The end date for access to this course for users who self-enroll has passed.',

   'Consequently, although a new role was created for you in the course, it is an inactive role which does not provide access to the course.'
=> 'Consequently, although a new role was created for you in the course, it is an inactive role which does not provide access to the course.',

   'Self-enrollment in this course was successful.'
=> 'Self-enrollment in this course was successful.',

   'The start date for access to this course for users who self-enroll has yet to be reached.'
=> 'The start date for access to this course for users who self-enroll has yet to be reached.',

   'Consequently, although a new role was created for you in the course, you will not be able to select this role until [_1].'
=> 'Consequently, although a new role was created for you in the course, you will not be able to select this role until [_1].',

   'Your new role is available immediately, and will provide access to the course until [_1].'
=> 'Your new role is available immediately, and will provide access to the course until [_1].',

   'Enrollment process complete'
=> 'Enrollment process complete',

   'Enrollment incomplete'
=> 'Enrollment incomplete',

   'Self-enrollment in this course failed.'
=> 'Self-enrollment in this course failed.',

   'You are not permitted to enroll yourself in this course.'
=> 'You are not permitted to enroll yourself in this course.',

   'Enter course now'
=> 'Enter course now',

   'other'
=> 'other',

   'Self-enrollment in this course is available to any user affiliated with [_1].'
=> 'Self-enrollment in this course is available to any user affiliated with [_1].',

   'Self-enrollment in this course is only available to users in affiliated with [_1] who have the following status: "[_2]".'
=> 'Self-enrollment in this course is only available to users in affiliated with [_1] who have the following status: "[_2]".',

   'Self-enrollment is not currently available for this course for users affiliated with [_1].'
=> 'Self-enrollment is not currently available for this course for users affiliated with [_1].',

   'Self-enrollment in this course is only available to users affiliated with the following institutions, and who have the required status:'
=> 'Self-enrollment in this course is only available to users affiliated with the following institutions, and who have the required status:',

   'Your registration status could not be verified.'
=> 'Your registration status could not be verified.',

   'Your registration status could not determined, because a problem occurred retrieving data.'
=> 'Your registration status could not determined, because a problem occurred retrieving data.',

   'As no institutional course sections are currently associated with this course, your registration status is undetermined.'
=> 'As no institutional course sections are currently associated with this course, your registration status is undetermined.',

   '[_1]Ad hoc[_2] roles in domain [_3] --'
=> '[_1]Ad hoc[_2] roles in domain [_3] --',

   'Assemble resources'
=> '布置课程内容',

   'Create, edit, modify and publish resources'
=> 'Create, edit, modify and publish resources',

   'Create, modify and delete course groups'
=> 'Create, modify and delete course groups',

   'View course groups'
=> '查看课程组',

   'View student activity'
=> 'View student activity',

   'Show full details for each course ([_1] only)'
=> 'Show full details for each course ([_1] only)',

   'Include courses set to be hidden from catalog ([_1] only)'
=> 'Include courses set to be hidden from catalog ([_1] only)',

   'Include subcategories within "[_1]"'
=> '包含子类 "[_1]"',

   'Only show courses which allow self-enrollment'
=> '只显示允许自行登记的课程',

   'include subdirectories'
=> '包括子目录',

   'force republication of previously published files'
=> 'force republication of previously published files',

   'make file(s) obsolete'
=> 'make file(s) obsolete',

   'force directory level catalog information over existing'
=> 'force directory level catalog information over existing',

   'Session could not be opened.'
=> 'Session could not be opened.',

   'The domain you provided is not a valid LON-CAPA domain.'
=> 'The domain you provided is not a valid LON-CAPA domain.',

   'Student Settings'
=> 'Student Settings',

   'Coordinator Settings'
=> 'Coordinator Settings',

   'Author Settings'
=> 'Author Settings',

   'Administrator Settings'
=> 'Administrator Settings',

   'Item'
=> 'Item',

   'Found [_1] without responses. This resource cannot be published.'
=> 'Found [_1] without responses. This resource cannot be published.',

   'LON-CAPA helpdesk'
=> 'LON-CAPA helpdesk',

   'Create a user account in LON-CAPA'
=> 'Create a user account in LON-CAPA',

   'Account creation unavailable'
=> 'Account creation unavailable',

   'Error creating token.'
=> 'Error creating token.',

   'Account creation'
=> 'Account creation',

   'Creation of a new user account using an e-mail address or an institutional log-in ID as username is not permitted at this institution: ([_1]).'
=> 'Creation of a new user account using an e-mail address or an institutional log-in ID as username is not permitted at this institution: ([_1]).',

   'Creation of a new LON-CAPA user account using an e-mail address or an institutional log-in ID as your username is not permitted at [_1].'
=> 'Creation of a new LON-CAPA user account using an e-mail address or an institutional log-in ID as your username is not permitted at [_1].',

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account in this domain."
=> "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account in this domain.",

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account at this institution, and you are not permitted to create one."
=> "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account at this institution, and you are not permitted to create one.",

   "Although your username and password were authenticated, you do not currently have a LON-CAPA account at this institution."
=> "Although your username and password were authenticated, you do not currently have a LON-CAPA account at this institution.",

   "Although your username and password were authenticated, you do not currently have a LON-CAPA account in this domain, and you are not permitted to create one."
=> "Although your username and password were authenticated, you do not currently have a LON-CAPA account in this domain, and you are not permitted to create one.",

   'A LON-CAPA account may not be created with the username you use.'
=> 'A LON-CAPA account may not be created with the username you use.',

   'User Information'
=> 'User Information',

   'User information'
=> 'User information',

   'Review user information'
=> 'Review user information',

   'To create one, use the table below to provide information about yourself (if appropriate), then click the "Create LON-CAPA account" button.'
=> 'To create one, use the table below to provide information about yourself (if appropriate), then click the "Create LON-CAPA account" button.',

   'To create one, use the table below to provide information about yourself, then click the [_1]Create LON-CAPA account[_2] button.'
=> 'To create one, use the table below to provide information about yourself, then click the [_1]Create LON-CAPA account[_2] button.',

   'A user account will be created with information displayed in the table below, when you click the [_1]Create LON-CAPA account[_2] button.'
=> 'A user account will be created with information displayed in the table below, when you click the [_1]Create LON-CAPA account[_2] button.',

   'Confirmation'
=> 'Confirmation',

   'Confirm that you wish to create an account.'
=> 'Confirm that you wish to create an account.',

   'New username'
=> 'New username',

   'Create account'
=> 'Create account',

   'You must enter a password'
=> 'You must enter a password',

   'The passwords you entered did not match.'
=> 'The passwords you entered did not match.',

   'Create account with a username provided by this institution'
=> 'Create account with a username provided by this institution',

   'If you already have a log-in ID at this institution,[_1] you may be able to use it for LON-CAPA.'
=> 'If you already have a log-in ID at this institution,[_1] you may be able to use it for LON-CAPA.',

   'Type in your log-in ID and password to find out.'
=> 'Type in your log-in ID and password to find out.',

   'Log-in ID'
=> 'Log-in ID',

   'Create account with an e-mail address as your username'
=> 'Create account with an e-mail address as your username',

   'Provide your e-mail address to request a LON-CAPA account,[_1] if you do not have a log-in ID at your institution.'
=> 'Provide your e-mail address to request a LON-CAPA account,[_1] if you do not have a log-in ID at your institution.',

   'Request LON-CAPA account'
=> 'Request LON-CAPA account',

   'Validation'
=> 'Validation',

   'Thank you for your request to create a new LON-CAPA account.'
=> 'Thank you for your request to create a new LON-CAPA account.',

   'A request was submitted on [_1] for creation of a LON-CAPA account at the following institution:[_2].'
=> 'A request was submitted on [_1] for creation of a LON-CAPA account at the following institution:[_2].',

   'To complete this process please open a web browser and enter the following URL in the address/location box: [_1]'
=> 'To complete this process please open a web browser and enter the following URL in the address/location box: [_1]',

   'A message has been sent to the e-mail address you provided.'
=> 'A message has been sent to the e-mail address you provided.',

   'The message includes the web address for the link you will use to complete the account creation process.'
=> 'The message includes the web address for the link you will use to complete the account creation process.',

   'The link included in the message will be valid for the next [_1]two[_2] hours.'
=> 'The link included in the message will be valid for the next [_1]two[_2] hours.',

   'An error occurred when sending a message to the e-mail address you provided.'
=> 'An error occurred when sending a message to the e-mail address you provided.',

   'An error occurred creating a token required for the account creation process.'
=> 'An error occurred creating a token required for the account creation process.',

   'Please contact the [_1] ([_2]) for assistance.'
=> 'Please contact the [_1] ([_2]) for assistance.',

   'Sorry, the URL you provided to complete creation of a new LON-CAPA account was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid.'
=> 'Sorry, the URL you provided to complete creation of a new LON-CAPA account was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid.',

   'Sorry, the token generated when you requested creation of an account has expired.'
=> 'Sorry, the token generated when you requested creation of an account has expired.',

   'Sorry, the URL generated when you requested creation of an account contained incomplete information.'
=> 'Sorry, the URL generated when you requested creation of an account contained incomplete information.',

   'Please submit a [_1]new request[_2] for account creation and follow the new link included in the e-mail that will be sent to you.'
=> 'Please submit a [_1]new request[_2] for account creation and follow the new link included in the e-mail that will be sent to you.',

   'A LON-CAPA account for the institution: [_1] has been created [_2] from IP address: [_3]. If you did not perform this action or authorize it, please contact the [_4] ([_5]).'
=> 'A LON-CAPA account for the institution: [_1] has been created [_2] from IP address: [_3]. If you did not perform this action or authorize it, please contact the [_4] ([_5]).',

   'A LON-CAPA account already exists for username [_1] at this institution ([_2]).'
=> 'A LON-CAPA account already exists for username [_1] at this institution ([_2]).',

   'The password entered was also correct so you have been logged in.'
=> 'The password entered was also correct so you have been logged in.',

   'Authentication failed'
=> 'Authentication failed',

   'An e-mail confirming creation of your new LON-CAPA account has been sent to [_1].'
=> 'An e-mail confirming creation of your new LON-CAPA account has been sent to [_1].',

   'An error occurred when sending e-mail to [_1] confirming creation of your LON-CAPA account.'
=> 'An error occurred when sending e-mail to [_1] confirming creation of your LON-CAPA account.',

   'A problem occurred when attempting to create your new LON-CAPA account.'
=> 'A problem occurred when attempting to create your new LON-CAPA account.',

   'Please provide user information and a password for your new account.'
=> 'Please provide user information and a password for your new account.',

   'Your password, which must contain at least seven characters, will be sent to the LON-CAPA server in an encrypted form.'
=> 'Your password, which must contain at least seven characters, will be sent to the LON-CAPA server in an encrypted form.',

   'Create LON-CAPA account'
=> 'Create LON-CAPA account',

   'Could not load javascript file [_1]'
=> 'Could not load javascript file [_1]',

   'Invalid ID format'
=> 'Invalid ID format',

   'An error occurred when storing a token'
=> 'An error occurred when storing a token',

   'You will not be able to proceed to the next stage of account creation'
=> 'You will not be able to proceed to the next stage of account creation',

   'A LON-CAPA account has been created for username: [_1] in domain: [_2].'
=> 'A LON-CAPA account has been created for username: [_1] in domain: [_2].',

   'Account creation failed for username: [_1] in domain: [_2].'
=> 'Account creation failed for username: [_1] in domain: [_2].',

   'User account creation is not available for the current default authentication type.'
=> 'User account creation is not available for the current default authentication type.',

   'The e-mail address you provided is already in use as a username at this institution.'
=> 'The e-mail address you provided is already in use as a username at this institution.',

   'Username rules at this institution do not allow the e-mail address you provided to be used as a username.'
=> 'Username rules at this institution do not allow the e-mail address you provided to be used as a username.',

   'The e-mail address you provided may not be used as a username at this LON-CAPA institution.'
=> 'The e-mail address you provided may not be used as a username at this LON-CAPA institution.',

   'Validation of the code you entered failed.'
=> 'Validation of the code you entered failed.',

   'Creation of a new user account using an e-mail address as username is not permitted at this LON-CAPA institution.'
=> 'Creation of a new user account using an e-mail address as username is not permitted at this LON-CAPA institution.',

   'Type in the letters/numbers shown below'
=> 'Type in the letters/numbers shown below',

   'You may need to reload the previous page to obtain a new token.'
=> 'You may need to reload the previous page to obtain a new token.',

   'Unable to retrieve your log-in information - unexpected context'
=> 'Unable to retrieve your log-in information - unexpected context',

   "Your e-mail address uses the same internet domain as your institution's LON-CAPA service."
=> "Your e-mail address uses the same internet domain as your institution's LON-CAPA service.",

   'Creation of a LON-CAPA account with this type of e-mail address as username is not permitted.'
=> 'Creation of a LON-CAPA account with this type of e-mail address as username is not permitted.',

   'You should request creation of a LON-CAPA account for a log-in ID of "[_1]" at your institution instead.'
=> 'You should request creation of a LON-CAPA account for a log-in ID of "[_1]" at your institution instead.',

   'Changes/page:'
=> '每页显示列数：',

   'Window during which changes occurred:'
=> '在这个时期发生的变化：',

   'This page is either empty or it only contains resources that are currently hidden'
=> 'This page is either empty or it only contains resources that are currently hidden',

   'Please use the LON-CAPA navigation arrows to move to another item in the course'
=> 'Please use the LON-CAPA navigation arrows to move to another item in the course',

   'Unable to modify requested student ([_1])'
=> 'Unable to modify requested student ([_1])',

   'Unable to grade requested sequence ([_1]).'
=> 'Unable to grade requested sequence ([_1]).',

   'No score was changed or updated.'
=> 'No score was changed or updated.',

   'The scores were changed for [quant,_1,problem].'
=> 'The scores were changed for [quant,_1,problem].',

   '[_1]Visit the [_2]Course/Community Catalog[_3][_4] to view all [_5] LON-CAPA courses and communities.' # _1: <b>, _2: <a>, _3: </a>, _4: </b>, _5: domain desc.
=> '[_1]Visit the [_2]Course/Community Catalog[_3][_4] to view all [_5] LON-CAPA courses and communities.',

   'If a course or community is [_1]not[_2] in your list of current courses and communities below, you may be able to enroll if self-enrollment is permitted.'
=> 'If a course or community is [_1]not[_2] in your list of current courses and communities below, you may be able to enroll if self-enrollment is permitted.', # '如果一个课程在下面列出您目前的课程中[_1]没有[_2]显示，你可以注册，如果自我注册是允许的。',

#SD begin 2008-07-02
   'When'
=> '什么时候',

   'Who made the change'
=> '谁进行了修改',

   'Changed User'
=> '改变用户',

   'Context'
=> '概述',

   'Context:'
=> '概述：',

   'After:'
=> '之后：',

   'Before:'
=> '之前：',

   'User Changes'
=> '用户更改',

   'For this user, the default quota would be [_1]'
=> '此使用者的默认的配额为[_1]',

   'Search for a user and enroll as a student'
=> '搜索用户并注册为学生',

   'username is known'
=> 'username is known',

   'Create a new user'
=> '创建一个新用户',

   'Enroll'
=> '注册',

   'User Search to enroll student'
=> 'User Search to enroll student',

   'Select a user to enroll as a student'
=> 'Select a user to enroll as a student',

   'modify' #context? breadcrumb_text
=> 'modify',

   'as a student'
=> '作为一名学生',

   'Set section/dates'
=> '设置章节/日期',

   'Unknown'
=> 'Unknown',

   'You do not have privileges to assign co-author roles.'
=> 'You do not have privileges to assign co-author roles.',

   'This user has an unrecognized authentication scheme'
=> 'This user has an unrecognized authentication scheme',

   'Please alert a domain coordinator of this situation'
=> 'Please alert a domain coordinator of this situation',

   'Please specify login data below'
=> 'Please specify login data below',

   'No domain specified'
=> 'No domain specified',

   'Invalid domain name'
=> 'Invalid domain name',

   'Only letters, numbers, periods, dashes, and underscores are valid'
=> 'Only letters, numbers, periods, dashes, and underscores are valid',

   'You do not have the authority to modify this users authentification information'
=> 'You do not have the authority to modify this users authentification information',

   'New Student/Employee ID does not match existing ID for this user.'
=> 'New Student/Employee ID does not match existing ID for this user.',

   "Change is not permitted without checking the 'Force ID change' checkbox on the previous page."
=> "Change is not permitted without checking the 'Force ID change' checkbox on the previous page.",

   'Unable to successfully change environment for'
=> 'Unable to successfully change environment for',

   'No roles'
=> 'No roles',

   'The following fields were not updated: '
=> 'The following fields were not updated: ',

   "You do not have the authority to change these fields given the user's current set of active/future course roles:"
=> "You do not have the authority to change these fields given the user's current set of active/future course roles:",

   "You do not have the authority to change these fields given the user's current set of active/future co-author roles:"
=> "You do not have the authority to change these fields given the user's current set of active/future co-author roles:",

   "You do not have the authority to change this field given the user's current set of active/future course roles:"
=> "You do not have the authority to change this field given the user's current set of active/future course roles:",

   "You do not have the authority to change this field given the user's current set of active/future co-author roles:"
=> "You do not have the authority to change this field given the user's current set of active/future co-author roles:",


   'Please contact your [_1]helpdesk[_2] for more information.'
=> 'Please contact your [_1]helpdesk[_2] for more information.',

   '<b>[_1]</b> enrolled'
=> '<b>[_1]</b> 注册的',

   'in section [_1]'
=> 'in section [_1]',

   'Access starts immediately'
=> '访问立即开始',

   'Access starts: '
=> '访问开始： ',

   'ends: no ending date'
=> '结束：没有结束日期',

   'ends: '
=> '结束： ',

   'If the student is currently logged-in to LON-CAPA, the new role will be available when the student next logs in.'
=> 'If the student is currently logged-in to LON-CAPA, the new role will be available when the student next logs in.',

   '(default)'
=> '(默认的)',

   '(default for [_1])'
=> '(默认 [_1])',

   'You are not authorized to make bulk changes to user roles'
=> 'You are not authorized to make bulk changes to user roles',

   'You do not have permission to modify dates or sections for users'
=> 'You do not have permission to modify dates or sections for users',

   'deleted'
=> 'deleted',

   'No start date'
=> '没有开始日期',

   'Previous [_1] changes'
=> 'Previous [_1] changes',

   'Next [_1] changes'
=> 'Next [_1] changes',

   'There are no records to display.'
=> '没有记录显示。',

   'There are no transactions to display.'
=> 'There are no transactions to display.',

   'Automated enrollment'
=> '自动注册',

   'Roster Update'
=> '名册更新',

   'Course Creation'
=> '创建课程',

   'User Management in course'
=> '在课程中的用户管理',

   'User Management in domain'
=> '在域中的用户管理',

   'Self-enrolled'
=> '自助注册',

   'Your search term must contain more than just spaces.'
=> 'Your search term must contain more than just spaces.',

   'this course'
=> '本课程',

   'LON-CAPA domain: '
=> 'LON-CAPA domain: ',

   'the institutional directory for domain: '
=> 'the institutional directory for domain: ',

   'Please contact the [_1]helpdesk[_2] if you need to create a new user.'
=> 'Please contact the [_1]helpdesk[_2] if you need to create a new user.',

   'Section for self-enrolled users unchanged as the proposed section is a group'
=> 'Section for self-enrolled users unchanged as the proposed section is a group',

   'Group names and section names must be distinct'
=> '组名称和章节的名称必须是不同的',

   'Section for self-enrolled users unchanged, as "all" is a reserved section name.'
=> 'Section for self-enrolled users unchanged, as "all" is a reserved section name.',

   'An error occurred when saving changes to self-enrollment settings in this course.'
=> 'An error occurred when saving changes to self-enrollment settings in this course.',

#SD end 2008-07-02

   'Server Switch Required'
=> 'Server Switch Required',

   'Authoring Space access is only available from the home server of the corresponding Author.'
=> 'Authoring Space access is only available from the home server of the corresponding Author.',

   "Click the 'Switch Server' link to go there."
=> "Click the 'Switch Server' link to go there.",

   'Default in use:'
=> '默认情况下使用：',

   'Self-creation of account by users with status: [_1]'
=> 'Self-creation of account by users with status: [_1]',

   'modifiable fields (if institutional data blank): '
=> 'modifiable fields (if institutional data blank): ',

   'Source Code'
=> 'Source Code',

   'Copy Problem Source Code to Authoring Space'
=> 'Copy Problem Source Code to Authoring Space',

   'Please enter the directory that you would like the source code to go into.'
=> 'Please enter the directory that you would like the source code to go into.',

   'Note: the path is in reference to the root of your Authoring Space, and new directories will be automatically created.'
=> 'Note: the path is in reference to the root of your Authoring Space, and new directories will be automatically created.',

   'shared_source'
=> 'shared_source',

   'Copy to Authoring Space'
=> 'Copy to Authoring Space',

   '[_1]W[_2]ARNING' 
=> '[_1]W[_2]ARNING',

   'At end of file some tags were still left unclosed:'
=> 'At end of file some tags were still left unclosed:',

   'Unable to save file [_1]'
=> 'Unable to save file [_1]',

   'Warnings and Errors'
=> 'Warnings and Errors',

   'Edit Math'
=> 'Edit Math',

   'DragMath Latex Equation Editor'
=> 'DragMath Latex Equation Editor',

   '[_1]Return[_2] to editing resource.'
=> '[_1]Return[_2] to editing resource.',

   'Counting pages for student: [_1]'
=> 'Counting pages for student: [_1]',

   'LaTeX could not successfully parse your tex file.'
=> 'LaTeX could not successfully parse your tex file.',

   'It probably has errors in it.'
=> 'It probably has errors in it.',

   'Here are the error messages in the LaTeX log file:'
=> 'Here are the error messages in the LaTeX log file:',

   'There are errors in [_1].'
=> 'There are errors in [_1].',

   'There are errors.'
=> 'There are errors.',

   'These errors prevent this resource from printing correctly.'
=> 'These errors prevent this resource from printing correctly.',

   'A message has been sent to the instructor describing this failure.'
=> 'A message has been sent to the instructor describing this failure.',

   'You are running LaTeX in [_1]batch mode[_2].'
=> 'You are running LaTeX in [_1]batch mode[_2].',

   'It has found an error in [_1][_2]and corrected it.'
=> 'It has found an error in [_1][_2]and corrected it.',

   'Usually this correction is valid but you probably need to check the indicated resource one more time and implement neccessary corrections by yourself.'
=> 'Usually this correction is valid but you probably need to check the indicated resource one more time and implement neccessary corrections by yourself.',

   'The link to [_1]Your log file[_2]'
=> 'The link to [_1]Your log file[_2]',

   'The link to [_1]Your original LaTeX file[_2]'
=> 'The link to [_1]Your original LaTeX file[_2]',

   'bomb'
=> 'bomb',

   'Output Tags'
=> 'Output Tags',

   'WARNING: Cannot connect to database!'
=> '警告：无法连接到数据库！',

   'Error occurred saving new values in metadata table in LON-CAPA database!'
=> '保存新值数据表到LON-CAPA数据库中时发生错误！',

   'Your course/community currently appears in the Course/Community Catalog for this domain.'
=> 'Your course/community currently appears in the Course/Community Catalog for this domain.',

   'Courses can be both self-cataloging, based on an institutional code (e.g., fs08phy231), or can be assigned categories from a hierarchy defined for the domain.'
=> '课程可自我编目的基础的研究所代码（例如， inf_20112012_math1 ）或可通过域的定义分配类别界定。',

   'Your course/community does not currently appear in the Course/Community Catalog for this domain.'
=> 'Your course/community does not currently appear in the Course/Community Catalog for this domain.',

   'You should remedy this if you plan to allow self-enrollment, otherwise students will have difficulty finding your course.'
=> 'You should remedy this if you plan to allow self-enrollment, otherwise students will have difficulty finding your course.',

   'Courses can be absent from the Catalog, because they do not have an institutional code, have no assigned category, or have been specifically excluded.'
=> 'Courses can be absent from the Catalog, because they do not have an institutional code, have no assigned category, or have been specifically excluded.',

   'Make any changes to self-enrollment settings below, click "Save changes", then take action to include the course in the Catalog:'
=> 'Make any changes to self-enrollment settings below, click "Save changes", then take action to include the course in the Catalog:',

   'Take the following action to ensure the course appears in the Catalog:'
=> 'Take the following action to ensure the course appears in the Catalog:',

   'Ask a domain coordinator to change the "Exclude from course catalog" setting.'
=> 'Ask a domain coordinator to change the "Exclude from course catalog" setting.',

   'Ask a domain coordinator to enable display the catalog of "Official courses (with institutional codes)".'
=> 'Ask a domain coordinator to enable display the catalog of "Official courses (with institutional codes)".',

   'Ask a domain coordinator to assign an institutional code (if this is an official course).'
=> 'Ask a domain coordinator to assign an institutional code (if this is an official course).',

   'Ask a domain coordinator to enable or create at least one course category in the domain.'
=> 'Ask a domain coordinator to enable or create at least one course category in the domain.',

   'Ask a domain coordinator to create a hierarchy of categories and sub categories for courses in the domain.'
=> 'Ask a domain coordinator to create a hierarchy of categories and sub categories for courses in the domain.',

   'Ask a domain coordinator to change the category assigned to the course, as the one currently assigned is no longer used in the domain'
=> 'Ask a domain coordinator to change the category assigned to the course, as the one currently assigned is no longer used in the domain',

   'Ask a domain coordinator to assign a category to the course.'
=> 'Ask a domain coordinator to assign a category to the course.',

   'Use [_1]Categorize course[_2] to change the "Exclude from course catalog" setting.'
=> 'Use [_1]Categorize course[_2] to change the "Exclude from course catalog" setting.',

   'Use [_1]Set course environment[_2] to change the category assigned to the course, as the one currently assigned is no longer used in the domain.'
=> 'Use [_1]Set course environment[_2] to change the category assigned to the course, as the one currently assigned is no longer used in the domain.',

   'Use [_1]Set course environment[_2] to assign a category to the course.'
=> 'Use [_1]Set course environment[_2] to assign a category to the course.',

   'You are able to both assign a course category and choose to exclude this course from the catalog.'
=> 'You are able to both assign a course category and choose to exclude this course from the catalog.',

   'You are able to choose to exclude this course from the catalog, but only a Domain Coordinator may assign a course category.'
=> 'You are able to choose to exclude this course from the catalog, but only a Domain Coordinator may assign a course category.',

   'You may assign a course category, but only a Domain Coordinator may choose to exclude this course from the catalog.'
=> 'You may assign a course category, but only a Domain Coordinator may choose to exclude this course from the catalog.',

   'Only a Domain Coordinator may assign a course category or choose to exclude this course from the catalog.'
=> 'Only a Domain Coordinator may assign a course category or choose to exclude this course from the catalog.',

   "Please use the 'Select Course' link to open a separate pick course window where you may select the course you wish to enter"
=> "Please use the 'Select Course' link to open a separate pick course window where you may select the course you wish to enter",

   'You can only use this screen to select courses in the current domain.'
=> 'You can only use this screen to select courses in the current domain.',

   '[_1]Your Excel spreadsheet[_2] is ready for download.'
=> '[_1]Your Excel spreadsheet[_2] is ready for download.',

   '[_1]Your CSV file[_2] is ready for download.'
=> '[_1]Your CSV file[_2] is ready for download.',

   'Name (username)'
=> 'Name (username)',

   'Grades Assigned'
=> 'Grades Assigned',

   'Comments'
=> '注释',

   'No Course Data'
=> 'No Course Data',

   'Error getting student data ([_1])'
=> 'Error getting student data ([_1])',

   'Score'
=> 'Score',

   'score'
=> 'score',

   'Display Options'
=> '显示选项',

   'This role has section(s) associated with it.'
=> 'This role has section(s) associated with it.',

   'Enter a specific section.'
=> 'Enter a specific section.',

   'Enter a specific section, or leave blank for no section.'
=> 'Enter a specific section, or leave blank for no section.',

   'Available sections are:'
=> 'Available sections are:',

   'You entered an invalid section choice:'
=> 'You entered an invalid section choice:',

   'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3] domain.'
=> '您不妨联系[_2][_3]域的[_1] LON-CAPA 求助。',

   '([_1] time zone)'
=> '(时区 [_1])',

   'Selecting an Author'
=> 'Selecting an Author',

   'Invalid domain'
=> '无效域',

   'There are no library servers containing Authoring Spaces currently in domain: [_1], so you can not assume a co-author role.'
=> 'There are no library servers containing Authoring Spaces currently in domain: [_1], so you can not assume a co-author role.',

   'You do not have a domain coordinator role in domain: [_1], so you cannot choose an Authoring Space for which you can assume a co-author role.'
=> 'You do not have a domain coordinator role in domain: [_1], so you cannot choose an Authoring Space for which you can assume a co-author role.',

   'You do not have a domain coordinator role, so you cannot choose an Authoring Space for which you can assume a co-author role.'
=> 'You do not have a domain coordinator role, so you cannot choose an Authoring Space for which you can assume a co-author role.',

   'There are no author roles currently in domain: [_1], so there are no Authoring Spaces for which you can assume a co-author role.'
=> 'There are no author roles currently in domain: [_1], so there are no Authoring Spaces for which you can assume a co-author role.',

   'As your session file for the course or community has expired, you will need to re-select it.'
=> 'As your session file for the course or community has expired, you will need to re-select it.', # '当>您的课程已过期，您将需要重新选择课程。',

   '[quant,_1,yr]'
=> '[quant,_1,yr]',

   '[quant,_1,mth]'
=> '[quant,_1,mth]',

   '[quant,_1,hr]'
=> '[quant,_1,hr]',

   '[quant,_1,min]'
=> '[quant,_1,min]',

   '[quant,_1,sec]'
=> '[quant,_1,sec]',

   'Loading student data...'
=> '检索学生数据...',

   'Options'
=> '选项',

   'Time Period'
=> '周期',

   'Resource is undefined.'
=> 'Resource is undefined.',

   'Plot Graph'
=> 'Plot Graph',

   'Download'
=> '下载',

   'PDF File'
=> 'PDF 文档',

   'Zip File'
=> 'ZIP 文档',

   'File Size (Bytes)'
=> '文件大小 (Bytes)',

   'Contents'
=> '内容',

   'Problem Type'
=> '问题类型',

   'not in this course'
=> 'not in this course',
#Start: redesigned menus
#lonparmset.pm

   'Edit environment settings for this course.'
=> 'Edit environment settings for this course.',

   'Portfolio Metadata'
=> '元数据-组合',

   'Settings for this Course'
=> '设置这门课程',

   'New and Existing Parameter Settings for Resources'
=> '新的和现有资源的参数设置',

   'Edit Resource Parameters - Helper Mode'
=> '编辑源参数 - 辅助模式',

   'Edit Resource Parameters - Overview Mode'
=> '编辑资源参数 - 概况模式',

   'Edit Resource Parameters - Table Mode'
=> '编辑资源参数 - 表模式',

   'Existing Parameter Settings for Resources'
=> '现有资源的参数设置',

   'Change Log'
=> '变更记录',

   'Restrict metadata for this course.'
=> 'Restrict metadata for this course.',

   'Manage slots for this course.'
=> 'Manage slots for this course.',

   'Reset access times for folders/maps, resources or the course.'
=> 'Reset access times for folders/maps, resources or the course.',

   'Set default actions for parameters.'
=> 'Set default actions for parameters.',

   'Set/Modify resource parameters in helper mode.'
=> 'Set/Modify resource parameters in helper mode.',

   'Set/Modify resource parameters in table mode.'
=> 'Set/Modify resource parameters in table mode.',

   'Set/Modify resource parameters in overview mode.'
=> 'Set/Modify resource parameters in overview mode.',

   'Set/Modify existing resource parameters in overview mode.'
=> 'Set/Modify existing resource parameters in overview mode.',

   'View parameter and course blog posting/user notification change log.'
=> 'View parameter and course blog posting/user notification change log.',
#lonpreferences.pm

   'Screen Name'
=> '昵称',

   'Screenname'
=> '昵称',

   'Nickname'
=> '昵称',

   'Messages &amp; Notifications'
=> '邮件＆公告',

   'Discussion Display'
=> '讨论显示',

   'Page Display Settings'
=> '页面显示设置',

   'Color Scheme'
=> '颜色方案',

   'Menu Display'
=> '菜单显示',

   'Content Display Settings'
=> '内容显示设置',

   'WYSIWYG Editor'
=> 'WYSIWYG-编辑器',

   'Roles Page'
=> '角色页面',

   'Display of Scientific Equations'
=> '显示科学公式',

   'Edit information about yourself that should be displayed on your public profile.'
=> 'Edit information about yourself that should be displayed on your public profile.',

   'Change the name that is displayed in your posts.'
=> '变更在您的讨论中的名称。',

   'Change LON-CAPA default colors.'
=> 'Change LON-CAPA default colors.',

   'Change messageforwarding or notifications settings.'
=> 'Change messageforwarding or notifications settings.',

   'Choose the default language for this user.'
=> 'Choose the default language for this user.',

   'Enable or disable the WYSIWYG-Editor.'
=> 'Enable or disable the WYSIWYG-Editor.',

   'Configure the roles hotlist.'
=> 'Configure the roles hotlist.',

   'Change how Scientific Equations are displayed.'
=> '改变如何显示科学方程。',

   'Register your clicker.'
=> '登记您的应答设备 (遥控).',

   'Change your password.'
=> '更改您的密码。',

   'Launch the remote control for LON-CAPA.'
=> 'Launch the remote control for LON-CAPA.',

   'Collapse the remote control for LON-CAPA.'
=> 'Collapse the remote control for LON-CAPA.',

   'Restrict domain coordinator access.'
=> 'Restrict domain coordinator access.',

   'Set the default page to be displayed when you select a course role.'
=> 'Set the default page to be displayed when you select a course role.',

   'Toggle Debug Messages.'
=> 'Toggle Debug Messages.',

   'Change whether the menus are displayed with buttons, icons or icons and text.'
=> 'Change whether the menus are displayed with buttons, icons or icons and text.',
   'Course Initialization'
=> '课程初始化',
#loncreateuser.pm
   'Single Users'
=> '单用户',

   'Upload a CSV or a text file containing users.'
=> '课程参加者上传CSV或文本文件。',

   'Add a user with a certain role to this course.'
=> '添加一个具有特定的角色的用户到这门课程中。',

   'Add/Modify a Student'
=> '添加/修改学生',

   'Add a user with the role student to this course.'
=> '添加一个用户到课程中，作为学生角色。',

   'Configuration'
=> '设置',

   'Automated enrollment manager.'
=> '管理自助注册',

   'Self-Enrollment'
=> 'Self-Enrollment',

   'User Self-Enrollment'
=> '用户自助注册',

   'Configure user self-enrollment.'
=> '配置用户自助注册。',

   'Manage course groups.'
=> '管理课程组。',

   'Change Logs'
=> '更改记录',

   'View change log.'
=> '显示更改记录。',

   'Administration'
=> '管理',

   'Manage Course Users'
=> '用户课程管理',

   'Show and manage users of this course.'
=> '查看和管理这门课程的用户。',

   'Remove a student from this course.'
=> '从这门课程中移除一名学生。',

   'Custom Roles'
=> '自定义角色',

   'Configure a custom role.'
=> '配置自定义角色。',

   'Multiple Users'
=> '多用户',

#lonstatistics.pm
   'Statistics and Analyses'
=> '统计与分析',

   'Plots'
=> '图表',

   'Reports'
=> '报告',

   'Personal Homepage'
=> '个人主页',

   'Link Name:'
=> '连接的名字：',

   'Address:'
=> '地址：',

   'Link Name'
=> '连接的名字',

   'Address'
=> '地址',

   'Broadcast to Active Members'
=> '通知活跃的会员',

   'Thank you for your input!'
=> '非常感谢您的评估！',

   'Saving feedback: [_1]'
=> '保存到信息反馈： [_1]',

   'Logging first evaluation'
=> '登录到首次评估',

   'The WYSIWYG editor only supports simple HTML and is in many cases unsuited for advanced authoring. In a number of cases, it may destroy advanced authoring involving LaTeX and script function calls.'
=> 'WYSIWYG 编辑器仅支持简单的 HTML，并且在许多情况下不适合复杂的创作。在一些情况下，它可能破坏复杂的创作及 LaTeX 和脚本函数的调用。',

   'Special Admin Options'
=> '特别管理选项',

   'Discussion postings'
=> '讨论帖子',

   'Currently using [_1] of the [_2] available.'
=> '目前使用 [_1] ，在 [_2] 可用中。',

   'Registering clickers: [_1]'
=> '注册的“遥控”号码为： [_1]',

   'New Broadcast Message'
=> '新的广播信息',

   'Send a broadcast message to members of this Course and/or other users.'
=> '发送广播信息给这门课程的成员和/或其他用户。',

   'New Messages from File'
=> '从文件生成新邮件',

   'Send copy to permanent e-mail address (if known)'
=> '发送一份副本给外部电子邮件（如果有的话）',

   'Require return receipt?'
=> '回执确认？',

   'Message Administration'
=> '邮件管理',

   'Message Log for Selected Users'
=> '选定用户的邮件日志',

   'New Document'
=> '新文档',

  'Bcc: course members with current access'
=> '密送：当前访问的课程参加者',

   'Tools:'
=> '工具:',

   'Upload PDF Form'
=> '上传PDF格式文档',

   'Upload a PDF Form with filled Form Fields'
=> '上传带有填写表格字段的PDF格式文档',

   'Please choose a PDF-File.'
=> '请选择一个PDF文件。',

   "Can't find any valid PDF form fields."
=> '找不到任何有效的PDF格式文档 。',

   'Results of PDF Form problems'
=> 'PDF格式习题答案',

   'Published Documents'
=> '公开文件',

#SYNCMARKER
);

1;

