# The LearningOnline Network with CAPA
# A debugging harness.
#
# $Id: londns.pm,v 1.3 2013/09/02 14:40:18 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#

package Apache::londns;

use strict;
use LONCAPA;
use Apache::Constants qw(:common :http);
use Apache::lonnet;

sub serve_file {
    my ($r,$file,$type)=@_;
    open(my $config,"<$Apache::lonnet::perlvar{'lonTabDir'}/$file");
    my $file = join('',<$config>);
    $r->content_type($type);
    $r->send_http_header;
    return OK if $r->header_only;
    $r->print($file);
    return OK;
}

sub handler {
    my ($r) = @_;

    my $command = (split('/',$r->uri))[3];
    if ($command eq 'hosts') {
	return &serve_file($r,'dns_hosts.tab','loncapa/hosts');
    } elsif ($command eq 'domain') {
	return &serve_file($r,'dns_domain.tab','loncapa/domain');
    } elsif ($command eq 'checksums') {
        my $version = (split('/',$r->uri))[4];
        return &serve_file($r,"dns_checksums/$version.tab",'loncapa/versions');
    }
    return FORBIDDEN;
}


1;
