package Apache::run;
#
# $Id: run.pm,v 1.62 2013/12/04 15:57:15 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use HTML::Entities;
use Apache::lonlocal;

$Apache::run::EVALUATE_STRING=<<'ENDEVALUATE';
my %_LONCAPA_INTERNAL_oldexpressions=();
while (!$_LONCAPA_INTERNAL_oldexpressions{$_}) {
    $_LONCAPA_INTERNAL_oldexpressions{$_}=1;
    $_ =~s/  # $1 will be the variable reference or subroutine name
            ((?:\$|\&) #look for a starting $ or &
             (?:[\#|\$]* #support $$ or $#$ etc.
              [A-Za-z][\w]*| # get variable name
              \{[A-Za-z][\w]*\})) # for ${a}
             # $2 is 0 or more array dereferences []
             #             or  hash dereferences {}
             # the ^$ and ^& is because we do this iteratively
             #    $a[$c] becomes $a[3] which then evaluates
             ([\[\{][^\$\&\]\}]+[\]\}])*?
             # $3 is the list of arguments
             (\([^\$\&\)]+\))*?
                # only match the above if there is not { [ ( coming up
                # Why? (I.e. this fails &a(1)[2]
                (?=[^\[\{\(]|$)/
		 my ($__LC__a,$__LC__b,$__LC__c)=($1,$2,$3);
		 my $__LC__prefix;
		 my $__LC__result;
		 while (1) {
		     if ($__LC__a =~ m-^&(theta|pi|rho)$-) { last; }
		     { 
			 use strict;
			 no strict "vars";
			 if (eval(defined(eval($__LC__a.$__LC__b)))) {
			     $__LC__result= $__LC__prefix.eval($__LC__a.$__LC__b.$__LC__c);
			     last;
			 }
		     }
		     $__LC__prefix.=substr($__LC__a,0,1,"");
		     if ($__LC__a!~m-^(\$|&|\#)-) { last; }
		 }
		 if (!defined($__LC__result)) {
		     $__LC__result=$__LC__prefix.$__LC__a.$__LC__b.$__LC__c;
		 }
		 $__LC__result;
                  /sexg;
    if (scalar(values(%_LONCAPA_INTERNAL_oldexpressions))>10) {last;}
}
ENDEVALUATE

sub evaluate {
    my ($expression,$safeeval,$decls) = @_;
    unless (defined($expression)) { return ''; }
    if ($Apache::lonxml::evaluate < 1) { return $expression; }
    my $result = '';
    $@='';
    $Apache::run::timeout=0;
    local $main::SIG{'ALRM'} = sub {
	$Apache::run::timeout=1;
	die("timeout");
    };
    my $innererror;
    eval {
	&Apache::lonxml::start_alarm();
	$safeeval->reval('{'.$decls.';$_=<<\'EXPRESSION\';'."\n".$expression.
			 "\n".'EXPRESSION'."\n".$EVALUATE_STRING.'}');
	$innererror=$@;
	&Apache::lonxml::end_alarm();
    };
    my $error=$@; 
    if ($error eq '' && $innererror eq '' && !$Apache::run::timeout) {
	$result = $safeeval->reval('return $_;');
	chomp $result;
    } else {
        if ($Apache::run::timeout) {
            $error =
                &mt('Code ran too long. It ran for more than [_1] seconds.',
                        $Apache::lonnet::perlvar{'lonScriptTimeout'});
        }
        &Apache::lonxml::error(
            &mt('Substitution on [_1] with [_2] caused:',
                    '<pre>'. &HTML::Entities::encode($expression,'<>&"').'</pre>',
                    '<pre>'.&HTML::Entities::encode($decls,'<>&"').'</pre>')
           .'<br />'
           .'<pre>'.&HTML::Entities::encode($error,'<>&"').' '
           .&HTML::Entities::encode($innererror,'<>&"').'</pre>');
    }
    return $result;
}

sub run {
    my ($code,$safeeval,$hideerrors) = @_;
    my @result;
    $@='';
    $Apache::run::timeout=0;
    local $main::SIG{'ALRM'} = sub {
	$Apache::run::timeout=1;
	die("timeout");
    };
    my $innererror;
    eval {
	&Apache::lonxml::start_alarm();
	@result=$safeeval->reval($code);
	$innererror=$@;
	&Apache::lonxml::end_alarm();
    };
    my $error=$@;
    if (($Apache::run::timeout || $error ne '' || $innererror ne '') && !$hideerrors) {
        if ($Apache::run::timeout) {
            $error = &mt('Code ran too long. It ran for more than [_1] seconds.',
                             $Apache::lonnet::perlvar{'lonScriptTimeout'});
        }
        $code=&HTML::Entities::encode($code,'<>&"');
        if ($innererror=~/line (\d+)/) {
            my $linenumber=$1;
            my @code=split("\n",$code);
            if ($linenumber < scalar(@code)) {
                $code[$linenumber-1]=
                    '<span style="color:red;font-weight:bold;">'.
                    $code[$linenumber-1].'</span>';
            }
            $code=join("\n",@code);
        }
        &Apache::lonxml::error(
            '<pre>'.&HTML::Entities::encode($error,'<>&"').' '.
            &HTML::Entities::encode($innererror,'<>&"').
            '</pre>'
           .&mt('This occurred while running: [_1]',
                   '<pre>'.$code.'</pre>'));
    }
    if ( $#result < '1') {
	return $result[0];
    } else {
	&Apache::lonxml::debug("<b>Got lots results</b>:$#result:");
	return (@result);
    }
}

sub dump {
    my ($target,$safeeval)=@_;
    my $dump='';
    foreach my $symname (sort keys %{$safeeval->varglob('main::')}) {
	if (($symname!~ /^(INC|SIG)/) && ($symname!~/\027/) &&
	    ($symname!~/^\_/) && ($symname!~/\:$/)) {
	    my $line;
	    if ($safeeval->reval('defined($'.$symname.')')) {
		if ($symname =~ /^\w/) {
		    $line.='$'.$symname.'='.$safeeval->reval('$'.$symname)."\n";
		}
	    }	
	    if ($safeeval->reval('@'.$symname)) {
		$line.='@'.$symname.'=('.
		    $safeeval->reval('join(",",@'.$symname.')').")"."\n";
	    }
	    if ($safeeval->reval('%'.$symname)) {
		$line.='%'.$symname.'=(';
		$line.=$safeeval->reval('join(",",map { $_."=>".$'.
					$symname.'{$_} } sort keys %'.
					$symname.')').")"."\n";
	    }
	    if ($line ne '') {
		$line=&HTML::Entities::encode($line,'<>&"');
		$line=~s|\n|<br />|g;
		$dump.=$line;
	    }
	}
    }
    $dump.='';
    return $dump;
}

1;
__END__;

=pod

=head1 NAME

Apache::run.pm

=head1 SYNOPSIS

Used to prevent poorly written problems from
causing lingering after effects

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.


=head1 NOTABLE SUBROUTINES

=over

=item run(), dump(), evaluate()

=back

=cut

