/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.io.BufferedReader;
import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.shape.MeshFileCollection;
import org.jmol.util.Logger;

public class Pmesh
extends MeshFileCollection {
    boolean isOnePerLine;
    int modelIndex;

    public void initShape() {
        super.initShape();
        this.myType = "pmesh";
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("init" == string) {
            this.isFixed = false;
            this.modelIndex = -1;
            this.isOnePerLine = false;
            this.script = (String)object;
            super.setProperty("thisID", "+PREVIOUS_MESH+", null);
        }
        if ("modelIndex" == string) {
            this.modelIndex = (Integer)object;
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            this.modelIndex = -1;
            this.setModelIndex(-1, -1);
            return;
        }
        if ("bufferedReaderOnePerLine" == string) {
            this.isOnePerLine = true;
            string = "bufferedReader";
        }
        if ("bufferedReader" == string) {
            BufferedReader bufferedReader = (BufferedReader)object;
            if (this.currentMesh == null) {
                this.allocMesh(null);
            }
            this.currentMesh.clear("pmesh");
            this.currentMesh.isValid = this.readPmesh(bufferedReader);
            if (this.currentMesh.isValid) {
                this.currentMesh.initialize(2);
                this.currentMesh.visible = true;
                this.currentMesh.title = this.title;
            }
            this.setModelIndex(-1, this.modelIndex);
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    boolean readPmesh(BufferedReader bufferedReader) {
        try {
            this.readVertexCount(bufferedReader);
            this.readVertices(bufferedReader);
            this.readPolygonCount(bufferedReader);
            this.readPolygonIndexes(bufferedReader);
        }
        catch (Exception exception) {
            Logger.error("pmesh ERROR: read exception: " + exception);
            return false;
        }
        return true;
    }

    void readVertexCount(BufferedReader bufferedReader) throws Exception {
        this.currentMesh.vertexCount = 0;
        this.currentMesh.vertices = new Point3f[0];
        this.currentMesh.vertices = new Point3f[this.parseInt(bufferedReader.readLine())];
        this.currentMesh.vertexCount = this.currentMesh.vertices.length;
    }

    void readVertices(BufferedReader bufferedReader) throws Exception {
        if (this.currentMesh.vertexCount <= 0) {
            return;
        }
        if (this.isOnePerLine) {
            for (int i = 0; i < this.currentMesh.vertexCount; ++i) {
                float f = this.parseFloat(bufferedReader.readLine());
                float f2 = this.parseFloat(bufferedReader.readLine());
                float f3 = this.parseFloat(bufferedReader.readLine());
                this.currentMesh.vertices[i] = new Point3f(f, f2, f3);
            }
        } else {
            for (int i = 0; i < this.currentMesh.vertexCount; ++i) {
                this.line = bufferedReader.readLine();
                float f = this.parseFloat(this.line);
                float f4 = this.parseFloat();
                float f5 = this.parseFloat();
                this.currentMesh.vertices[i] = new Point3f(f, f4, f5);
            }
        }
    }

    void readPolygonCount(BufferedReader bufferedReader) throws Exception {
        this.currentMesh.setPolygonCount(this.parseInt(bufferedReader.readLine()));
    }

    void readPolygonIndexes(BufferedReader bufferedReader) throws Exception {
        if (this.currentMesh.polygonCount > 0) {
            for (int i = 0; i < this.currentMesh.polygonCount; ++i) {
                this.currentMesh.polygonIndexes[i] = this.readPolygon(bufferedReader);
            }
        }
    }

    int[] readPolygon(BufferedReader bufferedReader) throws Exception {
        int n;
        int n2 = this.parseInt(bufferedReader.readLine());
        if (n2 < 2) {
            Logger.error("pmesh ERROR: each polygon must have at least two verticies indicated");
            this.currentMesh.isValid = false;
            return null;
        }
        int n3 = n2 - 1;
        int n4 = n3 < 3 ? 3 : n3;
        int[] nArray = new int[n4];
        for (n = 0; n < n3; ++n) {
            nArray[n] = this.parseInt(bufferedReader.readLine());
        }
        for (n = n3; n < n4; ++n) {
            nArray[n] = nArray[n - 1];
        }
        n = this.parseInt(bufferedReader.readLine());
        if (n != nArray[0]) {
            Logger.error("pmesh ERROR: last polygon point reference (" + n + ") is not the same as the first (" + nArray[0] + ")");
            this.currentMesh.isValid = false;
            throw new NullPointerException();
        }
        return nArray;
    }
}

