# The LearningOnline Network
# Information about blocking status for Portfolio files
#
# $Id: blockedaccess.pm,v 1.4 2012/03/31 23:10:47 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::blockedaccess;

use strict;
use Apache::Constants qw(:common :http REDIRECT);
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonlocal;

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    &Apache::lonlocal::get_language_handle($r);
    my $origurl = $r->uri;
    my ($blocked,$blocktext);

    if (&Apache::lonnet::is_portfolio_url($origurl)) {
        my ($type,$udom,$uname,$file_name,$group) = 
	    &Apache::lonnet::parse_portfolio_url($origurl);
        ($blocked,$blocktext) = 
            &Apache::loncommon::blocking_status('port',$uname,$udom);
    } else {
        if ($env{'request.course.id'}) {
            my $cnum = $env{'course.'.$env{'request.course.id'}.'.num'};
            my $cdom = $env{'course.'.$env{'request.course.id'}.'.domain'};
            ($blocked,$blocktext) =
                &Apache::loncommon::blocking_status('docs',$cnum,$cdom,$origurl);
        }
    }
    if ($blocked) {
        $r->print(&Apache::loncommon::start_page('Access Temporarily Blocked'));
        $r->print($blocktext);
    } else {
        my $server = &Apache::lonnet::absolute_url();
        $r->header_out(Location => $server.$origurl);
        return REDIRECT;
    }
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

sub setup_handler {
    my ($r) = @_;
    $r->set_handlers('PerlHandler'=>
                     [\&Apache::blockedaccess::handler]);
    $r->handler('perl-script');
}

1;
