# The LearningOnline Network
# Authorization handler for Shibboleth authenticated users
#
# $Id: lonshibacc.pm,v 1.1 2012/03/05 20:51:29 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

=head1 NAME

Apache::lonshibacc - Authorization handler if Shibboleth-authenticated

=head1 SYNOPSIS

Invoked for /adm/sso by
/etc/httpd/conf/loncapa_apache.conf:

PerlAuthzHandler       Apache::lonshibacc

=head1 INTRODUCTION

Authorization handler used to remove trailing @internet dom
from Shibboleth authenticated username (e.g., @mit.edu).

After making change to $r->user, will return DECLINE so
lonacc.pm can be invoked as the next authorization handler.

PerlAuthzHandler       Apache::lonacc

=head1 HANDLER SUBROUTINE

This routine is called by Apache and mod_perl.

=cut

package Apache::lonshibacc;

use strict;
use lib '/home/httpd/lib/perl/';
use Apache::lonnet;
use Apache::Constants qw(:common);
use LONCAPA qw(:DEFAULT);

sub handler {
    my $r = shift;
    my $user = $r->user;
    if ($user ne '') {
        my $udom = $r->dir_config('lonSSOUserDomain');
        if ($udom eq '') {
            $udom = $r->dir_config('lonDefDomain');
        }
        if ($udom ne '') {
            my $uprimary_id = &Apache::lonnet::domain($udom,'primary');
            my $uint_dom = &Apache::lonnet::internet_dom($uprimary_id);
            if ($user =~ /^(\w+)\@\Q$uint_dom\E$/i) {
                my $username = $1;
                $user = $r->user($username);
            }
        }
    }
    return DECLINED;
}

1;
__END__
