# The LearningOnline Network
# Redirect Shibboleth authentication to designated URL (/adm/sso).
#
# $Id: lonshibauth.pm,v 1.2 2013/01/04 01:37:02 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

=head1 NAME

Apache::lonshibauth - Redirect Shibboleth authentication

=head1 SYNOPSIS

Invoked when lonOtherAuthen is set to yes, and type is Shibboleth 

If server is configured as a Shibboleth SP, the main Apache 
configuration file, e.g.,  /etc/httpd/conf/httpd.conf
(for RHEL/CentOS/Scentific Linux/Fedora) should contain:

LoadModule mod_shib /usr/lib/shibboleth/mod_shib_22.so

or equivalent (depending on Apache version) 
before the line to include conf/loncapa_apache.conf

=head1 INTRODUCTION

Redirects a user requiring Single Sign On via Shibboleth to a  
URL -- /adm/sso -- on the server which is configured to use that service.

=head1 HANDLER SUBROUTINE

This routine is called by Apache and mod_perl.

=over 4

If $r->user defined and requested uri not /adm/sso
redirect to /adm/sso

Otherwise return DECLINED

=back

=cut

package Apache::lonshibauth;

use strict;
use lib '/home/httpd/lib/perl/';
use Apache::Constants qw(:common REDIRECT);
use LONCAPA qw(:DEFAULT);

sub handler {
    my $r = shift;
    my $target = '/adm/sso';
    if (($r->user eq '') && ($r->uri() ne $target)) {
        my $dest = &Apache::lonnet::absolute_url($r->hostname()).$target;
        $r->subprocess_env;
        if ($ENV{'QUERY_STRING'} ne '') {
            $dest .= '?'.$ENV{'QUERY_STRING'};
        }
        $r->header_out(Location => $dest);
        return REDIRECT;
    } else {
        return DECLINED;
    }
}

1;
__END__
