#!/usr/bin/perl
$|=1;
# Domain Configuration Dump
# $Id: listdomconfig.pl,v 1.1 2011/10/21 20:23:36 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#############################################
#############################################

=pod

=head1 NAME

listdomconfig.pl

=head1 SYNOPSIS

CGI script to display domain configuration as plain text.

=head1 Subroutines

=over 4

=cut

#############################################
#############################################

use strict;

use lib '/home/httpd/lib/perl/';
use LONCAPA::loncgi;
use LONCAPA::lonauthcgi;
use Apache::lonnet();
use Apache::lonlocal;
use LONCAPA;
use GDBM_File;
use Data::Dumper;
use Storable qw(thaw);
use GDBM_File;

print &LONCAPA::loncgi::cgi_header('text/plain',1);

&main();
exit 0;

#############################################
#############################################

=pod

=item main()

Inputs: None

Returns: Nothing

Description: Main program. Determines if requesting IP is allowed 
             to view domain configuration(s) for domains for
             which this server is the primary library server.

=cut

#############################################
#############################################

sub main {
    my $remote_ip = $ENV{'REMOTE_ADDR'};
    my $allowed;
    if (&LONCAPA::lonauthcgi::check_ipbased_access('domconf',$remote_ip)) {
        $allowed = 1;
    } elsif (&LONCAPA::loncgi::check_cookie_and_load_env()) {
        $allowed = &LONCAPA::lonauthcgi::can_view('domconf');
    }
    &LONCAPA::loncgi::check_cookie_and_load_env();
    &Apache::lonlocal::get_language_handle();
    if ($allowed ne '') {
        my @okdoms;
        unless ($allowed == 1) {
            @okdoms = split(/\&/,$allowed);
        }
        my @hosts = &Apache::lonnet::current_machine_ids();
        my $numshown = 0;
        my $numnonprim = 0;
        foreach my $lonhost (@hosts) {
            my $dom = &Apache::lonnet::host_domain($lonhost);
            unless ($allowed == 1) {
                next unless (grep(/^\Q$dom\E$/,@okdoms));
            }
            my $prim_id = &Apache::lonnet::domain($dom,'primary');
            if (($prim_id ne '') && (grep(/^\Q$prim_id\E$/,@hosts))) {
                my $domdesc = &Apache::lonnet::domain($dom);
                print &mt('Domain configuration for [_1]',"$domdesc ($dom)")."\n\n";
                &show_config($dom);
                print "\n";
                $numshown ++;
            } else {
                $numnonprim ++;
            }
        }
        if (!$numshown) {
            if ($numnonprim) {
                print &mt('This server is not a primary library server')."\n";
            } else {
                print &mt("You do not have access rights to view domain configuration for domain(s) hosted on this server.")."\n";
            }
        }
    } else {
        &LONCAPA::lonauthcgi::unauthorized_msg('domconf');
    }
}

#############################################
#############################################

=pod

=item show_config

Inputs: $domain - domain for which domain configuration is to be shown 

Returns: Nothing

Description: Displays plain text of domain configuration by dumping
             contents of configuration.db

=cut

#############################################
#############################################

sub show_config {
    my ($dom) = @_;
    my $lonusersdir = $Apache::lonnet::perlvar{'lonUsersDir'};
    my $fname = $lonusersdir.'/'.$dom.'/configuration.db';
    my $dbref=&LONCAPA::locking_hash_tie($fname,&GDBM_READER());
    if (ref($dbref) eq 'HASH') {
        foreach my $key (sort(keys(%{$dbref}))) {
            my $value = $dbref->{$key};  
            if ($value =~ s/^__FROZEN__//) {
                $value = thaw(&unescape($value));
            }
            $key = &unescape($key);
            $value = &unescape($value) if (!ref($value));
            print "$key = ".(ref($value)?Dumper($value):$value)."\n";
        }
        &LONCAPA::locking_hash_untie($dbref);
    }
    return;
}

=pod

=back

=cut

