# The LearningOnline Network with CAPA
# The LON-CAPA group sort handler
# Allows for sorting prior to import into RAT.
#
# $Id: groupsort.pm,v 1.68.6.6 2013/08/08 12:08:01 raeburn Exp $
# 
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

package Apache::groupsort;

use strict;

use Apache::Constants qw(:common);
use GDBM_File;
use Apache::loncommon;
use Apache::lonlocal;
use Apache::lonnet;
use LONCAPA qw(:DEFAULT :match);

my $iconpath; # variable to be accessible to multiple subroutines
my %hash; # variable to tie to user specific database


sub update_actions_hash {
    my ($hash) = @_;
    # be careful in here, there is also a global %hash
    my $acts=$env{'form.acts'};
    my @Acts=split(/b/,$acts);
    my %ahash;
    my %achash;
    # some initial hashes for working with data
    my $ac=0;
    foreach (@Acts) {
 	my ($state,$ref)=split(/a/);
	$ahash{$ref}=$state;
	$achash{$ref}=$ac;
	$ac++;
    }
    # sorting through the actions and changing the global database hash
    foreach my $key (sort {$achash{$a}<=>$achash{$b}} (keys %ahash)) {
	if ($ahash{$key} eq '1') {
	    $hash->{'store_'.$hash->{'pre_'.$key.'_link'}}=
		$hash->{'pre_'.$key.'_title'};
	    $hash->{'storectr_'.$hash->{'pre_'.$key.'_link'}}=
		$hash->{'storectr'}+0;
	    $hash->{'storectr'}++;
	}
	if ($ahash{$key} eq '0') {
	    if ($hash->{'store_'.$hash->{'pre_'.$key.'_link'}}) {
		delete($hash->{'store_'.$hash->{'pre_'.$key.'_link'}});
		delete($hash->{'storectr_'.$hash->{'pre_'.$key.'_link'}});
	    }
	}
    }
    # deleting the previously cached listing
    foreach my $key (keys(%{ $hash })) {
	next if ($key !~ /^pre_(\d+)_link/);
	my $which = $1;
	delete($hash->{'pre_'.$which.'_title'});
	delete($hash->{'pre_'.$which.'_link'});
    }
}

sub readfromdb {
    my ($r,$resources)=@_;

    my $diropendb = LONCAPA::tempdir() .
       "$env{'user.domain'}_$env{'user.name'}_sel_res.db";

# ----------------------------- diropendb is now the filename of the db to open
    if (tie(%hash,'GDBM_File',$diropendb,&GDBM_WRCREAT(),0640)) {
	&update_actions_hash(\%hash);

	my %temp_resources;
	foreach my $key (keys(%hash)) {
	    next if ($key !~ /^store_/);
	    my ($url) = ($key =~ /^store_(.*)/);
	    $temp_resources{$hash{'storectr_'.$url}}{'url'}=$url;
	    $temp_resources{$hash{'storectr_'.$url}}{'title'}=
		&Apache::lonnet::gettitle($url);
	}

	# use the temp, since there might be gaps in the counting
	foreach my $item (sort {$a <=> $b} (keys(%temp_resources))) {
	    push(@{ $resources },$temp_resources{$item});
	}

	if ($env{'form.oldval'}) {
	    my $res = splice(@{$resources},$env{'form.oldval'}-1,1);
	    if ($env{'form.newval'} == 0) {
		# picked 'discard'
		my $url =  $res->{'url'};
		delete($hash{'storectr_'.$url});
		delete($hash{'store_'.$url});
	    } else {
		splice(@{$resources},$env{'form.newval'}-1,0,$res);
	    }
	}
	# store out new order
	foreach my $which (0..$#$resources) {
	    my $url =  $resources->[$which]{'url'};
	    $hash{'storectr_'.$url} = $which;
	}
    } else {
	$r->print('Unable to tie hash to db file');
    }
    untie(%hash);
}



sub cleanup {
    if (tied(%hash)){
	&Apache::lonnet::logthis('Cleanup groupsort: hash');
        unless (untie(%hash)) {
	    &Apache::lonnet::logthis('Failed cleanup groupsort: hash');
        }
    }
    return OK;
}

# -------------------------------------------------------------- Read from file

sub readfromfile {
    my ($r,$resources)=@_;
    my $cont=&Apache::lonnet::getfile
	(&Apache::lonnet::filelocation('',$env{'form.readfile'}));
    if ($cont==-1) {
	$r->print('Unable to read file: '.
		  &Apache::lonnet::filelocation('',$env{'form.readfile'}));
    } else {
        my $parser = HTML::TokeParser->new(\$cont);
        my ($token,$donechk,$allmaps);
        $allmaps = {};
        while ($token = $parser->get_token) {
	    if ($token->[0] eq 'S') {
                if ($token->[1] eq 'resource') {
		    if ($env{'form.recover'}) {
			if ($token->[2]->{'type'} ne 'zombie') { next; }
                        if ($token->[2]->{'src'} =~ /\.(page|sequence)$/) {
                            if (($env{'request.course.id'}) &&
                                ($env{'form.readfile'} =~ m{/default(|_\d+)\.(page|sequence)$})) {
                                unless ($donechk) {
                                    $allmaps = &Apache::loncommon::allmaps_incourse();
                                    $donechk = 1;
                                }
                            }
                            if ($allmaps->{$token->[2]->{'src'}}) { next; }
                        }
		    } else {
			if ($token->[2]->{'type'} eq 'zombie') { next; }
		    }

                    my $name=$token->[2]->{'title'};
		    $name=~s/ \[\((\d+)\,($LONCAPA::username_re)\,($LONCAPA::domain_re)\)\]$//;
		    my $note;
		    if ($1) {
			$note = '<br />'.&mt('Removed by ').
			    &Apache::loncommon::plainname($2,$3).', '.
			    &Apache::lonlocal::locallocaltime($1);
		    }
		    $name=~s/\&colon\;/\:/g;
		    push(@{$resources}, {'url'   => $token->[2]->{'src'},
					 'title' => $name,
					 'note'  => $note,
				         'id'    => $token->[2]->{'id'},});
		}
	    }
	}
    }
}

# ---------------------------------------------------------------- Main Handler
sub handler {
    my $r = shift;
 
   &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
			     ['acts','mode','readfile','recover']);

    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

# finish_import looks different for graphical or "simple" RAT
    my $finishimport='';
    my $begincondition='';
    my $endcondition='';
    if (($env{'form.readfile'}))  {
        $begincondition='if (eval("document.forms.groupsort.include"+num+".checked")) {';
	$endcondition='}';
    }
    if ($env{'form.mode'} eq 'simple' || $env{'form.mode'} eq '') {
        $finishimport=(<<ENDSMP);
function finish_import() {
    opener.document.forms.simpleedit.importdetail.value='';
    for (var num=0; num<document.forms.groupsort.fnum.value; num++) {
	$begincondition
	opener.document.forms.simpleedit.importdetail.value+='&'+
              eval("document.forms.groupsort.title"+num+".value")+'='+
	      eval("document.forms.groupsort.filelink"+num+".value")+'='+
	      eval("document.forms.groupsort.id"+num+".value");
	$endcondition
    }
    opener.document.forms.simpleedit.submit();
    self.close();
}
ENDSMP
    } else {
        $finishimport=(<<ENDADV);
function finish_import() {
    var linkflag=false;
    for (var num=0; num<document.forms.groupsort.fnum.value; num++) {
	$begincondition
	insertRowInLastRow();
	placeResourceInLastRow(
	       eval("document.forms.groupsort.title"+num+".value"),
 	       eval("document.forms.groupsort.filelink"+num+".value"),
 	       eval("document.forms.groupsort.id"+num+".value"),
	       linkflag
	);
        linkflag=true;
	$endcondition
    }
    opener.editmode=0;
    opener.notclear=0;
    opener.linkmode=0;
    opener.draw();
    self.close();
}
ENDADV
    }

# output start of web page
    my $js = <<END;
<script type="text/javascript">
function insertRowInLastRow() {
    opener.insertrow(opener.maxrow);
    opener.addobj(opener.maxrow,'e&2');
}
function placeResourceInLastRow (title,url,id,linkflag) {
    opener.mostrecent=opener.newresource(opener.maxrow,2,opener.escape(title),
		       opener.escape(url),'false','normal',id);
    opener.save();
    if (linkflag) {
	opener.joinres(opener.linkmode,opener.mostrecent,0);
    }
    opener.linkmode=opener.mostrecent;
}
$finishimport
function selectchange(val) {
    var newval=0+eval("document.forms.groupsort.alt"+val+".selectedIndex");
    orderchange(val,newval);
}
function move(val,newval) {
    orderchange(val,newval);
}
function orderchange(val,newval) {
    document.forms.groupsort.oldval.value=val;
    document.forms.groupsort.newval.value=newval;
    document.forms.groupsort.submit();
}
</script>
END
    # read pertinent machine configuration
    my $domain  = $r->dir_config('lonDefDomain');
    $iconpath = $r->dir_config('lonIconsURL') . "/";

    my @resources;

    if ($env{'form.readfile'}) {
	&readfromfile($r,\@resources);
    } else {
	&readfromdb($r,\@resources);
    }

    my $ctr = 0;
    my $clen = scalar(@resources);
    my $title = '';
    if ($env{'form.recover'}) {
        $title = 'Recover Removed Resources';
    } else {
        $title = 'Sort Imported Resources';
    }
    if (($clen > 1) || ($env{'form.readfile'})) {
	my %lt=&Apache::lonlocal::texthash(
		'fin'=> 'Finalize order of resources',
		'ci' => 'Continue Import',
		'cs' => 'Continue Search',
		'fi' => 'Finish Import',
		're' => 'Recover Checked',
		'ip' => 'Import Checked',
		'ca' => 'Cancel',
		'co' => 'Change Order',
		'ti' => 'Title',
		'pa' => 'Path',
                'in' => 'Include'
		);

	$r->print(&Apache::loncommon::start_page($title, $js));
	$r->print('<h1>'.&mt($title).'</h1>');

	$r->print(<<END);
<form method='post' action='/adm/groupsort' name='groupsort'
      enctype='application/x-www-form-urlencoded'>
<input type="hidden" name="fnum" value="$clen" />
<input type="hidden" name="oldval" value="" />
<input type="hidden" name="newval" value="" />
<input type="hidden" name="mode" value="$env{'form.mode'}" />
<input type="hidden" name="readfile" value="$env{'form.readfile'}" />
<input type="hidden" name="recover" value="$env{'form.recover'}" />
END

        $r->print(&Apache::loncommon::inhibit_menu_check('input'));
        # ---

        my $buttontext = $lt{'re'};
        if ($env{'form.recover'}) {
	    $r->print(<<END);
<input type="button" name="alter" value="$buttontext"
 onclick="finish_import()" />&nbsp;
<input type="button" name="alter" value="$lt{'ca'}" onclick="self.close()" />
END
	} else {
        # --- Continue Buttons
	    my $resurl = 
		&Apache::loncommon::escape_single(&Apache::loncommon::lastresurl());
	    $r->print(<<END);
<h2>$lt{'fin'}</h2>
<div>
<input type="button" name="alter" value="$lt{'ci'}"
 onclick="window.location='$resurl?inhibitmenu=yes&amp;catalogmode=import'" />&nbsp;
<input type="button" name="altersearch" value="$lt{'cs'}"
 onclick="window.location='/adm/searchcat?inhibitmenu=yes&amp;catalogmode=import'" />&nbsp;
<input type="button" name="alter" value="$lt{'fi'}"
 onclick="finish_import()" />&nbsp;
<input type="button" name="alter" value="$lt{'ca'}" onclick="self.close()" />
</div>
<br />
END
        }

        # Only display header if content exists
        if ($clen > 0) {
            $r->print(&Apache::loncommon::start_data_table()
                     .&Apache::loncommon::start_data_table_header_row());
            if (($env{'form.readfile'})) { 
                $r->print("<th>$lt{'in'}</th>\n");
            } else { 
                $r->print('<th colspan="2">'.$lt{'co'}.'</th>'."\n"); 
            }
            $r->print('<th colspan="2">'.$lt{'ti'}.'</th>'."\n");
            $r->print("<th>$lt{'pa'}</th>");
            $r->print(&Apache::loncommon::end_data_table_header_row()."\n");
        } else {
            my $errtxt = '';
            if ($env{'form.recover'}) {
                $errtxt = 'There are no resources to recover.';
            } else {
                $errtxt = 'There are no resources to import.';
            }
            $r->print('<p class="LC_info">'.&mt($errtxt).'</p>');
        }
    } else {
	$r->print(&Apache::loncommon::start_page(undef,$js,
						 {'only_body' => 1}));
#       $r->print('<h1>'.&mt($title).'</h1>');
	$r->print(<<END);
<form method='post' action='/adm/groupsort' name='groupsort'
      enctype='application/x-www-form-urlencoded'>
<input type="hidden" name="fnum" value="$clen" />
<input type="hidden" name="oldval" value="" />
<input type="hidden" name="newval" value="" />
<input type="hidden" name="mode" value="$env{'form.mode'}" />
END
        $r->print(&Apache::loncommon::inhibit_menu_check('input'));

    }
    foreach my $resource (@resources) {
	$ctr++;
	my $iconname=&Apache::loncommon::icon($resource->{'url'});
	if (($clen > 1) || ($env{'form.readfile'})) {
	    $r->print(&Apache::loncommon::start_data_table_row()
                     ."<td>");
            if (($env{'form.readfile'})) {
		$r->print(&checkbox($ctr-1));
	    } else {
		$r->print(&movers($clen,$ctr));
	    }
	}
	$r->print(&hidden($ctr-1,$resource->{'title'},$resource->{'url'},
			  $resource->{'id'}));
	if (($clen > 1)  || ($env{'form.readfile'})) {
	    $r->print("</td>");
            unless (($env{'form.readfile'})) {
		$r->print("<td>".
			  &select_box($clen,$ctr).
			  "</td>");
	    }
	    $r->print("<td>");
	    $r->print("<img src='$iconname' />");
	    $r->print("</td><td>");
            if (($env{'form.recover'}) &&
                ($resource->{'url'} =~ m{/uploaded/$match_domain/$match_courseid/supplemental/})) {
                my $title = &Apache::loncommon::parse_supplemental_title($resource->{'title'});
                $r->print($title);
            } else {
                $r->print($resource->{'title'});
            }
            $r->print($resource->{'notes'}."</td><td>\n");
	    $r->print($resource->{'url'}."</td>"
                     .&Apache::loncommon::end_data_table_row()
                     ."\n");
	} 
    }
    if (($clen > 1) || ($env{'form.readfile'})) {
        if ($clen > 0) {
            $r->print(&Apache::loncommon::end_data_table());
        }
        $r->print('</form>');
    } else {
	$r->print(<<END);
<script type="text/javascript">
    finish_import();
</script>
END
    }

    $r->print(&Apache::loncommon::end_page());

    return OK;
}

# --------------------------------------- Hidden values (returns scalar string)
sub hidden {
    my ($sel,$title,$filelink,$id) = @_;
    my $string = '<input type="hidden" name="title'.$sel.'" value="'.
	&escape($title).'" />';
    $filelink=~s|^/ext/|http://|;
    $string .= '<input type="hidden" name="filelink'.$sel.'" value="'.
	&escape($filelink).'" />';
    $string .= '<input type="hidden" name="id'.$sel.'" value="'.&escape($id).'" />';
    return $string;
}

# --------------------------------------- Moving arrows (returns scalar string)
sub movers {
    my ($total,$sel) = @_;
    my $dsel = $sel-1;
    my $usel = $sel+1;
    $usel = 1 if $usel > $total;
    $dsel = $total if $dsel < 1;
    my $string;
    $string = (<<END);
<table border='0' cellspacing='0' cellpadding='0'>
<tr><td><a href='javascript:move($sel,$dsel)'>
<img src="${iconpath}move_up.gif" alt='UP' border='0' /></a></td></tr>
<tr><td><a href='javascript:move($sel,$usel)'>
<img src="${iconpath}move_down.gif" alt='DOWN' border='0' /></a></td></tr>
</table>
END
    return $string;
}

# ------------------------------------------ Select box (returns scalar string)
sub select_box {
    my ($total,$sel) = @_;
    my $string;
    $string = '<select name="alt'.$sel.'"';
    $string .= " onchange='selectchange($sel)'>";
    $string .= "<option name='o0' value='0'>".&mt('discard')."</option>";
    for my $cur (1..$total) {
	$string .= "<option name='o$cur' value='$cur'";
	if ($cur == $sel) {
	    $string .= "selected";
	}
	$string .= ">$cur</option>";
    }
    $string .= "</select>\n";
    return $string;
}

# ------------------------------------------------------------------- Checkbox

sub checkbox {
    my $sel=shift;
    return "<label><input type='checkbox' name='include$sel'".
       ($env{"form.include$sel"}?' checked="checked"':'').
       ' />'.&mt('Include').'</label>';
}

1;

__END__

=pod

=head1 NAME

Apache::groupsort.pm

=head1 SYNOPSIS

Implements a second phase of importing
multiple resources into the RAT. Allows for
reordering the sequence of resources

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.


=head1 NOTABLE SUBROUTINES

=over

=item 

=back

=cut

