#!/bin/bash

MAILADDR=certificate@lon-capa.org	# Email the cert request here.
DESTDIR=/home/httpd/lonCerts			# Destination for the key file.
DESTUID=www			# Who will own the private key.
DESTGROUP=www			# Group that will own the private key.

if [ $(whoami) != "$DESTUID" ] && [ $(whoami) != "root" ]; then
    echo "This script needs to be run either as $DESTUID or root"
    exit
fi

if [ $(whoami) != "root" ] ; then
    if [ -d "$DESTDIR" ] ; then
        CURROWNER=`stat -c %U $DESTDIR`
        if [ -L "$DESTDIR" ] ; then
            echo "$DESTDIR is a symbolic link. You need to remove the link and (as root) create $DESTDIR as a directory owned by $DESTUID:$DESTGROUP."
            exit
        elif [ $CURROWNER != $DESTUID ] ; then
            echo "$DESTUID is not the owner of $DESTDIR. As root you need to change ownership of this directory to $DESTUID:$DESTGROUP."
            exit
        fi
    else
        echo "You need to create a directory: $DESTDIR (as root) and then change ownership of this directory so it is owned by $DESTUID:$DESTGROUP."
        exit
    fi
fi

openssl req -newkey rsa:1024 -passout pass:loncapa \
    -keyout lonKey.enc -keyform PEM  \
    -out    CertRequest.pem -outform PEM

openssl rsa -passin pass:loncapa -in lonKey.enc -out lonKey.pem

if [ $(pwd) != "$DESTDIR" ] ; then
    if [ !-d "$DESTDIR" ] ; then
        install -d -m 0750 -o $DESTUID -g $DESTGROUP $DESTDIR
    fi
    install -m 0400 -o $DESTUID -g $DESTGROUP lonKey.pem $DESTDIR
    rm lonKey.pem
else
    chmod 0400 lonKey.pem
fi

rm lonKey.enc


mail <CertRequest.pem -s "Certificate Request" $MAILADDR
rm CertRequest.pem
