/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaArray
extends NativeJavaObject {
    static final long serialVersionUID = -924022554283675333L;
    Object array;
    int length;
    Class<?> cls;

    @Override
    public String getClassName() {
        return "JavaArray";
    }

    public static NativeJavaArray wrap(Scriptable scriptable, Object object) {
        return new NativeJavaArray(scriptable, object);
    }

    @Override
    public Object unwrap() {
        return this.array;
    }

    public NativeJavaArray(Scriptable scriptable, Object object) {
        super(scriptable, null, ScriptRuntime.ObjectClass);
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new RuntimeException("Array expected");
        }
        this.array = object;
        this.length = Array.getLength(object);
        this.cls = clazz.getComponentType();
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return string.equals("length") || super.has(string, scriptable);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return n >= 0 && n < this.length;
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        if (string.equals("length")) {
            return new Integer(this.length);
        }
        Object object = super.get(string, scriptable);
        if (object == NOT_FOUND && !ScriptableObject.hasProperty(this.getPrototype(), string)) {
            throw Context.reportRuntimeError2("msg.java.member.not.found", this.array.getClass().getName(), string);
        }
        return object;
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (n >= 0 && n < this.length) {
            Context context = Context.getContext();
            Object object = Array.get(this.array, n);
            return context.getWrapFactory().wrap(context, this, object, this.cls);
        }
        return Undefined.instance;
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        if (!string.equals("length")) {
            throw Context.reportRuntimeError1("msg.java.array.member.not.found", string);
        }
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (n < 0 || n >= this.length) {
            throw Context.reportRuntimeError2("msg.java.array.index.out.of.bounds", String.valueOf(n), String.valueOf(this.length - 1));
        }
        Array.set(this.array, n, Context.jsToJava(object, this.cls));
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.array.toString();
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (clazz == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    @Override
    public Object[] getIds() {
        Object[] objectArray = new Object[this.length];
        int n = this.length;
        while (--n >= 0) {
            objectArray[n] = new Integer(n);
        }
        return objectArray;
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        if (!(scriptable instanceof Wrapper)) {
            return false;
        }
        Object object = ((Wrapper)((Object)scriptable)).unwrap();
        return this.cls.isInstance(object);
    }

    @Override
    public Scriptable getPrototype() {
        if (this.prototype == null) {
            this.prototype = ScriptableObject.getClassPrototype(this.getParentScope(), "Array");
        }
        return this.prototype;
    }
}

