# The LearningOnline Network
# help_graphics_converter - converts help .png into .gif and .eps
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# YEAR=2002
# 7/4, Jeremy Bowers
#
###

use strict;

##
#  Sub to determine the relative modification dates of files:
#
# @param file1 - First file
# @param file2 - Seond file
#
# @return - 0 if file 1's mtime is <= file2's 1 otherwise.
sub newer {
    my ($file1, $file2) = @_;

    # IF file2 does not exist, return false to force the build:

    if (not (-s $file2)) {
	return 0;
    }

    # Check modification times if file2 exists:

    my $m1 = (stat($file1))[9];
    my $m2 = (stat($file2))[9];

    return $m2 > $m1;
}

my $dirprefix = "../html/adm/help/";

# Check that the png directory exists
if (not (-d $dirprefix . "png/"))
{ die "Can't convert help graphics because the png directory is not ".
      "installed."; }

mkdir $dirprefix . "gif/", 0755;
mkdir $dirprefix . "eps/", 0755;

my $convert = `which convert`;
if ($convert eq '')
{
    open LOG, ">> WARNINGS";
    print LOG "**** ERROR **** ImageMagick is not installed. You must install ImageMagick to use LON-CAPA. Please see your installation instructions.\n";
    print "**** ERROR **** ImageMagick is not installed. You must install ImageMagick to use LON-CAPA. Please see your installation instructions.\n";
    exit;
}

foreach my $file (glob($dirprefix . "png/*.png"))
{
    my $filename = substr($file, rindex($file, "/") + 1);
    my $gifdest = $dirprefix . "gif/" . substr($filename, 0, -4) . ".gif";
    my $epsdest = $dirprefix . "eps/" . substr($filename, 0, -4) . ".eps";
    
    
    print "Converting $filename... gif";
    system ("convert $file $gifdest\n") if (not &newer($file, $gifdest));
    print " eps";
    system ("convert $file $epsdest\n") if (not &newer($file, $epsdest));
    print " done.\n";
}
