# The LearningOnline Network
# Chat
#
# $Id: lonchat.pm,v 1.20 2009/10/16 20:22:06 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonchat;

use strict;
use Apache::Constants qw(:common :http);
use Apache::loncommon;
use Apache::lonnet;
use Apache::lonlocal;

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;
    
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['group']);
    my ($group,$group_elem);
    if (defined($env{'form.group'})) {
        $group = $env{'form.group'};
        $group_elem = '<input type="hidden" name="group" value="'.$group.'" />'; 
        if ((! &Apache::lonnet::allowed('pgc',$env{'request.course.id'}.'/'.
                                                                    $group))
            && (! &Apache::lonnet::allowed('vcg',$env{'request.course.id'}.($env{'request.course.sec'}?'/'.$env{'request.course.sec'}:'')))) {
            return HTTP_NOT_ACCEPTABLE;
        }
    } else {
        if (! &Apache::lonnet::allowed('plc',$env{'request.course.id'}.
              ($env{'request.course.sec'}?'/'.$env{'request.course.sec'}:'')
                                   )) {
            return HTTP_NOT_ACCEPTABLE;
        }
    }

    if ($env{'form.newchat'}) {
	&Apache::lonnet::chatsend(&Apache::lonfeedback::clear_out_html($env{'form.newchat'}),$env{'form.anonymous'},$group);
    }
# --------------------------------------------------- Print login screen header
    my $latexHelp = Apache::loncommon::helpLatexCheatsheet(undef,undef,1);
    my %loaditems = (onload => 'this.document.chatentry.newchat.focus();');
    my $start_page = 
	&Apache::loncommon::start_page('Chat Room',undef,
				       {'only_body'   => 1,
					'add_entries' => \%loaditems,});
    my $end_page = &Apache::loncommon::end_page();
    my %lt = &Apache::lonlocal::texthash(
                                        anon => 'Post Anonymous',
                                        post => 'Post',
                                      );         
    $r->print(<<ENDDOCUMENT);
$start_page
<form method="post" name="chatentry">
$latexHelp
<input type="text" size="55" name="newchat" />
<input value="$lt{'anon'}" name="anonymous" type="submit" />
<input value="$lt{'post'}" name="newentry" type="submit" />
$group_elem
</form>
$end_page
ENDDOCUMENT
    return OK;
} 

1;
__END__
