# The LearningOnline Network with CAPA
# displays the main menu
#
# $Id: lonmainmenu.pm,v 1.10.2.2 2014/05/22 12:47:27 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#
# There are two parameters controlling the action of this module:
#
# browser.interface - if this is 'textual', it overrides the second parameter
# and goes to screen reader PDA mode
#

package Apache::lonmainmenu;

use strict;
use Apache::Constants qw(:common REDIRECT);
use Apache::loncommon();
use Apache::lonnet;
use Apache::lonmenu();

sub handler {
    my $r = shift;

    # Check for critical messages and redirect if present.
    my ($redirect,$url) = &Apache::loncommon::critical_redirect(300);
    if ($redirect) {
        &Apache::loncommon::content_type($r,'text/html');
        $r->header_out(Location => $url);
        return REDIRECT;
    }

    &Apache::loncommon::no_cache($r);
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

# ---- Print the screen, pretend to be in text mode to generate text-based menu
# temporarily set interface to "faketextual" and remote to "off", which renders
# the main menu
    $env{'browser.interface'}='faketextual';
    $env{'environment.remote'}='off';
    $r->print(&Apache::loncommon::start_page( 'Main Menu',
                                               undef,
                                              {'bread_crumbs' => 1}));
    $r->print(&Apache::lonmenu::inlinemenu());
    $r->print(&Apache::loncommon::end_page());
    return OK;
}


1;
__END__







