# The LearningOnline Network
# Simple Page Editor
#
# $Id: lonsimplepage.pm,v 1.103 2013/09/17 15:04:30 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonsimplepage;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon;
use Apache::lontemplate;
use Apache::lonnet;
use Apache::lonhtmlgateway;
use Apache::lonlocal;
use Apache::lonprintout;
use Apache::lonxml;
use Apache::longroup;
use Apache::lonnavmaps();
use HTML::Entities();
use LONCAPA;

sub get_db_name {
    my ($url,$marker,$cdom,$cnum) = @_;
    my ($udom,$uname,$timemark)=(split(m{/},$url))[2,3,4];
    if ($marker eq '') {
        $marker = $timemark;
    }
    if (($cdom eq '') || ($cnum eq '')) {
        $cdom = $env{'course.'.$env{'request.course.id'}.'.domain'};
        $cnum = $env{'course.'.$env{'request.course.id'}.'.num'};
    }
    my $db_name;

    if ($cdom && $cnum && ($udom eq $cdom) && ($uname eq $cnum)) {
        $marker =~ s/\W//g;
        $db_name = 'grppage_'.$marker;
    } else {
        $marker=~s/\D//g;
        $db_name = 'smppage_'.$marker;
    }
    return if (!defined($marker));
    return $db_name;
}

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;
    my $target=$env{'form.grade_target'};
# ------------------------------------------------------------ Print the screen
    if ($target eq 'tex') {
        $r->print(&Apache::lonprintout::print_latex_header($env{'form.latex_type'}));
    }

# Is this even in a course?
    unless ($env{'request.course.id'}) {
        if ($target ne 'tex') {
            &Apache::loncommon::simple_error_page($r,'','Not in a course');
        } else {
            $r->print('\textbf{Not in a course}\end{document}');
        }
        return OK;
    }

    my $marker = (split(m{/},$r->uri))[4];
    my $db_name = &get_db_name($r->uri,$marker);

    my $dom = $env{'course.'.$env{'request.course.id'}.'.domain'};
    my $crs = $env{'course.'.$env{'request.course.id'}.'.num'};
    my ($group,$group_desc);

    my %curr_group = ();
    my %groupinfo = ();
    if ($db_name =~ /^grppage_/) {
        $group = $marker;
        $group =~ s/\W//g;
        my %curr_groups = &Apache::longroup::coursegroups($dom,$crs,$group);
        if (!%curr_groups) {
            &Apache::loncommon::simple_error_page($r,'','Invalid group name');
            return OK;
        }
        %groupinfo =
        &Apache::longroup::get_group_settings($curr_groups{$group});
        $group_desc = &unescape($groupinfo{'description'});
    }

    if (!$db_name) {
        &Apache::loncommon::simple_error_page($r,'','Invalid call');
        return OK;
    }

# --------------------------------------------------------- The syllabus fields
    my %syllabusfields=&Apache::lonlocal::texthash(
       'aaa_title'         => 'Page Title',
       'bbb_content'       => ($target eq 'tex'?'':'Content'),
       'ccc_webreferences' => 'Web References');
    if ($group ne '') {
        $syllabusfields{'abb_links'} = &mt('Available Group Tools');
    }


# ------------------------------------------------------------ Get query string
    &Apache::loncommon::get_unprocessed_cgi
                        ($ENV{'QUERY_STRING'},['forceedit','todocs',
                                               'register','ref']);
# --------------------------------------------------------------- Force Student
    my ($forceedit,$forcestudent);
    $forceedit = $env{'form.forceedit'};
    if (!$forceedit) {
        $forcestudent=1;
    }

    my $refarg;
    if ($env{'form.ref'}) {
        $refarg = '&amp;ref='.$env{'form.ref'};
    }

    my %syllabus=&Apache::lonnet::dump($db_name,$dom,$crs);

# --------------------------------------- There is such a user, get environment
    my ($registered,$group_view_perm,$group_edit_perm,$group_home_view,
        $group_home_edit,$has_group_access);
    my $brcrum = [];
    if ($group eq '') {
        $registered = $env{'form.register'};
    } else {
        unless ($env{'form.ref'} eq 'grouplist') {
            $registered = $env{'form.register'};
        }
        $group_view_perm =
               &Apache::lonnet::allowed('vcg',$env{'request.course.id'}.
               ($env{'request.course.sec'}?'/'.$env{'request.course.sec'}:''));
        $group_edit_perm =
               &Apache::lonnet::allowed('mdg',$env{'request.course.id'}.
               ($env{'request.course.sec'}?'/'.$env{'request.course.sec'}:''));
        $group_home_view = &Apache::lonnet::allowed('vgh',
                                         $env{'request.course.id'}.'/'.$group);
        $group_home_edit = &Apache::lonnet::allowed('mgh',
                                         $env{'request.course.id'}.'/'.$group);
        if ($group_view_perm || $group_edit_perm || $group_home_view ||
            $group_home_edit || &Apache::longroup::check_group_access($group)) {
            $has_group_access = 1;
            if (($env{'form.ref'} eq 'grouplist') && ($target ne 'tex') &&
                (!$registered)) {
                $brcrum = &grouppage_breadcrumbs($dom,$crs,$group,$group_desc);
            }
        }
    }

    if ($target ne 'tex') {
        my $title = ($group eq '')? 'Simple Course Page':'Simple Group Page';
        my $start_page =
        &Apache::loncommon::start_page($title,undef,
                       {'domain'         => $dom,
                        'group'          => $group,
                        'bread_crumbs'   => $brcrum,
                        'force_register' => $registered,
                       }); 
        $r->print($start_page);
    }

    if ($group ne '') {
        if ($has_group_access) {
            if ((!$group_home_edit) && (!$group_home_view) &&
                (!$group_view_perm) && (!$group_edit_perm)) {
                &display_group_links($r,$target,$group,'view',$refarg,%groupinfo);
                if ($env{'form.grade_target'} ne 'tex') {
                    $r->print(&Apache::loncommon::end_page());
                } else {
                    $r->print('\end{document}');
                }
                return OK;
            }
        } else {
            my $msg =
            &mt('You do not currently have rights to view this group.');
            if ($target ne 'tex') {
                $r->print('<p class="LC_warning">'.$msg.'</p>'.
                &Apache::loncommon::end_page());
            } else {
                $r->print('\textbf{'.$msg.'}\end{document}');
            }
            return OK;
        }
        my ($blocked,$blocktext) =
             &Apache::loncommon::blocking_status('groups');
        if ($blocked) {
            $r->print($blocktext);
            $r->print(&Apache::loncommon::end_page());
            return OK;
        }
    }

    my $allowed;

    if ($group ne '') {
        $allowed  = $group_edit_perm;
        if (!$allowed) {
            $allowed = $group_home_edit;
        }
    } else {
        $allowed=&Apache::lonnet::allowed('mdc',$env{'request.course.id'});
    }

    if ($forcestudent or $target eq 'tex') { $allowed=0; }

    if (($env{'form.uploaddoc.filename'} and $target ne 'tex') &&
    ($env{'form.storeupl'}) && ($allowed)) {
        if ($env{'form.uploaddoc.filename'}=~/\.(gif|jpg|png|jpeg)$/i) {
            if ($syllabus{'uploaded.photourl'}) {
                &Apache::lonnet::removeuploadedurl($syllabus{'uploaded.photourl'});
            }
            if ($group ne '') {
                $syllabus{'uploaded.photourl'}=&Apache::lonnet::userfileupload(
                                              'uploaddoc','coursedoc',
                                              "grouppage/$group");
            } else {
                $syllabus{'uploaded.photourl'}=
                &Apache::lonnet::userfileupload('uploaddoc','coursedoc',
                                                "simplepage/$marker");
            }
        }
        $syllabus{'uploaded.lastmodified'}=time;
        &Apache::lonnet::put($db_name,\%syllabus,$dom,$crs);
    }
#    if ($allowed && $env{'form.delupl'}) {
#        if ($syllabus{'uploaded.photourl'}) {
#            &Apache::lonnet::removeuploadedurl($syllabus{'uploaded.photourl'});
#            delete($syllabus{'uploaded.photourl'});
#            &Apache::lonnet::del('simplepage',['uploaded.photourl']);
#        }
#    }
    if (($allowed) && ($env{'form.storesyl'})) {
        foreach my $syl_field (keys(%syllabusfields)) {
            my $field=$env{'form.'.$syl_field};
            chomp($field);
            my $gateway = Apache::lonhtmlgateway->new();
            $field = $gateway->process_incoming_html($field,1);
            $syllabus{$syl_field}=$field;
        }
        $syllabus{'uploaded.lastmodified'}=time;
        &Apache::lonnet::put($db_name,\%syllabus,$dom,$crs);
    }

#---Print help Text
    if($target ne 'tex'){
        if ($allowed) {
            $r->print(&Apache::loncommon::help_open_topic('Uploaded_Templates_TextBoxes',&mt('Help with filling in text boxes')));
        }
    }

# ---------------------------------------------------------------- Get syllabus
    if ((($syllabus{'uploaded.lastmodified'}) &&
         (($group ne '' && ($group_home_view || $group_edit_perm ||
           $group_view_perm)) || ($group eq ''))) || ($allowed)) {
        #Print the title
        my $titletext=&HTML::Entities::encode($syllabus{'aaa_title'},'<>&"');
        if ($target ne 'tex') {
            if ($allowed) {
            }
            $r->print('<h2>'.$titletext.'</h2>');
        } else {
            my $safeinit;
            $r->print(&Apache::lonxml::xmlparse($r,'tex','<h1>'.$titletext.'</h1>'));
        }
        if ($allowed) {
            if ($env{'form.grade_target'} ne 'tex') {
                #editbox for title
                $r->print('<form method="post" action="" enctype="multipart/form-data">'."\n".
                          '<input type="hidden" register="'.$registered.'" />');
				&Apache::lontemplate::print_start_template($r,&mt('Title'),'LC_Box');
				$r->print($titletext);
				$r->print("<br /><div>");
				&Apache::lontemplate::print_textarea_template($r, $syllabus{'aaa_title'},
					'aaa_title', Apache::lontemplate->RICH_TEXT_ALWAYS_OFF);
				&Apache::lontemplate::print_saveall_template($r);
				$r->print("</div>");
				&Apache::lontemplate::print_end_template($r);
            } else {
                my $safeinit;
                $r->print(&Apache::lonxml::xmlparse($r,'tex',$syllabus{'aaa_title'},$safeinit));
            }
        }

        #print the image
        my $image='';
        if ($syllabus{'uploaded.photourl'}) {
            &Apache::lonnet::allowuploaded('/adm/smppg',
                    $syllabus{'uploaded.photourl'});

            $image='<img src="'.$syllabus{'uploaded.photourl'}
                  .'" alt="'.&mt('Image').'" />';
            if ($target eq 'tex') {
                $image=&Apache::lonxml::xmlparse($r,'tex',$image);
            }
        }

        if ($allowed) {
            &Apache::lontemplate::print_start_template($r, &mt('Upload a Photo'),'LC_Box');
            $r->print($image);
            $r->print("<br /><br />");
            $r->print(
                '<input type="hidden" name="forceedit" value="edit" />'.
                '<input type="file" name="uploaddoc" size="50" />'.
                '<input type="submit" name="storeupl" value="'.&mt('Upload').'" />'.
                '<input type="hidden" name="forceedit" value="edit" />');
            &Apache::lontemplate::print_end_template($r);
    

#            if ($syllabus{'uploaded.photourl'}) {
#                $r->print('<input type="submit" name="delupl"'
#                         .' value="'.&mt('Delete Photo').'" />');
#            }
        }
        #Image in Student view and printout.
        else {
            $r->print($image);
        }
       	
        my $links_handler = sub { 
        	my ($r, $field, $message, $group, $data_ref, $fields_ref, $target, $allowed) = @_;
			if ($group ne '') {
				my %data = %{$data_ref};
				my %fields = %{$fields_ref};
				$r->print('<br /><input type="hidden" name="'.$field.
					'" value="'.$data{$field}.'" />');
				&display_group_links($r, $target, $group, 'edit', $refarg, %groupinfo);
				$r->print('<br />');
			}
        };
        my $title_handler = sub {};
		my %custom_handlers = (
			'abb_links' => $links_handler,
			'aaa_title' => $title_handler
		);
		&Apache::lontemplate::print_template_fields($r, \%syllabus, \%syllabusfields, 
			$target, $allowed, Apache::lontemplate->RICH_TEXT_DETECT_HTML, \%custom_handlers, $group);
		
        if ($allowed && ($env{'form.grade_target'} ne 'tex')) {
            $r->print(&Apache::lonhtmlcommon::htmlareaselectactive().
                      '</form>');
        }

    } else {
        if ($group ne '') {
            &display_group_links($r,$target,$group,'view',$refarg,%groupinfo);
        } else {
            my $text=&mt('No page information provided.');
            if ($target ne 'tex') {
                $r->print('<p class="LC_info">'.$text.'</p>');
            } else {
            $r->print($text)
            }
        }
    }
    if ($env{'form.grade_target'} ne 'tex') {
        $r->print(&Apache::loncommon::end_page());
    } else {
        $r->print('\end{document}');
    }
    return OK;
}

sub display_group_links {
    my ($r,$target,$group,$context,$refarg,%groupinfo) = @_;
    my @available = ();
    my %menu = ();
    %{$menu{'email'}} = (
                        text => 'Group Message',
                        href => '/adm/email?compose=group&amp;group='.$group.
                                $refarg,
                      );
    %{$menu{'discussion'}} = (
                        text => 'Discussion Boards',
                        href => '/adm/groupboards?group='.$group.$refarg,
                      );
    %{$menu{'chat'}} = (
                        text => 'Group Chat Room',
                        href => "javascript:group_chat('$group')",
                      );
    %{$menu{'files'}} = (
                        text => 'Group Portfolio',
                        href => '/adm/coursegrp_portfolio?group='.$group.
                                $refarg,
                      );
    %{$menu{'roster'}} = (
                        text => 'Membership Roster',
                        href => '/adm/grouproster?group='.$group.$refarg,
                      );
    foreach my $tool (sort(keys(%menu))) {
        if ($groupinfo{functions}{$tool} eq 'on') {
            push(@available,$tool);
        }
    }
    if (@available > 0) {
        my $output = '';
        if ($target eq 'tex') {
            $output = '<table cellspacing="4" cellpadding="4">';
        } else {
            $output = &Apache::loncommon::start_data_table();
        }
        foreach my $tool (@available) {
            if ($target eq 'tex') {
                $output .= '<tr><td>'.&mt($menu{$tool}{text}).'</td></tr>';
            } else {
                $output .= &Apache::loncommon::start_data_table_row()
                          .'<td><a href="'.$menu{$tool}{href}.'">'
                          .&mt($menu{$tool}{text}).'</a></td>'
                          .&Apache::loncommon::end_data_table_row();
            }
        }
        if ($target eq 'tex') {
            $output .= '</table>';
        } else {
            $output .= &Apache::loncommon::end_data_table();
        }
        if ($target eq 'tex') {
            $r->print(&Apache::lonxml::xmlparse($r,'tex',&mt('Available functions').'<br /><br />'.$output));
        } else {
            $r->print('<h3>'.&mt('Available Group Tools').'</h3>'.$output);
        }
    } else {
        my $output;
        if ($context eq 'edit') {
            $output = &mt('No group functionality.');
        } else {
            $output = &mt('No group functionality (e.g., e-mail, discussion, chat room or file upload) is currently available to you in this group: [_1].','<b>'.&unescape($groupinfo{'description'}).'</b>');
        }
        if ($target eq 'tex') {
            $r->print(&Apache::lonxml::xmlparse($r,'tex',$output));
        } else {
            $r->print($output);
        }
    }
}

sub grouppage_breadcrumbs {
    my ($cdom,$cnum,$group,$description) = @_;
    &Apache::lonhtmlcommon::clear_breadcrumbs();
    return [{href=>"/adm/coursegroups",
             text=>"Groups",
             title=>"Display Groups"},
            {href=>"/adm/$cdom/$cnum/$group/smppg?ref=grouplist",
             text=>&mt('Group:')." $description",
             title=>"Go to group's home page"},
           ];
}

1;
__END__
