# The LearningOnline Network with CAPA
#
# $Id: longradinganalysis.pm,v 1.14 2014/02/26 16:01:56 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
package Apache::longradinganalysis;

use strict;
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonhtmlcommon();
use Apache::loncoursedata();
use Apache::lonstatistics;
use Apache::lonlocal;
use Apache::lonstathelpers();
use Spreadsheet::WriteExcel;
use Spreadsheet::WriteExcel::Utility();
use HTML::Entities();
use Time::Local();
use Data::Dumper;

my @submit_buttons = ({ name => 'PrevProblemAnalysis',
			text => 'Previous Problem' },
		      { name => 'ProblemAnalysis',
			text => 'Analyze Problem Again' },
		      { name => 'NextProblemAnalysis',
			text => 'Next Problem' },
		      { name => 'break'},
		      { name => 'SelectAnother',
			text => 'Choose a different Problem' });

sub build_grading_analysis_page {
    my ($r,$c)=@_;
    #
    my %saveable_parameters = ('Status' => 'scalar',
                               'Section' => 'array',
                               'Group' => 'array',
                               );
    &Apache::loncommon::store_course_settings('grading_analysis',
                                              \%saveable_parameters);
    &Apache::loncommon::restore_course_settings('grading_analysis',
                                                \%saveable_parameters);
    #
    &Apache::lonstatistics::PrepareClasslist();
    #
    $r->print(&create_interface());
    #
    my @students = @Apache::lonstatistics::Students;
    #
    if (@students < 1 && exists($env{'form.firstrun'})) {
        $r->print(
            '<p class="LC_info">'
           .&mt('There are no students in the sections/groups selected.')
           .'</p>');
    }
    #
    #my @cache_button_HTML = 
    #    &Apache::lonstathelpers::manage_caches($r,'Statistics','stats_status');
    $r->rflush();
    #
    if (exists($env{'form.problemchoice'}) && 
        ! exists($env{'form.SelectAnother'})) {
        foreach my $button (@submit_buttons) {
            if ($button->{'name'} eq 'break') {
                $r->print("<br />\n");
            } else {
                $r->print('<input type="submit" name="'.$button->{'name'}.'" '.
                          'value="'.&mt($button->{'text'}).'" />');
                $r->print('&nbsp;'x5);
            }
        }
#        foreach my $html (@cache_button_HTML) {
#            $r->print($html.('&nbsp;'x5));
#        }
        #
        #$r->print(&Apache::lonstathelpers::submission_report_form('grading_analysis'));
        #
        $r->print('<hr />');
        $r->rflush();
        #
        # Determine which problem we are to analyze
        my $current_problem = &Apache::lonstathelpers::get_target_from_id
            ($env{'form.problemchoice'});
        #
        my ($navmap,$prev,$curr,$next) = 
            &Apache::lonstathelpers::get_prev_curr_next($current_problem,
							undef,
                                                        'part_task',
                                                        );
        if (exists($env{'form.PrevProblemAnalysis'}) && defined($prev)) {
            $current_problem = $prev;
        } elsif (exists($env{'form.NextProblemAnalysis'}) && defined($next)) {
            $current_problem = $next;
        } else {
            $current_problem = $curr;
        }
        #
        # Store the current problem choice and send it out in the form
        $env{'form.problemchoice'} = 
            &Apache::lonstathelpers::make_target_id($current_problem);
        $r->print('<input type="hidden" name="problemchoice" value="'.
                  $env{'form.problemchoice'}.'" />');
        #
	if (! defined($current_problem->{'resource'})) {
            $r->print('<p class="LC_error">'.&mt('resource is undefined').'</p>');
        } else {
            my $resource = $current_problem->{'resource'};
            $r->print('<h1>'.$resource->compTitle.'</h1>');
            $r->print('<h3>'.$resource->src.'</h3>');
            $r->print('<h4>'.&Apache::lonstatistics::section_and_enrollment_description().'</h4>');
            $r->rflush();
            if ($resource->is_task()) {
		&task_analysis($r,$resource,\@students);
            } else {
                $r->print(
                    '<p class="LC_warning">'
                   .&mt('Analysis of [_1] is not supported.',$resource->src())
                   .'</p>');
            }
        }
        $r->print('<hr />');
    } else {
        my $submit_button = '<input type="submit" '.
            'name="ProblemAnalysis" value="'.
            &mt('Analyze Problem').'" />';
        $r->print($submit_button);
        $r->print('&nbsp;'x5);
        $r->print('<h3>'.&mt('Please select a problem to analyze').'</h3>');
        #FIXME need a task only selector.
        $r->print(&Apache::lonstathelpers::problem_selector('.',
                                                            $submit_button));
    }
}

sub task_analysis {
    my ($r,$problem,$students) = @_;
    my %prog_state=&Apache::lonhtmlcommon::Create_PrgWin($r,scalar(@$students));
    my %graders;
    foreach my $student (@$students) {
	my $sname = $student->{'username'};
        my $sdom = $student->{'domain'};
	my %data =  &Apache::lonnet::restore($problem->symb(),
					     $env{'request.course.id'},
					     $sdom,$sname);
	my $last_grader;
	foreach my $ver (0..$data{'version'}) {
	    if (exists($data{"$ver:resource.0.regrader"})
		&& $data{"$ver:resource.0.regrader"} =~ /\S/) {
		$last_grader=$data{"$ver:resource.0.regrader"};
	    }
	    if (exists($data{"$ver:resource.0.version"})
		&& $last_grader =~ /\S/) {
		$graders{$last_grader}++;
	    }
	}
	if ($last_grader =~ /\S/) {
	    $graders{$last_grader}++;
	}

	&Apache::lonhtmlcommon::Increment_PrgWin($r,\%prog_state,
                                                     'last student');

    }

    my @output;
    foreach my $grader (sort(keys(%graders))) {
	my ($gname,$gdom) = split(/(?:\:|\@)/,$grader,2);
	my $name = &Apache::loncommon::plainname($gname,$gdom);
	push(@output,[$name,$gname."@".$gdom,$graders{$grader}]);
    }

    if ($env{'form.output'} eq 'csv') {
	my ($outputfile,$filename) = &init_csv_output($r);
	foreach my $line (@output) {
	    print $outputfile 
		('"'.join(q{","},
			  map {&Apache::loncommon::csv_translate($_)} @{$line})
		 .'"'."\n");
	}
	close($outputfile);
	$r->print('<br />'.
		  '<a href="'.$filename.'">'.&mt('Your CSV file.')."</a>\n");
    } elsif ($env{'form.output'} eq 'excel') {
	my ($excel_workbook,$excel_sheet,$filename,$format,$rows_output) = 
	    &init_excel_output($r);
	foreach my $line (@output) {
	    my $cols_output = 0;
	    foreach my $item (@{ $line }) {
		$excel_sheet->write($rows_output,$cols_output++,$item);
	    }
	    $rows_output++;
	}
	# Write the excel file
	$excel_workbook->close();

	# Tell the user where to get their excel file
	$r->print('<br />'.
		  '<a href="'.$filename.'">'.
		  &mt('Your Excel spreadsheet.').'</a>'."\n");
    } else {
	$r->print(&Apache::loncommon::start_data_table());
	$r->print(&Apache::loncommon::start_data_table_header_row().
		  '<th>'.&mt('Name (username)').'</th><th>'.&mt('Grades Assigned').'</th>'.
		  &Apache::loncommon::end_data_table_header_row() );
	foreach my $line (@output) {
	    $r->print(&Apache::loncommon::start_data_table_row().
		      sprintf("<td>%s (<tt>%s</tt>)</td><td>%s</td></tr>",
			      @{$line}).
		      &Apache::loncommon::end_data_table_row());
	}
	$r->print(&Apache::loncommon::end_data_table());
    }
    &Apache::lonhtmlcommon::Close_PrgWin($r,\%prog_state);
}

sub init_csv_output {
    my ($r) = @_;
    my ($outputfile,$filename) = 
	&Apache::loncommon::create_text_file($r,'csv');
    my $description = $env{'course.'.$env{'request.course.id'}.'.description'};
    print $outputfile ('"'.&Apache::loncommon::csv_translate($description).
		       '","'.&Apache::loncommon::csv_translate(scalar(localtime(time))).
		       '"'."\n");
    print $outputfile ('"'.
		       &Apache::loncommon::csv_translate(&Apache::lonstatistics::section_and_enrollment_description()).
		       '"'."\n");
    print $outputfile ('"'  .&Apache::loncommon::csv_translate('Grader Name'));
    print $outputfile ('","'.&Apache::loncommon::csv_translate('Username'));
    print $outputfile ('","'.&Apache::loncommon::csv_translate('Grades Assigned').
		       '"'."\n");
    return ($outputfile,$filename);
}

sub init_excel_output {
    my ($r) = @_;
    my ($excel_workbook,$filename,$format)=
	&Apache::loncommon::create_workbook($r);
    return if (! defined($excel_workbook));
    my $rows_output = 0;
    my $cols_output = 0;
    my $header_row = $rows_output++;
    my $description_row = $rows_output++;
    $rows_output++;        # blank row
    
    my $sheetname = $env{'course.'.$env{'request.course.id'}.'.description'};
    $sheetname = &Apache::loncommon::clean_excel_name($sheetname);
    my $excel_sheet = $excel_workbook->addworksheet($sheetname);
    $excel_sheet->write($header_row,$cols_output++,
			$env{'course.'.$env{'request.course.id'}.'.description'},
			$format->{'h1'});
    $cols_output += 3;
    my $sectionstring = '';
#    my @Sections = &Apache::lonstatistics::get_selected_sections(); #This is never used
    $excel_sheet->write($header_row,$cols_output++,
			&Apache::lonstatistics::section_and_enrollment_description('plaintext'),
			$format->{'h3'});
    
    $excel_sheet->write($header_row,$cols_output++,
			&mt('Compiled on [_1]',&Apache::lonlocal::locallocaltime(time)),
                        $format->{'h3'});
    $cols_output = 0;
    foreach my $field ('Grader Name','Username','Grades Assigned') {
	$excel_sheet->write($description_row,$cols_output++,&mt($field),
			    $format->{'bold'});
    }
    return ($excel_workbook,$excel_sheet,$filename,$format,$rows_output);
}

#########################################################
#########################################################
##
##   Generic Interface Routines
##
#########################################################
#########################################################
sub create_interface {
    ##
    ## Build the menu
    my $output_selector = $/.'<select name="output">'.$/;
    foreach ('HTML','Excel','CSV') {
        $output_selector .= '    <option value="'.lc($_).'"';
        if ($env{'form.output'} eq lc($_)) {
            $output_selector .= ' selected="selected"';
        }
        $output_selector .='>'.&mt($_).'</option>'.$/;
    } 
    $output_selector .= '</select>'.$/;

    my $str = '';
    $str .= &Apache::lonhtmlcommon::breadcrumbs('Detailed Grading Statistics');
    $str .= '<table cellspacing="5">'."\n";
    $str .= '<tr>';
    $str .= '<td align="center"><b>'.&mt('Sections').'</b></td>';
    $str .= '<td align="center"><b>'.&mt('Groups').'</b></td>';
    $str .= '<td align="center"><b>'.&mt('Access Status').'</b></td>';
    $str .= '<td>'.&mt('[_1]Output as[_2] [_3]','<b>',$output_selector,'</b>').'</td>';
    $str .= '</tr>'."\n";
    ##
    ## 
    $str .= '<tr><td align="center">'."\n";
    $str .= &Apache::lonstatistics::SectionSelect('Section','multiple',5);
    $str .= '</td>';
    #
    $str .= '<td align="center">'."\n";
    $str .= &Apache::lonstatistics::GroupSelect('Group','multiple',5);
    $str .= '</td>';
    #
    $str .= '<td align="center">';
    $str .= &Apache::lonhtmlcommon::StatusOptions(undef,undef,5);
    $str .= '</td>';
    #
    $str .= '<td>';
    $str .= '</td>';
    ##
    ##
    $str .= '</tr>'."\n";
    $str .= '</table>'."\n";
    return $str;
}

1;

__END__
