# The LearningOnline Network
# checks for a cookie to authenticate a user
#
# $Id: checkauthen.pm,v 1.19 2015/09/21 14:25:03 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

package Apache::checkauthen;

use strict;
use Apache::Constants qw(:common);
use Apache::lonnet;

sub handler {
    my ($r) = @_;

    if ($r->uri() =~ m{^/res/adm/pages/[^/]+\.(gif|png)$}) {
        if ($r->user() eq '') {
            $r->user('public:public');
        }
        return OK;
    }

    if (&Apache::lonnet::is_domainimage($r->uri)) {
        if ($r->user() eq '') {
            $r->user('public:public');
        }
        return OK;
    }

    if ($r->auth_type() ne 'LONCAPA') {
	return DECLINED;
    }
    my $fail = FORBIDDEN; 
    if ($r->dir_config('lonOtherAuthen') eq 'yes') {
	if (defined($r->dir_config('lonOtherAuthenType'))) {
            $r->auth_type($r->dir_config('lonOtherAuthenType'));
        }
	#&Apache::lonnet::logthis("other authen");
	$fail = DECLINED;
    }

    if ($env{'user.name'} eq 'public' 
	&& $env{'user.domain'} eq 'public') {
	if ($env{'request.publicaccess'} ) {
            if ($r->user() eq '') {
                $r->user('public:public');
            }
	    return OK;
	} else {
	    return $fail;
	}
    }

    my %user;
    my $handle = &Apache::lonnet::check_for_valid_session($r,undef,\%user);
    if ($handle eq '') {
        $handle = $env{'user.environment'};
        if (($handle ne '') && ($r->user() eq '')) {
            if ($env{'user.domain'} eq $r->dir_config('lonDefDomain')) {
                $r->user($env{'user.name'});
            } else {
                $r->user($env{'user.name'}.':'.$env{'user.domain'});
            }
        }
    }

    if ($handle ne '') {
        if ($r->user() eq '') {
            if ($user{'domain'} eq $r->dir_config('lonDefDomain')) {
                $r->user($user{'name'});
            } else {
                $r->user($user{'name'}.':'.$user{'domain'});
            }
        }
        return OK;
    }
    if (($fail == FORBIDDEN) &&
        (($r->uri eq '/adm/email') || ($r->uri eq '/adm/preferences') ||
         ($r->uri eq '/adm/requestcourse'))) {
        $env{'form.firsturl'} = $r->uri;
    }
    return $fail;
}

1;
