# Checks contentopen/close settings disable subsequent PerlHandlers if not open
# $Id: londatecheck.pm,v 1.13 2012/04/11 11:40:07 goltermann Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use strict;
package Apache::londatecheck;
use Apache::lonnet;
use Apache::lonlocal;
use Apache::loncommon();
use Apache::Constants qw(:common :http :methods);

sub content_date_check {
    my $symb=$env{'request.symb'};
    my $open=&Apache::lonnet::EXT('resource.0.contentopen',$symb);
    my $close=&Apache::lonnet::EXT('resource.0.contentclose',$symb);
    if ( (defined($open)  && $open  ne '' && time < $open) ) {
	return ('CLOSED',$open,$close,
		'<p class="LC_warning">'.&mt('Not open to be viewed').'</p>'.
		&mt("This resource currently isn't open. ".
		    "It will be available at [_1].",
		    &Apache::lonlocal::locallocaltime($open)));
    }
    if ( (defined($close) && $close ne '' && time > $close) ) {
	return ('CLOSED',$open,$close,
		'<p class="LC_warning">'.&mt('Not open to be viewed').'</p>'.
		&mt("This resource is no longer available to be viewed."));
    }
    return ('OPEN',$open,$close);
}

sub handler {
    my ($r)=@_;
    if (&Apache::lonnet::allowed('bre',$r->uri) eq 'F') {
	return DECLINED;
    }
    my ($status,$open,$close,$msg)=&content_date_check();
    if ($status ne 'OPEN') {
	$r->set_handlers('PerlHandler'=>undef);
	&Apache::loncommon::content_type($r,'text/html');
	$r->send_http_header;
	return OK if $r->header_only;
	my $start_page =
	    &Apache::loncommon::start_page('Not Open',undef,
					   {'bgcolor'        => '#FFFFFF',
					    'force_register' => 1,});
	my $end_page   =
	    &Apache::loncommon::end_page({'discussion' => 1});
	$r->print($start_page.$msg.$end_page);

	return OK;
    }
    return DECLINED;
}
1;
