# The LearningOnline Network
# Access Handler for User File Transfers
#
# $Id: lontokacc.pm,v 1.19 2007/05/16 09:45:58 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lontokacc;

use strict;
use Apache::Constants qw(:common :remotehost);
use Apache::lonnet();
use Apache::File();
use IO::Socket;

sub handler {
    my $r = shift;
    my $reqhost = $r->get_remote_host(REMOTE_NOLOOKUP);
    my @hostids= &Apache::lonnet::get_hosts_from_ip($reqhost);
    if (!@hostids && $reqhost ne '127.0.0.1' ) {
	$r->log_reason("Unable to find a host for ".
		       $r->get_remote_host(REMOTE_NOLOOKUP));
	return FORBIDDEN;
    }
    if ($reqhost eq '127.0.0.1') {
       return OK;
    }
    return OK;
}

sub removefile {
    my $r=shift;
    if ($r->status==200) {
        unlink($r->filename);
	#&Apache::lonnet::logthis('Unlinking '.$r->filename);
    } else {
        &Apache::lonnet::logthis('Failed to transfer '.$r->filename);
    }
    return OK;
}
1;
__END__







