# The LearningOnline Network
# Switch Servers Handler
#
# $Id: switchserver.pm,v 1.35 2016/12/16 15:31:11 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::switchserver;

use strict;
use Apache::Constants qw(:common);
use Apache::lonnet;
use Apache::lonmenu;
use CGI::Cookie();
use Apache::lonlocal;
use LONCAPA qw(:DEFAULT :match);

sub init_env {
    my ($r) = @_;
    
    if (-e $env{'user.environment'}) {
	return  $env{'user.environment'};
    }
    my $requrl=$r->uri;
    my $handle= &Apache::lonnet::check_for_valid_session($r);
    if ($handle ne '') {
	return undef;
    }
    my $lonidsdir=$r->dir_config('lonIDsDir');
    &Apache::lonnet::transfer_profile_to_env($lonidsdir,$handle);
    
    return $r->dir_config('lonIDsDir')."/$handle.id";
}

sub do_redirect {
    my ($r,$url,$only_body,$extra_text) = @_;
    $r->send_http_header;
    my $start_page = 
	&Apache::loncommon::start_page('Switching Server ...',undef,
				       {'redirect'       => [0.5,$url],
					'only_body'      => $only_body,});
    my $end_page   = &Apache::loncommon::end_page();
    $r->print($start_page.$extra_text.$end_page);
    unless ($env{'user.name'} eq 'public' && ($env{'user.domain'} eq 'public')) {
        $r->register_cleanup(\&flush_course_logs);
    }
    return OK;
}

sub flush_course_logs {
    &Apache::lonnet::flushcourselogs();
    return OK;
}

sub handler {
    my ($r) = @_;
    
    my $handle=&init_env($r);
    if (!defined($handle)) { return FORBIDDEN; }

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
				['otherserver','role','origurl','symb']);

    my $switch_to=&Apache::lonnet::hostname($env{'form.otherserver'});
    if (! $env{'form.otherserver'}) {
	$env{'form.otherserver'} =	
	    &Apache::lonnet::find_existing_session($env{'user.domain'},
						   $env{'user.name'});
	if (! $env{'form.otherserver'}) {
	    $env{'form.otherserver'} = 
		&Apache::lonnet::spareserver(30000,undef,1);
	}
	$switch_to=&Apache::lonnet::hostname($env{'form.otherserver'});
    }

    if (!defined($switch_to)) { return FORBIDDEN; }

    my $protocol = 'http';
    if ($env{'form.otherserver'}) {
        if ($Apache::lonnet::protocol{$env{'form.otherserver'}} eq 'https') {
            $protocol = $Apache::lonnet::protocol{$env{'form.otherserver'}};
        }
    } 

    if ($env{'user.name'} eq 'public'
	&& $env{'user.domain'} eq 'public') {
	my $url = $protocol.'://'.$switch_to.$r->uri;
	return &do_redirect($r,$url,1)
    }

    my $skip_canhost_check = '';
    if ($env{'form.role'}) {
        if (!exists($env{'user.role.'.$env{'form.role'}})) {
            delete($env{'form.role'});
        } else {
            my $now = time;
            my ($start,$end) = split(/\./,$env{'user.role.'.$env{'form.role'}});
            if (($start && $start > $now) || ($end && $end < $now)) {
                delete($env{'form.role'});
            } elsif ($env{'form.role'} eq 'au./'.$env{'user.domain'}.'/') {
                if (&Apache::lonnet::homeserver($env{'user.name'},$env{'user.domain'}) eq $env{'form.otherserver'}) {
                    $skip_canhost_check = 1;
                }
            } elsif ($env{'form.role'} =~ m{^[ac]a\./($match_domain)/($match_username)$}) {
                if (&Apache::lonnet::homeserver($2,$1) eq $env{'form.otherserver'}) {
                    $skip_canhost_check = 1; 
                }
            }
        }
    }

    unless ($skip_canhost_check) {
        my $canhost = 1;
        my $uprimary_id = &Apache::lonnet::domain($env{'user.domain'},'primary');
        my $uint_dom = &Apache::lonnet::internet_dom($uprimary_id);
        my @intdoms;
        my $internet_names = &Apache::lonnet::get_internet_names($env{'form.otherserver'});
        if (ref($internet_names) eq 'ARRAY') {
            @intdoms = @{$internet_names};
        }
        unless ($uint_dom ne '' && grep(/^\Q$uint_dom\E$/,@intdoms)) {
            my $serverhomeID = &Apache::lonnet::get_server_homeID($switch_to);
            my $serverhomedom = &Apache::lonnet::host_domain($serverhomeID);
            my %defdomdefaults = &Apache::lonnet::get_domain_defaults($serverhomedom);
            my %udomdefaults = &Apache::lonnet::get_domain_defaults($env{'user.domain'});
            my $remoterev = &Apache::lonnet::get_server_loncaparev($env{'user.domain'},$env{'form.otherserver'});
            $canhost = 
                &Apache::lonnet::can_host_session($env{'user.domain'},
                                                  $env{'form.otherserver'},
                                                  $remoterev,
                                                  $udomdefaults{'remotesessions'},
                                                  $defdomdefaults{'hostedsessions'});
        }
        unless ($canhost) { return FORBIDDEN; }
    }

    #remove session env, and log event
    unlink($handle);
    my %temp=('switchserver' => time.':'.$env{'form.otherserver'},
	      $env{'form.role'});
    &Apache::lonnet::put('email_status',\%temp);
    my $logmsg = "Switch Server to $env{'form.otherserver'}";
    if ($env{'form.role'}) {
        $logmsg .= " with role: $env{'form.role'}";
    } else {
        $logmsg .= " (no role)";
    }
    $logmsg .= ' '.$ENV{'REMOTE_ADDR'};
    &Apache::lonnet::log($env{'user.domain'},$env{'user.name'},
			 $env{'user.home'},$logmsg);

    &Apache::loncommon::content_type($r,'text/html');

    #expire the cookie
    my $c = new CGI::Cookie(-name    => 'lonID',
			    -value   => '',
			    -expires => '-10y',);
    $r->header_out('Set-cookie' => $c);

    if ($r->header_only) {
	$r->send_http_header;
	return OK;
    }
# -------------------------------------------------------- Menu script and info
	   
# ---------------------------------------------------------------- Get handover

    my ($is_balancer) = &Apache::lonnet::check_loadbalancing($env{'user.name'},$env{'user.domain'});
    my %info=('ip'       => $ENV{'REMOTE_ADDR'},
	      'domain'   => $env{'user.domain'},
	      'username' => $env{'user.name'},
	      'role'     => $env{'form.role'},
	      'server'   => $r->dir_config('lonHostID'),
	      'balancer' => $is_balancer);
    if ($env{'form.origurl'}) {
        $info{'origurl'} = $env{'form.origurl'};
    }
    if ($env{'form.symb'}) {
        $info{'symb'} = $env{'form.symb'};
    }
    if ($env{'request.sso.login'}) {
	$info{'sso.login'} = $env{'request.sso.login'};
    }
    if ($env{'request.sso.reloginserver'}) {
        $info{'sso.reloginserver'} = $env{'request.sso.reloginserver'};
    }
    my $token = &Apache::lonnet::tmpput(\%info,$env{'form.otherserver'});
    my $url =$protocol.'://'.$switch_to.'/adm/login?'.
	'domain='.$env{'user.domain'}.
	'&amp;username='.$env{'user.name'}.
	'&amp;token='.$token;
# --------------------------------------------------------------- Screen Output
    return &do_redirect($r, $url, 0);
}

1;
__END__








