# The LearningOnline Network with CAPA
# Handler to set domain-wide configuration settings
#
# $Id: lonconfigsettings.pm,v 1.21.4.9 2016/10/23 21:13:51 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#
###############################################################
##############################################################

package Apache::lonconfigsettings;

use strict;
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonhtmlcommon();
use Apache::lonlocal;
use Apache::courseclassifier();
use LONCAPA qw(:DEFAULT :match);

sub print_header {
    my ($r,$phase,$context,$jscript,$container) = @_;
    my ($pagetitle,$brcrumtitle,$action,$call_category_check,$instcode_check,
        $crstype,@actions,@code_order);
    if ($phase eq 'display') {
        @actions = &Apache::loncommon::get_env_multiple('form.actions');
    }
    if ($context eq 'domain') {
        ($pagetitle, $brcrumtitle) = ('View/Modify Domain Settings','View/Modify Domain Settings');
        $action = '/adm/domainprefs';
        if ($phase eq 'display') {
            if (grep(/^coursecategories$/,@actions)) {
                $call_category_check = qq|
    if (formname == document.display) {
        if (!categoryCheck(formname)) {
            return;
        }
    }
|;
            }
        }
    } else {
        $crstype = &Apache::loncommon::course_type();
        if ($crstype eq 'Community') {
            ($pagetitle,$brcrumtitle) = ('Community Configuration','Community Configuration');
        } else {
            ($pagetitle,$brcrumtitle) = ('Course Configuration','Course Configuration');
        }
        $action = '/adm/courseprefs';
        if ($phase eq 'display') {
            if (grep(/^courseinfo$/,@actions)) {
                my %codedefaults;
                &Apache::lonnet::auto_instcode_defaults($env{'request.role.domain'},\%codedefaults,
                                                        \@code_order);
                if (@code_order) {
                   my $noinstcodestr = &mt('You indicated cloning based on category, but did not select any categories.');
                   &js_escape(\$noinstcodestr);
                   $instcode_check = <<"ENDSCRIPT";
    if (formname == document.display) {
        if (formname.cloners_instcode.length) {
            for (var j=0; j<formname.cloners_instcode.length; j++) {
                if (formname.cloners_instcode[j].checked) {
                    if (formname.cloners_instcode[j].value == 1) {
                        var codes;
                        if (document.getElementsByClassName) {
                            codes = document.getElementsByClassName('LC_cloners_instcodes');
                        } else {
                            codes = getElementsByClassName(document.body,'LC_cloners_instcodes');
                        }
                        if (codes.length) {
                            var gotcode = 0;
                            for (var i=0; i<codes.length; i++) {
                                if (codes[i].selectedIndex != 0) {
                                     gotcode = 1;
                                     break;
                                }
                            }
                            if (!gotcode) {
                                for (var k=0; k<formname.cloners_instcode.length; k++) {
                                    if (formname.cloners_instcode[k].value == 0) {
                                        formname.cloners_instcode[k].checked = true;
                                    }
                                }
                                toggleCloners(document.display.cloners_instcode);
                                alert('$noinstcodestr');
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

ENDSCRIPT
                }
            }
        }
    }
    my $alert = &mt('You must select at least one functionality type to display.');
    &js_escape(\$alert);
    my $js = '
<script type="text/javascript">
// <![CDATA[

function changePage(formname,newphase) {
    formname.phase.value = newphase;
    numchecked = 0;
    if (formname == document.pickactions) {
        if (formname.actions.length > 0) {
            for (var i = 0; i<formname.actions.length; i++) {
                if (formname.actions[i].checked) {
                    numchecked ++;
                }
            }
        } else {
            if (formname.actions.checked) {
                numchecked ++;
            }
        }
        if (numchecked > 0) {
            formname.submit();
        } else {
            alert("'.$alert.'");
            return;
        }
    }
    '.$instcode_check.$call_category_check.'
    formname.submit();
}'."\n";
    if ($phase eq 'pickactions') {
        $js .= &Apache::lonhtmlcommon::color_picker();
        $js .=
            &Apache::lonhtmlcommon::set_form_elements({actions => 'checkbox'})."\n";
    } elsif ($phase eq 'display') {
        $js .= &Apache::lonhtmlcommon::color_picker();
        $js .= &color_pick_js()."\n";
    }
    $js .= &Apache::loncommon::viewport_size_js().'

// ]]>
</script>
';
    if ($jscript) {
        $js .= "

$jscript

";
    }
    my $additem;
    if ($phase eq 'pickactions') {
        my %loaditems = (
                    'onload' => "setFormElements(document.pickactions);",
                        );
        $additem = {'add_entries' => \%loaditems,};
    } elsif ($phase eq 'display') {
        if ($context eq 'domain') {
            if (grep(/^coursedefaults$/,@actions)) {
                my %loaditems = (
                    '             onload' => "toggleDisplay(document.display,'cloneinstcode');".
                                             "toggleDisplay(document.display,'credits');".
                                             "toggleDisplay(document.display,'studentsubmission');",
                                );
                $additem = {'add_entries' => \%loaditems,};
            }
        } elsif ($context eq 'course') {
            if (grep(/^courseinfo$/,@actions)) {
                if (@code_order) {
                    $additem = {
                                   add_entries => {'onload' => "courseSet('','load');toggleCloners(document.display.cloners_instcode);"},
                               };
                }
            }
        }
    }
    $r->print(&Apache::loncommon::start_page($pagetitle,$js,$additem));
    $r->print(&Apache::lonhtmlcommon::breadcrumbs($brcrumtitle));
    $r->print('
<form name="parmform" action="">
<input type="hidden" name="pres_marker" />
<input type="hidden" name="pres_type" />
<input type="hidden" name="pres_value" />
</form>
');
    $r->print('<form method="post" name="'.$phase.'" action="'.$action.'"'.
              ' enctype="multipart/form-data">');
    return;
}

sub print_footer {
    my ($r,$phase,$newphase,$button_text,$actions,$container,$parm_permission) = @_;
    $button_text = &mt($button_text);
    $r->print('<input type="hidden" name="phase" value="" />');
    if (defined($env{'form.origin'})) {
        $r->print('<input type="hidden" name="origin" value="'.$env{'form.origin'}.'" />'."\n");
    }
    if (($phase eq 'display') || ($phase eq 'process')) {
        if (ref($actions) eq 'ARRAY') {
            foreach my $item (@{$actions}) {
                $r->print('<input type="hidden" name="actions" value="'.$item.'" />'."\n");
            }
        }
    }
    my $dest='"javascript:changePage(document.'.$phase.','."'$newphase'".')"';
    if ($phase eq 'process') {
        $r->print(
            &Apache::lonhtmlcommon::actionbox(
                ['<a href='.$dest.'>'.$button_text.'</a>']));
    } else {
        my $onclick;
        if ($phase eq 'display') {
            $onclick = '"javascript:changePage(document.'.$phase.','."'$newphase'".')"';
        } else {
            $onclick = '"javascript:changePage(document.'.$phase.','."'$newphase'".')"';
        }
        my $showbutton = 1;
        if (ref($parm_permission) eq 'HASH') {
            unless (($parm_permission->{'process'}) || ($newphase eq 'display')) {
                $showbutton = 0;
            }
        }
        if ($showbutton) {
            $r->print('<p><input type="button" name="store" value="'.
                      $button_text.'" onclick='.$onclick.' /></p>');
        }
    }
    if ($phase eq 'process') {
        $r->print('</form>');
        $r->print(&Apache::loncommon::end_page());
    }
    return;
}

sub make_changes {
    my ($r,$dom,$phase,$context,$prefs_order,$prefs,$values,$confname,$roles,
        $allitems,$container,$parm_permission) = @_;
    my %brcrumtext = &get_crumb_text();
    my @actions = &Apache::loncommon::get_env_multiple('form.actions');
    my ($numchanged,%changes,%disallowed);
    &Apache::lonhtmlcommon::add_breadcrumb
      ({href=>"javascript:changePage(document.$phase,'display')",
        text=>$brcrumtext{$context}},
       {href=>"javascript:changePage(document.$phase,'$phase')",
        text=>"Updated"});
    &print_header($r,$phase,$context,undef,$container);
    my ($crstype,%lastact);
    if ($context eq 'course') {
        $crstype = &Apache::loncommon::course_type();
    }
    if ((ref($prefs_order) eq 'ARRAY') && (ref($prefs) eq 'HASH') && 
        (ref($prefs) eq 'HASH')) {
        foreach my $item (@{$prefs_order}) {
            if (grep(/^\Q$item\E$/,@actions)) {
                if ($context eq 'domain') {
                    $r->print('<h3>'.&mt($prefs->{$item}{'text'}).'</h3>'.
                              &Apache::domainprefs::process_changes($r,$dom,
                                          $confname,$item,$roles,$values,\%lastact));
                } else {
                    $changes{$item} = {};
                    &Apache::courseprefs::process_changes($dom,$item,$values,
                                                          $prefs->{$item},$changes{$item},
                                                          $allitems,\%disallowed,$crstype);
                    if (keys(%{$changes{$item}}) > 0) {
                        $numchanged ++;
                    }
                }
            }
        }
    }
    if ($context eq 'course') {
        if ($numchanged) {
            my $message = &Apache::courseprefs::store_changes($dom,$confname,$prefs_order,\@actions,
                                                          $prefs,$values,\%changes,$crstype);
            $r->print(&Apache::loncommon::confirmwrapper($message));
        } else {
            if ($crstype eq 'Community') {
                $r->print(&Apache::loncommon::confirmwrapper(&mt("No changes made to community configuration.")));
            } else {
                $r->print(&Apache::loncommon::confirmwrapper(&mt("No changes made to course configuration.")));
            }
        }
        if (keys(%disallowed) > 0) {
            $r->print('<p>');
            foreach my $item ('cloners','rolenames','feedback','discussion','localization') {
                if (ref($disallowed{$item}) eq 'HASH') {
                    if (keys(%{$disallowed{$item}}) > 0) {
                        $r->print(&Apache::courseprefs::display_disallowed($item,$disallowed{$item},
                                                                           $prefs,$crstype));
                    }
                }
            }
            $r->print('</p>');
        }
    }
    $r->print('<p>');
    my $footer_text = 'Back to configuration display';
    if ($context eq 'course') {
        $footer_text = 'Back to display/edit settings'; 
    }
    &print_footer($r,$phase,'display',$footer_text,\@actions,$container,$parm_permission);
    $r->print('</p>');
    return \%lastact;
}

sub display_settings {
    my ($r,$dom,$phase,$context,$prefs_order,$prefs,$values,$confname,$jscript,
        $allitems,$crstype,$container,$parm_permission) = @_;
    my %brcrumtext = &get_crumb_text();
    my @actions = &Apache::loncommon::get_env_multiple('form.actions');
    &Apache::lonhtmlcommon::add_breadcrumb
        ({href=>"javascript:changePage(document.$phase,'display')",
          text=>"Display/Edit Settings"});
    my $instcode;
    if (ref($values) eq 'HASH') {
        $instcode = $values->{'internal.coursecode'};
    }
    &print_header($r,$phase,$context,$jscript,$container,$instcode);
    my $divwidth = 900;
    if ((ref($prefs_order) eq 'ARRAY') && (ref($prefs) eq 'HASH') && (ref($values) eq 'HASH')) { 
        if (@actions > 0) {
            my $rowsum = 0;
            my (%output,%rowtotal,@items);
            foreach my $item (@{$prefs_order}) {
                if (grep(/^\Q$item\E$/,@actions)) {
                    push(@items,$item);
                    if ($context eq 'domain') {
                        my $settings;
                        if (ref($values) eq 'HASH') {
                            $settings = $values->{$item};
                        }
                        if ($item eq 'usersessions') {
                            $r->print('<script type="text/javascript">'."\n".
                                      '// <![CDATA['."\n".
                                      &Apache::loncommon::check_uncheck_jscript()."\n".
                                      '// ]]>'."\n".
                                      '</script>'."\n");
                        } elsif ($item eq 'selfcreation') {
                            if (ref($values) eq 'HASH') {
                                $settings = $values->{'usercreation'};
                            }
                        } elsif ($item eq 'defaults') {
                            if (ref($values->{'inststatus'}) eq 'HASH') {
                                if (ref($values->{'defaults'}) eq 'HASH') {
                                    $settings = {%{$values->{'inststatus'}},%{$values->{'defaults'}}};
                                } else {
                                    $settings = $values->{'inststatus'};
                                }
                            } else {
                                my ($othertitle,$usertypes,$types) = &Apache::loncommon::sorted_inst_types($dom);
                                my $inststatus = {
                                                   inststatustypes => $usertypes,
                                                   inststatusorder => $types,
                                                   inststatusguest => [],
                                                 };
                                if (ref($values->{defaults}) eq 'HASH') {
                                    $settings = {%{$inststatus},%{$values->{'defaults'}}};
                                } else {
                                    $settings = $inststatus;
                                }
                            }
                        }
                        ($output{$item},$rowtotal{$item}) =
                            &Apache::domainprefs::print_config_box($r,$dom,$confname,
                                $phase,$item,$prefs->{$item},$settings);
                    } else {
                        ($output{$item},$rowtotal{$item}) =
                            &Apache::courseprefs::print_config_box($r,$dom,$phase,
                                $item,$prefs->{$item},$values,$allitems,$crstype,$parm_permission);
                    }
                    $rowsum += $rowtotal{$item};
                }
            }
            $r->print('<div id="prefs" style="max-width:'.$divwidth.'px;margin: 10px auto 10px auto;">');
            for (my $i=0; $i<@items; $i++) {
                $r->print($output{$items[$i]});
            }
            $r->print('</div>');
            $r->print(&print_footer($r,$phase,'process','Save Changes',\@actions,$container,$parm_permission));
        } else {
            $r->print('<input type="hidden" name="phase" value="" />'.
                      '<span class="LC_error">'.&mt('No settings chosen').
                      '</span>');
        }
        $r->print('</form>');
    }
    $r->print(&Apache::loncommon::end_page());
    return;
}

sub display_choices {
    my ($r,$phase,$context,$prefs_order,$prefs,$container,$parm_permission) = @_;
    if ($phase eq '') {
        $phase = 'pickactions';
    }
    my %helphash;
    &print_header($r,$phase,$context,undef,$container);
    $r->print('<script type="text/javascript">'."\n".
              '// <![CDATA['."\n".
              &Apache::loncommon::check_uncheck_jscript()."\n".
              '// ]]>'."\n".
              '</script>'."\n");
    my $heading = &mt('Settings to display/modify');
    if (ref($parm_permission) eq 'HASH') {
        unless ($parm_permission->{'process'}) {
            $heading = &mt('Settings to display');
        }
    }
    $r->print('<h3>'.$heading.'</h3>'.
              '<div><input type="button" value="'.&mt('check all').'" '.
              'onclick="javascript:checkAll(document.pickactions.actions)"'.
              ' />'.('&nbsp;'x2).
              '<input type="button" value="'.&mt('uncheck all').'" '.
              'onclick="javascript:uncheckAll(document.pickactions.actions)" />'.
              "\n".
              '</div><div class="LC_left_float">');
    my ($numitems,$maxincol,$firstthird,$secondthird,$seconddiv,$thirddiv,$count);
    if (ref($prefs_order) eq 'ARRAY') {
        $numitems = @{$prefs_order};
    }
    my $numcols = 3;
    $maxincol = int($numitems/$numcols);
    if ($numitems%$numcols) {
        $maxincol ++;
    }
    $firstthird = $maxincol;
    $secondthird = $firstthird + $maxincol;
    $count = 0;
    if ((ref($prefs_order) eq 'ARRAY') && (ref($prefs) eq 'HASH')) {
        foreach my $item (@{$prefs_order}) {
            $r->print('<h4>'.
                      &Apache::loncommon::help_open_topic($prefs->{$item}->{'help'}).
                      '<label><input type="checkbox" name="actions" value="'.$item.
                      '" />&nbsp;'.&mt($prefs->{$item}->{'text'}).'</label></h4>');
            $count ++;
            if ((!$seconddiv) && ($count >= $firstthird)) {
                $r->print('</div>'."\n".'<div class="LC_left_float">'."\n");
                $seconddiv = 1;
            }
            if ((!$thirddiv) && ($count >= $secondthird)) {
                $r->print('</div>'."\n".'<div class="LC_left_float">'."\n");
                $thirddiv = 1;
            }
        }
        $r->print('</div><br clear="all" />');
    }
    $r->print(&print_footer($r,$phase,'display','Display',undef,$container,$parm_permission));
    $r->print('</form>');
    $r->print(&Apache::loncommon::end_page());
    return;
}

sub color_pick_js {
    my $pjump_def = &Apache::lonhtmlcommon::pjump_javascript_definition();
    my $output = <<"ENDCOL";

    $pjump_def

    function psub() {
        modalWindow.close();
        if (document.parmform.pres_marker.value!='') {
            if (document.parmform.pres_type.value!='') {
                eval('document.display.'+
                     document.parmform.pres_marker.value+
                     '.value=document.parmform.pres_value.value;');
            }
        } else {
            document.parmform.pres_value.value='';
            document.parmform.pres_marker.value='';
        }
    }

    function get_id (span_id) {
        if (document.getElementById) {
            return document.getElementById(span_id);
        }
        if (document.all) {
            return document.all[span_id];
        }
        return false;
    }

    function colchg_span (span_id_str,new_color_item) {
        var span_ref = get_id(span_id_str);
        if (span_ref.style) { span_ref = span_ref.style; }
        span_ref.background = new_color_item.value;
        span_ref.backgroundColor = new_color_item.value;
        span_ref.bgColor = new_color_item.value;
    }

ENDCOL
    return $output;
}

sub get_crumb_text {
    my %brcrumbtext = (
                       domain => 'Domain Settings',
                       course => 'Display/Edit Settings',
                     );
    return %brcrumbtext;
}

1;
