# The LearningOnline Network with CAPA
# generate frame-based help system
#
# $Id: lonhelpmenu.pm,v 1.45 2017/02/20 00:36:40 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonhelpmenu;

use strict;
use lib qw(/home/httpd/lib/perl);
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::lonlocal;
use Apache::lonnet;
use lib '/home/httpd/lib/perl/';
use LONCAPA;
use HTML::Entities();

sub handler {
    my ($r) = @_;
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['page','faq','bug','topic','component_help','origurl','stayonpage']);
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;

    if ($r->header_only) {
        return OK;
    }
    my $faq = $env{'form.faq'};
    my $bug = $env{'form.bug'};
    my $topic = $env{'form.topic'};
    my $component_help = $env{'form.component_help'};
    my $origurl = $env{'form.origurl'};
    my $stayOnPage = $env{'form.stayonpage'};
    my $component_url = $component_help;
    if ($component_url) {
        $component_url = '/adm/help/'.$component_url.'.hlp';
    }
    my $bugurl = $Apache::lonnet::perlvar{'BugzillaHost'};
    $bugurl .= 'enter_bug.cgi?product=LON-CAPA&amp;bug_file_loc='.$origurl;
    if ($bug) {
        $bugurl .= '&amp;component='.$bug;
    }
    my $faqbaseurl = $Apache::lonnet::perlvar{'FAQHost'};
    my $origmail = $Apache::lonnet::perlvar{'lonSupportEMail'};
    $origurl = &unescape($origurl);
    my $defdom;
    if ($env{'request.course.id'}) {
        $defdom = $env{'course.'.$env{'request.course.id'}.'.domain'};
    } elsif ($env{'request.role.domain'}) {
        $defdom = $env{'request.role.domain'};
    } else {
        $defdom = &Apache::lonnet::default_login_domain();
    }
    my $requestmail = &Apache::loncommon::build_recipient_list(undef,'helpdeskmail',
                                                               $defdom,$origmail);
    if ($env{'form.page'} eq 'banner') {
        &display_help_banner($r,$faq,$bug,$topic,$component_url,$origurl,$bugurl,$faqbaseurl,$requestmail,$stayOnPage);
    } elsif ($env{'form.page'} eq 'body') {
        &display_help_mainpage($r,$faq,$bug,$topic,$component_url,$origurl,$bugurl,$faqbaseurl,$requestmail,$stayOnPage);
    }
    return OK;
}

sub display_help_banner {
    my ($r,$faq,$bug,$topic,$component_url,$origurl,$bugurl,$faqbaseurl,$requestmail,$stayOnPage) = @_;
    my $dom = $env{'request.role.domain'};
    my $scripttag = '';
    if ($requestmail) {
        my $displayurl = &escape($origurl);
        $scripttag = (<<"SCRIPT_ONE");
<script type="text/javascript">
// <![CDATA[
function gohelpdesk() {
    var actiontype = null;
    try {
        actiontype = parent.bodyframe.document.logproblem.action.value;
    }
    catch(error) {
        parent.bodyframe.location = "/adm/support?origurl=$displayurl";
        return;
    }
    if (actiontype) {
        var loc = parent.bodyframe.location.href;
        if (loc.indexOf("/adm/support") > -1) {
            if (parent.bodyframe.document.logproblem.action.value == "process") {
                if (validmail(parent.bodyframe.document.logproblem.email) == false) {
                    alert("The e-mail address you entered: "+parent.bodyframe.document.logproblem.email.value+" is not a valid e-mail address.");
                    return;
                }
                parent.bodyframe.document.logproblem.submit();
                return;
            }
        }
        parent.bodyframe.location = "/adm/support?origurl=$displayurl";
        return;
    }
}

SCRIPT_ONE
        $scripttag .= (<<'SCRIPT_TWO');
function validmail(field) {
    var str = field.value;
    if (window.RegExp) {
        var reg1str = "(@.*@)|(\\.\\.)|(@\\.)|(\\.@)|(^\\.)";
        var reg2str = "^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$"; //"
        var reg1 = new RegExp(reg1str);
        var reg2 = new RegExp(reg2str);
        if (!reg1.test(str) && reg2.test(str)) {
            return true;
        }
        return false;
    }
    else
    {

        if(str.indexOf("@") >= 0) {
            return true;
        }
        return false;
    }
}

// ]]>
</script>
SCRIPT_TWO
    }

    if ($stayOnPage) {
	$r->print(&Apache::loncommon::start_page('Help',$scripttag,
					         {'no_secondary_menu' => 1,}));
    } else {
        $r->print(&Apache::loncommon::start_page('Help',$scripttag,
                                                 {'only_body' => 1,}));
    }
    my $menu = &helpmenu_items($dom,$faq,$bug,$topic,$component_url,$origurl,$bugurl,$faqbaseurl,$requestmail,$stayOnPage);
    if ($menu) {
        $r->print("<ul id=\"LC_secondary_menu\">$menu</ul>");
    }
    if ($stayOnPage && $env{'user.adv'}) {
        $r->print('<br />');
    } 
    $r->print(&Apache::loncommon::end_page());
}

sub helpmenu_items {
    my ($dom,$faq,$bug,$topic,$component_url,$origurl,$bugurl,$faqbaseurl,$requestmail,$stayOnPage) = @_;
    my $location=&Apache::loncommon::lonhttpdurl("/adm");
    my $general_help = &Apache::loncommon::general_help();
    my %helpconfig = &Apache::lonnet::get_dom('configuration',['helpsettings'],$dom);
    my %lt = &Apache::lonlocal::texthash(
                                            general       => 'General help',
                                            component     => 'Topic help',
                                            faq           => 'FAQ',
                                            helpdesk      => 'Ask helpdesk',
                                            bugs          => 'Report a bug',
                                            manuals_web   => 'Online manuals',
                                            manuals_pdf   => 'Printable manuals',
                                            lastloc       => 'Go back',
                                            close         => 'Close',
                                         );
    my %items = (
                    general => {
                                 href => '/adm/help/'.$general_help.'.hlp',
                                 img  => $location.'/help/help.png',
                                 alt  => $lt{'general'},
                                 text => $lt{'general'},
                               },
                    component => {
                                   href => $component_url,
                                   img  => $location.'/help/help.png',
                                   alt  => $lt{'component'},
                                   text => $topic,
                                 },
                    faq      => {
                                   href => $faqbaseurl.'fom/cache/'.$faq.'.html',
                                   img  => $location.'/lonMisc/smallFAQ.gif',
                                   alt  => $lt{'faq'},
                                   text => $lt{'faq'},                                   
                                 },
                    helpdesk => {
                                   href    => '#',
                                   onclick => 'gohelpdesk()',
                                   img  => $location.'/lonIcons/helpdesk.gif',    
                                   alt  => $lt{'helpdesk'},
                                   text => $lt{'helpdesk'},
                                },
                    bugs     => {
                                   href => $bugurl,
                                   img  => $location.'/lonMisc/smallBug.gif', 
                                   alt  => $lt{'bugs'},
                                   text => $lt{'bugs'},
                                },
                    manuals_web  => {
                                       href => '',
                                       img  => $location.'/lonIcons/html.gif',
                                       alt  => $lt{'manuals_web'},
                                       text => $lt{'manuals_web'},
                                    },
                    manuals_pdf  => {
                                       href => '',
                                       img  => $location.'/lonIcons/pdf.gif',
                                       alt  => $lt{'manuals_pdf'},
                                       text => $lt{'manuals_pdf'},
                                    },
                    lastloc  => {
                                   href   => &HTML::Entities::encode($origurl,'"&<>'),
                                   img    => '/res/adm/pages/tolastloc.png',
                                   alt    => $lt{'lastloc'},
                                   text   => $lt{'lastloc'},
                                   target => '_top',
                                },
                    close    => {
                                   href   => 'javascript:window.close()',
                                   img    => $location.'/lonIcons/close.gif',
                                   alt    => $lt{'close'},
                                   text   => $lt{'close'},
                                   target => '_top',
                                },
    );
    my %help_submenu = (
                           manuals_web => [
                                            ['/adm/help/course.manual.access.hlp','Course Coordination','course'],
                                            ['/adm/help/author.manual.access.hlp','Authoring','author'],
                                          ],
                           manuals_pdf => [
                                            ['/adm/help/course.manual.pdf','Course Coordination','course'],
                                            ['/adm/help/author.manual.pdf','Authoring','author'],
                                          ],
                       );
    my @order = ('general');
    if ($component_url) {
        push(@order,'component');
    }
    if ($requestmail) {
        push(@order,'helpdesk');
    }
    if ($env{'user.adv'} && $faq) {
        push(@order,'faq');
    }
    if (($env{'user.adv'}) && (($helpconfig{'helpsettings'}{'submitbugs'} eq '1') || ($helpconfig{'helpsettings'}{'submitbugs'} eq ''))) {
        push(@order,'bugs');
    }
    if ($stayOnPage) {
        push(@order,('manuals_web','manuals_pdf','lastloc'));
    } else {
        push(@order,'close');
    }
    my $menu;
    foreach my $title (@order) {
        my $menuitem = $items{$title};
        next unless (ref($menuitem) eq 'HASH');
        if (defined($help_submenu{$title})) {
            my ($link,$target);
            if ($menuitem->{href} ne '') {
                $link = $menuitem->{href};
                $target = 'bodyframe';
            } else {
                $link = '#';
            }
            my @helpsub;
            if (ref($help_submenu{$title}) eq 'ARRAY') {
                foreach my $item (@{$help_submenu{$title}}) {
                    if (ref($item) eq 'ARRAY') {
                        if (($item->[2] eq 'course') || ($item->[2] eq 'author')) {
                            next unless($env{'user.adv'});
                        }
                        push(@helpsub,$item);
                    }
                }
                if (@helpsub > 0) {
                    my $img;
                    if ($menuitem->{img}) {
                        $img = '<img class="LC_noBorder" style="vertical-align:top" src="'.$menuitem->{img}.'" alt="'.$menuitem->{alt}.'" />';
                    }
                    $menu .= &create_submenu($link,$img,$target,$menuitem->{text},\@helpsub,1);
                } elsif ($link ne '#') {
                    $menu .= '<li><a href="'.$link.'" target="'.$target.'">'.$menuitem->{text}.'</a></li>';
                }
            }
        } else {
            $menu .= &build_menuitem($menuitem);
        }
    }
    return $menu;
}

sub build_menuitem {
    my ($menuitem) = @_;
    return '' unless(ref($menuitem) eq 'HASH');
    my $link;
    if ($menuitem->{img}) {
        $link = '<img style="vertical-align:top" class="LC_noBorder" src="'.$menuitem->{img}.'" alt="'.$menuitem->{alt}.'" />&nbsp;';
    }
    if ($menuitem->{text}) {
        $link .= $menuitem->{text};
    }
    my $target;
    if ($menuitem->{target}) {
        $target = $menuitem->{target};
    } else {
        $target = 'bodyframe';
    }
    my $onclick;
    if ($menuitem->{onclick}) {
        $onclick = ' onclick="'.$menuitem->{onclick}.';return false"';
    }
    return '<li><a href="'.$menuitem->{href}.'" target="'.$target.'"'.$onclick.'>'.$link.'</a></li>',
}

sub create_submenu {
    my ($link,$img,$target,$title,$submenu,$translate) = @_;
    return unless (ref($submenu) eq 'ARRAY');
    my $disptarget;
    if ($target ne '') {
        $disptarget = ' target="'.$target.'"';
    }
    my $menu = '<li class="LC_hoverable">'.$img.
               '<a href="'.$link.'"'.$disptarget.'>'.
               '<span class="LC_nobreak">'.$title.
               '<span class="LC_fontsize_small" style="font-weight:normal;">'.
               ' &#9660;</span></span></a>'.
               '<ul>';
    my $count = 0;
    my $numsub = scalar(@{$submenu});
    foreach my $item (@{$submenu}) {
        $count ++;
        if (ref($item) eq 'ARRAY') {
            my $href = $item->[0];
            my $borderbot;
            if ($count == $numsub) {
                $borderbot = 'border-bottom:1px solid black;';
            }
            $menu .= '<li style="margin:0;padding:0;'.
                     $borderbot.'"><a href="'.$href.'" target="bodyframe">';
            if ($translate) {
                $menu .= &mt($item->[1]);
            } else {
                $menu .= $item->[1];
            }
            $menu .= '</a></li>';
        }
    }
    $menu .= '</ul></li>';
    return $menu;
}

sub display_help_mainpage {
    my ($r,$faq,$bug,$topic,$component_url,$origurl,$bugurl,$faqbaseurl,$requestmail,$stayOnPage) = @_;

    my %lt =&Apache::lonlocal::texthash(
        'topp' => 'Topic Page',
        'chen' => 'Choose an entry below to go directly to a relevant help page',
        'orto' => 'or to submit a help request to the LON-CAPA support staff at your institution.',
        'vthp' => 'Visit the help page for ',
        'disp' => 'Display the page in the inline help system that covers this topic.',
        'crac' => 'Create an account for yourself in the LON-CAPA Bugzilla tracking system, if you wish to report bugs you have encountered in the LON-CAPA software, or if you have suggestions for improvements in LON-CAPA.',
        'cont' => 'Contact the LON-CAPA support team',
        'suhr' => 'Submit a help request to the team responsible for LON-CAPA support at this institution.',
        'faqo' => 'FAQ-O-Matic Help system',
        'tfaq' => 'The FAQ-O-Matic is a compendium of answers provided to common questions asked by users of LON-CAPA over the past couple of years.',
        'lbug' => 'LON-CAPA Bugzilla bug/feature request tracking system',
        'crea' => 'Create an account for yourself in the LON-CAPA Bugzilla tracking system, if you wish to report bugs you have encountered in the LON-CAPA software,or if you have suggestions for improvements in LON-CAPA.',
        'suim' => ' Suggested improvements may include additional functionality, improved usability, or changes to wording used in LON-CAPA pages, including the embedded help system.'
    );

    if ($stayOnPage) {
	$r->print(&Apache::loncommon::start_page('Help Content',undef,
				                 {'no_secondary_menu' => 1,}));
    } else {
        $r->print(&Apache::loncommon::start_page('Help Content',undef,
                                                 {'only_body' => 1,}));
    }
    if ($stayOnPage) {
        $r->print('<div>');
    } 
    $r->print('<b>'.$lt{'chen'});
    if ($requestmail) {
        $r->print(', '.$lt{'orto'});
    } else {
        $r->print(".");
    }
    $r->print('</b>');
    if ($topic) {
        if ( ($component_url) || ($env{'user.adv'}) ) {
            if ($component_url) {
                $r->print("
          <ul>
           <li><a href=\"$component_url\">$lt{'vthp'} $topic</a></li>
          </ul>
          <p>$lt{'disp'}</p>
                ");
            }
        }
    }
    if ($requestmail) {
        $r->print("
          <ul>
           <li><a href=\"/adm/support?origurl=".&escape($origurl)."\">$lt{'cont'}</a></li>
          </ul>
          <p>$lt{'suhr'}");
         unless ($env{'user.adv'}) {
             $r->print('<br />'.
                       &mt('[_1]Note[_2]: questions about course content should not be directed to the support team, but instead should be sent to the course instructor.'). 
                       ' '.
                       &mt('This can be done by clicking the [_1]Communicate[_2] link or the "Send Feedback" link when viewing a content page.',
                          '<a href="/adm/communicate" target="_top">','</a>')); 
         }
         $r->print("</p>");
    }
    if ($faqbaseurl && $env{'user.adv'}) {
        if (!defined($faq) ||$faq eq '') {
            $faq = '1';
        }
        $r->print("
          <ul>
           <li><a href=\"$faqbaseurl/fom/cache/$faq.html\">$lt{'faqo'}</a></li>
          </ul>
          <p>$lt{'tfaq'}</p>
        ");
    }
    if ($bugurl && $env{'user.adv'}) {
        $bugurl .= '?'.$bug;
        $r->print("
          <ul>
           <li><a href=\"$bugurl\">$lt{'lbug'}</a></li>
          </ul>
          <p>$lt{'crea'} $lt{'suim'}</p>
        ");
    }
    if ($stayOnPage) {
        $r->print('</div>');
    }
    $r->print(&Apache::loncommon::end_page());
}

1;
