# The LearningOnline Network with CAPA
# Routines to display the wishlist (handler)
#
# $Id: lonwishlistdisplay.pm,v 1.6 2014/02/28 19:24:03 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonwishlistdisplay;

use strict;
use Apache::Constants qw(:common :http);
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonhtmlcommon;
use Apache::lonlocal;
use Apache::lonwishlist;
use LONCAPA;
use Tree;


# Global variables
my $root;
my @childrenRt;
my %TreeHash;

 
# ----------------------------------------------------- Main Handler, package lonwishlistdisplay
sub handler {
    my ($r) = @_;

    if ($r->header_only) {
        &Apache::loncommon::content_type($r,'text/html');
        $r->send_http_header;
        return OK;
    }

    if ($env{'user.adv'}) {
        &Apache::loncommon::content_type($r,'text/html');
        $r->send_http_header;
    } else {
        $env{'user.error.msg'}=
            "/adm/wishlist:bre:0:0:No rights to access Stored Links";
        return HTTP_NOT_ACCEPTABLE;
    }

    if (&Apache::lonwishlist::getWishlist() ne 'error') {
        # get wishlist entries from user-data db-file and build a tree out of these entries
        %TreeHash = &Apache::lonwishlist::getWishlist();

        $root = &Apache::Tree::HashToTree(\%TreeHash);
        @childrenRt = $root->children();

        # create a new entry
        if ($env{'form.title'}) {
           $root = &Apache::lonwishlist::newEntry($root, $env{'form.title'}, $env{'form.path'}, $env{'form.note'});
        }

        # get unprocessed_cgi (i.e. marked entries, mode ...)
        &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['action','mark','markedToMove','mode','newtitle','note','rat','setTitle','setPath']);

        # change the order of entries within a level, that means sorting the entries
        my $changeOrder = 0;
        if (defined($env{'form.sel'})) {
            my @sel = &Apache::loncommon::get_env_multiple('form.sel');
            my $indexNode;
            my $at;
            for (my $s=0; $s<($#sel+1); $s++) {
                if ($sel[$s] ne '') {
                    $indexNode = $s;
                    $at = $sel[$s]-1;
                }
            }
            if ($at ne '') {
                $changeOrder = 1;
                $root = &Apache::lonwishlist::sortEntries($root, $indexNode,$at);
            }
        }

        # get all marked (checkboxes) entries
        my @marked = ();
        if (defined($env{'form.mark'})) {
            @marked = &Apache::loncommon::get_env_multiple('form.mark');
        }

        # move entries from one folder to another
        if (defined($env{'form.markedToMove'})) {
           my $markedToMove = $env{'form.markedToMove'};
           my @ToMove = split(/\,/,$markedToMove);
           my $moveTo = $env{'form.mark'};
           if (defined($moveTo)) { 
               $root = &Apache::lonwishlist::moveEntries($root, \@ToMove,$moveTo);
           }
           $changeOrder = 1;
        }

        # delete entries
        if ($env{'form.action'} eq 'delete') {
            $root = &Apache::lonwishlist::deleteEntries($root, \@marked);
        }

        # get all titles and notes and save them
        # only save, if user wants to save changes
        # do not save, when current action is 'delete' or 'sort' or 'move'
        my @newTitles = ();
        my @newPaths = ();
        my @newNotes = ();
        if ((defined $env{'form.newtitle'} || defined $env{'form.newpath'} || defined $env{'form.newnote'})
            && ($env{'form.action'} ne 'noSave') && ($env{'form.action'} ne 'delete') && !$changeOrder) {
            @newTitles = &Apache::loncommon::get_env_multiple('form.newtitle');
            @newPaths = &Apache::loncommon::get_env_multiple('form.newpath');
            @newNotes = &Apache::loncommon::get_env_multiple('form.newnote');
            my $node = 0;
            foreach my $t (@newTitles) {
               $root = &Apache::lonwishlist::setNewTitle($root, $node, $t);
               $node++;
            }
            $node = 0;
            my $path = 0;
            for (my $i = 0; $i < ($#newTitles+1); $i++ ) {
               if (&Apache::lonwishlist::setNewPath($root, $node, $newPaths[$path])) {
                     $path++;
               }
               $node++;
            }
            $node = 0;
            foreach my $n (@newNotes) {
               $root =  &Apache::lonwishlist::setNewNote($root, $node, $n);
               $node++;
            }
        }

        # Create HTML-markup
        my $page;
        if ($env{'form.mode'} eq 'edit') {
            $page = &Apache::lonwishlist::makePage($root, "edit");
        } elsif ($env{'form.mode'} eq 'move') {
            $page = &Apache::lonwishlist::makePage($root, "move", \@marked);
        } elsif ($env{'form.mode'} eq 'import') {
            $page = &Apache::lonwishlist::makePageImport($root, $env{'form.rat'});
        } elsif ($env{'form.mode'} eq 'newLink') {
            $page = &Apache::lonwishlist::makePopUpNewLink($env{'form.setTitle'},$env{'form.setPath'});
        } elsif ($env{'form.mode'} eq 'newFolder') {
            $page = &Apache::lonwishlist::makePopUpNewFolder();
        } elsif ($env{'form.mode'} eq 'set') {
            $page = &Apache::lonwishlist::makePageSet();
        } else {
            $page = &Apache::lonwishlist::makePage($root, "view");
        }
        @marked = ();
        $r->print($page);
    } else {
        # An error occurred, print an error-page
        my $errorPage = &Apache::lonwishlist::makeErrorPage();
        $r->print($errorPage);
    }
    return OK;
}

1;
__END__
