# The LearningOnline Network with CAPA
# German Localization Lexicon
#
# $Id: de.pm,v 1.463.2.33 2017/05/30 04:06:55 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::de;
use base qw(Apache::localize);

%Lexicon=('_AUTO' => 1,

'char_encoding'=> 'UTF-8',
'language_code'=> 'de',
'lang_locale' => 'de_DE.utf8',
'date_locale'  =>
      '$weekday, $day. $month $year, $twentyfour:$minutes:$seconds Uhr',
'date_months'  => 'Jan.,Feb.,März,April,Mai,Juni,Juli,Aug.,Sep.,Okt.,Nov.,Dez.',
'date_days'    => 'So.,Mo.,Di.,Mi.,Do.,Fr.,Sa.',
'date_am' => 'vormittags',
'date_pm' => 'nachmittags',
'htmlarea_lang' => 'de',
'spellcheck_lang' => 'de',

   'Deutsch - UTF' # do not translate
=> 'Deutsch - UTF',

   'English - UTF' # do not translate
=> 'English - UTF',

   'Português - UTF' # do not translate
=> 'Português - UTF',

   'español (castellano) - UTF' # do not translate
=> 'español (castellano) - UTF',

   'français - UTF' # do not translate
=> 'français - UTF',

   'türkçe - UTF' # do not translate
=> 'türkçe - UTF',

   'Русский - UTF' # do not translate
=> 'Русский - UTF',

   'עברית - UTF' # do not translate
=> 'עברית - UTF',

   '日本語 - UTF' # do not translate
=> '日本語 - UTF',

   '简体中文 - UTF' # do not translate
=> '简体中文 - UTF',

   'ﺍیﺭﺎﻧی - UTF' # do not translate
=> 'ﺍیﺭﺎﻧی - UTF',

   'ﺎﻠﻋﺮﺒﻳﺓ - UTF' # do not translate
=> 'ﺎﻠﻋﺮﺒﻳﺓ - UTF',

   'Swedish Chef - UTF'
=> 'Dänischer Koch - UTF',

   'Currently no other LON-CAPA server is available to host your session either.'
=> 'Derzeit ist kein anderer LON-CAPA Server verfügbar, um Ihre Sitzung zu eröffnen.',

   'Session unavailable'
=> 'Sitzung nicht verfügbar',

   'This LON-CAPA server is unable to host your session.'
=> 'Der LON-CAPA-Server kann Ihre Sitzung nicht eröffnen.',

   'An error was detected ([_1]) for PaperID [_2]'
=> 'Auf dem Blatt ist in der Zeile [_2] ein Problem aufgetreten: [_1]',

   'An error was detected ([_1]) in scanline [_2] [_3]'
=> 'In der eingescannten Zeile [_2] [_3] ist ein Problem aufgetreten: [_1]',

   'Collaborators:'
=> 'Mitarbeiter:',

   'File(s) will be uploaded when you click on Save &amp; Next below.'
=> 'Die Dateien werden hochgeladen, sobald Sie auf Speichern und weiter klicken.',

   'More than one entry found for [_1]!'
=> 'Für [_1] wurde mehr als ein Eintrag gefunden!',

   'Notification message status: [_1]'
=> 'Status der Benachrichtigungs-Nachricht: [_1]',

   'Stored submissions'
=> 'Gespeicherte Einreichungen',

   'The ID on the form is [_1]'
=> 'Die ID auf dem Formular ist [_1]',

   'The name on the paper is [_1], [_2]'
=> 'Der Name auf dem Blatt ist [_1], [_2]',

   'There have been [_1]no[_2] bubbles scanned for some question(s)'
=> 'Für einige Fragen wurden [_1]keine[_2] Ankreuzfelder eingescannt.',

   'Unable to handle ambiguous references: [_1].'
=> 'Konnte mehrdeutige Referenzen nicht bearbeiten: [_1].',

   'You have forgotten to specify some information. Please go Back and try again.'
=> 'Sie haben vergessen, einige Daten anzugeben. Bitte gehen Sie zurück und versuchen Sie es noch einmal.',

   "You have not selected a file that contains the student's response data."
=> 'Sie haben keine Datei ausgewählt, die studentische Antworten enthält.',

   "You have not selected the format of the student's response data."
=> 'Sie haben kein Format für die Daten der studentischen Antworten ausgewählt.',

   '[_1] will be the uploaded filename [_2]'
=> '[_1] wird der hochgeladene Dateiname [_2] sein',

   '[_1]: point value larger than weight'
=> '[_1]: Punktwert ist größer als Gewichtung',

   'Add selection to keyword list? Edit if desired.'
=> 'Auswahl zur Schlüsselwortliste hinzufügen? Änderung möglich, falls gewünscht.',

   'Compose Message for: '
=> 'Nachricht erstellen für: ',

   'Font Style'
=> 'Zeichensatzstil',

   'font-style'
=> 'Zeichensatzstil',

   'font-weight'
=> 'Schriftschnitt',

   'Keyword Highlighting for Essays'
=> 'Schlüsselwort-Hervorhebung für Essays',

   'Highlight Attribute'
=> 'Attribut hervorheben',

   'Keyword Highlight Options'
=> 'Optionen für Schlüsselwort-Hervorhebung',

   'Keyword Options'
=> 'Schlüsselwortoptionen',

   'Keywords list, separated by a space. Add/delete to list if desired.'
=> 'Schlüsselwortliste, getrennt durch Leerzeichen. Zur Liste hinzufügen/entfernen, falls gewünscht.',

   'Please select a word or group of words from document and then click this link.'
=> 'Bitte wählen Sie ein Wort oder eine Gruppe von Wörtern in dem Dokument und klicken dann auf diesen Link. ',

   'List'
=> 'Liste',

   'Paste Selection to List'
=> 'Auswahl zur Liste hinzufügen',

   'Text Color'
=> 'Textfarbe',

   'Check out Exam?'
=> 'Prüfung auschecken?',

   'Check out Exam for Viewing'
=> 'Prüfung zum Betrachten auschecken',

   'As a resource gets checked out, a unique timestamped ID is given to it, and a permanent record is left in the system.'
=> 'Wenn eine Ressource ausgecheckt wird, wird an sie ein eindeutiger Zeitstempel vergeben und ein dauerhafter Eintrag verbleibt im System.',

   'Checking out resources is subject to course policies, and may exclude future credit even if done erroneously.'
=> 'Das Auschecken von Ressourcen ist Teil der Kursrichtlinien und könnte eine zukünftige Punktevergabe verhindern, selbst dann, wenn dies auf falsche Weise gemacht wird.',

   'The resource needs to be checked out'
=> 'Die Ressource muss ausgecheckt werden.',

   'Checked out for'
=> 'Ausgecheckt für',

   'Switch role, but display Main Menu page instead?'
=> 'Rolle wechseln und stattdessen Hauptmenü anzeigen?',

   'The role you selected is not permitted to view the current page.'
=> 'Die von Ihnen gewählte Rolle berechtigt nicht die aktuelle Seite zu betrachten.',

   'An error occurred while saving the spreadsheet. The error is: [_1].'
=> 'Beim Speichern des Beurteilungsbogens ist ein Fehler aufgetreten. Der Fehler ist: [_1].',

   'Requested user: "[_1]" does not exist; your own sheet is displayed instead.'
=> 'Der angeforderte Benutzer "[_1]" existiert nicht. Ihre eigene Tabelle wird stattdessen angezeigt.',

   'Spreadsheet saved as: [_1] .'
=> 'Beurteilungsbogen gespeichert als: [_1] .',

   'Your current role is not permitted to display this sheet for the requested user: "[_1]"; your own sheet is displayed instead.'
=> 'Ihre derzeitige Rolle berechtigt nicht zur Anzeige dieser Tabelle für den angeforderten Benutzer "[_1]". Ihre eigene Tabelle wird stattdessen angezeigt.',

   'There may be a problem with the filename, e.g., you may be attempting to edit a versioned file (files in construction may not include a version number in front of the extension).'
=> 'Es besteht ein Problem mit dem Dateinamen. Eventuell versuchen Sie eine versionierte Datei zu ändern (Dateien im Autorenbereich dürfen keine Versionsnummer vor der Dateinamenserweiterung haben).',

   'Send Messages'
=> 'Nachrichten senden',

   'New Message'
=> 'Neue Nachricht',

   'Send a message to users.'
=> 'Sendet eine Nachricht an Benutzer.',

   'New Broadcast Message'
=> 'Neue Broadcast-Nachricht',

   'Send a broadcast message to members of this Course and/or other users.'
=> 'Sendet eine Broadcast-Nachricht an Kursteilnehmer und/oder andere Benutzer.',

   'New Messages from File'
=> 'Neue Nachrichten aus Datei',

   'Create a message from file and send to users.'
=> 'Erstellt auf Basis einer Datei Nachrichten und sendet diese an Benutzer.',

   'Message Administration'
=> 'Nachrichtenverwaltung',

   'Message Log for Selected Users'
=> 'Nachrichtenprotokoll für bestimmte Benutzer',

   'User notes, records of face-to-face discussions, critical messages, broadcast messages and archived messages in Course.'
=> 'Benutzeranmerkungen, Aufzeichnungen von persönlichen Diskussionsbeiträgen, wichtige Nachrichten, Broadcast-Nachrichten und archivierte Nachrichten.',

   'Discussion and message records for [_1] ([_2])'
=> 'Aufzeichnungen von Diskussionen und Nachrichten für [_1] ([_2])',

   'Domain'
=> 'Domäne',

   'Domain:'
=> 'Domäne:',

   'Domain: [_1]'
=> 'Domäne: [_1]',

   'Server'
=> 'Server',

   'Server Load'
=> 'Serverlast',

   'User Load'
=> 'Nutzerlast',

   'Help'
=> 'Hilfe',

   'Log in'
=> 'Einloggen',

   'Log-in to LON-CAPA'
=> 'In LON-CAPA einloggen',

   'Username'
=> 'Benutzerkennung',

   'User name'
=> 'Benutzerkennung',

   'Password'
=> 'Passwort',

   'choose'
=> 'wähle',

   'enter'
=> 'eingeben',

   'view'
=> 'betrachten',

   'calendar'
=> 'Kalender',

   'role'
=> 'Rolle',

   'course'
=> 'Kurs',

   'Course'
=> 'Kurs',

   'Course: [_1]'
=> 'Kurs: [_1]',

   'Communities'
=> 'Communitys',

   'Community'
=> 'Community',

   'community'
=> 'Community',

   'Course/Community'
=> 'Kurs/Community',

   'course/community'
=> 'Kurs/Community',

   'Courses/Communities'
=> 'Kurse/Communitys',

   'Course/Community: [_1]'
=> 'Kurs/Community: [_1]',

   'Section/Group'
=> 'Sektion/Gruppe',

   'section/group'
=> 'Sektion/Gruppe',

   'Sections/groups'
=> 'Sektionen/Gruppen',

   'today'
=> 'heute',

   'last week'
=> 'letzte Woche',

   'last month'
=> 'letzten Monat',

   'last three months'
=> 'letzte drei Monate',

   'last six months'
=> 'letzte sechs Monate',

   'last year'
=> 'letztes Jahr',

   'Submit'
=> 'Abschicken',

   'Submit All'
=> 'Alle einreichen',

   'Rename'
=> 'Umbenennen',

   'Save'
=> 'Speichern',

   'Save All'
=> 'Alles speichern',

   'Done'
=> 'Fertig',

   'Select User'
=> 'Benutzer auswählen',

   'Select Course'
=> 'Kurs auswählen',

   'Select Courses'
=> 'Kurse auswählen',

   'Select Communities'
=> 'Communitys auswählen',

   'Select Community'
=> 'Community auswählen',

   'Select Course/Community'
=> 'Kurs/Community auswählen',

   're-initializing Course'
=> 'Kurs neu initialisieren',

   're-initializing Community'
=> 'Community neu initialisieren',

   'Uploaded Document'
=> 'Hochgeladenes Dokument',

   'No content modifications yet.'
=> 'Noch keine Inhaltsänderungen.',

   'Part is not open to be viewed. It'
=> 'Aufgabenteil nicht verfügbar. Er',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Aufgrund von Netzwerkproblemen kann nicht festgestellt werden, ob diese Ressource verfügbar ist. Bitte versuchen Sie es später noch einmal.',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Beachten Sie, dass es bis zu 10 Minuten dauern kann, bis Änderungen für alle Benutzer aktiv werden.',

   'Language'
=> 'Sprache',

   'Notes'
=> 'Notizen',

   'Abstract'
=> 'Kurzbeschreibung',

   'Create a user or modify the roles and privileges of a user'
# => 'Benutzeraccounts erstellen oder Benutzerrollen und -privilegien ändern',
=> 'Benutzeraccounts und Rechte verwalten',

   'View course assessment statistics'
=> 'Aufgabenstatistiken', # Main Menu, Grading and Statistics

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'Setzen von Deadlines und anderen Parametern zur Beurteilung sowie Ändern der Kursumgebung',

   'New Folder'
=> 'Neues Verzeichnis',

   'Simple Course Page'
=> 'Einfache Kursseite',

   'Simple Problem'
=> 'Einfache Aufgabe',

   'Upload Document'
=> 'Dokument hochladen',

   'Search'
=> 'Suchen',

   'Import'
=> 'Importieren',

   'Import?'
=> 'Importieren?',

   'Main Course Content'
=> 'Hauptkursinhalt',

   'Main Course Documents'
=> 'Haupt-Kursdokumente',

   'Main Community Documents'
=> 'Haupt-Community-Dokumente',

   'Supplemental Course Documents'
=> 'Zusätzliche Kursdokumente',

   'Supplemental Community Documents'
=> 'Zusätzliche Community-Dokumente',

   'Supplemental documents'
=> 'Zusätzliche Dokumente',

   'View supplemental course documents'
=> 'Zusätzliche Kursdokumente betrachten',

   'Main Content'
=> 'Hauptinhalt',

   'Main Content Editor'
=> 'Hauptinhalts-Editor',

   'Supplemental Content'
=> 'Zusätzlicher Inhalt',

   'Supplemental Content Editor'
=> 'Editor für zusätzlichen Inhalt',

   'Supplemental Course Content'
=> 'Zusätzlicher Kursinhalt',

   'Supplemental Course Contents'
=> 'Zusätzliche Kursinhalte',

   'Content Editor'
=> 'Inhaltseditor',

   'Discussion Board'
=> 'Diskussionsforum',

   'Published Resources'
=> 'Veröffentlichte Ressourcen',

   'Special Documents'
=> 'Spezielle Dokumente',

   'Special Document'
=> 'Spezielles Dokument',

   'Document'
=> 'Dokument',

   'Settings'
=> 'Einstellungen',

   'create'
=> 'erstelle',

   'grades'
=> 'Bewertungen',

   'Grades'
=> 'Bewertungen',

   'enroll'
=> 'Kurs belegen',

   'Table of Contents'
=> 'Inhaltsverzeichnis',

   'Announcements and Calendar'
=> 'Bekanntmachungen und Kalender',

   'Author'
=> 'Autor',

   'Change Your Preferences'
=> 'Ändern Ihrer Benutzerpräferenzen',

   'Choose the user role'
=> 'Benutzerrolle wechseln',

   'Co-Author'
=> 'Co-Autor',

   'co-author'
=> 'Co-Autor',

   'Co-Author [_1]'
=> 'Co-Autor [_1]',

   'Communication and Messages'
=> 'Kommunikation und Nachrichten',

   'Course Coordinator'
=> 'Kurs-Koordinator',

   'Coordinator'
=> 'Koordinator',

   'Course Statistics and Charts'
=> 'Kursstatistiken und Notenübersicht',

   'Compiling Excel spreadsheet for [quant,_1,student]...'
=> 'Erstelle Excel-Datei für [quant,_1,Studenten/in,Studierende]...',

   'Course announcements and my calendar'
#=> 'Kurs-Bekanntmachungen und mein Kalender',
=> 'Kurs-Bekanntmachungen und Kalender',

   'Course Announcements'
=> 'Kurs-Bekanntmachungen',

   'Community Announcements'
=> 'Community-Bekanntmachungen',

   'Create Users, Change User Privileges'
# => 'Erstellen neuer Benutzeraccounts, ändern von Benutzerprivilegien',
=> 'Benutzeraccounts und Rechte verwalten',

   'Domain Coordinator'
=> 'Domänen-Koordinator',

   'Enrollment Manager'
=> 'Kursbelegungs-Verwaltung',

   'Enter grades from check-out assessment resources'
=> 'Eingeben von Bewertungen für Beurteilungs-Ressourcen', #??? [SB 20.10.2006]

   'Exam Proctor'
=> 'Klausuraufsichtspersonal',

   'Grades Spreadsheet'
=> 'Beurteilungsbogen mit Bewertungen',

   'Grading'
=> 'Bewertung',

   'Instructor'
=> 'Dozent',

   'Main Menu'
=> 'Hauptmenü',

   'No Role, Cumulative Privileges'
=> 'Keine Rolle, kumulative Privilegien',

   'Return to Last Location'
=> 'Zurück zum zuletzt verwendeten Kursdokument',

   'Return to last location' # Helpdesk
=> 'Zurück zum letzten Ort',

   'Send and receive messages'
# => 'Verschicken und Empfangen von Nachrichten',
# => 'Interne Nachrichten verwalten',
=> 'Kommunikation und Nachrichten',

   'Send and display messages'
=> 'Kommunikation und Nachrichten',

   'Send message to [_1]'
=> 'Nachricht an [_1] senden',

   'Send message to student'
=> 'Nachricht an Student/in senden',

   'Send message to member'
=> 'Nachricht an Mitglied senden',

   'Message to student and add to user notes'
=> 'Nachricht an Student/in senden und zu Benutzeranmerkungen hinzufügen',

   'Message to member and add to user notes'
=> 'Nachricht an Mitglied senden und zu Benutzeranmerkungen hinzufügen',

   'Set my user preferences'
=> 'Benutzereinstellungen',

   'student'
=> 'Student/in',

   'Student'
=> 'Student/in',

   'Student: '
=> 'Student/in: ',

   'Switch to another user role'
# => 'Andere Benutzerrolle wählen',
=> 'Benutzerrolle wechseln',

   'Teaching Assistant'
=> 'Tutor',

   'Use or edit my bookmark collection'
# => 'Meine Lesezeichen-Sammlung verwenden oder editieren',
=> 'Lesezeichen-Sammlung',

   'User Roles'
=> 'Benutzerrollen',

   'Calculate course grades (Spreadsheet)'
=> 'Bewertungen berechnen (Beurteilungsbogen)',

   'Enter the chat room for the course'
=> 'Kurs-Chatroom',

   'Navigate the table of contents for this course'
=> 'Inhaltsverzeichnis des Kurses',

   'Syllabus'
=> 'Kursüberblick',

   'Course syllabus'
=> 'Kursüberblick',

   'Syllabus status'
=> 'Status des Kursüberblicks',

   'View the course assessment progress chart'
=> 'Aufgabenfortschritt des Kurses',

   'Class Hours'
=> 'Vorlesungstermine',

   'Course Title'
=> 'Kurstitel',

   'Course title'
=> 'Kurstitel',

   'Community Title'
=> 'Community-Titel',

   'Coursepack'
=> 'Kurspaket',

   'Current Month'
=> 'Dieser Monat',

   'Deadlines'
=> 'Fälligkeitsdaten',

   'Fri'
=> 'Fr',

   'Grading Information'
=> 'Informationen zur Bewertung',

   'Grade display settings'
=> 'Einstellungen der Bewertungsanzeige',

   'Helproom Hours'
=> 'Hilfe',

   'Instructor Information'
=> 'Information über den Dozenten',

   'Mon'
=> 'Mo',

   'Next Month'
=> 'Nächster Monat',

   'Office Hours'
=> 'Sprechstunden',

   'Prerequisites'
=> 'Voraussetzungen',

   'Previous Month'
=> 'Vorheriger Monat',

   'Readings'
=> 'Material',

   'Sat'
=> 'Sa',

   'January'
=> 'Januar',

   'February'
=> 'Februar',

   'March'
=> 'März',

   'April'
=> 'April',

   'May'
=> 'Mai',

   'June'
=> 'Juni',

   'August'
=> 'August',

   'September'
=> 'September',

   'October'
=> 'Oktober',

   'November'
=> 'November',

   'December'
=> 'Dezember',

   'Sun'
=> 'So',

   'Textbook'
=> 'Lehrbuch',

   'textbook'
=> 'Lehrbuch',

   'Textbook course'
=> 'Lehrbuch-Kurs',

   'Textbook courses'
=> 'Lehrbuch-Kurse',

   'Thu'
=> 'Do',

   'Tue'
=> 'Di',

   'Web Links'
=> 'Weblinks',

   'Wed'
=> 'Mi',

   'Drop/Add students in this course'
=> 'Kursbelegungen verwalten',

   'A score has been assigned.'
=> 'Bewertung wurde zugewiesen', # inputtags.pm, grading feedback

   'Some parts were not submitted.'
=> 'Einige Aufgabenteile sind nicht bearbeitet worden.',

   'Due [_1]'
=> 'Fällig am [_1]',

   'Due'
=> 'Fällig',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'Die Endung der von Ihnen eingereichten Datei ist nicht zulässig.',

   'Units incorrect.'
=> 'Einheit inkorrekt.',

   'Only a number required.'
=> 'Als Eingabe ist nur eine Zahl zulässig.',

   'Units required'
=> 'Einheiten erwartet',

   'Tries'
=> 'Versuche',

   '[_1]Tries[_2] [_3]'
=> '[_1]Versuche[_2] [_3]',

   '[_1]Previous Tries[_2] [_3]'
=> '[_1]Bisherige Versuche[_2] [_3]',

   'Tries [_1]'
=> 'Versuche [_1]',

   'Submit Answer'
=> 'Antwort einreichen',

   'Prepare a printable document'
=> 'Drucken', # long version: 'Druckbares Dokument erstellen',

   'Go To My First Homework Problem'
=> 'Zur ersten Aufgabe gehen',

   'Show Me My First Homework Problem'
=> 'Erste Aufgabe anzeigen',

   'Cancel'
=> 'Abbrechen',

   'Discussions'
=> 'Diskussionen',

   'New discussion since'
=> 'Neue Diskussion seit',

   'New message (click to open)'
=> 'Neue Nachricht (zum Anzeigen klicken)',

   'Close all folders'
=> 'Alle Verzeichnisse schließen',

   'Open all folders'
=> 'Alle Verzeichnisse öffnen',

   'Goodbye'
=> 'Auf Wiedersehen',

   'Select'
=> 'Auswählen',

   'Re-Initialize'
=> 'Neu initialisieren',

   'Re-Select'
=> 'Neu initialisieren',

   'You may need to [_1]re-select[_2] the course.'
=> 'Sie müssen den Kurs [_1]neu initialisieren[_2].',

   'Currently selected.'
=> 'Derzeit ausgewählt.',

   'Switch Server'
=> 'Server wechseln',

   'Switch server?'
=> 'Server wechseln?',

   'system wide'
=> 'netzwerkweit', # 'systemweit'

   'Currently not available'
=> 'Derzeit nicht verfügbar',

   'No role specified'
=> 'Keine bestimmte Rolle',

   'Remark'
=> 'Bemerkung',

   'Extent'
=> 'Bereich',

   'extent'
=> 'Bereich',

   'Current Privileges'
=> 'Derzeitige Berechtigungen',

   'User Role'
=> 'Benutzerrolle',

   'User role'
=> 'Benutzerrolle',

   'Start'
=> 'Anfang',

   'End'
=> 'Ende',

   'System'
=> 'System',

   'Display'
=> 'Anzeigen',

   'Display:'
=> 'Anzeigen:',

   'Do not display'
=> 'Nicht anzeigen',

   "an unknown date"
=> ': unbekannter Zeitpunkt', # ! -> lonhomework.pm

   "an indeterminate date"
=> ': unbestimmter Zeitpunkt', # ! -> lonhomework.pm

   'will open on [_1]'
=> 'wird am [_1] verfügbar sein',

   'is due at [_1]'
=> 'ist am [_1] fällig',

   'was due on [_1], and answers will be available on [_2]'
=> 'war am [_1] fällig und Antworten werden am [_2] verfügbar sein',

   'is closed but you are allowed to view it'
=> "ist geschlossen, kann aber von Ihnen betrachtet werden",

   "Undid changes, Switched [_1] and [_2]"
=> "Änderungen rückgängig gemacht. [_1] und [_2] wurden ausgetauscht.",

   "Unable to undo, unable to switch [_1] and [_2]"
=> "Änderungen konnten nicht rückgängig gemacht werden. [_1] und [_2] konnten nicht ausgetauscht werden.",

   "Unable to make backup [_1]"
=> "Konnte keine Sicherungsdatei in [_1] erstellen!",

   "Saving Modifications to [_1]"
=> "Änderungen werden in [_1] gespeichert",

   "Unable to write to [_1]"
=> "Konnte Änderungen nicht in [_1] speichern!",

   "Analyzing a problem"
=> "Analysiere Aufgabe",

   "EditXML"
=> "XML-Editor",

   'Discard Edits and View'
=> 'Änderungen verwerfen und betrachten',

   'Submit Changes'
=> 'Speichern und weiterbearbeiten', # 'Änderungen speichern',

   'Submit Changes and View'
=> 'Speichern und betrachten',

   'Edit'
=> 'Editor',

   '[_1]Edit[_2]'
=> '[_1]Editor[_2]',

   'Exit Editing'
=> 'Editor verlassen',

   ', select a template from the pull-down menu below'
=> 'wählen Sie eine Vorlage aus dem unterstehenden Auswahlmenü',

   'Undo'
=> 'Rückgängig machen',

   'undo'
=> 'Rückgängig machen',

   'Answer'
=> 'Antwort',

   'Frequency'
=> 'Häufigkeit',

   'You did not select a template.'
=> 'Sie haben keine Vorlage ausgewählt.',

   'Analyze Progress'
=> 'Fortschritt analysieren',

   'Getting Problem Variants'
=> 'Berechne Aufgabenvariationen',

   'last problem'
=> 'letzte Aufgabe',

   "may open later."
=> 'könnte zu einem späteren Zeitpunkt verfügbar werden.',

   "Select a"
=> "Wählen Sie",

   'Part'
=> 'Aufgabenteil',

   'Part [_1]'
=> 'Aufgabenteil [_1]',

   'Then'
=> 'Dann',

   'is in under construction'
=> 'ist in Arbeit',

   'List of possible answers'
=> 'Liste möglicher Antworten',

   'Response [_1] is not analyzable at this time.'
=> 'Antwort [_1] ist derzeit nicht analysierbar.',

   'Title'
=> 'Titel',

   'Path'
=> 'Pfad',

   'New Search'
=> 'Neue Suche',

   'Go Back'
=> 'Zurück',

   'Go back'
=> 'Zurück',

   'File'
=> 'Datei',

   'File:'
=> 'Datei:',

   'File: [_1]'
=> 'Datei: [_1]',

   'Date'
=> 'Datum',

   'You have no unread messages'
=> 'Sie haben keine ungelesenen Nachrichten',

   'New Messages'
=> 'Neue Nachrichten',

   'All Messages'
=> 'Alle Nachrichten',

   'Map'
=> 'Inhaltszusammenstellung',

   'Page'
=> 'Seite',

   'Page:'
=> 'Seite:',

   'Sequence'
=> 'Sequenz',

   'Map contents are not shown in order.'
=> 'Inhaltszusammenstellungs-Inhalte werden nicht sortiert angezeigt.',

   'Empty'
=> 'Leer',

   'Currently empty'
=> 'Derzeit leer',

   'File [_1] could not be copied.'
=> 'Die Datei [_1] konnte nicht kopiert werden.',

   'Back to Directory'
=> 'Zurück zum Verzeichnis',

   'No upload file specified.'
=> 'Es wurde keine Datei zum Hochladen angegeben.',

   'The target is an existing directory.'
=> 'Die Zieldatei ist ein existierendes Verzeichnis.',

   'Please use browser "Back" button and pick a filename'
=> 'Bitte benutzen Sie "Zurück" in Ihrem Webbrowser und geben Sie einen Dateinamen an',

   "You do not have authoring privileges for this resource"
=> "Sie haben für diese Ressource keine Berechtigung mit Autorenzugriff!",

   'Copying file'
=> 'Kopiere Datei',

   'No write permission to user directory, FAIL'
=> 'Keine Schreibberechtigung für dieses Verzeichnis. Abbruch!',

   'Actions'
=> 'Aktionen',

   'Folder Actions'
=> 'Verzeichnis-Aktionen',

   'Message Actions'
=> 'Nachrichten-Aktionen',

   'Name'
=> 'Name',

   'Status'
=> 'Status',

   'Last Modified'
=> 'Letzte Änderung',

   'Yes'
=> 'Ja',

   'Authoring Space Directory'
=> 'Autorenbereich-Verzeichnis',

   'Contact [_1] for access.'
=> 'Kontaktieren Sie [_1], um Zugriff zu erhalten.',

   'Please log into [_1] to edit.'
=> 'Bitte melden Sie sich in der Domäne [_1] an, um Zugriff zu erhalten.',

   'Save uploaded file as [_1]'
=> 'Hochgeladene Datei speichern unter [_1]',

   'Searching'
=> 'Suche',

   'Searching ...'
=> 'Suche...',

   'Owner:Domain'
=> 'Eigentümer:Domäne',

   'Owner/Co-owner(s)'
=> '(Co-)Eigentümer',

   'Owner & Co-owner(s)'
=> 'Eigentümer & Co-Eigentümer',

   'Course Co-owners'
=> 'Kurs-Co-Eigentümer',

   'Select the Authoring Space'
=> 'Auswahl des Autorenbereichs',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'Es wird grundsätzlich empfohlen, einen aktuellen Virenscanner zu benutzen, bevor Sie diese Datei verwenden.',

   'Like all files provided by users, this file may contain viruses!'
=> 'Diese Datei kann, so wie alle Dateien, die von Benutzern stammen, Viren enthalten!',

   'Like all files provided by users, these files may contain viruses!'
=> 'Diese Dateien können, so wie alle Dateien, die von Benutzern stammen, Viren enthalten!',

   'not displayed'
=> 'nicht angezeigt',

   "Open, no due date"
=> "Verfügbar, kein Fälligkeitsdatum",

   "Uncompleted Homework"
=> "Unerledigte Übungsaufgaben",

   "Show Only Uncompleted Homework"
=> "Zeige nur unerledigte Übungsaufgaben",

   "All homework is currently completed."
=> "Derzeit sind alle Übungsaufgaben erledigt.",

   'This course is empty.'
=> 'Dieser Kurs ist leer.',

   'This directory is empty.'
=> 'Dieses Verzeichnis ist leer.',

   'Coursemap undefined.'
=> 'Inhaltszusammenstellung des Kurses ist nicht definiert.',

   "Was due [_1]"
=> "War fällig am [_1]",

   "Answer available"
=> "Antwort verfügbar",

   "Excused by instructor"
=> "Vom Dozenten erlassen",

   "Answer submitted, not yet graded"
=> "Antwort eingereicht, noch nicht bewertet",

   "No due date"
=> "Kein Fälligkeitsdatum",

   'never'
=> 'niemals',

   'Answer submitted'
=> 'Antwort eingereicht',

   '[_1] of [quant,_2,try,tries] used'
=> '[_1] von [quant,_2,Versuch,Versuchen] verbraucht',

   'Processing'
=> 'Wird verarbeitet',

   'Access and Usage Statistics'
=> 'Zugriffs- und Nutzungsstatistiken',

   'Evaluation Comments'
=> 'Evaluierungskommentare',

   'Evaluation Data'
=> 'Evaluierungsdaten',

   'July'
=> 'Juli',

   'Server Administration'
=> 'Serververwaltung',

   'System Administration'
=> 'Systemverwaltung',

   'Users with Roles Assigned by'
=> 'Benutzer, deren Rollen vergeben wurden von',

   'Name starting with'
=> 'Name beginnt mit',

   'This resource has been marked obsolete by the author(s)'
=> 'Dieses Ressource wurde vom Autor bzw. von den Autoren als veraltet gekennzeichnet',

   'Uploaded'
=> 'Hochgeladen',

   'Uploaded [_1]'
=> '[_1] wurde hochgeladen',

   'Dynamic Metadata'
=> 'Dynamische Metadaten',

   'View file'
=> 'Datei betrachten',

   'Illegal filename.'
=> 'Ungültiger Dateiname.',

   'Rule'
=> 'Regel',

   'Back to Source Directory'
=> 'Zurück zum Quellverzeichnis',

   'Back to Source'
=> 'Zurück zur Quelldatei',

   'Back to Resource'
=> 'Zurück zur Ressource',

   'File copied.'
=> 'Datei kopiert.',

   'FAIL'
=> 'Abbruch',

   'Fail'
=> 'Abbruch',

   'Back to [_1]'
=> 'Zurück zur Ressource [_1]',

   'untitled'
=> 'kein Titel',

   'The extension on this file, [_1], is reserved internally by LON-CAPA.'
=> 'Die Dateiendung [_1] ist LON-CAPA-intern reserviert.',

   'The extension on this file is reserved internally by LON-CAPA.'
=> 'Die Dateiendung ist LON-CAPA-intern reserviert.',

   'The extension on this file, [_1], is not recognized by LON-CAPA.'
=> 'Die Dateiendung [_1] ist LON-CAPA unbekannt.',

   'The extension on this file is not recognized by LON-CAPA.'
=> 'Die Dateiendung [_1] ist LON-CAPA unbekannt.',

   'Please change the extension.'
=> 'Bitte ändern Sie die Dateiendung.',

   'Became this version on ...'
=> 'Wurde diese Version am...',

   'Browse published resources'
# => 'Veröffentlichte Dokumente betrachten',
=> 'Veröffentlichte Ressourcen',

   'Browse own authored/co-authored published resources'
=> 'Veröffentlichte Ressourcen (eigener Autoren-Bereich/Co-Autoren-Bereich(e))',

   'Browse own authored or co-authored resources'
=> 'Veröffentlichte Ressourcen (eigener Autoren-Bereich/Co-Autoren-Bereich(e))',

   'Choose the course to work on'
=> 'Wählen Sie den Kurs, in dem Sie arbeiten wollen',

   'Create a new course'
=> 'Kurse erstellen',

   'Customized right of use ...'
=> 'Maßgeschneiderte Zugriffsrechte...',

   'Delete messages from discussion boards'
=> 'Löschen von Nachrichten aus Diskussionsforen',

   'Domain only - use limited to courses in the domain'
=> 'Beschränkt auf Domäne - Nutzung begrenzt auf Kurse innerhalb dieser Domäne',

   'Edit and view documents included in this course'
=> 'Kursinhalt einrichten', # old: 'Kurs-Ressourcen bearbeiten'

   'Edit course contents'
=> 'Kursinhalt einrichten',

   'Edit community contents '
=> 'Community-Inhalt einrichten ',

   'Enter my Authoring Space'
# => 'Autorenbereich aufrufen',
=> 'Mein Autorenbereich',

   'Failed to copy source'
=> 'Konnte Quelldatei nicht kopieren',

   'Failed to write metadata copy'
=> 'Konnte Metadaten nicht kopieren',

   'Finalize Publication'
=> 'Veröffentlichung abschließen',

   'Grant/revoke role of Co-Author'
=> 'Vergebe/entziehe Co-Autorenrollen',

   'Grant/revoke role of Assistant Co-Author'
=> 'Vergebe/entziehe Autor-Assistent-Rollen',

   'Grant/revoke role of Domain Coordinator'
=> 'Vergebe/entziehe Domänen-Koordinator-Rolle',

   'Grant/revoke role of Exam Proctor'
=> 'Vergebe/entziehe Rolle des Klausuraufsichtspersonals',

   'Grant/revoke role of Instructor'
=> 'Vergebe/entziehe Rolle des Dozenten',

   'Grant/revoke role of Student'
=> 'Vergebe/entziehe Rolle von Studierenden',

   'Grant/revoke role of Superuser'
=> 'Vergebe/entziehe Rolle des Superusers',

   'Grant/revoke role of Administrator'
=> 'Vergebe/entziehe Rolle des Administrators',

   'Grant/revoke role of Author'
=> 'Vergebe/entziehe Rolle des Autors',

   'Grant/revoke role of Course Coordinator'
=> 'Vergebe/entziehe Rolle des Kurs-Koordinators',

   'Grant/revoke role of Domain Guest'
=> 'Vergebe/entziehe Rolle des Domänengasts',

   'Grant/revoke role of Librarian'
=> 'Vergebe/entziehe Rolle des Bibliothekars',

   'Grant/revoke role of Teaching Assistant'
=> 'Vergebe/entziehe Rolle des Tutors',

   'Grant/revoke role of Bubblesheet Scanning Operator'
=> 'Vergebe/entziehe Rolle des Bubblesheetscanner-Mitarbeiters',

   'Grant/revoke role of Member'
=> 'Vergebe/entziehe Rolle des Teilnehmers',

   'No previous versions published.'
=> 'Es wurden keine vorhergehenden Versionen veröffentlicht.',

   'No write permission to'
=> 'Keine Schreibberechtigung für',

   'Please pick a version to retrieve:'
=> 'Bitte wählen Sie eine Version aus, die Sie wiederherstellen möchten:',

   'Private - visible to author only for testing purposes'
=> 'Privat - für den Autor nur zu Testzwecken sichtbar',

#   'Private Publication - did not synchronize database'
#=> 'Private Veröffentlichung - nicht mit Datenbank synchronisiert',

   'Public - no authentication or authorization required for use'
=> 'Öffentlich - keine LON-CAPA-Anmeldung zur Nutzung notwendig',

   'Retrieval of an old version will overwrite the file currently in Authoring Space.'
=> 'Das Wiederherstellen einer alten Version überschreibt die derzeit im Autorenbereich vorhandene Datei.',

   'Retrieve selected Version'
=> 'Ausgewählte Version wiederherstellen',

   'Retrieve previous version'
=> 'Vorherige Version wiederherstellen',

   'Retrieve previous versions of [_1]'
=> 'Wiederherstellen vorheriger Versionen von [_1]',

   'Search the contents of this course'
=> 'Kursinhalts-Suche',

   'Search the database of published resources and accessible portfolio files'
=> 'Datenbank veröffentlichter Ressourcen und Portfolio-Dateien',

   'Send broadcast and receipt-required message'
=> 'Sende Broadcast-Nachricht mit Empfangsbestätigung',

   'Show Problem Completeness'
=> 'Zeige Aufgabenvollständigkeit',

   'Switch to another course'
=> 'Zu einem anderen Kurs wechseln',

   'System wide - can be used for any courses system wide'
# => 'Systemweit - kann für alle Kurse systemweit verwendet werden',
=> 'Netzwerkweit - kann für alle Kurse im gesamten LON-CAPA-Netzwerk verwendet werden',

   'The extension on this file'
=> 'Die Endung dieser Datei',

   'Unsupported character combination [_1] in filename, FAIL.'
=> 'Ungültige Zeichenkombination [_1] im Dateinamen. Abbruch!',

   'No valid extension found in filename, FAIL'
=> 'Ungültige Dateinamen-Erweiterung. Abbruch!',

   'Filename of resource contains internal version number. Cannot publish such resources, FAIL'
=> 'Der Dateiname der Ressource enthält eine intern verwendete Versionsnummer und kann daher nicht veröffentlicht werden. Abbruch!',

   'No valid custom distribution rights file specified, FAIL'
=> 'Keine gültige Datei für maßgeschneiderte Zugriffsrechte angegeben. Abbruch!',

   'Could not write metadata, FAIL'
=> 'Metadaten konnten nicht geschrieben werden. Abbruch!',

   'View documents included in this course'
=> 'Zusätzliche Kursdokumente',

   'Additional Keywords'
=> 'Zusätzliche Schlüsselwörter',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'Zusätzliche Metadaten (nicht standardisiert, Parameter, Exporte)',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'Autoren- und Co-Autoren-Rollen könnten auf anderen Servern als Ihrem Heimatserver nicht verfügbar sein.',

   'Author(s)'
=> 'Autor(en)',

   'Average number of tries till solved'
=> 'Durchschnittliche Anzahl an Versuchen bis zur erfolgreichen Lösung',

   'Browse Resources'
=> 'Ressourcen durchsuchen',

   'Collapse Remote Control'
=> 'Fernbedienung deaktivieren',

   'Browse resources'
=> 'Ressourcen durchsuchen',

   'Browse'
=> 'Durchsuchen',

   'Authoring Space'
=> 'Autorenbereich',

   'Copied metadata'
=> 'Metadaten wurden kopiert',

   'Copied source file'
=> 'Quelldatei wurde kopiert',

   'Copyright/Distribution'
=> 'Copyright/Zugriffsrechte',

   'Copyright/Distribution:'
=> 'Copyright/Zugriffsrechte:',

   'Course Documents'
=> 'Kursdokumente',

   'Community Documents'
=> 'Community-Dokumente',

   'Creation Date'
=> 'Erstellungsdatum',

   'Custom Distribution File'
=> 'Datei für spezielle Zugriffsrechte',

   'Degree of difficulty'
=> 'Schwierigkeitsgrad',

   'Copy Course Content'
=> 'Kursinhalt kopieren',

   'Copy Course Content to Authoring Space'
=> 'Kursinhalt in Autorenbereich kopieren',

   'Copy Community Content to Authoring Space'
=> 'Community-Inhalt in Autorenbereich kopieren',

   'Choose the uploaded course items and templated pages/problems to be copied to Authoring Space.'
=> 'Wählen Sie die hochgeladenen Kurselemente und Vorlagenseiten/-aufgaben aus, die in den Autorenbereich kopiert werden sollen.',

   'Content to copy'
=> 'Inhalt, der kopiert werden soll',

   'Copy?'
=> 'Kopieren?',

   'Copying content to Authoring Space requires switching server.'
=> 'Zum Kopieren in den Autorenbereich müssen Sie den Server wechseln.',

   'Copying Content to Authoring Space'
=> 'Inhalt in Autorenbereich kopieren',

   'An item selected has no filename set in the "Save as ..." column.'
=> 'Für ein gewähltes Element wurde in der "Speichern unter..."-Spalte kein Dateiname angegeben.',

   'Items selected for copying need unique filenames in the "Save as ..." column.'
=> 'Die zum Kopieren ausgewählten Elemente müssen in der "Speichern unter..."-Spalte einen eindeutigen Dateinamen haben.',

   'An Authoring Space needs to be selected.'
=> 'Ein Autorenbereich muss ausgewählt werden.',

   'Entering course ...'
=> 'Betrete Kurs...',

   'Exam Information'
=> 'Prüfungsinformationen',

   'External Resource'
=> 'Externe Ressource',

   'Generate new role ...'
=> 'Erstelle neue Rolle...',

   'Go to the next resource in the course sequence'
=> 'Weiter', # long version: 'Gehe zur nächsten Ressource in der Kurssequenz',

   'Go to the previous resource in the course sequence'
=> 'Zurück', # long version: 'Gehe zur vorhergehenden Ressource in der Kurssequenz',

   'Import a published document'
=> 'Importieren einer veröffentlichten Ressource',

   'Keyword(s)'
=> 'Schlüsselwörter',

   'Logged Out'
=> 'Abgemeldet',

   'MIME Type'
=> 'MIME-Typ',

   'Make notes and annotations about this resource'
=> 'Notizen', # long version: 'Notizen zu dieser Ressource erstellen',

   'The material is covered with sufficient depth'
=> 'Das Thema wird in ausreichender Tiefe behandelt',

   'Metadata Information'
=> 'Metadaten-Informationen',

   'My Personal Information Page'
=> 'Meine persönliche Seite',

   'Network-wide number of accesses (hits)'
=> 'Netzwerkweite Anzahl von Zugriffen ("Hits")',

   'Network-wide number of courses using resource'
=> 'Netzwerkweite Anzahl von Kursen, die diese Ressource verwenden',

   'Number of resources that follow this resource in maps'
=> 'Anzahl der Ressourcen, die in Inhaltszusammenstellungen Nachfolger dieser Ressource sind',

   'Number of resources that lead up to this resource in maps'
=> 'Anzahl der Ressourcen, die in Inhaltszusammenstellungen Vorgänger dieser Ressource sind',

   'Number of resources using or importing resource'
=> 'Anzahl der Ressourcen, die diese Ressource verwenden oder importieren',

   'Obsolete'
=> 'Veraltet',

   'Parent Directory'
=> 'Übergeordnetes Verzeichnis',

   'Project Information'
=> 'Projektinformation',

   'Publisher/Owner'
=> 'Herausgeber/Besitzer',

   'Publisher:'
=> 'Herausgeber:',

   'Publishing'
=> 'Veröffentlichung:',

   'Publishing [_1]'
=> 'Veröffentlichung: [_1]',

   'Resource Details'
=> 'Details über Ressource',

   'Link to Resource'
=> 'Link zur Ressource',

   'Searching for your resource will be based on the following metadata. Please provide as much data as possible.'
=> 'Suche nach Ihrer Ressource wird auf den folgenden Metadaten beruhen. Bitte machen Sie so viele Angaben wie möglich.',

   'Resource Publication'
=> 'Veröffentlichung von Ressourcen',

   'Resource is technically correct'
=> 'Die Ressource ist technisch in Ordnung',

   'Score Upload Form'
=> 'Formular zum Hochladen von Bewertungen',

   'Select Map'
=> 'Inhaltszusammenstellung wählen',

   'Load Map'
=> 'Hochladen', # 'Lade Inhaltszusammenstellung',

   'Set a bookmark for this resource'
=> 'Lesezeichen setzen', # long version: 'Lesezeichen auf diese Ressource setzen',

   'Show all roles'
=> 'alle Rollen anzeigen',

   'Special documents'
=> 'Spezielle Dokumente',

   'Subject'
=> 'Thema',

   'Successful Login'
=> 'Erfolgreich angemeldet',

   'Suggested Replacement for Obsolete File'
=> 'Ersatzvorschlag für veraltete Datei',

   'Switching Role'
=> 'Wechseln der Benutzerrolle',

   'Target'
=> 'Ziel',

   'This syllabus can be publicly viewed at [_1]'
=> 'Dieser Kursüberblick kann öffentlich abgerufen werden: [_1]',

   'Instead of using this template you can specify an external URL as Syllabus in the [_1]Course Configuration[_2].'
=> 'Anstatt diese Vorlage zu verwenden, können Sie in der [_1]Kurskonfiguration[_2] eine externe URL als Kursüberblick angeben.',

   'Total number of students who have worked on this problem'
=> 'Gesamtanzahl an Studierenden, die diese Aufgabe bearbeitet haben',

   'URLs To Include in Syllabus'
=> 'URLs, die in den Kursüberblick eingefügt werden sollen',

   'User'
=> 'Benutzer',

   'User: [_1]'
=> 'Benutzer: [_1]',

   'Wrote Metadata'
=> 'Metadaten wurden geschrieben',

   'Your home server is '
=> 'Ihr Heimatserver ist ',

   'announce'
=> 'ankündigen',

   'bookmark'
=> 'Lesezeichen',

   'chart'
=> 'Chart',

   'chat'
=> 'Chat',

   'close this window'
=> 'dieses Fenster schließen',

   'docs'
=> 'Dokus',

   'exit'
=> 'abmelden',

   'library'
=> 'Bibliothek',

   'log in again'
=> 'erneut einloggen',

   'my'
=> 'mein',

   'or'
=> 'oder',

   'Or'
=> 'oder',

   'prepare'
=> 'Vorbereiten',

   'printout'
=> 'Ausdruck',

   'resource'
=> 'Ressource',

   'roles'
=> 'Rollen',

   'search'
=> 'suche',

   'set'
=> 'setze',

   'space'
=> 'Bereich',

   'stats'
=> 'Statistiken',

   'struct'
=> 'Struktur',

   'switch'
=> 'wechsle',

   'updated periodically'
=> 'regelmäßig aktualisiert',

   'user'
=> 'Benutzer',

   'visible to author and co-authors only'
=> 'nur für Autoren und Co-Autoren sichtbar',

   'All versions'
=> 'Alle Versionen',

   'Default Metadata for Directory [_1]'
=> 'Voreingestellte Metadaten für das Verzeichnis [_1]',

   'Error Messages'
=> 'Fehlermeldungen',

   'Update Display'
=> 'Neu anzeigen',

   'Content changed'
=> 'Inhalt geändert',

   'Differences'
=> 'Unterschiede',

   'Last Week'
=> 'letzte Woche',

   'Modification Date'
=> 'Änderungsdatum',

   'Since Start of Course'
=> 'seit Anfang des Kurses',

   'Since Yesterday'
=> 'seit gestern',

   'Verify Course Documents'
=> 'Kursdokumente überprüfen',

   'Verify Course Content'
=> 'Kursinhalt überprüfen',

   'Verify Community Documents'
=> 'Community-Dokumente überprüfen',

   'Verify Community Content'
=> 'Community-Inhalt überprüfen',

   'Version'
=> 'Version',

   'Version: [_1]'
=> 'Version: [_1]',

   'access denied'
=> 'Zugriff verweigert',

   'Access Denied ([_1])'
=> 'Zugriff verweigert ([_1])',

   'Access denied to [_1]'
=> 'Zugriff auf [_1] verweigert',

   'connection down'
=> 'Verbindung unterbrochen',

   'during the last'
=> 'während der letzten',

   'during the last week'
=> 'während der letzten Woche',

   'during the last month'
=> 'während des letzten Monats',

   'not found'
=> 'nicht gefunden',

   'warning(s)'
=> 'Warnung(en)',

   '[quant,_1,warning]'
=> '[quant,_1,Warnung,Warnungen]',

   'Advanced Catalog Search'
=> 'Erweiterte Katalog-Suche',

   'Advanced Search'
=> 'Erweiterte Suche',

   'Any Language'
=> 'Beliebige Sprache',

   'Any category'
=> 'Beliebige Kategorie',

   'Any copyright/distribution'
=> 'Beliebiges Copyright/Zugriffsrecht',

   'Broadcast Message to Course'
=> 'Broadcast-Nachricht senden', # 'Broadcast-Nachricht an gesamten Kurs senden',

   "Click to download or use your browser's Save Link function"
=> "Zum Speichern hier klicken oder 'Ziel speichern unter'-Funktion des Webbrowsers verwenden",

   'Close'
=> 'Schließen',

   'Compact View'
=> 'Kompaktansicht',

   'Detailed Citation View'
=> 'Detaillierte Zitatansicht',

   'Distribute Messages from Uploaded File to Course'
=> 'Aus Datei Nachrichten erstellen', # 'Verteile Nachrichten der hochgeladenen Datei an den Kurs',

   'Edit Metadata'
=> 'Metadaten bearbeiten',

   'Edit Content of a Map'
=> 'Inhalt der Inhaltszusammenstellung bearbeiten',

   'Edit Directory Metadata'
=> 'Metadaten des Verzeichnisses bearbeiten',

   'Evaluate Resource'
=> 'Ressource evaluieren',

   'Evaluate'
=> 'Evaluieren',

   'Failed Access to Authoring Space'
=> 'Zugriff auf Autorenbereich fehlgeschlagen',

   'Fielded Format'
=> 'In Felder aufgeteiltes Format',

   'File Category'
=> 'Dateikategorie',

   'Force publication of unmodified files'
=> 'veröffentliche auch ungeänderte Dateien',

   'Keywords'
=> 'Schlüsselwörter',

   'Last access'
=> 'Letzter Zugriff',

   'Last modified'
=> 'Letzte Änderungen',

   'Limit by copyright/distribution'
=> 'Durch Copyright/Zugriffsrechte einschränken',

   'Limit by language'
=> 'Durch Sprache einschränken',

   'Open'
=> 'Öffnen',

   'Is Open'
=> 'Ist geöffnet',

   'Open [_1]'
=> 'Öffnet am [_1]',

   'Per Page'
=> 'Pro Seite',

   'Printing Helper'
=> 'Hilfsprogramm zum Drucken',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Feedback, Kursdiskussion', # long version: 'Feedback geben oder an der Kursdiskussion zu dieser Ressource teilnehmen',

   'Provide my evaluation of this resource'
=> 'Ressource evaluieren', # long version: 'Diese Ressource evaluieren',

   'Publish'
=> 'Veröffentlichen',

   'Publish Directory'
=> 'Verzeichnis veröffentlichen',

   'Publish Directory and Sub Directories'
=> 'Veröffentliche Verzeichnis und Unterverzeichnisse',

   'Related'
=> 'Verwandte',

   'Resource Feedback and Discussion'
=> 'Feedback und Diskussion zu dieser Ressource',

   'Search Complete'
=> 'Suche beendet',

   'Show Metadata'
=> 'Metadaten', # long version: 'Metadaten anzeigen',

   'Show resource'
=> 'Ressource zeigen',

   'Statistics'
=> 'Statistiken',

   'Summary View'
=> 'Zusammenfassung',

   'There are currently no results.'
=> 'Derzeit noch keine Ergebnisse.',

   'Search: '
=> 'Suche: ',

   'URL'
=> 'URL',

   'Unpublished'
=> 'unveröffentlicht',

   'Up'
=> 'Hoch',

   'View'
=> 'Betrachten',

   '[_1]View[_2]'
=> '[_1]Betrachten[_2]',

   'View:'
=> 'Betrachten:',

   'Display Critical Messages'
=> 'Wichtige Nachrichten ansehen',

   'Words'
=> 'Wörter',

   'XML/SGML'
=> 'XML/SGML',

   'abstract'
=> 'Kurzbeschreibung',

   'audio'
=> 'Audio',

   'author'
=> 'Autor',

   'catalog'
=> 'katalog',

   'copyright'
=> 'Copyright',

   'directory'
=> 'Verzeichnis',

   'info'
=> 'Info',

   'Info'
=> 'Info',

   'keywords'
=> 'Schlüsselwörter',

   'language'
=> 'Sprache',

   'movies'
=> 'Filme',

   'notes'
=> 'Notizen',

   'obsolete'
=> 'veraltet',

   'pages'
=> 'Seiten',

   'pictures'
=> 'Bilder',

   'problem'
=> 'Aufgabe',

   'resources'
=> 'Ressourcen',

   'sequence'
=> 'Sequenz',

   'subject'
=> 'Thema',

   'this'
=> 'Diese',

   'title'
=> 'Titel',

   'Group Discussion Boards'
=> 'Gruppen-Diskussionsforen',

   'Group Discussion Board'
=> 'Gruppen-Diskussionsforum',

   'Course Discussion Board'
=> 'Kurs-Diskussionsforum',

   'Community Discussion Board'
=> 'Community-Diskussionsforum',

   'No group defined, so there are no group discussion boards to display'
=> 'Es gibt keine Gruppen, daher gibt es auch keine Gruppen-Diskussionsforen, die angezeigt werden könnten.',

   'You do not have privileges to view discussion boards in this group'
=> 'Sie sind nicht berechtigt, Diskussionsforen in dieser Gruppe zu betrachten.',

   'Clear All'
=> 'Lösche alle',

   'Close All Folders'
=> 'Schließe alle Verzeichnisse',

   'Authoring Space File Operation'
=> 'Dateiverarbeitung im Autorenbereich',

   'File Operation'
=> 'Dateiverarbeitung',

   'Contact Information'
=> 'Kontaktdaten',

   'Copied old metadata'
=> 'Alte Metadaten kopiert',

   'Failed to write old metadata copy'
=> 'Kopie der alten Metadaten konnte nicht geschrieben werden',

   'Copied old target file'
=> 'Alte Zieldatei wurde kopiert',

   'Failed to copy old target'
=> 'Alte Zieldatei konnte nicht kopiert werden',

   'Created directory [_1]'
=> 'Verzeichnis wurde angelegt: [_1]',

   'Copyright'
=> 'Copyright',

   'Could Not Process Request'
=> 'Befehl konnte nicht ausgeführt werden',

   'Default'
=> 'Voreinstellung',

   'Defaults'
=> 'Voreinstellungen',

   'Set Defaults'
=> 'Setze Voreinstellungen',

   'Discard Selected'
=> 'Verwerfe ausgewählte',

   'Edit this resource'
=> 'Bearbeiten', # long version: 'Bearbeite diese Ressource',

   'Enter Authoring Space as co-author'
=> 'Autorenbereich (als Co-Autor)',

   'Enter Authoring Space as a co-author'
=> 'Autorenbereich (als Co-Autor)',

   'Enter Authoring Space as assistant co-author'
=> 'Autorenbereich (als Autor-Assistent)',

   'Host'
=> 'Rechner',

   'Last updated'
=> 'Zuletzt aktualisiert',

   'Mime type'
=> 'MIME-Typ',

   'Modified'
=> 'geändert',

   'Modify deadlines, etc, for this assessment resource'
=> 'Bearbeite Fälligkeitsdaten, etc. für diese Beurteilungs-Ressource',

   'Modify user grades for this assessment resource'
=> 'Manuelle Bewertung', # 'Bearbeite die Noten des Benutzers für diese Beurteilungs-Ressource',

   'View user submissions for this assessment resource'
=> 'Einreichungen betrachten', # 'Betrachte Benutzer-Einreichungen für diese Beurteilungs-Ressource',

   'Move Down'
=> 'Nach unten',

   'Move Up'
=> 'Nach oben',

   'New Title'
=> 'Neuer Titel',

   'Open All Folders'
=> 'Öffne alle Verzeichnisse',

   'Owner/Publisher'
=> 'Besitzer/Herausgeber',

   'Personal Information Page - [_1]'
=> 'Persönliche Seite - [_1]',

   'Go to personal information page for [_1]'
=> 'Persönliche Seite von [_1]',

   'Viewable files - [_1]'
=> 'Einsehbare Dateien - [_1]',

   'Viewable files'
=> 'Einsehbare Dateien',

   'Viewable portfolio files for [_1]'
=> 'Einsehbare Portfolio-Dateien von [_1]',

   'Personal Information Page'
=> 'Persönliche Seite',

   'Personal Information'
=> 'Persönliche Informationen',

   'Personal web page'
=> 'Persönliche Webseite',

   'Privacy Note:'
=> 'Hinweis zur Privatsphäre:',

   'Published'
=> 'veröffentlicht',

   'Reading results from'
=> 'Lese Ergebnisse von',

   'Retrieve'
=> 'Wiederherstellen',

   'Revert to Last Saved'
=> 'Gehe zur letzten gespeicherten Version',

   'Revision Date'
=> 'Änderungsdatum',

   'Shared by course faculty and staff'
=> 'Gemeinsam für Kursverwaltung und Personal',

   'Synchronized SQL metadata database'
=> 'SQL Metadaten-Datenbank synchronisiert',

   'Task'
=> 'Aufgabe',

   'Temporary Assembly Workspace'
=> 'Temporärer Arbeitsbereich',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'Die Daten, die Sie hier bereitstellen, können von jeder Person, die in LON-CAPA angemeldet ist, eingesehen werden. Geben Sie daher keine Daten an, die Sie hier nicht öffentlich machen wollen.',

   'Topic'
=> 'Thema',

   'Upload a Photo'
=> 'Foto hochladen',

   'User Notes, Face-to-Face, Critical Messages, Broadcast Messages, Archived Messages'
=> 'Benutzeranmerkungen, persönliche Diskussionsbeiträge, wichtige Nachrichten, Broadcast-Nachrichten, Archivierte Nachrichten',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'Benutzeranmerkungen, Aufzeichnungen von persönlichen Diskussionsbeiträgen und wichtige Nachrichten',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'Benutzeranmerkungen, Aufzeichnungen von persönlichen Diskussionsbeiträgen und wichtige Nachrichten in dem Kurs',

   'User Notes, Records of Face-To-Face Discussions, Critical Messages, Broadcast Messages and Archived Messages in Course'
=> 'Benutzeranmerkungen, Aufzeichnungen von persönlichen Diskussionsbeiträgen, wichtige Nachrichten, Broadcast-Nachrichten und archivierte Nachrichten in dem Kurs',

   'User Notes, Records of Face-To-Face Discussions, Critical Messages, Broadcast Messages and Archived Messages in Community'
=> 'Benutzeranmerkungen, Aufzeichnungen von persönlichen Diskussionsbeiträgen, wichtige Nachrichten, Broadcast-Nachrichten und archivierte Nachrichten in der Community',

   'No notes, face-to-face discussion records, critical messages or broadcast messages in this course.'
=> 'Für diesen Kurs existieren keine Benutzer-Anmerkungen, Aufzeichnungen von persönlichen Diskussionsbeiträgen, wichtige Nachrichten oder Broadcast-Nachrichten.',

   'No notes, face-to-face discussion records, critical messages or broadcast messages in this community.'
=> 'Für diese Community existieren keine Benutzer-Anmerkungen, Aufzeichnungen von persönlichen Diskussionsbeiträgen, wichtige Nachrichten oder Broadcast-Nachrichten.',

   'Version Number'
=> 'Versionsnummer',

   'View Published Version'
=> 'Veröffentlichte Version betrachten',

   'Web References'
=> 'Webreferenzen',

   'contacting'
=> 'kontaktiere',

   'edit'
=> 'Bearbeite',

   'interface available'
=> 'Oberflächensprache verfügbar',

   'missions'
=> 'Aufgaben',

   'waiting on'
=> 'warte auf',

   'P#'
=> 'P#', # ?

   '#Stdnts'
=> 'Anzahl Stud.',

   'Number of Students Attempting Problem'
=> 'Anzahl Studierender, die die Aufgabe versucht haben',

   'Total Number of Tries'
=> 'Gesamtanzahl an Versuchen',

   '#YES'
=> 'Anz. KORR.',

   'Number of Students able to Solve'
=> 'Anzahl Studierender, die loesen konnten', # gnuplot! Umlaute?!?

   '#yes'
=> 'Anz. korr.',

   'Number of Students given Override'
=> 'Anzahl Studierender, fuer die ueberschrieben wurde', # ?

   '%Wrng'
=> '%Falsch',

   'Percent of students whose final answer is wrong'
=> 'Prozent Studierender, deren endgueltige Antwort falsch ist', # gnuplot! Umlaute?!?

   '#Items'
=> 'Anz. El.',

   'Number of Items in Sequence'
=> 'Anzahl Elemente in Sequenz',

   'Score Mean'
=> 'Pkt.-Durchschn.',

   'Count Mean'
=> 'Anz. Durchschn.',

   'Mean Sequence Score'
=> 'Durchschnittliche Punkte der Sequenz',

   'Score STD'
=> 'Std.-Abw. Pkt.',

   'Count STD'
=> 'Anz. Std.-Abw.',

   'Standard Deviation of Sequence Scores'
=> 'Standardabweichung der Punkte in der Sequenz',

   'Score Max'
=> 'Max. Pkt.',

   'Maximum Sequence Score'
=> 'Maximale Punkte in der Sequenz',

   'Score Min'
=> 'Min. Pkt.',

   'Minimum Sequence Score'
=> 'Minimale Punkte in der Sequenz',

   'Score N'
=> 'Anz. St. Pkt.-Berech.',

   'Count N'
=> 'Anz. Stud.',

   'Number of Students in score computations'
=> 'Anzahl Studierender in Punkteberechnungen',

   'Count Max'
=> 'Max. Anz. korr.',

   'Maximum Number of Correct Problems'
=> 'Maximale Anzahl korrekter Aufgaben',

   'Count Min'
=> 'Min. Anz. korr.',

   'Minimum Number of Correct Problems'
=> 'Minimale Anzahl korrekter Aufgaben',

   'KR-21'
=> 'KR-21',

   'KR-21 reliability statistic'
=> 'KR-21-Reliabilitäts-Statistik',

   'Brief view of each students performance in course.'
=> 'Kurze Übersicht der Leistungen eines jeden Studierenden im Kurs.',

   'Clear Caches'
=> 'Cache löschen',

   'Course Statistics and Charts cannot be retrieved until the database is restarted. Your data is intact but cannot be displayed at this time.'
=> 'Kurs-Statistiken und -Diagramme können solange nicht abgerufen werden, bis die Datenbank neu gestartet wurde. Ihre Daten sind vorhanden, können aber zu diesem Zeitpunkt nicht angezeigt werden.',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Ausführliche Statistiken und Graphen der studentischen Leistung hinsichtlich der Aufgaben',

   'DoDiff'
=> 'Schw.-Grad',

   'Degree of Difficulty ~[ 1 - ((#YES+#yes) / Tries) ~]'
=> 'Schwierigkeitsgrad ~[ 1 - ((Anz. KORR. + Anz. korr.) / Anz. Vers.) ~]',

   'Enrollment Status'
=> 'Kursbelegungs-Status',

   'Generate Statistics'
=> 'Statistiken erstellen',

   'Max Tries'
=> 'Max. Anz. Vers.',

   'Mean Tries'
=> 'Durchschn. Anz. Vers.',

   'Output'
=> 'Ausgabe',

   'Overall Problem Statistics'
=> 'Insgesamte Aufgabenstatistik',

   'Please notify the server administrator [_1]'
=> 'Benachrichtigen Sie bitte den Server-Administrator [_1]',

   'Preparing Excel Spreadsheet'
=> 'Erstelle Excel-Datei',

   'Preparing Excel spreadsheet of student responses'
=> 'Erstelle Excel-Datei mit studentischen Antworten',

   'Preparing Excel spreadsheet of student responses to [_1] problems'
=> 'Erstelle Excel-Datei mit studentischen Antworten von [_1] Aufgaben',

   'Problem Status Chart'
=> 'Aufgabenstatus-Diagramm',

   'S.D. tries'
=> 'Std.-Abw. d. Vers.', # Standardabweichung der Versuche

   'Standard Deviation of Number of Tries'
=> 'Standardabweichung der Anzahl an Versuchen',

   'Sections'
=> 'Sektionen',

   'sections'
=> 'Sektionen',

   'Sequence or Folder'
=> 'Sequenz oder Verzeichnis',

   'Sequences and Folders'
=> 'Sequenzen und Verzeichnisse',

   'Skew Tries'
=> 'Schiefe d. Vers.',

   'Skew of Number of Tries'
=> 'Schiefe der Anzahl an Versuchen',

   'Statistics and Problem Analysis'
=> 'Statistiken und Aufgabenanalysen',

   'Student performance statistics on all problems.'
=> 'Statistik studentischer Leistungen hinsichtlich aller Aufgaben',

   'Unable to connect to database!'
=> 'Verbindungsaufbau zur Datenbank nicht möglich!',

   'Unable to connect to the MySQL database where your results are saved.'
=> 'Verbindungsaufbau zur MySQL-Datenbank, wo Ihre Ergebnisse gespeichert sind, nicht möglich',

   'Your Excel Spreadsheet'
=> 'Ihre Excel-Datei',

   'Your Excel spreadsheet.'
=> 'Ihre Excel-Datei',

   'Your Excel spreadsheet'
=> 'Ihre Excel-Datei',

   'Your CSV file.'
=> 'Ihre CSV-Datei',

   'Your CSV file'
=> 'Ihre CSV-Datei',

   'Your CSV spreadsheet.'
=> 'Ihre CSV-Tabelle',

   'part'
=> 'Aufgabenteil',

   'part - '
=> 'Teil ',

   'problem statistics grouped by sequence'
=> 'Aufgabenstatistiken, gruppiert nach Sequenz',

   'problem statistics ungrouped'
=> 'Aufgabenstatistiken, nicht gruppiert',

   'problem statistics, Excel'
=> 'Aufgabenstatistiken, Excel',

   'Significant figures are incorrect, submission was not graded.'
=> 'Die Anzahl der signifikanten Stellen ist inkorrekt. Dieser Versuch wurde nicht gezählt.',

   '. . . for a particular section'
=> '. . . für eine bestimmte Sektion',

   '. . . for all students in the course'
=> '. . . für alle Studierenden im Kurs',

   '. . . for an individual student'
=> '. . . für einen bestimmten Studierenden',

   '. . . for a particular group'
=> '. . . für eine bestimmte Gruppe',

   '12 am' # midnight
=> '0',

   'midnight'
=> 'Mitternacht',

   '1 am'
=> '1',

   '2 am'
=> '2',

   '3 am'
=> '3',

   '4 am'
=> '4',

   '5 am'
=> '5',

   '6 am'
=> '6',

   '7 am'
=> '7',

   '8 am'
=> '8',

   '9 am'
=> '9',

   '10 am'
=> '10',

   '11 am'
=> '11',

   '12 noon'
=> '12',

   'noon'
=> 'Mittag',

   '1 pm'
=> '13',

   '2 pm'
=> '14',

   '3 pm'
=> '15',

   '4 pm'
=> '16',

   '5 pm'
=> '17',

   '6 pm'
=> '18',

   '7 pm'
=> '19',

   '8 pm'
=> '20',

   '9 pm'
=> '21',

   '10 pm'
=> '22',

   '11 pm'
=> '23',

   'ALL'
=> 'ALLE',

   'All Maps or Folders'
=> 'Alle Inhaltszusammenstellungen oder Verzeichnisse',

   'Any User'
=> 'Jeder Benutzer',

   'Assessment URL and Title'
=> 'Beurteilungs-URL und -Titel',

   'Assigned User Roles'
=> 'Zugewiesene Benutzerrollen',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Es kann bis zu 10 Minuten dauern, bis diese Änderungen für alle Studierenden aktiviert worden sind.',

   'Course Environment Parameters'
=> 'Kursumgebungsparameter',

   'Course Parameter Helper'
=> 'Kursparameter-Hilfsprogramm',

   'Create New Environment Variable'
=> 'Neue Umgebungsvariable erstellen',

   'Current Session Value'
=> 'Wert für diese Sitzung',

   'Default Value'
=> 'Voreingestellter Wert',

   'Delete a role'
=> 'Rolle löschen',

   'Disable all communication among students'
=> 'Unterbinden jeglicher Kommunikation zwischen Studierenden',

   'Enclosing Map or Folder'
=> 'Umschließende/s Inhaltszusammenstellung oder Verzeichnis',

   'Every problem in a particular folder'
=> 'Jede Aufgabe in einem bestimmten Verzeichnis',

   'Every problem in the course'
=> 'Jede Aufgabe im Kurs',

   'Folder'
=> 'Verzeichnis',

   'folder'
=> 'Verzeichnis',

   'Folder:'
=> 'Verzeichnis:',

   'Folder: [_1]'
=> 'Verzeichnis: [_1]',

   'Create a Course Custom Role'
=> 'Benutzerdefinierte Kursrolle erstellen',

   'Grant/revoke Course Custom Role'
=> 'Vergebe/entziehe benutzerdefinierte Kursrolle',

   'Internally authenticated'
=> 'Intern authentifiziert',

   'Kerberos authenticated'
=> 'Kerberos-authentifiziert',

   'LON-CAPA Helper:'
=> 'LON-CAPA-Hilfsprogramm:',

   'Lock and unlock assessments'
=> 'Sperren und Entsperren von Beurteilungen',

   'Manage Access Keys'
=> 'Zugriffsschlüssel verwalten',

   'Manage access keys'
=> 'Zugriffsschlüssel verwalten',

   'Max Possible To Date'
=> 'Bis jetzt maximal erreichbar',

   'Modify Course Assessment Parameters'
=> 'Bearbeite Parameter für die Kursbeurteilung',

   'Modify authentication mechanism and data for a user'
=> 'Bearbeite Authentifizierungs-Methode und Daten für einen Benutzer',

   'Modify grades'
=> 'Bewertungen ändern',

   'One particular problem'
=> 'Eine bestimmte Aufgabe',

   'Parameter Name'
=> 'Parametername',

   'Parameter Type'
=> 'Parametertyp',

   'Parameter in Effect'
=> 'Effektiver Parameter',

   'Please select a problem to analyze'
=> 'Wählen Sie die zu analysierende Aufgabe',

   'Post anonymously'
=> 'Anonym absenden',

   'Post discussion on course resources'
=> 'Diskussion zu den Ressourcen des Kurses absenden',

   'Post discussion on community resources'
=> 'Diskussion zu den Ressourcen der Community absenden',

   'Post system frontpage announcements'
=> 'Bekanntmachungen auf der Hauptseite des Systems absenden',

   'Post to chat rooms'
=> 'In die Chatrooms senden',

   'Problems Not Contained In A Folder'
=> 'Aufgaben, die sich nicht in einem Unterverzeichnis befinden',

   'Section'
=> 'Sektion',

   'Section:'
=> 'Sektion:',

   'Section: [_1]'
=> 'Sektion: [_1]',

   'Section and Credits'
=> 'Sektion und Credits',

   'Select Date'
=> 'Datum auswählen',

   'Select Enclosing Map or Folder'
=> 'Umschließende/s Inhaltszusammenstellung oder Verzeichnis auswählen',

   'Select Parameter Level'
=> 'Parameter-Ebene',

   'Send internal message'
=> 'Verschicke interne Nachrichten',

   'Set Course Environment Parameters'
=> 'Setze Kursumgebungs-Parameter',

   'Set Date'
=> 'Setze Datum',

   'Set Defaults for All Resources in [_1]Specifically for [_2][_3]'
=> 'Setze voreingestellte Werte für alle Ressourcen im [_1]speziell für [_2][_3]',

   'Set Defaults for All Resources in Course'
=> 'Setze voreingestellte Werte für alle Ressourcen im Kurs',

   'Set a due date'
=> 'Setze Fälligkeitsdatum',

#   'Set a <b>due date</b>'
#=> 'Setze <b>Fälligkeitsdatum</b>',

   'Set an answer open date'
=> 'Setze Antwort-Verfügbarkeits-Datum',

#   'Set an <b>answer open date</b>'
#=> 'Setze <b>Antwort-Verfügbarkeits-Datum</b>',

   'Set an open date'
=> 'Setze ein Bearbeitungsbeginn-Datum',

#   'Set an <b>open date</b>'
#=> 'Setze ein <b>Bearbeitungsbeginn-Datum</b>',

   'Set opening datefor all problems in the course for. . .'
=> 'Setze Öffnungsdatum für alle Aufgaben im Kurs auf. . .',

   'Set the number of tries'
=> 'Setze Anzahl von Versuchen',

#   'Set the <b>number of tries</b>'
#=> 'Setze <b>Anzahl von Versuchen</b>',

   'Set the problem weight'
=> 'Setze Aufgabengewichtung',

#   'Set the <b>problem weight</b>'
#=> 'Setze <b>Aufgabengewicht</b>',

   'Set/Modify Course Assessment Parameter'
=> 'Setze/Ändere Parameter zur Kursbeurteilung',

   'Set/Modify Course Assessment Parameters'
=> 'Setze/Ändere Parameter zur Kursbeurteilung',

   'Set/Modify Course Parameters'
=> 'Setze/Ändere Kursparameter',

   'Show More Options'
=> 'Zeige mehr Optionen',

   'Students Affected'
=> 'Betroffene Studierende',

   'This helper will assist you in setting the open, due, and answer dates for problems, setting the problem weights, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'Dieses Hilfsprogramm wird Ihnen dabei helfen, das Datum für den Bearbeitungsbeginn, die Fälligkeit und die Antwort-Verfügbarkeit für Aufgaben zu setzen und die Aufgabengewichtung sowie die Anzahl der Versuche für Aufgaben festzulegen. Sie werden gefragt, für welche Aufgaben Sie die Parameter zu setzen wünschen, dann, welche Parameter Sie setzen möchten. Schließlich wählen Sie aus, wen diese Einstellungen betreffen. Nach Abschluss dieser Hilfeunterstützung wird Ihnen gezeigt, wo Sie in dem erweiterten Interface die Parameter setzen können, die Sie ausgewählt haben, damit Sie dies in Zukunft direkt erledigen können. Klicken Sie auf Weiter -&gt; um zu beginnen oder wählen Sie &lt;- Zurück, um zur vorherigen Seite zurückzukehren.',

   'Total'
=> 'Gesamt',

   'Total Parts In Course'
=> 'Gesamtanzahl an Aufgabenteilen im Kurs',

   'Total Parts Done In Course'
=> 'Gesamtanzahl an erledigten Aufgabenteilen im Kurs',

   'Total Points In Course'
=> 'Gesamtanzahl an Punkten im Kurs',

   'Type'
=> 'Typ',

   'Type: [_1]'
=> 'Typ: [_1]',

   'UNIX authenticated'
=> 'UNIX-authentifiziert',

   'USERS'
=> 'BENUTZER',

   'Unknown ID'
=> 'Unbekannte ID',

   'Unknown user'
=> 'Unbekannter Benutzer',

   'Update Course Assessment Parameter Display'
=> 'Aktualisiere die Anzeige der Parameter zur Kursbeurteilung',

   'Update Section or Specific User'
=> 'Aktualisiere Sektion oder bestimmten Benutzer',

   'Verify Selection'
=> 'Auswahl überprüfen',

   'Welcome to the Assignment Parameter Helper'
=> 'Willkommen zum Hilfsprogramm für Übungs-Parameter',

   'What parameter do you want to set for all problems in the course?'
=> 'Welche Parameter möchten Sie für alle Aufgaben in dem Kurs setzen?',

   'What should the opening date be set to?'
=> 'Auf wann soll das Öffnungsdatum gesetzt werden?',

   'Which Problem or Problems?'
=> 'Welche Aufgabe oder Aufgaben?',

   'Which problems do you wish to set a parameter for?'
=> 'Für welche Aufgaben möchten Sie die Parameter setzen?',

   'You need to choose another user role or enter a specific course or community for this function.'
=> 'Für die angeforderte Seite müssen Sie eine andere Benutzerrolle wählen oder einen bestimmten Kurs bzw. eine bestimmte Community betreten.',

   'a.m.'
=> 'vorm.',

   'acc keys'
=> 'Zugr.-Schlüssel',

   'according to course preferences'
=> 'nach den Kurs-Einstellungen',

   'according to resource settings'
=> 'nach den Ressourceneinstellungen',

   'according to user session state'
=> 'nach dem Status der Benutzersitzung',

   'all'
=> 'alle',

   'at'
=> 'in',

   'at Domain'
=> 'in Domäne',

   'at domain'
=> 'in Domäne',

   'default'
=> 'voreingestellt',

   'for Enclosing Map or Folder'
=> 'für umschließende/s Inhaltszusammenstellung oder Verzeichnis',

   'for Resource'
=> 'für Ressource',

   'from Enclosing Map or Folder'
=> 'aus umschließender/m Inhaltszusammenstellung oder Verzeichnis',

   'general'
=> 'generell',

   'in Course'
=> 'in Kurs',

   'in Section/Group'
=> 'in Sektion/Gruppe',

   'manage'
=> 'verwalte',

   'of'
=> 'von',

   'or ID'
=> 'oder ID',

   'p.m.'
=> 'nachm.',

   'percent'
=> 'Prozent',

   'unless locked'
=> 'falls nicht gesperrt',

   'users in'
=> 'Benutzer in',

   'Access Key Management'
=> 'Zugriffsschlüssel-Verwaltung',

   'Assessment'
=> 'Beurteilung',

   'Calculations'
=> 'Berechnungen',

   'Comma Separated Values'
=> 'CSV (durch Kommata bzw. Semikola getrennte Liste)',

   'Course ID'
=> 'Kurs-ID',

   'Community ID'
=> 'Community-ID',

   'course ID'
=> 'Kurs-ID',

   'Course level sheet'
=> 'Kurs-Level-Bogen', # ??? [SB 2007-07-02], studentcalc.pm

   'Student level sheet'
=> 'Studierenden-Level-Bogen', # ??? [SB 2009-09-09], assesscalc.pm

   'Detailed Problem Analysis'
=> 'Detaillierte Aufgabenanalyse',

   'End Helper'
=> 'Hilfsprogramm beenden',

   'Excel'
=> 'Excel',

   'Text (essays only)'
=> 'Text (nur bei Essays)',

   'Finish Course Initialization'
=> 'Kursinitialisierung beenden',

   'Generate Spreadsheet'
=> 'Beurteilungsbogen erstellen',

   'HTML'
=> 'HTML',

   'RTF'
=> 'RTF',

   'Invalid date entry'
=> 'Ungültiger Datumseintrag',

   'Load:'
=> 'Lade:',

   'No changes were made to the current settings.'
=> 'An den derzeitigen Einstellungen wurden keine Änderungen vorgenommen.',

   'No changes were made to current settings.'
=> 'An den derzeitigen Einstellungen wurden keine Änderungen vorgenommen.',

   'Output Format'
=> 'Ausgabeformat',

   'Processing first student'
=> 'Verarbeite erste/n Studenten/in',

   'Row'
=> 'Reihe',

   'Save as'
=> 'Speichern unter',

   'Save as &amp; Make This Sheet the Default'
=> 'Speichern unter und diesen Beurteilungsbogen als Voreinstellung verwenden',

   'Bubblesheet Scanning Operator'
=> 'Bubblesheet-Scanner-Mitarbeiter',

   'Select All'
=> 'Alle auswählen',

   'Select All Students'
=> 'Wähle alle Studierenden',

   'Select Spreadsheet File'
=> 'Beurteilungsbogen-Datei auswählen',

   'Send bubblesheet data to a course'
=> 'Bubblesheet-Daten an einen Kurs senden',

   'Spreadsheet Computation'
=> 'Beurteilungsbogen berechnen',

   'Spreadsheet Computation Status'
=> 'Status der Beurteilungsbogen-Berechnungen',

   'Summary'
=> 'Zusammenfassung',

   'Template'
=> 'Vorlage',

   'Available templates'
=> 'Verfügbare Vorlagen',

   'Unselect All'
=> 'Auswahl komplett aufheben', # 'Alle deselektieren',

   'Unselect All Students'
=> 'Alle Studierenden deselektieren',

   'Upload bubblesheet data'
=> 'Bubblesheet-Daten hochladen',

   'Upload Bubblesheet Data'
=> 'Bubblesheet-Daten hochladen',

   'You must choose at least one student to continue.'
=> 'Zum Fortfahren müssen Sie mindestens einen Studierenden auswählen.',

   'You must choose one or more choices to continue.'
=> 'Zum Fortfahren müssen Sie mindestens eine oder mehrere Auswahlen treffen.',

   'may be open from a different computer.'
=> 'könnte von einem anderen Computer aus geöffnet sein.',

   'days'
=> 'Tage',

   'Days'
=> 'Tage',

   'Hours'
=> 'Stunden',

   'hours'
=> 'Stunden',

   'minutes'
=> 'Minuten',

   'Minutes'
=> 'Minuten',

   'remaining'
=> 'übrig',

   'second'
=> 'Sekunde',

   'seconds'
=> 'Sekunden',

   'Seconds'
=> 'Sekunden',

   'seconds for'
=> 'Sekunden für',

   'Additional Recipients'
=> 'Weitere Empfänger',

   'Analyze Over [_1] [_2]'
=> 'Analysieren: [_1] [_2]',

   'Analyze Problem'
=> 'Aufgabe analysieren',

   'Analyze Problem Again'
=> 'Aufgabe erneut analysieren',

   'Analyze as '
=> 'Analysiere als ',

   'Browsing resource, all submissions are temporary.'
=> 'Eingereichte Antworten werden nicht gespeichert.',

   'By'
=> 'Von',

   'Check All'
=> 'Alle auswählen',

   'Check all'
=> 'Alle auswählen',

   'Check for All'
=> 'Überprüfe für alle',

   'Check for None'
=> 'Überprüfe für nichts',

   'Check for Section/Group'
=> 'Überprüfe für Sektion/Gruppe',

   'Choose a different resource'
=> 'Eine andere Ressource auswählen',

   'Concepts'
=> 'Konzepte',

   'Critical Messages'
=> 'Wichtige Nachrichten',

   'Delete'
=> 'Löschen',

   'Undo Delete'
=> 'Löschen rückgängig machen',

   'Delete Checked'
=> 'Auswahl löschen',

   'Display All Messages'
=> 'Alle Nachrichten anzeigen',

   'Foils'
=> 'Auswahlmöglichkeiten',

   'Forward'
=> 'Weiterleiten',

   'Forwarded message from'
=> 'Weitergeleitete Nachricht von',

   'Forwarding'
=> 'Weiterleitung',

   'From'
=> 'Von',

   'Functions'
=> 'Funktionen',

   'Mail'
=> 'Nachricht',

   'Mark Unread'
=> 'Als ungelesen kennzeichnen',

   'New Problem Variation'
=> 'Neue Aufgabenvariation',

   'New Problem Variation Each Try'
=> 'Nach jedem Versuch neue Aufgabenvariation',

   'New Question Variation After Every [quant,_1,Try,Tries]'
=> 'Alle [quant,_1,Versuche,Versuche] neue Aufgabenvariation',

   'New Question Variation For Each Try'
=> 'Nach jedem Versuch neue Variation der Aufgabe',

   'New Randomization'
=> 'Neue Variation',

   'Next'
=> 'Weiter',

   'Number of Plots [_1]'
=> 'Anzahl Graphen: [_1]',

   'Option Response Problem Analysis'
=> 'Analyse von Optionsauswahl-Aufgabe',

   'Re'
=> 'Antw.',

   'Record'
=> 'Eintrag',

   'Reply'
=> 'Antworten',

   'Reset Submissions'
=> 'Einreichungen zurücksetzen',

   'Select a course'
=> 'Kurs auswählen',

   'Selecting a User'
=> 'Benutzer auswählen',

   'Send New'
=> 'Sende neue',

   'Send Reply'
=> 'Sende Antwort',

   'Send as critical message'
=> 'Als wichtige Nachricht senden',

   'Simple Problem Editor'
=> 'Einfacher Aufgabeneditor',

   'Starting'
=> 'Starte',

   'Student Data Compilation Progress'
=> 'Kompilierungsfortschritt der studentischen Daten',

   'Student Data Compilation Status'
=> 'Kompilierungsstatus der studentischen Daten',

   'There is no student data for this problem.'
=> 'Für diese Aufgabe existieren keine studentischen Daten.',

   'Time'
=> 'Zeit',

   'To'
=> 'An',

   'Uncheck All'
=> 'Gesamte Auswahl aufheben',

   'Uncheck all'
=> 'Gesamte Auswahl aufheben',

   'Unsuccessful Login'
=> 'Login fehlgeschlagen',

   'Update Student Data'
=> 'Aktualisiere Studierendendaten',

   'You have no critical messages.'
=> 'Sie haben keine wichtigen Nachrichten.',

   'and return receipt'
=> 'mit Empfangsbestätigung',

   'can not be accessed from your location.'
=> 'kann von Ihrer Position aus nicht aufgerufen werden.',

   'Unacceptable username [_1] for user [_2] [_3] [_4] [_5]'
=> 'Unzulässige Benutzerkennung [_1] für den Benutzer [_2] [_3] [_4] [_5]',

   'Unacceptable domain [_1] for user [_2] [_3] [_4] [_5]'
=> 'Unzulässige Domäne [_1] für Benutzer [_2] [_3] [_4] [_5]',

   'usernames may not contain spaces.'
=> 'Benutzerkennungen dürfen keine Leerzeichen enthalten.',

   '[_1]: The user does not exist, and you are not permitted to create users of type: [_2].'
=> '[_1]: Der Benutzer existiert nicht und Sie sind nicht berechtigt, Benutzer vom Typ [_2] anzulegen.',

   'All Documents in Course'
=> 'Alle Dokumente im Kurs',

   'All Documents in Community'
=> 'Alle Dokumente in der Community',

   'All Resources (possibly large output)'
=> 'Alle Ressourcen (möglicherweise lange Ausgabe)',

   'Anonymous'
=> 'Anonym',

   'Anonymous contribution to course discussion of resource'
=> 'Anonyme Teilnahme an der Kursdiskussion über diese Ressource',

   'Anonymous contribution to community discussion of resource'
=> 'Anonyme Teilnahme an der Community-Diskussion über diese Ressource',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'Generell sollten nur Autoren und Co-Autoren über das Dateisystem authentifiziert sein (erlaubt Zugriff auf das Server-Dateisystem).',

   'Associate columns with student attributes.'
=> 'Verknüpfung der Spalten aus der Datei mit den studentischen Eigenschaftsfeldern',

   'Attribute'
=> 'Eigenschaft',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (durch Kommata bzw. Semikola getrennte Liste, Tabelle)',

   'Check Course Document Versions'
=> 'Versionen der Kursdokumente überprüfen',

   'Check Community Document Versions'
=> 'Versionen der Community-Dokumente überprüfen',

   'Check/Set Resource Versions'
=> 'Ressourcen-Versionen verwalten',

   'Check Course Resource Versions'
=> 'Ressourcen-Versionen im Kurs verwalten',

   'View version information for resources in your course, and fix/unfix use of specific versions'
=> 'Betrachten von Versionsinformationen für Ressourcen in Ihrem Kurs und festsetzen/lösen der Verwendung bestimmter Versionen',

   'Chronological View'
=> 'Chronologische Sicht',

   'Other Views ...'
=> 'Andere Sichten...',

   'Column'
=> 'Spalte',

   'Column [_1]'
=> 'Spalte [_1]',

   'Continue enrollment?'
=> 'Trotzdem mit der Kursbelegung fortfahren?',

   'Contribution to course discussion of resource'
=> 'Normale Teilnahme an der Kursdiskussion über die Ressource',

   'Contribution to community discussion of resource'
=> 'Normale Teilnahme an der Community-Diskussion über die Ressource',

   'Diffs'
=> 'Unterschiede',

   'Disable ID/Student Number Safeguard and Force Change '
=> 'Studierenden-/Mitarbeiter-ID-Safeguard deaktivieren und Änderung erzwingen ',

   'Force change of existing ID' # 'Disable Student/Employee ID Safeguard and force change of conflicting IDs'
=> 'Änderung bestehender ID erzwingen', # 'Studierenden-/Mitarbeiter-ID-Safeguard deaktivieren und Änderung von in Konflikt stehenden IDs erzwingen.',

   'Disable Student/Employee ID Safeguard and force change of conflicting IDs'
=> 'Studierenden-/Mitarbeiter-ID-Safeguard deaktivieren und Änderung von in Konflikt stehenden IDs erzwingen',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'Studierenden-/Mitarbeiter-ID-Safeguard deaktivieren und Änderung von in Konflikt stehenden IDs erzwingen (Machen Sie dies nur, wenn Sie wirklich wissen, was Sie tun.)',

   '(only do if you know what you are doing.)'
=> '(Machen Sie dies nur, wenn Sie wirklich wissen, was Sie tun.)',

   'Discussion Contributions'
=> 'Diskussionsbeiträge',

   'Drop Students'
=> 'Studierende ausschließen',

   'Dropped [_1]'
=> '[_1] ausgeschlossen',

   'Dropped [quant,_1,student].'
=> '[quant,_1,Student/in,Studierende] ausgeschlossen.',

   'Dropping Students'
=> 'Schließe Studierende aus',

   'Dump Course Documents'
=> 'Kursdokumente übernehmen',

   'Dump Community Documents'
=> 'Community-Dokumente übernehmen',

   'Dump Course Content'
=> 'Kursinhalt übernehmen',

   'Dump Community Content'
=> 'Community-Inhalt übernehmen',

   'Enroll a single student'
=> 'Einzelnen Studierenden Kurs belegen lassen',

   'Enrolling Students'
=> 'Studierende werden in den Kurs aufgenommen',

   'Error'
=> 'Fehler',

   'Error: '
=> 'Fehler: ',

   'Error:'
=> 'Fehler:',

   'Error: [_1]'
=> 'Fehler: [_1]',

   'Error: [_1].'
=> 'Fehler: [_1]',

   'Errors'
=> 'Fehler',

   'Field'
=> 'Feld',

   'Filenames in Authoring Space'
=> 'Dateinamen im Autorenbereich',

   'Folder in Authoring Space'
=> 'Verzeichnis im Autorenbereich',

   'Full Update'
=> 'Vollständige Aktualisierung',

   'Full update (also print list of users not enrolled anymore)'
=> 'Vollständige Aktualisierung (auch Liste von Benutzern ausgeben, die den Kurs nicht mehr belegt haben)',

   'Generation'
=> 'Generation',

   'Group/Section'
=> 'Gruppe/Sektion',

   'HTML/XML'
=> 'HTML/XML',

   'Hide'
=> 'Verbergen',

   '(Hide)'
=> '(Verbergen)',

   'hide'
=> 'verbergen',

   'Student/Employee ID'
=> 'Studierenden-/Mitarbeiter-ID',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'Falls aktiv, dann wird die neue Rolle verfügbar sein, wenn sich die Studierenden das nächste Mal in LON-CAPA einloggen.',

   'Ignore First Line'
=> 'Erste Zeile nicht berücksichtigen',

   'Initial Password'
=> 'Anfangspasswort',

   'Internal Filename'
=> 'Interner Dateiname',

   'Invalid home server specified'
=> 'Ungültiger Heimatserver angegeben',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Alle Ressourcen immer mit den neuesten Versionen aktuell halten (voreingestellt)',

   'LON-CAPA Domain for Students'
=> 'LON-CAPA-Domäne für Studierende',

   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA-Kursbelegungs-Verwaltung',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPA-Domäne: [_1]',

   'LON-CAPA domain'
=> 'LON-CAPA-Domäne',

   'First Name'
=> 'Vorname',

   'Middle Name'
=> 'Zweiter Vorname',

   'Last Name'
=> 'Nachname',

   'Last Name, First Names'
=> 'Nachname, Vornamen',

   'Login Type'
=> 'Login-Typ',

   'Middle Names/Initials'
=> 'Zweiter Vorname/Initialen',

   'Modify Parameters'
=> 'Parameter ändern',

   'Modify student data'
=> 'Bearbeite Studierendendaten',

   'Most recently published Version'
=> 'Zuletzt veröffentlichte Version',

   'No Kerberos domain was specified.'
=> 'Es wurde keine Kerberos-Domäne angegeben.',

   'None Found'
=> 'Nichts gefunden',

   'Note: For large courses, this operation may be time consuming.'
=> 'Beachten Sie, dass die Ausführung für große Kurse lange dauern könnte.',

   'Note: This operation may be time consuming when adding several users.'
=> 'Beachten Sie, dass die Ausführung lange dauern kann, wenn Sie mehrere Benutzer hinzufügen.',

   'This will not take effect if the user already exists.'
=> 'Diese Einstellung bleibt ohne Wirkung, falls der Benutzer bereits existiert.',

   'Processed [quant,_1,student].'
=> '[quant,_1,Student/in,Studierende] bearbeitet.',

   'Re-enrollment will re-activate data.'
=> 'Eine erneute Kursbelegung würde die Daten reaktivieren.',

   'Registering clickers: [_1]'
=> 'Registriere Clicker: [_1]',

   'Samples'
=> 'Beispiele',

   'Save as ...'
=> 'Speichern unter...',

   'Set Version to be used in Course'
=> 'Version einstellen, die im Kurs verwendet werden soll',

   'Set Version to be used in Community'
=> 'Version einstellen, die in der Community verwendet werden soll',

   'Set Versions to be used in Course according to Selections below'
=> 'Gemäß der unten getroffenen Auswahl Versionen einstellen, die im Kurs verwendet werden sollen',

   'Set Versions to be used in Community according to Selections below'
=> 'Gemäß der unten getroffenen Auswahl Versionen einstellen, die in der Community verwendet werden sollen',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Alle Ressourcen auf die derzeitige Version festsetzen',

   'Show Preview'
=> 'Zeige Vorschau',

   'Space separated'
=> 'Durch Leerzeichen getrennt',

   'Starting and Ending Dates'
=> 'Anfangs- und Endezeitpunkte',

   'Tabulator separated'
=> 'Durch Tabulatoren getrennt',

   'The optional e-mail address field was not specified.'
=> 'Das optionale E-Mail-Adress-Feld wurde nicht zugewiesen.',

   'The optional name field was not specified.'
=> 'Das optionale Namensfeld wurde nicht zugewiesen.',

   'The optional student/employee ID field was not specified.'
=> 'Das optionale Studierenden-/Mitarbeiter-ID-Feld wurde nicht zugewiesen.',

   'The optional section or group field was not specified.'
=> 'Das optionale Sektions- oder Gruppenfeld wurde nicht zugewiesen.',

   'The optional section field was not specified.'
=> 'Das optionale Sektionsfeld wurde nicht zugewiesen.',

   'The optional role field was not specified.'
=> 'Das optionale Rollenfeld wurde nicht zugewiesen.',

   'The optional domain field was not specified.'
=> 'Das optionale Domänenfeld wurde nicht zugewiesen.',

   'The optional affiliation field was not specified'
=> 'Das optionale Angliederungsfeld wurde nicht zugewiesen.',

   'The optional credits field was not specified'
=> 'Das optionale Credits-Feld wurde nicht zugewiesen.',

   'There are no students currently enrolled.'
=> 'Derzeit haben keine Studierenden den Kurs belegt.',

   'Continue adding users?'
=> 'Mit dem Hinzufügen von Benutzern fortfahren?',

   'Threaded View'
=> 'Thread-Ansicht',

   'Total number of records found in file: [_1]'
=> 'Gesamtanzahl an Datensätzen, die in der Datei gefunden wurden: [_1]',

   'Total number of records found in file: [_1].'
=> 'Gesamtanzahl an Datensätzen, die in der Datei gefunden wurden: [_1]',

   'Unable to enroll students'
=> 'Konnte Studierende nicht in den Kurs aufnehmen',

   'Updating discussion time'
=> 'Aktualisiere Diskussionszeit',

   'Upload a class list'
=> 'Kursteilnehmerliste hochladen',

   'Uploading Class List'
=> 'Lade Kursteilnehmerliste hoch',

   'Verify Content'
=> 'Inhalte prüfen',

   'Verify contents can be retrieved/rendered'
=> 'Überprüfen, ob Inhalte abgerufen/gerendert werden können',

   'Version used in Course'
=> 'Version, die im Kurs verwendet wird',

   'Version used in Community'
=> 'Version, die in der Community verwendet wird',

   'Welcome'
=> 'Willkommen',

   'Welcome to the Learning[_1]Online[_2] Network with CAPA. Please wait while your session is being set up.'
=> 'Willkommen zu LON-CAPA. Bitte warten Sie, während Ihre Sitzung vorbereitet wird.',

   'You must choose an authentication type.'
=> 'Sie müssen einen Authentifizierungstyp auswählen.',

   'You need to specify the Kerberos domain.'
=> 'Sie müssen eine Kerberos-Domäne angeben.',

   'You need to specify the initial password.'
=> 'Sie müssen ein initiales Passwort angeben.',

   'You need to specify the username field.'
=> 'Sie müssen das Benutzerkennungs-Feld angeben.',

   'Your Version Settings have been Saved'
=> 'Ihre Versionseinstellungen wurden gespeichert',

   '[_1] Do not change login data'
=> '[_1] Login-Daten nicht ändern',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5 [_5]'
=> '[_1] Kerberos-authentifiziert mit Domäne [_2] [_3] Version 4 [_4] Version 5 [_5]',

   'Currently Kerberos authenticated with domain [_1] Version [_2].'
=> 'Derzeit Kerberos-authentifiziert mit Domäne [_1] Version [_2].',

   'Currently Kerberos authenticated, Version [_1].'
=> 'Derzeit Kerberos-authentifiziert, Version [_1].',

   'name only visible to course faculty'
=> 'Name nur für Kursverwaltung sichtbar',

   'name only visible to community facilitators'
=> 'Name nur für Community-Verwaltung sichtbar',

   'Calculate answers'
=> 'Berechne Antworten',

   'Show All Foils'
=> 'Alle Auswahlmöglichkeiten anzeigen',

   'Show All Instances'
=> 'Alle Instanzen anzeigen',

   '1 out of N multiple choice (radio button)'
=> 'Single Choice (1-aus-N-Auswahl / Radiobutton)',

   'Add new option'
=> 'Neue Option einfügen',

   'Administrator'
=> 'Administrator',

   'Answer:'
=> 'Antwort:',

   'Attachment'
=> 'Anhang',

   '(128 KB max size)'
=> '(maximal 128 KB)',

   'Change'
=> 'Ändern',

   'Change Random Seed To:'
=> 'Zufallszahlen-Basis:',

   'Change Your Language Preferences'
=> 'Ändere Spracheinstellungen',

   'Concept:'
=> 'Konzept:',

   'Correct Option:'
=> 'Korrekte Auswahl:',

   'Create a New Course'
=> 'Neuen Kurs erstellen',

   'Create course'
=> 'Kurs erstellen',

   'Create a New Community'
=> 'Neue Community erstellen',

   'Create community'
=> 'Community erstellen',

   'Create a New Group'
=> 'Neue Gruppe erstellen',

   'Create a New Course or Group Space'
=> 'Neuen Kurs oder neuen Gruppenbereich erstellen',

   'Current'
=> 'Derzeitig',

   'Current:'
=> 'Derzeitig:',

   'Delete an option'
=> 'Eine Option löschen',

   'Delete:'
=> 'Löschen:',

   'Diffs with Current Version'
=> 'Unterschiede zur derzeitigen Version',

   'Diffs with Version'
=> 'Unterscheidet sich von Version',

   'Diffs with Version [_1]'
=> 'Unterschiede zu Version [_1]',

   'Diffs with current Version'
=> 'Unterschiede zur derzeitigen Version',

   'Display and analysis of submission times on assessments.'
=> 'Anzeige und Analyse der Einreichungszeiten in Beurteilungen',

   'Display foils in order given'
=> 'Auswahlmöglichkeiten in gegebener Sortierung anzeigen',

   'Display foils in random order'
=> 'Auswahlmöglichkeiten in zufälliger Reihenfolge anzeigen',

   'Domain Guest'
=> 'Domänengast',

   'Essay, open end'
=> 'Essay, keine Zeitbegrenzung',

   'False'
=> 'Falsch',

   'Foil'
=> 'Auswahlmöglichkeit',

   'Format:'
=> 'Format:',

   'Height(pixel):'
=> 'Höhe (Pixel):',

   'Hint Text'
=> 'Lösungshinweis',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'Wenn diese Ressource in Benutzung ist, ist es möglich, dass auf Leistungsdaten der Studierenden von vorhergehenden Versionen nicht mehr zugegriffen werden kann.',

   'Image:'
=> 'Bild:',

   'Incorrect Answers:'
=> 'Falsche Antworten:',

   'Last accessed'
=> 'Letzter Zugriff',

   'Librarian'
=> 'Bibliothekar',

   'Making Backup to [_1]'
=> 'Erstelle Sicherungsdatei in [_1]',

   'Max Number Of Shown Foils:'
=> 'Maximale Anzahl anzuzeigender Auswahlmöglichkeiten:',

   'Max number of foils displayed'
=> 'Maximale Anzahl gezeigter Auswahlmöglichkeiten',

   'Metadata'
=> 'Metadaten',

   'metadata'
=> 'Metadaten',

   'Metadata Version'
=> 'Metadaten-Version',

   'Metadata Version [_1]'
=> 'Metadaten-Version [_1]',

   'Metadata current version'
=> 'Derzeitige Version der Metadaten',

   'Save Metadata'
=> 'Metadaten speichern',

   'Name:'
=> 'Name:',

   'New parameters or saved values'
=> 'Neue Parameter oder gespeicherte Werte',

   'No language preference'
=> 'Keine Sprachpräferenz',

   'Not shown, not used'
=> 'Nicht gezeigt, nicht benutzt',

   'Obsolete parameters or saved values'
=> 'Veraltete Parameter oder gespeicherte Werte',

   'Option response'
=> 'Optionsauswahl',

   'Option Response'
=> 'Optionsauswahl',

   'Position'
=> 'Position',

   'Preferred language'
=> 'Bevorzugte Sprache',

   'Problems'
=> 'Probleme',

   'Produce Excel Output'
=> 'Excel-Ausgabe erstellen',

   'Question Text'
=> 'Fragetext',

   'Random position'
=> 'Zufällige Position',

   'Retrieve Published Resources'
=> 'Veröffentlichte Ressourcen wiederherstellen',

   'Short string response'
=> 'Kurze Textantwort',

   'Show always at bottom position'
=> 'Immer am Ende anzeigen',

   'Show always at top position'
=> 'Immer am Anfang anzeigen',

   'Size:'
=> 'Größe:',

   'Save Changes'
=> 'Änderungen speichern',

   'Submission Time Analysis'
=> 'Analyse der Einreichungszeit',

   'Submit Changes and Edit'
=> 'Speichern und weiterbearbeiten',

   'TeXWidth(mm):'
=> 'TeX-Breite (mm):',

   'Text'
=> 'Text',

   'Text Block'
=> 'Textblock',

   'This is an automatic e-mail generated by the LON-CAPA system.'
=> 'Dies ist eine durch LON-CAPA automatisch erstellte E-Mail.',

   'True'
=> 'Wahr',

   'unused'
=> 'nicht verwendet',

   'Type-in value'
=> 'eingegebener Wert',

   'Unit:'
=> 'Einheit:',

   'Value'
=> 'Wert',

   'Warning!'
=> 'Achtung!',

   'Warning'
=> 'Achtung',

   'Width(pixel):'
=> 'Breite (Pixel):',

   'anonymous'
=> 'anonym',

   'bytes'
=> 'Bytes',

   'versions of this problem'
=> 'Versionen von dieser Aufgabe',

#=====================
# Begin remote control (mydesk.tab)
# 2x8 chars, only lower case
# Same order as in mydesk.tab!
   'choose[_1]'
=> 'wähle',
   'course[_1]'
=> 'kurs',

   'switch[_1]'
=> 'wechsle',
   'course[_2]'
=> 'kurs',

   'switch[_2]'
=> 'wechsle',
   'role[_1]'
=> 'rolle',

   'choose[_2]'
=> 'wähle',
   'role[_2]'
=> 'rolle',

   'course[_3]'
=> 'kurs-',
   'docs[_1]'
=> 'inhalt',

   'course[_7]'
=> 'Kursinh',
   'editor[_1]'
=> 'einricht',

   'navigate[_1]'
=> 'inhalts-',
   'contents[_1]'
=> 'verz',

   'request-[_1]'
=> 'Kurs',
   'course[_16]'
=> 'anfordern',

   'my[_1]'
=> 'meine',
   'grades[_1]'
=> 'bewert',

   'course[_4]'
=> 'kurs',
   'grades[_2]'
=> 'bewert',

   'course[_5]'
=> 'kurs-',
   'chart[_1]'
=> 'fortschr',

   'course[_6]'
=> 'kurs-',
   'stats[_1]'
=> 'stat',

   'manage[_1]'
=> 'verwalte',
   'acc keys[_1]'
=> 'z-schl',

   'course[_12]'
=> 'kursteil',
   'roster[_1]'
=> 'nehmer',

   'user[_1]'
=> 'benutzer',
   'privs[_1]'
=> 'berecht',

   'create[_1]'
=> 'kurs',
   'course[_8]'
=> 'erstell',

   'course[_9]'
=> 'kurs-',
   'parms[_1]'
=> 'param',

   'con-[_1]'
=> 'konstr-',
   'struct[_1]'
=> 'bereich',

   'co con-[_1]'
=> 'Konstruk',
   'struct[_2]'
=> 'Co-Autor',

   'domain[_1]'
=> 'domänen-',
   'config[_1]'
=> 'konfig',

   'upload[_1]'
=> 'PDF-Form',
   'pdf form[_1]'
=> 'hochlad',

   'resource[_1]'
=> 'res-',
   'space[_1]'
=> 'bereich',

   'co res[_1]'
=> 'co-res-',
   'space[_2]'
=> 'bereich',

   'what is[_1]'
=> 'wasgibts',
   'new[_1]'
=> 'neues',

   'enter[_1]'
=> 'Bewert',
   'grades[_3]'
=> 'eingeben',

   'send bub[_1]'
=> 'lade bub',
   'blesheet[_1]'
=> 'blesheet',

   'course[_13]'
=> 'kurs-',
   'catalog[_1]'
=> 'übersi',

   'view[_1]'
=> 'lese-',
   'bookmark[_1]'
=> 'zeichen',

   'calendar[_1]'
=> 'kalend-',
   'announce[_1]'
=> 'ankünd',

   'commu-[_1]'
=> 'kommu-',
   'nication[_1]'
=> 'nikation',

   'course[_10]'
=> 'kurs-',
   'chatroom[_1]'
=> 'chatroom',

   'course[_14]'
=> 'kurs-',
   'groups[_1]'
=> 'gruppen',

   'port-[_1]'
=> 'port-',
   'folio[_1]'
=> 'folio',

   'edit[_1]'
=> 'blogs',
   'blogs[_1]'
=> 'verwalt',

   'search[_3]'
=> 'suche in',
   'prtfolio[_1]'
=> 'prtfolio',

   'search[_1]'
=> 'im kurs',
   'course[_11]'
=> 'suchen',

   'search[_2]'
=> 'suche in',
   'library[_1]'
=> 'res',

   'prefer-[_1]'
=> 'benutz-',
   'ences[_1]'
=> 'einst',

   'logout[_1]'
=> 'logout',
   ' [_1]'
=> ' ',

#=====================
# Remote control entries which occur only in lonmenu.pm

   'problem[_1]'
=> 'Aufgaben',
   'grades[_4]'
=> 'Bewert',

   'sub-[_1]'
=> 'Einrei-',
   'missions[_1]'
=> 'chungen',

   'problem[_2]'
=> 'Aufgaben',
   'parms[_2]'
=> 'Param',

   'dir[_1]'
=> 'Verz[_1]',
   'list[_1]'
=> 'anzeigen[_1]',

   'retrieve[_1]'
=> 'Version',
   'version[_1]'
=> 'wiederherstellen',

   'publish[_1]'
=> 'Ressourc',
   'resource[_3]'
=> 'veröffen',

   'delete[_1]'
=> 'Ressourc',
   'resource[_2]'
=> 'löschen',

   'prepare[_1]'
=> 'Drucken',
   'printout[_1]'
=> '', # !

   'backward[_1]'
=> 'zurück',

   'forward[_1]'
=> 'Weiter',

   'catalog[_2]'
=> 'Katalog-',
   'info[_1]'
=> 'info',

   'evaluate[_1]'
=> 'Aufgabe',
   'this[_1]'
=> 'evaluier',

   'feedback[_1]'
=> 'Feedback',
   'discuss[_1]'
=> 'Diskuss',

# End remote control
#=====================


   'Enter a maximum of [quant,_1,collaborator] using username or username:domain, e.g. smithje or smithje:[_2].'
=> 'Geben Sie maximal [_1] Mitarbeiter ein in der Form Benutzerkennung oder Benutzerkennung:Domäne, z.B. mustermann oder mustermann:[_2]',

   '(Enter a maximum of [quant,_1,collaborator] using username or username:domain, e.g. smithje or smithje:[_2].)'
=> '(Geben Sie maximal [_1] Mitarbeiter ein in der Form Benutzerkennung oder Benutzerkennung:Domäne, z.B. mustermann oder mustermann:[_2])',

   'If entering more than one, use spaces to separate the collaborators.'
=> 'Falls Sie mehr als einen angeben, verwenden Sie Leerzeichen zum Trennen der einzelnen Mitarbeiter.',

   'Collaborated with [_1]',
=> 'Zusammengearbeitet mit [_1]',

   '(Hand in a file you have prepared on your computer)'
=> '(Reichen Sie eine Datei ein, die Sie auf Ihrem Computer vorbereitet haben)',

   ', select a template from the pull-down menu below.'
=> ', wählen Sie eine Vorlage aus dem folgenden Auswahlmenü aus.',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>-Tags sind zugleich innerhalb und außerhalb eines <part>-Tags. Dies ist keine gültige Aufgabe. Beim Bewerten können Fehler auftreten.',

   'ABSTRACT'
=> 'ÜBERBLICK',

   'Access Control'
=> 'Zugriffskontrolle',

   'Activate'
=> 'Aktivieren',

   'Add Roles'
=> 'Rollen hinzufügen',

   "Add one empty page/column after each student's assignment"
=> "Füge eine leere Seite/Spalte nach jeder studentischen Übung ein",

   "Add three empty pages/column after each student's assignment"
=> "Füge drei leere Seiten/Spalten nach jeder studentischen Übung ein",

   "Add two empty pages/column after each student's assignment"
=> "Füge zwei leere Seiten/Spalten nach jeder studentischen Übung ein",

   'Date Shift'
=> 'Datumsverschiebung',

   'Do not clone date parameters'
=> 'Datumswerte nicht klonen',

   'Clone date parameters as-is'
=> 'Datumswerte unverändert übernehmen',

   'Shift date parameters by number of days'
=> 'Datumswerte um bestimmte Anzahl an Tagen verschieben',

   'Additional settings, if specified below, will override cloned settings'
=> 'Weitere Einstellungen, falls unten angegeben, werden erzeugte Einstellungen überschreiben',

   'Advanced Edit'
=> 'Erweiterter Editor',

   'All Resources'
=> 'Alle Ressourcen',

   'all resources'
=> 'Alle Ressourcen',

   'All Students'
=> 'Alle Studierenden',

   'Previous Student'
=> 'Vorherige/r Student/in',

   'Previous Student ([_1])'
=> 'Vorherige/r Student/in ([_1])',

   'Next Student'
=> 'Nächste/r Student/in',

   'Next Student ([_1])'
=> 'Nächste/r Student/in ([_1])',

   'Allowed filetypes: [_1]'
=> 'Akzeptierte Dateitypen: [_1]',

   'An error occurred during the attempt to change the section for this student.'
=> 'Beim Ändern der Sektion für diesen Studierenden trat ein Fehler auf.',

   'An error occurred during the attempt to change the role information for this student.'
=> 'Beim Ändern der Rolleninformationen für diesen Studierenden trat ein Fehler auf.',

   'Analyzing Results'
=> 'Ergebnisse der Analyse',

   'Answerable'
=> 'Beantwortbar',

   'Assessment Parameters'
=> 'Beurteilungseinstellungen',

   'Automated Enrollment Manager'
=> 'Verwaltung der automatischen Kursbelegung',

   'Automated adds'
=> 'Automatische Hinzufügungen',

   'Automated drops'
=> 'Automatische Ausschließungen',

   'Automatic Adds'
=> 'Automatische Hinzufügungen',

   'Automatic Drops'
=> 'Automatische Ausschließungen',

   'Automated enrollment settings'
=> 'Einstellungen für automatische Kursbelegung',

   'Bad Filename'
=> 'Ungültiger Dateiname',

   'Begin Enrollment'
=> 'Kursbelegung beginnen',

   'Binary File'
=> 'Binärdatei',

   'Blank'
=> 'Leer',

   'CSV format'
=> 'CSV-Format',

   'Cannot publish directory'
=> 'Kann Verzeichnis nicht veröffentlichen',

   'Cannot retrieve directory'
=> 'Kann Verzeichnis nicht abrufen',

   'Catalog Search'
=> 'Katalog-Suche',

   'Change User Privileges'
=> 'Benutzerrechte ändern',

   'Click here for FAQ'
=> 'Häufig gestellte Fragen',

   'Click here for help'
=> 'Hilfe',

   'Click here to report bugs'
=> 'Hier zum Melden von Fehlern klicken',

   'Click-On Texts (comma sep):'
=> 'Antwortvorgabetexte zum Anklicken (durch Kommata getrennt):',

   'Clone an existing course'
=> 'Einen bestehenden Kurs klonen',

   'Clone an existing community'
=> 'Eine bestehende Community klonen',

   'Close This Window'
=> 'Dieses Fenster schließen',

   'Closed [_1]'
=> 'Geschlossen seit [_1]',

   'Communication'
=> 'Kommunikation',

   'Compare versions of'
=> 'Vergleiche Versionen von',

   'No differences found'
=> 'Keine Unterschiede gefunden',

   'Completely new course'
=> 'Komplett neuer Kurs',

   'Completely new community'
=> 'Komplett neue Community',

   'Authoring Space Version'
=> 'Version im Autorenbereich',

   'Continue'
=> 'Weiter',

   'Copy current file to'
=> 'Kopiere derzeitige Datei nach',

   'Copy selected'
=> 'Kopiere ausgewählte',

   'Course Code'
=> 'Kurscode',

   'Course Content'
=> 'Kursinhalt',

   'Course Data'
=> 'Kursdaten',

   'Course Home Server'
=> 'Heimatserver des Kurses',

   'Community Home Server'
=> 'Heimatserver der Community',

   'Course ID/Number'
=> 'Kurs-ID/Nummer',

   'Community ID/Number'
=> 'Community-ID/Nummer',

   'Course Information'
=> 'Kursinformationen',

   'Community Information'
=> 'Community-Informationen',

   'Resource Level'
=> 'Ressource', # 'Ressourcen-Ebene',

   'Map/Folder Level'
=> 'Inhaltszus./Verzeichnis', # 'Inhaltszus.-/Verzeichnis-Ebene',

   'Course Level'
=> 'Kurs-Ebene',

   'Course Search'
=> 'Suche im Kurs',

   'Create New User [_1] in domain [_2]'
=> 'Neuen Benutzer [_1] in der Domäne [_2] erstellen',

   'Create New User'
=> 'Neuen Benutzer erstellen',

   'Create User'
=> 'Benutzer erstellen',

   'Crosslisted courses'
=> 'Fachübergreifende Kurse',

   'Current Class List'
=> 'Aktuelle Kursteilnehmerliste',

   'Current Ending Date: [_1]'
=> 'Derzeitiges Enddatum: [_1]',

   'Current Ending Date: not set'
=> 'Derzeitiges Enddatum: nicht gesetzt',

   'Current Resource'
=> 'Derzeitige Ressource',

   'Current Starting Date: [_1]'
=> 'Derzeitiges Anfangsdatum: [_1]',

   'Current Starting Date: not set'
=> 'Derzeitiges Anfangsdatum: nicht gesetzt',

   'Current Version'
=> 'Derzeitige Version',

   'Currently no active roles, courses or communities'
=> 'Derzeit keine aktiven Rollen, Kurse oder Communitys',

   'Currently no additional roles, courses or communities'
=> 'Derzeit keine weiteren Rollen, Kurse oder Communitys',

   'The following [quant,_1,role,roles] will become active in the future:'
=> 'Die [quant,_1,folgende Rolle wird,folgenden Rollen werden] zukünftig aktiv:',

   'Currently submitted: [_1]'
=> 'Derzeit eingereicht: [_1]',

   'Custom Role Editor'
=> 'Editor für benutzerdefinierte Rollen',

   'Cut selected'
=> 'Auswahl ausschneiden',

   'Decompress'
=> 'Entpacken',

   'Default Assessment Spreadsheet'
=> 'Standard-Beurteilungsbogen',

   'Default Course Spreadsheet'
=> 'Standard-Kurs-Beurteilungsbogen',

   'Default Student Spreadsheet'
=> 'Standard-Studierenden-Beurteilungsbogen',

   'Default XML Style File'
=> 'Standard-XML-Style-Datei',

   'Default XML style file'
=> 'Standard-XML-Style-Datei',

   'Default for new courses is'
=> 'Standard für neue Kurse ist',

   'Default:'
=> 'Voreingestellt:',

   'Dependencies'
=> 'Abhängigkeiten',

   'Description:'
=> 'Beschreibung:',

   'Disable student resource discussion'
=> 'Ressourcendiskussion für Studierende deaktivieren',

   'Disable student use of chat rooms'
=> 'Chatroom-Nutzungsmöglichkeit für Studierende deaktivieren',

   'Disable member use of chat rooms'
=> 'Chatroom-Nutzungsmöglichkeit für Mitglieder deaktivieren',

   'Display file attributes'
=> 'Zeige Dateiattribute',

   'Do NOT generate as standard course'
=> 'NICHT als Standard-Kurs erstellen',

   'Do NOT generate as standard community'
=> 'NICHT als Standard-Community erstellen',

   'Domain Level'
=> 'Domänenebene',

   "Don't Show Feedback"
=> "Kein Feedback anzeigen",

   'Duration of automated classlist updates'
=> 'Dauer der automatischen Aktualisierung der Kursteilnehmerlisten',

   'Dynamic Metadata (updated periodically)'
=> 'Dynamische Metadaten (regelmäßig aktualisiert)',

   'ERROR'
=> 'FEHLER',

   'Edit Custom Role Privileges'
=> 'Bearbeite benutzerdefinierte Rollenprivilegien',

   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Editor Fehler - diese Fehler müssen das Ausführen der Aufgabe nicht beeinflussen, aber sie werden wahrscheinlich Probleme mit der weiteren Benutzung des Editormodus verursachen. Bearbeiten Sie bitte die Aufgabe im XML-Modus, um diese Fehler zu beheben.',

   'Start time'
=> 'Startzeit',

   'End Time'
=> 'Endezeit',

   'End time'
=> 'Endezeit',

   'Ending Date'
=> 'Enddatum',

   'Ending date'
=> 'Enddatum',

   'Enroll One Student'
=> 'Einen einzelnen Studierenden den Kurs belegen lassen',

   'Enroll as student'
=> 'Studierende den Kurs belegen lassen',

   'Enrolling'
=> 'Belege',

   'Enrolling Student'
=> 'Student/in wird in den Kurs aufgenommen',

   'Enter as many fields as you can.'
=> 'Füllen Sie so viele Felder wie möglich aus.',

   'The system will inform you and bring you back to this page,[_1]if the data selected are insufficient to add users.'
=> 'Das System wird Sie informieren und zu dieser Seite zurückbringen,[_1]falls die ausgewählten Daten nicht ausreichen, Benutzer in Ihren Kurs aufzunehmen.',

   'The system will inform you and bring you back to this page,[_1]if the data selected is insufficient to create the slots.'
=> 'Das System wird Sie informieren und zu dieser Seite zurückbringen,[_1]falls die ausgewählten Daten nicht ausreichen, die Slots zu erstellen.',

   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Geben Sie Suchbegriffe oder -Sätze ein. Sie können AND, OR und NOT als Such-Operatoren verwenden. Klicken Sie anschließend unten auf SUCHEN.',

   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Geben Sie Suchbegriffe oder -Sätze ein. Sie können als Such-Operatoren AND, OR und NOT verwenden.',

   'Entering Authoring Space'
=> 'Betrete Autorenbereich...',

   'Error: Directory Non Empty'
=> 'Fehler: Verzeichnis nicht leer',

   'Error: destination for operation is an existing directory.'
=> 'Fehler: Das Ziel der Verarbeitung ist ein existierendes Verzeichnis.',

   'Evaluation Error '
=> 'Evaluierungsfehler',

   'Evaluation Error: '
=> 'Evaluierungsfehler: ',

   'Homework Problem'
=> 'Aufgabe',

   'Homework problem'
=> 'Aufgabe',

   'Exam Problem'
=> 'Prüfungsaufgabe',

   'Exam problem'
=> 'Prüfungsaufgabe',

   'Excel format'
=> 'Excel-Format',

   'Feedback Addresses for Course Content Comments'
=> 'Feedback-Adressen für Kommentare zu Kursinhalten',

   'Feedback Addresses for Course Policy'
=> 'Feedback-Adressen für Kursrichtlinien',

   'Feedback Addresses for Resource Content Question'
=> 'Feedback-Adressen für Fragen zum Inhalt der Ressourcen',

   'First'
=> 'Erste',

   'First Resource'
=> 'Erste Ressource',

   'Foil name [_1] appears more than once. Foil names need to be unique.'
=> 'Die Auswahlmöglichkeits-Bezeichnung [_1] tritt mehr als einmal auf. Bezeichnungen für Auswahlmöglichkeiten müssen jedoch eindeutig sein.',

   'Folder/Map'
=> 'Verzeichnis/Inhaltszusammenstellung',

   'For one or more students'
=> 'Für einen oder mehrere Studierende',

   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Es wurde ein <*response>-Tag außerhalb eines <part>-Bereichs einer Aufgabe gefunden, die aber Aufgabenteile (parts) verwendet.',

   'Generate messages from a file'
=> 'Aus einer Datei Nachrichten erstellen',

   'Go'
=> 'Go',

   'go'
=> 'Go',

   'Go To'
=> 'Gehe nach',

   'Go to ...'
=> 'Gehe nach...',

   'Help on Creating Courses'
=> 'Hilfe bei der Kurserstellung',

   'Home Server'
=> 'Heimatserver',

   'How do I create a CSV file from a spreadsheet'
=> 'Wie erstelle ich aus einer Excel-Datei eine CSV-Datei?',

   'How should the results be printed?'
=> 'Wie sollen die Resultate ausgedruckt werden?',

   'Immediately expire own role as Course Coordinator'
=> 'Eigene Rolle als Kurs-Koordinator mit sofortiger Wirkung verfallen lassen',

   'Import and Paste Area'
=> 'Feld zum Importieren und Einfügen',

   'Include retrieval of student photographs?'
=> 'Abrufen der Studierendenfotos einbinden?',

   'Institutional Information'
=> 'Institutionelle Information',

   'Invalid Significant figures detected'
=> 'Ungültige signifikante Stellen entdeckt',

   'Invalid characters in requested name have been removed.'
=> 'Aus dem gewünschten Dateinamen wurden ungültige Zeichen entfernt.',

   'Invalid login mode or password.'
=> 'Falscher Login-Modus oder Passwort.',

   'Invalid username or domain'
=> 'Ungültige Benutzerkennung oder Domäne',

   'Invalid username or domain for community requestor'
=> 'Ungültige Benutzerkennung oder Domäne für Community-Anforderer',

   'Invalid username or domain for course requestor'
=> 'Ungültige Benutzerkennung oder Domäne für Kurs-Anforderer',

   'KEYWORDS'
=> 'SCHLÜSSELWÖRTER',

   'LaTeX batchmode'
=> 'LaTeX-Batchmodus',

   'LaTeX mode'
=> 'LaTeX-Modus',

   'Languages used'
=> 'Verwendete Sprachen',

   'Last'
=> 'Letzte',

   'Leave blank on scoring form'
=> 'Im Bewertungsformular leer lassen',

   'List Directory'
=> 'Verzeichnisinhalt auflisten',

   'Location'
=> 'Ort',

   'Login Data'
=> 'Login-Daten',

   'Logout'
=> 'Logout',

   'Make new directory [_1]?'
=> 'Neues Verzeichnis [_1] erstellen?',

   'Make new file'
=> 'Neue Datei erstellen',

   'Manual Grading'
=> 'Manuelle Bewertung',

   'Map has branchings. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat Verzweigungen. Verwenden Sie den erweiterten Editor.',

   'Map has conditions. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat Bedingungen. Verwenden Sie den erweiterten Editor.',

   'Map has resource parameters. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat Ressourcen-Parameter. Verwenden Sie den erweiterten Editor.',

   'Map has unconnected resources. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat unverbundene Ressourcen. Verwenden Sie den erweiterten Editor.',

   'Messaging'
=> 'Versenden von Nachrichten',

   'Missing Kerberos domain information.'
=> 'Fehlende Kerberos-Domänen-Informationen.',

   'Modification may make assessment data inaccessible!'
=> 'Eine Veränderung könnte die Beurteilungsdaten unzugänglich machen!',

   'Modify Enrollment for'
=> 'Bearbeite Kursbelegung für',

   'Modify User'
=> 'Benutzerdaten ändern',

   'Modify deadlines, etc, for this resource'
=> 'Fälligkeitszeiten, etc. für diese Ressource bearbeiten',

   'Modifying this will make problems have different numbers and answers!'
=> 'Eine Veränderung wird bewirken, dass Aufgaben unterschiedliche Zahlen und Antworten haben werden!',

   'Move current file to'
=> 'Derzeitige Datei verschieben nach',

   'Must create new subdirectory inside a directory'
=> 'Müssen ein neues Unterverzeichnis in dem Verzeichnis erstellen',

   'Name of Role'
=> 'Bezeichnung der Rolle',

   'New Directory'
=> 'Neues Verzeichnis',

   'New HTML file'
=> 'Neue HTML-Datei',

   'New Resource'
=> 'Neue Ressource',

   'New Role'
=> 'Neue Rolle',

   'New User'
=> 'Neuer Benutzer',

   'New Value'
=> 'Neuer Wert',

   'New assembled page'
=> 'Neue zusammengesetzte Seite',

   'New assembled sequence'
=> 'Neue zusammengesetzte Sequenz',

   'New custom rights file'
=> 'Neue Datei für maßgeschneiderte Zugriffsrechte',

   'New file'
=> 'Neue Datei',

   'New problem'
=> 'Neue Aufgabe',

   'Create New problem'
=> 'Neue Aufgabe erstellen',

   'New style file'
=> 'Neue Style-Datei',

   'New subdirectory'
=> 'Neues Unterverzeichnis',

   'Next    '
=> 'Weiter    ',

   'No'
=> 'Nein',

   'No Access or Usages Statistics are available for this resource.'
=> 'Für diese Ressource sind keine Zugriffs- oder Nutzungsstatistiken verfügbar.',

   'No Assessment Statistical Data is available for this resource'
=> 'Für diese Ressource sind keine statistischen Beurteilungsdaten verfügbar.',

   'No Evaluation Data is available for this resource.'
=> 'Für diese Ressource sind keine Evaluierungsdaten verfügbar.',

   'No new filename specified.'
=> 'Kein neuer Dateiname angegeben',

   'No such file'
=> 'Datei existiert nicht',

   'No such file: [_1]'
=> 'Die Datei [_1] existiert nicht.',

   'Not Allowed'
=> 'Nicht zulässig',

   'Not applicable -'
=> 'Nicht anwendbar -',

   'Not open to be viewed'
=> 'Ressource darf nicht betrachtet werden',

   'Not set -'
=> 'Nicht gesetzt -',

   'Notification of enrollment changes'
=> 'Benachrichtigung über Änderungen der Kursbelegung',

   'Notification to [_1]course coordinator[_2] via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Soll LON-CAPA den [_1]Kurs-Koordinator[_2] benachrichtigen, wenn während der automatischen Aktualisierung Änderungen an der Kursbelegung auftreten?',

   'Number of columns'
=> 'Anzahl an Spalten',

   'Old Value'
=> 'Alter Wert',

   'One particular problem (overrides folder and course defaults)'
=> 'Eine bestimmte Aufgabe (überschreibt Verzeichnis- und Kurs-Voreinstellungen)',

   'Online Help'
=> 'Online-Hilfe',

   'Help: [_1]'
=> 'Hilfe zu [_1]',

   'Only domain coordinators can change a users password.'
=> 'Nur Domänen-Koordinatoren können das Passwort eines Benutzers ändern.',

   'Open Course'
=> 'Kurs anlegen',

   'Open Community'
=> 'Community anlegen',

   'Open all assessments'
=> 'Alle Beurteilungen zugänglich machen',

   'Open and correct'
=> 'Öffnen und korrigieren',

   'Open with full tries'
=> 'Öffnen mit allen Versuchen',

   'Output Format: [_1]'
=> 'Ausgabeformat: [_1]',

   'Layout Options'
=> 'Layout-Optionen',

   'Page layout'
=> 'Seitenlayout',

   'Paper type'
=> 'Papiertyp',

   'A2'
=> 'A2',

   'A3'
=> 'A3',

   'A4'
=> 'A4',

   'A5'
=> 'A5',

   'A6'
=> 'A6',

   'Legal'
=> 'Legal',

   'Letter'
=> 'Letter',

   'Executive'
=> 'Executive',

   'Tabloid'
=> 'Tabloid',

   'PDF Form Fields'
=> 'PDF-Formularfelder',

   'with Form Fields'
=> 'mit Formularfeldern',

   'without Form Fields'
=> 'ohne Formularfelder',

   'Problems from the Whole Course'
=> 'Aufgaben des gesamten Kurses',

   'Resources from the Whole Course'
=> 'Ressourcen des gesamten Kurses',

   'Parameter'
=> 'Parameter',

   'Paste after selected'
=> 'Nach der Auswahl einfügen',

   'Personal Data'
=> 'Persönliche Daten',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Wählen Sie hier die voreingestellte Authentifizierungs-Methode aus, die bei neuen Benutzern in dieser LON-CAPA-Domäne verwendet werden soll, die durch den automatischen Kursbelegungs-Prozess hinzugefügt wurden',

   'Default authentication method for new users added to this domain by the automated enrollment process'
=> 'Voreingestellte Authentifizierungsmethode für neue Benutzer, die dieser Domäne durch den automatischen Kursbelegungs-Prozess hinzugefügt wurden',

   'No such user [_1] at domain [_2].' # 1: user, 2: domain
=> 'In der Domäne [_2] existiert der Benutzer [_1] nicht.',

   'Please click Back on your browser and select another user, or [_1]Create User[_2]'
=> 'Bitte klicken Sie in Ihrem Webbrowser auf Zurück und wählen Sie einen anderen Benutzer aus oder wählen Sie [_1]Benutzer erstellen[_2]',

   'Invalid home server for course: [_1]'
=> 'Ungültiger Heimatserver für Kurs [_1]',

   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Bitte kontaktieren Sie zu dieser Angelegenheit Ihren LON-CAPA-Administrator.',

   'Please select an authentication mechanism'
=> 'Wählen Sie bitte eine Authentifizierungs-Methode aus',

   'Please select the Authentication mechanism'
=> 'Auswahl der Authentifizierungs-Methode',

   'Please stand by.'
=> 'Bitte warten.',

   "Please use browser 'Back' button and pick a filename"
=> "Benutzen Sie bitte den Zurück-Button des Webbrowsers und wählen Sie einen Dateinamen aus",

   'Preparing Printout'
=> 'Bereite Ausdruck vor',

   'Print'
=> 'Drucken',

   'Print Index'
=> 'Index drucken',

   'Print Discussions'
=> 'Diskussionsbeiträge drucken',

   'Print Annotations'
=> 'Notizen drucken',

   'Print Table of Contents'
=> 'Inhaltsverzeichnis drucken',

   'Print:'
=> 'Drucke:',

   'Problems from entire course'
=> 'Aufgaben des gesamten Kurses',

   'Processed file: [_1]'
=> 'Verarbeitete Datei: [_1]',

   'Publish this Resource'
=> 'Diese Ressource veröffentlichen',

   'Randomization algorithm used'
=> 'Verwendeter Randomisierungs-Algorithmus',

   'Recent'
=> 'zuletzt',

   'Rename current file to'
=> 'Derzeitige Datei umbenennen in',

   'Report a Bug'
=> 'Einen Fehler melden',

   'Report a bug'
=> 'Einen Fehler melden',

   'Resource'
=> 'Ressource',

   'Resource:'
=> 'Ressource:',

   '[_1]Resource: [_2]'
=> '[_1]Ressource: [_2]',

   'Resource Differences'
=> 'Ressourcen-Unterschiede',

   'Resources from selected sequence in course'
=> 'Ressourcen von ausgewählten Sequenzen im Kurs',

   'Response'
=> 'Antwort',

   'Retrieve Old Version'
=> 'Alte Version wiederherstellen',

   'Retrieving current (most recent) version'
=> 'Aktuellste Version wiederherstellen',

   'Retrieving old version'
=> 'Alte Version wiederherstellen',

   'Back to Course Editor'
=> 'Zurück zum Kurs-Editor',

   'Reverse Association'
=> 'Umgekehrte Assoziierung',

   'Revoke'
=> 'Entziehen',

   'Revoke Existing Roles'
=> 'Bestehende Rollen entziehen',

   'Role'
=> 'Rolle',

   'Role:'
=> 'Rolle:',

   'Role Information'
=> 'Information zur Rolle',

   'Sample Points:'
=> 'Abtastpunkte:',

   'Submission type'
=> 'Art der Einreichung',

   'Submit entries below as answer to receive credit'
=> 'Die untenstehenden Eintragungen einreichen',

   'Save entries below (not submitted for credit yet)'
=> 'Die untenstehenden Eintragungen zwischenspeichern (noch keine endgültige Einreichung)',

   'Choose file(s) to submit'
=> 'Auswahl der Datei(en), die eingereicht werden soll(en)',

   'Combined size of all files not to exceed: [_1] MB.'
=> 'Die Gesamtgröße aller Dateien darf [_1] MB nicht überschreiten.',

   'Submit a file: (only one file per submission)'
=> 'Datei einreichen: (nur eine Datei pro Einreichung)',

   'Select Portfolio Files: (one or more files per submission)'
=> 'Portfolio-Dateien auswählen (eine oder mehrere Dateien pro Einreichung)',

   'Either the file you attempted to upload was empty, or your web browser was unable to read its contents.'
=> 'Entweder war die Datei, die Sie versucht haben hochzuladen, leer oder Ihr Webbrowser konnte den Inhalt der Datei nicht lesen.',

   'Select Action'
=> 'Aktion auswählen',

   'Select All Resources'
=> 'Alle Ressourcen auswählen',

   'Select Printing Options:'
=> 'Auswahl der Druckoptionen',

   'Change Printing Options'
=> 'Druckoptionen',

   'Select Problem(s) to print'
=> 'Auswahl von Aufgaben, die gedruckt werden sollen',

   'Select Resource(s) to print'
=> 'Ressource(n) zum Ausdrucken wählen',

   'Select Resources To Print'
=> 'Ressourcen zum Ausdrucken wählen',

   'Select Section'
=> 'Sektion auswählen',

   'Select Group'
=> 'Gruppe auswählen',

   'Select Sequence To Print From'
=> 'Sequenz, von der gedruckt werden soll, auswählen',

   'Select Students and Resources'
=> 'Studierende und Ressourcen auswählen',

   'Select Style File'
=> 'Style-Datei auswählen',

   "Select a user name to modify the student's information"
=> 'Klicken Sie auf die Benutzerkennung, um die Daten des Studierenden zu ändern.',

   "Select a user name to view the user's personal information page."
=> 'Klicken Sie auf die Benutzerkennung, um die persönliche Seite dieses Benutzers anzuschauen.',

   'Select resources for the assignment'
=> 'Wählen Sie Ressourcen für die Übung aus',

   'Set'
=> 'Setze',

   'Set?'
=> 'Setzen?',

   'Set Course Environment'
=> 'Kursumgebung',

   'Set End Date'
=> 'Enddatum festlegen',

   'Set Individual User Roles'
=> 'Benutzerrollen und -rechte einrichten',

   'Set Start Date'
=> 'Anfangsdatum festlegen',

   'Set content feedback to Course Coordinator'
=> 'Inhaltsbezogenes Feedback soll Kurs-Koordinator erhalten',

   'Set content feedback to Coordinator'
=> 'Inhaltsbezogenes Feedback soll Koordinator erhalten',

   'Set course policy feedback to Course Coordinator'
=> 'Feedback zu Kursrichtlinien soll Kurs-Koordinator erhalten',

   'Set community policy feedback to Coordinator'
=> 'Feedback zu Community-Richtlinien soll Koordinator erhalten',

   'Set opening date for all problems in the course for. . .'
=> 'Setze Öffnungstermin für alle Aufgaben in dem Kurs auf. . .',

   'Set to ...'
=> 'Setze auf...',

   'Show Answer'
=> 'Zeige Antwort',

   'Show Feedback'
=> 'Zeige Feedback',

   'Simple Edit'
=> 'Einfacher Editor',

   'Start Time'
=> 'Startzeit',

   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> 'Jede studentische Übung auf/in einer neuen Seite/Spalte beginnen (einen Seitenvorschub nach jeder Übung einfügen)',

   'Starting Date'
=> 'Anfangsdatum',

   'Starting date'
=> 'Anfangsdatum',

   'Student Information'
=> 'Studierenden-Informationen',

   'Student Sheet Links'
=> 'Tabellenlinks des Studierenden',

   'Student Status'
=> 'Studierendenstatus',

   'Domain Coordinator status'
=> 'Domänen-Koordinator-Status',

   'Student Status: [_1]'
=> 'Studierendenstatus: [_1]',

   'Student information updated successfully.'
=> 'Studierenden-Informationen erfolgreich aktualisiert.',

   'Students need access key to enter course'
=> 'Die Studierenden benötigen zum Betreten des Kurses einen Zugangsschlüssel',

   'Members need access key to enter course'
=> 'Die Mitglieder benötigen zum Betreten des Kurses einen Zugangsschlüssel',

   'Students with expired roles'
=> 'Studierende mit abgelaufenen Rollen',

   'Students with future roles'
=> 'Studierende mit zukünftigen Rollen',

   'Subject:'
=> 'Thema:',

   'Submission'
=> 'Einreichung',

   'Submissions'
=> 'Einreichungen',

   '[_1]Submissions[_2] [_3]'
=> '[_1]Einreichungen[_2] [_3]',

   'Submissions [_1]',
=> 'Einreichungen [_1]',

   'Submit Modifications'
=> 'Veränderungen einreichen',

   'Survey Question'
=> 'Frage einer Umfrage',

   'Survey question'
=> 'Frage einer Umfrage',

   'Anonymous Survey Question'
=> 'Frage einer anonymen Umfrage',

   'Anonymous Survey Question (with credit)'
=> 'Frage einer anonymen Umfrage (mit Punktevergabe)',

   'Survey Question (with credit)'
=> 'Frage einer Umfrage (mit Punktevergabe)',

   'System Level'
=> 'Systemebene',

   'Target Edit Map'
=> 'Ziel der erstellten Inhaltszusammenstellung', # lonratedt.pm, simple editor

   'TeX unconverted due to errors'
=> 'TeX wegen Fehlern nicht konvertiert',

   'TeX unconverted due to previous errors'
=> 'TeX aufgrund vorheriger Fehler nicht konvertiert',

   'Algebra unconverted due to previous errors'
=> 'Formeln aufgrund vorheriger Fehler nicht konvertiert',

   'The error reported was'
=> 'Der genannte Fehler war',

   'With very high probability this error occurred in [_1].'
=> 'Mit sehr hoher Wahrscheinlichkeit ist dieser Fehler in [_1] aufgetreten.',

   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'Die folgenden Einträge werden benutzt, um den Kurs gemäß des Namensschemas Ihrer Institution zu identifizieren. Ihre Auswahl wird benutzt werden, um eine interne LON-CAPA-Kurs-ID mit der/den zugehörigen Kurs-Sektions-ID(s) zu verbinden. Diese ID(s) werden von der Einrichtung verwendet, die für die Zurverfügungstellung der offiziellen Kurslisten an Ihrer Institution zuständig ist (z.B. Prüfungsamt). Diese Zuordnung ist notwendig, wenn Sie die automatische Aktualisierung von Kurslisten wählen.',

   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "Die folgenden Einstellungen legen die automatische Kursbelegung von Studierenden in diesen Kurs fest und zwar anhand der verfügbaren Informationen für diesen bestimmten Kurs von der offiziellen Kursteilnehmerliste Ihrer Institution.",

   'The requested file'
=> 'Die angeforderte Datei',

   'The student must log out and log in again to see these changes.'
=> 'Der/die Student/in muss sich ausloggen und neu einloggen, um diese Änderungen zu sehen.',

   'There are currently no Error Messages for this resource.'
=> 'Derzeit liegen keine Fehlermeldungen zu dieser Ressource vor.',

   'There are no Evaluation Comments on this resource.'
=> 'Zu dieser Ressource liegen keine Evaluierungskommentare vor.',

   'There was an error determining the environment values for'
=> 'Es trat ein Fehler auf bei der Bestimmung der Umgebungswerte für',

   'Top Level Map'
=> 'Hauptebenen-Inhaltszusammenstellung',

   'Please use a different name for the new top level category.'
=> 'Bitte verwenden Sie einen anderen Namen für die neue Hauptebenen-Kategorie.',

   'Type Name Here'
=> 'Hier Name eingeben',

   'Type in value'
=> 'Wert eingeben',

   'Type:'
=> 'Typ:',

   'UNDISPLAYABLE'
=> 'NICHT DARSTELLBAR',

   'Unable to enroll'
=> 'Kursbelegung nicht möglich',

   'unable to enroll'
=> 'Kursbelegung nicht möglich',

   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Die Datei kann nicht veröffentlicht werden, da Sie doppelte IDs enthält. IDs müssen jedoch eindeutig sein. Die doppelten IDs sind',

   'Unable to retrieve environment data for'
=> 'Konnte die Umgebungsdaten nicht abrufen für',

   'Unable to set default dates for course'
=> 'Die voreingestellten Datumswerte des Kurses konnten nicht gesetzt werden.',

   'Unavailable course'
=> 'Nicht verfügbarer Kurs',

   'Unavailable community'
=> 'Nicht verfügbare Community',

   'Unknown Action: [_1]'
=> 'Unbekannte Aktion: [_1]',

   'Upload class list'
=> 'Lade Kursteilnehmerliste hoch',

   'Upload file'
=> 'Datei hochladen',

   'Upload file to Authoring Space'
=> 'Datei in den Autorenbereich hochladen',

   'VIEW'
=> 'ANSICHT',

   'View the FAQ'
=> 'Zeige die FAQ',

   'Visibly Separate Items on Pages'
=> 'Sichtbar unterschiedliche Einzelteile auf Seiten',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'ACHTUNG: Die Metadaten-Tabelle existiert nicht in der LON-CAPA-Datenbank.',

   'Warning: change of MIME type!'
=> 'Achtung: Änderung des MIME-Typs!',

   'Warning: target file exists!'
=> 'Achtung: Zieldatei existiert bereits!',

   'Warning: target file exists, and has been published!'
=> 'Achtung: Zieldatei existiert und wurde bereits veröffentlicht!',

   'Width'
=> 'Breite',

   'Print Options'
=> 'Druckoptionen',

   'Print Answers'
=> 'Antworten drucken',

   'Only Answers'
=> 'Nur Antworten',

   'With Answers'
=> 'Mit Antworten',

   'Without Answers'
=> 'Ohne Antworten',

   'You are working with an unsaved version of your map.'
=> 'Sie arbeiten momentan an einer nicht gespeicherten Version Ihrer Inhaltszusammenstellung.',

   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Ihre Versuch zur Änderung der Rolleninformationen für diese/n Studenten/in wurde abgelehnt. Sie haben offensichtlich nicht genügend Rechte zum Ändern der Studierendendaten.',

   '[_1] (what you just saw on the screen)'
=> '[_1] (was Sie gerade auf dem Bildschirm sahen)',

   '[_1] Local Authentication with argument [_2]'
=> '[_1] Lokale Authentifizierung mit Argument [_2]',

   'Currently using local (institutional) authentication.'
=> 'Derzeit lokal (institutionell) authentifiziert.',

   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) section ID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2'
=> 'Eine durch Kommata getrennte Liste von Kurs-Sektionen zusammen mit dem derzeitigen Kurs, wobei jeder Eintrag den institutionellen Kurssektionsnamen beinhaltet, gefolgt von einem Doppelpunkt und dann der (optionalen) Sektions-ID zur Verwendung in LON-CAPA, z.B. fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'Eine durch Kommata getrennte Liste institutioneller Sektionsnummern, jeweils getrennt durch einen Doppelpunkt von der in LON-CAPA verwendeten entsprechenden (optionalen) Sektions-ID, z.B. 001:1,002:2',

   'after selected'
=> 'Einfügen nach der Auswahl',

   'and'
=> 'und',

   'And'
=> 'und',

   'between'
=> 'zwischen',

   'button'
=> 'Button',

   'by'
=> 'durch',

   'check all'
=> 'Alle auswählen',

   'chmod error'
=> 'Fehler beim Ausführen von "chmod"',

   'click on the'
=> 'klicken Sie bitte auf',

   'copy Error'
=> 'Kopierfehler',

   'currently does not exist'
=> 'existiert z.Z. nicht',

   'custom'
=> 'benutzerdefiniert',

   'Custom'
=> 'benutzerdefiniert',

   'domain'
=> 'Domäne',

   'expired or revoked'
=> 'abgelaufen oder entzogen',

   'extension'
=> 'Endung',

   'external'
=> 'extern',

   'first name'
=> 'Vorname',

   'generation'
=> 'Generation',

   'internal'
=> 'intern',

   'Internal'
=> 'intern',

   'is in this state by royal decree.'
=> 'hat die Erlaubnis aufgrund eines königlichen Erlasses.',

   'last name'
=> 'Nachname',

   'make these dates the default access dates for future course enrollment'
=> 'Diese Datumswerte als voreingestellte Zugriffszeiten für zukünftige Kursbelegungen verwenden',

   'make these dates the default access dates for future community enrollment'
=> 'Diese Datumswerte als voreingestellte Zugriffszeiten für zukünftige Community-Belegungen verwenden',

   'middle name'
=> 'zweiter Vorname',

   'name'
=> 'Name',

   'Full Name'
=> 'Vollständiger Name',

   'no ending date'
=> 'kein Enddatum',

   'number'
=> 'Nummer',

   'only check if you know what you are doing'
=> 'nur auswählen, wenn Sie wissen, was Sie tun',

   'only search domain [_1]'
=> 'nur in Domäne [_1] suchen',

   'optional'
=> 'optional',

   'or any other value'
=> 'oder jeder andere Wert',

   'private'
=> 'privat',

   'public'
=> 'öffentlich',

   'section'
=> 'Sektion',

   'standard'
=> 'Standard',

   'standard LaTeX mode'
=> 'Standard-LaTeX-Modus',

   'standard courses only'
=> 'Nur Standardkurse',

   'standard communities only'
=> 'Nur Standard-Communitys',

   'student name'
=> 'Studierendenname',

   'Student Name'
=> 'Studierendenname',

   'template'
=> 'Vorlage',

   'to interface with institutional data, e.g., [_1]fs13glg231[_2] for [_3]Fall 2013 Geology 231[_4]'
=> 'zur Kopplung mit institutionellen Daten, z.B. [_1]ws20132014inf1[_2] für [_3]Wintersemester 2013/2014 Informatik 1[_4]',

   'uncheck all'
=> 'Gesamte Auswahl aufheben',

   'use related words'
=> 'ähnliche Wörter verwenden',

   'username'
=> 'Benutzerkennung',

   'LON-CAPA username'
=> 'LON-CAPA-Benutzerkennung',

   'username: '
=> 'Benutzerkennung: ',

   'password: '
=> 'Passwort: ',

   'versus'
=> 'gegen',

   'with server'
=> 'mit Server',

   'yes'
=> 'ja',

   'Swedish Chef'
=> 'Dänischer Koch',

   '[_1] for default hiding'
=> '[_1] für voreingestelltes Verbergen',

   '[_1] for visible separation.'
=> '[_1] für sichtbare Trennung.',

   'Changes will not show until next login.'
=> 'Änderungen werden beim nächsten Login aktiv.',

   '[_1] if allowed, anything else if not'
=> '[_1], um zu erlauben. Alles andere, um nicht zu erlauben.',

   '"[_1]" to disable, anything else if not'
=> '"[_1]", um zu deaktivieren. Alles andere, um zu aktivieren.',

   '[_1] to suppress, anything else to not suppress'
=> '[_1], um zu unterdrücken. Alles andere, um nicht zu unterdrücken.',

   'Set value to [_1] to allow all roles.'
=> '[_1], um für alle Rollen zu erlauben.',

   '[_1] is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '[_1] ist kein zulässiger Wert für die Anzahl von Versuchen. Der Wert muss eine positive, ganze Zahl (ohne Dezimaltrennzeichen) sein.',

   '[_1] is not an acceptable weight. Weight must be a positive number.'
=> '[_1] ist kein zulässiger Wert für die Gewichtung. Der Wert muss eine positive Zahl sein.',

   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML zugelassen</b>: Diskussionsteilnehmer können in ihren Beiträgen eingeschränkten HTML-Befehlssatz verwenden.',

   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML verboten</b>: HTML wird in Diskussionen nicht zugelassen.',

   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Dozent</b> - Dozenten werden nicht an den Diskussionen teilnehmen können.',

   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Dozent</b> - Dozenten werden den Chatroom weder betreten noch die Inhalte einsehen können',

   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Studierende</b> - Studierende werden nicht an Diskussionen teilnehmen können',

   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Studierende</b> - Studierende werden den Chatroom weder betreten noch die Inhalte einsehen können',

   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Tutor</b> - Tutoren werden nicht an den Diskussionen teilnehmen können',

   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Tutor</b> - Tutoren werden den Chatroom weder betreten noch die Inhalte einsehen können',

   'Your current LON-CAPA domain is [_1].'
=> 'Ihre derzeitige LON-CAPA-Domäne ist [_1].',

   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Fortgeschritten: Sie können Feedback von unterschiedlichen Sektionen aus an unterschiedliche Personen senden. Hierzu ist jeder Eintrag mit einem Komma zu trennen. Um Feedback an eine bestimmte Adresse für unterschiedliche Sektionen zu senden, hängen Sie die die Sektionsbezeichnung(en) (getrennt durch Semikolons) in einer Klammerliste nach benutzer:domäne an. Beispiel: john102:msu(001;002;003), bob293:msu(004;005;006), irgendwer:irgendwo(007;008;009) würde Feedback an &quot; john102&quot; für Sektionen 1, 2 und 3, an &quot;bob293&quot; für Sektionen 4, 5 und 6 und an &quot;irgendwer:irgendwo&quot; für Sektionen 7, 8 und 9 senden. Beachten Sie, dass es nicht erforderlich ist, dass die Adressen in einer bestimmten Domäne liegen.',

   'Granting permission to clone course'
=> 'Erlaubnis zum Klonen des Kurses erteilen',

   'Existing courses can be cloned when creating new courses. Cloning will copy the course structure, contents, and most parameters (automatically advancing any date parameters by six months). Usernames of owners of other courses permitted to clone this course:'
=> 'Beim Erstellen neuer Kurse können bestehende Kurse geklont werden. Das Klonen kopiert die Kursstruktur, die Inhalte und die meisten der Parameter (Datumswerte werden automatisch um sechs Monate nach vorne geschoben). Benutzerkennungen von Eigentümern anderer Kurse, denen das Klonen erlaubt werden soll:',

   '(Course Coordinators automatically have the right to clone their own courses.) Format: user:domain, where &quot;user&quot; and &quot;domain&quot; are the LON-CAPA username and domain of the user.Separate different users with a comma.Use *:domain to allow course to be cloned by any course owner in the specified domain.Use * to allow unrestricted cloning by all course owners in all domains.'
=> '(Kurs-Koordinatoren haben automatisch die Berechtigung ihre eigenen Kurse zu klonen) Format: benutzerkennung:domäne, wobei &quot;benutzerkennung&quot; und &quot;domäne&quot; die LON-CAPA-Benutzerkennung und -Domäne des Benutzers sind. Trennen Sie mehrere Benutzer durch Kommata. Verwenden Sie *:domäne, um allen Benutzern der angegebenen Domäne das Klonen des Kurses zu erlauben. Verwenden Sie *, um allen Benutzern aller Domänen uneingeschränkte Berechtigung zum Klonen zu erteilen.',

   'Allow limited HTML in discussion posts'
=> 'Beschränkte Verwendung von HTML in den Diskussionsbeiträgen zulassen',

   'Printout generation'
=> 'Drucken',

   'Allow problems to be split over pages'
=> 'Erlauben, dass sich Aufgaben auf mehrere Seiten aufteilen dürfen',

   'Answer Date (answerdate)'
=> 'Antwort-Verfügbarkeits-Datum (answerdate)',

   'Chat Room Participation'
=> 'Teilnahme am Chatroom',

   'Click here to return to the chart.'
=> 'Klicken Sie hier, um zum Chart zurückzukehren.',

   'Completed'
=> 'Ausgeführt',

   'Confirm that this information is correct, then click &quot;Save&quot; to complete setting the parameter.'
=> 'Bestätigen Sie, dass diese Informationen richtig sind. Klicken Sie dann auf &quot;Speichern&quot;, um das Einstellen der Parameter abzuschließen.',

   'Course ID or number'
=> 'Kurs-ID oder -Nummer',

   'Course Initialization Helper'
=> 'Hilfsprogramm zur Kurs-Einrichtung',

   'Course default for all problems'
=> 'Voreinstellungen des Kurses für alle Aufgaben',

   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an e-mail address.'
=> 'Kursmitglieder können Feedback zum Kurs geben. Sie können hier auswählen, wer das Feedback empfangen soll, wie z.B. ein anderer Dozent oder Tutor. Bitte geben Sie deren LON-CAPA-Benutzer unten in der Form benutzer:domäne ein, wobei &quot;benutzer&quot; und &quot;domäne&quot; LON-CAPA-Benutzerkennung und LON-CAPA-Domäne sind. Verwenden Sie keine E-Mail-Adresse!',

   'Courses'
=> 'Kurse',

   'Default beginning date when enrolling students'
=> 'Voreingestelltes Anfangsdatum für die studentische Kursbelegung',

   'Default ending date when enrolling students'
=> 'Voreingestelltes Enddatum für die studentische Kursbelegung',

   'Default set of options to pass to tth/m when converting TeX'
=> 'Voreingestellte Optionen für tth/m für die Konvertierung von TeX',

   'Disable display of problem receipts'
=> 'Anzeige von Aufgaben-Nachweisnummern deaktivieren',

   'Disallow Resource Discussion for Roles'
=> 'Diskussion über Ressource für folgende Rollen nicht gestatten:',

   'Disallow Resource Discussion for Users'
=> 'Diskussion über Ressource für folgende Benutzer nicht gestatten:',

   'Disallow chat room use for Roles'
=> 'Nutzungsmöglichkeit des Chatrooms für folgende Rollen nicht gestatten:',

   'Disallow chat room use for Users'
=> 'Besuchen des Chatrooms für folgende Benutzer nicht gestatten:',

   'Discussion Participation'
=> 'Diskussionsteilnahme',

   'Due Date (contentclose)'
=> 'Fälligkeitsdatum (contentclose)',

   'Due Date (duedate)'
=> 'Fälligkeitsdatum (duedate)',

   'Every problem in a particular folder (overrides course default)'
=> 'Jede Aufgabe in einen bestimmten Verzeichnis (überschreibt Kurs-Voreinstellung)',

   'Exit'
=> 'Beenden',

   'Feedback Addresses for Course Content'
=> 'Feedback-Adressen für Kursinhalt',

   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML kann innerhalb von Kursdiskussionen erlaubt oder verboten werden.',

   'HTML in Discussions'
=> 'HTML in Diskussionen',

   'Hide Empty Rows in Spreadsheets'
=> 'Leere Zeilen in den Beurteilungsbögen verbergen',

   'How many tries should be set for all problems in the course?'
=> 'Wie viele Versuche sollen für alle Aufgaben im Kurs gesetzt werden?',

   'How many tries should be set for the selected folder?'
=> 'Wie viele Versuche sollen für alle gewählten Verzeichnisse gesetzt werden?',

   'How many tries should be set for the selected problem?'
=> 'Wie viele Versuche sollen für die ausgewählte Aufgabe gesetzt werden?',

   'LON-CAPA has chat room functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA bietet Chatrooms an. Dieser Kurs wird seinen eigenen Chatroom erhalten. Sie können Studierenden, Tutoren oder Dozenten das Recht verweigern, den Chatroom zu nutzen.',

   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA bietet für alle Ressourcen des Kurses eine Diskussionsmöglichkeit an. In der Grundeinstellung dürfen allen Benutzer an diesen Diskussionen teilnehmen. Wenn Sie nicht wollen, dass bestimmte Arten von Benutzern an den Diskussionen teilnehmen sollen dürfen, wählen Sie diese unten aus. Beachten Sie, dass Ihr Kurs nicht jede Art von Benutzerrollen haben könnte. Sie können problemlos Rollen ignorieren, die Sie nicht verwenden wollen (Beispiel: Klausuraufsichtspersonal ist üblicherweise nur für sehr große Kurse hilfreich.) Benutzergruppen, die nicht an der Diskussion teilnehmen dürfen, können dennoch jede Diskussion der anderen Benutzer mitlesen.',

   'No section assigned'
=> 'Keiner Sektion zugewiesen',

   'Number of assignments printed at the same time:'
=> 'Anzahl von Übungen, die gleichzeitig gedruckt werden sollen:',

   'Opening Date (contentopen)'
=> 'Bearbeitungsbeginn-Datum (contentopen)',

   'Opening Date (opendate)'
=> 'Bearbeitungsbeginn-Datum (opendate)',

   'Please adjust significant figures.'
=> 'Bitte passen Sie die signifikanten Stellen an.',

   'Please select the section you wish to set the answer open date for:'
=> 'Bitte wählen Sie die Sektion, für die Sie das Antwort-Verfügbarkeits-Datum festlegen wollen:',

   'Please select the section you wish to set the due date for:'
=> 'Bitte wählen Sie die Sektion, für die Sie das Fälligkeitsdatum festlegen wollen:',

   'Please select the section you wish to set the number of tries for:'
=> 'Bitte wählen Sie die Sektion, für die Sie die Anzahl der Versuche festlegen wollen:',

   'Please select the section you wish to set the opening date for:'
=> 'Bitte wählen Sie die Sektion, für die Sie den Bearbeitungsbeginn festlegen wollen:',

   'Please select the section you wish to set the problem weight for:'
=> 'Bitte wählen Sie die Sektion, für die Sie die Aufgabengewichtung festlegen wollen:',

   'Please select the student you wish to set the answer open date for:'
=> 'Bitte wählen Sie den/die Studenten/in, für den/die Sie das Antwort-Verfügbarkeits-Datum festlegen wollen:',

   'Please select the student you wish to set the due date for:'
=> 'Bitte wählen Sie den/die Studenten/in, für den/die Sie das Fälligkeitsdatum festlegen wollen:',

   'Please select the student you wish to set the number of tries for:'
=> 'Bitte wählen Sie den /die Studenten/in, für den/die Sie die Anzahl der Versuche festlegen wollen:',

   'Please select the student you wish to set the opening date for:'
=> 'Bitte wählen Sie den /die Studenten/in, für den/die Sie den Bearbeitungsbeginn festlegen wollen:',

   'Please select the student you wish to set the problem weight for:'
=> 'Bitte wählen Sie den /die Studenten/in, für den/die Sie die Aufgabengewichtung festlegen wollen:',

   'Please select the group you wish to set the answer open date for:'
=> 'Bitte wählen Sie die Gruppe, für die Sie das Antwort-Verfügbarkeits-Datum festlegen wollen:',

   'Please select the group you wish to set the due date for:'
=> 'Bitte wählen Sie die Gruppe, für die Sie das Fälligkeitsdatum festlegen wollen:',

   'Please select the group you wish to set the number of tries for:'
=> 'Bitte wählen Sie die Gruppe, für die Sie die Anzahl der Versuche festlegen wollen:',

   'Please select the group you wish to set the opening date for:'
=> 'Bitte wählen Sie die Gruppe, für die Sie den Bearbeitungsbeginn festlegen wollen:',

   'Please select the group you wish to set the problem weight for:'
=> 'Bitte wählen Sie die Gruppe, für die Sie die Aufgabengewichtung festlegen wollen:',

   'Privileged users that should not be hidden on staff listings'
=> 'Privilegierte Nutzer, die auf Personallisten nicht verborgen werden sollen',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Zufallszahlen-Basis für zufällige Wahl der Ressourcen-Anzahl (optional. Setzen Sie dies nur, wenn Sie die Funktionalität verstehen) (randompickseed)',

   'Reading results from [_1]'
=> 'Lese Ergebnisse von [_1]',

   'Receipt algorithm used'
=> 'Verwendetes Verfahren für Nachweisnummern',

   'Receiving results from [_1]'
=> 'Erhalte Ergebnisse von [_1]',

   'Resources'
=> 'Ressourcen',

   'Search Complete on Server [_1]'
=> 'Suche abgeschlossen für Server [_1]',

   'Unable to retrieve search results. Unable to determine the table results were saved in.'
=> 'Suchergebnisse konnten nicht abgerufen werden. Es ist nicht möglich festzustellen, in welcher Tabelle die Ergebnisse gespeichert wurden.',

   'Search: [_1]'
=> 'Suche: [_1]',

   'Select All Files'
=> 'Alle Dateien auswählen',

   'Select All Published'
=> 'Alle veröffentlichten Ressourcen auswählen',

   'Select Folder'
=> 'Verzeichnis auswählen',

   'Select Only Current Students'
=> 'Nur aktuelle Studierende auswählen',

   'Select Problem'
=> 'Aufgabe auswählen',

   'Select Student'
=> 'Student/in auswählen',

   'Select student'
=> 'Student/in auswählen',

   'Select for Section/Group'
=> 'Auswahl für Sektion/Gruppe',

   'Select the folder you wish to set the parameter for:'
=> 'Wählen Sie das Verzeichnis, für den Sie den Parameter einstellen wollen:',

   'Select the problem you wish to set the parameter for:'
=> 'Wählen Sie die Aufgabe, für die Sie den Parameter einstellen wollen:',

   'Set Problem Tries'
=> 'Aufgaben-Versuche einstellen',

   'Set Problem Weight'
=> 'Aufgabengewichtung einstellen',

   'Set answer open date for all problems in the course for ...'
=> 'Setze Antwort-Verfügbarkeits-Datum aller Aufgaben des Kurses für...',

   'Set answer open date for the selected folder for ...'
=> 'Setze Antwort-Verfügbarkeits-Datum des ausgewählten Verzeichnisses für...',

   'Set answer open date for the selected problem for...'
=> 'Setze Antwort-Verfügbarkeits-Datum der ausgewählten Aufgabe für...',

   'Set due date for all problems in the course for ...'
=> 'Setze Fälligkeitsdatum aller Aufgaben des Kurses für...',

   'Set due date for the selected folder for ...'
=> 'Setze Fälligkeitsdatum des ausgewählten Verzeichnisses für...',

   'Set due date for the selected problem for ...'
=> 'Setze Fälligkeitsdatum der ausgewählten Aufgabe für...',

   'Set number of tries for all problems in the course for ...'
=> 'Setze Anzahl der Versuche aller Aufgaben des Kurses für...',

   'Set number of tries for the selected folder for ...'
=> 'Setze Anzahl der Versuche des ausgewählten Verzeichnisses für...',

   'Set number of tries for the selected problem for ...'
=> 'Setze Anzahl der Versuche der ausgewählten Aufgabe für...',

   'Set opening date for all problems in the course for ...'
=> 'Setze Bearbeitungsbeginn-Datum aller Aufgaben des Kurses für...',

   'Set opening date for the selected folder for ...'
=> 'Setzte Bearbeitungsbeginn-Datum des ausgewählten Verzeichnisses für...',

   'Set opening date for the selected problem for ...'
=> 'Setze Bearbeitungsbeginn-Datum der ausgewählten Aufgabe für...',

   'Set problem weight for all problems in the course for ...'
=> 'Setze Aufgabengewichtung aller Aufgaben des Kurses für...',

   'Set problem weight for the selected folder for ...'
=> 'Setze Aufgabengewichtung des ausgewählten Verzeichnisses...',

   'Set problem weight for the selected problem for ...'
=> 'Setze Aufgabengewichtung der ausgewählten Aufgabe für...',

   'Set value to [_1] to allow.'
=> '[_1], um zu erlauben.',

   'Setting the [_1]'
=> 'Eingestellt wird: [_1]',

   'Setting the [_1] to [_2]'
=> 'Einstellung ändern von [_1] auf [_2]',

   'The &quot;Course Title&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next&quot; to continue.'
=> 'Der &quot;Kurstitel&quot; ist der Name des Kurses, der von den Kursteilnehmern gesehen wird. Sie können diese Bezeichnung nun ändern und mit &quot;Weiter&quot; fortfahren',

   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'Die Antwort auf diese Frage kann niemals richtig werden. Die folgenden Auswahlmöglichkeiten im &lt;optionresponse&gt;-Tag beinhalten unzulässige richtige Optionen',

   'There are no currently enrolled students in the course.'
=> 'Es gibt keine Kursteilnehmer mit aktuellen Zugriff im Kurs.',

   'There are no currently enrolled students in the selected sections.'
=> 'Es gibt keine Kursteilnehmer mit aktuellen Zugriff in der ausgewählten Sektion.',

   'There are no previously enrolled students in the course.'
=> 'Es gibt keine Kursteilnehmer in der Vergangenheit im Kurs.',

   'There are no previously enrolled students in the selected sections.'
=> 'Es gibt keine Kursteilnehmer in der Vergangenheit in den ausgewählten Sektionen.',

   'There are no students with future access in the course.'
=> 'Es gibt keine Kursteilnehmer mit zukünftigem Kurszugriff im Kurs.',

   'There are no students with future access in the selected sections.'
=> 'Es gibt keine Kursteilnehmer mit zukünftigem Kurszugriff in den ausgewählten Sektionen.',

   'There are no students in the course.'
=> 'Es gibt keine Kursteilnehmer im Kurs.',

   'There are no students in the selected sections.'
=> 'Es gibt keine Kursteilnehmer in den ausgewählten Sektionen.',

   'This controls how receipt numbers are generated.'
=> 'Steuert die Erstellung der Nachweisnummern',

   'This controls how receipt numbers are generated'
=> 'Steuert die Erstellung der Nachweisnummern',

   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'Dieses Hilfsprogramm unterstützt Sie dabei, Ihren LON-CAPA-Kurs einzurichten und zu wählen, welche Einstellungen aktiv sein werden.',

   'Unselect All Files'
=> 'Auswahl für alle Dateien aufheben',

   'Unselect All Published'
=> 'Auswahl für alle veröffentlichten Dokumente aufheben',

   'Unselect All Resources'
=> 'Auswahl für alle Ressourcen aufheben',

   'Unselect for Section/Group'
=> 'Auswahl für Sektion/Gruppe aufheben',

   'Welcome to Your New LON-CAPA Course'
=> 'Willkommen in Ihrem neuen LON-CAPA-Kurs',

   'What parameter do you want to set for the selected folder?'
=> 'Welchen Parameter möchten Sie für das ausgewählte Verzeichnis setzen?',

   'What parameter do you want to set for the selected problem?'
=> 'Welchen Parameter möchten Sie für die ausgewählte Aufgabe setzen?',

   'What should the answer open date be set to?'
=> 'Auf welchen Wert soll das Antwort-Verfügbarkeits-Datum gesetzt werden?',

   'What should the due date be set to?'
=> 'Auf welchen Wert soll das Fälligkeitsdatum gesetzt werden?',

   'What weight should be set for all problems in the course?'
=> 'Auf welchen Wert soll die Gewichtung für alle Aufgaben im Kurs gesetzt werden?',

   'What weight should be set for the selected folder?'
=> 'Auf welchen Wert soll die Gewichtung für das ausgewählte Verzeichnis gesetzt werden?',

   'What weight should be set for the selected problem?'
=> 'Auf welchen Wert soll die Gewichtung der ausgewählten Aufgabe gesetzt werden?',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Authentifizierung über Dateisystem (mit Anfangspasswort [_2])',

   'Currently Filesystem Authenticated.'
=> 'Derzeit dateisystem-authentifiziert.',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] LON-CAPA-interne Authentifizierung (mit Anfangspasswort [_2])',

   'Currently internally authenticated.'
=> 'Derzeit LON-CAPA-intern authentifiziert.',

   'Records per Page:'
=> 'Suchergebnisse je Seite:',

   '[_1] with value [_2]'
=> '[_1] mit dem Wert [_2]',

   '[_1]/[_2]: [quant,_3,minute,minutes,] [quant,_4,second ,seconds ,]remaining ([quant,_5,second] for last student)'
=> '[_1]/[_2]: [quant,_3,min,min,] [quant,_4,s ,s ,]Restzeit ([quant,_5,s,s] für letzte/n Studenten/in)',

   '[_1]/[_2]: [quant,_3,minute,minutes,] [quant,_4,second ,seconds ,]remaining ([quant,_5,second] for last five students)'
=> '[_1]/[_2]: [quant,_3,min,min,] [quant,_4,s ,s ,]Restzeit ([quant,_5,s,s] für die letzten fünf Studierenden)',

   'all resources in the course'
=> 'alle Ressourcen des Kurses',

   'all students in course'
=> 'alle Studierenden des Kurses',

   'anonymous students'
=> 'Anonyme Studierende',

   'answer date'
=> 'Antwortdatum',

   'contacting [_1]'
=> 'kontaktiere [_1]',

   'due date'
=> 'Fälligkeitsdatum',

   'for'
=> 'für',

   'for [_1]all resources in the course[_2]'
=> 'für [_1]alle Ressourcen des Kurses[_2]',

   'for [_1]all students in course[_2]'
=> 'für [_1]alle Studierende des Kurses[_2]',

   'for [_1]'
=> 'für [_1]',

   'for section [_1]'
=> 'für den Sektion [_1]',

   'for the map named [_1]'
=> 'für die Inhaltszusammenstellung mit der Bezeichnung [_1]',

   'for the resource named [_1], part [_2]'
=> 'für die Ressource [_1], Aufgabenteil [_2]',

   'for the resource ID [_1] (name unavailable), part [_2]'
=> 'für die Ressource mit der ID [_1] (Name nicht verfügbar), Aufgabenteil [_2]',

   'from'
=> 'von',

   'from current subdirectory'
=> 'von derzeitigem Unterverzeichnis',

   'helper'
=> 'Hilfsprogramm',

   'Helper'
=> 'Hilfsprogramm',

   'in'
=> 'in',

   'instructor'
=> 'Dozent',

   'number of tries'
=> 'Anzahl der Versuche',

   'Number of Tries'
=> 'Anzahl der Versuche',

   'opening date'
=> 'Startdatum',

   'problem weight'
=> 'Aufgabengewichtung',

   'role,role,...'
=> 'Rolle,Rolle,...',

   'selected students'
=> 'ausgewählte Studierende',

   'to'
=> 'auf',

   'to [_1] ([_2])'
=> 'auf [_1] ([_2])',

   'waiting on [_1]'
=> 'warte auf [_1]',

   'what you just saw on the screen'
=> 'was Sie gerade auf dem Bildschirm gesehen haben',

   'Enter my portfolio space'
=> 'Portfolio',

   'No syllabus information provided.'
=> 'Kein Kursüberblick vorhanden',

   'Sorry ...'
=> 'Schade...',

   'This resource might be part of another course.'
=> 'Diese Ressource ist wahrscheinlich Bestandteil eines anderen Kurses.',

   'Agree'
=> 'Trifft eher zu',

   'Copy this column'
=> 'Kopiere diese Spalte',

   'Disagree'
=> 'Trifft eher nicht zu',

   'General Intro'
=> 'Allgemeine Einführung',

   'Greek Symbols'
=> 'Griechische Buchstaben',

   'HTML character entities'
=> 'HTML-Zeichencode',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'Wenn Sie sich diesen Text online ansehen, kopieren Sie den Eintrag in der rechten Spalte und fügen Sie ihn in den Texteingabebereich ein, um das entsprechende Symbol auf der linken Seite zu erhalten.',

   'LON-CAPA Help'
=> 'LON-CAPA-Hilfe',

   'Landscape'
=> 'Querformat',

   'Launch navigation window'
=> 'Navigationsfenster starten',

   'Grade Levels'
=> 'Kursniveau',

   'Lowest Grade Level'
=> 'Niedrigstes Kursniveau',

   'Lowest Grade Level:'
=> 'Niedrigstes Kursniveau:',

   'Highest Grade Level'
=> 'Höchstes Kursniveau',

   'Highest Grade Level:'
=> 'Höchstes Kursniveau:',

   'Mark all posts read'
=> 'Alle Diskussionsbeiträge als gelesen kennzeichnen',

   'Question/comment/feedback:'
=> 'Frage/Anmerkung/Feedback:',

   'Other Symbols'
=> 'Weitere Symbole',

   'Please check at least one of the following feedback types:'
=> 'Bitte wählen Sie eine der angebotenen Optionen:',

   'Please rank the following criteria:'
=> 'Bitte evaluieren Sie die folgenden Kriterien:',

   'Portrait'
=> 'Hochformat',

   'Question about resource content'
=> 'Frage zum Inhalt der Ressource',

   'Question/Comment/Feedback about course policy'
=> 'Frage/Anmerkung/Feedback zu Regeln des Kurses',

   'Question/Comment/Feedback about community policy'
=> 'Frage/Anmerkung/Feedback zu Regeln der Community',

   'Select a Course to Enter'
=> 'Wählen Sie den gewünschten Kurs aus',

   'Standards'
=> 'Standards',

   'Strongly Agree'
=> 'Trifft völlig zu',

   'Strongly Disagree'
=> 'Trifft überhaupt nicht zu',

   'Symbol'
=> 'Symbol',

   'The material appears to be correct'
=> 'Das Material scheint korrekt zu sein',

   'The material is helpful'
=> 'Das Material ist hilfreich',

   'The material is presented in a clear way'
=> 'Das Material wird in einer verständlichen Art dargestellt',

   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc)'
=> 'Die Ressource ist technisch einwandfrei (lädt ausreichend schnell, erzeugt keine Fehlermeldungen, verlinkte Seiten sind erreichbar, etc.)',

   '"Waiting for Remote Control window to load: "+[_1]'
=> '"Warte auf das Laden der Fernbedienung: "+[_1]',

   'HTML character enties'
=> 'HTML-Zeichen-Entitys',

   'All posts'
=> 'Alle Diskussionsbeiträge',

   'Change Color Scheme'
=> 'Farben',

   'Change Colors'
=> 'Farben',

   'Change Discussion Display Preferences'
=> 'Darstellung der Diskussionsbeiträge',

   'Change How Math Equations Are Displayed'
=> 'Darstellung wissenschaftlicher Formeln',

   'Change Language'
=> 'Sprache',

   'Change Language Preferences'
=> 'Sprache',

   'Change Password'
=> 'Passwort ändern',

   'Change Preferences'
=> 'Benutzereinstellungen', # 'Präferenzen ändern'

   'Change Roles Page Preferences'
=> 'Schnellzugriffsliste für Benutzerrollen',

   'Change Screen Name'
=> 'Nicknamen',

   'Change Screenname'
=> 'Nicknamen ändern',

   'Change WYSIWYG Editor Preferences'
=> 'WYSIWYG-Editor',

   'Contact Helpdesk'
=> 'Helpdesk kontaktieren',

   'Current discussion settings'
=> 'Einstellung für diesen Diskussionsbeitrag',

   'Due Date'
=> 'Fälligkeitsdatum',

   'Due date: [_1]'
=> 'Fällig am [_1]',

   'Each post can be toggled read/unread'
=> 'Jeder Diskussionsbeitrag kann zwischen als gelesen und als ungelesen umgeschaltet werden',

   "Edit the Personal Information Page"
=> "Persönliche Seite bearbeiten",

   'Enable WYSIWYG Editor'
=> 'WYSIWYG-Editor verwenden',

   'End of Sequence'
=> 'Ende der Sequenz',

   'Entering Course'
=> 'Betrete Kurs',

   'Get help'
=> 'Hilfe abrufen',

   'Go to main menu'
=> 'Zum Hauptmenü wechseln',

   'Has New Discussion'
=> 'Neue Diskussionsbeiträge',

   'Navigate Course Content'
=> 'Inhaltsverzeichnis',

   'New posts only'
=> 'Nur neue Diskussionsbeiträge',

   'No Resource'
=> 'Keine Ressource',

   'No syllabus available'
=> 'Kein Kursüberblick verfügbar',

   'Not currently assigned'
=> 'Derzeit nicht als Aufgabe gestellt',

   'Not new'
=> 'Nicht neu',

   'Off'
=> 'Aus',

   'On'
=> 'An',

   'Once displayed'
=> 'sobald angezeigt',

   'Once marked not NEW'
=> 'sobald als nicht NEU markiert',

   'Please click on the the resource you intend to access'
=> 'Bitte klicken Sie auf die Ressource, auf die Sie zugreifen wollen',

   'Posts cease to be marked "NEW"'
=> 'Beiträge nicht mehr als "NEU" kennzeichnen',

   'Posts to be displayed'
=> 'Diskussionsbeiträge, die angezeigt werden sollen',

   'Role selected. Please stand by.'
=> 'Rolle ausgewählt. Bitte warten.',

   'Course selected. Please stand by.'
=> 'Kurs ausgewählt. Bitte warten.',

   'Send'
=> 'Senden',

   'Set User Preferences'
=> 'Benutzereinstellungen',

   'Show Preview and Check Spelling'
=> 'Vorschau und Rechtschreibprüfung',

   'Sort by:'
=> 'Sortieren nach:',

   'Sorted by'
=> 'Sortiert nach',

   'There are several possibilities of where to go next'
=> 'Es gibt mehrere Möglichkeiten, wohin Sie als nächstes gehen können',

   'Toggle read/unread'
=> 'Umschalten zwischen gelesen/ungelesen',

   'Unread only'
=> 'Nur ungelesene',

   "View this user's personal information page"
=> "Persönliche Seite dieses Nutzers anzeigen",

   'You have reached the end of the sequence of materials.'
=> 'Sie haben das Ende der Sequenz von Lehrmaterialien erreicht.',

   'attachments'
=> 'Anhänge',

   'Personal Information Page for a User'
=> 'Persönliche Seite eines Benutzers',

   'All documents out of a published map into this folder'
=> 'Alle Dokumente aus einer veröffentlichten Inhaltszusammenstellung in dieses Verzeichnis',

   'Change Math Pref'
=> 'Darstellung wissenschaftl. Formeln',

   'Change Math Preferences'
=> 'Darstellung wissenschaftlicher Formeln',

   'Comment'
=> 'Kommentar',

   'Communication/Messages'
=> 'Kommunikation und Nachrichten',

   'Configure blocking of student communication during exams'
=> 'Blockieren von studentischer Kommunikation während Prüfungen konfigurieren',

   'Convert to Images'
=> 'In Grafik konvertieren',

   'Course and Catalog Search'
=> 'Kurs- und Katalog-Suche',

   'Create Subdirectory'
=> 'Unterverzeichnis erstellen',

   'Upload file to current directory'
=> 'Datei in aktuelles Verzeichnis laden',

   'Create subdirectory in current directory'
=> 'Im aktuellen Verzeichnis neues Unterverzeichnis erstellen',

   'Upload embedded images/multimedia/css/linked files if HTML file'
=> 'Bei HTML-Dateien: eingebettete Bilder/Multimedia-Dateien/CSS/verlinkte Dateien mit hochladen',

   'Delete Selected'
=> 'Ausgewählte löschen',

   'CRITICAL'
=> 'WICHTIG',

   'Currently no documents.'
=> 'Derzeit keine Dokumente',

   'Enter terms or phrases, then press "Search" below'
=> 'Geben Sie Suchbegriffe oder -Sätze ein und klicken Sie dann unten auf "Suchen"',

   'INBOX'
=> 'POSTEINGANG',

   'Upload embedded images/multimedia files if HTML file'
=> 'Bei HTML-Dateien: eingebettete Bilder und Multimedia-Dateien mit hochladen',

   'IMS Import'
=> 'IMS-Import',

   'Import IMS package'
=> 'IMS-Paket importieren',

   'IMS Export'
=> 'IMS-Export',

   'Export Course to IMS Package'
=> 'Kurs als IMS-Paket exportieren',

   'Export content item?'
=> 'Inhaltselement exportieren?',

   'Export discussion posts?'
=> 'Diskussionsbeitrag exportieren?',

   'As you did not select any content items or discussions for export, an IMS package has not been created.'
=> 'Da Sie weder Inhaltselemente noch Diskussionsbeiträge zum Exportieren ausgewählt haben, wurde kein IMS-Paket erstellt.',

   'Please [_1]go back[_2] to select either content items or discussions for export.'
=> 'Bitte gehen Sie [_1]zurück[_2], um Inhaltselemente und Diskussionsbeiträge zum Exportieren auszuwählen.',

   '[_1]Your IMS package[_2] is ready for download.'
=> '[_1]Ihr IMS-Paket[_2] steht zum Download bereit.',

   'Import a document'
=> 'LON-CAPA-interne Dokumente',

   'New Composite Page'
=> 'Neue zusammengesetzte Seite',

   'New Messages Only'
=> 'Nur neue Nachrichten',

   'Portfolio Manager'
=> 'Portfolio-Verwaltung',

   'Preferred method to display Math'
=> 'Bevorzugte Methode, um wissenschaftliche Formeln darzustellen',

   'Preferred method to display math'
=> 'Bevorzugte Methode, um wissenschaftliche Formeln darzustellen',

   'Change how math is displayed'
=> 'Darstellung wissenschaftlicher Formeln ändern',

   'Change how math is displayed.'
=> 'Darstellung wissenschaftlicher Formeln ändern.',

   'Published documents'
=> 'Veröffentlichte Dokumente',

   'Recover Deleted Documents'
=> 'Gelöschte Dokumente wiederherstellen',

   'Send a Message'
=> 'Nachricht versenden',

   'SENT MESSAGES'
=> 'GESENDET',

   'Show'
=> 'Zeige',

   'show'
=> 'anzeigen',

   '(Show path)'
=> '(Pfad anzeigen)',

   'TRASH'
=> 'GELÖSCHT',

   'TeX to HTML'
=> 'TeX-nach-HTML',

   'Save uploaded file as'
=> 'Hochgeladene Datei speichern unter',

   'Upload'
=> 'Hochladen',

   'Upload:'
=> 'Hochladen:',

   'File [_1] already exists.'
=> 'Die Datei [_1] existiert bereits.',

   'Overwrite'
=> 'Überschreiben',

   'Overwrite?'
=> 'Überschreiben?',

   'View Folder'
=> 'Verzeichnis betrachten',

   'fulltext search (time consuming)'
=> 'Volltextsuche (zeitaufwändig)',

   'search discussion postings (resources and discussion boards)'
=> 'Suche in Diskussionsbeiträgen (Ressourcen und Diskussionsforen)',

   'Roles'
=> 'Rollen',

   'Select style file'
=> 'Style-Datei auswählen',

   '(mark them then click "next" button)'
=> '(markieren und dann auf "Weiter" klicken)',

   '100 Level'
=> '1. Studienjahr',

   '200 Level'
=> '2. Studienjahr',

   '300 Level'
=> '3. Studienjahr',

   '400 Level'
=> '4. Studienjahr',

   'Action'
=> 'Aktion',

   'Actions for current directory'
=> 'Aktionen für dieses Verzeichnis',

   'Change Discussion Preferences'
=> 'Präferenzen für Diskussionen ändern',

   'Change Message Forwarding/Notification'
=> 'Nachrichtenweiterleitung und Benachrichtigung',

   'Change WYSIWYG Preferences'
=> 'WYSIWYG-Editor',

   'Change to '
=> 'Ändern in ',

   'Clean Up'
=> 'Aufräumen',

   'Clean up'
=> 'Aufräumen',

   'Clean up of file not allowed.'
=> 'Aufräumen der Datei ist nicht zulässig.',

   'Closed - XML source is closed to everyone'
=> 'Gesperrt - XML-Quellcode ist für alle gesperrt',

   'Copy'
=> 'Kopieren',

   'Create a new directory or LON-CAPA document'
=> 'Neue Ressource oder neues Verzeichnis erstellen',

   'Current setting '
=> 'Derzeitige Einstellung ',

   'Delete Directory'
=> 'Verzeichnis löschen',

   'Delete directory'
=> 'Verzeichnis löschen',

   'Delete this resource'
=> 'Ressource löschen', # long version: 'Lösche diese Ressource',

   'Disable WYSIWYG editor'
=> 'WYSIWYG-Editor nicht verwenden',

   'Enable WYSIWYG editor'
=> 'WYSIWYG-Editor verwenden',

   'The WYSIWYG editor only supports simple HTML and is in many cases unsuited for advanced authoring. In a number of cases, it may destroy advanced authoring involving LaTeX and script function calls.'
=> 'Der WYSIWYG-Editor unterstützt nur einfaches HTML und ist in vielen Fällen für fortgeschrittene Autorentätigkeiten nicht geeignet. In manchen Fällen kann er LaTeX- und Skript-Funktions-Aufrufe zerstören.',

   'Display Preference'
=> 'Darstellungs-Präferenz',

   'Grade 1'
=> '1. Klasse',

   'Grade 10'
=> '10. Klasse',

   'Grade 11'
=> '11. Klasse',

   'Grade 12'
=> '12. Klasse',

   'Grade 13'
=> '13. Klasse',

   'Grade 2'
=> '2. Klasse',

   'Grade 3'
=> '3. Klasse',

   'Grade 4'
=> '4. Klasse',

   'Grade 5'
=> '5. Klasse',

   'Grade 6'
=> '6. Klasse',

   'Grade 7'
=> '7. Klasse',

   'Grade 8'
=> '8. Klasse',

   'Grade 9'
=> '9. Klasse',

   'Graduate Level'
=> 'Graduierten-Niveau',

   'List current directory'
=> 'Verzeichnis', # long version: 'Aktuelles Verzeichnis anzeigen',

   'Mark obsolete'
=> 'Als veraltet kennzeichnen',

   'Move'
=> 'Verschieben',

   'New library file'
=> 'Neue Programmbibliotheks-Datei',

   'No file: [_1]'
=> 'Datei nicht vorhanden: [_1]',

   'No personal information provided'
=> 'Keine Informationen zur Person zur Verfügung gestellt',

   'Not specified'
=> 'Nicht angegeben',

   'Open - XML source is open to people who want to use it'
=> 'Lesbar - XML-Quellcode ist für interessierte Autoren lesbar',

   'Points Display'
=> 'Anzeige erreichter Punkte',

   'Completed Problems Display'
=> 'Anzeige abgeschlossener Aufgaben',

   'Points Scored'
=> 'Erreichte Punkte',

   'Attempted'
=> 'Versucht',

   'Posts displayed?'
=> 'Welche Beiträge sollen angezeigt werden?',

   'Preferences can be set that determine'
=> 'Präferenzen können eingestellt werden, die festlegen...',

   'Print directory'
=> 'Verzeichnis drucken',

   'Problem Document'
=> 'Aufgaben-Dokument',

   'Hypertext Document'
=> 'HTML-Dokument',

   'GIF Image Document'
=> 'Bilddatei (GIF)',

   'General XML Document'
=> 'Allgemeines XML-Dokument',

   'JPEG Image Document'
=> 'Bilddatei (JPEG)',

   'PNG Image Document'
=> 'Bilddatei (PNG)',

   'Portable Data Format Document'
=> 'PDF-Datei',

   'Text (Plain) Document'
=> 'Einfache Textdatei',

   'Java Jar File'
=> 'Java-Jar-Datei',

   'Library of Functions File'
=> 'Datei mit Funktionen-Bibliothek',

   'Macromedia Flash Format'
=> 'Macromedia-Flash-Format',

   'Wav Sound Document'
=> 'WAV-Sound-Datei',

   'Publish this Directory'
=> 'Dieses Verzeichnis veröffentlichen',

   'Publish this resource'
=> 'Veröffentlichen', # long version: 'Diese Ressource veröffentlichen',

   'Re-publish'
=> 'Neu veröffentlichen',

   'Retrieve old version'
=> 'Alte Version wiederherstellen',

   'Select action'
=> 'Aktion auswählen',

   'Send message'
=> 'Nachricht versenden',

   'Set display preferences for discussion posts for both discussion boards and individual resources in all your courses.'
=> 'Hier können Sie festlegen, wie Diskussionsbeiträge, Nachrichten in Diskussionsforen und einzelne Ressourcen in allen Ihren Kursen angezeigt werden sollen.',

   'Source Distribution'
=> 'Zugriffsrechte auf Quellcode',

   'Under what circumstances posts are identified as "NEW"'
=> 'unter welchen Bedingungen Beiträge als "NEU" identifiziert werden',

   'Upload a new document'
=> 'Externes Dokument hochladen',

   'Upload a new main course document'
=> 'Neues Haupt-Kursdokument hochladen',

   'Upload a new main community document'
=> 'Neues Haupt-Community-Dokument hochladen',

   'Upload a new supplemental course document'
=> 'Neues zusätzliches Kursdokument hochladen',

   'Upload a new supplemental community document'
=> 'Neues zusätzliches Community-Dokument hochladen',

   'Use random seed'
=> 'Zufallszahlen-Basis',

   'Use random seed:'
=> 'Zufallszahlen-Basis:',

   'Use style file'
=> 'Verwende Style-Datei',

   'Use style file:'
=> 'Verwende Style-Datei:',

   'Which posts are displayed when you display a discussion board or resource, and'
=> 'welche Nachrichten angezeigt werden, wenn Sie ein Diskussionsforum bzw. eine Ressource anzeigen',

   'Source: closed'
=> 'Quellcode: gesperrt',

   'Source: open'
=> 'Quellcode: einsehbar',

   '(mark desired resources then click "next" button)'
=> '(Markieren Sie gewünschte Ressourcen und klicken Sie dann auf "Weiter".)',

   '[_1]Change[_2] for just [_3]this course[_4] or for [_5]all your courses/communities[_6].'
=> '[_1]Ändern:[_2] nur für [_3]diesen Kurs[_4] oder für [_5]alle Ihre Kurse/Communitys[_6].',

   '[_1]Change[_2] for just [_3]this community[_4] or for [_5]all your courses/communities[_6].'
=> '[_1]Ändern:[_2] nur für [_3]diese Community[_4] oder für [_5]alle Ihre Kurse/Communitys[_6].',

   "Page displayed after role selection in course now set by [_1]user's global preferences[_2]."
=> "Seite, die nach Betreten des Kurses angezeigt werden soll, wird nun durch Ihre [_1]allgemeinen Benutzereinstellungen[_2] gesteuert.",

   "Page displayed after role selection in community now set by [_1]user's global preferences[_2]."
=> "Seite, die nach Betreten der Community angezeigt werden soll, wird nun durch Ihre [_1]allgemeinen Benutzereinstellungen[_2] gesteuert.",

   'Page displayed after role selection in this course set to [_1].'
=> 'Seite, die nach Betreten des Kurses angezeigt werden soll, wurde auf [_1] gesetzt.',

   'Page displayed after role selection in this community set to [_1].'
=> 'Seite, die nach Betreten der Community angezeigt werden soll, wurde auf [_1] gesetzt.',

   'Unable to set control of page display to [_1] due to [_2].'
=> 'Setzen der Seitenanzeige-Einstellungen auf [_1] war nicht möglich aufgrund von [_2].',

   'Unable to set control of page display to [_1]'
=> 'Setzen der Seitenanzeige-Einstellungen auf [_1] war nicht möglich.',

   'Unable to set page display, after role selection, for this course to [_1] due to [_2].'
=> 'Setzen der Seitenanzeige-Einstellungen nach Rollenauswahl für diesen Kurs auf [_1] war nicht möglich aufgrund von [_2].',

   'Unable to set page display, after role selection, for this community to [_1] due to [_2].'
=> 'Setzen der Seitenanzeige-Einstellungen nach Rollenauswahl für diese Community auf [_1] war nicht möglich aufgrund von [_2].',

   'Add or Edit Blog Entries'
=> 'Blog-Einträge hinzufügen oder bearbeiten',

   'Add to my public course blog'
=> 'Zu meinem öffentlichen Kurs-Blog hinzufügen',

   'Add to my public community blog'
=> 'Zu meinem öffentlichen Community-Blog hinzufügen',

   'Annotator'
=> 'Notizen',

   'Av. Attempts'
=> 'Mittlere Anzahl an Versuchen',

   'An RSS Feed provided by the LON-CAPA Learning Content Management System'
=> 'Ein RSS-Feed, das vom LON-CAPA-Learning-Content-Management-System angeboten wird',

   'Available RSS Feeds and Blogs'
=> 'Verfügbare RSS-Feeds und Blogs',

   'New RSS Feed or Blog'
=> 'Neuer RSS-Feed oder Blog',

   'New Feed'
=> 'Neuer Feed',

   'Average number of attempts'
=> 'Durchschnittliche Anzahl an Versuchen',

   'Bookmarks'
=> 'Lesezeichen',

   'Change interval?'
=> 'Intervall ändern',

   'Change options?'
=> 'Optionen ändern',

   'Change thresholds?'
=> 'Schwellenwerte ändern',

   'Close Folder'
=> 'Verzeichnis schließen',

   'Configure Blocking of Student Communication during Exams'
=> 'Kommunikationssperre einrichten', # 'Blockieren studentischer Kommunikation während Prüfungen konfigurieren',

   'Configure blocking of communication/collaboration and access to resources during an exam'
=> 'Konfiguration der Zugriffssperre für Kommunikation und Zusammenarbeit und für den Zugriff auf Ressourcen während einer Prüfung',

   'Blocking of student communication during exams.'
=> 'Kommunikationssperre für Studierende während Prüfungen.',

   'Communication Blocked'
=> 'Kommunikation gesperrt',

   'Communication Blocking Status Information'
=> 'Statusinformationen der Kommunikationssperren',

   'Currently active communication blocks'
=> 'Momentan aktive Kommunikationssperren',

   'Currently active communication/content blocks'
=> 'Momentan aktive Kommunikations-/Inhaltssperren',

   'Block set by'
=> 'Sperre gesetzt von',

   '[_1] to [_2]'
=> '[_1] bis [_2]',

   "Group portfolio in the course '[_1]' will be inaccessible between [_2] and [_3] because communication is being blocked."
=> "Auf das Gruppen-Portfolio für '[_1]' kann zwischen [_2] und [_3] nicht zugegriffen werden, da die Kommunikationsmöglichkeit für diese Zeit gesperrt wurde.",

   'Portfolio files belonging to [_1] will be inaccessible between [_2] and [_3] because communication is being blocked.'
=> 'Auf die Portfolio-Dateien von [_1] kann zwischen [_2] und [_3] nicht zugegriffen werden, da die Kommunikationsmöglichkeit für diese Zeit gesperrt wurde.',

   'Your portfolio files will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Auf Ihre Portfolio-Dateien kann zwischen [_1] und [_2] nicht zugegriffen werden, da die Kommunikationsmöglichkeit für diese Zeit gesperrt wurde.',

   'Discussion posts in this course will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Auf Diskussionsbeiträge kann zwischen [_1] und [_2] nicht zugegriffen werden, da die Kommunikationsmöglichkeit für diese Zeit gesperrt wurde.',

   'Chat will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Auf den Chat kann zwischen [_1] und [_2] nicht zugegriffen werden, da die Kommunikationsmöglichkeit für diese Zeit gesperrt wurde.',

   'This message will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Auf diese Nachricht kann zwischen [_1] und [_2] nicht zugegriffen werden, da die Kommunikationsmöglichkeit für diese Zeit gesperrt wurde.',

   'Blogs will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Auf Blogs kann zwischen [_1] und [_2] nicht zugegriffen werden, da die Kommunikationsmöglichkeit für diese Zeit gesperrt wurde.',

   'Groups in this course will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Auf Gruppen kann zwischen [_1] und [_2] nicht zugegriffen werden, da die Kommunikationsmöglichkeit für diese Zeit gesperrt wurde.',

   'Communication will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Auf Kommunikation kann zwischen [_1] und [_2] nicht zugegriffen werden, da die Kommunikationsmöglichkeit für diese Zeit gesperrt wurde.',

   'Creating PDF'
=> 'Erstellung PDF-Datei',

   'Creating PDF for: [_1]'
=> 'Erstelle PDF-Datei für [_1]',

   'Currently: [_1].'
=> 'Zur Zeit: [_1]',

   'Deg. Diff'
=> 'Schwierigkeitsgrad',

   'Description'
=> 'Beschreibung',

   'Enter my groups in the course'
=> 'Meine Kursgruppen',

   'Entering [_1]'
=> 'Betrete [_1]',

   'Entering [_1] ...'
=> 'Betrete [_1]...',

   'First resource'
=> 'Erste Ressource',

   'Generated [_1] ([_2] bytes)'
=> 'Estellt am [_1] ([_2] Bytes)',

   'Generated on [_1]'
=> 'Erstellt am [_1]',

   'Go to first resource'
=> 'Gehe zur ersten Ressource',

   'Group Documents'
=> 'Gruppen-Dokumente',

   'Groups'
=> 'Gruppen',

   'Help Menu'
=> 'Hilfemenü',

   'Hide all'
=> 'Alle verbergen',

   'Hide this Feed'
=> 'Diesen Feed verbergen',

   'LON-CAPA Feed "[_1]" for [_2]'
=> 'LON-CAPA-Feed "[_1]" für [_2]',

   'Last Reset'
=> 'Letzte Zurücksetzung',

   'Last revised'
=> 'Letzte Änderung',

   'Link'
=> 'Link',

   'Log In'
=> 'Anmelden',

   'Move Checked to Folder'
=> 'Verschiebe Auswahl in Verzeichnis',

   'Name for New Feed'
=> 'Name des neuen Feed',

   'Name of this Feed'
=> 'Name dieses Feeds',

   'New course messages'
=> 'Neue Kursnachrichten',

   'New critical messages in course'
=> 'Neue wichtige Kursnachrichten',

   'New community messages'
=> 'Neue Community-Nachrichten',

   'New critical messages in community'
=> 'Neue wichtige Community-Nachrichten',

   'New in course'
=> 'Neu im Kurs',

   'New version'
=> 'Neue Version',

   'No messages sent.'
=> 'Keine Nachrichten verschickt.',

   'No new course messages'
=> 'Keine neuen Kursnachrichten',

   'No new community messages'
=> 'Keine neuen Community-Nachrichten',

   'No unread critical messages in course'
=> 'Keine ungelesenen wichtigen Kursnachrichten',

   'No unread critical messages in community'
=> 'Keine ungelesenen wichtigen Community-Nachrichten',

   'No problems require handgrading'
=> 'Keine Aufgaben müssen manuell bewertet werden',

   'No problems satisfy threshold criteria'
=> 'Keine Aufgaben erfüllen die Schwellenkriterien',

   'No problems with errors'
=> 'Keine Aufgaben mit Fehlern',

   'No unread posts in course discussions'
=> 'Keine ungelesenen Beiträge in Kursdiskussionsforen',

   'No unread posts in community discussions'
=> 'Keine ungelesenen Beiträge in Community-Diskussionsforen',

   'No updated versions'
=> 'Keine aktualisierten Versionen',

   'Num. students'
=> 'Studierendenanzahl',

   'Number of errors'
=> 'Fehleranzahl',

   'Number of new posts'
=> 'Anzahl neuer Diskussionsbeiträge',

   'Number ungraded'
=> 'Anzahl Unbewerteter',

   'Open Folder'
=> 'Verzeichnis öffnen',

   'Page set to be displayed after you have selected a role in this course'
=> 'Seite, die angezeigt werden soll, nachdem Sie eine Rolle in diesem Kurs ausgewählt haben',

   'Page set to be displayed after you have selected a role in this community.'
=> 'Seite, die angezeigt werden soll, nachdem Sie eine Rolle in dieser Community ausgewählt haben.',

   'Page set to be displayed after you have selected a role in this course.'
=> 'Seite, die angezeigt werden soll, nachdem Sie eine Rolle in diesem Kurs ausgewählt haben.',

   'Please select the type of LON-CAPA entity - Course or Group - for which you wish to add/modify a user role'
=> 'Bitte wählen Sie den Typ der LON-CAPA-Entität - Kurs oder Gruppe - für den Sie die Benutzerrolle hinzufügen/ändern wollen.',

   'Please stand by while processing your print request, this may take some time ...'
=> 'Ihr Druckauftrag wird bearbeitet. Dies kann einige Zeit dauern. Bitte warten Sie...',

   'Print contents of directory'
=> 'Inhalte des Verzeichnisses drucken',

   'Problem'
=> 'Aufgabe',

   'Problem Name'
=> 'Aufgabenbezeichnung',

   'Problem is not open to be viewed. It' # ??? bridgetask.pm, structuretags.pm
=> 'Aufgabe nicht zur Betrachtung freigegeben. Es',

   'Problems requiring handgrading'
=> 'Aufgaben, die manuell bewertet werden müssen',

   '(Problems with av. attempts &ge; [_1] or deg. difficulty &ge; [_2]) [_3] and total number of students with submissions &ge; [_4]'
=> '(Aufgaben mit durchschnittlicher Anzahl an Versuchen &ge; [_1] oder Schwierigkeitsgrad &ge; [_2]) [_3] und insgesamte Anzahl Studierender, die etwas eingereicht haben &ge; [_4]',

   '(Problems with av. attempts &ge; [_1] or deg. difficulty &ge; [_2]) [_3] and total number of members with submissions &ge; [_4]'
=> '(Aufgaben mit durchschnittlicher Anzahl an Versuchen &ge; [_1] oder Schwierigkeitsgrad &ge; [_2]) [_3] und insgesamte Anzahl an Mitgliedern, die etwas eingereicht haben &ge; [_4]',

   'Problems with errors'
=> 'Aufgaben mit Fehlern',

   'Recently generated printouts'
=> 'Zuletzt erstellte Ausdrucke',

   'Recently generated printout zip files'
=> 'Zuletzt erstellte ZIP-Dateien',

   'Reset Count?'
=> 'Zähler zurücksetzen?',

   'Reset counters to 0'
=> 'Zähler auf 0 zurücksetzen',

   'Select [_1]'
=> 'Wähle [_1]',

   'Select the sequence to print resources from:'
=> 'Wählen Sie die Sequenz, aus der Ressourcen gedruckt werden sollen:',

   'Selected [_1]Problems[_2] from folder [_3]'
=> 'Bestimmte [_1]Aufgaben[_2] aus dem Verzeichnis [_3]',

   'Selected  [_1]Incomplete Problems[_2] from folder [_3]'
=> 'Bestimmte [_1]unerledigte Aufgaben[_2] aus dem Verzeichnis [_3]',

   'Selected [_1]Resources[_2] from folder [_3]'
=> 'Bestimmte [_1]Ressourcen[_2] aus dem Verzeichnis [_3]',

   'Selected Problems from entire course'
=> 'Bestimmte <b>Aufgaben</b> des <b>gesamten Kurses</b>',

   'Selected Resources from entire course'
=> 'Bestimmte <b>Ressourcen</b> des <b>gesamten Kurses</b>',

   'Selected Problems from entire course for selected people'
=> 'Bestimmte <b>Ressourcen</b> des <b>gesamten Kurses</b> für <b>bestimmte Personen</b>',

   'Selected Incomplete Problems from entire course for selected people'
=> 'Bestimmte <b>ungelöste Aufgaben</b> des <b>gesamten Kurses</b> für <b>bestimmte Personen</b>',

   'Selected [_1]Problems[_2] from folder [_3] for [_4]selected people[_5]'
=> 'Bestimmte [_1]Aufgaben[_2] aus dem Verzeichnis [_3] für [_4]bestimmte Personen[_5]',

   'Selected  [_1]Incomplete Problems[_2] from folder [_3] for selected students'
=> 'Bestimmte [_1]ungelöste Aufgaben[_2] aus dem Verzeichnis [_3] für bestimmte Studierende',

   'Selected [_1]Problems[_2] from folder [_3] for [_4]CODEd assignments[_5]'
=> 'Bestimmte [_1]Aufgaben[_2] aus dem Verzeichnis [_3] für [_4]mit CODE versehene Übungen[_5]',

   'Selected [_1]Resources[_2] from folder [_3] for [_4]selected people[_5]'
=> 'Bestimmte [_1]Ressourcen[_2] aus dem Verzeichnis [_3] für [_4]bestimmte Personen[_5]',

   'Selected [_1]Resources[_2] from folder [_3] for [_4]CODEd assignments[_5]'
=> 'Bestimmte [_1]Ressourcen[_2] aus dem Verzeichnis [_3] für [_4]mit CODE versehene Übungen[_5]',

   'Selected [_1]Problems[_2] from page [_3] for [_4]CODEd assignments[_5]'
=> 'Bestimmte [_1]Aufgaben[_2] von der Seite [_3] für [_4]mit CODE versehene Übungen[_5]',

   'Selected [_1]Problems[_2] from current subdirectory [_3]'
=> 'Bestimmte [_1]Aufgaben[_2] aus aktuellem Unterverzeichnis [_3]',

   'Selected [_1]Problems[_2] from page [_3] for [_4]selected people[_5]'
=> 'Bestimmte [_1]Aufgaben[_2] der Seite [_3] für [_4]bestimmte Personen[_5]',

   'Selected Resources from selected folder in course'
=> 'Bestimmte <b>Ressourcen</b> aus </b>bestimmtem Verzeichnis</b> im Kurs',

   'Send Message'
=> 'Nachricht senden',

   'Send Feedback'
=> 'Feedback geben',

   'Show all'
=> 'Alle anzeigen',

   'Show my first due problem'
=> 'Zeige meine erste zu bearbeitende Aufgabe',

   'Show only uncompleted problems'
=> 'Zeige nur nicht erledigte Aufgaben',

   'Show everything'
=> 'Alles anzeigen',

   'Uncompleted Problems'
=> 'Nicht erledigte Aufgaben',

   'All homework assignments have been completed.'
=> 'Alle Übungsaufgaben sind erledigt.',

   'Speller Suggestions'
=> 'Alternativvorschläge der Rechtschreibprüfung',

   'Start a New Feed'
=> 'Neuen Feed starten',

   'Save Marked Changes'
=> 'Markierte Änderungen speichern',

   'Save changes'
=> 'Änderungen speichern',

   'The preferences you set here can be overridden within each individual discussion.'
=> 'Die hier einstellbaren Präferenzen können innerhalb jedes einzelnen Diskussionsbeitrages geändert werden.',

   'This action is currently not authorized.'
=> 'Diese Aktion ist momentan nicht erlaubt.',

   'Time of last post'
=> 'Uhrzeit des letzten Beitrags',

   'Title of document goes here'
=> 'Dokumententitel hier eintragen',

   'Body of document goes here'
=> 'Hauptinhalt des Dokuments kommt hier hin',

   'Total number of students with submissions'
=> 'Gesamtanzahl an Studierenden, die etwas eingereicht haben',

   'Unread course discussion posts'
=> 'Ungelesene Kursdiskussionsbeiträge',

   'Unread community discussion posts'
=> 'Ungelesene Community-Diskussionsbeiträge',

   'Version used'
=> 'verwendete Version',

   'View current problem status and grading information'
=> 'Bewertungs-Informationen',

   "What's New?"
=> "Was gibt's Neues?",

   "What's New"
=> "Was gibt's Neues",

   "What's New Page"
=> "Was-gibt's-Neues-Seite",

   'You are accessing an invalid course'
=> 'Sie versuchen auf einen ungültigen Kurs zuzugreifen.',

   'course only'
=> 'nur Kurs',

   'delete'
=> 'Löschen',

   'first resource in the course'
=> 'erste Kursressource',

   'first resource in the community'
=> 'erste Community-Ressource',

   'hidden'
=> 'verborgen',

   'since last month'
=> 'seit letztem Monat',

   'since last week'
=> 'seit letzter Woche',

   'since start of course'
=> 'seit Kursbeginn',

   'since yesterday'
=> 'seit gestern',

   'specific setting for this course'
=> 'bestimmte Einstellung für diesen Kurs',

   'specific setting for this community'
=> 'bestimmte Einstellung für diese Community',

   'user preference'
=> 'Benutzerpräferenz',

   'your general user preferences'
=> 'Ihre allgemeinen Benutzerpräferenzen',

   'Submitting as Comment'
=> 'Kommentar wird gesendet',

   'Submitting as Policy Feedback'
=> 'Feedback zu Kursrichtlinien wird gesendet',

   'Submitting as Question'
=> 'Frage wird gesendet',

   'the resource you just saw on the screen'
=> 'die zuletzt betrachtete Ressource',

   'Annotations'
=> 'Notizen',

   'Save and Update'
=> 'Speichern und aktualisieren',

   'Bookmark Tree Viewer/Editor'
=> 'Lesezeichenbaum-Anzeige/Editor',

   'Chat'
=> 'Chat',

   'Chat Room'
=> 'Chatroom',

   'Import Bookmarks'
=> 'Lesezeichen importieren',

   'The LearningOnline Network with CAPA'
=> 'The LearningOnline Network with CAPA',

   'This LON-CAPA server is temporarily not available for login.'
=> 'Dieser LON-CAPA-Server steht vorübergehend zum Login nicht zur Verfügung.',

   'Please attempt to login to one of the following servers:'
=> 'Bitte versuchen Sie sich an einem der folgenden Server anzumelden:',

   '(preferred)'
=> '(bevorzugt)',

   'Collaborative Tools'
=> 'Kollaborative Werkzeuge',

   'Course content'
=> 'Kursinhalt',

   'Create a new group'
=> 'Neue Gruppe erstellen',

   'Created'
=> 'Erstellt',

   'Creator'
=> 'Ersteller',

   'Discussion Boards'
=> 'Diskussionsforen',

   'Disk Use (%)'
=> 'Speicherplatzverbrauch (%)',

   'Files'
=> 'Dateien',

   'Group Name'
=> 'Gruppenname',

   'Group name:'
=> 'Gruppenname:',

   'Group Title'
=> 'Gruppentitel',

   'Members'
=> 'Mitglieder',

   'Modify'
=> 'Verändern',

   'Re-enable'
=> 'Wiederherstellen',

   'Re-enabled'
=> 'Wiederhergestellt',

   'Expire'
=> 'Ablaufen lassen',

   'Group settings'
=> 'Gruppen-Einstellungen',

   'Modify group membership'
=> 'Gruppen-Mitgliedschaften ändern',

   'No groups exist.'
=> 'Es existieren keine Gruppen.',

   'Number of roles in Hotlist:'
=> 'Anzahl der Rollen in Schnellzugriffsliste:',

   'Quota (MB)'
=> 'Speicherplatz (MB)',

   'Some LON-CAPA users have a long list of roles. The Recent Roles Hotlist feature keeps track of the last N roles which have been visited and places a table of these at the top of the roles page. People with very few roles should leave this feature disabled.'
=> 'Einige LON-CAPA-Benutzer haben sehr viele Rollen. Der Schnellzugriff auf zuletzt verwendete Rollen speichert die letzten n Rollen, die Sie verwendet haben und bietet Ihnen eine Liste mit diesen Rollen am Anfang Ihrer Rollenauswahlseite. Benutzer mit nur wenigen Rollen sollten diese Schnellzugriffsliste deaktiviert lassen.',

   'Some LON-CAPA users have a long list of courses. The Recent Courses Hotlist feature keeps track of the last N courses which have been visited and places a table of these at the top of the courses page. People with very few courses should leave this feature disabled.'
=> 'Einige LON-CAPA-Benutzer haben sehr viele Kurse belegt. Der Schnellzugriff auf zuletzt verwendete Kurse speichert die letzten n Kurse, die Sie verwendet haben und bietet Ihnen eine Liste mit diesen Kursen am Anfang Ihrer Kursauswahlseite. Benutzer mit nur wenigen Kursen sollten diese Schnellzugriffsliste deaktiviert lassen.',

   'When enabled, the Hotlist keeps track of the last N roles visited.'
=> 'Bei Aktivierung speichert der Schnellzugriff auf zuletzt verwendete Rollen die letzten n Rollen, die Sie verwendet haben.',

   'When enabled, the Hotlist keeps track of the last N courses visited.'
=> 'Bei Aktivierung speichert der Schnellzugriff auf zuletzt verwendete Kurse die letzten n Kurse, die Sie verwendet haben.',

   'LON-CAPA users with several roles may wish to enable the Hotlist.'
=> 'LON-CAPA-Benutzern mit vielen Rollen wird empfohlen, die Schnellzugriffsliste zu aktivieren.',

   'LON-CAPA users with several courses may wish to enable the Hotlist.'
=> 'LON-CAPA-Benutzern mit vielen Kursen wird empfohlen, die Schnellzugriffsliste zu aktivieren.',

   'Once the Hotlist contains recently visited roles you can return to this page to also set frozen roles.'
=> 'Sobald die Schnellzugriffsliste kürzliche besuchte Rollen enthält, können Sie zu dieser Seite zurückkehren und zusätzlich bestimmte Rollen festsetzen.',

   'Once the Hotlist contains recently visited courses you can return to this page to also set frozen roles.'
=> 'Sobald die Schnellzugriffsliste kürzliche besuchte Kurse enthält, können Sie zu dieser Seite zurückkehren und zusätzlich bestimmte Rollen festsetzen.',

   'Those N roles are then shown in a table at the top of the courses page.'
=> 'Diese n Rollen werden dann in einer Tabelle im obersten Bereich der Kursseite angezeigt.',

   'Those N courses are then shown in a table at the top of the courses page.'
=> 'Diese n Kurse werden dann in einer Tabelle im obersten Bereich der Kursseite angezeigt.',

   'Those N roles are then shown in a table at the top of the roles page.'
=> 'Diese n Rollen werden dann in einer Tabelle im obersten Bereich der Rollenseite angezeigt.',

   'Switch to Inline Menu Mode'
=> 'Zum Modus mit Kopfzeilenmenü wechseln',

   'View Status'
=> 'Status anzeigen',

   'View/Change Status'
=> 'Status anzeigen/ändern',

   'You are not currently a member of any active groups in this course.'
=> 'Sie sind derzeit nicht Mitglied einer aktiven Gruppe in diesem Kurs.',

   'Group [_1] was updated.'
=> 'Die Gruppe [_1] wurde aktualisiert.',

   'An error occurred while setting parameters for Discussion Boards folder: [_1]'
=> 'Beim Einstellen der Parameter für das Diskussionsforen-Verzeichnis ist ein Fehler aufgetreten: [_1]',

   'Discussion Boards Folder created.'
=> 'Diskussionsforums-Verzeichnis wurde angelegt.',

   'You do not have group administration privileges in this course.'
=> 'Sie haben in diesem Kurs keine Gruppen-Administrationsrechte.',

   'An error occurred when creating the group. Please try again.'
=> 'Beim Erstellen der Gruppe ist ein Fehler aufgetreten. Bitte versuchen Sie es noch einmal.',

   'An error occurred when modifying the group. Please try again.'
=> 'Beim Verändern der Gruppe ist ein Fehler aufgetreten. Bitte versuchen Sie es noch einmal.',

   'You have requested deletion of the group [_1].'
=> 'Sie möchten die Gruppe [_1] löschen.',

   'The following users could not be activated, because an error occurred:'
=> 'Die folgenden Benutzer konnten nicht aktiviert werden, da ein Fehler aufgetreten ist:',

   'The following users could not be re-enabled, because an error occurred:'
=> 'Die folgenden Benutzer konnten nicht wiederhergestellt werden, da ein Fehler aufgetreten ist:',

   'The following users could not be modified, because an error occurred:'
=> 'Die folgenden Benutzer konnten nicht geändert werden, da ein Fehler aufgetreten ist:',

   'The following users could not be added, because an error occurred:'
=> 'Die folgenden Benutzer konnten nicht hinzugefügt werden, da ein Fehler aufgetreten ist:',

   'The following users could not be deleted, because an error occurred:'
=> 'Die folgenden Benutzer konnten nicht entfernt werden, da ein Fehler aufgetreten ist:',

   'The following users could not be expired, because an error occurred:'
=> 'Die Mitgliedschaften der folgenden Benutzer konnten nicht entzogen werden, da ein Fehler aufgetreten ist:',

   'No change occurred for the following users:'
=> 'Folgende Benutzer bleiben unverändert:',

   'When a group is deleted the following occurs:'
=> 'Beim Löschen einer Gruppe passiert folgendes:',

   'All group membership is terminated.'
=> 'Alle Gruppen-Mitgliedschaften werden aufgelöst.',

   'The group ceases to be available either for viewing or for modification of group settings and membership.'
=> 'Betrachten und Ändern der Gruppen-Einstellungen und -Mitgliedschaften wird für die Gruppe nicht mehr möglich sein.',

   'Although a deleted group is no longer accessible, the group name used for the group will be reserved, and will not be available for assignment to a new group in the same course in the future.'
=> 'Auch wenn die gelöschte Gruppe nicht länger verfügbar sein wird, so bleibt der Gruppenname dennoch reserviert und steht für neue Gruppen im selben Kurs zukünftig nicht zur Verfügung.',

   'Although a deleted group is no longer accessible, the group name used for the group will be reserved, and will not be available for assignment to a new group in the same community in the future.'
=> 'Auch wenn die gelöschte Gruppe nicht länger verfügbar sein wird, so bleibt der Gruppenname dennoch reserviert und steht für neue Gruppen in der selben Community zukünftig nicht zur Verfügung.',

   'Delete group'
=> 'Gruppe löschen',

   'Group deletion failed because deletion of [_1] out of [_2] members failed.'
=> 'Das Löschen der Gruppe ist fehlgeschlagen, da [_1] von [_2] Mitgliedern nicht entfernt werden konnten.',

   'Group successfully deleted.'
=> 'Die Gruppe wurde erfolgreich gelöscht.',

   "Although the group was deleted, an error occurred when removing the group's folder from the 'Course Groups' folder: [_1]"
=> "Die Gruppe wurde zwar gelöscht, beim Entfernen des Gruppen-Verzeichnisses aus dem 'Kursgruppen'-Verzeichnis ist jedoch ein Fehler aufgetreten: [_1]",

   "Although the group was deleted, an error occurred when removing the group's folder from the 'Community Groups' folder: [_1]"
=> "Die Gruppe wurde zwar gelöscht, beim Entfernen des Gruppen-Verzeichnisses aus dem 'Community-Gruppen'-Verzeichnis ist jedoch ein Fehler aufgetreten: [_1]",

   'Group deletion failed.'
=> 'Das Löschen der Gruppe ist fehlgeschlagen.',

   'Course Folder -[_1]'
=> 'Kursverzeichnis [_1]',

   'Community Folder -[_1]'
=> 'Community-Verzeichnis [_1]',

   'An error occurred when saving updated parent folder to group:'
=> 'Beim Speichern des aktualisierten übergeordneten Verzeichnisses für die Gruppe ist ein Fehler aufgetreten:',

   'An error occurred when reading contents of parent folder to group:'
=> 'Beim Lesen des Inhalts des übergeordneten Verzeichnisses für die Gruppe ist ein Fehler aufgetreten:',

   'You have requested enabling the previously deleted group [_1].'
=> 'Sie möchten die gelöschte Gruppe [_1] wiederherstellen.',

   'When a deleted group is re-enabled the following occurs:'
=> 'Beim Wiederherstellen einer gelöschten Gruppe passiert folgendes:',

   'Group settings and membership at the time the group was deleted are reinstated.'
=> 'Gruppen-Einstellungen und -Mitgliedschaften, die zum Zeitpunkt des Löschens dieser Gruppe bestanden, werden wiederhergestellt.',

   'Reenable group'
=> 'Gruppe wiederherstellen',

   'The group [_1] was not re-enabled, because it is not a deleted group.[_2]Perhaps it has already been re-enabled?'
=> 'Die Gruppe [_1] wurde nicht wiederhergestellt, da es sich nicht um eine gelöschte Gruppe handelt.[_2]Möglicherweise wurde sie zwischenzeitlich schon wiederhergestellt.',

   'No end date set'
=> 'Keine Enddatum gesetzt',

   'Membership reinstated for [quant,_1,user], each with start and end dates for group access set to defaults: [_2] and [_3]'
=> 'Die Mitgliedschaft wurde für [_quant,_1,Benutzer,Benutzer] wiederhergestellt, jeweils mit den voreingestellten Start- und Enddatumswerten dieser Gruppe: [_2] und [_3].',

   "Although the group was re-enabled, an error occurred when adding the group's folder to the 'Course Groups' folder: [_1]"
=> "Die Gruppe wurde zwar wiederhergestellt, beim Hinzufügen des Gruppen-Verzeichnisses zu dem 'Kursgruppen'-Verzeichnis ist jedoch ein Fehler aufgetreten: [_1]",

   "Although the group was re-enabled, an error occurred when adding the group's folder to the 'Community Groups' folder: [_1]"
=> "Die Gruppe wurde zwar wiederhergestellt, beim Hinzufügen des Gruppen-Verzeichnisses zu dem 'Community-Gruppen'-Verzeichnis ist jedoch ein Fehler aufgetreten: [_1]",

   'Re-enabling group failed.'
=> 'Wiederherstellen der Gruppe ist fehlgeschlagen.',

   'with related words'
=> 'mit ähnlichen Wörtern',

   'with no related words'
=> 'ohne ähnliche Wörter',

   'Change Roles Page Pref'
=> 'Schnellzugriffsliste für Benutzerrollen',

   'Change Courses Page Pref'
=> 'Schnellzugriffsliste für Kurse',

   'Recent Roles Hotlist'
=> 'Schnellzugriffsliste für zuletzt verwendete Rollen',

   'Recent Courses Hotlist'
=> 'Schnellzugriffsliste für zuletzt verwendete Kurse',

   'Enable Recent Roles Hotlist'
=> 'Schnellzugriffsliste für zuletzt verwendete Rollen aktivieren',

   'Enable Recent Courses Hotlist'
=> 'Schnellzugriffsliste für zuletzt verwendete Kurse aktivieren',

   'Number of Roles in Hotlist'
=> 'Anzahl der Rollen in der Schnellzugriffsliste',

   'Number of Courses in Hotlist'
=> 'Anzahl der Kurse in der Schnellzugriffsliste',

   'Number of Courses in Hotlist:'
=> 'Anzahl Kurse in Schnellzugriffsliste:',

   'Change Roles Preferences'
=> 'Rollenpräferenzen ändern',

   'Display [_1] Most Recent Roles.'
=> 'Es werden die letzten [_1] verwendeten Rollen angezeigt.',

   'Display [_1] Most Recent Roles'
=> 'Es werden die letzten [_1] verwendeten Rollen angezeigt.',

   'Display [_1] Most Recent Courses.'
=> 'Es werden die letzten [_1] verwendeten Kurse angezeigt.',

   'Display [_1] Most Recent Courses'
=> 'Es werden die letzten [_1] verwendeten Kurse angezeigt.',

   'Freeze Roles'
=> 'Rollen festsetzen',

   'Freeze Courses'
=> 'Kurse festsetzen',

   'Freeze Role'
=> 'Rolle festsetzen',

   'Freeze Course'
=> 'Kurs festsetzen',

   'Configure Hotlist'
=> 'Schnellzugriffsliste konfigurieren',

   'Use Recent Roles Hotlist'
=> 'Schnellzugriffsliste für zuletzt verwendete Rollen verwenden',

   'The table below can be used to [_1]freeze[_2] roles on your screen.'
=> 'Verwenden Sie die folgende Liste, um Rollen [_1]festzusetzen[_2].',

   'The table below can be used to [_1]freeze[_2] courses on your screen.'
=> 'Verwenden Sie die folgende Liste, um Kurse [_1]festzusetzen[_2].',

   'The table below can be used to [_1]freeze[_2] roles in the Hotlist.'
=> 'Verwenden Sie die folgende Liste, um Rollen in der Schnellzugriffsliste [_1]festzusetzen[_2].',

   'Those roles marked frozen will not be removed from the list, even if not recently used.'
=> 'Als festgesetzt markierte Rollen werden aus der Liste nicht mehr automatisch entfernt, selbst wenn Sie sie in letzter Zeit nicht verwendet haben.',

   'Those courses marked frozen will not be removed from the list, even if not recently used.'
=> 'Als festgesetzt markierte Kurse werden aus der Liste nicht mehr automatisch entfernt, selbst wenn Sie sie in letzter Zeit nicht verwendet haben.',

   'Those marked frozen will not be removed from the list, even if not recently used.'
=> 'Als festgesetzt Markierte werden aus der Liste nicht mehr automatisch entfernt, selbst wenn Sie sie in letzter Zeit nicht verwendet haben.',

   'Recent Roles Hotlist is Disabled'
=> 'Die Schnellzugriffsliste für zuletzt verwendete Rollen wurde deaktiviert.',

   'Recent Courses Hotlist is Disabled'
=> 'Die Schnellzugriffsliste für zuletzt verwendete Kurse wurde deaktiviert.',

   'Recent Roles Hotlist is Enabled.'
=> 'Die Schnellzugriffsliste für zuletzt verwendete Rollen ist aktiv.',

   'Recent Courses Hotlist is Enabled.'
=> 'Die Schnellzugriffsliste für zuletzt verwendete Kurse ist aktiv.',

   'Freezing Role: [_1]'
=> 'Festsetzen der Rolle [_1]',

   'Freezing Course: [_1]'
=> 'Festsetzen des Kurses [_1]',

   'Unfreezing Role: [_1]'
=> 'Aufhebung der Festsetzung der Rolle [_1]',

   'Unfreezing Course: [_1]'
=> 'Aufhebung der Festsetzung des Kurses [_1]',

   'Author Space'
=> 'Autorenbereich',

   '[_1] Author Space'
=> 'Autorenbereich von [_1]',

   'Degree of discrimination'
=> 'Grad der Abgrenzung',

   'Disable WYSIWYG Editor'
=> 'WYSIWYG-Editor deaktivieren',

   'Last Modifying User'
=> 'Benutzer, der zuletzt geändert hat',

   'Last Revision Date'
=> 'Datum der letzten Überarbeitung',

   'Linked/Related Resources'
=> 'Verknüpfte/Verwandte Ressourcen',

   'Network-wide courses using resource'
=> 'Netzwerkweite Kurse, die diese Ressource verwenden',

   'Never'
=> 'Niemals',

   'Preview'
=> 'Vorschau',

   'Resources that follow this resource in maps'
=> 'Ressourcen, die in einer Inhaltszusammenstellung Nachfolger dieser Ressource sind',

   'Resources that lead up to this resource in maps'
=> 'Ressourcen, die in einer Inhaltszusammenstellung Vorgänger dieser Ressource sind',

   'Resources used by this resource'
=> 'Ressourcen, die von dieser Ressource verwendet werden',

   'Resources using or importing resource'
=> 'Ressourcen, die diese Ressource verwenden oder importieren',

   'Return'
=> 'Zurück',

   'Source Available'
=> 'Quellcode verfügbar',

   'Source Custom Distribution File'
=> 'Datei zum Maßschneidern der Zugriffsrechte auf den Quellcode',

   'Start new page[_1]before selected' # _1: <br />
=> 'Neue Seite beginnen[_1]vor dem Ausgewählten',

   'Extra space[_1]before selected' # _1: <br />
=> 'Zusätzlicher Leerraum[_1]vor dem Ausgewählten',

   'Space units[_1]check for mm' # _1: <br />
=> 'Einheiten für Leerraum in mm?[_1]auswählen!',

   'on'
=> 'an',

   '(on)'
=> '(an)',

   'off'
=> 'aus',

   '(off)'
=> '(aus)',

   '(re-initialize course to access)'
=> '(Kurs neu initialisieren, um Zugriff zu erhalten)',

   '(re-initialize community to access)'
=> '(Community neu initialisieren, um Zugriff zu erhalten)',

   'All Parts'
=> 'Alle Teile',

   'Changes will become active for your current session after [_1], or the next time you log in.'
# => 'Um die Änderungen für die aktuelle Sitzung zu übernehmen, klicken Sie [_1] oder melden Sie sich neu an.',
# => 'Klicken Sie auf [_1], um die letzten Änderungen sofort zu übernehmen.',
=> 'Die letzten Änderungen werden für Ihre Sitzung aktiviert, wenn Sie auf [_1] klicken bzw. ab Ihrem nächsten Login.',

   'Cut'
=> 'Ausschneiden',

   'Random Order'
=> 'Zufällige Reihenfolge',

   'Due and Answer Available'
=> 'Fällig, Antwort verfügbar',

   'Edit any group in the course'
=> 'Kursgruppen verwalten',

   'Editing the Table of Contents for your Course'
=> 'Wie bearbeite ich den Inhalt des Kurses',

   'Enter any group in the course'
=> 'Einer beliebigen Gruppe des Kurses beitreten',

   'Existing Parameter Settings for Your Resources'
=> 'Bestehende Parameter-Einstellungen für Ihre Ressourcen',

   'Group'
=> 'Gruppe',

   'Group:'
=> 'Gruppe:',

   'Group: [_1]'
=> 'Gruppe: [_1]',

   'Hidden'
=> 'Verborgen',

   'List Symbs'
=> 'Interne Bezeichner',

   'Symb List'
=> 'Liste interner Bezeichner',

   'Manage Course Slots'
=> 'Kurs-Slots verwalten',

   'Manage student enrollment '
=> 'Studentische Kursbelegungen verwalten ',

   'Modify parameter settings (due dates, etc) for resources and the course'
=> 'Kurs- und Ressourcen-Parameter',

   'Modify parameter settings for this resource'
=> 'Parametereinstellungen', # long version: 'Parametereinstellungen für diese Ressource ändern',

   'New and Existing Parameter Settings for Your Resources'
=> 'Neue und bestehende Parameter-Einstellungen für die Ressourcen',

   'Parameter Change Log and Course Blog Posting/User Notification'
=> 'Parameteränderungs-Protokoll und Kurs-Blog-Einträge/Benutzer-Benachrichtigung',

   'Parameter Manager'
=> 'Kurs- und Ressourcen-Parameter',

   'Randomly Pick: '
=> 'Wähle zufällig: ',

   'Remove'
=> 'Löschen',

   'Rendering:'
=> 'Überprüfung:',

   'Select Parameters to View'
=> 'Auswahl der Parameter, die angezeigt werden sollen',

   'Select Parts to View'
=> 'Auswahl der anzuzeigenden Aufgabenteile',

   'Set Parameter Setting Default Actions'
=> 'Standardaktionen für Parametereinstellungen',

   'Set Portfolio Metadata'
=> 'Portfolio-Metadaten',

   'Set/Modify Resource Parameters - Helper Mode'
=> 'Ressourcen-Parameter - Hilfsmodus',

   'Set/Modify Resource Parameters - Overview Mode'
=> 'Ressourcen-Parameter - Übersichtsmodus',

   'Set/Modify Resource Parameters - Table Mode'
=> 'Ressourcen-Parameter - Tabellenmodus',

   'Settings for Your Course'
=> 'Kurs-Einstellungen',

   'Table Mode'
=> 'Tabellenmodus',

   'Table Mode Parameter Setting'
=> 'Tabellenmodus-Parameter-Einstellungen',

   'The resources in "[_1]" are open for a limited time. Once you click the "[_2]" button below you have [_3] to complete all resources in "[_1]".'
=> 'Die Ressourcen in "[_1]" können nur zeitlich begrenzt bearbeitet werden. Sobald Sie auf "[_2]" klicken, haben Sie [_3], um alle Ressourcen in "[_1]" zu bearbeiten.',

   'URL hidden'
=> 'URL verborgen',

   'Update Parameter Display'
=> 'Parameteranzeige aktualisieren',

   'View calculated grades (Spreadsheet)'
=> 'Berechnete Bewertungen (Beurteilungsbogen)',

   'Show Resource'
=> 'Ressource zeigen',

   'Feedback to resource author'
=> 'Feedback an den Autor der Ressource',

   'Add/remove attachments'
=> 'Anhänge hinzufügen/entfernen',

   'New attachments'
=> 'Neue Anhänge',

   'Retained attachments'
=> 'Zurückbehaltene Anhänge',

   'Add a new attachment to this post'
=> 'Neuen Anhang für diese Nachricht erstellen',

   'Discussion Post Attachments'
=> 'Anhänge für Diskussionsbeiträge',

   'Modify course settings'
=> 'Kurs-Einstellungen',

   'Send and display broadcast e-mail'
=> 'Broadcast-E-Mails',

   'Awarded Total Points'
=> 'Erreichte Gesamtpunktzahl',

   'Total Parts Done'
=> 'Gesamtanzahl erledigter Aufgabenteile',

   'Create a single course'
=> 'Einen neuen, einzelnen Kurs erstellen',

   'Create a single community'
=> 'Eine neue, einzelne Community erstellen',

   'Create a new course by completing an online form.'
=> 'Einen neuen Kurs durch Ausfüllen eines Formulars erstellen.',

   'Create a single collaborative group space'
=> 'Einzelnen, kollaborativen Gruppenbereich erstellen',

   'Create a new group space for non-course use by completing an online form.'
=> 'Einen Gruppenbereich für die Verwendung außerhalb von Kursen durch Ausfüllen eines Formulars erstellen.',

   'Create courses/groups by uploading an attributes file'
=> 'Kurse/Gruppen durch Hochladen einer Attributedatei erstellen',

   'Create courses/communities by uploading an attributes file'
=> 'Kurse/Communitys durch Hochladen einer Attributedatei erstellen',

   'Upload an attributes file containing specifications for one or more courses or groups in XML format.'
=> 'Hochladen einer Attributedatei, die Spezifikationen für einen oder mehrere Kurse oder Gruppen im XML-Format enthält.',

   'current'
=> 'aktuell',

   'Version changes'
=> 'Versionsänderungen',

   'Change interval'
=> 'Intervall ändern',

   'Student Submission Reports'
=> 'Berichte studentischer Einreichungen',

   'Prepare reports of student submissions.'
=> 'Berichte zu den studentischen Einreichungen erstellen',

   'Survey Reports'
=> 'Umfrage-Berichte',

   'Prepare reports on survey results.'
=> 'Berichte zu Umfrage-Ergebnissen erstellen',

   'View survey'
=> 'Umfrage betrachten',

   'Previous Survey'
=> 'Vorherige Umfrage',

   'Next Survey'
=> 'Nächste Umfrage',

   'Choose a different Survey'
=> 'Andere Umfrage wählen',

   'Generate Report'
=> 'Bericht erstellen',

   'Part [_1], Response [_2]'
=> 'Aufgabenteil [_1], Antwort [_2]',

   'Response [_1]'
=> 'Antwort [_1]',

   'Foil Name'
=> 'Name der Auswahlmöglichkeit',

   'Foil Text'
=> 'Text der Auswahlmöglichkeit',

   'Percent'
=> 'Prozent',

   'Correct Problems Plot'
=> 'Richtige-Antworten-Diagramme',

   'Display a histogram of student performance in the course.'
=> 'Histogramm studentischer Kursleistungen anzeigen',

   'Access Status'
=> 'Zugriffsstatus',

   '[_1] Limit by time'
=> '[_1] Zeitliche Begrenzung',

   'Submission Time Plots'
=> 'Einreichungszeit-Diagramme',

   'Currently Has Access'
=> 'Aktueller Zugriff',

   'Will Have Future Access'
=> 'Zukünftiger Zugriff',

   'Previously Had Access'
=> 'In der Vergangenheit liegender Zugriff',

   'Any Access Status'
=> 'Beliebiger Zugriffsstatus',

   'Previous Problem'
=> 'Vorherige Aufgabe',

   'Next Problem'
=> 'Nächste Aufgabe',

   'Choose a different Problem'
=> 'Eine andere Aufgabe auswählen',

   'Update Caches'
=> 'Cache aktualisieren',

   'Begin'
=> 'Beginn',

   'There are no students in the sections selected.'
=> 'In den gewählten Sektionen sind keine Studierenden.',

   'There are no students in the sections/groups selected.'
=> 'In den gewählten Sektionen/Gruppen sind keine Studierenden.',

   'There are no students in the sections/groups selected'
=> 'In den gewählten Sektionen/Gruppen sind keine Studierenden.',

   'There is no submission data for this problem at all.'
=> 'Für diese Aufgabe existieren keinerlei studentische Einreichungsdaten.',

   'There is no submission data for this problem.'
=> 'Für diese Aufgabe existieren keine studentischen Einreichungsdaten.',

   'There is no submission data for this resource.'
=> 'Für diese Ressource existieren keine Einreichungsdaten.',

   'There is no data to plot.'
=> 'Es existieren keine Daten, die geplottet werden könnten.',

   'There is no data to plot'
=> 'Es existieren keine Daten, die geplottet werden könnten.',

   'Analysis of [_1] is not supported.'
=> 'Die Analyse von Aufgaben des Typs "[_1]" wird nicht unterstützt.',

   'None of the selected students attempted the problem more than [quant,_1,time].'
=> 'Keiner der ausgewählten Studierenden hat für die Aufgabe mehr als [quant,_1,Versuch,Versuche] benötigt.',

   'None of the selected students have attempted the problem.'
=> 'Keiner der ausgewählten Studierenden hat die Aufgabe bearbeitet.',

   'The analysis you have selected is not supported at this time.'
=> 'Die von Ihnen ausgewählte Analyse wird derzeit nicht angeboten.',

   'Graph Problem Submission Times'
=> 'Graph Aufgaben-Einreichungszeiten',

   'Return to Directory'
=> 'Zurück zum Verzeichnis',

   'Return to directory'
=> 'Zurück zum Verzeichnis',

# 2007-06-15

   'My Roles'
=> 'Meine Rollen',

   'My Space'
=> 'Mein Bereich',

   'Edit blogs, RSS feeds, and podcasts'
=> 'Blogs, RSS-Feeds und Podcasts',

   'Content Library'
=> 'Inhalte',

   'LON-CAPA Digital Library Search Results'
=> 'Suchergebnisse aus der digitalen LON-CAPA-Bibliothek',

   'Search the contents of this course or accessible portfolio files'
=> 'Kurs- und Portfolio-Suche',

   'Grading and Statistics'
=> 'Bewertungen und Statistiken',

   'Other'
=> 'Sonstiges',

   'group'
=> 'Gruppe',

   'Size'
=> 'Größe',

   'Current Access Status'
=> 'Aktueller Zugriffsstatus',

   'Delete Checked Files'
=> 'Markierte Dateien löschen',

   'Using the portfolio file list'
=> 'Verwendung der Portfolio-Dateiliste',

   'Help on the portfolio'
=> 'Hilfe zum Portfolio',

   'Private'
=> 'privat',

   'Change How Menus are Displayed'
=> 'Darstellung der Menüs',

   'Use icons and text'
=> 'Icons mit Text',

   'Use icons only'
=> 'Nur Icons',

   'Previous Tries'
=> 'Bisherige Antworten',

   'Previous Submissions'
=> 'Bisherige Einreichungen',

   'Change Menu Display'
=> 'Darstellung der Menüs',

   'Screenname'
=> 'Anonymer Nickname',

   '(shown if you post anonymously)'
=> '(für anonyme Beiträge)',

   'Nickname'
=> 'Nickname',

   '(shown if you post non-anonymously)'
=> '(für normale, nicht anonyme Beiträge)',

   'Choose the time window to use to display roles for which access to the course expired.'
=> 'Auswahl des Zeitfensters zur Anzeige von Rollen, die in diesem Kurs abgelaufen sind',

   'Choose the time window to use to display roles for which access to the course became available.'
=> 'Auswahl des Zeitfensters zur Anzeige von Rollen, die diesem Kurs zugeteilt sind',

   'Choose the time window to use to display roles for which access to the community became available.'
=> 'Auswahl des Zeitfensters zur Anzeige von Rollen, die dieser Community zugeteilt sind',

   'Choose the time window to use to display roles for which access to the community expired.'
=> 'Auswahl des Zeitfensters zur Anzeige von Rollen, die in dieser Community abgelaufen sind',

   'Choose the time window to use to display resources in the course with version changes.'
=> 'Auswahl des Zeitfensters zur Anzeige von Versionsänderungen von Ressourcen im Kurs',

   'Choose the time window to use to display resources in the community with version changes.'
=> 'Auswahl des Zeitfensters zur Anzeige von Versionsänderungen von Ressourcen in der Community',

   'Choose the time window to use to display the last login by a user in the course'
=> 'Auswahl des Zeitfensters zur Anzeige der letzten Benutzer-Logins in dem Kurs',

   'User Management'
=> 'Benutzerverwaltung',

   'Manage student enrollment'
=> 'Studentische Kursbelegungen',

   'Modify an existing group'
=> 'Bestehende Gruppe ändern',

   'Delete an existing group'
=> 'Bestehende Gruppe löschen',

   'Re-enable a deleted group'
=> 'Gelöschte Gruppe wiederherstellen',

   'Enter an existing group'
=> 'Einer bestehenden Gruppe beitreten',

   'Course Management'
=> 'Kursverwaltung',

   'Reset Student Access Times'
=> 'Studentische Zugriffszeiten zurücksetzen',

   'Submission #'
=> 'Antwort-Nr.',

   'Try'
=> 'Versuch',

   'Try [_1]'
=> '[_1]. Versuch',

   'Submitted Answer'
=> 'Eingereichte Antwort',

   'Submitted Answer:'
=> 'Eingereichte Antwort:',

   'Close Window'
=> 'Fenster schließen',

   'Close window'
=> 'Fenster schließen',

   'Portfolio Search'
=> 'Portfolio-Suche',

   'Enter words and quoted phrases'
=> 'Eingabe von Wörtern und in Anführungszeichen gesetzten Ausdrücken',

   'Portfolio and Course Search'
=> 'Kurs- und Portfolio-Suche',

   'Message Status'
=> 'Nachrichtenstatus',

   'Any'
=> 'beliebig',

   'Unread'
=> 'ungelesen',

   'Read'
=> 'gelesen',

   'Replied to'
=> 'beantwortet',

   'Forwarded'
=> 'weitergeleitet',

   'Rename Folder'
=> 'Verzeichnis umbenennen',

   'Delete Folder'
=> 'Verzeichnis löschen',

   'Recent Roles'
=> 'Zuletzt verwendete Rollen',

   'Close navigation window'
=> 'Navigationsfenster beenden',

   'Post Anonymous'
=> 'Anonym absenden',

   'Post'
=> 'Absenden',

   'Back to preferences menu'
=> 'Zurück',

   'Forward messages to other account(s) in LON-CAPA'
=> 'Nachrichtenweiterleitung an andere LON-CAPA-Accounts',

   'Forward to account(s)'
=> 'Weiterleitung an Account(s)',

   'e.g. [_1]userA:domain1,userB:domain2,...[_2]'
=> 'z.B. [_1]BenutzerA:Domäne1,BenutzerB:Domäne2,...[_2]',

   'E-mail notification of LON-CAPA messages'
=> 'E-Mail-Benachrichtigung über LON-CAPA-Nachrichten',

   'E-mail address(es) which should be notified about new LON-CAPA messages'
=> 'E-Mail-Adresse(n) zur Benachrichtigung über neue LON-CAPA-Nachrichten',

   'e.g. [_1]joe@doe.com[_2]'
=> 'z.B. [_1]hans@wurst.de[_2]',

   'Notification address'
=> 'Benachrichtigungsadresse',

   'Types of message for which notification is sent'
=> 'Art der Nachrichten, für die Benachrichtigung stattfinden soll',

   'Excerpt retains HTML tags in message'
=> 'Im Nachrichtenauszug HTML beibehalten',

   'All'
=> 'alle',

   'Critical only'
=> 'nur wichtige',

   'Non-critical only'
=> 'nur nicht-wichtige',

   'Add new address'
=> 'Neue Adresse hinzufügen',

   'What are forwarding and notification addresses?'
=> 'Was sind Weiterleitungs- und Benachrichtigungs-Adressen?',

   'What are critical messages?'
=> 'Was sind wichtige Nachrichten?',

   'Current Password'
=> 'Derzeitiges Passwort',

   'New Password'
=> 'Neues Passwort',

   'Confirm Password'
=> 'Bestätigung neues Passwort',

   'Passwords must be a minimum of 7 characters long. Please try again.'
=> 'Das Passwort muss mindestens 7 Zeichen lang sein. Bitte versuchen Sie es noch einmal.',

   'The new passwords you entered do not match. Please try again.'
=> 'Die Bestätigung des neuen Passworts stimmt nicht mit dem neuen Passwort überein. Bitte versuchen Sie es noch einmal.',

   'Send me a message'
=> 'Diesem Benutzer eine Nachricht schicken',

   'Show Public View'
=> 'Öffentliche Sicht zeigen',

   'Delete Photo'
=> 'Foto löschen',

   'Help with filling in text boxes'
=> 'Hilfe zur Eingabe in Textfeldern',

   'Examples'
=> 'Beispiele',

   'Summary Preview'
=> 'Zusammenfassungsvorschau',

   'Send copy to permanent e-mail address (if known)'
=> 'Kopie an externe E-Mail-Adresse senden (falls hinterlegt)',

   'Include in course RSS newsfeed'
=> 'In kursinterne RSS-Feeds einbinden',

   'Include in community RSS newsfeed'
=> 'In Community-interne RSS-Feeds einbinden',

   'Allow replies:'
=> 'Antworten zulassen:',

   'Reply to:'
=> 'Antwort an:',

   'Domain Management'
=> 'Domänen-Verwaltung',

   'Course ID of Key Authority:'
=> 'Kurs-ID des Schlüsselmeisters:',

   'Course ID of Key Authority'
=> 'Kurs-ID des Schlüsselmeisters',

   'Set domain configuration'
=> 'Domänen-Konfiguration',

   'Domain Configuration'
=> 'Domänen-Konfiguration',

   'View/Modify Domain Settings'
=> 'Domänen-Konfiguration',

   'Menu'
=> 'Menü',

   'Domain Settings'
=> 'Domänen-Konfiguration',

   'Course Environment'
=> 'Kursumgebung',

   'Edit Course Environment'
=> 'Kursumgebung',

   'Users allowed to clone course'
=> 'Benutzer, die berechtigt sein sollen, diesen Kurs zu klonen',

   'Users with active Course Coordinator role in this course are permitted to clone and need not be included.'
=> 'Benutzer mit aktiver Kurs-Koordinatoren-Rolle zu diesem Kurs haben automatisch das Recht zum Klonen und brauchen daher hier nicht eingetragen werden.',

   'Use [_1] to allow course to be cloned by anyone in the specified domain.'
=> '[_1] gestattet jedem in der angegebenen Domäne diesen Kurs zu klonen.',

   'Use [_1] to allow unrestricted cloning in all domains.'
=> '[_1] gestattet jedem aller Domänen diesen Kurs zu klonen.',

   'URL of Syllabus (not using internal handler)'
=> 'Externer Kursüberblick (URL)',

   'Custom Text for Resource Content Question Option in Feedback'
=> 'Eigener Text für Ressourcen-Inhaltsfragen-Option beim Feedback',

   'Custom Text for Course Content Option in Feedback'
=> 'Eigener Text für Kursinhalts-Option beim Feedback',

   'Custom Text for Course Policy Option in Feedback'
=> 'Eigener Text für Kursrichtlinien-Option beim Feedback',

   'Allow students to view classlist.'
=> 'Studierenden erlauben, die Kursteilnehmerliste einzusehen',

   'Allow users with specified roles to edit/delete their own discussion posts'
=> 'Erlaube Benutzern mit folgenden Rollen, ihre eigenen Diskussionsbeiträge zu editieren/löschen',

   'Suppress number of tries in printing'
=> 'Beim Druck Angabe der Anzahl der Versuche auslassen',

   'Default paper type'
=> 'Standard-Papierformat',

   'Default beginning date for student access.'
=> 'Voreingestelltes Anfangsdatum für studentischen Zugriff',

   'Default ending date for student access.'
=> 'Voreingestelltes Enddatum für studentischen Zugriff',

   'Disable checking of Significant Figures'
=> 'Überprüfung signifikanter Stellen deaktivieren',

   'Disable automatically printing point values on bubblesheet exams'
=> 'Automatisches Drucken von Punkten auf Bubblesheet-Prüfungen deaktivieren',

   'Substitution'
=> 'Ersetzung',

   'assignment note'
=> 'Anmerkung zur Übung',

   'None specified - use domain default'
=> 'Keine Angabe - Domänen-Voreinstellung verwenden',

   'Send message to student when clicking Done on Tasks'
=> 'Nachricht an Studierende versenden, wenn diese auf "Erledigt" in ihren Übungen klicken', # ???

   'Restrict Metadata'
=> 'Portfolio-Metadaten',

   'Show to student'
=> 'dem/der Student/in zeigen',

   'Provide text area for students to type metadata'
=> 'dem/der Student/in Textfeld anbieten, um Metadaten eingeben zu können',

   'Provide choices for students to select from'
=> 'dem/der Student/in Auswahl anbieten, um wählen zu können aus',

   'Student may select multiple choices from list'
=> 'Mehrfachauswahl aus Liste erlauben',

   'Student may select only one choice from list'
=> 'Nur eine Auswahl aus der Liste erlauben',

   'Add a Metadata Field'
=> 'Ein Metadatenfeld hinzufügen',

   'Order Metadata Fields'
=> 'Metadaten-Felder sortieren',

   'Continue Import'
=> 'Import fortsetzen',

   'Continue Search'
=> 'Suche fortsetzen',

   'Finish Import'
=> 'Import abschließen',

   'Include'
=> 'Einbinden',

   'Include?'
=> 'Einbinden?',

   'LON-CAPA Catalog Search'
=> 'LON-CAPA-Katalog-Suche',

   '[_1] include external resources'
=> '[_1] externe Ressourcen mit einbeziehen',

   'Change Course Initialization Preference'
=> 'Kurs-Initialisierung',

   'Change Course Init. Pref.'
=> 'Kurs-Initialisierung',

   'Reset Access Times'
=> 'Studentische Zugriffszeiten zurücksetzen',

   'Select Scope'
=> 'Bereich wählen',

   'Reset times on one or more folders/maps for a single student.'
=> 'Zeiten in einem/r oder mehreren Verzeichnissen/Inhaltszusammenstellungen für eine/n einzelne/n Studenten/in zurücksetzen',

   'Reset times on a single folder/map for a section or whole clase.'
=> 'Zeiten für ein(e) einzelne(s) Verzeichnis/Inhaltszusammenstellung für eine Sektion oder einen gesamten Kurs zurücksetzen',

   'Choose a student:'
=> 'Student/in auswählen:',

   'Select Currently Enrolled Students and Active Course Personnel'
=> 'Auswahl derzeit den Kurs belegender Studierender oder aktiven Kurspersonals',

   'Select Previously Enrolled Students and Inactive Course Personnel'
=> 'Auswahl in der Vergangenheit den Kurs belegender Studierender oder inaktiven Kurspersonals',

   'Select Future Enrolled Students and Future Course Personnel'
=> 'Auswahl zukünftig den Kurs belegender Studierender oder zukünftigen Kurspersonals',

   'This is a list of first access times and what was accessed, please select those you want deleted.'
=> 'Hier ist eine Liste der Erstzugriffszeiten und das, auf was zugegriffen wurde. Bitte wählen Sie aus, welche gelöscht werden sollen.',

   'Select:'
=> 'Auswahl:',

   'All Course Personnel'
=> 'Gesamtes Kurspersonal',

   'No Section'
=> 'Keine Sektion',

   'Unselect'
=> 'Auswahl aufheben',

   'Select a folder/map'
=> 'Verzeichnis/Inhaltszusammenstellung wählen',

   'Will remove access times for'
=> 'Werde Zugriffszeiten entfernen für',

   'Will remove access times from user'
=> 'Werde Zugriffszeiten entfernen von Benutzer',

   'from users'
=> 'von Benutzern',

   'No Access times found for student'
=> 'Keine Zugriffszeiten gefunden für Student/in',

   'Finish'
=> 'Abschließen',

   'Name of New Folder'
=> 'Name des neuen Verzeichnisses:',

   'Name of New Page'
=> 'Name der neuen zusammengesetzten Seite',

   'New Page'
=> 'Neue zusammengesetzte Seite',

   'WARNING: Removing a resource makes associated grades and scores inaccessible!'
=> 'Achtung: Das Entfernen der Ressource macht die damit verknüpften Bewertungen und Punkte unerreichbar!',

   'Clipboard'
=> 'Zwischenablage',

   'Remove[_99]'
=> 'Soll[_99]',

   '?[_99]'
=> 'wirklich entfernt werden?',

   'WARNING: Cutting a resource makes associated grades and scores inaccessible!'
=> 'Achtung: Das Ausschneiden der Ressource macht die damit verknüpften Bewertungen und Punkte unerreichbar!',

   'Grades remain inaccessible if resource is pasted into another folder.'
=> 'Die Bewertungen bleiben unerreichbar, auch wenn die Ressource in einem anderen Verzeichnis eingefügt wird.',

   'Cut[_98]'
=> 'Soll[_98]',

   '?[_98]'
=> 'wirklich ausgeschnitten werden?[_98]',

   'Paste'
=> 'Einfügen',

   'This screen shows how many problems (or problem parts) you have completed, and how many you have not yet done. You can also look at [_1]a detailed score sheet[_2].'
=> 'Diese Seite zeigt Ihnen, wie viele Aufgaben bzw. Aufgabenteile Sie vollständig beantwortet und wie viele Sie noch nicht bearbeitet haben. Sie können sich auch eine [_1]detaillierte Punktetabelle[_2] anzeigen lassen.',

   'This screen shows how many problems (or problem parts) you have completed , and how many you have not yet done. You can also look at [_1]a detailed score sheet[_2].'
=> 'Diese Seite zeigt Ihnen, wie viele Aufgaben bzw. Aufgabenteile Sie vollständig beantwortet und wie viele Sie noch nicht bearbeitet haben. Sie können sich auch eine [_1]detaillierte Punktetabelle[_2] anzeigen lassen.',

   'This may take a few moments to display.'
=> 'Die Berechnung könnte einen Moment dauern.',

   'Detailed Citation Preview'
=> 'Detaillierte Zitatsvorschau',

   'related words'
=> 'ähnliche Wörter',

   '(including related words)'
=> '(inklusive ähnlicher Wörter)',

   'Any domain'
=> 'Beliebige Domäne',

   'Reset'
=> 'Zurücksetzen',

   'MIME Type Category'
=> 'MIME-Typ-Kategorie',

   'Domains'
=> 'Domänen',

   'Custom Metadata fields'
=> 'Eigene Metadaten-Felder',

   'Field Name'
=> 'Feldbezeichnung',

   'Field Value(s)'
=> 'Feldinhalt(e)',

   'Another custom field/value pair?'
=> 'Ein weiteres eigenes Metadaten-Feld?',

   'Creation and Modification dates'
=> 'Erstellungs- und Änderungszeiten',

   'Created between'
=> 'Erstellung zwischen',

   'created between [_1] and [_2]'
=> 'Erstellung zwischen [_1] und [_2]',

   'Last modified between'
=> 'Letzte Änderung zwischen',

   'last revised between [_1] and [_2]'
=> 'zuletzt geändert zwischen [_1] und [_2]',

   'Standard Portfolio Metadata'
=> 'Standard-Portfolio-Metadaten',

   'Advanced Portfolio Search'
=> 'Erweiterte Portfolio-Suche',

   'Standard Catalog Metadata'
=> 'Standard-Katalog-Metadaten',

   'Problem Statistics'
=> 'Aufgaben-Statistiken',

   'Statistics calculated for number of students'
=> 'Statistiken berechnet für folgende Anzahl Studierende',

   'Portfolio and Catalog Search'
=> 'Datenbank veröffentlichter Ressourcen und Portfolio-Dateien',

# 2007-06-22
   'Search the database of accessible portfolio files'
=> 'Datenbank der Portfolio-Dateien',

   'Authoring Space:'
=> 'Autorenbereich:',

   'Problem Status:'
=> 'Aufgabenstatus:',

   'Problem Type:'
=> 'Aufgabentyp:',

   'Feedback Mode:'
=> 'Feedback-Modus:',

   'Answer for Part: [_1]'
=> 'Antwort für Teil [_1]',

   'Script Vars'
=> 'Skript-Variablen',

   'Regular file'
=> 'Normale Datei',

   'Testbank file'
=> 'Testbank-Datei',

   'IMS package'
=> 'IMS-Paket',

   'There are unsaved changes'
=> 'Es liegen ungespeicherte Änderungen vor!',

   'Found no analyzable responses in this problem. Currently only Numerical, Formula and String response styles are supported.'
=> 'In dieser Aufgabe konnten keine analysierbaren Antworttypen gefunden. Derzeit werden nur numerische Ausdrücke, Formeln und Strings unterstützt.',

   'Page Background Color'
=> 'Seitenhintergrundfarbe',

   'Header Background Color'
=> 'Seitenkopf-Hintergrundfarbe',

   'Header Border Color'
=> 'Seitenkopf-Rahmenfarbe',

   'Font Color'
=> 'Zeichenfarbe',

   'Font color'
=> 'Zeichenfarbe',

   'Font Menu Color'
=> 'Menüzeichenfarbe',

   'Un-Visited Link Color'
=> 'Farbe nicht besuchter Links',

   'Visited Link Color'
=> 'Farbe besuchter Links',

   'Active Link Color'
=> 'Farbe aktiver Links',

   'Reset All'
=> 'Alle zurücksetzen',

   'Reset All Colors to Default'
=> 'Alle Farben auf Voreinstellung zurücksetzen',

   'Set [_1] to [_2]'
=> '[_1] wurde geändert auf [_2]',

   'Reset [_1]'
=> '[_1] wurde zurückgesetzt',

   'Save and Edit'
=> 'Speichern und weiterbearbeiten',

   'Save and EditXML'
=> 'Speichern und XML-Editor',

   'Save and View'
=> 'Speichern und betrachten',

   'Check Spelling'
=> 'Rechtschreibprüfung',

   'Selecting a Course'
=> 'Kurs auswählen',

   'Course Activity:'
=> 'Letzte Kursaktivität:',

   'Course Domain:'
=> 'Kurs-Domäne:',

   'Course domain'
=> 'Kursdomäne',

   'Community Domain'
=> 'Community-Domäne',

   'Course/Community Domain'
=> 'Kurs-/Community-Domäne',

   'Course Institutional Code:'
=> 'Institutioneller Kurs-Code:',

   "Course Owner's Username:"
=> 'Benutzerkennung des Kurs-Eigentümers:',

   "Course Owner's Domain:"
=> 'Domäne des Kurs-Eigentümers:',

   'LON-CAPA course ID:'
=> 'LON-CAPA-Kurs-ID:',

   'Course Title:'
=> 'Kurstitel:',

   'Course Description'
=> 'Kurstitel',

   'Brief Course Description'
=> 'Kurze Beschreibung des Kurses',

   'Community Description'
=> 'Community-Titel',

   'Brief Community Description'
=> 'Kurze Beschreibung der Community',

   'Course/Community Description'
=> 'Kurs-/Community-Titel',

   'Resource Space Home'
=> 'Ressourcenbereich-Hauptverzeichnis',

   'Default start and end dates for student access'
=> 'Voreingestelltes Anfangs- und Enddatum für studentischen Zugriff',

   'Default start and end dates for member access'
=> 'Voreingestelltes Anfangs- und Enddatum für Mitglieder-Zugriff',

   'Notification to [_1]domain coordinator[_2] via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Soll LON-CAPA den [_1]Domänen-Koordinator[_2] benachrichtigen, wenn während der automatischen Aktualisierung Änderungen an der Kursbelegung auftreten?',

   'Course Group Settings'
=> 'Kursgruppen-Einstellungen',

   'Community Group Settings'
=> 'Community-Gruppen-Einstellungen',

   'Set a quota for the total disk space available for storage of course group portfolio files'
=> 'Verfügbarer Gesamtspeicherplatz für Gruppen-Portfolio-Dateien des Kurses',

   'Set a quota for the total disk space available for storage of community group portfolio files'
=> 'Verfügbarer Gesamtspeicherplatz für Gruppen-Portfolio-Dateien der Community',

   'Creation Options'
=> 'Erstellungsoptionen',

   ' Creation Settings'
=> ' Erstellungs-Einstellungen',

   '[_1] Creation Settings'
=> '[_1] Erstellungs-Einstellungen',

   'Creation Outcome'
=> 'Ergebnis der Erstellung',

   'New LON-CAPA course ID:'
=> 'Neue LON-CAPA-Kurs-ID:',

   'Created on'
=> 'Erstellt in Domäne',

   'Cloning course from'
=> 'Kurs geclont aus Domäne',

   'Setting environment'
=> 'Einstellung der Kursumgebung',

   'Opening all assignments'
=> 'Start aller Übungen',

   'Setting first resource'
=> 'Einstellung der ersten Ressource',

   'Assigning role of Course Coordinator to [_1]:'
=> 'Zuweisung der Rolle Kurs-Koordinator an [_1]:',

   'Assigning role of Group Coordinator to [_1]:'
=> 'Zuweisung der Rolle Gruppen-Koordinator an [_1]:',

   'Roles will be active at next login'
=> 'Rollen werden ab dem nächsten Login aktiv sein',

   'Active at next login.'
=> 'Beim nächsten Login aktiv.',

   'Expired after logout.'
=> 'Nach dem Logout abgelaufen.',

   'No new course created.'
=> 'Der Kurs wurde nicht erstellt.',

   'No new community created.'
=> 'Die Community wurde nicht erstellt.',

   'Course Created'
=> 'Erstellungsdatum des Kurses',

   'Community Created'
=> 'Erstellungsdatum der Community',

   'Community created'
=> 'Erstellungsdatum der Community',

   'Course created'
=> 'Erstellungsdatum des Kurses',

   'A new course could not be cloned from the specified original - [_1] - because it is a non-existent course.'
=> 'Ein neuer Kurs kann nicht von dem angegebenen Originalkurs ([_1]) geklont werden, da dieser Kurs nicht existiert.',

   'A new community could not be cloned from the specified original - [_1] - because it is a non-existent community.'
=> 'Eine neue Community kann nicht von der angegebenen Original-Commmunity ([_1]) geklont werden, da diese Community nicht existiert.',

   'The new course could not be cloned from the existing course because the new course owner ([_1]) does not have cloning rights in the existing course ([_2]).'
=> 'Der neue Kurs kann nicht von dem angegebenen Kurs geklont werden, da der neue Kurs-Eigentümer ([_1]) nicht die Berechtigung erteilt bekommen hat, den existierenden Kurs ([_2]) zu klonen.',

   'The new community could not be cloned from the existing community because the new community owner ([_1]) does not have cloning rights in the existing community ([_2]).'
=> 'Die neue Community kann nicht von der angegebenen Community geklont werden, da der neue Community-Eigentümer ([_1]) nicht die Berechtigung erteilt bekommen hat, die existierende Community ([_2]) zu klonen.',

   'Create Another Course'
=> 'Einen weiteren Kurs anlegen',

   'Create Another Group'
=> 'Eine weitere Gruppe anlegen',

   'Create Another Community'
=> 'Eine weitere Community anlegen',

   'from domain'
=> 'aus der Domäne',

   'Submit Evaluation'
=> 'Evaluierung absenden',

   'Thank you for your input!'
=> 'Danke für Ihre Angaben!',

   'Saving feedback: [_1]'
=> 'Speichere Feedback: [_1]',

   'Logging first evaluation'
=> 'Protokolliere erste Evaluation',

   'Standard Problem'
=> 'Standard-Aufgabe',

   'Practice'
=> 'Übung',

   'Exam'
=> 'Prüfung',

   'Survey'
=> 'Umfrage',

   'Surveys'
=> 'Umfragen',

   'Library'
=> 'Bibliothek',

   'Value:'
=> 'Wert:',

   'String Value'
=> 'Text-Wert',

   'practice'
=> 'Übung',

   'Loading Domain Coordinator Menu'
=> 'Lade Domänen-Koordinator-Menü...',

   "Disk space allocated to user's portfolio files"
=> "Speicherplatz für Portfolio-Dateien des Benutzers",

   'Current quota: [_1] MB'
=> 'Derzeitiger Speicherplatz: [_1] MB',

   'Current quota'
=> 'Derzeitiger Speicherplatz',

   'Default ([_1] MB)'
=> 'Voreingestellt ([_1] MB)',

   'Change quota'
=> 'Speicherplatz ändern',

   'Custom quota'
=> 'Selbsteingestellter Speicherplatz',

   'custom quota: [_1] MB'
=> 'Selbsteingestellter Speicherplatz: [_1] MB',

   'Set quota'
=> 'Speicherplatz festlegen',

   'The quota you entered contained invalid characters.'
=> 'Der von Ihnen eingegebene Wert für den Speicherplatz enthält ungültige Zeichen.',

   'Existing sections'
=> 'Bestehende Sektionen',

   'Define new section'
=> 'Neue Sektion erstellen',

   'Create/Modify Another User'
=> 'Andere Benutzeraccounts erstellen oder ändern',

   'Set Privileges for New User'
=> 'Einstellungen für neuen Benutzer',

   'Generating user'
=> 'Erstelle Benutzer',

   'Generating user: [_1]'
=> 'Erstelle Benutzer: [_1]',

   'Home server'
=> 'Heimatserver',

   'Home server: [_1]'
=> 'Heimatserver: [_1]',

   'Modifying Roles'
=> 'Anpassung der Benutzerrollen',

   'No roles to modify'
=> 'Es erfolgte keine Änderung der Benutzerrollen.',

   'starting'
=> 'Start am',

   'Add to classlist:'
=> 'Hinzufügen zur Kursteilnehmerliste:',

   'Change Current Login Data'
=> 'Derzeitige Login-Einstellung ändern',

   'Enter New Login Data'
=> 'Neue Login-Einstellungen',

   'will override current values'
=> 'überschreibt derzeitigen Wert',

   'Section Numbers and corresponding LON-CAPA section IDs'
=> 'Sektionsnummern und korrespondierende LON-CAPA-Sektions-IDs',

   'Overall Assessment Statistical Data'
=> 'Übergreifende statistische Beurteilungsdaten',

   'No new dynamic data found.'
=> 'Keine neuen dynamischen Daten gefunden.',

   'Current value is'
=> 'Aktuelle Einstellung ist',

   'Current value is "[_1]".'
=> 'Aktuelle Einstellung ist "[_1]".',

   'Interval set to version changes [_1]'
=> 'Intervall auf Versionsänderungen [_1] gesetzt',

   'Creating a new problem resource.'
=> 'Neue Aufgabe erstellen',

   'Creating a new library resource.'
=> 'Neue Bibliothek erstellen',

   'Creating a new survey resource.'
=> 'Neue Umfrage erstellen',

   'Creating a new task resource.'
=> 'Neue "Bridgetask"-Datei erstellen',

   'The requested file [_1] currently does not exist.'
=> 'Die angeforderte Datei [_1] existiert momentan nicht.',

   'To create a new problem, select a template from the list below. Then click on the "Create problem" button.'
=> 'Um eine neue Aufgabe zu erstellen, wählen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Aufgabe erstellen"-Button.',

   'To create a new library, select a template from the list below. Then click on the "Create library" button.'
=> 'Um eine neue Bibliothek zu erstellen, wählen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Bibliothek erstellen"-Button.',

   'To create a new survey, select a template from the list below. Then click on the "Create survey" button.'
=> 'Um eine neue Umfrage zu erstellen, wählen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Umfrage erstellen"-Button.',

   'To create a new task, select a template from the list below. Then click on the "Create task" button.'
=> 'Um eine neue "Bridgetask"-Datei zu erstellen, wählen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Bridgetask-Datei erstellen"-Button.',

   'Accessibility Options'
=> 'Alternativ-Login',

   'About LON-CAPA'
=> 'Über LON-CAPA',

   'Course/Community Catalog'
=> 'Kurs-/Community-Übersicht',

   'Course catalog'
=> 'Kursübersicht',

   'If you were expecting to see an active role listed for a particular course in the [_1] domain, it may be missing for one of the following reasons:'
=> 'Falls Sie eine aktive Rolle für einen bestimmten Kurs in der Domäne "[_1]" erwartet haben, könnte es sein, dass diese aus einem der folgenden Gründe fehlt:',

   'The course has yet to be created.'
=> 'Der Kurs wurde noch nicht erstellt.',

   'Automatic enrollment of registered students has not been enabled for the course.'
=> 'Die automatische Kursbelegung registrierter Studierender wurde für diesen Kurs nicht aktiviert.',

   'You are in a section of course for which automatic enrollment in the corresponding LON-CAPA course is not active.'
=> 'Sie sind in einer Sektion des Kurses, für die die automatische Kursbelegung im zugehörigen LON-CAPA-Kurs nicht aktiviert ist.',

   'You registered for the course recently and there is a time lag between the time you register, and the time this information becomes available for the update of LON-CAPA course rosters.'
=> 'Sie haben sich kürzlich für den Kurs registriert und es gibt eine Zeitverzögerung zwischen der Zeit Ihrer Registrierung und dem Erscheinen dieser Information in der LON-CAPA-Kursteilnehmerliste.',

   'If you were expecting to see an active role listed for a particular course, that course may not have been created yet.'
=> 'Falls Sie eine aktive Rolle für einen bestimmten Kurs erwartet haben, könnte es sein, dass diese noch nicht erstellt wurde.',

   'The [_1]Course/Community Catalog[_2] provides information about all [_3] classes for which LON-CAPA courses have been created, as well as any communities in the domain.' # [_3]: domain
=> 'Die [_1]Kurs-/Community-Übersicht[_2] enthält Informationen über alle Kurse der Einrichtung [_3], für die LON-CAPA-Kurse sowie Communitys in dieser Domäne eingerichtet wurden.',

   'You can search for courses and communities which permit self-enrollment, if you would like to enroll in one.'
=> 'Falls Sie sich in einen Kurs oder in eine Community eintragen möchten, können Sie die Kurs-/Community-Übersicht nach Kursen und Communitys durchsuchen, die eine Selbsteintragung zulassen.',

   'Log-in Help'
=> 'Login-Hilfe',

   'Forgot password?'
=> 'Passwort vergessen?',

   'New User?'
=> 'Neuer Benutzer?',

   'Crosslisted'
=> 'fachübergreifend',

   'Owner'
=> 'Eigentümer',

   'Code'
=> 'Kurscode',

   'Course listing'
=> 'Auflistung der Kurse',

   'Community listing'
=> 'Auflistung der Communitys',

   'Display information about official [_1] classes for which LON-CAPA courses have been created:'
=> 'Informationen zu offiziellen Kursen der [_1], für die LON-CAPA-Kurse eingerichtet wurden',

   'help/support'
=> 'Hilfe und Support',

   'Log-in help'
=> 'Login-Hilfe',

   'Ask helpdesk'
=> 'Helpdesk kontaktieren',

   'Back to last location'
=> 'Zurück zum letzten Ort',

   'LON-CAPA help/support'
=> 'LON-CAPA-Hilfe und -Support',

   'Topic help'
=> 'Hilfe zum Thema',

   'FAQ'
=> 'FAQ',

   'Note'
=> 'Anmerkung',

   'Student questions about course content should be directed to the course instructor'
=> 'Studentische Fragen zum Kursinhalt richten Sie bitte direkt an den Dozenten des Kurses',

   'Questions about course content should not be directed to the support team, but instead should be sent to the course instructor'
=> 'Fragen zum Kursinhalt sollten nicht an die Kundenbetreuung, sondern stattdessen an den Kurs-Koordinator des Kurses gerichtet werden.',

   '[_1]Note[_2]: questions about course content should not be directed to the support team, but instead should be sent to the course instructor.'
=> '[_1]Hinweis[_2]: Fragen zum Kursinhalt sollten nicht an die Kundenbetreuung, sondern stattdessen an den Kurs-Koordinator des Kurses gerichtet werden.',

   'This can be done by clicking the [_1]Communicate[_2] link or the "Send Feedback" link when viewing a content page.'
=> 'Dies ist möglich, indem Sie auf den Link [_1]Kommunikation[_2] klicken oder indem Sie auf den Link "Feedback geben" klicken, wenn Sie sich auf einer Kursinhaltsseite befinden.',

   'Submit Request'
=> 'Anfrage abschicken',

   'E-mail address'
=> 'E-Mail-Adresse',

   'e-mail address'
=> 'E-Mail-Adresse',

   'Sender e-mail address'
=> 'E-Mail Adresse des Absenders',

   'Enter the username you use to log-in to LON-CAPA, and your domain.'
=> 'Geben Sie Ihre LON-CAPA-Benutzerkennung ein und wählen Sie Ihre Domäne.',

   'URL of page'
=> 'URL der Seite',

   'Phone'
=> 'Telefon-Nr.',

   'Course Details'
=> 'Kursdetails',

   'Enter institutional course code'
=> 'Institutioneller Kurs-Code',

   'Enter course title'
=> 'Kurstitel',

   'Section Number'
=> 'Sektionsnummer',

   'LON-CAPA sec'
=> 'LON-CAPA-Sektion',

   'Detailed Description'
=> 'Detaillierte Beschreibung',

   'Clear Form'
=> 'Formular zurücksetzen',

   'Material presented in clear way'
=> 'Das Material wird in einer verständlichen Art dargestellt',

   'Material covered with sufficient depth'
=> 'Das Thema wird in ausreichender Tiefe behandelt',

   'Material is helpful'
=> 'Das Material ist hilfreich',

   'Material appears to be correct'
=> 'Das Material scheint korrekt zu sein',

   'This will only retrieve the resource. If you want to retrieve the metadata, you will need to do that separately.'
=> 'Die Aktion wird lediglich die Ressource selbst wiederherstellen. Möchten Sie auch eine alte Version der Metadaten zu dieser Ressource wiederherstellen, müssen Sie dies extra tun.',

   'is in this state due to author settings.'
=> 'befindet sich aufgrund von Einstellungen des Autors temporär in diesem Zustand.',

   'User Data for'
=> 'Benutzerdaten von',

   'Enroll Student'
=> 'Student/in Kurs belegen lassen',

   'If active, the new role will be available when the student next logs in to LON-CAPA.'
=> 'Falls bereits aktiv, wird die Rolle ab dem nächsten Login für den/die Student/in verfügbar sein.',

   'Enroll Another Student'
=> 'Eine/n weitere/n Studenten/in den Kurs belegen lassen',

   'start date'
=> 'Anfangsdatum',

   'end date'
=> 'Enddatum',

   'active groups'
=> 'Aktive Gruppen',

   'active group(s)'
=> 'Aktive Gruppen',

   'View recent activity'
=> 'Zuletzt stattgefundene Aktivitäten',

   'View recent activity by this student'
=> 'Zuletzt stattgefundene Aktivitäten dieses/r Studenten/in',

   'View recent activity by this person'
=> 'Zuletzt stattgefundene Aktivitäten dieser Person',

   'Recent activity of [_1]'
=> 'Zuletzt stattgefundene Aktivitäten von [_1]',

   'Compiling student activity data can take a long time. Your request continues to be processed while results are displayed.'
=> 'Das Zusammenstellen der Aktivitätsdaten kann eine Weile dauern. Ihre Anfrage wird weiter verarbeitet, während die schon vorhandenen Ergebnisse bereits angezeigt werden.',

   'Composing Query'
=> 'Stelle Anfrage zusammen',

   'Student Activity'
=> 'Studentische Aktivitäten',

   'Waiting up to [_1] seconds for results'
=> 'Warte noch maximal [_1] Sekunden auf Ergebnisse',

   'Activity data compiled up to [_1]'
=> 'Aktivitätsdaten zusammengestellt bis [_1]',

   'While data is processed, periodically reload this page for more recent activity'
=> 'Während die Daten verarbeitet werden, können Sie gelegentlich die Seite aktualisieren, um aktuellere Aktivitätsdaten zu erhalten.',

   'Data'
=> 'Daten',

   'Resubmit last request to check for newer data'
=> 'Letzte Anfrage erneut abschicken, um auf aktuellere Daten zu prüfen',

   'View Classlist'
=> 'Kursteilnehmerliste anschauen',

   'View class list'
=> 'Kursteilnehmerliste anschauen',

   'Count'
=> 'Zähler',

   'Modifying authentication:'
=> 'Ändere Authentifizierung:',

   'Modify User Privileges'
=> 'Benutzerrechte ändern',

   'Insert:'
=> 'Einfügen:',

   'Delete?'
=> 'Löschen?',

   'Randomize Foil Order:'
=> 'Reihenfolge der Auswahlmöglichkeiten randomisieren:',

   'Use template:'
=> 'Vorlage verwenden:',

   'Display Direction'
=> 'Anzeige-Richtung:',

   'vertical'
=> 'vertikal',

   'horizontal'
=> 'horizontal',

   'Script'
=> 'Skript-Block',

   'Problem Editing'
=> 'Aufgabenerstellung',

   'Hint'
=> 'Hinweis',

   'Show hint even if problem Correct:'
=> 'Hinweis auch zeigen, wenn Aufgabe richtig beantwortet wurde:',

   'Single Line Text Entry Area'
=> 'Zeile mit Texteingabefeld',

   'Parameters for a response'
=> 'Parameter für Antworttyp',

   'Problem Part'
=> 'Aufgabenteil',

   'Part:'
=> 'Teil:',

   'Part ID'
=> 'Aufgabenteil-ID',

   'Part ID:'
=> 'Aufgabenteil-ID:',

   'Part ID: [_1]'
=> 'Aufgabenteil-ID: [_1]',

   'Response ID'
=> 'Antwort-ID',

   'Response ID: [_1]'
=> 'Antwort-ID: [_1]',

   'Res. ID'
=> 'Aufg.-ID',

   'Points:'
=> 'Punkte:',

   'Trial not counted'
=> 'Versuch wird nicht gezählt',

   'Trial: [_1]'
=> 'Versuch: [_1]',

   'Displayed Part Description:'
=> 'Anzuzeigende Aufgabenteil-Beschreibung:',

   'Readonly:'
=> 'Nur lesbar:',

   'Response: Numerical'
=> 'Antwortblock: numerisch',

   'random'
=> 'zufällig',

   'top'
=> 'am Anfang',

   'bottom'
=> 'am Ende',

   'Add new Option:'
=> 'Option hinzufügen:',

   'Delete an Option:'
=> 'Option löschen:',

   'Print options:'
=> 'Ausgabe der Optionen:',

   "Don't show option list"
=> "Optionsliste nicht anzeigen",

   'Display of options when printed'
=> 'Anzeigeart der Optionen beim Druck',

   'Normal list'
=> 'Normale Liste',

   'Listed in vertical column'
=> 'In senkrechter Spalte aufgelistet',

   'Multiple Option Response Question'
=> 'Antwortblock: Optionsauswahl',

   'Select Options'
=> 'Wählbare Optionen',

   'Image'
=> 'Bild',

   'Images'
=> 'Bilder',

   'Image Url:'
=> 'URL des Bildes:',

   'width (pixel):'
=> 'Breite (Pixel):',

   'height (pixel):'
=> 'Höhe (Pixel):',

   'Alignment:'
=> 'Ausrichtung:',

   'Encrypt URL:'
=> 'URL verschlüsseln:',

   'no'
=> 'nein',

   'Location:'
=> 'Stelle:',

   'Randomly labeled image'
=> 'Dynamisch beschriftetes Bild',

   'Response: Click on Image'
=> 'Antwortblock: Klick-ins-Bild',

   'Collection of Imageresponse foils'
=> 'Sammlung von Auswahlmöglichkeiten für Klick-ins-Bild-Antwort',

   'Image response foil'
=> 'Auswahlmöglichkeit für Klick-ins-Bild-Antwort',

   'Enter Coordinates'
=> 'Koordinaten festlegen',

   'Rectangle'
=> 'Rechteck',

   'Coordinate Pairs'
=> 'Koordinatenpaar',

   'Polygon'
=> 'Polygon',

   'Coordinate list'
=> 'Koordinatenliste',

   'Create Polygon Data'
=> 'Polygon-Daten festlegen',

   'Task Description'
=> 'Beschreibung der Aufgabe',

   'Clickable Image'
=> 'Anklickbares Bild',

   'Image Source File'
=> 'Pfad und Name der Bilddatei',

   'No image source specified'
=> 'Pfad und Name des Bildes nicht angegeben',

   'Select Position on Image'
=> 'Auswahl der Position im Bild',

   'Select First Coordinate on Image.'
=> 'Klicken Sie an die Stelle der ersten Koordinate.',

   'Select Second Coordinate on Image.'
=> 'Klicken Sie an die Stelle der zweiten Koordinate.',

   'Select [_1] to save selection.'
=> 'Klicken Sie zum Speichern der Auswahl auf [_1].',

   'Click to select a Coordinate or click [_1] to close Polygon.'
=> 'Klicken Sie in das Bild, um eine Koordinate festzulegen oder klicken Sie auf [_1], um das Polygon zu schließen.',

   'Click to select a Coordinate or click [_1] to save current selection.'
=> 'Klicken Sie in das Bild, um eine Koordinate festzulegen oder klicken Sie auf [_1], um die derzeitige Auswahl zu speichern.',

   'New Name'
=> 'Neuer Name',

   'Make Obsolete'
=> 'Als veraltet kennzeichnen',

   'Set Margins'
=> 'Seitenränder festlegen',

   'How should each column be formatted?'
=> 'Wie soll jede Spalte formatiert werden?',

   'Height'
=> 'Höhe',

   'Width:'
=> 'Breite:',

   'Height:'
=> 'Höhe:',

   'Left Margin'
=> 'Linker Rand',

   'Username and/or password could not be authenticated.'
=> 'Benutzerkennung und/oder Passwort konnten nicht erfolgreich authentifiziert werden.',

   'Please check the username and password.'
=> 'Bitte überprüfen Sie Ihre Benutzerkennung und Ihr Passwort.',

   'Try again'
=> 'Nochmal versuchen',

   'Try again?'
=> 'Nochmal versuchen?',

   'Information needed to verify your login information is missing, inaccessible or expired.'
=> 'Informationen, die notwendig sind, um Ihre Logindaten überprüfen zu können, fehlen, können nicht gelesen werden oder sind abgelaufen.',

   'Sending'
=> 'Sende',

   'Completed.'
=> 'Ausgeführt.',

   'Messages being sent.'
=> 'Nachrichten wurden gesendet',

   'Assigning'
=> 'Zuweisung der Rolle',

   'Assigning [_1] in [_2] starting [_3]'
=> 'Zuweisung der Rolle [_1] in [_2] mit Anfangsdatum: [_3]',

   'ending'
=> 'Ende am',

   'Assistant Co-Author'
=> 'Autor-Assistent',

   'Metadata for [_1]'
=> 'Metadaten für [_1]',

   'There are [_1] matches to your query.'
=> 'Ihre Suche hat [_1] Treffer ergeben.',

   'There were no results matching your query.'
=> 'Ihre Suche hat keine Treffer ergeben.',

   'Total of [quant,_1,match,matches] to your query.'
=> 'Ihre Suche hat ingesamt [quant,_1,Treffer,Treffer] ergeben.',

   'Total number of queries: [_1]'
=> 'Gesamtanzahl an Anfragen: [_1]',

   'Revise search'
=> 'Suche ändern',

   'Revise Search Request'
=> 'Suchanfrage ändern',

   'Revise search request'
=> 'Suchanfrage ändern',

   'Internal Error - Bad view selected.'
=> 'Interner Fehler - ungültige Ansicht ausgewählt',

   'Unable to save import results.'
=> 'Eingelesene Ergebnisse konnten nicht gespeichert werden.',

   'A MySQL error has occurred.'
=> 'Ein MySQL-Fehler ist aufgetreten.',

   'The table of results could not be found.'
=> 'Die Tabelle mit den Ergebnissen konnte nicht gefunden werden.',

   'Number of accesses'
=> 'Anzahl der Zugriffe',

   'Ascending'
=> 'aufsteigend',

   'Descending'
=> 'absteigend',

   'Students Attempting'
=> 'Studentische Versuche', # ??? [SB 2007-07-03] lonproblemstatistics.pm

   'Average Number of Tries'
=> 'Durchschnittliche Anzahl an Versuchen',

   'Mean Degree of Difficulty'
=> 'Durchschnittlicher Schwierigkeitsgrad',

   'Mean Degree of Discrimination'
=> 'Durchschnittlicher Grad der Abgrenzung',

   'Evaluation: Clear'
=> 'Evaluierung: Klar',

   'Evaluation: Technically Correct'
=> 'Evaluierung: Technisch korrekt',

   'Evaluation: Material is Correct'
=> 'Evaluierung: Material ist korrekt',

   'Evaluation: Material is Helpful'
=> 'Evaluierung: Material ist hilfreich',

   'Evaluation: Material has Depth'
=> 'Evaluierung: Tiefe des Themas',

   'Prev'
=> 'Zurück',

   'Reload'
=> 'Aktualisieren',

   'Results [_1] to [_2] out of [_3]'
=> 'Treffer [_1] bis [_2] von insgesamt [_3]',

   'Unactionable Search Query'
=> 'Suchanfrage zurückgewiesen',

   'LON-CAPA Access Control'
=> 'LON-CAPA-Zugriffskontrolle',

   'Access  : '
=> 'Zugriff  : ',

   'Resource: '
=> 'Ressource: ',

   'Action  : '
=> 'Aktion   : ',

   'You have modified your course recently, [_1] may fix this access problem.'
=> 'Sie haben den Kurs kürzlich verändert. [_1] könnte das Zugriffsproblem beheben.',

   'Published on ...'
=> 'Veröffentlicht am...',

   'Currently published version'
=> 'Derzeit veröffentlichte Version',

   'Cleanup XML Document'
=> 'XML-Code aufräumen',

   'Select actions to attempt'
=> 'Auswahl der gewünschten Aktionen',

   'Linefeeds, formfeeds, and carriage returns'
=> 'Zeilenumbrüche (LF), Seitenvorschübe und "Wagenrückläufe" (CR)',

   'Empty tags'
=> 'Leere Tags',

   'Lower casing'
=> 'Kleinschreibung',

   'Symbol font'
=> 'Symbol-Zeichensatz',

   'Back to Source File'
=> 'Zurück zur Quelldatei',

   'Original file'
=> 'Original-Datei',

   'Cleaned up file'
=> 'Aufgeräumte Datei',

   'Open (and edit) cleaned up file in new window'
=> 'Aufgeräumte Datei zum Editieren öffnen (in neuem Fenster)',

   'Show diffs in new window'
=> 'Unterschiede zeigen (in neuem Fenster)',

   'Accepting changes...'
=> 'Änderungen werden durchgeführt...',

   'Rejecting changes...'
=> 'Änderungen werden abgebrochen...',

   'Hypertext Cascading Style Sheet'
=> 'Stylesheet-Datei',

   'Online Survey'
=> 'Umfrage',

   'Unable to find [_1]'
=> 'Die Datei [_1] konnte nicht gefunden werden.',

   ' Unable to find [_1]'
=> ' Die Datei [_1] konnte nicht gefunden werden.',

   'Post Server Announcements'
=> 'Server-Bekanntmachungen',

   'Post announcements to the system login and roles screen'
=> 'Server-Bekanntmachungen für die Login-Seite und die Rollenauswahl',

   '(leave blank to delete announcement)'
=> '(leer lassen, um Bekanntmachung zu entfernen)',

   'Check machines:'
=> 'Server auswählen:',

   'Current Announcement'
=> 'Derzeitige Bekanntmachung',

   'Calendar'
=> 'Kalender',

   'Download your Calendar as iCalendar File'
=> 'Kalender-Download im iCalendar-Format',

   'No calendar available for this date.'
=> 'Für dieses Datum ist kein Kalender verfügbar.',

   'Posting [_1]'
=> 'Sende an [_1]',

   'This LON-CAPA server is version [_1]'
=> 'Auf diesem LON-CAPA-Server läuft Version [_1]',

   'Only changes made from servers running LON-CAPA [_1] or later are displayed.'
=> 'Es werden nur Änderungen angezeigt, die auf Servern mit der LON-CAPA-Version [_1] oder später vorgenommen wurden.',

   'Edit Answer'
=> 'Antwort editieren',

   'Date/Time'
=> 'Datum, Uhrzeit',

   'Threshold Name'
=> 'Schwellenwert-Name',

   'Current value'
=> 'Aktueller Wert',

   'Change?'
=> 'Ändern',

   'Change thresholds'
=> 'Schwellenwerte ändern',

   'Picture Conversion Status'
=> 'Bildkonvertierungs-Status',

   'Class Print Status'
=> 'Druckstatus',

   'Removing error messages:'
=> 'Entfernen von Fehlermeldungen:',

   'Invalid target directory, FAIL'
=> 'Ungültiges Zielverzeichnis. Abbruch!',

   'Creating old version [_1]'
=> 'Erstelle alte Version [_1]',

   'Initial version'
=> 'Urversion',

   'Press "Generate Statistics" when you are ready.'
=> 'Klicken Sie auf "Statistiken erstellen", wenn Sie die gewünschten Einstellungen vorgenommen haben.',

   'It may take some time to update the student data for the first analysis. Future analysis this session will not have this delay.'
=> 'Es kann einige Zeit dauern, um die studentischen Daten für die erste Analyse zu aktualisieren. Zukünftige Analysen werden nicht diese Verzögerung verursachen.',

   'A course-wide error occurred.'
=> 'Ein kursweiter Fehler ist aufgetreten.',

   'none'
=> 'nichts',

   'Prepare Report'
=> 'Bericht erstellen',

   'Show problem'
=> 'Aufgabe anzeigen',

   'Show correct answers'
=> 'Korrekte Antworten anzeigen',

   'Show all submissions'
=> 'Alle Einreichungen anzeigen',

   'Show problem grading'
=> 'Aufgabenbewertung anzeigen',

   'Computing correct answers greatly increases the amount of time required to prepare a report.'
=> 'Die Berechnung korrekter Antworten erhöht die benötigte Zeit erheblich, um den Bericht zu erstellen.',

   'Please select problems and use the [_1]Prepare Report[_2] button to continue.'
=> 'Wählen Sie die zu berücksichtigenden Aufgaben aus und klicken Sie anschließend auf den [_1]Bericht erstellen[_2]-Button.',

   'Please select a Survey to analyze'
=> 'Wählen Sie eine Umfrage, die analysiert werden soll:',

   'There are no survey problems in this course.'
=> 'In diesem Kurs sind keine Umfragen enthalten.',

   'Generate Survey Report'
=> 'Umfragebericht generieren',

   'Building text document.'
=> 'Erstelle Textdokument.',

   'Your text file'
=> 'Ihre Textdatei',

   'Done compiling text file. See link below to download.'
=> 'Erstellung der Textdatei abgeschlossen. Verwenden Sie den unten angegebenen Link zum Herunterladen.',

   'There is no essay or string response data to output for this survey.'
=> 'In dieser Umfrage existieren keine Essay- oder Text-Antwortdaten (essayresponse, stringresponse), die ausgegeben werden könnten.',

   'Building spreadsheet.'
=> 'Erstelle Tabelle.',

   '[_1]:[_2] responses to [_3] may be too long to fit Excel spreadsheet.'
=> '[_1]:[_2]-Antworten für [_3] könnten zu lang sein, um in einer Excel-Tabelle Platz zu finden.',

   'Done compiling spreadsheet. See link below to download.'
=> 'Erstellung der Tabelle abgeschlossen. Verwenden Sie den unten angegebenen Link zum Herunterladen.',

   'Make a sequence selection from the "Sequences and Folders" menu and hit "Create Plot" to begin'
=> 'Wählen Sie eine Sequenz aus der "Sequenzen und Verzeichnisse"-Liste und klicken Sie auf "Diagramm erstellen", um zu starten.',

   'Create Plot'
=> 'Diagramm erstellen',

   'Start Time:'
=> 'Startzeit:',

   'Start Time: [_1]'
=> 'Startzeit: [_1]',

   'End Time:'
=> 'Endezeit:',

   'Sender'
=> 'Absender',

   'Number'
=> 'Nummer',

   'Upload Classlist'
=> 'Kursteilnehmerliste hochladen',

   'Semicolon separated values'
=> 'Durch Semikolons getrennt',

   'Show Log'
=> 'Protokoll anzeigen',

   'Course Document Change Log'
=> 'Kursressourcen-Veränderungs-Protokoll',

   'Records'
=> 'Datensätze',

   'Before'
=> 'Vorher',

   'After'
=> 'Nachher',

   'Current folder/page'
=> 'Aktuelles Verzeichnis/Seite',

   'Containing phrase'
=> 'Enthält Text:',

   'None'
=> 'nichts',

   'Users'
=> 'Benutzer',

   'Include parameter types'
=> 'Parametertypen zeigen',

   'Parameter Change Log'
=> 'Parameteränderungs-Protokoll',

   'Announce'
=> 'Bekanntmachen',

   'Not active anymore'
=> 'nicht mehr aktiv',

   'Add to Course Announcements'
=> 'Den Kursbekanntmachungen hinzufügen',

   'Username : Domain'
=> 'Benutzerkennung:Domäne',

   'User Status'
=> 'Benutzerstatus',

   'Active'
=> 'aktiv',

   'Moderately Active'
=> 'Mäßig aktiv',

   'Inactive'
=> 'Inaktiv',

   'User Counts'
=> 'Benutzeranzahl',

   'Overall'
=> 'Gesamt',

   'Browser'
=> 'Webbrowser',

   'OS'
=> 'Betriebssystem',

   'Load Average'
=> 'Durchschnittliche Auslastung',

   'Login time'
=> 'Zeitpunkt des Logins',

   'Last Transaction'
=> 'Letzte Transaktion',

   'Last Access'
=> 'Letzter Zugriff',

   'secs ago'
=> 'Sekunden vergangen',

   'Expired'
=> 'Abgelaufen',

   'expired'
=> 'Abgelaufen',

   'Future'
=> 'Zukünftig',

   'future'
=> 'Zukünftig',

   'Sort by realm first, then student (group/section)'
=> 'Sortierung nach Bereich, dann nach Student/in (Gruppe/Sektion)',

   'Sort by student (group/section) first, then realm'
=> 'Sortierung nach Student/in (Gruppe/Sektion), dann nach Bereich',

   'Shift all dates based on this date'
=> 'Alle Datumseinträge anhand dieses Datums verschieben',

   'Overview Mode'
=> 'Übersichtsmodus',

   'Overview'
=> 'Übersicht',

   'Set Parameters'
=> 'Parameter einstellen',

   'Parts'
=> 'Aufgabenteile',

   'Section(s)'
=> 'Sektion(en)',

   'Group(s)'
=> 'Gruppe(n)',

   'Parameter Selection'
=> 'Parameter-Auswahl',

   'Add Selection for...'
=> 'Auswahl hinzufügen für...',

   'Select Common Only'
=> 'Nur Übliche wählen',

   'Problem Dates'
=> 'Aufgabendatumsfelder',

   'Content Dates'
=> 'Inhaltsdatumsfelder',

   'Discussion Settings'
=> 'Diskussions-Einstellungen',

   'Visibilities'
=> 'Sichtbarkeit',

   'Part Parameters'
=> 'Aufgabenteil-Parameter',

   'For User [_1] or Student/Employee ID [_2] at Domain [_3]'
=> 'Für Benutzer [_1] oder Studierenden-/Mitarbeiter-ID [_2] in der Domäne [_3]',

   'Group Portfolio'
=> 'Gruppen-Portfolio',

   "Enter user:domain for User's Personal Information Page"
=> "Geben Sie Benutzerkennung:Domäne für die persönliche Seite des gewünschten Benutzers ein:",

   'No map selected.'
=> 'Keine Inhaltszusammenstellung gewählt!',

   'Most Recent:'
=> 'Aktuellste:',

   'most recent'
=> 'aktuellste',

   'In Course:'
=> 'Im Kurs:',

   'Use:'
=> 'Verwende:',

   'Search LON-CAPA help'
=> 'Suche in der LON-CAPA-Hilfe',

   'Before course enrollment start!'
=> 'Liegt VOR Kursbelegungs-Start!',

   'After course enrollment end!'
=> 'Liegt NACH Kursbelegungs-Ende!',

   'in the past'
=> 'liegt in der Vergangenheit',

   'in the future'
=> 'liegt in der Zukunft',

   'Choose'
=> 'Übernehmen',

   'Title:'
=> 'Titel:',

   'URL:'
=> 'URL:',

   'Course, Portfolio and Catalog Search'
=> 'Katalog-Suche, Portfolio-Suche und Suche im Kurs',

   'ERROR:'
=> 'FEHLER:',

   '(click for example)'
=> '(Klicken für Beispiel)',

   'click for example'
=> 'Klicken für Beispiel',

   'Re-Enable'
=> 'wieder aktivieren',

   'Script Functions'
=> 'Funktionen in Skripten',

   'Image Options'
=> 'Bildoptionen',

   'left'
=> 'links',

   'right'
=> 'rechts',

   'middle'
=> 'mittig',

   'Middle'
=> 'mittig',

   'TeXwidth (mm):'
=> 'TeX-Breite (mm):',

   'TeXheight (mm):'
=> 'TeX-Höhe (mm):',

   'TeXwrap:'
=> 'TeX-Umbruch',

   'Sorry!'
=> 'Schade...',

   'Resource not available.'
=> 'Ressource nicht erreichbar.',

   'File Type'
=> 'Dateityp',

   'Decompress [_1]?'
=> '[_1] entpacken?',

   'Output of decompress:'
=> 'Ausgabe des Entpackvorgangs:',

   'Decompress complete.'
=> 'Entpackvorgang abgeschlossen.',

   'Archive:'
=> 'Archiv:',

   'inflating:'
=> 'entpacke:',

   'Incorrect:'
=> 'Inkorrekt:',

   'Correct:'
=> 'Korrekt:',

   'Correct'
=> 'Korrekt',

   'Partially Correct'
=> 'Teilweise korrekt',

   'Pick course first'
=> 'Erst Kurs auswählen',

   'User Information Changed'
=> 'Geänderte Benutzerdaten',

   'Previous Value:'
=> 'Vorheriger Wert:',

   'Changed To:'
=> 'Geändert in:',

   'disk space allocated to portfolio files'
=> 'Speicherplatz für Portfolio-Dateien',

   'You have new messages'
=> 'Sie haben neue Nachrichten',

   'Destination folder'
=> 'Zielverzeichnis',

   'Mark Read'
=> 'Als gelesen kennzeichnen',

   'Move to Folder ->'
=> 'Verschiebe in Verzeichnis',

   'Register Response Devices (&quot;Clickers&quot;)'
=> 'Antwortgeräte ("Clicker") registrieren',

   'Enter response device ("clicker") numbers'
=> 'Geben Sie die Nummern der Antwortgeräte ("Clicker") ein',

   'Locating your clicker ID'
=> 'Die Clicker-ID ausfindig machen',

   'Register Clicker'
=> 'Clicker registrieren',

   'Register'
=> 'Registrieren',

   'New Link'
=> 'Neues Lesezeichen',

   'Refresh'
=> 'Aktualisieren',

   'Custom metadata [_1]'
=> 'Eigene Metadaten [_1]',

   'Custom Metadata'
=> 'Eigene Metadaten',

   'Question/Comment/Feedback about course content'
=> 'Frage/Anmerkung/Feedback zum Kursinhalt',

   'Question/Comment/Feedback about community content'
=> 'Frage/Anmerkung/Feedback zum Community-Inhalt',

   'User modify/custom role edit'
=> 'Benutzeraccounts und Rechte verwalten',

   'User Search'
=> 'Benutzersuche',

   'to add/modify roles'
=> ', um Rollen hinzuzufügen oder zu ändern',

   'is'
=> 'ist',

   'contains'
=> 'enthält',

   'Contains'
=> 'enthält',

   'in this domain'
=> 'in dieser Domäne',

   'in institutional directory'
=> 'im Institutionsverzeichnis',

   'Domain/institution to search'
=> 'LON-CAPA-Domäne, in der gesucht werden soll',

   'Directory search has not been configured for domain: [_1]'
=> 'Die Verzeichnissuche wurde noch nicht für die Domäne [_1] konfiguriert!',

   'permanent e-mail'
=> 'Permanente E-Mail-Adresse',

   'Set user role'
=> 'Benutzerrolle einrichten',

   'Make new user "[_1]"'
=> 'Neuen Benutzer "[_1]" anlegen',

   'Course Editor'
=> 'Kurs-Editor',

   'Community Editor'
=> 'Community-Editor',

   'Choose which items you wish to export from your Course.'
=> 'Wählen Sie, welche Elemente aus dem Kurs exportiert werden sollen.',

   'Choose which items you wish to export from your Community.'
=> 'Wählen Sie, welche Elemente aus der Community exportiert werden sollen.',

   'Content items'
=> 'Inhaltselemente',

   'Discussion posts'
=> 'Diskussionsbeiträge',

   'Discussion postings'
=> 'Diskussionsbeiträge',

   'IMS course archive'
=> 'IMS-Kursarchiv',

   'last name, first name'
=> 'Nachname, Vorname',

   'Select a Template'
=> 'Auswahl einer Vorlage',

   'Edit custom role'
=> 'Benutzerdefinierte Benutzerrolle einrichten',

   'Privilege'
=> 'Berechtigung',

   'Showing users with a name starting with [_1]'
=> 'Anzeige von Benutzern, deren Name beginnt mit [_1]',

   'Permanent e-mail address'
=> 'Permanente E-Mail-Adresse',

   'User [_1] in domain [_2]'
=> 'Benutzer [_1] in Domäne [_2]',

   'Result'
=> 'Ergebnis',

   'Directory search in domain [_1] is not available for the requested search type: "[_2]"'
=> 'Die Institutssuche in der Domäne [_1] ist für den angeforderten Suchtyp "[_2]" nicht verfügbar.',

   'Setting'
=> 'Einstellung',

   'Directory search available?'
=> 'Verzeichnissuche verfügbar machen?',

   'Edit action'
=> 'Aktion',

   'Effect'
=> 'Effekt',

   'Course / User'
=> 'Kurs / Benutzer',

   'deny'
=> 'verweigern',

   'allow'
=> 'zulassen',

   'Delete this rule'
=> 'Diese Regel löschen',

   'Insert rule above'
=> 'Regel oberhalb einfügen',

   'Insert rule below'
=> 'Regel unterhalb einfügen',

   'Move rule down'
=> 'Regel nach unten verschieben',

   'Move rule up'
=> 'Regel nach oben verschieben',

   'Warning: It can take up to 1 hour for rights changes to fully propagate.'
=> 'Achtung: Es kann bis zu einer Stunde dauern, bis alle Rechte-Änderungen vollständig wirken.',

   'Updated'
=> 'Geändert',

   'The error occurred on host [_1]'
=> 'Der Fehler trat auf dem Host [_1] auf.',

   'This error occurred on machine [_1]'
=> 'Dieser Fehler trat auf Maschine [_1] auf.',

   'Clear all Messages in Subdirectory'
=> 'Alle Nachrichten im Unterverzeichnis entfernen',

   'Task information'
=> 'Information',

   'Automated adds/drops'
=> 'Automatische Hinzufügungen/Ausschließungen',

   'Change enrollment dates'
=> 'Kursbelegungszeiten ändern',

   'Change access dates'
=> 'Zugriffszeiten ändern',

   'Notification of changes'
=> 'Benachrichtigung über Änderungen',

   'Change crosslistings'
=> 'Fachübergreifende Querverweise ändern',

   'Section settings'
=> 'Sektions-Einstellungen',

   'Student photo settings'
=> 'Einstellungen studentischer Fotos',

   'Update roster now'
=> 'Kursteilnehmerliste jetzt aktualisieren',

   'Update student photos'
=> 'Studentische Fotos aktualisieren',

   'View students and change type'
=> 'Studierende betrachten und Typ ändern',

   'Changes to nightly automated enrollments'
=> 'Die nächtlichen, automatischen Kursbelegungen ändern',

   'Currently: Nightly adds: [_1], Nightly drops: [_2]'
=> 'Derzeit: Nächtliche Hinzufügungen: [_1], nächtliche Ausschließungen: [_2]',

   'OFF'
=> 'AUS',

   'ON'
=> 'AN',

   'Additions based on classlist changes:'
=> 'Hinzufügungen aufgrund von Änderungen an der Kursteilnehmerliste:',

   'Removals based on classlist changes:'
=> 'Ausschließungen aufgrund von Änderungen an der Kursteilnehmerliste:',

   'Enable'
=> 'Aktivieren',

   'Disable'
=> 'Deaktivieren',

   'Note: Any students added manually by course coordinators using the Enrollment Manager will be unaffected by the nightly removal process if you choose to enable it.'
=> 'Hinweis: Alle Studierenden, die manuell durch den Kurs-Koordinator über die Kursbelegungs-Verwaltung hinzugefügt wurden, werden beim nächtlichen Ausschließungsprozess NICHT berücksichtigt, auch wenn die Ausschließungs-Option aktiviert ist.',

   'Changes to first and/or last automated enrollment dates'
=> 'Änderungen von Anfangs- und/oder Enddatum der automatischen Kursbelegung',

   'Currently: First enrollment: [_1], Last enrollment: [_2]'
=> 'Derzeit: Erste Kursbelegung: [_1], letzte Kursbelegung: [_2]',

   'Set date of first automated enrollment for registered students'
=> 'Einstellen des Anfangsdatums der automatischen Kursbelegung für registrierte Studierende',

   'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, once the first enrollment date has been reached. Prior to this date, the class roster will only contain students you have added directly using the standard LON-CAPA enrollment tools'
=> 'Falls das automatische Hinzufügen und Ausschließen aktiviert ist, wird ab dem Datum der ersten Kursbelegung nächtlich die Kursteilnehmerliste automatisch aktualisiert. Vor diesem Zeitpunkt wird die Kursteilnehmerliste nur Studierende enthalten, die über die manuelle Kursbelegung in LON-CAPA eingetragen wurden.',

   'Set date of last automated enrollment for registered students'
=> 'Einstellen des Datums der letzten, automatischen Kursbelegung für registrierte Studierende',

   'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, until the last enrollment date has been reached.'
=> 'Falls das automatische Hinzufügen und Ausschließen aktiviert ist, wird bis zum Erreichen des Datums der letzten Kursbelegung nächtlich die Kursteilnehmerliste automatisch aktualisiert.',

   'Changes to default start and/or end dates for student access'
=> 'Änderungen an dem voreingestellten Anfangs- und/oder Enddatum für studentischen Zugriff',

   'Currently: default first access:'
=> 'Derzeit: voreingestellter erster Zugriff:',

   'Currently: default first access'
=> 'Derzeit: voreingestellter erster Zugriff',

   ', default last access:'
=> ', voreingestellter letzter Zugriff:',

   'default last access'
=> 'voreingestellter letzter Zugriff',

   'Set date of first access for registered students added via automated enrollment'
=> 'Einstellen des Datums für den ersten studentischen Zugriff registrierter Studierender, die über die automatische Kursbelegung hinzugefügt werden',

   'Set date of last access for registered students added via automated enrollment'
=> 'Einstellen des Datums für den letzten studentischen Zugriff registrierter Studierender, die über die automatische Kursbelegung hinzugefügt werden',

   'Changes to section settings'
=> 'Sektionseinstellungen',

   'Currently no sections of'
=> 'Derzeit ist für keine Sektionen des Kurses',

   'are contributing enrollment to the LON-CAPA class roster.'
=> 'eine Teilnahme an der Kursbelegung eingerichtet.',

   'Add enrollment from additional sections.'
=> 'Kursbelegung für weitere Sektionen hinzufügen',

   'Number of new sections to add:'
=> 'Anzahl hinzuzufügender Sektionen:',

   'Students enrolling in the sections listed below will be automatically added to the class roster for LON-CAPA course'
=> 'Studierende, die in die unten aufgelisteten Sektionen eingeschrieben werden, werden automatisch in die Kursteilnehmerliste des Kurses',

   'if you have chosen to enable a nightly automated enrollment update.'
=> 'aufgenommen, falls die nächtliche, automatische Kursbelegung aktiviert ist.',

   'Nightly additions based on classlist changes now'
=> 'Nächtliche Hinzufügungen aufgrund von Kursteilnehmerlisten-Änderungen sind jetzt',

   'Nightly additions based on classlist changes still'
=> 'Nächtliche Hinzufügungen aufgrund von Kursteilnehmerlisten-Änderungen bleiben weiterhin',

   'Nightly removals based on classlist changes now'
=> 'Nächtliche Ausschließungen aufgrund von Kursteilnehmerlisten-Änderungen sind jetzt',

   'Nightly removals based on classlist changes still'
=> 'Nächtliche Ausschließungen aufgrund von Kursteilnehmerlisten-Änderungen bleiben weiterhin',

   'Enabled?'
=> 'Aktiviert?',

   'enabled'
=> 'aktiviert',

   'disabled'
=> 'deaktiviert',

   'The first date for automated enrollment has been changed'
=> 'Das Anfangsdatum der automatischen Kursbelegung wurde geändert auf',

   'The last date for automated enrollment has been changed'
=> 'Das Enddatum der automatischen Kursbelegung wurde geändert auf',

   'The first date for automated enrollment has been left unchanged as'
=> 'Das Anfangsdatum der automatischen Kursbelegung bleibt weiterhin',

   'The last date for automated enrollment has been left unchanged as'
=> 'Das Enddatum der automatischen Kursbelegung bleibt weiterhin',

   'Currently: Notification:'
=> 'Derzeit: Benachrichtigung:',

   'Notification of LON-CAPA course roster changes resulting from nightly automated enrollment process?'
=> 'Benachrichtigung über Änderungen an der Kursteilnehmerliste durch die nächtliche, automatische Kursbelegung aktivieren?',

   'The table below contains a list of Kurs-Koordinators in this course.'
=> 'Liste der Kurs-Koordinatoren in diesem Kurs',

   'username:domain'
=> 'Benutzerkennung:Domäne',

   'Username:domain'
=> 'Benutzerkennung:Domäne',

   'Username:domain of each co-owner'
=> 'Benutzerkennung:Domäne eines jeden Co-Eigentümers',

   'Username/domain'
=> 'Benutzerkennung/Domäne',

   'Course Access'
=> 'Kurs-Zugriff',

   'Current notification status'
=> 'Derzeitiger Benachrichtigungsstatus',

   'Notification active'
=> 'Benachrichtigung aktiv',

   'Notification inactive'
=> 'Benachrichtigung inaktiv',

   'Notification?'
=> 'Benachrichtigen?',

   "The table below contains a list of Domänen-Koordinators from this course's domain who are not also Kurs-Koordinators."
=> "Liste der Domänen-Koordinatoren, die in der Kurs-Domäne liegen, aber nicht zusätzlich Kurs-Koordinatoren sind",

   'Notification of enrollment changes now'
=> 'Benachrichtigung über Kursbelegungsänderungen ist jetzt',

   'Notification of enrollment changes still'
=> 'Benachrichtigung über Kursbelegungsänderungen bleibt weiterhin',

   'The following will receive notification if there are any changes in enrollment in LON-CAPA course:'
=> 'Die folgenden Benutzer erhalten eine Benachrichtigung im Falle von Änderungen der Kursteilnehmerliste durch die automatische Kursbelegung des Kurses',

   'as a result of the nightly enrollment check:'
=> 'aufgrund des nächtlichen Kursbelegungsabgleichs:',

   'Course search'
=> 'Kurs-Suche',

   'View/Modify Courses'
=> 'Kurse betrachten/ändern',

   'Course details'
=> 'Kursdetails',

   'Detailed course information:'
=> 'Detaillierte Kursinformationen:',

   'Detailed community information:'
=> 'Detaillierte Community-Informationen:',

   'Default Access Dates for Students'
=> 'Voreingestellte Zugriffszeiten für Studierende',

   'Default Access Dates for Members'
=> 'Voreingestellte Zugriffszeiten für Mitglieder',

   'Access dates for students'
=> 'Zugriffszeiten für Studierende',

   'Access dates for community members'
=> 'Zugriffszeiten für Community-Mitglieder',

   'Student Counts'
=> 'Anzahl Studierende',

   'Member Counts'
=> 'Anzahl Teilnehmer',

   'Auto-enrollment of[_1]registered students'
=> 'Automatische Kursbelegung[_1]registrierter Studierender',

   'Details'
=> 'Details',

   'Not enabled'
=> 'Nicht aktiviert',

   'section:'
=> 'Sektion:',

   'Previous access'
=> 'In der Vergangenheit liegender Zugriff',

   'Current access'
=> 'Aktueller Zugriff',

   'Future access'
=> 'Zukünftiger Zugriff',

   'Back to course listing'
=> 'Zurück zur Kursübersicht',

   'Back to community listing'
=> 'Zurück zur Community-Übersicht',

   'Immediate course roster update'
=> 'Sofortige Aktualisierung der Kursteilnehmerliste',

   'There were no new students to add to the course.'
=> 'Es existieren keine Studierenden, die neu am Kurs teilnehmen sollen.',

   'Back to options page'
=> 'Zurück zum Funktionsauswahlmenü',

   'View/Modify settings for: [_1]'
=> 'Anzeigen/ändern der Einstellungen für [_1]',

   'Modify quota for group portfolio'
=> 'Ändern des Speicherplatzes für das Gruppen-Portfolio',

   'Display current settings for automated enrollment'
=> 'Anzeige der derzeitigen Einstellungen der automatischen Kursbelegung',

   'Modify institutional code, course owner and/or default authentication'
=> 'Ändern des institutionellen Codes, des Kurs-Eigentümers und/oder der voreingestellten Authentifizierung',

   'Modify course catalog settings for course'
=> 'Ändern der Kursübersicht-Einstellungen für diesen Kurs',

   'Catalog settings'
=> 'Kurs-/Community-Übersicht-Einstellungen',

   'Catalog Settings for Course'
=> 'Kurs-/Community-Übersicht-Einstellungen für den Kurs',

   'Catalog Settings for Community'
=> 'Kurs-/Community-Übersicht-Einstellungen für die Community',

   'Visibility in Course/Community Catalog'
=> 'Sichtbarkeit in der Kurs-/Community-Übersicht',

   "Unless excluded, a course/community is listed in this domain's publicly accessible Course/Community Catalog, if at least one of the following applies:"
=> 'Sofern ein Kurs/eine Community nicht aus der Anzeige in der in dieser Domäne öffentlich zugänglichen Kurs-/Community-Übersicht ausgeschlossen wurde, wird er/sie angezeigt, solange mindestens eine der folgenden Einstellungen zutrifft:',

   'Auto-cataloging is enabled and the course is assigned an institutional code.'
=> 'Automatische Katalogisierung ist aktiviert und dem Kurs wurde ein institutioneller Code zugewiesen.',

   'The course has been categorized using at least one of the course categories defined for the domain.'
=> 'Der Kurs wurde in mindestens eine der Kurskategorien, die für diese Domäne angelegt wurden, eingeordnet.',

   'Exclude from course catalog'
=> 'Von der Kursübersicht ausschließen',

   'Exclude from course catalog:'
=> 'Von der Kursübersicht ausschließen:',

   'Exclude from community catalog'
=> 'Von der Community-Übersicht ausschließen',

   'Excluded from course catalog'
=> 'Von der Kursübersicht ausgeschlossen',

   'Excluded from community catalog'
=> 'Von der Community-Übersicht ausgeschlossen',

   'Categorize Course'
=> 'Kurs kategorisieren',

   'Categorize course'
=> 'Kurs kategorisieren',

   'Categorize Community'
=> 'Community kategorisieren',

   'No categories defined for this domain'
=> 'In dieser Domäne wurden bisher keine Kategorien angelegt.',

   'Assign one or more categories to this course.'
=> 'Diesem Kurs eine oder mehrere Kategorien zuweisen:',

   'Assign one or more categories to this community.'
=> 'Dieser Community eine oder mehrere Kategorien zuweisen:',

   'If auto-cataloging based on institutional code is enabled in the domain, a course will continue to be listed in the catalog of official courses, in addition to receiving a listing under any manually assigned categor(ies).'
=> 'Falls die automatische, auf den institutionellen Codes basierende Katalogisierung in dieser Domäne aktiviert ist, wird ein Kurs weiterhin in der Übersicht der offiziellen Kurse aufgelistet und zusätzlich in einer Liste mit allen manuell zugewiesenen Kategorien angezeigt.',

   'Category settings'
=> 'Kategorie-Einstellungen',

   'Show/Hide a course in the catalog'
=> 'Anzeigen/Verbergen von Kursen im Kursüberblick',

   'Assign a category to a course'
=> 'Einem Kurs eine Kategorie zuweisen',

   'Assign a category to a community'
=> 'Einer Community eine Kategorie zuweisen',

   'Set in "Modify Course" (Domain)'
=> 'Einstellung in "Kurs einstellen" (Domäne)',

   'Set in "Modify Parameters" (Course)'
=> 'Einstellung in "Parameter ändern" (Kurs)',

   'Categories'
=> 'Kategorien',

   'Add category'
=> 'Kategorie hinzufügen',

   'Add category:'
=> 'Kategorie hinzufügen:',

   'Add subcategory:'
=> 'Unterkategorie hinzufügen:',

   'New:'
=> 'Neu:',

   'Choose a course'
=> 'Kurs auswählen',

   'Pick action'
=> 'Aktion auswählen',

   'Pick Action'
=> 'Aktion auswählen',

   'Display settings'
=> 'Einstellungen anzeigen',

   'Course settings that control automated enrollment in this LON-CAPA course are currently:'
=> 'Derzeitige Einstellungen der automatischen Kursbelegung dieses Kurses:',

   'Course setting'
=> 'Kurs-Einstellung',

   'Modifiable by DC only'
=> 'Nur durch Dom.-Koord. änderbar',

   'Default authentication parameter'
=> 'Voreingestellter Authentifizierungsparameter',

   'Default authentication method'
=> 'Voreingestellte Authentifizierungsmethode',

   'Date of last automated enrollment'
=> 'Enddatum der automatischen Kursbelegung',

   'Date of first automated enrollment'
=> 'Anfangsdatum der automatischen Kursbelegung',

   'Official course code'
=> 'Offizieller Kurscode',

   'Username:domain of course owner'
=> 'Benutzerkennung:Domäne des Kurs-Eigentümers',

   'Username:domain of community owner'
=> 'Benutzerkennung:Domäne des Community-Eigentümers',

   'Date of last student access'
=> 'Enddatum des studentischen Zugriffs',

   'Date of first student access'
=> 'Anfangsdatum des studentischen Zugriffs',

   'Course section number(:LON-CAPA section)'
=> 'Kurssektionsnummer(:LON-CAPA-Sektionsnummer)',

   'Show more details'
=> 'Mehr Details',

   'Public RSS/podcast (subscribe to):'
=> 'Öffentlicher RSS-Feed/Podcast (Einschreibe-Link):',

   'Public RSS/podcast (subscribe to)'
=> 'Öffentlicher RSS-Feed/-Podcast (Einschreibe-Link)',

   'Course Owner:'
=> 'Kurs-Eigentümer:',

   'Default Authentication method'
=> 'Voreingestellte Authentifizierungsmethode',

   'Automated Enrollment'
=> 'Automatische Kursbelegung',

   'Use the menu on the left to choose an enrollment management task.'
=> 'Wählen Sie im Menü links die gewünschte Aktion zur automatischen Kursbelegung.',

   'Result of Changes to Automated Enrollment Settings.'
=> 'Ergebnis der Änderungen an den Einstellungen zur automatischen Kursbelegung',

   'The following automated enrollment parameters have been changed:'
=> 'Die folgenden Parameter der automatischen Kursbelegung wurden geändert:',

   'now set to'
=> 'ist jetzt',

   'now set to:'
=> 'ist jetzt:',

   'still set to'
=> 'bleibt weiterhin',

   'still set to:'
=> 'bleibt weiterhin:',

   '[_1] still set to: [_2]'
=> '[_1] bleibt weiterhin [_2]',

   'Set to "[_1]" for "[_2]".'
=> 'Eingestellt auf "[_1]" für "[_2]"',

   'The following were unchanged:'
=> 'Folgendes bleibt unverändert:',

   'The following automated enrollment parameters remain unchanged:'
=> 'Die folgenden Parameter der automatischen Kursbelegung bleiben unverändert:',

   'Change settings'
=> 'Einstellungen ändern',

   "Student's agreement needed for listing in student-viewable roster"
=> "Studentisches Einverständnis notwendig, um in der von Studierenden einsehbaren Kursteilnehmerliste aufgelistet zu werden",

   'Include link to accessible portfolio files'
=> 'Link zu erreichbaren Portfolio-Dateien einbinden',

   'Print header format'
=> 'Kopfbereich beim Druck',

   'Force all students in the course to use a specific math rendering engine.'
=> 'Vorgabe für alle Studierenden im Kurs, wie wissenschaftliche Formeln dargestellt werden sollen',

   "[_1], [_2] (Convert to Images), [_3] (TeX to HTML), or blank for student's preference"
=> "[_1], [_2] (in Grafik konvertieren), [_3] (TeX-nach-HTML) oder leer lassen für studentische Voreinstellung",

   'Bridge Task Grading'
=> 'Bewertung von "Bridgetasks"',

   'Classlist Manager'
=> 'Automatische Kursbelegung', # ???

   'Note for students:'
=> 'Hinweis für Studierende:',

   'If you are officially enrolled in a course but the course is not listed in your LON-CAPA courses, click the "Show more details" link for the specific course and check the default access dates and/or automated enrollment settings.'
=> 'Falls Sie einen Kurs Ihrer Einrichtung regulär belegt haben, dieser aber nicht in Ihrer persönlichen LON-CAPA-Kursauswahl aufgelistet wird, klicken Sie in der unten stehenden Kursübersicht bei dem entsprechenden Kurs auf "Mehr Details". Überprüfen Sie dort die Angaben zu den voreingestellten Zugriffszeiten und die Einstellungen der automatischen Kursbelegung.',

   'Please [_1]log in again[_2].'
=> 'Bitte [_1]erneut einloggen[_2].',

   'Switching Server ...'
=> 'Serverwechsel...',

   'Already logged in'
=> 'Bereits angemeldet',

   'Apply style file: '
=> 'Style-Datei anwenden: ',

   'The problem '
=> 'Die Aufgabe ',

   'Search criteria'
=> 'Suchkriterien',

   'begins with'
=> 'beginnt mit',

   'Begins with'
=> 'Beginnt mit',

   'in selected LON-CAPA domain'
=> 'in ausgewählter LON-CAPA-Domäne',

   'in institutional directory for selected domain'
=> 'im Institutionsverzeichnis der ausgewählten Domäne',

   'No match found for the username [_1] in this course.'
=> 'Die Suche nach der Benutzerkennung [_1] hat in diesem Kurs keine Treffer ergeben.',

   'No exact match found for the username [_1] in this course.'
=> 'Die Suche nach der Benutzerkennung [_1] hat in diesem Kurs keine exakten Treffer ergeben.',

   'No match found for the last name [_1] in this course.'
=> 'Die Suche nach dem Nachnamen [_1] hat in diesem Kurs keine Treffer ergeben.',

   'No exact match found for the last name [_1] in this course.'
=> 'Die Suche nach dem Nachnamen [_1] hat in diesem Kurs keine exakten Treffer ergeben.',

   'No match found for the last name, first name [_1] in this course.'
=> 'Die Suche nach Nachname, Vorname [_1] hat in diesem Kurs keine Treffer ergeben.',

   'No exact match found for the last name, first name [_1] in this course.'
=> 'Die Suche nach Nachname, Vorname [_1] hat in diesem Kurs keine exakten Treffer ergeben.',

   'No match found for the username [_1] in LON-CAPA domain: [_2]'
=> 'Die Suche nach der Benutzerkennung [_1] hat in der Domäne [_2] keine Treffer ergeben.',

   'No exact match found for the username [_1] in LON-CAPA domain: [_2]'
=> 'Die Suche nach der Benutzerkennung [_1] hat in der Domäne [_2] keine exakten Treffer ergeben.',

   'No match found for the last name [_1] in LON-CAPA domain: [_2]'
=> 'Die Suche nach dem Nachnamen [_1] hat in der Domäne [_2] keine Treffer ergeben.',

   'No exact match found for the last name [_1] in LON-CAPA domain: [_2]'
=> 'Die Suche nach dem Nachnamen [_1] hat in der Domäne [_2] keine exakten Treffer ergeben.',

   'No match found for the last name, first name [_1] in LON-CAPA domain: [_2]'
=> 'Die Suche nach Nachname, Vorname [_1] hat in der Domäne [_2] keine Treffer ergeben.',

   'No exact match found for the last name, first name [_1] in LON-CAPA domain: [_2]'
=> 'Die Suche nach Nachname, Vorname [_1] hat in der Domäne [_2] keine exakten Treffer ergeben.',

   'No match found for the username [_1] in the institutional directory for domain: [_2]'
=> 'Die Suche nach der Benutzerkennung [_1] hat im Institutionsverzeichnis der Domäne [_2] keine Treffer ergeben.',

   'No exact match found for the username [_1] in the institutional directory for domain: [_2]'
=> 'Die Suche nach der Benutzerkennung [_1] hat im Institutionsverzeichnis der Domäne [_2] keine exakten Treffer ergeben.',

   'No match found for the last name [_1] in the institutional directory for domain: [_2]'
=> 'Die Suche nach dem Nachnamen [_1] hat im Institutionsverzeichnis der Domäne [_2] keine Treffer ergeben.',

   'No exact match found for the last name [_1] in the institutional directory for domain: [_2]'
=> 'Die Suche nach dem Nachnamen [_1] hat im Institutionsverzeichnis der Domäne [_2] keine exakten Treffer ergeben.',

   'No match found for the last name, first name [_1] in the institutional directory for domain: [_2]'
=> 'Die Suche nach Nachname, Vorname [_1] hat im Institutionsverzeichnis der Domäne [_2] keine Treffer ergeben.',

   'No exact match found for the last name, first name [_1] in the institutional directory for domain: [_2]'
=> 'Die Suche nach Nachname, Vorname [_1] hat im Institutionsverzeichnis der Domäne [_2] keine exakten Treffer ergeben.',

   'Creating new account.'
=> 'Erstelle neuen Benutzeraccount...',

   'Report a documentation bug'
=> 'Fehler in der Dokumentation melden (Englisch)',

   'You must specify a valid username. Only the following are allowed: letters numbers - . @'
=> 'Geben Sie eine gültige Benutzerkennung ein. Nur folgende Zeichen sind erlaubt: Buchstaben, Ziffern, "-", "." und "@"',

   'The following need to be corrected before the search can be run:'
=> 'Folgendes muss korrigiert werden, bevor die Suche gestartet werden kann:',

   'You must include some text to search for.'
=> 'Sie müssen Text eingeben, nach dem gesucht werden soll.',

   "The text you are searching for must contain at least two characters when using a 'begins' type search."
=> "Der Text, nach dem gesucht werden soll, muss mindestens zwei Zeichen lang sein, wenn die 'beginnt mit'-Option verwendet wird.",

   "The text you are searching for must contain at least three characters when using a 'contains' type search."
=> "Der Text, nach dem gesucht werden soll, muss mindestens drei Zeichen lang sein, wenn die 'enthält'-Option verwendet wird.",

   'You must choose a domain when using an institutional directory search.'
=> 'Für die Suche im Institutionsverzeichnis müssen Sie eine Domäne auswählen.',

   'You must choose a domain when using a domain search.'
=> 'Für die Domänensuche müssen Sie eine Domäne auswählen.',

   "When using searching by last,first you must include a comma as separator between last name and first name."
=> "Bei der Suche mit der Option 'Nachname, Vorname' muss zwischen Vor- und Nachname als Trennzeichen ein Komma stehen.",

   "When searching by last,first you must include at least one character in the first name."
=> "Bei der Suche mit der Option 'Nachname, Vorname' muss der Vorname mindestens ein Zeichen enthalten.",

   'Revoking [_1] in [_2]'
=> 'Entziehe Rolle [_1] für [_2]',

   'Revoking [_1] in [_2]: [_3]'
=> 'Entziehe Rolle [_1] für [_2]: [_3]',

   'Revoking custom role [_1] by [_2] in [_3]'
=> 'Entziehe benutzerdefinierte Rolle [_1] von [_2] in [_3]',

   'Deleting [_1] in [_2]'
=> 'Entferne Rolle [_1] für [_2]',

   'Deleting [_1] in [_2]: [_3]'
=> 'Entferne Rolle [_1] für [_2]: [_3]',

   'Deleting custom role [_1] by [_2] in [_3]'
=> 'Entferne benutzerdefinierte Rolle [_1] von [_2] für [_3]',

   'Add to classlist'
=> 'Hinzufügen zur Kursteilnehmerliste',

   'Re-enabling [_1] in [_2]'
=> 'Reaktivierung der Rolle [_1] für [_2]',

   'Re-enabling [_1] in [_2]: [_3]'
=> 'Reaktivierung der Rolle [_1] für [_2]: [_3]',

   'Re-enabling custom role [_1] by [_2] in [_3]'
=> 'Reaktivierung der benutzerdefinierten Rolle [_1] für [_2] in [_3]',

   'Unknown command'
=> 'Unbekannter Befehl',

   '[_1] may not be used as the name for a section, as it is a reserved word.'
=> '[_1] ist nicht als Sektionsname zulässig, da es sich um ein systemintern-reserviertes Wort handelt.',

   '[_1] may not be used as the name for a section, as it is the name of a course group.'
=> '[_1] ist nicht als Sektionsname zulässig, da er bereits als Name einer bestehenden Kursgruppe verwendet wird.',

   'may not be used as the name for a section, as it is the name of a community group'
=> 'ist nicht als Sektionsname zulässig, da er bereits als Name einer bestehenden Community verwendet wird.',

   'Please [_1]go back[_2] and choose a different section name.'
=> 'Bitte gehen Sie [_1]zurück[_2] und wählen Sie einen anderen Sektionsnamen.',

   'Drop from classlist: [_1]'
=> 'Aus Kursteilnehmerliste ausschließen: [_1]',

   'Existing Role'
=> 'Bestehende Rolle',

   'Assigning Role to Self'
=> 'Zuweisung der Rolle an sich selber',

   'Invalid search.'
=> 'Ungültige Suche.',

   'You must enter a search term.'
=> 'Sie müssen einen Suchbegriff eingeben.',

   'You must specify a valid domain when searching in a domain or institutional directory.'
=> 'Bei der Suche in einer Domäne oder im Institutionsverzeichnis müssen Sie eine gültige Domäne angeben.',

   'You may want to search in the LON-CAPA domain instead of the institutional directory.'
=> 'Anstatt im Institutionsverzeichnis könnten Sie alternativ in den LON-CAPA-Domänen suchen.',

   'New users can only be created in the domain to which your current role belongs - [_1].'
=> 'Neue Benutzer können nur in der Domäne angelegt werden, in der auch Ihre derzeitige Rolle liegt - [_1].',

   'Institutional directory search is not available in domain: [_1]'
=> 'Eine Suche im Institutionsverzeichnis ist in der Domäne [_1] nicht verfügbar.',

   'Institutional directory search in domain: [_1] is only allowed for users with a current role in the domain.'
=> 'Eine Suche im Institutionsverzeichnis in der Domäne [_1] ist nur für Benutzer erlaubt, die eine aktive Rolle in dieser Domäne haben.',

   'Institutional directory search in domain: [_1] is not available to your user type: '
=> 'Eine Suche im Institutionsverzeichnis in der Domäne [_1] ist nicht für Ihren Benutzertyp verfügbar: ',

   'Institutional directory search has not been configured for domain: [_1]'
=> 'Die Suchfunktion im Institutionsverzeichnis in der Domäne [_1] ist nicht konfiguriert.',

   'Institutional directory search in domain: [_1] is not available for searching by "[_2]"'
=> 'Eine Suche im Institutionsverzeichnis in der Domäne [_1] ist nicht verfügbar für eine Suche nach "[_2]"',

   'Institutional directory search in domain: [_1] is not available.'
=> 'Eine Suche im Institutionsverzeichnis ist in der Domäne [_1] nicht verfügbar.',

   'Institutional directory search in domain [_1] is not available for the requested search type: "[_2]"'
=> 'Eine Suche im Institutionsverzeichnis ist in der Domäne [_1] für den gewünschten Suchtyp "[_2]" nicht verfügbar.',

   'You may want to broaden your search to a search of the institutional directory for the domain.'
=> 'Sie können Ihre Suche auf eine Suche im Institutionsverzeichnis der Domäne erweitern.',

   'You may want to broaden your search to the selected LON-CAPA domain.'
=> 'Sie können Ihre Suche auf eine Suche in der gewählten LON-CAPA-Domäne erweitern.',

   'Pick group first'
=> 'Erst Gruppe auswählen',

   'No login name specified'
=> 'Kein Loginname angegeben',

   'Invalid login name.'
=> 'Ungültiger Loginname.',

   'Only letters, numbers, periods, dashes, @, and underscores are valid.'
=> 'Es sind nur erlaubt: Buchstaben, Ziffern, ".", "@", ,"-", "_"',

   'For this user, the default quota would be [_1] MB.'
=> 'Für diesen Benutzer würde der voreingestellte Speicherplatz [_1] MB betragen.',

   "For this user, the default quota would be [_1] MB, as determined by the user's institutional affiliation ([_2])."
=> "Für diesen Benutzer würde der voreingestellte Speicherplatz [_1] MB betragen, festgelegt durch die institutionelle Angliederung ([_2]).",

   'For this user, the default quota is [_1] MB.'
=> 'Für diesen Benutzer ist der voreingestellte Speicherplatz [_1] MB.',

   "For this user, the default quota of [_1] MB, is determined by the user's institutional affiliation ([_2])."
=> "Für diesen Benutzer beträgt der voreingestellte Speicherplatz [_1] MB, festgelegt durch die institutionelle Angliederung ([_2]).",

   'in all LON-CAPA domains.'
=> 'in allen LON-CAPA-Domänen.',

   'in LON-CAPA domains:'
=> 'in den LON-CAPA-Domänen:',

   'in LON-CAPA domain '
=> 'in LON-CAPA-Domäne ',

   'Course settings modifiable by [_1] only.'
=> 'Kurs-Einstellungen, die nur durch einen [_1] änderbar sind',

   'Course Owner'
=> 'Kurs-Eigentümer',

   'Community Owner'
=> 'Community-Eigentümer',

   'Username:Domain'
=> 'Benutzerkennung:Domäne',

   'Course Activity'
=> 'Letzte Kursaktivität',

   'Community Activity'
=> 'Letzte Community-Aktivität',

   'Course Domain'
=> 'Kurs-Domäne',

   'Course Institutional Code'
=> 'Kurs-Institutions-Code',

   'Institutional Code'
=> 'Institutioneller Code',

   'Institutional code'
=> 'Institutioneller Code',

   'Institutional Categorization'
=> 'Institutionelle Kategorisierung',

   'Institutional ID'
=> 'Institutionelle ID',

   'Institutional Section'
=> 'Institutionelle Sektion',

   'Institutional section'
=> 'Institutionelle Sektion',

   'Institutional course/section'
=> 'Institutionelle/r Kurs/Sektion',

   "Course Owner's Username"
=> "Benutzerkennung des Kurs-Eigentümers",

   "Course Owner's Domain"
=> "Domäne des Kurs-Eigentümers",

   'Course Type'
=> 'Kurstyp',

   'Course Type:'
=> 'Kurstyp:',

   'Course type'
=> 'Kurs-Typ',

   'LON-CAPA course ID'
=> 'LON-CAPA-Kurs-ID',

   'None found'
=> 'Keine Treffer',

   'Course settings which only a [_1] may modify.'
=> 'Kurs-Einstellungen, die nur ein [_1] ändern kann.',

   "Click a 'Select' button to view or modify settings for a [_1] which may only be modified by a [_2] in this domain."
=> "Klicken Sie auf den Auswahl-Button eines [_1], um die Einstellungen für diesen [_1] zu betrachten oder zu ändern, die nur durch einen [_2] in dieser Domäne geändert werden können.",

   'Set enrollment'
=> 'Kursbelegung einstellen',

   'Please review the information in "Log-in help" and the "Getting started" guide if you are unable to log-in.'
=> 'Bitte schauen Sie zunächst in die "Login-Hilfe" und in die "Kurzeinleitung für Studierende", falls Sie sich nicht anmelden können.',

   'Please review the information in "Log-in help" if you are unable to log-in.'
=> 'Bitte schauen Sie zunächst in die "Login-Hilfe", falls Sie sich nicht anmelden können.',

   'If your problem is still unresolved, the form below can be used to send a question to the LON-CAPA helpdesk.'
=> 'Wenn sich damit die Probleme nicht lösen lassen, dann können Sie das Formular auf dieser Seite ausfüllen und eine Anfrage an das Helpdesk schicken.',

   'Getting started guide'
=> 'Kurzeinleitung für Studierende',

   '[_1] [_2] [_3] ' # "mm tt yyyy"
=> '[_2].[_1].[_3] ', # "tt.mm.yyyy"

   '[_1] [_2] [_3] [_4] [_5]m [_6]s ' # "mm dd yyyy hh mi ss" (1:month, 2:day, 3:year, 4:hour, 5:minute, 6:second)
=> '[_2]. [_1] [_3], [_4]:[_5]:[_6] ', # "dd. mm yyyy, hh:mi:ss"

   '[_1]Select Date[_2]'
=> '[_1]Datum auswählen[_2]',

   '[_1]: students can view all sections. [_2]: students can only view their own section. blank or [_3] prevents student view.'
=> '[_1]: Studierende können alle Sektionen sehen. [_2]: Studierende können nur ihre eigene Sektion sehen. Leer lassen oder [_3]: keine Einsicht für Studierende.',

   '[_1] to require students to opt-in to listing in the roster (on the roster page).'
=> '[_1], um Notwendigkeit des studentischen Einverständnisses zu aktivieren.',

   "[_1] for link to each a listing of each student's files."
=> '[_1] zum Einbinden von Links zu jeder Liste mit den Dateien eines/r jeden Studenten/in.',

   '[_1]: student, [_2]: TA, [_3]: instructor'
=> '[_1]: Student/in, [_2]: Tutor, [_3]: Dozent',

   'role:section,role:section,...'
=> 'Rolle:Sektion,Rolle:Sektion,...',

   'supported types'
=> 'Unterstützte Formate',

   '[_1] to send a message only to student, [_2] to send message to student and add record to user information page for instructors. Leave blank to disable.'
=> '[_1], um Nachricht nur an Studierende zu schicken. [_2], um Nachricht an Studierende zu schicken und Eintrag in die Seite der studentischen Benutzerdaten für Dozenten einzutragen. Leer lassen, um zu deaktivieren.',

   'Bridge tasks'
=> '"Bridgetasks"',

   'Instructors and TAs in sections, when grading bridge tasks, should be allowed to grade other sections.'
=> 'Wenn Dozenten und Tutoren bestimmter Sektionen "Bridgetasks" bewerten, auch die Bewertung anderer Sektionen erlauben.',

   '[_1]: they are allowed (this is the default). [_2]: no, they can only grade their own section.'
=> '[_1]: erlauben (voreingestellt). [_2]: nur eigene Sektion.',

   'Calendar Announcement for '
=> 'Kalender-Bekanntmachung für den Kurs ',

   'Opening'
=> 'Start',

   'Closing'
=> 'Ende',

   'To add a new user:'
=> 'Um einen neuen Benutzer hinzuzufügen...:',

   "(You can only create new users in your current role's domain - [_1])"
=> "(Neue Benutzer können nur in der Domäne Ihrer derzeitigen Benutzerrolle erzeugt werden - [_1])",

   "You are not authorized to create new users in your current role's domain - [_1]."
=> "Sie sind nicht berechtigt, neue Benutzer in der Domäne Ihrer derzeitigen Benutzerrolle anzulegen - [_1].",

   "Set 'Domain/institution to search' to: [_1]"
=> "Setzen Sie die Domäne, in der gesucht werden soll, auf [_1]",

   "Set 'Search criteria' to: [_1]username is ..... in selected LON-CAPA domain[_2]"
=> "Setzen Sie 'Suchkriterien' auf [_1]Benutzerkennung ist ..... in ausgewählter LON-CAPA-Domäne[_2]",

   'Provide the proposed username'
=> 'Geben Sie die gewünschte Benutzerkennung ein',

   'Select a user to add/modify roles'
=> 'Wählen Sie einen Benutzer, für den Sie Rollen oder Berechtigungen ändern bzw. hinzufügen möchten',

   "Click 'Search'"
=> "Klicken Sie auf 'Suchen'",

   'User Search to add/modify roles'
=> 'Benutzersuche zum Hinzufügen/Ändern von Rollen oder Berechtigungen',

# Feedback messages:
   'You have entered that answer before'
=> 'Sie hatten diese Antwort bereits eingegeben',

   "Computer's answer now shown above."
=> "Die als richtig hinterlegte Antwort wird oben angezeigt.",

   'You are correct.'
=> 'Korrekt!',

   'You are partially correct.'
=> 'Teilweise korrekt.',

   'Incorrect'
=> 'Inkorrekt',

   'Incorrect.'
=> 'Inkorrekt.',

   'You are incorrect'
=> 'Inkorrekt',

   'Your receipt no. is [_1]'
=> 'Ihre Nachweis-Nr. ist [_1]',

   'Your receipt is [_1]'
=> 'Ihre Nachweis-Nr. ist [_1]',

   'You are excused from the problem.'
=> 'Die Aufgabe ist Ihnen erlassen worden.',

   'Some extra items were submitted.'
=> 'Es wurden zuviele Antwortelemente angegeben.',

   'Some items were not submitted.'
=> 'Die Fragen wurden nicht vollständig beantwortet.',

   'An error occurred while grading your answer.'
=> 'Während der Bewertung Ihrer Antwort ist ein Fehler aufgetreten.',

   'The submitted answer was too long.'
=> 'Ihre Antwort ist zu lang.',

   'This question expects a numeric answer.'
=> 'Eine numerische Antwort ist gefragt.',

   'You have provided an invalid ranking.'
=> 'Die eingegebene Rangordnung ist ungültig.',

   'Please refer to [_1]'
=> 'Hilfe erhalten Sie unter [_1]',

   'help on ranking problems'
=> 'Hilfe zu Rangordnungs-Aufgaben',

   "Submission won't be graded. The type of file submitted is not allowed."
=> 'Ihre Einreichung wurde nicht gewertet. Der Dateityp ist nicht zulässig.',

   "Submission won't be graded. The combined size of submitted files exceeded the amount allowed."
=> 'Ihre Einreichung wird nicht gewertet. Die gesamte Größe an eingereichten Dateien überschreitet die zulässige Grenze.',

   'Submission not graded. Use fewer digits.'
=> 'Ihre Antwort wurde nicht gewertet. Verwenden Sie weniger Ziffern.',

   'Submission not graded. Use more digits.'
=> 'Ihre Antwort wurde nicht gewertet. Verwenden Sie mehr Ziffern.',

   'Error in instructor specifed unit. This error has been reported to the instructor.'
=> 'Es liegt ein Fehler in der vom Dozenten vorgegebenen Einheit vor. Der Fehler wurde an den Dozenten gemeldet.',

   'Unable to interpret units. Computer reads units as "[_1]".'
=> 'Einheiten können nicht ausgewertet werden. Computer versteht Einheiten als "[_1]".',

   'Incompatible units. No conversion found between "[_1]" and the required units.'
=> 'Inkompatible Einheiten. Keine Umrechnungsmöglichkeit zwischen "[_1]" und der benötigten Einheit gefunden.',

   'Only a number required. Computer reads units of "[_1]".'
=> 'Als Eingabe ist nur eine Zahl zulässig. Der Computer interpretiert Ihre Eingabe so, als wollten Sie die Einheit "[_1]" verwenden.',

   'Proper comma separation is required'
=> 'Eine ordentliche Trennung durch Kommata ist erforderlich.',

   'Unable to understand formula'
=> 'Der eingegebene Ausdruck kann nicht ausgewertet werden',

   'Your submission has been recorded.'
=> 'Ihre Antwort wurde gespeichert.',

   'Draft Copy'
=> 'Entwurf',

   'A draft copy has been saved.'
=> 'Ihr Entwurf wurde gespeichert.',

   'Nothing submitted.'
=> 'Es wurde nichts eingereicht.',

   'An internal error occurred while processing your answer. Please try again later.'
=> 'Während der Verarbeitung Ihrer Antwort ist ein interner Fehler aufgetreten. Bitte versuchen Sie es später noch einmal.',

   'Unknown message'
=> 'Unbekannte Meldung',

   'Returned file(s): [_1]'
=> 'Zurückgelieferte Datei(en): [_1]',

   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Antwort eingereicht. Die Daten werden nach dem Fälligkeitsdatum ausgewertet.',

   'Answer Submitted: Your final submission will be graded when the time limit is reached.'
=> 'Antwort eingereicht. Die Daten werden nach dem Ende des Zeitlimits ausgewertet.',
# --/

   ' The last submission was after the Due Date '
=> ' Die letzte Einreichung erfolgte nach dem Fälligkeitsdatum ',

   'Submit a file: (only one file can be uploaded)'
=> 'Datei einreichen: (Es kann nur eine Datei hochgeladen werden)',

   'OR:'
=> 'ODER:',

   'Select Portfolio Files'
=> 'Auswahl Portfolio-Dateien',

   'Portfolio files previously selected: [_1]'
=> 'Zuvor ausgewählte Portfolio-Dateien: [_1]',

   "These file(s) don't exist: [_1]"
=> "Diese Datei(en) existieren nicht: [_1]",

   'Previously published version'
=> 'Zuvor veröffentlichte Version',

   'You do not have privileges to modify the authentication configuration for this user.'
=> 'Sie sind nicht berechtigt, die Authentifizierungs-Konfiguration dieses Benutzers zu ändern.',

   'You do not have privileges to modify the portfolio and/or Authoring Space quotas for this user.'
=> 'Sie sind nicht berechtigt, den Portfolio-Speicherplatz und/oder Speicherplatz des Autorenbereichs dieses Benutzers zu ändern.',

   'If a change is required, contact a domain coordinator for the domain'
=> 'Falls notwendig, kontaktieren Sie einen Domänen-Koordinator der Domäne',

   'with submissions'
=> 'mit Antworten',

   'in grading queue'
=> 'in Bewertungs-Warteschlange',

   'with ungraded submissions'
=> 'mit unbewerteten Antworten',

   'with incorrect submissions'
=> 'mit inkorrekten Antworten',

   'with any status'
=> 'mit beliebigem Status',

   'Default value or none'
=> 'Voreingestellt oder nichts',

   'Floating Point between 1 and 0'
=> 'Gleitkommazahl zwischen 0 und 1',

   'Floating point number between zero and one'
=> 'Gleitkommazahl zwischen Null und Eins',

   'Positive Floating Point'
=> 'Positive Gleitkommazahl',

   'Positive floating point number or zero'
=> 'Positive Gleitkommazahl oder Null',

   'Floating Point'
=> 'Gleitkommazahl',

   'Floating point number'
=> 'Gleitkommazahl',

   'Auto-enrollment settings'
=> 'Einstellungen für automatische Kursbelegungen',

   'Configuration setting'
=> 'Konfigurations-Einstellung',

   'Configuration Setting'
=> 'Konfigurations-Einstellung',

   'Value(s)'
=> 'Wert(e)',

   'Auto-enrollment active?'
=> 'Automatische Kursbelegung aktivieren?',

   'Access to other pages will be prevented until you have moved the message to your inbox.'
=> 'Zugriff auf andere Seiten wird erst ermöglicht, wenn Sie diese Nachricht in Ihren Posteingang verschoben haben.',

   'Access to other pages will be prevented until you have moved all critical messages to your inbox.'
=> 'Zugriff auf andere Seiten wird erst ermöglicht, wenn Sie alle wichtigen Nachrichten in Ihren Posteingang verschoben haben.',

   'Move to Inbox'
=> 'In Posteingang verschieben',

   'Move to Inbox/Compose reply'
=> 'In Posteingang verschieben und antworten',

   'Confirm Receipt'
=> 'Empfang bestätigen',

   'Confirm Receipt and Reply'
=> 'Empfang bestätigen und antworten',

   'Displaying Critical Messages'
=> 'Anzeige wichtiger Nachrichten',

   'Confirming Receipt'
=> 'Empfang bestätigen',

   'Confirmed Receipt'
=> 'Empfang bestätigt',

   'Communicate'
=> 'Kommunikation',

   'Replying to a Critical Message'
=> 'Antwort auf wichtige Nachricht',

   'Answer Available'
=> 'Antwort verfügbar',

   ' to '
=> ' bis ', # ???

   'Event from [_1] to [_2]'
=> 'Veranstaltung von [_1] bis [_2]',

   '[_1]: [_2] from domain [_3]'
=> '[_1]: Aus der Domäne [_3] [_2]',

   'The following problems occurred:'
=> 'Die folgenden Probleme traten auf:',

   'Could not initialize [_1] at this time.'
=> 'Initialisierung von [_1] war nicht möglich.',

   'Please try again.'
=> 'Bitte versuchen Sie es noch einmal.',

   'in this course'
=> 'in diesem Kurs',

   'Remove Checked Entries'
=> 'Ausgewählte Einträge entfernen',

   'Modify Student Data'
=> 'Studentische Daten ändern',

   'First name'
=> 'Vorname',

   'Middle name'
=> 'Zweiter Vorname',

   'Last name'
=> 'Nachname',

   'ID'
=> 'ID/Matrikelnummer',

   'Id'
=> 'ID/Matrikelnummer',

   'Sending critical message'
=> 'Sende wichtige Nachricht an',

   'Replying to'
=> 'Antwort an',

   'All messages:'
=> 'Alle Nachrichten:',

   'Unread messages:'
=> 'Ungelesene Nachrichten:',

   'Read messages:'
=> 'Gelesene Nachrichten:',

   'Replied to messages:'
=> 'Beantwortete Nachrichten:',

   'Forwarded messages:'
=> 'Weitergeleitete Nachrichten:',

   'showing messages [_1] through [_2] of [_3].'
=> 'Anzeige der Nachrichten [_1] bis [_2] von insgesamt [_3]',

   'Broadcast Message'
=> 'Broadcast-Nachricht',

   'randomly pick [quant,_1,resource]'
=> 'zufällig [quant,_1,Ressource,Ressourcen] wählen',

   'contents hidden'
=> 'Inhalte verborgen',

   'URLs hidden'
=> 'URLs verborgen',

   'random order'
=> 'zufällige Reihenfolge',

   'Resources in course with version changes since yesterday'
=> 'Ressourcen im Kurs mit Versionsänderungen seit gestern',

   'Version changes since Yesterday'
=> 'Versionsänderungen seit gestern',

   'Resources in course with version changes since last week'
=> 'Ressourcen im Kurs mit Versionsänderungen seit letzter Woche',

   'Version changes since last Week'
=> 'Versionsänderungen seit letzter Woche',

   'Resources in course with version changes since last month'
=> 'Ressourcen im Kurs mit Versionsänderungen seit letztem Monat',

   'Version changes since last Month'
=> 'Versionsänderungen seit letztem Monat',

   'Resources in course with version changes since start of course'
=> 'Ressourcen im Kurs mit Versionsänderungen seit Kursbeginn',

   'Resources in community with version changes since last month'
=> 'Ressourcen in der Community mit Versionsänderungen seit letztem Monat',

   'Resources in community with version changes since last week'
=> 'Ressourcen in der Community mit Versionsänderungen seit letzter Woche',

   'Resources in community with version changes since start of community'
=> 'Ressourcen in der Community mit Versionsänderungen seit Community-Beginn',

   'Resources in community with version changes since yesterday'
=> 'Ressourcen in der Community mit Versionsänderungen seit gestern',

   'Version changes since start of Course'
=> 'Versionsänderungen seit Kursbeginn',

   'Version changes since start of Community'
=> 'Versionsänderungen seit Community-Beginn',

   'No version changes since yesterday'
=> 'Keine Versionsänderungen seit gestern',

   'No version changes since last week'
=> 'Keine Versionsänderungen seit letzter Woche',

   'No version changes since last month'
=> 'Keine Versionsänderungen seit letztem Monat',

   'No version changes since start of course'
=> 'Keine Versionsänderungen seit Kursbeginn',

   'version changes since yesterday'
=> 'Versionsänderungen seit gestern',

   'version changes since last week'
=> 'Versionsänderungen seit letzter Woche',

   'version changes since last month'
=> 'Versionsänderungen seit letztem Monat',

   'version changes since start of course'
=> 'Versionsänderungen seit Kursbeginn',

   'Roles for which access to course has expired since yesterday'
=> 'Seit gestern in diesem Kurs abgelaufene Rollen',

   'Roles for which access to course has expired since last week'
=> 'Seit letzter Woche in diesem Kurs abgelaufene Rollen',

   'Roles for which access to course has expired since last month'
=> 'Seit letztem Monat in diesem Kurs abgelaufene Rollen',

   'Roles for which access to course has expired since start of course'
=> 'Seit Beginn des Kurses in diesem Kurs abgelaufene Rollen',

   'Roles for which access to community has expired since yesterday'
=> 'Seit gestern in dieser Community abgelaufene Rollen',

   'Roles for which access to community has expired since last week'
=> 'Seit letzter Woche in dieser Community abgelaufene Rollen',

   'Roles for which access to community has expired since last month'
=> 'Seit letztem Monat in dieser Community abgelaufene Rollen',

   'Roles for which access to community has expired since start of community'
=> 'Seit Beginn der Community in dieser Community abgelaufene Rollen',

   'There are no roles which expired since yesterday'
=> 'Keine Rollen, die in diesem Kurs seit gestern abgelaufen sind',

   'There are no roles which expired since last week'
=> 'Keine Rollen, die in diesem Kurs seit letzter Woche abgelaufen sind',

   'There are no roles which expired since last month'
=> 'Keine Rollen, die in diesem Kurs seit letztem Monat abgelaufen sind',

   'There are no roles which expired since start of course'
=> 'Keine Rollen, die in diesem Kurs seit Kursbeginn abgelaufen sind',

   'roles which expired since yesterday'
=> 'seit gestern in diesem Kurs abgelaufene Rollen',

   'roles which expired since last week'
=> 'seit letzter Woche in diesem Kurs abgelaufene Rollen',

   'roles which expired since last month'
=> 'seit letztem Monat in diesem Kurs abgelaufene Rollen',

   'roles which expired since start of course'
=> 'seit Beginn des Kurses in diesem Kurs abgelaufene Rollen',

   'Roles for which access to course has become available since yesterday'
=> 'Seit gestern diesem Kurs zugeteilte Rollen',

   'Roles for which access to course has become available since last week'
=> 'Seit letzter Woche diesem Kurs zugeteilte Rollen',

   'Roles for which access to course has become available since last month'
=> 'Seit letztem Monat diesem Kurs zugeteilte Rollen',

   'Roles for which access to course has become available since start of course'
=> 'Seit Beginn des Kurses diesem Kurs zugeteilte Rollen',

   'Roles for which access to community has become available since yesterday'
=> 'Seit gestern dieser Community zugeteilte Rollen',

   'Roles for which access to community has become available since last week'
=> 'Seit letzter Woche dieser Community zugeteilte Rollen',

   'Roles for which access to community has become available since last month'
=> 'Seit letztem Monat dieser Community zugeteilte Rollen',

   'Roles for which access to community has become available since start of community'
=> 'Seit Beginn der Community dieser Community zugeteilte Rollen',

   'There are no roles which have become active since yesterday'
=> 'Keine Rollen, die seit gestern diesem Kurs zugeteilt sind',

   'There are no roles which have become active since last week'
=> 'Keine Rollen, die seit letzter Woche diesem Kurs zugeteilt sind',

   'There are no roles which have become active since last month'
=> 'Keine Rollen, die seit letztem Monat diesem Kurs zugeteilt sind',

   'There are no roles which have become active since start of course'
=> 'Keine Rollen, die seit Kursbeginn diesem Kurs zugeteilt sind',

   'roles which have become active since yesterday'
=> 'seit gestern diesem Kurs zugeteilte Rollen',

   'roles which have become active since last week'
=> 'seit letzter Woche diesem Kurs zugeteilte Rollen',

   'roles which have become active since last month'
=> 'seit letztem Monat diesem Kurs zugeteilte Rollen',

   'roles which have become active since start of course'
=> 'seit Beginn des Kurses diesem Kurs zugeteilte Rollen',

   '[_1]Show all posts[_2] to display [quant,_3,post] previously marked read'
=> '[_1]Alle Beiträge anzeigen[_2], um [quant,_3,Beitrag,Beiträge] anzuzeigen, der/die zuvor als gelesen markiert wurde/n',

   '[_1]Show all posts[_2] to display [quant,_3,post] previously viewed'
=> '[_1]Alle Beiträge anzeigen[_2], um [quant,_3,Beitrag,Beiträge] anzuzeigen, der/die zuvor betrachtet wurde/n',

   'NEW'
=> 'NEU',

   'New'
=> 'Neu',

   'Old'
=> 'Alt',

   'Preferences on what is marked as NEW'
=> 'Präferenzen, was als NEU markiert werden soll',

   'My general preferences on what is marked as NEW'
=> 'Meine allgemeinen Präferenzen, was als NEU markiert werden soll',

   'Mark NEW posts no longer new'
=> 'Mit NEU gekennzeichnete Nachrichten nicht länger als neu markieren',

   'Sorting/Filtering options'
=> 'Sortierungs-/Filter-Optionen',

   'Export'
=> 'Exportieren',

   'Attachments'
=> 'Anhänge',

   'Download the zip file from [_1]Discussion Posting Archive[_2]'
=> 'Download ZIP-Datei vom [_1]Diskussionsbeitrags-Archiv[_2]',

   'The following errors occurred during export - [_1]'
=> 'Beim Exportieren sind folgende Fehler aufgetreten: [_1]',

   'Unfortunately you will not be able to retrieve an archive of the discussion posts at this time, because there was a problem creating a manifest file.'
=> 'Leider können Sie derzeit kein Archiv von Diskussionsbeiträgen erhalten, da es Probleme mit der Erstellung einer Manifest-Datei gab.',

   'Unfortunately you will not be able to retrieve an IMS archive of this posts at this time, because there was a problem creating a manifest file.'
=> 'Leider können Sie derzeit kein IMS-Archiv dieser Diskussionsbeiträge erhalten, da es Probleme mit der Erstellung einer Manifest-Datei gab.',

   'Unfortunately you will not be able to retrieve an IMS archive of your course at this time, because there was a problem creating a manifest file.'
=> 'Leider können Sie derzeit kein IMS-Archiv dieses Kurses erhalten, da es Probleme mit der Erstellung einer Manifest-Datei gab.',

   'Make Visible'
=> 'Anzeigen',

   'Mark unread'
=> 'Als ungelesen kennzeichnen',

   'Mark read'
=> 'Als gelesen kennzeichnen',

   'This post has been edited by the author.'
=> 'Dieser Beitrag wurde vom Autor überarbeitet.',

   'Display all versions'
=> 'Alle Versionen anzeigen',

   'Earlier version(s) were posted on: '
=> 'Frühere Versionen wurden gesendet am: ',

   'You do not have privileges to view all versions of posts.'
=> 'Sie sind nicht berechtigt, alle Versionen von Beiträgen anzuschauen.',

   'Please select a different role.'
=> 'Bitte wählen Sie eine andere Benutzerrolle.',

   'Error copying file attachment - [_1] to IMS package'
=> 'Fehler beim Kopieren des Datei-Anhangs - [_1] ins IMS-Paket',

   'Error copying file attachment - [_1] to IMS package: '
=> 'Fehler beim Kopieren des Datei-Anhangs - [_1] ins IMS-Paket: ',

   'Re: '
=> 'Re: ',

   'Please select a feedback type.'
=> 'Bitte wählen Sie einen Feedback-Typ aus.',

   'Sorry, no feedback possible on this resource ...'
=> 'Für diese Ressource kann kein Feedback gesendet werden.',

   'Sorry, no recipients ...'
=> 'Keine Empfänger.',

   'Error sending message to [_1], no user specified.'
=> 'Fehler beim Senden der Nachricht an [_1]. Es wurde kein Benutzer angegeben.',

   'Error sending message to [_1], no domain specified.'
=> 'Fehler beim Senden der Nachricht an [_1]. Es wurde keine Domäne angegeben.',

   'Error sending message to'
=> 'Fehler beim Senden der Nachricht an',

   'Not registered'
=> 'Nicht registriert', # ???

   'Editing not permitted'
=> 'Überarbeiten nicht erlaubt',

   'Marked postings read/unread'
=> 'Neue Beiträge als gelesen/ungelesen kennzeichnen',

   'Changed sort/filter'
=> 'Sortierung/Filter geändert',

   'Changed display status'
=> 'Anzeigestatus geändert',

   'Deletion not permitted'
=> 'Löschen nicht erlaubt',

   'Changed discussion status'
=> 'Diskussionsstatus geändert',

   'Changed discussion view mode'
=> 'Ansichtsmodus der Diskussion geändert',

   'Added to my course blog'
=> 'Zum eigenen Kurs-Blog hinzugefügt',

   'Added to my community blog'
=> 'Zum eigenen Community-Blog hinzugefügt',

   'Back to previous page'
=> 'Zurück zur vorherigen Seite',

   'Return to previous page'
=> 'Zurück zur vorherigen Seite',

   'Untitled resource'
=> 'Ressource ohne Titel',

   'Discussion display options'
=> 'Diskussions-Anzeige-Optionen',

   'Preferences can be set for this discussion that determine ....'
=> 'Für diese Diskussion können Präferenzen eingestellt werden, die festlegen...',

   'Which posts are displayed when you display this discussion board or resource, and'
=> 'welche Beiträge angezeigt werden, wenn Sie dieses Diskussionsforum bzw. diese Ressource anzeigen',

   'Under what circumstances posts are identified as "NEW", and'
=> 'unter welchen Bedingungen Beiträge als "NEU" identifiziert werden',

   'Whether individual posts can be marked as read/unread'
=> 'ob einzelne Beiträge als gelesen/ungelesen gekennzeichnet werden dürfen',

   'Posts not marked read'
=> 'Beiträge, die nicht als gelesen gekennzeichnet wurden',

   'New posts cease to be identified as "NEW"?'
=> 'Wann sollen neue Diskussionsbeiträge nicht mehr als "NEU" identifiziert werden?',

   'Option to mark each post as read/unread?'
=> 'Option anbieten, Beiträge als gelesen/ungelesen zu kennzeichnen?',

   'Marked "New" posts as read in a total of [_1] resources/discussion boards.'
=> 'Als "NEU" markierte Diskussionsbeiträge wurden in ingesamt [_1] Ressourcen/Diskussionsforen als gelesen gekennzeichnet.',

   'Shown'
=> 'anzeigen',

   'Not shown'
=> 'nicht anzeigen',

   'Discussion options'
=> 'Diskussionsforen-Optionen',

   'Set options that control the sort order of posts, and/or which posts are displayed.'
=> 'Einstellungen der Sortierungsreihenfolge von Beiträgen und welche Beiträge angezeigt werden',

   'Sort order'
=> 'Sortierungsreihenfolge',

   'Date order - oldest first'
=> 'nach Datum - ältester Beitrag zuerst',

   'Date order - newest first'
=> 'nach Datum - neuester Beitrag zuerst',

   'Threaded'
=> 'nach Beiträgen', # ???

   'By subject'
=> 'nach Thema',

   'By domain and username'
=> 'nach Domäne und Benutzerkennung',

   'By last name, first name'
=> 'nach Nachname, Vorname',

   'Specific role status'
=> 'Rollenstatus',

   'Roles of any status'
=> 'beliebig',

   'Only active roles'
=> 'nur aktive',

   'Only past roles'
=> 'nur inaktive',

   'Only future roles'
=> 'nur zukünftige',

   'Specific user roles'
=> 'Benutzerrollen',

   'All roles'
=> 'Alle Rollen',

   'Students'
=> 'Studierende',

   'Course Coordinators'
=> 'Kurs-Koordinatoren',

   'Instructors'
=> 'Dozenten',

   'TAs'
=> 'Tutoren',

   'Exam proctors'
=> 'Klausuraufsichtspersonal',

   'Custom Role'
=> 'Benutzerdefinierte Rolle',

   'Custom role'
=> 'Benutzerdefinierte Rolle',

   'Specific sections'
=> 'Bestimmte Sektionen',

   'Specific groups'
=> 'Bestimmte Gruppen',

   'Specific users'
=> 'Bestimmte Benutzer',

   'Pick specific users (by name)'
=> 'Bestimmte Benutzer auswählen (Name)',

   'Show a list of current posters'
=> 'Liste aktueller Beitragssender anzeigen',

   'So far, no data has been returned for your request'
=> 'Bis jetzt hat Ihre Anfrage keine Daten zurückgeliefert.',

   'Select a user'
=> 'Benutzerauswahl',

   'An error occurred while processing this resource. The course personnel ([_1]) and the author have been notified.'
=> 'Während der Verarbeitung dieser Ressource ist ein Fehler aufgetreten. Das Kurspersonal ([_1]) und der Autor wurden informiert.',

   'photo'
=> 'Foto',

   'Critical Message'
=> 'Wichtige Nachricht',

   'Display a Message'
=> 'Nachricht anzeigen',

   'Back to Folder Display'
=> 'Zurück zur Verzeichnisliste',

   'Currently available actions (will open extra window)'
=> 'Verfügbare Aktionen (öffnen in neuem Fenster)',

   'There are no unread messages in this folder.'
=> 'In diesem Verzeichnis befinden sich keine ungelesenen Nachrichten.',

   'There are no read messages in this folder.'
=> 'In diesem Verzeichnis befinden sich keine gelesenen Nachrichten.',

   'There are no forwarded messages in this folder.'
=> 'In diesem Verzeichnis befinden sich keine weitergeleiteten Nachrichten.',

   'You have not replied to any messages in this folder.'
=> 'In diesem Verzeichnis befinden sich keine Nachrichten, auf die Sie geantwortet haben.',

   'There are no messages in this folder.'
=> 'In diesem Verzeichnis befinden sich keine Nachrichten.',

   'To:'
=> 'An:',

   'Cc:'
=> 'CC:',

   'Bcc:'
=> 'BCC:',

   'Retrieve discussion and message records'
=> 'Aufzeichnungen von Diskussionen und Nachrichten abrufen',

   'New Record (record is visible to course faculty and staff)'
=> 'Neue Aufzeichnung (nur für Kursverwaltung und Personal sichtbar):',

   'New Record (record is visible to community coordinators and leaders)'
=> 'Neue  Aufzeichnung (nur für Community-Koordinatoren und Leiter)',

   'Post this Record'
=> 'Speichern',

   'Revise your search criteria for this domain'
=> 'Suchkriterien für die Suche in dieser Domäne ändern',

   'Metadata Modified'
=> 'Geänderte Metadaten',

   'Use of LON-CAPA requires Javascript to be enabled in your web browser.'
=> 'Zur Verwendung von LON-CAPA ist es notwendig, dass Sie Javascript in Ihrem Webbrowser aktiviert haben.',

   'Use of LON-CAPA requires java_script to be enabled in your web browser.'
=> 'Zur Verwendung von LON-CAPA ist es notwendig, dass Sie Javascript in Ihrem Webbrowser aktiviert haben.',

   'As this is not the case, most functionality in the system will be unavailable.'
=> 'Da dies momentan nicht der Fall ist, werden die meisten Funktionen des Systems nicht zur Verfügung stehen.',

   'The required Java applet could not be started, because Java is not supported by your mobile device.'
=> 'Das erforderliche Java-Applet konnte nicht gestartet werden, weil Ihr Mobilgerät kein Java unterstützt.',

   "You have requested to create file in directory [_1] which doesn't exist. The requested directory path has been removed from the requested filename."
=> "Schreiben in das Verzeichnis [_1] ist nicht möglich, da es nicht existiert. Der entsprechende Verzeichnispfad wurde daher entfernt.",

   'Directory'
=> 'Verzeichnis',

   'Create Directory'
=> 'Verzeichnis erstellen',

   'Only empty directories may be deleted.'
=> 'Es können nur leere Verzeichnisse gelöscht werden.',

   'You must delete the contents of the directory first.'
=> 'Sie müssen zunächst die Inhalte aus dem Verzeichnis entfernen.',

   'Cannot delete non-obsolete published file.'
=> 'Veröffentlichte, aber nicht als veraltet gekennzeichnete Dateien können nicht gelöscht werden.',

   'Must not include'
=> 'Darf nicht enthalten:',

   'Name of new file is the same as name of old file'
=> 'Name der neuen Datei ist der gleiche wie der der alten Datei',

   'no action taken'
=> 'keine Aktion ausgeführt',

   'copy metadata error'
=> 'Fehler beim Metadaten-Kopieren',

   'No New filename specified'
=> 'Kein neuer Dateiname angegeben',

   'Warning: a published problem of this name exists.'
=> 'Achtung: eine veröffentlichte Aufgabe mit diesem Namen existiert bereits.',

   'Warning: a published library of this name exists.'
=> 'Achtung: eine veröffentlichte Bibliothek mit diesem Namen existiert bereits.',

   'Bad filename [_1]'
=> 'Ungültiger Dateiname: [_1]',

   '[_1](name).(number).(extension)[_2] not allowed.'
=> '[_1](Name).(Zahl).(Erweiterung)[_2] ist nicht zulässig.',

   'Removing the [_1].number.[_2] from requested filename.'
=> '[_1].Zahl.[_2] wurde aus dem angeforderten Dateinamen entfernt.',

   'Cannot change MIME type of a directory.'
=> 'Der MIME-Typ eines Verzeichnisses kann nicht geändert werden.',

   'Cannot rename or move non-obsolete published file.'
=> 'Veröffentlichte, aber nicht als veraltet gekennzeichnete Dateien können nicht umbenannt oder verschoben werden.',

   'Change discussion display'
=> 'Anzeige von Diskussionen ändern',

   'Choose whether or not to display a count of the number of new posts for each resource or discussion board which has unread posts.'
=> 'Wahl, ob Anzahl neuer Beiträge in einzelnen Ressourcen oder Anzahl ungelesener Beiträge in Diskussionsforen angezeigt werden sollen.',

   "This can increase the time taken to gather data for the [_1]What's New Page[_2] by a few seconds."
=> "Dies kann die Dauer des Zusammenstellens der Daten für die [_1]Was-gibt's-Neues-Seite[_2] um ein paar Sekunden erhöhen.",

   'Currently set to [_1].'
=> 'Derzeit eingestellt auf [_1].',

   'Change to [_1]'
=> 'Auf [_1] umstellen',

   'No change'
=> 'Keine Änderung',

   'Count unread posts in discussions display set to [_1]'
=> 'Zähler für ungelesene Beiträge in Diskussionen auf [_1] gestellt.',

   'Groups Manager'
=> 'Gruppenverwaltung',

   'Group access start and end dates'
=> 'Start- und Endezeiten des Gruppenzugriffs',

   'None available'
=> 'keine verfügbar',

   'There are no active, future or previous group members to modify.'
=> 'Es existieren weder aktive, zukünftige noch in der Vergangenheit liegende Gruppen-Mitgliedschaften, die geändert werden könnten.',

   'Members to delete or expire'
=> 'Mitgliedschaften, die gelöscht werden oder ablaufen sollen',

   'To be deleted'
=> 'Zu löschen',

   'To be expired'
=> 'Abzulaufen',

   'No members to be deleted or expired from the group.'
=> 'Es existieren keine Mitgliedschaften, die aus der Gruppe entfernt werden oder ablaufen könnten.',

   'Files: [_1]'
=> 'Dateien: [_1]',

   'Folders: [_1]'
=> 'Verzeichnisse: [_1]',

   'Choose Task'
=> 'Aktion wählen',

   'Group Actions'
=> 'Gruppenaktionen',

   'Modify default group settings'
=> 'Voreingestellte Gruppeneinstellungen',

   'Modify access, tools and privileges for members'
=> 'Zugriff, Werkzeuge und Berechtigungen für Mitglieder ändern',

   'Add member(s) to the group'
=> 'Gruppenmitglieder hinzufügen',

   'Group Settings'
=> 'Gruppen-Einstellungen',

   'Modify/Delete Members'
=> 'Mitglieder ändern/entfernen',

   'Current Tool Set'
=> 'Derzeitige Werkzeuge',

   'Change Privileges'
=> 'Berechtigungen ändern',

   'Membership Mapping'
=> 'Mitgliedschafts-Zuordnung',

   'Group name, title and available collaborative tools'
=> 'Gruppenname, Titel und verfügbare kollaborative Werkzeuge',

   'Letters, numbers and underscore only'
=> 'nur Buchstaben, Ziffern und Unterstrich',

   'E-mail'
=> 'E-Mail',

   'Group home page'
=> 'Gruppen-Homepage',

   'Membership Roster'
=> 'Mitgliederliste',

   'Granularity:'
=> 'Granularität:',

   'Different subsets of the chosen collaborative tools for different group members?'
=> 'Unterschiedliche Teilbereiche der gewählten kollaborativen Werkzeuge für unterschiedliche Gruppenmitglieder?',

   'Disk Quota'
=> 'Speicherplatz',

   'Disk quota'
=> 'Speicherplatz',

   'disk usage (%)'
=> 'Speicherverbrauch (%)',

   'Course/Community Disk Usage'
=> 'Kurs-/Community-Speicherverbrauch',

   'Course/Community disk usage and quotas'
=> 'Kurs-/Community-Speicherverbrauch und Speicherplatz',

   'disk quota (MB)'
=> 'Speicherplatz (MB)',

   'If you enable the group portfolio for the group, allocate a disk quota.'
=> 'Falls Sie das Gruppen-Portfolio für die Gruppe aktivieren, weisen Sie Speicherplatz zu:',

   'MB'
=> 'MB',

   '[_1] MB'
=> '[_1] MB',

   'A total of [_1] MB can be divided amongst all groups in the course, and [_2] MB are currently unallocated.'
=> 'Insgesamt können [_1] MB auf alle Gruppen des Kurses aufgeteilt werden. [_2] MB sind derzeit noch nicht zugewiesen.',

   'Default start and end dates for group access'
=> 'Voreingestelltes Anfangs- und Enddatum für Gruppenzugriff',

   'Start:'
=> 'Start:',

   'End:'
=> 'Ende:',

   'Error: invalid course domain or number - group folder creation failed.'
=> 'Fehler: Ungültige Kurs-Domäne oder -Nummer. Das Erstellen des Gruppenverzeichnisses ist fehlgeschlagen.',

   'Error: invalid community domain or number - group folder creation failed.'
=> 'Fehler: Ungültige Community-Domäne oder -Nummer. Das Erstellen des Gruppenverzeichnisses ist fehlgeschlagen.',

   'Course Groups'
=> 'Kurs-Gruppen',

   'Non-standard course - folder for all groups not added.'
=> 'Kein Standard-Kurs - Verzeichnis für alle Gruppen wurde nicht hinzugefügt.',

   'Build a list of users for selection of group members'
=> 'Zusammenstellen einer Benutzerliste zur Auswahl von Gruppenmitgliedern',

   'Group membership selection list criteria:'
=> 'Auswahlkriterien für Gruppen-Mitgliedschaft:',

   'Pick the criteria to use to build a list of course users from which you will select '
=> 'Wählen Sie die Kriterien, die verwendet werden sollen, um die Liste der Kursbenutzer zu erstellen, anhand der Sie ',

   'Pick the criteria to use to build a list of community participants from which you will select '
=> 'Wählen Sie die Kriterien, die verwendet werden sollen, um die Liste der Community-Teilnehmer zu erstellen, anhand der Sie ',

   'members of the new group.'
=> 'die neuen Gruppenmitglieder wählen werden.',

   'If you do not wish to add members when you first create the group, there is no need to pick any criteria.'
=> 'Falls Sie beim Erstellen der Gruppe nicht sofort auch Mitglieder hinzufügen wollen, brauchen Sie hier keine Kriterien auswählen.',

   'A subsequent step will also allow you to specify automatic adding/dropping of group members triggered by specified user role and section [_1]changes[_2] in the course.'
=> 'Ein weiterer Teilschritt wird Ihnen ermöglichen, automatisches Hinzufügen und Entfernen von Gruppenmitgliedern anzugeben. Dies wird durch angegebene Benutzerrollen und Sektions[_1]änderungen[_2] im Kurs ausgelöst.',

   'Access types'
=> 'Zugriffstypen',

   'Currently has access'
=> 'Aktueller Zugriff',

   'Will have future access'
=> 'Zukünftiger Zugriff',

   'Previously had access'
=> 'In der Vergangenheit liegender Zugriff',

   'Course roles'
=> 'Benutzerrollen', # 'Benutzerrollen im Kurs',

   'Course sections'
=> 'Sektionen im Kurs',

   'Community sections'
=> 'Sektionen in der Community',

   'all sections'
=> 'Alle Sektionen',

   'no section'
=> 'Keine Sektion',

   'Invalid group name'
=> 'Ungültiger Gruppenname',

   'The group name entered '
=> 'Der eingegebene Name ',

   'is not a valid name.'
=> 'ist kein gültiger Name.',

   'can not be used as it is the name of '
=> 'kann nicht verwendet werden, da es sich um den Namen ',

   'an existing group'
=> 'einer bereits bestehenden Gruppe handelt',

   ' in this Course'
=> ' in diesem Kurs',

   'Group names and section names used in a Course must be unique.'
=> 'Gruppen- und Sektionsnamen müssen in einem Kurs eindeutig sein.',

   'Group names may only contain letters, numbers or underscores.'
=> 'Gruppennamen dürfen nur aus Buchstaben, Zahlen und Unterstrichen bestehen.',

   'Previous'
=> 'Zurück',

   'Select Members'
=> 'Mitgliederauswahl',

   'Your group selections - '
=> 'Gruppenauswahl',

   'The following settings will apply to the group:'
=> 'Die folgenden Einstellungen werden auf Ihre Gruppe wirken:',

   'Granularity'
=> 'Granularität',

   'File quota'
=> 'Speicherplatz für Dateien',

   'Default access dates'
=> 'Voreingestellte Zugriffszeiten',

   'Default Access Dates'
=> 'Voreingestellte Zugriffszeiten',

   'Access Dates'
=> 'Zugriffszeiten',

   'Different collaborative tools[_1]for different members:'
=> 'Unterschiedliche kollaborative Werkzeuge[_1]für unterschiedliche Mitglieder:',

   'Start date'
=> 'Anfangsdatum',

   'Start date:'
=> 'Anfangsdatum:',

   'End date'
=> 'Enddatum',

   'End date:'
=> 'Enddatum:',

   'Available for assignment to members:'
=> 'Zugriff für Mitglieder möglich:',

   'Unavailable for assignment:'
=> 'Kein Zugriff möglich:',

   'User privileges for collaborative tools'
=> 'Benutzerrechte für kollaborative Werkzeuge',

   'For each collaborative tool you have chosen to include, there is a set of core privileges which all group members assigned use of the tool will receive.'
=> 'Für jedes der kollaborativen Werkzeuge, das Sie zur Verwendung gewählt haben, existiert eine Reihe von Grundberechtigungen, die allen Gruppenmitgliedern, die dieses Werkzeug erhalten, zugewiesen werden.',

   'For some tools there are also additional optional privileges which can be set.'
=> 'Für manche Werkzeuge können auch weitere optionale Berechtigungen festgelegt werden.',

   'Choose one of the following:'
=> 'Wählen Sie eines der folgenden:',

   'For the collaborative tools you have chosen to include only core privileges are available, so there are no optional privileges to assign.'
=> 'Für die von Ihnen gewählten kollaborativen Werkzeuge sind nur Grundberechtigungen verfügbar. Daher können keine optionalen Berechtigungen zugewiesen werden.',

   'As you have chosen not to include any collaborative tools in the group, no default optional privileges need to be set.'
=> 'Da Sie keinerlei kollaborativen Werkzeuge für die Gruppe gewählt haben, die eingebunden werden sollen, brauchen keine voreingestellten optionalen Berechtigungen eingestellt werden.',

   'Group membership'
=> 'Gruppen-Mitgliedschaft',

   'Add members'
=> 'Mitglieder hinzufügen',

   'Assign collaborative tools'
=> 'Kollaborative Werkzeuge zuweisen',

   'Tools'
=> 'Werkzeuge',

   'Add Members'
=> 'Mitglieder hinzufügen',

   'Add?'
=> 'Hinzufügen?',

   'All:'
=> 'Alle:',

   'You have indicated that the group portfolio should be enabled, but you have set the repository quota to 0 MB.\nThis will prevent any upload of files.\nPlease set a value or disable the repository feature.'
=> 'Sie haben angegeben, dass das Gruppen-Portfolio aktiviert werden soll, jedoch einen Speicherplatz von 0 MB angegeben.\nDies verhindert jegliches Hochladen von Dateien.\nBitte geben Sie einen Wert größer 0 ein oder deaktivieren Sie das Portfolio.',

   'Group membership list updated.'
=> 'Die Liste der Gruppen-Mitgliedschaften wurde aktualisiert.',

   'Any currently logged in course users affected by the changes you made to group membership or privileges for the [_1] group will need to log out and log back in for their LON-CAPA sessions to reflect these changes.'
=> 'Sie haben Gruppen-Mitgliedschaften und/oder -berechtigungen für die Gruppe [_1] eingestellt bzw. geändert. Alle derzeit angemeldeten Benutzer, für die diese Einstellungen wirken, müssen sich aus- und wieder einloggen, damit für sie die Änderungen wirksam werden.',

   'An error occurred while updating the group membership list:'
=> 'Beim Aktualisieren der Gruppen-Teilnehmerliste ist ein Fehler aufgetreten:',

   'Choose Privileges'
=> 'Auswahl der Berechtigungen',

   'Setting Changes Complete'
=> 'Änderungen der Einstellungen abgeschlossen',

   'Modifications Complete'
=> 'Änderungen abgeschlossen',

   'Creation Complete'
=> 'Erstellung abgeschlossen',

   'Additions Complete'
=> 'Hinzufügungen abgeschlossen',

   'Verify deletion'
=> 'Entfernen-Bestätigung',

   'Deletion Complete'
=> 'Entfernen abgeschlossen',

   'Create Group'
=> 'Gruppe erstellen',

   'discussion'
=> 'Diskussion',

   'homepage'
=> 'Homepage',

   'roster'
=> 'Teilnehmerliste',

   'Edit Group Homepage'
=> 'Gruppen-Homepage ändern',

   'Edit Group Settings'
=> 'Gruppeneinstellungen ändern',

   'Available Group Tools'
=> 'Verfügbare Gruppenwerkzeuge',

   'Group Chat Room'
=> 'Gruppen-Chatroom',

   'Group Chat Room:'
=> 'Gruppen-Chatroom:',

   'Group page - [_1]'
=> 'Gruppenseite - [_1]',

   '[_1] discussion boards - [_2]'
=> '[_1]-Diskussionsforen - [_2]',

   'New Discussion Board'
=> 'Neues Diskussionsforum anlegen',

   'There are currently no discussion boards in this course.'
=> 'In diesem Kurs sind derzeit keine Diskussionsforen.',

   'There are currently no discussion boards in this group.'
=> 'In dieser Gruppe sind derzeit keine Diskussionsforen.',

   'Discussion Board Title'
=> 'Titel des Diskussionsforums',

   'discussion board'
=> 'Diskussionsforum',

   'The new discussion board was added successfully.'
=> 'Das neue Diskussionsforum wurde erfolgreich angelegt.',

   'Edit [_1] board'
=> 'Diskussionsforum [_1] ändern',

   'View all group discussion boards'
=> 'Alle Gruppen-Diskussionsforen anschauen',

   'Show Student View'
=> 'Studentische Sicht zeigen',

   'Student View'
=> 'Studentische Sicht',

   'Course View'
=> 'Kursansicht',

   'Community View'
=> 'Community-Ansicht',

   'Note: in anonymous discussion, your name is visible only to course faculty'
=> 'Beachten Sie, dass Ihr Name bei anonymer Diskussionsteilnahme nur für die Kursverwaltung sichtbar ist.',

   'Note: in anonymous discussion, your name is visible only to community facilitators'
=> 'Beachten Sie, dass Ihr Name bei anonymer Diskussionsteilnahme nur für die Community-Verwaltung sichtbar ist.',

   'Send a Message in a Group'
=> 'Nachricht innerhalb einer Gruppe verschicken',

   'As this group has no members, there are no recipients to select.'
=> 'Da diese Gruppe keine Mitglieder hat, können Sie keine Empfänger auswählen.',

   'Allow replies'
=> 'Antworten zulassen',

   'Reply to'
=> 'Antwort an',

   '[_1] portfolio files - [_2]'
=> '[_1]-Portfolio-Dateien - [_2]',

   'There are no membership data to display for this [_1]'
=> 'Für diesen [_1] existieren keine anzeigbaren Mitgliedsdaten.',

   'Group Membership'
=> 'Gruppen-Mitgliedschaften',

   '[_1] membership status - [_2]'
=> '[_1]-Mitgliedschaftsstatus - [_2]',

   'Group Message'
=> 'Gruppen-Nachricht',

   'Compose Group Message'
=> 'Gruppen-Nachricht verfassen',

   'Course Discussion Boards'
=> 'Kurs-Diskussionsforen',

   'Post Discussion'
=> 'Diskussionsbeitrag abschicken',

   'Post Anonymous Discussion'
=> 'Diskussionsbeitrag anonym abschicken',

   'Content'
=> 'Inhalt',

   'You do not currently have rights to view this group.'
=> 'Sie haben derzeit keine Berechtigung diese Gruppe zu sehen.',

   'No page information provided.'
=> 'Keine Seiteninformationen angegeben.',

   'Available functions'
=> 'Verfügbare Funktionen',

   'No group functionality.'
=> 'Keine Gruppenfunktionen.',

   'No group functionality (e.g., e-mail, discussion, chat room or file upload) is currently available to you in this group: [_1].'
=> 'Derzeit ist in der Gruppe [_1] keine Gruppenfunktion (z.B. E-Mail, Diskussion, Chatroom oder Dateien-Hochladen) verfügbar.',

   'Simple Group Page'
=> 'Einfache Gruppen-Seite',

   'Quota allocated to group portfolio:'
=> 'Speicherplatz für Gruppen-Portfolio:',

   'The quota is currently [_1] MB'
=> 'Der Speicherplatz beträgt derzeit [_1] MB',

   'The quota can be increased to [_1] MB, by adding all unallocated space for groups in the course.'
=> 'Der Speicherplatz kann auf bis zu [_1] MB erhöht werden, indem der gesamte nicht zugewiesene Speicherplatz für Gruppen des Kurses hinzugefügt wird.',

   'Each collaborative tool includes core privileges assigned to all members with access to the tool. Some tools may also feature additional privileges which can be set for specific members.'
=> 'Jedes kollaborative Werkzeug bietet allen Benutzern, die Zugriff auf das Werkzeug haben, grundlegende Berechtigungen. Einige Werkzeuge bieten weitere Möglichkeiten, die für ausgewählte Gruppenmitglieder eingestellt werden können.',

   'All group members will receive the same privileges for any tool assigned to them, including the default set of optional privileges.'
=> 'Alle Gruppenmitglieder erhalten die gleichen Berechtigungen für alle Werkzeuge, die ihnen zugewiesen wurden - die voreingestellten optionalen Berechtigungen eingeschlossen.',

   'Different group members may receive different privileges from others for the tools they have been assigned.'
=> 'Unterschiedliche Gruppenmitglieder können unterschiedliche Berechtigungen für Werkzeuge von anderen erhalten, die diese zugewiesen bekommen haben.',

   'Indicate which [_1]optional[_2] privileges members will receive by default for a specific tool.'
=> 'Angabe, welche [_1]optionalen[_2] Berechtigungen für ein bestimmtes Werkzeug voreingestellt zugewiesen werden sollen.',

   'These will be the privileges given to members assigned in the future via automatic group assignment for users who receive specific sections/roles in the course '
=> 'Es handelt sich um die Berechtigungen, die Gruppenmitglieder durch das automatische Belegen von Gruppen zukünftig erhalten. Dies betrifft Benutzer, die bestimmte Sektionen/Rollen im Kurs erhalten ',

   'These will be the privileges given to members assigned in the future via automatic group assignment for users who receive specific sections/roles in the community '
=> 'Es handelt sich um die Berechtigungen, die Gruppenmitglieder durch das automatische Belegen von Gruppen zukünftig erhalten. Dies betrifft Benutzer, die bestimmte Sektionen/Rollen in der Community erhalten ',

   'if enabled on the next page'
=> 'falls auf der nächsten Seite aktiviert',

   'if enabled below'
=> 'falls im Folgenden aktiviert',

   'Additional privileges'
=> 'Zusätzliche Berechtigungen',

   'Fixed privileges'
=> 'Feste Berechtigungen',

   'Optional privileges'
=> 'Optionale Berechtigungen',

   'Collaborative Tool'
=> 'Kollaboratives Werkzeug',

   'Fixed'
=> 'fest',

   'Optional'
=> 'optional',

   'Additional Tools'
=> 'Weitere Werkzeuge',

   'Core privileges'
=> 'Grund-Berechtigungen',

   'For the collaborative tools included for group members being added or modified, there are no optional privileges to set for specific members.'
=> 'Für die kollaborativen Werkzeuge, die für Gruppenmitglieder hinzugefügt bzw. geändert werden, gibt es keine optionalen Berechtigungen, die für bestimmte Mitglieder einzustellen wären.',

   'All new group members will receive the same privileges.'
=> 'Alle neuen Gruppenmitglieder werden die gleichen Berechtigungen erhalten.',

   'If previously expired members are being re-enabled, or if access for future members is being activated now, previously set privileges will be preserved.'
=> 'Falls nicht mehr aktive Mitgliedschaften wiederhergestellt werden oder falls Zugriff für zukünftige Mitglieder jetzt aktiviert wird, bleiben zuvor eingestellte Berechtigungen erhalten.',

   'As no group members are being added, there are no specific user privileges to set.'
=> 'Da keine Gruppenmitglieder hinzugefügt werden, können auch keine Berechtigungen für bestimmte Benutzer eingestellt werden.',

   'No group member privileges to display or set, as you have not indicated that you will be activating, re-enabling, changing privileges, or adding/removing tools for any current members.'
=> 'Es können keine Berechtigungen für Gruppenmitglieder angezeigt oder eingestellt werden, da Sie nicht angegeben haben, dass Sie Berechtigungen aktivieren, wiederherstellen oder ändern möchten oder dass Werkzeuge für aktuelle Benutzer hinzugefügt oder geändert werden sollen.',

   'Currently the group is configured '
=> 'Derzeit ist die Gruppe so konfiguriert, dass ',

   'so different members can receive different optional privileges for a particular tool.'
=> 'unterschiedliche Gruppenmitglieder unterschiedliche optionale Berechtigungen für jedes einzelne Werkzeug erhalten können.',

   'so all members will receive the same optional privileges for a particular tool.'
=> 'alle Gruppenmitglieder die gleichen optionalen Berechtigungen für jedes einzelne Werkzeug erhalten.',

   'Settings for automatic group enrollment'
=> 'Einstellungen für die automatisierte Gruppenbelegung',

   'Group membership mapping to specific sections/roles'
=> 'Verweis von Gruppen-Mitgliedschaften auf bestimmte Sektionen/Rollen',

   'Enable/disable automatic group enrollment for users in specified roles and sections'
=> 'Aktivierung/Deaktivierung der automatischen Belegung von Gruppen für Benutzer mit bestimmten Rollen und in bestimmten Sektionen',

   'If automatic group enrollment is enabled, when a user is newly assigned a course-wide or section-specific role, he/she will automatically be added as a member of the group, with start and end access dates defined by the default dates set for the group, unless he/she is already a group member, with access dates that permit either current or future group access.'
=> 'Falls die automatische Gruppenbelegung aktiviert ist: Wenn ein Benutzer eine kursweite Rolle oder für eine bestimmte Sektion neu zugewiesen bekommen hat, wird er automatisch als Mitglied der Gruppe hinzugefügt. Die Anfangs- und Endzugriffszeiten werden durch die Datumswerte vorgegeben, die für die Gruppe voreingestellt sind. Das allerdings nur, wenn der Benutzer nicht bereits Gruppenmitglied mit Zugriffszeiten ist, die aktuellen oder zukünftigen Gruppenzugriff zulassen.',

   "If automatic group disenrollment is enabled, when a user's role is expired, access to the group will be terminated unless the user continues to have other course-wide or section-specific active or future roles which receive automatic membership in the group."
=> "Falls das automatische Ausschließen aus Gruppen aktiviert ist: Wenn eine Benutzerrolle ausläuft, wird der Zugriff auf die Gruppe entzogen, sofern der Benutzer nicht andere kursweite oder für eine bestimmte Sektion aktive oder zukünftige Rollen hat, die automatischen Gruppenzugriff ermöglichen.",

   'Automatically enable group membership when roles are added?'
=> 'Automatisches Belegen von Gruppen, wenn Rollen hinzugefügt werden?',

   'Automatically expire group membership when roles are removed?'
=> 'Automatisches Ausschließen aus Gruppen, wenn Rollen entfernt werden?',

   'Currently set to'
=> 'Derzeit eingestellt auf',

   'Mapping of roles and sections affected by automatic group enrollment/disenrollment follows scheme chosen below.'
=> 'Das Verweisen von Rollen und Sektionen durch das automatische Belegen von/Ausschließen aus Gruppen folgt dem folgenden Schema.',

   'Pick roles and sections for automatic group enrollment'
=> 'Auswahl von Rollen und Sektionen für das automatische Belegen von Gruppen',

   'Active?'
=> 'Aktiv?',

   'Send group message'
=> 'Gruppennachricht senden',

   'Create boards'
=> 'Erstellen von Foren',

   'Edit own posts'
=> 'Eigene Beiträge bearbeiten',

   'Hide/Delete any post'
=> 'Anzeigen/Löschen beliebiger Beiträge',

   'View boards'
=> 'Foren anschauen',

   'Control Access'
=> 'Zugriffskontrolle',

   'Basic Display'
=> 'Einfache Anzeige',

   'Detailed Display'
=> 'Detaillierte Anzeige',

   'View page'
=> 'Seite betrachten',

   'Modify page'
=> 'Seite ändern',

   'communication'
=> 'Kommunikation',

   'Broadcast message'
=> 'Broadcast-Nachricht',

   'files'
=> 'Dateien',

   'Foils without names exist. This can cause problems to malfunction.'
=> 'Es existieren Auswahlmöglichkeiten ohne Namen. Das könnte eine fehlerhafte Funktionalität verursachen.',

   'Unknown area style [_1]'
=> 'Unbekannter Bereichstyp: [_1]',

   "The message itself will begin with a first line: [_1]'Forwarded message from'[_2] followed by the original sender's name."
=> "Die Nachricht wird in der ersten Zeile mit [_1]'Weitergeleitete Nachricht von'[_2] starten, gefolgt vom Originalnamen des Absenders.",

   'Forwarded message from '
=> 'Weitergeleitete Nachricht von ',

   'You received a critical message from [_1] in LON-CAPA.'
=> 'Sie haben eine wichtige Nachricht von [_1] in LON-CAPA erhalten.',

   'You received a message from [_1] in LON-CAPA.'
=> 'Sie haben eine Nachricht von [_1] in LON-CAPA erhalten.',

   "'New' critical message from [_1]"
=> "Neue wichtige Nachricht von [_1]",

   "'New' message from [_1]"
=> "Neue Nachricht von [_1]",

   'Refers to'
=> 'Bezieht sich auf',

   'Previous attempts of student (if applicable)'
=> 'Bisherige Versuche des/der Studenten/in (falls verfügbar)',

   'Previous attempts of member (if applicable)'
=> 'Bisherige Versuche des Mitglieds (falls verfügbar)',

   'Original screen output (if applicable)'
=> 'Original-Bildschirmausgabe (falls verfügbar)',

   'Correct Answer(s) (if applicable)'
=> 'Korrekte Antwort(en) (falls verfügbar)',

   'LON-CAPA messages sent to you between [_1] and [_2] will be inaccessible until the end of this time period, because you are a student in a course with an active communications block.'
=> 'Sie haben auf Ihnen zugesandte LON-CAPA-Nachrichten zwischen [_1] und [_2] bis zum Ende dieses Zeitbereichs keinen Zugriff, da Sie Student/in in einem Kurs mit aktiver Kommunikationssperre sind.',

   'The subject is 

 [_1]

'
=> 'Der Betreff lautet 

 [_1]

',

   'Excerpt'
=> 'Auszug',

   'Use 

 [_1]

to access the full message.'
=> 'Ueber 

 [_1]

erhalten Sie auf die gesamte Nachricht Zugriff.',

   'You can reply to this e-mail'
=> 'Sie können auf diese E-Mail antworten.',

   'Please do not reply to this address.'
=> 'Bitte antworten Sie nicht an die Absender-E-Mail-Adresse.',

   'A reply will not be received by the recipient!'
=> 'Eine Antwort wuerde nicht beim vorgesehenen Empfaenger ankommen!',

   "Include in course's 'User records' for recipient(s)"
=> "In Kurs-Benutzeraufzeichnungen des Empfängers einbinden",

   "Include in community's 'User records' for recipient(s)"
=> "In Community-Benutzeraufzeichnungen des Empfängers einbinden",

   'No replies to sender'
=> 'Keine Antwort an Absender möglich',

   'Display Message'
=> 'Nachricht anzeigen',

   'Replying to a Message'
=> 'Nachricht beantworten',

   'Forwarding a Message'
=> 'Nachricht weiterleiten',

   'Forwarding Multiple Messages'
=> 'Mehrere Nachrichten weiterleiten',

   'At end of file some tags were still left unclosed, '
=> 'Am Ende der Datei sind noch nicht geschlossene Tags übrig: ',

   'Upload and Send'
=> 'Hochladen und Absenden',

   'Choose which course(s) to list.'
=> 'Auswahl der Kurse, die angezeigt werden sollen',

   'Display courses'
=> 'Kurse anzeigen',

   'Display communities'
=> 'Communitys anzeigen',

   'Public'
=> 'Öffentlich',

   'Answer [_1]'
=> 'Antwort [_1]',

   'EditXML [_1]'
=> 'XML-Editor [_1]',

   'Not authorized'
=> 'Nicht berechtigt',

   'An error occurred while processing this resource. The author has been notified.'
=> 'Während der Verarbeitung dieser Ressource ist ein Fehler aufgetreten. Der Autor wurde informiert.',

   'Code ran too long. It ran for more than [_1] seconds.'
=> 'Die Ausführung hat zu lange gedauert ("Code ran too long"). Sie dauerte länger als [_1] Sekunden.',

   'This occurred while running &lt;while&gt; on line [_1].'
=> 'Dies trat während der Ausführung von &lt;while&gt; in der Zeile [_1] auf.',

   'This occurred while running: [_1]'
=> 'Dies trat auf während der Ausführung von: [_1]',

   'Substitution on [_1] with [_2] caused:'
=> 'Ersetzung von [_1] durch [_2] hat verursacht:',

   'Correct answer'
=> 'Korrekte Antwort',

   'Could not identify problem.'
=> 'Aufgabe konnte nicht identifiziert werden', # ???

   'Chart'
=> 'Chart',

   'Student Data'
=> 'Studentische Daten',

   'HTML, with links'
=> 'HTML, mit Links',

   'HTML, with all links'
=> 'HTML, mit allen Links',

   'HTML, without links'
=> 'HTML, ohne Links',

   'Output Data'
=> 'Ausgabedaten',

   'Scores Summary'
=> 'Punktesumme',

   'Scores Per Problem'
=> 'Punkte je Aufgabe',

   'Parts Correct'
=> 'Richtige Teile',

   'id'
=> 'ID/Matr.-Nr.',

   'Generate Chart'
=> 'Chart generieren',

   'Generate Graph'
=> 'Chart generieren',

   'Select One Student'
=> 'Einzelne/n Studenten/in wählen',

   'All sections.'
=> 'Alle Sektionen.',

   'Section [_1].'
=> 'Sektion [_1].',

   'Section [_1]'
=> 'Sektion [_1]',

   'Sections [_1] and [_2].'
=> 'Sektionen [_1] und [_2].',

   'All groups.'
=> 'Alle Gruppen.',

   'Group [_1].'
=> 'Gruppe [_1].',

   'Groups [_1] and [_2].'
=> 'Gruppen [_1] und [_2].',

   'Active access status.'
=> 'Aktiver Zugriffsstatus.',

   'Future access status.'
=> 'Zukünftiger Zugriffsstatus.',

   'Expired access status.'
=> 'Abgelaufener Zugriffsstatus.',

   'Any access status.'
=> 'Beliebiger Zugriffsstatus.',

   'Show links in new window:'
=> 'Links in neuem Fenster öffnen:',

   'Show links in new window'
=> 'Links in neuem Fenster öffnen',

   'Summary Table'
=> 'Zusammenfassende Tabelle',

   'Summary Tables'
=> 'Zusammenfassende Tabellen',

   'Summary table for [_1] ([_2])'
=> 'Zusammenfassende Tabelle für [_1] ([_2])',

   'Average'
=> 'Durchschnitt',

   'maximum'
=> 'Maximum',

   'Maximum'
=> 'Maximum',

   'Minimum'
=> 'Minimum',

   'Max. Total'
=> 'Max. Gesamt',

   'Median'
=> 'Median',

   'Std Dev'
=> 'Std.-Abw.',

   'sum'
=> 'Summe',

   'maximum possible'
=> 'Maximal erreichbar',

   'parts correct'
=> 'korrekte Teile',

   'Return to the chart'
=> 'Zurück zum Chart',

   'Compiled on [_1]'
=> 'Erstellt am [_1]',

   "Click on a student's name or username to view their chart."
=> "Klicken Sie auf den Namen oder die Benutzerkennung eines/r Studenten/in, um dessen Chart anzuzeigen.",

   'status'
=> 'Status',

   'Status:'
=> 'Status:',

   'Status: [_1]'
=> 'Status: [_1]',

   'Picture Conversion Status [_1]'
=> 'Bildumwandlungs-Status [_1]',

   'Class Print Status [_1]'
=> 'Druckklassen-Status [_1]',

   'groups'
=> 'Gruppen',

   'Essay will be hand graded.'
=> 'Essay wird manuell bewertet.',

   'Text you want to appear by default:'
=> 'Text, der voreingestellt angezeigt werden soll:',

   'Check as many files as you wish in response to the problem:'
=> 'Wählen Sie alle Dateien aus, die als Antwort eingereicht werden sollen:',

   'Select portfolio files'
=> 'Auswahl Portfolio-Dateien',

   'Select checked files, and continue selecting'
=> 'Auswahl übernehmen und weiter auswählen',

   'Select checked files, and close window'
=> 'Auswahl übernehmen und Fenster schließen',

   'Copy of'
=> 'Kopie von',

   'Overall result: [_1]'
=> 'Gesamtergebnis: [_1]',

   'Dimension: [_1], status [_2] '
=> 'Dimension: [_1], Status [_2] ',

   'Queue Status'
=> 'Warteschlangen-Status',

   'Check Mark'
=> 'Korrekt-Zeichen',

   'Return commented version of [_1] to student.' # 1: filename
=> 'Rückgabe kommentierter Version von [_1] an Student/in.',

   'Download All Submitted Documents'
=> 'Alle eingereichten Dokumente herunterladen',

   'Essay is [_1]% similar to an essay by [_2] in course [_3] (course id [_4]:[_5])'
=> 'Das Essay stimmt zu [_1]% mit dem Essay von [_2] im Kurs [_3] (Kurs-ID [_4]:[_5]) überein',

   'Compose message to student'
=> 'Nachricht an Student/in erstellen',

   'Compose message to students'
=> 'Nachricht an Studierende erstellen',

   'incl. grades'
=> 'Bewertung einbinden',

   'Message will be sent when you click on Save &amp; Next below.'
=> 'Nachricht wird gesendet, sobald Sie auf Speichern und weiter klicken.',

   'Set/Change parameters'
=> 'Parameter setzen/ändern',

   'Grading Feedback'
=> 'Bewertungs-Feedback',

   'Sending message to [_1]'
=> 'Sende Nachricht an [_1]',

   'Not allowed to modify grades for [_1]'
=> 'Keine Berechtigung zur Änderung der Bewertungen für [_1].',

   'You need to specify the username or the student/employee ID'
=> 'Sie müssen eine Benutzerkennung oder eine Studierenden-/Mitarbeiter-ID angeben',

   'You need to specify at least one grading field'
=> 'Sie müssen mindestens ein Bewertungsfeld ausfüllen',

   'Specify a file containing the class scores for current resource.'
=> 'Angabe einer Datei, die Kursbewertungen für diese Ressource enthält.',

   'Upload Scores'
=> 'Bewertungen hochladen',

   'Some point values were assigned for problems with a weight of zero. These values were ignored.'
=> 'In einigen Aufgaben wurden Punkte vergeben, bei denen die Gewichtung Null ist. Daher wurden diese Werte ignoriert.',

   'Some resources in the sequence currently are not set to exam mode. Grading these resources currently may not work correctly.'
=> 'Einige Ressourcen in der Sequenz sind derzeit nicht auf "Prüfung" eingestellt. Eine Bewertung dieser Ressourcen könnte derzeit nicht korrekt funktionieren.',

   'Process'
=> 'Verarbeite',

   'clicker file' # Process clicker file
=> 'Clicker-Datei',

   'Grade'
=> 'Bewerte',

   'Grade Student'
=> 'Student/in bewerten',

   'Grade student'
=> 'Student/in bewerten',

   'Store grades'
=> 'Bewertungen speichern',

   'bubblesheet forms'
=> 'Bubblesheet-Formulare',

   'Verifying Receipt No. [_1]'
=> 'Überprüfung der Nachweis-Nr. [_1]',

   'Verifying Receipt Number [_1]'
=> 'Überprüfung der Nachweisnummer [_1]',

   'receipt no.'
=> 'Nachweis-Nr.',

   'Verify Receipt Number'
=> 'Nachweisnummer überprüfen',

   'Verify Receipt Number.'
=> 'Nachweisnummer überprüfen',

   'Verify a system-generated receipt number for correct problem solution.'
=> 'Eine systemgenerierte Nachweisnummer für eine korrekte Aufgabenlösung überprüfen',

   'Manage'
=> 'Verwalten',

   'Specify a file containing the clicker information for this resource.'
=> 'Angabe einer Datei, die Clicker-Informationen für diese Ressource enthält.',

   'Upload File'
=> 'Datei hochladen',

   'Award points just for participation'
=> 'Erreichte Punkte, lediglich für Teilnahme',

   'Correctness determined from response by course personnel'
=> 'Korrektheit, bestimmt durch Antwort durch Kurspersonal',

   'Correctness determined from response with clicker ID(s)'
=> 'Korrektheit, bestimmt durch Antwort mit Clicker-ID(s)',

   'Correctness determined from given list of answers'
=> 'Korrektheit, bestimmt durch externe Liste mit Antworten',

   "Provide comma-separated list. Use '*' for any answer correct, '-' for skip"
=> "Stellen Sie eine durch Kommata getrennte Liste zur Verfügung mit '*' für 'jede Antwort ist richtig' und '-' für Auslassen.",

   'Percentage points for correct solution'
=> 'Prozentuale Punkte für korrekte Lösung',

   'Percentage points for incorrect solution'
=> 'Prozentuale Punkte für inkorrekte Lösung',

   'You need to specify a clicker ID for the correct answer'
=> 'Sie müssen für die korrekte Antwort eine Clicker-ID angeben',

   'Score based on attendance only'
=> 'Punkte, die lediglich auf Anwesenheit beruhen',

   'Correctness determined by the following IDs'
=> 'Korrektheit, bestimmt durch folgende IDs',

   'specified'
=> 'angegeben',

   'No IDs found to determine correct answer'
=> 'Keine IDs gefunden, um korrekte Antwort bestimmen zu können',

   'Scanning clicker file'
=> 'Scanne Clicker-Datei',

   'Found [_1] question(s)'
=> '[_1] Frage(n) gefunden',

   'Awarding [_1] percent for correct and [_2] percent for incorrect responses'
=> '[_1] Prozent für korrekte und [_2] Prozent für inkorrekte Antworten erhalten',

   'Clicker registered more than once'
=> 'Clicker ist mehr als einmal registriert',

   'Unregistered Clicker'
=> 'Nicht registrierter Clicker',

   'Found [_1] registered and [_2] unregistered clickers.'
=> '[_1] registrierte und [_2] nicht registrierte Clicker gefunden.',

   'Found no correct answers for grading!'
=> 'Keine korrekten Antworten zur Bewertung gefunden!',

   'Found [_1] entries for grading!'
=> '[_1] Einträge zur Bewertung gefunden!',

   'Found no questions.'
=> 'Keine Fragen gefunden.',

   'Finalize Grading'
=> 'Bewertung abschließen',

   'Question [_1]'
=> 'Frage [_1]',

   'More than one correct result given for question "[_1]": [_2] versus [_3].'
=> 'Mehr als eine korrektes Ergebnis gegeben für Frage "[_1]": [_2] gegen [_3].',

   'No correct result given for question "[_1]"!'
=> 'Kein korrektes Ergebnis für Frage "[_1]" gegeben!',

   'Correct answer: [_1]'
=> 'Korrekte Antwort: [_1]',

   'Successfully stored grades for [quant,_1,student].'
=> 'Erfolgreiche Speicherung der Bewertungen für [quant,_1,Studenten/in,Studierende].',

   'Grading Menu'
=> 'Bewertungsmenü',

   'Missing tags, unable to properly run file.'
=> 'Fehlende Tags. Die Datei kann nicht ordnungsgemäß ausgeführt werden.',

   'Using tag [_1] on line [_2] as end tag to [_3]'
=> 'Das Tag [_1] in Zeile [_2] wird als Ende-Tag für [_3] verwendet.',

   'Found tag [_1] on line [_2] when looking for [_3] in file.'
=> 'In der Datei wurde in Zeile [_2] das Tag [_1] gefunden, wo [_3] erwartet wurde.',

   'ID [_1] contains invalid characters. IDs are only allowed to contain letters, numbers, spaces and -'
=> 'ID [_1] enthält ungültige Zeichen. Gültige Zeichen für IDs sind nur Buchstaben, Ziffern, Leerzeichen und -',

   'File not found: [_1]'
=> 'Datei nicht gefunden: [_1]',

   'This file appears to be a rendering of a LON-CAPA resource. If this is correct, this resource will act very oddly and incorrectly.'
=> 'Diese Datei scheint eine Umwandlung einer LON-CAPA-Ressource zu sein. Falls dies zutrifft, wird sich diese Ressource sehr unpassend und inkorrekt verhalten.', # ??? [SB 2007-11-27]

   'An error occurred while processing this resource. The instructor has been notified.'
=> 'Während der Verarbeitung dieser Ressource ist ein Fehler aufgetreten. Der Dozent wurde informiert.',

   'CourseID'
=> 'Kurs-ID',

   'DocID'
=> 'Dokumenten-ID',

   'Username, password and domain need to be specified.'
=> 'Benutzerkennung, Passwort und Domäne müssen angegeben werden!',

   'Untitled Resource'
=> 'Unbenannte Ressource',

   'Not Available'
=> 'Nicht verfügbar',

   'Clear'
=> 'Leeren',

   'There are no parameters.'
=> 'Derzeit existieren keine Parametereinstellungen.',

   'enroll type/action'
=> 'Kursbelegungstyp/-aktion',

   'Map not loaded: The file [_1] does not exist.'
=> 'Inhaltszusammenstellung nicht geladen: Die Datei [_1] existiert nicht.',

   'Saved'
=> 'gespeichert',

   'An error occurred while saving.'
=> 'Beim Speichern ist ein Fehler aufgetreten.',

   'Reverted'
=> 'zurückgesetzt',

   'Title in map'
=> 'Titel in Inhaltszusammenstellung',

   'Filename of resource'
=> 'Dateiname der Ressource',

   'Link to published resource'
=> 'Link zur veröffentlichten Ressource',

   'Link to resource in Authoring Space'
=> 'Link zur Ressource im Autorenbereich',

   'Resource space'
=> 'Ressourcenbereich',

   'No such directory: [_1]'
=> 'Verzeichnis existiert nicht: [_1]',

   'discard'
=> 'verwerfen',

   'Discard'
=> 'verwerfen',

   'Change Order'
=> 'Reihenfolge ändern',

   'Sort Imported Resources'
=> 'Importierte Ressourcen sortieren',

   'Finalize order of resources'
=> 'Reihenfolge der Ressourcen festlegen',

   'Recover Deleted'
=> 'Gelöschtes wiederherstellen',

   'Recover deleted'
=> 'Gelöschtes wiederherstellen',

   'Recover Removed Resources'
=> 'Gelöschte Ressourcen wiederherstellen',

   'Recover Checked'
=> 'Auswahl wiederherstellen',

   'Import Resources from Bookmarks'
=> 'Ressourcen aus Lesezeichen importieren',

   'There are no resources to recover.'
=> 'Es gibt keine Ressourcen, die wiederhergestellt werden können.',

   'There are no resources to import.'
=> 'Es gibt keine Ressourcen, die importiert werden können.',

   'There are no resources in your bookmarks to import.'
=> 'Es gibt keine Ressourcen in Ihren Lesezeichen, die importiert werden können.',

   'Import Checked'
=> 'Auswahl importieren',

   'Recent Detailed Assessment Statistical Data'
=> 'Aktuelle detaillierte statistische Beurteilungsdaten',

   'No information available'
=> 'Keine Information verfügbar',

   'Creating new file [_1]'
=> 'Erstelle neue Datei [_1]',

   'If you would like to associate this resource ([_1]) with a current or previous course, please select one from the list below, otherwise select, "None".'
=> 'Falls Sie diese Ressource ([_1]) mit einem aktuellen oder alten Kurs verknüpfen wollen, wählen Sie bitte einen Kurs aus der unten angebotenen Liste. Ansonsten wählen Sie "nichts".',

   'Associate Resource With Selected Course'
=> 'Verknüpfe Ressource mit ausgewähltem Kurs',

   'This resource is currently associated with a course ([_1]) which includes added metadata fields specific to the course.'
=> 'Diese Ressource ist derzeit mit einem Kurs ([_1]) verknüpft, der zusätzliche kursspezifische Metadaten-Felder enthält.',

   'You can choose to transfer data from the added fields to the "Notes" field if you are planning to change the course association.'
=> 'Sie können die Daten der zusätzlichen Felder in das "Bemerkungen"-Feld transferieren lassen, falls Sie vorhaben, die Kursverknüpfung zu ändern.',

   'not available'
=> 'nicht verfügbar',

   'most recent version'
=> 'neueste Version',

   'information not available'
=> 'Information nicht verfügbar',

   'Num Student'
=> 'Anz. Student/in',

   'Num Students'
=> 'Anz. Studierende',

   'Degree of Difficulty'
=> 'Schwierigkeitsgrad',

   'DoDisc'
=> 'Grad d. Abgr.',

   'Degree of Discrimination'
=> 'Grad der Abgrenzung',

   'Degree of Discrimination and Degree of Difficulty'
=> 'Grad der Abgrenzung und Schwierigkeitsgrad',

   'Degree of Discrimination[_1]and Degree of Difficulty'
=> 'Grad der Abgrenzung[_1]und Schwierigkeitsgrad',

   'Degree of Discrimination and Degree of Difficulty Plot'
=> 'Grad-der-Abgrenzung- und Schwierigkeitsgrad-Plot',

   'Problem Number'
=> 'Nummer der Aufgabe',

   'Time of computation'
=> 'Zeitpunkt der Berechnung',

   'Messages deleted.'
=> 'Nachrichten gelöscht.',

   'Error deleting messages'
=> 'Fehler beim Löschen der Nachrichten',

   'Messages cleared.'
=> 'Nachrichten entfernt.',

   'Error clearing messages'
=> 'Fehler beim Entfernen der Nachrichten',

   'Delete Messages for this Resource'
=> 'Nachrichten für diese Ressource löschen',

   'Back To Directory'
=> 'Zurück zum Verzeichnis',

   'Associated with course [_1]'
=> 'Verknüpft mit Kurs [_1]',

   'This resource is not associated with a course.'
=> 'Diese Ressource ist mit keinem Kurs verknüpft.',

   'Discard Edits and Return to Portfolio'
=> 'Änderungen verwerfen und zurück zum Portfolio',

   'Could not transfer data in added fields to notes'
=> 'Die Daten der zusätzlichen Felder konnten nicht in das "Bemerkungen"-Feld transferiert werden',

   'Transferred data in added fields to notes'
=> 'Die Daten der zusätzlichen Felder wurden in das "Bemerkungen"-Feld transferiert',

   'Home'
=> 'Heimatverzeichnis',

   'Usage Statistics'
=> 'Nutzungsstatistiken',

   'Courses/Network Hits'
=> 'Kursweite/Netzwerkweite Anzahl an Zugriffen ("Hits")',

   'Already in this course:'
=> 'Bereits in diesem Kurs:',

   '[_1] in folder/map [_2]'
=> '[_1] im Verzeichnis / in der Inhaltszusammenstellung [_2]',

   'External Resource, preview not enabled'
=> 'Externe Ressource, Vorschau nicht aktiviert',

   'Somewhere something went wrong'
=> 'Irgendwo ist irgendwas schief gelaufen',

   'Please help us to find out what.'
=> 'Bitte helfen Sie uns herauszufinden, was passiert ist!',

   'Please take a moment to fill out the form below.'
=> 'Bitte nehmen Sie sich einen Moment Zeit, um das folgende Formular auszufüllen.',

   'Your information, together with internal debugging information, will be e-mailed to the system and server administrators.'
=> 'Ihre Informationen, zusammen mit internen Debugging-Daten, werden an die System- und Server-Administratoren per E-Mail weitergeleitet.',

   'Send Information'
=> 'Fehlerbericht abschicken',

   'Please describe what you did just before this screen came up'
=> 'Bitte erläutern Sie, was Sie getan haben, unmittelbar bevor dieser Bildschirm erschien.',

   'Is this problem reproducible?'
=> 'Ist das Problem reproduzierbar?',

   'Yes!'
=> 'Ja!',

   'Do you have any guesses why this might have happened?'
=> 'Haben Sie eine Vermutung, warum das passiert sein könnte?',

   'Thank you for your help!'
=> 'Vielen Dank für Ihre Unterstützung!',

   'Internal info:'
=> 'Interne Daten:',

   'Report submitted'
=> 'Bericht gesendet',

   'Sending Error Report'
=> 'Fehlerbericht senden',

   'Thank you!'
=> 'Danke!',

   'Warning: Report not submitted'
=> 'Achtung, der Fehlerbericht wurde nicht abgeschickt.',

   'The administrators of the domain [_1] have not set any e-mail addresses for receipt of your error report.'
=> 'Die Administratoren der Domäne [_1] haben keine E-Mail-Adresse hinterlegt, an die Ihr Fehlerbericht gesendet werden könnte.',

   'The document contains errors and cannot be published.'
=> 'Die Ressource enthält Fehler und kann daher nicht veröffentlicht werden.',

   'error(s)'
=> 'Fehler',

   '[quant,_1,error]'
=> '[quant,_1,Fehler,Fehler]',

   'Please fill out all required fields below!'
=> 'Bitte füllen Sie alle Pflichtfelder aus!',

   'Caution: this folder is set to randomly pick a subset of resources. Adding or removing resources from this folder will change the set of resources that the students see, resulting in spurious or missing credit for completed problems, not limited to ones you modify. Do not modify the contents of this folder if it is in active student use.'
=> 'Achtung, dieses Verzeichnis ist so eingestellt, dass zufällig eine Teilmenge der Ressourcen gewählt wird. Hinzufügen oder Entfernen von Ressourcen zu/aus diesem Verzeichnis wird die Auswahl ändern, die die Studierenden sehen. Dies kann eine falsche oder fehlende Punktevergabe für abgeschlossene Aufgaben zur Folge haben, was nicht beschränkt auf die Ressourcen ist, die Sie ändern. Ändern Sie daher die Inhalte dieses Verzeichnisses nicht, wenn es in aktueller studentischer Verwendung ist.',

   'Caution: this folder is set to randomly order its contents. Adding or removing resources from this folder will change the order of resources shown.'
=> 'Achtung, dieses Verzeichnis ist so eingestellt, dass der Inhalt in zufälliger Reihenfolge angezeigt wird. Hinzufügen oder Entfernen von Ressourcen zu/aus diesem Verzeichnis wird die Reihenfolge ändern, in der die Ressourcen gezeigt werden.',

   'Parameters'
=> 'Parameter',

   'Parameters:'
=> 'Parameter:',

   'Total Score and Maximum Possible for each Sequence or Folder'
=> 'Gesamtanzahl an Punkten und maximal erreichbare für jede Sequenz oder jedes Verzeichnis',

   'Score on each Problem Part'
=> 'Punkte je Aufgabenteil',

   'Number of Tries before success on each Problem Part'
=> 'Anzahl notwendiger Versuche je Aufgabenteil',

   'Number of Problem Parts completed successfully'
=> 'Anzahl erfolgreich bearbeiteter Aufgabenteile',

   'Unable to retrieve course information.'
=> 'Kursdaten konnten nicht abgerufen werden.',

   'Please select an action to perform using the new filename'
=> 'Bitte wählen Sie zuerst eine Aktion aus, was mit der neuen Datei geschehen soll!',

   'View or modify a course'
=> 'Kurs-Einstellungen', # long version: 'Kurs-Einstellungen betrachten oder ändern',

   'Enter the course with the role of [_1]'
=> 'Den Kurs mit der Rolle [_1] betreten.',

   'Enter the course with the role of [_1].'
=> 'Den Kurs mit der Rolle [_1] betreten.',

   'Enter the community with the role of [_1].'
=> 'Die Community mit der Rolle [_1] betreten.',

   'Enter the community with the role of [_1]'
=> 'Die Community mit der Rolle [_1] betreten',

   'View or modify course settings which only a [_1] may modify.'
=> 'Betrachten oder Ändern der Kurs-Einstellungen, die nur ein [_1] ändern darf.',

   'View or modify community settings which only a [_1] may modify.'
=> 'Betrachten oder Ändern der Community-Einstellungen, die nur ein [_1] ändern darf.',

   'Manage course users'
=> 'Kursteilnehmer verwalten',

   'Upload a File of Course Users'
=> 'Datei mit Kursteilnehmern hochladen',

   'Add/Modify a Course User'
=> 'Teilnehmer hinzufügen/ändern',

   'Edit Custom Roles'
=> 'Benutzerdefinierte Rollen',

   'Enroll a Single Student'
=> 'Einzelne/n Studenten/in Kurs belegen lassen',

   'Enroll a student'
=> 'Student/in Kurs belegen lassen',

   'Manage Course Groups'
=> 'Kursgruppen',

   'Manage course groups'
=> 'Kursgruppen',

   'This error occurred while processing response [_1] in part [_2]'
=> 'Dieser Fehler trat während der Verarbeitung von Antwortbereich [_1] in Aufgabenteil [_2] auf.',

   'This error occurred while processing part [_1]'
=> 'Dieser Fehler trat während der Verarbeitung von Aufgabenteil [_1] auf.',

   'Unable to find section for this student'
=> 'Konnte für diese/n Studenten/in keine Sektion finden.',

   'Classlist update for "[_1]" in "[_2]".'
=> 'Kursteilnehmerlisten-Aktualisierung für "[_1]" in "[_2]".',

   'Error: "[_1]" during classlist update for "[_2]" in "[_3]".'
=> 'Fehler: "[_1]" während Kursteilnehmerlisten-Aktualisierung für "[_2]" in "[_3]".',

   'Role: '
=> 'Rolle: ',

   'Identify fields in uploaded list'
=> 'Zuweisung der Felder in der hochgeladenen Liste',

   'Default domain'
=> 'Voreingestellte Domäne',

   'Change authentication for existing users in domain "[_1]" to these settings?'
=> 'Soll die Authentifizierungsmethode für existierende Benutzer der Domäne "[_1]" geändert werden?',

   'LON-CAPA Home Server for New Users'
=> 'LON-CAPA-Heimatserver für neue Benutzer',

   'LON-CAPA domain: [_1] with home server:'
=> 'LON-CAPA-Domäne [_1] mit Heimatserver:',

   'Settings for assigning roles'
=> 'Einstellungen für Rollenzuweisungen',

   'Pick the action to take on roles for these users:'
=> 'Wählen Sie die Aktion aus, die bei neuen Rollen für diesen Benutzer ausgeführt werden soll:',

   'No role changes'
=> 'Keine Rollenänderungen',

   'Add a domain role'
=> 'Eine Domänenrolle hinzufügen',

   'Add a course role'
=> 'Eine Kursrolle hinzufügen',

   'Add a course/community role'
=> 'Eine Kurs-/Community-Rolle hinzufügen',

   'Default role'
=> 'Voreingestellte Rolle',

   'Choose the role to assign to users without a value specified in the uploaded file.'
=> 'Wählen Sie die Rolle, die Benutzern zugewiesen werden sollen, für die kein Wert in der hochgeladenen Datei angegeben ist.',

   'Default role and section'
=> 'Voreingestellte Rolle und Sektion',

   'Choose the role and/or section(s) to assign to users without values specified in the uploaded file.'
=> 'Wählen Sie die Rolle und/oder Sektion(en), die Benutzern zugewiesen werden sollen, für die keine Werte in der hochgeladenen Datei angegeben wurden.',

   'Default role and/or section(s)'
=> 'Voreingestellte Rolle und/oder Sektion(en)',

   'Role and/or section(s) for users without values specified in the uploaded file.'
=> 'Rolle und/oder Sektion(en) für Benutzer, für die keine Werte in der hochgeladenen Datei angegeben wurde',

   'Display students with current/future access who are not in the uploaded file.'
=> 'Anzeige von Studierenden mit aktuellem/zukünftigem Zugriff, die nicht in der hochgeladenen Datei sind.',

   'Display students with current/future access who are not in the uploaded file'
=> 'Anzeige von Studierenden mit aktuellem/zukünftigem Zugriff, die nicht in der hochgeladenen Datei sind',

   'Students selected from this list can be dropped.'
=> 'Studierende können von dieser Liste gewählt und aus dem Kurs ausgeschlossen werden.',

   'Members selected from this list can be dropped.'
=> 'Mitglieder können von dieser Liste gewählt und aus dem Kurs ausgeschlossen werden.',

   "Update ID in user's course(s)." # 'Update student/employee ID in courses in which user is active/future student,[_1](if forcing change).'
=> 'ID in Kurs(en) des Benutzers aktualisieren', # 'Aktualisierung der Studierenden-/Mitarbeiter-ID in Kursen, in denen der Benutzer aktueller/zukünftige/r Student/in ist[_1](falls Änderung erzwungen wird)',

   'make these dates the default access dates for future student enrollment'
=> 'Diese Datumswerte als voreingestellte Zugriffszeiten für zukünftige studentische Kursbelegungen verwenden',

   'Set default start and end access dates for course.'
=> 'Setze voreingestellte Anfangs- und Endzugriffszeiten für Kurs',

   'Set default start and end access dates for community.'
=> 'Setze voreingestellte Anfangs- und Endzugriffszeiten für Community',

   'Unable to set default access dates for course.'
=> 'Konnte nicht die voreingestellten Zugriffszeiten für den Kurs setzen',

   'Unable to set default access dates for course'
=> 'Konnte nicht die voreingestellten Zugriffszeiten für den Kurs setzen',

   'Unable to set default access dates for community'
=> 'Konnte nicht die voreingestellten Zugriffszeiten für die Community setzen',

   'Please select'
=> 'Bitte wählen',

   'User Status: [_1]'
=> 'Benutzerstatus: [_1]',

   'Role Type: [_1]'
=> 'Art der Rolle: [_1]',

   'Any role'
=> 'Beliebige Rolle',

   'Role: [_1]'
=> 'Rolle: [_1]',

   'Select Course(s)'
=> 'Kurs(e) auswählen',

   'Warning: data retrieval for multiple courses can take considerable time, as this operation is not currently optimized.'
=> 'Achtung: Das Abrufen von Daten für mehrere Kurse kann einige Zeit in Anspruch nehmen, da diese Aktion derzeit noch nicht optimiert ist.',

   'Warning: data retrieval for multiple communities can take considerable time, as this operation is not currently optimized.'
=> 'Achtung: Das Abrufen von Daten für mehrere Communitys kann einige Zeit in Anspruch nehmen, da diese Aktion derzeit noch nicht optimiert ist.',

   'There are no co-authors to display.'
=> 'Es gibt keine Co-Autoren, die angezeigt werden können.',

   'There are no users with domain roles to display.'
=> 'Es gibt keine Benutzer mit Domänenrollen, die angezeigt werden können.',

   'There are no authors or co-authors to display.'
=> 'Es gibt keine Autoren oder Co-Autoren, die angezeigt werden können.',

   'There are no course users to display'
=> 'Es gibt keine Kursteilnehmer, die angezeigt werden können.',

   'There are no community users to display'
=> 'Es gibt keine Community-Teilnehmer, die angezeigt werden können.',

   'There are no course users to display.'
=> 'Es gibt keine Kursteilnehmer, die angezeigt werden können.',

   'There are no users matching the search criteria.'
=> 'Es gibt keine Benutzer, auf die die Suchkriterien zutreffen.',

   "You must select at least one user by checking a user's 'Select' checkbox"
=> "Sie müssen mindestens einen Benutzer auswählen, indem Sie die Checkboxen in der Spalte 'Auswählen' anklicken.",

   'You need to select an action to take for the user(s) you have selected'
=> 'Sie müssen eine Aktion auswählen, die für die ausgewählten Benutzer ausgeführt soll.',

   ' for a single user?'
=> '? (betrifft einen einzelnen Benutzer)',

   ' for multiple users?'
=> '? (betrifft mehrere Benutzer)',

   'Proceed'
=> 'Weiter',

   'Action to take for selected users'
=> 'Aktion für ausgewählte Benutzer',

   'Behavior of clickable username link for each user'
=> 'Verhalten der Benutzerkennung-Links', # long version: 'Verhalten der anklickbaren Benutzerkennung-Links eines jeden Benutzers',

   "Display a user's personal information page"
=> "Persönliche Seite anzeigen",

   "Modify a user's information"
=> "Benutzerdaten ändern",

   'Course(s): description, section(s), status'
=> 'Kurs(e): Beschreibung, Sektion(en), Status',

   'course(s): description, section(s), status'
=> 'Kurs(e): Beschreibung, Sektion(en), Status',

   "Click on a username to view the user's personal information page."
=> "Klicken Sie auf eine Benutzerkennung, um die persönliche Seite anzuschauen.",

   'auto'
=> 'automatisch',

   'manual'
=> 'manuell',

   'Unlock'
=> 'Entsperren',

   'Lock'
=> 'Sperren',

   'Domain Roles'
=> 'Domänen-Rollen',

   'Co-Author Roles'
=> 'Co-Autoren-Rollen',

   'Course Roles'
=> 'Kursrollen',

   'Community roles'
=> 'Community-Rollen',

   'Community Roles'
=> 'Community-Rollen',

   'Date and Section selector'
=> 'Datums- und Sektions-Selektor',

   'Date selector'
=> 'Datums-Selektor',

   "Check the boxes for any users for whom roles are to be revoked, and click 'Proceed'"
=> "Wählen Sie all die Benutzer, für die Rollen entzogen werden sollen und klicken Sie dann auf 'Weiter'",

   "Check the boxes for any users for whom roles are to be deleted, and click 'Proceed'"
=> "Wählen Sie all die Benutzer, für die Rollen gelöscht werden sollen und klicken Sie dann auf 'Weiter'",

   'Choose an action to take for selected users'
=> 'Wählen Sie eine Aktion, die mit den ausgewählten Benutzern ausgeführt werden soll',

   'New section to assign'
=> 'Neue Sektion, die zugewiesen werden soll',

   'Use "Save" to update the main window with your selections.'
=> "Verwenden Sie 'Speichern', um im Hauptfenster Ihre Auswahl zu aktualisieren.",

   'New section'
=> 'Neue Sektion',

   'Course - [_1]:'
=> 'Kurs - [_1]:',

   'Community - [_1]:'
=> 'Community - [_1]:',

   'Domain - [_1]:'
=> 'Domäne - [_1]:',

   'Users in course with expired [_1] roles'
=> 'Benutzer im Kurs mit abgelaufener Rolle "[_1]"',

   'Users in community with expired [_1] roles'
=> 'Benutzer in der Community mit abgelaufener Rolle "[_1]"',

   'Users in course with future [_1] roles'
=> 'Benutzer im Kurs mit zukünftiger Rolle "[_1]"',

   'Users in community with future [_1] roles'
=> 'Benutzer in der Community mit zukünftiger Rolle "[_1]"',

   'Users in course with active [_1] roles'
=> 'Benutzer im Kurs mit aktiver Rolle "[_1]"',

   'Users in community with active [_1] roles'
=> 'Benutzer in der Community mit aktiver Rolle "[_1]"',

   'All users in course'
=> 'Alle Benutzer im Kurs',

   'All users in community'
=> 'Alle Benutzer in der Community',

   'All users in course with [_1] roles'
=> 'Alle Benutzer im Kurs mit Rolle "[_1]"',

   'All users in community with [_1] roles'
=> 'Alle Benutzer in der Community mit Rolle "[_1]"',

   'only users in section "[_1]"'
=> 'nur Benutzer in Sektion "[_1]"',

   'only users affiliated with no section or section "[_1]"'
=> 'nur Benutzer, die in keiner Sektion oder in der Sektion "[_1]" sind',

   ' and not in any group'
=> ' und in keiner Gruppe',

   ' and members of group: "[_1]"'
=> ' und Mitglieder der Gruppe "[_1]"',

   'only users affiliated with no section'
=> 'nur Benutzer, die in keiner Sektion sind',

   'only users affiliated with section "[_1]"'
=> 'nur Benutzer, die in der Sektion "[_1]" sind',

   'only users not in any group'
=> 'nur Benutzer, die in keiner Gruppe sind',

   ' and also not in any group'
=> ' und auch nicht in einer Gruppe sind',

   'only members of group: "[_1]"'
=> 'nur Mitglieder der Gruppe "[_1]"',

   ' and also members of group: "[_1]"'
=> ' und auch Mitglieder der Gruppe "[_1] sind',

   'Author space for [_1]'
=> 'Autorenbereich für [_1]',

   'Co-authors with expired [_1] roles'
=> 'Co-Autoren mit abgelaufener Rolle "[_1]"',

   'Co-authors with future [_1] roles'
=> 'Co-Autoren mit zukünftiger Rolle "[_1]"',

   'Co-authors with active [_1] roles'
=> 'Co-Autoren mit aktiver Rolle "[_1]"',

   'All co-authors'
=> 'Alle Co-Autoren',

   'All co-authors with [_1] roles'
=> 'Alle Co-Autoren mit Rolle "[_1]"',

   'Users in domain with expired [_1] roles'
=> 'Benutzer in Domäne mit abgelaufener Rolle "[_1]"',

   'Users in domain with future [_1] roles'
=> 'Benutzer in Domäne mit zukünftiger Rolle "[_1]"',

   'Users in domain with active [_1] roles'
=> 'Benutzer in Domäne mit aktiver Rolle "[_1]"',

   'All users in domain'
=> 'Alle Benutzer in der Domäne',

   'All users in domain with [_1] roles'
=> 'Alle Benutzer in der Domäne mit der Rolle "[_1]"',

   'Co-authors in domain with expired [_1] roles'
=> 'Co-Autoren in der Domäne mit abgelaufener Rolle "[_1]"',

   'Co-authors in domain with future [_1] roles'
=> 'Co-Autoren in der Domäne mit zukünftiger Rolle "[_1]"',

   'Co-authors in domain with active [_1] roles'
=> 'Co-Autoren in der Domäne mit aktiver Rolle "[_1]"',

   'All users with co-author roles in domain'
=> 'Alle Benutzer mit Co-Autoren-Rolle in der Domäne',

   'All co-authors in domain with [_1] roles'
=> 'Alle Co-Autoren in der Domäne mit Rolle "[_1]"',

   'Courses in domain with institutional code: [_1]'
=> 'Kurse in der Domäne mit institutionellem Code "[_1]"',

   'Selected courses in domain'
=> 'Ausgewählte Kurse in der Domäne',

   'Selected communities in domain'
=> 'Ausgewählte Communitys in der Domäne',

   'All courses in domain'
=> 'Alle Kurse in der Domäne',

   'All communities in domain'
=> 'Alle Communitys in der Domäne',

   'users with expired [_1] roles'
=> 'Benutzer mit abgelaufener Rolle "[_1]"',

   'users with future [_1] roles'
=> 'Benutzer mit zukünftiger Rolle "[_1]"',

   'users with active [_1] roles'
=> 'Benutzer mit aktiver Rolle "[_1]"',

   'all users'
=> 'alle Benutzer',

   'All users'
=> 'Alle Benutzer',

   'users with [_1] roles'
=> 'Benutzer mit Rolle "[_1]"',

   'There are no students to drop.'
=> 'Es gibt keine Studierenden, die ausgeschlossen werden könnten.',

   'There are no members to drop.'
=> 'Es gibt keine Mitglieder, die ausgeschlossen werden könnten.',

   'Upload a file containing information about users'
=> 'Hochladen einer Datei mit Benutzerinformationen',

   'Please upload an UTF8 encoded file to ensure a correct character encoding in your classlist.'
=> 'Bitte laden Sie eine UTF8-codierte Datei hoch, um in der Kursteilnehmerliste eine korrekte Zeichencodierung sicherzustellen.',

   'Upload file of users'
=> 'Hochladen einer Datei mit Benutzern',

   'How do I create a users list from a spreadsheet'
=> 'Wie erstelle ich aus einer Excel-Datei eine Benutzerliste',

   'How do I create a class list from a spreadsheet'
=> 'Wie erstelle ich aus einer Excel-Datei eine Kursteilnehmerliste',

   'Unable to enroll users'
=> 'Konnte Benutzer nicht den Kurs belegen lassen!',

   'Enrolling Users'
=> 'Benutzer werden in den Kurs aufgenommen',

   'Updating Co-authors'
=> 'Aktualisiere Co-Autoren',

   'Adding/Modifying Users'
=> 'Benutzer werden hinzugefügt/geändert',

   'Default section name [_1] could not be used as it is a reserved word.'
=> 'Der voreingestellte Sektionsname "[_1]" ist nicht zulässig, da es sich um ein intern reserviertes Wort handelt.',

   'Default section name "[_1]" is the name of a course group. Section names and group names must be distinct.'
=> 'Der voreingestellte Sektionsname "[_1]" ist eine Name einer Kursgruppe. Sektionsnamen und Gruppennamen müssen sich jedoch unterscheiden.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a reserved word.'
=> '[_1]: Kursbelegung für Benutzer [_2] [_3] [_4] [_5] in der Sektion "[_6]" nicht möglich - es handelt sich um ein intern reserviertes Wort.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a course group.'
=> '[_1]: Kursbelegung für Benutzer [_2] [_3] [_4] [_5] in der Sektion "[_6]" nicht möglich - es handelt sich um eine Kursgruppe.',

   'Section names and group names must be distinct.'
=> 'Sektionsnamen und Gruppennamen müssen sich unterscheiden.',

   'Section names and group names must be distinct'
=> 'Sektionsnamen und Gruppennamen müssen sich unterscheiden',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]".'
=> '[_1]: Kursbelegung für Benutzer [_2] [_3] [_4] [_5] in der Sektion "[_6]" nicht möglich.',

   'This user already has an active/future student role in the course, unaffiliated to any section.'
=> 'Dieser Benutzer hat bereits eine aktive oder zukünftige Rolle in diesem Kurs, die nicht mit einer Sektion verbunden ist.',

   'This user already has an active/future role in section "[_1]" of the course.'
=> 'Dieser Benutzer hat in dem Kurs bereits eine aktive oder zukünftige Rolle in der Sektion "[_1]".',

   'Although your current role has privileges to add students to section "[_1]", you do not have privileges to modify existing enrollments in other sections.'
=> 'Auch wenn Ihre derzeitige Rolle das Hinzufügen von Studierenden in die Sektion "[_1]" zulässt, haben Sie nicht die Berechtigung, bestehende Kursbelegungen in anderen Sektionen zu ändern.',

   '[_1]: You do not have permission to add the requested role [_2] for the user.'
=> '[_1]: Sie haben nicht die Berechtigung, dem Benutzer die gewünschte Rolle "[_2]" zuzuweisen.',

   'Allowable role(s) is/are: [_1].'
=> 'Zulässige Rollen: [_1]',

   '[_1]: Unable to enroll. No password specified.'
=> '[_1]: Kursbelegung nicht möglich. Kein Passwort angegeben!',

   '[_1]: Unable to add co-author. No password specified.'
=> '[_1]: Hinzufügen des Co-Autors nicht möglich. Kein Passwort angegeben!',

   '[_1]: Unable to add user. No password specified.'
=> '[_1]: Hinzufügen des Benutzers nicht möglich. Kein Passwort angegeben!',

   'Processed [quant,_1,user].'
=> '[quant,_1,Benutzer,Benutzer] verarbeitet.',

   'Roles added for [quant,_1,user].'
=> 'Rollen für [quant,_1,Benutzer,Benutzer] hinzugefügt.',

   'If a user is currently logged-in to LON-CAPA, any new roles which are active will be available when the user next logs in.'
=> 'Beim nächsten Anmelden des Benutzers werden alle neuen aktiven Rollen verfügbar sein.',

   'No roles added'
=> 'Keine Rollen hinzugefügt',

   'Authentication changed for [_1] existing users.'
=> 'Die Authentifizierungsmethode hat sich für [_1] existente(n) Benutzer geändert.',

   'Students to Drop'
=> 'Auszuschließende Studierende',

   'There are no students with current/future access to the course.'
=> 'Es existieren keine Studierenden mit aktuellem oder zukünftigem Zugriff auf den Kurs.',

   '[_1]: Unable to add/modify: [_2]'
=> '[_1]: Hinzufügen/Ändern nicht möglich: [_2]',

   '[_1]: Unable to modify authentication: [_2]'
=> '[_1]: Ändern der Authentifizierungsmethode nicht möglich: [_2]',

   '[_1]: Unable to add role: [_2]'
=> '[_1]: Hinzufügen der Rolle nicht möglich: [_2]',

   'No change in section assignment (none)'
=> 'Keine Änderung in Sektionsbelegung (nichts)',

   "Revoked role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' entzogen in [_2] für [_3]",

   "Deleted role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' gelöscht in [_2] für [_3]",

   "Re-enabled role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' reaktiviert in [_2] für [_3]",

   "Activated role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' aktiviert in [_2] für [_3]",

   "Changed Access Dates for role of '[_1]' in [_2] for [_3]"
=> "Geänderte Zugriffszeiten für Rolle '[_1]' in [_2] für [_3]",

   "Changed Access Dates for role of '[_1]' in [_2] for '[_3]' - [_4]"
=> "Geänderte Zugriffszeiten für Rolle '[_1]' in [_2] für [_3] - [_4]",

   "Changed section(s) for role of '[_1]' in [_2] for '[_3]' to [_4] - [_5]"
=> "Geänderte Sektion(en) für Rolle '[_1]' in [_2] für '[_3]' in [_4] - [_5]",

   "Changed section for role of '[_1]' in [_2] for [_3]"
=> "Geänderte Sektion für Rolle '[_1]' in [_2] für [_3]",

   "Dropped role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' entzogen in [_2] für [_3]",

   "Activated role of '[_1]' in [_2] for '[_3]'."
=> "Rolle '[_1]' in [_2] für '[_3]' aktiviert.",

   "Deleted role of '[_1]' in [_2] for '[_3]'."
=> "Rolle '[_1]' in [_2] für '[_3]' gelöscht.",

   "Dropped role of '[_1]' in [_2] for '[_3]'."
=> "Rolle '[_1]' in [_2] für '[_3]' entzogen.",

   "Re-enabled role of '[_1]' in [_2] for '[_3]'."
=> "Rolle '[_1]' in [_2] für '[_3]' reaktiviert.",

   "Revoked role of '[_1]' in [_2] for '[_3]'."
=> "Rolle '[_1]' in [_2] für '[_3]' entzogen.",

   'Error revoking [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Entziehen von [_1] in [_2] für [_3]: [_4].',

   'Error deleting [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Löschen von [_1] in [_2] für [_3]: [_4].',

   'Error re-enabling [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Reaktivieren von [_1] in [_2] für [_3]: [_4].',

   'Error activating [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Aktivieren für [_1] in [_2] für [_3]: [_4].',

   'Error changing access dates for [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Ändern der Zugriffszeiten für [_1] in [_2] für [_3]: [_4].',

   'Error changing section for [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Ändern der Sektion für [_1] in [_2] für [_3]: [_4].',

   'Error dropping [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Entziehen für [_1] in [_2] für [_3]: [_4].',

   "Error activating [_1] in [_2] for '[_3]': [_4]."
=> "Fehler beim Aktivieren von [_1] in [_2] für '[_3]': [_4].",

   "Error changing access dates for [_1] in [_2] for '[_3]': [_4]."
=> "Fehler beim Ändern der Zugriffszeiten für [_1] in [_2] für '[_3]': [_4].",

   "Error changing section for [_1] in [_2] for '[_3]': [_4]."
=> "Fehler beim Ändern der Sektion für [_1] in [_2] für '[_3]': [_4].",

   "Error deleting [_1] in [_2] for '[_3]': [_4]."
=> "Fehler beim Löschen von [_1] in [_2] für '[_3]': [_4].",

   "Error dropping [_1] in [_2] for '[_3]': [_4]."
=> "Fehler beim Entziehen von [_1] in [_2] für '[_3]': [_4].",

   "Error re-enabling [_1] in [_2] for '[_3]': [_4]."
=> "Fehler beim Reaktivieren von [_1] in [_2] für '[_3]': [_4].",

   "Error revoking [_1] in [_2] for '[_3]': [_4]."
=> "Fehler beim Entfernen von [_1] in [_2] für '[_3]': [_4].",

   'Revoked role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] entzogen.',

   'Deleted role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] gelöscht.',

   'Re-enabled role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] reaktiviert.',

   'Activated role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] aktiviert.',

   'Changed Access Dates for role(s) for [quant,_1,user,users,no users].'
=> 'Zugriffszeiten für Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] geändert.',

   'Changed Access Dates for [quant,_1,user role,user roles,no user roles].'
=> 'Zugriffszeiten für [quant,_1,Benutzerrolle,Benutzerrollen,keine Benutzerrolle] geändert.',

   'Changed section for role(s) for [quant,_1,user,users,no users].'
=> 'Sektionen für Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] geändert.',

   'Dropped role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] entzogen.',

   'Activated [quant,_1,user role,user roles,no user roles].'
=> '[quant,_1,Benutzerrolle,Benutzerrollen,keine Benutzerrollen] aktiviert',

   'Deleted [quant,_1,user role,user roles,no user roles].'
=> '[quant,_1,Benutzerrolle,Benutzerrollen,keine Benutzerrollen] gelöscht',

   'Dropped [quant,_1,user role,user roles,no user roles].'
=> '[quant,_1,Benutzerrolle,Benutzerrollen,keine Benutzerrollen] entzogen',

   'Re-enabled [quant,_1,user role,user roles,no user roles].'
=> '[quant,_1,Benutzerrolle,Benutzerrollen,keine Benutzerrollen] reaktiviert',

   'Revoked [quant,_1,user role,user roles,no user roles].'
=> '[quant,_1,Benutzerrolle,Benutzerrollen,keine Benutzerrollen] entzogen',

   "Activated role of '[_1]' in [_2] for '[_3]' - [_4]"
=> "Rolle '[_1]' in [_2] für '[_3]' aktiviert - [_4]",

   "Deleted role of '[_1]' in [_2] for '[_3]' - [_4]"
=> "Rolle '[_1]' in [_2] für '[_3]' gelöscht - [_4]",

   "Dropped role of '[_1]' in [_2] for '[_3]' - [_4]"
=> "Rolle '[_1]' in [_2] für '[_3]' entzogen - [_4]",

   "Re-enabled role of '[_1]' in [_2] for '[_3]' - [_4]"
=> "Rolle '[_1]' in [_2] für '[_3]' reaktiviert - [_4]",

   "Revoked role of '[_1]' in [_2] for '[_3]' - [_4]"
=> "Rolle '[_1]' in [_2] für '[_3]' entzogen - [_4]",

   "Activated role of '[_1]' in [_2] for '[_3]' to [_4] - [_5]"
=> "Rolle '[_1]' in [_2] für '[_3]' in [_4] aktiviert - [_5]",

   "Deleted role of '[_1]' in [_2] for '[_3]' to [_4] - [_5]"
=> "Rolle '[_1]' in [_2] für '[_3]' in [_4] gelöscht - [_5]",

   "Dropped role of '[_1]' in [_2] for '[_3]' to [_4] - [_5]"
=> "Rolle '[_1]' in [_2] für '[_3]' in [_4] entzogen - [_5]",

   "Re-enabled role of '[_1]' in [_2] for '[_3]' to [_4] - [_5]"
=> "Rolle '[_1]' in [_2] für '[_3]' in [_4] reaktiviert - [_5]",

   "Revoked role of '[_1]' in [_2] for '[_3]' to [_4] - [_5]"
=> "Rolle '[_1]' in [_2] für '[_3]' in [_4] entzogen - [_5]",

   'Re-enabling will re-activate data for the role.'
=> 'Reaktivierung wird die Daten der Rolle reaktivieren.',

   'Display User Lists'
=> 'Teilnehmerliste anzeigen',

   'Display current class roster'
=> 'Aktuelle Kursteilnehmerliste anzeigen',

   'No section'
=> 'Keine Sektion',

   'List Users'
=> 'Benutzer anzeigen',

   'Pick custom role'
=> 'Benutzerdefinierte Rolle auswählen',

   'Advanced Role'
=> 'Erweiterte Rolle',

   "Create User Notes, Display all User's Notes, Face-to-Face, Critical Messages, Broadcast Messages"
=> "Erstellen von Benutzeranmerkungen, Anzeige aller Benutzeranmerkungen, persönlicher Diskussionsbeiträge, wichtiger Nachrichten, Broadcast-Nachrichten",

   'Evade communication blocking'
=> 'Umgehen der Kommunikationssperre',

   'Generate anonymous statistics'
=> 'Anonyme Statistiken erstellen',

   'Modify grade queue'
=> 'Ändern der Bewertungs-Warteschlange',

   'Grade items in grading queue'
=> 'Bewerten von Elementen in der Bewertungs-Warteschlange',

   'Set assessment parameters'
=> 'Beurteilungs-Parameter setzen', # Ressourcenparameter setzen/ändern (???)

   'Advanced printing options (with answers, discussions, all foils, ...)'
=> 'Erweiterte Druckoptionen (mit Antworten, Diskussionen, allen Auswahlmöglichkeiten, ...)',

   'Print for other users and entire course'
=> 'Für andere Benutzer und für gesamten Kurs drucken',

   'Get identity behind anonymous postings'
=> 'Identität hinter anonymen Beiträgen erhalten können',

   'View grades'
=> 'Beurteilungen anzeigen',

   "Access to What's New Page"
=> "Zugriff auf Was-gibt's-Neues-Seite",

   'Upload Users List'
=> 'Datei mit Benutzern hochladen',

   'Update Users'
=> 'Benutzer aktualisieren',

   'Create/modify a user'
=> 'Einzelnen Benutzer hinzufügen/ändern',

   'Search for a user and modify/add user information or roles'
=> 'Suche nach einem Benutzer und ändern/hinzufügen von Benutzerdaten oder -rollen',

   'Add/modify a single user'
=> 'Einzelnen Benutzer hinzufügen/ändern',

   'Create users or modify the roles and privileges of users'
=> 'Benutzer, -rechte und -rollen erstellen/ändern',

   'Upload a File of Users'
=> 'Hochladen einer Datei mit Benutzern',

   'Add/Modify a User'
=> 'Benutzer hinzufügen/ändern',

   'create new user if required'
=> 'falls notwendig, neuen Benutzer erstellen',

   'Manage Users'
=> 'Benutzer verwalten',

   'Create/Modify user'
=> 'Benutzer erstellen/ändern',

   'Visible input'
=> 'Sichtbare Eingabe',

   'Currently in use'
=> 'Derzeit in Verwendung',

   'Modify this user: [_1]'
=> 'Weitere Änderungen für Benutzer [_1]',

   'radiobutton'
=> '1-aus-n-Auswahl (radiobutton)',

   'numerical'
=> 'numerisch',

   'formula'
=> 'Formel',

   'Blank Problem'
=> 'Leere Aufgabe',

   'Chemical Reaction Response'
=> 'Chemische Reaktion',

   'Chemical Reaction Response with Hints'
=> 'Chemische Reaktion mit Hinweisen',

   'Click-On-Image Problem'
=> 'Klick-ins-Bild',

   'Curve Plot with Numerical Response'
=> 'Dynamischer Graph mit numerischer Antwort',

   'Custom Response with Partial Credit'
=> 'Customresponse mit teilweiser Punktevergabe',

   'Custom Response'
=> 'Customresponse (Freie Programmierung)',

   'Data Plot with Numerical Response'
=> 'Datenplot mit numerischer Antwort',

   'Drop Box'
=> 'Dropbox',

   'Essay Response'
=> 'Essay',

   'Exam Upload Resource'
=> 'Prüfungs-Hochlade-Ressource',

   'Formula Response using Computer Algebra System'
=> 'Formel mit Computer-Algebra-System',

   'Formula Response using Computer Algebra System and Hints'
=> 'Formel mit Computer-Algebra-System und Hinweisen',

   'Formula Response using Computer Algebra System R and Data Plot'
=> 'Formel mit Computer-Algebra-System R und Datenplot',

   'Formula Response with Samples'
=> 'Formel mit Abtastpunkten',

   'Unordered Multi-Answer Formula Response Problem'
=> 'Formel - mehrere Antworten, ungeordnet',

   'Math Response using Computer Algebra System MAXIMA'
=> 'Mathematische Antwort mit Computer-Algebra-System MAXIMA (mathresponse)',

   'Math Response using Computer Algebra System R'
=> 'Mathematische Antwort mit Computer-Algebra-System R (mathresponse)',

   'Math Response using Computer Algebra System and Hints'
=> 'Mathematische Antwort mit Computer-Algebra-System und Hinweisen (mathresponse)',

   'Numerical Response'
=> 'Numerisch',

   'One of Multiple Answers Numerical Problem'
=> 'Numerisch - eine aus mehreren Antworten',

   'Option Response - Matching'
=> 'Zuordnung mit Optionen (Option Response - Matching)',

   'Option Response - Matching (multilingual)'
=> 'Zuordnung mit Optionen (Option Response - Matching), mehrsprachig',

   'Option Response - Concept Groups'
=> 'Zuordnung mit Optionen - Konzeptgruppen (Option Response - Concept Groups)', # 'Optionsauswahl mit Konzeptgruppen',

   'Matching Response'
=> 'Zuordnung mit Optionen - indirekt (Matching Response)',

   'Option Response - True/False'
=> 'Zuordnung mit Optionen - wahr/falsch (Option Response - True/False)', # 'Optionen - wahr/falsch',

   'Organic Material Response'
=> 'Organisches Material',

   'Organic Material Response with Hint'
=> 'Organisches Material mit Hinweisen',

   'Radio Button Response'
=> '1-aus-n (radiobutton)',

   'Randomly Labelled Image with Option Response'
=> 'Dynamische Bildbeschriftung mit Optionsauswahl (Randomly Labelled Image)',

   'Rank Response'
=> 'Rangordnung (Rank Response)',

   'String Response'
=> 'Texteingabe (String Response)',

   'String Response with Pre-Processing'
=> 'Texteingabe (String Response) mit Vorverarbeitung',

   'External Response'
=> 'Extern bewertete Antwort',

   'Custom Response using Computer Algebra System and Hints'
=> 'Customresponse mit Computer-Algebra-System und Hinweisen',

   'Custom Response comparing Equations using Computer Algebra System'
=> 'Customresponse vergleicht Gleichungen mit Computer-Algebra-System',

   'Randomized Question Stem Radio Button Response'
=> 'Zufälliger Frage-Pool mit 1-aus-n (radiobutton)',

   'Using Learner Answer in Multipart Numerical Problem'
=> 'Verwendung eingegebener Antwort in mehrteiliger, numerischer Aufgabe',

   'Using Learner Formula in Graph with Formula Response'
=> 'Verwendung eingegebener Formel in Graph mit Formelantwort',

   'Using Learner Formula in Graph with Math Response'
=> 'Verwendung eingegebener Formel in Graph mit mathematischer Antwort (mathresponse)',

   'Functionplotresponse with Background Plot'
=> 'Funktionsplot-Antwort mit Hintergrund-Plot',

   'Functionplotresponse with Labels'
=> 'Funktionsplot-Antwort mit Beschriftungen',

   'Functionplotresponse with Vectors and Hints'
=> 'Funktionsplot-Antwort mit Vektoren und Hinweisen',

   'Functionplotresponse with two Splines and Hints'
=> 'Funktionsplot-Antwort mit zwei Splines und Hinweisen',

   'Numerical Response Multiple Answers unordered'
=> 'Numerisch - mehrere Antworten, ungeordnet',

   'Numerical Response with Custom Units'
=> 'Numerisch mit eigenen Einheiten',

   'Numerical Response with Pre-Processing'
=> 'Numerisch mit Vorverarbeitung',

   'Blank Library File'
=> 'Leere Bibliothek',

   'Basic Script Library'
=> 'Bibliothek mit Skript',

   'Display catalog of courses and communities'
=> 'Kurs-/Community-Übersicht', # long version: Kurs- und Community-Übersicht anzeigen

   'Manage co-authors'
=> 'Co-Autoren verwalten',

   'Upload a File of Co-authors'
=> 'Datei mit Co-Autoren hochladen',

   'Add/Modify a Co-author'
=> 'Co-Autor hinzufügen/ändern',

   'Manage Co-authors'
=> 'Co-Autoren verwalten',

   'No courses match the criteria you selected.'
=> 'Es existieren keine Kurse, die der getroffenen Auswahl entsprechen.',

   'No communities match the criteria you selected.'
=> 'Es existieren keine Communitys, die der getroffenen Auswahl entsprechen.',

   'Key authority ([_1]id:domain[_2]) if other than community'
=> 'Schlüsselmeister ([_1]id:domäne[_2]), falls anderer als der der Community',

   'Key authority ([_1]id:domain[_2]) if other than course'
=> 'Schlüsselmeister ([_1]id:domäne[_2]), falls anderer als der des Kurses',

   'New bridgetask file'
=> 'Neue "Bridgetask"-Datei',

   'Create problem'
=> 'Aufgabe erstellen',

   'Create library'
=> 'Bibliothek erstellen',

   'Create survey'
=> 'Umfrage erstellen',

   'Create task'
=> '"Bridgetask" erstellen',

   'Problem Testing'
=> 'Testen von Aufgaben',

   'Task Testing'
=> 'Testen von "Bridgetasks"',

   "Don't Show Incorrect/Correct Feedback"
=> "Korrekt/Inkorrekt-Hinweis nicht anzeigen",

   "Don't Show Any Feedback"
=> "Keinerlei Hinweis anzeigen",

   'Change View'
=> 'Anzeigeart wechseln',

   'Show Default View'
=> 'Standard-Anzeigeart',

   '[_1] for [_2] versions.'
=> '[_1] für [_2] Versionen.',

   'Set new screenname to '
=> 'Nickname für anonyme Beiträge gesetzt auf ',

   'Reset screenname.'
=> 'Nickname für anonyme Beiträge zurückgesetzt.',

   'Set new nickname to '
=> 'Nickname gesetzt auf ',

   'Reset nickname.'
=> 'Nickname zurückgesetzt.',

   'Reset '
=> ' zurückgesetzt',

   'Set message forwarding to '
=> 'Nachrichtenweiterleitung gesetzt auf ',

   "Set message forwarding to 'off'."
=> "Nachrichtenweiterleitung auf 'aus' gesetzt.",

   'Set non-critical message notification address(es) to '
=> 'Benachrichtigungsadresse(n) für nicht-wichtige Nachrichten gesetzt auf ',

   "Set non-critical message notification to 'off'."
=> "Benachrichtigung für nicht-wichtige Nachrichten auf 'aus' gesetzt.",

   'Set critical message notification address(es) to '
=> 'Benachrichtigungsadresse(n) für wichtige Nachrichten gesetzt auf ',

   "Set critical message notification to 'off'."
=> "Benachrichtigung für wichtige Nachrichten auf 'aus' gesetzt.",

   'Set address(es) to receive excerpts with html retained '
=> 'Adresse(n) zum Empfang von Nachrichtenauszügen mit Beibehaltung von HTML gesetzt auf ',

   'Set notification address to receive excerpts with html stripped.'
=> 'Adresse zum Empfang von Nachrichtenauszügen gesetzt auf ohne Beibehaltung von HTML.',

   'Set all notification addresses to receive excerpts with html stripped.'
=> 'Alle Beachrichtigungsadressen zum Empfang von Nachrichtenauszügen gesetzt auf ohne Beibehaltung von HTML.',

   'No such user: '
=> 'Dieser Benutzer existiert nicht: ',

   'Sorry, the URL you provided to complete the reset of your password was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid. Please submit a [_1]new request[_2] for a password reset, and follow the link to the new URL included in the e-mail that will be sent to you, to allow you to enter a new password.'
=> 'Die von Ihnen angegebene URL zum Beenden des Zurücksetzens Ihres Passworts ist ungültig. Entweder wurde der in der URL eingebundene Authentifizierungscode gelöscht oder die von Ihnen angegebene URL ist nicht gültig. Bitte schicken Sie eine [_1]neue Anfrage[_2] zum Zurücksetzen des Passworts und folgen dem Link der neuen URL, die in der Ihnen zugesandten E-Mail angegeben ist, damit Sie ein neues Passwort eingeben dürfen.',

   'Sorry, the URL you provided to complete creation of a new LON-CAPA account was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid.'
=> 'Die von Ihnen angegebene URL, um den Erstellungsvorgang eines neuen LON-CAPA-Accounts abzuschließen, ist ungültig. Entweder wurde der in der URL enthaltene Authentifizierungscode gelöscht oder die von Ihnen angegebene URL ist ungültig.',

   'Either the token included in the URL has been deleted or the URL you provided was invalid.'
=> 'Entweder wurde der in der URL enthaltene Authentifizierungscode gelöscht oder die von Ihnen angegebene URL ist ungültig.',

   'Sorry, the token generated when you requested a password reset has expired.'
=> 'Der erstellte Authentifizierungscode zum Zurücksetzen Ihres Passworts ist bereits abgelaufen und daher nicht mehr gültig.',

   'Sorry, the URL generated when you requested reset of your password contained incomplete information.'
=> 'Die URL, die erstellt wurde, als Sie das Zurücksetzen Ihres Passworts angefordert haben, enthält unvollständige Daten und ist daher ungültig.',

   'Sorry, the URL you provided to complete creation of a new LON-CAPA account was invalid.'
=> 'Die von Ihnen angegebene URL zum Abschließen der Erstellung Ihres neuen LON-CAPA-Accounts ist ungültig.',

   'Page requested in unexpected context'
=> 'Die Seite wurde in unerwartetem Kontext aufgerufen',

   'Invalid username and/or domain'
=> 'Ungültige Benutzerkennung und/oder Domäne',

   'Username and domain were blank'
=> 'Benutzerkennung und Domäne waren leer',

   'Authentication type for this user can not be changed by this mechanism'
=> 'Die Authentifizierungsmethode kann für diesen Benutzer nicht auf die gewünschte Methode umgestellt werden',

   'One or more password fields were blank'
=> 'Ein oder mehrere Passwort-Felder waren leer',

   'Please log out and try again.'
=> 'Bitte loggen Sie sich aus und versuchen Sie es noch einmal.',

   'Please try again later.'
=> 'Bitte versuchen Sie es später noch einmal.',

   'Unable to retrieve saved token for password decryption'
=> 'Es ist nicht möglich, den gespeicherten Authentifizierungscode für die Passwortentschlüsselung abzurufen.',

   'Could not verify current authentication.'
=> 'Die aktuelle Authentifizierung konnte nicht bestätigt werden.',

   'The new passwords you entered do not match.'
=> 'Die Bestätigung des neuen Passworts stimmt nicht mit dem neuen Passwort überein.',

   'Passwords must be a minimum of 7 characters long.'
=> 'Das Passwort muss mindestens 7 Zeichen lang sein.',

   'The password you entered contained illegal characters.'
=> 'Das von Ihnen eingegebene Passwort enthält ungültige Zeichen.',

   'Valid characters are'
=> 'Gültige Zeichen sind',

   'The password for user [_1] was successfully changed.'
=> 'Das Passwort für den Benutzer [_1] wurde erfolgreich geändert.',

   'The password for user [_1] was not changed.'
=> 'Das Passwort für den Benutzer [_1] wurde nicht geändert.',

   'Please make sure your old password was entered correctly.'
=> 'Bitte stellen Sie sicher, dass das alte Passwort korrekt eingegeben wurde.',

   'In discussions: only new posts will be displayed.'
=> 'In Diskussionen: Es werden nur neue Beiträge angezeigt.',

   'In discussions: all posts will be displayed.'
=> 'In Diskussionen: Es werden alle Beiträge angezeigt.',

   'In discussions: new posts will cease to be identified as "NEW" after display.'
=> 'In Diskussionen: Neue Beiträge werden nach dem Anzeigen nicht mehr als "NEU" angezeigt.',

   'In discussions: posts will be identified as "NEW" until marked as not "NEW".'
=> 'In Diskussionen: Es werden Beiträge solange als "NEU" interpretiert, bis sie durch den Leser als nicht mehr "NEU" markiert werden.',

   'The e-mail address entered in row '
=> 'Die eingegebene E-Mail-Adresse in der Zeile ',

   'The e-mail address you entered'
=> 'Die von Ihnen eingegebene E-Mail-Adresse',

   'is not a valid e-mail address'
=> 'ist keine gültige E-Mail-Adresse',

   'Title for the Uploaded Score'
=> 'Titel für Formular zum Hochladen von Bewertungen',

   'Name of Simple Course Page'
=> 'Name der einfachen Kursseite',

   'Title for the Problem'
=> 'Titel der Aufgabe',

   'Title for the Drop Box'
=> 'Titel der Dropbox',

   'Title for the Discussion Board'
=> 'Titel des Diskussionsforums',

   'Not a valid user:domain'
=> 'Benutzer:Domäne ungültig',

   'Please enter both user and domain in the format user:domain'
=> 'Bitte geben Sie Benutzer und Domäne im Format Benutzer:Domäne ein!',

   'Personal Information Page of '
=> 'Persönliche Seite von ',

   'No info'
=> 'Keine Information vorhanden',

   'No user information available'
=> 'Keine Benutzerdaten verfügbar',

   'The new directory name was changed from [_1] to [_2].'
=> 'Der Name des neuen Verzeichnisses wurde von [_1] in [_2] geändert.',

   'Unable to create a directory named'
=> 'Es war nicht möglich ein Verzeichnis anzulegen mit dem Namen',

   'A file or directory by that name already exists.'
=> 'Es existiert bereits eine Datei oder ein Verzeichnis mit diesem Namen.',

   'Allowing others to retrieve file: [_1]'
=> 'Für andere Abrufen der Datei [_1] gestatten',

   'Access to this file by others can be set to be one or more of the following types: public, passphrase-protected or conditional.'
=> 'Zugriff durch andere auf diese Datei kann auf folgende drei Typen eingestellt werden: öffentlich, passwortgeschützt oder bedingungsabhängig',

   'Public files are available to anyone without the need for login.'
=> 'Öffentliche Dateien sind für alle verfügbar, auch ohne Login.',

   'Passphrase-protected files do not require log-in, but will require the viewer to enter the passphrase you set.'
=> 'Passwortgeschützte Dateien erfordern keinen Login, aber es ist für den Zugriff notwendig, dass das von Ihnen hinterlegte Passwort eingegeben wird.',

   'A listing of files viewable without log-in is available at: '
=> 'Eine Liste von Dateien, die ohne Login verfügbar sind, gibt es unter: ',

   "For logged in users a 'Display file listing' link will also appear (when there are Viewable files) on your personal information page:"
=> "Für eingeloggte Benutzer wird es auf Ihrer persönlichen Seite zusätzlich einen Link 'Dateiliste anzeigen' geben (falls anzeigbare Dateien vorhanden sind):",

   "For logged in users a 'Display file listing' link will also appear (when there are viewable files) on your personal information page:"
=> "Für eingeloggte Benutzer wird es auf Ihrer persönlichen Seite zusätzlich einen Link 'Dateiliste anzeigen' geben (falls anzeigbare Dateien vorhanden sind):",

   "For logged in users a 'Display file listing' link will also appear (when there are viewable files) on the course information page:"
=> "Für eingeloggte Benutzer wird es auf der Kursinformationsseite zusätzlich einen Link 'Dateiliste anzeigen' geben (falls anzeigbare Dateien vorhanden sind):",

   "Users with privileges to edit course contents may add a course information page to a course using the 'Course Info' button in DOCS"
=> "Benutzer mit Berechtigung zum Ändern von Kursinhalten können dem Kurs eine Kursinformations-Seite hinzufügen. Dies geschieht durch Verwendung des 'Kursinformationen'-Buttons im Bereich 'Kurs-Editor'",

   'Conditional access controls for file: [_1]'
=> 'Bedingte Zugriffskontrolle für Datei: [_1]',

   'Help on setting up share access'
=> 'Hilfe zum Einstellen für gemeinsamen Zugriff',

   'Help on changing settings'
=> 'Hilfe zum Ändern der Einstellungen',

   'Help on removing share access'
=> 'Hilfe zum Entfernen des gemeinsamen Zugriffs',

   'Public access: [_1]'
=> 'Öffentlicher Zugriff: [_1]',

   'Dates available'
=> 'Verfügbare Datumseinstellungen',

   'Passphrase-protected access: [_1]'
=> 'Passwortgeschützter Zugriff: [_1]',

   'Passphrase'
=> 'Passwort',

   'Passphrase: '
=> 'Passwort: ',

   'Conditional access: [_1]'
=> 'Bedingungsabhängiger Zugriff: [_1]',

   'You have previously set [_1] conditional access controls.'
=> 'Zuvor haben Sie [_1] bedingungsabhängige Zugriffskontrollen eingerichtet.',

   'Change Conditions'
=> 'Bedingungen ändern',

   'Add conditional access'
=> 'Bedingungsabhängigen Zugriff hinzufügen',

   'based on domain, username, or course/community affiliation.'
=> 'basierend auf Domäne, Benutzerkennung oder Kurs-/Community-Zugehörigkeit',

   'Domain-based conditional access:'
=> 'Domänen-basierter bedingungsabhängiger Zugriff:',

   'User-based conditional access:'
=> 'Benutzer-basierter bedingungsabhängiger Zugriff:',

   'Course/Community-based conditional access:'
=> 'Kurs-/Community-basierter bedingungsabhängiger Zugriff:',

   '[quant,_1,condition]'
=> '[quant,_1,Bedingung,Bedingungen]',

   'Action?'
=> 'Aktion?',

   'Allowed course/community affiliations'
=> 'Zugelassene Kurs-/Community-Mitgliedszugehörigkeiten', # ???

   'No Domain-based conditions defined'
=> 'Keine Domänen-basierten Bedingungen definiert',

   'No User-based conditions defined'
=> 'Keine Benutzer-basierten Bedingungen definiert',

   'No Course/Community-based conditions defined'
=> 'Keine Kurs-/Community-basierten Bedingungen definiert',

   'Type of change'
=> 'Änderungsart',

   'Access control'
=> 'Zugriffskontrolle',

   'Access not allowed.'
=> 'Zugriff nicht gestattet',

   'Additional information'
=> 'Zusätzliche Informationen',

   'A problem occurred deleting access controls: [_1]'
=> 'Beim Löschen der Zugriffkontrollen trat ein ein Problem auf: [_1]',

   'A problem occurred saving access control settings: [_1]'
=> 'Beim Speichern der Zugriffskontroll-Einstellungen trat ein Problem auf: [_1]',

   'opened folder'
=> 'geöffnetes Verzeichnis',

   'closed folder'
=> 'geschlossenes Verzeichnis',

   'Passphrase-protected'
=> 'Passwortgeschützt',

   'Conditional'
=> 'Bedingungsabhängig',

   'An error occurred ([_1]) while trying to delete [_2].'
=> 'Beim Versuch, [_2] zu löschen, ist ein Fehler aufgetreten: [_1]',

   'File: [_1] deleted.'
=> 'Die Datei [_1] wurde gelöscht.',

   'An error occurred ([_1]) while trying to delete access controls for the file.'
=> 'Beim Versuch, Zugriffskontrollen für die Datei zu löschen, ist ein Fehler aufgetreten: [_1]',

   'Access controls also deleted for the file.'
=> 'Auch die Zugriffskontrollen wurden für diese Datei gelöscht.',

   'Error: no valid filename was provided to rename to.'
=> 'Fehler: Das Umbenennen ist nicht möglich, da für den neuen Dateinamen kein gültiger Dateiname angegeben wurde.',

   'An error occurred ([_1]) while trying to rename [_2] to [_3]'
=> 'Beim Versuch, [_2] in [_3] umzubenennen, ist ein Fehler aufgetreten: [_1]',

   'An error occurred ([_1]) while trying to rename [_2] to [_3].'
=> 'Beim Versuch, [_2] in [_3] umzubenennen, ist ein Fehler aufgetreten: [_1]',

   'An error occurred ([_1]) while trying to overwrite [_2].'
=> 'Beim Versuch, [_2] zu überschreiben, ist ein Fehler aufgetreten: [_1]',

   'The new filename was changed from [_1] to [_2].'
=> 'Der neue Dateiname wurde von [_1] in [_2] geändert.',

   'An error occurred ([_1]) while trying to delete access control records for the old name.'
=> 'Beim Versuch, Zugriffskontroll-Datensätze für den alten Namen zu löschen, ist ein Fehler aufgetreten: [_1]',

   'An error occurred ([_1]) while trying to update access control records for the new name.'
=> 'Beim Versuch, Zugriffskontroll-Datensätze für den neuen Namen zu aktualisieren, ist ein Fehler aufgetreten: [_1]',

   'An error occurred ([_1]) while trying to upload [_2].'
=> 'Beim Versuch, [_2] hochzuladen, ist ein Fehler aufgetreten: [_1]',

   'An error occurred (dir) ([_1]) while trying to delete [_2].'
=> 'Beim Versuch, das Verzeichnis [_2] zu löschen, ist ein Fehler aufgetreten: [_1]',

   'An error occurred ([_1]) while trying to upload [_2] for embedded element [_3].'
=> 'Beim Versuch, [_2] für das eingebettete Element [_3] hochzuladen, ist ein Fehler aufgetreten: [_1]',

   'An error occurred ([_1]) while trying to create a new directory [_2].'
=> 'Beim Versuch, das Verzeichnis [_2] anzulegen, ist ein Fehler aufgetreten: [_1]',

   'Access controls updated to reflect the name change.'
=> 'Die Zugriffskontrolle wurde aufgrund der Namensänderung aktualisiert.',

   'Conditional files are accessible to logged-in users with accounts in the LON-CAPA network, who satisfy the conditions you set.'
=> 'Auf bedingungsabhängige Dateien können eingeloggte Benutzer zugreifen, die im LON-CAPA-Netzwerk einen Benutzeraccount haben und die die von Ihnen eingestellten Bedingungen erfüllen.',

   'Alternatively access can be granted to people with specific LON-CAPA usernames and domains.'
=> 'Alternativ kann Zugriff für Personen gewährt werden, die bestimmte LON-CAPA-Benutzernamen oder -Domänen haben.',

   'Current access controls defined for this file:'
=> 'Derzeit eingestellte Zugriffskontrolle für diese Datei:',

   'No access control settings currently exist for this file.'
=> 'Für diese Datei existieren derzeit keine Zugriffskontroll-Einstellungen.',

   'Deleted'
=> 'Gelöscht',

   'No end date'
=> 'Kein Enddatum',

   'Start: '
=> 'Start: ',

   'End: '
=> 'Ende: ',

   'Domains: '
=> 'Domänen: ',

   'Users: '
=> 'Benutzer: ',

   'New control(s) added'
=> 'Neue Zugriffskontrolle(n) hinzugefügt',

   'Existing control(s) deleted'
=> 'Bestehende Zugriffskontrolle(n) gelöscht',

   'Existing control(s) modified'
=> 'Bestehende Zugriffskontrolle(n) geändert',

   'Add new [_1]course/community-based[_2] access control for portfolio file: [_3]'
=> 'Neue [_1]kurs-/community-basierte[_2] Zugriffskontrolle für Portfolio-Datei [_3] hinzufügen',

   'Add new [_1]domain-based[_2] access control for portfolio file: [_3]'
=> 'Neue [_1]domänen-basierte[_2] Zugriffskontrolle für Portfolio-Datei [_3] hinzufügen',

   'Add new [_1]user-based[_2] access control for portfolio file: [_3]'
=> 'Neue [_1]benutzer-basierte[_2] Zugriffskontrolle für Portfolio-Datei [_3] hinzufügen',

   'Display all access settings for this file'
=> 'Alle Einstellungen für diese Datei anzeigen',

   'Add a roles-based condition'
=> 'Rollen-basierte Bedingung hinzufügen',

   'New role-based condition'
=> 'Neue rollen-basierte Bedingung',

   "Format for users' username:domain information:"
=> "Format für Informationen des Benutzers username:domäne:", # ??? -> portfolio.pm

   'Add new course/community-based condition(s)?'
=> 'Neue kurs-/community-basierte(n) Bedingung(en) hinzufügen?',

   'Add new domain-based condition(s)?'
=> 'Neue domänen-basierte(n) Bedingung(en) hinzufügen?',

   'Add new user-based condition(s)?'
=> 'Neue benutzer-basierte(n) Bedingung(en) hinzufügen?',

   'Number to add: '
=> 'Anzahl: ', # 'Anzahl neu Hinzuzufügender: ',

   'Select roles, course status, section(s) and group(s) for users who will be able to access the portfolio file.'
=> 'Wählen Sie Rollen, Kurs-Status, Sektion(en) und Gruppe(n) für die Benutzer, die Zugriff auf die Portfolio-Dateien erhalten sollen.',

   'Select roles, community status, section(s) and group(s) for users who will be able to access the portfolio file.'
=> 'Wählen Sie Rollen, Kurs-Status, Sektion(en) und Gruppe(n) für die Benutzer, die Zugriff auf die Portfolio-Dateien erhalten sollen.',

   'Course status'
=> 'Kursstatus',

   'Community status'
=> 'Community-Status',

   'Course/Community status'
=> 'Kurs-/Community-Status',

   'Files selected from other directories:'
=> 'Dateien, die aus anderen Verzeichnissen ausgewählt wurden:',

   'Unable to upload [_1]. (size = [_2] kilobytes). Disk quota will be exceeded.'
=> '[_1] konnte nicht hochgeladen werden (Größe: [_2] KB). Der verfügbare Speicherplatz wurde überschritten.',

   'Unable to upload [_1]. A locked file by that name was found in [_2].'
=> '[_1] konnte nicht hochgeladen werden. Eine gesperrte Datei mit diesem Namen wurde in [_2] gefunden.',

   'You will be able to rename or delete existing [_1] after a grade has been assigned.'
=> 'Sie können die Datei [_1] umbenennen oder löschen, nachdem eine Bewertung zugewiesen wurde.',

   'Unable to upload [_1]. A file by that name was found in [_2].'
=> '[_1] konnte nicht hochgeladen werden. Eine Datei mit diesem Namen wurde in [_2] gefunden.',

   'To upload, rename or delete existing [_1] in [_2].'
=> 'Um eine existierende Datei [_1] in [_2] hochzuladen, umzubenennen oder zu löschen.', # ???

   'Rename [_1] to [_2]?'
=> '[_1] in [_2] umbenennen?',

   'Move [_1] to [_2]?'
=> '[_1] nach [_2] verschieben?',

   'Copy [_1] to [_2]?'
=> '[_1] nach [_2] kopieren?',

   'Reference Warning'
=> 'Verweiswarnung',

   'This file contained references to other files.'
=> 'Diese Datei enthält Verweise auf andere Dateien.',

   'You must upload the referenced files or else the uploaded file may not work properly.'
=> 'Sie müssen die Dateien, auf die verwiesen wird, auch hochladen oder die hochgeladene Datei wird nicht korrekt funktionieren.',

   'Please select the locations from which the referenced files are to be uploaded.'
=> 'Bitte wählen Sie die Orte aus, von denen die Dateien, auf die verwiesen wird, hochgeladen werden sollen.',

   'Delete [_1]?'
=> '[_1] löschen?',

   'Edit Portfolio File Metadata'
=> 'Metadaten der Portfolio-Datei bearbeiten',

   'Edit Group Portfolio File Metadata'
=> 'Metadaten der Gruppen-Portfolio-Datei bearbeiten',

   'Update'
=> 'Aktualisieren',

   'domains'
=> 'domänen',

   'users'
=> 'benutzer',

   'Access'
=> 'Zugriff',

   'Conditional: domain-based'
=> 'Bedingungsabhängig: domänen-basiert',

   'Conditional: user-based'
=> 'Bedingungsabhängig: benutzer-basiert',

   'Conditional: course/community-based'
=> 'Bedingungsabhängig: Kurs-/Community-basiert',

   '[_1] was submitted in response to problem: [_2]'
=> '[_1] wurde als Antwort auf die Aufgabe [_2] eingereicht.',

   '[_1] was handed back in response to problem: [_2]'
=> '[_1] wurde als Antwort auf die Aufgabe [_2] zurückgegeben.',

   'In the course:'
=> 'Im Kurs',

   'Back'
=> 'Zurück',

   'Error: no directory name was provided.'
=> 'Fehler: Es wurde kein Verzeichnisname angegeben.',

   'Unable to create a directory named [_1].'
=> 'Konnte das Verzeichnis [_1] nicht anlegen.',

   'Action disallowed'
=> 'Aktion nicht gestattet',

   'You do not have sufficient privileges to [_1]'
=> 'Sie haben nicht genügend Berechtigungen, um [_1]',

   'upload files'
=> 'Datei hochzuladen',

   'delete files'
=> 'Dateien zu löschen',

   'rename files'
=> 'Dateien umzubenennen',

   'set access controls for files'
=> 'Zugriffskontrollen für Dateien zu setzen',

   "in the group's group portfolio."
=> 'im Gruppen-Portfolio.',

   'in this portfolio.'
=> 'in diesem Portfolio.',

   'You do not have the privileges required to access the shared files space for this group.'
=> 'Sie haben nicht die Berechtigung, um auf den Bereich für gemeinsam genutzte Dateien in dieser Gruppe zugreifen zu können.',

   'Not a valid group for this course'
=> 'Keine gültige Gruppe für diesen Kurs',

   'Group portfolio for [_1]'
=> 'Gruppen-Portfolio für [_1]',

   'Invalid group'
=> 'Ungültige Gruppe',

   'No file was selected to upload.'
=> 'Es wurde keine Datei ausgewählt, die hochgeladen werden soll.',

   'To upload a file, click [_1]Browse...[_2] and select a file, then click [_1]Upload[_2].'
=> 'Um eine Datei hochzuladen, klicken Sie auf [_1]Durchsuchen...[_2] und wählen Sie eine Datei, dann klicken Sie auf [_1]Hochladen[_2].',

   'Pick functionality'
=> 'Funktion auswählen',

   'Functionality to display/modify'
=> 'Funktionen, die angezeigt oder geändert werden sollen',

   'Settings to display/modify'
=> 'Einstellungen, die angezeigt oder geändert werden sollen',

   'You must select at least one functionality type to display.'
=> 'Sie müssen mindestens einen Funktionstyp auswählen, der angezeigt werden soll.',

   'Default color schemes'
=> 'Voreingestellte Farbeinstellungen',

   'Log-in page options'
=> 'Optionen für Login-Seite',

   'Default authentication/language/timezone'
=> 'Voreingestellte Authentifizierung/Sprache/Zeitzone',

   'Default quotas for user portfolios'
=> 'Voreingestellter Speicherplatz für Portfolios der Benutzer',

   'View/Modify quotas for group portfolio files, and for uploaded content.'
=> 'Speicherplatz für Gruppen-Portfolio-Dateien und für hochgeladenenen Inhalt betrachten/ändern',

   'Auto-update settings'
=> 'Einstellungen für automatische Aktualisierungen',

   'Institutional directory searches'
=> 'Suche im Institutionsverzeichnis',

   'User creation'
=> 'Benutzer-Erstellung',

   'User modification'
=> 'Benutzer-Einstellungen',

   'Bubblesheet format file'
=> 'Bubblesheet-Formatdatei',

   'Cataloging of courses'
=> 'Katalogisierung von Kursen',

   'Display options'
=> 'Anzeigeoptionen',

   'Display using: '
=> 'Anzeige verwendet: ',

   'one column'
=> 'eine Spalte',

   'two columns'
=> 'zwei Spalten',

   'Changes made:'
=> 'Vorgenommene Änderungen:',

   'Changes made: '
=> 'Vorgenommene Änderungen: ',

   'Back to configuration display'
=> 'Zurück zur Konfiguration',

   'No changes made to log-in page settings'
=> 'An den Optionen für die Login-Seite wurden keine Änderungen vorgenommen.',

   'No changes made to community configuration.'
=> 'An der Community-Konfiguration wurden keine Änderungen vorgenommen.',

   'No changes made to community settings.'
=> 'An den Community-Einstellungen wurden keine Änderungen vorgenommen.',

   'No changes made to course and community categories'
=> 'An den Kurs- und Community-Kategorien wurden keine Änderungen vorgenommen.',

   'No changes made to course configuration.'
=> 'An der Kurs-Konfiguration wurden keine Änderungen vorgenommen.',

   'No changes made to course defaults'
=> 'An den Kurs-Voreinstellungen wurden keine Änderungen vorgenommen.',

   'No changes made to course settings.'
=> 'An den Kurs-Einstellungen wurden keine Änderungen vorgenommen.',

   'Support Request'
=> 'Anfrage an Helpdesk',

   'Do [_1]not[_2] use this form to ask about course content.'
=> 'Verwenden Sie dieses Formular [_1]nicht[_2] für Fragen über Kursinhalte.',

   'Contact your instructor instead.'
=> 'Kontaktieren Sie dazu Ihren Dozenten.',

   'Cc'
=> 'Kopie an (CC)',

   'Your e-mail address'
=> 'Ihre E-Mail-Adresse',

   'Search and Enroll'
=> 'Suche und Kursbelegung',

   'Search or Add New User'
=> 'Suche oder neuen Benutzer hinzufügen',

   'No username and/or domain provided.'
=> 'Keine Benutzerkennung und/oder Domäne angegeben.',

   'Submit a request to the LON-CAPA [_1]helpdesk[_2] for [_3] if you require assistance.'
=> 'Kontaktieren Sie das [_1]LON-CAPA-Helpdesk[_2] ([_3]), falls Sie Unterstützung benötigen.',

   'Problems occurred in creating the new Excel file.'
=> 'Bei der Erstellung der Excel-Datei sind Schwierigkeiten aufgetreten.',

   'Problems occurred in creating the output file.'
=> 'Bei der Erstellung der Ausgabedatei sind Schwierigkeiten aufgetreten.',

   'Problems occurred in writing the CSV file.'
=> 'Beim Schreiben der CSV-Datei sind Schwierigkeiten aufgetreten.',

   'This error has been logged.'
=> 'Dieser Fehler wurde protokolliert.',

   'This is a serious error and has been logged.'
=> 'Es handelt sich um einen schwerwiegenden Fehler, der protokolliert wurde.',

   'Please alert your LON-CAPA administrator.'
=> 'Bitte benachrichtigen Sie Ihren LON-CAPA-Administrator.',

   'Records [_1]'
=> 'Datensätze [_1]', # ???

   'Records: [_1]'
=> 'Datensätze: [_1]',

   'Filter [_1]'
=> 'Filter [_1]',

   'Filter: [_1]'
=> 'Filter: [_1]',

   'Under your current role you are not permitted to change login settings for this user'
=> 'Mit Ihrer derzeitigen Benutzerrolle sind Sie nicht berechtigt, die Login-Daten für diesen Benutzer zu ändern.',

   'History'
=> 'Historie',

   'Part '
=> 'Teil ',

   'Transaction [_1]'
=> 'Transaktion [_1]', # ???

   'Nothing submitted - no attempts.'
=> 'Nichts eingereicht - keine Versuche unternommen.',

   'No data.'
=> 'Keine Daten vorhanden.',

   'Open in a new window'
=> 'In neuem Fenster öffnen',

   'Open in new window'
=> 'In neuem Fenster öffnen',

   'Revoke user roles'
=> 'Benutzerrollen entziehen',

   'Delete user roles'
=> 'Benutzerrollen löschen',

   'Re-enable expired user roles'
=> 'Abgelaufene Benutzerrollen reaktivieren',

   'Make future user roles active now'
=> 'Zukünftige Benutzerrollen für jetzt aktivieren',

   'Change starting/ending dates'
=> 'Anfangs-/Endezeiten ändern',

   'Change section associated with user roles'
=> 'Mit Benutzerrollen verknüpfte Sektionen ändern',

   'Modify existing user: '
=> 'Existierenden Benutzer ändern: ',

   'Modify existing user: [_1] in domain [_2]'
=> 'Existierenden Benutzer [_1] in Domäne [_2] ändern',

   'Enroll one student'
=> 'Einzelne/n Studenten/in Kurs belegen lassen',

   'Enroll one student: '
=> 'Einzelne/n Studenten/in Kurs belegen lassen: ',

   'Enroll one student: [_1] in domain [_2]'
=> 'Einzelne/n Studenten/in [_1] in Domäne [_2] Kurs belegen lassen',

   'Existing Roles'
=> 'Bestehende Rollen',

   'Existing Roles in this Course'
=> 'Bestehende Rollen in diesem Kurs',

   'Existing Co-Author Roles in your Authoring Space'
=> 'Bestehende Co-Autoren-Rollen in Ihrem Autorenbereich',

   'Existing Roles in this Domain'
=> 'Bestehende Rollen in dieser Domäne',

   'Existing Roles in this Community'
=> 'Bestehende Rollen in dieser Community',

   'You are already logged in!'
=> 'Sie sind bereits angemeldet!',

   'You are already logged in'
=> 'Sie sind bereits angemeldet!',

   'Please either [_1]continue the current session[_2] or [_3]log out[_4].'
=> 'Ihre Möglichkeiten: [_1]aktuelle Sitzung fortsetzen[_2] oder [_3]ausloggen[_4].',

   'Login problems?'
=> 'Schwierigkeiten beim Login?',

   'Reset password'
=> 'Passwort zurücksetzen',

   'Reset Password'
=> 'Passwort zurücksetzen',

   'Reset forgotten LON-CAPA password'
=> 'Vergessenes LON-CAPA-Passwort zurücksetzen',

   'Update Password'
=> 'Passwort erneuern',

   'Forgotten Password'
=> 'Vergessenes Passwort',

   'Account Information'
=> 'Account-Daten',

   'If you use the same account for other campus services besides LON-CAPA, (e.g., e-mail, course registration, etc.), a separate centrally managed mechanism likely exists to reset a password. However, if your account is used for just LON-CAPA access you will probably be able to reset a password from this page.'
=> 'Falls Sie den gleichen Account für mehrere Campusdienste neben LON-CAPA verwenden (z.B. E-Mail, Vorlesungsanmeldung, etc.), existiert üblicherweise ein zentrale Einrichtung, über die Sie Ihr Passwort zurücksetzen können. Falls Ihr Account nur für LON-CAPA eingesetzt wird, können Sie Ihr Passwort gegebenenfalls über diese Seite zurücksetzen.',

   'Three conditions must be met:'
=> 'Drei Bedingungen müssen zutreffen:',

   'An e-mail address must have previously been associated with your LON-CAPA username.'
=> 'Es muss eine E-Mail-Adresse mit Ihrer LON-CAPA-Benutzerkennung verknüpft sein.',

   'You must be able to access e-mail sent to that address.'
=> 'Sie müssen E-Mails, die an diesen E-Mail-Account geschickt werden, lesen können.',

   'Your LON-CAPA account must be of a type for which LON-CAPA can reset a password.'
=> 'Ihr LON-CAPA-Account muss von dem Typ sein, für den LON-CAPA Passwörter zurücksetzen kann.',

   'Thank you for your request to reset the password for your LON-CAPA account.'
=> 'Danke für Ihre Anforderung zur Zurücksetzung des Passworts Ihres LON-CAPA-Accounts.',

   'E-mail address in LON-CAPA'
=> 'E-Mail-Adresse in LON-CAPA',

   'The username you provided was not verified as a valid username in the LON-CAPA system for the [_1] domain.'
=> 'Die von Ihnen angegebene Benutzerkennung konnte nicht als gültige LON-CAPA-Benutzerkennung der Domäne [_1] bestätigt werden.',

   '[_1]Go back[_2] and try again'
=> '[_1]Zurück[_2] und noch einmal versuchen',

   'The e-mail address you provided does not appear to be a valid address.'
=> 'Die von Ihnen angegebene E-Mail-Adresse scheint keine gültige E-Mail-Adresse zu sein.',

   'The e-mail address you provided does not match the address recorded in the LON-CAPA system for the username and domain you provided.'
=> 'Die von Ihnen angegebene E-Mail-Adresse stimmt nicht mit der in LON-CAPA hinterlegten E-Mail-Adresse des von Ihnen angegebenen Benutzers und Domäne überein.',

   'A valid e-mail address was not located in the LON-CAPA system for the username and domain you provided.'
=> 'In LON-CAPA konnte zu dem/r von Ihnen angegebenen/r Benutzer und Domäne keine gültige E-Mail-Adresse gefunden werden.',

   'The username you provided uses an authentication type which can not be reset directly via LON-CAPA.'
=> 'Das Authentifizierungsverfahren, das bei dem von Ihnen angegebenen Benutzer verwendet wird, erlaubt kein Zurücksetzen des Passworts über LON-CAPA.',

   'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3].'
=> 'Sie können das [_1]LON-CAPA-Helpdesk[_2] der Einrichtung [_3] kontaktieren.',

   'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for [_3].'
=> 'Sie können das [_1]LON-CAPA-Helpdesk[_2] der Einrichtung [_3] kontaktieren.',

   'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3] domain.'
=> 'Sie können das [_1]LON-CAPA-Helpdesk[_2] der Einrichtung [_3] kontaktieren.',

   'Contact the [_1]LON-CAPA helpdesk[_2] for the institution: [_3]'
=> '[_1]LON-CAPA-Helpdesk[_2] der Einrichtung [_3] kontaktieren',

   'You may wish to send an e-mail to the server administrator: [_1] for [_2].' # 1: e-mail, 2: domain
=> 'Sie können an den Server-Administrator [_1] der Domäne [_2] eine E-Mail schicken.',
   'You may wish to send an e-mail to the server administrator: [_1] for the [_2] domain.'
=> 'Sie können an den Server-Administrator [_1] der Domäne [_2] eine E-Mail schicken.',


   'Assigning yourself a co-author or assistant co-author role in your own author area in Authoring Space is not permitted'
=> 'Es ist nicht möglich, sich selbst im eigenen Autorenbereich eine Rolle als Co-Autor oder Autor-Assistent zuzuweisen.',

   'Owner(s)'
=> 'Eigentümer',

   'Practice Problem'
=> 'Übungsaufgabe',

   'Submissions are not permanently recorded'
=> 'Die Antworten werden nicht dauerhaft gespeichert.',

   'Submissions to practice problems are not permanently recorded.'
=> 'Antworten von Übungsaufgaben werden nicht dauerhaft gespeichert.',

   'not graded'
=> 'keine Punktewertung',

   'Course initialization preference'
=> 'Kurs-Initialisierungs-Präferenz',

   'Choose which page will be displayed when you enter this course after selecting a role.'
=> 'Festlegung, welche Seite beim Betreten dieses Kurses angezeigt werden soll.',

   'Choose which page will be displayed when you enter this community after selecting a role.'
=> 'Festlegung, welche Seite beim Betreten der Community angezeigt werden soll.',

   'Current value is determined by'
=> 'Derzeitiger Wert ist bestimmt durch',

   'and is set to display'
=> 'und ist so eingestellt, dass folgende Seite gezeigt wird:',

   'Page display controlled by'
=> 'Seitenanzeige wird bestimmt durch',

   'If'
=> 'Falls',

   'Choose course entry'
=> 'Auswahl des Kurs-Eintrags',

   'Choose community entry'
=> 'Auswahl des Community-Eintrags',

   'Modify course entry'
=> 'Kurs-Eintrag ändern',

   'No members to add at this time, as there are no users matching the specified type(s), role(s) and section(s).'
=> 'Derzeit gibt es keine Mitglieder, die hinzuzufügen wären, da es keine Benutzer gibt, auf die die Typen, Rollen und Sektionen zutreffen.',

   'There are no users to add as new members, as all users matching the specified type(s), role(s), and section(s) are already affiliated with this group.'
=> 'Derzeit gibt es keine Benutzer, die als neue Mitglieder hinzuzufügen wären, da alle Benutzer, auf die die Typen, Rollen und Sektionen zutreffen, bereits mit der Gruppe verknüpft sind.',

   "You may need to use the 'modify existing, past or future members' page if you need to re-enable or activate access for previous or future members."
=> "Sie müssen ggf. die 'Bestehende, in der Vergangenheit liegende oder zukünftige Mitgliedschaften'-Seite verwenden, um Zugriff für in der Vergangenheit liegende oder zukünftige Mitgliedschaften wiederherzustellen oder zu aktivieren.",

   'Setting optional privileges for specific group members'
=> 'Einrichten von optionalen Berechtigungen für bestimmte Gruppenmitglieder',

   'As no group tools will be made available to users, there are no specific user privileges to set.'
=> 'Da keine Gruppenwerkzeuge für Benutzer zugänglich gemacht werden, können auch keine Berechtigungen für bestimmte Benutzer eingerichtet werden.',

   'Create group'
=> 'Gruppe erstellen',

   'The value you entered for the quota for the group portfolio in this group contained invalid characters, so it has been set to 0 MB. You can change this by modifying the group settings.'
=> 'Der von Ihnen eingegebene Wert des Speicherplatzes für das Gruppen-Portfolio dieser Gruppe enthält ungültige Zeichen. Der Wert wurde deshalb auf 0 MB gesetzt. Sie können dies in den Gruppen-Einstellungen ändern.',

   'The value you entered for the quota for the group portfolio in this group exceeded the maximum possible value, so it has been set to [_1] MB (the maximum possible value).'
=> 'Der von Ihnen eingegebene Wert des Speicherplatzes für das Gruppen-Portfolio dieser Gruppe hat die maximal zulässige Größe überschritten. Der Wert wurde deshalb auf [_1] MB gesetzt (die maximal mögliche Größe).',

   'A problem occurred when creating folders for the new group [_1]:'
=> 'Bei Erstellen von Verzeichnissen für die neue Gruppe [_1] ist ein Fehler aufgetreten:',

   'Group [_1] was created.'
=> 'Die Gruppe [_1] wurde erstellt.',

   'E-mail Address'
=> 'E-Mail-Adresse',

   'Closes [_1]'
=> 'Schließt am [_1]',

   'The resources in "[_1]" are open for a limited time.'
=> 'Die Ressourcen in "[_1]" sind nur für eine begrenzte Zeit verfügbar.',

   'Once you click the "Show Resource" button below you have [_2] to complete all resources "[_1]".'
=> 'Sobald Sie auf "Ressource zeigen" klicken, haben Sie [_2] Zeit, um alle Ressourcen in "[_1]" zu bearbeiten.',

   'This resource "[_1]" is open for a limited time.'
=> 'Diese Ressource "[_1]" ist nur für eine begrenzte Zeit verfügbar.',

   'Once you click the "Show Resource" button below you have [_2] to complete this resource "[_1]".'
=> 'Sobald Sie auf "Ressource zeigen" klicken, haben Sie [_2] Zeit, um diese Ressource zu bearbeiten.',

   '[quant,_1,day]'
=> '[quant,_1,Tag,Tage]',

   '[quant,_1,hour]'
=> '[quant,_1,Stunde,Stunden]',

   '[quant,_1,minute]'
=> '[quant,_1,Minute,Minuten]',

   '[quant,_1,second]'
=> '[quant,_1,Sekunde,Sekunden]',

   'Start Timer?'
=> 'Timer starten?',

   'Sign up for time to work.'
=> 'Für Zeiten zur Bearbeitung eintragen',

   'Sign up for time to work'
=> 'Für Zeiten zur Bearbeitung eintragen',

   'Requesting Another Worktime'
=> 'Anforderung anderer Zeiten zur Bearbeitung',

   'No available times.'
=> 'Keine Zeiten verfügbar.',

   'Return to last resource'
=> 'Zur letzten Ressource zurückkehren',

   'Back to most recent content resource'
=> 'Zur zuletzt verwendeten Ressource zurückkehren',

   'My Courses'
=> 'Meine Kurse',

   'My Courses/Communities'
=> 'Meine Kurse/Communitys',

   '[_1] parts'
=> '[_1] Teile',

   'Part: [_1]'
=> 'Aufgabenteil: [_1]',

   'New Discussion'
=> 'Neuer Diskussionsbeitrag',

   'New E-mail'
=> 'Neue E-Mail',

   'New Error'
=> 'Neuer Fehler',

   '(randomly select [_1])'
=> '(zufällig [_1] ausgewählt)',

   '(randomly ordered)'
=> '(in zufälliger Reihenfolge)',

   'No course selected'
=> 'Kein Kurs gewählt',

   'Open '
=> 'Öffnet am ',

   'Having technical difficulties; please check status later'
=> 'Technische Probleme - bitte später nochmal probieren',

   'Answer open'
=> 'Antwort verfügbar am',

   'Answer open [_1]'
=> 'Antwort verfügbar am [_1]',

   'Yes, and show correct answer if they exceed the maximum number of tries.'
=> 'Ja, und korrekte Antwort anzeigen, nachdem alle Versuche aufgebraucht sind.',

   "No, don't show correct/incorrect feedback."
=> "Nein, kein Korrekt-/Inkorrekt-Feedback anzeigen",

   'No, show no feedback at all.'
=> 'Nein, keinerlei Feedback anzeigen.',

   'Yes, unless discussion ended'
=> 'Ja, sofern die Diskussion noch nicht beendet ist',

   'Default - only bubblesheet grading is lenient'
=> 'Voreingestellt - nur die Bubblesheet-Bewertung ist abgeschwächt',

   'single part'
=> 'einteilig',

   'Unable to set "number unread posts display" to [_1] due to [_2].'
=> '"Anzeige der Anzahl ungelesener Beiträge" konnte nicht auf [_1] gesetzt werden. Ursache: [_2]',

   'Unable to set "number unread posts display" to [_1]'
=> '"Anzeige der Anzahl ungelesener Beiträge" konnte nicht auf [_1] gesetzt werden.',

   'Current value is [_1].'
=> 'Derzeitiger Wert ist [_1].',

   'Unable to set interval to [_1] due to [_2].'
=> 'Intervall konnte nicht auf [_1] gesetzt werden. Ursache: [_2]',

   'Changes to threshold(s) for problem tracking:'
=> 'Vorgenommene Änderungen der Schwellenwerte:',

   'Set threshold for [_1] to [_2]'
=> 'Schwellenwert für [_1] auf [_2] gesetzt',

   'Set the default page to be displayed when you select a course role'
=> 'Einstellen der voreingestellten Seite, die nach Betreten des Kurses angezeigt werden soll',

   '(Currently: [_1])'
=> '(Derzeit: [_1])',

   "The global user preference you set for your courses can be overridden in an individual course by setting a course specific setting via the [_1]What's New Page[_2] in the course."
=> "Die hier vorgenommenen allgemeinen Benutzereinstellungen können in einzelnen Kursen überschrieben werden, indem bestimmte Kurs-Einstellungen auf der [_1]Was-gibt's-Neues-Seite[_2] im jeweiligen Kurs vorgenommen werden.",

   'Display the [_1]first resource[_2] in the course.'
=> 'Anzeige der [_1]ersten Ressource[_2] im Kurs.',

   "Display the [_1]What's New Page[_2] - a summary of items in the course which require attention."
=> "Anzeige der [_1]Was-gibt's-Neues-Seite[_2] - eine Übersicht von Elementen im Kurs, auf die geachtet werden sollte.",

   'Default now set'
=> 'Voreinstellung ist ab sofort',

   'when you select a course role from the roles screen'
=> 'Wenn Sie einen Kurs von der Benutzerrollen-Seite wählen',

   'you will be taken to the start of the course.'
=> 'werden Sie zum Anfang des Kurses geleitet.',

   'a page will be displayed that lists items in the course that may require action from you.'
=> 'wird eine Seite angezeigt, die Elemente auflistet, die von Ihnen beachtet werden sollten.',

   "Display the What's New Page"
=> "Anzeige der Was-gibt's-Neues-Seite",

   'Go to the start of the course'
=> 'Zum Anfang des Kurses gehen, und zwar ',

   'now'
=> 'jetzt',

   'No official courses to display for [_1].'
=> 'Es existieren keine offiziellen Kurse für [_1], die angezeigt werden könnten.',

   '(Month - Day - Year)'
=> '(Monat - Tag - Jahr)',

   'Month[_1]Day[_2]Year'
=> 'Monat[_1]Tag[_2]Jahr',

   'Copyright/distribution option "Private" is no longer supported. Select another option from below. Consider "Custom Rights" for maximum control over the usage of your resource.'
=> 'Copyright/Zugriffsrechte unterstützt ab sofort nicht mehr die Option "Private Veröffentlichung". Deshalb wählen Sie bitte unten eine andere Option aus. Sie können "Maßgeschneiderte Zugriffsrechte" wählen, um bestmögliche Kontrolle über den Zugriff auf Ihre Ressource zu erhalten.',

   'Skipping'
=> 'Ausgelassen:',

   'Notifying host'
=> 'Benachrichtigung des Hosts', # ???

   'Back to Metadata'
=> 'Zurück zu den Metadaten',

   'Metadata Publication'
=> 'Veröffentlichung von Metadaten',

   ' at '
=> ' in ',

   "Computer's answer is incorrect ([_1])."
=> "Die hinterlegte Antwort ist falsch ([_1]).",

   'It is likely that the tolerance range [_1] or significant figures [_2] need to be adjusted.'
=> 'Wahrscheinlich müssen der Toleranzbereich [_1] oder die signifikanten Stellen [_2] angepasst werden.',

   'It is likely that the tolerance range [_1] needs to be adjusted.'
=> 'Wahrscheinlich muss der Toleranzbereich [_1] angepasst werden.',

   'Submission Record'
=> 'Einreichungs-Aufzeichnungen',

   'Set/Change grades'
=> 'Bewertungen eingeben/ändern',

   'View of the problem'
=> 'Anzeige der Aufgabe',

   'Assign Grade'
=> 'Bewertung zuweisen',

   'Assign Grades'
=> 'Bewertungen zuweisen',

   'Assigning grades based on clicker file'
=> 'Weise Bewertungen zu, die auf der Clicker-Datei basieren',

   'Assign Grade to Specific Students in Class'
=> 'Bewertung einem/r bestimmten Studenten/in im Kurs zuweisen',

   'Assign Common Grade to Class'
=> 'Dem Kurs allgemeine Bewertung zuweisen',

   'Assign Common Grade to Students in Section(s) [_1]'
=> 'Studierenden in der/den Sektion/en [_1] allgemeine Bewertung zuweisen',

   'Assign Common Grade to Students in no Section'
=> 'Studierenden, die in keiner Sektion sind, allgemeine Bewertung zuweisen',

   'Assign Grade to Specific Students in Section(s) [_1]'
=> 'Bestimmten Studierenden in der/den Sektion/en [_1] Bewertung zuweisen',

   'Assign Grade to Specific Students in no Section'
=> 'Bestimmten Studierenden, die in keiner Sektion sind, Bewertung zuweisen',

   'Save &amp; Next'
=> 'Speichern und weiter',

   '[quant,_1,student]'
=> '[quant,_1,Student/in,Studierende]',

   '[_1]student(s)'
=> '[_1]Studierende',

   '(Next and Previous (student) do not save the scores.)'
=> '("Zurück" und "Weiter" speichern nicht die Bewertungsdaten dieser Seite.)',

   'LON-CAPA User Message'
=> 'LON-CAPA-Benutzernachricht',

   '[_1]Message:[_2] No more students for this section or class.'
=> '[_1]Nachricht:[_2] Keine weiteren Studierenden für diese Sektion oder diesen Kurs.',

   'Click on the button below to return to the grading menu.'
=> 'Klicken Sie auf den Button, um zum Bewertungsmenü zurückzugelangen.',

   'Group portfolio'
=> 'Gruppen-Portfolio',

   'One group portfolio file is available.'
=> 'Eine Gruppen-Portfolio-Datei ist verfügbar.',

   'One portfolio file owned by [_1] is available.'
=> 'Eine Gruppen-Portfolio-Datei von [_1] ist verfügbar.',

   'A total of [_1] group portfolio files are available.'
=> 'Insgesamt sind [_1] Gruppen-Portfolio-Dateien verfügbar.',

   'A total of [_1] portfolio files owned by [_2] are available'
=> 'Insgesamt sind [_1] Gruppen-Portfolio-Dateien von [_2] verfügbar.',

   'A total of [_1] portfolio files owned by [_2] are available.'
=> 'Insgesamt sind [_1] Gruppen-Portfolio-Dateien von [_2] verfügbar.',

   '[quant,_1,file is,files are] publicly accessible.'
=> 'Auf [quant,_1,Datei,Dateien] kann öffentlich zugegriffen werden.',

   '[quant,_1,file requires,files require] a passphrase for access.'
=> '[quant,_1,Datei benötigt,Dateien benötigen] für den Zugriff ein Passwort.',

   'Group Portfolio files'
=> 'Gruppen-Portfolio-Dateien',

   'Viewable portfolio files.'
=> 'Einsehbare Portfolio-Dateien.',

   'Viewable portfolio files'
=> 'Einsehbare Portfolio-Dateien',

   'Viewable group portfolio files'
=> 'Einsehbare Gruppen-Portfolio-Dateien',

   'Display file listing'
=> 'Dateienliste anzeigen',

   'Portfolio files for [_1]'
=> 'Portfolio-Dateien von [_1]',

   'File access type: '
=> 'Dateizugriffs-Typ: ',

   'Update display'
=> 'Anzeige aktualisieren',

   'Course Information page'
=> 'Kursinformations-Seite',

   'Information about [_1]'
=> 'Informationen über [_1]',

   'There are no available files of the specified access type: [_1]'
=> 'Es sind keine Dateien des angegebenen Zugriffstyps [_1] verfügbar.',

   'File Type Displayed: [_1]'
=> 'Anzuzeigende Dateitypen: [_1]',

   'All file types'
=> 'Alle Dateitypen',

   'The resource depends on another resource with variable filename, i.e., [_1].'
=> 'Die Ressource hängt von einer anderen Ressource ab, die einen variablen Dateinamen hat, z.B. [_1].',

   'You likely need to explicitly allow access to all possible dependencies using the [_1]-tag.'
=> 'Sie müssen explizit Zugriff auf alle möglichen Abhängigkeiten erlauben, indem Sie das [_1]-Tag verwenden.',

   'Add Selection for:'
=> 'Auswahl hinzufügen für:',

   'Selected Parameters:'
=> 'Ausgewählte Parameter:',

   'Show detailed Parameter Selection'
=> 'Detaillierte Parameterauswahl anzeigen',

# Resource Parameters - Start

   'Problem Opening Date (opendate)'
=> 'Aufgaben-Startzeit (opendate)',

   'Problem Opening Date'
=> 'Aufgaben-Startzeit',

   'Problem Due Date (duedate)'
=> 'Aufgaben-Fälligkeitszeit (duedate)',

   'Problem Due Date'
=> 'Aufgaben-Fälligkeitszeit',

   'Problem Answer Date (answerdate)'
=> 'Aufgaben-Antwortverfügbarkeitszeit (answerdate)',

   'Problem Answer Date'
=> 'Aufgaben-Antwortverfügbarkeitszeit',

   'Time-Limit (interval)'
=> 'Zeitlimit (interval)',

   'Time-Limit'
=> 'Zeitlimit',

   'Weight (weight)'
=> 'Gewichtung (weight)',

   'weight'
=> 'Aufg.-Gew.',

   'Problem weight (for instructor)'
=> 'Aufgaben-Gewichtung (für Dozent)',

   'Weight'
=> 'Aufgaben-Gewichtung',

   'Maximum Number of Tries (maxtries)'
=> 'Maximale Anzahl an Versuchen (maxtries)',

   'Maximum Number of Tries'
=> 'Maximale Anzahl an Versuchen',

   'Number of Tries before hints appear (hinttries)'
=> 'Anzahl der Versuche, bevor Hinweise erscheinen (hinttries)',

   'Number of Tries before hints appear'
=> 'Anzahl Versuche, bevor Hinweise angezeigt werden',

   'Content Opening Date (contentopen)'
=> 'Inhalts-Startzeit (contentopen)',

   'Content Opening Date'
=> 'Inhalts-Startzeit',

   'Content Due Date (contentclose)'
=> 'Inhalts-Fälligkeitszeit (contentclose)',

   'Content Due Date'
=> 'Inhalts-Fälligkeitszeit',

   'Content Close Date (contentclose)'
=> 'Inhalts-Endezeit (contentclose)',

   'Content Close Date'
=> 'Inhalts-Endezeit',

   'Question Type (type)'
=> 'Aufgabentyp (type)',

   'Question Type'
=> 'Aufgabentyp',

   'Show Problem Status (problemstatus)'
=> 'Aufgabenstatus anzeigen (problemstatus)',

   'Show Problem Status'
=> 'Aufgabenstatus anzeigen',

   'Resource Hidden from Students (hiddenresource)'
=> 'Ressource für Studierende verborgen (hiddenresource)',

   'Resource Hidden from Students'
=> 'Ressource für Studierende verborgen',

   'Resource hidden from students (hiddenresource)'
=> 'Ressource für Studierende verborgen (hiddenresource)',

   'Resource hidden from students'
=> 'Ressource für Studierende verborgen',

   'List of hidden parts (hiddenparts)'
=> 'Liste der versteckten Aufgabenteile (hiddenparts)',

   'List of hidden parts'
=> 'Liste der versteckten Aufgabenteile', # ???

   'Part Description (display)'
=> 'Aufgabenteil-Beschreibung (display)',

   'Part Description'
=> 'Aufgabenteil-Beschreibung',

   'Show Parts One-at-a-Time (ordered)'
=> 'Aufgabenteile nacheinander zeigen (ordered)',

   'Show Parts One-at-a-Time'
=> 'Aufgabenteile nacheinander zeigen',

   'Numerical Tolerance (tol)'
=> 'Numerische Toleranz (tol)',

   'Numerical Tolerance'
=> 'Numerische Toleranz',

   'Significant Digits (sig)'
=> 'Signifikante Stellen (sig)',

   'Significant Digits'
=> 'Signifikante Stellen',

   'Significant digits'
=> 'Signifikante Stellen',

   'Show Units - Disable Entry (turnoffunit)'
=> 'Einheiten anzeigen - Eintrag deaktivieren (turnoffunit)',

   'Show Units - Disable Entry'
=> 'Einheiten anzeigen - Eintrag deaktivieren', # ???

   'Discussion End Time (discussend)'
=> 'Diskussions-Endezeit (discussend)',

   'Discussion End Time'
=> 'Diskussions-Endezeit',

   'Hide Closed Discussion (discusshide)'
=> 'Geschlossene Diskussion verbergen (discusshide)',

   'Hide Closed Discussion'
=> 'Geschlossene Diskussion verbergen',

   'Randomly Order Resources (randomorder)'
=> 'Zufällige Reihenfolge der Ressourcen (randomorder)',

   'Randomly Order Resources'
=> 'Zufällige Reihenfolge der Ressourcen',

   'Randomly pick number of resources (randompick)'
=> 'Zufällig bestimmte Anzahl an Ressourcen verwenden (randompick)',

   'Randomly pick number of resources'
=> 'Zufällig bestimmte Anzahl an Ressourcen verwenden',

   'Do not show plain URL (encrypturl)'
=> 'URL nicht im Klartext zeigen (encrypturl)',

   'Do not show plain URL'
=> 'URL nicht im Klartext zeigen',

   'Slots of availability (available)'
=> 'Verfügbarkeits-Slots (available)',

   'Slots of availability'
=> 'Verfügbarkeits-Slots',

   'CSS file to link (cssfile)'
=> 'Zu verlinkende CSS-Datei (cssfile)',

   'CSS file to link'
=> 'Zu verlinkende CSS-Datei',

   'Use slot based access controls (useslots)'
=> 'Slot-basierte Zugriffskontrolle verwenden (useslots)',

   'Use slot based access controls'
=> 'Slot-basierte Zugriffskontrolle verwenden',

   'Client IP/Name Access Control (acc)'
=> 'Client IP/Namen-Zugriffssteuerung (acc)',

   'Client IP/Name Access Control'
=> 'Zugriffskontrolle durch Client-IP-Adresse/-Name',

   'Resource alias name for conditions (mapalias)'
=> 'Ressourcen-Aliasname für Bedingungen (mapalias)',

   'Resource alias name for conditions'
=> 'Ressourcen-Aliasname für Bedingungen',

   'Slots of availability selected by student (availablestudent)'
=> 'Verfügbarkeits-Slots durch Student/in gewählt (availablestudent)',

   'Slots of availability selected by student'
=> 'Verfügbarkeits-Slots durch Student/in gewählt',

   'Hide buttons from students (buttonshide)'
=> 'Buttons für Studierende verbergen (buttonshide)',

   'Hide buttons from students'
=> 'Buttons für Studierende verbergen', # ???

   'Hide DragMath-Editor (turnoffeditor)'
=> 'DragMath-Editor verbergen (turnoffeditor)',

   'Hide DragMath-Editor'
=> 'DragMath-Editor verbergen',

   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximale Anzahl an Mitarbeitern (maxcollaborators)',

   'Maximum Number of Collaborators'
=> 'Maximale Anzahl an Mitarbeitern',

   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Erlaubte Dateiendungen für hochgeladene Dateien (uploadedfiletypes)',

   'Allowed File Extensions for Uploaded Files'
=> 'Erlaubte Dateiendungen für hochgeladene Dateien',

   'Hand Graded (handgrade)'
=> 'Manuell bewertet (handgrade)',

   'Hand Graded'
=> 'Manuell bewertet',

   'Number of bubbles in exam mode (numbubbles)'
=> 'Anzahl Ankreuzfelder im Bubblesheet-Prüfungsmodus (numbubbles)',

   'Number of bubbles in exam mode'
=> 'Anzahl Ankreuzfelder im Bubblesheet-Prüfungsmodus',

   'Number of bubbles in exam mode'
=> 'Anzahl Ankreuzfelder im Prüfungsmodus',

   'Format for display of score (scoreformat)'
=> 'Format für Punkteanzeige (scoreformat)',

   'scoreformat'
=> 'scoreformat',

   'Format for display of score'
=> 'Format für Punkteanzeige',

   'Max. Cumulative Size (MB) for Submitted Files (maxfilesize)'
=> 'Max. kumulative Größe (MB) für eingereichte Dateien (maxfilesize)',

   'Max. Cumulative Size (MB) for Submitted Files'
=> 'Max. kumulative Größe (MB) für eingereichte Dateien',

   'Max. cumulative size (MB) for submitted files (maxfilesize)'
=> 'Max. kumulative Größe (MB) für eingereichte Dateien (maxfilesize)',

   'Max. cumulative size (MB) for submitted files'
=> 'Max. kumulative Größe (MB) für eingereichte Dateien',
# Resource Parameters - End

# Resource Parameter Categories - Start
   'Problem Appearance'
=> 'Erscheinung der Aufgaben',

   'Time Settings'
=> 'Zeitfenster',

   'High Level Randomization'
=> 'Übergreifende Randomisierung',

   'Hiding'
=> 'Verbergen',

   'Behaviour of Input Fields'
=> 'Verhalten der Eingabefelder',

   'Slots'
=> 'Slots',

   'File Submission'
=> 'Datei-Einreichungen',
# Resource Parameters Categories - End

   'New LON-CAPA [_1] ID: [_2]'
=> 'Neue LON-CAPA-[_1]-ID: [_2]',

   'Not available'
=> 'Nicht verfügbar',

   'Post Announcement'
=> 'Bekanntmachung absenden',

   'The folder name: "[_1]" is already in use for an existing folder.'
=> 'Der Verzeichnisname "[_1]" ist bereits in einem bestehendem Verzeichnis in Verwendung.',

   'The folder name: "[_1]" is already used for one of the folders automatically generated by the system.'
=> 'Der Verzeichnisname "[_1]" ist bereits in einem automatisch vom System erstellten Verzeichnis in Verwendung.',

   'Error - could not obtain lock on message folders record.'
=> 'Fehler: Sperrung des Nachrichtenverzeichnis-Datensatzes war nicht möglich.',

   'The folder "[_1]" may not be deleted'
=> 'Das Verzeichnis "[_1]" kann nicht gelöscht werden',

   'The folder "[_1]" may not be deleted.'
=> 'Das Verzeichnis "[_1]" kann nicht gelöscht werden.',

   'The folder "[_1]" does not exist so deletion is not required.'
=> 'Das Verzeichnis "[_1]" existiert nicht und braucht daher nicht gelöscht zu werden.',

   'The folder "[_1]" contains messages so it may not be deleted.'
=> 'Das Verzeichnis "[_1]" enthält Nachrichten und kann daher nicht gelöscht werden.',

   'Delete or move the messages to a different folder first.'
=> 'Löschen oder verschieben Sie die Nachrichten zunächst in ein anderes Verzeichnis.',

   'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is an invalid name.'
=> 'Das Verzeichnis "[_1]" kann nicht in "[_2]" umbenannt werden, da der neue Name ungültig ist.',

   'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is reserved for folders provided automatically by the system.'
=> 'Das Verzeichnis "[_1]" kann nicht in "[_2]" umbenannt werden, da der neue Name für Verzeichnisse reserviert ist, die automatisch vom System angeboten werden.',

   'The folder "[_1]" may not be renamed to "[_2]" because the new name you requested is already being used for an existing folder.'
=> 'Das Verzeichnis "[_1]" kann nicht in "[_2]" umbenannt werden, da der neue Name bereits für ein bestehendes Verzeichnis verwendet wird.',

   'The folder "[_1]" could not be renamed to "[_2]" because the folder does not exist.'
=> 'Das Verzeichnis "[_1]" kann nicht in "[_2]" umbenannt werden, da das Verzeichnis "[_1]" nicht existiert.',

   'Warning: failed to release lock for counter'
=> 'Achtung: Die Sperre für den Zähler konnte nicht freigegeben werden.',

   'Warning: failed to release lock for folder: [_1].'
=> 'Achtung: Die Sperre für das Verzeichnis [_1] konnte nicht freigegeben werden.',

   'Error uploading new folder.'
=> 'Fehler beim Hochladen des neuen Verzeichnisses.',

   'Error uploading IMS package'
=> 'Fehler beim Hochladen des IMS-Pakets',

   'Error reading contents of parent folder.'
=> 'Fehler beim Lesen der Inhalte des übergeordneten Verzeichnisses.',

   'Error saving updated parent folder.'
=> 'Fehler beim Speichern des aktualisierten übergeordneten Verzeichnisses.',

   'Parameters not set for [_1] because the resource was not recognized as part of the course.'
=> 'Die Parameter für [_1] wurden nicht gesetzt, da die Ressource nicht als Teil des Kurses erkannt wurde.',

   'Parameters not set for [_1] because the resource was not recognized as part of the community.'
=> 'Die Parameter für [_1] wurden nicht gesetzt, da die Ressource nicht als Teil der Community erkannt wurde.',

   'Message not moved, Attempted to move message to the same folder as it already is in.'
=> 'Die Nachricht wurde nicht verschoben, da sie in das gleiche Verzeichnis verschoben werden sollte, in dem sie sich bereits befindet.',

   'Message not moved, A network error occurred.'
=> 'Die Nachricht wurde nicht verschoben, da ein Netzwerkfehler aufgetreten ist.',

   'Message not moved as the message is no longer in the source folder.'
=> 'Die Nachricht wurde nicht verschoben, da sie sich nicht mehr im Quellverzeichnis befindet.',

   'Message copied to new folder but status was not, A network error occurred.'
=> 'Die Nachricht wurde in das neue Verzeichnis kopiert, deren Status allerdings nicht, da ein Netzwerkproblem aufgetreten ist.',

   'Message copied, but unable to delete the original from the source folder.'
=> 'Die Nachricht wurde kopiert, allerdings konnte das Original im Quellverzeichnis nicht entfernt werden.',

   'Message copied, but unable to delete the original status from the source folder.'
=> 'Die Nachricht wurde kopiert, allerdings konnte der Originalstatus im Quellverzeichnis nicht entfernt werden.',

   'Error: you must have a course role selected to be able to send a broadcast message to a group in the course.'
=> 'Fehler: Sie müssen zunächst eine Kursrolle auswählen, um Broadcast-Nachrichten an eine Kursgruppe senden zu können.',

   'Error: could not determine domain or number of course'
=> 'Fehler: Weder die Domäne noch die Nummer des Kurses konnte ermittelt werden',

   'Select message recipients from the group members listed below.'
=> 'Wählen Sie Nachrichtenempfänger von der unten angegebenen Liste der Gruppenmitglieder.',

   'Send another e-mail'
=> 'Eine weitere E-Mail schicken',

   'Send another group message'
=> 'Eine weitere Gruppen-Nachricht schicken',

   'Return to group page'
=> 'Zurück zur Gruppenseite',

   'You have to confirm that you have received this message before you can view other pages. After confirmation, this message will be moved to your regular inbox'
=> 'Sie müssen bestätigen, dass Sie diese Nachricht empfangen haben, bevor Sie Zugriff auf andere Seiten erhalten. Nach der Bestätigung wird diese Nachricht in Ihren Posteingang verschoben.',

   '[quant,_1,message is, messages are] not viewable because display of LON-CAPA messages sent to you by other students between [_2] and [_3] is currently being blocked because of online exams.'
=> '[quant,_1,Nachricht ist, Nachrichten sind] nicht sichtbar, da die Anzeige von an Sie von anderen Studierenden gesendeten LON-CAPA-Nachrichten zwischen [_2] und [_3] derzeit aufgrund von Online-Prüfungen gesperrt ist.',

   'Each of the[_1] [quant,_2,message] [_3]you checked will be forwarded to the recipient(s) you select below.'
=> 'Jede der[_1] [quant,_2,Nachricht,Nachrichten], [_3]die Sie ausgewählt haben, wird an die Empfänger weitergeleitet, die Sie unten auswählen.',

   'The message you checked will be forwarded to the recipient(s) you select below.'
=> 'Die Nachricht, die Sie ausgewählt haben, wird an die Empfänger weitergeleitet, die Sie unten auswählen.',

   'Send Reply to Messages'
=> 'Antwort auf Nachrichten absenden',

   'Send Reply to Message'
=> 'Antwort auf Nachricht absenden',

   'Forward Messages'
=> 'Nachrichten weiterleiten',

   'Forward Message'
=> 'Nachricht weiterleiten',

   'Save message for re-use'
=> 'Nachricht zur Wiederverwendung speichern',

   'Show re-usable messages'
=> 'Wiederverwendbare Nachrichten anzeigen',

   'This message was designated by the sender not to allow replies.'
=> 'Der Absender dieser Nachricht hat festgelegt, dass auf diese Nachricht nicht geantwortet werden kann.',

   'The sender did not designate a reply to address for this message.'
=> 'Der Absender hat keine Antwortadresse für diese Nachricht festgelegt.',

   'Reply to other recipients'
=> 'Antwort an weitere Empfänger',

   'Unless you choose otherwise:'
=> 'Sofern Sie nichts anderes auswählen, werden folgende Einstellungen verwendet:',

   "The subject in each forwarded message will be [_1]'Forwarding:'[_2] followed by the original subject."
=> "Der Betreff in jeder weitergeleiteten Nachricht wird [_1]'Weiterleitung:'[_2] sein, gefolgt vom ursprünglichen Betreff.",

   'original subject'
=> 'ursprünglicher Betreff',

   "sender's name"
=> "Name des Absenders",

   'Message begins with:'
=> 'Nachricht beginnt mit:',

   'Any new text to display before the text of the original messages:'
=> 'Beliebiger neuer Text, der vor dem Text der Originalnachricht angezeigt werden soll:',

   'username1:domain1: text'
=> 'Benutzerkennung1:Domäne1: Text',

   'username2:domain2: text'
=> 'Benutzerkennung2:Domäne2: Text',

   'username3:domain3: text'
=> 'Benutzerkennung3:Domäne3: Text',

   'username3:domain1: text'
=> 'Benutzerkennung3:Domäne1:Text',

   'The messages will be assembled from all lines with the respective [_1][_2]username:domain[_3], and appended to the general message text.'
=> 'Die Nachrichten werden aus allen Zeilen des jeweiligen Benutzers[_1][_2]Benuterzname:Domäne[_3] zusammengestellt und zum allgemeinen Nachrichtentext hinzugefügt.',

   'Not allowed'
=> 'Nicht zulässig',

   'Archived Message'
=> 'Archivierte Nachrichten',

   '[quant,_1,communication blocking period was,communication blocking periods were] removed.'
=> '[quant,_1,Kommunikationssperr-Zeitraum wurde,Kommunikationssperr-Zeiträume wurden] entfernt.',

   '[quant,_1,communication blocking period was,communication blocking periods were] modified.'
=> '[quant,_1,Kommunikationssperr-Zeitraum wurde,Kommunikationssperr-Zeiträume wurden] geändert.',

   '[quant,_1,communication blocking period was,communication blocking periods were] added.'
=> '[quant,_1,Kommunikationssperr-Zeitraum wurde,Kommunikationssperr-Zeiträume wurden] hinzugefügt.',

   'You attempted to display a message that is currently blocked because you are enrolled in one or more courses for which there is an ongoing online exam.'
=> 'Sie haben versucht eine Nachricht anzuzeigen, die derzeit gesperrt ist, da Sie einen oder mehre Kurse belegen, in denen eine Online-Prüfung stattfindet.',

   'Reply To'
=> 'Antwort an',

   'Current attempts of student (if applicable)'
=> 'Derzeitige Versuche des/der Studenten/in (falls verfügbar)',

   'Current screen output (if applicable)'
=> 'Derzeitige Bildschirmausgabe (falls verfügbar)',

   'No saved comments yet.'
=> 'Bisher keine gespeicherten Kommentare.',

   'No saved comments yet for this resource.'
=> 'Bisher keine gespeicherten Kommentare für diese Ressource.',

   'Could not deliver message'
=> 'Nachricht konnte nicht zugestellt werden.',

   'Please use the browser "Back" button and correct the recipient addresses ([_1]).'
=> 'Bitte verwenden Sie den Zurück-Button des Webbrowsers und korrigieren Sie die Empfängeradressen ([_1]).',

   'Failed to delete the message.'
=> 'Löschen der Nachricht ist fehlgeschlagen.',

   'Marked [quant,_1,message] read'
=> '[quant,_1,Nachricht,Nachrichten] als gelesen markiert',

   'Marked [quant,_1,message] unread'
=> '[quant,_1,Nachricht,Nachrichten] als ungelesen markiert',

   'Destination folder [_1] is not a valid folder'
=> 'Bei dem Zielverzeichnis [_1] handelt es sich um kein gültiges Verzeichnis.',

   'Failed to move [quant,_1,message]'
=> '[quant,_1,Nachricht konnte,Nachrichten konnten] nicht verschoben werden.',

   'Moved [quant,_1,message]'
=> '[quant,_1,Nachricht wurde,Nachrichten wurden] verschoben.',

   'Failed to delete [quant,_1,message]'
=> '[quant,_1,Nachricht konnte,Nachrichten konnten] nicht gelöscht werden.',

   'Deleted [quant,_1,message]'
=> '[quant,_1,Nachricht wurde,Nachrichten wurden] gelöscht.',

   '[quant,_1,message] forwarded.'
=> '[quant,_1,Nachricht,Nachrichten] weitergeleitet.',

   'Could not forward [quant,_1,message].'
=> '[quant,_1,Nachricht,Nachrichten] konnte nicht nicht weitergeleitet werden.',

   'Could not deliver forwarded message.'
=> 'Weitergeleitete Nachricht konnte nicht zugestellt werden.',

   'The recipient addresses may need to be corrected'
=> 'Die Empfängeradressen müssen korrigiert werden',

   'Folder "[_1]" created.'
=> 'Das Verzeichnis "[_1]" wurde angelegt.',

   'Creation failed.'
=> 'Anlegen fehlgeschlagen.',

   'Folder "[_1]" deleted.'
=> 'Das Verzeichnis "[_1]" wurde gelöscht.',

   'Deletion failed.'
=> 'Löschen fehlgeschlagen.',

   'Folder "[_1]" renamed to "[_2]".'
=> 'Das Verzeichnis "[_1]" wurde umbenannt in "[_2]".',

   'Renaming failed.'
=> 'Umbenennen fehlgeschlagen.',

   'Messages'
=> 'Nachrichten',

   'Distribute from Uploaded File'
=> 'Hochgeladene Datei verteilen', # ???

   'Communication Blocking'
=> 'Kommunikationssperre',

   'Communication blocking during scheduled exams'
=> 'Kommunikationssperre während zeitgebundener Prüfungen',

   'Modify existing communication blocking periods'
=> 'Bestehende Kommunikationssperren ändern',

   'No communication blocks currently saved'
=> 'Derzeit sind keine Sperren eingerichtet.',

   'Duration'
=> 'Dauer',

   'Event'
=> 'Veranstaltung',

   'Blocked?'
=> 'Gesperrt wird...',

   'Add block'
=> 'Sperre hinzufügen',

   'e.g., Exam 1'
=> '(z.B. Eingangstest)',

   'Discussion'
=> 'Diskussionsforen',

   'The following changes were made'
=> 'Folgende Änderungen wurden vorgenommen:',

   'Add new communication blocking periods'
=> 'Neue Kommunikationssperre hinzufügen',

   'Set by'
=> 'Ersteller',

   'Deleted Message'
=> 'Gelöschte Nachrichten',

   'Marked Messages Read'
=> 'Nachrichten als gelesen gekennzeichnet',

   'Marked Messages Unread'
=> 'Nachrichten als ungelesen gekennzeichnet',

   'Moved Messages'
=> 'Nachrichten verschoben',

   'Deleted Messages'
=> 'Nachrichten gelöscht',

   'Marked Message as Unread'
=> 'Nachrichten als ungelesen gekennzeichnet',

   'Deleted Folder'
=> 'Verzeichnis gelöscht',

   'Renamed Folder'
=> 'Verzeichnis umbenannt',

   'username:domain,username:domain,...'
=> 'Benutzerkennung:Domäne,Benutzerkennung:Domäne,...',

   'All courses'
=> 'Alle Kurse',

   'All communities'
=> 'Alle Communitys',

   'Pick specific course(s):'
=> 'Bestimmte(n) Kurs(e) auswählen:',

   'Pick specific communities:'
=> 'Bestimmte Communitys auswählen:',

   'Search for a course in the [_1] domain'
=> 'Kurs-Suche in der Domäne [_1]',

   'Search for a community in the [_1] domain'
=> 'Community-Suche in der Domäne [_1]',

   'Actions available after searching for a course:'
=> 'Verfügbare Aktionen nach der Suche eines Kurses:',

   'Actions available after searching for a community:'
=> 'Verfügbare Aktionen nach der Suche einer Community:',

   'Although almost all course settings can be modified by a [_1], a number of settings exist which only a [_2] may change:'
=> 'Der [_1] kann beinahe alle Kurs-Einstellungen vornehmen. Einige Einstellungen darf jedoch nur ein [_2] ändern:',

   "Certain settings which control auto-enrollment of students from your institution's student information system."
=> "Bestimmte Einstellungen, die die automatische Kursbelegung für Studierende steuern",

   'The total disk space allocated for storage of portfolio files in all groups in a course.'
=> 'Der Gesamtspeicherplatz für die Portfolio-Dateien aller Gruppen im Kurs',

   'Total disk space allocated for storage of portfolio files in all groups in a community.'
=> 'Gesamtspeicherplatz für die Portfolio-Dateien aller Gruppen in der Community.',

   'Total disk space allocated for storage of portfolio files in all groups in a course.'
=> 'Gesamtspeicherplatz für die Portfolio-Dateien aller Gruppen im Kurs.',

   'No existing sections'
=> '(Keine Sektionen vorhanden)',

   'Broadcast e-mail to users'
=> 'Broadcast-E-Mail an Benutzer',

   'Broadcast E-mail'
=> 'Broadcast-E-Mail',

   'Broadcast e-mail to Domain'
=> 'Broadcast-E-Mail an Domäne',

   'Send e-mail to selected users'
=> 'E-Mail an ausgewählte Benutzer senden',

   'Send a new e-mail to selected users from this domain'
=> 'Senden einer E-Mail an ausgewählte Benutzer dieser Domäne',

   'Display sent e-mails'
=> 'Anzeige gesendeter E-Mails',

   'Display e-mail sent by Domain Coordinators in this domain'
=> 'Anzeige von Domänen-Koordinatoren gesendeter E-Mails in dieser Domäne',

   'Select Audience'
=> 'Empfängerkreis auswählen',

   'Choose e-mail audience'
=> 'Empfängerkreis auswählen',

   'Roles:'
=> 'Rollen:',

   'Courses:'
=> 'Kurse:',

   '[_1] selected.'
=> '[_1] ausgewählt',

   'Access status:'
=> 'Zugriffsstatus:',

   'Access status'
=> 'Zugriffsstatus',

   'Username -> E-mail conversion:'
=> 'Benutzerkennung -> E-Mail-Konvertierung:',

   'Building valid e-mail address from username, if missing from preferences:'
=> 'Erstellung einer gültigen E-Mail-Adresse aus der Benutzerkennung, falls Voreinstellungen fehlen:',

   'Kerberos: enter default for each realm used in the domain, with comma separation of entries'
=> 'Kerberos: Geben Sie die Voreinstellung für jeden Bereich in der Domäne ein, getrennt durch Kommata',

   '(e.g., MSU.EDU=msu.edu, MSUE.EDU=msue.msu.edu).'
=> '(z.B. MSU.EDU=msu.edu, MSUE.EDU=msue.msu.edu).',

   'Internal, Filesystem and Local authentication: enter single default.'
=> 'LON-CAPA-interne, Dateisystem- oder lokale Authentifizierung: Geben Sie eine einzelne Voreinstellung ein.',

   'Authentication Method'
=> 'Authentifizierungsmethode',

   'Username -> e-mail conversion'
=> 'Benutzerkennung -> E-Mail-Konvertierung',

   'Username -> E-mail conversion'
=> 'Benutzerkennung -> E-Mail-Konvertierung',

   'Internal (LON-CAPA)'
=> 'LON-CAPA-intern',

   'username@'
=> 'Benutzerkennung@',

   'Local/Customized'
=> 'Lokal/benutzerdefiniert',

   'Filesystem (UNIX)'
=> 'Dateisystem (UNIX)',

   'Compose E-mail'
=> 'E-Mail erstellen',

   'No recipients identified'
=> 'Keine Empfänger gefunden',

   'Broadcast e-mail display options'
=> 'Anzeigeoptionen für Broadcast-E-Mail',

   'Date range:'
=> 'Zeitraum:',

   'Date range'
=> 'Zeitraum',

   'Earliest to display:'
=> 'Frühester Zeitpunkt:',

   'Latest to display:'
=> 'Spätester Zeitpunkt:',

   'Choose sender(s):'
=> 'Auswahl des/der Sender:',

   'Choose sender(s)'
=> 'Auswahl des/der Sender',

   'Display e-mail'
=> 'E-Mail anzeigen',

   'E-mail display'
=> 'E-Mail-Anzeige',

   'Display Broadcast e-mail'
=> 'Anzeige Broadcast-E-Mail',

   'No mail sent matching supplied criteria'
=> 'Es wurde keine E-Mail gesendet, auf die die Suchkriterien zutreffen.',

   'No mail sent - no recipients identified'
=> 'Es wurde keine E-Mail gesendet, denn es konnten keine Empfänger gefunden werden.',

   'Custom role defined by [_1].'
=> 'Benutzerdefinierte Rolle, festgelegt durch [_1]',

   'Custom role [_1][_2]defined by [_3]' # _2: <br />
=> 'Benutzerdefinierte Rolle [_1][_2]festgelegt durch [_3]',

   'Customrole [_1][_2]defined by [_3]' # _2: <br />
=> 'Benutzerdefinierte Rolle [_1][_2]festgelegt durch [_3]',

   'No students found.'
=> 'Keine Studierenden gefunden.',

   'Spreadsheet'
=> 'Beurteilungsbogen',

   'Spreadsheets'
=> 'Beurteilungsbögen',

   'Spreadsheet Help'
=> 'Hilfe zu Beurteilungsbögen',

   'Editing Help'
=> 'Eingabehilfe',

   'Help on printing'
=> 'Hilfe zum Drucken',

   'Metadata Diffs'
=> 'Metadaten-Unterschiede',

   'Retrieve Metadata'
=> 'Alte Metadaten wiederherstellen',

   'Enter course'
=> 'Kurs betreten',

   'Enter Course'
=> 'Kurs betreten',

   'Enter Access Key to Unlock this Course'
=> 'Eingabe des Zugriffsschlüssels zum Entsperren des Kurses',

   'Verifying Access Key to Unlock this Course'
=> 'Überprüfung des Zugriffsschlüssels, um Kurs zu entsperren',

   'Successfully registered key'
=> 'Schlüssel erfolgreich registriert',

   'Re-Enter Key'
=> 'Schlüssel erneut eingeben',

   'Assigned from [_1] at [_2] for [_3]'
=> 'Zugewiesen am [_2] von [_1] an [_3]',

   'Total Matches'
=> 'Gesamtanzahl Treffer',

   'Time Remaining'
=> 'Verbleibende Zeit',

   'IMPORT'
=> 'Importieren',

   'Help on slots'
=> 'Hilfe zu Slots',

   'Help on selecting Fields'
=> 'Hilfe zur Auswahl der Felder',

   'New user accounts in [_1]'
=> 'Neue Benutzeraccounts in [_1]',

   'Student enrollment changes in [_1]'
=> 'Änderungen der studentischen Kursbelegung in [_1]',

   'The following [quant,_1,change] occurred in [_2] - [_3] as a result of the automated classlist update:'
=> 'Die [quant,_1,folgende Änderung trat,folgenden Änderungen traten] im Kurs [_2] - [_3] auf. Auslöser war der automatische Prozess zur Aktualisierung von Kursteilnehmerlisten.',

   'No institutional classlist data could be retrieved for [_1]'
=> 'Für [_1] konnte keine institutionelle Kursteilnehmerliste abgerufen werden.',

   'Not within time window for auto-enrollment in [_1]'
=> '[_1] befindet sich nicht innerhalb des Zeitfensters der automatischen Kursbelegung.',

   'Auto-enrollment not currently enabled for [_1]'
=> 'Für [_1] ist die automatische Kursbelegung derzeit nicht aktiviert.',

   'The courseID provided does not match a course in this domain.'
=> 'Die gewählte Kurs-ID gehört zu keinem Kurs in dieser Domäne.',

   'The courseID provided does not match a community in this domain.'
=> 'Die gewählte Kurs-ID gehört zu keiner Community in dieser Domäne.',

   'Not Open'
=> 'Derzeit kein Zugriff',

   "This resource currently isn't open. It will be available at [_1]."
=> "Auf diese Ressource darf momentan nicht zugegriffen werden. Sie wird ab [_1] verfügbar sein.",

   'Could not handle ambiguous resource reference'
=> 'Konnte mehrdeutige Ressourcenreferenz nicht bearbeiten',

   'The nature of the problem is unclear'
=> 'Die Fehlerursache ist unklar.',

   'Course Roster'
=> 'Kursteilnehmerliste',

   'Classlist'
=> 'Kursteilnehmerliste',

   'Display of a student-viewable course roster is not currently enabled.'
=> 'Die Anzeige der studenteneinsehbaren Kursteilnehmerliste ist derzeit deaktiviert.',

   'Student-viewable course roster'
=> 'Für Studierende einsehbare Kursteilnehmerliste',

   'Students with no section'
=> 'Studierende in keiner Sektion',

   'Students in section "[_1]"'
=> 'Studierende in Sektion "[_1]"',

   'Students in any section'
=> 'Studierende in beliebiger Sektion',

   'Only students who have opted to be listed in the roster ([_1] out of [_2] students) are shown.'
=> 'Es werden nur Studierende angezeigt, die der Auflistung in der Kursteilnehmerliste zugestimmt haben (derzeit [_1] von insgesamt [_2]).',

   'The single student without a section[_1] has opted not to be listed in the roster.'
=> 'Der/die einzelne Student/in ohne Sektionszugehörigkeit[_1] hat der Auflistung in der Kursteilnehmerliste nicht zugestimmt.',

   'The single student in the section[_1] has opted not to be listed in the roster.'
=> 'Der/die einzelne Student/in in der Sektion[_1] hat der Auflistung in der Kursteilnehmerliste nicht zugestimmt.',

   'The single student in the course[_1] has opted not to be listed in the roster.'
=> 'Der/die einzelne Student/in im Kurs[_1] hat der Auflistung in der Kursteilnehmerliste nicht zugestimmt.',

   'None of the [_1] students without a section[_2] have opted to be listed in the roster.'
=> 'Keiner der [_1] Studierenden ohne Sektionszugehörigkeit[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'None of the [_1] students in the section[_2] have opted to be listed in the roster.'
=> 'Keiner der [_1] Studierenden in der Sektion[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'None of the [_1] students in the course[_2] have opted to be listed in the roster.'
=> 'Keiner der [_1] Studierenden im Kurs[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'All [_1] students without a section[_2] have opted to be listed in the roster.'
=> 'Alle [_1] Studierenden ohne Sektionszugehörigkeit[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'All [_1] students in the section[_2] have opted to be listed in the roster.'
=> 'Alle [_1] Studierenden in der Sektion[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'All [_1] students in the course[_2] have opted to be listed in the roster.'
=> 'Alle [_1] Studierenden im Kurs[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'The single student without a section[_1] has opted to be listed in the roster.'
=> 'Der/die einzelne Student/in ohne Sektionszugehörigkeit[_1] hat der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'The single student in the section[_1] has opted to be listed in the roster.'
=> 'Der/die einzelne Student/in in der Sektion[_1] hat der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'The single student in the course[_1] has opted to be listed in the roster.'
=> 'Der/die einzelne Student/in im Kurs[_1] hat der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'All [_1] students without a section[_2] are listed in the roster.'
=> 'Alle [_1] Studierenden ohne Sektionszugehörigkeit[_2] werden in der Kursteilnehmerliste aufgelistet.',

   'All [_1] students in the section[_2] are listed in the roster.'
=> 'Alle [_1] Studierenden in der Sektion[_2] werden in der Kursteilnehmerliste aufgelistet.',

   'All [_1] students in the course[_2] are listed in the roster.'
=> 'Alle [_1] Studierenden im Kurs[_2] werden in der Kursteilnehmerliste aufgelistet.',

   'There is only a single student without a section[_1]'
=> 'Es gibt nur eine/n einzelne/n Studenten/in ohne Sektionszugehörigkeit[_1].',

   'There is only a single student in the section[_1]'
=> 'Es gibt nur eine/n einzelne/n Studenten/in in der Sektion[_1].',

   'There is only a single student in the course[_1]'
=> 'Es gibt nur eine/n einzelne/n Studenten/in im Kurs[_1].',

   'There are currently no students to display.'
=> 'Derzeit gibt es keine Studierenden, die angezeigt werden könnten.',

   'Available Portfolio files'
=> 'Verfügbare Portfolio-Dateien',

   'Name not given'
=> 'Name nicht vorhanden',

   '[quant,_1,file,files,No files]'
=> '[quant,_1,Datei,Dateien,Keine Dateien]',

   'Error retrieving file information.'
=> 'Fehler beim Abrufen der Dateiinformationen',

   'Your roster setting'
=> 'Ihre Kursteilnehmerlisten-Einstellung',

   'You are currently listed in the student-viewable roster.'
=> 'Sie werden derzeit in der studierendeeinsehbaren Kursteilnehmerliste aufgelistet.',

   'You are currently [_1]not[_2] listed in the student-viewable roster.'
=> 'Sie werden derzeit [_1]nicht[_2] in der studierendeeinsehbaren Kursteilnehmerliste aufgelistet.',

   'Include yourself in the roster?'
=> 'Möchten Sie in der Kursteilnehmerliste aufgelistet werden?',

   'Display of your name in the student-viewable roster set to [_1].'
=> 'Anzeige Ihres Namens in der studierendeeinsehbaren Kursteilnehmerliste auf [_1] gesetzt.',

   'Error occurred saving display setting.'
=> 'Es ist ein Fehler beim Speichern der Anzeige-Einstellungen aufgetreten.',

   'Display of your name in the student-viewable roster unchanged (set to [_1]).'
=> 'Anzeige Ihres Namens in der studierendeeinsehbaren Kursteilnehmerliste bleibt unverändert (auf [_1] gesetzt).',

   'No student-viewable course roster settings available.'
=> 'Es sind keine Einstellungen zur studierendeeinsehbaren Kursteilnehmerliste verfügbar.',

   'You do not have rights to modify student-viewable course roster settings.'
=> 'Sie haben nicht die Berechtigung, die Einstellungen zur studierendeeinsehbaren Kursteilnehmerliste zu ändern.',

   'View course roster'
=> 'Kursteilnehmerliste',

   'Change Course Page Preferences'
=> 'Schnellzugriffsliste für Kurse',

   'Change Course Page Pref'
=> 'Schnellzugriffsliste für Kurse',

   'No context.'
=> 'Kein Kontext',

   'unable to verify variable URL'
=> 'variable URL konnte nicht überprüft werden',

   'Receipt'
=> 'Empfangsbestätigung',

   'Problems during Course Initialization'
=> 'Probleme während der Kursinitialisierung',

   'Try Selecting Again'
=> 'Auswählen erneut versuchen',

   'Invalid map: [_1]'
=> 'Ungültige Inhaltszusammenstellung: [_1]',

   'Please either [_1]close this window[_2] or [_3]log in again[_4].'
=> 'Bitte entweder [_1]dieses Fenster schließen[_2] oder [_3]erneut einloggen[_4].',

   'Thank you for using LON-CAPA.'
=> 'Vielen Dank, dass Sie LON-CAPA verwenden.',

   'You have been successfully logged out.'
=> 'Sie wurden erfolgreich abgemeldet.',

   'You can [_1]close this window[_2] now.'
=> 'Sie können [_1]dieses Fenster jetzt schließen[_2].',

   '[_1]Log in again[_2]'
=> '[_1]Erneut einloggen[_2]',

   '[_1]Log in[_2]'
=> '[_1]Einloggen[_2]',

   'No matches found in resources.'
=> 'Keine Treffer in den Ressourcen.',

   'No matches found in postings.'
=> 'Keine Treffer in den Diskussionsbeiträgen.',

   'Unable to understand the search phrase [_1]. Please modify your search.'
=> 'Der Suchbegriff [_1] kann nicht ausgewertet werden. Bitte verändern Sie Ihre Anfrage.',

   'Unable to understand the search phrase [_1]: [_2]'
=> 'Der Suchbegriff [_1] kann nicht ausgewertet werden: [_2]',

   'You did not fill in enough information for the search to be started. You need to fill in relevant fields on the search page in order for a query to be processed.'
=> 'Die Suche kann nicht durchgeführt werden, da Sie nicht genügend Daten angegeben haben. Sie müssen auf der Suchseite relevante Felder ausfüllen, damit Ihre Anfrage verarbeitet werden kann.',

   'conditionally hidden'
=> 'Bedingungsabhängig verborgen',

   'Problem Parameters'
=> 'Aufgabenparameter',

   'No group name provided.'
=> 'Es wurde kein Gruppenname angegeben.',

   'Invalid group name provided.'
=> 'Es wurde ein ungültiger Gruppenname angegeben.',

   'Invalid [_1]'
=> '[_1] ist ungültig', # ???

   '"[_1]" is not the name of a valid group in this [_2].'
=> '"[_1]" ist kein gültiger Name für ein Gruppe in dieser [_2].',

   'You do not have privileges to view the membership roster in this group.'
=> 'Sie sind nicht berechtigt, die Teilnehmerliste dieser Gruppe zu betrachten.',

   'Group membership status - [_1]'
=> 'Gruppen-Mitgliedschafts-Status: [_1]',

   'group membership status - [_1]'
=> 'Gruppen-Mitgliedschafts-Status: [_1]',

   'There are no membership data to display for this group.'
=> 'Für diese Gruppe existieren keine anzeigbaren Mitgliedsdaten.',

   'Membership status: '
=> 'Mitgliedschaftsstatus: ',

   'There are no groups to display in this [_1].'
=> 'Es gibt keine Gruppen, die in diesem [_1] angezeigt werden können.', # ??? -> grouproster.pm

   'Start Date'
=> 'Anfangsdatum',

   'End Date'
=> 'Enddatum',

   'Functionality'
=> 'Funktionalität',

   'Privileges'
=> 'Berechtigungen',

   'Any Membership status'
=> 'Beliebiger Mitgliedsstatus',

   'Active Member'
=> 'Aktives Mitglied',

   'Former Member'
=> 'Ehemaliges Mitglied',

   'Future Member'
=> 'Zukünftiges Mitglied',

   'Group Folder - [_1]'
=> 'Gruppenverzeichnis für [_1]',

   'Group homepage - [_1]'
=> 'Gruppen-Homepage für [_1]',

   'Enter the username you use to log-in to LON-CAPA'
=> 'Geben Sie die Benutzerkennung ein, die Sie zum Einloggen bei LON-CAPA verwenden.',

   'Optional file upload'
=> 'Optionales Hochladen einer Datei',

   'Warning: Problem with support e-mail address'
=> 'Achtung, es gibt Probleme mit der Support-E-Mail-Adresse.',

   'A support request has been sent to [_1]'
=> 'Es wurde eine Support-Anfrage an [_1] gesendet.',

   'Your support request contained the following information'
=> 'Ihre Support-Anfrage enthält folgende Daten',

   'Support request recorded'
=> 'Support-Anfrage wurde registriert',

   'Support request failed'
=> 'Support-Anfrage ist fehlgeschlagen',

   'The following Cc e-mail address is invalid: '
=> 'Die folgende CC-E-Mail-Adresse ist ungültig: ',

   'The following Cc e-mail addresses are invalid: '
=> 'Die folgenden CC-E-Mail-Adressen sind ungültig: ',

   'As the e-mail address provided for this LON-CAPA server ([_1]) does not appear to be a valid e-mail address, your support request has [_2]not[_3] been sent to the LON-CAPA support staff or administrator at your institution.'
=> 'Da die für diesen LON-CAPA-Server angegebene E-Mail-Adresse ([_1]) anscheinend ungültig ist, wurde Ihre Support-Anfrage weder an das LON-CAPA-Supportteam Ihrer Institution noch an den Administrator geschickt.',

   'Instead a copy has been sent to the LON-CAPA support team at Michigan State University.'
=> 'Stattdessen wurde eine Kopie an die LON-CAPA-Kundenbetreuung der Michigan State University gesendet.',

   'The uploaded screenshot file ([_1] bytes) included with your request exceeded the maximum allowed size - 128 KB, and has therefore been discarded.'
=> 'Die hochgeladene Screenshot-Datei Ihrer Anfrage hat die maximale Größe von 128 KB überschritten ([_1] Bytes) und wurde daher verworfen.',

   'An uploaded screenshot file [_1] ([_2] bytes) was included in the request sent by [_3].'
=> 'Eine hochgeladene Screenshot-Datei [_1] ([_2] Bytes) wurde der Anfrage beigefügt, die von [_3] gesendet wurde.',

   'Information supplied'
=> 'Angegebene Daten',

   'Additional information recorded'
=> 'Zusätzlich mitgeschriebene Daten',

   'File does not have [_1] or [_2] starting tag'
=> 'Die Datei hat weder ein [_1]- noch ein [_2]-Start-Tag',

   'File does not have [_1] or [_2] ending tag'
=> 'Die Datei hat weder ein [_1]- noch ein [_2]-Ende-Tag',

   'File does not have [_1] ending tag'
=> 'Die Datei hat kein [_1]-Ende-Tag',

   'Example'
=> 'Beispiel',

   'Algebraic Response Problems'
=> 'Algebraische Aufgaben',

   'Allow algebraic entry'
=> 'Algebraische Eingabe erlauben',

   'Chemistry Problems'
=> 'Chemische Aufgaben',

   'Free Form Problems'
=> 'Aufgaben mit freier Gestaltung',

   'Handgraded Problems'
=> 'Manuell bewertete Aufgaben',

   'Miscellaneous'
=> 'Verschiedenes',

   'Multiple Choice Problems'
=> 'Auswahl-Aufgaben',

   'Numerical Problems'
=> 'Numerische Aufgaben',

   'Input-Dependent Problems'
=> 'Eingabeabhängige Aufgaben',

   'Language:'
=> 'Sprache:',

   'Math Rendering:'
=> 'Formeldarstellung:',

   'Restrict Domain Coordinator Access'
=> 'Zugriff durch Domänen-Koordinator',

   'By default, the Domain Coordinator can enter your Authoring Space.'
=> 'Die Voreinstellung erlaubt dem Domänen-Koordinator, Ihren Autorenbereich betreten zu können.',

   'Block access to Authoring Space'
=> 'Zugriff auf Autorenbereich verwehren',

   'jsMath'
=> 'jsMath',

   'tth (TeX to HTML)'
=> 'tth (TeX-nach-HTML)',

   'mimetex (Convert to Images)'
=> 'mimetex (in Grafik konvertieren)',

   'Raw (Screen Reader)'
=> 'Raw (Screen-Reader)',

   "It looks like you don't have the TeX math fonts installed."
=> 'Offenbar sind auf Ihrem Computer nicht die TeX-Mathematik-Zeichensätze installiert.',

   'The jsMath example on this page may not look right without them. The [_1]jsMath Home Page[_2] has information on how to download the needed fonts. In the meantime, jsMath will do the best it can with the fonts you have, but it may not be pretty and some equations may not be rendered correctly.'
=> 'Das jsMath-Beispiel auf dieser Seite könnte ohne diese Zeichensätze nicht korrekt ausschauen. Auf der [_1]jsMath-Homepage[_2] finden Sie Informationen wie man die notwendigen Zeichensätze installiert. Bis dahin versucht jsMath mit den vorhandenen Zeichensätzen eine Darstellung so gut es geht. Das Ergebnis könnte jedoch nicht sehr schön aussehen und einige Gleichungen könnten falsch gerendert werden.',

   'jsMath:'
=> 'jsMath:',

   'tth (TeX to HTML):'
=> 'tth (TeX-nach-HTML):',

   'mimetex (Convert to Images):'
=> 'mimetex (in Grafik konvertieren):',

   '[_1], [_2], or [_3]'
=> '[_1], [_2] oder [_3]',

   'internal, optional'
=> 'intern, optional',

   'user:domain,user:domain,...'
=> 'Benutzer:Domäne,Benutzer:Domäne,...',

   'user:domain,user:domain'
=> 'Benutzer:Domäne,Benutzer:Domäne',

   'user:domain,user:domain(section;section;...;*;...),...'
=> 'Benutzer:Domäne,Benutzer:Domäne(Sektion;Sektion;...;*;...),...',

   'user:domain,user:domain,*:domain'
=> 'Benutzer:Domäne,Benutzer:Domäne,*:Domäne',

   'Bcc: course members with current access'
=> 'BCC: Kursteilnehmer mit aktuellem Zugriff',

   'Course members with current access'
=> 'Kursteilnehmer mit aktuellem Zugriff',

   'Bcc: course members with expired access'
=> 'BCC: Kursteilnehmer mit abgelaufenem Zugriff',

   'Course members with expired access'
=> 'Kursteilnehmer mit abgelaufenem Zugriff',

   'Bcc: course members with future access'
=> 'BCC: Kursteilnehmer mit zukünftigem Zugriff',

   'Course members with future access'
=> 'Kursteilnehmer mit zukünftigem Zugriff',

   'Other Roles'
=> 'Weitere Rollen',

   'Select Author'
=> 'Autor auswählen',

   'Non-standard Course'
=> 'Nicht-Standard-Kurs',

   'Switch course role to...'
=> 'Kursrolle wechseln...',

   'Switch community role to...'
=> 'Community-Rolle wechseln...',

   'Message'
=> 'Nachricht',

   'Message (new)'
=> '(neue) Nachricht',

   'Time of change'
=> 'Änderungszeit',

   'active'
=> 'aktiv',

   'previous'
=> 'in der Vergangenheit liegend',

   'Access dates to apply for selected users'
=> 'Zugriffszeiten für die ausgewählten Benutzer ändern',

   'Changes in section affiliation to apply to selected users'
=> 'Sektionszugehörigkeiten für die ausgewählten Benutzer ändern',

   'For student roles changing the section, will result in a section switch as students may only be in one section of a course at a time.'
=> 'Ein Sektionswechsel bei studentischen Rollen verursacht einen Austausch der Sektion, da Studierende nur in einer einzigen Sektion eines Kurses zur gleichen Zeit sein können.',

   'For a role in a course that is not a student role, a user may have roles in more than one section of a course at a time.'
=> 'Benutzer mit einer Kursrolle, die keine studentische Rolle ist, können in mehr als einer Sektion in einem Kurs zur gleichen Zeit sein.',

   "Retain each user's current section affiliations?"
=> "Sollen die bisherigen Sektionszugehörigkeiten beibehalten werden?",

   '(Does not apply to student roles).'
=> '(Betrifft nicht Studierendenrollen).',

   '(Does not apply to member roles).'
=> '(Betrifft nicht Teilnehmerrollen).',

   '[_1]Show[_2] clicker id'
=> 'Clicker-ID [_1]anzeigen[_2]',

   '[_1]Hide[_2] clicker id'
=> 'Clicker-ID [_1]verbergen[_2]',

   'Catalog:'
=> 'Katalog:',

   'Main Categories'
=> 'Hauptkategorien',

   'Show subcategories'
=> 'Unterkategorien anzeigen',

   'Pick main category'
=> 'Hauptkategorie auswählen',

   'Pick subcategory'
=> 'Unterkategorie auswählen',

   '(No subcategories)'
=> '(keine Unterkategorien)',

   'Official courses (with institutional codes)'
=> 'Offizielle Kurse (mit institutionellen Codes)',

   'Official courses'
=> 'Offizielle Kurse',

   'with institutional codes'
=> 'mit institutionellen Codes',

   'Self-enroll (if permitted)'
=> 'Selbsteintragung (falls zugelassen)',

   'No ending date'
=> 'Kein Enddatum',

   'From:[_1]'
=> 'Start:[_1]',

   'To:[_1]'
=> 'Ende:[_1]',

   'Starts: [_1]'
=> 'Start: [_1]',

   'Ends: [_1]'
=> 'Ende: [_1]',

   'Ended: [_1]'
=> 'Endete: [_1]',

   'Currently enabled'
=> 'Derzeit aktiviert',

   '[quant,_1,section:,sections:,No sections]'
=> '[quant,_1,Sektion:,Sektionen:,Keine Sektionen]',

   '[quant,_1,section,sections,No sections]'
=> '[quant,_1,Sektion,Sektionen,Keine Sektionen]',

   'No information available for [_1].'
=> 'Für "[_1]" sind keine Informationen verfügbar.',

   'Self-enrollers:'
=> 'Selbsteintragungen:',

   'Choices:'
=> 'Auswahlmöglichkeiten:',

   'Choices: '
=> 'Auswahlmöglichkeiten: ',

   'Configure User Self-enrollment'
=> 'Selbsteintragung konfigurieren',

   'View Change Logs'
=> 'Änderungsprotokoll', # long version: Änderungsprotokoll betrachten

   'View Log-in History'
=> 'Anmeldehistorie', # longversion: Anmeldehistorie betrachten

   'Configure Self-enrollment'
=> 'Selbsteintragung konfigurieren',

   'Self-enrollment with a student role'
=> 'Selbsteintragungen mit studentischer Rolle',

   'Users allowed to self-enroll'
=> 'Zugelassene Benutzer, die sich selbst eintragen dürfen',

   'Users allowed to self-enroll in this course'
=> 'Zugelassene Benutzer, die sich in den Kurs selbst eintragen dürfen',

   'Any user in any domain:'
=> 'Beliebige Nutzer in beliebiger Domäne',

   'User types:'
=> 'Benutzertypen',

   'any'
=> 'beliebig',

   'Any Users'
=> 'Beliebige Benutzer',

   'Any users'
=> 'Beliebige Benutzer',

   'Others'
=> 'Andere',

   'Additional domain:'
=> 'Zusätzliche Domäne:',

   'Users in additional domain:'
=> 'Benutzer in zusätzlicher Domäne:',

   'Specific domain:'
=> 'Bestimmte Domäne:',

   'Users in specific domain:'
=> 'Benutzer in bestimmter Domäne:',

   'Other domain:'
=> 'Andere Domäne:',

   'Users in other domain:'
=> 'Benutzer in anderer Domäne:',

   'Any user in additional domain:'
=> 'Beliebiger Benutzer in zusätzlicher Domäne:',

   'Any user in domain:'
=> 'Beliebiger Benutzer in dieser Domäne:',

   'Any user in other domain:'
=> 'Beliebiger Benutzer in anderer Domäne:',

   'Any user in specific domain:'
=> 'Beliebiger Benutzer in bestimmter Domäne:',

   'Restrict self-enrollment to students officially registered for the course'
=> 'Selbsteintragung auf für diesen Kurs offiziell registrierte Studierende beschränken',

   'Dates self-enrollment available'
=> 'Zeitraum für Selbsteintragung',

   'Starts'
=> 'Startet',

   'Ends'
=> 'Endet',

   'Course access dates assigned to self-enrolling users'
=> 'Kurszugriffszeiten für selbsteintragende Benutzer',

   'Section assigned to self-enrolling users'
=> 'Den selbsteintragenden Benutzern zuzuweisende Sektion',

   'The following changes were made to self-enrollment settings:'
=> 'Folgende Änderungen wurden an den Einstellungen zur Selbsteintragung vorgenommen:',

   '[_1]: "[_2]" set to "[_3]".'
=> '[_1]: "[_2]" geändert. Neuer Wert: "[_3]".',

   '"[_1]" set to "[_2]".'
=> '"[_1]" geändert. Neuer Wert: "[_2]".',

   'No changes were made to the existing self-enrollment settings in this course.'
=> 'An den Einstellungen zur Selbsteintragung für diesen Kurs wurden keine Änderungen vorgenommen.',

   'Self-enrollment result'
=> 'Ergebnis Selbsteintragung',

   'Enroll in course'
=> 'Diesen Kurs belegen',

   'Sections:'
=> 'Sektionen:',

   'Self-enroll in course'
=> 'Kurse selbst belegen',

   'Self-enroll in a LON-CAPA course'
=> 'Selbsteintragung in einen LON-CAPA-Kurs',

   'Self-enroll'
=> 'Selbsteintragung',

   'Self-enroll in [_1]'
=> 'Selbsteintragung in [_1]',

   'Self-enrollment error'
=> 'Fehler bei der Selbsteintragung',

   'Invalid domain or course number'
=> 'Ungültige Domäne oder Kursnummer',

   'Self-enrollment unavailable'
=> 'Selbsteintragung nicht verfügbar',

   'Self-enrollment is restricted to students officially registered for this course.'
=> 'Die Selbsteintragung ist auf Studierende begrenzt, die offiziell für diesen Kurs registriert sind.',

   'Self-enrollment is not currently available for this course.'
=> 'Die Selbsteintragung ist für diesen Kurs derzeit nicht verfügbar.',

   'Self-enrollment is not currently available in this course'
=> 'Die Selbsteintragung ist für diesen Kurs derzeit nicht verfügbar.',

   'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users.'
=> 'Die Selbsteintragung wird am [_1] für alle LON-CAPA-Nutzer verfügbar werden.',

   'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users at your institution ([_2]).'
=> 'Die Selbsteintragung wird am [_1] für alle LON-CAPA-Nutzer Ihrer Einrichtung ([_2]) verfügbar werden.',

   'Self-enrollment will become available starting [_1]; please enroll at that time.'
=> 'Die Selbsteintragung wird am [_1] verfügbar werden. Bitte tragen Sie sich ab dann selbst ein.',

   'Although self-enrollment will become available starting [_1], you are ineligible for enrollment.'
=> 'Die Selbsteintragung wird zwar am [_1] verfügbar werden, Ihnen ist es allerdings nicht gestattet sich selbst einzutragen.',

   'Self-enrollment will become available starting [_1].'
=> 'Die Selbsteintragung wird am [_1] verfügbar werden.',

   'Self-enrollment ends: [_1]'
=> 'Selbsteintragung endet: [_1]',

   'Available permanently'
=> 'dauerhaft verfügbar',

   'No courses'
=> 'Keine Kurse',

   'The link to the requested page could not be followed.'
=> 'Der Link zu der angeforderten Seite konnte nicht aufgerufen werden.',

   'The placeholder for the courseID is absent.'
=> 'Der Platzhalter für die Kurs-ID ist fehlt.',

   'LON-CAPA account required'
=> 'LON-CAPA-Account notwendig',

   'You need to be logged into LON-CAPA to self-enroll in a course.'
=> 'Sie müssen in LON-CAPA angemeldet sein, um sich in diesen Kurs selbst eintragen zu können.',

   'If you have an account in LON-CAPA, [_1]log-in[_2].'
=> 'Falls Sie einen LON-CAPA-Account haben, [_1]melden Sie sich bitte an[_2].',

   'Otherwise:'
=> 'Ansonsten:',

   "if you have an institutional log-in, use your institution's [_1]single sign on page[_2] to log-in, then create an account"
=> "Falls Sie einen Benutzeraccount Ihrer Einrichtung haben, verwenden Sie Ihre institutionelle [_1]Single-Sign-On-Seite[_2], um sich anzumelden. Erstellen Sie dann einen Account",

   'if you have an institutional login, [_1]create an account[_2]'
=> 'Falls Sie einen Benutzeraccount Ihrer Einrichtung haben, [_1]erstellen Sie einen Account[_2]',

   'you can use an e-mail address to [_1]create an account[_2]'
=> 'Sie können eine E-Mail-Adresse verwenden, um [_1]einen Account zu erstellen[_2]',

   'Otherwise, if you have an institutional login, [_1]create an account[_2].'
=> 'Falls Sie einen Benutzeraccount Ihrer Einrichtung haben, [_1]erstellen Sie einen LON-CAPA-Account[_2].',

   'Otherwise, you will use an e-mail address to [_1]create an account[_2].'
=> 'Ansonsten verwenden Sie eine E-Mail-Adresse, um [_1]einen Account zu erstellen[_2].',

   "Otherwise, use your institution's [_1]single sign on page[_2] to log-in, then create an account."
=> "Ansonsten verwenden Sie Ihre institutionelle [_1]Single-Sign-On-Seite[_2], um sich anzumelden und erstellen Sie dann einen Account.",

   'You will be able to self enroll in this course once the account has been created.'
=> 'Sie haben die Möglichkeit sich selbst in den Kurs einzutragen, nachdem der Account erzeugt wurde.',

   'You will be able to self-enroll in the course you selected ([_1]) after you have successfully logged in.'
=> 'Nachdem Sie sich erfolgreich angemeldet haben, haben Sie die Möglichkeit sich selbst in den gewählten Kurs ([_1]) einzutragen.',

   'You must [_1]log-in[_2] to LON-CAPA with an existing account to be able to enroll in this course, as account creation at this institution ([_3]) is not permitted when self-enrolling.'
=> 'Sie müssen sich in LON-CAPA mit einem bestehenden Account [_1]anmelden[_2], um sich in diesen Kurs eintragen zu können. Das Erstellen von Benutzeraccounts an dieser Einrichtung ([_3]) ist im Zuge der Selbsteintragung nicht gestattet.',

   'You already have an active student role (section: "[_1]") in this course.'
=> 'Sie haben in diesem Kurs bereits eine aktive studentische Rolle (Sektion "[_1]").',

   'You have a student role (section: "[_1]") in this course which will become active [_2].'
=> 'Sie haben in diesem Kurs (Sektion "[_1]") eine studentische Rolle, die am [_2] aktiv wird.',

   'Self-enrollment is restricted to officially registered students.'
=> 'Selbsteintragung ist auf offiziell registrierte Studierende beschränkt.',

   'As you are not currently registered for this course, self-enrollment is unavailable.'
=> 'Da Sie derzeit für diesen Kurs nicht registriert sind, ist die Selbsteintragung nicht verfügbar.',

   'The end date for access to this course for users who self-enroll has passed.'
=> 'Das Enddatum für den Zugriff auf diesen Kurs ist für Benutzer, die sich selbst eintragen können, abgelaufen.',

   'Self-enrollment in this course was successful.'
=> 'Die Selbsteintragung für diesen Kurs war erfolgreich.',

   'The start date for access to this course for users who self-enroll has yet to be reached.'
=> 'Das Anfangsdatum für den Zugriff auf diesen Kurs ist für Benutzer, die sich selbst eintragen können, noch nicht erreicht.',

   'Your new role is available immediately, and will provide access to the course until [_1].'
=> 'Ihre neue Rolle ist ab sofort verfügbar und erlaubt Ihnen bis [_1] Zugriff auf den Kurs.',

   'Enrollment process complete'
=> 'Kursbelegung abgeschlossen',

   'Enrollment incomplete'
=> 'Kursbelegung unvollständig',

   'Self-enrollment in this course failed.'
=> 'Die Selbsteintragung in diesen Kurs ist fehlgeschlagen.',

   'You are not permitted to enroll yourself in this course.'
=> 'Es ist Ihnen nicht gestattet, sich in diesen Kurs selbst einzutragen.',

   'Enter course now'
=> 'Kurs jetzt betreten',

   'other'
=> 'andere',

   'Self-enrollment in this course is available to any user affiliated with [_1].'
=> 'Die Selbsteintragung in diesen Kurs ist für beliebige Benutzer der Einrichtung "[_1]" verfügbar.',

   'Self-enrollment in this course is only available to users in affiliated with [_1] who have the following status: "[_2]".'
=> 'Die Selbsteintragung in diesen Kurs ist nur für Benutzer der Einrichtung "[_1]" verfügbar, die folgenden Status haben: "[_2]".',

   'Self-enrollment is not currently available for this course for users affiliated with [_1].'
=> 'Die Selbsteintragung in diesen Kurs ist derzeit für Benutzer der Einrichtung "[_1]" nicht zulässig.',

   'Self-enrollment in this course is only available to users affiliated with the following institutions, and who have the required status:'
=> 'Die Selbsteintragung in diesen Kurs ist nur für Benutzer der folgenden Einrichtungen verfügbar, die den erforderlichen Status haben:',

   'Self-enrollment in this course is only available to users affiliated with [_1] who have the following status: "[_2]".'
=> 'Die Selbsteintragung in diesen Kurs ist nur für Benutzer mit Zugehörigkeit zu [_1] verfügbar, die den Status "[_2]" haben.',

   'Registration status (official courses)'
=> 'Registrierungsstatus (offizielle Kurse)',

   'Your registration status could not be verified.'
=> 'Ihr Registrierungsstatus konnte nicht überprüft werden.',

   'Your registration status could not determined, because a problem occurred retrieving data.'
=> 'Ihr Registrierungsstatus konnte nicht bestimmt werden, da während des Datenabrufs ein Problem aufgetreten ist.',

   'As no institutional course sections are currently associated with this course, your registration status is undetermined.'
=> 'Da derzeit mit diesem Kurs keine institutionellen Kurssektionen verknüpft sind, ist Ihr Registrierungsstatus unbestimmt.',

   '[_1]Ad hoc[_2] roles in domain [_3]'
=> '[_1]Ad-hoc[_2]-Rollen in der Domäne [_3]',

   'Assemble resources'
=> 'Kursinhalt einrichten',

   'Create, edit, modify and publish resources'
=> 'Erstellen, Ändern und Veröffentlichen von Ressourcen',

   'Create, modify and delete course groups'
=> 'Erstellen, Ändern und Löschen von Kursgruppen',

   'View course groups'
=> 'Kursgruppen anzeigen',

   'View student activity'
=> 'Studentische Aktivitätsdaten anzeigen',

   'Show full details for each course ([_1] only)'
=> 'Alle Details für jeden Kurs zeigen (nur mit Benutzerrolle [_1] verfügbar)',

   'Show full details for each community ([_1] only)'
=> 'Alle Details für jede Community zeigen (nur mit Benutzerrolle [_1] verfügbar)',

   'Include courses set to be hidden from catalog ([_1] only)'
=> 'Auch Kurse anzeigen, die im Kursüberblick als verborgen eingestellt sind (nur mit Benutzerrolle [_1] verfügbar)',

   'Include communities set to be hidden from catalog ([_1] only)'
=> 'Auch Communitys anzeigen, die im Überblick als verborgen eingestellt sind (nur mit Benutzerrolle [_1] verfügbar)',

   'Include subcategories within "[_1]"'
=> 'Auch Unterkategorien von "[_1]" anzeigen',

   'Only show courses which allow self-enrollment'
=> 'Nur Kurse anzeigen, die Selbsteintragung ermöglichen',

   'Only show communities which allow self-enrollment'
=> 'Nur Communitys anzeigen, die Selbsteintragung ermöglichen',

   'Only show courses which currently allow self-enrollment (or will allow it in the future)'
=> 'Nur Kurse anzeigen, die derzeit Selbsteintragung ermöglichen (oder zukünftig ermöglichen werden)',

   'Only show communities which currently allow self-enrollment (or will allow it in the future)'
=> 'Nur Communitys anzeigen, die derzeit Selbsteintragung ermöglichen (oder zukünftig ermöglichen werden)',

   'include subdirectories'
=> 'Unterverzeichnisse mit einbinden',

   'force republication of previously published files'
=> 'Erneute Veröffentlichung bereits zuvor veröffentlichter Ressourcen erzwingen',

   'make file(s) obsolete'
=> 'Ressource(n) als veraltet kennzeichnen',

   'force directory level metadata over existing'
=> 'Metadaten des Verzeichnisses sollen bestehende Metadaten überschreiben',

   'Session could not be opened.'
=> 'Die Sitzung konnte nicht gestartet werden.',

   'The domain you provided is not a valid LON-CAPA domain.'
=> 'Die von Ihnen angegebene Domäne ist keine LON-CAPA-Domäne.',

   'Student Settings'
=> 'Studentische Einstellungen',

   'Coordinator Settings'
=> 'Koordinatoren-Einstellungen',

   'Author Settings'
=> 'Autoren-Einstellungen',

   'Administrator Settings'
=> 'Administratoren-Einstellungen',

   'Item'
=> 'Element',

   'Found [_1] without responses. This resource cannot be published.'
=> 'Ressource vom Typ [_1] gefunden, die keinen Antwortblock enthält. Diese Ressource kann nicht veröffentlicht werden.',

   'LON-CAPA helpdesk'
=> 'LON-CAPA-Helpdesk',

   'Create a user account in LON-CAPA'
=> 'Neuen Benutzeraccount in LON-CAPA erstellen',

   'Account creation unavailable'
=> 'Account-Erstellung nicht möglich',

   'Error creating token.'
=> 'Fehler beim Erstellen des Authentifizierungscodes.',

   'Account creation'
=> 'Account-Erstellung',

   'Creation of a new user account using an e-mail address or an institutional log-in ID as username is not permitted at this institution: ([_1]).'
=> 'Das Erstellen eines Benutzeraccounts mit einer E-Mail-Adresse oder einem Benutzeraccount Ihrer Einrichtung als Benutzerkennung ist an der Einrichtung [_1] nicht gestattet.',

   'Creation of a new user account using an e-mail address or an institutional log-in ID as username is not permitted at this institution ([_1]).'
=> 'Das Erstellen eines Benutzeraccounts mit einer E-Mail-Adresse oder einem Benutzeraccount Ihrer Einrichtung als Benutzerkennung ist an der Einrichtung [_1] nicht gestattet.',

   'Creation of a new user account using an e-mail address as username is not permitted at this LON-CAPA institution.'
=> 'Das Erstellen von neuen Benutzeraccounts mit einer E-Mail-Adresse als Benutzerkennung ist für diese Einrichtung nicht gestattet.',

   'Creation of a new LON-CAPA user account using an e-mail address or an institutional log-in ID as your username is not permitted at [_1].'
=> 'Das Erstellen eines LON-CAPA-Benutzeraccounts mit einer E-Mail-Adresse oder einem Benutzeraccount Ihrer Einrichtung als Benutzerkennung ist an der Einrichtung [_1] nicht gestattet.',

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account in this domain."
=> 'Sie wurden zwar mit Ihrer Benutzerkennung und Passwort durch das institutionelle Single-Sign-On-System korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account in dieser Domäne.',

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account at this institution, and you are not permitted to create one."
=> 'Sie wurden zwar mit Ihrer Benutzerkennung und Passwort durch das institutionelle Single-Sign-On-System korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account an dieser Einrichtung und Sie sind nicht berechtigt, einen zu erstellen.',

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account at this institution."
=> 'Sie wurden zwar mit Ihrer Benutzerkennung und Passwort durch das institutionelle Single-Sign-On-System korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account an dieser Einrichtung.',

   "Although your username and password were authenticated, you do not currently have a LON-CAPA account at this institution."
=> 'Sie wurden zwar mit Ihrer Benutzerkennung und Passwort korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account in dieser Einrichtung.',

   "Although your username and password were authenticated, you do not currently have a LON-CAPA account in this domain, and you are not permitted to create one."
=> 'Sie wurden zwar mit Ihrer Benutzerkennung und Passwort korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account in dieser Domäne und Sie sind nicht berechtigt, einen zu erstellen.',

   'A LON-CAPA account may not be created with the username you use.'
=> 'Mit der von Ihnen verwendeten Benutzerkennung kann kein LON-CAPA-Account erzeugt werden.',

   'User Information'
=> 'Benutzerdaten',

   'User information'
=> 'Benutzerdaten',

   'Review user information'
=> 'Benutzerdaten überprüfen',

   'To create one, use the table below to provide information about yourself (if appropriate), then click the "Create LON-CAPA account" button.'
=> 'Um einen zu erstellen, verwenden Sie die untenstehende Tabelle, um Ihre persönliche Daten in die leeren Felder einzutragen. Klicken Sie anschließend auf "LON-CAPA-Account erstellen".',

   'To create one, use the table below to provide information about yourself, then click the [_1]Create LON-CAPA account[_2] button.'
=> 'Um einen zu erstellen, verwenden Sie die untenstehende Tabelle, um Ihre persönliche Daten in die leeren Felder einzutragen. Klicken Sie anschließend auf [_1]LON-CAPA-Account erstellen[_2].',

   'A user account will be created with information displayed in the table below, when you click the [_1]Create LON-CAPA account[_2] button.'
=> 'Durch Klicken auf [_1]LON-CAPA-Account erstellen[_2] wird mit den unten angezeigten Daten ein Benutzeraccount erzeugt.',

   'Confirmation'
=> 'Bestätigung',

   'Confirm that you wish to create an account.'
=> 'Bitte bestätigen Sie, dass Sie einen Account erstellen möchten.',

   'New username'
=> 'Neue Benutzerkennung',

   'Create account'
=> 'Account anlegen',

   'You must enter a password'
=> 'Sie müssen ein Passwort angeben.',

   'The passwords you entered did not match.'
=> 'Die eingegebenen Passwörter stimmen nicht überein.',

   'Create account with a username provided by this institution'
=> 'Erstellen eines LON-CAPA-Accounts mit einem Benutzeraccount dieser Einrichtung',

   'If you already have a log-in ID at this institution [_1]you may be able to use it for LON-CAPA.'
=> 'Falls Sie bereits einen Benutzeraccount dieser Einrichtung haben,[_1]können Sie diesen gegebenenfalls für LON-CAPA verwenden.',

   'Type in your log-in ID and password to find out.'
=> 'Geben Sie Ihren Benutzeraccount Ihrer Einrichtung und Ihr Passwort ein, um dies herauszufinden.',

   'Log-in ID'
=> 'Benutzeraccount Ihrer Einrichtung',

   'Create account with an e-mail address as your username'
=> 'Erstellen eines Benutzeraccounts mit einer E-Mail-Adresse als Benutzerkennung',

   'Provide your e-mail address to request a LON-CAPA account,[_1] if you do not have a log-in ID at your institution.'
=> 'Geben Sie Ihre E-Mail-Adresse an, um einen LON-CAPA-Account zu beantragen,[_1] falls Sie keinen Benutzeraccount Ihrer Einrichtung haben.',

   'Request LON-CAPA account'
=> 'LON-CAPA-Account anfordern',

   'Validation'
=> 'Gültigkeitsprüfung',

   'Thank you for your request to create a new LON-CAPA account.'
=> 'Vielen Dank für Ihren Antrag auf Erstellung eines neuen LON-CAPA-Accounts.',

   'A request was submitted on [_1] for creation of a LON-CAPA account at the following institution:[_2].'
=> 'Ein Antrag auf Erstellung eines LON-CAPA-Accounts wurde am [_1] für die Einrichtung [_2] abgeschickt.',

   'A request was submitted on [_1] for creation of a LON-CAPA account at the following institution: [_2].'
=> 'Ein Antrag auf Erstellung eines LON-CAPA-Accounts wurde am [_1] für die Einrichtung [_2] abgeschickt.',

   'To complete this process please open a web browser and enter the following URL in the address/location box: [_1]'
=> 'Um den Vorgang abzuschließen, öffnen Sie bitte einen Webbrowser und geben Sie folgende URL in die Adresszeile ein: [_1]',

   'A message has been sent to the e-mail address you provided.'
=> 'An die von Ihnen angegebene E-Mail-Adresse wurde eine Nachricht geschickt.',

   'The message includes the web address for the link you will use to complete the account creation process.'
=> 'Die Nachricht enthält einen Link, mit dem Sie den Erstellungsvorgang Ihres Accounts abschließen können.',

   'An e-mail sent to the e-mail address associated with your LON-CAPA account includes the web address for the link you should use to complete the reset process.'
=> 'Die E-Mail, die an Ihre mit dem LON-CAPA-Account verknüpfte E-Mail-Adresse geschickt wurde, enthält den Link, den Sie zum Abschließen des Vorgangs benötigen.',

   'The link included in the message will be valid for the next [_1]two[_2] hours.'
=> 'Der Link wird für die nächsten [_1]zwei[_2] Stunden gültig sein.',

   'An error occurred when sending a message to the e-mail address you provided.'
=> 'Beim Verschicken Ihrer Nachricht an die von Ihnen angegebene E-Mail-Adresse ist ein Fehler aufgetreten.',

   'An error occurred when sending a message to the e-mail address associated with your LON-CAPA account.'
=> 'Beim Verschicken Ihrer Nachricht an die von Ihnen angegebene E-Mail-Adresse ist ein Fehler aufgetreten.',

   'An error occurred creating a token required for the account creation process.'
=> 'Beim Erstellen des Authentifizierungscodes, der für den Erstellungsvorgang des Accounts notwendig ist, ist ein Fehler aufgetreten.',

   'An error occurred creating a token required for the password reset process.'
=> 'Beim Erstellen des Authentifizierungscodes, der für den Passwortzurücksetzungsvorgang notwendig ist, ist ein Fehler aufgetreten.',

   'Please contact the [_1] ([_2]) for assistance.'
=> 'Nehmen Sie zur Klärung bitte mit [_1] ([_2]) Kontakt auf.',

   'Sorry, the token generated when you requested creation of an account has expired.'
=> 'Der Authentifizierungscode, der bei Ihrem Antrag auf Erstellung des Accounts erstellt wurde, ist nicht mehr gültig.',

   'Sorry, the URL generated when you requested creation of an account contained incomplete information.'
=> 'Die URL, die bei Ihrem Antrag auf Erstellung des Accounts erstellt wurde, enthält unvollständige Daten.',

   'Please submit a [_1]new request[_2] for account creation and follow the new link included in the e-mail that will be sent to you.'
=> 'Bitte stellen Sie einen [_1]erneuten Antrag[_2] auf Erstellung eines Accounts und folgen Sie dem neuen Link, der Ihnen per E-Mail zugesandt werden wird.',

   'Please submit a [_1]new request[_2] for account creation and follow the new link page included in the e-mail that will be sent to you.'
=> 'Bitte stellen Sie einen [_1]erneuten Antrag[_2] auf Erstellung eines Accounts und folgen Sie dem neuen Link, der Ihnen per E-Mail zugesandt werden wird.',

   'A LON-CAPA account for the institution: [_1] has been created [_2] from IP address: [_3]. If you did not perform this action or authorize it, please contact the [_4] ([_5]).'
=> 'Am [_2] wurde für die Einrichtung [_1] von der IP-Adresse [_3] ein LON-CAPA-Account erzeugt. Falls Sie diese Anforderung nicht ausgeführt oder beauftragt hatten, nehmen Sie bitte mit [_4] ([_5]) Kontakt auf.',

   'The password for your LON-CAPA account in the [_1] domain was changed [_2] from IP address: [_3].  If you did not perform this change or authorize it, please contact the [_4] ([_5]).'
=> 'Das Passwort für Ihren LON-CAPA-Account in der Domäne [_1] wurde am [_2] von der IP-Adresse [_3] geändert. Wenn Sie diese Änderung nicht durchgeführt oder autorisiert haben, kontaktieren Sie bitte den [_4] ([_5]).',

   'A LON-CAPA account already exists for username [_1] at this institution ([_2]).'
=> 'Für den Benutzer [_1] existiert bereits ein LON-CAPA-Account an der Einrichtung [_2].',

   'The password entered was also correct so you have been logged in.'
=> 'Das von Ihnen eingegebene Passwort war korrekt, so dass Sie angemeldet wurden.',

   'Authentication failed'
=> 'Authentifizierung fehlgeschlagen',

   'An e-mail confirming creation of your new LON-CAPA account has been sent to [_1].'
=> 'Eine E-Mail zur Bestätigung der Erstellung Ihres neuen LON-CAPA-Accounts wurde an [_1] gesendet.',

   'An error occurred when sending e-mail to [_1] confirming creation of your LON-CAPA account.'
=> 'Beim Versenden der E-Mail zur Bestätigung der Erstellung Ihres neuen LON-CAPA-Accounts ist ein Fehler aufgetreten.',

   'An error occurred when sending e-mail to [_1] confirming setting of your new password.'
=> 'Beim Versenden der E-Mail an [_1] zur Bestätigung der Einstellung Ihres neuen Passworts ist ein Fehler aufgetreten.',

   'A problem occurred when attempting to create your new LON-CAPA account.'
=> 'Beim Erstellen Ihres neuen LON-CAPA-Accounts ist ein Fehler aufgetreten.',

   'Please provide user information and a password for your new account.'
=> 'Bitte geben Sie Ihre Benutzerdaten und ein Passwort für Ihren neuen Account ein.',

   'Please provide a password for your new account.'
=> 'Bitte geben Sie ein Passwort für Ihren neuen Account ein.',

   'Your password will be encrypted when sent (and stored).'
=> 'Ihr Passwort wird verschlüsselt übertragen und gespeichert.',

   'Your password, which must contain at least seven characters, will be sent to the LON-CAPA server in an encrypted form.'
=> 'Ihr Passwort, das aus mindestens sieben Zeichen bestehen muss, wird in verschlüsselter Form an den LON-CAPA-Server geschickt.',

   'Create LON-CAPA account'
=> 'LON-CAPA-Account erstellen',

   'Could not load javascript file [_1]'
=> 'Konnte die Javascript-Datei [_1] nicht laden.',

   'Invalid ID format'
=> 'Ungültiges ID-Format',

   'An error occurred when storing a token'
=> 'Beim Speichern des Authentifizierungscodes ist ein Fehler aufgetreten.',

   'You will not be able to proceed to the next stage of account creation'
=> 'Sie werden den nächsten Schritt zum Erstellen eines Accounts nicht ausführen können.',

   'A LON-CAPA account has been created for username: [_1] in domain: [_2].'
=> 'Für den Benutzer [_1] in der Domäne [_2] wurde ein LON-CAPA-Account erstellt.',

   'Account creation failed for username: [_1] in domain: [_2].'
=> 'Das Erstellen eines LON-CAPA-Accounts für den Benutzer [_1] in der Domäne [_2] ist fehlgeschlagen.',

   'User account creation is not available for the current default authentication type.'
=> 'Für die momentan voreingestellte Authentifizierungsmethode ist das Erstellen von Benutzeraccounts nicht verfügbar.',

   'The e-mail address you provided is already in use as a username at this institution.'
=> 'Die von Ihnen angegebene E-Mail-Adresse wird in dieser LON-CAPA-Domäne als Benutzerkennung bereits verwendet.',

   'Username rules at this institution do not allow the e-mail address you provided to be used as a username.'
=> 'Die für diese Einrichtung eingestellten Regeln für Benutzerkennungen gestatten es nicht, die von Ihnen angegebene E-Mail-Adresse als Benutzerkennung zu verwenden.',

   'The e-mail address you provided may not be used as a username at this LON-CAPA institution.'
=> 'Die von Ihnen angegebene E-Mail-Adresse kann in dieser Einrichtung nicht als Benutzerkennung verwendet werden.',

   'Validation of the code you entered failed.'
=> 'Die Gültigkeitsprüfung des von Ihnen eingegebenen Codes ist fehlgeschlagen.',

   'Type in the letters/numbers shown below'
=> 'Geben Sie die unten angezeigten Buchstaben/Zahlen ein',

   'You may need to reload the previous page to obtain a new token.'
=> 'Sie können die vorherige Seite neu laden, um einen neuen Authentifizierungscode zu erhalten.',

   'Unable to retrieve your log-in information - unexpected context'
=> 'Die Anmeldedaten konnten nicht erfolgreich abgerufen werden - unerwarteter Kontext',

   "Your e-mail address uses the same internet domain as your institution's LON-CAPA service."
=> "Ihre E-Mail-Adresse verwendet die gleiche Internetdomäne wie die Domäne des LON-CAPA-Systems Ihrer Institution.",

   'Creation of a LON-CAPA account with this type of e-mail address as username is not permitted.'
=> 'Das Erstellen eines LON-CAPA-Accounts mit dieser Art von E-Mail-Adressen als Benutzerkennung ist nicht zulässig.',

   'You should request creation of a LON-CAPA account for a log-in ID of "[_1]" at your institution instead.'
=> 'Stattdessen sollten Sie die Erstellung eines LON-CAPA-Accounts für Ihren Benutzeraccount "[_1]" an Ihrer Einrichtung beantragen.',

   'Changes/page:'
=> 'Zeilen pro Seite:',

   'Window during which changes occurred:'
=> 'Zeitspanne, in der Änderungen aufgetreten sind:',

   'This page is either empty or it only contains resources that are currently hidden'
=> 'Diese Seite ist entweder leer oder enthält derzeit nur verborgene Ressourcen',

   'Please use the LON-CAPA navigation arrows to move to another item in the course'
=> 'Bitte verwenden Sie die LON-CAPA-Navigationspfeile, um zu anderen Ressourcen zu gelangen.',

   'Unable to modify requested student ([_1])'
=> 'Die Daten des/der angeforderte/n Studenten/in [_1] konnten nicht geändert werden.',

   'Unable to grade requested sequence ([_1]).'
=> 'Die angeforderte Sequenz [_1] konnte nicht bewertet werden.',

   'No score was changed or updated.'
=> 'An den Punkten wurde keine Änderung vorgenommen.',

   'The scores were changed for [quant,_1,problem].'
=> 'Für [quant,_1,Aufgabe,Aufgaben] wurden die Punkte geändert.',

   '[_1]Visit the [_2]Course/Community Catalog[_3][_4] to view all [_5] LON-CAPA courses and communities.' # _1: <b>, _2: <a>, _3: </a>, _4: </b>, _5: domain desc.
=> '[_1]Besuchen Sie die [_2]Kurs-/Community-Übersicht[_3][_4], um alle LON-CAPA-Kurse und -Communitys der Institution [_5] zu betrachten.',

   'If a course or community is [_1]not[_2] in your list of current courses and communities below, you may be able to enroll if self-enrollment is permitted.'
=> 'Falls ein Kurs in der folgenden Liste Ihrer derzeitigen Kurse [_1]nicht[_2] angezeigt wird, können Sie sich in der Kursübersicht in diesen Kurs selbst eintragen, sofern die Selbsteintragung für diesen Kurs aktiviert ist.',

   'When'
=> 'Wann',

   'Who made the change'
=> 'Wer führte die Änderung durch',

   'Changed User'
=> 'Geänderter Benutzer',

   'Context'
=> 'Kontext',

   'Context:'
=> 'Kontext:',

   'After:'
=> 'Nach:',

   'Before:'
=> 'Vor:',

   'User Changes'
=> 'Teilnehmer-Änderungen',

   'For this user, the default quota would be [_1]'
=> 'Der voreingestellte Speicherplatz für diesen Benutzer beträgt [_1]',

   'Search for a user and enroll as a student'
=> 'Nach einem Benutzer suchen und als Student/in den Kurs belegen lassen',

   'username is known'
=> 'Benutzerkennung ist bekannt',

   'Create a new user'
=> 'Neuen Benutzer erstellen',

   'Enroll'
=> 'Kurs belegen',

   'User Search to enroll student'
=> 'Benutzersuche, um Student/in Kurs belegen zu lassen',

   'Select a user to enroll as a student'
=> 'Auswahl eines Benutzers zur Kursbelegung als Student/in',

   'modify' #Kontext? breadcrumb_text
=> 'modifizieren',

#   'userpicked' #Kontext?
#=> '',

   'as a student'
=> 'als ein/e Student/in',

   'as a member'
=> 'als Mitglied',

   'Set section/dates'
=> 'Sektion/Daten festlegen',

   'Unknown'
=> 'unbekannt',

   'You do not have privileges to assign co-author roles.'
=> 'Sie sind nicht berechtigt, Co-Autor Rollen zuzuweisen.',

   'This user has an unrecognized authentication scheme'
=> 'Dieser Benutzer hat ein unbekanntes Authentifizierungsschema',

   'Please alert a domain coordinator of this situation'
=> 'Bitte benachrichtigen Sie einen Domänen-Koordinator über diese Situation',

   'Please specify login data below'
=> 'Bitte geben Sie Sie die Login-Daten an',

   'No domain specified'
=> 'Keine Domäne angegeben',

   'Invalid domain name'
=> 'Ungültiger Domänenname',

   'Invalid domain name.'
=> 'Ungültiger Domänenname.',

   'Only letters, numbers, periods, dashes, and underscores are valid.'
=> 'Es sind nur erlaubt: Buchstaben, Ziffern, ".", "-", "_"',

   'You do not have the authority to modify this users authentication information.'
=> 'Sie haben nicht die Berechtigung, um die Authentifizierungsinformationen dieses Benutzers zu ändern.',

   'New student/employee ID does not match existing ID for this user.'
=> 'Die neue Studierenden-/Mitarbeiter-ID stimmt nicht mit der bestehenden ID dieses Benutzers überein.',

   "Change is not permitted without checking the 'Force ID change' checkbox on the previous page."
=> "Ohne Auswahl der 'Erzwinge-ID-Änderung'-Checkbox auf der vorherigen Seite ist eine Änderung nicht erlaubt.",

   'Unable to successfully change environment for [_1] in domain [_2].'
=> 'Für den Benutzer [_1] in der Domäne [_2] konnte die Umgebung nicht geändert werden.',

   'No roles'
=> 'Keine Rollen',

   'The following fields were not updated: '
=> 'Die folgenden Felder wurden nicht aktualisiert: ',

   "You do not have the authority to change this field given the user's current set of active/future course roles:"
=> 'Sie haben nicht die Berechtigung, um dieses Feld angesichts der aktuellen aktiven/zukünftigen Kursrollen des Benutzers zu ändern:',

   "You do not have the authority to change this field given the user's current set of active/future co-author roles:"
=> 'Sie haben nicht die Berechtigung, um dieses Feld angesichts der aktuellen aktiven/zukünftigen Co-Author-Rollen des Benutzers zu ändern:',

   "You do not have the authority to change these fields given the user's current set of active/future course roles:"
=> 'Sie haben nicht die Berechtigung, um diese Felder angesichts der aktuellen aktiven/zukünftigen Kursrollen des Benutzers zu ändern:',

   "You do not have the authority to change these fields given the user's current set of active/future co-author roles:"
=> 'Sie haben nicht die Berechtigung, um diese Felder angesichts der aktuellen aktiven/zukünftigen Co-Author-Rollen des Benutzers zu ändern:',

   'Please contact your [_1]helpdesk[_2] for more information.'
=> 'Bitte kontaktieren Sie das [_1]Helpdesk[_2] für weitere Informationen.',

   'Please contact the [_1]helpdesk[_2] for assistance.'
=> 'Bitte nehmen Sie zur Klärung Kontakt mit dem [_1]Helpdesk[_2] auf.',

   '[_1] enrolled'
=> 'Kurs belegt für [_1]',

   'in Section'
=> 'in der Sektion',

   'in section [_1]'
=> 'in Sektion [_1]',

   'in Group'
=> 'in der Gruppe',

   'Access starts immediately'
=> 'Zugriff beginnt sofort',

   'Access starts: '
=> 'Zugriff beginnt: ',

   'Access Ends'
=> 'Zugriff endet',

   'Access Starts'
=> 'Zugriff beginnt',

   'ends: no ending date'
=> 'endet: kein Enddatum',

   'ends: '
=> 'endet: ',

   'If the student is currently logged-in to LON-CAPA, the new role will be available when the student next logs in.'
=> 'Falls der/die Student/in gerade in LON-CAPA angemeldet ist, wird die Rolle nach dem nächsten Anmelden des/der Studenten/in verfügbar sein.',

   'default for [_1]'
=> 'Standard für [_1]',

   'You are not authorized to make bulk changes to user roles'
=> 'Sie sind nicht autorisiert, Massenänderungen an Benutzerrollen durchzuführen.',

   'You do not have permission to modify dates or sections for users'
=> 'Sie haben keine Berechtigung, um Daten oder Sektionen für Benutzer zu ändern',

   'deleted'
=> 'gelöscht',

   'No start date'
=> 'Kein Anfangsdatum',

   'Previous [_1] changes'
=> 'Vorherige [_1] Änderungen',

   'Next [_1] changes'
=> 'Nächste [_1] Änderungen',

   'There are no records to display.'
=> 'Keine Datensätze zum Anzeigen.',

   'There are no records to display'
=> 'Keine Datensätze zum Anzeigen',

   'There are no transactions to display.'
=> 'Es gibt keine Transaktionen, die angezeigt werden können.',

   'Automated enrollment'
=> 'Automatisierte Kursbelegung',

   'Roster Update'
=> 'Teilnehmeraktualisierung',

   'Course Creation'
=> 'Kurserstellung',

   'Community Creation'
=> 'Community-Erstellung',

   'Course/Community Creation'
=> 'Kurs-/Community-Erstellung',

   'User Management in course'
=> 'Benutzerverwaltung im Kurs',

   'User Management in community'
=> 'Benutzerverwaltung in der Community',

   'User Management in domain'
=> 'Benutzerverwaltung in der Domäne',

   'Self-enrolled'
=> 'Selbst eingetragen',

   'Your search term must contain more than just spaces.'
=> 'Ihre Suchanfrage muss mehr als nur Leerzeichen enthalten.',

   'this course'
=> 'dieser Kurs',

   'Please contact the [_1]helpdesk[_2] if you need to create a new user.'
=> 'Bitte kontaktieren Sie das [_1]Helpdesk[_2], falls Sie einen neuen Benutzer erstellen möchten.',

   'Section for self-enrolled users unchanged as the proposed section is a group'
=> 'Sektion für selbst eingetragene Benutzer nicht geändert, da die vorgeschlagene Sektion eine Gruppe ist',

   'Group names and section names must be distinct'
=> 'Gruppen- und Sektionsnamen müssen eindeutig sein',

   'Section for self-enrolled users unchanged, as "all" is a reserved section name.'
=> 'Sektion für selbst eingetragene Benutzer nicht geändert, da "all" ein system-intern reservierter Sektionsname ist.',

   'An error occurred when saving changes to self-enrollment settings in this course.'
=> 'Ein Fehler trat während des Speicherns der Änderungen an den Selbsteintragungs-Einstellungen in diesem Kurs auf.',

   'Server Switch Required'
=> 'Serverwechsel erforderlich',

   'Authoring Space access is only available from the home server of the corresponding Author.'
=> 'Der Autorenbereich ist nur vom Heimatserver des zugehörigen Autors verfügbar.',

   "Click the 'Switch Server' link to go there."
=> "Klicken Sie auf 'Server wechseln', um dort hinzugelangen.",

   'Default in use:'
=> 'Voreinstellung in Verwendung:',

   'Default in use'
=> 'Voreinstellung in Verwendung',

   'Default(s) in use:'
=> 'Voreinstellung(en) in Verwendung:',

   'Self-creation of account by users with status: [_1]'
=> 'Selbsterstellung eines Accounts durch Benutzer mit Status [_1]',

   'modifiable fields (if institutional data blank): '
=> 'änderbare Felder (falls Daten der Einrichtung leer sind): ',

   'Format rules to check for IDs: '
=> 'Formatregeln, die auf IDs angewendet werden: ',

   'Format rules to check for new usernames: '
=> 'Formatregeln, die auf neue Benutzerkennungen angewendet werden: ',

   'Formats disallowed for self-created accounts (e-mail): '
=> 'Nicht erlaubte Regeln für selbst erstellte Accounts (E-Mail): ', # ?

   'Source Code'
=> 'Quellcode',

   'Copy Problem Source Code to Authoring Space'
=> 'Aufgaben-Quellcode in Autorenbereich kopieren',

   'Please enter the directory that you would like the source code to go into.'
=> 'Bitte geben Sie das Verzeichnis ein, in das der Quellcode kopiert werden soll.',

   'Note: the path is in reference to the root of your Authoring Space, and new directories will be automatically created.'
=> 'Beachten Sie, dass sich der Pfad auf das Heimatverzeichnis Ihres Autorenbereichs bezieht. Noch nicht existierende Verzeichnisse werden automatisch angelegt.',

   'shared_source' # will be path in CSTR, restrictive use of characters advised, e.g. [a-zA-Z0-9_-]
=> 'gemeinsame_Dokumente',

   'Copy to Authoring Space'
=> 'In Autorenbereich kopieren',

   '[_1]W[_2]ARNING' # Highlight first char
=> '[_1]W[_2]ARNUNG',

   'At end of file some tags were still left unclosed:'
=> 'Am Ende der Datei sind manche Tags noch nicht geschlossen:',

   'Unable to save file [_1]'
=> 'Die folgende Datei konnte nicht gespeichert werden: [_1]',

   'Warnings and Errors'
=> 'Warnungen und Fehler',

   'Edit Math'
=> 'Formeleditor',

   'DragMath LaTeX Equation Editor'
=> 'DragMath-LaTeX-Formel-Editor',

   '[_1]Return[_2] to resource.'
=> '[_1]Zurück[_2] zur Ressource',

   'Counting pages for student: [_1]'
=> 'Zähle Seiten für Student/in [_1]',

   'LaTeX could not successfully parse your TeX file.'
=> 'LaTeX konnte Ihre TeX-Datei nicht erfolgreich parsen.',

   'The LaTeX file [_1] was not created successfully.'
=> 'Die LaTeX-Datei [_1] konnte nicht erfolgreich erstellt werden.',

   'Zip Output:'
=> 'ZIP-Ausgabe:',

   'It probably has errors in it.'
=> 'Sie enthält vermutlich Fehler.',

   'Here are the error messages in the LaTeX log file:'
=> 'Die Fehlermeldungen der LaTeX-Logdatei:',

   'There are errors in [_1].'
=> 'Es sind Fehler aufgetreten. Ort: [_1]',

   'There are errors.'
=> 'Es sind Fehler aufgetreten.',

   'These errors prevent this resource from printing correctly.'
=> 'Diese Fehler verhindern, dass diese Ressource korrekt gedruckt werden kann.',

   'A message has been sent to the instructor describing this failure.'
=> 'Dem Dozenten wurde eine Nachricht gesendet, die eine Beschreibung des Fehlverhaltens enthält.',

   'You are running LaTeX in [_1]batch mode[_2].'
=> 'Sie verwenden LaTeX im [_1]Stapelverarbeitungsbetrieb[_2] (batch mode).',

   'It has found an error in [_1][_2]and corrected it.'
=> 'Es wurde ein Fehler in [_1] gefunden[_2]und korrigiert.',

   'Usually this correction is valid but you probably need to check the indicated resource one more time and implement necessary corrections by yourself.'
=> 'Üblicherweise ist diese Korrektur gültig, allerdings sollten Sie zur Sicherheit die angezeigte Ressource selbst noch einmal überprüfen und ggf. notwendige Korrekturen vornehmen.',

   'The link to [_1]Your log file[_2]'
=> 'Link zur [_1]Logdatei[_2]',

   'The link to [_1]Your original LaTeX file[_2]'
=> 'Link zur [_1]Original-LaTeX-Datei[_2]',

   'bomb'
=> 'Bombe',

   'Bomb'
=> 'Bombe',

   'Output Tags'
=> 'Tags zur Ausgabe',

   'WARNING: Cannot connect to database!'
=> 'WARNUNG: Datenbankverbindung kann nicht aufgebaut werden!',

   'Error occurred saving new values in metadata table in LON-CAPA database!'
=> 'Speichern neuer Werte in der Metadaten-Tabelle der LON-CAPA-Datenbank ist fehlgeschlagen!',

   'Your course/community currently appears in the Course/Community Catalog for this domain.'
=> 'Ihr Kurs / Ihre Community wird derzeit in der Kurs-/Community-Übersicht dieser Domäne aufgelistet.',

   'This course/community currently appears in the Course/Community Catalog for this domain.'
=> 'Dieser Kurs / diese Community wird derzeit in der Kurs-/Community-Übersicht dieser Domäne aufgelistet.',

   'This course/community does not currently appear in the Course/Community Catalog for this domain.'
=> 'Dieser Kurs / diese Community wird derzeit nicht in der Kurs-/Community-Übersicht dieser Domäne aufgelistet.',

   'Courses can be both self-cataloging, based on an institutional code (e.g., fs08phy231), or can be assigned categories from a hierarchy defined for the domain.'
=> 'Kurse können selbst-katalogisiert sein, auf institutionellen Codes basieren (z.B. fbi_ws20082009_linalg) oder können eine Kategorie einer Hierarchie zugeordnet sein, die durch die Domäne definiert ist.',

   'Your course/community does not currently appear in the Course/Community Catalog for this domain.'
=> 'Ihr Kurs/Ihre Community wird derzeit nicht in der Kurs-/Community-Übersicht dieser Domäne aufgelistet.',

   'You should remedy this if you plan to allow self-enrollment, otherwise students will have difficulty finding your course.'
=> 'Sie sollten dies ändern, falls Sie Selbsteintragung für diesen Kurs anbieten möchten, da Studierende sonst Schwierigkeiten haben werden, Ihren Kurs zu finden.',

   'You should remedy this if you plan to allow self-enrollment, otherwise students will have difficulty finding this course.'
=> 'Sie sollten dies ändern, falls Sie Selbsteintragung für diesen Kurs anbieten möchten, da Studierende sonst Schwierigkeiten haben werden, diesen Kurs zu finden.',

   'Courses can be absent from the Catalog, because they do not have an institutional code, have no assigned category, or have been specifically excluded.'
=> 'Gründe für das Fehlen der Auflistung von Kursen in der Kursübersicht können sein, dass die Kurse keinen institutionellen Code haben, ihnen keine Kategorie zugewiesen wurde oder mit Absicht aus der Auflistung ausgeschlossen wurden.',

   'Make any changes to self-enrollment settings below, click "Save", then take action to include the course in the Catalog:'
=> 'Nehmen Sie unten Änderungen an der Selbsteintragung vor, klicken Sie auf "Speichern" und sorgen Sie anschließend dafür, dass der Kurs in die Kursübersicht aufgenommen wird:',

   'Take the following action to ensure the course appears in the Catalog:'
=> 'Führen Sie folgende Schritte aus, damit der Kurs in der Kursübersicht aufgelistet wird:',

   'Ask a domain coordinator to change the "Exclude from course catalog" setting.'
=> 'Bitten Sie einen Domänen-Koordinator, die Einstellung "Kurs aus Kursübersicht ausschließen" zu ändern.',

   'Ask a domain coordinator to enable display the catalog of "Official courses (with institutional codes)".'
=> 'Bitten Sie einen Domänen-Koordinator, die Anzeige der Kursübersicht "Offizielle Kurse (mit institutionellen Codes)" zu aktivieren.',

   'Ask a domain coordinator to assign an institutional code (if this is an official course).'
=> 'Bitten Sie einen Domänen-Koordinator, einen institutionellen Code zuzuweisen (falls es sich um einen offiziellen Kurs handelt).',

   'Ask a domain coordinator to enable or create at least one course category in the domain.'
=> 'Bitten Sie einen Domänen-Koordinator, in der Domäne mindestens eine Kurskategorie anzulegen.',

   'Ask a domain coordinator to create a hierarchy of categories and sub categories for courses in the domain.'
=> 'Bitten Sie einen Domänen-Koordinator, für Kurse in der Domäne eine Hierarchie von Kategorien und Unterkategorien anzulegen.',

   'Ask a domain coordinator to change the category assigned to the course, as the one currently assigned is no longer used in the domain'
=> 'Bitten Sie einen Domänen-Koordinator, die diesem Kurs zugewiesene Kategorie zu abzuändern, da die derzeit zugewiesene in der Domäne nicht mehr verwendet wird.',

   'Ask a domain coordinator to assign a category to the course.'
=> 'Bitten Sie einen Domänen-Koordinator, dem Kurs eine Kategorie zuzuweisen.',

   'Ask a domain coordinator to assign a six character code to the course'
=> 'Bitten Sie einen Domänen-Koordinator, dem Kurs einen Sechs-Zeichen-Code zuzuweisen.',

   'Ask a domain coordinator to change the Catalog type for this domain.'
=> 'Bitten Sie einen Domänen-Koordinator, den Übersichtstyp für diese Domäne zu ändern.',

   'Use [_1]Categorize course[_2] to change the "Exclude from course catalog" setting.'
=> 'Gehen Sie zum Menüpunkt [_1]Kurs kategorisieren[_2], um die Einstellung "Kurs aus Kursübersicht ausschließen" zu ändern.',

   'Use [_1]Categorize course[_2] to change the category assigned to the course, as the one currently assigned is no longer used in the domain.'
=> 'Gehen Sie zum Menüpunkt [_1]Kurs kategorisieren[_2], um die diesem Kurs zugewiesene Kategorie zu abzuändern, da die derzeit zugewiesene in der Domäne nicht mehr verwendet wird.',

   'Use [_1]Categorize course[_2] to assign a category to the course.'
=> 'Gehen Sie zum Menüpunkt [_1]Kurs kategorisieren[_2], um dem Kurs eine Kategorie zuzuweisen.',

   'You are able to both assign a course category and choose to exclude this course from the catalog.'
=> 'Sie können dem Kurs eine Kurskategorie zuweisen und den Kurs aus der Kursübersicht ausschließen.',

   'You are able to choose to exclude this course from the catalog, but only a Domain Coordinator may assign a course category.'
=> 'Sie können den Kurs aus der Kursübersicht ausschließen, aber nur ein Domänen-Koordinator darf dem Kurs eine Kurskategorie zuweisen.',

   'You may assign a course category, but only a Domain Coordinator may choose to exclude this course from the catalog.'
=> 'Sie können dem Kurs eine Kurskategorie zuweisen, aber nur ein Domänen-Koordinator darf den Kurs aus der Kursübersicht ausschließen.',

   'Only a Domain Coordinator may assign a course category or choose to exclude this course from the catalog.'
=> 'Nur ein Domänen-Koordinator darf dem Kurs eine Kurskategorie zuweisen und den Kurs aus der Kursübersicht ausschließen.',

   "Please use the 'Select Course' link to open a separate pick course window where you may select the course you wish to enter"
=> "Bitte verwenden Sie den 'Kurs auswählen'-Link, um ein extra Fenster zu öffnen, das Ihnen die Möglichkeit bietet, einen Kurs auszuwählen, den Sie betreten möchten.",

   "Please use the 'Select Course/Community' link to open a separate pick course window where you may select the course or community you wish to enter."
=> "Bitte verwenden Sie den 'Kurs/Community auswählen'-Link, um ein extra Fenster zu öffnen, das Ihnen die Möglichkeit bietet, einen Kurs oder eine Community auszuwählen, den oder die Sie betreten möchten.",

   "Please use the 'Select Course' link to open a separate window where you can search for a course to which a file can be uploaded."
=> "Bitte verwenden Sie den 'Kurs auswählen'-Link, um ein extra Fenster zu öffnen, das Ihnen die Möglichkeit bietet, nach einem Kurs zu suchen, in den eine Datei hochgeladen werden kann.",

   'You can only use this screen to select courses in the current domain.'
=> 'Sie können diesen Bildschirm nur verwenden, um Kurse der derzeitigen Domäne auszuwählen.',

   '[_1]Your Excel spreadsheet[_2] is ready for download.'
=> '[_1]Ihre Excel-Datei[_2] steht zum Download bereit.',

   '[_1]Your CSV file[_2] is ready for download.'
=> '[_1]Ihre CSV-Datei[_2] steht zum Download bereit.',

   '[_1] - [_2]Your PDF file[_3] is ready for download.'
=> '[_1] - [_2]Ihre PDF-Datei[_3] steht zum Download bereit.',

   'A [_1]ZIP file[_2] of all the PDF files is ready for download.'
=> 'Eine [_1]ZIP-Datei[_2] mit allen PDF-Dateien steht zum Download bereit.',

   'Name (username)'
=> 'Name (Benutzerkennung)',

   'Grades Assigned'
=> 'Zugewiesene Bewertungen',

   'Comments'
=> 'Kommentare',

   'comments'
=> 'Kommentare',

   'No Course Data'
=> 'Keine Kursdaten vorhanden',

   'Error getting student data ([_1])'
=> 'Fehler beim Abrufen der studentischen Daten ([_1])',

   'Score'
=> 'Punkte',

   'score'
=> 'Punkte',

   'Display Options'
=> 'Anzeige-Optionen',

   'This role has section(s) associated with it.'
=> 'Mit dieser Rolle sind Sektionen verknüpft.',

   'Enter a specific section.'
=> 'Geben Sie eine bestimmte Sektion ein.',

   'Enter a specific section, or leave blank for no section.'
=> 'Geben Sie eine bestimmte Sektion ein oder lassen Sie das Feld frei für keine Sektion.',

   'Available sections are:'
=> 'Verfügbare Sektionen sind:',

   'You entered an invalid section choice:'
=> 'Sie haben einen ungültige Sektion eingegeben:',

   'No specific section'
=> 'Keine bestimmte Sektion',

   '([_1] time zone)'
=> '(Zeitzone [_1])',

   'Selecting an Author'
=> 'Auswahl eines Autors',

   'Invalid domain.'
=> 'Ungültige Domäne.',

   'Invalid domain'
=> 'Ungültige Domäne',

   'There are no library servers containing Authoring Spaces currently in domain: [_1], so you can not assume a co-author role.'
=> 'In der Domäne [_1] existieren derzeit keine Library-Server mit Autorenbereichen. Somit können Sie auch keine Co-Autoren-Rolle annehmen.',

   'You do not have a domain coordinator role in domain: [_1], so you cannot choose an Authoring Space for which you can assume a co-author role.'
=> 'In der Domäne [_1] haben Sie keine Domänen-Koordinatoren-Rolle. Somit können Sie auch keinen Autorenbereich wählen, für den Sie eine Co-Autoren-Rolle annehmen könnten.',

   'You do not have a domain coordinator role, so you cannot choose an Authoring Space for which you can assume a co-author role.'
=> 'Sie habe keine Domänen-Koordinatoren-Rolle. Somit können Sie auch keinen Autorenbereich wählen, für den Sie eine Co-Autoren-Rolle annehmen könnten.',

   'There are no author roles currently in domain: [_1], so there are no Authoring Spaces for which you can assume a co-author role.'
=> 'In der Domäne [_1] gibt es derzeit keine Autoren-Rollen. Somit können Sie auch keinen Autorenbereich wählen, für den Sie eine Co-Autoren-Rolle annehmen könnten.',

   'As your session file for the course or community has expired, you will need to re-select it.'
=> 'Da die Sitzungsdatei für diesen Kurs / diese Community zwischenzeitlich verfallen ist, müssen Sie ihn/sie erneut auswählen.',

   '[quant,_1,yr]'
=> '[quant,_1,Jahr,Jahre]',

   '[quant,_1,mth]'
=> '[quant,_1,Mon.,Mon.]',

   '[quant,_1,hr]'
=> '[quant,_1,h,h]',

   '[quant,_1,min]'
=> '[quant,_1,min,min]',

   '[quant,_1,sec]'
=> '[quant,_1,s,s]',

   'Loading student data...'
=> 'Abruf der studentischen Daten...',

   'Option'
=> 'Option',

   'Options'
=> 'Optionen',

   'Options:'
=> 'Optionen:',

   'Time Period'
=> 'Zeitraum',

   'Plot Graph'
=> 'Graph plotten',

   'Download'
=> 'Download',

   'PDF File'
=> 'PDF-Datei',

   'Zip File'
=> 'ZIP-Datei',

   'File Size (Bytes)'
=> 'Dateigröße (Bytes)',

   'Contents'
=> 'Inhalt',

   'Problem Type'
=> 'Aufgabentyp',

   'not in this course'
=> 'nicht in diesem Kurs.',

#Start: redesigned menus
#lonparmset.pm
   'Edit environment settings for this course.'
=> 'Einstellungen der Kursumgebung ändern.',

   'Portfolio Metadata'
=> 'Portfolio-Metadaten',

   'Settings for this Course'
=> 'Einstellungen für diesen Kurs',

   'New and Existing Parameter Settings for Resources'
=> 'Neue und bestehende Parameter-Einstellungen für Ressourcen',

   'Edit Resource Parameters - Helper Mode'
=> 'Hilfsmodus',

   'Edit Resource Parameters - Overview Mode'
=> 'Übersichtsmodus',

   'Edit Resource Parameters - Table Mode'
=> 'Tabellenmodus',

   'Modify Resource Parameters - Overview Mode'
=> 'Ändern von Ressourcen-Parametern in Gesamtübersicht',

   'Existing Parameter Settings for Resources'
=> 'Bestehende Parameter-Einstellungen für Ressourcen',

   'Change Log'
=> 'Änderungsprotokoll',

   'Restrict metadata for this course.'
=> 'Metadaten für diesen Kurs einschränken.',

   'Manage slots for this course.'
=> 'Slots für diesen Kurs vewalten.',

   'Reset access times for folders/maps, resources or the course.'
=> 'Zugriffszeiten für Verzeichnisse, Ressourcen oder den Kurs zurücksetzen.',

   'Set default actions for parameters.'
=> 'Standardaktionen für Parameter festlegen.',

   'Set/Modify resource parameters in helper mode.'
=> 'Festlegen/Ändern von Parametern zur Kursbeurteilung im Hilfsmodus.',

   'Set/Modify resource parameters in table mode.'
=> 'Festlegen/Ändern von Parametern zur Kursbeurteilung im Tabellenmodus.',

   'Set/Modify resource parameters in overview mode.'
=> 'Festlegen/Ändern von Parametern zur Kursbeurteilung im Übersichtsmodus.',

   'Set/Modify existing resource parameters in overview mode.'
=> 'Festlegen/Ändern von Parametern zur Kursbeurteilung im Übersichtsmodus.',

   'View parameter and course blog posting/user notification change log.'
=> 'Anzeigen des Änderungsprotokolls.',
#lonpreferences.pm
   'Screen Name'
=> 'Nicknamen',

   'Messages &amp; Notifications'
=> 'Nachrichten und Benachrichtigungen',

   'Discussion Display'
=> 'Darstellung der Diskussionsbeiträge',

   'Color Scheme'
=> 'Farbschema',

   'Content Display Settings'
=> 'Erscheinungsbild des Inhalts',

   'Menu Display'
=> 'Menüdarstellung',

   'WYSIWYG Editor'
=> 'WYSIWYG-Editor',

   'Roles Page'
=> 'Rollen-Schnellzugriff',

   'Change Role Page Pref'
=> 'Rollen-Schnellzugriff ändern',

   'Course Page'
=> 'Kurs-Schnellzugriff',

   'Display of Scientific Equations'
=> 'Darstellung wissenschaftlicher Formeln',

   'Edit information about yourself that should be displayed on your public profile.'
=> 'Informationen festlegen, die in ihrem öffentlichen Profil darstellt werden sollen.',

   'Change the name that is displayed in your posts.'
=> 'Änderung des Namens, der in Ihren Diskussionsbeiträgen angezeigt wird.',

   'Change LON-CAPA default colors.'
=> 'Standardfarben für LON-CAPA festlegen.',

   'Change messageforwarding or notifications settings.'
=> 'Konfiguration der Nachrichtenweiterleitung und Benachrichtigungseinstellungen.',

   'Choose the default language for this user.'
=> 'Ändern der voreingestellten Benutzersprache für diesen Benutzer.',

   'Enable or disable the WYSIWYG-Editor.'
=> 'Aktivieren bzw. Deaktivieren des WYSIWYG-Editors.',

   'Configure the roles hotlist.'
=> 'Konfiguration der Rollen-Schnellzugriffsliste.',

   'Change how Scientific Equations are displayed.'
=> 'Konfiguration der Darstellung wissenschaftlicher Formeln.',

   'Register your clicker.'
=> 'Registrierung von Antwortgeräten (Clicker).',

   'Change your password.'
=> 'Änderung des Passworts.',

   'Launch the remote control for LON-CAPA.'
=> 'Fernbedienung für LON-CAPA aktivieren.',

   'Collapse the remote control for LON-CAPA.'
=> 'Fernbedienung für LON-CAPA deaktivieren.',

   'Restrict domain coordinator access.'
=> 'Domänenkoordinatorzugriff beschränken.',

   'Set the default page to be displayed when you select a course role.'
=> 'Ändern der voreingestellten Seite, die nach Auswahl eines Kurses angezeigt wird.',

   'Toggle Debug Messages.'
=> 'Umschalten der Debug-Meldungen',

   'Toggle debug messages'
=> 'Umschalten der Debug-Meldungen',

   'Toggle Debug Messages (Currently on)'
=> 'Umschalten der Debug-Meldungen (derzeit: an)',

   'Toggle Debug Messages (Currently off)'
=> 'Umschalten der Debug-Meldungen (derzeit: aus)',

   'Change whether the menus are displayed with icons or icons and text.'
=> 'Festlegen, ob Menüs mit Buttons, Icons oder Icons und Text dargestellt werden sollen.',

   'Course Initialization'
=> 'Kursinitialisierung',
#loncreateuser.pm
   'Single Users'
=> 'Einzelne Teilnehmer',

   'Upload a CSV or a text file containing users.'
=> 'Eine CSV- oder Textdatei mit Kursteilnehmern hochladen.',

   'Single Course User'
=> 'Einzelnen Kursteilnehmer',

   'Add a user with a certain role to this course.'
=> 'Einen Kursteilnehmer mit einer bestimmten Benutzerrolle hinzufügen.',

   'Show and manage users in this domain.'
=> 'Anzeige und verwalten von Benutzern in dieser Domäne.',

   'Add/Modify a Student'
=> 'Student/in hinzufügen/ändern',

   'Add a user with the role student to this course.'
=> 'Einen Kursteilnehmer mit der Benutzerrolle Student/in hinzufügen.',

   'Configuration'
=> 'Konfiguration',

   'Automated enrollment manager.'
=> 'Verwaltung der automatischen Kursbelegung.',

   'Self-Enrollment'
=> 'Selbsteintragung',

   'User Self-Enrollment'
=> 'Benutzer-Selbsteintragung',

   'Configure user self-enrollment.'
=> 'Die Selbsteintragung in diesem Kurs konfigurieren.',

   'Manage course groups.'
=> 'Kursgruppen verwalten.',

   'View change log.'
=> 'Änderungsprotokoll betrachten.',

   'Administration'
=> 'Administration',

   'Manage Community Users'
=> 'Community-Teilnehmer verwalten',

   'Manage Course Users'
=> 'Kursteilnehmer verwalten',

   'List and Modify Multiple Community Users'
=> 'Community-Teilnehmer auflisten und ändern',

   'List and Modify Multiple Course Users'
=> 'Kursteilnehmer auflisten und ändern',

   'Show and manage users of this course.'
=> 'Anzeigen und verwalten von Benutzern dieses Kurses.',

   'Remove a student from this course.'
=> 'Student/in aus diesem Kurs ausschließen.',

   'Custom Roles'
=> 'Benutzerdefinierte Rollen',

   'Configure a custom role.'
=> 'Konfiguration von benutzerdefinierten Rollen.',

   'Define new custom role:'
=> 'Neue benutzerdefinierte Rolle anlegen:',

   'Define or Edit Custom Role'
=> 'Benutzerdefinierte Rolle anlegen oder bearbeiten',

   'Enrollment Requests'
=> 'Belegungswünsche',

   'Enrollment request'
=> 'Belegungswunsch',

   'Approve or reject enrollment requests.'
=> 'Belegungswünsche bestätigen oder ablehnen',

   'There are currently no enrollment requests awaiting approval.'
=> 'Derzeit gibt es keine Belegungswünsche, die auf Bestätigung warten.',

   'There are currently no requests for Authoring Space awaiting approval.'
=> 'Derzeit gibt es keine Anträge auf einen Autorenbereich, die auf Bestätigung warten.',

   'Multiple Users'
=> 'Mehrere Teilnehmer',

#lonstatistics.pm
   'Statistics and Analyses'
=> 'Statistiken und Analysen',

   'Plots'
=> 'Diagramme',

   'Reports'
=> 'Berichte',

   'Paste failed: an error occurred saving the composite page'
=> 'Einfügen fehlgeschlagen: Beim Speichern der zusammengesetzten Seite ist ein Fehler aufgetreten.',

   'Paste failed: an error occurred saving the folder'
=> 'Einfügen fehlgeschlagen: Beim Speichern des Verzeichnisses ist ein Fehler aufgetreten.',

   'Paste failed: an error occurred creating a unique URL for the composite page'
=> 'Einfügen fehlgeschlagen: Beim Anlegen einer eindeutigen URL für die zusammengesetzte Seite ist ein Fehler aufgetreten.',

   'Paste failed: an error occurred creating a unique URL for the folder'
=> 'Einfügen fehlgeschlagen: Beim Anlegen einer eindeutigen URL für das Verzeichnis ist ein Fehler aufgetreten.',

   'Paste failed: An error occurred when copying the simple page.'
=> 'Einfügen fehlgeschlagen: Beim Kopieren der einfachen Seite ist ein Fehler aufgetreten.',

   'Paste failed: Item is from a different course which you do not have rights to edit.'
=> 'Einfügen fehlgeschlagen: Das Element ist aus einem anderen Kurs, für den Sie jedoch keine Änderungsrechte haben.',

   'Paste failed: an error occurred copying the file.'
=> 'Einfügen fehlgeschlagen: Beim Kopieren der Datei ist ein Fehler aufgetreten.',

   'Paste failed: an error occurred saving the file.'
=> 'Einfügen fehlgeschlagen: Beim Speichern der Datei ist ein Fehler aufgetreten.',

   'Paste failed: an error occurred saving the folder or page.'
=> 'Einfügen fehlgeschlagen: Beim Speichern des Verzeichnisses / der Seite ist ein Fehler aufgetreten.',

   'Paste failed: content type is not supported within Supplemental Content'
=> 'Einfügen fehlgeschlagen: Der Inhaltstyp wird nicht innerhalb der zusätzlichen Inhalte unterstützt.',

   'Paste failed: only one instance of a particular published sequence or page is allowed within each course'
=> 'Einfügen fehlgeschlagen: Innerhalb eines Kurses ist nur eine einzige Instanz einer veröffentlichten Sequenz oder Seite zulässig.',

   'Paste failed: only one instance of a particular published sequence or page is allowed within each course.'
=> 'Einfügen fehlgeschlagen: Innerhalb eines Kurses ist nur eine einzige Instanz einer veröffentlichten Sequenz oder Seite zulässig.',

#grades.pm

   'Manual Grading/View Submissions'
=> 'Manuelle Bewertung vornehmen / Einreichungen betrachten',

   'This problem has been graded correct by the computer. Do you want to change the score?'
=> "Diese Aufgabe wurde durch den Computer mit 'korrekt' bewertet. Möchten Sie die Punkte anpassen?",

   'Process Clicker'
=> 'Clicker-Verarbeitung',

   'Process clicker'
=> 'Clicker-Verarbeitung',

   'Grade/Manage/Review Bubblesheets'
=> 'Bewertung/Verwaltung/Überprüfung von Bubblesheets',

   'Start the process of hand grading submissions.'
=> 'Mit der manuellen Bewertung von Einreichungen beginnen.',

   'Grade bubblesheet exams, upload/download bubblesheet data files, and review previously graded bubblesheet exams.'
=> 'Bubblesheet-Prüfungen bewerten, Bubblesheet-Datendateien hoch- bzw. herunterladen und überprüfen zuvor bewerteter Bubblesheet-Prüfungen.',

   'Grade all selected students in a grading table.'
=> 'Alle ausgewählte Studierende in einer Tabelle bewerten.',

   'Select individual students to grade and view submissions.'
=> 'Einzelne Studierende auswählen, um deren Einreichungen zu betrachten oder diese zu bewerten.',

   'Course Grading'
=> 'Leistungen bewerten',

   'Grade Complete Folder for One Student'
=> 'Für eine Person vollständiges Verzeichnis bewerten',

   'The <b>complete</b> page/sequence/folder: For one student'
=> 'Seite/Sequenz/Verzeichnis <em>vollständig</em> für eine Person bewerten.',

   'Revert to Default'
=> 'Auf voreingestellte Bepunktung zurücksetzen',

   'fullname'
=> 'Vollständiger Name',

   'Fullname'
=> 'Vollständiger Name',

   '(problem weight)'
=> '(Aufgabengewichtung)',

   'No.'
=> 'Nr.',

   'Grade Current Resource'
=> 'Bewerte derzeitige Ressource',

   'Submission Status'
=> 'Status der Einreichung',

   'last submission only'
=> 'nur letzte Einreichung',

   'last submission &amp; parts info'
=> 'letzte Einreichung und Aufgabenteil-Information',

   'by dates and submissions'
=> 'sortiert nach Datum und Einreichung',

   'all details'
=> 'alle Details anzeigen',

   'one student'
=> 'eine Person',

   'all students'
=> 'alle Studierende',

   'View Problem Text'
=> 'Aufgabentext anzeigen',

   'View Answer'
=> 'Antworten anzeigen',

   'View Submissions'
=> 'Einreichungen anzeigen',

   'Grading Increments'
=> 'Punktschrittweite',

   'Whole Points'
=> 'Ganze Punkte',

   'Half Points'
=> 'Halbe Punkte',

   'Quarter Points'
=> 'Viertelpunkte',

   'Tenths of a Point'
=> 'Zehntelpunkte',

   'View Submissions for a Student or a Group of Students'
=> 'Einreichungen eines/r Studenten/in oder einer Gruppe von Studierenden betrachten',

   'View/Grade/Regrade Submissions for a Student or a Group of Students'
=> 'Einreichungen eines/r Studenten/in oder einer Gruppe von Studierenden betrachten/bewerten/erneut bewerten',

   "To view a submission or a group of submissions, click on the check box(es) next to the student's name(s). Then click on the Next button."
=> "Wählen Sie die Namen der Studierenden aus, um eine Einreichung oder eine Gruppe von Einreichungen zu betrachten. Klicken Sie dann auf Weiter.",

   "To view/grade/regrade a submission or a group of submissions, click on the check box(es) next to the student's name(s). Then click on the Next button."
=> "Wählen Sie die Namen der Studierenden aus, um eine Einreichung oder eine Gruppe von Einreichungen zu betrachten/zu bewerten/erneut zu bewerten. Klicken Sie dann auf Weiter.",

   'Check Section/Group'
=> 'Sektion/Gruppe auswählen',

   'Check For Plagiarism'
=> 'Auf Plagiate überprüfen',

   'Please select the student before clicking on the Next button.'
=> 'Bitte wählen Sie eine Person aus, bevor Sie auf Weiter klicken.',

   'Please select a student or group of students before clicking on the Next button.'
=> 'Bitte wählen Sie eine Person oder Gruppe von Personen aus, bevor Sie auf Weiter klicken.',

   'Select a student you wish to grade and then click on the Next button.'
=> 'Wählen Sie eine Person aus, um deren Einreichungen zu bewerten, und klicken Sie dann auf Weiter.',

   'Verify Receipt No.'
=> 'Nachweis-Nr. überprüfen',

   'Please enter a receipt number given by a student in the receipt box.'
=> 'Bitte geben Sie die Nachweisnummer ein, die der/die Student/in erhalten hat.',

   'No match found for the above receipt number.'
=> 'Für die angegebene Nachweisnummer konnte kein/e Student/in gefunden werden.',

   'The above receipt number matches the following [quant,_1,student].'
=> 'Die angegebene Nachweisnummer passt zu folgenden/m/r [quant,_1,Studenten/in,Studierenden].',

   'Problems from'
=> 'Aufgaben aus',

   'Grade Status'
=> 'Bewertungsstatus',

   'Override "Correct"'
=> '"Korrekt" überschreiben',

   'reset status'
=> 'Status zurücksetzen',

   'excused'
=> 'Aufgabe erlassen',

   'Problems graded correct by the computer are marked with a [_1] symbol.'
=> 'Aufgaben, die als korrekt bewertet wurden, sind mit [_1] gekennzeichnet.',

   'Part(s) graded correct by the computer is marked with a [_1] symbol.'
=> 'Aufgabenteile, die als korrekt bewertet wurden, sind mit [_1] gekennzeichnet.',

   'Add Records'
=> 'Aufzeichnungen hinzufügen',

   'Add records'
=> 'Aufzeichnungen hinzufügen',

   'Require return receipt?'
=> 'Mit Empfangsbestätigung?',

   'Self-enrollment requests need approval?'
=> 'Bestätigung der Selbsteintragungs-Wünsche notwendig',

   'Enrollment limit'
=> 'Belegungsbeschränkung',

   'Personnel to be notified when an enrollment request needs approval, or has been approved:'
=> 'Personal, das darüber informiert werden soll, wenn Belegungswünsche bestätigt werden müssen bzw. bestätigt wurden:',

   'No limit'
=> 'Keine Beschränkung',

   'Limit by total students'
=> 'Beschränkt auf Gesamtanzahl Studierender',

   'Limit by total self-enrolled students'
=> 'Beschränkt auf Gesamtanzahl selbsteintragender Studierender',

   'Maximum number allowed: '
=> 'Maximal erlaubte Anzahl: ',

   'Maximum enrollment setting unchanged.'
=> 'Maximale Eintragungseinstellung nicht geändert.',

   'The value provided was invalid - it must be a positive integer if enrollment is being limited.'
=> 'Der eingetragene Wert ist ungültig - verwenden Sie eine positive ganze Zahl, wenn die Selbsteintragung beschränkt werden soll.',

   'New self-enrollment no longer allowed when total (all students) reaches [_1].'
=> 'Neue Selbsteintragungen sind nicht mehr erlaubt, wenn Gesamtanzahl aller Studenten [_1] erreicht hat.',

   'New self-enrollment no longer allowed when total number of self-enrolled students reaches [_1].'
=> 'Neue Selbsteintragungen sind nicht mehr erlaubt, wenn Gesamtanzahl selbsteingetragener Studenten [_1] erreicht hat.',

   'The following will be notified when an enrollment request needs approval, or has been approved: [_1].'
=> 'Die folgenden Benutzer werden benachrichtigt, wenn Belegungswünsche bestätigt werden müssen bzw. bestätigt wurden: [_1]',

   'No notifications sent when an enrollment request needs approval, or has been approved.'
=> 'Es wird keine Benachrichtigung gesendet, wenn Belegungswünsche bestätigt werden müssen bzw. bestätigt wurden.',

   'Enrollment requests'
=> 'Belegungswünsche',

   'Pending enrollment requests'
=> 'Noch ausstehende Belegungswünsche',

   'Enrollment request processing'
=> 'Belegungswünsche werden verarbeitet',

   'Requestor'
=> 'Anforderer',

   'Date requested'
=> 'Datum des Antrags',

   'Approve'
=> 'Bestätigen',

   'Reject'
=> 'Ablehnen',

   'There are currently no enrollment requests.'
=> 'Derzeit gibt es keine Belegungswünsche',

   'The following were enrolled in the course:'
=> 'Folgende Benutzer wurden in den Kurs aufgenommen:',

   'The following were enrolled in the community:'
=> 'Folgende Benutzer wurden in die Community aufgenommen:',

   'The following enrollment requests were rejected:'
=> 'Folgende Belegungswünsche wurden abgelehnt:',

   'Action was taken on the following course and community requests by [_1].'
=> 'Die folgenden Kurs-/Community-Anträge wurden durch [_1] bearbeitet.',

   'The following enrollment requests were deleted because the user is already enrolled in the course:'
=> 'Folgende Belegungswünsche wurden entfernt, da der Benutzer bereits im Kurs ist:',

   'The following enrollment requests were ignored because the request is no longer in the enrollment queue:'
=> 'Folgende Belegungswünsche wurden nicht berücksichtigt, da sich der Belegungswunsch nicht länger in der Belegungswarteschlange befindet:',

   'The following enrollment requests were deleted because the requestor does not have a LON-CAPA account:'
=> 'Folgende Belegungswünsche wurden entfernt, da der Anforderer keinen LON-CAPA-Account hat:',

   'The following enrollment requests were skipped because the enrollment limit has been reached for the course:'
=> 'Folgende Belegungswünsche wurden ausgelassen, da die Belegungsgrenze für diesen Kurs erreicht wurde:',

   'The following enrollment requests could not be processed because an error occurred:'
=> 'Folgende Belegungswünsche konnten nicht verarbeitet werden, da ein Fehler aufgetreten ist:',

   'Consequently, although a new role was created for you in the course, you will not be able to select this role until [_1].'
=> 'Auch wenn für Sie die neue Benutzerrolle im Kurs bereits angelegt wurde, können Sie die Rolle erst ab [_1] auswählen.',

   'Consequently, although a new role was created for you in the course, it is an inactive role which does not provide access to the course.'
=> 'Auch wenn für Sie die neue Benutzerrolle im Kurs bereits angelegt wurde, handelt es sich um eine inaktive Rolle, die keinen Zugriff auf den Kurs gestattet.',

   'The enrollment limit of [quant,_1,student] has been reached.'
=> 'Die Belegungsgrenze von [quant,_1,Student,Studenten] wurde erreicht.',

   'The enrollment limit of [quant,_1,self-enrolled student] has been reached.'
=> 'Die Belegungsgrenze von [quant,_1,selbsteingetragenen Studenten,selbsteingetragenen Studenten] wurde erreicht.',

   'A self-enrollment request already exists for you for this course.'
=> 'Für Sie existiert bereits ein Selbsteintragungswunsch für diesen Kurs.',

   'Your earlier request was submitted: [_1] and remains in a queue awaiting action by a Course Coordinator.'
=> 'Ihr vorheriger Wunsch wurde am [_1] abgeschickt und verbleibt in der Warteschlange, um vom Kurs-Koordinator abgearbeitet zu werden.',

   'Your request for self-enrollment has been recorded.'
=> 'Ihr Wunsch auf Selbsteintragung wurde aufgenommen.',

   'A message will be sent to your LON-CAPA account when the course coordinator takes action on your request.'
=> 'Sobald der Kurs-Koordinator Ihren Antrag abgearbeitet hat, wird an Ihren LON-CAPA-Account eine Nachricht gesendet.',

   'A message will be sent to your LON-CAPA account when a domain coordinator takes action on your request.'
=> 'Sobald ein Domänen-Koordinator Ihren Antrag abgearbeitet hat, wird an Ihren LON-CAPA-Account eine Nachricht gesendet.',

   'An e-mail will also be sent to: [_1] when this occurs.'
=> 'Wenn dies passiert, wird ebenfalls eine E-Mail an [_1] gesendet.',

   'An error occurred when recording your request.'
=> 'Beim Aufnehmen Ihres Belegungswunsches ist ein Fehler aufgetreten.',

   'Self-enrollment requests processed'
=> 'Die Selbsteintragungswünsche wurden abgearbeitet',

   'Enrollment requests in the following course: [_1] have been processed.'
=> 'Belegungswünsche für den Kurs [_1] wurden abgearbeitet.',

   'Your request for enrollment in the following course: [_1]requested on [_2]has been reviewed by a Course Coordinator.'
=> 'Ihr Belegungswunsch vom [_2] für den Kurs [_1] wurde durch einen Kurs-Koordinator überprüft.',

   'Your request for enrollment in the following community: [_1]requested on [_2]has been reviewed by a Coordinator.'
=> 'Ihr Belegungswunsch vom [_2] für die Community [_1] wurde durch einen Koordinator überprüft.',

   'Self-enrollment request'
=> 'Selbsteintragungswunsch',

   'Your request for enrollment has been approved.'
=> 'Ihr Belegungswunsch wurde bestätigt.',

   'Your request for enrollment has not been approved.'
=> 'Ihr Belegungswunsch wurde nicht bestätigt.',

   'Your course request has been approved.'
=> 'Ihr Kursantrag wurde bestätigt.',

   'Your course request has not been approved.'
=> 'Ihr Kursantrag wurde abgelehnt.',

   'Your community request has been approved.'
=> 'Ihr Community-Antrag wurde bestätigt.',

   'Your community request has not been approved.'
=> 'Ihr Community-Antrag wurde abgelehnt.',

   'Your request for an author role has been approved.'
=> 'Ihr Antrag auf eine Autorenrolle wurde bestätigt.',

   'As Coordinator, use: [_1]Main Menu -> Manage Community Users -> Enrollment Requests[_2]to display a list of pending enrollment requests, which you can either approve or reject.'
=> 'Um eine Liste aller noch offenen Belegungswünsche anzuzeigen, wählen Sie als Koordinator: [_1]Hauptmenü -> Community-Teilnehmer verwalten -> "Belegungswünsche".[_1]Diese können dort bestätigt bzw. abgelehnt werden.',

   'As Course Coordinator, use: [_1]Main Menu -> Manage Course Users -> Enrollment Requests[_2]to display a list of pending enrollment requests, which you can either approve or reject.'
=> 'Um eine Liste aller noch offenen Belegungswünsche anzuzeigen, wählen Sie als Kurs-Koordinator: [_1]Hauptmenü -> Kursteilnehmer verwalten -> "Belegungswünsche".[_1]Diese können dort bestätigt bzw. abgelehnt werden.',

   'Visit [_1] to log-in and access the course'
=> 'Gehen Sie nach [_1], um sich anzumelden und Zugriff auf den Kurs zu erhalten.',

   'Visit [_1] to log-in and access the community'
=> 'Gehen Sie nach [_1], um sich anzumelden und Zugriff auf die Community zu erhalten.',

   'Approved enrollments:'
=> 'Bestätigte Belegungen:',

   'Rejected enrollments:'
=> 'Abgelehnte Belegungen',

   'Approved course requests:'
=> 'Bestätigte Kursanträge:',

   'Rejected course requests:'
=> 'Abgelehnte Kursanträge:',

   'An error occurred generating the validation code[_1] required for an e-mail address to be used as username.'
=> 'Beim Erstellen des Validierungscodes, der zur Verwendung der Benutzerkennung als E-Mail-Adresse notwendig ist[_1]ist ein Fehler aufgetreten.',

   '[_1]Contact the helpdesk[_2] or [_3]reload[_2] the page and try again.'
=> 'Kontaktieren Sie das [_1]Helpdesk[_2] oder [_3]laden Sie die Seite neu[_2] und versuchen es noch einmal.',

   'An error occurred saving a personal record of your request.'
=> 'Beim Speichern eines persönlichen Datensatzes Ihrer Anforderung ist ein Fehler aufgetreten.',

   'An error occurred saving a record of the details of your request: [_1].'
=> 'Beim Speichern eines Datensatzes mit den Details Ihrer Anforderung ist ein Fehler aufgetreten: [_1].',

   'An error occurred saving a record of the status of your request: [_1].'
=> 'Beim Speichern eines Datensatzes mit dem Status Ihrer Anforderung ist ein Fehler aufgetreten: [_1].',

   'Enrollment requests pending Course Coordinator approval'
=> 'Belegungswünsche, die auf Bestätigung durch den Kurs-Koordinator warten',

   ' not allowed to participate in chat room.'
=> ' nicht gestattet am Chatroom teil zu nehmen.',

   'Everyone can participate in chat room.'
=> 'Jeder kann am Chatroom teilnehmen.',

   'Chat Room will be unavailable to you until [_1] because communication is blocked in one or more of your courses:'
=> 'Der Chatroom ist bis [_1] nicht erreichbar, weil die Kommunikation in einem oder mehreren Ihrer Kurse geblockt ist:',

   'Branch'
=> 'Zweig',

   'Can Request Official Courses'
=> 'Darf offizielle Kurse beantragen',

   'Can Request Unofficial Courses'
=> 'Darf inoffizielle Kurse beantragen',

   'Can Request Textbook Courses'
=> 'Darf Lehrbuch-Kurse beantragen',

   'Can request creation of textbook courses'
=> 'Darf die Erstellung von Lehrbuch-Kursen beantragen',

   'Disk space allocated to portfolio files'
=> 'Speicherplatz für Portfolio-Dateien',

   'Personal Information Page Availability'
=> 'Verfügbarkeit der persönlichen Seite',

   'Blog Availability'
=> 'Blog-Verfügbarkeit',

   'Portfolio Availability'
=> 'Portfolio-Verfügbarkeit',

   'Tools:'
=> 'Werkzeuge:',

   'Upload PDF Form'
=> 'PDF-Formular hochladen',

   'Upload a PDF Form with filled Form Fields'
=> 'Hochladen eines PDF-Formulars mit ausgefüllten Formularfeldern',

   'Please choose a PDF-File.'
=> 'Bitte wählen Sie eine PDF-Datei aus.',

   "Can't find any valid PDF form fields."
=> 'Konnte keine PDF-Formularfelder finden',

   'Results of PDF Form problems'
=> 'Ergebnisse der PDF-Formular-Aufgaben',

   'Request creation of a course or community'
=> 'Antrag auf Erstellung von Kursen oder Communitys',

   'You have rights to request the creation of courses and/or communities in the following domain(s):'
=> 'Sie haben die Berechtigung, die Erstellung von Kursen und/oder Communitys in den folgenden Domänen zu beantragen:',

   '[_1]Official course[_2] in domain: [_3]'
=> '[_1]Offizieller Kurs[_2] in Domäne: [_3]',

   '[_1]Unofficial course[_2] in domain: [_3]'
=> '[_1]Inoffizieller Kurs[_2] in Domäne: [_3]',

   '[_1]Community[_2] in domain: [_3]'
=> '[_1]Community[_2] in Domäne: [_3]',

   'Use the [_1]request form[_2] to submit a request for creation of a new course or community.'
=> 'Verwenden Sie das [_1]Antragsformular[_2], um die Erstellung eines neuen Kurses oder einer neuen Community zu beantragen.',

   'A number equal or greater than 0 is expected. Entered value = '
=> 'Es wird eine Eingabe größer oder gleich 0 erwartet. Eingegebener Wert = ',

   'A role with no section will be added'
=> 'Es wird eine Rolle ohne Sektion hinzugefügt',

   'Access will be set to continue indefinitely'
=> 'Der Zugriff wird unbegrenzt gültig sein',

   'Access will be set to start immediately'
=> 'Der Zugriff wird ab sofort gültig sein',

   'Add a user with a co- or assistant author role.'
=> 'Einen Benutzer mit Co-Autor- oder Autor-Assistenten-Rolle hinzufügen',

   'Add a user with the role of student to this course'
=> 'Einen Benutzer mit studentischer Rolle diesem Kurs hinzufügen',

   'Recipients'
=> 'Empfänger',

   'Recipents'
=> 'Empfänger',

   '[quant,_1,recipient]'
=> '[quant,_1,Empfänger,Empfänger]',

   'Additional recipient:'
=> 'Weiterer Empfänger:',

   'Allow limited HTML in discussion'
=> 'Eingeschränkte HTML-Nutzung in Diskussion erlauben',

   'Although your current role has privileges to view any existing groups in this course, you do not have privileges to create new groups.'
=> 'Die derzeit ausgewählte Rolle erlaubt zwar das Betrachten existierender Gruppen, nicht aber das Erstellen neuer Gruppen.',

   'An error occurred opening the export file for posting'
=> 'Beim Öffnen der Exportdatei für Beiträge ist ein Fehler aufgetreten',

   'An error occurred opening the manifest file.'
=> 'Beim Öffnen der Manifestdatei ist ein Fehler aufgetreten.',

   'Announcements and my calendar'
=> 'Bekanntmachungen und Kalender',

   'Are you sure you want to delete this post?'
=> 'Sind Sie sicher, dass Sie diesen Beitrag löschen wollen?',

   'Deleted posts will no longer be visible to you and other students'
=> 'Gelöschte Beiträge werden sowohl für Sie als auch für andere Studierende nicht mehr sichtbar sein,',

   'but will continue to be visible to your instructor'
=> 'werden aber weiterhin für Ihren Dozenten sichtbar sein.',

   'Deleted posts will no longer be visible to you or anyone else.'
=> 'Gelöschte Beiträge werden sowohl für Sie als auch für Andere nicht mehr sichtbar sein.',

   'Category'
=> 'Kategorie',

   'Choose a category to display'
=> 'Wählen Sie ein anzuzeigende Kategorie',

   'Choose a subcategory to display'
=> 'Wählen Sie eine anzuzeigende Unterkategorie',

   'Change Parameter Selection'
=> 'Parameterauswahl ändern',

   'No messages have been selected to apply this action to.'
=> 'Es wurden keine Nachrichten für die Aktion ausgewählt.',

   'Check the checkbox for at least one message.'
=> 'Wählen Sie mindestens eine Nachricht aus.',

   'Classlist of all students'
=> 'Kursteilnehmerliste aller Studierenden',

   'Classlists and Staff Listing'
=> 'Kursteilnehmer- und Personallisten',

   'Clone From'
=> 'Klonen von',

   'Clone content and settings from an existing course?'
=> 'Inhalt und Einstellungen von einem vorhandenen Kurs klonen?',

   'Clone content and settings from an existing community?'
=> 'Inhalt und Einstellungen von einer vorhandenen Community klonen?',

   'Course Configuration'
=> 'Kurskonfiguration',

   'Course Contents'
=> 'Inhaltsverzeichnis',

   'Community Content'
=> 'Community-Inhalt',

   'Community Contents'
=> 'Community-Inhalt',

   'Course Policy'
=> 'Kursrichtlinien',

   'Course Requests'
=> 'Anträge auf Kurserstellung',

   'Course Request'
=> 'Antrag auf Kurserstellung',

   'Community Request'
=> 'Antrag auf Community-Erstellung',

   'Course Request Details'
=> 'Details des Kursantrags',

   'Community Request Details'
=> 'Details des Community-Antrags',

   'Course/Community Request Details'
=> 'Details des Kurs-/Community-Antrags',

   'Course/Community Requests'
=> 'Anträge auf Kurs-/Community-Erstellung',

   'Course/Community requests'
=> 'Anträge auf Kurs-/Community-Erstellung',

   'Create a New Slot'
=> 'Neuen Slot erstellen',

   'Current recipient:'
=> 'Derzeitiger Empfänger:',

   'Current recipients:'
=> 'Derzeitige Empfänger:',

   'Date Submitted:'
=> 'Einreichungsdatum:',

   'Disallowed:'
=> 'Nicht gestattet:',

   'disallowed'
=> 'nicht gestattet',

   'allowed'
=> 'gestattet',

   'Discussion and Chat'
=> 'Diskussion und Chatroom',

   'Discussion for'
=> 'Diskussion für',

   'Display Categories'
=> 'Kategorien anzeigen',

   'Display Groups'
=> 'Gruppen anzeigen',

   'Display List of Users'
=> 'Benutzerliste anzeigen',

   'Display of resources '
=> 'Anzeige von Ressourcen ',

   'Display/Edit Settings'
=> 'Einstellungen anzeigen/bearbeiten',

   'Back to display/edit settings'
=> 'Zurück zu "Einstellungen anzeigen/bearbeiten"',

   'Drop Members'
=> 'Mitglieder ausschließen',

   'Edit Course Configuration'
=> 'Kurskonfiguration bearbeiten',

   'Enroll one member'
=> 'Ein Mitglied eintragen',

   'Enroll Another Member'
=> 'Ein weiteres Mitglied eintragen',

   'Enroll Member'
=> 'Mitglied eintragen',

   'Enroll one member: '
=> 'Ein Mitglied eintragen: ',

   'Feedback Settings'
=> 'Feedback-Einstellungen',

   'Feedback messages'
=> 'Feedback-Nachrichten',

   'Feedback sent'
=> 'Feedback wurde gesendet',

   'Feedback not sent'
=> 'Feedback wurde nicht gesendet',

   'Filters'
=> 'Filter',

   'Force use of a specific math rendering engine'
=> 'Bestimmte Darstellungsmethode wissenschaftlicher Formeln erzwingen',

   'General course settings'
=> 'Allgemeine Kurs-Einstellungen',

   'General message text'
=> 'Allgemeiner Nachrichtentext',

   "Go to group's home page"
=> 'Zur Gruppenhomepage',

   'Hide detailed Parameter Selection'
=> 'Detaillierte Parameterauswahl verbergen',

   'Import Document'
=> 'Dokument importieren',

   'Import Documents'
=> 'Dokumente importieren',

   'Language and Time Localization'
=> 'Sprache und Zeitzone',

   'Language and time localization'
=> 'Sprache und Zeitzone',

   'Math display settings'
=> 'Einstellungen zur Darstellung wissenschaftlicher Formeln',

   'Messages & Notifications'
=> 'Nachrichten und Benachrichtigungen',

   'Min Tries'
=> 'Min. Anz. Vers.',

   'Minimum Number of Tries'
=> 'Minimale Anzahl an Versuchen',

   'Modify course configuration'
=> 'Kurskonfiguration ändern',

   'More Options'
=> 'Mehr Optionen',

   'Neutral'
=> 'Neutral',

   'New Name for Folder'
=> 'Neuer Verzeichnisname',

   'New posts marked as read'
=> 'Neue Beiträge wurden als gelesen markiert',

   'New request'
=> 'Neuer Antrag',

   'No Chat room use'
=> 'Keine Chatroom-Nutzung',

   'No Resource Discussion'
=> 'Keine Ressourcendiskussion',

   'No message or record in user notes'
=> 'Keine Nachricht oder Aufzeichnung in Benutzeranmerkungen',

   'No slots have been created in this course.'
=> 'Es wurden keine Slots für diesen Kurs angelegt.',

   'No slots have been created in this community.'
=> 'Es wurden keine Slots für diese Community angelegt.',

   'No user personal information page available'
=> 'Keine persönliche Seite des Benutzers verfügbar',

   'No viewable classlist'
=> 'Keine einsehbare Kursteilnehmerliste',

   'No viewable membership list'
=> 'Keine einsehbare Mitgliedschaftsliste',

   'Official course'
=> 'Offizieller Kurs',

   'Other settings'
=> 'Andere Einstellungen',

   'Page Title'
=> 'Seitentitel',

   'Problem Title'
=> 'Aufgabentitel',

   'Parameter Specification'
=> 'Parameter-Spezifikation',

   'Resource Specification'
=> 'Ressourcen-Spezifikation',

   'User Specification (optional)'
=> 'Benutzer-Spezifikation (optional)',

   'Pick the criteria to use to build a list of course users from which you will select additional members of the group.'
=> 'Wählen Sie Kriterien aus, um eine Liste von Kursteilnehmern zu erstellen, aus der Sie dann weitere Gruppenmitglieder auswählen können.',

   'Pick the criteria to use to build a list of course users from which you will select members of the new group.'
=> 'Wählen Sie Kriterien aus, um eine Liste von Kursteilnehmern zu erstellen, aus der Sie dann Gruppenmitglieder für die neue Gruppe auswählen können.',

   'Points'
=> 'Punkte',

   'Privileged users (Domain Coordinators) in staff listing'
=> 'Privilegierte Benutzer (Domänen-Koordinatoren) auf der Personalliste',

   'Questions about:'
=> 'Frage zu:',

   'Registering'
=> 'Registrieren',

   'Request creation of a new course, or review your pending course requests.'
=> 'Antrag auf Kurserstellung stellen oder noch ausstehende Anträge überprüfen.',

   'Request creation of a new course, or review your pending requests.'
=> 'Antrag auf Kurserstellung stellen oder noch ausstehende Anträge überprüfen.',

   'Request creation of a new course or community, or review your pending requests.'
=> 'Antrag auf Kurs- oder Community-Erstellung stellen oder noch ausstehende Anträge überprüfen.',

   'Resource Content'
=> 'Ressourceninhalt',

   'Roles will be added for section(s):'
=> 'Rollen werden hinzugefügt für Sektion(en):',

   'Table of course contents'
=> 'Inhaltsverzeichnis',

   'Manage Reservations'
=> 'Reservierungen verwalten',

   'Manage reservations'
=> 'Reservierungen verwalten',

   'Manage Slots'
=> 'Slots verwalten',

   'Manage slots'
=> 'Slots verwalten',

   'Search for a user and enroll as a member'
=> 'Nach einem Benutzer suchen und als Teilnehmer den Kurs belegen lassen',

   "Sections will be switched to 'No section'"
=> "Sektionen werden auf 'Keine Sektion' geändert",

   'Sections will be switched to:'
=> 'Sektionen werden geändert auf:',

   'Select a destination folder to which the messages will be moved.'
=> 'Wählen Sie ein Zielverzeichnis, in das die Nachrichten verschoben werden sollen.',

   'Show Source'
=> 'Quelle anzeigen',

   'Show and manage co- or assistant authors.'
=> 'Anzeigen und verwalten von Co-Autoren und Autor-Assistenten.',

   'Show and manage users in this course.'
=> 'Anzeigen und verwalten von Benutzern in diesem Kurs.',

   'Spreadsheet: (with link to detailed scores)'
=> 'Beurteilungsbogen: (mit Link zu detaillierten Punkten)',

   'Spreadsheet (Detailed)'
=> 'Beurteilungsbogen (detailliert)',

   'Standard: shows points'
=> 'Standard: Zeige Punkte',

   'Statistics Main Page'
=> 'Hauptseite der Statistiken',

   'Published Map'
=> 'Veröffentlichte Inhaltszusammenstellung',

   'Size limit'
=> 'Größenbeschränkung',

   'String to display for answer:'
=> 'Ausdruck, der bei richtiger Antwort angezeigt werden soll:',

   'Student agreement needed to be listed'
=> 'Studentisches Einverständnis erforderlich, um aufgelistet zu werden',

   'Member agreement needed to be listed'
=> 'Einverständnis der Teilnehmer erforderlich, um aufgelistet zu werden',

   'Student-viewable classlist options'
=> 'Optionen zu der von Studierenden einsehbarer Kursteilnehmerliste',

   'Member-viewable membership list options'
=> 'Optionen zu der von Teilnehmern einsehbarer Teilnehmerliste',

   'The administrator of this domain has disabled personal information page functionality for this specific user.'
=> 'Der Administrator dieser Domäne hat die persönliche Seite für diesen Benutzer deaktiviert.',

   'The default privileges new members will receive are:'
=> 'Neue Mitglieder werden folgende voreingestellte Rechte erhalten:',

   'The domain has been configured to disable, by default, personal information page functionality for all users in the domain.'
=> 'Die Domäne ist so konfiguriert, dass persönliche Seiten standardmäßig für alle Benutzer in dieser Domäne deaktiviert sind.',

   'The file format for the uploaded portion of the message is'
=> 'Das Dateiformat für den hochgeladenen Teil der Nachricht ist',

   'The folder may not be renamed'
=> 'Das Verzeichnis kann nicht umbenannt werden',

   'The new folder may not be named'
=> 'Das neue Verzeichnis kann nicht benannt werden',

   'There are currently no resources or discussion boards with unread discussion postings.'
=> 'Derzeit gibt es keine Ressourcen oder Diskussionsforen mit ungelesenen Diskussionsbeiträgen.',

   'This is a result of one of the following:'
=> 'Dies ist das Ergebnis eines der folgenden:',

   'Timezone in which the course takes place'
=> 'Zeitzone, in der der Kurs stattfindet',

   "To enter multiple addresses, enter one address at a time, click 'Change' and then add the next one"
=> "Um mehrere Adressen einzugeben, geben Sie zuerst eine Adresse ein, bestätigen Sie diese mit 'Ändern' und geben Sie dann die nächste ein",

   'To replace the standard title for a course role, enter a title, otherwise leave blank'
=> 'Um den Standardtitel einer Rolle mit einem anderen Titel zu ersetzen, geben Sie einen Titel ein. Andernfalls lassen Sie das Feld leer.',

   'Tries Statistics'
=> 'Statistiken über Anzahl der Versuche',

   'URL of Syllabus'
=> 'URL des Kursüberblicks',

   'Unable to determine section, groups and access status'
=> 'Sektion, Gruppen und Zugriffsstatus konnten nicht festgestellt werden',

   'Upload Slot List'
=> 'Slot-Liste hochladen',

   'Users can edit/delete own discussion posts'
=> 'Benutzer dürfen eigene Diskussionsbeiträge bearbeiten und löschen',

   'Users can print problems as PDF forms and upload later for grading'
=> 'Benutzer dürfen Aufgaben als PDF-Formular drucken und später für die Bewertung hochladen',

   "View a user's recent activity"
=> 'Letzte Aktivitäten eines Benutzers betrachten',

   'View class lists'
=> 'Kursteilnehmerliste betrachten',

   'View recent activity of this student'
=> 'Letzte Aktivitäten dieses/r Studenten/in betrachten',

   'View/Modify/Cancel pending requests'
=> 'Ausstehende Anträge betrachten/bearbeiten/abbrechen',

   'You are not permitted to request creation of a community this domain.'
=> 'Sie sind nicht berechtigt, einen Antrag auf Erstellung einer Community in dieser Domäne zu stellen.',

   'You are not permitted to request creation of an official course in this domain.'
=> 'Sie sind nicht berechtigt, einen Antrag auf Erstellung eines offiziellen Kurses in dieser Domäne zu stellen.',

   'You are not permitted to request creation of an unofficial course in this domain.'
=> 'Sie sind nicht berechtigt, einen Antrag auf Erstellung eines inoffiziellen Kurses in dieser Domäne zu stellen.',

   'You must provide a (brief) community description.'
=> 'Sie müssen eine (kurze) Community-Beschreibung angeben.',

   'You must provide a (brief) course description.'
=> 'Sie müssen eine (kurze) Kursbeschreibung angeben.',

   'Requested name already in use for a system-provided or user-defined folder.'
=> 'Name bereits von einem Systemverzeichnis oder einem benutzerdefinierten Verzeichnis benutzt wird.',

#   'as you did not select an end date in the pop-up window'
#=> 'da Sie kein Endedatum in dem Pop-Up-Fenster ausgewählt haben',

#   "as you either selected the 'No section' option"
#=> "da Sie entweder die Option 'Keine Sektion' ausgewählt haben",

#   'or you did not select a section in the pop-up window'
#=> 'oder Sie haben keine Sektion in dem Pop-Up-Fenster ausgewählt',

   'Folder may not be renamed as it is a folder provided by the system.'
=> 'Das Verzeichnis kann nicht umbenannt werden, da es ein Systemverzeichnis ist.',

   'The folder "[_1]" may not be renamed as it is a folder provided by the system.'
=> 'Das Verzeichnis "[_1]" kann nicht umbenannt werden, da es ein Systemverzeichnis ist.',

   'member name'
=> 'Mitgliedsname',

   'role name'
=> 'Rollenname',

   "Classlist of viewer's section"
=> 'Kursteilnehmerliste der Sektion des Betrachters',

   "Membership of viewer's section"
=> "Mitgliedschaften der Sektion des Betrachters",

   'Default dates for student access'
=> 'Voreingestellte Datumswerte für studentischen Zugriff',

   'Replacement titles for standard course roles'
=> 'Ersatztitel, die statt den Standardtiteln für Rollen benutzt werden',

   '(applies when current role is student)'
=> '(trifft zu, falls als aktuelle Rolle Student/in gewählt ist)',

   '(overrides individual user preference)'
=> '(überschreibt individuelle Benutzereinstellungen)',

   '(role-based)'
=> '(rollen-basiert)',

   'Course Policy (role-based)'
=> 'Kursrichtlinien (rollen-basiert)',

   'Community Policy (role-based)'
=> 'Community-Richtlinien (rollen-basiert)',

   '- does not correspond to the name of an existing group'
=> '- entspricht nicht dem Namen einer existierenden Gruppe',

   'Currently using [_1] of the [_2] available.'
=> 'Momentan werden [_1] der verfügbaren [_2] verwendet.',

   '#Wrng'
=> 'Anz. Falsch',

   'Number of students whose final answer is wrong'
=> 'Anzahl Studierender, deren endgueltige Antwort falsch ist', # gnuplot! Umlaute?!?

   'Reset times on a single folder/map, resource or the course for a section or the whole class.'
=> 'Zeiten für ein einzelnes Verzeichnis/Inhaltszusammenstellung, eine Ressource oder den ganzen Kurs für eine Sektion oder den gesamten Kurs zurücksetzen.',

   'Reset times on one or more folders/maps, resources or the course for a single student.'
=> 'Zeiten für ein oder mehrere Verzeichnisse/Inhaltszusammenstellungen, Ressourcen oder den ganzen Kurs für eine/n Studenten/in zurücksetzen.',

   '(specific user(s))'
=> '(bestimmte/r Benutzer)',

   'Course Policy (specific user(s))'
=> 'Kursrichtlinien (bestimmte/r Benutzer)',

   'Community Policy (specific user(s))'
=> 'Community-Richtlinien (bestimmte/r Benutzer)',

   'Owner and Coordinators included automatically'
=> 'Eigentümer und Koordinatoren sind automatisch berechtigt',

   'A Community title is required'
=> 'Ein Community-Titel ist notwendig',

   'A coordinator role will be added with access to all sections'
=> 'Eine Koordinatoren-Rolle mit Zugriff auf alle Sektionen wird hinzugefügt',

   'A course coordinator role will be added with access to all sections.'
=> 'Eine Kurs-Koordinatoren-Rolle mit Zugriff auf alle Sektionen wird hinzugefügt.',

   "A group folder is added to the 'Community Groups' folder which contains folders for all groups in the community."
=> "Ein Gruppenverzeichnis, welches Verzeichnisse für alle Gruppen in der Community enthält, wird zum 'Community-Gruppen'-Verzeichnis hinzugefügt.",

   "A group folder is added to the 'Course Groups' folder which contains folders for all groups in the course."
=> "Ein Gruppenverzeichnis, welches Verzeichnisse für alle Gruppen im Kurs enthält, wird zum 'Kursgruppen'-Verzeichnis hinzugefügt.",

   'A problem occurred when attempting to reset the password for your account.'
=> 'Beim Zurücksetzen des Passwortes für Ihren Account ist ein Fehler aufgetreten.',

   'A problem occurred when attempting to reset the password for your account. Please try again from your [_1]home server[_2].'
=> 'Beim Zurücksetzen des Passwortes für Ihren Account ist ein Fehler aufgetreten. Bitte versuchen Sie es noch einmal von Ihrem [_1]Heimatserver[_2] aus.',

   '(Less ...)'
=> '(Weniger ...)',

   '(More ...)'
=> '(Mehr ...)',

   '(in [_1])'
=> '(in [_1])',

   'A request was submitted on [_1] for reset of the password for your LON-CAPA account.'
=> 'Ein Antrag auf Zurücksetzung des Passwortes für Ihren LON-CAPA-Account wurde am [_1] gestellt.',

   '[_1] LON-CAPA support team'
=> 'LON-CAPA-Kundenbetreuung - [_1]',

   'Add registered students automatically'
=> 'Registrierte Studierende automatisch hinzufügen',

   'Additional Display Specification (optional)'
=> 'Weitere Anzeige-Spezifikation (optional)',

   'Additional Personnel'
=> 'Weiteres Kurspersonal',

   'Additional language:'
=> 'Weitere Sprache:',

   'Additional options'
=> 'Weitere Optionen',

   'Affected User'
=> 'Betroffener Benutzer',

   'All types'
=> 'Alle Typen',

   'Although almost all community settings can be modified by a Coordinator, the following may only be set or modified by a Domain Coordinator:'
=> 'Obwohl fast alle Community-Einstellungen von einem Koordinator geändert werden können, können die folgenden nur von einem Domänen-Koordinator gesetzt oder geändert werden:',

   'Although almost all course settings can be modified by a Course Coordinator, the following may only be set or modified by a Domain Coordinator:'
=> 'Obwohl fast alle Kurs-Einstellungen von einem Kurs-Koordinator geändert werden können, können die folgenden nur von einem Domänen-Koordinator gesetzt oder geändert werden:',

   'An error occurred retrieving information about resources in the course.'
=> 'Beim Abrufen von Informationen zu Ressourcen in diesem Kurs ist ein Fehler aufgetreten.',

   'An error occurred retrieving the link to this problem.'
=> 'Beim Abrufen des Links zu dieser Aufgabe ist ein Fehler aufgetreten.',

   'An error occurred saving your request in the pending requests queue.'
=> 'Beim Speichern Ihrer Anfrage in der Warteschlange für ausstehende Anfragen ist ein Fehler aufgetreten.',

   'An error occurred storing the quota(s) for group portfolio files and/or uploaded content: '
=> 'Beim Speichern des Speicherplatzes für die Gruppen-Portfolio-Dateien ist ein Fehler aufgetreten: ',

   'An error occurred when processing your community request.'
=> 'Während der Verarbeitung Ihres Community-Antrags ist ein Fehler aufgetreten.',

   'An error occurred when processing your course request.'
=> 'Während der Verarbeitung Ihres Kursantrags ist ein Fehler aufgetreten.',

   'An error occurred when removing community settings which are no longer in use.'
=> 'Beim Entfernen von Community-Einstellungen, die nicht mehr genutzt werden, ist ein Fehler aufgetreten.',

   'An error occurred when removing course settings which are no longer in use.'
=> 'Beim Entfernen von Kurs-Einstellungen, die nicht mehr genutzt werden, ist ein Fehler aufgetreten.',

   'An error occurred when saving changes to community settings, which remain unchanged.'
=> 'Beim Speichern von Änderungen in den Community-Einstellungen, die unverändert geblieben sind, ist ein Fehler aufgetreten.',

   'An error occurred when saving changes to course settings, which remain unchanged.'
=> 'Beim Speichern der Änderungen an den Kurs-Einstellungen ist ein Fehler aufgetreten. Die Einstellungen bleiben unverändert.',

   'An error occurred when updating the pending requests queue: [_1]'
=> 'Bei der Aktualisierung der Warteschlange für ausstehende Anträge ist ein Fehler aufgetreten: [_1]',

   'Approval by Dom. Coord.'
=> 'Bestätigung des Domänen-Koordinators',

   'Approve or reject requests'
=> 'Anträge bestätigen oder ablehnen',

   'Approve or reject author role requests'
=> 'Anträge auf Autorenrollen bestätigen oder ablehnen',

   'Are you sure you want to cancel this request?'
=> 'Sind Sie sicher, dass Sie diesen Antrag stornieren wollen?',

   'Your request will be removed.'
=> 'Ihr Antrag wird entfernt.',

   'Assign one or more categories and/or subcategories to this course.'
=> 'Diesem Kurs eine oder mehrere Kategorien und/oder Unterkategorien zuweisen.',

   'Assign one or more subcategories to this community.'
=> 'Dieser Community eine oder mehrere Unterkategorien zuweisen.',

   'Assigned categories for this community'
=> 'Zugewiesene Kategorien für diese Community',

   'Assigned categories for this course'
=> 'Zugewiesene Kategorien für diesen Kurs',

   'Authentication mechanism'
=> 'Authentifizierungs-Methode',

   'Bcc: community participants with current access'
=> 'BCC: Community-Teilnehmer mit aktuellem Zugriff',

   'Bcc: community participants with expired access'
=> 'BCC: Community-Teilnehmer mit abgelaufenem Zugriff',

   'Bcc: community participants with future access'
=> 'BCC: Community-Teilnehmer mit zukünftigem Zugriff',

   'Because of this student/employee ID conflict, the new username - [_1] - has not been added to the LON-CAPA classlist'
=> 'Wegen des Konflikts mit der Studierenden-/Mitarbeiter-ID wurde der neue Benutzer [_1] nicht zur LON-CAPA-Kursteilnehmerliste hinzugefügt',

   'Bubblesheet'
=> 'Bubblesheet',

   'Cancel Request'
=> 'Antrag stornieren',

   'Cancel community request'
=> 'Community-Antrag stornieren',

   'Cancel course request'
=> 'Kursantrag stornieren',

   'Cancelling the request will remove it from the queue of pending community requests'
=> 'Stornieren des Antrages wird den Antrag aus der Warteschlange noch ausstehender Community-Anträge entfernen',

   'Cancelling the request will remove it from the queue of pending course requests'
=> 'Stornieren des Antrages wird den Antrag aus der Warteschlange noch ausstehender Kursanträge entfernen',

   'Check the checkboxes for all areas you wish to import from the IMS package:'
=> 'Wählen Sie all die Teile des IMS-Pakets, die Sie importieren möchten:',

   'Check username'
=> 'Benutzerkennung prüfen',

   'Choose another server.'
=> 'Wählen Sie einen anderen Server.',

   'Communities: description, section(s), status'
=> 'Communitys: Beschreibung, Sektion(en), Status',

   'community(s): description, section(s), status'
=> 'Community(s): Beschreibung, Sektion(en), Status',

   'Community Blog'
=> 'Community-Blog',

   'Community owner (permitted to assign Coordinator roles in the community).'
=> 'Community-Eigentümer (berechtigt, Koordinatoren-Rollen in der Community zu vergeben).',

   'Course owner (permitted to assign Course Coordinator roles in the course).'
=> 'Kurs-Eigentümer (berechtigt, Kurs-Koordinatoren-Rollen im Kurs zu vergeben).',

   'Confirm Cancellation'
=> 'Stornierung bestätigen',

   'Copy saved but not submitted.'
=> 'Kopie wurde gespeichert, aber nicht eingereicht.',

   'Current settings are:'
=> 'Aktuelle Einstellungen sind:',

   'Custom text for '
=> 'Benutzerdefinierter Text für ',

   'Define new user'
=> 'Neuen Benutzer anlegen',

   'Deleted setting for [_1]'
=> 'Einstellungen für [_1] gelöscht',

   'Display Actions'
=> 'Anzeige-Aktionen',

   'Display Course/Community Catalog link?'
=> 'Link zur Kurs-/Community-Übersicht anzeigen?',

   'View creation log'
=> 'Erstellungsprotokoll anzeigen',

   'Display information about when, how and by whom courses and communities were created in this domain.'
=> 'Zeige Informationen darüber, wann, wie und von wem Kurse und Communitys in dieser Domäne erzeugt wurden.',

   'Domain does not exist'
=> 'Domäne existiert nicht',

   'Drop unregistered students automatically'
=> 'Nicht registrierte Studierende automatisch ausschließen',

   'Enrollment'
=> 'Kursbelegung',

   'Enrollment Ends'
=> 'Kursbelegung endet',

   'Enrollment Starts'
=> 'Kursbelegung startet',

   'Enter a filename: '
=> 'Geben Sie einen Dateinamen ein: ',

   'Font Size'
=> 'Schriftgröße',

   'font-size'
=> 'Schriftgröße',

   'Format'
=> 'Format',

   'Go to Automated Enrollment Manager for course'
=> 'Zur Verwaltung der automatischen Kursbelegung des Kurses wechseln',

   'Go to the login page'
=> 'Zur Login-Seite wechseln',

   'Home Server for Course'
=> 'Heimatserver des Kurses',

   'ID/Student Number'
=> 'ID/Studierenden-Nummer',

   'IMS Export Failed'
=> 'IMS Export fehlgeschlagen',

   'If automated enrollment at your institution requires validation of course owners, automated enrollment will fail.'
=> 'Wenn die automatische Kursbelegung an Ihrer Institution eine Validierung durch die Kurs-Eigentümer benötigt, wird die automatische Kursbelegung fehlschlagen.',

   'If the member is currently logged-in to LON-CAPA, the new role will be available when the member next logs in.'
=> 'Wenn der Teilnehmer aktuell in LON-CAPA eingeloggt ist, so wird die neue Rolle erst verfügbar sein, wenn er sich das nächste mal einloggt.',

   'If unexpected discrepancies were detected, it is recommended that you inspect the original bubblesheets.'
=> 'Wenn unerwartete Abweichungen festgestellt werden, so wird empfohlen, die Original-Bubblesheets zu kontrollieren.',

   'Include other personnel?'
=> 'Weiteres Personal hinzufügen?',

   'Intended course owner does not exist'
=> 'Vorgesehener Kurs-Eigentümer existiert nicht',

   'Invalid LON-CAPA course number for the new course'
=> 'Ungültige LON-CAPA-Kursnummer für den neuen Kurs',

   'Invalid course ID'
=> 'Ungültige Kurs-ID',

   'Invalid filename: '
=> 'Ungültiger Dateiname: ',

   'Invalid format'
=> 'Ungültiges Format',

   'Invalid slot name: [_1]'
=> 'Ungültiger Slot-Name: [_1]',

   'LON-CAPA user(s) do(es) not exist.'
=> 'LON-CAPA Benutzer existiert/en nicht.',

   'LON-CAPA will automatically scale your uploaded file so the image will not exceed a width of 400px and a height of 500px.'
=> 'LON-CAPA wird die hochgeladene Datei automatisch skalieren, so dass das Bild eine Breite von 400px und eine Höhe von 500px nicht überschreitet.',

   'List of all members'
=> 'Liste aller Mitglieder',

   'Modifiable only by Domain Coordinator'
=> 'Nur vom Domänen-Koordinator veränderbar',

   'Name already used as a standard role name'
=> 'Name wird bereits als Standard-Rollenname verwendet',

   'Name already used as the name of a custom role'
=> 'Name wird bereits für eine benutzerdefinierte Rolle verwendet',

   'Name already used to replace a different standard role name'
=> 'Name wird bereits verwendet, um einen anderen Standard-Rollennamen zu ersetzen',

   'Next Item'
=> 'Nächstes Element',

   'No Domain Coordinators have community roles'
=> 'Keine Domänen-Koordinatoren haben Community-Rollen',

   'No Domain Coordinators have course roles'
=> 'Keine Domänen-Koordinatoren haben Kursrollen',

   'No categories defined in this domain'
=> 'In dieser Domäne sind keine Kategorien definiert',

   'No categories defined in this domain.'
=> 'In dieser Domäne sind keine Kategorien definiert.',

   'No course was found matching your choice of institutional course category.'
=> 'Zu Ihrer Auswahl der institutionellen Kurs-Kategorie wurde kein Kurs gefunden.',

   'No information was found for this community request.'
=> 'Zu diesem Community-Antrag wurden keine Informationen gefunden.',

   'No information was found for this course request.'
=> 'Zu diesem Kursantrag wurden keine Informationen gefunden.',

   'No record exists for the course ID'
=> 'Für diese Kurs-ID existieren keine Aufzeichnungen',

   'No settings chosen'
=> 'Keine Einstellungen ausgewählt',

   'No suitable categories defined for this course type in this domain.'
=> 'Für diesen Kurstyp sind in dieser Domäne keine geeigneten Kategorien definiert.',

   "None specified - use member's choice"
=> 'Nichts angegeben - Mitgliederauswahl wird verwendet',

   "None specified - use student's choice"
=> 'Nichts angegeben - Studierendenauswahl wird verwendet',

   'Not permitted'
=> 'Nicht gestattet',

   'Note: this will not take effect if the user already exists'
=> 'Beachten Sie, dass dies keine Auswirkungen haben wird, wenn der Benutzer bereits existiert',

   'OK'
=> 'OK',

   'ok'
=> 'ok',

   'Official'
=> 'Offiziell',

   'Official course:'
=> 'Offizieller Kurs:',

   'Only courses and communities created from servers running LON-CAPA [_1] or later are displayed.'
=> 'Es werden nur Kurse und Communitys angezeigt, die auf einem Server mit LON-CAPA-Version [_1] oder höher erzeugt wurden.',

   'Pending community requests'
=> 'Ausstehende Community-Anträge',

   'Pending course/community requests'
=> 'Ausstehende Kurs-/Community-Anträge',

   'Pending requests for official courses'
=> 'Ausstehende Anträge für offizielle Kurse',

   'Pending requests for unofficial courses'
=> 'Ausstehende Anträge für inoffizielle Kurse',

   'Personnel'
=> 'Personal',

   'Pick another action'
=> 'Eine andere Aktion wählen',

   'Problem is available at a different location.'
=> 'Die Aufgabe ist an einer anderen Position verfügbar.',

   'Problem is currently available.'
=> 'Die Aufgabe ist derzeit verfügbar.',

   'Problem is unavailable.'
=> 'Die Aufgabe ist nicht verfügbar.',

   'Problem will be available later.'
=> 'Die Aufgabe wird später verfügbar sein.',

   'Quit Grading'
=> 'Bewertung beenden',

   'Recipients of '
=> 'Empfänger von ',

   'Records/page:'
=> 'Aufzeichnungen/Seite:',

   'Redo'
=> 'wiederholen',

   'Requested'
=> 'Beantragt',

   'Requestor is automatically assigned Coordinator role.'
=> 'Dem Anforderer wird automatisch eine Koordinatoren-Rolle zugewiesen.',

   'Requestor is automatically assigned Course Coordinator role.'
=> 'Dem Anforderer wird automatisch eine Kurs-Koordinatoren-Rolle zugewiesen.',

   'Required'
=> 'Benötigt',

   'Return to Community Editor'
=> 'Zurück zum Community-Editor',

   'Return to reservations'
=> 'Zurück zu den Reservierungen',

   'Role(s) for [_1]'
=> 'Rolle(n) für [_1]',

   'Save Selected'
=> 'Ausgewählte speichern',

   'Save map'
=> 'Inhaltszusammenstellung speichern',

   'Save map and layout'
=> 'Inhaltszusammenstellung und Layout speichern',

   'Search for a user to add to course personnel'
=> 'Nach einem Benutzer suchen, um ihn als Kurspersonal hinzuzufügen',

   'Select a user to enroll as a member'
=> 'Auswahl eines Benutzers zur Kursbelegung als Teilnehmer',

   'Search for user'
=> 'Nach Benutzer suchen',

   'LON-CAPA Section(s)'
=> 'LON-CAPA-Sektion(en)',

   'LON-CAPA Sections'
=> 'LON-CAPA-Sektionen',

   'LON-CAPA section'
=> 'LON-CAPA-Sektion',

   'Section names may only contain letters or numbers.'
=> 'Sektionsnamen dürfen nur Buchstaben und Zahlen enthalten.',

   'Sections for auto-enrollment'
=> 'Sektionen für automatische Kursbelegung',

   'See course contents for further information.'
=> 'Verwenden Sie das Inhaltsverzeichnis für weitere Informationen.',

   'Select all that are [_1].'
=> 'Wählen Sie alle aus, die [_1] sind.',

   'Selected [_1]Problems[_2] from page [_3]'
=> 'Ausgewählte [_1]Aufgaben[_2] von Seite [_3]',

   'Selected [_1]Resources[_2] from page [_3]'
=> 'Ausgewählte [_1]Ressourcen[_2] von Seite [_3]',

   'Separate multiple sections with a comma.'
=> 'Trennen Sie mehrere Sektionen durch Kommata.',

   'Settings for this community have been left unchanged.'
=> 'Einstellungen für diese Community sind unverändert geblieben.',

   'Settings for this course have been left unchanged.'
=> 'Einstellungen für diesen Kurs sind unverändert geblieben.',

   'Skip hidden resources'
=> 'Verborgene Ressourcen überspringen',

   'Subcategory ...'
=> 'Unterkategorie ...',

   'Submit Grades'
=> 'Bewertungen einreichen',

   'Submit community request'
=> 'Community-Antrag einreichen',

   'Submit course request'
=> 'Kursantrag einreichen',

   'TeX error message: [_1]'
=> 'TeX-Fehlermeldung: [_1]',

   'The chosen course category [_1] is valid.'
=> 'Die ausgewählte Kurskategorie [_1] ist gültig.',

   'The community you selected is not a valid community in this domain'
=> 'Die Community, die Sie ausgewählt haben, ist keine gültige Community in dieser Domäne',

   'The course you selected is not a valid course in this domain'
=> 'Den Kurs, den Sie ausgewählt haben, ist kein gültiger Kurs in dieser Domäne',

   'The course roster is not up to date.'
=> 'Die Kursteilnehmerliste ist nicht aktuell.',

   'The disk space allocated for group portfolio files in this community is the default quota for this domain: [_1] MB.'
=> 'Der Speicherplatz, der für Gruppen-Portfolio-Dateien in dieser Community reserviert wurde, entspricht dem voreingestellten Speicherplatz dieser Domäne: [_1] MB.',

   'The disk space allocated for group portfolio files in this course is the default quota for this domain: [_1] MB.'
=> 'Der Speicherplatz, der für Gruppen-Portfolio-Dateien in diesem Kurs reserviert wurde, entspricht dem voreingestellten Speicherplatz dieser Domäne: [_1] MB.',

   'The disk space allocated for files uploaded to this course via the Content Editor is the default quota for this domain: [_1] MB.'
=> 'Der zugewiesene Speicherplatz für Dateien, die über den Inhaltseditor direkt in den Kurs hochgeladen wurden, entspricht dem voreingestellten Speicherplatz dieser Domäne: [_1] MB',

   'The disk space allocated for files uploaded to this community via the Content Editor is the default quota for this domain: [_1] MB.'
=> 'Der zugewiesene Speicherplatz für Dateien, die über den Inhaltseditor direkt in die Community hochgeladen wurden, entspricht dem voreingestellten Speicherplatz dieser Domäne: [_1] MB',

   'The disk space allocated for group portfolio files is now: [_1] MB.'
=> 'Der reservierte Speicherplatz für Gruppen-Portfolio-Dateien beträgt nun: [_1] MB.',

   'The disk space allocated for group portfolio files remains unchanged as [_1] MB.'
=> 'Der reservierte Speicherplatz für Gruppen-Portfolio-Dateien bleibt unverändert bei [_1] MB.',

   'The file was uploaded to the wrong course.'
=> 'Die Datei wurde in den falschen Kurs hochgeladen.',

   'The following changes occurred:'
=> 'Folgende Änderungen sind aufgetreten:',

   'The following course/community creation request rejections could not be fully processed because an error occurred:'
=> 'Die folgenden Kurs-/Community-Antrags-Ablehnungen konnten nicht vollständig bearbeitet werden, da ein Fehler aufgetreten ist:',

   'The following course/community creation requests could not be processed because an error occurred:'
=> 'Die folgenden Kurs-/Community-Anträge konnten nicht bearbeitet werden, da ein Fehler aufgetreten ist:',

   'The following course/community creation requests could not be processed because the owner does not have rights to create this type of course:'
=> 'Die folgenden Kurs-/Community-Anträge konnten nicht bearbeitet werden, da der Eigentümer keine Rechte hat, einen Kurs dieses Typs zu erstellen:',

   'The following course/community creation requests were deleted because the course or community has already been created:'
=> 'Die folgenden Kurs-/Community-Anträge wurden gelöscht, da der Kurs oder die Community bereits erstellt wurde:',

   'The following course/community creation requests were ignored because the request is no longer in the queue:'
=> 'Die folgenden Kurs-/Community-Anträge wurden ignoriert, da sie sich nicht länger in der Warteschlange befinden:',

   'The following courses/communities were created:'
=> 'Die folgenden Kurse/Communitys wurden erstellt:',

   'The following requested role: [_1] is unavailable.'
=> 'Die gewünschte Rolle [_1] ist nicht verfügbar.',

   'The following requested roles are unavailable:'
=> 'Die folgenden beantragten Rollen sind nicht verfügbar:',

   'The following requests were rejected:'
=> 'Die folgenden Anträge wurden abgelehnt:',

   'The following settings have been changed:'
=> 'Die folgenden Einstellungen wurden geändert:',

   'The following settings remain unchanged:'
=> 'Die folgenden Einstellungen blieben unverändert:',

   "The group folder is removed from the folder containing it - normally this is the 'Community Groups' folder which contains folders for all groups in the community."
=> "Das Gruppenverzeichnis wird aus dem Verzeichnis, in dem es sich befindet, entfernt - normalerweise ist dies das 'Community-Gruppen'-Verzeichnis, welches Verzeichnisse für alle Gruppe in der Community enthält.",

   "The group folder is removed from the folder containing it - normally this is the 'Course Groups' folder which contains folders for all groups in the course."
=> "Das Gruppenverzeichnis wird aus dem Verzeichnis, in dem es sich befindet, entfernt - normalerweise ist dies das 'Kurs-Gruppen'-Verzeichnis, welches Verzeichnisse für alle Gruppe im Kurs enthält.",

   'The name of the new file needs to end with an appropriate file extension to indicate the type of file to create.'
=> 'Der Name der neuen Datei muss mit einer geeigneten Dateiendung enden, um den Dateitypen, der erzeugt werden soll, anzugeben.',

   'The username of the Coordinator is required'
=> 'Die Benutzerkennung des Koordinators muss angegeben werden',

   'There are no active Domain Coordinators'
=> 'Es gibt keine aktiven Domänen-Koordinatoren',

   'There are no members currently enrolled.'
=> 'Derzeit sind keine Mitglieder eingetragen.',

   'There is currently no owner set for this community.'
=> 'Derzeit ist kein Eigentümer für diese Community eingetragen.',

   'There is currently no owner set for this course.'
=> 'Derzeit ist für diesen Kurs kein Eigentümer eingetragen.',

   'There is no owner associated with this LON-CAPA course.'
=> 'Mit diesem LON-CAPA-Kurs ist kein Eigentümer verknüpft.',

   'There was a problem processing your requested changes.'
=> 'Es gab ein Problem beim Verarbeiten Ihrer Änderungen.',

   'There was a problem with your course selection'
=> 'Es gab ein Problem mit Ihrer Kursauswahl',

   'There was a problem with your community selection'
=> 'Es gab ein Problem mit Ihrer Community-Auswahl',

   'This request has already been cancelled.'
=> 'Dieser Antrag wurde bereits storniert.',

   'This request has already been processed, and a course created.'
=> 'Der Antrag wurde bereits bearbeitet und ein Kurs erstellt.',

   'To access your LON-CAPA message, go to the Main Menu and click on "Send and Receive Messages".'
=> 'Um Zugriff auf Ihre LON-CAPA-Nachrichten zu erhalten, gehen Sie ins Hauptmenü und klicken auf "Kommunikation und Nachrichten".',

   'Tolerance'
=> 'Toleranz',

   'Unable to determine status due to network problems.'
=> 'Der Status konnte aufgrund von Netzwerkproblemen nicht ermittelt werden.',

   'Unable to retrieve information about community contents'
=> 'Es konnten keine Informationen über den Community-Inhalt abgerufen werden',

   'Unable to retrieve information about course contents'
=> 'Es konnten keine Informationen über den Kursinhalt abgerufen werden',

   'Unit'
=> 'Einheit',

   'Unknown type'
=> 'Unbekannter Typ',

   'Unofficial'
=> 'Inoffiziell',

   'unofficial'
=> 'inoffiziell',

   'official'
=> 'offiziell',

   'Unofficial course'
=> 'Inoffizieller Kurs',

   'Unofficial courses'
=> 'Inoffizielle Kurse',

   'Unrecognized course type: [_1]'
=> 'Unerkannter Kurstyp: [_1]',

   'Unsupported IMS format: [_1]'
=> 'Nicht unterstütztes IMS-Format: [_1]',

   'Upload IMS package'
=> 'IMS-Paket hochladen',

   'Upload a courses or communities attributes file'
=> 'Eine Kurs- oder Community-Attributedatei hochladen',

   'Upload Course/Community Attributes File'
=> 'Eine Kurs-/Community-Attributedatei hochladen',

   'Create Courses/Communities'
=> 'Kurse/Communitys erstellen',

   'Upload an attributes file containing specifications for one or more courses or communities in XML format.'
=> 'Eine Attributedatei hochladen, die Spezifikationen für ein oder mehrere Kurse oder Communitys im XML-Format beinhaltet.',

   'Uploaded file contained no data'
=> 'Die hochgeladene Datei enthält keine Daten',

   "Use 'Save' in the main window to save community categories"
=> "Verwenden Sie 'Speichern' im Hauptfenster, um die Community-Kategorien zu speichern",

   "Use 'Save' in the main window to save course categories"
=> "Verwenden Sie 'Speichern' im Hauptfenster, um die Kurs-Kategorien zu speichern",

   'Use the following link to enter the community:'
=> 'Verwenden Sie folgenden Link, um die Community zu betreten:',

   'Use the following link to enter the course:'
=> 'Verwenden Sie folgenden Link, um den Kurs zu betreten:',

   'Use the following links to your new roles to enter the community:'
=> 'Verwenden Sie den folgenden Link zu Ihrer neuen Rolle, um die Community zu betreten:',

   'Use the following links to your new roles to enter the course:'
=> ' Verwenden Sie den folgenden Link zu Ihrer neuen Rolle, um den Kurs zu betreten:',

   'User Search to enroll member'
=> 'Benutzersuche, um Mitglieder einzutragen',

   'User does not exist - username: [_1], domain: [_2].'
=> 'Benutzer existiert nicht - Benutzerkennung: [_1], Domäne: [_2].',

   'You are not permitted to create a LON-CAPA account.'
=> 'Sie sind nicht berechtigt, einen LON-CAPA-Account zu erstellen.',

   'You do not have privileges to request creation of courses or communities.'
=> 'Sie sind nicht berechtigt, die Erstellung von Kursen oder Communitys zu beantragen.',

   'You do not have rights to request creation of courses in this domain; please choose a different domain.'
=> 'Sie haben nicht die Berechtigung, die Erstellung von Kursen in dieser Domäne zu beantragen. Bitte wählen Sie eine andere Domäne.',

   'You do not have privileges to modify Portfolio, Blog or Personal Information Page settings for this user.'
=> "Sie sind nicht berechtigt, Portfolio-, Blog- oder die 'Persönliche Seite'-Einstellungen für diesen Benutzer zu ändern.",

   'You do not have privileges to modify Portfolio, Blog, WebDAV, or Personal Information Page settings for this user.'
=> "Sie sind nicht berechtigt, Portfolio-, Blog-, WebDAV- oder die 'Persönliche Seite'-Einstellungen für diesen Benutzer zu ändern.",

   'You may also add users later, once the community has been created, by using the "Manage community users" link, accessible from the "Main Menu".'
=> 'Sie können Benutzer auch später, nachdem die Community erstellt wurde, hinzufügen. Dafür verwenden Sie den Menüpunkt "Community-Teilnehmer verwalten", den Sie im "Hauptmenü" finden.',

   'You may also add users later, once the course has been created, by using the "Manage course users" link, accessible from the "Main Menu".'
=> 'Sie können Benutzer auch später, nachdem der Kurs erstellt wurde, hinzufügen. Dafür verwenden Sie den Menüpunkt "Kursteilnehmer verwalten", den Sie im "Hauptmenü" finden.',

   'You must select a course or community in the current domain'
=> 'Sie müssen einen Kurs oder eine Community aus der derzeitigen Domäne wählen',

   'You need to change one or more LON-CAPA section names - names may only contain letters or numbers.'
=> 'Sie müssen einen oder mehrere LON-CAPA-Sektionsnamen ändern - die Name dürfen nur aus Buchstaben und Ziffern bestehen.',

   'You need to change one or more LON-CAPA section names - none is a reserved word in the system, and may not be used.'
=> 'Sie müssen einen oder mehrere LON-CAPA-Sektionsnamen ändern - "nichts" ist ein reserviertes Wort in dem System und darf nicht verwendet werden.',

   'You need to reinitialize the course.'
=> 'Sie müssen die Kurs neu initialisieren.',

   'You need to re-initialize the course.'
=> 'Sie müssen die Kurs neu initialisieren.',

   'You need to reinitialize the community.'
=> 'Sie müssen die Community neu initialisieren.',

   'You need to re-initialize the community.'
=> 'Sie müssen die Community neu initialisieren.',

   'Your community request has been cancelled.'
=> 'Ihr Community-Antrag wurde storniert.',

   'Your community request has been recorded.'
=> 'Ihr Community-Antrag wurde gespeichert.',

   'Your community request has been updated'
=> 'Ihr Community-Antrag wurde aktualisiert',

   'Your community request was rejected.'
=> 'Ihr Community-Antrag wurde abgelehnt.',

   'Your course request has been cancelled.'
=> 'Ihr Kursantrag wurde storniert.',

   'Your course request has been recorded.'
=> 'Ihr Kursantrag wurde gespeichert.',

   'Your course request has been updated'
=> 'Ihr Kursantrag wurde aktualisiert',

   'Your course request was rejected.'
=> 'Ihr Kursantrag wurde abgelehnt.',

   'Your community request has been processed and the community has been created.'
=> 'Ihr Community-Antrag wurde bearbeitet und eine Community wurde erstellt.',

   'Your course request has been processed and the course has been created.'
=> 'Ihr Kursantrag wurde bearbeitet und ein Kurs wurde erstellt.',

   'Your file - [_1] - was uploaded successfully.'
=> 'Ihre Datei - [_1] - wurde erfolgreich hochgeladen.',

   'Your import is complete.'
=> 'Ihr Import ist abgeschlossen.',

   'Your limit is [_1].'
=> 'Ihre Begrenzung ist [_1].',

   'Your request has not been processed because you have reached the limit for the number of communities.'
=> 'Ihr Antrag wurde nicht bearbeitet, da Sie bereits die maximale Anzahl an Communitys erreicht haben.',

   'Your request has not been processed because you have reached the limit for the number of courses of this type.'
=> 'Ihr Antrag wurde nicht bearbeitet, da Sie bereits die maximale Anzahl an Kursen dieses Typs erreicht haben.',

   'Your request status is: [_1].'
=> 'Ihr Antragsstatus ist: [_1].',

   'Zoom in'
=> 'Ansicht vergrößern',

   'Zoom out'
=> 'Ansicht verkleinern',

   '[_1] Display Creation History'
=> '[_1] Erstellungshistorie anzeigen',

   '[_1] now set to: [_2]'
=> '[_1] nun geändert auf: [_2]',

   '[_1] set to [_2]'
=> '[_1] geändert auf [_2]',

   '[_1] set to "[_2]"'
=> '[_1] geändert auf "[_2]"',

   '[_1] set to: [_2].'
=> '[_1] geändert auf [_2]',

   '[_1] set to: [_2]'
=> '[_1] geändert auf [_2]',

   '[_1] set to [_2] MB'
=> '[_1] geändert auf [_2] MB',

   'Set to '
=> 'Geändert auf ',

   ' set to: '
=> ' geändert auf: ',

   '[_1] set to: none'
=> '[_1] geändert auf: nichts',

   '[_1] set to: off'
=> '[_1] geändert auf: aus',

   '[_1] was excluded because new users need to be from the course domain'
=> '[_1] wurde ausgeschlossen, da neue Benutzer aus der Domäne des Kurses stammen müssen',

   '[_1] was excluded because the domain is invalid'
=> '[_1] wurde ausgeschlossen, da die Domäne ungültig ist',

   '[_1] was excluded because the username or domain is invalid.'
=> '[_1] wurde ausgeschlossen, da die Benutzerkennung oder die Domäne ungültig ist.',

   '[_1] was excluded because the username violated format rules for the domain'
=> '[_1] wurde ausgeschlossen, da die Benutzerkennung gegen Formatregeln der Domäne verstößt',

   'Upload failed'
=> 'Hochladen ist fehlgeschlagen',

   'An error ([_1]) occurred when attempting to upload the file: [_2]'
=> 'Beim Hochladen der Datei [_2] ist ein Fehler aufgetreten: [_1]',

   'Not all entries could be matched!'
=> 'Es konnten nicht alle Einträge zugeordnet werden!',

   'The file: [_1] you attempted to upload contained no information. Please check that you entered the correct filename.'
=> 'Die Datei [_1], die Sie versucht haben hochzuladen, beinhaltet keine Informationen. Bitte überprüfen Sie, ob Sie den richtigen Dateinamen angegeben haben.',

   'clicker id'
=> 'Clicker-ID',

   'Clicker-ID'
=> 'Clicker-ID',

   'clicker-ID'
=> 'Clicker-ID',

   'passphrase not required'
=> 'Passwort nicht erforderlich',

   'passphrase protected'
=> 'passwortgeschützt',

   'Submit passphrase'
=> 'Passwort einreichen',

   'A low percentage of matches results from one of the following:'
=> 'Eine niedrige Trefferquote hat einen der folgenden Gründe:',

   'Access requires proctor validation.'
=> 'Zugriff benötigt Validierung durch das Aufsichtspersonal.',

   'Add another'
=> 'Weitere hinzufügen',

   'Affiliation'
=> 'Zugehörigkeit',

   'Affiliations'
=> 'Zugehörigkeiten',

   'Although this particular question type requires handgrading, the instructions for this question in the exam directed students to leave [quant,_1,line] blank on their bubblesheets.'
=> 'Obwohl dieser besondere Aufgabentyp eine manuelle Bewertung erforderlich macht, haben die Anweisungen zu dieser Aufgabe in der Prüfung die Studierenden veranlasst, [quant,_1,Zeile,Zeilen] auf ihren Bubblesheets leer zu lassen.',

   "An error occurred when updating the status of this request in the requestor's records: [_1]"
=> "Beim Aktualisieren des Status dieses Antrages in den Aufzeichnungen des Anforderers ist ein Fehler aufgetreten: [_1]",

   'Automated creation from batch file'
=> 'Automatisierte Erstellung durch Batch-Datei',

   'Can Request Communities'
=> 'Darf Communitys beantragen',

   'Can request creation of communities'
=> 'Darf die Erstellung von Communitys beantragen',

   'Can request creation of official courses'
=> 'Darf die Erstellung von offiziellen Kursen beantragen',

   'Can request creation of unofficial courses'
=> 'Darf die Erstellung von inoffiziellen Kursen beantragen',

   'Catalog settings in this domain are set in community context via "Community Configuration".'
=> 'Kurs-/Community-Übersicht-Einstellungen für diese Domäne werden im Community-Kontext über die "Community-Konfiguration" gesetzt.',

   'Catalog settings in this domain are set in course context via "Course Configuration".'
=> 'Kurs-/Community-Übersicht-Einstellungen für diese Domäne werden im Kurskontext über die "Kurskonfiguration" gesetzt.',

   'Category settings for communities in this domain should be modified in community context (via "[_1]Community Configuration[_2]").'
=> 'Kategorie-Einstellungen für Communitys in dieser Domäne sollten im Community-Kontext geändert werden (über die "[_1]Community-Konfiguration[_2]").',

   'Category settings for courses in this domain should be modified in course context (via "[_1]Course Configuration[_2]").'
=> 'Kategorie-Einstellungen für Kurse in dieser Domäne sollten im Kurskontext geändert werden (über die "[_1]Kurskonfiguration[_2]").',

   'Change reservation'
=> 'Reservierungen ändern',

   'Check Import first'
=> 'Prüfen Sie zuerst den Import',

   'Course portfolio files disk space'
=> 'Speicherplatz für Kurs-Portfolio-Dateien',

   'Community portfolio files disk space'
=> 'Speicherplatz für Community-Portfolio-Dateien',

   'Reservation History'
=> 'Reservierungshistorie',

   'Reservation needed'
=> 'Reservierung erforderlich',

   'Reservation needed: none available.'
=> 'Reservierung erforderlich: keine verfügbar.',

   'Reservation not available'
=> 'Reservierung nicht verfügbar',

   'Reservation status unknown'
=> 'Reservierungsstatus unbekannt',

   'Choose which content types you wish to import'
=> 'Wählen Sie aus, welche Inhaltstypen Sie importieren möchten',

   'Content type'
=> 'Inhaltstyp',

   'Coordinators included automatically'
=> 'Koordinatoren werden automatisch eingebunden',

   'Copy to main window'
=> 'Ins Hauptfenster kopieren',

   'Course section number:LON-CAPA section'
=> 'Kurssektionsnummer:LON-CAPA-Sektion',

   'Course/Community users can create/upload PDF forms'
=> 'Kurs-/Community-Teilnehmer dürfen PDF-Formulare erstellen/hochladen',

   'Course/Community users can create/upload PDF forms set to "off"'
=> 'Kurs-/Community-Teilnehmer dürfen PDF-Formulare erstellen/hochladen auf "aus" gesetzt',

   "Course/Community users can create/upload PDF forms set to 'on'"
=> 'Kurs-/Community-Teilnehmer dürfen PDF-Formulare erstellen/hochladen auf "ein" gesetzt',

   'Create a new collaborative community by completing an online form.'
=> 'Eine neue kollaborative Community durch Ausfüllen eines Formulars erstellen.',

   'Create pending official courses from XML files'
=> 'Erstellen von ausstehenden offiziellen Kursen durch XML-Dateien',

   'Crosslisted courses for auto-enrollment'
=> 'Fachübergreifende Kurse für die automatische Kursbelegung',

   'Current automated enrollment settings for:'
=> 'Derzeitige Einstellungen der automatischen Kursbelegung für:',

   "Settings which control auto-enrollment using classlists from your institution's student information system fall into two groups:"
=> "Einstellungen, die die automatische Kursbelegung kontrollieren, die die Kursteilnehmerlisten aus dem Informationssystem Ihrer Institution für studentische Daten verwendet, splitten sich in zwei Gruppen:",

   'Settings modifiable by a [_1] via [_2]View/Modify course owner, institutional code, and default authentication[_3].'
=> 'Einstellungen, die ein [_1] über [_2]Kurs-Eigentümer, institutionellen Code und voreingestellte Authentifizierung anzeigen/ändern[_3] ändern kann.',

   'Settings modifiable by a [_1] via [_2]View/Modify course owner, institutional code, and default authentication and credits[_3].'
=> 'Einstellungen, die ein [_1] über [_2]Kurs-Eigentümer, institutionellen Code, voreingestellte Authentifizierung und Credits anzeigen/ändern[_3] ändern kann.',

   'Settings modifiable by a [_1] via [_2]View/Modify course owner, institutional code, default authentication, credits, and self-enrollment[_3].'
=> 'Einstellungen, die ein [_1] über [_2]Kurs-Eigentümer, institutionellen Code, voreingestellte Authentifizierung, Credits und Selbsteintragung anzeigen/ändern[_3] ändern kann.',

   'Settings modifiable by a [_1] via the [_2]Automated Enrollment Manager[_3] in a course.'
=> 'Einstellungen, die ein [_1] über [_2]Verwaltung der automatischen Kursbelegung[_3] in einem Kurs ändern kann.',

   'Current print header:'
=> 'Derzeitiger Kopfbereich beim Drucken:',

   'Current standard notification e-mail - [_1] for [_2] is different to e-mail address in institutional classlist - [_3].'
=> 'Die derzeitige E-Mail-Adresse für normale Benachrichtigungen [_1] für [_2] unterscheidet sich von der E-Mail-Adresse, die in der institutionellen Kursteilnehmerliste eingetragen ist: [_3].',

   'Current critical notification e-mail - [_1] for [_2] is different to e-mail address in institutional classlist - [_3].'
=> 'Die derzeitige E-Mail-Adresse für wichtige Benachrichtigungen [_1] für [_2] unterscheidet sich von der E-Mail-Adresse, die in der institutionellen Kursteilnehmerliste eingetragen ist: [_3].',

   'Custom setting'
=> 'Benutzerdefinierte Einstellung',

   'Disk usage exceeds the quota for this course.'
=> 'Der Speicherverbrauch überschreitet den verfügbaren Speicherplatz für diesen Kurs.',

   'Disk usage now exceeds the quota for this course.'
=> 'Der Speicherverbrauch überschreitet ab jetzt den verfügbaren Speicherplatz für diesen Kurs.',

   'Disk usage exceeds the quota for this community.'
=> 'Der Speicherverbrauch überschreitet den verfügbaren Speicherplatz für diese Community.',

   'Disk usage now exceeds the quota for this community.'
=> 'Der Speicherverbrauch überschreitet ab jetzt den verfügbaren Speicherplatz für diese Community.',

   'View pending official course requests'
=> 'Offizielle Kursanträge anzeigen',

   'Display Pending Queue'
=> 'Anzeige der Warteschlange ausstehender Punkte',

   'There are currently no requests for official courses awaiting validation.'
=> 'Derzeit gibt es keine Anträge auf offizielle Kurse, die auf Validierung warten.',

   'Display official course requests submitted by authorized users, held pending validation of instructor status.'
=> 'Zeige Kursanträge, die durch autorisierte Benutzer eingereicht wurden und auf Validierung durch einen Dozenten warten.',

   'Display course and community creation requests submitted by authorized users, held pending approval by a Domain Coordinator.'
=> 'Zeige Anträge auf Kurs- und Community-Erstellung, die durch autorisierte Benutzer eingereicht wurden und auf Bestätigung durch einen Domänen-Koordinator warten.',

   'Course/Community requests queued pending approval by a Domain Coordinator'
=> 'Kurs-/Community-Anträge, die auf Bestätigung durch einen Domänen-Koordinator warten.',

   'Requests for Authoring Space queued pending approval by a Domain Coordinator'
=> 'Anträge auf einen Autorenbereich, die auf Bestätigung durch einen Domänen-Koordinator warten.',

   'Display listing of contents in a new folder, with folder name:'
=> 'Zeige eine Liste des Inhalts in einem neuen Verzeichnis mit dem Verzeichnisnamen:',

   'Display members with current/future access who are not in the uploaded file'
=> 'Zeige Mitglieder mit aktuellem/zukünftigem Zugriff, die nicht in der hochgeladenen Datei sind',

   'Made reservation'
=> 'Reservierung vorgenommen',

   'Dropped reservation'
=> 'Reservierung abgewiesen',

   'E-mail from course requests requiring approval'
=> 'E-Mail von Kursanträgen, die eine Bestätigung erfordern',

   'Error reading community contents.'
=> 'Fehler beim Lesen des Community-Inhaltes.',

   'Error retrieving community contents'
=> 'Fehler beim Abrufen des Community-Inhaltes',

   'File to upload'
=> 'Datei zum Hochladen',

   'File to upload: [_1]'
=> 'Datei zum Hochladen: [_1]',

   'Filename of bubblesheet data file:'
=> 'Dateiname der Bubblesheet-Daten-Datei:',

   'Font menu'
=> 'Schriftfarbe im Menü',

   'Format of bubblesheet data file:'
=> 'Format der Bubblesheet-Daten-Datei:',

   'Grade BTs in any section'
=> '"Bridgetasks" in jeder Sektion bewerten',

   'Grade BTs only in own section'
=> '"Bridgetasks" nur in eigener Sektion bewerten',

   'Grade Level'
=> 'Bewertungslevel',

   'Grading: Validate Bubblesheet Records'
=> 'Bewertung: Validiere Bubblesheet-Datensätze',

   'Cataloging of courses/communities'
=> 'Katalogisierung von Kursen/Communitys',

   'Hiding/unhiding a course from the course catalog (although can be [_1]configured[_2] to be modifiable by a Course Coordinator in course context).'
=> 'Einen Kurs in der Kurs-/Community-Übersicht verbergen/anzeigen (Dies kann auch so [_1]konfiguriert[_2] werden, dass ein Kurs-Koordinator im Kurskontext diese Änderung vornehmen darf).',

   'Hiding/unhiding a community from the catalog (although can be [_1]configured[_2] to be modifiable by a Coordinator in community context).'
=> 'Eine Community in der Kurs-/Community-Übersicht verbergen/anzeigen (Dies kann auch so [_1]konfiguriert[_2] werden, dass ein Koordinator im Community-Kontext diese Änderung vornehmen darf).',

   'Manual cataloging of a course (although can be [_1]configured[_2] to be modifiable by a Course Coordinator in course context).'
=> 'Manuelles Katalogisieren eines Kurses (Dies kann auch so [_1]konfiguriert[_2] werden, dass ein Kurs-Koordinator im Kurskontext diese Änderung vornehmen darf).',

   'Manual cataloging of a community (although can be [_1]configured[_2] to be modifiable by a Coordinator in community context).'
=> 'Manuelles Katalogisieren einer Community (Dies kann auch so [_1]konfiguriert[_2] werden, dass ein Koordinator im Community-Kontext diese Änderung vornehmen darf).',

   "If a community has been categorized using at least one of the categories defined for communities in the domain, it will be listed in the domain's publicly accessible Course/Community Catalog, unless excluded."
=> 'Wenn eine Community mindestens einer Kategorie, die in der Domäne für Communitys definiert wurde, zugeordnet ist, wird sie in der Kurs-/Community-Übersicht, die in der Domäne öffentlich zugängig ist, aufgelistet. Solange sie nicht ausgeschlossen wird, bleibt sie dort aufgelistet.',

   'Show/Hide a community in catalog'
=> 'Community in der Kurs-/Community-Übersicht anzeigen/verbergen',

   'Show/Hide a course in catalog'
=> 'Kurs in der Kurs-/Community-Übersicht anzeigen/verbergen',

   "Unless excluded, a course will be listed in the domain's publicly accessible Course/Community Catalog, if at least one of the following applies"
=> 'Sofern nicht ausgeschlossen wird ein Kurs in der öffentlich zugänglichen Kurs-Community-Übersicht der Domäne angezeigt, sofern mindestens eine der folgenden Bedingungen zutrifft',

   'View/Modify catalog settings for course'
=> 'Einstellungen des Kurses für die Kurs-/Community-Übersicht ansehen/ändern',

   'View/Modify catalog settings for community'
=> 'Einstellungen der Community für die Kurs-/Community-Übersicht ansehen/ändern',

   'Request Logs'
=> 'Antragsprotokolle',

   'Course/Community Request Logs'
=> 'Antragsprotokolle für Kurse/Communitys',

   'Choose categories, from left to right'
=> 'Wählen Sie die Kategorien, von links nach rechts',

   'Pick courses by category:'
=> 'Kursauswahl über Kategorie:',

   'If automatic enrollment is enabled for "[_1]", automated enrollment may fail for "[_2]" - section: [_3] for the following reason: "[_4]"'
=> 'Wenn die automatische Kursbelegung für "[_1]" aktiviert ist, dann könnte die automatische Kursbelegung für "[_2]" - Sektion: [_3], fehlschlagen. Der Grund dafür ist: "[_4]"',

   'If automatic enrollment is enabled for "[_1]", automated enrollment may fail for "[_2]" - section [_3] for the following reason: "[_4]".'
=> 'Wenn die automatische Kursbelegung für "[_1]" aktiviert ist, dann könnte die automatische Kursbelegung für "[_2]" - Sektion: [_3], fehlschlagen. Der Grund dafür ist: "[_4]".',

   'If automatic enrollment is enabled for "[_1]", automated enrollment may fail for "[_2]" - section: [_3], because this is not a valid section entry.'
=> 'Wenn die automatische Kursbelegung für "[_1]" aktiviert ist, dann könnte die automatische Kursbelegung für "[_2]" - Sektion: [_3], fehlschlagen, da dies kein gültiger Sektionseintrag ist.',

   'It is recommended that you [_1]re-initialize the course[_2] and then return to this grading page.'
=> 'Es wird empfohlen, dass Sie den [_1]Kurs neu initialisieren[_2] und dann zu dieser Bewertungsseite zurückkehren.',

   'Login box'
=> 'Login-Box',

   'Make another request'
=> 'Einen weiteren Antrag stellen',

   'Modify Request'
=> 'Antrag bearbeiten',

   'Modify another students data'
=> 'Daten eines/r weiteren Studenten/in bearbeiten',

   'Modify this request'
=> 'Diesen Antrag bearbeiten',

   'No changes made to auto-creation settings'
=> 'An den Einstellungen der automatischen Erstellung wurden keine Änderungen vorgenommen',

   'No changes made to help settings'
=> 'An den Einstellungen der Hilfe wurden keine Änderungen vorgenommen',

   'No changes made to availability of personal information pages, blogs, portfolios or default quotas'
=> 'An der Verfügbarkeit der persönlichen Seiten der Benutzer, Blogs, Portfolios und des voreingestellten Speicherplatzes wurden keine Änderungen vorgenommen.',

   'No changes made to bubblesheet format file'
=> 'An der Bubblesheet-Formatdatei wurden keine Änderungen vorgenommen.',

   'No changes made to rights to request creation of courses.'
=> 'An den Berechtigungen zum Beantragen von Kursen wurden keine Änderungen vorgenommen.',

   'No changes made to access to server status pages'
=> 'An dem Zugriff auf die Serverstatus-Seiten wurden keine Änderungen vorgenommen.',

   'No changes made to auto-enrollment settings'
=> 'An den Einstellungen der automatischen Kursbelegung wurden keine Änderungen vorgenommen.',

   'No changes made to autoupdates'
=> 'An der automatischen Aktualisierung wurden keine Änderungen vorgenommen.',

   'No changes made to contact information'
=> 'An den Kontaktdaten wurden keine Änderungen vorgenommen.',

   'No changes made to default authentication/language/timezone settings'
=> 'An den Einstellungen zur voreingestellten Authentifizierung/Sprache/Zeitzone wurden keine Änderungen vorgenommen.',

   'No changes made to default color schemes'
=> 'An den voreingestellten Farbeinstellungen wurden keine Änderungen vorgenommen.',

   'No changes made to institution directory search settings'
=> 'An den Einstellungen zur institutionellen Verzeichnissuche wurden keine Änderungen vorgenommen.',

   'No changes made to user modification settings'
=> 'An den Einstellungen zur Benutzer-Änderung wurden keine Änderungen vorgenommen.',

   'reason'
=> 'Grund',

   'reason - invalid user: [_1]'
=> 'Grund - ungültiger Benutzer: [_1]',

   'reason - unsupported language: [_1]'
=> 'Grund - nicht unterstützte Sprache: [_1]',

   '[_1] was excluded because you may not request new users in the domain'
=> '[_1] wurde ausgeschlossen, da Sie keine neuen Benutzer in diese Domäne anfordern dürfen',

   'You do not have rights to view community request information.'
=> 'Sie haben nicht die Berechtigung, Informationen zum Community-Antrag einzusehen.',

   'You do not have rights to view course or community request information.'
=> 'Sie haben nicht die Berechtigung, Informationen zum Kurs- oder Community-Antrag einzusehen.',

   'You do not have rights to view course request information.'
=> 'Sie haben nicht die Berechtigung, Informationen zum Kursantrag einzusehen.',

   'Numerical limit'
=> 'Zahlenmäßige Begrenzung',

   'No slot name provided'
=> 'Kein Slot-Name vorhanden',

   'No current reservation.'
=> 'Derzeit keine Reservierungen.',

   'No community items currently require a reservation to gain access.'
=> 'Derzeit benötigen keine Community-Elemente eine Reservierung, um Zugriff zu erhalten.',

   'No course items currently require a reservation to gain access.'
=> 'Derzeit benötigen keine Kurselemente eine Reservierung, um Zugriff zu erhalten.',

   'Instructors may use a reservation system to place restrictions on when and where assignments can be worked on.'
=> 'Dozenten können ein Reservierungssystem verwenden, um die Bearbeitung von Übungen zeitlich und örtlich zu beschränken.',

   'One example is for management of laboratory space, which is only available at certain times, and has a limited number of seats.'
=> 'Ein Beispiel dafür ist das Verwalten von Laborplätzen, die nur zu bestimmten Zeiten mit beschränktem Platzangebot zur Verfügung stehen.',

   'Your reservation status for any such assignments is listed below:'
=> 'Ihr Reservierungsstatus wird für alle Ihre Übungen solcher Art im Folgenden aufgelistet:',

   'No further action will be taken'
=> 'Es werden keine weiteren Maßnahmen ergriffen',

   'Preferences'
=> 'Einstellungen',

   'Portfolio'
=> 'Portfolio',

   'Portfolio:'
=> 'Portfolio:',

   'Course Category'
=> 'Kurskategorie',

   'Cross Listed Course'
=> 'Fachübergreifender Kurs',

   'Start auto-enrollment'
=> 'Start der automatischen Kursbelegung',

   'End auto-enrollment'
=> 'Ende der automatischen Kursbelegung',

   'Default start access'
=> 'Voreingestellte Start-Zugriffszeit',

   'Default end access'
=> 'Voreingestellte End-Zugriffszeit',

   'Crosslistings'
=> 'Fachübergreifende Querverweise',

   'Clone?'
=> 'Klonen?',

   'Request Action'
=> 'Antragsaktion',

   'View request history'
=> 'Antragshistorie betrachten',

   'You have no matching community requests awaiting approval by a Domain Coordinator or held in a queue pending administrative action at your institution.'
=> 'Sie haben keine Community-Anträge, die auf Bestätigung eines Domänen-Koordinators warten oder sich in der Warteschlange für noch ausstehende administrative Aktionen Ihrer Institution befinden.',

   'You have no matching course or community requests awaiting approval by a Domain Coordinator or held in a queue pending administrative action at your institution.'
=> 'Sie haben keine Kurs- oder Community-Anträge, die auf Bestätigung eines Domänen-Koordinators warten oder sich in der Warteschlange für noch ausstehende administrative Aktionen Ihrer Institution befinden.',

   'You have no matching course requests awaiting approval by a Domain Coordinator or held in a queue pending administrative action at your institution.'
=> 'Sie haben keine Kursanträge, die auf Bestätigung eines Domänen-Koordinators warten oder sich in der Warteschlange für noch ausstehende administrative Aktionen Ihrer Institution befinden.',

   'Please enter the username and domain of the LON-CAPA account, and the associated e-mail address, for which you are setting a password. The new password must contain at least 7 characters.'
=> 'Bitte geben Sie die Benutzerkennung und Domäne des LON-CAPA-Accounts, sowie die dazugehörende E-Mail-Adresse an, für den Sie das Passwort setzen möchten. Das Passwort muss mindestens 7 Zeichen lang sein.',

   'Your new password will be sent to the LON-CAPA server in an encrypted form.'
=> 'Ihr neues Passwort wird verschlüsselt an den LON-CAPA-Server gesendet.',

   'The token included in an e-mail sent to you [_1] has been verified, so you may now proceed to reset the password for your LON-CAPA account.'
=> 'Der Authentifizierungscode, der in die E-Mail vom [_1] eingebunden war, wurde verifiziert, so dass Sie nun mit dem Zurücksetzen des Passwortes Ihres LON-CAPA-Accounts fortfahren können.',

   'An e-mail confirming setting of the password for your LON-CAPA account has been sent to [_1].'
=> 'Eine E-Mail, die das Setzen des Passwortes Ihres LON-CAPA-Accounts bestätigt, wurde an [_1] gesendet.',

   'Sorry, the URL generated when you requested reset of your password contained incomplete information. Please submit a [_1]new request[_2] for a password reset, and use the new URL that will be sent to your e-mail account to complete the process.'
=> 'Die URL, die bei Ihrem Antrag auf Zurücksetzen Ihres Passwortes erstellt wurde, enthält unvollständige Daten. Bitte senden Sie einen [_1]erneuten Antrag[_2] auf Zurücksetzung Ihres Passwortes und nutzen Sie die neue URL, die Ihnen dann an Ihre E-Mail-Adresse gesendet wird, um den Vorgang abzuschließen.',

   'Sorry, the token generated when you requested a password reset has expired. Please submit a [_1]new request[_2], and follow the link to the web page included in the new e-mail that will be sent to you, to allow you to enter a new password.'
=> 'Der erstellte Authentifizierungscode zum Zurücksetzen Ihres Passworts ist bereits abgelaufen und daher nicht mehr gültig. Bitte senden Sie einen [_1]erneuten Antrag[_2]. Sie werden eine neue E-Mail erhalten. Folgen Sie dem dort angegebenen Link zur Webseite, damit Sie ein neues Passwort eingeben können.',

   'Your LON-CAPA account'
=> 'Ihr LON-CAPA-Account',

   'By student'
=> 'durch Student/in',

   'By member'
=> 'durch Mitglied',

   'Choose your LON-CAPA domain'
=> 'Wählen Sie Ihre LON-CAPA-Domäne',

   'LON-CAPA Logo'
=> 'LON-CAPA-Logo',

   'LON-CAPA Remote'
=> 'LON-CAPA-Fernbedienung',

   'LON-CAPA Standard'
=> 'LON-CAPA-Standard',

   'Launched'
=> 'gestartet',

   'Pick'
=> 'Auswahl',

   'Results'
=> 'Ergebnisse',

   'Search Status'
=> 'Suchstatus',

   'Sequence of Materials'
=> 'Sequenz von Materialien',

   'The LearningOnline Network with CAPA Login'
=> 'The LearningOnline Network with CAPA - Login',

   'Upload a file (e.g., a screenshot) relevant to your help request (128 KB max.)'
=> 'Hochladen einer Datei, z.B. ein Screenshot, die Ihre Helpdesk-Anfrage betrifft (max. 128 KB)',

   'You must include a description'
=> 'Sie müssen eine Beschreibung angeben',

   'You must include a subject'
=> 'Sie müssen ein Thema angeben',

   'Activation of self-enrollment was selected for the following domain(s)'
=> 'Aktivierung der Selbsteintragung wurde für folgende Domäne(n) ausgewählt',

   'but no user types have been checked.'
=> 'Es wurden jedoch keine Benutzertypen ausgewählt.',

   "Please uncheck 'activate' or check at least one type."
=> "Bitte heben Sie entweder die Auswahl für 'aktiv' auf oder wählen Sie mindestens einen Typ aus.",

   'All assignments in a single PDF file'
=> 'Alle Übungen in einer einzigen PDF-Datei',

   'Announcement'
=> 'Bekanntmachung',

   'Announcements'
=> 'Bekanntmachungen',

   'Assessment Questions'
=> 'Beurteilungsfragen',

   'Documents, pages, and folders'
=> 'Dokumente, Seiten und Verzeichnisse',

   'Each PDF contains exactly one assignment'
=> 'Jedes PDF enthält genau eine Übung',

   'Each PDF contains exactly one section'
=> 'Jedes PDF enthält genau eine Sektion',

   'CSV'
=> 'CSV',

   'all LON-CAPA'
=> 'gesamt LON-CAPA',

   'Tiny'
=> 'mini',

   'Script Size'
=> 'Skriptgröße',

   'Footnote Size'
=> 'Fußnotengröße',

   'Small'
=> 'klein',

   'Normal (default)'
=> 'normal (voreingestellt)',

   'larger than normal'
=> 'etwas größer als normal',

   'Even larger than normal'
=> 'größer als normal',

   'Still larger than normal'
=> 'noch größer als normal',

   'huge font size'
=> 'große Schriftgröße',

   'Largest possible size'
=> 'größtmögliche Größe',

   'Specify the number of assignments per PDF:'
=> 'Anzahl der Übungen pro PDF-Datei:',

   'Select sorting order of printout'
=> 'Auswahl der Sortierungsreihenfolge für den Ausdruck',

   'Sort by section then student'
=> 'Sortieren nach Sektion, dann nach Student/in',

   'Sort by students across sections.'
=> 'Sektionsübergreifend sortieren nach Student/in.',

   'Select People'
=> 'Personenauswahl',

   'Select resources to print'
=> 'Ressourcen für den Ausdruck auswählen',

   'How do you want assignments split into PDF files?'
=> 'Wie sollen die Übungen auf die PDF-Dateien aufgeteilt werden?',

   'Format of the print job'
=> 'Format des Ausdrucks',

   'Bridge Task grading by instructors and TAs in sections'
=> '"Bridgetask"-Bewertung durch Dozenten oder Tutoren in Sektionen',

   'External: shows number of completed parts and totals'
=> 'Extern: Zeige Anzahl bearbeiteter Aufgabenteile und Gesamtanzahl',

   'External: shows only number of completed parts'
=> 'Extern: Zeige nur die Anzahl bearbeiteter Aufgabenteile',

   'Fill out one of the forms below'
=> 'Füllen Sie eines der unten stehenden Formulare aus',

   'Hide upload references prompt if uploading file to portfolio'
=> 'Hochlade-Referenzen sofort verbergen, sobald eine Datei ins Portfolio hochgeladen wird',

   'In each community, each user may only have one member role at a time.'
=> 'In jeder Community kann jeder Benutzer zu einem Zeitpunkt nur eine Teilnehmer-Rolle haben.',

   'In each course, each user may only have one student role at a time.'
=> 'In jedem Kurs kann jeder Benutzer zu einem Zeitpunkt nur eine Studenten-Rolle haben.',

   'In each course, each user may only have one student role at a time'
=> 'In jedem Kurs kann jeder Benutzer zu einem Zeitpunkt nur eine Studenten-Rolle haben',

   'In each community, each user may only have one member role at a time'
=> 'In jeder Community kann jeder Benutzer zu einem Zeitpunkt nur eine Teilnehmer-Rolle haben',

   'Links to external sites'
=> 'Links zu externen Seiten',

   'Locate the IMS content package you wish to upload'
=> 'Wählen Sie das IMS-Paket aus, dass Sie hochladen möchten',

   'Pick a Date'
=> 'Datum auswählen',

   'Please choose a different section name.'
=> 'Bitte wählen Sie einen anderen Sektionsnamen.',

   'Please choose a different section name'
=> 'Bitte wählen Sie einen anderen Sektionsnamen',

   'Please choose the CMS used to create your IMS content package:'
=> 'Bitte wählen Sie das KMS aus, das benutzt werden soll, um Ihr IMS-Paket zu erstellen:',

   'Specify the Course Management system used to create the package'
=> 'Geben Sie das Kurs-Management-System an, das genutzt werden soll, um das Paket zu erstellen',

   'Staff information'
=> 'Personalinformationen',

   'Please modify your selections so they include no more than one section.'
=> 'Bitte verändern Sie Ihre Auswahlen so, dass sie nicht mehr als eine Sektion beinhalten.',

   'Please modify your selections so they include no more than one section'
=> 'Bitte verändern Sie Ihre Auswahlen so, dass sie nicht mehr als eine Sektion beinhalten',

   'Question pools'
=> 'Fragen-Pools',

   'Quizzes'
=> 'Quizzes',

   'Score Part: [_1][_2](weight = [_3])'
=> 'Punkte für Aufgabenteil [_1][_2](Gewichtung = [_3])',

   'Section designations do not apply to Coordinator roles.'
=> 'Sektionsbezeichnungen treffen nicht auf Koordinatoren-Rollen zu.',

   'Section designations do not apply to Course Coordinator roles.'
=> 'Sektionsbezeichnungen treffen nicht auf Kurs-Koordinatoren-Rollen zu.',

   'Section names and group names must be distinct. Please choose a different section name.'
=> 'Sektionsnamen und Gruppennamen müssen eindeutig sein. Bitte wählen Sie einen anderen Sektionsnamen.',

   'User Management Logs'
=> 'Benutzerverwaltungs-Protokolle',

   'Locale used for course calendar'
=> 'Gebietsschema, das für den Kurskalender genutzt werden soll',

   'RSS Feeds and Blogs'
=> 'RSS-Feeds und Blogs',

   'The change will become active on the next page.'
=> 'Die Änderung wird auf der nächsten Seite wirksam.',

   'Contacting course home server'
=> 'Nehme Verbindung mit dem Heimatserver des Kurses auf',

   'Error contacting home server for course: [_1]'
=> 'Fehler beim Verbinden mit dem Heimatserver des Kurses [_1]',

   'Do only previously skipped records'
=> 'Nur die bis jetzt ausgelassenen Datensätze verarbeiten',

   'Remove all existing corrections'
=> 'Alle bestehenden Korrekturen entfernen',

   'Skip hidden resources when grading'
=> 'Beim Bewerten alle verborgenen Ressourcen überspringen',

   'Download a scoring office file'
=> 'Download einer Office-Datei mit Bewertungen',

   'Filename of scoring office file:'
=> 'Dateiname der Office-Datei mit Bewertungen:',

   'Filename of scoring office file: [_1]'
=> 'Dateiname der Office-Datei mit Bewertungen: [_1]',

   'Download: Show List of Associated Files'
=> 'Download: Liste der verknüpften Dateien anzeigen',

   'Finished!'
=> 'Fertig',

   'Format of data file:'
=> 'Format der Datendatei:',

   'Graded folder/sequence:'
=> 'Bewertete/s Verzeichnis/Sequenz:',

   'Graphics'
=> 'Grafiken',

   'History of student-reservable slots for: [_1]'
=> 'Historie der durch Studierende reservierbaren Slots für: [_1]',

   'Manual Grading by Page or Sequence'
=> 'Manuelle Bewertung pro Seite oder Sequenz',

   'No recorded submission for this problem.'
=> 'Keine aufgezeichneten Einreichungen für diese Aufgabe.',

   'No subject'
=> 'Kein Betreff',

   'Parsing results'
=> 'Parse-Ergebnisse',

   'Please select the student you wish to grade.'
=> 'Bitte wählen Sie den/die Studenten/in, den/die Sie bewerten möchten.',

   'Please use the browse button to select a file from your local directory.'
=> 'Bitte verwenden Sie den Durchsuchen-Button, um eine Datei von Ihrer lokalen Festplatte auszuwählen.',

   'Problem Text'
=> 'Aufgabentext',

   'Removed by '
=> 'Entfernt durch ',

   'Review Bubblesheet Data and Submission Records'
=> 'Überprüfen der Bubblesheet-Daten und Einreichungs-Aufzeichnungen',

   'Review bubblesheet data and submissions for a previously graded folder/sequence'
=> 'Überprüfen der Bubblesheet-Daten und Einreichungen für ein/e zuvor bewertete/s Verzeichnis/Sequenz',

   'Specify a bubblesheet data file to upload.'
=> 'Geben Sie eine Bubblesheet-Datendatei an, die hochgeladen werden soll.',

   'Sequence to grade:'
=> 'Sequenz, die bewertet werden soll:',

   'Show all parts'
=> 'Alle Aufgabenteile anzeigen',

   'Slot reservation history'
=> 'Slot-Reservierungs-Historie',

   'Specific Resource: [_1] ([_2])'
=> 'Bestimmte Ressource: [_1] ([_2])',

   'Specify file and which Folder/Sequence to grade'
=> 'Angabe der Datei und welche/s Verzeichnis/Sequenz bewertet werden soll',

   'Student Activity Retrieval'
=> 'Abruf der studentischen Aktivitätsdaten',

   'View more activity by this student'
=> 'Mehr Aktivitäten dieses/r Studenten/in anzeigen',

   'View slot reservation history of this student'
=> 'Slot-Reservierungs-Historie dieses/r Student/in betrachten',

   'Waiting for results'
=> 'Warte auf Ergebnisse',

   'Student: [_1]'
=> 'Student/in: [_1]',

   'Via Parameter Manager'
=> 'Durch Parameter-Manager',

   'Via Slot Manager'
=> 'Durch Slot-Manager',

   ' Display Request Queue'
=> ' Antragswarteschlange anzeigen',

   '(blank for unlimited)'
=> '(leerlassen für unbegrenzt)',

   '(shows course personnel)'
=> '(Kurspersonal anzeigen)',

   '(will be assigned Coordinator role)'
=> '(wird eine Koordinatoren-Rolle erhalten)',

   '(will be assigned Course Coordinator role)'
=> '(wird eine Kurs-Koordinatoren-Rolle erhalten)',

   'Access to server status pages'
=> 'Zugriff auf Serverstatus-Seiten',

   'Active link'
=> 'Aktiver Link',

   'Add a user to the domain, and/or a course or community in the domain.'
=> 'Einen Benutzer zu einer Domäne und/oder Kurs oder Community in der Domäne hinzufügen.',

   'Admin E-mail address'
=> 'E-Mail-Adresse des Administrators',

   'Apache Server Status'
=> 'Apache-Serverstatus',

   'Apache Status Page'
=> 'Apache-Statusseite',

   'Assignable authentication types'
=> 'Zuweisbare Authentifizierungstypen',

   'assignable authentication types: '
=> 'Zuweisbare Authentifizierungstypen:',

   'Assistant Leader'
=> 'Leitungsassistent',

   'Leader'
=> 'Leiter',

   'Authenticated Help Settings'
=> 'Einstellungen für Authentifizierungs-Hilfe',

   'Auto-course creation settings'
=> 'Einstellungen für automatische Kurserstellungen',

   'Auto-update active?'
=> 'Automatische Aktualisierung aktiv?',

   'User population'
=> 'Benutzer-Aktualisierung',

   'Automatic access for Dom. Coords.'
=> 'Automatischer Zugriff für Dom.-Koord.',

   'Availability/Processing of requests'
=> 'Verfügbare/verarbeitende Anträge',

   'Available tools'
=> 'Verfügbare Tools',

   'Background colors'
=> 'Hintergrundfarben',

   'Banner for admin role'
=> 'Banner für Administratoren-Rolle',

   'Banner for author role'
=> 'Banner für Autoren-Rolle',

   'Banner for coordinator role'
=> 'Banner für Koordinatoren-Rolle',

   'Banner for student role'
=> 'Banner für Studentische Rolle',

   'Batch creation from uploaded file'
=> 'Stapelverarbeitende Erstellung aus hochgeladener Datei',

   'Blog'
=> 'Blog',

   'Border'
=> 'Rahmen',

   'Text color'
=> 'Textfarbe',

   'Box color'
=> 'Boxfarbe',

   'Choose next report:'
=> 'Nächsten Bericht auswählen:',

   'Connection Status'
=> 'Verbindungsstatus',

   'Connections Matrix'
=> 'Verbindungsmatrix',

   'Course Coordinators to be notified of enrollment changes'
=> 'Kurs-Koordinatoren, die über Belegungsänderungen informiert werden sollen',

   'Course Name'
=> 'Name des Kurses',

   'Course Owner/Co-owner'
=> 'Kurs-Eigentümer/-Co-Eigentümer',

   'Community Owner/Co-owner'
=> 'Community-Eigentümer/-Co-Eigentümer',

   'Course Personnel Includes'
=> 'Kurspersonal beinhaltet',

   'Community Personnel Includes'
=> 'Community-Personal beinhaltet',

   'Course Settings'
=> 'Kurs-Einstellungen',

   'Community Settings'
=> 'Community-Einstellungen',

   'Course and community creation'
=> 'Kurs- und Community-Erstellung',

   'Course or community created by Dom. Coord.'
=> 'Kurs- und Community-Erstellung durch Dom.-Koord.',

   'Course settings modifiable only by [_1] for:'
=> 'Kurs-Einstellungen, die nur durch einen [_1] vorgenommen werden können, für:',

   'Community settings modifiable only by [_1] for:'
=> 'Community-Einstellungen, die nur durch einen [_1] vorgenommen werden können, für:',

   'Course/Community Creation Logs'
=> 'Kurs-/Community-Erstellungs-Protokolle',

   'Course/Community Management'
=> 'Kurs-/Community-Verwaltung',

   'Course/Community defaults'
=> 'Kurs-/Community-Voreinstellungen',

   'Course/Community search'
=> 'Kurs-/Community-Suche',

   'Create a New Course or Community'
=> 'Neuen Kurs oder neue Community erstellen',

   'Create pending requests for official courses (if validated)'
=> 'Ausstehende Anträge für offizielle Kurse erstellen (sofern validiert)', # ???

   'Created Courses/Communities'
=> 'Kurse/Communitys erstellen',

   'Creating users when a Domain Coordinator'
=> 'Erstellung von Benutzern, wenn Domänen-Koordinator',

   'Creating users when an Author'
=> 'Erstellung von Benutzern, wenn Autor',

   'Creating users when in a course'
=> 'Erstellung von Benutzern, wenn in einem Kurs',

   'Creation Context'
=> 'Erstellungs-Kontext',

   'Creation Context:'
=> 'Erstellungs-Kontext:',

   'Creation options menu'
=> 'Optionsmenü für Erstellungen',

   'Crosslisted class:LON-CAPA section'
=> 'Fachübergreifender Kurs:LON-CAPA-Sektion',

   'Custom bubblesheet format file error'
=> 'Fehler in der Formatdatei des benutzerdefinierten Bubblesheets',

   'Default Login Page Help File In Use',
=> 'Voreingestellte Hilfedatei für Login-Seite wird verwendet',

   'Upload Custom Login Page Help File:'
=> 'Benutzerdefinierte Hilfedatei für Login-Seite hochladen:',

   'Default Server Admin E-mail address'
=> 'Voreingestellte E-Mail-Adresse des Server-Administrators',

   'Support E-mail address'
=> 'E-Mail-Adresse des Supports (Helpdesk)',

   'Support E-mail'
=> 'E-Mail-Adresse des Supports (Helpdesk)',

   'Default authentication argument'
=> 'Voreingestelltes Authentifizierungs-Argument',

   'Default authentication type'
=> 'Voreingestellter Authentifizierungstyp',

   'Default bubblesheet format file error'
=> 'Fehler in voreingestellter Bubblesheet-Formatdatei',

   'Default image:'
=> 'Voreingestelltes Bild:',

   'Default language'
=> 'Voreingestellte Sprache',

   'Default locale for dates'
=> 'Voreingestelltes Gebietsschema für Datumswerte',

   'Default timezone'
=> 'Voreingestellte Zeitzone',

   'Disable member resource discussion'
=> 'Ressourcen-Diskussion für Mitglieder deaktivieren',

   'Disk space for storage of group portfolio files'
=> 'Speicherplatz zum Speichern von Gruppen-Portfolio-Dateien',

   'Display &quot;Submit a bug&quot; link?'
=> 'Link &quot;Fehler melden&quot; anzeigen?',

   "Display Administrator's E-mail Address?"
=> "E-Mail-Adresse des Administrators anzeigen?",

   'Display Detailed Report'
=> 'Ausführlichen Bericht anzeigen',

   'Generate Detailed Report'
=> 'Ausführlichen Bericht erstellen',

   'Display Metadata Keywords'
=> 'Metadaten-Schlüsselwörter anzeigen',

   'Display Requests'
=> 'Anträge anzeigen',

   'Domain Logo'
=> 'Domänen-Logo',

   'Domain Status'
=> 'Domänen-Status',

   'Domain status'
=> 'Domänen-Status',

   'E-mail from nightly status check (warnings/errors)'
=> 'E-Mail mit Infos über nächtliche Statusüberprüfung (Warnungen/Fehler)',

   'Error reports to be e-mailed to'
=> 'Fehlerberichte sollen per E-Mail gesendet werden an',

   'E-mail error reports to [_1]'
=> 'E-Mail-Fehlerberichte sollen an [_1] gehen',

   'E-mail record of completed LON-CAPA updates to [_1]'
=> 'E-Mail-Aufzeichnung des abgeschlossenen LON-CAPA-Updates soll an [_1] gehen',

   'LON-CAPA core group - MSU'
=> 'LON-CAPA-Hauptentwicklerteam an der MSU',

   'Exact match'
=> 'Genauer Treffer',

   'Format rule type'
=> 'Typ der Formatregel',

   'Format rules in force'
=> 'Erzwungene Formatregeln',

   'Gathering initial domain data'
=> 'Zusammenstellung initialisierender Domänen-Daten',

   'Handler Versions'
=> 'Versionen der "Handler"',

   'Harvest Metadata Keywords'
=> 'Metadaten-Schlüsselwörter zusammenstellen',

   'Harvest Metadata Searches'
=> 'Metadaten-Suchen zusammenstellen',

   'Header'
=> 'Kopfbereich',

   'Help on Creating Courses and Communities'
=> 'Hilfe zur Erstellung von Kursen und Communitys',

   'Help page settings'
=> 'Einstellungen für Hilfeseite',

   'Helpdesk requests to be e-mailed to'
=> 'Helpdesk-Anfragen werden per E-Mail gesendet an',

   'Specific IPs'
=> 'Bestimmte IPs',

   'IP1,IP2 etc.'
=> 'IP1,IP2, etc.',

   'Information settable when self-creating account (if directory data blank)'
=> 'Daten, die bei der Selbsterstellung von Accounts eingetragen werden können (falls Verzeichnisdaten nicht vorhanden sind)',

   'Institution Logo'
=> 'Institutions-Logo',

   'Institutional Login'
=> 'Institutionelles Login',

   'Institutional code and default authentication (both required for auto-enrollment of students from institutional datafeeds).'
=> 'Institutioneller Code und voreingestellte Authentifizierung (beides für automatische Kursbelegung notwendig, die für Studierende mit institutionellen Daten verwendet werden soll).',

   'Institutional only '
=> 'nur institutionell ',

   'Kerberos 4'
=> 'Kerberos 4',

   'Kerberos 5'
=> 'Kerberos 5',

   'LON-CAPA Advanced Users'
=> 'Benutzer in LON-CAPA mit erweiterten Berechtigungen',

   'LON-CAPA Domain Status'
=> 'LON-CAPA-Domänenstatus',

   'LON-CAPA Module Versions'
=> 'LON-CAPA-Modulversionen',

   'LON-CAPA Modules'
=> 'LON-CAPA-Module',

   'LONC report.'
=> 'LONC-Bericht.',

   'LOND report'
=> 'LOND-Bericht',

   'Link colors'
=> 'Link-Farben',

   'Link to create a user account'
=> 'Link zur Erstellung von Benutzeraccounts',

   'List Environment'
=> 'Umgebung anzeigen',

   'Load Report'
=> 'Auslastungsbericht',

   'Local'
=> 'lokal',

   'Log-in Header'
=> 'Login-Kopfbereich',

   'Text default(s):'
=> 'Textvoreinstellung(en):',

   'Log-in Page Items'
=> 'Elemente auf der Login-Seite',

   'Log-in Service'
=> 'Login-Service',

   'Log-in banner'
=> 'Login-Banner',

   'Login page requests redirected'
=> 'Umleitung von Anforderungen der Login-Seite',

   'Main Logo'
=> 'Hauptlogo',

   'Member'
=> 'Mitglied',

   'No format rules have been defined for usernames or IDs in this domain.'
=> 'In dieser Domäne wurden keine Formatregeln für Benutzerkennungen oder IDs definiert.',

   'No override set'
=> 'Überschreiben ist nicht aktiviert',

   'No override set for [_1]'
=> 'Überschreiben für [_1] ist nicht aktiviert',

   '(overrides affiliation, if checked)'
=> '(überschreibt Zugehörigkeit, falls ausgewählt)',

   '(overrides affiliation, if set)'
=> '(überschreibt Zugehörigkeit, falls gesetzt)',

   'No redirect'
=> 'Keine Umleitung',

   'Rerouting'
=> 'Umleitung',

   'Non-institutional only'
=> 'Nur nicht-institutionelle',

   'Notification messages - sender'
=> 'Absender von Benachrichtigungs-Nachrichten',

   'Offline - replace Log-in page'
=> '-Offline- Login-Seite ersetzen',

   'Online - restore Log-in page'
=> '-Online- Login-Seite wiederherstellen',

   'Replace log-in page with offline notice'
=> 'Login-Seite durch Offline-Hinweis ersetzen',

   'Replace offline notice with log-in page'
=> 'Offline-Hinweis durch Login-Seite ersetzen',

   'Replace:'
=> 'Ersetzen:',

   'Other domains can search?'
=> 'Dürfen andere Domänen suchen?',

   'Supported search methods'
=> 'Unterstützte Suchmethoden',

   'Other named users'
=> 'Weitere Benutzer',

   'Package update alerts to be e-mailed to'
=> 'Hinweise zu Updates von Betriebssystem-Paketen sollen per E-Mail gesendet werden an',

   'Please be patient'
=> 'Bitte haben Sie einen Moment Geduld',

   'Portfolio quota'
=> 'Portfolio-Speicherplatz',

   'Processing of submitted course request'
=> 'Verarbeitung des eingereichten Kursantrags',

   'Receive notification of course requests requiring approval.'
=> 'Benachrichtigung über Kursanträge, die eine Bestätigung erfordern.',

   'Receive notification of course requests requiring approval'
=> 'Benachrichtigung über Kursanträge, die eine Bestätigung erfordern',

   'Receive notification of Authoring Space requests requiring approval'
=> 'Benachrichtigung über Autorenbereich-Anträge, die eine Bestätigung erfordern',

   'Receive notification of queued requests for self-created user accounts requiring approval'
=> 'Benachrichtigung über Anträge auf selbsterstellte Benutzeraccounts, die eine Bestätigung erfordern',

   'You must choose a specific course type when making a new course request.'
=> 'Sie müssen für einen Kursantrag einen bestimmten Kurstyp auswählen.',

   '"All types" is not allowed.'
=> '"Alle Typen" ist nicht zulässig.',

   'Redirect to log-in via:'
=> 'Umleitung auf Login-Seite über:',

   'Request creation of courses'
=> 'Erstellung eines Kurses beantragen',

   'Running loncron ...'
=> 'loncron wird ausgeführt...',

   'SSO'
=> 'SSO',

   'Search latitude'
=> 'Suchbereich',

   'Section designations do not apply to '
=> 'Sektionsbenennungen nicht anwenden auf ', # ???

   'Server Actions'
=> 'Server-Aktionen',

   'Server Setting'
=> 'Server-Einstellungen',

   'Server Status'
=> 'Serverstatus',

   'Server Status Information'
=> 'Informationen zum Serverstatus',

   'Your current role and/or IP address does not have permission to display information about server status for servers in the domain: [_1].'
=> 'Ihre derzeitige Rolle und/oder IP-Adresse gestattet es Ihnen nicht, Informationen über den Serverstatus für Server in der Domäne [_1] anzuzeigen.',

   'Server Utilities for Domain: [_1]'
=> 'Server-Hilfsprogramme für die Domäne [_1]',

   'Show user environment'
=> 'Benutzerumgebung anzeigen',

   'Starting ...'
=> 'Starte...',

   'Status Page'
=> 'Status-Seite',

   'Status Report'
=> 'Statusbericht',

   'Status information'
=> 'Statusinformation',

   'Status of domain servers'
=> 'Status der Server dieser Domäne',

   'The name: [_1] is a reserved category.'
=> 'Der Name [_1] ist eine intern reservierte Kategorie.',

   'This may take some time ...'
=> 'Dies könnte einen Moment dauern...',

   'Trouble'
=> 'Schwierigkeiten',

   'Unauthenticated Help Settings'
=> 'Einstellungen zu Nicht-authentifizierter Hilfe',

   'Updatable user data'
=> 'Änderbare Benutzerdaten',

   'Update Connections and Refresh Status Information'
=> 'Verbindungen und Statusinformationen aktualisieren',

   'Update information in classlists?'
=> 'Daten in Kursteilnehmerlisten aktualisieren?',

   'Upload Description File'
=> 'Beschreibungsdatei hochladen',

   'User Environment for current log-in'
=> 'Benutzerumgebung für aktuelle Sitzung',

   'User Report'
=> 'Benutzerberichte',

   'User Sessions'
=> 'Benutzersitzungen',

   'User Status Summary'
=> 'Benutzerstatus-Zusammenfassung',

   'User account creation'
=> 'Benutzeraccount-Erstellung',

   'Usernames which may be created'
=> 'Benutzeraccounts, die erstellt werden dürfen',

   'When adding a co-author'
=> 'wenn ein Co-Autor hinzugefügt wird',

   'When adding a user to a course'
=> 'wenn ein Benutzer zum Kurs hinzugefügt wird',

   'When requesting a course'
=> 'wenn ein Kurs beantragt wird',

   'User creates own account'
=> 'Benutzer erstellt Account selbst',

   'User affiliation'
=> 'Benutzerzugehörigkeit',

   'User blogs, personal information pages and portfolios'
=> 'Benutzer-Blogs, Persönliche Seiten und Portfolios',

   'User blogs, personal information pages, portfolios'
=> 'Benutzer-Blogs, Persönliche Seiten, Portfolios',

   'Blogs, personal web pages, webDAV, portfolios'
=> 'Blogs, Persönliche Webseiten, WebDAV, Portfolios',

   'Blogs, personal web pages, webDAV/quotas, portfolios'
=> 'Blogs, Persönliche Webseiten, WebDAV/Speicherplatz, Portfolios',

   'View or modify a course or community'
=> 'Einen Kurs oder eine Community anzeigen oder ändern',

   'View/Modify Course Settings'
=> 'Anzeigen/ändern der Kurs-Einstellungen',

   'View/Modify Community Settings'
=> 'Anzeigen/ändern der Community-Einstellungen',

   'View/Modify Course/Community Settings'
=> 'Anzeigen/ändern der Kurs-/Community-Einstellungen',

   'View/Modify course owner, institutional code, and default authentication'
=> 'Kurs-Eigentümer, institutionellen Code und voreingestellte Authentifizierung anzeigen/ändern',

   'View/Modify course owner, institutional code, and default authentication and credits'
=> 'Kurs-Eigentümer, institutionellen Code, voreingestellte Authentifizierung und Credits anzeigen/ändern',

   'View/Modify course owner, institutional code, default authentication, credits, and self-enrollment'
=> 'Kurs-Eigentümer, institutionellen Code, voreingestellte Authentifizierung, Credits und Selbsteintragung anzeigen/ändern',

   'View/Modify course owner'
=> 'Kurs-Eigentümer anzeigen/ändern',

   'View/Modify community owner'
=> 'Community-Eigentümer anzeigen/ändern',

   'View/Modify quota for group portfolio files'
=> 'Speicherplatz für Gruppen-Portfolio-Dateien anzeigen/ändern',

   'Visited link'
=> 'Besuchter link',

   'Window during which course/community was created:'
=> 'Zeitfenster, in dem der Kurs/die Community erstellt wurde:',

   'With validation'
=> 'mit Bestätigung',

   'Course creation processed as: (choose Dom. Coord.)'
=> 'Kurserstellung verarbeiten als: (Dom.-Koord. auswählen)',

   'You can only use this screen to select courses and communities in the current domain.'
=> 'Sie können diese Seite nur zur Auswahl von Kursen verwenden, die zur aktuellen Domäne gehören.',

   'user1:domain1,user2:domain2 etc.'
=> 'Benutzer1:Domäne1,Benutzer2:Domäne2, etc.',

   'You are not currently signed up to work at this time and/or place.'
=> 'Sie sind derzeit nicht für diese Zeit/diesen Ort zum Arbeiten angemeldet.',

   'Loading Data Upload Page'
=> 'Daten-Hochlade-Seite wird geladen',

   'Recent Courses'
=> 'Zuletzt verwendete Kurse',

   'Requested custom role: [_1] unavailable, as it was not defined by the course owner.'
=> 'Angeforderte benutzerdefinierte Rolle [_1] ist nicht verfügbar, da sie nicht durch den Kurs-Eigentümer festgelegt wurde.',

   'Requested role: [_1] is unavailable.'
=> 'Die angeforderte Rolle [_1] ist nicht verfügbar.',

   'The URL you should use to access the LON-CAPA system at your institution is: '
=> 'Die URL, die Sie verwenden sollten, um auf das LON-CAPA-System Ihrer Institution Zugriff zu erhalten, lautet: ',

   'The existing LON-CAPA classlist contains user: [_1] and student/employee ID: [_2].'
=> 'Die bestehende LON-CAPA-Kursteilnehmerliste enthält den Benutzer [_1] und die Studierenden-/Mitarbeiter-ID [_2].',

   'The username [_1] remains in the institutional classlist, but the same student/employee ID is used for new user: [_2] now found in the institutional classlist.'
=> 'Die Benutzerkennung [_1] verbleibt in der institutionellen Kursteilnehmerliste, die gleiche Studierenden-/Mitarbeiter-ID wird jedoch für den neuen Benutzer [_2] verwendet, der nun in der institutionellen Kursteilnehmerliste ist.',

   'This username - [_1] - has been dropped from the institutional classlist, but the student/employee ID of this user is also used by [_2] who now appears in the institutional classlist.'
=> 'Diese Benutzerkennung [_1] wurde aus der institutionellen Kursteilnehmerliste ausgeschlossen, die Studierenden-/Mitarbeiter-ID dieses Benutzers wird jedoch zusätzlich für den Benutzer [_2] verwendet, der nun in der institutionellen Kursteilnehmerliste ist.',

   'This username has been dropped from the institutional classlist, but the same student/employee ID is used for user: [_1] who still appears in the institutional classlist.'
=> 'Diese Benutzerkennung wurde aus der institutionellen Kursteilnehmerliste ausgeschlossen, die gleiche Studierenden-/Mitarbeiter-ID wird jedoch für den Benutzer [_1] verwendet, der weiterhin in der institutionellen Kursteilnehmerliste ist.',

   'You have been enrolled in the LON-CAPA system at your institution, because you are a registered student in a class which is using the LON-CAPA course management and online homework system.'
=> 'Sie wurden in das LON-CAPA-System in Ihrer Institution eingetragen, weil Sie ein/e registrierte/r Student/in in einem Kurs sind, der das LON-CAPA-Kursverwaltungs- und Online-Übungssystem verwendet.',

   'A non-zero score can be assigned to the student during bubblesheet grading by selecting a bubble in at least one line.'
=> 'Von Null abweichende Punkte können Studierenden während der Bubblesheet-Bewertung zugewiesen werden, indem Sie eine Auswahl (Ankreuzfeld) in mindestens einer Zeile auswählen.',

   "Alternatively, the 'Review bubblesheet data' utility (see grading menu) can be used for all students after grading is complete."
=> "Alternativ kann das 'Überprüfen der Bubblesheet-Daten' (siehe Bewertungsmenü) für alle Studierenden verwendet werden, nachdem die Bewertung abgeschlossen ist.",

   'Anonymous Survey'
=> 'Anonyme Umfrage',

   '(Anonymous Survey)'
=> '(Anonyme Umfrage)',

   'As the current submission is for an anonymous survey, no other details are available.'
=> 'Da die momentane Einreichung für eine anonyme Umfrage ist, sind keine weiteren Details verfügbar.',

   'Comparison of bubblesheet data (including corrections) with corresponding submission records (most recent submission) for [_1][quant,_2,student][_3] ([quant,_4,bubblesheet line] per student).'
=> 'Vergleich der Bubblesheet-Daten (inklusive Korrekturen) mit den entsprechenden Einreichungs-Datensätzen (neueste Einreichung) für [_1][quant,_2,Student/in,Studierende][_3] ([quant,_4,Bubblesheet-Zeile,Bubblesheet-Zeilen] pro Student/in).',

   'Comparison of student IDs in the uploaded file with the course roster found matches for [_1] of the [_2] entries in the file (for the format defined for [_3]).'
=> 'Der Vergleich der Studierenden-IDs in der hochgeladenen Datei mit der Kursteilnehmerliste hat [_1] Treffer der insgesamt [_2] Einträge in der Datei ergeben (für das Format, das in [_3] festgelegt wurde).',

   'Comparison of student IDs: [_1] matching ([quant,_2,entry,entries])'
=> 'Vergleich der Studierenden-IDs: [_1] Treffer ([quant,_2,Eintrag,Einträge])',

   'Comparison of student IDs: [_1] matching ([_2]/[quant,_3,entry,entries])'
=> 'Vergleich der Studierenden-IDs: [_1] Treffer ([_2]/[quant,_3,Eintrag,Einträgen])',

   'Differences can occur if submissions were modified using manual grading after a bubblesheet grading pass.'
=> 'Es können Unterschiede auftreten, wenn Einreichungen nach einem Bubblesheet-Bewertungsdurchlauf über die manuelle Bewertung geändert wurden.',

   'Essay was found to be similar to another essay submitted for this assignment.'
=> 'Es wurden Ähnlichkeiten dieses Essays mit einem anderen Essay festgestellt, das für diese Übung eingereicht wurde.',

   'Modification of scores not allowed for the following username(s):'
=> 'Die Veränderung von Punkten ist für folgende Benutzer nicht zulässig:',

   'No scores stored for the following username(s):'
=> 'Für die folgenden Benutzer wurden keine Punkte gespeichert:',

   'Saved scores for [quant,_1,student]'
=> 'Für [quant,_1,Student/in/Studierende] wurden die Punkte gespeichert',

   'Warnings generated for the following saved scores:'
=> 'Es wurden Warnungen für folgende gespeicherte Punkte erzeugt:',

   'Students did not bubble their IDs, or mis-bubbled them'
=> 'Studierende haben ihre IDs nicht oder falsch angekreuzt.',

   'Students with differences between bubblesheet data and submissions are as follows:'
=> 'Studierende mit Abweichungen zwischen den Bubblesheet-Daten und den Einreichungen:',

   'Students with exact correspondence between bubblesheet data and submissions are as follows:'
=> 'Studierende mit exakter Übereinstimmung der Bubblesheet-Daten mit den Einreichungen:',

   'The data is not in the format expected for the domain: [_1]'
=> 'Die Daten sind nicht in dem Format, wie es für die Domäne [_1] erwartet wurde.',

   'Uploading file to [_1]'
=> 'Datei wird in [_1] hochgeladen',

   'You are not allowed to upload bubblesheet data to the requested course.'
=> 'Sie sind nicht berechtigt, Bubblesheet-Daten in den angeforderten Kurs hochzuladen.',

   'Upload successful'
=> 'Hochladen war erfolgreich',

   'Uploaded [_1] bytes of data into location: [_2]'
=> 'Es wurden [_1] Datenbytes an den Ort [_2] hochgeladen.',

   '[quant,_1,file] uploaded to this anonymous survey'
=> '[quant,_1,Datei wurde,Dateien wurden] für die anonyme Umfrage hochgeladen',

   'Your anonymous submission has been recorded, and credit awarded.'
=> 'Ihre anonyme Einreichung wurde gespeichert und Punkte wurden vergeben.',

   'Your anonymous submission has been recorded.'
=> 'Ihre anonyme Einreichung wurde gespeichert.',

   'Your submission has been recorded, and credit awarded.'
=> 'Ihre Einreichung wurde gespeichert und Punkte wurden vergeben.',

   'Scripting (optional)'
=> 'Skript (optional)',

   'Two-option checkboxes for:'
=> 'Zwei-Optionen-Checkboxen für:',

   'Append listing of contents of top level of package to contents list for the current folder.'
=> 'Hinzufügen einer Liste von Inhalten der obersten Ebene des Pakets zu der Inhaltsliste für das aktuelle Verzeichnis.',

   'Choose display options for listing of contents of top level of package'
=> 'Wahl der Anzeigeoptionen für die Inhaltsliste der obersten Ebene des Pakets',

   'Select a display option for the package content:'
=> 'Wählen Sie eine Anzeigeoption für den Paketinhalt:',

   'Unpacking of your IMS package failed because an IMS manifest file was not located in the package.'
=> 'Das Entpacken Ihres IMS-Pakets ist fehlgeschlagen, weil in dem Paket keine IMS-Manifest-Datei gefunden werden konnte.',

   'Unpacking of your IMS package failed because an IMS manifest file was not located in the package'
=> 'Das Entpacken Ihres IMS-Pakets ist fehlgeschlagen, weil in dem Paket keine IMS-Manifest-Datei gefunden werden konnte',

   'Processing of your IMS package failed, because the IMS content package did not contain an IMS manifest file.'
=> 'Die Verarbeitung Ihres IMS-Pakets ist fehlgeschlagen, da das IMS-Inhaltspaket keine IMS-Manifest-Datei enthält.',

   'Processing of your IMS package failed because the file you uploaded could not be unzipped'
=> 'Die Verarbeitung Ihres IMS-Pakets ist fehlgeschlagen, da die von Ihnen hochgeladene Datei nicht entpackt werden konnte.',

   'Processing of your IMS package failed because the file you uploaded could not be unzipped.'
=> 'Die Verarbeitung Ihres IMS-Pakets ist fehlgeschlagen, da die von Ihnen hochgeladene Datei nicht entpackt werden konnte.',

   '[quant,_1,item]'
=> '[quant,_1,Element,Elemente]',

   'De-select'
=> 'Auswahl aufheben',

   '(Previous URL backed up)'
=> '(vorherige URL wurde gesichert)',

   'Accept?'
=> 'Annehmen?',

   'Co-ownership is set automatically when a Course Coordinator role[_1] is assigned to official course personnel (from institutional data).'
=> 'Co-Eigentümer-Rechte werden automatisch vergeben,[_1] wenn eine Kurs-Koordinator-Rolle an offizielles Kurspersonal (von institutionellen Daten) vergeben wird.',

   'Current co-owners'
=> 'Derzeitige Co-Eigentümer',

   'Current co-owners are:'
=> 'Derzeitige Co-Eigentümer sind:',

   'Currently no co-owners.'
=> 'Derzeit keine Co-Eigentümer',

   'Decline?'
=> 'Ablehnen?',

   'Discontinue?'
=> 'Aufhören lassen?',

   'Invitation to be co-owner declined'
=> 'Einladung als Co-Eigentümer wurde abgewiesen',

   'Invite other Coordinators [_1]to become co-owners'
=> 'Andere Koordinatoren einladen,[_1]Co-Eigentümer zu werden',

   'Invited as co-owners [_1](agreement pending)'
=> 'Als Co-Eigentümer eingeladen [_1](Zustimmung ausstehend)',

   'Invited as co-owners, pending acceptance'
=> 'Als Co-Eigentümer eingeladen, Akzeptierung ausstehend',

   'None specified'
=> 'Nichts angegeben',

   'Please [_1]add the user(s)[_2] before returning to the [_3]Course Configuration[_2] to add as potential cloners.'
=> 'Bitte [_1]fügen Sie den/die Benutzer hinzu[_2], bevor Sie zu der [_3]Kurs-Konfiguration[_2] zurückkehren, um potentielle Kloner hinzuzufügen.',

   'Please [_1]add the user(s)[_2] before returning to the [_3]Community Configuration[_2] to add as potential cloners.'
=> 'Bitte [_1]fügen Sie den/die Benutzer hinzu[_2], bevor Sie zu der [_3]Community-Konfiguration[_2] zurückkehren, um potentielle Kloner hinzuzufügen.',

   'The course owner has invited you to become a co-owner:'
=> 'Der Kurs-Eigentümer hat Sie eingeladen, Co-Eigentümer zu werden:',

   'There are no coordinators to select as co-owners'
=> 'Es gibt keine Koordinatoren, die als Co-Eigentümer ausgewählt werden könnten',

   'Unable to add to allowed cloners: '
=> 'Hinzufügen zu zulässigen Klonern nicht möglich: ',

   'Unable to include amongst replacements for role names: '
=> 'Einfügen in die Ersetzungen für Rollennamen nicht möglich: ',

   'Unable to include as a recipient of community feedback for:'
=> 'Einfügen als Empfänger von Community-Feedback nicht möglich für:',

   'Unable to include as a recipient of course feedback for:'
=> 'Einfügen als Empfänger von Kurs-Feedback nicht möglich:',

   'Unable to include in community localization:'
=> 'Einfügen in Sprach- und Zeitzone der Community nicht möglich:',

   'Unable to include in course localization:'
=> 'Einfügen in Sprach- und Zeitzone des Kurse nicht möglich:',

   'Unable to include in user-based access control for:'
=> 'Einfügen in benutzer-basierter Zugriffskontrolle nicht möglich für:',

   'You are currently a co-owner:'
=> 'Sie sind derzeit ein Co-Eigentümer:',

   'Your co-ownership status'
=> 'Ihr Co-Eigentümer-Status',

   'Disallow more:'
=> 'Noch mehr nicht gestatten:',

   'Course Information - [_1]'
=> 'Kursinformationen - [_1]',

   'There are currently no publicly accessible or password protected group portfolio files.'
=> 'Es gibt derzeit keine Gruppen-Portfolio-Dateien, auf die öffentlich zugegriffen werden kann oder die passwortgeschützt sind.',

   'all access types '
=> 'alle Zugriffstypen ',

   '(Message not fully displayed due to incorrect embedded TeX.)'
=> '(Nachricht wird nicht vollständig angezeigt, da das eingebettete TeX fehlerhaft ist.)',

   'A new community could not be cloned from the specified original - [_1] - because it is a course not a community.'
=> 'Von dem angegebenen Original [_1] kann keine neue Community geklont werden, da es sich nicht um eine Community, sondern um einen Kurs handelt.',

   'Course creation failed, unrecognized course home server.'
=> 'Die Kurserstellung ist fehlgeschlagen, da der Heimatserver des Kurses unbekannt ist.',

   'It is recommended that you [_1]re-initialize the course[_2] and then return to this page.'
=> 'Es wird empfohlen, dass Sie den [_1]Kurs neu initialisieren[_2] und dann zu dieser Seite zurückkehren.',

   'It is recommended that you [_1]re-initialize the course[_2] and then try your search again.'
=> 'Es wird empfohlen, dass Sie den [_1]Kurs neu initialisieren[_2] und dann die Suche erneut ausführen.',

   'It is recommended that you [_1]re-select the course[_2].'
=> 'Es wird empfohlen, dass Sie den [_1]Kurs neu zu initialisieren[_2].',

   'You may need to [_1]re-select the course[_2] and then return to this resource to view it.'
=> 'Sie müssen ggf. [_1]den Kurs neu initialisieren[_2] und dann zurück zu dieser Ressource gehen, um sie zu betrachten.',

   'Parameters not set for [_1] because the contents of the community could not be retrieved.'
=> 'Die Parameter für [_1] wurden nicht gesetzt, da die Inhalte der Community nicht abgerufen werden konnten.',

   "An error occurred saving the modified course request for [_1] submitted by [_2] in the domain's courserequestqueue.db."
=> 'Beim Speichern des geänderten Kursantrags für [_1], eingereicht durch [_2], ist ein Fehler aufgetreten.',

   'An error occurred when removing the request for [_1] submitted by [_2] from the pending queue.'
=> 'Beim Entfernen des Antrags aus der Warteschlange ausstehender Punkte für [_1], eingereicht durch [_2], ist ein Fehler aufgetreten.',

   'Any course/community requests which are successfully validated will be created immediately.'
=> 'Alle Kurs-/Community-Anträge, die erfolgreich validiert wurden, werden sofort erstellt.',

   'For the following course/community requests an error occurred when removing requests from the pending queue:'
=> 'Für die folgenden Kurs-/Community-Anträge ist beim Entfernen aus der Warteschlange ausstehender Punkte ein Fehler aufgetreten:',

   "For the following course/community requests an error occurred when updating the requestor's own requests record:"
=> 'Für die folgenden Kurs-/Community-Anträge ist beim Aktualisieren des eigenen Anforderungsdatensatzes des Anforderers ein Fehler aufgetreten:',

   'For the following requests, the requestor could [_1]not[_2] be validated as official course personnel, so the request remains in the pending queue.'
=> 'Für die folgenden Anträge konnte der Anforderer [_1]nicht[_2] als offizielles Kurspersonal bestätigt werden, so dass der Antrag in der Warteschlange ausstehender Punkte verbleibt.',

   "For the following users, an error occurred when updating the user's own self-enroll requests record:"
=> 'Für die folgenden Benutzer ist beim Aktualisieren des eigenen Selbsteintragungs-Anforderungsdatensatzes des Benutzers ein Fehler aufgetreten:',

   'If unvalidated, the request will be held in a queue.'
=> 'Falls nicht validiert, verbleibt der Antrag in der Warteschlange.',

   'Queued course request for [_1] submitted by [_2] with status [_3] rejected when validating.'
=> 'Der in der Warteschlange eingereihte Kursantrag für [_1], eingereicht durch [_2] mit dem Status [_3], wurde beim Validieren abgelehnt.',

   'Queued course request for [_1] submitted by [_2] with status [_3] switched to "approval by DC" because of validation error: [_4].'
=> 'Der in der Warteschlange eingereihte Kursantrag für [_1], eingereicht durch [_2] mit dem Status [_3], wurde aufgrund eines Validierungsfehlers ([_4]) in "Bestätigung durch DC" geändert.',

   'Requests are validated against institutional data to confirm that the requestor is an instructor of record.'
=> 'Anträge werden gegen institutionelle Daten validiert, um zu bestätigen, dass der Anforderer ein Dozent des Datensatzes ist.',

   'Requests for official courses queued pending validation'
=> 'Anträge auf offizielle Kurse, die auf Validierung warten',

   'Requests may be left in the queue, or you can manually approve or reject them.'
=> 'Anträge können in der Warteschalange bleiben. Sie können diese auch manuell bestätigen oder ablehnen.',

   'Self-enrollment requests queued pending approval by a Coordinator'
=> 'Selbsteintragungs-Anträge, die auf Bestätigung durch einen Koordinator warten',

   'There are currently no course or community requests awaiting approval.'
=> 'Derzeit gibt es keine Kurse oder Communitys, die auf Bestätigung warten.',

   'Unvalidated requests will be listed for manual approval/rejection.'
=> 'Nicht validierte Anträge werden in der manuellen Bestätigungs-/Ablehnungs-Liste angezeigt.',

   'Validate'
=> 'Validieren',

   'Validation is attempted when the request is submitted.'
=> 'Eine Validierung wird versucht, wenn der Antrag eingereicht wird.',

   'Validation of pending requests is automatically repeated daily.'
=> 'Validierung von ausstehenden Anträgen wird automatisch täglich wiederholt.',

   'Assigning role of '
=> 'Zuweisung der Rolle ',

   'Validation Attempted'
=> 'Validierung versucht',

   '[_1] Display Request Queue'
=> '[_1] Antrags-Warteschlange anzeigen',

   '[_1] Requests Updated'
=> '[_1] Anträge wurden aktualisiert',

   'Requests Updated'
=> 'Anträge wurden aktualisiert',

   'Requests Validation Result'
=> 'Ergebnis der Antragsvalidierung',

   'Update Requests Result'
=> 'Ergebnis der Aktualisierung der Anträge',

   "(You can only define new users in the new course's domain - [_1])"
=> '(Sie können neue Benutzer nur in der Domäne des neuen Kurses ([_1]) anlegen)',

   'Availability determined currently from custom setting.'
=> 'Verfügbarkeit wird derzeit durch benutzerdefinierte Einstellung bestimmt.',

   'Availability determined currently from default setting.'
=> 'Verfügbarkeit wird derzeit durch voreingestellte Einstellung bestimmt.',

   'Course/Community Level'
=> 'Kurs-/Community-Ebene',

   'Currently from custom setting.'
=> 'Derzeit durch benutzerdefinierte Einstellung.',

   'Currently from default setting.'
=> 'Derzeit durch voreingestellte Einstellung.',

   'Enrolling Member'
=> 'Teilnehmer wird/werden aufgenommen',

   'User Can Request Creation of Courses/Communities in this Domain?'
=> 'Darf der Benutzer Anträge auf Erstellung von Kursen/Communitys in dieser Domäne stellen?',

   'User Can Request Assignment of Domain Roles?'
=> 'Darf der Benutzer Anträge auf Zuweisung von Domänenrollen stellen?',

   'View/Modify existing role:'
=> 'Bestehende Rolle betrachten/ändern:',

   'Yes, automatic creation'
=> 'Ja, automatische Erstellung',

   'Yes, processed automatically'
=> 'Ja, automatisch fortfahren',

   'Yes, up to [quant,_1,request]/user'
=> 'Ja, bis zu [quant,_1,Antrag,Anträge]/Benutzer',

   'Yes, up to limit of [quant,_1,request] per user.'
=> 'Ja, bis zu einer Grenze von [quant,_1,Antrag,Anträgen] pro Benutzer.',

   "You are not authorized to define new users in the new course's domain - [_1]."
=> 'Sie sind nicht berechtigt, neue Benutzer in der Domäne des neuen Kurses ([_1]) anzulegen.',

   'Enrollment result'
=> 'Ergebnis der Belegung',

   'User Information (unchanged)'
=> 'Benutzerinformation (unverändert)',

   'Yes, need approval'
=> 'Ja, Bestätigung notwendig',

   'Yes, with validation'
=> 'Ja, mit Validierung',

   'Note that grading records for problems included in this sequence or folder will overlap.'
=> 'Beachten Sie, dass sich Bewertungsdatensätze für Aufgaben in dieser/m Sequenz/Verzeichnis überlappen werden.',

   'Upload of new portfolio files and assignment of a non-zero MB quota to new groups in the community will not be possible until some files have been deleted, and total usage is below community quota.'
=> 'Hochladen neuer Portfolio-Dateien und das Zuweisen eines von Null MB abweichenden Speicherplatzes an neue Gruppen in der Community wird nicht möglich sein, solange nicht einige Dateien gelöscht werden und die Gesamtnutzungsmenge nicht unterhalb des Community-Speicherplatzes bleibt.',

   'Reservable ending [_1]'
=> 'Reservierungszeitraum endet am [_1]',

   'Reservable starting [_1]'
=> 'Reservierungszeitraum startet am [_1]',

   'Reserve a time/place to work'
=> 'Zeit/Ort zum Arbeiten anmelden',

   'Reserved - ends [_1]'
=> 'Reserviert - endet am [_1]',

   'Reserved - next open [_1]'
=> 'Reserviert - nächste Verfügbarkeit am [_1]',

   'Reserved - specific location(s) - ends [_1]'
=> 'Reserviert - bestimmte(r) Ort(e) - endet am [_1]',

   'Submission in grading queue'
=> 'Einreichung in Bewertungs-Warteschlange',

   'Survey submission recorded'
=> 'Umfrageeinreichung wurde aufgezeichnet',

   'Cloneable by you'
=> 'Durch Sie klonbar',

   'Cloneable for [_1]'
=> 'Klonbar für [_1]',

   'No cloning for [_1]'
=> 'Nicht klonbar für [_1]',

   'No restriction'
=> 'Keine Beschränkung',

   'No rights to clone'
=> 'Keine Berechtigung zum Klonen',

   'Selecting course personnel'
=> 'Auswahl des Kurspersonals',

   'You are not authorized to create new institutional users in this domain.'
=> 'Sie sind nicht berechtigt, institutionelle Benutzer in dieser Domäne zu erstellen.',

   'You are not authorized to create new non-institutional users in this domain.'
=> 'Sie sind nicht berechtigt, nicht-institutionelle Benutzer in dieser Domäne zu erstellen.',

   'Changing default start and end access dates will affect [_1]future enrollments[_2] and also [_1]currently inactive[_2] students (i.e., those for whom access will begin in the future).'
=> 'Das Ändern von voreingestellten Anfangs- und Endzugriffszeiten wird sich auf [_1]zukünftige Kursbelegungen[_2] sowie auf [_1]derzeit inaktive[_2] Studierende auswirken (z.B. für solche, die zukünftig Zugriff erhalten werden)',

   'To change access dates for [_1]currently active[_2] students, use User Management -> "Manage course users" to display currently active students, then use the dropdown menu for "Action to take for selected users:" to choose "Change starting/ending dates", select the students to change, and click "Proceed".'
=> 'Um die Zugriffszeiten für [_1]derzeit aktive[_2] Studierende zu ändern, gehen Sie zur Benutzerverwaltung -> "Teilnehmer verwalten", um derzeit aktive Studierende anzeigen zu lassen. Verwenden Sie die Dropdownliste bei "Aktion für ausgewählte Benutzer" und wählen Sie dort "Anfangs-/Endezeiten ändern", wählen Sie dann die Studierenden, für die die Daten geändert werden sollen und klicken Sie auf "Weiter".',

   'Automatic update of first, middle and last names if institutional directory information indicates changes'
=> 'Automatisches Aktualisieren der Felder "Vorname", "Zweiter Vorname" und "Nachname", falls im Institutionsverzeichnis Änderungen feststellt werden.',

   'Based on your institutional affiliation no name information is automatically updated for your LON-CAPA account.'
=> 'Gemäß Ihrer institutionellen Zugehörigkeit werden Namensdaten für Ihren LON-CAPA-Account nicht automatisch aktualisiert.',

   'By default, based on your institutional affiliation, your LON-CAPA account can be automatically updated nightly based on directory information from your institution.'
=> 'Gemäß Ihrer institutionellen Zugehörigkeit kann Ihr LON-CAPA-Account per Voreinstellung nächtlich automatisch aktualisiert werden. Die Daten basieren auf den Verzeichnisinformationen Ihrer Institution.',

   'Disallow automatic updates to name information for your LON-CAPA account'
=> 'Automatische Aktualisierungen Ihrer Namensdaten für Ihren LON-CAPA-Account nicht gestatten',

   'The following may be updated, unless you disallow updates:'
=> 'Die folgenden Felder können aktualisiert werden, solange Sie nicht eine Aktualisierung nicht gestatten:',

   'You are not permitted to set a user preference for automatic name updates for your LON-CAPA account.'
=> 'Sie sind nicht berechtigt, Benutzereinstellungen für automatische Namensänderungen Ihres Accounts vorzunehmen.',

   'Allow/disallow name updates'
=> 'Namensaktualisierungen gestatten/nicht gestatten',

   'Automatic name changes'
=> 'Automatische Namensänderungen',

   'Page Display Settings'
=> 'Seitenanzeige-Einstellungen',

   'An error occurred validating your request with institutional data sources: [_1].'
=> 'Beim Validieren Ihres Antrags mit institutionellen Datenquellen ist ein Fehler aufgetreten.',

   'Any status'
=> 'Beliebiger Status',

   'Cancellation Date'
=> 'Stornierungsdatum',

   'No course request ID provided.'
=> 'Es wurde keine Kursantrags-ID angegeben.',

   'Not all requested personnel could be included.'
=> 'Es konnte nicht vollständig das gewünschte Personal eingebunden werden.',

   'Not applicable'
=> 'Nicht anwendbar',

   'Rejection Date'
=> 'Ablehnungsdatum',

   'Request Cancellation'
=> 'Antragsstornierung',

   'Request Date'
=> 'Antragsdatum',

   'Request Status:'
=> 'Antragsstatus:',

   'Review'
=> 'Überprüfung',

   'Review community request details before submission'
=> 'Überprüfung der Community-Antrags-Details vor dem Absenden',

   'Review course request details before submission'
=> 'Überprüfung der Kursantrags-Details vor dem Absenden',

   'Sections of [_1]'
=> 'Sektionen von [_1]',

   'Shift dates by [_1] days'
=> 'Datumswerte um [_1] Tage verschieben',

   'Specify the course to be created.'
=> 'Angabe des Kurses, der erstellt werden soll.',

   'The current status of this request could not be verified as pending approval/institutional action.'
=> 'Der aktuelle Status dieses Antrags kann nicht überprüft werden, da noch eine Bestätigung bzw. institutionelle Aktion aussteht.',

   'The following community [quant,_1,role] will become available for selection from your [_2]roles page[_3], once the default student access start date - [_4] - has been reached:'
=> 'Die [quant,_1,folgende Community-Rolle wird,folgenden Community-Rollen werden] verfügbar, sobald die studentische Anfangszugriffszeit [_4] erreicht ist:',

   'The following course [quant,_1,role] will become available for selection from your [_2]roles page[_3], once the default student access start date - [_4] - has been reached:'
=> 'Die [quant,_1,folgende Kursrolle wird,folgenden Kursrollen werden] verfügbar, sobald das studentische Anfangszugriffszeit [_4] erreicht ist:',

   'The following crosslisted courses were invalid:'
=> 'Die folgenden fachübergreifenden Kurse waren ungültig:',

   'The list of instructional personnel for the course will be automatically checked daily, and once you are listed the request will be processed.'
=> 'Die Liste des Dozentenpersonals für diesen Kurs wird automatisch jeden Tag überprüft werden und, sobald Sie in der Liste stehen, wird der Antrag ausgeführt werden.',

   'The request cancellation process was not complete.'
=> 'Der Antragsabbruchs-Vorgang war nicht vollständig.',

   'Unknown status'
=> 'Unbekannter Status',

   "Usually this means that your institution's information systems do not list you among the instructional personnel for this course."
=> 'Normalerweise bedeutet dies, dass die Informationssyteme Ihrer Institution Sie nicht als Dozentenpersonal für diesen Kurs gelistet haben.',

   'Window during which course/community was requested:'
=> 'Zeitfenster, in dem der Kurs/die Community beantragt wurde:',

   'You are not permitted to request creation of communities'
=> 'Sie sind nicht berechtigt, die Erstellung von Communitys zu beantragen',

   'You are not permitted to request creation of official courses.'
=> 'Sie sind nicht berechtigt, die Erstellung von offiziellen Kursen zu beantragen.',

   'You are not permitted to request creation of unofficial courses.'
=> 'Sie sind nicht berechtigt, die Erstellung von nicht-offiziellen Kursen zu beantragen.',

   'You may want to review the request details and submit the request again.'
=> 'Sie können die Antragsdetails überprüfen und Ihren Antrag erneut abschicken.',

   'Your community limit is [_1].'
=> 'Ihre Community-Begrenzung ist [_1].',

   'Your course limit is [_1].'
=> 'Ihre Kursbegrenzung ist [_1].',

   'Your request has been placed in a queue pending administrative action.'
=> 'Ihr Antrag wurde in die Warteschlange für ausstehende administrative Aktionen aufgenommen.',

   'Queued pending approval'
=> 'Eingereiht in ausstehende Bestätigung',

   'Queued for approval'
=> 'Eingereiht in ausstehende Bestätigung',

   'Queued pending validation'
=> 'Eingereiht in ausstehende Validierung',

   'Queued, pending validation'
=> 'Eingereiht, ausstehende Validierung',

   'Request cancelled'
=> 'Antrag storniert',

   'Request rejected'
=> 'Antrag abgelehnt',

   'Although more than one section was indicated, a role was only added for the first section - [_1], as each community member may only be in one section at a time.'
=> 'Auch wenn mehr als Sektion angegeben war, wird eine Rolle nur für die erste Sektion [_1] hinzugefügt, da ein jeder Community-Teilnehmer nur in einer Sektion zur gleichen Zeit sein kann.',

   'Although more than one section was indicated, a role was only added for the first section - [_1], as each student may only be in one section of a course at a time.'
=> 'Auch wenn mehr als Sektion angegeben war, wird eine Rolle nur für die erste Sektion [_1] hinzugefügt, da ein jeder Community-Teilnehmer nur in einer Sektion zur gleichen Zeit sein kann.',

   'For a community role that is not "member", users may have roles in more than one section at a time.'
=> 'Für Community-Rollen, die nicht "Teilnehmer" sind, können Benutzer Rollen in mehr als einer Sektion zur gleichen Zeit haben.',

   'For member roles, changing the section will result in a section switch, as members may only be in one section of a community at a time.'
=> 'Das Ändern der Sektion für Teilnehmerrollen wird einen Wechsel der Sektion zur Folge haben, da Teilnehmer nur in einer Sektion einer Community zur gleichen Zeit sein können.',

   'For a course role that is not "student", users may have roles in more than one section at a time.'
=> 'Für Kursrollen, die nicht "Student/in" sind, können Benutzer Rollen in mehr als einer Sektion zur gleichen Zeit haben.',

   'For student roles, changing the section will result in a section switch as students may only be in one section of a course at a time.'
=> 'Das Ändern der Sektion für Studierende wird einen Wechsel der Sektion zur Folge haben, da Studierende nur in einer Sektion eines Kurses zur gleichen Zeit sein können.',

   "Section assignment for role of '[_1]' in [_2] for '[_3]' unchanged."
=> "Die Zuweisung der Rolle '[_1]' in [_2] für '[_3]' bleibt unverändert.",

   'Section(s): [_1] - [_2]'
=> 'Sektion(en): [_1] - [_2]',

   '[_1]No section[_2] - [_3]'
=> '[_1]Keine Sektion[_2] - [_3]',

   'future role(s); starts: [_1].'
=> 'zukünftige Rolle(n); Start: [_1]',

   'role(s) active now; ends [_1].'
=> 'Rolle(n) jetzt aktiv; endet/n [_1]',

   'role(s) active now; no end date'
=> 'Rolle(n) jetzt aktiv; kein Enddatum',

   'role(s) expired: [_1].'
=> 'Rolle(n) am [_1] abgelaufen',

   'The conditions can include affiliation with a particular course or community, or a user account in a specific domain.'
=> 'Die Bedingungen können eine Zugehörigkeit mit einem/r bestimmten/r Kurs/Community oder Benutzeraccount in einer bestimmten Domäne beinhalten.',

   'Your earlier request is in a queue awaiting action by a Course Coordinator.'
=> 'Ihr früherer Antrag ist in einer Warteschlange und wartet auf Bearbeitung durch einen Kurs-Koordinator.',

   'History of member-reservable slots for: [_1]'
=> 'Historie der durch Teilnehmer reservierbaren Slots für [_1]',

   'Reservation changes for member-reservable slot: [_1]'
=> 'Reserverierungsänderungen für durch Teilnehmer reservierbaren Slot: [_1]',

   'Reservation changes for student-reservable slot: [_1]'
=> 'Reserverierungsänderungen für durch Studierende reservierbaren Slot: [_1]',

   'Reservation history unavailable for non-member-reservable slot: [_1].'
=> 'Die Reservierungshistorie ist für Nicht-Teilnehmer reservierbaren Slot nicht erreichbar: [_1]',

   'Reservation history unavailable for non-student-reservable slot: [_1].'
=> 'Die Reservierungshistorie ist für Nicht-Studierende reservierbaren Slot nicht erreichbar: [_1]',

   'Reserved:'
=> 'Reserviert:',

   'Scheduled Members'
=> 'Vorgesehene Teilnehmer',

   'Submitted and currently in grading queue.'
=> 'Eingereicht und derzeit in Bewertungs-Warteschlange',

   'Time members can start reserving'
=> 'Zeit, zu der Teilnehmer ihre Reservierung starten können',

   'Availability list'
=> 'Verfügbarkeitsliste',

   'File Dialogs'
=> 'Datei-Dialoge',

   'The following are valid extensions: [_1].'
=> 'Zulässige Erweiterungen sind: [_1]',

   'Condense'
=> 'Verdichten',

   'Revert'
=> 'Rückgängig machen',

   'Revert to beginning of edit session?'
=> 'Alles bis zum Anfang der Sitzung rückgängig machen?',

   'Straighten'
=> 'Gerade richten',

   'Toggle display'
=> 'Anzeige umschalten',

   'Version Actions'
=> 'Versionsaktionen',

   'Map not loaded - Lock file could not be opened when reading map:'
=> 'Inhaltszusammenstellung nicht geladen - Sperrdatei konnte nicht geöffnet werden, als die Zusammenstellung gelesen wurde:',

   'Version discrepancy: resource [_1] included in both version [_2] and version [_3]. Using version [_2].'
=> 'Versionswiderspruch: Die Ressource [_1] ist in zwei Versionen eingebunden, [_2] und [_3]. Es wird Version [_2] verwendet.',

   'You can only select maps and folders which have modifiable settings.'
=> 'Sie können nur solche Inhaltszusammenstellungen und Verzeichnisse auswählen, die veränderbare Einstellungen haben.',

   'As no gradable form items were found, no submissions have been recorded.'
=> 'Da keine bewertbaren Elemente gefunden wurden, wurden auch keine Einreichungen gespeichert.',

   'Could not determine identity of this course.'
=> 'Identität des Kurses konnte nicht festgestellt werden.',

   'Did you download the PDF form from another course and upload it to the wrong course?'
=> 'Haben Sie vielleicht das PDF-Formular von einem anderen Kurs heruntergeladen und in den falschen Kurs wieder hochgeladen?',

   'Result of PDF Form upload'
=> 'Ergebnis des PDF-Formular-Hochladens',

   'The uploaded file does not appear to be a PDF file.'
=> 'Die hochgeladene Datei ist offenbar keine PDF-Datei.',

   'Upload of PDF forms is not permitted for this course.'
=> 'Hochladen von PDF-Formularen ist für diesen Kurs nicht gestattet.',

   'Verification of PDF form items failed'
=> 'Die Überprüfung der Elemente des PDF-Formulars ist fehlgeschlagen',

   'Your uploaded PDF form contained the following resource(s) from [_1] different courses:'
=> 'Ihr hochgeladenes PDF-Formular enthält folgende Ressource(n) aus [_1] anderen Kursen:',

   'Your uploaded PDF form contained the following resource(s) from a different course:'
=> 'Ihr hochgeladenes PDF-Formular enthält folgende Ressource(n) aus einem anderen Kurs:',

   'The following [quant,_1,warning was,warnings were] generated when applying your changes to automated enrollment:'
=> 'Folgende [quant,_1,Warnung wurde,Warnungen wurden] beim Anwenden der Änderungen an der automatischen Kursbelegung erzeugt:',

   'As no section numbers are currently listed for "[_1]", automated enrollment will not occur for any sections of institutional course code: "[_2]".'
=> 'Da derzeit keine Sektionsnummern für "[_1]" aufgelistet werden, wird die automatische Kursbelegung für keine Sektionen mit dem institutionellen Kurs-Code "[_2]" stattfinden.',

   'Display course catalog set to on '
=> 'Anzeige der Kurs-/Community-Übersicht wurde aktiviert ',

   'Display course catalog set to off'
=> 'Anzeige der Kurs-/Community-Übersicht wurde deaktiviert',

   'Display administrator E-mail address set to on'
=> 'Anzeige der Administrator-E-Mail-Adresse wurde aktiviert',

   'Display administrator E-mail address set to off'
=> 'Anzeige der Administrator-E-Mail-Adresse wurde deaktiviert',

   'Link for visitors to create a user account'
=> 'Link für Besucher zum Erstellen eines Benutzeraccounts',

   'Link for visitors to create a user account set to on'
=> 'Link für Besucher zum Erstellen eines Benutzeraccounts wurde aktiviert',

   'Link for visitors to create a user account set to off'
=> 'Link für Besucher zum Erstellen eines Benutzeraccounts wurde deaktiviert',

   'Log-in box header set to on'
=> 'Login-Box-Kopfbereich wurde aktiviert',

   'Log-in box header set to off'
=> 'Login-Box-Kopfbereich wurde deaktiviert',

   'Identity of course creator of courses from XML files set to [_1]'
=> 'Identität des Kurs-Erstellers von Kursen aus XML-Dateien ist jetzt [_1]',

   'Auto-creation of courses in XML course description files set to [_1]on [_2]'
=> 'Automatische Erstellung von Kursen in XML-Kursbeschreibungs-Dateien wurde aktiviert',

   'Auto-creation of courses in XML course description files set to [_1]off [_2]'
=> 'Automatische Erstellung von Kursen in XML-Kursbeschreibungs-Dateien wurde deaktiviert',

   'Auto-creation of validated requests for official courses set to [_1]on [_2]'
=> 'Automatische Erstellung von validierten Anträgen für offizielle Kurse wurde aktiviert',

   'Auto-creation of validated requests for official courses set to [_1]off [_2]'
=> 'Automatische Erstellung von validierten Anträgen für offizielle Kurse wurde deaktiviert',

   'Assign a category to a community set in Domain ("Modify Course/Community")'
=> 'Zuweisen einer Kategorie an eine Community wird in der Domäne konfiguriert ("Kurs/Community ändern")',

   'Assign a category to a community set in Community ("Community Configuration")'
=> 'Zuweisen einer Kategorie an eine Community wird in der Community konfiguriert ("Community-Konfiguration")',

   'Automatically assign co-ownership'
=> 'Automatisches Zuweisen von Co-Eigentümer-Rechten',

   'Automatic assignment of co-ownership to instructors of record (institutional data) set to on'
=> 'Automatisches Zuweisen von Co-Eigentümer-Rechten an Dozenten des Datensatzes (institutionelle Daten) wurde aktiviert',

   'Automatic assignment of co-ownership to instructors of record (institutional data) set to off'
=> 'Automatisches Zuweisen von Co-Eigentümer-Rechten an Dozenten des Datensatzes (institutionelle Daten) wurde deaktiviert',

   'Show/Hide a community in catalog set in Community ("Community Configuration")'
=> 'Anzeigen/Verbergen einer Community in der Kurs-/Community-Übersicht wird in der Community konfiguriert ("Community-Konfiguration")',

   'Show/Hide a community in catalog set in Domain ("Modify Course/Community")'
=> 'Anzeigen/Verbergen einer Community in der Kurs-/Community-Übersicht wird auf Domänenebene konfiguriert ("Domänen-Konfiguration")',

   '(Automatic processing of any request).'
=> '(Automatisches Verarbeiten aller Anträge).',

   '(Automatic processing of requests up to limit of [quant,_1,request] per user).'
=> '(Automatisches Verarbeiten von Anträgen bis zu einer Grenze von [quant,_1,Antrag,Anträgen] pro Benutzer).',

   'Although institutional affiliations permitted to create accounts were changed, self creation of accounts is not currently permitted for any authentication types.'
=> 'Auch wenn die Einstellungen zum Erlauben des Erstellens von Accounts durch institutionelle Zugehörigkeiten geändert wurde, ist die Selbsterstellung von Accounts derzeit für keine Authentifizierungstypen zulässig.',

   'An error occurred publishing the [_1] bubblesheet format file in RES space. Error was: [_2].'
=> 'Beim Veröffentlichen der [_1]-Bubblesheet-Formatdatei in den Ressourcen-Bereich ist ein Fehler aufgetreten. Der Fehler war: [_2]',

   'Changes made to bubblesheet format file.'
=> 'An der Bubblesheet-Formatdatei wurden Änderungen vorgenommen.',

   'Creation of a new account for an institutional user is restricted to the following institutional affiliation(s):'
=> 'Die Erstellung von neuen Accounts für institutionelle Benutzer ist auf folgende institutionelle Zugehörigkeiten beschränkt:',

   'Custom Login Page Help File In Use'
=> 'Benutzerdefinierte Login-Hilfe-Datei wird verwendet',

   'Custom Path'
=> 'Benutzerdefinierter Pfad',

   'Custom bubblesheet format file'
=> 'Benutzerdefinierte Bubblesheet-Formatdatei',

   'Custom bubblesheet format file ([_1]) uploaded for use with courses in this domain.'
=> 'Benutzerdefinierte Bubblesheet-Formatdatei [_1] wurde zur Verwendung in Kursen dieser Domäne hochgeladen.',

   'Default bubblesheet format file'
=> 'Voreingestellte Bubblesheet-Formatdatei',

   "However, no institutional affiliations (including 'other') are currently permitted to create accounts."
=> 'Dennoch sind derzeit institutionellen Zugehörigkeiten (inklusive "andere") die Erstellung von Accounts nicht gestattet.',

   'However, users authenticated by institutional login/single sign on are not currently permitted to create accounts.'
=> 'Dennoch ist es Benutzern, die durch institutionellen Login oder Single-Sign-On authentifiziert werden, derzeit nicht gestattet, Accounts zu erstellen.',

   "Institutional affiliations permitted to create accounts set to 'None'."
=> 'Erlaubnis des Erstellens von Accounts durch institutionelle Zugehörigkeiten wurde auf "keine" gesetzt.',

   "Institutional affiliations permitted to create accounts were set to 'none'."
=> 'Erlaubnis des Erstellens von Accounts durch institutionelle Zugehörigkeiten wurde auf "keine" gesetzt.',

   'Institutional affiliations permitted to create accounts with institutional authentication were set as follows:'
=> 'Erlaubnis des Erstellens von Accounts durch institutionelle Zugehörigkeiten wurde auf folgende Einstellung gesetzt:',

   'creation of a new account is permitted for:'
=> 'Die Erstellung eines neuen Accounts ist gestattet für:',

   'Self-creation of a new account is permitted for:'
=> 'Die Selbsterstellung eines neuen Accounts ist gestattet für:',

   'Institutional affiliation(s) able to create own account (login/SSO)'
=> 'Institutionelle Zugehörigkeiten dürfen Account erstellen (Login/SSO)',

   'Institutional user type (login/SSO self-creation)'
=> 'Institutioneller Benutzertyp (Login/SSO-Selbsterstellung)',

   'Log-in page availability:'
=> 'Verfügbarkeit der Login-Seite:',

   'Server: [_1] has standard log-in page.'
=> 'Server [_1] hat Standard-Login-Seite.',

   'Server: [_1] log-in page redirects to [_2].'
=> 'Die Login-Seite des Servers [_1] leitet auf [_2] um.',

   'Redirect to:'
=> 'Umleitung nach:',

   'No redirection for clients from following IPs:'
=> 'Keine Umleitungen für Clients mit folgenden IP-Adressen:',

   'Exempt IP(s)'
=> 'Ausgenommene IP-Adresse(n)',

   'Set to be available to [_1].'
=> 'Eingestellt, um verfügbar zu sein für [_1].',

   'Set to be available to [_1]'
=> 'Eingestellt, um verfügbar zu sein für [_1]',

   'No Domain Coordinators will receive notification of course requests requiring approval.'
=> 'Es werden keine Domänen-Koordinatoren Benachrichtigungen über Kursanträge, die eine Bestätigung erfordern, erhalten.',

   'No Domain Coordinators will receive notification of requests requiring approval.'
=> 'Es werden keine Domänen-Koordinatoren Benachrichtigungen über Anträge, die eine Bestätigung erfordern, erhalten.',

   'No Domain Coordinators will receive notification of username requests requiring approval.'
=> 'Es werden keine Domänen-Koordinatoren Benachrichtigungen über Benutzerkennungsanträge, die eine Bestätigung erfordern, erhalten.',

   'Notification of requests requiring approval will be sent to: '
=> 'Benachrichtigungen über Anträge, die eine Bestätigung erfordern, werden gesendet an:',

   'Notification of username requests requiring approval will be sent to: '
=> 'Benachrichtigungen über Benutzerkennungsanträge, die eine Bestätigung erfordern, werden gesendet an:',

   "Unable to copy default bubblesheet formatfile to domain's RES space: [_1]"
=> 'Kopieren der Bubblesheet-Formatdatei in den Ressourcenbereich der Domäne [_1] ist nicht möglich.',

   'Upload of bubblesheet format file is not permitted to this server: [_1]'
=> 'Hochladen der Bubblesheet-Formatdatei ist für diesen Server [_1] nicht gestattet.',

   'Upload of custom help file is not permitted to this server: [_1]'
=> 'Hochladen einer benutzerdefinierten Hilfedatei ist für diesen Server [_1] nicht gestattet.',

   'User preference to lock name'
=> 'Benutzereinstellung zum Sperren des Namens',

   "User preference to disable replacement of user's name with institutional data (by auto-update) is unavailable."
=> 'Die Benutzereinstellung zum Deaktivieren des Ersetzens des Namens des Benutzers durch institutionelle Daten (durch das automatische Aktualisieren) ist nicht verfügbar.',

   "User preference to disable replacement of user's name with institutional data (by auto-update), available for the following affiliations:"
=> 'Die Benutzereinstellung zum Deaktivieren des Ersetzens des Namens des Benutzers durch institutionelle Daten (durch das automatische Aktualisieren) ist für folgende Zugehörigkeiten verfügbar:',

   '[_1] bubblesheet format file removed; [_2] file will be used for courses in this domain.'
=> 'Die Bubblesheet-Formatdatei [_1] wurde entfernt. Die Datei [_2] wird nun für Kurse in dieser Domäne verwendet.',

   'with Bcc to'
=> 'mit Blindkopie (BCC) an',

   '(Processing of request subject to approval by Domain Coordinator).'
=> '(Verarbeitung von Anträgen ist abhängig von der Bestätigung durch den Domänen-Koordinator)',

   '(Processing of request subject to institutional validation).'
=> '(Verarbeitung von Anträgen ist abhängig von der institutionellen Validierung)',

   'Set in Community'
=> 'In der Community gesetzt',

   'Set in Course'
=> 'Im Kurs gesetzt',

   'Set in Domain'
=> 'In der Domäne gesetzt',

   'Auto-update:'
=> 'Automatisches Aktualisieren:',

   'Status of user'
=> 'Status des Benutzers',

   'Target user has role'
=> 'Zielbenutzer hat Rolle',

   'Updates to user information in classlists?'
=> 'Aktualisierungen an den Benutzerdaten in den Kursteilnehmerlisten?',

   'User information updatable in author context'
=> 'Im Autorenkontext aktualisierbare Benutzerdaten',

   'User information updatable in course context'
=> 'Im Kurskontext aktualisierbare Benutzerdaten',

   'In author context'
=> 'Im Autorenkontext',

   'In course context'
=> 'Im Kurskontext',

   'Users allowed to search'
=> 'Benutzer, die berechtigt sind zu suchen',

   'Use CODE'
=> 'Verwende CODE',

   'CODE: [_1]'
=> 'CODE: [_1]',

   'CODE'
=> 'CODE',

   'Saved CODEs to validate against:'
=> 'Gespeicherte CODEs, um sie zu validieren mit:',

   'List of CODES to validate against:'
=> 'Liste von CODEs, um sie zu validieren mit:',

   'Each CODE is only to be used once:'
=> 'Jeder CODE darf nur einmal verwendet werden:',

   'The encoded CODE is not in the list of possible CODEs.'
=> 'Der codierte CODE kommt nicht in der Liste der möglichen CODEs vor.',

   'The encoded CODE has also been used by a previous paper [_1], and CODEs are supposed to be unique.'
=> 'Der codierte CODE wurde bereits auf einem vorherigen Blatt [_1] verwendet. CODEs müssen jedoch eindeutig sein.',

   'The CODE on the form is [_1]'
=> 'Der CODE auf dem Formular ist [_1]',

   'Use the similar CODE [_1] instead.'
=> 'Stattdessen ähnlichen CODE [_1] verwenden.',

   'Use the CODE [_1] that was on the paper, ignoring the error.'
=> 'Den CODE [_1] verwenden, der auf dem Blatt war und den Fehler ignorieren.',

   '[_1]Select[_2] a CODE from the list of all CODEs and use it.'
=> '[_1]Auswahl eines CODEs[_2] aus der Liste aller CODEs und diesen verwenden.',

   'Selected CODE is [_1]'
=> 'Gewählter CODE ist [_1]',

   'Use [_1] as the CODE.'
=> 'CODE [_1] verwenden.',

   'Mismatch grading bubblesheet for user: [_1] with ID: [_2].'
=> 'Abgleichsfehler beim Bewerten des Bubblesheets für den Benutzer [_1] mit der ID [_2].',

   'Mismatch grading bubblesheet for user: [_1] with ID: [_2] and CODE: [_3].'
=> 'Abgleichsfehler beim Bewerten des Bubblesheets für den Benutzer [_1] mit der ID [_2] und dem CODE [_3].',

   'Source'
=> 'Quelle',

   'Bubbled responses'
=> 'Angekreuzte Antworten',

   'Selecting a CODE'
=> 'Auswahl eines CODEs',

   'The CODE on the paper is [_1]. Please select a new one.'
=> 'Der CODE auf dem Blatt ist [_1]. Bitte wählen Sie einen neuen aus.',

   'Bubblesheet Exams using this CODE'
=> 'Bubblesheet-Prüfungen, die diesen CODE verwenden',

   'Select another set of saved CODEs to view.'
=> 'Wählen Sie zum Betrachten eine andere Gruppe von gespeicherten CODEs.',

   'Select a set of saved CODEs to view.'
=> 'Wählen Sie eine Gruppe von gespeicherten CODEs zum Betrachten.',

   'CODEs with [_1] matching letters:'
=> 'CODEs mit [_1] übereinstimmenden Zeichen:',

   'Check the checkboxes for any you wish to remove.'
=> 'Markieren Sie die zu löschenden Einträge.',

# The way how the helper deals with formats needs to be overhauled before the following phrases should be added:
#   'Specify CODEd Assignments'
#=> 'Optionen zu mit CODE versehenen Übungen',

#   'Generate new CODEd Assignments'
#=> 'Neue, mit CODE-versehene Übungen erstellen',

#   'Number of CODEd assignments to print:'
#=> 'Anzahl an mit CODE versehener Übungen, die gedruckt werden sollen:',

#   'Names to save the CODEs under for later:'
#=> 'Bezeichnung, unter der die CODEs für die spätere Verwendung gespeichert werden sollen:',

#   'Bubblesheet type:'
#=> 'Bubblesheet-Typ:',

#   'Print a Specific CODE'
#=> 'Für einen bestimmten CODE drucken',

#   'Enter a CODE to print:'
#=> 'CODE, der gedruckt werden soll:',

#   'Reprint a Set of Saved CODEs'
#=> 'Eine Gruppe von gespeicherten CODEs erneut drucken',

#   'Select saved CODEs:'
#=> 'Auswahl aus gespeicherten CODEs:',

   'No answers defined for response [_1] in part [_2] to make bubbles for.'
=> 'Für die Antwort [_1] in Aufgabenteil [_2] sind keine Antworten hinterlegt, für die Ankreuzfelder erstellt werden könnten.',

   'Display Summary'
=> 'Zusammenfassung anzeigen',

   'Manage course requests'
=> 'Kursanträge verwalten',

   'Outcome'
=> 'Ergebnis',

   'Request Details'
=> 'Antragsdetails',

   'Request a course'
=> 'Einen Kurs beantragen',

   'Request course'
=> 'Einen Kurs beantragen',

   'Request a community'
=> 'Eine Community beantragen',

   'Request author role'
=> 'Einen Autorenrolle beantragen',

   'Request Authoring Space'
=> 'Autorenbereich beantragen',

   'User Authentication'
=> 'Benutzer-Authentifizierung',

   'Course/Community creation requests in the following domain: [_1] have been reviewed.'
=> 'Für die Domäne [_1] wurden Kurs-/Community-Anträge überprüft.',

   'Course/Community requests reviewed'
=> 'Kurs-/Community-Anträge wurden überprüft',

   'Community request'
=> 'Community-Antrag',

   'Your request for creation of the following community: [_1]requested on [_2]has been reviewed by a Domain Coordinator.'
=> 'Ihr Antrag vom [_2] auf Erstellung der Community [_1] wurde durch einen Domänen-Koordinator überprüft.',

   'Course request'
=> 'Kursantrag',

   'Your request for creation of the following course: [_1]requested on [_2]has been reviewed by a Domain Coordinator.'
=> 'Ihr Antrag vom [_2] auf Erstellung des Kurses [_1] wurde durch einen Domänen-Koordinator überprüft.',

   'Community request to review'
=> 'Community-Antrag zur Überprüfung',

   'Creation of the following community: [_1]was requested by [_2] on [_3].'
=> 'Die Erstellung der Community [_1] wurde am [_3] durch [_2] beantragt.',

   'Course request to review'
=> 'Kursantrag zur Überprüfung',

   'Creation of the following course: [_1]was requested by [_2] on [_3].'
=> 'Die Erstellung des Kurses [_1] wurde am [_3] durch [_2] beantragt.',

   '[_1]As Domain Coordinator, use: [_2]Main Menu -> Course and community creation -> Approve or reject requests[_3]to display a list of pending requests, which you can either approve or reject.'
=> '[_1]Um eine Liste aller noch offenen Anträge anzuzeigen, wählen Sie als Domänen-Koordinator: [_2]Hauptmenü -> Kurs- und Community-Erstellung -> Anträge bestätigen oder ablehnen.[_1]Diese können dort bestätigt bzw. abgelehnt werden.',

   'Enrollment in the following community: [_1] was requested by [_2] on [_3].'
=> 'Belegung der Community [_1] wurde am [_3] von [_2] beantragt.',

   'Enrollment in the following course: [_1] was requested by [_2] on [_3].'
=> 'Belegung des Kurses [_1] wurde am [_3] von [_2] beantragt.',

   '# of students/max'
=> 'Anz. Stud./max.',

   '&nbsp;&nbsp;&nbsp;End:'
=> '&nbsp;&nbsp;&nbsp;Ende:',

   'Any time'
=> 'Jederzeit',

   'Anytime'
=> 'Jederzeit',

   'Changing the Name will create a new slot with the new name, and not rename the existing slot.'
=> 'Das Ändern des Namens wird einen neuen Slot mit dem neuen Namen erstellen, nicht jedoch den bestehenden Slot umbenennen.',

   'Created Slot'
=> 'Slot wurde erstellt',

   'Creating/Modifying Slot'
=> 'Slot wird erstellt/geändert',

   'DISCUSSIONS'
=> 'DISKUSSIONEN',

   'Description:&nbsp;&nbsp;&nbsp;'
=> 'Beschreibung:&nbsp;&nbsp;&nbsp;',

   'Drop Reservation'
=> 'Reservierung verwerfen',

   "Editing requires switching to the resource's home server."
=> 'Ein Ändern erfordert den Wechsel zum Heimatserver der Ressource.',

   'Start time:&nbsp;&nbsp;&nbsp;'
=> 'Startzeit:&nbsp;&nbsp;&nbsp;',

   'End time:&nbsp;&nbsp;&nbsp;'
=> 'Endezeit:&nbsp;&nbsp;&nbsp;',

   'Full name'
=> 'Vollständiger Name',

   'IP or DNS restrictions'
=> 'IP- oder DNS-Beschränkungen',

   'IP restrictions:&nbsp;&nbsp;&nbsp;'
=> 'IP-Beschränkungen:&nbsp;&nbsp;&nbsp;',

   'Student selectable.'
=> 'durch Studierende wählbar',

   'Instructor assignable.'
=> 'durch Dozenten festlegbar',

   'List of proctors'
=> 'Liste des Aufsichtspersonals',

   'Managing Slots'
=> 'Slots verwalten',

   'Maximum number of students allowed in this slot:&nbsp;&nbsp;&nbsp;'
=> 'Maximale Anzahl erlaubter Studierender in diesem Slot:&nbsp;&nbsp;&nbsp;',

   'Name: &nbsp;&nbsp;&nbsp;'
=> 'Name: &nbsp;&nbsp;&nbsp;',

   'No proctor checkin required for access.'
=> 'Aufnahme durch Aufsichtspersonal ist nicht erforderlich, um Zugriff zu erhalten.',

   'Require proctored checkin for access.'
=> 'Aufnahme durch Aufsichtspersonal ist erforderlich, um Zugriff zu erhalten.',

   'Open now'
=> 'Jetzt verfügbar',

   'Open within the next week'
=> 'Innerhalb der nächsten Woche verfügbar',

   'Period of time slot is unique'
=> 'Zeitraum, in dem der Slot eindeutig ist',

   'Period of time when this slot can only be uniquely chosen:&nbsp;&nbsp;&nbsp;Start:'
=> 'Zeitraum, in dem allein dieser Slot gewählt werden kann:&nbsp;&nbsp;&nbsp;Start:',

   'Proctored access:'
=> 'Zugriff durch Aufsichtspersonal:',

   'Released Reservation: [_1]'
=> 'Freigegebene Reservierung: [_1]',

   'Released reservation: [_1]'
=> 'Freigegebene Reservierung: [_1]',

   'Released Reservation for user: [_1]'
=> 'Freigegebene Reservierung für Benutzer [_1]',

   'Releasing reservations'
=> 'Reservierungen werden freigegeben',

   'Not allowed to release Reservation: [_1], as it has already ended.'
=> 'Die Reservierung [_1] kann nicht freigegeben werden, da sie bereits beendet ist.',

   'Remove All'
=> 'Alle entfernen',

   'Resource slot is restricted to.'
=> 'Ressource, auf die der Slot beschränkt ist.',

   'Sections slot is restricted to.'
=> 'Sektionen, auf die der Slot beschränkt ist.',

   'Users slot is restricted to.'
=> 'Benutzer, auf die der Slot beschränkt ist.',

   'Restrict slot availability'
=> 'Slot-Verfügbarkeit beschränken',

   'Return to slot list'
=> 'Zur Slot-Liste zurückkehren',

   'Scheduled Students'
=> 'Vorgemerkte Studierende', # ???

   'Secret Word'
=> 'Geheimes Wort',

   'Secret word proctors use to checkin users:&nbsp;&nbsp;&nbsp;'
=> 'Geheimes Wort, das das Aufsichtspersonal verwendet, um Benutzer aufzunehmen:&nbsp;&nbsp;&nbsp;',

   'Select sections to limit slot availability to: &nbsp;&nbsp;&nbsp;'
=> 'Auswahl der Sektionen, auf die die Slot-Verfügbarkeit beschränkt sein soll: &nbsp;&nbsp;&nbsp;',

   'Select users to limit slot availability to: &nbsp;&nbsp;&nbsp;'
=> 'Auswahl der Benutzer, auf die die Slot-Verfügbarkeit beschränkt sein soll: &nbsp;&nbsp;&nbsp;',

   'Slot Creation'
=> 'Slot-Erstellung',

   'Slot Deletion'
=> 'Slot-Löschung',

   'Slot Name'
=> 'Slot-Name',

   'Slot Name Filter'
=> 'Slot-Namens-Filter',

   'Slot [_1] marked as deleted.'
=> 'Slot [_1] als gelöscht markiert.',

   'Slot is:'
=> 'Slot ist:',

   'Slots are by default available to all users in a course, if you would like this slot to be restricted to a subset of users you can specify restrictions.'
=> 'Slots sind voreingestellt für alle Benutzer im Kurs verfügbar. Falls Sie diesen Slot auf eine Untermenge von Benutzern beschränken möchten, können Sie Beschränkungen festlegen.',

   'Specify Optional Attributes'
=> 'Festlegung optionaler Attribute',

   'Specify Required Attributes'
=> 'Festlegung notwendiger Attribute',

   'Student Display'
=> 'Studierenden-Anzeige',

   'Exact'
=> 'Exakt',

   'Substring'
=> 'Teilstring',

   'Success: [_1]'
=> 'Erfolgreich: [_1]',

   'This discussion is closed.'
=> 'Diese Diskussion ist geschlossen.',

   'Time students can start reserving'
=> 'Zeitpunkt, ab dem Studierende anfangen können zu reservieren',

   'Time students can start reserving:&nbsp;&nbsp;&nbsp;'
=> 'Zeitpunkt, ab dem Studierende anfangen können zu reservieren:&nbsp;&nbsp;&nbsp;',

   'Were open'
=> 'Waren verfügbar',

   'Were open last week'
=> 'Waren letzte Woche verfügbar',

   'Will be next available:'
=> 'Nächste Verfügbarkeit:',

   'Will open later'
=> 'Wird später verfügbar sein',

   '[_1] From [_2] to [_3]'
=> '[_1] Von [_2] an [_3]', # ???

   'restricted to a specific resource.'
=> 'auf bestimmte Ressource beschränkt.',

   'usable for any resource.'
=> 'für jede Ressource verwendbar.',

   'A new variation will be generated after every [quant,_1,try,tries], until correct or tries limit is reached.'
=> 'Alle [quant,_1,Versuche,Versuche] wird eine neue Variation erzeugt, bis die Aufgabe korrekt gelöst wurde oder die maximale Anzahl an Versuchen erreicht ist.',

   'A new variation will be generated after every [quant,_1,try,tries], until the tries limit is reached.'
=> 'Alle [quant,_1,Versuche,Versuche] wird eine neue Variation erzeugt, bis die maximale Anzahl an Versuchen erreicht ist.',

   'A new variation will be generated after each try until correct or tries limit is reached.'
=> 'Nach jedem Versuch wird eine neue Variation erzeugt, bis die Aufgabe korrekt gelöst wurde oder die maximale Anzahl an Versuchen erreicht ist.',

   'A new variation will be generated after each try until the tries limit is reached.'
=> 'Nach jedem Versuch wird eine neue Variation erzeugt, bis die maximale Anzahl an Versuchen erreicht ist.',

   'New Problem Variation After Every [quant,_1,Try,Tries]'
=> 'Neue Aufgabenvariation alle [quant,_1,Versuch,Versuche]',

   'New Randomization Each Try'
=> 'Bei jedem Versuch neue Randomisierung',

   'New problem variation this try.'
=> 'Bei diesem Versuch neue Variation',

   'For this question there will no new variation after a try.'
=> 'Für diese Aufgabe wird es keine neue Variation nach einem Versuch geben.',

   'Tries before new Variation (if Qn. Type=randomizetry)'
=> 'Anz. Versuche vor neuer Variation (falls Aufg.-Typ = randomizetry)',

   'For this question a new variation will be generated after every [quant,_1,try,tries], until the tries limit is reached.'
=> 'Alle [quant,_1,Versuche,Versuche] wird für diese Aufgabe eine neue Variation erzeugt, bis die maximale Anzahl an Versuchen erreicht ist.',

   'For this question a new variation will be generated after every [quant,_1,try,tries], until correct or tries limit is reached.'
=> 'Alle [quant,_1,Versuche,Versuche] wird für diese Aufgabe eine neue Variation erzeugt, bis die Aufgabe korrekt gelöst wurde oder die maximale Anzahl an Versuchen erreicht ist.',

   'For this question a new variation will be generated after each try until the tries limit is reached.'
=> 'Nach jedem Versuch wird für diese Aufgabe eine neue Variation erzeugt, bis die maximale Anzahl an Versuchen erreicht ist.',

   'For this question a new variation will be generated after each try until correct or tries limit is reached.'
=> 'Nach jedem Versuch wird für diese Aufgabe eine neue Variation erzeugt, bis die Aufgabe korrekt gelöst wurde oder die maximale Anzahl an Versuchen erreicht ist.',

   'No Question Variation'
=> 'Keine Aufgabenvariation',

   'Submitted Files'
=> 'Eingereichte Dateien',

   'Submitted Files:'
=> 'Eingereichte Dateien:',

   'Currently submitted files'
=> 'Derzeit eingereichte Dateien',

   'Submit other file(s)'
=> 'Weitere Datei(en) einreichen',

   'Exclude existing file(s) from grading by checking the "Delete?" checkbox(es) and clicking "Submit Answer"'
=> 'Existierende Datei(en) von der Bewertung ausschließen: "Löschen?" auswählen und "Antwort einreichen" klicken.',

   'You have already uploaded a file with that filename.'
=> 'Sie hatten bereits eine Datei mit diesem Dateinamen hochgeladen.',

   'Please use a different filename.'
=> 'Bitte verwenden Sie einen anderen Dateinamen.',

   'Size (KB)'
=> 'Größe (KB)',

   'Size (MB)'
=> 'Größe (MB)',

   'An error occurred during the conversion of [_1].'
=> 'Es ist ein Fehler bei der Konvertierung von [_1] aufgetreten.',

   'If possible try to save this image using different settings and republish it.'
=> 'Falls möglich, versuchen Sie bitte das Bild mit anderen Einstellungen zu speichern und veröffentlichen Sie es erneut.',

   'Survey (credit for submission)'
=> 'Umfrage (Punktevergabe für die Einreichung)',

   'Anonymous Survey (credit for submission)'
=> 'Anonyme Umfrage (Punktevergabe für die Einreichung)',

   'Credit for survey submission'
=> 'Punktevergabe für Umfrage-Einreichung',

   'New Randomization Each N Tries (default N=1)'
=> 'Neue Variation alle N Versuche (voreingestellt: N=1)',

   'Changed [_1]'
=> 'Geändert wurde: [_1]',

   'Changed [_1] for [_2] to [_3]'
=> 'Geändert wurde [_1] für [_2] in [_3]',

   'Could not be determined.'
=> 'Konnte nicht ermittelt werden',

   'Could not be determined'
=> 'Konnte nicht ermittelt werden',

   'Custom Text'
=> 'Eigener Text',

   '(Custom text)'
=> '(eigener Text)',

   'New filter setting: [_1].'
=> 'Neue Filtereinstellung: [_1].',

   'Required LON-CAPA version'
=> 'Erforderliche LON-CAPA-Version',

   '[_1] or newer'
=> '[_1] oder eine neuere',

   'Course type: [_1] requires [_2] or newer'
=> 'Kurstyp [_1] erfordert [_2] oder eine neuere',

   'No specific version required'
=> 'Keine bestimmte Version erforderlich',

   'LON-CAPA version ([_1]) installed on home server ([_2]) does not meet version requirements ([_3] or newer).'
=> 'Die auf Ihrem Heimatserver ([_2]) installierte LON-CAPA-Version ([_1]) erfüllt nicht die notwendigen Versionsvoraussetzungen ([_3] oder eine neuere).',

   'Requirements from general settings'
=> 'Anforderungen aus allgemeinen Einstellungen',

   'Release'
=> 'Release',

   'Scope'
=> 'Bereich',

   'Requirements for specific folders or resources'
=> 'Anforderungen an bestimmte Verzeichnisse oder Ressourcen',

   'LON-CAPA version dependencies'
=> 'LON-CAPA-Versionsabhängigkeiten',

   'No version requirements from resource content or settings.'
=> 'Keine Versionsanforderungen aus Ressourceninhalt oder Einstellungen',

   'Attribute/Setting'
=> 'Attribut/Einstellung',

   'Setting - scope: [_1]'
=> 'Einstellung - Bereich: [_1]',

   'Submissions to: '
=> 'Einreichungen für: ',

   'Response Type(s): '
=> 'Antworttyp(en): ',

   'Anonymous survey submissions displayed when responders exceeds'
=> 'Anzeige der anonymen Umfrage-Einreichungen, sobald Anzahl der Antworten größer wird als',

   'Threshold for anonymous submissions display'
=> 'Anzeige-Schwellenwert für anonyme Einreichungen',

   'Responder threshold for anonymous survey submissions display:'
=> 'Anzeige-Schwellenwert für Anzahl der Antworten für anonyme Umfrage-Einreichungen:',

   'Responder threshold required to display anonymous survey submissions'
=> 'erforderlicher Anzeige-Schwellenwert für Anzeige anonymer Umfrage-Einreichungen',

   'The responder threshold you entered is invalid.'
=> 'Der von Ihnen eingegebene Anzahl-Antworter-Schwellenwert ist ungültig.',

   'View/Modify responders threshold for anonymous survey submissions display'
=> 'Anzeige/Ändern des Anzeige-Schwellenwerts für Anzahl der Antworten für anonyme Umfrage-Einreichungen',

   'Responder count needed before showing submissions for anonymous surveys'
=> 'Erforderliche Anzahl an Antworten, bevor diese für anonyme Umfragen angezeigt werden',

   'Responder count required for display of anonymous survey submissions set to [_1].'
=> 'Erforderliche Anzahl an Antworten, bevor diese für anonyme Umfragen angezeigt werden, gesetzt auf [_1]',

   'You must enter a number'
=> 'Sie müssen eine Zahl eingeben',

   'You must enter a positive integer.'
=> 'Sie müssen eine positive Zahl eingeben.',

   'General Help'
=> 'Allgemeine Hilfe',

   'General help'
=> 'Allgemeine Hilfe',

   '[_1] was [_2]not[_3] set to [_4].'
=> '[_1] wurde [_2]nicht[_3] in [_4] geändert.',

   '[quant,_1,pt,pt]'
=> '[quant,_1,Pkt.,Pkt.]',

   '(for example: [_1])'
=> '(zum Beispiel: [_1])',

   'Rules'
=> 'Regeln',

   'Unavailable'
=> 'unerreichbar',

   'User session hosting'
=> 'Hosting von Benutzersitzungen',

   'User session hosting/offloading'
=> 'Hosting von Benutzersitzungen / Offloading',

   "Hosting domain's own users elsewhere"
=> 'Benutzer der eigenen Domäne woanders hosten',

   'Hosting of sessions for users from other domains on servers in this domain'
=> 'Hosting von Sitzungen für Benutzern anderer Domänen auf Servern dieser Domäne',

   'Hosting of sessions for users in this domain on servers in other domains'
=> 'Hosting von Sitzungen für Benutzern in dieser Domäne auf Servern anderer Domänen',

   'Hosting of users from other domains'
=> 'Hosting von Benutzern anderer Domänen',

   'Allow all, but exclude specific domains'
=> 'Alle zulassen, jedoch bestimmte Domänen ausschließen',

   'Deny all, but include specific domains'
=> 'Alle verweigern, jedoch bestimmte Domänen zulassen',

   'Default authentication/language/timezone/portal'
=> 'Voreingestellte Authentifizierungsmethode/Sprache/Zeitzone/Portal',

   'Default authentication/language/timezone/portal/types'
=> 'Voreingestellte Authentifizierungsmethode/Sprache/Zeitzone/Portal/Typen',

   'Defaults which can be overridden for each course by a DC'
=> 'Voreinstellungen, die für jeden Kurs durch einen Dom.-Koord. überschrieben werden können',

   'Defaults which can be overridden for each course by a CC'
=> 'Voreinstellungen, die für jeden Kurs durch einen Kurs-Koord. überschrieben werden können',

   'In use'
=> 'in Verwendung',

   'Not in use'
=> 'nicht in Verwendung',

   'LON-CAPA version requirement'
=> 'Vorausgesetzte LON-CAPA-Version',

   'remote server must be version: [_1] or later'
=> 'Entfernter Server muss Version [_1] oder eine neuere verwenden',

   'Nothing to set here, as the cluster to which this domain belongs only contains this institution.'
=> 'Nichts einzustellen, da der Cluster, zu dem diese Domäne gehört, nur diese Institution enthält.',

   'Portal/Default URL'
=> 'Portal/voreingestellte URL',

   ' Initial password - sent to '
=> ' Initiales Passwort - wurde gesendet an ',

   ' username: [_1], password: [_2]'
=> ' Benutzerkennung: [_1], Passwort: [_2]',

   "Existing user [_1] detected in institutional classlist - switched from 'manual' to 'auto' enrollment in section [_2]."
=> "In der institutionellen Kursteilnehmerliste wurde der bestehende Benutzer [_1] erkannt. In Sektion [_2] erfolgte eine Umschaltung von 'manueller' auf 'automatische' Kursbelegung.",

   '(Currently -- draft)'
=> '(Derzeit -- Entwurf)',

   'Collaborators'
=> 'Mitarbeiter',

   'Please remove [quant,_1,collaborator].'
=> 'Bitte [quant,_1,Mitarbeiter,Mitarbeiter] entfernen.',

   'You have too many collaborators.'
=> 'Sie haben zu viele Mitarbeiter.',

   '(only shown to submitter)'
=> '(wird nur dem Einreicher angezeigt)',

   'A possible change in username has been detected for a student enrolled in this course.'
=> 'Eine mögliche Änderung der Benutzerkennung wurde für eine/n Studenten/in, dieses Kurses festgestellt.',

   'A user account has been created for you while creating your new course in the LON-CAPA course management and online homework system.'
=> 'Für Sie wurde im Zuge der Erstellung eines neuen LON-CAPA-Kurses ein Benutzeraccount erstellt.',

   'Access starts: [_1], ends: [_2].'
=> 'Zugriff beginnt: [_1], endet: [_2].',

   'All answers must have the same number of components. Varying numbers of answers were seen. '
=> 'Alle Antworten müssen die gleiche Anzahl an Komponenten haben. Es wurde eine unterschiedliche Anzahl an Antworten festgestellt. ',

   'An error occurred during the attempt to convert [_1] from a manual type to an auto type student - [_2].'
=> 'Beim Versuch der Umwandlung von [_1] von einem manuellen in einen automatischen Typ von Student/in ist ein Fehler aufgetreten: [_2]',

   'An error occurred during the attempt to expire the [_1] from the old section [_2] - [_3].'
=> 'Beim Versuch, die alte Sektion [_2] bei dem/der Studenten/in [_1] ablaufen zu lassen, ist ein Fehler aufgetreten: [_3]',

   'An error occurred adding new user [_1] - [_2].'
=> 'Beim Hinzufügen des neuen Benutzers [_1] ist ein Fehler aufgetreten: [_2]',

   'An error occurred adding the new user [_1] because the authcheck failed for authtype [_2] and parameter [_3].'
=> 'Beim Hinzufügen des neuen Benutzers [_1] ist ein Fehler aufgetreten, da die Authentifizierungsüberprüfung für den Authentifizierungstyp [_2] und Parameter [_3] fehlgeschlagen ist.',

   'An invalid authentication type was provided for the new user - [_1], so the user was not enrolled in the course.'
=> 'Für den neuen Benutzer [_1] wurde ein ungültiger Authentifizierungstyp angegeben, so dass der Benutzer nicht in den Kurs aufgenommen wurde.',

   'Answer display:'
=> 'Anzeige der Antwort:',

   'Answers [_1] had [_2] components.'
=> 'Antwort [_1] hatte [_2] Komponenten.',

   'Collection Of Foils'
=> 'Sammlung von Auswahlmöglichkeiten',

   'Continue submission with these files removed?'
=> 'Einreichung fortsetzen mit Entfernung dieser Dateien?',

   'Your answer:'
=> 'Ihre Antwort:',

   '[_1] appears in classlists for more than one section of this course, i.e. in sections: '
=> '[_1] taucht in Kursteilnehmerlisten in mehr als einer Sektion dieses Kurses auf, z.B. in den Sektionen: ',

   'not in portfolio'
=> 'nicht im Portfolio',

   'Autoupdate messages start for domain: [_1]'
=> 'Autoupdate - Beginn der Mitteilungen für die Domäne [_1]',

   'Autoupdate messages end'
=> 'Autoupdate - Ende der Mitteilungen',

   'Enrollment messages start'
=> 'Kursbelegungsnachrichten - Start',

   'Enrollment messages end'
=> 'Kursbelegungsnachrichten - Ende',

   'BEGIN [_1]'
=> 'BEGINN [_1]',

   'END [_1]'
=> 'ENDE [_1]',

   'Currently a LON-CAPA server is not available within the [_1] domain for you to log-in to, to create an account.'
=> 'Derzeit ist für Sie kein LON-CAPA-Server innerhalb der Domäne [_1] zum Login verfügbar, um einen Account zu erstellen.',

   'Display roles'
=> 'Rollen anzeigen',

   'Draw Molecule'
=> 'Molekül zeichnen',

   'Include Language:'
=> 'Sprache einbeziehen:',

   'Exclude Language:'
=> 'Sprache ausschließen:',

   'Expected [_1] input fields, but there were only [_2] seen.'
=> 'Es wurden [_1] Eingabefelder erwartet, aber nur [_2] gefunden.',

   'Form:'
=> 'Formular:',

   'Marker for the start of a part. Place end marker below to wrap in-between tags into a new part.'
=> 'Markierung für den Beginn eines Aufgabenteils. Fügen Sie die Ende-Markierung weiter unten ein, um die Bereiche zwischen den Markierungen in einen neuen Aufgabenteil zu bringen.',

   'Marker for the end of a part. Place start marker above to wrap in-between tags into a new part.'
=> 'Markierung für das Ende eines Aufgabenteils. Fügen Sie die Beginn-Markierung weiter oben ein, um die Bereiche zwischen den Markierungen in einen neuen Aufgabenteil zu bringen.',

   'Messages end for [_1]'
=> 'Start der Nachrichten für [_1]',

   'Messages start for [_1]'
=> 'Ende der Nachrichten für [_1]',

   "No suitable server could be found amongst servers in either your own domain or in the course's domain."
=> 'Weder in Ihrer eigenen Domäne noch in der Domäne des Kurses konnte ein passender Server gefunden.',

   "No suitable server could be found amongst servers in your own domain (which is also the course's domain)."
=> 'In Ihrer eigenen Domäne, die zudem die gleiche Domäne wie die des Kurses ist, konnte kein passender Server gefunden werden.',

   'Not a function'
=> 'Keine Funktion',

   'One moment please...'
=> 'Einen Moment bitte...',

   'Please correct.'
=> 'Bitte korrigieren.',

   'Username change to [_1] detected for [_2] in domain [_3].'
=> 'Für den Benutzer [_2] in der Domäne [_3] wurde eine Änderung der Benutzerkennung in [_1] festgestellt.',

   'Possible username change to [_1] detected for [_2] in domain [_3].'
=> 'Für den Benutzer [_2] in der Domäne [_3] wurde eine mögliche Änderung der Benutzerkennung in [_1] festgestellt.',

   'Requires LON-CAPA version [_1].'
=> 'Erfordert LON-CAPA-Version [_1].',

   'This course requires a newer version of LON-CAPA than is installed on this server.'
=> 'Dieser Kurs benötigt eine neuere Version von LON-CAPA als auf Ihrem Server installiert ist.',

   'Response from [_1] was [_2]'
=> 'Antwort von [_1] war [_2]',

   'Smile representation: [_1]'
=> 'Smile-Repräsentation: [_1]',

   'Submitted files:'
=> 'Eingereichte Dateien:',

   'Submitted text'
=> 'Eingereichter Text',

   'Test Condition:'
=> 'Test-Bedingung:',

   'The following [_1] users are invalid:'
=> 'Die folgenden [_1] Benutzer sind ungültig:',

   'The following user is invalid:'
=> 'Der folgende Benutzer ist ungültig:',

   'The start date for automated enrollment has yet to be reached.'
=> 'Das Anfangsdatum für die automatische Kursbelegung wurde noch nicht erreicht.',

   'There are no true statements available.'
=> 'Es sind keine wahren Aussagen verfügbar.',

   'This resource can not be accessed from your location.'
=> 'Auf diese Ressource kann von Ihrem Ort aus nicht zugegriffen werden.',

   "This resource currently isn't open. "
=> 'Diese Ressource ist momentan nicht verfügbar. ',

   'This resource is no longer available to be viewed.'
=> 'Diese Ressource darf nun nicht mehr betrachtet werden.',

   'Transferring to login page.'
=> 'Leite auf Login-Seite um',

   'Wrong format'
=> 'Falsches Format',

   'You do not currently have a LON-CAPA account at this institution.'
=> 'Sie haben derzeit keinen LON-CAPA-Account an dieser Institution.',

   'You have indicated you wish to remove some files previously included in your submission.'
=> 'Sie haben angegeben, dass Sie einige Dateien entfernen möchten, die Bestandteil einer früheren Einreichung von Ihnen waren.',

   'You will be able to create one by logging into a LON-CAPA server within the [_1] domain.'
=> 'Sie können einen erstellen, indem Sie sich bei einem LON-CAPA-Server innerhalb der Domäne [_1] einloggen.',

   'Account creation status'
=> 'Status der Account-Erstellung',

   'Confirm password'
=> 'Passwort bestätigen',

   'You must enter a password.'
=> 'Sie müssen ein Passwort eingeben.',

   'Bookmarks saved. ([_1]Continue[_2])'
=> 'Lesezeichen wurden gespeichert. ([_1]Weiter[_2])',

   'Choose course:'
=> 'Auswahl des Kurses:',

   'Choose the CMS used to create your IMS content package.'
=> 'Auswahl des LMS, in dem Ihr IMS-Inhaltspaket erstellt wurde.',

   'Connection broken with home server. Please contact your system administrator.'
=> 'Die Verbindung zum Heimatserver ist abgebrochen. Bitte kontaktieren Sie Ihren System-Administrator.',

   'Create a destination LON-CAPA directory in which to store the contents of the IMS package file.'
=> 'Erstellung des LON-CAPA-Zielverzeichnisses, in dem die Inhalte der IMS-Paket-Datei gespeichert werden.',

   'Create a directory where you will unpack your IMS package'
=> 'Erstellung eines Verzeichnisses, in dem Sie Ihr IMS-Paket entpacken können',

   'Display new directory'
=> 'Das neue Verzeichnis anzeigen',

   'Enter the name of the new directory where you will store the contents of your IMS package.'
=> 'Geben Sie den Namen des neuen Verzeichnisses ein, in dem die Inhalte Ihres IMS-Pakets gespeichert werden sollen.',

   'Exit now'
=> 'Jetzt verlassen',

   'Import package'
=> 'Paket importieren',

   'Not required'
=> 'nicht erforderlich',

   'Once your files are published, subsequent re-publication will result in the storage of information about changes between the different versions.'
=> 'Sobald Ihre Dateien veröffentlicht sind, werden nachfolgende Neuveröffentlichungen dazu führen, dass Informationen über Änderungen der verschiedenen Versionen gespeichert werden.',

   'The final step in the IMS import process is to publish the materials you have imported into your Authoring Space so that you can use them in a course. Once your files are published, subsequent re-publication will result in the storage of information about changes between the different versions.'
=> 'Der letzte Schritt im IMS-Import-Vorgang ist das Veröffentlichen des Materials, das Sie in Ihren Autorenbereich importiert haben, so dass Sie dieses in Ihrem Kurs verwenden können. Sobald Ihre Dateien veröffentlicht sind, werden nachfolgende Neuveröffentlichungen dazu führen, dass Informationen über Änderungen der verschiedenen Versionen gespeichert werden.',

   'Please [_1]start again[_2].'
=> 'Bitte [_1]erneut starten[_2].',

   'Please view the imported items and use the LON-CAPA editing tools to make changes.'
=> 'Bitte schauen Sie sich die importierten Elemente an und verwenden Sie die in LON-CAPA integrierten Bearbeitungswerkzeuge, um ggf. Änderungen vorzunehmen.',

   'Sorry, your authentication has expired.'
=> 'Ihre Authentifizierung ist abgelaufen.',

   'The credentials you provided could not be verified.'
=> 'Die von Ihnen angegebenen Anmeldedaten konnten nicht überprüft werden.',

   'The e-mail address you provided is already in use as a username in LON-CAPA at this institution.'
=> 'Die von Ihnen angegebene E-Mail-Adresse wird bereits von einem anderen LON-CAPA-Benutzer in dieser Institution verwendet.',

   'The final step in the IMS import process is to publish the materials you have imported into your Authoring Space so that you can use them in a course.'
=> 'Der abschließende Schritt des IMS-Import-Vorgangs besteht aus dem Veröffentlichen des Materials, das Sie in Ihren Autorenbereich importiert haben, so dass Sie es in Kursen verwenden können.',

   "The sequences directory contains a file named 'Top.sequence' which includes links to the items found at the top level of your IMS package. From there you can follow links to display all the imported items. Alternatively, you can browse the pages, sequences, problems and resfiles directories directly. Note if you rename a file, you will need to modify any .sequence files or .page files which include a reference to the renamed file."
=> "Das Sequenzen-Verzeichnis enthält eine Datei mit dem Namen 'Top.sequence'. Diese enthält Links auf die Elemente, die auf der obersten Ebene ('top') Ihres IMS-Pakets gefunden wurden. Von dort aus können Sie den Links folgen, um alle importierten Elemente anzuzeigen. Alternativ können Sie die Seiten, Sequenzen, Aufgaben und Ressourcen-Verzeichnisse auch direkt durchsuchen. Beachten Sie, dass Sie nach dem Umbenennen einer Datei auch alle .sequence- und .page-Dateien anpassen müssen, die einen Verweis auf die umbenannte Datei enthalten.",

   'You must choose a destination directory for the import'
=> 'Sie müssen für den Import ein Zielverzeichnis auswählen',

   'You must choose the Course Management System from which the IMS package was exported'
=> 'Sie müssen das Lernmanagement-System auswählen, aus dem das IMS-Paket exportiert werden soll',

   'Your IMS package has been processed successfully.'
=> 'Ihr IMS-Paket wurde erfolgreich verarbeitet.',

   'Your current role does not grant you the right to modify course content in this course.'
=> 'Ihre derzeitige Rolle gestattet es Ihnen nicht, Kursinhalte in diesem Kurs zu ändern.',

   'included by default if assigned institutional code, or categorized'
=> 'wird voreingestellt eingebunden, falls institutioneller Code zugewiesen ist oder kategorisiert ist',

   ' A file by that name: [_1] was found in [_2].'
=> ' Eine Datei mit dem Namen [_1] wurde in [_2] gefunden.',

   '(only files for which a location has been provided will be uploaded)'
=> '(nur Dateien, für die ein Ort angegeben wurde, werden hochgeladen)',

   'Addition of user [_1] from domain [_2] to course [_3], section [_4] not completed.'
=> 'Das Hinzufügen des Benutzers [_1] aus der Domäne [_2] zu dem Kurs [_3] in Sektion [_4] wurde nicht abgeschlossen.',

   'Already exists'
=> 'existiert bereits',

   'Although your current role has privileges to add students to section "[_1]", you do not have privileges to modify existing enrollments unaffiliated with any section.'
=> 'Die derzeit ausgewählte Rolle erlaubt zwar das Hinzufügen von Studierenden zu der Sektion "[_1]", nicht aber das Ändern bestehender Kursbelegungen, die sich nicht auf eine Sektion beziehen.',

   'An error occurred while trying to upload [_1] for embedded element [_2].'
=> 'Beim Versuch des Hochladens von [_1] für das eingebettete Element [_2] ist ein Fehler aufgetreten.',

   'An error occurred while writing the file [_1] for embedded element [_2].'
=> 'Beim Schreiben der Datei [_1] für das eingebettete Element [_2] ist ein Fehler aufgetreten.',

   'As you did not include the default Kerberos domain to be used for authentication in this class, the institutional data used by the automated enrollment process must include the Kerberos domain for each new student'
=> 'Sie haben nicht die voreingestellte Kerberos-Domäne eingebunden, um sie zur Authentifizierung in diesem Kurs zu verwenden. Daher müssen die institutionellen Daten, die von der automatischen Kursbelegung verwendet werden, für jede/n neue/n Studenten/in die Kerberos-Domäne enthalten.',

   'As you did not include the default Kerberos domain to be used for authentication in this class, the institutional data used by the automated enrollment process must include the Kerberos domain for each new student.'
=> 'Sie haben nicht die voreingestellte Kerberos-Domäne eingebunden, um sie zur Authentifizierung in diesem Kurs zu verwenden. Daher müssen die institutionellen Daten, die von der automatischen Kursbelegung verwendet werden, für jede/n neue/n Studenten/in die Kerberos-Domäne enthalten.',

   'Assigning custom role'
=> 'Benutzerdefinierte Rolle wird zugewiesen',

   'Block for [_1] starts: [_2], ends [_3], set by: [_4]'
=> 'Sperre für [_1] startet am [_2], endet am [_3], gesetzt von [_4]',

   'Cloning [_1] from [_2]'
=> 'Klone [_1] von [_2]',

   'Current reference'
=> 'Derzeitiger Verweis',

   'Changes in content of HTML file required'
=> 'Änderungen am Inhalt der HTML-Datei erforderlich',

   'Changes need to be made to the reference(s) used for one or more of the dependencies, if your HTML file is to work correctly:'
=> 'Damit Ihre HTML-Datei korrekt funktioniert, sind Änderungen der Verweise erforderlich, die auf eine bzw. mehrere abhängige Elemente zeigen:',

   'For consistency between the reference(s) and the location of the corresponding stored file within LON-CAPA.'
=> 'aufgrund von Konsistenz zwischen den Verweisen und des Ortes der zugehörigen Dateien, die in LON-CAPA gespeichert werden',

   'To change absolute paths to relative paths, or replace directory traversal via "../" within the original reference.'
=> 'um absolute Pfade in relative Pfade zu ändern oder Verzeichniswechsel mit "../" im Originalverweis zu ersetzen',

   'No files need to be uploaded, as one of the following applies to each reference:'
=> 'Keine Dateien hochzuladen, da einer der folgenden Punkte auf jeden Verweis zutrifft:',

   'None to upload, as all references are to URLs pointing to another server.'
=> 'Nichts hochzuladen, da alle Verweise auf URLs eines anderen Servers zeigen.',

   'None to upload, as all references are to existing files.'
=> 'Nichts hochzuladen, da alle Verweise auf bereits vorhandene Dateien zeigen.',

   'None to upload, as all references are to files with names containing invalid characters.'
=> 'Nichts hochzuladen, da alle Verweise auf Dateien zeigen, deren Namen ungültige Zeichen enthalten.',

   'Or [_1]continue[_2] the testbank import without modifying the reference(s).'
=> 'Oder [_1]Testbank-Import fortsetzen[_2], ohne die Verweise zu ändern.',

   'Referenced files'
=> 'verwiesene Dateien',

   'Required reference'
=> 'notwendiger Verweis',

   'Updated [quant,_1,reference] in [_2].'
=> '[quant,_1,Verweis wurde,Verweise wurden] in [_2] aktualisiert',

   'reference is to a URL which points to another server'
=> 'Verweis zeigt auf eine URL eines anderen Servers',

   'reference is to an existing file at the specified location'
=> 'Verweis zeigt auf eine vorhandene Datei an dem angegebenen Ort',

   'reference is to file with a name containing invalid characters'
=> 'Verweis zeigt auf eine Datei, deren Name ungültige Zeichen enthält',

   'Disk quota is [_1] kilobytes. Your current disk usage is [_2] kilobytes.'
=> 'Der Speicherplatz beträgt [_1] KB. Sie verwenden derzeit [_2] KB.',

   'Error when attempting section change for [_1] from old section "[_2]" to new section: "[_3]" in course [_4] -error:'
=> 'Beim Versuch, im Kurs [_4] eine Sektionsänderung für [_1] von der alten Sektion "[_2]" zur neuen Sektion "[_3]" ausführen, ist ein Fehler aufgetreten:',

   'Error when attempting to expire existing role for [_1] in section [_2] in course [_3] -error: '
=> 'Beim Versuch, im Kurs [_3] eine Rolle für [_1] für die Sektion [_2] ablaufen zu lassen, ist ein Fehler aufgetreten:',

   'Error when attempting to expire existing role without a section for [_1] in course [_2] -error: '
=> 'Beim Versuch, im Kurs [_2] eine Rolle ohne eine Sektion für [_1] ablaufen zu lassen, ist ein Fehler aufgetreten:',

   'Error when attempting to modify role for [_1] for section: "[_2]" in course [_3] -error:'
=> 'Beim Versuch, im Kurs [_3] eine Rolle für [_1] für die Sektion [_2] zu ändern, ist ein Fehler aufgetreten:',

   'Error: could not update [_1].'
=> 'Fehler: [_1] konnte nicht aktualisiert werden.',

   'Error: update failed for: [_1].'
=> 'Fehler: Aktualisierung für [_1] ist fehlgeschlagen.',

   'Filename not allowed - rename the file to remove the number immediately before the file extension([_1]) and re-upload.'
=> 'Der Dateiname ist unzulässig. Benennen Sie die Datei so um, dass die Zahl, die unmittelbar vor der Dateinamenserweiterung ([_1]) steht, nicht mehr vorhanden ist und laden Sie die Datei erneut hoch.',

   'IDs with the following format(s) may [_1]only[_2] be used for verified users at [_3]:'
=> 'IDs mit den folgenden Formaten kann [_1]nur[_2] für bestätigte Benutzer in [_3] verwendet werden:',

   'Usernames with the following format(s) may [_1]only[_2] be used for verified users at [_3]:'
=> 'Benutzerkennungen mit den folgenden Formaten kann [_1]nur[_2] für bestätigte Benutzer in [_3] verwendet werden:',

   'Incomplete course id defined.'
=> 'Unvollständige Kurs-ID ist festgelegt',

   'Invalid characters'
=> 'Ungültige Zeichen',

   'Rename the file with a different extension and re-upload.'
=> 'Benennen Sie die Datei um, so dass sie eine andere Dateinamenserweiterung hat und laden Sie die Datei erneut hoch.',

   'Unrecognized file extension ([_1]) - rename the file with a proper extension and re-upload.'
=> 'Unbekannte Dateinamenserweiterung ([_1]). Benennen Sie die Datei um, so dass sie eine gültige Dateinamenserweiterung hat und laden Sie die Datei erneut hoch.',

   'LON-CAPA can make the required changes to your HTML file.'
=> 'LON-CAPA kann für Sie die notwendigen Änderungen an Ihrer HTML-Datei vornehmen.',

   'Modify HTML file'
=> 'HTML-Datei ändern',

   'New student role for [_1] in section [_2] in course [_3].'
=> 'Neue studentische Rolle für [_1] in Sektion [_2] im Kurs [_3]',

   'New student role without a section for [_1] in course [_2].'
=> 'Neue studentische Rolle ohne Sektion für [_1] im Kurs [_3]',

   'No user portfolio available'
=> 'Kein Benutzer-Portfolio verfügbar',

   'Other users'
=> 'Andere Benutzer',

   'Return to discussion boards'
=> 'Zurück zu den Diskussionsforen',

   'Section for [_1] switched from (possibly expired) old section: [_2] to new section: [_3].'
=> 'Sektion für [_1] wurde geändert von (wahrscheinlich abgelaufener) alter Sektion [_2] in neue Sektion [_3]',

   'Section for [_1] switched from (possibly expired) old section: [_2] to student role without a section.'
=> 'Sektion für [_1] wurde geändert von (wahrscheinlich abgelaufener) alter Sektion [_2] in studentische Rolle ohne Sektion',

   'Student [_1] assigned to course [_2] without a section.'
=> 'Student/in [_1] wurde dem Kurs [_2] ohne Sektion zugewiesen',

   'Student [_1] assigned to section [_2] in course [_3].'
=> 'Student/in [_1] wurde der Sektion [_2] im Kurs [_3] zugewiesen',

   'The administrator of this domain has disabled portfolio functionality for this specific user.'
=> 'Der Administrator dieser Domäne hat die Portfolio-Funktionalität für diesen Benutzer deaktiviert.',

   'The courses listed below were included as sections or crosslistings affiliated with your new LON-CAPA course.  However, if automated course roster updates are enabled for this class, these particular sections/crosslistings will not contribute towards enrollment, because the user identified as the course owner for this LON-CAPA course'
=> 'Die unten aufgelisteten Kurse waren als Sektionen oder Querverweise mit Zugehörigkeit zu Ihrem neuen LON-CAPA-Kurs enthalten. Dennoch werden im Falle von aktivierten, automatischen Kursteilnehmerlisten-Aktualisierungen für diesen Kurs diese bestimmten Sektionen/Querverweise sich nicht auf die Kursbelegung auswirken, da der Benutzer der Kurseigentümer dieses LON-CAPA-Kurses ist.',

   'The domain has been configured to disable, by default, portfolio functionality for all users in the domain.'
=> 'Die Domäne wurde so konfiguriert, dass voreingestellt Portfolio-Funktionalität für alle Benutzer der Domäne deaktiviert ist.',

   'There was a problem creating the new discussion board - [_1]'
=> 'Beim Erstellen des neuen Diskussionsforums [_1] ist ein Problem aufgetreten.',

   'There was a problem removing a lockfile for the group ([_1]).'
=> 'Beim Entfernen der Sperrdatei für die Gruppe [_1] ist ein Problem aufgetreten.',

   'This may prevent creation of additional discussion boards in this group.'
=> 'Dies könnte dazu führen, dass in dieser Gruppe keine neuen Diskussionsforen angelegt werden können.',

   'URL points to other server.'
=> 'URL zeigt auf anderen Server',

   'Unable to upload [_1]. (size = [_2] bytes)'
=> '[_1] konnte nicht hochgeladen werden (Größe: [_2] Bytes)',

   'Unable to upload [_1]. (size = [_2] kilobytes). Disk quota will be exceeded if existing (smaller) file with same name (size = [_3] kilobytes) is replaced.'
=> '[_1] konnte nicht hochgeladen werden (Größe: [_2] KB). Der Speicherplatz würde überschritten, wenn vorhandene (kleinere) Datei mit dem selben Namen (Größe: [_3] KB) ersetzt würde.',

   'Unable to upload [_1]. A directory by that name was found in [_2].'
=> '[_1] konnte nicht hochgeladen werden. Ein Verzeichnis mit diesem Namen wurde in [_2] gefunden.',

   'Upload Listed Files'
=> 'Aufgelistete Dateien hochladen',

   'Upload embedded files'
=> 'Eingebettete Dateien hochladen',

   'View embedded file: [_1]'
=> 'Eingebettete Datei betrachten: [_1]',

   'changed from: [_1]'
=> 'geändert von [_1]',

   'Stored Links'
=> 'Linksammlung',

   'Add Folder'
=> 'Verzeichnis hinzufügen',

   'Add Link'
=> 'Link hinzufügen',

   'An error occurred! Please try again later.'
=> 'Es ist ein Fehler aufgetreten! Bitte versuchen Sie es später noch einmal.',

   'Are you sure you want to delete the selected entries? Deleting a folder also deletes all entries within this folder!'
=> 'Sind Sie sicher, dass Sie die ausgewählten Einträge löschen möchten? Das Löschen eines Verzeichnisses löscht auch alle Einträge in diesem Verzeichnis!',

   'Close this window'
=> 'Dieses Fenster schließen',

   'Folder title'
=> 'Titel des Verzeichnisses',

   'Go to Stored Links'
=> 'Zu der Linksammlung gehen',

   'Import Resources from Stored Links'
=> 'Ressourcen aus der Linksammlung importieren',

   'Link Title'
=> 'Linktitel',

   'Link successfully saved!'
=> 'Link wurde erfolgreich gespeichert!',

   'Move Selected'
=> 'Ausgewählte verschieben',

   'No rights to access Stored Links'
=> 'Sie haben keine Zugriffsberechtigung auf die Linksammlung',

   'Note: where a Stored Link is unavailable for import in the current context it is grayed out.'
=> 'Beachten Sie, dass die Stellen, an denen ein gespeicherter Link aus der Linksammlung im aktuellen Kontext für einen Import nicht verfügbar ist, ausgegraut sind.',

   'Use the checkboxes corresponding to a folder to easily check all links within this folder.'
=> 'Verwenden Sie die zu einem Verzeichnis gehörenden Checkboxen, um auf einfache Weise alle Links in diesem Verzeichnis auswählen zu können.',

   'Use the checkboxes corresponding to a folder to easily check all links within the folder.'
=> 'Verwenden Sie die zu einem Verzeichnis gehörenden Checkboxen, um auf einfache Weise alle Links in dem Verzeichnis auswählen zu können.',

   'The folder structure itself cannot be imported.'
=> 'Die Verzeichnisstruktur an sich kann nicht importiert werden.',

   'All checked links will be imported into the current folder of your course.'
=> 'Alle ausgewählten Links werden in das aktuelle Verzeichnis Ihres Kurses importiert.',

   'Save in'
=> 'Speichern in',

   'Save to Stored Links'
=> 'In der Linksammlung speichern',

   'The following link is not allowed:'
=> 'Der folgende Link ist nicht zulässig:',

   'Top level'
=> 'Oberste Ebene',

   'You can only insert links to LON-CAPA resources from the resource-pool or to external websites. Paths to LON-CAPA resources must be of the form /res/domain/user/... Paths to external websites must contain the network protocol, e.g. http://...'
=>  'Sie können nur Links auf LON-CAPA-Ressourcen aus dem Ressourcenpool oder auf externe Webseiten einfügen. Pfade auf LON-CAPA-Ressourcen müssen in der Form /res/domäne/benutzer/... sein. Pfade auf externe Webseiten müssen das Netzwerkprotokoll enthalten wie z.B. http://...',

   'You have selected the red marked entries to be moved to another folder. Now choose the new destination folder.'
=> 'Sie haben die rot-markierten Einträge zum Verschieben in ein anderes Verzeichnis ausgewählt. Wählen Sie nun das Zielverzeichnis.',

   'You have unsaved changes. You can either save these changes now by clicking "OK" or click "Cancel" if you do not want to save your changes.'
=> 'Sie haben ungespeicherte Änderungen. Sie können diese Änderungen durch Klick auf "OK" speichern. Klicken Sie auf "Abbrechen", wenn Sie die Änderungen nicht übernehmen wollen.',

   "You haven't marked any entry to move."
=> 'Sie haben keinen Eintrag zum Verschieben ausgewählt.',

   'You must insert a title and a path!'
=> 'Sie müssen einen Titel und einen Pfad angeben!',

   'You must insert a title!'
=> 'Sie müssen einen Titel angeben!',

   'You must select a destination folder!'
=> 'Sie müssen ein Zielverzeichnis angeben!',

   'You must select at minimum one entry to move!'
=> 'Sie müssen mindestens einen Eintrag auswählen, der verschoben werden soll!',

   'Your Stored Links list is currently empty.'
=> 'Ihre Linksammlung ist derzeit leer.',

   'Import from Stored Links'
=> 'Aus der Linksammlung importieren',

   'Save a link for this folder in Stored Links'
=> 'Einen Link für dieses Verzeichnis in der Linksammlung speichern',

   'Save a link for this folder in your personal Stored Links repository'
=> 'Einen Link für dieses Verzeichnis in der persönlichen Linksammlung speichern',

   'Save a link for this resource in your personal Stored Links repository'
=> 'Einen Link für diese Ressource in der persönlichen Linksammlung speichern',

   'Save a link for this resource in my personal Stored Links repository'
=> 'Einen Link für diese Ressource in meiner persönlichen Linksammlung speichern',

   'save in Stored Links'
=> 'in der Linksammlung gespeichert',

   'nothing'
=> 'nichts',

   'ungraded'
=> 'unbewertet',

   'incorrect'
=> 'inkorrekt',

   'Validating sequence'
=> 'Validiere Sequenz',

   'Validating ID'
=> 'Validiere ID',

   'Validating CODE'
=> 'Validiere CODE',

   'Validating doublebubble'
=> 'Validiere doppelte Ankreuzungen',

   'Validating missingbubbles'
=> 'Validiere fehlende Ankreuzungen',

   'A second grading pass was needed for user: [_1] with ID: [_2], because a mismatch was seen on the first pass.'
=> 'Für den Benutzer [_1] mit der ID [_2] war ein zweiter Bewertungsdurchlauf notwendig, da es im ersten Durchlauf eine Abgleichsfehler gegeben hatte.',

   'An error occurred ([_1]) when trying to remove the existing corrections.'
=> 'Beim Versuch, bestehende Korrekturen zu entfernen, ist ein Fehler aufgetreten: [_1]',

   'An unrecoverable network error occurred:'
=> 'Ein nicht behebbarer Netzwerkfehler ist aufgetreten:',

   "As a consequence, this user's submission history records two tries."
=> 'Als Folge daraus sind in der Historie dieses Benutzers zwei Versuche protokolliert.',

   'Current Grade Status'
=> 'Derzeitiger Bewertungsstatus',

   'Data File that will be used:'
=> 'Daten-Datei, die verwendet werden soll:',

   'Do Another Upload'
=> 'Einen weiteren Hochladevorgang ausführen',

   'Exact matches for [_1][quant,_2,student][_3].'
=> 'Genaue Treffer für [_1][quant,_2,Student/in,Studierende][_3].',

   'Gathering necessary information.'
=> 'Notwendige Daten werden zusammengetragen...',

   'Grading bubblesheet exam'
=> 'Bewertung von Bubblesheet-Prüfungen',

   'Grading will take longer if you use verification.'
=> 'Die Bewertung wird länger dauern, wenn Sie die Überprüfung verwenden.',

   'Grading: Validate Records'
=> 'Bewertung: Datensätze validieren',

   'How should I handle this?'
=> 'Wie soll damit umgegangen werden?',

   "If something is incorrect, please click the 'Grading Menu' button to start over."
=> "Falls etwas nicht stimmen sollte, klicken Sie bitte auf 'Bewertungsmenü', um noch einmal von vorn anzufangen.",

   "If this information is correct, please click on '[_1]'."
=> "Falls diese Information korrekt ist, klicken Sie bitte auf '[_1]'.",

   'It is recommended that you try again later, as this error may mean the server was just temporarily unavailable, or is down for maintenance.'
=> 'Es wird empfohlen, die Aktion später noch einmal auszuführen, da dieser Fehler bedeuten könnte, dass der Server nur momentan nicht verfügbar ist, z.B. aufgrund von Wartungsarbeiten.',

   'If the error persists, please contact the [_1] for assistance.'
=> 'Falls der Fehler bestehen bleibt, kontaktieren Sie bitte [_1] für weitere Hilfe.',

   'Item ID'
=> 'Element-ID',

   'Option ID'
=> 'Options-ID',

   'Manually graded by [_1]'
=> 'Manuell bewertet von [_1]',

   'New Score'
=> 'Neue Punkte',

   'Old Score'
=> 'Alte Punkte',

   'Previous Score'
=> 'Vorherige Punkte',

   'New variation this try'
=> 'Neue Variation mit diesem Versuch',

   'No Changes Occurred For the Students Below'
=> 'Für die unten angegebenen Studierenden wurden keine Änderungen vorgenommen.',

   'Not allowed to modify student'
=> 'Sie sind nicht berechtigt, die studentischen Daten zu ändern.',

   'Number of given answers does not agree with number of questions in file.'
=> 'Die Anzahl der gegebenen Antworten stimmt nicht mit der Anzahl der Fragen in der Datei überein.',

   'Part: [_1] (Weight = [_2])'
=> 'Teil: [_1] (Gewichtung: [_2])',

   'Part: [_1] Status'
=> 'Teil: [_1] Status',

   'Perform verification for each student after storage of submissions?'
=> 'Soll nach der Speicherung der Einreichungen für jeden Studierenden eine Datenüberprüfung vorgenommen werden?',

   "Please double check the information below before clicking on '[_1]'"
=> "Bitte überprüfen Sie die unten gemachten Angaben noch einmal, bevor Sie auf '[_1]' klicken.",

   'Please indicate which bubble should be used for grading'
=> 'Bitte geben Sie an, welches Ankreuzfeld für die Bewertung verwendet werden soll.',

   'Please indicate which bubble should be used for grading.'
=> 'Bitte geben Sie an, welches Ankreuzfeld für die Bewertung verwendet werden soll.',

   'Prob.'
=> 'Aufg.',

   'Score based on [_1] ([_2] answers)'
=> 'Punkte basieren auf [_1] ([_2] Antworten)',

   'No bubble'
=> 'Kein Ankreuzfeld',

   "Select at most one bubble in a single line and select 'No Bubble' in all the other lines. "
=> "Wählen Sie mindestens ein Ankreuzfeld in einer einzelnen Zeile aus und wählen Sie 'Kein Ankreuzfeld' in allen anderen Zeilen aus. ",

   "A bubble or 'No bubble' selection has not been made for one or more lines."
=> "Für eine oder mehrere Zeilen wurde kein Ankreuzfeld angekreuzt oder nicht 'Kein Ankreuzfeld' ausgewählt.",

   'Sequence to be Graded:'
=> 'Sequenz, die bewertet werden soll:',

   'Some questions have no scanned bubbles.'
=> 'Einige Fragen haben keine gescannten Ankreuzfelder.',

   'Start Grading'
=> 'Bewertung starten',

   'The encoded ID has also been used by a previous paper [_1]'
=> 'Die eingetragene ID wurde bereits bei einem vorherigen Blatt verwendet [_1]',

   'The encoded ID is not in the classlist'
=> 'Die eingetragene ID ist nicht in der Kursteilnehmerliste.',

   'The group of bubble lines below responds to a single question.'
=> 'Die Gruppe der Ankreuzfelder-Zeilen bezieht sich auf eine einzelne Frage.',

   'The requested filename was invalid.'
=> 'Der angeforderte Dateiname ist ungültig.',

   'There have been multiple bubbles scanned for some question(s)'
=> 'Für einige Fragen wurden mehrere Ankreuzfelder gescannt.',

   'This student has submitted [quant,_1,invalid collaborator]: [_2]'
=> 'Dieser/diese Student/in hat [quant,_1,ungültigen Mitarbeiter,ungültige Mitarbeiter] eingereicht: [_2]',

   'Total number of students = [_1]'
=> 'Gesamtanzahl Studierender: [_1]',

   'Unable to retrieve a resource from a server:'
=> 'Eine Ressource konnte von einem Server nicht abgerufen werden:',

   'Unable to view requested sequence. ([_1])'
=> 'Die angeforderte Sequenz kann nicht betrachtet werden. ([_1])',

   'Unable to view requested student. ([_1])'
=> 'Der/die angeforderte Student/in kann nicht betrachtet werden. ([_1])',

   'Unable to view requested student.'
=> 'Der/die angeforderte Student/in kann nicht betrachtet werden.',

   'Unable to view previous version for requested student.'
=> 'Die vorherige Version für den/die angeforderte/n Student/in kann nicht betrachtet werden.',

   '([_1] in section [_2] in course id [_3])'
=> '([_1] in der Sektion [_2] im Kurs mit der ID [_3])',

   'Validation process complete.'
=> 'Validierungsvorgang abgeschlossen',

   'You have not selected a Sequence to grade'
=> 'Sie haben keine Sequenz zum Bewerten ausgewählt.',

   'You need to specify the correct answer'
=> 'Sie müssen die korrekte Antwort angegeben',

   '[_1]: no data to save'
=> '[_1]: keine Daten zum Speichern',

   '[_1]parts'
=> '[_1]Teile',

   '[quant,_1,part]'
=> '[quant,_1,Teil,Teile]',

   'essay part only'
=> 'nur Essay-Teil',

   'true'
=> 'wahr',

   'false'
=> 'falsch',

   'problem weight assigned by computer'
=> 'Aufgabengewichtung wurden durch den Computer zugewiesen',

   'Any user in any domain'
=> 'Beliebiger Benutzer in beliebiger Domäne',

   'Available'
=> 'Verfügbar',

   'availability'
=> 'Verfügbarkeit',

   'Change setting'
=> 'Einstellung ändern',

   'Create or edit another custom role'
=> 'Eine weitere benutzerdefinierte Rolle erstellen oder ändern',

   'For this user, the default quota of [_1]'
=> 'Für diesen Benutzer beträgt der voreingestellte Speicherplatz [_1]',

   'Invalid login mode or password'
=> 'Ungültiger Login-Modus oder Passwort',

   'Personal User Blog'
=> 'Persönlicher Benutzer-Blog',

   'Personal User Portfolio'
=> 'Persönliches Benutzer-Portfolio',

   'The error was: [_1].'
=> 'Der Fehler war: [_1].',

   'Unable to determine home server for [_1] in domain [_2].'
=> 'Für den Benutzer [_1] in der Domäne [_2] konnte der Heimatserver nicht bestimmt werden.',

   'Use custom'
=> 'benutzerdefinierte Einstellungen verwenden',

   'Use default'
=> 'Voreinstellung verwenden',

   'User Tools'
=> 'Benutzer-Werkzeuge',

   'User Tools Availability'
=> 'Verfügbarkeit von Benutzer-Werkzeugen',

   "availability set to 'off'"
=> "Verfügbarkeit auf 'aus' gestellt",

   "availability set to 'on'"
=> "Verfügbarkeit auf 'an' gestellt",

   "availability set to 'on' (approval required)"
=> "Verfügbarkeit auf 'an' gestellt (Bestätigung erforderlich)",

   "availability set to 'on' (automatic approval)"
=> "Verfügbarkeit auf 'an' gestellt (automatische Bestätigung)",

   'available with automatic approval (unlimited)'
=> 'verfügbar mit automatischer Bestätigung (unbegrenzt)',

   'available with automatic approval, up to limit of [quant,_1,request] per user'
=> 'verfügbar mit automatischer Bestätigung bis zu einer Grenze von [quant,_1,Antrag,Anträgen] pro Benutzer',

   'An Error Occured while Attempting to Save your Version Settings'
=> 'Während des Versuchs, Ihre Versionseinstellungen zu speichern, ist ein Fehler aufgetreten.',

   'Copying Files'
=> 'Dateien werden kopiert',

   'Copying File'
=> 'Datei wird kopiert',

   'Press delete to remove file and replace it with a copy of the source you are viewing'
=> 'Klicken Sie auf "Löschen", um die Datei zu entfernen und sie mit einer Kopie des Quellcodes zu ersetzen, den Sie gerade betrachten.',

   'Creating directories'
=> 'Verzeichnisse werden erstellt',

   'Embedded item(s) already present, so no additional upload(s) required'
=> 'Eingebettete Elemente sind bereits vorhanden, also sind keine weiteren Hochladevorgänge notwendig.',

   'No embedded items identified'
=> 'Keine eingebetteten Elemente gefunden',

   'Retrieval of List Failed'
=> 'Abrufen der Liste ist fehlgeschlagen',

   'Return to Course Editor'
=> 'Zurück zum Kurs-Editor',

   'Return to Editor'
=> 'Zurück zum Editor',

   'The following sequence or page is included more than once in your Course:'
=> 'Die folgende Sequenz oder Seite ist in Ihrem Kurs mehrfach vorhanden:',

   'The following sequence or page is included more than once in your Community:'
=> 'Die folgende Sequenz oder Seite ist in Ihrer Community mehrfach vorhanden:',

   'The uploaded file has not been stored as an error occurred reading the contents of the current folder.'
=> 'Die hochgeladene Datei wurde nicht gespeichert, da beim Lesen des Inhalts des aktuellen Verzeichnisses ein Fehler aufgetreten ist.',

   'This file contains embedded multimedia objects, which need to be uploaded.'
=> 'Diese Datei enthält eingebettete Multimedia-Objekte, die ebenfalls hochgeladen werden müssen.',

   'Unable to save file [_1].'
=> 'Konnte Datei [_1] nicht speichern',

   'Version used in community'
=> 'Version, die in der Coommunity verwendet wird',

   'Version used in course'
=> 'Version, die im Kurs verwendet wird',

   'fail'
=> 'fehlgeschlagen',

   'Environment'
=> 'Umgebung',

   'File (contents not shown) - size was [_1] MB.'
=> 'Datei (Inhalt wird nicht angezeigt) - die Größe betrug [_1] MB.',

   'Guesses'
=> 'Schätzungen',

   'LON-CAPA Error Message'
=> 'LON-CAPA-Fehlermeldung',

   'Prior Action'
=> 'Vor der Aktion',

   'Reproducible'
=> 'Reproduzierbar',

   '(Closed for [_1] roles)'
=> '(für [_1] Rollen geschlossen)',

   'Attachment not included - exceeded permitted length'
=> 'Anhang wurde nicht verwendet - zulässige Dateigröße überschritten',

   'Default for all discussions'
=> 'Voreinstellung für alle Diskussionen',

   'Feedback'
=> 'Feedback',

   'None selected'
=> 'Nichts ausgewählt',

   'Posts'
=> 'Beiträge',

   'Posts by'
=> 'Beiträge von',

   'Save read/unread changes'
=> 'Gelesene/ungelesene Änderungen speichern',

   'The following attachments have been uploaded for inclusion with this posting.'
=> 'Die folgenden Anhänge wurden zur Einbindung in diesen Beitrag hochgeladen.',

   'The following attachments were part of the most recent saved version of this posting.'
=> 'Die folgenden Anhänge waren Teil der zuletzt gespeicherten Version dieses Beitrags.',

   'The following errors occurred during export:'
=> 'Während des Exports sind folgende Fehler aufgetreten:',

   'You have not indicated that you wish to change any of the discussion settings'
=> 'Sie haben nicht angegeben, dass Sie Diskussionseinstellungen ändern möchten.',

   'You will be returned to the previous page if you click OK.'
=> 'Mit Klick auf OK kehren Sie auf die vorherige Seite zurück.',

   'posts previously marked read'
=> 'Beiträge, die zuvor als gelesen gekennzeichnet wurden',

   'previously viewed posts'
=> 'zuvor betrachtete Beiträge',

   '"[_1]" not found'
=> '"[_1]" konnte nicht gefunden werden',

   'You must choose at least one user to continue.'
=> 'Sie müssen zumindest einen Benutzer auswählen, um fortfahren zu können.',

   'for group [_1]'
=> 'für die Gruppe [_1]',

   'for the map ID [_1] (name unavailable)'
=> 'für die Inhaltszusammenstellungs-ID [_1] (Name nicht verfügbar)',

   ' Suggested improvements may include additional functionality, improved usability, or changes to wording used in LON-CAPA pages, including the embedded help system.'
=> ' Vorgeschlagene Verbesserungen können zusätzliche Funktionalität, verbesserte Benutzerfreundlichkeit oder Änderungen an der Wortwahl von LON-CAPA-Seiten, auch die der eingebauten Hilfe, enthalten.',

   'Choose an entry below to go directly to a relevant help page'
=> 'Wählen Sie unten einen Eintrag aus, um direkt zu der entsprechenden Hilfeseite zu gelangen',

   'or to submit a help request to the LON-CAPA support staff at your institution.'
=> 'oder um ein Hilfeticket an die LON-CAPA-Kundenbetreuung Ihrer Institution zu senden.',

   'Contact the LON-CAPA support team'
=> 'Die LON-CAPA-Kundenbetreuung kontaktieren',

   'Create an account for yourself in the LON-CAPA Bugzilla tracking system, if you wish to report bugs you have encountered in the LON-CAPA software, or if you have suggestions for improvements in LON-CAPA.'
=> 'Erstellen Sie sich einen Account in dem LON-CAPA-Bugzilla-System, wenn Sie Fehler melden möchten, die Sie in der LON-CAPA-Software entdeckt haben oder wenn Sie Vorschläge zur Verbesserung von LON-CAPA haben.',

   'Create an account for yourself in the LON-CAPA Bugzilla tracking system, if you wish to report bugs you have encountered in the LON-CAPA software,or if you have suggestions for improvements in LON-CAPA.'
=> 'Erstellen Sie sich einen Account in dem LON-CAPA-Bugzilla-System, wenn Sie Fehler melden möchten, die Sie in der LON-CAPA-Software entdeckt haben oder wenn Sie Vorschläge zur Verbesserung von LON-CAPA haben.',

   'Display the page in the inline help system that covers this topic.'
=> 'Anzeige der Seite im eingebettenen Hilfesystem, die sich mit diesem Thema befasst.',

   'FAQ-O-Matic Help system'
=> 'FAQ-O-Matic-Hilfesystem',

   'The FAQ-O-Matic is a compendium of answers provided to common questions asked by users of LON-CAPA over the past couple of years.'
=> 'Das FAQ-O-Matic-Hilfesystem ist eine Sammlung von Antworten auf übliche Fragen von LON-CAPA-Benutzern der letzten Jahre.',

   'LON-CAPA Bugzilla bug/feature request tracking system'
=> 'LON-CAPA-Bugzilla-Fehler-und-Verbesserungs-Nachverfolgungssystem',

   'Submit a help request to the team responsible for LON-CAPA support at this institution.'
=> 'Absenden einer Hilfeanfrage an die LON-CAPA-Kundenbetreuung dieser Institution',

   'Topic Page'
=> 'Themenseite',

   'No context provided.'
=> 'Kein Kontext angegeben',

   'The required Java applet could not be started. Please make sure to have Java installed and active in your browser.'
=> 'Das erforderliche Java-Applet konnte nicht gestartet werden. Bitte stellen Sie sicher, dass Sie Java in Ihrem Browser installiert und aktiviert haben.',

   'Access to this course is key controlled.'
=> 'Der Zugriff auf den Kurs wird über einen Schlüsel geregelt.',

   'Access to this course is open, no access keys'
=> 'Der Zugriff auf den Kurs ist frei. Es ist kein Zugriffsschlüssel erforderlich.',

   'Key Access'
=> 'Schlüsselzugriff',

   'Key Authority'
=> 'Schlüsselmeister',

   'Open Access'
=> 'Freier Zugang',

   'Could not write metadata'
=> 'Metadaten konnten nicht geschrieben werden',

   'If automatic enrollment is enabled for "[_1]", automated enrollment may fail for "[_2]" - section: [_3] for the following reason: "[_4]".'
=> 'Falls die automatische Kursbelegung für "[_1]" aktiviert ist, könnten automatische Kursbelegungen für "[_2]", Sektion [_3] aus folgendem Grund fehlschlagen: "[_4]"',

   'If automatic enrollment is enabled for "[_1]", automated enrollment may fail for crosslisted class "[_2]" for the following reason: "[_3]".'
=> 'Falls die automatische Kursbelegung für "[_1]" aktiviert ist, könnten automatische Kursbelegungen für den querverwiesenen Kurs "[_2]" aus folgendem Grund fehlschlagen: "[_4]"',

   'An error occurred storing the responder threshold for anonymous submissions display: '
=> 'Beim Speichern des Anzahl-Antworter-Schwellenwerts zur Anzeige anonymer Einreichungen ist ein Fehler aufgetreten: ',

   'Responder threshold for anonymous survey submissions display remains unchanged: [_1].'
=> 'Der Anzahl-Antworter-Schwellenwert zur Anzeige anonymer Umfrageeinreichungen bleibt unverändert: [_1]',

   'Responder threshold required for display of anonymous survey submissions:'
=> 'Anzahl-Antworter-Schwellenwert erforderlich, um anonyme Umfrageeinreichungen anzuzeigen:',

   'The proposed responder threshold for display of anonymous submissions contained invalid characters, so the threshold is unchanged.'
=> 'Der angegebene Anzahl-Antworter-Schwellenwert zur Anzeige anonymer Umfrageeinreichungen enthält ungültige Zeichen, so dass der Schwellenwert unverändert bleibt.',

   'The proposed responder threshold for display of anonymous survey submissions was blank, so the threshold is unchanged.'
=> 'Der angegebene Anzahl-Antworter-Schwellenwert zur Anzeige anonymer Umfrageeinreichungen war leer, so dass der Schwellenwert unverändert bleibt.',

   'The responder threshold for display of anonymous survey submissions is now: [_1].'
=> 'Der Anzahl-Antworter-Schwellenwert zur Anzeige anonymer Umfrageeinreichungen ist jetzt: [_1]',

   'The responder threshold for display of anonymous survey submissions is the default for this domain: [_1].'
=> 'Der Anzahl-Antworter-Schwellenwert zur Anzeige anonymer Umfrageeinreichungen ist die Voreinstellung für diese Domäne: [_1]',

   'The new quota requested contained invalid characters, so the quota is unchanged.'
=> 'Die Eingabe des gewünschten Speicherplatzes enthält ungültige Zeichen, so dass der Speicherplatz unverändert bleibt.',

   'Upload of new portfolio files and assignment of a non-zero MB quota to new groups in the course will not be possible until some files have been deleted, and total usage is below course quota.'
=> 'Ein Hochladen von neuen Portfolio-Dateien und Zuweisung von echtem Speicherplatz für neue Gruppen im Kurs wird nicht möglich sein, bis einige Dateien gelöscht worden sind und der Gesamtspeicherplatzverbrauch geringer als der Kursspeicherplatz ist.',

   'As this group has no members, there are no recipients to select'
=> 'Da diese Gruppe keine Mitglieder hat, können Sie auch keine Empfänger auswählen.',

   'Bcc'
=> 'BCC',

   'Bcc to group'
=> 'BCC an Gruppe',

   'Blogs'
=> 'Blogs',

   'Broadcast (Bcc) to Former Members'
=> 'Broadcast-Nachricht (BCC) an ehemalige Teilnehmer',

   'Broadcast (Bcc) to Future Members'
=> 'Broadcast-Nachricht (BCC) an zukünftige Teilnehmer',

   'Broadcast to'
=> 'Broadcast-Nachricht an',

   'Broadcast to Active Members'
=> 'Broadcast-Nachricht an aktive Teilnehmer',

   'Cc to group'
=> 'CC an Gruppe',

   'Group Cc'
=> 'Gruppe (CC)',

   'No changes were made.'
=> 'Keine Änderungen vorgenommen',

   'No changes saved.'
=> 'Änderungen nicht gespeichert',

   'Recipients of broadcast message'
=> 'Empfänger der Broadcast-Nachricht',

   '[_1]Cc[_2] to other copied group members'
=> '[_1]CC[_2] an andere, in Kopie befindliche Gruppenmitglieder',

   '[_1]Cc[_2] to other copied recipients'
=> '[_1]CC[_2] an andere in Kopie befindliche Empfänger',

   '[_1]Send reply[_2] to other recipients'
=> '[_1]Antworten senden[_2] an andere Empfänger',

   'Automatic setting rules apply to table mode interfaces only.'
=> 'Automatische Einstellungsregeln beziehen sich nur auf den Tabellenmodus.',

   'Manual setting rules apply to all interfaces.'
=> 'Manuelle Einstellungsregeln beziehen sich auf alle Modi.',

   'Control by other group?'
=> 'Durch andere Gruppe gesteuert?',

   'Currently set date:'
=> 'Derzeit eingestelltes Datum:',

   'Deleted parameter for'
=> 'Parameter gelöscht für',

   'Deleted [quant,_1,parameter]'
=> '[_1] Parameter entfernt',

   'Error deleting parameters'
=> 'Fehler beim Löschen der Parameter',

   'Error saving parameters'
=> 'Fehler beim Speichern der Parameter',

   'Parameter: "[_1]" with value: "[_2]"'
=> 'Parameter "[_1]" mit dem Wert "[_2]"',

   'Rule for parameter'
=> 'Regel für den Parameter',

   'Saved [quant,_1,parameter]'
=> '[_1] Parameter gespeichert',

   'Saved modified date for'
=> 'Geändertes Datum gespeichert für',

   'Saved modified parameter for'
=> 'Geänderter Parameter gespeichert für',

   'Shift all dates accordingly'
=> 'Alle Datumswerte entsprechend verschieben',

   'Shifted date:'
=> 'Verschobenes Datum:',

   'Shifting all dates such that [_1] becomes [_2]'
=> 'Verschiebe alle Datumswerte, so dass aus [_1] nun [_2] wird',

   'These parameters refer to resources that do not exist.'
=> 'Diese Parameter beziehen sich auf nicht existierende Ressourcen.',

   'Triggering value(s) of other parameter (optional, comma-separated):'
=> 'Auslösende(r) Wert(e) eines anderen Parameters (optional, durch Kommata getrennt):',

   'Action locked'
=> 'Aktion gesperrt',

   'Cleared locks.'
=> 'Sperrungen aufgehoben',

   'Changing roles or logging out may result in data corruption.'
=> 'Ein Ändern von Rollen oder Ausloggen könnte eine Zerstörung von Daten bewirken.',

   'LON-CAPA is currently performing the following actions:'
=> 'LON-CAPA führt derzeit folgende Aktionen aus:',

   'Override'
=> 'Übergehen',

   'At least one of the resources you chose to print could not be rendered due to an unrecoverable error when communicating with a server:'
=> 'Mindestens eine Ressource, die Sie zum Drucken ausgewählt haben, konnte aufgrund eines nicht behebbaren Server-Kommunikationsfehlers nicht gerendert werden:',

   'We apologize for the inconvenience.'
=> 'Wir bitten die Unannehmlichkeiten zu entschuldigen.',

   'You can continue using the link provided below, but make sure to carefully inspect your output file! The errors will be marked in the file.'
=> 'Sie können weiterhin den unten angegebenen Link verwenden. Überprüfen Sie jedoch genau die Ausgabedatei! Die Fehler werden in der Datei markiert sein.',

   'You may be able to reprint the individual resources for which this error occurred, as the issue may be temporary.'
=> 'Es handelt sich möglicherweise um einen temporären Fehler. Daher könnte es möglich sein, dass Sie die einzelnen Ressourcen, für die dieser Fehler aufgetreten ist, erneut drucken können.',

   'last assignment'
=> 'letzte Übung',

   'last student'
=> 'letzte/r Student/in',

   '[_1] was excluded because institutional information is incomplete for this new user.'
=> '[_1] wurde ausgelassen, da die institutionellen Informationen für diesen Benutzer nicht vollständig sind.',

   'Advertise this Feed'
=> 'Diesen Feed bewerben',

   'Blogs belonging to [_1] are unavailable from [_2] to [_3].'
=> 'Blogs, die zu [_1] gehören, sind von [_2] bis [_3] nicht verfügbar.',

   'Course Blog'
=> 'Kurs-Blog',

   'Enclosure'
=> 'Enclosure', # ???

   'Podcasted enclosure'
=> 'Podcasted enclosure', # ???

   'No feed available'
=> 'Kein Feed verfügbar',

   'No user blog available'
=> 'Kein Benutzer-Blog verfügbar',

   'Read more'
=> 'Mehr lesen',

   'The administrator of this domain has disabled blog functionality for this specific user.'
=> 'Der Administrator dieser Domäne hat die Blog-Funktionalität für diesen Benutzer deaktiviert.',

   'The domain has been configured to disable, by default, blog functionality for all users in the domain.'
=> 'Die Domäne wurde so konfiguriert, dass voreingestellt für alle Benutzer dieser Domäne die Blog-Funktionalität deaktiviert ist.',

   'This is because the blog owner is a student in one or more courses in which communication is being blocked.'
=> 'Der Grund liegt darin, dass der Blog-Eigentümer Student/in eines oder mehrerer Kurse ist, für die die Kommunikation gesperrt ist.',

   'This is because you are a student in one or more courses in which communication is being blocked.'
=> 'Der Grund liegt darin, dass  Sie Student/in eines oder mehrerer Kurse sind, für die die Kommunikation gesperrt ist.',

   'Incorrect entry for the creation date. You must specify both the beginning and ending dates.'
=> 'Ungültige Eingabe für das Erstellungsdatum. Sie müssen Start- und Enddatum angeben.',

   'Incorrect entry for the last revision date. You must specify both the beginning and ending dates.',
=> 'Ungültige Eingabe für das Datum der letzten Überarbeitung. Sie müssen Start- und Enddatum angeben.',

   'Unparsed Field'
=> 'Nicht verarbeitetes Feld',

   'search again.'
=> 'Nochmal suchen',

   'Not allowed to create file [_1]'
=> 'Sie sind nicht berechtigt, die Datei [_1] zu erstellen.',

   'Please use the code view in previous window to use shared code.'
=> 'Bitte verwenden Sie die Code-Ansicht im vorhergehenden Fenster, um geteilten Code zu verwenden.',

   'Anonymous Survey Submission: details not shown'
=> 'Anonyme Umfrage-Einreichung: Details werden nicht gezeigt',

   'Originating Server'
=> 'Ursprünglicher Server',

   'Please try again in a few minutes.'
=> 'Bitte versuchen Sie es in ein paar Minuten noch einmal.',

   'Unable to process for [_1]:[_2]'
=> 'Verarbeitung für [_1]:[_2] nicht möglich',

   'Unable to read results file.'
=> 'Die Ergebnisdatei konnte nicht gelesen werden.',

   'Unable to retrieve any data.  Please reload this page and try again.'
=> 'Es konnten keine Daten abgerufen werden. Bitte laden Sie die Seite erneut und versuchen Sie es noch einmal.',

   'Unable to retrieve data.'
=> 'Es konnten keine Daten abgerufen werden.',

   'Consequently, the user was not created.'
=> 'Der Benutzer wurde deshalb nicht erstellt.',

   'Institutional'
=> 'Institutionell',

   'Non-institutional'
=> 'Nicht-institutionell',

   'The user does not already exist, and you may not create a new user in a different domain.'
=> 'Der Benutzer existiert noch nicht und Sie dürfen keine neuen Benutzer in einer fremden Domäne erstellen.',

   'Your current role does not have rights to create users with that authentication type.'
=> 'Ihre aktuelle Rolle gestattet es nicht, Benutzer mit dieser Authentifizierungsmethode zu erstellen.',

   '[_1]: The domain specified ([_2]) is different to that of the author.'
=> '[_1]: Die angegebene Domäne [_2] ist eine andere als die des Autors.',

   '[_1]: The domain specified ([_2]) is different to that of the course.'
=> '[_1]: Die angegebene Domäne [_2] ist eine andere als die des Kurses.',

   '[_1]: The domain specified ([_2]) is different to that of your current role.'
=> '[_1]: Die angegebene Domäne [_2] ist eine andere als die Ihrer derzeitigen Rolle.',

   '[_1]: has a student/employee ID matching the format at your institution, but the ID is found by your directory service.'
=> '[_1] hat eine Studierenden-/Mitarbeiter-ID, die dem Format Ihrer Institution entspricht, jedoch wurde die Id in Ihrem Verzeichnisdienst gefunden.',

   '[_1]: matches the username format at your institution, but is not known to your directory service.'
=> '[_1] entspricht dem Format für Benutzerkennungen an Ihrer Institution, konnte jedoch nicht in Ihrem Verzeichnisdienst gefunden werden.',

   'role will be added with access to all sections'
=> 'Rolle wird mit Zugriff auf alle Sektionen hinzugefügt',

   'An error occurred retrieving information about the course.'
=> 'Beim Abrufen von Informationen über den Kurs ist ein Fehler aufgetreten.',

   'Counters reset for following problems (and parts):'
=> 'Zähler für folgende Aufgaben (und Aufgabenteile) zurücksetzen:',

   'Number of correct submissions'
=> 'Anzahl korrekter Einreichungen',

   'Number of submissions'
=> 'Anzahl Einreichungen',

   'Students with submissions'
=> 'Studierende mit Einreichungen',

   'Unable to reset counters to zero due to [_1]'
=> 'Die Zähler konnten nicht auf Null zurückgesetzt werden. Ursache: [_1]',

   'Unable to save visibility settings due to [_1]'
=> 'Die Sichtbarkeitseinstellungen konnten nicht gespeichert werden. Ursache: [_1]',

   'Unable to set threshold for [_1] to [_2] due to [_3].'
=> 'Der Schwellenwert für [_1] konnte nicht auf [_2] gesetzt werden. Ursache: [_3]',

   'Click to download'
=> 'Hier klicken zum Herunterladen',

   'You are not authorized to download student submissions.'
=> 'Sie sind nicht berechtigt, studentische Einreichungen herunterzuladen.',

   'Files contained in this zip:'
=> 'Dateien in dieser ZIP-Datei:',

   'Zip file generated on [_1]'
=> 'ZIP-Datei am [_1] erstellt',

   'No Files Submitted'
=> 'Keine Dateien eingereicht',

   'Problem: [_1]'
=> 'Problem: [_1]',

   'Unable to create: '
=> 'Kann nicht erstellt werden: ',

   'Are you sure you want to overwrite an existing file?'
=> 'Sind Sie sicher, dass Sie die bestehende Datei überschreiben möchten?',

   'Overwrite existing file?'
=> 'Bestehende Datei überschreiben?',

   'Overwriting completed.'
=> 'Überschreiben abgeschlossen',

   'Completed upload of the file.'
=> 'Hochladen der Datei abgeschlossen',

   'Completed upload of the file. This file contained references to other files.'
=> 'Hochladen der Datei abgeschlossen. Diese Datei enthält Verweise auf andere Dateien.',

   'Invalid filename: [_1]; the name of the uploaded file did not contain any letters, so after eliminating special characters there was nothing left.'
=> 'Ungültiger Dateiname: [_1]; der Name der hochgeladenen Datei enthält keine Buchstaben, denn nach dem Entfernen von Sonderzeichen bliebt nichts übrig.',

   'Locked'
=> 'gesperrt',

   'locked'
=> 'gesperrt',

   'unlocked'
=> 'nicht gesperrt',

   'No embedded items identified.'
=> 'Keine eingebetteten Elemente gefunden',

   'Reference Information'
=> 'Referenz-Information',

   'The file is locked and cannot be deleted.'
=> 'Die Datei ist gesperrt und kann nicht gelöscht werden.',

   'The file is locked and cannot be renamed.'
=> 'Die Datei ist gesperrt und kann nicht umbenannt werden.',

   'This action can not be undone.'
=> 'Diese Aktion kann nicht rückgängig gemacht werden.',

   '[quant,_1,file] in list not selectable as file size is 0 bytes.'
=> '[quant,_1,Datei,Dateien] in der Liste können nicht ausgewählt werden, da die Datei 0 Byte groß ist.',

   'A network error has occurred.'
=> 'Es ist ein Netzwerkfehler aufgetreten.',

   'Already have a reservation: [_1].'
=> 'Haben bereits eine Reservierung: [_1].',

   'Already reserved: [_1]'
=> 'Bereits reserviert: [_1]',

   'An error occurred determining slot availability.'
=> 'Beim Feststellen der Slot-Verfügbarkeit ist ein Fehler aufgetreten.',

   'An error occurred when attempting to delete slot: [_1]'
=> 'Beim Versuch, den Slot zu löschen, ist ein Fehler aufgetreten: [_1]',

   'An error occurred while attempting to make a reservation. ([_1])'
=> 'Beim Versuch, eine Reservierung vorzunehmen, ist ein Fehler aufgetreten: [_1]',

   'Change Reservation'
=> 'Reservation ändern',

   'Create Slots'
=> 'Slots erstellen',

   'Created [quant,_1,slot]'
=> '[quant,_1,Slot wurde,Slots wurden] erstellt',

   'Creating Slots'
=> 'Slots werden erstellt',

   'Deleted Slots:'
=> 'Gelöschte Slots:',

   'Entry added to course record (viewable by instructor): [_1]'
=> 'Eintrag wurde den Kursaufzeichnungen hinzugefügt (von Dozenten einsehbar): [_1]',

   'Failed.'
=> 'Fehlgeschlagen',

   'Make no change'
=> 'Keine Änderung vornehmen',

   'Message triggered by reservation'
=> 'Nachricht wurde durch Reservierung ausgelöst',

   'No change to existing registration by [_1] for [_2].'
=> 'Keine Änderung der bestehenden Registrierung durch [_1] für [_2].',

   'No slots are available.'
=> 'Keine Slots verfügbar',

   'None sent and no record in user notes'
=> 'Nichts gesendet und kein Eintrag in den Benutzeranmerkungen',

   'Not allowed to sign up or change reservations at this time.'
=> 'Momentan ist es nicht zulässig, sich einzutragen oder Reservierungen zu ändern.',

   'Process the change'
=> 'Die Änderung ausführen',

   'Regular Expression'
=> 'Regulärer Ausdruck',

   'Remove [_1] from slot [_2] for [_3]'
=> 'Entfernen von [_1] vom Slot [_2] für [_3]',

   'Remove all of [_1] from slot [_2]?'
=> 'Alles entfernen von [_1] für Slot [_2]?',

   'Reservation change: [_1]'
=> 'Reservierungsänderung: [_1]',

   'Reservation currently unchanged'
=> 'Reservierung derzeit unverändert',

   'Reservation no longer reported as available.'
=> 'Reservierung nicht mehr verfügbar',

   'Reservation released by [_1] for [_2].'
=> 'Reservierung freigegeben durch [_1] für [_2]',

   'Reservation unchanged: [_1]'
=> 'Reservierung unverändert: [_1]',

   'Sent to student'
=> 'Zum/r Student/in gesendet',

   'Sent to student and added to user notes'
=> 'Zum/r Student/in gesendet und den Benutzeranmerkungen hinzugefügt',

   'Sent to you: [_1]'
=> 'An Sie gesendet: [_1]',

   'Slot [_1] does not exist.'
=> 'Slot [_1] existiert nicht',

   'Slot [_1] has active reservations.'
=> 'Slot [_1] hat bestehende Reservierungen',

   'Slot [_1] has no reservations.'
=> 'Slot [_1] hat keine Reservierungen',

   'Slot: [_1] has unknown status.'
=> 'Slot [_1] hat unbekannten Status',

   'Upload a file containing the slot definitions'
=> 'Hochladen einer Datei mit Slot-Definitionen',

   'Status of messages about dropped reservation'
=> 'Status der Nachrichten über verworfene Reservierung',

   'Status of messages about saved reservation'
=> 'Status der Nachrichten über gespeicherte Reservierung',

   'Status of messages about unchanged existing reservation'
=> 'Status der Nachrichten über unveränderte, bestehende Reservierung',

   'Successful reservation by [_1] for [_2].'
=> 'Erfolgreiche Reservierung durch [_1] für [_2]',

   'Successfully signed up:  [_1]'
=> 'Erfolgreich eingetragen:  [_1]',

   'Unable to understand what resource you wanted to sign up for.'
=> 'Es ist unklar, für welche Ressource Sie sich eintragen wollten.',

   'Unchanged reservation: [_1]'
=> 'Unveränderte Reservierung: [_1]',

   'Unknown command: [_1]'
=> 'Unbekannter Befehl: [_1]',

   'You need to specify the name, start time, end time and a type.'
=> 'Sie müssen Name, Anfangszeit, Endezeit und einen Typ angeben.',

   '[_1]Failed[_2] to reserve a slot for [_3].'
=> 'Das Reservieren eines Slots für [_3] ist [_1]fehlgeschlagen[_2].',

   'Click on a student to be taken to their spreadsheet'
=> 'Klicken Sie auf eine/n Studenten/in, um zu seinem/ihrem Beurteilungsbogen zu gelangen.',

   'Expire all student spreadsheets'
=> 'Alle studentischen Beurteilungsbögen ablaufen lassen',

   'Error loading spreadsheet [_1]'
=> 'Fehler beim Laden des Beurteilungsbogens [_1]',

   'Cell'
=> 'Zelle',

   'Deleted contents of cell'
=> 'Inhalt der Zell entfernen',

   'Expired spreadsheet caches for all students'
=> 'Abgelaufene Beurteilungsbogen-Caches für alle Studierende',

   'Expired spreadsheet caches for all students for symb  [_1]'
=> 'Abgelaufene Beurteilungsbogen-Caches für alle Studierende für symb [_1]',

   'Expired spreadsheet caches for student [_1]'
=> 'Abgelaufene Beurteilungsbogen-Caches für Student/in [_1]',

   'Made this spreadsheet the default'
=> 'Dieser Beurteilungsbogen wurde als Voreinstellung übernommen.',

   'for all assessments'
=> 'für alle Beurteilungen',

   'for all students'
=> 'für alle Studierende',

   'for the course'
=> 'für den Kurs',

   'An error occurred while calculating this spreadsheet'
=> 'Beim Berechnen des Beurteilungsbogens ist ein Fehler aufgetreten.',

   'This output is not supported'
=> 'Diese Ausgabe wird nicht unterstützt.',

   'Assessment title'
=> 'Beurteilungs-Titel',

   'Error computing row for assessment "[_1]" (row [_2]):[_3]'
=> 'Fehler beim Berechnen der Zeile für die Beurteilung "[_1]" (Zeile [_2]):[_3]',

   'Select spreadsheet for entire sequence'
=> 'Auswahl eines Beurteilungsbogens für die gesamte Sequenz',

   'Some computations are not available at this time.'
=> 'Einige der Berechnungen sind derzeit nicht verfügbar.',

   'There are problems whose status you are not allowed to view.'
=> 'Es gibt Probleme damit, wessen Status Sie nicht berechtigt sind zu sehen.',

   'Unavailable at this time'
=> 'Derzeit nicht verfügbar',

   'Problem weights do not reflect individual student settings.'
=> 'Die Aufgaben-Gewichtungen beziehen sich nicht auf individuelle studentische Einstellungen.',

   'Statistics on submissions from [_1] to [_2]'
=> 'Statistik über Einreichungen von [_1] bis [_2]',

   '[_1]Output as[_2] [_3]'
=> '[_1]Ausgabe als[_2] [_3]',

   'Attempt [_1], [_2] submissions, [_3] correct, [_4] incorrect'
=> 'Versuch [_1], [_2] Einreichungen, [_3] korrekt, [_4] inkorrekt',

   'Bar'
=> 'Balken',

   'Concept'
=> 'Konzept',

   'Concept Number'
=> 'Konzept-Nummer',

   'Correct Value'
=> 'Korrekter Wert',

   'Data from [_1] to [_2]'
=> 'Daten von [_1] bis [_2]',

   'Difference between submission and correct'
=> 'Unterschiede zwischen Einreichung und korrekt',

   'Distribution of correct answers'
=> 'Verteilung der korrekten Antworten',

   'Start time: [_1]'
=> 'Startzeit: [_1]',

   'End time: [_1]'
=> 'Endezeit: [_1]',

   '&nbsp;End Time: [_1]'
=> '&nbsp;Endezeit: [_1]',

   'Foil Number'
=> 'Nummer der Auswahlmöglichkeit',

   'Maximum number of coinciding values: [_1]'
=> 'Maximale Anzahl an übereinstimmenden Werten: [_1]',

   'Not enough data for concept analysis. Performing Foil Analysis instead.'
=> 'Es liegen nicht genügend Daten für eine Konzeptanalyse vor. Stattdessen wird eine Analyse der Auswahlmöglichkeiten ausgeführt.',

   'Percent Difference'
=> 'Prozent Unterschied',

   'Range'
=> 'Bereich',

   '[_1] students, [_2] distinct correct answers'
=> '[_1] Studierende, [_2] echt unterschiedlich korrekte Antworten',

   '[_1] submissions from [_2] students, [_3] correct, [_4] incorrect'
=> '[_1] Einreichungen von [_2] Studierenden, [_3] korrekt, [_4] inkorrekt',

   '[quant,_1,submission,submissions,No submissions] from [quant,_2,student], [_3] correct, [_4] incorrect'
=> '[quant,_1,Einreichung,Einreichungen,Keine Einreichungen] von [quant,_2,Student/in,Studierenden,Studierenden], [_3] korrekt, [_4] inkorrekt',

   'correct foil chosen'
=> 'korrekte Auswahlmöglichkeit ausgewählt',

   'correct option chosen'
=> 'korrekte Option ausgewählt',

   'Compiling statistics for [quant,_1,problem]'
=> 'Erstelle Statistik für [quant,_1,Aufgabe,Aufgaben]',

   'It may take some time to update the student data.'
=> 'Es kann einige Zeit dauern, bis die studentischen Daten aktualisiert sind.',

   'Sequence Statistics'
=> 'Statistik zu den Sequenzen',

   'This will take some time.'
=> 'Dies wird einen Moment dauern.',

   'Unable to plot the requested statistic.'
=> 'Die angeforderte Statistik konnte nicht geplottet werden.',

   'plot'
=> 'Plot',

   'Both anonymous and named submissions -- display: [_1]Anonymous [_2]Named[_3]'
=> 'Anonyme sowie personenbezogene Einreichungen -- Anzeige: [_1]anonym [_2]personenbezogen[_3]',

   'Error: cannot process course structure'
=> 'Fehler: Die Kursstruktur kann nicht verarbeitet werden.',

   'If a selection contains both anonymous and named parts,[_1]use the Anonymous/Named buttons to ensure selections will be either all anonymous[_1]or all named.'
=> 'Falls eine Auswahl anonyme sowie personenbezogene Teile enthält,[_1]verwenden Sie die Anonym-/Personenbezogen-Buttons, um sicherzustellen, dass Auswahlen entweder alle anonym[_1]oder alle personenbezogen sind.',

   'View data as [_1] [_2]go[_3]'
=> 'Daten ansehen als [_1] [_2]Go[_3]',

   'You must select either only anonymous or only named problems.'
=> 'Sie müssen entweder nur anonyme oder nur personenbezogene Aufgaben auswählen.',

   'Your selection includes both problems with and without anonymous submissions.'
=> 'Ihre Auswahl enthält sowohl Aufgaben mit als auch ohne anonymer Einreichungen.',

   'response'
=> 'Antwort',

   'LON-CAPA can produce [_1]CSV[_2] files of this data or Excel files of the [_1]Scores Summary[_2] data.'
=> 'LON-CAPA kann [_1]CSV[_2]-Dateien aus diesen Daten erstellen oder Excel-Dateien aus den [_1]Punktesummen[_2]-Daten.',

   'LON-CAPA is unable to produce your Excel spreadsheet because your selections will result in more than 255 columns.  Excel allows only 255 columns in a spreadsheet.'
=> 'LON-CAPA kann die gewünschte Excel-Datei nicht erstellen, da Ihre Auswahl mehr als 255 Spalten ergeben würde. Excel lässt maximal 255 Spalten in einer Tabelle zu.',

   'The last problem that will fit in the current spreadsheet is [_1].'
=> 'Die letzte Aufgabe, die in die aktuelle Tabelle passt, ist [_1].',

   'Consider selecting fewer problems to generate reports on, or reducing the number of items per problem.  Or use HTML or CSV output.'
=> 'Sie könnten weniger Aufgaben zur Erstellung des Berichts auswählen oder die Anzahl der Elemente je Aufgabe verringern. Alternativ steht Ihnen die HTML- und CSV-Ausgabe zur Verfügung.',

   'You may consider reducing the number of [_1]Sequences or Folders[_2] you have selected.'
=> 'Sie könnten die Anzahl an ausgewählten [_1]Sequenzen oder Verzeichnisse[_2] verringern.',

   'Unable to Complete Request'
=> 'Der Vorgang konnte nicht abgeschlossen werden.',

   'Unable to complete request'
=> 'Der Vorgang konnte nicht abgeschlossen werden.',

   'Anonymized'
=> 'Anonymisiert',

   'Contact a Domain Coordinator if you need the threshold to be changed for this course.'
=> 'Kontaktieren Sie einen Domänen-Koordinator, falls Sie den Schwellenwert für diesen Kurs ändern möchten.',

   'Generating CSV report of student responses'
=> 'Erstelle CSV-Bericht der studentischen Antworten',

   'Internal error'
=> 'Interner Fehler',

   'The number of students matching the selection criteria is too few for display of submission data for anonymous surveys.'
=> 'Die Anzahl Studierender, auf die die gewählte Auswahl zutrifft, ist zu gering, um Einreichungsdaten für anonyme Umfragen anzuzeigen.',

   'There must be at least [quant,_1,student].'
=> 'Es sind mindestens [quant,_1,Student/in,Studierende] notwendig.',

   'resource is undefined'
=> 'Die Ressource ist nicht definiert.',

   'Resource is undefined.'
=> 'Die Ressource ist nicht definiert.',

   'Correct Submissions (not plotted)'
=> 'Korrekte Einreichungen (nicht geplottet)',

   'Cumulative Correct of those attempting the problem (not plotted)'
=> 'Kumulativ korrekt, die die Aufgabe versucht haben (nicht geplottet)',

   'Cumulative Percent Correct of selected students (plotted)'
=> 'Kumulativ prozentual korrekt der ausgewählten Studierenden (geplottet)',

   'Cumulative Percent Correct of those attempting the problem (not plotted)'
=> 'Kumulativ prozentual korrekt, die die Aufgabe versucht haben (nicht geplottet)',

   'Submissions (plotted)'
=> 'Einreichungen (geplottet)',

   'Error: a published directory of this name exists.'
=> 'Fehler: Ein veröffentlichtes Verzeichnis mit diesem Namen existiert bereits.',

   'Error: a published file of this name exists.'
=> 'Fehler: Eine veröffentlichte Datei mit diesem Namen existiert bereits.',

   'Warning: a published directory of this name exists.'
=> 'Achtung: Ein veröffentlichtes Verzeichnis mit diesem Namen existiert bereits.',

   'Warning: a published file of this name exists.'
=> 'Achtung: Eine veröffentlichte Datei mit diesem Namen existiert bereits.',

   'Cannot cleanup this filetype'
=> 'Für diesen Dateityp ist keine Bereinigung möglich.',

   'Failed to write backup copy, [_1], FAIL'
=> 'Das Schreiben der Sicherungskopie ist fehlgeschlagen: [_1]',

   'WARNING: The metadata table does not exist in the LON-CAPA database!'
=> 'Achtung: Die Metadaten-Tabelle existiert nicht in der LON-CAPA-Datenbank!',

   'Publish with Subdirectories'
=> 'Mit Unterverzeichnissen veröffentlichen',

   'Copy failed: [_1]'
=> 'Kopiervorgang fehlgeschlagen: [_1]',

   'Failed to copy: [_1].'
=> 'Kopiervorgang fehlgeschlagen: [_1]',

   'Error! No default set.'
=> 'Fehler! Keine Voreinstellung eingetragen',

   'No default set'
=> 'Keine Voreinstellung eingetragen',

   'The Authoring Space for this resource is located on another server.'
=> 'Der Autorenbereich für diese Ressource befindet sich auf einem anderen Server.',

   'The Authoring Space for this resource is located on a different server: [_1]'
=> 'Der Autorenbereich für diese Ressource befindet sich auf einem anderen Server: [_1]',

   'Variable image source'
=> 'Variable Bildquelle',

   'Warning: the description "[_1]" will be available, even for encrypted URL'
=> 'Achtung: Die Beschreibung "[_1]" wird trotz verschlüsselter URL verfügbar sein.',

   'Custom Parameter'
=> 'Benutzerdefinierter Parameter',

   'Enter' # lonratparms.pm
=> 'Eingeben',

   'Next resource could not be displayed'
=> 'Die nächste Ressource konnte nicht angezeigt werden.',

   'Undefined condition ID: [_1]'
=> 'Undefinierte Bedingungs-ID: [_1]',

   'Error: Found the mapalias "[_1]" defined multiple times.'
=> 'Fehler: Der Ressourcen-Aliasname "[_1]" ist mehrfach definiert.',

   'Multiple use of sequence/page [_1]! The course will not function properly.'
=> 'Die Sequenz/Seite [_1] wird mehrfach verwendet! Der Kurs wird nicht korrekt funktionieren.',

   'No course data available.'
=> 'Keine Kursdaten verfügbar',

   'Resource [_1][_2]in Map [_3]' # _2: <br />
=> 'Ressource [_1][_2]in Inhaltszusammenstellung [_3]',

   'The [_1]Summary Table (Scores)[_2] option is not available for non-HTML output.'
=> 'Die Option [_1]zusammenfassende Tabelle (Punkte)[_2] ist nur für die HTML-Ausgabe verfügbar.',

   'The resource you had been accessing appears more than once in this course, and LON-CAPA has insufficient session information to determine which instance of the resource you meant.'
=> 'Die Ressource, auf die Sie zugreifen, ist mehrfach in diesem Kurs vorhanden. LON-CAPA hat nicht genügend Informationen über die aktuelle Sitzung, um entscheiden zu können, welche Instanz der Ressource Sie meinen.',

   'Please click on the instance of the resource you intended to access:'
=> 'Bitte wählen Sie eine Instanz der Ressource aus, auf die Sie zugreifen möchten:',

   'Part of ...'
=> 'Teil von...',

   'No file was checked to delete.'
=> 'Es wurde keine Datei ausgewählt, die gelöscht werden soll.',

   'Due in less than 24 hours!'
=> 'Fällig in weniger als 24 Stunden!',

   'Navigation'
=> 'Navigation',

   'Please select at least one option.'
=> 'Bitte wählen Sie mindestens eine Option aus.',

   'Select Messages'
=> 'Nachrichten auswählen',

   'A request for Authoring Space submitted on [_1] is awaiting approval'
=> 'Ein am [_1] abgesendeter Antrag auf einen Autorenbereich wartet auf Bestätigung.',

   'A request for Authoring Space submitted on [_1] has been approved.'
=> 'Ein am [_1] abgesendeter Antrag auf einen Autorenbereich wurde bestätigt.',

   'Author role request'
=> 'Antrag auf eine Autorenrolle',

   'Checking for new courses ...'
=> 'Prüfe auf neue Kurse...',

   'Checking for new roles ...'
=> 'Prüfe auf neue Rollen...',

   'Course: [_1], groups: [_2].'
=> 'Kurs: [_1], Gruppen: [_2].',

   'Courses with changes in groups'
=> 'Kurse mit Änderungen in Gruppen',

   'Courses with new groups'
=> 'Kurse mit neuen Gruppen',

   'Custom roles with privilege changes'
=> 'Benutzerdefinierte Rollen mit Änderungen der Berechtigungen',

   'Include expired'
=> 'Abgelaufene einbeziehen',

   'Exclude expired'
=> 'Abgelaufende ausschließen',

   'Existing roles now expired'
=> 'Bestehende Rollen sind nun ausgelaufen',

   'Existing course/community groups with status changes'
=> 'Bestehende Kurs-/Community-Gruppen mit Statusänderungen',

   'Existing roles with status changes'
=> 'Bestehende Rollen mit Statusänderungen',

   'Group: [_1] status now: [_2].'
=> 'Der Status der Gruppe [_1] ist nun [_2].',

   'Hide queued'
=> 'In der Warteschlange befindliche Elemente verbergen',

   'Hotlist'
=> 'Schnellzugriffsliste',

   'Hotlist options'
=> 'Optionen für die Schnellzugriffsliste',

   'However you can continue to use this role until you logout, click the "Re-Select" button, or your session has been idle for more than 24 hours.'
=> 'Sie können diese Rolle dennoch weiterverwenden, allerdings nur, bis Sie sich ausloggen, bis Sie den "Erneut auswählen"-Button klicken oder bis Ihre Sitzung mehr als 24 Stunden nicht mehr aktiv war.',

   'New roles'
=> 'Neue Rollen',

   'No changes in course/community groups'
=> 'Keine Änderungen in Kurs-/Community-Gruppen',

   'No enrollment requests currently queued awaiting approval'
=> 'Es sind derzeit keine Belegungswünsche in der Warteschlange, die auf Bestätigung warten.',

   'No new courses or communities'
=> 'Keine neuen Kurse oder Communitys',

   'No requests for courses, communities or authoring currently queued'
=> 'Es sind derzeit keine Anträge für Kurse, Communitys oder Autorenbereiche in der Warteschlange.',

   'Queued requests'
=> 'In der Warteschlange befindliche Anträge',

   'Show queued'
=> 'In Warteschlange befindliche Elemente zeigen',

   'The section has changed for your current role. Log-out and log-in again to select a role for the new section.'
=> 'Die Sektion hat sich für Ihre aktuelle Rolle geändert. Bitte loggen Sie sich aus und wieder ein, um die Rolle für die neue Sektion auszuwählen.',

   'Check for changes'
=> 'Auf Änderungen prüfen',

   'Use the "Check for changes" link to update your list of roles.'
=> 'Verwenden Sie den "Auf Änderungen prüfen"-Link, um die Auflistung Ihrer Rollen zu aktualisieren.',

   'Your current role has expired.'
=> 'Ihre derzeitige Rolle ist abgelaufen.',

   'Your role in the current course has expired.'
=> 'Ihre Rolle im derzeitigen Kurs ist abgelaufen.',

   'Your section has changed for your current [_1] role in [_2].'
=> 'Die Sektion für Ihre derzeitige Rolle [_1] in [_2] hat sich geändert.',

   '[_1] status now: [_2].'
=> 'Status von [_1] ist jetzt [_2]',

   '[_1] to continue with your new role in section ([_2]).'
=> '[_1], um mit Ihrer neuen Rolle in der Sektion [_2] fortzufahren',

   '[_1] to continue with your new section-less role.'
=> '[_1], um mit Ihrer neuen Rolle ohne Sektion fortzufahren',

   '[_1] with status: [_2].'
=> '[_1] mit Status [_2]',

   'Invalid home server for course'
=> 'Ungültiger Heimatserver für den Kurs',

   'Could not change working directory to "[_1]".'
=> 'Der Wechsel in das Arbeitsverzeichnis "[_1]" ist nicht möglich.',

   'The specified directory "[_1]" is invalid'
=> 'Das angegebene Verzeichnis "[_1]" ist ungültig.',

   'The specified directory "[_1]" is invalid.'
=> 'Das angegebene Verzeichnis "[_1]" ist ungültig.',

   'The specified file "[_1]" does not exist.'
=> 'Die angegebene Datei "[_1]" existiert nicht.',

   'There has been an error in determining the file type of [_1], please check the name.'
=> 'Beim Ermitteln des Dateityps für [_1] ist ein Fehler aufgetreten. Bitte überprüfen Sie den Namen.',

   'An error occurred.'
=> 'Es ist ein Fehler aufgetreten.',

   'Extraction failed.'
=> 'Das Entpacken ist fehlgeschlagen.',

   'Invalid file or directory name'
=> 'Ungültige/r Datei oder Verzeichnisname',

   'Client'
=> 'Client',

   'Not in a course'
=> 'Nicht in einem Kurs',

   'Problem retrieving institutional data for users in domain: [_1].'
=> 'Beim Abrufen institutioneller Daten für Benutzer der Domäne [_1] ist ein Problem aufgetreten.',

   'Function Plot Elements'
=> 'Elemente von "Function Plot"',

   'Function Plot Question'
=> '"Function Plot"-Frage',

   'Function Plot Rule Set'
=> '"Function Plot"-Regelwerk',

   'Function:'
=> 'Funktion:',

   'Relationship:'
=> 'Beziehung:',

   'Rule derivative not defined.'
=> 'Ableitungsregel nicht definiert',

   'Rule indices should only contain alphanumeric characters.'
=> 'Regel-Indizes dürfen nur alphanumerische Zeichen enthalten.',

   'Rule labels must be alphanumeric.'
=> 'Regelbeschriftungen müssen alphanumerisch sein.',

   'Rule relationship not defined.'
=> 'Regelbeziehung nicht definiert',

   'Rules Log'
=> 'Regel-Protokoll',

   'Spline indices must be unique.'
=> 'Spline-Indizes müssen eindeutig sein.',

   'Spline indices should only contain alphanumeric characters.'
=> 'Spline-Indizes dürfen nur alphanumerische Zeichen enthalten.',

   'Vector labels must be unique: [_1]'
=> 'Vektor-Beschriftungen müssen eindeutig sein: [_1]',

   'Vectors must be defined before using them for drawing vector sums: [_1]'
=> 'Vektoren müssen definiert werden, bevor sie zum Zeichnen von Vektorsummen verwendet werden können: [_1]',

#SB grades.pm
   'Bubble records'
=> 'Ankreuzfeld-Datensätze',

   'Checked in by [_1] into slot [_2]'
=> 'Aufgenommen durch [_1] in Slot [_2]',

   'Choose another version:'
=> 'Auswahl einer anderen Version:',

   'Correct answer for[_1]'
=> 'Korrekte Antwort für[_1]',

   'View of the problem for[_1]'
=> 'Anzeige der Aufgabe für[_1]',

   'Discrepancies detected for [_1][quant,_2,student][_3].'
=> 'Unstimmigkeiten für [quant,_2,Student/in,Studierende] entdeckt',

   'Failed to save data for student [_1]. Message when trying to save was: [_2]'
=> 'Das Speichern der Daten für Student/in [_1] ist fehlgeschlagen. Die Nachricht beim Speicherversuch war: [_2]',

   'Hand-graded items: points from last bubble in row'
=> 'Manuelle bewertete Elemente: Punkte vom letzten Ankreuzfeld in der Zeile',

   'If you have already graded these by bubbling sheets to indicate points awarded, [_1]what point value is assigned to a filled last bubble in each row?' # _1: <br />
=> 'Falls Sie diese bereits durch Ausfüllen des Bubblesheets bewertet haben und dadurch angegeben haben, welche Punkte vergeben werden, [_1]welche Punktzahl ist dem letzten angekreuzten Ankreuzfeld je Zeile zugewiesen?', # SB ???

   'No previous versions to show for this student'
=> 'Für diese/n Studenten/in keine vorherigen Versionen zu zeigen',

   'Number of records updated = [_1] for [quant,_2,student].'
=> 'Anzahl aktualisierter Datensätze = [_1] für [quant,_2,Student/in,Studierende]',

   "Or click the 'Grading Menu' button to start over."
=> "Oder klicken Sie auf den 'Bewertungsmenü'-Button, um noch einmal von vorne zu beginnen.",

   'Please select a grading task'
=> 'Bitte wählen Sie eine Bewertungstätigkeit',

   'Show earlier version:'
=> 'Frühere Version zeigen:',

   'The score for this question will be a sum of the numeric values for the selected bubbles from each line, where A=1 point, B=2 points etc.'
=> 'Die Punkte für diese Frage werden eine Summe aus den numerischen Werten der ausgewählten Ankreuzfelder aus jeder Zeile sein mit A=1 Punkt, B=2 Punkte, etc.',

   'The sequence to be graded contains response types which are handgraded.'
=> 'Die zu bewertende Sequenz enthält Antworttypen, die manuell bewertet werden.',

   'There are no students in section(s) [_1] with enrollment status [_2] to modify or grade.'
=> 'In der/n Sektion(en) [_1] sind keine Studierenden mit Belegungsstatus [_2], die geändert oder bewertet werden müssen.',

   'This student has submitted too many collaborators.  Maximum is [_1].'
=> 'Diese/r Student/in hat zu viele Mitarbeiter eingereicht. Das Maximum ist [_1].',

   "To assign a score of zero for this question, mark all lines as 'No bubble'."
=> "Um für dieser Frage null Punkte zuzuweisen, markieren Sie alle Zeilen mit 'Kein Ankreuzfeld'.",

   '[_1]Corrections[_2], a file of corrected records that were used in grading.'
=> '[_1]Korrekturen[_2] - eine Datei mit korrekten Datensätzen, die in der Bewertung verwendet wurden',

   '[_1]Original[_2] file as uploaded by the bubblesheet scanning office.'
=> '[_1]Originaldatei[_2] - die Datei, wie sie von der Person, die die Bubblesheets gescannt hat, hochgeladen wurde',

   '[_1]Skipped[_2], a file of records that were skipped.'
=> '[_1]Ausgelassen[_2] - eine Datei mit Datensätzen, die ausgelassen wurden',

   '[quant,_1,point]'
=> '[quant,_1,Punkte,Punkte]',

   '0 points'
=> '0 Punkte',

   'Ignore'
=> 'Ignorieren',

   'this error'
=> 'dieses Fehlers', # ! grades.pm

   'Skip'
=> 'Auslassen',

   'this scanline saving it for later.' # 'Skip' ...
=> 'dieser gescannten Zeile, um sie später zu verarbeiten', # ! grades.pm

   'using corrected info' # 'Continue' ...
=> 'mit Verwendung der korrigierten Informationen', # ! grades.pm

   'An error: [_1] occurred saving your changes'
=> 'Beim Speichern Ihrer Änderungen ist ein Fehler aufgetreten: [_1]',

   '(Bubble once in [_1] lines)'
=> '(Einmal ankreuzen alle [_1] Zeilen)', # SB ???

   '(first line)'
=> '(erste Zeile)',

   '(next line)'
=> '(nächste Zeile)',

   'Access requires reservation to work at specific time/place.'
=> 'Um Zugriff zu erhalten, ist eine Reservierung zum Arbeiten zu einer bestimmten Zeit / an einem bestimmten Ort erforderlich.',

   'Available to make a reservation.'
=> 'Verfügbar, um eine Reservierung vornehmen zu können',

   'Not available to make a reservation.'
=> 'Nicht verfügbar, um eine Reservierung vornehmen zu können',

   'Closed'
=> 'Geschlossen',

   'Criteria Grading'
=> 'Criteria Grading', # SB ???

   'Reservation window closes [_1].'
=> 'Das Reservierungs-Zeitfenster schließt am [_1].',

   'Window to make a reservation will open [_1].'
=> 'Das Zeitfenster zum Vornehmen einer Reservierung wird am [_1] öffnen.',

   "Cannot annotate current window. Please point your browser to a LON-CAPA page and then 'continue'."
=> "Für das aktuelle Fenster können keine Anmerkungen vorgenommen werden. Bitte wählen Sie in Ihrem Browser eine LON-CAPA-Seite und dann 'Weiter'.",

   'Modification of Course Contents Disallowed'
=> 'Ändern der Kursinhalte nicht gestattet',

   'Enroll all users'
=> 'Alle Benutzer Kurs belegen lassen',

   'Enroll students only'
=> 'Nur Studierende den Kurs belegen lassen',

   'Import topics + posts (no author)'
=> 'Themen und Diskussionsbeiträge importieren (ohne Autor)',

   'Import topics + posts (with author)'
=> 'Themen und Diskussionsbeiträge importieren (mit Autor)',

   'Import topics only'
=> 'Nur Themen importieren',

   'You must check at least one Content Type.'
=> 'Sie müssen mindestens einen Inhaltstypen auswählen.',

   'You must select one of the additional options when importing Discussion Boards.'
=> 'Um Diskussionsforen importieren zu können, müssen Sie eine der zusätzlichen Optionen auswählen.',

   'You must select one of the additional options when importing Enrollment.'
=> 'Um Kursbelegungen importieren zu können, müssen Sie eine der zusätzlichen Optionen auswählen.',

   'You must select a target course when importing enrollment information.'
=> 'Um Kursbelegungs-Informationen importieren zu können, müssen Sie eine der zusätzlichen Optionen auswählen.',

   'You must select a target course when importing Discussion Boards.'
=> 'Um Diskussionsforen importieren zu können, müssen Sie einen Zielkurs auswählen.',

   'Other css'
=> 'Anderes CSS',

   'Sum of likes/dislikes'
=> 'Summe von "Gefällt mir" / "Gefällt mir nicht"',

   'One sigma above mean'
=> 'Ein Sigma über dem Mittelwert',

   'One sigma below mean'
=> 'Ein Sigma unterhalb des Mittelwerts',

   'Two sigma above mean'
=> 'Zwei Sigma über dem Mittelwert',

   'Two sigma below mean'
=> 'Zwei Sigma unterhalb des Mittelwerts',

   'Within one sigma of mean'
=> 'Innerhalb eines Sigmas des Mittelwerts',

   'CAPTCHA validation'
=> 'CAPTCHA-Validierung',

   '"Contact helpdesk" CAPTCHA validation'
=> '"Helpdesk kontaktieren"-CAPTCHA-Validierung',

   'CAPTCHA validation (e-mail as username)'
=> 'CAPTCHA-Validierung (E-Mail-Adresse als Benutzerkennung)',

   'No CAPTCHA validation in use for helpdesk form.'
=> 'Keine CAPTCHA-Validierung für das Helpdesk-Formular in Verwendung',

   'No CAPTCHA validation in use for self-creation screen.'
=> 'Keine CAPTCHA-Validierung für den Selbsterstellungs-Bildschirm in Verwendung',

   'ReCAPTCHA keys changes'
=> 'ReCAPTCHA-Schlüsseländerungen',

   'original (CAPTCHA)'
=> 'original (CAPTCHA)',

   'successor (ReCAPTCHA)'
=> 'Nachfolger (ReCAPTCHA)',

   '(or later)'
=> '(oder später)',

   'Access available for the following specified IP addresses: '
=> 'Zugriff für die folgenden angegebenen IP-Adressen möglich: ',

   'Access available for the following specified users: '
=> 'Zugriff für die folgenden angegebenen Benutzer möglich: ',

   'Access terminated for all specific (named) users'
=> 'Zugriff für alle angegebenen Benutzer (mit Name) aufgehoben',

   'Access terminated for all specific IP addresses'
=> 'Zugriff für alle angegebenen IP-Adressen aufgehoben',

   'Accounts may not be created by users self-enrolling with e-mail addresses of the following types: '
=> 'Accounts können nicht von Benutzern erstellt werden, die sich mit einer E-Mail-Adresse folgenden Typs selbst eintragen: ',

   'Add log-in help page for a specific language:'
=> 'Login-Hilfeseite für eine bestimmte Sprache hinzufügen:',

   'Added categories:'
=> 'Hinzugefügte Kategorien:',

   'Deleted categories:'
=> 'Gelöschte Kategorien:',

   'Reordered categories:'
=> 'Neu geordnete Kategorien:',

   'Advanced users from [_1]'
=> 'Erweiterte Benutzer von [_1]',

   'All users from [_1]'
=> 'Alle Benutzer von [_1]',

   'Although account creation has been set to be available for institutional logins, currently default authentication in this domain has not been set to support this.'
=> 'Die Account-Erstellung für institutionelle Logins wurde zwar aktiviert. Derzeit ist jedoch die voreingestellte Authentifizierung für diese Domäne nicht so eingestellt, dass die Account-Erstellung möglich ist.',

   'An error occurred saving access settings for server status pages: [_1].'
=> 'Beim Speichern der Zugriffseinstellungen für die Serverstatus-Seiten ist ein Fehler aufgetreten: [_1].',

   'An error occurred storing the settings: [_1]'
=> 'Beim Speichern der Einstellungen ist ein Fehler aufgetreten: [_1]',

   'An error occurred updating the domain configuration: [_1]'
=> 'Beim Aktualisieren der Domänen-Konfiguration ist ein Fehler aufgetreten: [_1]',

   'An error occurred: [_1]'
=> 'Es ist ein Fehler aufgetreten: [_1]',

   'An error occurred: [_1].'
=> 'Es ist ein Fehler aufgetreten: [_1]',

   'Authentication types available for assignment to new users'
=> 'Verfügbare Authentifizierungstypen für die Zuweisung an neue Benutzer',

   'Display link to: [_1]?'
=> 'Link zu [_1] anzeigen?',

   'Domain configuration settings have yet to be saved for this domain via the web-based domain preferences interface.'
=> 'Die Domänen-Konfigurations-Einstellungen müssen für diese Domäne noch über das webbasierte Domänen-Einstellungs-Interface gespeichert werden.',

   'Failed to copy file to RES space'
=> 'Das Kopieren der Datei in den Ressourcen-Bereich ist fehlgeschlagen.',

   'Failed to copy old meta'
=> 'Das Kopieren der alten Metadaten ist fehlgeschlagen.',

   'Failed to create file'
=> 'Das Erstellen der Datei ist fehlgeschlagen.',

   'Failed to write file'
=> 'Das Schreiben der Datei ist fehlgeschlagen.',

   'Filename is a directory name - rename the file and re-upload'
=> 'Der Dateiname ist der Name eines Verzeichnisses. Benennen Sie die Datei um und laden Sie sie erneut hoch.',

   'File unavailable for display'
=> 'Die Datei steht zur Anzeige nicht zur Verfügung',

   "However, you will still need to switch to the domain's primary library server to upload new images or logos."
=> 'Dennoch müssen Sie noch zum primären Library-Server der Domäne wechseln, um neue Bilder oder Logos hochladen zu können.',

   'IDs with the following formats are restricted to verified users in the institutional directory: '
=> 'IDs mit folgenden Formaten sind beschränkt auf verifizierte Benutzer im Institutionsverzeichnis: ',

   'Invalid file extension ([_1]) - reserved for internal use.'
=> 'Ungültige Dateinamenserweiterung ([_1]) - für interne Verwendung reserviert.',

   'LON-CAPA bug tracker'
=> 'LON-CAPA-Bug-Tracker',

   'Stop balancing'
=> 'Lastverteilung beenden',

   'Add balancer:'
=> 'Balancer hinzufügen:',

   'Enable balancer:'
=> 'Balancer aktivieren:',

   'Load Balancer: [_1] -- balancing for [_2] set to - "[_3]"'
=> 'Load-Balancer: [_1] -- Lastverteilung für [_2] eingestellt auf "[_3]"',

   'Load Balancing discontinued for: [_1]'
=> 'Lastverteilung für [_1] gestoppt',

   'Load Balancing enabled for: [_1]'
=> 'Lastverteilung für [_1] aktiviert',

   'No changes made to Load Balancer settings.'
=> 'An den Einstellungen zum Load-Balancer wurden keine Änderungen vorgenommen.',

   'No existing load balancer'
=> 'Es existiert kein Load-Balancer.',

   "Servers to which Load Balance server offloads set to 'None', by default"
=> "Server, an die der Load-Balancing-Server die Last verteilt, gesetzt auf 'keine' (voreingestellt)",

   "Offloads to Load Balancer in user's domain"
=> 'Offloading an Load-Balancer in der Domäne des Benutzers',

   'By default, Load Balancer: [_1] set to offload to - [_2]'
=> 'Voreingestellt ist der Load-Balancer [_1] eingestellt, dass er nach [_2] umleitet',

   'Session hosted on Load Balancer, after re-authentication'
=> 'Auf dem Load-Balancer gehostete Sitzung nach erneuter Authentifizierung',

   'Session hosted on offload server, after re-authentication'
=> 'Auf dem Offload-Server gehostete Sitzung nach erneuter Authentifizierung',

   'No changes made to settings for user session hosting/offloading.'
=> 'An den Einstellungen zum Hosting von Benutzersitzungen / Offloading wurden keine Änderungen vorgenommen.',

   'Offloads to:'
=> 'Offloading nach:',

   'offload to [_1]'
=> 'Offloading nach [_1]',

   'Session offloading controlled by domain: [_1]'
=> 'Sitzungs-Offloading wird durch die Domäne [_1] geregelt',

   'No offload'
=> 'Kein Offloading',

   'Offloads to default destinations'
=> 'Offloading an voreingestellte Ziele',

   'Offloads to specific server'
=> 'Offloading an bestimmten Server',

   "Offloads to user's home server"
=> 'Offloading an den Heimatserver des Benutzers',

   'Servers offloaded to, when busy'
=> 'Server, an die die Last verteilt werden soll, falls Überlast auftritt',

   'Servers to offload sessions to when busy'
=> 'Server für das Offloading von Benutzersitzungen, falls Überlast auftritt',

   '[_1] when busy, offloads to:'
=> 'Falls [_1] überlastet ist, Last verteilen nach:',

   'Log-in help page for language: [_1] is [_2]'
=> 'Login-Hilfeseite für die Sprache [_1] ist [_2]',

   'Log-in help page if no specific language file: [_1]'
=> 'Login-Hilfeseite, falls keine spezielle Sprachdatei angegeben ist: [_1]',

   'No changes made to rights to request author space.'
=> 'An den Berechtigungen zum Beantragen eines Autorenbereichs wurden keine Änderungen vorgenommen.',

   'No changes made to user creation settings'
=> 'An den Einstellungen zur Benutzererstellung wurden keine Änderungen vorgenommen.',

   'No write permission to Authoring Space'
=> 'Keine Schreibberechtigung auf Autorenbereich',

   'Nothing to set here, as the cluster to which this domain belongs only contains one institution.'
=> 'Keine Einstellungen möglich, da der Cluster, zu dem diese Domäne gehört, nur aus einer einzigen Institution besteht.',

   'Nothing to set here, as the cluster to which this domain belongs only contains one server.'
=> 'Keine Einstellungen möglich, da der Cluster, zu dem diese Domäne gehört, nur einen einzigen Server enthält.',

   'Other users from [_1]'
=> 'Andere Benutzer von [_1]',

   'Portfolio default quotas'
=> 'Voreingestellter Speicherplatz der Portfolios',

   'Private key'
=> 'Privater Schlüssel',

   'Public key'
=> 'Öffentlicher Schlüssel',

   'Private key deleted'
=> 'Privater Schlüssel gelöscht',

   'Private key set to [_1]'
=> 'Privater Schlüssel gesetzt auf [_1]',

   'Public key deleted'
=> 'Öffentlicher Schlüssel gelöscht',

   'Public key set to [_1]'
=> 'Öffentlicher Schlüssel gesetzt auf [_1]',

   'Set to be unavailable to [_1]'
=> 'Eingestellt auf nicht verfügbar für [_1]',

   'Target user with [_1] role'
=> 'Zielbenutzer mit Rolle [_1]',

   'The following errors occurred: '
=> 'Folgende Fehler sind aufgetreten: ',

   'The following were left unchanged because the values entered were invalid:'
=> 'Die folgenden Werte wurden nicht geändert, da die eingegebenen Werte ungültig sind:',

   'There are now no ID formats restricted to verified users in the institutional directory.'
=> 'In dem Institutionsverzeichnis gibt es keine ID-Format-Einschränkungen für bestätigte Benutzer.',

   'There are now no restrictions on e-mail addresses which may be used as a username when self-enrolling.'
=> 'Für E-Mail-Adressen als Benutzerkennung für die Selbsteintragung bestehen ab jetzt keine Beschränkungen mehr.',

   'There are now no username formats restricted to verified users in the institutional directory.'
=> 'Für das Format der Benutzerkennungen verifizierter Benutzer des Institutionsverzeichnisses bestehen ab jetzt keine Beschränkungen mehr.',

   'Thereafter, (with a Domain Coordinator role selected in the domain) you will be able to update settings when logged in to any server in the LON-CAPA network.'
=> 'Nun können Sie mit ausgewählter Domänen-Koordinator-Rolle in Ihrer Domäne die Einstellungen aktualisieren, wenn Sie auf einem beliebigen Server im LON-CAPA-Netzwerk eingeloggt sind.',

   "Updates for '[_1]' set to: '[_2]'"
=> "Aktualisierungen für '[_1]' geändert auf '[_2]'",

   'Upload of [_1] failed because a Domain Configuration user ([_2]) could not be created in domain: [_3].  Error was: [_4].'
=> 'Das Hochladen von [_1] ist fehlgeschlagen, da ein Domänen-Konfigurations-Benutzer ([_2]) in der Domäne [_3] nicht erstellt werden konnte. Der Fehler war: [_4]',

   'Upload of [_1] failed because an author role could not be assigned to a Domain Configuration user ([_2]) in domain: [_3].  Error was: [_4].'
=> 'Das Hochladen von [_1] ist fehlgeschlagen, da eine Autorenrolle nicht an einen Domänen-Konfigurations-Benutzer ([_2]) in der Domäne [_3] zugewiesen werden konnte. Der Fehler war: [_4]',

   'Upload of [_1] failed because an error occurred publishing the file in RES space. Error was: [_2].'
=> 'Das Hochladen von [_1] ist fehlgeschlagen, da beim Veröffentlichen der Datei im Ressourcenpool ein Fehler aufgetreten ist. Der Fehler war: [_2].',

   'Upload of custom log-in help file(s) failed because a Domain Configuration user ([_1]) could not be created in domain: [_2].  Error was: [_3].'
=> 'Das Hochladen benutzerdefinierter Login-Hilfeseiten-Datei(en) ist fehlgeschlagen, da ein Domänen-Konfigurations-Benutzer ([_1]) in der Domäne [_2] nicht erstellt werden konnte. Der Fehler war: [_3]',

   'Upload of custom log-in help file(s) failed because an author role could not be assigned to a Domain Configuration user ([_1]) in domain: [_2].  Error was: [_3].'
=> 'Das Hochladen benutzerdefinierter Login-Hilfeseiten-Datei(en) ist fehlgeschlagen, da eine Autorenrolle nicht an einen Domänen-Konfigurations-Benutzer ([_1]) in der Domäne [_2] zugewiesen werden konnte. Der Fehler war: [_3]',

   'Upload to library server: [_1]'
=> 'Hochladen auf Library-Server: [_1]',

   'Usernames with the following formats are restricted to verified users in the institutional directory: '
=> 'Benutzerkennungen mit den folgenden Formaten sind beschränkt auf verifizierte Benutzer im Institutionsverzeichnis: ',

   'Users from [_1] with author role'
=> 'Benutzer von [_1] mit Autorenrolle',

   "Users from domain '[_1]' permitted to search the institutional directory set to: [_2]"
=> "Benutzer der Domäne '[_1]', denen es gestattet ist, im Institutionsverzeichnis zu suchen, geändert auf: [_2]",

   'Users not from [_1]'
=> 'Benutzer nicht von [_1]',

   'Users not from [_1], but from [_2]'
=> 'Benutzer nicht von [_1], aber von [_2]',

   "While this remains so, you must switch to the domain's primary library server in order to update settings."
=> 'Während dies so bleibt, müssen Sie zum primären Library-Server der Domäne wechseln, um Einstellungen aktualisieren zu können.',

   'You need to set the default authentication type to Kerberos 4 or 5 (with a Kerberos domain specified), or to Local authentication, if the localauth module has been customized in your domain to authenticate institutional logins.'
=> 'Sie müssen den voreingestellten Authentifizierungstyp auf Kerberos 4 oder 5 (unter Angabe einer Kerberos-Domäne) oder auf lokale Authentifizierung setzen, falls Sie das "localauth"-Modul in Ihrer Domäne zur Authentifizierung von institutionellen Logins konfiguriert haben.',

   'creation of a new user account is not permitted.'
=> 'Das Erstellen eines neuen Benutzeraccounts ist nicht gestattet.',

   'Self creation of a new user account is not permitted.'
=> 'Das Selbsterstellen eines neuen Benutzeraccounts ist nicht gestattet.',

   'creation of new users is not permitted, except by a Domain Coordinator.'
=> 'Das Erstellen neuer Benutzer ist nicht gestattet. Das darf nur ein Domänen-Koordinator.',

   'creation of new users is only permitted for institutional usernames.'
=> 'Das Erstellen neuer Benutzer ist nur für institutionelle Benutzerkennungen gestattet.',

   'creation of new users is only permitted for non-institutional usernames.'
=> 'Das Erstellen neuer Benutzer ist nur für nicht-institutionelle Benutzerkennungen gestattet.',

   'creation of new users is permitted for both institutional and non-institutional usernames.'
=> 'Das Erstellen neuer Benutzer ist für institutionelle sowie für nicht-institutionelle Benutzerkennungen gestattet.',

   'custom log-in help file for no preferred language'
=> 'benutzerdefinierte Login-Hilfeseite-Datei für keine bevorzugte Sprache',

   'custom log-in help file for specific language: [_1]'
=> 'benutzerdefinierte Login-Hilfeseite-Datei für spezielle Sprache [_1]',

   'custom log-in help file removed for no preferred language; [_1]'
=> 'benutzerdefinierte Login-Hilfeseite-Datei für keine bevorzugte Sprache entfernt; [_1]',

   'custom log-in help file removed for specific language: [_1]; [_2]'
=> 'benutzerdefinierte Login-Hilfeseite-Datei für spezielle Sprache [_1] entfernt; [_2]',

   'modifiable fields: '
=> 'änderbare Felder: ',

   'to primary library server for domain: [_1]'
=> 'für primären Library-Server der Domäne [_1]',

   'Automatic approval'
=> 'Automatische Bestätigung',

   'Primary (checked first)'
=> 'Primär (als erster ausgewählt)',

   'primary'
=> 'primär',

   'WebDAV'
=> 'WebDAV',

   'Last Action:'
=> 'Letzte Aktion:',

   'Domain server'
=> 'Domänen-Server',

   'Defaults which can be overridden in each course by a CC'
=> 'Voreingestellte Werte, die in jedem Kurs von einem Kurs-Koordinator überschrieben werden können.',

   'Add new [_1]primary[_2]:'
=> 'Neuen [_1]Primär-Server[_2] hinzufügen:',

   'Add new [_1]default[_2]:'
=> 'Neuen [_1]voreingestellten Server[_2] hinzufügen:',

   'Dedicated Load Balancer'
=> 'Dedizierter Load-Balancer',

   'Dedicated Load Balancer(s)'
=> 'Dedizierte(r) Load-Balancer',

   'Balancers'
=> 'Balancer',

   'Default destinations'
=> 'Voreingestellte Ziele',

   'Overrides'
=> 'Überschrieben',

   'Announcement posted to [_1]'
=> 'Bekanntmachung gesendet an [_1]',

   'Posting announcement to [_1] failed: [_2]'
=> 'Das Senden der Bekanntmachung an [_1] ist fehlgeschlagen: [_2]',

   '(in: [_1])'
=> '(in [_1])',

   'All users -- time limit: [_1]'
=> 'Alle Benutzer -- Zeitlimit: [_1]',

   '[_1] -- time limit: [_2]'
=> '[_1] -- Zeitlimit: [_2]',

   'Choose trigger'
=> 'Auslöser auswählen',

   'Triggered by Activating Timer'
=> 'Ausgelöst durch Timeraktivierung',

   'No timed items defined.'
=> 'Keine zeitgesteuerten Elemente festgelegt',

   'Timer folder/resource not in course'
=> 'Zeitgesteuerte(s) Verzeichnis/Ressource nicht im Kurs',

   'Timer for all items in course'
=> 'Timer für alle Elemente im Kurs',

   'Timer for all items in course.'
=> 'Timer für alle Elemente im Kurs',

   'Timer for all items in folder: [_1]'
=> 'Timer für alle Elemente im Verzeichnis [_1]',

   'Timer for resource: [_1]'
=> 'Timer für Ressource [_1]',

   'Use [_1]Settings[_2] to assign a timer, then return here.'
=> 'Gehen Sie nach [_1]Einstellungen[_2] zum Zuweisen eines Timers und kehren Sie anschließend nach hier zurück.',

   '[_1] days'
=> '[_1] Tage',

   '[_1] hours'
=> '[_1] Stunden',

   '[_1] minutes'
=> '[_1] Minuten',

   '[_1] seconds'
=> '[_1] Sekunden',

   'Invalid trigger for new blocking event'
=> 'Ungültiger Auslöser für neues Sperrungsereignis',

   'No date range found for new blocking event'
=> 'Kein Zeitfenster für neues Sperrungsereignis gefunden',

   '[quant,_1,blocking event was,blocking events were] added.'
=> '[quant,_1,Sperrungsereignis wurde,Sperrungsereignisse wurden] hinzugefügt',

   '[quant,_1,blocking event was,blocking events were] modified.'
=> '[quant,_1,Sperrungsereignis wurde,Sperrungsereignisse wurden] geändert',

   '[quant,_1,blocking event was,blocking events were] removed.'
=> '[quant,_1,Sperrungsereignis wurde,Sperrungsereignisse wurden] entfernt',

   'Add new blocking event'
=> 'Neues Sperrungsereignis hinzufügen',

   'Modify existing blocking event(s)'
=> 'Bestehende Sperrungsereignisse ändern',

   'There are no blocking events currently saved.'
=> 'Derzeit gibt es keine gespeicherten Sperrungsereignisse.',

   'Blocking communication and/or content access during exams'
=> 'Kommunikationssperre und/oder Inhaltszugriffssperre während Prüfungen',

   "Portfolio blocking can impact a student's ability to complete assignments in courses besides your own. Please use this feature wisely."
=> 'Portfolio-Sperren können sich auf die Möglichkeit für Studierende auswirken, ihre Aufgaben im Kurs zu bearbeiten. Bitte verwenden Sie diese Einstellung mit Vorsicht.',

   'accessing course content in specified folders or resources'
=> 'auf Kursinhalt in angegebenen Verzeichnissen und Ressourcen zugreifen',

   'accessing community content in specified folders or resources'
=> 'auf Community-Inhalt in angegebenen Verzeichnissen und Ressourcen zugreifen',

   'accessing content in LON-CAPA portfolios or blogs'
=> 'auf Inhalt in LON-CAPA-Portfolios und -Blogs zugreifen',

   'displaying LON-CAPA messages sent by other students in the course'
=> 'zeigen von LON-CAPA-Nachrichten, die von anderen Studierenden des Kurses gesendet wurden',

   'displaying LON-CAPA messages sent by other members in the community'
=> 'zeigen von LON-CAPA-Nachrichten, die von anderen Mitgliedern der Community gesendet wurden',

   'displaying or posting to LON-CAPA discussion boards or live chat in the course'
=> 'zeigen oder senden an LON-CAPA-Diskussionsforen oder Chats im Kurs',

   'displaying or posting to LON-CAPA discussion boards or live chat in the community'
=> 'zeigen oder senden an LON-CAPA-Diskussionsforen oder Chats in der Community',

   'generating printouts of course content'
=> 'erstellen von Ausdrücken des Kursinhalts',

   'generating printouts of community content'
=> 'erstellt Ausdrücke des Community-Inhalts',

   'Action to take:'
=> 'Vorzunehmende Aktion:',

   'Blocks can potentially interrupt legitimate communication between students who are also both enrolled in a different LON-CAPA course.'
=> 'Sperren können grundsätzlich zulässige Kommunikation zwischen Studierenden verhindern, die auch noch in einen anderen LON-CAPA-Kurs eingetragen sind.',

   'Blocks can potentially interrupt legitimate communication between members who are also both enrolled in a different LON-CAPA community.'
=> 'Sperren können grundsätzlich zulässige Kommunikation zwischen Studierenden verhindern, die auch noch in eine andere LON-CAPA-Community eingetragen sind.',

   'Choose dates'
=> 'Datumswerte auswählen',

   'When using defined start/end times for an event, please set dates carefully.'
=> 'Bitte seien Sie beim Festlegen der Start-/Endzeiten für ein Ereignis vorsichtig.',

   'Defined Start/End'
=> 'Start/Ende festlegen',

   'For the duration of an exam, or a timed quiz, students in this course can be prevented from:'
=> 'Während einer Prüfung oder eines zeitgesteuerten Quizzes können Studierende dieses Kurses von Folgendem abgehalten werden:',

   'Less ...'
=> 'weniger...',

   'More ...'
=> 'mehr...',

   'Printouts'
=> 'Ausdrücke',

   'Unable to retrieve contents of course.'
=> 'Der Inhalt des Kurses konnte nicht abgerufen werden.',

   ' (triggered by you when starting timer)'
=> ' (ausgelöst durch Ihr Starten des Timers)',

   'Error: unknown activity type blocked'
=> 'Fehler: unbekannter Aktivitätstyp gesperrt',

   'Information about the owner of the portfolio files you were trying to view was missing or invalid.'
=> 'Die Informationen über den Eigentümer der Portfolio-Dateien, die Sie versucht haben zu betrachten, fehlen oder sind ungültig.',

   'Without valid owner information, the reason why access is blocked can not be determined'
=> 'Ohne gültige Informationen über den Eigentümer kann der Grund der Zugriffssperre nicht festgestellt werden.',

   'Add as folder'
=> 'Als Verzeichnis hinzufügen',

   'All items in the archive file already exist, and no overwriting of existing files has been requested.'
=> 'Alle Elemente in der Archivdatei existieren bereits und es war kein Überschreiben bestehender Elemente gewünscht.',

   'An error occurred during extraction from the archive file.'
=> 'Beim Entpacken aus der Archivdatei ist ein Fehler aufgetreten.',

   'Archive file not found.'
=> 'Archivdatei nicht gefunden',

   'Content Access Blocked'
=> 'Inhaltszugriff gesperrt',

   'Could not determine home server for course.'
=> 'Der Heimatserver des Kurses konnte nicht festgestellt werden.',

   'Course home server failed to retrieve:'
=> 'Abrufen des Heimatservers des Kurses ist fehlgeschlagen:',

   'Directory containing archive file unavailable.'
=> 'Das Verzeichnis mit der Archivdatei ist nicht verfügbar.',

   'The username you chose matches the format of usernames defined for [_1], but the username does not exist in the institutional directory.'
=> 'Die von Ihnen angegebene Benutzerkennung entspricht dem Format der Benutzerkennungen, die für [_1] festgelegt wurden, jedoch ist die Benutzerkennung nicht im Institutionsverzeichnis vorhanden.',

   'The usernames you chose match the format of usernames defined for [_1], but the usernames do not exist in the institutional directory.'
=> 'Die von Ihnen angegebenen Benutzerkennungen entsprechen dem Format der Benutzerkennungen, die für [_1] festgelegt wurden, jedoch sind die Benutzerkennungen nicht im Institutionsverzeichnis vorhanden.',

   'The ID you chose matches the format of IDs defined for [_1], but the ID does not exist in the institutional directory.'
=> 'Die von Ihnen angegebene ID entspricht dem Format der IDs, die für [_1] festgelegt wurden, jedoch ist die ID nicht im Institutionsverzeichnis vorhanden.',

   'The IDs you chose match the format of IDs defined for [_1], but the IDs do not exist in the institutional directory.'
=> 'Die von Ihnen angegebenen IDs entsprechen dem Format der IDs, die für [_1] festgelegt wurden, jedoch sind die IDs nicht im Institutionsverzeichnis vorhanden.',

   "Either upload a file which includes a username with a different format --  one that will not conflict with 'official' institutional usernames, or when associating fields with data columns, omit an association for the Student/Employee ID field."
=> "Laden Sie entweder eine Datei hoch, die eine Benutzerkennung in einem anderen Format enthält (eine, die nicht in Konflikt mit 'offiziellen' institutionellen Benutzerkennungen steht) oder - falls Sie Felder mit Datenzeilen verknüpfen - lassen Sie die Verknüpfung mit dem Feld 'Studierenden-/Mitarbeiter-ID' weg.",

   "Either upload a file which includes usernames with a different format --  ones that will not conflict with 'official' institutional usernames, or when associating fields with data columns, omit an association for the Student/Employee ID field."
=> "Laden Sie entweder eine Datei hoch, die Benutzerkennungen in einem anderen Format enthält (welche, die nicht in Konflikt mit 'offiziellen' institutionellen Benutzerkennungen stehen) oder - falls Sie Felder mit Datenzeilen verknüpfen - lassen Sie die Verknüpfung mit dem Feld 'Studierenden-/Mitarbeiter-ID' weg.",

   "Either upload a file which includes an ID with a different format --  one that will not conflict with 'official' institutional IDs, or when associating fields with data columns, omit an association for the Student/Employee ID field."
=> "Laden Sie entweder eine Datei hoch, die eine ID in einem anderen Format enthält (eine, die nicht in Konflikt mit 'offiziellen' institutionellen IDs steht) oder - falls Sie Felder mit Datenzeilen verknüpfen - lassen Sie die Verknüpfung mit dem Feld 'Studierenden-/Mitarbeiter-ID' weg.",

   "Either upload a file which includes IDs with a different format --  ones that will not conflict with 'official' institutional IDs, or when associating fields with data columns, omit an association for the Student/Employee ID field."
=> "Laden Sie entweder eine Datei hoch, die IDs in einem anderen Format enthält (welche, die nicht in Konflikt mit 'offiziellen' institutionellen IDs stehen) oder - falls Sie Felder mit Datenzeilen verknüpfen - lassen Sie die Verknüpfung mit dem Feld 'Studierenden-/Mitarbeiter-ID' weg.",

   "You must choose a username with a different format --  one that will not conflict with 'official' institutional usernames."
=> "Sie müssen eine Benutzerkennung in einem anderen Format wählen - eine, die nicht in Konflikt mit 'offiziellen' institutionellen Benutzerkennungen steht.",

   "You must choose usernames with a different format --  ones that will not conflict with 'official' institutional usernames."
=> "Sie müssen Benutzerkennungen in einem anderen Format wählen - welche, die nicht in Konflikt mit 'offiziellen' institutionellen Benutzerkennungen stehen.",

   "You must choose an ID with a different format --  one that will not conflict with 'official' institutional IDs."
=> "Sie müssen eine ID in einem anderen Format wählen - eine, die nicht in Konflikt mit 'offiziellen' institutionellen IDs steht.",

   "You must choose IDs with a different format --  ones that will not conflict with 'official' institutional IDs."
=> "Sie müssen IDs in einem anderen Format wählen - welche, die nicht in Konflikt mit 'offiziellen' institutionellen IDs stehen.",

   "You must either choose a username with a different format --  one that will not conflict with 'official' institutional usernames, or leave the ID field blank."
=> "Sie müssen entweder eine Benutzerkennung in einem anderen Format wählen (eine, die nicht in Konflikt mit 'offiziellen' institutionellen Benutzerkennungen steht) oder das ID-Feld leer lassen.",

   "You must either choose usernames with a different format --  ones that will not conflict with 'official' institutional usernames, or leave the ID field blank."
=> "Sie müssen entweder Benutzerkennungen in einem anderen Format wählen (welche, die nicht in Konflikt mit 'offiziellen' institutionellen Benutzerkennungen stehen) oder das ID-Feld leer lassen.",

   "You must either choose an ID with a different format --  one that will not conflict with 'official' institutional IDs, or leave the ID field blank."
=> "Sie müssen entweder eine ID in einem anderen Format wählen (eine, die nicht in Konflikt mit 'offiziellen' institutionellen IDs steht) oder das ID-Feld leer lassen.",

   "You must either choose IDs with a different format --  ones that will not conflict with 'official' institutional IDs, or leave the ID field blank."
=> "Sie müssen entweder IDs in einem anderen Format wählen (welche, die nicht in Konflikt mit 'offiziellen' institutionellen IDs stehen) oder das ID-Feld leer lassen.",

   "You will need to modify your upload file so it will include a username with a different format --  one that will not conflict with 'official' institutional usernames."
=> "Sie müssen die von Ihnen hochgeladene Datei anpassen, so dass sie eine Benutzerkennung in einem anderen Format enthält (eine, die nicht in Konflikt mit 'offiziellen' institutionellen Benutzerkennungen steht).",

   "You will need to modify your upload file so it will include usernames with a different format --  ones that will not conflict with 'official' institutional usernames."
=> "Sie müssen die von Ihnen hochgeladene Datei anpassen, so dass sie Benutzerkennungen in einem anderen Format enthält (welche, die nicht in Konflikt mit 'offiziellen' institutionellen Benutzerkennungen stehen).",

   "You will need to modify your upload file so it will include an ID with a different format --  one that will not conflict with 'official' institutional IDs."
=> "Sie müssen die von Ihnen hochgeladene Datei anpassen, so dass sie eine ID in einem anderen Format enthält (eine, die nicht in Konflikt mit 'offiziellen' institutionellen IDs steht).",

   "You will need to modify your upload file so it will include IDs with a different format --  ones that will not conflict with 'official' institutional IDs."
=> "Sie müssen die von Ihnen hochgeladene Datei anpassen, so dass sie IDs in einem anderen Format enthält (welche, die nicht in Konflikt mit 'offiziellen' institutionellen IDs stehen).",

   'Filename not a supported archive file type.'
=> 'Bei dem Dateinamen handelt es sich um einen nicht unterstützten Archivdatei-Typ.',

   'Filename should end with one of: [_1].'
=> 'Der Dateiname sollte mit einer der folgenden Endungen enden: [_1]',

   'File: [_1] added to course'
=> 'Die Datei [_1] wurde zum Kurs hinzugefügt.',

   'Files extracted successfully from archive.'
=> 'Die Dateien wurden erfolgreich aus dem Archiv entpackt.',

   'Folder: [_1] added to course'
=> 'Das Verzeichnis [_1] wurde zum Kurs hinzugefügt.',

   'If the text is hard to read, [_1] will replace them.'
=> 'Falls der Text schwierig zu lesen ist, können Sie auf [_1] klicken, um neue Wörter zu erhalten.',

   'Item extracted from archive: [_1] has unexpected path.'
=> 'Das aus dem Archiv [_1] entpackte Element hat einen ungültigen Pfad.',

   'Missing dependencies'
=> 'Fehlende Abhängigkeiten',

   'No items found in archive.'
=> 'In dem Archiv wurden keine Elemente gefunden.',

   'No new items extracted from archive file.'
=> 'Aus der Archivdatei wurden keine neuen Elemente entpackt.',

   'Not extracted.'
=> 'Nicht entpackt',

   'Printing Blocked'
=> 'Ausdruck blockierter Elemente',

   'Printing for current resource is only possible between [_1] and [_2]'
=> 'Das Drucken der aktuellen Ressource ist nur zwischen [_1] und [_2] möglich.',

   'Printing for current resource no longer available (ended: [_1])'
=> 'Das Drucken der aktuellen Ressource ist nicht länger verfügbar (beendet seit [_1])',

   'Printing for current resource will only be possible starting [_1]'
=> 'Das Drucken der aktuellen Ressource wird ab dem [_1] möglich sein.',

   'Printing for current resource is unavailable'
=> 'Das Drucken der aktuellen Ressource ist nicht verfügbar.',

   'Status of dependencies in [_1]'
=> 'Status der Abhängigkeiten in [_1]',

   'The following files need to be uploaded.'
=> 'Die folgenden Dateien müssen hochgeladen werden.',

   'The following uploaded files are no longer used.'
=> 'Die folgenden hochgeladenen Dateien werden nicht mehr verwendet.',

   'Unused files'
=> 'Nicht verwendete Dateien',

   'Upload a new file to replace the one currently in use.'
=> 'Laden Sie eine neue Datei hoch, um die derzeit verwendete zu ersetzen.',

   'Upload replacement?'
=> 'Ersatz hochladen?',

   'Uploaded dependencies (in use)'
=> 'Hochgeladenene Abhängigkeiten (in Verwendung)',

   'Used by:'
=> 'verwendet von:',

   'Warning: decompression of the archive will overwrite the following items which already exist:'
=> 'Achtung, das Entpacken des Archivs wird folgende Elemente überschreiben, die bereits vorhanden sind:',

   'Decompression of archive file disallowed.'
=> 'Entpacken der Archivdatei ist nicht zulässig.',

   '[_1] included as a dependency'
=> '[_1] als Abhängigkeit enthalten',

   '[_1] is a dependency of [_2], which was discarded.'
=> '[_1] ist abhängig von [_2], das verworfen wurde.',

   'turned in'
=> 'turned in', # Folder name, loncommon.pm

   'Add as file'
=> 'Als Datei hinzufügen',

   'Add as folder/file'
=> 'Als Verzeichnis/Datei hinzufügen',

   'Content actions for all'
=> 'Inhaltsaktionen für alle',

   'Extract contents'
=> 'Inhalte entpacken',

   'How should each extracted item be incorporated in the course?'
=> 'Wie soll jedes der entpackten Elemente in den Kurs eingebunden werden?',

   'Include as dependency'
=> 'als Abhängigkeit einbinden',

   'Include as dependency for a displayed file'
=> 'als Abhängigkeit für eine angezeigte Datei einbinden',

   'Its contents are as follows:'
=> 'Seine Inhalte:',

   'LON-CAPA can process the files automatically, or you can decide how each should be handled.'
=> 'LON-CAPA kann die Dateien automatisch verarbeiten oder Sie legen fest, wie jede Datei behandelt werden soll.',

   'Permanently remove archive file?'
=> 'Soll die Archivdatei dauerhaft entfernt werden?',

   'Process automatically?'
=> 'Automatisch verarbeiten?',

   'This file is a Camtasia archive file.'
=> 'Bei dieser Datei handelt es sich um eine Camtasia-Archivdatei.',

   'This file is an archive file.'
=> 'Bei dieser Datei handelt es sich um eine Archivdatei.',

   'Title for folder containing movie'
=> 'Titel für Verzeichnis, das den Film enthält',

   'Title for page containing embedded movie'
=> 'Titel für die Seite, die den eingebetteten Film enthält',

   'You may wish to extract its contents.'
=> 'Sie können die Inhalte entpacken.',

   'Access to Authoring Space'
=> 'Zugriff auf Autorenbereich',

   'Access to Authoring Space has been activated'
=> 'Der Zugriff auf den Autorenbereich wurde aktiviert.',

   'An Authoring Space has already been assigned to you.'
=> 'Ein Autorenbereich wurde Ihnen bereits zugewiesen.',

   'An error occurred saving your request for Authoring Space.'
=> 'Beim Speichern Ihres Antrags auf einen Autorenbereich ist ein Fehler aufgetreten.',

   'An error occurred while activating your access to Authoring Space'
=> 'Beim Aktivieren des Zugriffs auf Ihren Autorenbereich ist ein Fehler aufgetreten.',

   'Authoring Space requests from the following users were deleted because one already exists:'
=> 'Anträge auf einen Autorenbereich wurden für folgende Personen entfernt, da bereits einer existiert:',

   'The following Authoring Space requests were deleted because the requestor does not have a LON-CAPA account:'
=> 'Die folgenden Anträge auf einen Autorenbereich wurden entfernt, da der Antragsteller keinen LON-CAPA-Account hat:',

   'Decide Later'
=> 'später entscheiden',

   'For the following requests an error occurred when removing the request from the queue:'
=> 'Bei den folgenden Anträgen ist beim Entfernen des Antrags aus der Warteschlange ein Fehler aufgetreten:',

   "For the following users, an error occurred when updating the user's own author request record:"
=> 'Bei den folgenden Benutzern ist beim Aktualisieren des Datensatzes des Antrags des eigenen Autorenbereichs des Benutzers ein Fehler aufgetreten:',

   'Please select the Author role from your [_1]roles page[_2].'
=> 'Bitte wählen Sie die Autorenrolle von Ihrer [_1]Rollenseite[_2].',

   'The following requests could not be processed because an error occurred:'
=> 'Die folgenden Anträge konnten nicht verarbeitet werden, da ein Fehler aufgetreten ist:',

   'The following requests could not be processed because the requestor does not have rights to request an Authoring Space:'
=> 'Die folgenden Anträge konnten nicht verarbeitet werden, da der Antragsteller nicht die Berechtigung hat, einen Autorenbereich zu beantragen:',

   'The following requests were approved:'
=> 'Die folgenden Anträge wurden bestätigt:',

   'The following requests were ignored because the request is no longer in the queue:'
=> 'Die folgenden Anträge wurden ignoriert, da sich der Antrag nicht mehr in der Warteschlange befindet:',

   'You do not currently have rights to request an Authoring Space.'
=> 'Sie haben derzeit nicht die Berechtigung, einen Autorenbereich zu beantragen.',

   'Your request for Authoring Space has been submitted for approval.'
=> 'Ihr Antrag auf einen Autorenbereich wurde abgeschickt und wartet auf Bestätigung.',

   'Access blocked?'
=> 'Zugriff gesperrt?',

   'Composite Page'
=> 'Zusammengesetzte Seite',

   'Copy Choices to Main Window'
=> 'Auswahl ins Hauptfenster kopieren',

   'Export format for LON-CAPA problems:'
=> 'Exportformat für LON-CAPA-Aufgaben:',

   'Resource Display Failed'
=> 'Anzeige der Ressource ist fehlgeschlagen',

   'XML'
=> 'XML',

   'No match was found for the username ([_1]) in this course.'
=> 'Die Suche nach der Benutzerkennung ([_1]) hat in diesem Kurs keine Treffer ergeben.',

   'No exact match was found for the username ([_1]) in this course.'
=> 'Die Suche nach der Benutzerkennung ([_1]) hat in diesem Kurs keine exakten Treffer ergeben.',

   'No match was found for the last name ([_1]) in this course.'
=> 'Die Suche nach dem Nachnamen ([_1]) hat in diesem Kurs keine Treffer ergeben.',

   'No exact match was found for the last name ([_1]) in this course.'
=> 'Die Suche nach  dem Nachnamen ([_1]) hat in diesem Kurs keine exakten Treffer ergeben.',

   'No match was found for the last name, first name ([_1]) in this course.'
=> 'Die Suche nach Nachname, Vorname ([_1]) hat in diesem Kurs keine Treffer ergeben.',

   'No exact match was found for the last name, first name ([_1]) in this course.'
=> 'Die Suche nach Nachname, Vorname ([_1]) hat in diesem Kurs keine exakten Treffer ergeben.',

   'Authoring request processing'
=> 'Verarbeite Antrag auf Autorenbereich',

   'Revoking custom role:'
=> 'Entziehe benutzerdefinierte Rolle:',


   'Authoring Request'
=> 'Antrag auf Autorenbereich',

   'Can Request Author Role'
=> 'Darf Autorenrolle beantragen',

   'Can request author space'
=> 'Darf Autorenbereich beantragen',

   'Command line script (DC role)'
=> 'Kommandozeilen-Skript (DC-Rolle)',

   'User Management by author'
=> 'Benutzerverwaltung durch den Autor',

   'WebDAV Availability'
=> 'WebDAV-Verfügbarkeit',

   'WebDAV access to Authoring Spaces (if SSL and author/co-author)'
=> 'WebDAV-Zugriff auf Autorenbereiche (falls SSL und Autor/Co-Autor)',

   'Yes, automatic approval'
=> 'Ja, automatische Bestätigung',

   'as exact match to'
=> 'als exakter Treffer von',

   'Cannot display dependency information - invalid file: [_1].'
=> 'Die Informationen zu Abhängigkeiten konnten nicht angezeigt werden - ungültige Datei: [_1]',

   'Close pop-up window and reload page'
=> 'Schließen Sie das Pop-Up-Fenster und laden Sie die Seite erneut.',

   'Deleted unused files'
=> 'Nicht verwendete Dateien wurden entfernt',

   'Error(s) deleting unused files'
=> 'Fehler beim Löschen nicht verwendeter Dateien',

   'Error: [_1] occurred when removing [_2]'
=> 'Beim Entfernen von [_2] ist der Fehler [_1] aufgetreten.',

   'Could not parse HTML file: [_1] to identify existing dependencies.'
=> 'Das Parsen der HTML-Datei [_1] zum Feststellen bestehender Abhängigkeiten ist nicht möglich.',

   'Failed to access HTML file: [_1] to identify existing dependencies.'
=> 'Der Zugriff auf die HTML-Datei [_1] zum Feststellen bestehender Abhängigkeiten ist fehlgeschlagen.',

   'File: [_1] does not appear to be an HTML file.'
=> 'Die Datei [_1] scheint keine HTML-Datei zu sein.',

   'File: [_1] not found when attempting removal.'
=> 'Die Datei [_1] wurde beim Versuch sie zu entfernen nicht gefunden.',

   'Manage Dependencies'
=> 'Abhängigkeiten verwalten',

   'No changes made.'
=> 'Keine Änderungen vorgenommen',

   'Removal failed for [_1].'
=> 'Entfernen fehlgeschlagen für [_1]',

   'This file has no dependencies.'
=> 'Diese Datei hat keine Abhängigkeiten.',

   'Unable to process any requested dependency changes - invalid file: [_1].'
=> 'Konnte keine Abhängigkeitsanforderungen verarbeiten - ungültige Datei: [_1].',

   'Uploaded files'
=> 'Hochgeladene Dateien',

   '(from another course)'
=> '(von einem anderen Kurs)',

   'An error occurred retrieving the contents of the current folder.'
=> 'Beim Abrufen der Inhalte des aktuellen Verzeichnisses ist ein Fehler aufgetreten.',

   'An error occurred retrieving the contents of the current page.'
=> 'Beim Abrufen der Inhalte der aktuellen Seite ist ein Fehler aufgetreten.',

   'An error occurred updating the contents of the current folder.'
=> 'Beim Aktualisieren der Inhalte des aktuellen Verzeichnisses ist ein Fehler aufgetreten.',

   'An error occurred updating the contents of the current page.'
=> 'Beim Aktualisieren der Inhalte der aktuellen Seite ist ein Fehler aufgetreten.',

   'Archive file "[_1]" not in the expected location.'
=> 'Die Archivdatei "[_1]" befindet sich nicht an der erwarteten Stelle.',

   'Archive file removed.'
=> 'Archivdatei wurde entfernt',

   'As a result the archive file has not been removed.'
=> 'Daher wurde die Archivdatei nicht entfernt.',

   'Change display'
=> 'Anzeige wechseln',

   'Choose server'
=> 'Server auswählen',

   'List of Content Identifiers'
=> 'Liste der Inhalts-Bezeichner',

   'Course Content Identifiers'
=> 'Kursinhalts-Bezeichner',

   'Community Content Identifiers'
=> 'Community-Inhalts-Bezeichner',

   'Course is empty'
=> 'Kurs ist leer',

   'Community is empty'
=> 'Community ist leer',

   'Content Overview'
=> 'Inhaltsübersicht',

   'Content Search'
=> 'Inhaltssuche',

   'Content Utilities'
=> 'Inhaltswerkzeuge',

   'Copy to new' # londocs.pm
=> 'Ins neue kopieren',

   'Move old' # londocs.pm
=> 'Altes verschieben',

   'Copy to new folder'
=> 'In neues Verzeichnis einfügen',

   'Display of Content Changes'
=> 'Anzeige von Inhaltsänderungen',

   'Enter number to pick (e.g., 3)'
=> 'Geben Sie eine Zahl ein, wie viele verwendet werden sollen (z.B. 3)',

   'Export contents to IMS Archive'
=> 'Inhalte in IMS-Archiv exportieren',

   'External Scores (handgrade, upload, clicker)'
=> 'Externe Punkte (manuell bewertet, hochgeladen, Clicker)',

   'Title for the External Score'
=> 'Titel für die externen Punkte',

   'Failed to acquire a unique timestamp-based suffix for the new folder/page.'
=> 'Es war nicht möglich, für das Verzeichnis / die Seite einen Suffix mit einem eindeutigen Zeitstempel zu erstellen.',

   'Folder to paste contains sub-folders'
=> 'Das einzufügende Verzeichnis enthält Unterverzeichnisse.',

   'Show Paste Options'
=> 'Einfügeoptionen anzeigen',

   'Hide Paste Options'
=> 'Einfügeoptionen verbergen',

   'Identifier'
=> 'Bezeichner',

   'Internal Identifier'
=> 'Interne Bezeichner',

   'Import Content'
=> 'Inhalt importieren',

   'Import from Assembled Map'
=> 'Import aus zusammengesetzter Inhaltszusammenstellung',

   'Invalid URL'
=> 'Ungültige URL',

   'List Resource Identifiers'
=> 'Ressourcen-Bezeichner anzeigen',

   'Content Identifiers'
=> 'Inhaltsbezeichner',

   'Move old folder'
=> 'Altes Verzeichnis verschieben',

   'Origin of IMS package'
=> 'Herkunft des IMS-Pakets',

   'Paste buffer contains:'
=> 'Die Zwischenablage enthält:',

   'Paste from another course unavailable.'
=> 'Einfügen aus einem anderen Kurs ist nicht verfügbar',

   'Paste into Supplemental Content unavailable for this type of content.'
=> 'Einfügen in zusätzliche Inhalte ist für diese Art von Inhalt nicht verfügbar.',

   'Randomly Pick'
=> 'Zufällig auswählen',

   'The following files are either dependencies of a web page or references within a folder and/or composite page for which errors occurred during import:'
=> 'Die folgenden Dateien sind entweder Abhängigkeiten einer Webseite oder Verweise innerhalb eines Verzeichnisses und/oder zusammengesetzten Seite, für die Fehler beim Import aufgetreten sind:',

   'The following files are either dependencies of a web page or references within a folder and/or composite page which could not be copied during the paste operation:'
=> 'Die folgenden Dateien sind entweder Abhängigkeiten einer Webseite oder Verweise innerhalb eines Verzeichnisses und/oder zusammengesetzten Seite, die während des Einfügevorgangs nicht kopiert werden konnten:',

   'There was a problem removing a lockfile.'
=> 'Beim Entfernen der Sperrdatei ist ein Problem aufgetreten.',

   'This will prevent creation of additional folders or composite pages in this course.'
=> 'Somit ist es nicht möglich, weitere Verzeichnisse oder zusammengesetzte Seiten im Kurs zu erstellen.',

   'Title is blank'
=> 'Der Titel ist leer.',

   'Version [_1]'
=> 'Version [_1]',

   'Version choice(s) for specific resources'
=> 'Versionsauswahl für bestimmte Ressourcen',

   'You must choose an IMS package for import'
=> 'Sie müssen ein IMS-Paket zum importieren auswählen.',

   'You must select which Course Management System was the source of the IMS package'
=> 'Sie müssen auswählen, aus welchem Kurs-Management-System das IMS-Paket stammt.',

   'You need to switch to a server housing an Authoring Space for which you are author or co-author.'
=> 'Sie müssen zu einem Server wechseln, auf dem ein Autorenbereich besteht, für den Sie eine Autoren- oder Co-Autoren-Rolle haben.',

   'External Resource updated'
=> 'Externe Ressource wurde aktualisiert',

   'Information about current external resource is incomplete.'
=> 'Die Informationen zu der aktuellen externen Ressource ist unvollständig.',

   'Information about external resource to edit is missing.'
=> 'Es fehlen Informationen über die zu editierende externe Ressource.',

   'Reload failed: [_1].'
=> 'Erneutes Laden ist fehlgeschlagen: [_1].',

   'Update failed: [_1].'
=> 'Aktualisieren ist fehlgeschlagen: [_1].',

   'External Resource Editor'
=> 'Editor für externe Ressourcen',

   'Like'
=> 'Gefällt mir',

   'Unlike'
=> 'Gefällt mir nicht',

   'Like this posting'
=> "Diesen Beitrag mit 'Gefällt mir' kennzeichnen",

   'Unlike this posting'
=> "Diesen Beitrag mit 'Gefällt mir nicht' kennzeichnen",

   'You like this posting'
=> 'Sie mögen diesen Beitrag.',

   'You unlike this posting'
=> 'Sie mögen diesen Beitrag nicht.',

   '[_1] likes'
=> "[_1] 'Gefällt mir'",

   '[_1] unlikes'
=> "[_1] 'Gefällt mir nicht'",

   "Registered 'Like'"
=> "Registrierte 'Gefällt mir'",

   "Registered 'Unlike'"
=> "Registrierte 'Gefällt mir nicht'",

   "'Like' already registered"
=> "'Gefällt mir' ist bereits registriert",

   "'Unlike' already registered"
=> "'Gefällt mir nicht' ist bereits registriert",

   '(Posting and voting closed for [_1] roles)'
=> '(Abschicken von Beiträgen und Abstimmung ist für [_1] Rollen geschlossen)',

   'No voting for deleted posts.'
=> 'Kein Abstimmen für gelöschte Beiträge',

   'No voting for hidden posts.'
=> 'Kein Abstimmen für verborgene Beiträge',

   'No voting for your own posts.'
=> 'Kein Abstimmen für eigene Beiträge.',

   'Voting unavailable for this discussion'
=> 'Abstimmen für Diskussion nicht verfügbar',

   'Contributor Kudos'
=> 'Ansehen des Beitragenden',

   'Discussion status unchanged'
=> 'Diskussionsstatus unverändert',

   'Failed to register vote'
=> 'Das Registrieren der Abstimmung ist fehlgeschlagen.',

   'Failed to undelete entries'
=> 'Das wiederherstellen der Einträge ist fehlgeschlagen.',

   'Hiding not permitted'
=> 'Verbergen nicht gestattet',

   'Invalid post number'
=> 'Ungültige Beitragsnummer',

   'No entries to undelete'
=> 'Keine Einträge, die wiederhergestellt werden können',

   'Quote'
=> 'Zitat',

   'Return and reload'
=> 'Zurückkehren und erneut laden',

   'Undelete all deleted entries'
=> 'Alle gelöschten Einträge wiederherstellen',

   'Undeleted all entries'
=> 'Alle gelöschten Einträge wurden wiederhergestellt.',

   'Vote not registered.'
=> 'Abstimmung wurde nicht registriert',

   'My settings for this discussion'
=> 'Meine Einstellungen für diese Diskussion',

   'Any time before slot starts'
=> 'Beliebige Zeit, bevor der Slot startet',

   'No restriction on uniqueness'
=> 'Keine Einschränkung bezüglich Eindeutigkeit',

   '(Internal Course/Group Content)'
=> '(Interner Kurs-/Gruppeninhalt)',

   'Continue submission and overwrite the file(s)?'
=> 'Einreichung fortsetzen und Datei(en) überschreiben?',

   'Due in: {dn} {dl} {hnn}{sep}{mnn}{sep}{snn} [_1]'
=> 'Fällig in {dn} {dl} {hnn}{sep}{mnn}{sep}{snn} [_1]',

   'Submit Early'
=> 'rechtzeitig einreichen!',

   'Past Due'
=> 'Fälligkeit überschritten',

   'File(s) you uploaded for your submission will overwrite existing file(s) submitted for this item'
=> 'Dateien, die Sie als Einreichung hochladen, werden bestehende Dateien überschreiben, die für dieses Element eingereicht wurden.',

   "Student's current version:"
=> "Derzeitige Version des/der Studenten/in:",

   "Student's version displayed:"
=> "Angezeigte Version des/der Studenten/in:",

   'Directory does not exist.'
=> 'Verzeichnis existiert nicht',

   'Directory temporarily not accessible.'
=> 'Zugriff auf das Verzeichnis temporär nicht möglich',

   'Countdown to due date/time'
=> 'Countdown bis zur Fälligkeit',

   'Timer'
=> 'Timer',

   'View Resource'
=> 'Ressource anzeigen',

   'dated' #lonmsg.pm
=> 'vom',

   'Edit Content'
=> 'Inhalt editieren',

   'Reservable, reservations close [_1]'
=> 'Reservierbar, Reservierungen schließen am [_1]',

   'Reservable, reservations open [_1]'
=> 'Reservierbar, Reservierungen öffnen am [_1]',

   'Could not determine e-mail addresses for the following users:'
=> 'Für die folgenden Benutzer konnte keine E-Mail-Adresse festgestellt werden:',

   'Sent'
=> 'Gesendet',

   'Automatically set earlier than '
=> 'Automatisch eher setzen als ',

   'Automatically set later than '
=> 'Automatisch später setzen als ',

   'Automatically set when setting '
=> 'Wird automatisch gesetzt, wenn Folgendes gesetzt wird: ',

   'Automatically sets'
=> 'Setzt automatisch',

   'Default value when manually setting'
=> 'Voreingestellter Wert, wenn manuell eingestellt wird',

   'Display of Changes'
=> 'Anzeige der Änderungen',

   'Resource: [_1]with ID: [_2]in folder [_3]'
=> 'Ressource [_1]mit ID [_2]im Verzeichnis [_3]',

   'Wrong username ([_1]) found in PDF file. Expected username: [_2]'
=> 'Falsche Benutzerkennung in der PDF-Datei gefunden: [_1] Erwartete Benutzerkennung: [_2]',

   'Intended course owner not specified'
=> 'Vorgesehener Kurseigentümer nicht angegeben',

   'Clicker: [_1]'
=> 'Clicker: [_1]',

   'clicker'
=> 'Clicker',

   'Your current selection: "Use buttons and text" is deprecated - it is recommended that you change this to "Use icons and text".'
=> 'Ihre derzeitige Auswahl "Buttons mit Text" ist veraltet. Es wird empfohlen, dass Sie die Auswahl in "Icons mit Text" ändern.',

   'MathJax'
=> 'MathJax',

   'MathJax:'
=> 'MathJax:',

   'Printing from Authoring Space: No Title'
=> 'Druck aus dem Autorenbereich: Kein Titel',

   'Test-Printout '
=> 'Test-Ausdruck ',

   'Although assessment items can be created directly inside a course, such items only use part of the assessment capabilities of LON-CAPA.'
=> 'Beurteilungs-Elemente können zwar direkt in einem Kurs erstellt werden, doch diese Elemente nutzen nur einen Teil der Beurteilungsmöglichkeiten von LON-CAPA.',


   'By contrast, items created in Authoring Space, then imported into a course, can use all of the features of the assessment engine.'
=> 'Im Gegensatz dazu können Elemente, die in einem Autorenbereich erstellt und dann in einen Kurs importiert wurden, alle Features der Beurteilungsmöglichkeiten des Systems nutzen.',

   'Choose a role:'
=> 'Auswahl einer Rolle:',

   'Enter new course with role: [_1]'
=> 'Neuen Kurs mit der Rolle [_1] betreten',

   'Enter your Authoring Space with role: [_1]'
=> 'Betreten Sie Ihren Autorenbereich mit der Rolle [_1].',

   'New roles will be listed on your [_1]Roles[_2] page.'
=> 'Neue Rollen werden auf der [_1]Rollenseite[_2] aufgelistet.',

   'Request Authoring Space access now?'
=> 'Jetzt Zugriff auf Autorenbereich beantragen?',

   'Submit authoring request'
=> 'Antrag auf Autorenbereich abschicken',

   'Search terms'
=> 'Suchbegriffe',

   'Source code is displayed, but you can not copy to Authoring Space on this server.'
=> 'Der Quellcode wird angezeigt, Sie können ihn jedoch nicht in einen Autorenbereich auf diesem Server kopieren.',

   'Source code is displayed, but you can not copy to Authoring Space, as you do not have an author or co-author role on this server.'
=> 'Der Quellcode wird angezeigt, Sie können ihn jedoch nicht in einen Autorenbereich auf diesem Server kopieren, da Sie weder eine Autoren- noch eine Co-Autoren-Rolle auf diesem Server haben.',

   'Unable to retrieve file contents.'
=> 'Die Dateiinhalte konnten nicht abgerufen werden.',

   'Information to show'
=> 'Anzuzeigende Informationen',

   'No user information selected for display.'
=> 'Keine Benutzerinformationen zur Anzeige ausgewählt',

   'last login'
=> 'Letzter Login',

   'Last login for anyone who has ever logged in'
=> 'Letzter Login von allen, die sich jemals eingeloggt haben',

   'Last login for users in last 24 hours'
=> 'Letzter Login von Benutzern in den letzten 24 Stunden',

   'Last login for users in last 30 days'
=> 'Letzter Login von Benutzern in den letzten 30 Tagen',

   'Last login for users in last 7 days'
=> 'Letzter Login von Benutzern in den letzten sieben Tagen',

   'last logins for anyone who has ever logged in'
=> 'letzter Login von allen, die sich jemals eingeloggt haben',

   'last logins for users in last 24 hours'
=> 'letzter Login von Benutzern in den letzten 24 Stunden',

   'last logins for users in last 30 days'
=> 'letzter Login von Benutzern in den letzten 30 Tagen',

   'last logins for users in last 7 days'
=> 'letzter Login von Benutzern in den letzten sieben Tagen',

   'There are no last logins for users in last 7 days'
=> 'In den letzten sieben Tagen gab es keine letzten Logins von Benutzern.',

   'Total number of logins'
=> 'Gesamtanzahl an Logins',

   'Processing student [_1] of [_2]'
=> 'Verarbeite Student/in [_1] von [_2]',

   'Converting to EPS: [_1]'
=> 'Umwandlung nach EPS: [_1]',

   'Operation timed out!'
=> 'Zeitüberschreitung bei der Ausführung!',

   'Repaginating student: [_1]'
=> 'Umnummerierung für Student/in [_1]',

   'Domain configuration for [_1]'
=> 'Domänen-Konfiguration für [_1]',

   'This server is not a primary library server'
=> 'Dieser Server ist kein primärer Library-Server',

   'You do not have access rights to view domain configuration for domain(s) hosted on this server.'
=> 'Sie haben keine Zugriffsrechte, um die Domänen-Konfiguration für Domänen zu betrachten, die auf diesem Server gehostet werden.',

   'Configurations for the domains housed on this server: '
=> 'Konfigurationen für die Domänen, die auf diesem Server sind: ',

   'No domain information exists for this server'
=> 'Für diesen Server existiert keine Domänen-Information.',

   'The configuration for domain: [_1] does not permit you to view the requested server status page: [_2].'
=> 'Die Konfiguration für die Domäne [_1] gestattet es Ihnen nicht, die angeforderte Serverstatusseite [_2] zu betrachten.',

   'Your current role does not permit you to view the requested server status page: [_1]'
=> 'Ihre derzeitige Rolle gestattet es Ihnen nicht, die angeforderte Serverstatusseite [_1] zu betrachten.',

   'do not permit you to view the requested server status page: [_1]'
=> 'gestatten Ihnen nicht, die  angeforderte Serverstatusseite [_1] zu betrachten.',

   'Cause server to ping another server'
=> 'Bewirkt, dass der Server einen anderen Server anpingt',

   'Text Display of Domain Configuration'
=> 'Textanzeige für Domänen-Konfiguration',

   'Bad Cookie'
=> 'Ungültiger Cookie',

   'Your cookie information is incorrect.'
=> 'Ihre Cookie-Informationen sind inkorrekt.',

   'This can only be run on a library server!'
=> 'Dies kann nur auf einem Library-Server ausgeführt werden!',

   'Reservation needed: will be reservable later.'
=> 'Reservierung notwendig: wird später reservierbar',

   'Time members can no longer reserve'
=> 'Zeitpunkt, ab dem Mitglieder nicht mehr reservieren können',

   'Time students can no longer reserve'
=> 'Zeitpunkt, ab dem Studierende nicht mehr reservieren können',

   'To complete the transaction you [_1]must confirm[_2] you want to [_3]process the change[_4] to [_5].'
=> 'Um die Transaktion abzuschließen, [_1]müssen Sie bestätigen[_2], dass Sie [_3]die Änderung in [_5] vornehmen[_4] möchten.',

   'Student Submission Data'
=> 'Studentische Einreichungsdaten',

   'Student submission data'
=> 'Studentische Einreichungsdaten',

   'Assistant Author in Authoring Space for: [_1]'
=> 'Autor-Assistent in Autorenbereich für [_1]',

   'Co-Author in Authoring Space for: [_1]'
=> 'Co-Autor in Autorenbereich für [_1]',

   'Resource Author is: [_1]'
=> 'Autor der Ressource ist [_1]',

   'There is a problem with the filename'
=> 'Es gibt mit dem Dateinamen ein Problem.',

   'Unable to determine home server for this resource: [_1]'
=> 'Für diese Ressource konnte der Heimatserver nicht ermittelt werden: [_1]',

   'You are not permitted to take this action.'
=> 'Ihnen ist es nicht gestattet, diese Aktion auszuführen.',

   'You do not have privileges to view the published resource'
=> 'Sie sind nicht berechtigt, die veröffentlichte Ressource zu betrachten.',

   'You may be attempting to edit a versioned file (files in Authoring Space may not include a version number before the extension).'
=> 'Sie versuchen vielleicht, eine versionierte Datei zu editieren (Dateien im Autorenbereich dürfen keine Versionsnummer for der Dateinamenserweiterung haben).',

   'Copying, moving, renaming or creating file not allowed.'
=> 'Kopieren, verschieben, umbenennen oder erstellen einer Datei ist nicht zulässig.',

   'Display of differences between file versions disallowed.'
=> 'Das Anzeigen von Unterschieden zwischen Dateiversionen ist nicht zulässig.',

   'Publishing not allowed.'
=> 'Veröffentlichen ist nicht zulässig.',

   'Retrieving version information not allowed.'
=> 'Abrufen von Versionsinformationen ist nicht zulässig.',

   'Uploading file not allowed.'
=> 'Hochladen einer Datei ist nicht zulässig.',

   'Uploading testbank file not allowed'
=> 'Hochladen einer Testbank-Datei ist nicht zulässig.',

   'Or [_1]continue[_2] the testbank import without these files.'
=> 'Oder [_1]fahren Sie mit dem Testbank-Import fort[_2] und zwar ohne diese Dateien.',

   'Upload cancelled.'
=> 'Hochladen abgebrochen',

   'View main file'
=> 'Hauptdatei betrachten',

   'Import as:'
=> 'Importieren als:',

   'as problem'
=> 'als Aufgabe',

   'as problem part(s)'
=> 'als Aufgabenteil(e)',

   'as standard library'
=> 'als Standardbibliothek',

   'As all folders and sequences following the current resource were empty, you have now reached the end of the course.'
=> 'Da alle auf die aktuelle Ressource folgenden Verzeichnisse und Sequenzen leer sind, haben Sie nun das Ende des Kurses erreicht.',

   'As all folders and sequences preceding the current resource were empty, you have now reached the beginning of the course.'
=> 'Da alle vor der aktuellen Ressource befindlichen Verzeichnisse und Sequenzen leer sind, haben Sie nun den Anfang des Kurses erreicht.',

   'Access Temporarily Blocked'
=> 'Zugriff temporär gesperrt',

   'Access to LON-CAPA unavailable'
=> 'Zugriff auf LON-CAPA nicht möglich',

   'Add Metadata Field'
=> 'Metadaten-Feld hinzufügen',

   'Alert'
=> 'Alarm',

   'Blocking communication/content access'
=> 'Zugriffssperre für Kommunikation und Inhalt',

   'Blocking Communication/Resource Access'
=> 'Zugriffssperre für Kommunikation und Ressourcen',

   'Broadcast List'
=> 'Broadcast-Liste',

   'Cell Edit Window'
=> 'Zellen-Editor',

   'Clean Parameters'
=> 'Parameter aufräumen',

   'Content Change Log'
=> 'Inhaltsänderungs-Protokoll',

   'Copying Source'
=> 'Kopiere Quelle',

   'Create IMS import directory'
=> 'IMS-Import-Verzeichnis erstellen',

   'Create Testbank directory'
=> 'Testbank-Verzeichnis erstellen',

   'Custom Distribution Rights'
=> 'Maßgeschneiderte Zugriffsrechte',

   'Debug'
=> 'Debuggen',

   'Dialog'
=> 'Dialog',

   'Discussion Post Versions'
=> 'Versionen der Diskussionsbeiträge',

   'Discussion Post'
=> 'Diskussionsbeitrag',

   'Edit Sequence'
=> 'Sequenz editieren',

   'Empty Folder/Sequence'
=> 'Leere/s Verzeichnis/Sequenz',

   'File Error'
=> 'Dateifehler',

   'Get Coordinates'
=> 'Koordinaten holen',

   'Going to login'
=> 'Gehe zum Login',

   'Help Content'
=> 'Inhalt der Hilfe',

   'Highlight Central'
=> 'Highlight Central', # ??? grades.pm

   'Message Central'
=> 'Message Central', # ??? grades.pm

   'LON-CAPA Reaction Editor'
=> 'LON-CAPA-Reaktions-Editor',

   'Map Contents'
=> 'Inhaltszusammenstellungs-Inhalte',

   'Molecule Editor'
=> 'Molekül-Editor',

   'Multiple Downloads'
=> 'Mehrfache Downloads',

   'Multiple Resources'
=> 'Mehrfache Ressourcen',

   'Parameter Setting Default Actions'
=> 'Standardaktionen der Parameter-Einstellungen',

   'Passphrase protected file'
=> 'Passwortgeschützte Datei',

   'Pick Instance of Resource'
=> 'Instanz einer Ressource auswählen',

   'Publishing Frame'
=> 'Publishing Frame', # ??? lonpubmenu.pm

   'Save Custom Role'
=> 'Benutzerdefinierte Rolle speichern',

   'Saved Comment Listing'
=> 'Saved Comment Listing', # ??? lonmsgdisplay.pm

   'Selected course unavailable on this server'
=> 'Der ausgewählte Kurs ist auf diesem Server nicht verfügbar.',

   'Selecting Resource'
=> 'Auswahl der Ressource',

   'Selection of Resources for Blocking'
=> 'Auswahl der Ressourcen für eine Sperre',

   'Set Resource Parameters in Map'
=> 'Ressourcen-Parameter in Inhaltszusammenstellung setzen',

   'Shift Dates'
=> 'Datumswerte verschieben',

   'Spell Checker'
=> 'Rechtschreibprüfung',

   "Student's Version"
=> 'Studentische Version',

   'Take Offline'
=> 'Offline schalten',

   'Take offline'
=> 'Offline schalten',

   'Take Online'
=> 'Online schalten',

   'Undelete all deleted discussion entries'
=> 'Alle gelöschten Diskussionsbeiträge wieder herstellen',

   'View CODEs'
=> 'CODEs betrachten',

   'View Source Code'
=> 'Quellcode betrachten',

   '...'
=> '...',

   'Assessment Overview Chart'
=> 'Aufgabenfortschritt des Kurses',

   'Assessment Chart'
=> 'Aufgabenfortschritt',

   'Automated Grading'
=> 'Automatische Bewertung',

   'Categories: shows points according to categories'
=> 'Kategorien: Zeigt Punkte bezüglich Kategorien',

   'Classlists and staff listing'
=> 'Kursteilnehmer- und Personalliste',

   'Collaboration'
=> 'Zusammenarbeit',

   'Content Grading'
=> 'Bewertung von Inhalten',

   'Content Index'
=> 'Inhaltsindex',

   'Content Settings for this Course'
=> 'Inhaltseinstellungen für diesen Kurs',

   'Content and Problem Settings'
=> 'Inhalts- und Aufgabeneinstellungen',

   'Course content verification'
=> 'Überprüfung des Kursinhalts',

   'Difficulty Indexes'
=> 'Schwierigkeitsindizes',

   'Discussion Voting'
=> 'Diskussionsabstimmungen',

   'Discussion post fonts based on likes/unlikes'
=> 'Zeichensätze der Diskussionsbeiträge, abhängig von "Gefällt mir" / "Gefällt mir nicht"',

   'Display Individual'
=> 'Einzelne anzeigen',

   'Display Individual Student'
=> 'Einzelne/n Studenten/in anzeigen',

   'Display/Download Multiple Students'
=> 'Mehrere Studierende anzeigen/herunterladen',

   'Download Multiple'
=> 'Mehrere herunterladen',

   'Download all students submissions.'
=> 'Alle studentischen Einreichungen herunterladen',

   'Download submissions'
=> 'Einreichungen herunterladen',

   'Edit Course Settings'
=> 'Kurseinstellungen bearbeiten',

   'Editing Course Contents'
=> 'Kursinhalt bearbeiten',

   'Evaluate File'
=> 'Datei auswerten',

   'Exit Editor'
=> 'Editor verlassen',

   'Feeds'
=> 'Feeds',

   'Grade all resources in current page/sequence/folder for one student.'
=> 'Alle Ressourcen in aktueller/m Seite/Sequenz/Verzeichnis für eine/n Student/in bewerten',

   'Grade all submissions that have not been graded yet.'
=> 'Alle Einreichungen bewerten, die bis jetzt noch nicht bewertet wurden',

   'Grade current resource for a selection of students.'
=> 'Derzeitige Ressource für eine Auswahl an Studierenden bewerten',

   'Grade current resource for all students.'
=> 'Derzeitige Ressource für alle Studierenden bewerten',

   'Grade page/folder for one student'
=> 'Seite/Verzeichnis für eine/n Student/in',

   'Grade ungraded submissions'
=> 'Unbewertete Einreichungen bewerten',

   'Grade ungraded submissions.'
=> 'Unbewertete Einreichungen bewerten',

   'Grading Resources'
=> 'Bewertungsressourcen',

   'Grading table'
=> 'Bewertungstabelle',

   'Hand Grading'
=> 'Manuelle Bewertung',

   'If something is incorrect, please return to [_1]Grade/Manage/Review Bubblesheets[_2] to start over.'
=> 'Falls etwas nicht korrekt ist, kehren Sie bitte nach [_1]Bewertung/Verwaltung/Überprüfung von Bubblesheets[_2] zurück und beginnen Sie noch einmal von vorne.',

   'Or return to [_1]Grade/Manage/Review Bubblesheets[_2] to start over.'
=> 'Oder kehren Sie zu [_1]Bewertung/Verwaltung/Überprüfung von Bubblesheets[_2] zurück, um noch einmal von vorne zu beginnen.',

   'Individual Points Overview'
=> 'Individuelle Punkteübersicht',

   'List Content IDs'
=> 'Inhalts-IDs anzeigen',

   'List the unique identifier used for each resource instance in your course'
=> 'Eindeutige Bezeichner anzeigen, die für jede Ressourceninstanz in Ihrem Kurs verwendet werden',

   'No submissions found for this resource for any students. ([quant,_1,student] checked for submissions)'
=> 'Keine Einreichungen für diese Ressource für keine Studierenden gefunden. ([quant,_1,Student/in wurde,Studierende wurden] auf Einreichungen überprüft.)',

   'No incorrect submissions found for this resource for any students. ([quant,_1,student] checked for incorrect submissions)'
=> 'Keine inkorrekten Einreichungen für diese Ressource für keine Studierenden gefunden. ([quant,_1,Student/in wurde,Studierende wurden] auf inkorrekte Einreichungen überprüft.)',

   'No ungraded submissions found for this resource for any students. ([quant,_1,student] checked for ungraded submissions)'
=> 'Keine unbewerteten Einreichungen für diese Ressource für keine Studierenden gefunden. ([quant,_1,Student/in wurde,Studierende wurden] auf unbewertete Einreichungen überprüft.)',

   'No queued submissions found for this resource for any students. ([quant,_1,student] checked for queued submissions)'
=> 'Keine in der Warteschlange befindlichen Einreichungen für diese Ressource für keine Studierenden gefunden. ([quant,_1,Student/in wurde,Studierende wurden] auf in der Warteschlange befindliche Einreichungen überprüft.)',

   'Otherwise, Grade/Manage/Review Bubblesheets [_1] Review bubblesheet data can be used once grading is complete.'
=> 'Ansonsten können Sie "Bewertung/Verwaltung/Überprüfung von Bubblesheets [_1] Überprüfen der Bubblesheet-Daten" verwenden, sobald der Bewertungsvorgang abgeschlossen ist.',

   'Partially correct is answerable '
=> 'Teilweise korrekt ist beantwortbar ', # ??? custompartial.problem, packages.tab

   'People'
=> 'Personen',

   'Personal'
=> 'Mein LON-CAPA', # Persönliches

   'Print end date'
=> 'Enddatum drucken',

   'Print start date'
=> 'Startdatum drucken',

   'Problem Grading'
=> 'Aufgabenbewertung',

   'Published Content'
=> 'Veröffentlichter Inhalt',

   'Select Students for Which to Download Submissions'
=> 'Auswahl der Studierenden, für die Einreichungen heruntergeladen werden sollen',

   'Select individual students to grade'
=> 'Einzelne Studierende bewerten',

   'Select the problem or one of the problems you want to grade'
=> 'Wählen Sie eine oder mehrere Aufgaben, die Sie bewerten möchten.',

   'Select which submissions to download'
=> 'Auswahl, welche Einreichungen heruntergeladen werden sollen',

   'Special Pages'
=> 'Spezielle Seiten',

   'Specify a file containing clicker information and set grading options.'
=> 'Angabe einer Datei, die Clicker-Informationen enthält und setzen von Bewertungsinformationen',

   'Statistics and Reports'
=> 'Statistiken und Berichte',

   'Student Submissions'
=> 'Studentische Einreichungen',

   'Students will see points based on problem weights.'
=> 'Studierende werden Punkte sehen, die auf den Aufgabengewichtungen basieren.',

   'Switch role'
=> 'Rolle wechseln',

   'There are currently no submitted documents.'
=> 'Derzeit gibt es keine eingereichten Dokumente.',

   'These will be the privileges all group members receive for a particular assigned tool, if you selected the first option above.'
=> 'Diese Berechtigungen werden alle Gruppenmitglieder für ein bestimmtes zugewiesenes Tool erhalten, falls Sie die erste Option gewählt haben.',

   'Verification Result'
=> 'Ergebnis der Überprüfung',

   'Verify Re-enable'
=> 'Überprüfung erneut aktivieren',

   'tries/correct'
=> 'Versuche/korrekt',

   'Tries per Correct Answer'
=> 'Versuche pro korrekter Antwort',

   'Choose single CODE from list:'
=> 'Einzelnen CODE aus Liste auswählen:',

   'Content Grades'
=> 'Inhaltsbewertungen',

   'Content Settings'
=> 'Inhaltseinstellungen',

   'Edit Folder'
=> 'Verzeichnis bearbeiten',

   'Folder/Page Content'
=> 'Verzeichnis-/Seiten-Inhalt',

   'Next content resource'
=> 'Nächste Inhaltsressource',

   'Previous content resource'
=> 'Vorherige Inhaltsressource',

   'RSS Feeds'
=> 'RSS-Feeds',

   'Reservations'
=> 'Reservierungen',

   'Select CODEd Assignments'
=> 'Mit CODE versehene Übungen auswählen',

   'Select Resources'
=> 'Ressourcen auswählen',

   'Authoring Space Requests'
=> 'Anträge auf einen Autorenbereich',

   'Authoring Space requests'
=> 'Anträge auf einen Autorenbereich',

   'Authoring requests'
=> 'Anträge auf einen Autorenbereich',

   'E-mail Delivery'
=> 'E-Mail-Zustellung',

   'Select audience'
=> 'Auswahl der Zielgruppe',

   'Title for Web Page'
=> 'Titel für Webseite',

   'Blank Web Page (editable)'
=> 'Leere Webseite (änderbar)',

   'Clear selected'
=> 'Ausgewählte entfernen',

   'Paste to current folder'
=> 'In aktuelles Verzeichnis einfügen',

   'Clipboard is empty'
=> 'Zwischenablage ist leer',

   'Copy to new page'
=> 'Auf neue Seite kopieren',

   'Show Options'
=> 'Optionen anzeigen',

   'Hide Options'
=> 'Optionen verbergen',

   'Make changes'
=> 'Änderungen vornehmen',

   'No actions selected or changes to settings specified.'
=> 'Keine Aktionen ausgewählt und keine Änderungen an den Einstellungen angegeben',

   'No actions selected.'
=> 'Keine Aktionen ausgewählt',

   'No changes to settings specified.'
=> 'Keine Änderungen an den Einstellungen angegeben',

   'No items selected from clipboard.'
=> 'Keine Elemente der Zwischenablage ausgewählt',

   'Paste selected'
=> 'Ausgewählte einfügen',

   '[quant,_1,item] cleared from clipboard'
=> '[quant,_1,Elemente,Elemente] von der Zwischenablage entfernt',

   'multiple' # londocs.pm
=> 'mehrere',

   'one' # londocs.pm
=> 'einzeln',

   'check/uncheck all'
=> 'Alle auswählen / Gesamte Auswahl aufheben',

   'File successfully renamed'
=> 'Datei erfolgreich umbenannt',

   'File successfully uploaded'
=> 'Datei erfolgreich hochgeladen',

   'Directory successfully created'
=> 'Verzeichnis erfolgreich erstellt',

   'Directory successfully deleted'
=> 'Verzeichnis erfolgreich gelöscht',

   'Algebra System:'
=> 'Algebra-System:',

   'Argument Array:'
=> 'Argumente-Array:',

   'Background plot(s) for answer (function(x):xmin:xmax,function(x):xmin:xmax,x1:y1:sx1:sy1:x2:y2:sx2:sy2,...):'
=> 'Hintergrund-Plot(s) für die Antwort (function(x):xmin:xmax,function(x):xmin:xmax,x1:y1:sx1:sy1:x2:y2:sx2:sy2,...):',

   'Case Insensitive'
=> 'Groß-/Kleinschreibung wird nicht unterschieden',

   'Case Insensitive, Any Order'
=> 'Groß-/Kleinschreibung wird nicht unterschieden, beliebige Reihenfolge',

   'Case Sensitive'
=> 'Groß-/Kleinschreibung wird unterschieden',

   'Checkbox options:'
=> 'Checkbox-Optionen:',

   'Columns:'
=> 'Spalten:',

   'Rows:'
=> 'Zeilen:',

   'Correct Answer:'
=> 'Korrekte Antwort:',

   'Display Direction:'
=> 'Anzeigerichtung:',

   'Grid visible:'
=> 'Raster sichtbar:',

   'Height (pixels):'
=> 'Höhe (Pixel):',

   'Width (pixels):'
=> 'Breite (Pixel):',

   'Initial Reaction:'
=> 'Initiale Reaktion:',

   'Items Columns:'
=> 'Anzahl Spalten der Elemente:',

   'Items Display Direction:'
=> 'Anzeigerichtung der Elemente:',

   'Items Display Location:'
=> 'Anzeigeort der Elemente:',

   'JME string of the answer - automatically updated by "Insert Answer" in the JME pop-up (click pencil):'
=> 'JME-Text der Antwort - wird automatisch aktualisiert durch "Antwort einfügen" im JME-PopUp-Fenster (klicken Sie auf den Stift):',

   'Insert Answer'
=> 'Antwort einfügen',

   'Label x-axis:'
=> 'Beschriftung der X-Achse:',

   'Label y-axis:'
=> 'Beschriftung der Y-Achse:',

   'Libraries:'
=> 'Bibliotheken:',

   'Listed in a vertical column'
=> 'In vertikaler Spalte gelistet',

   'Maximum x-value:'
=> 'Maximaler X-Wert:',

   'Maximum y-value:'
=> 'Maximaler Y-Wert:',

   'Minimum x-value:'
=> 'Minimaler X-Wert:',

   'Minimum y-value:'
=> 'Minimaler Y-Wert:',

   'Pre-Processor Subroutine:'
=> 'Pre-Processor-Unterroutine:',

   'maxima'
=> 'Maxima',

   'R'
=> 'R',

   'Randomize Order:'
=> 'Zufällige Reihenfolge:',

   'Rank Value:'
=> 'Rangordnungswert:',

   'Spellcheck for:'
=> 'Rechtschreibprüfung für:',

   'Starting Molecule:'
=> 'Start-Molekül:',

   'Width of correct answer image:'
=> 'Breite des Korrekte-Antwort-Bildes:',

   'x-axis visible:'
=> 'X-Achse sichtbar:',

   'y-axis visible:'
=> 'Y-Achse sichtbar:',

   '1'
=> '1',

   '2'
=> '2',

   '3'
=> '3',

   '4'
=> '4',

   '5'
=> '5',

   '6'
=> '6',

   '7'
=> '7',

   '8'
=> '8',

   'Plain text'
=> 'Einfacher Texteditor',

   'Rich formatting'
=> 'WYSIWYG-Editor',

   'Disable rich text formatting and edit in plain text'
=> 'WYSIWYG-Editor deaktivieren und im einfachen Texteditor weiterarbeiten',

   'Enable rich text formatting (bold, italic, etc.)'
=> 'WYSIWYG-Editor aktivieren (Absätze, Fettschrift, etc.)',

   'Text Editor'
=> 'Texteditor',

   'Incomplete file upload'
=> 'Unvollständiges Hochladen einer Datei',

   'Return to the [_1]Authoring Space menu[_2] to upload a file'
=> 'Kehren Sie zum [_1]Autorenbereichs-Menü[_2] zurück, um eine Datei hochzuladen.',

   'Activity'
=> 'Aktiviät',

   'Message to user'
=> 'Nachricht an Benutzer',

   'Send message to specific user'
=> 'Nachricht an bestimmten Benutzer senden',

   'We were unable to retrieve data describing your search.'
=> 'Wir konnten die Daten Ihrer Suche nicht abrufen.',

   'Unable to tie hash to db file.'
=> 'Der Hash konnte nicht an die DB-Datei gebunden werden.',

   'Unable to create table in which to save search results. The search has been aborted.'
=> 'Die Tabelle zum Speichern der Suchergebnisse konnte nicht erstellt werden. Die Suche wurde abgebrochen.',

   'Unable to properly save search information. The search has been aborted.'
=> 'Die Suchinformationen konnten nicht korrekt gespeichert werden. Die Suche wurde abgebrochen.',

   'LON-CAPA Module Checking'
=> 'Überprüfung von LON-CAPA-Modulen',

   'Code checking unavailable for LON-CAPA CVS HEAD'
=> 'Die Code-Überprüfung ist für LON-CAPA-CVS-HEAD nicht verfügbar.',

   'Code integrity check -- LON-CAPA version: [_1]'
=> 'Code-Integritätstest -- LON-CAPA-Version [_1]',

   'No comparison attempted - failed to retrieve checksums for installed files.'
=> 'Es wurde kein Vergleich durchgeführt, da es nicht möglich war, die Checksummen der installierten Dateien zu abzurufen.',

   'No comparison attempted - unable to determine Linux distribution.'
=> 'Es wurde kein Vergleich durchgeführt, da es nicht möglich war, die Linux-Distribution zu ermitteln.',

   'A newer testing version of LON-CAPA: [_1]'
=> 'Eine neuere Testversion von LON-CAPA: [_1]',

   'A newer version of LON-CAPA: [_1]'
=> 'Eine neuere Version von LON-CAPA: [_1]',

   'Update check result -- [_1]'
=> 'Überprüfungsergebnis aktualisieren -- [_1]',

   'Check for LON-CAPA Module changes'
=> 'Überprüfung von Änderungen an LON-CAPA-Modulen',

   'Display "Contact Helpdesk" link'
=> '"Helpdesk kontaktieren"-Link anzeigen',

   'Credits'
=> 'Credits',

   'Credits: [_1]'
=> 'Credits: [_1]',

   'credits'
=> 'Credits',

   'Credits earned by students'
=> 'Credits, die durch Studierende erlangt wurden',

   'Default credits earned by student on course completion.'
=> 'Voreingestellte Credits, die durch Studierende nach Abschluss des Kurses erlangt sein werden',

   'Default credits'
=> 'Voreingestellte Credits',

   '[quant,_1,credit]'
=> '[quant,_1,Credit,Credits]',

   'Disk space allocated to Authoring Space'
=> 'Speicherplatz für Autorenbereich',

   'No changes made to user information'
=> 'An den Benutzerinformationen wurden keine Änderungen vorgenommen',

   'Custom-defined Units'
=> 'Eigene Einheiten',

   'Exam Code (graded CODEd exam containing randomorder/randompick).'
=> 'Prüfungs-Code (bewertete, mit CODE-versehene Prüfung mit zufälliger Reihenfolge / zufälliger Auswahl)',

   'Course/Community Activity'
=> 'Kurs-/Community-Aktivitäten',

   'Course/Community Created'
=> 'Kurs/Community wurde erstellt',

   'Course/Community Owner/Co-owner'
=> 'Kurs-/Community-Eigentümer / -Co-Eigentümer',

   'Course/Community Personnel Includes'
=> 'Kurs-/Community-Personal enthält',

   'Course/Community Title'
=> 'Kurs-/Community-Titel',

   'Lenient Grading (Partial Credit)'
=> 'Abgeschwächte Bewertung (teilweise Punktevergabe)',

   'Selecting a Kurs/Community'
=> 'Auswahl eines Kurses / einer Community',

   'Final x-value (optional):'
=> 'Endgültiger X-Wert (optional):',

   'Final x-value label (optional):'
=> 'Endgültige X-Wert-Beschriftung (optional):',

   'First derivative'
=> 'Erste Ableitung',

   'Second derivative'
=> 'Zweite Ableitung',

   'Function itself'
=> 'Funktion',

   'Index/Name:'
=> 'Index/Name:',

   'Index:'
=> 'Index:',

   'Initial x-value label:'
=> 'Initiale X-Wert-Beschriftung:',

   'Initial x-value:'
=> 'Initialer X-Wert:',

   'Initial y-value:'
=> 'Initialer Y-Wert:',

   'Integral'
=> 'Integral',

   'Maximum length for range (optional):'
=> 'Maximale Länge für Bereich (optional):',

   'Minimum length for range (optional):'
=> 'Minimale Länge für Bereich (optional):',

   'Order:'
=> 'Reihenfolge:',

   'Percent error:'
=> 'Fehlerprozent:',

   'Scale x:'
=> 'X-Skalierung:',

   'Scale y:'
=> 'Y-Skalierung:',

   'HTML Editor'
=> 'HTML-Editor',

   'Information'
=> 'Information',

   'Version Constraints'
=> 'Versionseinschränkungen',

   '(local rev: [_1])'
=> '(lokale Vers.: [_1])',

   '(expected rev: [_1])'
=> '(erwartete Vers.: [_1])',

   'The following [quant,_1,file appears,files appear] to have been modified locally:'
=> 'Die [quant,_1,folgende Datei wurde,folgenden Dateien wurden] offenbar lokal geändert:',

   'The following [quant,_1,file is a,files are] different version(s) from that expected for LON-CAPA [_2]:'
=> 'Die [quant,_1,folgende Datei hat,folgenden Dateien haben] eine unterschiedliche Version im Vergleich zu der von LON-CAPA [_2] erwarteten:',

   'The following [quant,_1,file is,files are] not required by the release you have installed:'
=> 'Die [quant,_1,folgende Datei wird,folgenden Dateien werden] für das installierte Release nicht benötigt:',

   '[quant,_1,difference was,differences were] found between LON-CAPA modules installed on your server [_2] and those expected for the LON-CAPA version you are currently running.'
=> '[quant,_1,Unterschied wurde,Unterschiede wurden] zwischen auf Ihrem Server [_2] installierten LON-CAPA-Modulen und solchen, die entsprechend der derzeit laufenden Version erwarteten, gefunden.',

   'Server version'
=> 'Serverversion',

   'Expected version'
=> 'erwartete Version',

   'IMS Upload'
=> 'IMS-Paket hochladen',

   'Upload Content'
=> 'Inhalt hochladen',

   '(Course Coordinators automatically have the right to clone their own courses.)  Format: user:domain, where &quot;user&quot; and &quot;domain&quot; are the LON-CAPA username and domain of the user. Separate different users with a comma. Use *:domain to allow course to be cloned by any course owner in the specified domain. Use * to allow unrestricted cloning by all course owners in all domains.'
=> '(Kurs-Koordinatoren haben automatisch die Berechtigung, ihre eigenen Kurse zu klonen.)  Format: &quot;benutzer:domäne&quot;, wobei &quot;benutzer&quot; und &quot;domäne&quot; die LON-CAPA-Benutzerkennung und Domäne des Benutzers sind. Trennen Sie mehrere Benutzer durch Kommata. Verwenden Sie &quot;*:domäne&quot;, um ein Klonen des Kurses für beliebige Kurseigentümer in der angegebenen Domäne zuzulassen. Verwenden Sie &quot;*&quot;, um uneingeschränktes Klonen für alle Kurseigentümer in allen Domänen zuzulassen.',

   'All settings which you can change with this Helper can also be changed by going to the &quot;Modify parameter settings&quot; screen and clicking on the &quot;Course Configuration&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click &quot;Next&quot;.'
=> 'Alle Einstellungen, die Sie mit diesem Hilfsprogramm ändern können, können auch über &quot;Einstellungen&quot; >> &quot;Inhaltseinstellungen&quot; ändern. Falls Sie mit der Koordination von LON-CAPA-Kursen keine Erfahrung haben oder falls Sie das Hilfsprogramm bevorzugen, dann klicken Sie bitte nun auf &quot;Weiter&quot;.',

   'After you select Finish Course Initialization, you will be taken to the Parameter Overview screen to update the dates for this cloned course.'
=> 'Nachdem Sie "Kursinitialisierung beenden" gewählt haben, werden sie auf die Parameter-Übersichts-Seite geleitet, um dort die Datumswerte des geklonten Kurses aktualisieren zu können.',

   'Your course is now set up. Please select the Save button to re-initialize the course with your chosen settings. Remember that all of these settings can be modified in the Modify parameter settings screen (Course Configuration).'
=> 'Ihr Kurs ist nun einsatzbereit. Bitte klicken Sie auf den Speichern-Button, um den Kurs mit den von Ihnen gewählten Einstellungen neu zu initialisieren. Beachten Sie, dass alle diese Einstellungen jederzeit in den Inhaltseinstellungen (Kurs-Konfiguration) angepasst werden können.',

   'Course credits'
=> 'Kurs-Credits',

   'Student credits'
=> 'Studentische Credits',

   'Student Credits'
=> 'Studentische Credits',

   'credits (students)'
=> 'Credits (Studierende)',

   'Credits (students)'
=> 'Credits (Studierende)',

   'Default credits for textbook courses'
=> 'Voreingestellte Credits für Lehrbuch-Kurse',

   'Default credits can also be specified, if different from the domain defaults (official courses: [_1]; unofficial courses: [_2]; textbook courses: [_3]).'
=> 'Voreingstellte Credits können ebenso angegeben werden, falls sie sich von den Domänenvoreinstellungen unterscheiden (offizielle Kurse: [_1], inoffizielle Kurse: [_2], Lehrbuch-Kurse: [_3]).',

   'the number of institutional credits students will earn by completing this course'
=> 'Anzahl institutioneller Credits, die Studierende durch Abschließen dieses Kurses erhalten',

   'Credits can be specified for courses'
=> 'Für Kurse können Credits angegeben werden',

   'Default credits for official courses [_1]'
=> 'Voreingestellte Credits für offizielle Kurse [_1]',

   'Default credits for unofficial courses [_1]'
=> 'Voreingestellte Credits für inoffizielle Kurse [_1]',

   'Default quota for files uploaded directly to course/community using Course Editor (MB)'
=> 'Voreingestellter Speicherplatz für Dateien, die über den Kurs-Editor direkt in den Kurs / in die Community hochgeladen werden (MB)',

   "Disk space allocated to user's Authoring Space (if role assigned)"
=> 'Dem Autorenbereich des Benutzers zugewiesener Speicherplatz (falls Rolle zugewiesen ist)',

   'Some resources in the sequence currently are not set to exam mode. Grading these resources currently may not work correctly.'
=> 'Einige Ressourcen in der Sequenz sind momentan auf Prüfungsmodus gestellt. Eine Bewertung dieser Ressourcen könnte derzeit fehlschlagen.',

   'Unable to accept last correction, an error occurred: [_1]'
=> 'Die letzte Korrektur konnte nicht angenommen werden. Es ist ein Fehler aufgetreten: [_1]',

   'Domain Coordinators in course'
=> 'Domänen-Koordinatoren im Kurs',

   "Domains to check for privileged users (besides course's domain)"
=> 'Domänen, die auf privilegierte Benutzer überprüft werden sollen (neben der Domäne des Kurses)',

   'Existing courses can be cloned when creating new courses. Cloning will copy the course structure, contents, and most settings. For dates (open dates, due dates etc.) a choice is provided to: (a) omit, (b) copy as-is or (c) shift by a specified number of days. Usernames of owners of other courses permitted to clone this course:'
=> 'Bestehende Kurse können im Zuge der Erstellung neuer Kurse geklont werden. Das Klonen wird den Kursaufbau, die Inhalte und die meisten der Einstellungen kopieren. Für Datumswerte (Startdatum, Fälligkeitsdatum, etc.) steht eine Auswahl zur Verfügung: (a) auslassen, (b) kopieren wie vorhanden und (c) verschieben anhand einer angegebenen Anzahl an Tagen. Benutzerkennungen von Eigentümern anderer Kurse, die berechtigt sein sollen, diesen Kurs zu klonen:',

   'Shift'
=> 'Verschieben',

   'Shifting Dates'
=> 'Verschiebe Datumswerte',

   'Upload Slots File'
=> 'Slots-Datei hochladen',

   'All content in Course'
=> 'Gesamter Inhalt im Kurs',

   'All content in Community'
=> 'Gesamter Inhalt in der Community',

   'Clipboard is already empty'
=> 'Zwischenablage ist bereits leer',

   'Clipboard unchanged'
=> 'Zwischenablage unverändert',

   'Copy to new board'
=> 'In neue Zwischenablage kopieren',

   'Copy to new file'
=> 'In neue Datei kopieren',

   'Failed to save new web page.'
=> 'Das Speichern der neuen Webseite ist fehlgeschlagen.',

   'Move (not posts)'
=> 'Verschieben (ohne Diskussionsbeiträge)',

   'Nothing selected to clear from clipboard'
=> 'Es wurde nichts ausgewählt, das aus der Zwischenablage entfernt werden könnte.',

   'Paste failed: An error occurred when copying the discussion board.'
=> 'Einfügen fehlgeschlagen: Beim Kopieren des Diskussionsforums ist ein Fehler aufgetreten.',

   'Paste into Supplemental Content unavailable.'
=> 'Einfügen in den zusätzlichen Inhalt ist nicht verfügbar.',

   'Replace with your own content.'
=> 'Geben Sie hier Ihren eigenen Inhalt ein.',

   'This will prevent creation of additional discussion boards in this course.'
=> 'Dies wird das Erstellen weiterer Diskussionsforen in diesem Kurs verhindern.',

   'This will prevent creation of additional simple pages in this course.'
=> 'Dies wird das Erstellen weiterer einfacher Seiten in diesem Kurs verhindern.',

   'This will prevent use of the paste buffer until th next log-in.'
=> 'Dies wird das Verwenden der Zwischenablage bis zum nächsten Login verhindern.',

   'Web Page'
=> 'Webseite',

   'Reading folder contents failed'
=> 'Lesen des Verzeichnisinhalts ist fehlgeschlagen',

   'Storage of folder contents failed'
=> 'Speichern des Verzeichnisinhalts ist fehlgeschlagen',

   'All feeds currently hidden'
=> 'Es sind bereits alle Feeds verborgen.',

   'An error occurred creating the minimal template file [_1]'
=> 'Beim Erstellen der minimalen Vorlagedatei [_1] ist ein Fehler aufgetreten.',

   'An error occurred storing the external URL: [_1]'
=> 'Beim Speichern der externen URL [_1] ist ein Fehler aufgetreten.',

   'An error occurred storing the template: [_1]'
=> 'Beim Speichern der Vorlage [_1] ist ein Fehler aufgetreten.',

   'An error occurred storing the uploaded file [_1]'
=> 'Beim Speichern der hochgeladenen Datei [_1] ist ein Fehler aufgetreten.',

   'External URL not saved -- invalid URL.'
=> 'Externe URL nicht gespeichert - ungültige URL.',

   'External URL saved.'
=> 'Externe URL wurde gespeichert',

   'External URL unchanged.'
=> 'Externe URL unverändert',

   'Manage Course RSS Feeds/Blogs'
=> 'Kurs-RSS-Feeds/-Blogs verwalten',

   'Manage Community RSS Feeds/Blogs'
=> 'Community-RSS-Feeds/-Blogs verwalten',

   'No current feeds'
=> 'Keine aktuellen Feeds',

   'No file uploaded'
=> 'Keine Datei hochgeladen',

   'Personnel (hidden if checked)'
=> 'Personal (verborgen, falls ausgewählt)',

   'Print the syllabus directly from your web browser'
=> 'Den Kursüberblick direkt in Ihrem Webbrowser drucken',

   'Public link (no log-in): [_1]'
=> 'Öffentlicher Link (ohne Login): [_1]',

   "RSS Feeds and Blogs item is not included in a student's view of the syllabus."
=> 'RSS-Feed- und Blog-Element ist nicht in der studentischen Sicht des Kursüberblicks enthalten.',

   'Role hidden?'
=> 'Rolle verborgen?',

   'Syllabus File'
=> 'Kursüberblicks-Datei',

   'Syllabus file: [_1]'
=> 'Kursüberblicks-Datei: [_1]',

   'Syllabus file unavailable'
=> 'Kursüberblicks-Datei nicht verfügbar',

   'Template saved.'
=> 'Vorlage gespeichert',

   'Title of Syllabus Page:'
=> 'Titel der Kursüberblicks-Seite:',

   'Unsupported file type.'
=> 'Nicht unterstützter Dateityp',

   'Are you sure you want to delete the contents of the syllabus template?'
=> 'Sind Sie sicher, dass Sie den Inhalt der Kursüberblicks-Vorlage löschen möchten?',

   'Are you sure you want to delete the uploaded syllabus file?'
=> 'Sind Sie sicher, dass Sie die hochgeladene Kursüberblicks-Datei löschen möchten?',

   'Choose template items ... '
=> 'Vorlage-Elemente auswählen... ',

   'External URL'
=> 'Externe URL',

   'externalurl'
=> 'externalurl',

   'Syllabus (minimal template)'
=> 'Kursüberblick (Minimale Vorlage)',

   'Minimal template'
=> 'Minimale Vorlage',

   'Standard template'
=> 'Standard-Vorlage',

   'Syllabus Type'
=> 'Typ des Kursüberblicks',

   'This action cannot be reversed.'
=> 'Diese Aktion kann nicht rückgängig gemacht werden.',

   'Uploaded file'
=> 'Hochgeladene Datei',

   'Uploaded syllabus file'
=> 'Hochgeladene Kursüberblicks-Datei',

   '(Syllabus type in use)'
=> '(vewendeter Typ des Kursüberblicks)',

   'Changed section(s) for [quant,_1,user role,user roles,no user roles].'
=> 'Sektion(en) für [quant,_1,Benutzerrolle,Benutzerrollen,keine Benutzerrollen] geändert',

   'No data exists for attempt [_1]'
=> 'Für Versuch [_1] existieren keine Daten.',

   'No differences detected between installed files and files expected for LON-CAPA [_1]'
=> 'Zwischen den installierten Dateien und den erwarteten Dateien für LON-CAPA [_1] wurden keine Unterschiede festgestellt.',

   'Ordered'
=> 'sortiert',

   'Unordered'
=> 'unsortiert',

   'Collaborative submission by: [_1]'
=> 'Kollaborative Einreichung von [_1]',

   'Error: could not update links in [_1].'
=> 'Fehler: Konnte [_1] konnten die Links aktualisiert werden.',

   'No dependencies need to be uploaded, as one of the following applies to each reference:'
=> 'Es brauchen keine Abhängigkeiten hochgeladen werden, da auf jede Referenz einer der folgenden Punkte zutrifft:',

   'Rewrote [quant,_1,link] as [quant,_1,absolute link] in [_2].'
=> 'In [_2] wurde(n) [quant,_1,Link,Links] als [quant,_1,absoluter Link,absolute Links] neu geschrieben.',

   'Items in course for which access will be blocked.'
=> 'Elemente im Kurs, auf die der Zugriff gesperrt werden wird.',

   'Items in community for which access will be blocked.'
=> 'Elemente in der Community, auf die der Zugriff gesperrt werden wird.',

   "Disk quotas for user's portfolio and Authoring Space"
=> 'Speicherplatz für Portfolio und Autorenbereich des Benutzers',

   'Visit the help page for '
=> 'Konsultieren Sie die Hilfeseite für ',

   'Default role, section and credits'
=> 'Voreingestellte Rolle, Sektion und Credits',

   'Choose the role and/or section(s) and/or credits to assign to users without values specified in the uploaded file.'
=> 'Wählen sie die Rolle und/oder Sektion(en) und/oder Credits, die Benutzern zugewiesen werden sollen, für die in der hochgeladenen Datei keine Werte angegeben wurden.',

   'You may not specify an initial password for each user, as this is only available when new users use LON-CAPA internal authentication.'
=> 'Sie können nicht für jeden einzelnen Benutzer ein initiales Passwort angeben, da dies nur verfügbar ist, wenn neue Benutzer interne Authentifizierung verwenden.',

   'You may not specify an initial password, as this is only available when new users use LON-CAPA internal authentication.'
=> 'Sie können nicht ein initiales Passwort angeben, da dies nur verfügbar ist, wenn neue Benutzer interne Authentifizierung verwenden.',

   'Unable to retrieve current settings.'
=> 'Derzeitige Einstellungen konnten nicht abgerufen werden.',

   'Show count for current student access'
=> 'Zähler für aktuellen studentischen Zugriff zeigen',

   'Show count for future student access'
=> 'Zähler für zukünftigen studentischen Zugriff zeigen',

   'Show count for past access'
=> 'Zähler für in der Vergangenheit liegenden studentischen Zugriff zeigen',

   'Total communities'
=> 'Gesamtanzahl Communitys',

   'Total cross-listings'
=> 'Gesamtanzahl Querverweise',

   'Total current members'
=> 'Gesamtanzahl aktueller Teilnehmer',

   'Total future members'
=> 'Gesamtanzahl zukünftiger Teilnehmer',

   'Total previous members'
=> 'previous members',

   'Total current student credit hours'
=> 'Gesamtanzahl aktueller studentischer SWS',

   'Total future student credit hours'
=> 'Gesamtanzahl zukünftiger studentischer SWS',

   'Total previous student credit hours'
=> 'Gesamtanzahl in der Vergangenheit liegender studentischer SWS',

   'Total current students'
=> 'Gesamtanzahl aktueller Studierender',

   'Total future students'
=> 'Gesamtanzahl zukünftiger Studierender',

   'Total previous students'
=> 'Gesamtanzahl in der Vergangenheit liegender Studierender',

   'Total sections'
=> 'Gesamtanzahl Sektionen',

   'Total unique codes and courses without codes'
=> 'Gesamtanzahl eindeutiger Codes und Kurse ohne Codes',

   'immediately prior to default end access date'
=> 'sofort vor dem voreingestellten Endzugriffsdatum',

   'immediately prior to end date for auto-enrollment'
=> 'sofort vor dem Enddatum der automatischen Kursbelegung',

   'immediately prior to specific date:'
=> 'sofort vor einem bestimmten Datum:',

   'where member access status was current ...'
=> 'mit Teilnehmer-Zugriffsstatus war derzeit...',

   'where student access status was current ...'
=> 'mit studentischem Zugriffsstatus war derzeit...',

   "Course's domain is only domain"
=> 'Die Domäne des Kurses ist die einzige Domäne.',

   'Default is [quant,_1,credit]'
=> 'Voreingestellt: [quant,_1,Credit,Credits]',

   'A problem occurred when trying to reinstate [_1] of the [_2] members of the pre-existing group.'
=> 'Beim Reaktivieren von [_1] der [_2] Teilnehmer der zuvor existenten Gruppe ist ein Fehler aufgetreten.',

   "An error occurred while retrieving the contents of the group's folder."
=> 'Beim Abrufen der Inhalte des Gruppenverzeichnisses ist ein Fehler aufgetreten.',

   'Could not obtain exclusive lock to check status of the folder for all groups. No group folder added.'
=> 'Zum Prüfen des Status des Verzeichnisses für alle Gruppen konnten nicht die exklusiven Sperrrechte erlangt werden. Es wurden daher kein Gruppenverzeichnis hinzugefügt.',

   'Error reading course contents.'
=> 'Beim Abrufen des Kursinhalts ist ein Fehler aufgetreten.',

   'Error retrieving course contents'
=> 'Beim Abrufen des Kursinhalts ist ein Fehler aufgetreten.',

   'Group successfully re-enabled.'
=> 'Die Gruppe wurde erfolgreich wiederhergestellt.',

   'Parameters not set for [_1] because the contents of the course could not be retrieved.'
=> 'Die Parameter für [_1] wurden nicht gesetzt, da der Kursinhalt nicht abgerufen werden konnte.',

   'There were no group members to reinstate, as none were removed when the group was deleted.'
=> 'Es gibt keine Gruppenmitglieder, die reaktiviert werden könnten, da bis zum Zeitpunkt des Löschens der Gruppe keine Mitglieder entfernt worden waren.',

   'Tool'
=> 'Werkzeug',

   'Disk space for storage of content directly uploaded to course via Content Editor'
=> 'Speicherplatz für über den Inhaltseditor direkt in den Kurs hochgeladenen Inhalt',

   'Disk space allocated for storage of content uploaded directly to a course via Content Editor.'
=> 'Zugewiesener Speicherplatz für über den Inhaltseditor direkt in den Kurs hochgeladenen Inhalt',

   'Disk space allocated for storage of content uploaded directly to a community via Content Editor.'
=> 'Zugewiesener Speicherplatz für über den Inhaltseditor direkt in die Community hochgeladenen Inhalt',

   'The disk space allocated for content uploaded directly via the Content Editor is now: [_1] MB.'
=> 'Der zugewiesene Speicherplatz für über den Inhaltseditor direkt hochgeladenen Inhalt ist nun [_1] MB.',

   'The disk space allocated for files uploaded via the Content Editor remains unchanged as [_1] MB.'
=> 'Der zugewiesene Speicherplatz für Dateien, die über den Inhaltseditor hochgeladenen wurden, bleibt unverändert bei [_1] MB.',

   'Disk space quotas for course: [_1]'
=> 'Speicherplatz für den Kurs [_1]',

   'Disk space quotas for community: [_1]'
=> 'Speicherplatz für die Community [_1]',

   'Set disk space quotas for course: [_1]'
=> 'Speicherplatz für den Kurs [_1] festlegen',

   'Set disk space quotas for community: [_1]'
=> 'Speicherplatz für die Community [_1] festlegen',

   'The proposed group portfolio quota contained invalid characters, so the quota is unchanged.'
=> 'Die Eingabe des gewünschten Speicherplatzes für das Gruppen-Portfolio enthält ungültige Zeichen, so dass der Speicherplatz unverändert bleibt.',

   'The proposed quota for content uploaded via the Content Editor contained invalid characters, so the quota is unchanged.'
=> 'Die Eingabe des gewünschten Speicherplatzes für über den Inhaltseditor direkt hochgeladenen Inhalt enthält ungültige Zeichen, so dass der Speicherplatz unverändert bleibt.',

   'A listing of possible course targets will be displayed if import of discussion boards and/or enrollment is checked above (step 3). If you do not plan to import either of these content types, there is no need to specify a course.'
=> 'Eine Liste von möglichen Kurszielen wird angezeigt, falls der Import von Diskussionsforen und/oder Belegungen oben ausgewählt wurde (Schritt 3). Falls Sie keine diese Inhaltstypen importieren möchten, brauchen Sie keinen Kurs anzugeben.',

   'A total of [quant,_1,sequence], [quant,_2,composite page], [quant,_3,discussion board], [quant,_4,quiz,quizzes], [quant,_5,survey], and [quant,_6,problem] have been created, and [quant,_7,file] copied.'
=> 'Insgesamt wurden [quant,_1,Sequenz,Sequenzen], [quant,_2,Zusammengesetzte Seite,Zusammengesetzte Seiten], [quant,_3,Diskussionsforum,Diskussionsforen], [quant,_4,Quiz,Quizzes], [quant,_5,Umfrage,Umfragen] und [quant,_6,Aufgabe,Aufgaben] erstellt und [quant,_7,Datei,Dateien] kopiert.',

   'A total of [quant,_1,sequence], [quant,_2,composite page], and [quant,_3,discussion board] have been created, and [quant,_4,file] copied.'
=> 'Insgesamt wurden [quant,_1,Sequenz,Sequenzen], [quant,_2,Zusammengesetzte Seite,Zusammengesetzte Seiten], [quant,_3,Diskussionsforum,Diskussionsforen] und [quant,_4,Datei,Dateien] kopiert.',

   'Choose a course to receive discussion boards and user enrollment'
=> 'Wählen Sie einen Kurs, für den die Diskussionsforen und die Benutzer-Kursbelegungen bestimmt sind',

   "If you wish to import discussion boards and/or user information into LON-CAPA please click 'Exit now' to quit the current IMS import process, and contact your domain coordinator and request a course coordinator role in a LON-CAPA course into which you can upload discussion boards and/or enroll users."
=> "Falls Sie Diskussionsforen und/oder Benutzerinformationen in LON-CAPA importieren möchten, klicken Sie bitte 'Jetzt verlassen', um den aktuellen IMS-Import-Vorgang abzubrechen und kontaktieren Sie Ihren Domänen-Koordinator. Beantragen Sie eine Kurs-Koordinator-Rolle für einen LON-CAPA-Kurs, in den Sie dann Diskussionsforen hochladen und/oder Benutzer den Kurs belegen lassen können.",

   'You do not have active course coordinator status in any LON-CAPA courses currently, so discussion boards and enrollment information included in your IMS package will be discarded, regardless of your import choice for these two items above (step 3).'
=> 'Sie haben in keinem LON-CAPA-Kurs eine aktive Kurs-Koordinatoren-Rolle. Daher werden Diskussionsforen und Kursbelegungs-Informationen in Ihrem IMS-Paket verworfen, unabhängig von Ihrer getroffenen Import-Auswahl für diese beiden Elemente (Schritt 3).',

   'IMS import completed'
=> 'IMS-Import abgeschlossen',

   'Attempt [_1]'
=> 'Versuch [_1]',

   '% Answered Correct'
=> '% korrekte Antworten',

   '% Chosen Incorrectly'
=> '% falsch gewählt',

   'Correct Concepts'
=> 'Korrekte Konzepte',

   'Correct Foil'
=> 'Korrekte Ausw.-mögl.',

   'Statement'
=> 'Angabe',

   'Statement Number'
=> 'Nummer der Angabe',

   'Correct Statements'
=> 'Korrekte Angaben',

   'Incorrect Statements'
=> 'Inkorrekte Angaben',

   'Difference from Correct'
=> 'Unterschiede zu korrekt',

   'Incorrect Option Choice'
=> 'Inkorrekte Optionsauwahl',

   'Percent Choosing'
=> 'Prozent ausgewählt',

   'Percent Correct'
=> 'Prozent korrekt',

   'Percent Difference from Correct'
=> 'Prozent Unterschied zu korrekt',

   'Percent of Answers'
=> 'Prozent an Antworten',

   'concept'
=> 'Konzept',

   'foil chosen'
=> 'gewählte Ausw.-mögl.',

   'foils chosen Incorrectly'
=> 'inkorrekt gewählte Ausw.-mögl.',

   'Mean and S.D. of Tries'
=> 'Durchschn. u. Std.-Abw. d. Vers.', # Standardabweichung der Versuche

   'Mean and Standard Deviation of Tries'
=> 'Durchschnitt und Standardabweichung der Versuche',

   'Mean and S.D of Tries Plot'
=> 'Durchschn.- u. Std.-Abw.-d.-Vers.-Plot',

   'Authoring'
=> 'Autorentätigkeit',

   'Authoring Space default quotas'
=> 'Voreingestellter Speicherplatz für Autorenbereiche',

   'Banner for login role'
=> 'Banner für Login-Rolle',

   'Default quota for content uploaded to a course/community via Course Editor set as follows:'
=> 'Voreingestellter Speicherplatz für Inhalt, der über den Kurs-Editor in einen Kurs / eine Community hochgeladen wurde, wie folgt eingestellt:',

   'Default quota for content uploaded via Course Editor remains default: [_1] MB'
=> 'Voreingestellter Speicherplatz für Inhalt, der über den Kurs-Editor hochgeladen wurde, bleibt unverändert beim voreingestellten Wert von [_1] MB.',

   'E-mail from bi-nightly check for multiple users sharing same student/employee ID'
=> 'E-Mail von alle zwei Nächte stattfindender Überprüfung auf mehrere Benutzer, ob die gleiche Studierenden-/Mitarbeiter-ID verwendet wird',

   'E-mail from nightly check of LON-CAPA module integrity/updates'
=> 'E-Mail von nächtlicher Überprüfung der LON-CAPA-Modulintegrität/-aktualisierungen',

   'However, that does not apply when new domains are added to a multi-domain server, and ./UPDATE has not been run recently.'
=> 'Dies trifft allerdings nicht zu, wenn neue Domänen zu einem Multi-Domänen-Server hinzugefügt werden und "./UPDATE" in letzter Zeit nicht ausgeführt wurde.',

   'Communities: [_1] MB'
=> 'Communitys: [_1] MB',

   'Official courses: [_1]'
=> 'Offizielle Kurse: [_1]',

   'Official courses: [_1] MB'
=> 'Offizielle Kurse: [_1] MB',

   'Unofficial courses: [_1]'
=> 'Inoffizielle Kurse: [_1]',

   'Unofficial courses: [_1] MB'
=> 'Inoffizielle Kurse: [_1] MB',

   'Once that is done, you will be able to use the web-based "Set domain configuration" to configure the domain'
=> 'Sobald das erledigt ist, können Sie die webbasierte "Domänen-Konfiguration" verwenden, um Ihre Domäne zu konfigurieren.',

   'Ordinarily, that domain configuration user is created when the ./UPDATE script is run to install LON-CAPA for the first time.'
=> 'Üblicherweise wir der Domänen-Konfigurations-Benutzer erstellt, wenn das "./UPDATE"-Skript bei der Erstinstallation von LON-CAPA ausgeführt wird.',

   'Student credits can be set per course by a Domain Coordinator, with the following defaults applying:'
=> 'Studentische Credits können pro Kurs durch einen Domänen-Koordinator gesetzt werden. Folgende Voreinstellungen gelten:',

   'Student credits not in use for courses in this domain'
=> 'Für Kurse in dieser Domäne sind keine studentischen Credits in Verwendung.',

   'The "[_1]" user can be created automatically when a Domain Coordinator visits the web-based "Set domain configuration" screen, in a session hosted on the primary library server.'
=> 'Der "[_1]"-Benutzer wird automatisch erstellt, wenn ein Domänen-Koordinator die web-basierte "Domänen-Konfiguration"-Seite aufruft (sofern dies in einer Sitzung geschieht, die auf dem primären Library-Server gehostet wird).',

   'The domain configuration user "[_1]" has yet to be created.'
=> 'Der Domänen-Konfigurations-Benutzer "[_1]" muss noch erstellt werden.',

   'To create that user from the command line run the ./UPDATE script found in the top level directory of the extracted LON-CAPA tarball.'
=> 'Um diesen Benutzer über die Kommandozeile zu erstellen, führen Sie das "./UPDATE"-Skript aus. Sie finden das Skript in dem Hauptverzeichnis des extrahierten LON-CAPA-Installationspakets ("tarball").',

   'To do that now, use the following link: [_1]'
=> 'Um dies jetzt zu machen, folgen Sie dem Link: [_1]',

   'Upload of [_1] image for login page(s) failed because a Domain Configuration user ([_2]) could not be created in domain: [_3].  Error was: [_4].'
=> 'Das Hochladen des [_1]-Bildes für die Login-Seite(n) ist fehlgeschlagen, da ein Domänen-Konfigurations-Benutzer ([_2]) für die Domäne [_3] nicht erstellt werden konnte. Der Fehler war: [_4]',

   'Upload of [_1] image for login page(s) failed because an author role could not be assigned to a Domain Configuration user ([_2]) in domain: [_3].  Error was: [_4].'
=> 'Das Hochladen des [_1]-Bildes für die Login-Seite(n) ist fehlgeschlagen, da an den Domänen-Konfigurations-Benutzer ([_2]) für die Domäne [_3] keine Autorenrolle zugewiesen werden konnte. Der Fehler war: [_4]',

   'Upload of [_1] image for login page(s) failed because an error occurred publishing the file in RES space. Error was: [_2].'
=> 'Das Hochladen des [_1]-Bildes für die Login-Seite(n) ist fehlgeschlagen, da beim Veröffentlichen der Datei in den Ressourcenpool ein Fehler aufgetreten ist. Der Fehler war: [_2]',

   'Upload of [_1] image for login page(s) is not permitted to this server: [_2]'
=> 'Das Hochladen des [_1]-Bildes für die Login-Seite(n) ist für diesen Server [_2] nicht zulässig.',

   'After Answer Date Block'
=> 'Block: nach dem Antwortverfügbarkeitsdatum',

   'Before Due Date Block'
=> 'Block: vor dem Fälligkeitsdatum',

   'Block For After Solved'
=> 'Block: nach dem korrekten Beantworten',

   'Block For When Not Solved'
=> 'Block: noch nicht korrekt beantwortet',

   'Conditional Block'
=> 'Block: bedingungsabhängig',

   'Display Script Result Block'
=> 'Block: Anzeige der Skript-Ergebnisse',

   'Problem Type Block'
=> 'Block: Aufgabentyp',

   'Randomly Parsed Block'
=> 'Block: zufällig geparst',

   'Answer algorithm'
=> 'Antwort-Algorithmus',

   'Background Function Plot'
=> 'Hintergrund-Funktionsplot',

   'Background Plot'
=> 'Hintergrundplot',

   'Closing Information'
=> 'Schließungsinformationen',

   'Collection of Answers'
=> 'Sammlung von Antworten',

   'Collection of Foils'
=> 'Sammlung von Auswahlmöglichkeiten',

   'Collection of similar foils'
=> 'Sammlung von ähnlichen Auswahlmöglichkeiten',

   'Criteria Information'
=> 'Kriterieninformationen',

   'Curve data'
=> 'Liniendaten',

   'Curve function'
=> 'Linienfunktion',

   'Display Due Date'
=> 'Anzeige des Fälligkeitsdatums',

   'Draw Option List'
=> 'Optionsliste anzeigen',

   'Draw Vector Sum'
=> 'Vektorsumme anzeigen',

   'File Dependencies'
=> 'Dateiabhängigkeiten',

   'Function Plot Custom Rule'
=> 'Eigene Regel für Funktionsplot',

   'Graph Rule'
=> 'Graphenregel',

   'Function Plot Graph Rule'
=> 'Graphenregel für Funktionsplot',

   'Vector Rule'
=> 'Vektorregel',

   'Function Plot Vector Rule'
=> 'Vektorregel für Funktionsplot',

   'Vector Sum Rule'
=> 'Vektorsummenregel',

   'Function Plot Vector Sum Rule'
=> 'Vektorsummenregel für Funktionsplot',

   'GnuPlot'
=> 'GnuPlot',

   'Group of Labels'
=> 'Gruppe von Beschriftungen',

   'How to write adaptive hints'
=> 'So erstellt man adaptive Hinweise',

   'How to write custom responses'
=> 'So erstellt man Freie-Programmierungs-Aufgaben (Customresponse)',

   'How to write external responses'
=> 'So erstellt man extern bewertete Aufgaben (externalresponse)',

   'How to write hints'
=> 'So erstellt man Hinweise',

   'How to write math responses'
=> 'So erstellt man mathematische Aufgaben',

   'How to create problems in different languages'
=> 'So erstellt man Aufgaben in verschiedenen Sprachen',

   'Imageresponse Image'
=> 'Bild für Klick-ins-Bild-Antwort',

   'Import Script Library'
=> 'Import: Skript-Bibliothek',

   'Import Tag Definitions'
=> 'Import: Tag-Definitionen',

   'Import a File'
=> 'Import: Datei',

   'Information for the Instance'
=> 'Informationen für die Instanz',

   'Introductory Information'
=> 'Einführende Informationen',

   'Item to Match'
=> 'Element, das zugeordnet wird',

   'Label Location'
=> 'Stelle der Beschriftung',

   'Label Text'
=> 'Beschriftungstext',

   'Large Text Entry Area'
=> 'Eingabebereich großes Textfeld',

   'Hint algorithm'
=> 'Hinweis-Algorithmus',

   'Conditional Hint'
=> 'Bedingungsabhängiger Hinweis',

   'Custom Hint Condition'
=> 'Bedingung für Freie-Programmierung(Custom)-Hinweis',

   'Formula Hint Condition'
=> 'Bedingung für Formel-Hinweis',

   'Math Hint Condition'
=> 'Bedingung für mathematischen Hinweis',

   'Numerical Hint Condition'
=> 'Bedingung für numerischen Hinweis',

   'Option Response Hint Condition'
=> 'Bedingung für Optionsantwort-Hinweis',

   'Organic Hint Condition'
=> 'Bedingung für organischen Hinweis',

   'Radiobutton Hint Condition'
=> 'Bedingung für Radiobutton-Hinweis',

   'Reaction Hint Condition'
=> 'Bedingung für Reaktions-Hinweis',

   'String Hint Condition'
=> 'Bedingung für Texteingabe-Hinweis',

   'Option response foil'
=> 'Auswahlmöglichkeit für Optionsauswahl',

   'Organic Structure'
=> 'Organische Struktur',

   'Parameters for a part'
=> 'Parameter für einen Aufgabenteil',

   'Perl Script Block'
=> 'Perl-Skript-Block',

   'Plot Curve'
=> 'Plotlinie',

   'Plot Key'
=> 'Plotschlüssel',

   'Plot Label'
=> 'Plotbeschriftung',

   'Plot Object'
=> 'Plotobjekt',

   'Plot Title'
=> 'Plottitel',

   'Plot Vector'
=> 'Plotvektor',

   'Plot axes'
=> 'Plotachsen',

   'Plot tics'
=> 'Plot-Tics',

   'Plot xtics'
=> 'Plot-X-Tics',

   'Plot ytics'
=> 'Plot-Y-Tics',

   'Plot x-label'
=> 'Plot-X-Beschriftung',

   'Plot y-label'
=> 'Plot-Y-Beschriftung',

   'Polygonal area in image'
=> 'Polygonaler Bereich im Bild',

   'Rectangular area in image'
=> 'Rechteckiger Bereich im Bild',

   'Problem Part: Marker for Start of New Part'
=> 'Aufgabenteil: Markierung für den Start eines neuen Teils',

   'Problem Part: Marker for End of New Part'
=> 'Aufgabenteil: Markierung für das Ende eines neuen Teils',

   'Question'
=> 'Frage',

   'Question Criteria'
=> 'Fragekriterien',

   'Question Information'
=> 'Frageinformationen',

   'Response: Chemical Reaction'
=> 'Antwortblock: Chemische Reaktion',

   'Response: Custom'
=> 'Antwortblock: Freie Programmierung (customresponse)',

   'Response: Essay'
=> 'Antwortblock: Essay',

   'Response: External'
=> 'Antwortblock: Externe Bewertung',

   'Response: Formula'
=> 'Antwortblock: Formel',

   'Response: Function Plot'
=> 'Antwortblock: Funktionsplot',

   'Response: Match Two Lists'
=> 'Antwortblock: Indirekte Zuordnung',

   'Response: Math'
=> 'Antwortblock: Mathematisch',

   'Response: One of N statements'
=> 'Antwortblock: Single Choice (1-aus-N-Auswahl / Radiobutton)',

   'Response: Organic Chemical Structure'
=> 'Antwortblock: Organisch-chemische Struktur',

   'Response: Rank Values'
=> 'Antwortblock: Rangordnung',

   'Response: Select from Options'
=> 'Antwortblock: Auswahl aus Optionen',

   'Response: String'
=> 'Antwortblock: Text',

   'Setup....'
=> 'Setup ...',

   'Specific Question Instance'
=> 'Bestimmte Antwortinstanz',

   'Spline'
=> 'Spline',

   'Start of Homework'
=> 'Beginn der Hausübung',

   'Start of Library'
=> 'Beginn der Bibliothek',

   'Start of Task'
=> 'Beginn des Tasks',

   'Stored Entry Field'
=> 'Feld für gespeicherte Eingabe',

   'TeX Only Block'
=> 'Nur-TeX-Block',

   'Web Only Block'
=> 'Nur-Web-Block',

   'Text In Separate Window'
=> 'Text in Extrafenster',

   'Text/HTML Block'
=> 'Text-/HTML-Block',

   'Text to describe option'
=> 'Text, der die Option beschreibt',

   'Text to display to Grader'
=> 'Text, der dem Bewerter gezeigt wird',

   'Vector'
=> 'Vektor',

   'While Loop Block'
=> 'While-Schleifen-Block',

   '(All fields marked with * are required.)'
=> '(Alle mit * markierten Felder sind Pflichtfelder.)',

   'required'
=> 'Pflichtfeld',

   'Fields marked [_1]*[_2] are required.'
=> 'Alle mit [_1]*[_2] markierten Felder sind Pflichtfelder.',

   'One or more required fields are currently blank.'
=> 'Eins oder mehrere Pflichtfelder sind leer.',

   'Course Coordination'
=> 'Kurs-Koordination',

   'Course Index'
=> 'Kurs-Index',

   'Custom Rights Editor'
=> 'Editor für maßgeschneiderte Zugriffsrechte',

   'Defining Role'
=> 'Lege Rolle fest',

   'Help Settings (logged-in users)'
=> 'Einstellungen der Hilfe (für eingeloggte Benutzer)',

   'Online manuals'
=> 'Online-Handbücher',

   'Printable manuals'
=> 'Druckbare Handbücher',

   'Page of Materials'
=> 'Seite mit Material',

   'Cloned from'
=> 'geklont von',

   'Unique code'
=> 'Eindeutiger Code',

   'Attempt'
=> 'Versuch',

   'Attempt: [_1]'
=> 'Versuch [_1]',

   'Award Detail'
=> 'Erreichungsdetails',

   'Award Detail: [_1]'
=> 'Erreichungsdetails: [_1]',

   'Awarded'
=> 'Erreicht',

   'Awarded: [_1]'
=> 'Erreicht: [_1]',

   'Time: [_1]'
=> 'Zeit: [_1]',

   'Group information missing'
=> 'Gruppeninformationen fehlen',

   'Invalid Call'
=> 'Ungültiger Aufruf',

   'Invalid call'
=> 'Ungültiger Aufruf',

   'Search Error'
=> 'Fehler beim Suchen',

   'Create six character course identifier to share with students'
=> 'Sechs Zeichen langes Kurskennzeichen für Studierende erstellen',

   'LON-CAPA Courses with Unique Six Character Codes'
=> 'LON-CAPA-Kurse mit eindeutigem Sechs-Zeichen-Code',

   "List Domain's Courses with Assigned Six Character codes"
=> 'Kurse der Domäne mit zugewiesenem Sechs-Zeichen-Code auflisten',

   'No courses currently have six character identifiers.'
=> 'Derzeit haben keine Kurse einen Sechs-Zeichen-Code.',

   'Six-character Course Codes'
=> 'Sechs-Zeichen-Kurscodes',

   'Course identifier to share with students: [_1]'
=> 'Kurskennzeichen für Studierende: [_1]',

   'Course look-up'
=> 'Kurs nachschlagen',

   'Enter the course code (six letters and numbers)'
=> 'Kurscode eingeben (sechs Buchstaben und/oder Ziffern)',

   'Find course'
=> 'Kurs finden',

   'Copy resources'
=> 'Ressourcen kopieren',

   'Data collected from [_1] to [_2]'
=> 'Datenzusammenstellung von [_1] bis [_2]',

   'Data collected from [_1]'
=> 'Datenzusammenstellung von [_1]',

   'Data collected before [_1]'
=> 'Datenzusammenstellung bis [_1]',

   'normal'
=> 'normal',

   '+1'
=> '+1',

   '+2'
=> '+2',

   'red'
=> 'rot',

   'blue'
=> 'blau',

   'green'
=> 'grün',

   'bold'
=> 'fett',

   'italic'
=> 'kursiv',

   'Validation for self-creation screen set to original (CAPTCHA).'
=> 'Gültigkeitsprüfung für Selbsterstellungs-Seite auf "original (CAPTCHA)" gesetzt',

   'The following users were successfully added:'
=> 'Die folgenden Benutzer wurden erfolgreich hinzugefügt:',

   'The following users were successfully activated:'
=> 'Die folgenden Benutzer wurden erfolgreich aktiviert:',

   'The following users were successfully re-enabled:'
=> 'Die folgenden Benutzer wurden erfolgreich wiederhergestellt:',

   'The following users were successfully modified:'
=> 'Die folgenden Benutzer wurden erfolgreich geändert:',

   'The following users were successfully deleted:'
=> 'Die folgenden Benutzer wurden erfolgreich entfernt:',

   'The following users were successfully expired:'
=> 'Die folgenden Benutzer wurden erfolgreich ausgeschlossen:',

   'The following users were successfully added with the following privileges:'
=> 'Die folgenden Benutzer wurden mit folgenden Berechtigungen erfolgreich hinzugefügt:',

   'The following users were successfully activated with the following privileges:'
=> 'Die folgenden Benutzer wurden mit folgenden Berechtigungen erfolgreich aktiviert:',

   'The following users were successfully re-enabled with the following privileges:'
=> 'Die folgenden Benutzer wurden mit folgenden Berechtigungen erfolgreich wiederhergestellt:',

   'The following users were successfully modified with the following privileges:'
=> 'Die folgenden Benutzer wurden mit folgenden Berechtigungen erfolgreich geändert:',

   'The following users were successfully deleted with the following privileges:'
=> 'Die folgenden Benutzer wurden mit folgenden Berechtigungen erfolgreich gelöscht:',

   'The following users were successfully expired with the following privileges:'
=> 'Die folgenden Benutzer wurden mit folgenden Berechtigungen erfolgreich ausgeschlossen:',

   'Blackboard 5'
=> 'Blackboard 5',

   'Blackboard 6'
=> 'Blackboard 6',

   'ANGEL 5.5'
=> 'ANGEL 5.5',

   'WebCT 4 Campus Edition'
=> 'WebCT 4 Campus Edition',

   'Copy to notes?'
=> 'Nach Bemerkungen kopieren?',

   'Values'
=> 'Werte',

   'Expire Record'
=> 'Datensatz ablaufen lassen',

   'non-unique parameter name: [_1]'
=> 'nicht eindeutiger Parametername: [_1]',

   'bizarre parameter: [_1]'
=> 'seltsamer Parameter: [_1]',

   'Maximum calculation depth exceeded'
=> 'Maximale Berechnungstiefe überschritten',

   'Grader Name'
=> 'Name des Bewerters',

   'Detailed Grading Statistics'
=> 'Detaillierte Bewertungsstatistiken',

   'Select substituent...'
=> 'Substiuent auswählen...',

   'Not Permitted to change values'
=> 'Keine Berechtigung zum Ändern von Werten',

   'Position Selected'
=> 'Position wurde gewählt',

   'The X coordinate is [_1]'
=> 'Die X-Koordinate ist [_1]',

   'The Y coordinate is [_1]'
=> 'Die Y-Koordinate ist [_1]',

   'The selected coordinates are [_1]'
=> 'Die gewählten Koordinaten sind [_1]',

   'If this window fails to close you may need to manually replace the old coordinates with the above value.'
=> 'Falls dieses Fenster nicht automatisch schließt, ersetzen Sie manuell die alten Koordinaten mit den oben angegebenen Daten.',

   'School/college/university'
=> 'Schule/(Fach-)hochschule/Universität',

   "School's city, state/province, country"
=> 'Stadt, Bundesland und Land der Schule',

   "School's web address"
=> 'Internetadresse der Schule',

   'E-mail address at institution (if different)'
=> 'Institutionelle E-Mail-Adresse (falls andere)',

   'Data user provides'
=> 'Daten, die der Benutzer angibt',

   'Information user can enter'
=> 'Informationen, die der Benutzer eingeben kann',

   'E-mail address as username'
=> 'E-Mail-Adresse als Benutzerkennung',

   'No changes made to self-creation settings'
=> 'No changes made to self-creation settings',

   'Self-creation with e-mail as username'
=> 'Selbsterstellung mit E-Mail-Adresse als Benutzerkennung',

   'Self-creation with institutional username'
=> 'Selbsterstellung mit institutioneller Benutzerkennung',

   'When self-creating institutional account:'
=> 'Wenn institutionelle Accounts selbst erstellt werden:',

   'When self creating account with e-mail as username, user will not provide any information besides e-mail address'
=> 'Wenn ein Account mit E-Mail-Adresse als Benutzerkennung selbst erstellt wird, dann werden Benutzer keine Daten außer der E-Mail-Adresse angeben.',

   'When self-creating account with e-mail as username, user will provide the following information:'
=> 'Wenn ein Account mit E-Mail-Adresse als Benutzerkennung selbst erstellt wird, dann werden Benutzer die folgenden Daten angeben:',

   'When self creating account with e-mail as username, no information besides e-mail address will be provided by [_1].'
=> 'Wenn ein Account mit E-Mail-Adresse als Benutzerkennung selbst erstellt wird, wird - abgesehen von der E-Mail-Adresse - von [_1] nichts weiter angegeben.',

   'When self-creating account with e-mail as username, the following information will be provided by [_1]:'
=> 'Wenn ein Account mit E-Mail-Adresse als Benutzerkennung selbst erstellt wird,  dann werden die folgenden Daten von [_1] angeben:',

   'Approved automatically'
=> 'Automatisch bestätigt',

   'Authoring:'
=> 'Autorentätigkeit:',

   'Course ID does not exist'
=> 'Die Kurs-ID existiert nicht.',

   'Data provided by [_1]'
=> 'Daten durch [_1] bereitgestellt',

   'Data provided by user'
=> 'Daten durch Benutzer bereitgestellt',

   'Instructor name'
=> 'Name des Dozenten',

   'Invalid code'
=> 'Ungültiger Code',

   'Code matched, but course ID to which this mapped is invalid.'
=> 'Der Code stimmt überein, jedoch ist die Kurs-ID, auf die verwiesen wird, ungültig.',

   'No match'
=> 'Kein Treffer',

   'Quotas, MB; (Authoring requires role)'
=> 'Speicherplätze, MB; (Autorentätigkeit erfordert Rolle)',

   'Status type (self-reported)'
=> 'Statustyp (selbst eingetragen)',

   'The query string needs to include domain=dom, where dom is a valid domain.'
=> 'Der Anfragestring muss domain=dom enthalten, wobei "dom" eine gültige Domäne sein muss.',

   'Users self-creating accounts'
=> 'Selbsterstellung von Accounts durch Benutzer',

   'You do not have access rights to view course codes for the requested domain.'
=> 'Sie haben nicht die Berechtigung, Kurscodes für die angeforderte Domäne zu betrachten.',

   "This server is not the home server for the domain config 'user' for the requested domain."
=> 'Dieser Server ist nicht der Heimatserver für den "Domain-Config-Benutzer" der angeforderten Domäne.',

   'You will need to access this information from: [_1].'
=> 'Sie müssen die Informationen von [_1] abrufen.',

   'bolder'
=> 'fetter',

   'lighter'
=> 'weniger fett',

   'oblique'
=> 'schräg gestellt',

   'omit'
=> 'auslassen',

   'Display quotas and usage for Course/Community Content'
=> 'Speicherplatz und -verbrauch für Kurs-/Community-Inhalt anzeigen',

   'Output Formats'
=> 'Ausgabeformate',

   'Available textbooks'
=> 'Verfügbare Lehrbücher',

   'Form fields to send to validator'
=> 'Formularfelder, die an den Überprüfer gesendet werden sollen',

   'Text for validation button'
=> 'Text for validation button',

   'Validated course requests identified as processed by: [_1]'
=> 'Validierte Kursanträge wurden erkannt als durch [_1] verarbeitet.',

   'Validation (not official courses)'
=> 'Validierung (keine offiziellen Kurse)',

   'Validation description (HTML)'
=> 'Validierungsbeschreibung (HTML)',

   'Validation of courses/communities updated'
=> 'Validierung von Kursen/Communitys wurde aktualisiert',

   'Web address of validation server/script'
=> 'Webadresse des Validierungsservers/-skripts',

   'User information updateable in author context'
=> 'Benutzerdaten, die im Autorenkontext änderbar sind',

   'User information updateable in course context'
=> 'Benutzerdaten, die im Kurskontext änderbar sind',

   'Access dates for self-enrolling users'
=> 'Zugriffszeiten für selbsteintragende Benutzer',

   "Self-enrolling users' section"
=> 'Sektion für selbsteintragende Benutzer',

   'Display of a course catalog is disabled for this domain.'
=> 'Die Anzeige der Kursübersicht ist für diese Domäne deaktiviert.',

   'Limit by total self-enrolled'
=> 'begrenzt durch Gesamtanzahl Selbsteingetragener',

   'Processed automatically'
=> 'automatisch verarbeitet',

   'Processing of requests'
=> 'Verarbeitung der Anträge',

   '(new)'
=> '(neu)',

   'Add'
=> 'Hinzufügen',

   'Assignable to e-mail usernames'
=> 'Zuweisbar an E-Mail-Benutzerkennungen',

   'Author(s):'
=> 'Autor(en):',

   'Catalog type for authenticated users'
=> 'Übersichtstyp für authentifizierte Benutzer',

   'Catalog type for unauthenticated users'
=> 'Übersichtstyp für nicht authentifizierte Benutzer',

   'Catalog type/availability'
=> 'Übersichtstyp/Verfügbarkeit',

   'Category settings for standard catalog'
=> 'Kategorie-Einstellungen für Standardübersicht',

   'Code search form'
=> 'Code-Suchmaske',

   'Course personnel'
=> 'Kurspersonal',

   'Community personnel'
=> 'Community-Personal',

   'Configuration Rights'
=> 'Konfigurationsrechte',

   'Configured by Course Personnel or Domain Coordinator?'
=> 'Vom Kurspersonal oder vom Domänen-Koordinator konfiguriert?',

   'Default credits for textbook courses [_1]'
=> 'Voreingestellte Credits für Lehrbuch-Kurse [_1]',

   'Standard catalog'
=> 'Standardübersicht',

   'Domain-only catalog'
=> 'Übersicht nur für diese Domäne',

   'No catalog'
=> 'Keine Übersicht',

   'Generate unique six character code as course identifier?'
=> 'Eindeutigen Sechs-Zeichen-Code zur Verwendung als Kurskennzeichen erstellen?',

   'Institutional Single Sign On'
=> 'Institutionelles Single-Sign-On (SSO)',

   'Mapping of Shibboleth environment variable names to user data fields (SSO auth)'
=> 'Zuordnung der Shibboleth-Umgebungsvariablennamen zu den Benutzerdatenfeldern (SSO auth)',

   'Non-SSO users with IP mismatch'
=> 'Nicht-SSO-Benutzer mit IP-Abgleichsfehler',

   'SSO users from [_1], with IP mismatch'
=> 'SSO-Benutzer aus [_1] mit IP-Abgleichsfehler',

   'Shibboleth-autheticated user does not use environment variables to set user information'
=> 'Shibboleth-authentifizierter Benutzer verwendet nicht Umgebungsvariablen, um die Benutzerinformationen zu setzen.',

   'Shibboleth-autheticated user information set from environment variables, as follows:'
=> 'Shibboleth-authentifizierte Benutzerinformationen wie folgt durch Umgebungsvariablen gesetzt:',

   'Institutional status'
=> 'Institutioneller Status',

   'Institutional user types'
=> 'Institutionelle Benutzertypen',

   'Internal ID:'
=> 'Interne ID:',

   'LON-CAPA course:'
=> 'LON-CAPA-Kurs:',

   'Maximum allowed: '
=> 'Erlaubtes Maximum: ',

   'Name displayed:'
=> 'Angezeigter Name:',

   'Selecting Course(s)'
=> 'Kursauswahl',

   'Self-enrollment in Course/Community'
=> 'Selbsteintragung in Kurs/Community',

   'Self-enrollment validation (optional)'
=> 'Bestätigung der Selbsteintragung (optional)',

   'MathJax provides rendered equations whose source code can be extracted in TeX and MathML formats by right clicking the equation.'
=> 'MathJax erstellt gerenderte Gleichungen, deren Quellcode in TeX und MathML per Rechts-Klick (Kontextmenü) exportiert werden kann.', 

   'No content changes in imported content in specified time frame'
=> 'Innerhalb des angegebenen Zeitfensters gibt es keine Inhaltsänderungen des importierten Inhalts.',

   'Title in Course'
=> 'Titel im Kurs',

   'Active Users:'
=> 'Aktive Benutzer:',

   'Code integrity check'
=> 'Code-Integritäts-Überprüfung',

   'Content disk usage'
=> 'Inhalts-Speicherverbrauch',

   'Course-specific self-enrollment configuration by Course personnel'
=> 'Konfiguration der Selbsteintragung für einen bestimmten Kurs durch das Kurspersonal',

   'Course-specific self-enrollment configuration by Domain Coordinator'
=> 'Konfiguration der Selbsteintragung für einen bestimmten Kurs durch den Domänen-Koordinator',

   'Override defaults for who configures self-enrollment for this specific course.'
=> 'Voreinstellungen überschreiben, wer Selbsteintragung für diesen bestimmten Kurs konfiguriert',

   'Does not respond to several queries.'
=> 'Reagiert nicht auf verschiedene Anfragen',

   'Domain default'
=> 'Domänen-Voreinstellung',

   'Use domain default'
=> 'Domänen-Voreinstellung verwenden',

   'Doomed: Connections'
=> 'Verloren: Verbindungen',

   'Doomed: Database (mysql)'
=> 'Verloren: Datenbank (mysql)',

   'Doomed: General (loncron)'
=> 'Verloren: allgemein (loncron)',

   'Doomed: Load'
=> 'Verloren: Last',

   'Doomed: RPMs'
=> 'Verloren: RPMs',

   'Doomed: Status could not be determined'
=> 'Verloren: Status konnte nicht festgestellt werden',

   'Doomed: Users'
=> 'Verloren: Benutzer',

   'MySQL Database:'
=> 'MySQL-Datenbank:',

   'Not connected'
=> 'Nicht verbunden',

   'Percent complete:'
=> 'Prozent abgeschlossen:',

   'Percent from cache:'
=> 'Prozent des Caches:',

   'Percent usage'
=> 'Prozent Verwendung',

   'Quotas for uploaded course content'
=> 'Speicherplatz für hochgeladenen Kursinhalt',

   'RPMs'
=> 'RPMs',

   'RPMs:'
=> 'RPMs:',

   'Reroute to:'
=> 'Umleiten nach:',

   'Reroute:'
=> 'Umleitung:',

   'Run loncron'
=> 'loncron ausführen',

   'Self-enrollment configuration'
=> 'Konfiguration der Selbsteintragung',

   'Testing[_1]:'
=> 'Teste[_1]:',

   'Connections'
=> 'Verbindungen',

   'connecting [_1]'
=> 'verbinde mit [_1]',

   'Database'
=> 'Datenbank',

   'Done gathering cached data'
=> 'Zusammenstellen der gecacheten Daten beendet',

   'Done initial run'
=> 'Initialer Lauf beendet',

   'General'
=> 'allgemein',

   'Reroute'
=> 'Umleitung',

   'Usage (MB)'
=> 'Verwendung (MB)',

   'Version:'
=> 'Version:',

   'Versions'
=> 'Versionen',

   'Who configures'
=> 'Wer konfiguriert',

   '[_1] configures'
=> '[_1] konfiguriert',

   'Will automatically refresh ([_1] secs refresh cycle)'
=> 'Aktualisiert sich automatisch (im [_1]-Sekunden-Takt)',

   'loncron errors'
=> '"loncron"-Fehler',

   'Could not determine'
=> 'Konnte nicht ermittelt werden',

   'No active users logged in.'
=> 'Es sind keine aktiven Benutzer eingeloggt.',

   'Content blocking'
=> 'Inhaltssperre',

   'Content blocking not allowed for [_1]'
=> 'Eine Inhaltssperre ist für [_1] nicht zulässig.',

   'Event(s)'
=> 'Ereignis(se)',

   'Printout blocking not allowed for [_1]'
=> 'Eine Ausdrucksperre ist für [_1] nicht zulässig.',

   'Requirements from exam blocking'
=> 'Anforderungen an Prüfungssperre',

   'Timed quiz trigger'
=> 'Auslöser für zeitgesteuertes Quiz',

   'Triggering of blocking events not allowed for [_1]'
=> 'Das Auslösen von Sperrereignissen ist für [_1] nicht zulässig.',

   'Languages'
=> 'Sprachen',

   'Your request is being processed; this page will update when processing is complete.'
=> 'Ihre Anfrage wird verarbeitet. Diese Seite wird sich automatisch aktualisieren, wenn die Verarbeitung abgeschlossen ist.',

   'Link to PDF (for mobile devices)'
=> 'Link zur PDF-Datei (für Mobilgeräte)',

   'Book'
=> 'Buch',

   'Publisher'
=> 'Herausgeber',

   '(Set by Domain Coordinator)'
=> '(durch Domänen-Koordinator gesetzt)',

   'From: [_1], to: [_2]'
=> 'von: [_1], bis: [_2]',

   'Maximum: [_1]'
=> 'Maximum: [_1]',

   'Must be registered in course'
=> 'muss in einem Kurs registriert sein',

   'No requirement'
=> 'Keine Anforderungen',

   'any user'
=> 'jeder Benutzer',

   'other users'
=> 'andere Benutzer',

   'Dynamic size'
=> 'Dynamische Größe',

   'Fixed size'
=> 'Feste Größe',

   'By default, CodeMirror an editor with advanced functionality for editing code is activated for authors.'
=> 'CodeMirror, ein Editor mit erweiterter Funktionalität für die Bearbeitung von Quelltext, ist standardmäßig für Autoren aktiviert.',

   'Deactivate CodeMirror. This can improve performance on slow computers and accessibility.'
=> 'CodeMirror deaktivieren. Dies kann die Leistung auf langsamen Computern sowie die Barrierefreiheit verbessern.',

   'Deactivate CodeMirror in Authoring Space'
=> 'CodeMirror im Autorenbereich deaktivieren',

   'Processing your submission ...'
=> 'Ihre Einreichung wird bearbeitet ...',

   'As a result, your LON-CAPA session is being redirected to the server where you originally logged in.'
=> 'Daher wird Ihre LON-CAPA Sitzung auf den Server umgeleitet, an dem Sie sich ursprünglich angemeldet haben.',

   'As a result, your LON-CAPA session is being redirected.'
=> 'Daher wird Ihre LON-CAPA Sitzung umgeleitet.',

   'For [_1]: [quant,_2,transaction] hidden'
=> 'Für [_1]: [quant,_2,Transaktion,Transaktionen] verborgen',

   'Submissions were marked "hidden" for [quant,_1,transaction].'
=> 'Einreichungen wurden für [quant,_1,Transaktion,Transaktionen] als "verborgen" markiert.',

   'Files currently selected for submission'
=> 'Zum Einreichen ausgewählte Dateien',

   'Number of boxes checked outside permissible range (either too few or too many).'
=> 'Die Anzahl der ausgewählten Antworten liegt außerhalb des zulässigen Bereichs (entweder zu viele oder zu wenige ausgewählt).',

   'Enter maximum number students may check (e.g., 3)'
=> 'Geben Sie die maximale Anzahl an, die Studierende auswählen dürfen (z.B. 3)',

   'Enter minimum number students need to check (e.g., 1)'
=> 'Geben Sie die minimale Anzahl an, die Studierende auswählen müssen (z.B. 1)',

   '(for [_1])'
=> '(für [_1])',

   'Disable submit button/keypress following student submission'
=> '"Antwort einreichen"-Button deaktivieren, nachdem eine Antwort eingereicht wurde',

   'Number of seconds submit is disabled'
=> 'Dauer in Sekunden, die der "Antwort einreichen"-Button deaktivert bleibt',

   'Enter 0 to remain disabled until page reload.'
=> 'Geben Sie 0 ein, um den Button bis zum Neuladen der Seite zu deaktivieren.',

   'Math preview uses DragMath (Java), if supported by client OS.'
=> 'Für die Vorschau von mathematischen Ausdrücken DragMath (Java) verwenden, sofern vom Client unterstützt.',

   'Math preview uses LON-CAPA previewer (javascript), if supported by browser.'
=> 'Für die Vorschau von mathematischen Audrücken die LON-CAPA Vorschau verwenden (javascript), sofern vom Client unterstützt.',

   'Math preview uses LON-CAPA previewer (javascript) in place of DragMath (Java)'
=> 'Die Vorschau von mathematischen Ausdrücken verwendet die LON-CAPA Vorschau (javascript) anstelle von DragMath (Java)',

   'Molecule editor uses JME (Java), if supported by client OS.'
=> 'JME (Java) als Moleküleditor verwenden, sofern vom Client unterstützt.',

   'Molecule editor uses JSME (HTML5), if supported by browser.'
=> 'JSME (HTML5) als Moleküleditor verwenden, sofern vom Client unterstützt.',

   'Molecule editor uses JSME (HTML5) in place of JME (Java)'
=> 'JSME (HTML5) wird anstelle von JME (Java) als Moleküleditor verwendet.',

   'Submit button(s) disabled on page after student makes submission'
=> '"Antwort einreichen"-Buttons werden deaktiviert nachdem eine Antwort eingereicht wurde',

   'Submit button(s) remain enabled on page after student makes submission.'
=> '"Anwort einreichen" Buttons bleiben aktiviert nachdem eine Antwort eingereicht wurde.',

   'Upload of custom markup file(s) failed because a Domain Configuration user ([_1]) could not be created in domain: [_2].  Error was: [_3].'
=> 'Das Hochladen von benutzerdefinierten Markupdateien ist fehlgeschlagen, da ein Domänen-Konfigurations-Benutzer ([_1]) in der Domäne [_2] nicht erstellt werden konnte. Der Fehler war: [_3]',

   'Upload of custom markup file(s) failed because an author role could not be assigned to a Domain Configuration user ([_1]) in domain: [_2].  Error was: [_3].'
=> 'Das Hochladen von benutzerdefinierten Markupdateien ist fehlgeschlagen, da eine Autorenrolle einem Domänen-Konfigurations-Benutzer ([_1]) in der Domäne [_2] nicht zugewiesen werden konnte. Der Fehler war: [_3]',

   'Upload of custom markup is not permitted to this server: [_1]'
=> 'Das Hochladen von benutzerdefiniertem Markup ist nicht gestattet auf diesem Server: [_1]',

   '[quant,_1,second] (default)'
=> '[quant,_1,Sekunde,Sekunden] (voreingestellt)',

   'custom markup'
=> 'benutzerdefiniertes Markup',

   'Custom markup'
=> 'Benutzerdefiniertes Markup',

   'Submit button will not be disabled after student submission'
=> '"Antwort einreichen"-Button wird nach Einreichung nicht deaktiviert',

   'Submit button will be disabled after student submission for [quant,_1,second].'
=> '"Antwort einreichen"-Button wird für [quant,_1,Sekunde,Sekunden] nach einer Einreichung deaktiviert.',

   'Submit button will be disabled after student submission until page is reloaded.'
=> '"Antwort einreichen"-Button wird nach Einreichung bis zum Neuladen der Seite deaktiviert.',

   'The choice entered for disabling the submit button is invalid.'
=> 'Die Eingabe für die Deaktivierung des "Antwort einreichen"-Buttons ist ungültig.',

   'The proposed duration for disabling the Submit button post-submission was blank, so the domain default of [quant,_1,second] will be used.'
=> 'Die eingegebene Dauer für die Deaktivierung des "Antwort einreichen"-Buttons nach einer Einreichung war leer, daher wird die Domänenvoreinstellung [quant,_1,Sekunde,Sekunden] verwendet.',

   'The timeout you entered for disabling the submit button is invalid.'
=> 'Das eingegebene Timeout für die Deaktivierung des "Antwort einreichen"-Buttons ist ungültig.',

   'An error occurred when saving your proposed changes.'
=> 'Es ist ein Fehler bei der Bearbeitung Ihrer Änderungen aufgetreten.',

   'An invalid response was recorded.'
=> 'Eine ungültige Antwort wurde angegeben.',

   'Configure submit button behavior after student makes a submission'
=> 'Konfiguration des "Antwort einreichen"-Buttons nach einer Einreichung',

   'Post submission behavior of the Submit button is unchanged.'
=> 'Verhalten des "Antwort einreichen"-Buttons nach einer Einreichung ist unverändert.',

   'Submit button behavior after student makes a submission:'
=> 'Verhalten des "Antwort einreichen"-Buttons nach einer Einreichung:',

   'One try remaining!'
=> 'Noch ein Versuch möglich!',

   'For each crosslisting, leave the checkbox checked if you want registered students in that course to be included in the student roster for LON-CAPA course: [_1]; otherwise uncheck it.'
=> 'Für jeden fächerübergreifenden Querverweis: lassen Sie die Auswahl aktiviert, wenn Studierende in diesem Kurs in der Kursteilnehmerliste des LON-CAPA Kurses [_1] angezeigt werden sollen, ansonsten entfernen Sie die Auswahl.',

   "'Hidden' is checked in the Course Editor individually for each resource in the folder being printed."
=> "Im Kurs-Editor ist 'Verborgen' für jede Ressource einzeln in dem auszudruckenden Verzeichnis ausgewählt.",

   'No incomplete resources'
=> 'Keine unerledigten Ressourcen',

   'No resources to print'
=> 'Keine Ressourcen zum Drucken',

   "Note: to print a bubblesheet exam which you want to hide from students, use the Course Editor to check the 'Hidden' checkbox for the exam folder itself."
=> "Hinweis: Um eine Bubblesheet-Prüfung zu drucken, die Sie vor den Studierenden verbergen möchten, verwenden Sie die Kurs-Editor und markieren Sie die 'Verborgen'-Checkbox für das Prüfungsverzeichnis.",

   "The 'Resource hidden from students' parameter is set for the folder being printed."
=> "Der 'Ressource für Studierende verborgen' Parameter ist für das zu druckende Verzeichnis aktiviert.",

   'The most likely reason is one of the following: '
=> 'Wahrscheinlich ist eine der folgenden Ursachen aufgetreten:',

   'There are no unhidden resources to print.'
=> 'Keine nicht verborgenen Ressourcen zum Drucken vorhanden.',

   'Member-viewable community roster'
=> 'Für Mitglieder einsehbare Community-Teilnehmerliste',

   'Members with no section'
=> 'Mitglieder ohne Sektionszugehörigkeit',

   'Members in section "[_1]"'
=> 'Mitglieder in Sektion "[_1]"',

   'Members in any section'
=> 'Mitglieder in beliebiger Sektion',

   'The single member without a section[_1] has opted not to be listed in the roster.'
=> 'Das einzelne Mitglied ohne Sektionszugehörigkeit[_1] hat der Auflistung in der Teilnehmerliste nicht zugestimmt.',

   'None of the [_1] members without a section[_2] have opted to be listed in the roster.'
=> 'Keines der [_1] Mitglieder ohne Sektionszugehörigkeit[_2] hat der Auflistung in der Teilnehmerliste zugestimmt.',

   'None of the [_1] members in the section[_2] have opted to be listed in the roster.'
=> 'Keines der [_1] Mitglieder in der Sektion[_2] hat der Auflistung in der Teilnehmerliste zugestimmt.',

   'None of the [_1] members in the community[_2] have opted to be listed in the roster.'
=> 'Keines der [_1] Mitglieder in der Community[_2] hat der Auflistung in der Teilnehmerliste zugestimmt.',

   'All [_1] members without a section[_2] have opted to be listed in the roster.'
=> 'Alle [_1] Mitglieder ohne Sektionszugehörigkeit[_2] haben der Auflistung in der Teilnehmerliste zugestimmt.',

   'All [_1] members in the section[_2] have opted to be listed in the roster.'
=> 'Alle [_1] Mitglieder in der Sektion[_2] haben der Auflistung in der Teilnehmerliste zugestimmt.',

   'All [_1] members in the community[_2] have opted to be listed in the roster.'
=> 'Alle [_1] Mitglieder in der Community[_2] haben der Auflistung in der Teilnehmerliste zugestimmt.',

   'The single member without a section[_1] has opted to be listed in the roster.'
=> 'Das einzelne Mitglied ohne Sektionszugehörigkeit[_1] hat der Auflistung in der Teilnehmerliste zugestimmt.',

   'The single member in the section[_1] has opted to be listed in the roster.'
=> 'Das einzelne Mitglied in der Sektion[_1] hat der Auflistung in der Teilnehmerliste zugestimmt.',

   'The single member in the section[_1] has opted not to be listed in the roster.'
=> 'Das einzelne Mitglied in der Sektion[_1] hat der Auflistung in der Teilnehmerliste nicht zugestimmt.',

   'The single member in the community[_1] has opted to be listed in the roster.'
=> 'Das einzelne Mitglied in der Community[_1] hat der Auflistung in der Teilnehmerliste zugestimmt.',

   'All [_1] members without a section[_2] are listed in the roster.'
=> 'Alle [_1] Mitglieder ohne Sektionzugehörigkeit[_2] werden in der Teilnehmerliste aufgelistet.',

   'All [_1] members in the section[_2] are listed in the roster.'
=> 'Alle [_1] Mitglieder in der Sektion[_2] werden in der Teilnehmerliste aufgelistet.',

   'All [_1] members in the community[_2] are listed in the roster.'
=> 'Alle [_1] Mitglieder in der Community[_2] werden in der Teilnehmerliste aufgelistet.',

   'There is only a single member without a section[_1]'
=> 'Es gibt nur ein Mitglied ohne Sektionszugehörigkeit[_1]',

   'There is only a single member in the section[_1]'
=> 'Es gibt nur ein Mitglied in der Sektion[_1]',

   'There is only a single member in the community[_1]'
=> 'Es gibt nur ein Mitglied in der Community[_1]',

   'There are currently no members to display.'
=> 'Derzeit gibt es keine Mitglieder, die angezeigt werden könnten.',

   'Display of a member-viewable community roster is not currently enabled.'
=> 'Die Anzeige der mitgliedereinsehbaren Community-Teilnehmerliste ist derzeit deaktiviert.',

   'No member-viewable community roster settings available.'
=> 'Es sind keine Einstellungen zur mitgliedereinsehbaren Teilnehmerliste verfügbar.',

   'Display of your name in the member-viewable roster set to [_1].'
=> 'Anzeige Ihres Namens in der mitgliedereinsehbaren Teilnehmerliste auf [_1] gesetzt.',

   'Display of your name in the member-viewable roster unchanged (set to [_1]).'
=> 'Anzeige Ihres Namens in der mitgliedereinsehbaren Teilnehmerliste bleibt unverändert (auf [_1] gesetzt).',

   'You are currently listed in the member-viewable roster.'
=> 'Sie werden derzeit in der mitgliedereinsehbaren Teilnehmerliste aufgelistet.',

   'You are currently [_1]not[_2] listed in the member-viewable roster.'
=> 'Sie werden derzeit [_1]nicht[_2] in der mitgliedereinsehbaren Teilnehmerliste aufgelistet.',

   'Only members who have opted to be listed in the roster ([_1] out of [_2] members) are shown.'
=> 'Nur Mitglieder, die der Auflistung in der Teilnehmerliste zugestimmt haben ([_1] von [_2] Mitgliedern), werden angezeigt.',

   'You do not have rights to modify member-viewable community roster settings.'
=> 'Sie haben nicht die Berechtigung, die Einstellungen zur mitgliedereinsehbaren Community-Teilnehmerliste ändern.',

   'Member-viewable roster settings'
=> 'Einstellungen zur mitgliedereinsehbaren Teilnehmerliste',

   'Student-viewable roster settings'
=> 'Einstellungen zur studierendeeinsehbaren Teilnehmerliste',

   'Copying loncapa [_1] site file to [_2] and pointing [_3] to it from sites-enabled.'
=> 'Kopiere loncapa [_1] Site-Datei nach [_2] und richte Link [_3] in sites-enabled ein.',

   'Problem Templates'
=> 'Aufgabenvorlagen',

   'Response Types'
=> 'Antworttypen',

   'Conditional Blocks'
=> 'Bedingungsabhängige Blöcke', #FIXME kürzere Übersetzung

   'Chemistry'
=> 'Chemie',

   'Math'
=> 'Mathematik',

   'Translated Block'
=> 'Block: Übersetzung',

   'Formula Response'
=> 'Formelantwort',

   'Function Plot Response'
=> '"Function Plot"-Antwort',

   'Math Response'
=> 'Mathematische Antwort',

   'Click on Image'
=> 'Klick-ins-Bild',

   'One out of N statements'
=> 'Single Choice (1-aus-N-Auswahl / Radiobutton)',

   'Match Two Lists'
=> 'Indirekte Zuordnung',

   'Select from Options'
=> 'Auswahl aus Optionen',

   'Rank Values'
=> 'Rangordnung',

   'Chemical Reaction'
=> 'Chemische Reaktion',

   'Organic Chemical Structure'
=> 'Organisch-chemische Struktur',

   'Helpdesk[_1]'
=> 'Helpdesk[_1]',

   'Helpdesk [_1]'
=> 'Helpdesk [_1]',

   'Loading Domain Helpdesk Assistant Menu'
=> 'Domänen-Helpdesk-Assistenz Menü wird geladen',

   'Loading Domain Helpdesk Menu'
=> 'Domänen-Helpdesk Menü wird geladen',

   '[_1]Ad hoc[_2] course/community roles in domain [_3]'
=> '[_1]Ad-hoc[_2]-Kurs/Community-Rollen in der Domäne [_3]',

   'Error when attempting to change institutional section for [_1] in section: [_2] -error [_3].'
=> 'Es trat ein Fehler bei der Änderung der institutionellen Sektion für [_1] in Sektion [_2] auf -Fehler [_3].',

   'Institutional section change for [_1] from [_2] to [_3].'
=> 'Änderung der institutionellen Sektion für [_1] von [_2] zu [_3].',

   'The following students were not expired from the old section [_1] because the enrollment count retrieved for that institutional section was zero, and the number of students with roles to expire exceeded the failsafe threshold of [_2]:'
=> 'Die folgenden Studierendenrollen wurden für die Sektion [_1] nicht entzogen, weil es keine Einschreibungen für diese institutionelle Sektion gab und die Anzahl der Studierenden den Schwellenwert von [_2] übersteigt:',

   'The unit attribute in the numericalresponse item needs to be a supported physical unit.'
=> 'Das Attribut "Einheit" der numerischen Antwort muss eine unterstützte physikalische Einheit sein.',

   '(submission status: "[_1]")'
=> '(Einreichungsstatus: "[_1]")',

   'Assign Common Grade to Students in Group(s) [_1]'
=> 'Gemeinsame Bewertung der Studierenden in Gruppe(n) [_1]',

   'Assign Common Grade to Students in Section(s) [_1] and no Group'
=> 'Gemeinsame Bewertung der Studierenden in Sektion(en) [_1] und keiner Gruppe',

   'Assign Common Grade to Students in Section(s) [_1], and in Group(s) [_2]'
=> 'Gemeinsame Bewertung der Studierenden in Sektion(en) [_1], und Grupp(en) [_2]',

   'Assign Common Grade to Students in no Section and in Group(s) [_1]'
=> 'Gemeinsame Bewertung der Studerienden in keiner Sektion und in Gruppe(n) [_1]',

   'Assign Common Grade to Students in no Section and in no Group'
=> 'Gemeinsame Bewertung der Studierenden in keiner Sektion und in keiner Gruppe',

   'Assign Common Grade to Students not assigned to any groups'
=> 'Gemeinsame Bewertung der Studierenden ohne Gruppenzugehörigkeit',

   'Assign Grade to Specific Students in Group(s) [_1]'
=> 'Bewertung ausgewählter Studierender in Gruppe(n) [_1]',

   'Assign Grade to Specific Students in Section(s) [_1] and no Group'
=> 'Bewertung ausgewählter Studierender in Sektion(en) [_1] und in keiner Gruppe',

   'Assign Grade to Specific Students in Section(s) [_1], and in Group(s) [_2]'
=> 'Bewertung ausgewählter Studierender in Sektion(en) [_1], und in Gruppe(n) [_2]',

   'Assign Grade to Specific Students in no Section and in Group(s)'
=> 'Bewertung ausgwählter Studierender in keiner Sektion und in Gruppe(n)',

   'Assign Grade to Specific Students in no Section and in no Group'
=> 'Bewertung ausgewählter Studierender in keiner Sektion oder Gruppe',

   'Assign Grade to Specific Students not assigned to any groups'
=> 'Bewertung ausgewählter Studierender ohne Gruppenzuweisung',

   'There are no students in group(s) [_1] with enrollment status [_2] and submission status "[_3]" to modify or grade.'
=> 'Es gibt keine Studierenden in Gruppe(n) [_1] mit Belegungsstatus [_2] und Einreichungsstatus "[_3]" to modify or grade.',

   'There are no students in group(s) [_1] with enrollment status [_2] to modify or grade.'
=> 'Es gibt keine Studierenden in Gruppe(n) [_1] mit Belegungsstatus [_2], die geändert oder bewertet werden können.',

   'There are no students in no section and no group with enrollment status [_1] and submission status "[_2]" to modify or grade.'
=> 'Es gibt keine Studierenden ohne Sektions- und Gruppenzugehörigkeit mit Belegungsstatus [_1] und Einreichungsstatus "[_2]", die geändert oder bewertet werden können.',

   'There are no students in no section and no group with enrollment status [_1] to modify or grade.'
=> 'Es gibt keine Studierenden ohne Sektions- und Gruppenzugehörigkeit mit Belegungsstatus [_1], die geändert oder bewertet werden können.',

   'There are no students in no section in group(s) [_1] with enrollment status [_2] and submission status "[_3]" to modify or grade.'
=> 'Es gibt keine Studierenden ohne Sektionszugehörigkeit in Gruppe(n) [_1] mit Belegungsstatus [_2] und Einreichungsstatus "[_3]", die geändert oder bewertet werden können.',

   'There are no students in no section in group(s) [_1] with enrollment status [_2] to modify or grade.'
=> 'Es gibt keine Studierenden ohne Sektionszugehörigkeit in Gruppe(n) [_1] mit Belegungsstatus [_2], die geändert oder bewertet werden können.',

   'There are no students in no section with enrollment status [_1] and submission status "[_2]" to modify or grade.'
=> 'Es gibt keine Studierenden ohne Sektionszugehörigkeit und Belegungsstatus [_1] und Einreichungsstatus "[_2]", die geändert oder bewertet werden können.',

   'There are no students in no section with enrollment status [_1] to modify or grade.'
=> 'Es gibt keine Studierenden ohne Sektionszugehörigkeit mit Belegungsstatus [_1], die geändert oder bewertet werden können.',

   'There are no students in section(s) [_1] and group(s) [_2] with enrollment status [_3] and submission status "[_4]" to modify or grade.'
=> 'Es gibt keine Studierenden in Sektion(en) [_1] und Gruppe(n) [_2] mit Belegungsstatus [_3] und Einreichungsstatus "[_4]", die geändert oder bewertet werden können.',

   'There are no students in section(s) [_1] and group(s) [_2] with enrollment status [_3] to modify or grade.'
=> 'Es gibt keine Studierenden in Sektion(en) [_1] und Gruppe(n) [_2] mit Belegungsstatus [_3], die geändert oder bewertet werden können.',

   'There are no students in section(s) [_1] and no group with enrollment status [_2] and submission status "[_3]" to modify or grade.'
=> 'Es gibt keine Studierenden in Sektion(en) [_1] ohne Gruppenzugehörigkeit mit Belegungsstatus [_2] und Einreichungsstatus "[_3]", die geändert oder bewertet werden können.',

   'There are no students in section(s) [_1] and no group with enrollment status [_2] to modify or grade.'
=> 'Es gibt keine Studierenden in Sektion(en) [_1] ohne Gruppenzugehörigkeit mit Belegungsstatus [_2], die geändert oder bewertet werden können.',

   'There are no students in section(s) [_1] with enrollment status [_2] and submission status "[_3]" to modify or grade.'
=> 'Es gibt keine Studierenden in Sektion(en) [_1] mit Belegungsstatus [_2] und Einreichungsstatus "[_3]", die geändert oder bewertet werden können.',

   'There are no students with enrollment status [_1] and submission status "[_2]" to modify or grade.'
=> 'Es gibt keine Studierenden mit Belegungsstatus [_1] und Einreichungsstatus "[_2]", die geändert oder bewertet werden können.',

   'There are no students with enrollment status [_1] to modify or grade.'
=> 'Es gibt keine Studierenden mit Belegungsstatus [_1], die geändert oder bewertet werden können.',

   'There are no students with no group assigned and with enrollment status [_1] to modify or grade.'
=> 'Es gibt keine Studierenden ohne Gruppenzugehörigkeit und Belegungsstatus [_1], die geändert oder bewertet werden können.',

   'There are no students with no group assigned with enrollment status [_1] and submission status "[_2]" to modify or grade.'
=> 'Es gibt keine Studierenden ohne Gruppenzugehörigkeit und Belegungsstatus [_1] und Einreichungsstatus "[_2]", die geändert oder bewertet werden können.',

   'Essay'
=> 'Essay',

   'GNU Plot'
=> 'GNU Plot',

   'Invalid template file.'
=> 'Ungültige Vorlagendatei.',

   'Invalid template file; template needs to be a .problem, .library, or .task file.'
=> 'Ungültige Vorlagendatei; die Vorlage muss eine .problem, .library, oder .task Datei sein.',

   'Script Block'
=> 'Skript-Block',  

   'Include communities set to be hidden from catalog (domain staff only)'
=> 'Im Kurskatalog ausgeblendete Communitys einschließen (nur Domänen-Personal)',

   'Include courses set to be hidden from catalog (domain staff only)'
=> 'Im Kurskatalog ausgblendete Kurse einschließen (nur Domänen-Personal)',

   'Show full details for each community (domain staff only)'
=> 'Alle Details für jede Community anzeigen (nur Domänen-Personal)',

   'Show full details for each course (domain staff only)'
=> 'Alle Details für jeden Kurs anzeigen (nur Domänen-Personal)',

   'Failsafe for no drops if institutional data missing for a section set to: [_1]'
=> 'Schwellenwert für Ausschließungen, falls instutionelle Daten für eine Sektion fehlen, geändert auf: [_1]',

   'Failsafe for no drops if institutional data missing for a section: deleted'
=> 'Schwellenwert für Ausschließungen, falls instutionelle Daten für eine Sektion fehlen, gelöscht',

   'Institutional directory search available set to: off'
=> 'Verfügbarkeit der Suche im Institutionsverzeichnis ausgeschaltet',

   'Institutional directory search available set to: on'
=> 'Verfügbarkeit der Suche im Institutionsverzeichnis eingeschaltet',

   'LON-CAPA directory search available set to: off'
=> 'Verfügbarkeit der Suche im LON-CAPA Verzeichnis ausgeschaltet',

   'LON-CAPA directory search available set to: on'
=> 'Verfügbarkeit der Suche im LON-CAPA Verzeichnis eingeschaltet',

   'Other domains can search institution set to: Yes'
=> 'Andere Domänen können die Institution durchsuchen geändert auf: ja',

   'Other domains can search institution set to: No'
=> 'Andere Domänen können die Institution durchsuchen geändert auf: nein',

   'Other domains can search LON-CAPA domain set to: Yes'
=> 'Andere Domänen können die LON-CAPA Domäne durchsuchen geändert auf: ja',

   'Other domains can search LON-CAPA domain set to: No'
=> 'Andere Domänen können die LON-CAPA Domäne durchsuchen geändert auf: nein',

   '(e-mail, subject, and description always shown)'
=> '(E-Mail, Betreff, und Beschreibung wird immer angezeigt)',

   '(logged-in users)'
=> '(angemeldete Benutzer)',

   'An error occurred storing privileges for existing role [_1]: [_2]'
=> 'Ein Fehler ist beim Speichern der Berechtigungen für die vorhandene Rolle [_1] augetreten: [_2]',

   'An error occurred storing the new custom role: [_1]'
=> 'Ein Fehler ist beim Speichern der neuen benutzerdefinierten Rolle aufgetreten: [_1]',

   'Communities: [_1] s'
=> 'Communitys: [_1] s',

   'E-mail recipient(s)'
=> 'E-mail Empfänger',

   'Existing custom role modified: [_1]'
=> 'Vorhandene benutzerdefinierte Rolle geändert: [_1]',

   'Extra helpdesk form fields:'
=> 'Zusätzliche Helpdesk Formularfelder:',

   'Failsafe for no drops when institutional data missing'
=> 'Schwellenwert für Ausschließungen, falls institutionelle Daten fehlen',

   'Help form fields changed to "Not shown": [_1].'
=> 'Hilfeformularfelder geändert auf "Nicht angezeigt": [_1].',

   'Help form fields changed to "Optional": [_1].'
=> 'Hilfeformularfelder geändert auf "optional": [_1].',

   'Help form fields changed to "Required": [_1].'
=> 'Hilfeformularfelder geändert auf "erforderlich": [_1].',

   'Hosting on balancer itself'
=> 'Hosting auf Balancer selbst',

   'Institutional directory search available?'
=> 'Suche im Institutionsverzeichnis verfügbar?',

   'Internal name:'
=> 'Interner Name:',

   'LON-CAPA directory search available?'
=> 'Suche im LON-CAPA Verzeichnis verfügbar?',

   'Lifetime of "Temporary" MySQL tables (student performance data) on homeserver'
=> 'Lebensdauer von "temporären" MySQL Tabellen (student performance data) auf Heimatserver',

   'Lifetime of "Temporary" MySQL tables (student performance data) on homeserver remains default: [_1] s'
=> 'Lebensdauer von "temporären" MySQL Tabellen (student performance data) auf Heimatserver bleibt wie voreingestellt: [_1] s',

   'Max size for file uploaded to help form by logged-in user set to [_1] MB.'
=> 'Maximale Dateigröße für Hilfeformular-Uploads von angemeldeten Benutzern geändert auf [_1] MB.',

   'Maximum size for upload (MB)'
=> 'Maximale Dateigröße für Uploads (MB)',

   'Name shown to users:'
=> 'Name, der Benutzern angezeigt wird:',

   'New custom role added: [_1]'
=> 'Neue benutzerdefinierte Rolle hinzugefügt: [_1]',

   'No changes made to contacts and form settings'
=> 'Keine Änderungen an Kontakt- und Formulareinstellungen',

   'No changes made to directory search settings'
=> 'Keine Änderungen an den Einstellungen der Verzeichnissuche',

   'No one'
=> 'Keiner',

   'No recipients'
=> 'Keine Empfänger',

   'Official courses: [_1] s'
=> 'Offizielle Kurse [_1] s',

   'Optional added text'
=> 'Optional hinzugefügter Text',

   'Other domains can search LON-CAPA domain?'
=> 'Andere Domänen dürfen in LON-CAPA Domäne suchen?',

   'Other domains can search institution?'
=> 'Andere Domänen dürfen in der Institution suchen?',

   'Privileges set to :'
=> 'Berechtigungen geändert auf:',

   'ReCAPTCHA for helpdesk form set to version [_1]'
=> 'ReCAPTCHA für Helpdeskformular geändert auf Version [_1]',

   'ReCAPTCHA set to version [_1]'
=> 'ReCAPTCHA geändert auf Version [_1]',

   'Role name'
=> 'Rollenname',

   'Role privileges'
=> 'Rollenberechtigungen',

   'Text automatically added to e-mail body:'
=> 'Nachrichtentext (automatisch angefügt):',

   'Text automatically added to e-mail subject:'
=> 'Betrefftext (automatisch angefügt):',

   'Text automatically added to e-mail:'
=> 'Text (automatisch angefügt):',

   'Textbook courses: [_1] s'
=> 'Lehrbuch-Kurse: [_1] s',

   'Unofficial courses: [_1] s'
=> 'Inoffizielle Kurse: [_1] s',

   'Warning: bcrypt encryption cost for internal authentication must be an integer.'
=> 'Warnung: der bcrypt Kostenfaktor für die interne Authentifizierung muss ein Integer sein.',

   'Warning: disallowing login for an authenticated user if the stored cost is less than the default will require a password reset by/for the user.'
=> 'Warnung: Das Unterbinden der Anmeldung für authentifizierte Benutzer, wenn der gespeicherte Kostenfaktor niedriger als die Voreinstellung ist, erfordert ein Zurücksetzen des Benutzerpassworts.',

   'in body'
=> 'im Inhalt',

   'in subject'
=> 'im Betreff',

   'none -- defaults to No'
=> 'leer -- voreingestellter Wert: Nein',

   'sent to'
=> 'gesendet an',

   'All with domain helpdesk assistant role'
=> 'Jeder mit Domänen-Helpdesk-Assistenten Rolle',

   'All with domain helpdesk or helpdesk assistant role'
=> 'Jeder mit Domänen-Helpdesk oder Domänen-Helpdesk-Assistenten Rolle',

   'All with domain helpdesk role'
=> 'Jeder mit Domänen-Helpdesk Rolle',

   'Allowed institutional types'
=> 'Zugelassene institutionelle Benutzertypen',

   'Allowed personnel'
=> 'Zugelassenes Personal',

   'Cc e-mail'
=> 'CC E-Mail',

   'Check bcrypt cost if authenticated'
=> 'Überprüfe bcrypt Kostenfaktor, wenn authentifiziert',

   'Determined based on institutional status'
=> 'Auf Grundlage des institutionellen Status festgelegt',

   'Disallowed personnel'
=> 'Nicht zugelassenes Personal',

   'Display order'
=> 'Anzeigereihenfolge',

   'Encryption cost for bcrypt (positive integer)'
=> 'Kostenfaktor für bcrypt (positiver Integer)',

   'Exclude all, but include specific personnel'
=> 'Alle ausschließen, aber bestimmtes Personal einschließen',

   'Existing crypt-based switched to bcrypt on authentication'
=> 'Crypt-basierte Passwortverschlüsselung durch bcrypt bei Authentifizierung ersetzen',

   'File upload'
=> 'Dateiupload',

   'Helpdesk requests for other (unconfigured) domains'
=> 'Helpdesk Anfragen für andere (nicht konfigurierte) Domänen',

   "Helpdesk requests for this domain's users"
=> "Helpdesk Anfragen für Benutzer dieser Domäne",

   'Hide details'
=> 'Verstecke Details',

   'Include all, but exclude specific personnel'
=> 'Alle einschließen, aber bestimmtes Personal ausschließen',

   'Lifetime (s) of "Temporary" MySQL tables (student performance data) on homeserver'
=> 'Lebensdauer (in s) von "temporären" MySQL Tabellen (studentische Leistungsdaten) auf Heimatserver',

   'Order'
=> 'Reihenfolge',

   'ReCAPTCHA version (1 or 2)'
=> 'ReCAPTCHA Version (1 or 2)',

   'Role description'
=> 'Rollenbeschreibung',

   'Role usage'
=> 'Rollenverwendung',

   'Show details'
=> 'Details anzeigen',

   'Which helpdesk personnel may use this role?'
=> 'Welches Helpdesk Personal darf diese Rolle verwenden?',

   'Yes, allow login then update passwd file using default cost (if higher)'
=> 'Ja, erlaube Anmeldung und aktualisiere passwd Datei (verwende voreingestellten K