# The LearningOnline Network
# Unauthorized to access construction space
#
# $Id: lonunauthorized.pm,v 1.17 2013/06/07 16:07:49 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonunauthorized;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon;
use Apache::lonnet;
use Apache::lonlocal;
use LONCAPA();
use HTML::Entities();

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

# ------------------------------------------------------------ Print the screen
# Figure out who the user is and what they wanted to access

    my ($ownername,$ownerdomain,$ownerhome);
    if ($env{'request.editurl'} ne '') {
        ($ownername,$ownerdomain,$ownerhome) = 
            &Apache::lonnet::constructaccess($env{'request.editurl'});
    }

    # Breadcrumbs
    &Apache::lonhtmlcommon::clear_breadcrumbs();
    if ($env{'request.role'} =~ /^(au|ca|aa)/) { 
        &Apache::lonhtmlcommon::add_breadcrumb({
            'text' => 'Authoring Space',
            'href' => &Apache::loncommon::authorspace($env{'request.editurl'}),
        });
    } elsif (($env{'request.course.id'}) && 
             (&Apache::lonnet::allowed('mdc',$env{'request.course.id'}))) {
        &Apache::lonhtmlcommon::add_breadcrumb({
            'text' => 'Course Contents',
            'href' => '/adm/coursedocs',
        });
    }

# print header
    $r->print(&Apache::loncommon::start_page("Failed Access to Authoring Space",
					     undef,
					     {'domain' => $ownerdomain,}).
                                             &Apache::lonhtmlcommon::breadcrumbs());
# figure out what went wrong

    if ($ownerdomain) {
        if ($ownerhome eq 'no_host') {
            $r->print('<p class="LC_error">'.
                      &mt('Unable to determine home server for this resource: [_1]',
                      '<span class="LC_filename">'.$env{'request.editurl'}.'</span>').
                      '</p>');
        } else {
            my @hosts = &Apache::lonnet::current_machine_ids();
            if (!grep(/^\Q$ownerhome\E$/,@hosts)) {
                my $switchlink = '/adm/switchserver?otherserver='.$ownerhome.
                                 '&origurl='.&HTML::Entities::encode($env{'request.editurl'},'<>&"');
	        $r->print('<p class="LC_warning">'.
                          &mt('The Authoring Space for this resource is located on a different server: [_1]',
                          '<b><tt>'.&Apache::lonnet::hostname($ownerhome).'</b></tt>').
                          '</p>'.
                          '<p class="LC_error"><a href="'.$switchlink.'">'.
                          &mt('Switch Server').'</a>'.
                          '</p>');
            } else {
                $r->print('<p class="LC_error">'.
                          &mt('You do not have authoring privileges for this resource').' '.
                          '<span class="LC_filename">'.$env{'request.editurl'}.'</span>'.
                          '</p>');
            }
        }
    } elsif (!$env{'request.editurl'}) {
        if ($ENV{'REDIRECT_URL'} =~ m{^/adm/([^/]+)}) {
            my $action = $1;   
            my ($option,$filename,$filename1,$filename2,$decompress,
                $qualifiedfilename);
            if ($ENV{'REDIRECT_QUERY_STRING'} ne '') {
                foreach my $pair (split(/&/,$ENV{'REDIRECT_QUERY_STRING'})) {
                    my ($name,$value) = split(/=/,$pair);
                    if ($name eq 'filename') {
                        if (($action eq 'publish') || ($action eq 'cfile')) {
                            $filename = &LONCAPA::unescape($value);
                        } else {
                            $filename = $value;
                        }
                    } elsif ($name eq 'filename1') {
                        $filename1 = $value;
                    } elsif ($name eq 'filename2') {
                        $filename2 = $value;
                    } elsif ($name eq 'decompress') {
                        $decompress = $value;
                        $option = 'decompress';
                    } elsif ($name eq 'qualifiedfilename') {
                        $qualifiedfilename = $value;
                    } elsif ($name eq 'versionone') {
                        if ($value eq 'priv') {
                            $option = 'cstr';
                        }
                    } elsif ($name eq 'versiontwo') {
                        if ($value eq 'priv') {
                            $option = 'cstr';
                        }
                    } elsif ($name eq 'filetwo') {
                        $option = $value; 
                    }
                }
                if (($action eq 'upload') || ($action eq 'testbank')) {
                    if (($filename1 ne '') && ($filename ne '')) {
                        $filename = $filename1.$filename2;
                    }
                } elsif ($action eq 'cfile') {
                    if ($decompress ne '') {
                        $filename = $decompress;
                    } elsif ($qualifiedfilename ne '') {
                        $filename = $qualifiedfilename;
                    }
                }
                my %deniedactions = &get_denied_action_text();
                my $warning;
                if ($option eq 'decompress') {
                    $warning = $deniedactions{$option};
                } else {
                    $warning = $deniedactions{$action};
                }
                if ($warning) {
                    if (($action eq 'diff') && ($option ne 'cstr')) {
                        $r->print('<p class="LC_error">'.
                                  $deniedactions{$action}.'</p><p class="LC_warning">'.
                                  &mt('You do not have privileges to view the published resource').' '.
                                      '<span class="LC_filename">'.$filename.'</span>'.
                                  '</p>');
                    } else {
                        if (($action eq 'diff') && ($option eq 'cstr')) {
                            $filename =~ s{^/res/}{/priv/};
                        }
                        $r->print('<p class="LC_error">'.
                                  $deniedactions{$action}.'</p><p class="LC_warning">'.
                                  &mt('You do not have authoring privileges for this resource').' '.
                                      '<span class="LC_filename">'.$filename.'</span>'.
                                  '</p>');
                    }
                } else {
                    $r->print('<p class="LC_error">'.
                              &mt('You are not permitted to take this action.').
                              '</p>');
                }
            }
        } elsif ($r->uri =~ m{priv/.+\.\d+\.[^.]+$}) {
            $r->print('<p class="LC_error">'.
                      &mt('There is a problem with the filename').' '.
                      '<span class="LC_filename">'.$r->uri.'</span></p>'.
                      '<p class="LC_warning">'.
                      &mt('You may be attempting to edit a versioned file (files in Authoring Space may not include a version number before the extension).').
                      '</p>');
        } else {
            $r->print('<p class="LC_error">'.
                      &mt('You are not permitted to take this action.').
                      '</p>'); 
        }
    } elsif ($env{'request.editurl'} =~ m{priv/.+\.\d+\.[^.]+$}) {
        $r->print('<p class="LC_error">'.
                  &mt('There is a problem with the filename').' '.
                  '<span class="LC_filename">'.$env{'request.editurl'}.'</span></p>'.
                  '<p class="LC_warning">'.
                  &mt('You may be attempting to edit a versioned file (files in Authoring Space may not include a version number before the extension).').
                  '</p>');
    } else {
        $r->print('<p class="LC_error">'
                 .&mt('You do not have authoring privileges for this resource').' '
                 .'<span class="LC_filename">'.$env{'request.editurl'}.'</span>'
                 .'</p>');
        my ($realownerdom,$realownername) =
	    ($env{'request.editurl'}=~m{^/priv/($LONCAPA::domain_re)/($LONCAPA::username_re)});
        my $realownerhome=
	    &Apache::lonnet::homeserver($realownername,$realownerdom);
        unless ($realownerhome eq 'no_host') {
            my $plainname=&Apache::loncommon::plainname($realownername,$realownerdom);
            my $user=$realownername.':'.$realownerdom;
            my $userlink=&Apache::loncommon::aboutmewrapper(
                             $plainname.' ('.$user.')'
                            ,$realownername
                            ,$realownerdom);
	    $r->print('<p>'
                     .&mt('Contact [_1] for access.',$userlink)
                     .'</p>');
        }
    }
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

sub get_denied_action_text {
    my %deniedtext = 
        &Apache::lonlocal::texthash(
           cfile      => 'Copying, moving, renaming or creating file not allowed.',
           publish    => 'Publishing not allowed.',
           upload     => 'Uploading file not allowed.',
           testbank   => 'Uploading testbank file not allowed',
           retrieve   => 'Retrieving version information not allowed.',
           cleanup    => 'Clean up of file not allowed.',
           diff       => 'Display of differences between file versions disallowed.',
           decompress => 'Decompression of archive file disallowed.',
    );
    return %deniedtext;
}

1;
__END__
