# The LearningOnline Network
# Information about blocking status for Portfolio files
#
# $Id: blockedaccess.pm,v 1.6 2020/10/01 10:16:33 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::blockedaccess;

use strict;
use Apache::Constants qw(:common);
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonlocal;
use HTML::Entities();

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    &Apache::lonlocal::get_language_handle($r);
    my $ver_origurl = $r->uri;
    my $origurl = &Apache::lonnet::deversion($r->uri);
    my ($blocked,$blocktext);

    if (&Apache::lonnet::is_portfolio_url($origurl)) {
        my ($type,$udom,$uname,$file_name,$group) = 
	    &Apache::lonnet::parse_portfolio_url($origurl);
        ($blocked,$blocktext) = 
            &Apache::loncommon::blocking_status('port',$uname,$udom);
    } else {
        if ($env{'request.course.id'}) {
            my $cnum = $env{'course.'.$env{'request.course.id'}.'.num'};
            my $cdom = $env{'course.'.$env{'request.course.id'}.'.domain'};
            my $symb = $env{'request.symb'};
            my $url = $origurl;
            # If no symb, and url is on not map, check for referrer
            unless (($symb) || &Apache::lonnet::is_on_map($url) || ($origurl eq '/adm/blockedaccess'))  {
                my $refuri = $env{'httpref.'.$origurl} || $env{'httpref.'.$ver_origurl};
                if ($refuri) {
                    $url = $refuri;
                }
            }
            ($blocked,$blocktext) =
                &Apache::loncommon::blocking_status('docs',$cnum,$cdom,$url,1,$symb,'blockedaccess');
        }
    }
    if ($blocked) {
        $r->print(&Apache::loncommon::start_page('Access Temporarily Blocked'));
        $r->print($blocktext);
    } elsif ($origurl eq '/adm/blockedaccess') {
        $r->print(&Apache::loncommon::start_page('Access Blocking Information'));
        $r->print('<p class="LC_warning">'.&mt('Could not determine which page had access blocked.').'</p>');
    } else {
        $r->print(&Apache::loncommon::start_page('Access Blocking Information'));
        my $link;
        if ($origurl ne '') {
            my $showurl = &Apache::lonenc::check_encrypt($origurl);
            $link = &Apache::lonnet::absolute_url().$showurl;
            if ($r->args ne '') {
                $link .= '?'.$r->args;
            }
        }
        $r->print('<p class="LC_info">'.
                  &mt('The page you are trying to reach was reported as having access blocked, but the reason is not available.').
                  '</p>');
        if ($link) {
            $r->print('<p><a href="'.&HTML::Entities::encode($link,'\'"<>&').'">'.&mt('Try again?').'</a></p>');
        }
    }
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

sub setup_handler {
    my ($r) = @_;
    $r->set_handlers('PerlHandler'=>
                     [\&Apache::blockedaccess::handler]);
    $r->handler('perl-script');
}

1;
