# The LearningOnline Network
# Access Handler for User Files
#
# $Id: lonuploadedacc.pm,v 1.17 2017/02/08 18:01:32 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#



package Apache::lonuploadedacc;


use strict;
use Apache::Constants qw(:common :http);
use Apache::lonnet;
use LONCAPA qw(:match);

sub handler {
    my $r = shift;
    my $args=$r->args;
    &Apache::loncommon::get_unprocessed_cgi($args,['token','tokenissued']); 
    my (undef,undef,$udom,$uname,$ufile)=split(/\//,$r->uri,5);
    $ufile=~s/^[\~\.]+//;
    my $remoteserver=$env{'form.tokenissued'};
    my $reply=&Apache::lonnet::reply('tokenauthuserfile:'.
                 $udom.'/'.$uname.'/'.$ufile.':'.$env{'form.token'},
				     $remoteserver);
    if ($reply eq 'ok') {
       if (($r->user() eq '') && ($env{'form.token'} ne '')) {
           my ($cuname,$cudom) = 
               ($env{'form.token'} =~ /^($match_username)_\d+_($match_domain)_/); 
           if ($cuname ne '') {
               if ($cudom eq $r->dir_config('lonDefDomain')) {
                   $r->user($cuname);
               } else {
                   $r->user($cuname.':'.$cudom);
               }
           } else {
               $r->user('public');
           }
       } else {
           $r->user('public');
       }
       return OK;
   } elsif ($reply eq 'con_lost' || $reply eq 'no_such_host') {
       &Apache::lonnet::logthis("Server unavailable for userfile access $uname at $udom for $ufile with $remoteserver token $env{'form.token'}: $reply");
       return HTTP_SERVICE_UNAVAILABLE;
   } else {
       &Apache::lonnet::logthis("Refused userfile access $uname at $udom for $ufile with $remoteserver token $env{'form.token'}: $reply");
       return FORBIDDEN;
   }
}

sub skip_phase {
    return OK;
}

1;
__END__



=head1 NAME

Apache::lonuploadedacc

=head1 SYNOPSIS

The way this is supposed to work:

 User A has client machine C 
 User A is logged into LON-CAPA server S
 needs file from user B
 homeserver for user B is H

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.

=head1 HANDLER SUBROUTINE

This handler runs on H
To access a userfile:
Server S generates a token and puts it into the query string of URL for H
Client box C asks H for file with token issued by C
H now must ask S if token is valid, uses S's lond-command tokenauthuserfile

=cut



