# The LearningOnline Network
# Cookie Based Access Handler
#
# $Id: publiccheck.pm,v 1.24.2.2 2021/01/04 03:53:20 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

package Apache::publiccheck;

use strict;
use Apache::Constants qw(:common :http :methods);
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonlocal;
use Fcntl qw(:flock);
use Apache::lonacc();
use LONCAPA();

sub handler {
    my $r = shift;

    my $requrl=$r->uri;

    if (&Apache::lonnet::is_domainimage($requrl)) {
        return OK;
    }

    if ($requrl =~ m{^/res/adm/pages/[^/]+\.(gif|png)$}) {
        return OK;
    }

    my $handle = &Apache::lonnet::check_for_valid_session($r);
    if ($handle ne '') {
        my $lonidsdir=$r->dir_config('lonIDsDir');
	&Apache::lonnet::transfer_profile_to_env($lonidsdir,$handle);
	if ($env{'user.name'} ne 'public'
	    && $env{'user.domain'} ne 'public') {
	    return OK;
	}
    }
    if ($requrl=~m|^/public/|
	|| $requrl=~m|^/adm/help/.*\.hlp$|
	|| $requrl=~m|^/adm/[^/]+/[^/]+/aboutme/portfolio$|
	|| (&Apache::lonnet::metadata($requrl,'copyright') eq 'public') 
    || $requrl=~m|^/adm/blockingstatus/.*$|) {
        &process_public($r,$requrl);
        return OK;
    } elsif (&Apache::lonnet::is_portfolio_url($requrl)) {
	my (undef,$udom,$unum,$file_name,$group) = 
	    &Apache::lonnet::parse_portfolio_url($requrl);
        my $access = &process_portfolio($r,$udom,$unum,$file_name,$group);
        if ($access) {
            &process_public($r,$requrl,$access);
            return OK;
        } 
    } elsif ($requrl eq '/adm/restrictedaccess') {
        &process_public($r,$requrl);
	return OK;
    } elsif ($requrl eq '/adm/blockedaccess') {
       &process_public($r,$requrl);
       return OK;
    }
    return DECLINED;
}

sub process_public {
    my ($r,$requrl,$access) = @_;
    &Apache::lonnet::logthis('Granting public access: '.$requrl);
    if ($env{'user.name'} ne 'public' && $env{'user.domain'} ne 'public') {
        my $cookie=&Apache::lonauth::success($r,'public','public','public');
        my $lonidsdir=$r->dir_config('lonIDsDir');
        &Apache::lonnet::transfer_profile_to_env($lonidsdir,$cookie);
	$r->err_header_out('Set-cookie',"lonID=$cookie; path=/; HttpOnly");
    }
    &Apache::lonacc::get_posted_cgi($r);
    $env{'request.state'} = "published";
    $env{'request.publicaccess'} = 1;
    $env{'request.filename'} = $r->filename;
    return;
}

sub process_portfolio {
    my ($r,$udom,$unum,$file_name,$group) = @_;
    my $current_perms = &Apache::lonnet::get_portfile_permissions($udom,$unum);
    my %access_controls = &Apache::lonnet::get_access_controls($current_perms,$group,$file_name);
    my $access = '';
    my $now = time;
    my $clientip = &Apache::lonnet::get_requestor_ip($r);
    foreach my $key (keys(%{$access_controls{$file_name}})) {
        my ($num,$scope,$end,$start) = ($key =~ /^([^:]+):([a-z]+)_(\d*)_?(\d*)$/);
        if ($start > $now) {
            next;
        }
        if ($end && $end<$now) {
            next;
        }
        if ($scope eq 'public') {
            $access = 'public';
            last;
        }
        if ($scope eq 'ip') {
            if (ref($access_controls{$file_name}{$key}) eq 'HASH') {
                if (ref($access_controls{$file_name}{$key}{'ip'}) eq 'ARRAY') {
                    if (&Apache::loncommon::check_ip_acc(join(',',@{$access_controls{$file_name}{$key}{'ip'}}),$clientip)) {
                        $access = 'ip';
                        last;
                    }
                }
            }
        }
        if ($scope eq 'guest') {
            $access = 'guest';
        }
    }
    return $access;
}

1;

__END__
