#!/usr/bin/perl
$|=1;
# Generates a html page showing various sataus reports about the cluster
# $Id: translator.pl,v 1.1 2003/09/16 22:40:25 www Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
use strict;
use GDBM_File;

my $buffer;

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
my @pairs=split(/&/,$buffer);
my $pair; my $name; my $value;

my %FORM=();
my %hash=();

foreach $pair (@pairs) {
    ($name,$value) = split(/=/,$pair);
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
    $FORM{$name}=$value;
} 


$buffer=$ENV{'QUERY_STRING'};
@pairs=split(/&/,$buffer);
foreach $pair (@pairs) {
    ($name,$value) = split(/=/,$pair);
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
    $FORM{$name}=$value;
} 
print 'Content-type: text/html'."\n\n";


    print (<<ENDSCREEN);
<html><body>
<h1>LON-CAPA Localization Project</h1>
<h3>Language: $FORM{'lang'}</h3>
<a href="/cgi-bin/translator.pl?lang=$FORM{'lang'}&list=1">List all</a><br />
ENDSCREEN

$FORM{'lang'}=~s/\W//g;

if ($FORM{'trans'}) {
    if (tie(%hash,'GDBM_File',
	  '/home/httpd/perl/logs/'.$FORM{'lang'}.'.db',&GDBM_WRCREAT(),0640)) {
	$hash{$FORM{'arg1'}}=$FORM{'trans'};
	untie %hash;
	print "Stored.";
    }
} elsif ($FORM{'list'}) {
    if (tie(%hash,'GDBM_File',
	  '/home/httpd/perl/logs/'.$FORM{'lang'}.'.db',&GDBM_READER(),0640)) {
	print "<pre>";
	foreach (sort keys %hash) {
	    print "\n   '".$_."'".
		"\n=> '".$hash{$_}."',\n";
	}
	print "</pre>";
	untie %hash;
    }
} else {
    my $trans=$FORM{'arg1'};
    if (tie(%hash,'GDBM_File',
	  '/home/httpd/perl/logs/'.$FORM{'lang'}.'.db',&GDBM_READER(),0640)) {
	if ($hash{$trans}) { $trans=$hash{$trans}; }
	untie %hash;
    }
    print (<<ENDQUERY);
<blockquote>$FORM{'arg1'}</blockquote>
<form method="post">
<input type="hidden" name="org" value="$FORM{'arg1'}">
<input type="hidden" name="lang" value="$FORM{'lang'}">
<input type="text" size="80" name="trans" value="$trans">
<input type="submit">
</form>
ENDQUERY
}

print('</body></html>');
exit 0;
