# The LearningOnline Network
# Pick a CODE from the list of possible CODEs
#
# $Id: lonpickcode.pm,v 1.17 2019/01/31 16:08:06 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonpickcode;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::grades();
use Apache::lonlocal;
use Apache::lonnet;

sub get_code_freq {
    my ($r)=@_;
    my %codes;
    my %scantron_config=
	&Apache::lonnet::get_scantron_config($env{'form.scantron_format'});
    $r->rflush();
    my ($scanlines,$scan_data)=&Apache::grades::scantron_getfile();
    for (my $i=0;$i<=$scanlines->{'count'};$i++) {
	my $line=&Apache::grades::scantron_get_line($scanlines,$scan_data,$i);
	if ($line=~/^[\s\cz]*$/) { next; }
	my $scan_record=
	    &Apache::grades::scantron_parse_scanline($line,$i,
						     \%scantron_config,
						     $scan_data,1);
	push(@{$codes{$$scan_record{'scantron.CODE'}}},$$scan_record{'scantron.PaperID'});

    }
    return %codes;
}

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
					    ['curCODE','scantron_selectfile',
					     'form','scantron_format','symb',
					     'scantron_CODElist','command']);

    if  (!($env{'request.course.id'}) && 
	 (&Apache::lonnet::allowed('usc',$env{'request.course.id'}))) {
	$r->print(&Apache::loncommon::start_page().
		  '<p class="LC_error">'.&mt('Access not allowed.').'</p>'.
		  &Apache::loncommon::end_page());
        return OK;
    }
    if      ($env{'form.command'} eq 'codelist') {
	&code_list($r);
        $r->print(&Apache::grades::show_grading_menu_form($env{'form.symb'},
						      $env{'form.url'}));	
    } elsif ($env{'form.command'} eq 'showcodes') {
	&show_codes($r);
    } else {
	&picking_a_code($r);
    }
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

sub code_list {
    my ($r,$context)=@_;
    # $context = 0 Print page header and enclosing table
    # $context = 1 No page header, print enclosing table
    # $context = 2 No page header, no enclosing table
    my $table_head;
    my $extra_css;
    if (!$context) {
	$r->print(&Apache::loncommon::start_page("View CODEs",undef,
						 {'no_nav_bar' => 1}));
	$table_head = &mt('Select a set of saved CODEs to view.');
    } elsif ($context eq 1) {
	$table_head = &mt('Select another set of saved CODEs to view.');
    } elsif ($context eq 2) {
        $table_head = &mt('Select a set of saved CODEs to view.');
	$extra_css = 'LC_scantron_action';
    }
    $r->print("<form method='post' action='/adm/pickcode' name='pickcode'>");
    $r->print('
     '.&Apache::loncommon::start_data_table($extra_css).'
       '.&Apache::loncommon::start_data_table_header_row());
    $r->print('<th>');
    $r->print($table_head);
    $r->print('</th>');
    $r->print('
       '.&Apache::loncommon::end_data_table_header_row().'
       '.&Apache::loncommon::start_data_table_row());
    $r->print('<td>');
    $r->print("<input type='submit' name='submit' value='".&mt("View:")."' /> ");
    $r->print(&Apache::grades::scantron_CODElist());
    $r->print('</td>');
    $r->print('
       '.&Apache::loncommon::end_data_table_row().'
       '.&Apache::loncommon::end_data_table());
    $r->print("<input type='hidden' name='command' value='showcodes' />");
    $r->print("<input type='hidden' name='symb' value='".$env{'form.symb'}."' />");
    $r->print("<input type='hidden' name='url' value='".$env{'form.url'}."' />");
    $r->print("</form>");
    
}

sub show_codes {
    my ($r)=@_;
    $r->print(&Apache::loncommon::start_page("View CODEs",undef,
					     {'no_nav_bar' => 1}));
    my %codes=&Apache::grades::get_codes();
    $r->print("<h2>".$env{'form.scantron_CODElist'}."</h2>");
    $r->print('<pre>');
    foreach my $code (sort(keys(%codes))) {
	$r->print($code."\n");
    }
    $r->print('</pre>');
    &code_list($r,1);
    $r->print(&Apache::grades::show_grading_menu_form($env{'form.symb'},
						      $env{'form.url'}));
}

sub picking_a_code {
    my ($r)=@_;
    my $title = 'Selecting a CODE';
    $r->print(&Apache::loncommon::start_page($title,undef,
					     {'no_nav_bar' => 1}));
    $r->print('<h1>'.&mt($title).'</h1>');

    $r->print(&Apache::lonhtmlcommon::scripttag("
function gochoose(newcode) {
    opener.document.$env{'form.form'}.scantron_CODE_selectedvalue.value=newcode;
    var slct=opener.document.$env{'form.form'}.scantron_CODE_resolution;
    var i;
    for (i=0;i<slct.length;i++) {
        if (slct[i].value=='use_found') { slct[i].checked=true; }
    }
    self.close();
}
"));

    $r->print(
        '<p>'
       .&mt('The CODE on the paper is [_1]. Please select a new one.',
                '<tt><b>'.$env{'form.curCODE'}.'</b></tt>')
       ."</p>\n".'<form action="">'
    );
    my %codes=&Apache::grades::get_codes();
    my %code_freq=&get_code_freq($r);
    my $num_matches=length($env{'form.curCODE'});
    for (my $i=$num_matches;$i>=0;$i--) {
	my $to_print =
            '<p>'.&mt('CODEs with [_1] matching letters:',$i)."</p>\n"
           .&Apache::loncommon::start_data_table()
           .&Apache::loncommon::start_data_table_header_row()
           .'<th>&nbsp;</th>'
           .'<th>'.&mt('CODE').'</th>'
           .'<th>'.&mt('Bubblesheet Exams using this CODE').'</th>'
           .&Apache::loncommon::end_data_table_header_row();

	my $print;
	foreach my $code (sort(keys(%codes))) {
	    if (&Apache::grades::num_matches($env{'form.curCODE'},$code) != $i) { next; }
	    $print=1;
	    my ($count,$list);
	    if (!ref($code_freq{$code})) {
		$count=0;
	    } else {
		$count=scalar(@{$code_freq{$code}});
		$list=' - '.join(', ',@{$code_freq{$code}});
	    }
        $to_print .=
            &Apache::loncommon::start_data_table_row()
           .'<td><input type="button" value="'.&mt('Select')
           .'" onclick="gochoose(\''.$code.'\')" /></td>'
           .'<td><tt>'.$code.'</tt></td>'
           .'<td>'.$count.$list.'</td>'
           .&Apache::loncommon::end_data_table_row();
            delete($codes{$code});
        }
        $to_print .= &Apache::loncommon::end_data_table();
        if ($print) { $r->print($to_print); }
    }
    $r->print('</form>');
} 

1;
__END__
