# The LearningOnline Network with CAPA
# Interface routines for Aspell
#
# $Id: lonspeller.pm,v 1.17 2006/07/03 13:40:42 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################

package Apache::lonspeller;

use Apache::Constants qw(:common);
use Text::Aspell;
use Apache::lonlocal;
use Apache::lonnet;
use Apache::lontexconvert();
use HTML::LCParser;
use strict;

my $speller;
my $insidelink;

sub spellcheck_language {
    if ($env{'form.lang'}) { return $env{'form.lang'}; }
    if (&mt('spellcheck_lang') ne 'spellcheck_lang') {
	return &mt('spellcheck_lang');
    }
    return 'en_US';
}

sub set_language {
    my $lang=&spellcheck_language();
    $speller->set_option('lang',$lang);
}

{
    my $uniq;
    sub get_uniq {
	return ++$uniq;
    }
}

sub textsection {
    my $input=shift;
    my $output='';
    &set_language();
    foreach my $word (split(/\b/,$input)) {
	if (($word=~/\W/) || ($word=~/^(lt|gt|nbsp|amp)$/i)
	    || ($speller->check($word))) {
	    $output.=$word;
	} else {
	    my $suggestions=join(' ',$speller->suggest($word));
	    $suggestions = &Apache::loncommon::js_ready($suggestions);
	    if (($suggestions) && (!$insidelink)) {
		my $start_page=
		    &Apache::loncommon::start_page('Speller Suggestions',undef,
						   {'only_body'   => 1,
						    'js_ready'    => 1,
						    'bgcolor'     => '#FFFFFF'});
		my $end_page=
		    &Apache::loncommon::end_page({'js_ready'    => 1,});
		my $num = &get_uniq();
		my $info  ='<h3>'.$word.'</h3>'.$suggestions;
		$output .= "<script type=\"text/javascript\">
//<!--
 function LONCAPA_lonspeller_$num() {
    spellwin=open(".&Apache::lonhtmlcommon::javascript_nothing().",'spellwin','width=140,height=280,resizable=yes,scrollbars=yes,location=no,menubar=no,toolbar=no');
    spellwin.".&Apache::lonhtmlcommon::javascript_docopen().";
    spellwin.document.writeln('$start_page $info $end_page');
    spellwin.document.close();
    spellwin.focus();
}
//-->
</script><a href=\"javascript:LONCAPA_lonspeller_$num();void(0);\">";
	    }
	    $output.='<font color="red">'.$word.'</font>';
	    if (($suggestions) && (!$insidelink)) { $output.='</a>'; }
	}
    }
    return $output;
}


sub markeduptext {
    my $input=shift;
    my $output='';
    my $parser=HTML::LCParser->new(\$input);
    $insidelink=0;
    my $token;
    while ($token=$parser->get_token) {
	if ($token->[0] eq 'T') {
	    $output.=&textsection($token->[1]);
	} elsif ($token->[0] eq 'S') {
	    $output.=$token->[4];
	    foreach my $tag ('m','script') {
		if ($token->[1] eq $tag) {
		    $output.=$parser->get_text('/'.$tag);
		}
	    }
	    if ($token->[1] eq 'a') {
		$insidelink=1;
	    }
	} elsif ($token->[0] eq 'E') {
	    $output.=$token->[2];
	    if ($token->[1] eq 'a') {
		$insidelink=0;
	    }
	}
    }
    $insidelink=0;
    return $output;
}

sub initspeller {
    unless (defined($speller)) {
	$speller = Text::Aspell->new;
	$speller->set_option('lang','en_US');
    }
    $insidelink=0;
}

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'});

    &initspeller();
    my $start_page = 
	&Apache::loncommon::start_page('Spell Checker',undef,
				       {'only_body' => 1,
					'bgcolor'   => '#DDDDDD'});
    $r->print($start_page.
	      &Apache::lontexconvert::msgtexconverted(
				     &markeduptext($env{'form.text'})).
	      &Apache::loncommon::end_page());
    return OK;
}

BEGIN {
    &initspeller();
}

1;

__END__
