
# The LearningOnline Network
# URL translation for encrypted filenames
#
# $Id: lonencurl.pm,v 1.7 2020/03/04 16:33:35 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonencurl;

use strict;
use Apache::Constants qw(:common :remotehost);
use Apache::lonnet;
use Apache::lonenc;
use GDBM_File;

sub handler {
    my $r = shift;

    $env{'request.enc'}=1;

    my $handle = &Apache::lonnet::check_for_valid_session($r);
    if ($handle ne '') {
# Initialize Environment
	my $lonidsdir=$r->dir_config('lonIDsDir');
	&Apache::lonnet::transfer_profile_to_env($lonidsdir,$handle);
# Decrypt URL, if appropriate, and redirect
        my $redirect;
        my ($decrypted,$encnum,$remainder) = &checkdecryption($r->uri);
        if (($encnum ne '') && ($remainder ne '')) {
            my $referrer = $r->headers_in->{'Referer'} || '';
            my $host = $r->headers_in->{'Host'};
            my $decryptreferrer;
            if ($referrer =~ m{^https?://\Q$host\E(/enc/\Q$encnum\E/[^?]+)}) {
                ($decryptreferrer) = &checkdecryption($1);
            }
            if ($decryptreferrer eq '') {
                if ($env{'request.course.fn'} ne '') {
                    my %symbhash;
                    if (tie(%symbhash,'GDBM_File',$env{'request.course.fn'}.'_symb.db',
                        &GDBM_READER(),0640)) {
                        my $lastsymb=$symbhash{'last_known'};
                        untie(%symbhash);
                        (undef,undef,$decryptreferrer)=&Apache::lonnet::decode_symb($lastsymb);
                        $decryptreferrer = &Apache::lonnet::clutter($decryptreferrer);
                    }
                }
            }
            if ($decryptreferrer ne '') {
                my ($referrerpath) = ($decryptreferrer =~ m{^(.+/)[^/]+$});
                if (($env{'httpref.'.$referrerpath.$remainder} eq $decryptreferrer) ||
                    ($env{'httpref.'.$referrerpath.'*'} eq $decryptreferrer) ||
                    ($env{'httpref.'.$referrerpath} eq $decryptreferrer)) {
                   $redirect=$referrerpath.$remainder;
                }
            }
        }
        my $anchor;
        if ($redirect eq '') {
            $redirect=&Apache::lonenc::unencrypted($r->uri);
            if ($redirect =~ m{^/adm/wrapper/ext/[^\#]+(\#.+)$}) {
                $anchor = $1;
                $redirect =~ s/\#.+$//;
            } elsif (($redirect =~ m{^https?://}) && ($r->args)) {
                my $symb;
                foreach my $item (split(/\&/,$r->args)) {
                    my ($key,$value) = split(/=/,$item);
                    if ($key eq 'symb') {
                        $symb = &Apache::lonenc::unencrypted($value);
                        last;
                    }
                }
                if ($symb) {
                    my ($map,$id,$res) = &Apache::lonnet::decode_symb($symb);
                    if (($map =~ /\.page$/) && ($res =~ m{^ext/})) {
                         if ($res =~ /(\#[^#]+)$/) {
                             $anchor = $1;
                         }
                         $r->headers_out->set(Location => $redirect.$anchor);
                         return REDIRECT;
                    }
                }
            }
        }
	if ($r->args) { $redirect.='?'.$r->args; }
	$r->internal_redirect($redirect.$anchor);
	return OK;
    }
    return FORBIDDEN;
}

sub checkdecryption {
    my ($uri) = @_;
    my ($encnum,$encname,$rest) = ($uri =~ m{^/enc/(\d+)/([^.]+)(.*)$});
    my $enclength = length($encname);
    my $rem = $enclength%16;
    if (($encname =~ /[^a-f0-9]/) || ($rem != 0) || ($enclength < 16)) {
        return ('',$encnum,$encname.$rest);
    } else {
        return (&Apache::lonenc::unencrypted($uri));
    }
}

1;
__END__
