# The LearningOnline Network
# Replication Manager
#
# $Id: lonrep.pm,v 1.15 2020/09/03 13:40:50 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonrep;

use strict;
use Apache::Constants qw(:common :http);
use Apache::lonnet;
use Apache::File();

sub update_filename {
    my ($r,$filename) = @_;
    my $oldfile = $r->filename($filename);
    if ($ENV{'MOD_PERL_API_VERSION'} == 2
	&& -e $filename) {
	eval {
	    require APR::Finfo;
	    require APR::Const;
	    $r->finfo(APR::Finfo::stat($filename, 
				       &APR::Const::FINFO_NORM(),
				       $r->pool));
	};
	if ($@) {
	    return $@;
	}
    }
    return;
}

sub handler {
    my $r = shift;
    if (-e $r->finfo) {
      return OK;
    } else {
      my $filename=$r->filename.$r->path_info;
      if ($filename=~/\/$/) { return OK; }
      if ($filename eq '/home/httpd/html/res/lib/templates/simpleproblem.problem/smpedit') { return OK; }
      if (-e "$filename.in.transfer") {
	sleep 10;
        if (-e $filename) {
	    my $error = &update_filename($r,$filename);
	    if ($error) {
		$r->log_reason('Update filename failed '.$error);
		return HTTP_SERVICE_UNAVAILABLE;
	    }
	    return OK;
        } else {
	    $r->log_reason("Waiting for file transfer timed out",$filename);
	    return HTTP_SERVICE_UNAVAILABLE;
        }
      } else {
          my $response=&Apache::lonnet::repcopy($filename);
          if ($response eq 'ok' && -e $filename) {
	      $r->path_info('');
	      my $error = &update_filename($r,$filename);
	      if ($error) {
		  $r->log_reason('Update filename failed after replication '.$error);
		  return HTTP_SERVICE_UNAVAILABLE;
	      }
              return OK;
          }
          my $handle = &Apache::lonnet::check_for_valid_session($r);
          if ($handle) {
	     $r->log_reason('Replication failed for '.$handle);
             return $response;
	  } else {
	     $r->log_reason('Replication failed for unknown user'); 
             return FORBIDDEN;
          } 
      }
    }
}

1;
__END__








