# The LearningOnline Network with CAPA
# TeX Content Handler
#
# $Id: lontex.pm,v 1.13 2008/11/24 17:17:52 jms Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#
# Copyright for TtHfunc and TtMfunc by Ian Hutchinson. 
# TtHfunc and TtMfunc (the "Code") may be compiled and linked into 
# binary executable programs or libraries distributed by the 
# Michigan State University (the "Licensee"), but any binaries so 
# distributed are hereby licensed only for use in the context
# of a program or computational system for which the Licensee is the 
# primary author or distributor, and which performs substantial 
# additional tasks beyond the translation of (La)TeX into HTML.
# The C source of the Code may not be distributed by the Licensee
# to any other parties under any circumstances.
#
# 05/29/00,05/30,10/11 Gerd Kortemeyer

package Apache::lontex;

use strict;
use Apache::File;
use Apache::lontexconvert;
use Apache::Constants qw(:common);
use Apache::lonnet;
use tth;

# ================================================================ Main Handler

sub footer {
    my ($errorstring) = @_;
    my $xmlstring='';
    if ($env{'request.state'} eq 'construct') {
	$xmlstring.='<address>'.
	    $Apache::lontexconvert::errorstring.'</address>';
    } else {
	&Apache::lonmsg::author_res_msg($env{'request.filename'},
					$Apache::lonxml::errorstring);
    }
# -------------------------------------------------------------------- End Body
    $xmlstring.=&Apache::loncommon::end_page({'discussion' => 1});
    return $xmlstring;
}

sub handler {
  my ($r)= @_;
  my @texcontents;
  my $texstring;

# ----------------------------------------------------------- Set document type

  if ($env{'browser.mathml'}) {
      &Apache::loncommon::content_type($r,'text/xml');
  } else {
      &Apache::loncommon::content_type($r,'text/html');
  }
  $r->send_http_header;

  return OK if $r->header_only;

# ------------------------------------------------------------------- Read file

  {
    my $fh=Apache::File->new($r->filename);
    @texcontents=<$fh>;
  }

  $texstring=join("\n",@texcontents);

# --------------------------------------------------------------- Render Output
  
  &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
					  ['texengine','inhibitmenu']);


  $r->print(&Apache::loncommon::start_page(undef,undef,
					   {'bgcolor'        => '#FFFFFF',
					    'force_register' => 1,
					    'only_body'      =>
						($env{'form.inhibitmenu'} 
						 eq 'yes'), }));

  $r->print(&Apache::lontexconvert::converted(\$texstring,
					      $env{'form.texengine'}));
  $r->print(&footer());

  return OK;
}

1;
__END__

=pod

=head1 NAME

Apache::lontex.pm

=head1 SYNOPSIS

Handler for tex files (somewhere in modules)

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.


=head1 SUBROUTINES

=over

=item footer()

Main Handler

=back

=cut







