#!/usr/bin/perl

# The LearningOnline Network with CAPA
# Converts a texxml file into an 'index' file suitable for use as a
# help file online
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# 7-16-2002 Jeremy Bowers

use strict;
use HTML::TokeParser;
use GDBM_File;

if (not defined($ARGV[1]))
{
    print <<USAGE;
Usage: texxml2indextex.pl texxmlfilename
texxml2indextex.pl will create an 'index file' suitable for use as a 
sort of title page for a given set of help files. The second file will
be placed at the beginning, verbatim, so it can be used to provide
context, title, etc, if given.
USAGE

   exit;
}

# accept texxml document on standard in
my $p = HTML::TokeParser->new( <$ARGV[1]> );
my $dirprefix = "/home/httpd/html/adm/help/tex/";

# there's a TTH error if we put something before a section starts,
# so don't display anything that precedes a section. Since that's just
# the title page anyhow, no loss.
my $inSection = 0;

while (my $token = $p->get_token())
{
    my $type = $token->[0];
    if ($type eq 'S')
    {
	my $tag = $token->[1];
	my $attr = $token->[2];
	if ($tag eq 'title')
	{
	    my $title = $attr->{'name'};
	    print "{\\Large Online Access to $title}\n\n";
	}
	if ($tag eq 'section')
	{
	    $inSection = 1;
	    my $title = $attr->{'name'};
	    print "\\emph{\\textbf{$title}}\n";
	    print "\\begin{itemize}\n\n";
	}

	if ($tag eq 'subsection')
	{
	    my $title = $attr->{'name'};
	    print "\\textbf{$title}\n\n";
	    print "\\begin{itemize}\n\n";
	}

	if ($tag eq 'subsubsection')
	{
	    my $title = $attr->{'name'};
	    print "\\emph{$title}\n\n";
	    print "\\begin{itemize}\n\n";
	}

	if ($tag eq 'file')
	{
	    my $file = substr($attr->{'name'}, 0, -4);
	    my $title = $file;
	    $title =~ s/_/ /g;
	    if ($inSection) {print "\\item \\ref{$file} $title\n\n"};
	}
    }
    elsif ($type eq 'E')
    {
	my $tag = $token->[1];
	if (index($tag, "section") != -1)
	{
	    print "\\end{itemize}\n\n";
	}
    }
}

