# The LearningOnline Network
# Logout Handler
#
# $Id: lonlogout.pm,v 1.45.2.8 2021/01/04 03:49:52 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

=head1 NAME

Apache::lonlogout

=head1 SYNOPSIS


This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.


=cut

package Apache::lonlogout;

use strict;
use Apache::Constants qw(:common);
use Apache::File;
use Apache::lonnet;
use Apache::loncommon;
use Apache::lonmenu;
use CGI::Cookie();
use Apache::lonlocal;
use LONCAPA qw(:DEFAULT :match);

sub handler {
    my $r = shift;

    #Check for cookie
    my $requrl=$r->uri;
    my $handle = &Apache::lonnet::check_for_valid_session($r);
    #check if cookie still valid
    if ($handle eq '') {
	$r->log_reason("Cookie $handle not valid", $r->filename); 
	return FORBIDDEN;
    }

    #we've got a valid user
    #any locks in place?
    my $locknum=&Apache::lonnet::get_locks();
    if ($locknum) { return 409; }
    #nope, go ahead
    my @profile;
    my $lonidsdir=$r->dir_config('lonIDsDir');
    &Apache::lonnet::transfer_profile_to_env($lonidsdir,$handle);
    if (unlink("$lonidsdir/$handle.id")) {
        if (($env{'user.linkedenv'} =~ /^[a-f0-9]+_linked$/) &&
            (-l "$lonidsdir/$env{'user.linkedenv'}.id") &&
            (readlink("$lonidsdir/$env{'user.linkedenv'}.id") eq "$lonidsdir/$handle.id")) {
            unlink("$lonidsdir/$env{'user.linkedenv'}.id");
        }
    }
    if (!$Apache::lonlocal::lh) {
        &Apache::lonlocal::get_language_handle($r);
    }
    my %temp=('logout' => time);
    my $ip = &Apache::lonnet::get_requestor_ip();
    &Apache::lonnet::put('email_status',\%temp);
    &Apache::lonnet::log($env{'user.domain'},
			 $env{'user.name'},
			 $env{'user.home'},
			 "Logout $ip");

    &Apache::loncommon::content_type($r,'text/html');

    #expire the cookies
    my %cookies=CGI::Cookie->parse($r->header_in('Cookie'));
    foreach my $name (keys(%cookies)) {
        next unless ($name =~ /^lon(|S|Link|Pub)ID$/);
        my $c = new CGI::Cookie(-name    => $name,
                                -value   => '',
                                -expires => '-10y',);
        $r->headers_out->add('Set-cookie' => $c);
    }
    $r->send_http_header;
    return OK if $r->header_only;
# -------------------------------------------------------- Menu script and info

    my $windowinfo=&Apache::lonmenu::close();
# ---------------------------------------------------------------- Get handover
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['handover']);
    my $switch='';
    my $start_page='';
    my $relogmessage='';
    if ($env{'form.handover'}) {
	$switch='<meta HTTP-EQUIV="Refresh" CONTENT="0.5; url='.
	    $env{'form.handover'}.'" />';
	$start_page=&Apache::loncommon::start_page('Switching Server ...',
						   $switch);
    } else {
        my $domain = $env{'user.domain'};
        my ($headextra,$ssofile);
        if ($env{'request.sso.login'}) {
            my $londocroot = $r->dir_config('lonDocRoot');
            if ($domain =~ /^$match_domain$/) {
                if (defined($r->dir_config("lonSSOUserLogoutHeadFile_$domain"))) {
                    $ssofile = '/'.&Apache::loncommon::clean_path($r->dir_config("lonSSOUserLogoutHeadFile_$domain"));
                    if ($ssofile eq $r->dir_config("lonSSOUserLogoutHeadFile_$domain")) {
                        if ($ssofile =~ /^\Q$londocroot\E/) {
                            if (open(my $fh,'<',$ssofile)) {
                                $headextra = join('',<$fh>);
                                close($fh);
                            }
                        }
                    }
                }
            }
            if (defined($r->dir_config('lonSSOUserLogoutHeadFile'))) {
                $ssofile = '/'.&Apache::loncommon::clean_path($r->dir_config('lonSSOUserLogoutHeadFile'));
                if ($ssofile eq $r->dir_config('lonSSOUserLogoutHeadFile')) {
                    if ($ssofile =~ /^\Q$londocroot\E/) {
                        if (open(my $fh,'<',$ssofile)) {
                            $headextra.= join('',<$fh>);
                            close($fh);
                        }
                    }
                }
            }
        }
	$start_page=&Apache::loncommon::start_page('Logged Out',$headextra,
                           {'no_inline_link' => 1,
                            'no_nav_bar'     => 1,});
	
        $relogmessage.='<h1>'.&mt('Goodbye').'</h1>'
                      .'<p>'.&mt('Thank you for using LON-CAPA.').'</p>';

	if (!$env{'request.sso.norelogin'}) {
	    my ($relogin_server,$login_url);
	    if ($env{'request.sso.reloginserver'}) {
		$relogin_server = $env{'request.sso.reloginserver'};
	    } else {
                 my %domdefaults = &Apache::lonnet::get_domain_defaults($domain);
                 if ($domdefaults{'portal_def'}) {
                     $login_url = $domdefaults{'portal_def'};
                 } else {
                     my $checkloginvia = 1;
                     my ($lonhost,$server,$path,$isredirect) = 
                         &Apache::lonnet::choose_server($domain,$checkloginvia);
                     if ($server && $lonhost) {
                         $login_url = $Apache::lonnet::protocol{$lonhost}.
                                      '://'.$server.$path;
                         if (($path eq '') && (!$isredirect)) {
                             my $serverhomeID =
                                 &Apache::lonnet::get_server_homeID($server);
                             my $serverhomedom =
                                 &Apache::lonnet::host_domain($serverhomeID);
                             if ($serverhomedom ne $domain) {
                                 $path = '/adm/login';
                                 $login_url .= $path;
                             }
                         }
                         if ($path eq '/adm/login' && $domain ne '') {
                             $login_url .= '?domain='.$domain;
                         }
                     }
                 }
            }
            if ($login_url eq '') {
	        $login_url = $relogin_server.'/adm/'.
		    ($env{'request.sso.login'} ? 'roles': 'login?domain='.$domain);
            }
            $relogmessage.='<p>'.&mt('You have been successfully logged out.').' '
                          .&mt('You can [_1]close this window[_2] now.'
                              ,'','') # ,'<a href="javascript:self.close();">','</a>')
                          .'</p>';
=pod

=head1 NOTES:

'<a href="javascript:self.close();">','</a>'

Due to security reasons in new web browsers a window could only be closed with javascript, if this window has also been opened with javascript. This is not done here which means that in most cases the close link will not work. Unless we find another solution, this link should not be offered. (Stefan Bisitz, 2008-08-01)

=cut
            $relogmessage.='<p>'.&mt('[_1]Log in again[_2]'
                              ,'<a href="'.$login_url.'">','</a>')
                          .'</p>';
        }
        if ($env{'request.sso.login'}
	    && defined($r->dir_config("lonSSOUserLogoutMessageFile_$domain"))) {
	    if (open(my $fh,'<',$r->dir_config("lonSSOUserLogoutMessageFile_$domain"))) {
	        $relogmessage.= join('',<$fh>);
                close($fh);
            }
	}
	if ($env{'request.sso.login'}
	    && defined($r->dir_config('lonSSOUserLogoutMessageFile'))) {
	    if (open(my $fh,'<',$r->dir_config('lonSSOUserLogoutMessageFile'))) {
	        $relogmessage.= join('',<$fh>);
                close($fh);
            }
	}
    }
    my $end_page=&Apache::loncommon::end_page();
# --------------------------------------------------------------- Screen Output
    $r->print(<<ENDDOCUMENT);
$start_page
$windowinfo
$relogmessage
$end_page
ENDDOCUMENT
    if ($env{'request.balancercookie'}) {
        my ($balancer,$cookie) = split(/:/,$env{'request.balancercookie'});
        if ((&Apache::lonnet::hostname($balancer)) && ($cookie =~ /^[a-f0-9]{32}$/)) {
            $cookie = $env{'user.domain'}.'_'.$env{'user.name'}.'_'.$cookie;
            &Apache::lonnet::delbalcookie($cookie,$balancer);
        }
    }
    $r->register_cleanup(\&flush_course_logs);
    return OK; 
}

sub flush_course_logs {
    &Apache::lonnet::flushcourselogs();
    return OK;
}

1;
__END__







