#!/usr/bin/perl
#
# $Id: decompress.pl,v 1.19 2012/11/27 11:33:17 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/cgi-bin/decompress.pl
#
# http://www.lon-capa.org/
#
# The LearningOnline Network with CAPA
#
# A CGI script that decompresses compressed files for mass uploading into
# construction space or into a course.
####
use strict;
use lib '/home/httpd/lib/perl';
use Apache::lonnet;
use Apache::lonlocal;
use LONCAPA::loncgi;

my %location_of;
foreach my $program ('tar','gunzip','bunzip2','unzip') {
    foreach my $dir ('/bin/','/usr/bin/','/usr/local/bin/','/sbin/',
		     '/usr/sbin/') {
	if (-x $dir.$program) {
	    $location_of{$program} = $dir.$program;
	}
    }
}

print("Content-type: text/html\n\n");

if (!&LONCAPA::loncgi::check_cookie_and_load_env()) {
    &Apache::lonlocal::get_language_handle();
    print(&LONCAPA::loncgi::missing_cookie_msg());
} else {
    &Apache::lonlocal::get_language_handle();
    my %lt = &Apache::lonlocal::texthash (
                                            bade => 'Invalid file or directory name',
                                            outo => 'Output of decompress:',
                                            comp => 'Decompress complete.', 
                                            erro => 'An error occurred.',
                                            extf => 'Extraction failed.',
                                         );
    my $file=$Apache::lonnet::env{'cgi.file'};
    my $dir=$Apache::lonnet::env{'cgi.dir'};
    if (!$file || !$dir) {
        print(<<END);
        <html><body><span class="LC_error">$lt{'extf'} $lt{'bade'}</span></body></html>
END
    } elsif (!-d $dir) {
        print('<html><body><span class="LC_error">'.$lt{'extf'}.' '."\n".
              &Apache::lonlocal::mt('The specified directory "[_1]" is invalid.',$dir).
              '</span></body></html>');
    } else {
        my $londocroot = $Apache::lonnet::perlvar{'lonDocRoot'};
        my $lonuserroot = $Apache::lonnet::perlvar{'lonUsersDir'};
        if (($dir !~ /^\Q$londocroot\E/) && ($dir !~ /^\Q$lonuserroot\E/)) {
            print('<html><body><span class="LC_error">'.$lt{'extf'}.'<br />'."\n".
                  &Apache::lonlocal::mt('The specified directory "[_1]" is invalid',$dir).
                  '</span></body></html>');
        } elsif (chdir($dir)) {
            if (-e $file) {
                print(<<END);
        <html><body><p><b>$lt{'outo'}</b></p>
END
                my @cmd;
                if ($file =~ m|\.zip$|) {
                    @cmd = ($location_of{'unzip'},"-o");
                } elsif ($file =~ m|\.tar\.gz$|
	            || $file =~ m|\.tgz$| ) {
                    @cmd = ($location_of{'tar'},"-zxpvf");
                } elsif ($file =~ m|\.tar\.bz2$|) {
                    @cmd = ($location_of{'tar'},"-jxpvf");
                } elsif ($file =~ m|\.bz2$|) {
                    @cmd = ($location_of{'bunzip2'});
                } elsif ($file =~ m|\.gz$|) {
	            @cmd = ($location_of{'gunzip'});
                } elsif ($file =~ m|\.tar$|) {
                    @cmd = ($location_of{'tar'},"-xpvf");
                }
	        if (@cmd) {
	            undef($!);
	            undef($@);
	            open(OUTPUT,"-|", @cmd, $file);
	            while (my $line = <OUTPUT>) { print("$line<br />"); }
	            close(OUTPUT);
	            print("<p><b>$lt{'comp'}</b></p>");
	            if ($! || $@) {
		        print('<p><span class="LC_error">'.$lt{'erro'}.'<br />'.$!."\n".
                              '<br />'.$@.'</span></p>');
	            } else {
                        &Apache::lonnet::appenv({'cgi.decompressed' => 'ok'});
                    }
                } else {
                    print('<span class="LC_error">'.
                          &Apache::lonlocal::mt('There has been an error in determining the file type of [_1], please check the name.',$file).'</span>');
                }
                print('</body></html>');
            } else {
                print('<html><body><span class="LC_error">'.$lt{'extf'}.'<br />'."\n".
                      &Apache::lonlocal::mt('The specified file "[_1]" does not exist.',$file).
                      '</span></body></html>');
            }
        } else {
            print('<html><body><span class="LC_error">'.$lt{'extf'}.'<br />'."\n".
                  &Apache::lonlocal::mt('Could not change working directory to "[_1]".',$dir).
                  '</span></body></html>');
        }
    }
}

