/**
 * @license Copyright (c) 2003-2015, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or http://ckeditor.com/license
 */

'use strict';

CKEDITOR.dialog.add( 'chem', function( editor ) {
    return {
        title: editor.lang.chem.title,
        minWidth: 300,
        minHeight: 150,
        contents: [
            {
                id: 'info',
                elements: [
                    {
                        id: 'ta',
                        type: 'textarea',
                        label: editor.lang.chem.dialogInput,

                        onLoad: function() {
                            var that = this;

                            if ( !( CKEDITOR.env.ie && CKEDITOR.env.version == 8 ) ) {
                                this.getInputElement().on( 'keyup', function() {
                                    var dlg = that.getDialog();
                                    var preview = dlg.getContentElement('info', 'preview');
                                    var div = preview.getElement();
                                    var span = div.getChild( 0 );
                                    var value = that.getInputElement().getValue();
                                    if (value)
                                        CKEDITOR.plugins.chem.add_html(value, span);
                                    else
                                        span.setHtml('?');
                                } );
                            }
                        },

                        setup: function( widget ) {
                            this.setValue( widget.data.reaction );
                        },

                        commit: function( widget ) {
                            widget.setData( 'reaction', this.getValue() );
                        }
                    },
                    {
                        id: 'preview',
                        type: 'html',
                        html:
                            '<div style="width:100%;text-align:center;">' +
                                '<span class="chem"></span>' +
                            '</div>',

                        onLoad: function() {
                        },

                        setup: function( widget ) {
                            var span = CKEDITOR.document.getById( this.domId ).getChild( 0 );
                            if (widget.data.reaction)
                                CKEDITOR.plugins.chem.add_html( widget.data.reaction, span);
                            else
                                span.setHtml('?');
                        }
                    }
                ]
            }
        ]
    };
} );
